// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/monitoring/v3/snooze_service.proto

package monitoringpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SnoozeService_CreateSnooze_FullMethodName = "/google.monitoring.v3.SnoozeService/CreateSnooze"
	SnoozeService_ListSnoozes_FullMethodName  = "/google.monitoring.v3.SnoozeService/ListSnoozes"
	SnoozeService_GetSnooze_FullMethodName    = "/google.monitoring.v3.SnoozeService/GetSnooze"
	SnoozeService_UpdateSnooze_FullMethodName = "/google.monitoring.v3.SnoozeService/UpdateSnooze"
)

// SnoozeServiceClient is the client API for SnoozeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SnoozeServiceClient interface {
	// Creates a `Snooze` that will prevent alerts, which match the provided
	// criteria, from being opened. The `Snooze` applies for a specific time
	// interval.
	CreateSnooze(ctx context.Context, in *CreateSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error)
	// Lists the `Snooze`s associated with a project. Can optionally pass in
	// `filter`, which specifies predicates to match `Snooze`s.
	ListSnoozes(ctx context.Context, in *ListSnoozesRequest, opts ...grpc.CallOption) (*ListSnoozesResponse, error)
	// Retrieves a `Snooze` by `name`.
	GetSnooze(ctx context.Context, in *GetSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error)
	// Updates a `Snooze`, identified by its `name`, with the parameters in the
	// given `Snooze` object.
	UpdateSnooze(ctx context.Context, in *UpdateSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error)
}

type snoozeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSnoozeServiceClient(cc grpc.ClientConnInterface) SnoozeServiceClient {
	return &snoozeServiceClient{cc}
}

func (c *snoozeServiceClient) CreateSnooze(ctx context.Context, in *CreateSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error) {
	out := new(Snooze)
	err := c.cc.Invoke(ctx, SnoozeService_CreateSnooze_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snoozeServiceClient) ListSnoozes(ctx context.Context, in *ListSnoozesRequest, opts ...grpc.CallOption) (*ListSnoozesResponse, error) {
	out := new(ListSnoozesResponse)
	err := c.cc.Invoke(ctx, SnoozeService_ListSnoozes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snoozeServiceClient) GetSnooze(ctx context.Context, in *GetSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error) {
	out := new(Snooze)
	err := c.cc.Invoke(ctx, SnoozeService_GetSnooze_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *snoozeServiceClient) UpdateSnooze(ctx context.Context, in *UpdateSnoozeRequest, opts ...grpc.CallOption) (*Snooze, error) {
	out := new(Snooze)
	err := c.cc.Invoke(ctx, SnoozeService_UpdateSnooze_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SnoozeServiceServer is the server API for SnoozeService service.
// All implementations should embed UnimplementedSnoozeServiceServer
// for forward compatibility
type SnoozeServiceServer interface {
	// Creates a `Snooze` that will prevent alerts, which match the provided
	// criteria, from being opened. The `Snooze` applies for a specific time
	// interval.
	CreateSnooze(context.Context, *CreateSnoozeRequest) (*Snooze, error)
	// Lists the `Snooze`s associated with a project. Can optionally pass in
	// `filter`, which specifies predicates to match `Snooze`s.
	ListSnoozes(context.Context, *ListSnoozesRequest) (*ListSnoozesResponse, error)
	// Retrieves a `Snooze` by `name`.
	GetSnooze(context.Context, *GetSnoozeRequest) (*Snooze, error)
	// Updates a `Snooze`, identified by its `name`, with the parameters in the
	// given `Snooze` object.
	UpdateSnooze(context.Context, *UpdateSnoozeRequest) (*Snooze, error)
}

// UnimplementedSnoozeServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSnoozeServiceServer struct {
}

func (UnimplementedSnoozeServiceServer) CreateSnooze(context.Context, *CreateSnoozeRequest) (*Snooze, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnooze not implemented")
}
func (UnimplementedSnoozeServiceServer) ListSnoozes(context.Context, *ListSnoozesRequest) (*ListSnoozesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnoozes not implemented")
}
func (UnimplementedSnoozeServiceServer) GetSnooze(context.Context, *GetSnoozeRequest) (*Snooze, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnooze not implemented")
}
func (UnimplementedSnoozeServiceServer) UpdateSnooze(context.Context, *UpdateSnoozeRequest) (*Snooze, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnooze not implemented")
}

// UnsafeSnoozeServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SnoozeServiceServer will
// result in compilation errors.
type UnsafeSnoozeServiceServer interface {
	mustEmbedUnimplementedSnoozeServiceServer()
}

func RegisterSnoozeServiceServer(s grpc.ServiceRegistrar, srv SnoozeServiceServer) {
	s.RegisterService(&SnoozeService_ServiceDesc, srv)
}

func _SnoozeService_CreateSnooze_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnoozeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnoozeServiceServer).CreateSnooze(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SnoozeService_CreateSnooze_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnoozeServiceServer).CreateSnooze(ctx, req.(*CreateSnoozeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnoozeService_ListSnoozes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnoozesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnoozeServiceServer).ListSnoozes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SnoozeService_ListSnoozes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnoozeServiceServer).ListSnoozes(ctx, req.(*ListSnoozesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnoozeService_GetSnooze_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnoozeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnoozeServiceServer).GetSnooze(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SnoozeService_GetSnooze_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnoozeServiceServer).GetSnooze(ctx, req.(*GetSnoozeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SnoozeService_UpdateSnooze_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnoozeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnoozeServiceServer).UpdateSnooze(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SnoozeService_UpdateSnooze_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnoozeServiceServer).UpdateSnooze(ctx, req.(*UpdateSnoozeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SnoozeService_ServiceDesc is the grpc.ServiceDesc for SnoozeService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SnoozeService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.SnoozeService",
	HandlerType: (*SnoozeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSnooze",
			Handler:    _SnoozeService_CreateSnooze_Handler,
		},
		{
			MethodName: "ListSnoozes",
			Handler:    _SnoozeService_ListSnoozes_Handler,
		},
		{
			MethodName: "GetSnooze",
			Handler:    _SnoozeService_GetSnooze_Handler,
		},
		{
			MethodName: "UpdateSnooze",
			Handler:    _SnoozeService_UpdateSnooze_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/snooze_service.proto",
}
