/* Appearance.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Appearance.vala, do not modify */

/*
* Copyright 2018–2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include "desktop.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <granite-7.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PANTHEON_SHELL_APPEARANCE_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_properties[PANTHEON_SHELL_APPEARANCE_NUM_PROPERTIES];
typedef enum  {
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN,
	PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY
} PantheonShellAppearanceAccentColor;

#define PANTHEON_SHELL_APPEARANCE_TYPE_ACCENT_COLOR (pantheon_shell_appearance_accent_color_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON (pantheon_shell_appearance_prefers_accent_color_button_get_type ())
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton))
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButtonClass))
#define PANTHEON_SHELL_APPEARANCE_IS_PREFERS_ACCENT_COLOR_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON))
#define PANTHEON_SHELL_APPEARANCE_IS_PREFERS_ACCENT_COLOR_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON))
#define PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButtonClass))

typedef struct _PantheonShellAppearancePrefersAccentColorButton PantheonShellAppearancePrefersAccentColorButton;
typedef struct _PantheonShellAppearancePrefersAccentColorButtonClass PantheonShellAppearancePrefersAccentColorButtonClass;
typedef struct _PantheonShellAppearancePrefersAccentColorButtonPrivate PantheonShellAppearancePrefersAccentColorButtonPrivate;
enum  {
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW (pantheon_shell_appearance_desktop_preview_get_type ())
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreview))
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreviewClass))
#define PANTHEON_SHELL_APPEARANCE_IS_DESKTOP_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW))
#define PANTHEON_SHELL_APPEARANCE_IS_DESKTOP_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW))
#define PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreviewClass))

typedef struct _PantheonShellAppearanceDesktopPreview PantheonShellAppearanceDesktopPreview;
typedef struct _PantheonShellAppearanceDesktopPreviewClass PantheonShellAppearanceDesktopPreviewClass;
typedef struct _PantheonShellAppearanceDesktopPreviewPrivate PantheonShellAppearanceDesktopPreviewPrivate;
enum  {
	PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_0_PROPERTY,
	PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_appearance_desktop_preview_properties[PANTHEON_SHELL_APPEARANCE_DESKTOP_PREVIEW_NUM_PROPERTIES];

#define PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_shell_pantheon_accounts_service_get_type ())
#define PANTHEON_SHELL_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonShellPantheonAccountsService))
#define PANTHEON_SHELL_PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_SHELL_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonShellPantheonAccountsServiceIface))

typedef struct _PantheonShellPantheonAccountsService PantheonShellPantheonAccountsService;
typedef struct _PantheonShellPantheonAccountsServiceIface PantheonShellPantheonAccountsServiceIface;

#define PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_shell_pantheon_accounts_service_proxy_get_type ())
typedef struct _Block1Data Block1Data;

#define PANTHEON_SHELL_FDO_TYPE_ACCOUNTS (pantheon_shell_fdo_accounts_get_type ())
#define PANTHEON_SHELL_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS, PantheonShellFDOAccounts))
#define PANTHEON_SHELL_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS))
#define PANTHEON_SHELL_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_FDO_TYPE_ACCOUNTS, PantheonShellFDOAccountsIface))

typedef struct _PantheonShellFDOAccounts PantheonShellFDOAccounts;
typedef struct _PantheonShellFDOAccountsIface PantheonShellFDOAccountsIface;

#define PANTHEON_SHELL_FDO_TYPE_ACCOUNTS_PROXY (pantheon_shell_fdo_accounts_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _PantheonShellAppearancePrefersAccentColorButton {
	GtkCheckButton parent_instance;
	PantheonShellAppearancePrefersAccentColorButtonPrivate * priv;
};

struct _PantheonShellAppearancePrefersAccentColorButtonClass {
	GtkCheckButtonClass parent_class;
};

struct _PantheonShellAppearancePrefersAccentColorButtonPrivate {
	PantheonShellAppearanceAccentColor _color;
};

struct _PantheonShellAppearanceDesktopPreview {
	GtkWidget parent_instance;
	PantheonShellAppearanceDesktopPreviewPrivate * priv;
};

struct _PantheonShellAppearanceDesktopPreviewClass {
	GtkWidgetClass parent_class;
};

struct _PantheonShellAppearanceDesktopPreviewPrivate {
	GtkPicture* picture;
};

struct _PantheonShellPantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_accent_color) (PantheonShellPantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonShellPantheonAccountsService* self, gint value);
	gint (*get_prefers_color_scheme) (PantheonShellPantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonShellPantheonAccountsService* self, gint value);
};

struct _Block1Data {
	int _ref_count_;
	PantheonShellAppearance* self;
	GraniteTimePicker* from_time;
	GraniteTimePicker* to_time;
	PantheonShellPantheonAccountsService* pantheon_act;
	GSettings* settings;
	GtkSwitch* animations_switch;
	GSettings* animations_settings;
	GSimpleAction* accent_color_action;
};

struct _PantheonShellFDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (PantheonShellFDOAccounts* self, const gchar* username, GError** error);
};

static gpointer pantheon_shell_appearance_parent_class = NULL;
static gint PantheonShellAppearancePrefersAccentColorButton_private_offset;
static gpointer pantheon_shell_appearance_prefers_accent_color_button_parent_class = NULL;
static gint PantheonShellAppearanceDesktopPreview_private_offset;
static gpointer pantheon_shell_appearance_desktop_preview_parent_class = NULL;
static GSettings* pantheon_shell_appearance_desktop_preview_pantheon_settings;
static GSettings* pantheon_shell_appearance_desktop_preview_pantheon_settings = NULL;
static GSettings* pantheon_shell_appearance_desktop_preview_gnome_settings;
static GSettings* pantheon_shell_appearance_desktop_preview_gnome_settings = NULL;

static GType pantheon_shell_appearance_accent_color_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* pantheon_shell_appearance_accent_color_to_string (PantheonShellAppearanceAccentColor self);
static GDateTime* pantheon_shell_appearance_double_date_time (gdouble dbl);
static gdouble pantheon_shell_appearance_date_time_double (GDateTime* date_time);
static GType pantheon_shell_appearance_prefers_accent_color_button_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonShellAppearancePrefersAccentColorButton* pantheon_shell_appearance_prefers_accent_color_button_new (PantheonShellAppearanceAccentColor color,
                                                                                                            GtkCheckButton* group_member);
static PantheonShellAppearancePrefersAccentColorButton* pantheon_shell_appearance_prefers_accent_color_button_construct (GType object_type,
                                                                                                                  PantheonShellAppearanceAccentColor color,
                                                                                                                  GtkCheckButton* group_member);
static PantheonShellAppearanceAccentColor pantheon_shell_appearance_prefers_accent_color_button_get_color (PantheonShellAppearancePrefersAccentColorButton* self);
static void pantheon_shell_appearance_prefers_accent_color_button_set_color (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                      PantheonShellAppearanceAccentColor value);
static GObject * pantheon_shell_appearance_prefers_accent_color_button_constructor (GType type,
                                                                             guint n_construct_properties,
                                                                             GObjectConstructParam * construct_properties);
static void pantheon_shell_appearance_prefers_accent_color_button_finalize (GObject * obj);
static GType pantheon_shell_appearance_prefers_accent_color_button_get_type_once (void);
static void _vala_pantheon_shell_appearance_prefers_accent_color_button_get_property (GObject * object,
                                                                               guint property_id,
                                                                               GValue * value,
                                                                               GParamSpec * pspec);
static void _vala_pantheon_shell_appearance_prefers_accent_color_button_set_property (GObject * object,
                                                                               guint property_id,
                                                                               const GValue * value,
                                                                               GParamSpec * pspec);
static GType pantheon_shell_appearance_desktop_preview_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonShellAppearanceDesktopPreview* pantheon_shell_appearance_desktop_preview_new (const gchar* style_class);
static PantheonShellAppearanceDesktopPreview* pantheon_shell_appearance_desktop_preview_construct (GType object_type,
                                                                                            const gchar* style_class);
static void pantheon_shell_appearance_desktop_preview_update_picture (PantheonShellAppearanceDesktopPreview* self);
static void _pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed (GSettings* _sender,
                                                                                   const gchar* key,
                                                                                   gpointer self);
static void pantheon_shell_appearance_desktop_preview_update_dim (PantheonShellAppearanceDesktopPreview* self);
static void _pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed (GSettings* _sender,
                                                                               const gchar* key,
                                                                               gpointer self);
static void pantheon_shell_appearance_desktop_preview_finalize (GObject * obj);
static GType pantheon_shell_appearance_desktop_preview_get_type_once (void);
static GObject * pantheon_shell_appearance_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
VALA_EXTERN GType pantheon_shell_pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_shell_pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_pantheon_accounts_service_register_object (void* object,
                                                                GDBusConnection* connection,
                                                                const gchar* path,
                                                                GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType pantheon_shell_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_fdo_accounts_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType pantheon_shell_fdo_accounts_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* pantheon_shell_fdo_accounts_find_user_by_name (PantheonShellFDOAccounts* self,
                                                      const gchar* username,
                                                      GError** error);
static void _pantheon_shell_appearance___lambda35_ (Block1Data* _data1_);
static void __pantheon_shell_appearance___lambda35__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                               gpointer self);
static void _pantheon_shell_appearance___lambda36_ (Block1Data* _data1_);
static void __pantheon_shell_appearance___lambda36__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                               gpointer self);
static void _pantheon_shell_appearance___lambda37_ (Block1Data* _data1_);
static void __pantheon_shell_appearance___lambda37__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
VALA_EXTERN gint pantheon_shell_pantheon_accounts_service_get_prefers_accent_color (PantheonShellPantheonAccountsService* self);
static void _pantheon_shell_appearance____lambda38_ (Block1Data* _data1_,
                                              GVariant* changed,
                                              gchar** invalid);
static void __pantheon_shell_appearance____lambda38__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                 GVariant* changed_properties,
                                                                                 gchar** invalidated_properties,
                                                                                 gpointer self);
static void _pantheon_shell_appearance____lambda39_ (Block1Data* _data1_,
                                              GVariant* value);
VALA_EXTERN void pantheon_shell_pantheon_accounts_service_set_prefers_accent_color (PantheonShellPantheonAccountsService* self,
                                                                        gint value);
static void __pantheon_shell_appearance____lambda39__g_simple_action_activate (GSimpleAction* _sender,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static GType pantheon_shell_appearance_get_type_once (void);

static gchar*
pantheon_shell_appearance_accent_color_to_string (PantheonShellAppearanceAccentColor self)
{
	gchar* result;
	switch (self) {
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("strawberry");
			result = _tmp0_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("orange");
			result = _tmp1_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("banana");
			result = _tmp2_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("lime");
			result = _tmp3_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("mint");
			result = _tmp4_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("blueberry");
			result = _tmp5_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("grape");
			result = _tmp6_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("bubblegum");
			result = _tmp7_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("cocoa");
			result = _tmp8_;
			return result;
		}
		case PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("slate");
			result = _tmp9_;
			return result;
		}
		default:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("auto");
			result = _tmp10_;
			return result;
		}
	}
}

static GType
pantheon_shell_appearance_accent_color_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE", "no-preference"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED", "red"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE", "orange"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW", "yellow"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN", "green"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT", "mint"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE", "blue"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE", "purple"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK", "pink"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN", "brown"}, {PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY, "PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY", "gray"}, {0, NULL, NULL}};
	GType pantheon_shell_appearance_accent_color_type_id;
	pantheon_shell_appearance_accent_color_type_id = g_enum_register_static ("PantheonShellAppearanceAccentColor", values);
	return pantheon_shell_appearance_accent_color_type_id;
}

static GType
pantheon_shell_appearance_accent_color_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_accent_color_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_accent_color_type_id__once)) {
		GType pantheon_shell_appearance_accent_color_type_id;
		pantheon_shell_appearance_accent_color_type_id = pantheon_shell_appearance_accent_color_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_accent_color_type_id__once, pantheon_shell_appearance_accent_color_type_id);
	}
	return pantheon_shell_appearance_accent_color_type_id__once;
}

PantheonShellAppearance*
pantheon_shell_appearance_construct (GType object_type)
{
	PantheonShellAppearance * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-theme");
	_tmp1_ = _tmp0_;
	self = (PantheonShellAppearance*) g_object_new (object_type, "title", _ ("Appearance"), "description", _ ("Apps may follow these preferences, but can choose their own accents or" \
" style."), "icon", _tmp1_, "show-end-title-buttons", TRUE, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PantheonShellAppearance*
pantheon_shell_appearance_new (void)
{
	return pantheon_shell_appearance_construct (PANTHEON_SHELL_TYPE_APPEARANCE);
}

static GDateTime*
pantheon_shell_appearance_double_date_time (gdouble dbl)
{
	gint hours = 0;
	gint minutes = 0;
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* result;
	hours = (gint) dbl;
	minutes = (gint) round ((dbl - hours) * 60);
	_tmp0_ = g_date_time_new_local (1, 1, 1, hours, minutes, 0.0);
	date_time = _tmp0_;
	result = date_time;
	return result;
}

static gdouble
pantheon_shell_appearance_date_time_double (GDateTime* date_time)
{
	gdouble time_double = 0.0;
	gdouble result;
	g_return_val_if_fail (date_time != NULL, 0.0);
	time_double = (gdouble) 0;
	time_double += (gdouble) g_date_time_get_hour (date_time);
	time_double += ((gdouble) g_date_time_get_minute (date_time)) / 60;
	result = time_double;
	return result;
}

static inline gpointer
pantheon_shell_appearance_prefers_accent_color_button_get_instance_private (PantheonShellAppearancePrefersAccentColorButton* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellAppearancePrefersAccentColorButton_private_offset);
}

static PantheonShellAppearancePrefersAccentColorButton*
pantheon_shell_appearance_prefers_accent_color_button_construct (GType object_type,
                                                                 PantheonShellAppearanceAccentColor color,
                                                                 GtkCheckButton* group_member)
{
	PantheonShellAppearancePrefersAccentColorButton * self = NULL;
	self = (PantheonShellAppearancePrefersAccentColorButton*) g_object_new (object_type, "color", color, "group", group_member, NULL);
	return self;
}

static PantheonShellAppearancePrefersAccentColorButton*
pantheon_shell_appearance_prefers_accent_color_button_new (PantheonShellAppearanceAccentColor color,
                                                           GtkCheckButton* group_member)
{
	return pantheon_shell_appearance_prefers_accent_color_button_construct (PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, color, group_member);
}

static PantheonShellAppearanceAccentColor
pantheon_shell_appearance_prefers_accent_color_button_get_color (PantheonShellAppearancePrefersAccentColorButton* self)
{
	PantheonShellAppearanceAccentColor result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color;
	return result;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_set_color (PantheonShellAppearancePrefersAccentColorButton* self,
                                                                 PantheonShellAppearanceAccentColor value)
{
	PantheonShellAppearanceAccentColor old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_appearance_prefers_accent_color_button_get_color (self);
	if (old_value != value) {
		self->priv->_color = value;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY]);
	}
}

static GObject *
pantheon_shell_appearance_prefers_accent_color_button_constructor (GType type,
                                                                   guint n_construct_properties,
                                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellAppearancePrefersAccentColorButton * self;
	PantheonShellAppearanceAccentColor _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PantheonShellAppearanceAccentColor _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_appearance_prefers_accent_color_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp0_ = self->priv->_color;
	_tmp1_ = pantheon_shell_appearance_accent_color_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) self, _tmp2_);
	_g_free0 (_tmp2_);
	gtk_actionable_set_action_name ((GtkActionable*) self, "desktop-appearance.prefers-accent-color");
	_tmp3_ = self->priv->_color;
	_tmp4_ = g_variant_new_int32 ((gint32) _tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_object_set ((GtkActionable*) self, "action-target", _tmp5_, NULL);
	_g_variant_unref0 (_tmp5_);
	return obj;
}

static void
pantheon_shell_appearance_prefers_accent_color_button_class_init (PantheonShellAppearancePrefersAccentColorButtonClass * klass,
                                                                  gpointer klass_data)
{
	pantheon_shell_appearance_prefers_accent_color_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellAppearancePrefersAccentColorButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_appearance_prefers_accent_color_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_appearance_prefers_accent_color_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_appearance_prefers_accent_color_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_appearance_prefers_accent_color_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY, pantheon_shell_appearance_prefers_accent_color_button_properties[PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY] = g_param_spec_enum ("color", "color", "color", PANTHEON_SHELL_APPEARANCE_TYPE_ACCENT_COLOR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
pantheon_shell_appearance_prefers_accent_color_button_instance_init (PantheonShellAppearancePrefersAccentColorButton * self,
                                                                     gpointer klass)
{
	self->priv = pantheon_shell_appearance_prefers_accent_color_button_get_instance_private (self);
}

static void
pantheon_shell_appearance_prefers_accent_color_button_finalize (GObject * obj)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	G_OBJECT_CLASS (pantheon_shell_appearance_prefers_accent_color_button_parent_class)->finalize (obj);
}

static GType
pantheon_shell_appearance_prefers_accent_color_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearancePrefersAccentColorButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_prefers_accent_color_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearancePrefersAccentColorButton), 0, (GInstanceInitFunc) pantheon_shell_appearance_prefers_accent_color_button_instance_init, NULL };
	GType pantheon_shell_appearance_prefers_accent_color_button_type_id;
	pantheon_shell_appearance_prefers_accent_color_button_type_id = g_type_register_static (gtk_check_button_get_type (), "PantheonShellAppearancePrefersAccentColorButton", &g_define_type_info, 0);
	PantheonShellAppearancePrefersAccentColorButton_private_offset = g_type_add_instance_private (pantheon_shell_appearance_prefers_accent_color_button_type_id, sizeof (PantheonShellAppearancePrefersAccentColorButtonPrivate));
	return pantheon_shell_appearance_prefers_accent_color_button_type_id;
}

static GType
pantheon_shell_appearance_prefers_accent_color_button_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_prefers_accent_color_button_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_prefers_accent_color_button_type_id__once)) {
		GType pantheon_shell_appearance_prefers_accent_color_button_type_id;
		pantheon_shell_appearance_prefers_accent_color_button_type_id = pantheon_shell_appearance_prefers_accent_color_button_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_prefers_accent_color_button_type_id__once, pantheon_shell_appearance_prefers_accent_color_button_type_id);
	}
	return pantheon_shell_appearance_prefers_accent_color_button_type_id__once;
}

static void
_vala_pantheon_shell_appearance_prefers_accent_color_button_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	switch (property_id) {
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY:
		g_value_set_enum (value, pantheon_shell_appearance_prefers_accent_color_button_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_appearance_prefers_accent_color_button_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec)
{
	PantheonShellAppearancePrefersAccentColorButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_APPEARANCE_TYPE_PREFERS_ACCENT_COLOR_BUTTON, PantheonShellAppearancePrefersAccentColorButton);
	switch (property_id) {
		case PANTHEON_SHELL_APPEARANCE_PREFERS_ACCENT_COLOR_BUTTON_COLOR_PROPERTY:
		pantheon_shell_appearance_prefers_accent_color_button_set_color (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pantheon_shell_appearance_desktop_preview_get_instance_private (PantheonShellAppearanceDesktopPreview* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellAppearanceDesktopPreview_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed (GSettings* _sender,
                                                                              const gchar* key,
                                                                              gpointer self)
{
	pantheon_shell_appearance_desktop_preview_update_picture ((PantheonShellAppearanceDesktopPreview*) self);
}

static void
_pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed (GSettings* _sender,
                                                                          const gchar* key,
                                                                          gpointer self)
{
	pantheon_shell_appearance_desktop_preview_update_dim ((PantheonShellAppearanceDesktopPreview*) self);
}

static PantheonShellAppearanceDesktopPreview*
pantheon_shell_appearance_desktop_preview_construct (GType object_type,
                                                     const gchar* style_class)
{
	PantheonShellAppearanceDesktopPreview * self = NULL;
	GtkPicture* _tmp0_ = NULL;
	GtkBox* dock = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* _tmp2_;
	GtkBox* window_back = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* window_front = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* shell = NULL;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkOverlay* overlay = NULL;
	GtkPicture* _tmp11_;
	GtkWidget* _tmp12_;
	GtkOverlay* _tmp13_ = NULL;
	GtkOverlay* _tmp14_;
	GtkBox* _tmp15_;
	GtkOverlay* _tmp16_;
	GtkBox* _tmp17_;
	GtkOverlay* _tmp18_;
	GtkBox* _tmp19_;
	GtkOverlay* _tmp20_;
	GtkBox* _tmp21_;
	GtkOverlay* _tmp22_;
	GtkOverlay* _tmp23_;
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp24_;
	GApplication* _tmp25_;
	GtkWindow* _tmp26_;
	GtkWindow* _tmp27_;
	GdkSurface* _tmp28_;
	GdkMonitor* _tmp29_;
	GdkMonitor* _tmp30_;
	gfloat monitor_ratio = 0.0F;
	GdkMonitor* _tmp31_;
	GdkRectangle _tmp32_ = {0};
	GdkRectangle _tmp33_;
	GdkMonitor* _tmp34_;
	GdkRectangle _tmp35_ = {0};
	GdkRectangle _tmp36_;
	GtkAspectFrame* frame = NULL;
	GtkOverlay* _tmp37_;
	GtkWidget* _tmp38_;
	GtkAspectFrame* _tmp39_ = NULL;
	GtkAspectFrame* _tmp40_;
	GSettings* _tmp41_;
	g_return_val_if_fail (style_class != NULL, NULL);
	self = (PantheonShellAppearanceDesktopPreview*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkPicture*) gtk_picture_new ();
	gtk_picture_set_content_fit (_tmp0_, GTK_CONTENT_FIT_COVER);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->picture);
	self->priv->picture = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp1_);
	dock = _tmp1_;
	_tmp2_ = dock;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "dock");
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp3_);
	window_back = _tmp3_;
	_tmp4_ = window_back;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "window");
	_tmp5_ = window_back;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, "back");
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp6_);
	window_front = _tmp6_;
	_tmp7_ = window_front;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "window");
	_tmp8_ = window_front;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "front");
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp9_);
	shell = _tmp9_;
	_tmp10_ = shell;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, "shell");
	_tmp11_ = self->priv->picture;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	gtk_widget_set_overflow ((GtkWidget*) _tmp13_, GTK_OVERFLOW_HIDDEN);
	g_object_ref_sink (_tmp13_);
	overlay = _tmp13_;
	_tmp14_ = overlay;
	_tmp15_ = shell;
	gtk_overlay_add_overlay (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = overlay;
	_tmp17_ = dock;
	gtk_overlay_add_overlay (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = overlay;
	_tmp19_ = window_back;
	gtk_overlay_add_overlay (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = overlay;
	_tmp21_ = window_front;
	gtk_overlay_add_overlay (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = overlay;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, GRANITE_STYLE_CLASS_CARD);
	_tmp23_ = overlay;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp24_ = gdk_display_get_default ();
	_tmp25_ = g_application_get_default ();
	_tmp26_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_application_get_type (), GtkApplication));
	_tmp27_ = _tmp26_;
	_tmp28_ = gtk_native_get_surface ((GtkNative*) _tmp27_);
	_tmp29_ = gdk_display_get_monitor_at_surface (_tmp24_, _tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	monitor = _tmp30_;
	_tmp31_ = monitor;
	gdk_monitor_get_geometry (_tmp31_, &_tmp32_);
	_tmp33_ = _tmp32_;
	_tmp34_ = monitor;
	gdk_monitor_get_geometry (_tmp34_, &_tmp35_);
	_tmp36_ = _tmp35_;
	monitor_ratio = ((gfloat) _tmp33_.width) / _tmp36_.height;
	_tmp37_ = overlay;
	_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
	_tmp39_ = (GtkAspectFrame*) gtk_aspect_frame_new (0.5f, 0.5f, monitor_ratio, FALSE);
	gtk_aspect_frame_set_child (_tmp39_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	frame = _tmp39_;
	_tmp40_ = frame;
	gtk_widget_set_parent ((GtkWidget*) _tmp40_, (GtkWidget*) self);
	gtk_widget_add_css_class ((GtkWidget*) self, style_class);
	pantheon_shell_appearance_desktop_preview_update_picture (self);
	_tmp41_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	g_signal_connect_object (_tmp41_, "changed", (GCallback) _pantheon_shell_appearance_desktop_preview_update_picture_g_settings_changed, self, 0);
	if (gtk_widget_has_css_class ((GtkWidget*) self, "dark")) {
		GSettings* _tmp42_;
		pantheon_shell_appearance_desktop_preview_update_dim (self);
		_tmp42_ = pantheon_shell_appearance_desktop_preview_pantheon_settings;
		g_signal_connect_object (_tmp42_, "changed", (GCallback) _pantheon_shell_appearance_desktop_preview_update_dim_g_settings_changed, self, 0);
	}
	_g_object_unref0 (frame);
	_g_object_unref0 (monitor);
	_g_object_unref0 (overlay);
	_g_object_unref0 (shell);
	_g_object_unref0 (window_front);
	_g_object_unref0 (window_back);
	_g_object_unref0 (dock);
	return self;
}

static PantheonShellAppearanceDesktopPreview*
pantheon_shell_appearance_desktop_preview_new (const gchar* style_class)
{
	return pantheon_shell_appearance_desktop_preview_construct (PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, style_class);
}

static void
pantheon_shell_appearance_desktop_preview_update_dim (PantheonShellAppearanceDesktopPreview* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_pantheon_settings;
	if (g_settings_get_boolean (_tmp0_, "dim-wallpaper-in-dark-style")) {
		gtk_widget_add_css_class ((GtkWidget*) self, "dim");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "dim");
	}
}

static void
pantheon_shell_appearance_desktop_preview_update_picture (PantheonShellAppearanceDesktopPreview* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GtkPicture* _tmp23_;
	GSettings* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "picture-options");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "none") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GdkRGBA rgba = {0};
		GdkRGBA _tmp4_ = {0};
		GSettings* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkRGBA _tmp10_;
		GtkPicture* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkTexture* _tmp13_;
		GdkTexture* _tmp14_;
		rgba = _tmp4_;
		_tmp5_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "primary-color");
		_tmp7_ = _tmp6_;
		gdk_rgba_parse (&rgba, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 500, 500);
		pixbuf = _tmp8_;
		_tmp9_ = pixbuf;
		_tmp10_ = rgba;
		gdk_pixbuf_fill (_tmp9_, pantheon_shell_solid_color_container_rgba_to_pixel (&_tmp10_));
		_tmp11_ = self->priv->picture;
		_tmp12_ = pixbuf;
		_tmp13_ = gdk_texture_new_for_pixbuf (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_picture_set_paintable (_tmp11_, (GdkPaintable*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (pixbuf);
		return;
	}
	if (gtk_widget_has_css_class ((GtkWidget*) self, "dark")) {
		GFile* dark_file = NULL;
		GSettings* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		_tmp15_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
		_tmp16_ = g_settings_get_string (_tmp15_, "picture-uri-dark");
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_new_for_uri (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		dark_file = _tmp19_;
		_tmp20_ = dark_file;
		if (g_file_query_exists (_tmp20_, NULL)) {
			GtkPicture* _tmp21_;
			GFile* _tmp22_;
			_tmp21_ = self->priv->picture;
			_tmp22_ = dark_file;
			gtk_picture_set_file (_tmp21_, _tmp22_);
			_g_object_unref0 (dark_file);
			return;
		}
		_g_object_unref0 (dark_file);
	}
	_tmp23_ = self->priv->picture;
	_tmp24_ = pantheon_shell_appearance_desktop_preview_gnome_settings;
	_tmp25_ = g_settings_get_string (_tmp24_, "picture-uri");
	_tmp26_ = _tmp25_;
	_tmp27_ = g_file_new_for_uri (_tmp26_);
	_tmp28_ = _tmp27_;
	gtk_picture_set_file (_tmp23_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
}

static void
pantheon_shell_appearance_desktop_preview_base_init (PantheonShellAppearanceDesktopPreviewClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "desktop-preview");
}

static void
pantheon_shell_appearance_desktop_preview_class_init (PantheonShellAppearanceDesktopPreviewClass * klass,
                                                      gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	pantheon_shell_appearance_desktop_preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellAppearanceDesktopPreview_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_appearance_desktop_preview_finalize;
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
	_tmp0_ = g_settings_new ("io.elementary.desktop.background");
	_g_object_unref0 (pantheon_shell_appearance_desktop_preview_pantheon_settings);
	pantheon_shell_appearance_desktop_preview_pantheon_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (pantheon_shell_appearance_desktop_preview_gnome_settings);
	pantheon_shell_appearance_desktop_preview_gnome_settings = _tmp1_;
}

static void
pantheon_shell_appearance_desktop_preview_instance_init (PantheonShellAppearanceDesktopPreview * self,
                                                         gpointer klass)
{
	self->priv = pantheon_shell_appearance_desktop_preview_get_instance_private (self);
}

static void
pantheon_shell_appearance_desktop_preview_finalize (GObject * obj)
{
	PantheonShellAppearanceDesktopPreview * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_APPEARANCE_TYPE_DESKTOP_PREVIEW, PantheonShellAppearanceDesktopPreview);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	_g_object_unref0 (self->priv->picture);
	G_OBJECT_CLASS (pantheon_shell_appearance_desktop_preview_parent_class)->finalize (obj);
}

static GType
pantheon_shell_appearance_desktop_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearanceDesktopPreviewClass), (GBaseInitFunc) pantheon_shell_appearance_desktop_preview_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_desktop_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearanceDesktopPreview), 0, (GInstanceInitFunc) pantheon_shell_appearance_desktop_preview_instance_init, NULL };
	GType pantheon_shell_appearance_desktop_preview_type_id;
	pantheon_shell_appearance_desktop_preview_type_id = g_type_register_static (gtk_widget_get_type (), "PantheonShellAppearanceDesktopPreview", &g_define_type_info, 0);
	PantheonShellAppearanceDesktopPreview_private_offset = g_type_add_instance_private (pantheon_shell_appearance_desktop_preview_type_id, sizeof (PantheonShellAppearanceDesktopPreviewPrivate));
	return pantheon_shell_appearance_desktop_preview_type_id;
}

static GType
pantheon_shell_appearance_desktop_preview_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_desktop_preview_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_desktop_preview_type_id__once)) {
		GType pantheon_shell_appearance_desktop_preview_type_id;
		pantheon_shell_appearance_desktop_preview_type_id = pantheon_shell_appearance_desktop_preview_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_desktop_preview_type_id__once, pantheon_shell_appearance_desktop_preview_type_id);
	}
	return pantheon_shell_appearance_desktop_preview_type_id__once;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PantheonShellAppearance* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->accent_color_action);
		_g_object_unref0 (_data1_->animations_settings);
		_g_object_unref0 (_data1_->animations_switch);
		_g_object_unref0 (_data1_->settings);
		_g_object_unref0 (_data1_->pantheon_act);
		_g_object_unref0 (_data1_->to_time);
		_g_object_unref0 (_data1_->from_time);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_pantheon_shell_appearance___lambda35_ (Block1Data* _data1_)
{
	PantheonShellAppearance* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->settings;
	_tmp1_ = _data1_->from_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "prefer-dark-schedule-from", pantheon_shell_appearance_date_time_double (_tmp3_));
}

static void
__pantheon_shell_appearance___lambda35__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                          gpointer self)
{
	_pantheon_shell_appearance___lambda35_ (self);
}

static void
_pantheon_shell_appearance___lambda36_ (Block1Data* _data1_)
{
	PantheonShellAppearance* self;
	GSettings* _tmp0_;
	GraniteTimePicker* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->settings;
	_tmp1_ = _data1_->to_time;
	_tmp2_ = granite_time_picker_get_time (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_double (_tmp0_, "prefer-dark-schedule-to", pantheon_shell_appearance_date_time_double (_tmp3_));
}

static void
__pantheon_shell_appearance___lambda36__granite_time_picker_time_changed (GraniteTimePicker* _sender,
                                                                          gpointer self)
{
	_pantheon_shell_appearance___lambda36_ (self);
}

static void
_pantheon_shell_appearance___lambda37_ (Block1Data* _data1_)
{
	PantheonShellAppearance* self;
	GSettings* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->animations_settings;
	_tmp1_ = _data1_->animations_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "enable-animations", !_tmp3_);
}

static void
__pantheon_shell_appearance___lambda37__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_pantheon_shell_appearance___lambda37_ (self);
}

static void
_pantheon_shell_appearance____lambda38_ (Block1Data* _data1_,
                                         GVariant* changed,
                                         gchar** invalid)
{
	PantheonShellAppearance* self;
	GVariant* accent_color = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GVariant* _tmp5_;
	self = _data1_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "PrefersAccentColor", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	accent_color = _tmp3_;
	_tmp5_ = accent_color;
	if (_tmp5_ != NULL) {
		GSimpleAction* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = _data1_->accent_color_action;
		_tmp7_ = g_action_get_state ((GAction*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = accent_color;
		_tmp4_ = !g_variant_equal (_tmp8_, _tmp9_);
		_g_variant_unref0 (_tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GSimpleAction* _tmp10_;
		GVariant* _tmp11_;
		_tmp10_ = _data1_->accent_color_action;
		_tmp11_ = accent_color;
		g_simple_action_set_state (_tmp10_, _tmp11_);
	}
	_g_variant_unref0 (accent_color);
}

static void
__pantheon_shell_appearance____lambda38__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                            GVariant* changed_properties,
                                                                            gchar** invalidated_properties,
                                                                            gpointer self)
{
	_pantheon_shell_appearance____lambda38_ (self, changed_properties, invalidated_properties);
}

static void
_pantheon_shell_appearance____lambda39_ (Block1Data* _data1_,
                                         GVariant* value)
{
	PantheonShellAppearance* self;
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->accent_color_action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_equal (_tmp2_, value);
	_g_variant_unref0 (_tmp2_);
	if (_tmp3_) {
		GSimpleAction* _tmp4_;
		PantheonShellPantheonAccountsService* _tmp5_;
		_tmp4_ = _data1_->accent_color_action;
		g_simple_action_set_state (_tmp4_, value);
		_tmp5_ = _data1_->pantheon_act;
		pantheon_shell_pantheon_accounts_service_set_prefers_accent_color (_tmp5_, (gint) g_variant_get_int32 (value));
	}
}

static void
__pantheon_shell_appearance____lambda39__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	_pantheon_shell_appearance____lambda39_ (self, parameter);
}

static GObject *
pantheon_shell_appearance_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellAppearance * self;
	Block1Data* _data1_;
	PantheonShellAppearanceDesktopPreview* default_preview = NULL;
	PantheonShellAppearanceDesktopPreview* _tmp0_;
	GtkCheckButton* prefer_default_radio = NULL;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GtkCheckButton* _tmp3_ = NULL;
	GtkCheckButton* _tmp4_;
	GtkGrid* prefer_default_grid = NULL;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	PantheonShellAppearanceDesktopPreview* _tmp7_;
	GtkGrid* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkGrid* _tmp11_;
	GtkCheckButton* _tmp12_;
	PantheonShellAppearanceDesktopPreview* dark_preview = NULL;
	PantheonShellAppearanceDesktopPreview* _tmp13_;
	GtkCheckButton* prefer_dark_radio = NULL;
	gchar* _tmp14_;
	GVariant* _tmp15_;
	GtkCheckButton* _tmp16_;
	GtkCheckButton* _tmp17_;
	GtkCheckButton* _tmp18_ = NULL;
	GtkCheckButton* _tmp19_;
	GtkGrid* prefer_dark_grid = NULL;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	PantheonShellAppearanceDesktopPreview* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_;
	GtkCheckButton* _tmp27_;
	GtkBox* prefer_style_box = NULL;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkBox* _tmp31_;
	GtkCheckButton* _tmp32_;
	GtkSwitch* dim_switch = NULL;
	GtkSwitch* _tmp33_ = NULL;
	GraniteHeaderLabel* dim_label = NULL;
	GtkSwitch* _tmp34_;
	GtkWidget* _tmp35_;
	GraniteHeaderLabel* _tmp36_ = NULL;
	GtkBox* dim_box = NULL;
	GtkBox* _tmp37_ = NULL;
	GtkBox* _tmp38_;
	GraniteHeaderLabel* _tmp39_;
	GtkBox* _tmp40_;
	GtkSwitch* _tmp41_;
	GtkCheckButton* schedule_disabled_radio = NULL;
	gchar* _tmp42_;
	GVariant* _tmp43_;
	GtkCheckButton* _tmp44_ = NULL;
	GtkCheckButton* schedule_sunset_radio = NULL;
	gchar* _tmp45_;
	GVariant* _tmp46_;
	GtkCheckButton* _tmp47_;
	GtkCheckButton* _tmp48_;
	GtkCheckButton* _tmp49_ = NULL;
	GtkLabel* from_label = NULL;
	GtkLabel* _tmp50_;
	GraniteTimePicker* _tmp51_ = NULL;
	GtkLabel* to_label = NULL;
	GtkLabel* _tmp52_;
	GraniteTimePicker* _tmp53_ = NULL;
	GtkBox* schedule_manual_box = NULL;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GtkLabel* _tmp56_;
	GtkBox* _tmp57_;
	GraniteTimePicker* _tmp58_;
	GtkBox* _tmp59_;
	GtkLabel* _tmp60_;
	GtkBox* _tmp61_;
	GraniteTimePicker* _tmp62_;
	GtkCheckButton* schedule_manual_radio = NULL;
	gchar* _tmp63_;
	GVariant* _tmp64_;
	GtkBox* _tmp65_;
	GtkWidget* _tmp66_;
	GtkCheckButton* _tmp67_;
	GtkCheckButton* _tmp68_;
	GtkCheckButton* _tmp69_ = NULL;
	GtkBox* schedule_box = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkBox* _tmp71_;
	GtkCheckButton* _tmp72_;
	GtkBox* _tmp73_;
	GtkCheckButton* _tmp74_;
	GtkBox* _tmp75_;
	GtkCheckButton* _tmp76_;
	GraniteHeaderLabel* schedule_label = NULL;
	GtkBox* _tmp77_;
	GtkWidget* _tmp78_;
	GraniteHeaderLabel* _tmp79_ = NULL;
	gchar* user_path = NULL;
	const gchar* _tmp88_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp93_ = NULL;
	GtkGrid* _tmp94_;
	GtkBox* _tmp95_;
	GtkGrid* _tmp96_;
	GtkBox* _tmp97_;
	GtkGrid* _tmp98_;
	GraniteHeaderLabel* _tmp99_;
	GtkGrid* _tmp100_;
	GtkBox* _tmp101_;
	GSettings* _tmp102_;
	GraniteTimePicker* _tmp103_;
	GSettings* _tmp104_;
	GDateTime* _tmp105_;
	GDateTime* _tmp106_;
	GraniteTimePicker* _tmp107_;
	GraniteTimePicker* _tmp108_;
	GSettings* _tmp109_;
	GDateTime* _tmp110_;
	GDateTime* _tmp111_;
	GraniteTimePicker* _tmp112_;
	GtkCheckButton* _tmp113_;
	GtkBox* _tmp114_;
	PantheonShellAppearancePrefersAccentColorButton* blueberry_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp115_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp116_;
	PantheonShellAppearancePrefersAccentColorButton* mint_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp117_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp118_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp119_;
	PantheonShellAppearancePrefersAccentColorButton* lime_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp120_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp121_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp122_;
	PantheonShellAppearancePrefersAccentColorButton* banana_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp123_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp124_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp125_;
	PantheonShellAppearancePrefersAccentColorButton* orange_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp126_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp127_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp128_;
	PantheonShellAppearancePrefersAccentColorButton* strawberry_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp129_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp130_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp131_;
	PantheonShellAppearancePrefersAccentColorButton* bubblegum_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp132_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp133_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp134_;
	PantheonShellAppearancePrefersAccentColorButton* grape_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp135_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp136_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp137_;
	PantheonShellAppearancePrefersAccentColorButton* cocoa_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp138_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp139_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp140_;
	PantheonShellAppearancePrefersAccentColorButton* slate_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp141_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp142_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp143_;
	PantheonShellAppearancePrefersAccentColorButton* auto_button = NULL;
	PantheonShellAppearancePrefersAccentColorButton* _tmp144_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp145_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp146_;
	GtkBox* accent_box = NULL;
	GtkBox* _tmp147_ = NULL;
	GtkBox* _tmp148_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp149_;
	GtkBox* _tmp150_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp151_;
	GtkBox* _tmp152_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp153_;
	GtkBox* _tmp154_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp155_;
	GtkBox* _tmp156_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp157_;
	GtkBox* _tmp158_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp159_;
	GtkBox* _tmp160_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp161_;
	GtkBox* _tmp162_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp163_;
	GtkBox* _tmp164_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp165_;
	GtkBox* _tmp166_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp167_;
	GtkBox* _tmp168_;
	PantheonShellAppearancePrefersAccentColorButton* _tmp169_;
	GraniteHeaderLabel* accent_label = NULL;
	GtkBox* _tmp170_;
	GtkWidget* _tmp171_;
	GraniteHeaderLabel* _tmp172_ = NULL;
	GtkGrid* _tmp173_;
	GraniteHeaderLabel* _tmp174_;
	GtkGrid* _tmp175_;
	GtkBox* _tmp176_;
	GtkSwitch* _tmp177_ = NULL;
	GraniteHeaderLabel* animations_label = NULL;
	GtkSwitch* _tmp178_;
	GtkWidget* _tmp179_;
	gchar* _tmp180_;
	GraniteHeaderLabel* _tmp181_ = NULL;
	GtkBox* animations_box = NULL;
	GtkBox* _tmp182_ = NULL;
	GtkBox* _tmp183_;
	GraniteHeaderLabel* _tmp184_;
	GtkBox* _tmp185_;
	GtkSwitch* _tmp186_;
	GtkSwitch* scrollbar_switch = NULL;
	GtkSwitch* _tmp187_ = NULL;
	GraniteHeaderLabel* scrollbar_label = NULL;
	GtkSwitch* _tmp188_;
	GtkWidget* _tmp189_;
	gchar* _tmp190_;
	GraniteHeaderLabel* _tmp191_ = NULL;
	GtkBox* scrollbar_box = NULL;
	GtkBox* _tmp192_ = NULL;
	GtkBox* _tmp193_;
	GraniteHeaderLabel* _tmp194_;
	GtkBox* _tmp195_;
	GtkSwitch* _tmp196_;
	GtkGrid* _tmp197_;
	GtkBox* _tmp198_;
	GtkGrid* _tmp199_;
	GtkBox* _tmp200_;
	GtkGrid* _tmp201_;
	GSettings* _tmp202_;
	GtkSwitch* _tmp203_;
	GSettings* interface_settings = NULL;
	GSettings* _tmp204_;
	GSettings* _tmp205_;
	GtkSwitch* _tmp206_;
	GSettings* _tmp207_;
	GtkSwitch* _tmp208_;
	GSettings* background_settings = NULL;
	GSettings* _tmp209_;
	GSettings* _tmp210_;
	GtkSwitch* _tmp211_;
	const GVariantType* _tmp212_;
	GVariant* _tmp213_;
	GVariant* _tmp214_;
	GSimpleAction* _tmp215_;
	GSimpleAction* _tmp216_;
	GAction* color_scheme_action = NULL;
	GSettings* _tmp217_;
	GAction* _tmp218_;
	GAction* prefer_dark_action = NULL;
	GSettings* _tmp219_;
	GAction* _tmp220_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp221_;
	GSimpleActionGroup* _tmp222_;
	GSimpleAction* _tmp223_;
	GSimpleActionGroup* _tmp224_;
	GAction* _tmp225_;
	GSimpleActionGroup* _tmp226_;
	GAction* _tmp227_;
	GSimpleActionGroup* _tmp228_;
	PantheonShellPantheonAccountsService* _tmp229_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pantheon_shell_appearance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_APPEARANCE, PantheonShellAppearance);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = pantheon_shell_appearance_desktop_preview_new ("default");
	g_object_ref_sink (_tmp0_);
	default_preview = _tmp0_;
	_tmp1_ = g_strdup ("desktop-appearance.color-scheme");
	_tmp2_ = g_variant_new_string ("no-preference");
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp3_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_set ((GtkActionable*) _tmp3_, "action-target", _tmp2_, NULL);
	_g_variant_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	prefer_default_radio = _tmp3_;
	_tmp4_ = prefer_default_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "image-button");
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	prefer_default_grid = _tmp5_;
	_tmp6_ = prefer_default_grid;
	_tmp7_ = default_preview;
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = prefer_default_grid;
	_tmp9_ = (GtkLabel*) gtk_label_new (_ ("Default"));
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp10_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = prefer_default_grid;
	_tmp12_ = prefer_default_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = pantheon_shell_appearance_desktop_preview_new ("dark");
	g_object_ref_sink (_tmp13_);
	dark_preview = _tmp13_;
	_tmp14_ = g_strdup ("desktop-appearance.color-scheme");
	_tmp15_ = g_variant_new_string ("prefer-dark");
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = prefer_default_radio;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_tmp18_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp18_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_set ((GtkActionable*) _tmp18_, "action-target", _tmp15_, NULL);
	_g_variant_unref0 (_tmp15_);
	gtk_check_button_set_group (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	prefer_dark_radio = _tmp18_;
	_tmp19_ = prefer_dark_radio;
	gtk_widget_add_css_class ((GtkWidget*) _tmp19_, "image-button");
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp20_);
	prefer_dark_grid = _tmp20_;
	_tmp21_ = prefer_dark_grid;
	_tmp22_ = dark_preview;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 0, 0, 1, 1);
	_tmp23_ = prefer_dark_grid;
	_tmp24_ = (GtkLabel*) gtk_label_new (_ ("Dark"));
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp25_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = prefer_dark_grid;
	_tmp27_ = prefer_dark_radio;
	gtk_widget_set_parent ((GtkWidget*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp28_);
	prefer_style_box = _tmp28_;
	_tmp29_ = prefer_style_box;
	_tmp30_ = prefer_default_radio;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = prefer_style_box;
	_tmp32_ = prefer_dark_radio;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp33_);
	dim_switch = _tmp33_;
	_tmp34_ = dim_switch;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	_tmp36_ = granite_header_label_new (_ ("Dim Wallpaper With Dark Style"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp36_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp36_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	dim_label = _tmp36_;
	_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 18);
	g_object_ref_sink (_tmp37_);
	dim_box = _tmp37_;
	_tmp38_ = dim_box;
	_tmp39_ = dim_label;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = dim_box;
	_tmp41_ = dim_switch;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = g_strdup ("desktop-appearance.prefer-dark-schedule");
	_tmp43_ = g_variant_new_string ("disabled");
	g_variant_ref_sink (_tmp43_);
	_tmp44_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Disabled"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp44_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_set ((GtkActionable*) _tmp44_, "action-target", _tmp43_, NULL);
	_g_variant_unref0 (_tmp43_);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp44_, 3);
	g_object_ref_sink (_tmp44_);
	schedule_disabled_radio = _tmp44_;
	_tmp45_ = g_strdup ("desktop-appearance.prefer-dark-schedule");
	_tmp46_ = g_variant_new_string ("sunset-to-sunrise");
	g_variant_ref_sink (_tmp46_);
	_tmp47_ = schedule_disabled_radio;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	_tmp49_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Sunset to Sunrise"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp49_, _tmp45_);
	_g_free0 (_tmp45_);
	g_object_set ((GtkActionable*) _tmp49_, "action-target", _tmp46_, NULL);
	_g_variant_unref0 (_tmp46_);
	gtk_check_button_set_group (_tmp49_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	g_object_ref_sink (_tmp49_);
	schedule_sunset_radio = _tmp49_;
	_tmp50_ = (GtkLabel*) gtk_label_new (_ ("From:"));
	g_object_ref_sink (_tmp50_);
	from_label = _tmp50_;
	_tmp51_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp51_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp51_, 6);
	g_object_ref_sink (_tmp51_);
	_data1_->from_time = _tmp51_;
	_tmp52_ = (GtkLabel*) gtk_label_new (_ ("To:"));
	g_object_ref_sink (_tmp52_);
	to_label = _tmp52_;
	_tmp53_ = granite_time_picker_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp53_, TRUE);
	g_object_ref_sink (_tmp53_);
	_data1_->to_time = _tmp53_;
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp54_);
	schedule_manual_box = _tmp54_;
	_tmp55_ = schedule_manual_box;
	_tmp56_ = from_label;
	gtk_box_append (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = schedule_manual_box;
	_tmp58_ = _data1_->from_time;
	gtk_box_append (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = schedule_manual_box;
	_tmp60_ = to_label;
	gtk_box_append (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = schedule_manual_box;
	_tmp62_ = _data1_->to_time;
	gtk_box_append (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = g_strdup ("desktop-appearance.prefer-dark-schedule");
	_tmp64_ = g_variant_new_string ("manual");
	g_variant_ref_sink (_tmp64_);
	_tmp65_ = schedule_manual_box;
	_tmp66_ = _g_object_ref0 ((GtkWidget*) _tmp65_);
	_tmp67_ = schedule_disabled_radio;
	_tmp68_ = _g_object_ref0 (_tmp67_);
	_tmp69_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp69_, _tmp63_);
	_g_free0 (_tmp63_);
	g_object_set ((GtkActionable*) _tmp69_, "action-target", _tmp64_, NULL);
	_g_variant_unref0 (_tmp64_);
	gtk_check_button_set_child (_tmp69_, _tmp66_);
	_g_object_unref0 (_tmp66_);
	gtk_check_button_set_group (_tmp69_, _tmp68_);
	_g_object_unref0 (_tmp68_);
	g_object_ref_sink (_tmp69_);
	schedule_manual_radio = _tmp69_;
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_set ((GtkAccessible*) _tmp70_, "accessible-role", GTK_ACCESSIBLE_ROLE_LIST, NULL);
	g_object_ref_sink (_tmp70_);
	schedule_box = _tmp70_;
	_tmp71_ = schedule_box;
	_tmp72_ = schedule_disabled_radio;
	gtk_box_append (_tmp71_, (GtkWidget*) _tmp72_);
	_tmp73_ = schedule_box;
	_tmp74_ = schedule_sunset_radio;
	gtk_box_append (_tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = schedule_box;
	_tmp76_ = schedule_manual_radio;
	gtk_box_append (_tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = schedule_box;
	_tmp78_ = _g_object_ref0 ((GtkWidget*) _tmp77_);
	_tmp79_ = granite_header_label_new (_ ("Schedule"));
	granite_header_label_set_mnemonic_widget (_tmp79_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	g_object_ref_sink (_tmp79_);
	schedule_label = _tmp79_;
	_data1_->pantheon_act = NULL;
	user_path = NULL;
	{
		PantheonShellFDOAccounts* accounts_service = NULL;
		PantheonShellFDOAccounts* _tmp80_;
		gchar* _tmp81_ = NULL;
		PantheonShellFDOAccounts* _tmp82_;
		const gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp80_ = (PantheonShellFDOAccounts*) g_initable_new (PANTHEON_SHELL_FDO_TYPE_ACCOUNTS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		accounts_service = (PantheonShellFDOAccounts*) _tmp80_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp82_ = accounts_service;
		_tmp83_ = g_get_user_name ();
		_tmp84_ = pantheon_shell_fdo_accounts_find_user_by_name (_tmp82_, _tmp83_, &_inner_error0_);
		_tmp81_ = _tmp84_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (accounts_service);
			goto __catch0_g_error;
		}
		_tmp85_ = _tmp81_;
		_tmp81_ = NULL;
		_g_free0 (user_path);
		user_path = _tmp85_;
		_g_free0 (_tmp81_);
		_g_object_unref0 (accounts_service);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp86_;
		const gchar* _tmp87_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp86_ = e;
		_tmp87_ = _tmp86_->message;
		g_critical ("Appearance.vala:182: %s", _tmp87_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (user_path);
		_g_object_unref0 (schedule_label);
		_g_object_unref0 (schedule_box);
		_g_object_unref0 (schedule_manual_radio);
		_g_object_unref0 (schedule_manual_box);
		_g_object_unref0 (to_label);
		_g_object_unref0 (from_label);
		_g_object_unref0 (schedule_sunset_radio);
		_g_object_unref0 (schedule_disabled_radio);
		_g_object_unref0 (dim_box);
		_g_object_unref0 (dim_label);
		_g_object_unref0 (dim_switch);
		_g_object_unref0 (prefer_style_box);
		_g_object_unref0 (prefer_dark_grid);
		_g_object_unref0 (prefer_dark_radio);
		_g_object_unref0 (dark_preview);
		_g_object_unref0 (prefer_default_grid);
		_g_object_unref0 (prefer_default_radio);
		_g_object_unref0 (default_preview);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp88_ = user_path;
	if (_tmp88_ != NULL) {
		{
			PantheonShellPantheonAccountsService* _tmp89_ = NULL;
			const gchar* _tmp90_;
			PantheonShellPantheonAccountsService* _tmp91_;
			PantheonShellPantheonAccountsService* _tmp92_;
			_tmp90_ = user_path;
			_tmp91_ = (PantheonShellPantheonAccountsService*) g_initable_new (PANTHEON_SHELL_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp90_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
			_tmp89_ = (PantheonShellPantheonAccountsService*) _tmp91_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp92_ = _tmp89_;
			_tmp89_ = NULL;
			_g_object_unref0 (_data1_->pantheon_act);
			_data1_->pantheon_act = _tmp92_;
			_g_object_unref0 (_tmp89_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("Appearance.vala:194: Unable to get AccountsService proxy, color scheme" \
" preference may be incorrect");
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_path);
			_g_object_unref0 (schedule_label);
			_g_object_unref0 (schedule_box);
			_g_object_unref0 (schedule_manual_radio);
			_g_object_unref0 (schedule_manual_box);
			_g_object_unref0 (to_label);
			_g_object_unref0 (from_label);
			_g_object_unref0 (schedule_sunset_radio);
			_g_object_unref0 (schedule_disabled_radio);
			_g_object_unref0 (dim_box);
			_g_object_unref0 (dim_label);
			_g_object_unref0 (dim_switch);
			_g_object_unref0 (prefer_style_box);
			_g_object_unref0 (prefer_dark_grid);
			_g_object_unref0 (prefer_dark_radio);
			_g_object_unref0 (dark_preview);
			_g_object_unref0 (prefer_default_grid);
			_g_object_unref0 (prefer_default_radio);
			_g_object_unref0 (default_preview);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	_tmp93_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp93_, 6);
	g_object_ref_sink (_tmp93_);
	grid = _tmp93_;
	_tmp94_ = grid;
	_tmp95_ = prefer_style_box;
	gtk_grid_attach (_tmp94_, (GtkWidget*) _tmp95_, 0, 2, 2, 1);
	_tmp96_ = grid;
	_tmp97_ = dim_box;
	gtk_grid_attach (_tmp96_, (GtkWidget*) _tmp97_, 0, 3, 2, 1);
	_tmp98_ = grid;
	_tmp99_ = schedule_label;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 0, 4, 2, 1);
	_tmp100_ = grid;
	_tmp101_ = schedule_box;
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 0, 5, 2, 1);
	_tmp102_ = g_settings_new ("io.elementary.settings-daemon.prefers-color-scheme");
	_data1_->settings = _tmp102_;
	_tmp103_ = _data1_->from_time;
	_tmp104_ = _data1_->settings;
	_tmp105_ = pantheon_shell_appearance_double_date_time (g_settings_get_double (_tmp104_, "prefer-dark-schedule-from"));
	_tmp106_ = _tmp105_;
	granite_time_picker_set_time (_tmp103_, _tmp106_);
	_g_date_time_unref0 (_tmp106_);
	_tmp107_ = _data1_->from_time;
	g_signal_connect_data (_tmp107_, "time-changed", (GCallback) __pantheon_shell_appearance___lambda35__granite_time_picker_time_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp108_ = _data1_->to_time;
	_tmp109_ = _data1_->settings;
	_tmp110_ = pantheon_shell_appearance_double_date_time (g_settings_get_double (_tmp109_, "prefer-dark-schedule-to"));
	_tmp111_ = _tmp110_;
	granite_time_picker_set_time (_tmp108_, _tmp111_);
	_g_date_time_unref0 (_tmp111_);
	_tmp112_ = _data1_->to_time;
	g_signal_connect_data (_tmp112_, "time-changed", (GCallback) __pantheon_shell_appearance___lambda36__granite_time_picker_time_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp113_ = schedule_manual_radio;
	_tmp114_ = schedule_manual_box;
	g_object_bind_property_with_closures ((GObject*) _tmp113_, "active", (GObject*) _tmp114_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp115_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BLUE, NULL);
	g_object_ref_sink (_tmp115_);
	blueberry_button = _tmp115_;
	_tmp116_ = blueberry_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp116_, _ ("Blueberry"));
	_tmp117_ = blueberry_button;
	_tmp118_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_MINT, (GtkCheckButton*) _tmp117_);
	g_object_ref_sink (_tmp118_);
	mint_button = _tmp118_;
	_tmp119_ = mint_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp119_, _ ("Mint"));
	_tmp120_ = blueberry_button;
	_tmp121_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GREEN, (GtkCheckButton*) _tmp120_);
	g_object_ref_sink (_tmp121_);
	lime_button = _tmp121_;
	_tmp122_ = lime_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp122_, _ ("Lime"));
	_tmp123_ = blueberry_button;
	_tmp124_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_YELLOW, (GtkCheckButton*) _tmp123_);
	g_object_ref_sink (_tmp124_);
	banana_button = _tmp124_;
	_tmp125_ = banana_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp125_, _ ("Banana"));
	_tmp126_ = blueberry_button;
	_tmp127_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_ORANGE, (GtkCheckButton*) _tmp126_);
	g_object_ref_sink (_tmp127_);
	orange_button = _tmp127_;
	_tmp128_ = orange_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp128_, _ ("Orange"));
	_tmp129_ = blueberry_button;
	_tmp130_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_RED, (GtkCheckButton*) _tmp129_);
	g_object_ref_sink (_tmp130_);
	strawberry_button = _tmp130_;
	_tmp131_ = strawberry_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp131_, _ ("Strawberry"));
	_tmp132_ = blueberry_button;
	_tmp133_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PINK, (GtkCheckButton*) _tmp132_);
	g_object_ref_sink (_tmp133_);
	bubblegum_button = _tmp133_;
	_tmp134_ = bubblegum_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp134_, _ ("Bubblegum"));
	_tmp135_ = blueberry_button;
	_tmp136_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_PURPLE, (GtkCheckButton*) _tmp135_);
	g_object_ref_sink (_tmp136_);
	grape_button = _tmp136_;
	_tmp137_ = grape_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp137_, _ ("Grape"));
	_tmp138_ = blueberry_button;
	_tmp139_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_BROWN, (GtkCheckButton*) _tmp138_);
	g_object_ref_sink (_tmp139_);
	cocoa_button = _tmp139_;
	_tmp140_ = cocoa_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp140_, _ ("Cocoa"));
	_tmp141_ = blueberry_button;
	_tmp142_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_GRAY, (GtkCheckButton*) _tmp141_);
	g_object_ref_sink (_tmp142_);
	slate_button = _tmp142_;
	_tmp143_ = slate_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp143_, _ ("Slate"));
	_tmp144_ = blueberry_button;
	_tmp145_ = pantheon_shell_appearance_prefers_accent_color_button_new (PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE, (GtkCheckButton*) _tmp144_);
	g_object_ref_sink (_tmp145_);
	auto_button = _tmp145_;
	_tmp146_ = auto_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp146_, _ ("Automatic based on wallpaper"));
	_tmp147_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_set ((GtkAccessible*) _tmp147_, "accessible-role", GTK_ACCESSIBLE_ROLE_LIST, NULL);
	g_object_ref_sink (_tmp147_);
	accent_box = _tmp147_;
	_tmp148_ = accent_box;
	_tmp149_ = blueberry_button;
	gtk_box_append (_tmp148_, (GtkWidget*) _tmp149_);
	_tmp150_ = accent_box;
	_tmp151_ = mint_button;
	gtk_box_append (_tmp150_, (GtkWidget*) _tmp151_);
	_tmp152_ = accent_box;
	_tmp153_ = lime_button;
	gtk_box_append (_tmp152_, (GtkWidget*) _tmp153_);
	_tmp154_ = accent_box;
	_tmp155_ = banana_button;
	gtk_box_append (_tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = accent_box;
	_tmp157_ = orange_button;
	gtk_box_append (_tmp156_, (GtkWidget*) _tmp157_);
	_tmp158_ = accent_box;
	_tmp159_ = strawberry_button;
	gtk_box_append (_tmp158_, (GtkWidget*) _tmp159_);
	_tmp160_ = accent_box;
	_tmp161_ = bubblegum_button;
	gtk_box_append (_tmp160_, (GtkWidget*) _tmp161_);
	_tmp162_ = accent_box;
	_tmp163_ = grape_button;
	gtk_box_append (_tmp162_, (GtkWidget*) _tmp163_);
	_tmp164_ = accent_box;
	_tmp165_ = cocoa_button;
	gtk_box_append (_tmp164_, (GtkWidget*) _tmp165_);
	_tmp166_ = accent_box;
	_tmp167_ = slate_button;
	gtk_box_append (_tmp166_, (GtkWidget*) _tmp167_);
	_tmp168_ = accent_box;
	_tmp169_ = auto_button;
	gtk_box_append (_tmp168_, (GtkWidget*) _tmp169_);
	_tmp170_ = accent_box;
	_tmp171_ = _g_object_ref0 ((GtkWidget*) _tmp170_);
	_tmp172_ = granite_header_label_new (_ ("Accent Color"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp172_, 18);
	granite_header_label_set_mnemonic_widget (_tmp172_, _tmp171_);
	_g_object_unref0 (_tmp171_);
	g_object_ref_sink (_tmp172_);
	accent_label = _tmp172_;
	_tmp173_ = grid;
	_tmp174_ = accent_label;
	gtk_grid_attach (_tmp173_, (GtkWidget*) _tmp174_, 0, 8, 2, 1);
	_tmp175_ = grid;
	_tmp176_ = accent_box;
	gtk_grid_attach (_tmp175_, (GtkWidget*) _tmp176_, 0, 9, 2, 1);
	_tmp177_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp177_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp177_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp177_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp177_);
	_data1_->animations_switch = _tmp177_;
	_tmp178_ = _data1_->animations_switch;
	_tmp179_ = _g_object_ref0 ((GtkWidget*) _tmp178_);
	_tmp180_ = g_strdup (_ ("Disable animations in the window manager and some other interface elem" \
"ents."));
	_tmp181_ = granite_header_label_new (_ ("Reduce Motion"));
	granite_header_label_set_mnemonic_widget (_tmp181_, _tmp179_);
	_g_object_unref0 (_tmp179_);
	granite_header_label_set_secondary_text (_tmp181_, _tmp180_);
	_g_free0 (_tmp180_);
	g_object_ref_sink (_tmp181_);
	animations_label = _tmp181_;
	_tmp182_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp182_, 18);
	g_object_ref_sink (_tmp182_);
	animations_box = _tmp182_;
	_tmp183_ = animations_box;
	_tmp184_ = animations_label;
	gtk_box_append (_tmp183_, (GtkWidget*) _tmp184_);
	_tmp185_ = animations_box;
	_tmp186_ = _data1_->animations_switch;
	gtk_box_append (_tmp185_, (GtkWidget*) _tmp186_);
	_tmp187_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp187_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp187_);
	scrollbar_switch = _tmp187_;
	_tmp188_ = scrollbar_switch;
	_tmp189_ = _g_object_ref0 ((GtkWidget*) _tmp188_);
	_tmp190_ = g_strdup (_ ("Scrollbars will take up space, even when not in use."));
	_tmp191_ = granite_header_label_new (_ ("Always Show Scrollbars"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp191_, TRUE);
	granite_header_label_set_mnemonic_widget (_tmp191_, _tmp189_);
	_g_object_unref0 (_tmp189_);
	granite_header_label_set_secondary_text (_tmp191_, _tmp190_);
	_g_free0 (_tmp190_);
	g_object_ref_sink (_tmp191_);
	scrollbar_label = _tmp191_;
	_tmp192_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp192_, 18);
	g_object_ref_sink (_tmp192_);
	scrollbar_box = _tmp192_;
	_tmp193_ = scrollbar_box;
	_tmp194_ = scrollbar_label;
	gtk_box_append (_tmp193_, (GtkWidget*) _tmp194_);
	_tmp195_ = scrollbar_box;
	_tmp196_ = scrollbar_switch;
	gtk_box_append (_tmp195_, (GtkWidget*) _tmp196_);
	_tmp197_ = grid;
	_tmp198_ = animations_box;
	gtk_grid_attach (_tmp197_, (GtkWidget*) _tmp198_, 0, 10, 2, 1);
	_tmp199_ = grid;
	_tmp200_ = scrollbar_box;
	gtk_grid_attach (_tmp199_, (GtkWidget*) _tmp200_, 0, 11, 2, 1);
	_tmp201_ = grid;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp201_);
	gtk_widget_add_css_class ((GtkWidget*) self, "appearance-view");
	_tmp202_ = g_settings_new ("io.elementary.desktop.wm.animations");
	_data1_->animations_settings = _tmp202_;
	_tmp203_ = _data1_->animations_switch;
	g_signal_connect_data ((GObject*) _tmp203_, "notify::active", (GCallback) __pantheon_shell_appearance___lambda37__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp204_ = g_settings_new ("org.gnome.desktop.interface");
	interface_settings = _tmp204_;
	_tmp205_ = interface_settings;
	_tmp206_ = scrollbar_switch;
	g_settings_bind (_tmp205_, "overlay-scrolling", (GObject*) _tmp206_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp207_ = interface_settings;
	_tmp208_ = _data1_->animations_switch;
	g_settings_bind (_tmp207_, "enable-animations", (GObject*) _tmp208_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp209_ = g_settings_new ("io.elementary.desktop.background");
	background_settings = _tmp209_;
	_tmp210_ = background_settings;
	_tmp211_ = dim_switch;
	g_settings_bind (_tmp210_, "dim-wallpaper-in-dark-style", (GObject*) _tmp211_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp212_ = G_VARIANT_TYPE_INT32;
	_tmp213_ = g_variant_new_int32 ((gint32) PANTHEON_SHELL_APPEARANCE_ACCENT_COLOR_NO_PREFERENCE);
	g_variant_ref_sink (_tmp213_);
	_tmp214_ = _tmp213_;
	_tmp215_ = g_simple_action_new_stateful ("prefers-accent-color", _tmp212_, _tmp214_);
	_tmp216_ = _tmp215_;
	_g_variant_unref0 (_tmp214_);
	_data1_->accent_color_action = _tmp216_;
	_tmp217_ = _data1_->settings;
	_tmp218_ = g_settings_create_action (_tmp217_, "color-scheme");
	color_scheme_action = _tmp218_;
	_tmp219_ = _data1_->settings;
	_tmp220_ = g_settings_create_action (_tmp219_, "prefer-dark-schedule");
	prefer_dark_action = _tmp220_;
	_tmp221_ = g_simple_action_group_new ();
	action_group = _tmp221_;
	_tmp222_ = action_group;
	_tmp223_ = _data1_->accent_color_action;
	g_action_map_add_action ((GActionMap*) _tmp222_, (GAction*) _tmp223_);
	_tmp224_ = action_group;
	_tmp225_ = color_scheme_action;
	g_action_map_add_action ((GActionMap*) _tmp224_, _tmp225_);
	_tmp226_ = action_group;
	_tmp227_ = prefer_dark_action;
	g_action_map_add_action ((GActionMap*) _tmp226_, _tmp227_);
	_tmp228_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "desktop-appearance", (GActionGroup*) _tmp228_);
	_tmp229_ = _data1_->pantheon_act;
	if (_tmp229_ != NULL) {
		GSimpleAction* _tmp230_;
		PantheonShellPantheonAccountsService* _tmp231_;
		gint _tmp232_;
		gint _tmp233_;
		GVariant* _tmp234_;
		GVariant* _tmp235_;
		PantheonShellPantheonAccountsService* _tmp236_;
		GSimpleAction* _tmp237_;
		_tmp230_ = _data1_->accent_color_action;
		_tmp231_ = _data1_->pantheon_act;
		_tmp232_ = pantheon_shell_pantheon_accounts_service_get_prefers_accent_color (_tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = g_variant_new_int32 ((gint32) _tmp233_);
		g_variant_ref_sink (_tmp234_);
		_tmp235_ = _tmp234_;
		g_simple_action_set_state (_tmp230_, _tmp235_);
		_g_variant_unref0 (_tmp235_);
		_tmp236_ = _data1_->pantheon_act;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __pantheon_shell_appearance____lambda38__g_dbus_proxy_g_properties_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp237_ = _data1_->accent_color_action;
		g_signal_connect_data (_tmp237_, "activate", (GCallback) __pantheon_shell_appearance____lambda39__g_simple_action_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	}
	_g_object_unref0 (action_group);
	_g_object_unref0 (prefer_dark_action);
	_g_object_unref0 (color_scheme_action);
	_g_object_unref0 (background_settings);
	_g_object_unref0 (interface_settings);
	_g_object_unref0 (scrollbar_box);
	_g_object_unref0 (scrollbar_label);
	_g_object_unref0 (scrollbar_switch);
	_g_object_unref0 (animations_box);
	_g_object_unref0 (animations_label);
	_g_object_unref0 (accent_label);
	_g_object_unref0 (accent_box);
	_g_object_unref0 (auto_button);
	_g_object_unref0 (slate_button);
	_g_object_unref0 (cocoa_button);
	_g_object_unref0 (grape_button);
	_g_object_unref0 (bubblegum_button);
	_g_object_unref0 (strawberry_button);
	_g_object_unref0 (orange_button);
	_g_object_unref0 (banana_button);
	_g_object_unref0 (lime_button);
	_g_object_unref0 (mint_button);
	_g_object_unref0 (blueberry_button);
	_g_object_unref0 (grid);
	_g_free0 (user_path);
	_g_object_unref0 (schedule_label);
	_g_object_unref0 (schedule_box);
	_g_object_unref0 (schedule_manual_radio);
	_g_object_unref0 (schedule_manual_box);
	_g_object_unref0 (to_label);
	_g_object_unref0 (from_label);
	_g_object_unref0 (schedule_sunset_radio);
	_g_object_unref0 (schedule_disabled_radio);
	_g_object_unref0 (dim_box);
	_g_object_unref0 (dim_label);
	_g_object_unref0 (dim_switch);
	_g_object_unref0 (prefer_style_box);
	_g_object_unref0 (prefer_dark_grid);
	_g_object_unref0 (prefer_dark_radio);
	_g_object_unref0 (dark_preview);
	_g_object_unref0 (prefer_default_grid);
	_g_object_unref0 (prefer_default_radio);
	_g_object_unref0 (default_preview);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
pantheon_shell_appearance_class_init (PantheonShellAppearanceClass * klass,
                                      gpointer klass_data)
{
	pantheon_shell_appearance_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_appearance_constructor;
}

static void
pantheon_shell_appearance_instance_init (PantheonShellAppearance * self,
                                         gpointer klass)
{
}

static GType
pantheon_shell_appearance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellAppearanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_appearance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellAppearance), 0, (GInstanceInitFunc) pantheon_shell_appearance_instance_init, NULL };
	GType pantheon_shell_appearance_type_id;
	pantheon_shell_appearance_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PantheonShellAppearance", &g_define_type_info, 0);
	return pantheon_shell_appearance_type_id;
}

GType
pantheon_shell_appearance_get_type (void)
{
	static volatile gsize pantheon_shell_appearance_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_appearance_type_id__once)) {
		GType pantheon_shell_appearance_type_id;
		pantheon_shell_appearance_type_id = pantheon_shell_appearance_get_type_once ();
		g_once_init_leave (&pantheon_shell_appearance_type_id__once, pantheon_shell_appearance_type_id);
	}
	return pantheon_shell_appearance_type_id__once;
}

