/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
* Copyright 2013-2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Julien Spautz <spautz.julien@gmail.com>
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "applications.h"
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define STARTUP_UTILS_AUTOSTART_DIR "autostart"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

gchar*
startup_utils_get_user_startup_dir (void)
{
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* startup_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = config_dir;
	_tmp3_ = g_build_filename (_tmp2_, STARTUP_UTILS_AUTOSTART_DIR, NULL);
	startup_dir = _tmp3_;
	_tmp4_ = startup_dir;
	if (g_file_test (_tmp4_, G_FILE_TEST_EXISTS) == FALSE) {
		GFile* file = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		_tmp5_ = startup_dir;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		file = _tmp6_;
		{
			GFile* _tmp7_;
			_tmp7_ = file;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("Utils.vala:35: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (startup_dir);
			_g_free0 (config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_object_unref0 (file);
	}
	result = startup_dir;
	_g_free0 (config_dir);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
startup_utils_is_desktop_file (const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	if (!string_contains (name, "~")) {
		_tmp0_ = g_str_has_suffix (name, ".desktop");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkImage*
startup_utils_create_icon (StartupEntityAppInfo* app_info)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkIconTheme* icon_theme = NULL;
	GdkDisplay* _tmp1_;
	GtkIconTheme* _tmp2_;
	GtkIconTheme* _tmp3_;
	GtkIconTheme* _tmp4_;
	StartupEntityAppInfo _tmp5_;
	const gchar* _tmp6_;
	GtkImage* result;
	g_return_val_if_fail (app_info != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp0_, 32);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gtk_icon_theme_get_for_display (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	icon_theme = _tmp3_;
	_tmp4_ = icon_theme;
	_tmp5_ = *app_info;
	_tmp6_ = _tmp5_.icon;
	if (gtk_icon_theme_has_icon (_tmp4_, _tmp6_)) {
		GtkImage* _tmp7_;
		StartupEntityAppInfo _tmp8_;
		const gchar* _tmp9_;
		GThemedIcon* _tmp10_;
		GThemedIcon* _tmp11_;
		_tmp7_ = image;
		_tmp8_ = *app_info;
		_tmp9_ = _tmp8_.icon;
		_tmp10_ = (GThemedIcon*) g_themed_icon_new (_tmp9_);
		_tmp11_ = _tmp10_;
		g_object_set (_tmp7_, "gicon", (GIcon*) _tmp11_, NULL);
		_g_object_unref0 (_tmp11_);
	} else {
		GtkImage* _tmp12_;
		GThemedIcon* _tmp13_;
		GThemedIcon* _tmp14_;
		_tmp12_ = image;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_tmp14_ = _tmp13_;
		g_object_set (_tmp12_, "gicon", (GIcon*) _tmp14_, NULL);
		_g_object_unref0 (_tmp14_);
	}
	result = image;
	_g_object_unref0 (icon_theme);
	return result;
}

