/* KeyFile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from KeyFile.vala, do not modify */

/*
* Copyright 2013-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Julien Spautz <spautz.julien@gmail.com>
*/

#include "applications.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

#define STARTUP_BACKEND_KEY_FILE_FALLBACK_ICON "application-default-icon"
#define STARTUP_BACKEND_KEY_FILE_KEY_GNOME_AUTOSTART_ENABLED "X-GNOME-Autostart-enabled"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	STARTUP_BACKEND_KEY_FILE_0_PROPERTY,
	STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY,
	STARTUP_BACKEND_KEY_FILE_SHOW_PROPERTY,
	STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY,
	STARTUP_BACKEND_KEY_FILE_NUM_PROPERTIES
};
static GParamSpec* startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _StartupBackendKeyFilePrivate {
	gchar* _path;
	GKeyFile* keyfile;
};

static gint StartupBackendKeyFile_private_offset;
static gpointer startup_backend_key_file_parent_class = NULL;
static gchar** startup_backend_key_file_languages;
static gint startup_backend_key_file_languages_length1;
static gchar** startup_backend_key_file_languages = NULL;
static gint startup_backend_key_file_languages_length1 = 0;
static gint _startup_backend_key_file_languages_size_ = 0;
static gchar* startup_backend_key_file_preferred_language;
static gchar* startup_backend_key_file_preferred_language = NULL;

static gchar* startup_backend_key_file_create_path_for_custom_command (StartupBackendKeyFile* self);
static gchar* startup_backend_key_file_keyfile_get_locale_string (StartupBackendKeyFile* self,
                                                           const gchar* key);
static gchar* startup_backend_key_file_keyfile_get_string (StartupBackendKeyFile* self,
                                                    const gchar* key);
static gboolean startup_backend_key_file_keyfile_get_bool (StartupBackendKeyFile* self,
                                                    const gchar* key);
static gboolean startup_backend_key_file_keyfile_has_key (StartupBackendKeyFile* self,
                                                   const gchar* key);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void startup_backend_key_file_finalize (GObject * obj);
static GType startup_backend_key_file_get_type_once (void);
static void _vala_startup_backend_key_file_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_startup_backend_key_file_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
startup_backend_key_file_get_instance_private (StartupBackendKeyFile* self)
{
	return G_STRUCT_MEMBER_P (self, StartupBackendKeyFile_private_offset);
}

StartupBackendKeyFile*
startup_backend_key_file_construct (GType object_type,
                                    const gchar* path)
{
	StartupBackendKeyFile * self = NULL;
	GKeyFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (StartupBackendKeyFile*) g_object_new (object_type, "path", path, NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	{
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyfile;
		g_key_file_load_from_file (_tmp1_, path, G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_warning ("KeyFile.vala:92: Failed to load contents of file '%s'", path);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("KeyFile.vala:93: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

StartupBackendKeyFile*
startup_backend_key_file_new (const gchar* path)
{
	return startup_backend_key_file_construct (STARTUP_BACKEND_TYPE_KEY_FILE, path);
}

StartupBackendKeyFile*
startup_backend_key_file_construct_from_command (GType object_type,
                                                 const gchar* command)
{
	StartupBackendKeyFile * self = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	const gchar* _tmp2_;
	GKeyFile* _tmp3_;
	const gchar* _tmp4_;
	GKeyFile* _tmp5_;
	GKeyFile* _tmp6_;
	GKeyFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (command != NULL, NULL);
	self = (StartupBackendKeyFile*) g_object_new (object_type, NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp0_;
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = startup_backend_key_file_preferred_language;
	g_key_file_set_locale_string (_tmp1_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NAME, _tmp2_, _ ("Custom Command"));
	_tmp3_ = self->priv->keyfile;
	_tmp4_ = startup_backend_key_file_preferred_language;
	g_key_file_set_locale_string (_tmp3_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_COMMENT, _tmp4_, command);
	_tmp5_ = self->priv->keyfile;
	g_key_file_set_string (_tmp5_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_EXEC, command);
	_tmp6_ = self->priv->keyfile;
	g_key_file_set_string (_tmp6_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, STARTUP_BACKEND_KEY_FILE_FALLBACK_ICON);
	_tmp7_ = self->priv->keyfile;
	g_key_file_set_string (_tmp7_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, G_KEY_FILE_DESKTOP_TYPE_APPLICATION);
	startup_backend_key_file_set_active (self, TRUE);
	_tmp8_ = startup_backend_key_file_create_path_for_custom_command (self);
	_tmp9_ = _tmp8_;
	startup_backend_key_file_set_path (self, _tmp9_);
	_g_free0 (_tmp9_);
	startup_backend_key_file_write_to_file (self);
	return self;
}

StartupBackendKeyFile*
startup_backend_key_file_new_from_command (const gchar* command)
{
	return startup_backend_key_file_construct_from_command (STARTUP_BACKEND_TYPE_KEY_FILE, command);
}

static gchar*
startup_backend_key_file_create_path_for_custom_command (StartupBackendKeyFile* self)
{
	gchar* startup_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = startup_utils_get_user_startup_dir ();
	startup_dir = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* filename = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 100)) {
					break;
				}
				_tmp3_ = startup_dir;
				_tmp4_ = g_strdup_printf ("%i", i);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat ("custom-command", _tmp5_, ".desktop", NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_build_filename (_tmp3_, _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				filename = _tmp9_;
				_tmp10_ = filename;
				if (g_file_test (_tmp10_, G_FILE_TEST_EXISTS) == FALSE) {
					result = filename;
					_g_free0 (startup_dir);
					return result;
				}
				_g_free0 (filename);
			}
		}
	}
	_tmp11_ = g_strdup ("");
	result = _tmp11_;
	_g_free0 (startup_dir);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
startup_backend_key_file_write_to_file (StartupBackendKeyFile* self)
{
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = self->priv->_path;
		_tmp1_ = self->priv->keyfile;
		_tmp2_ = g_key_file_to_data (_tmp1_, NULL, NULL);
		_tmp3_ = _tmp2_;
		g_file_set_contents (_tmp0_, _tmp3_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = self->priv->_path;
		g_warning ("KeyFile.vala:129: Could not write to file %s", _tmp4_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("KeyFile.vala:130: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = self->priv->_path;
	g_debug ("KeyFile.vala:133: -- Saving to %s --", _tmp7_);
	_tmp8_ = startup_backend_key_file_keyfile_get_locale_string (self, G_KEY_FILE_DESKTOP_KEY_NAME);
	_tmp9_ = _tmp8_;
	g_debug ("KeyFile.vala:134: Name:    %s", _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = startup_backend_key_file_keyfile_get_locale_string (self, G_KEY_FILE_DESKTOP_KEY_COMMENT);
	_tmp11_ = _tmp10_;
	g_debug ("KeyFile.vala:135: Comment: %s", _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = startup_backend_key_file_keyfile_get_string (self, G_KEY_FILE_DESKTOP_KEY_EXEC);
	_tmp13_ = _tmp12_;
	g_debug ("KeyFile.vala:136: Command: %s", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = startup_backend_key_file_keyfile_get_string (self, G_KEY_FILE_DESKTOP_KEY_ICON);
	_tmp15_ = _tmp14_;
	g_debug ("KeyFile.vala:137: Icon:    %s", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = startup_backend_key_file_get_active (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = bool_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	g_debug ("KeyFile.vala:138: Active:  %s", _tmp19_);
	_g_free0 (_tmp19_);
	g_debug ("KeyFile.vala:139: -- Done --");
}

static gboolean
startup_backend_key_file_keyfile_get_bool (StartupBackendKeyFile* self,
                                           const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyfile;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, G_KEY_FILE_DESKTOP_GROUP, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("KeyFile.vala:146: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	return result;
}

static gchar*
startup_backend_key_file_keyfile_get_string (StartupBackendKeyFile* self,
                                             const gchar* key)
{
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->keyfile;
		_tmp2_ = g_key_file_get_string (_tmp1_, G_KEY_FILE_DESKTOP_GROUP, key, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_debug ("KeyFile.vala:156: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = g_strdup ("");
	result = _tmp6_;
	return result;
}

static gchar*
startup_backend_key_file_keyfile_get_locale_string (StartupBackendKeyFile* self,
                                                    const gchar* key)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = startup_backend_key_file_languages;
	_tmp0__length1 = startup_backend_key_file_languages_length1;
	{
		gchar** lang_collection = NULL;
		gint lang_collection_length1 = 0;
		gint _lang_collection_size_ = 0;
		gint lang_it = 0;
		lang_collection = _tmp0_;
		lang_collection_length1 = _tmp0__length1;
		for (lang_it = 0; lang_it < lang_collection_length1; lang_it = lang_it + 1) {
			gchar* _tmp1_;
			gchar* lang = NULL;
			_tmp1_ = g_strdup (lang_collection[lang_it]);
			lang = _tmp1_;
			{
				{
					gchar* _tmp2_ = NULL;
					GKeyFile* _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp3_ = self->priv->keyfile;
					_tmp4_ = lang;
					_tmp5_ = g_key_file_get_locale_string (_tmp3_, G_KEY_FILE_DESKTOP_GROUP, key, _tmp4_, &_inner_error0_);
					_tmp2_ = _tmp5_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						_g_free0 (lang);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp6_ = _tmp2_;
					_tmp2_ = NULL;
					result = _tmp6_;
					_g_free0 (_tmp2_);
					_g_free0 (lang);
					return result;
				}
				goto __finally0;
				__catch0_g_key_file_error:
				{
					GError* e = NULL;
					GError* _tmp7_;
					const gchar* _tmp8_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp7_ = e;
					_tmp8_ = _tmp7_->message;
					g_debug ("KeyFile.vala:167: %s", _tmp8_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (lang);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (lang);
			}
		}
	}
	_tmp9_ = g_strdup ("");
	result = _tmp9_;
	return result;
}

static gboolean
startup_backend_key_file_keyfile_has_key (StartupBackendKeyFile* self,
                                          const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->priv->keyfile;
		_tmp0_ = g_key_file_has_key (_tmp1_, G_KEY_FILE_DESKTOP_GROUP, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("KeyFile.vala:178: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	return result;
}

void
startup_backend_key_file_copy_to_local (StartupBackendKeyFile* self)
{
	const gchar* _tmp0_;
	gchar* basename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* startup_dir = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_path;
	_vala_return_if_fail (_tmp0_ != NULL, "path != null");
	_tmp1_ = self->priv->_path;
	_tmp2_ = g_path_get_basename (_tmp1_);
	basename = _tmp2_;
	_tmp3_ = startup_utils_get_user_startup_dir ();
	startup_dir = _tmp3_;
	_tmp4_ = g_build_filename (startup_dir, basename, NULL);
	_tmp5_ = _tmp4_;
	startup_backend_key_file_set_path (self, _tmp5_);
	_g_free0 (_tmp5_);
	startup_backend_key_file_write_to_file (self);
	_g_free0 (startup_dir);
	_g_free0 (basename);
}

void
startup_backend_key_file_create_app_info (StartupBackendKeyFile* self,
                                          StartupEntityAppInfo* result)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	StartupEntityAppInfo _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = startup_backend_key_file_keyfile_get_locale_string (self, G_KEY_FILE_DESKTOP_KEY_NAME);
	_tmp1_ = startup_backend_key_file_keyfile_get_locale_string (self, G_KEY_FILE_DESKTOP_KEY_COMMENT);
	_tmp2_ = startup_backend_key_file_keyfile_get_locale_string (self, G_KEY_FILE_DESKTOP_KEY_ICON);
	_tmp3_ = startup_backend_key_file_get_active (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_path;
	_tmp6_ = g_strdup (_tmp5_);
	memset (&_tmp7_, 0, sizeof (StartupEntityAppInfo));
	_g_free0 (_tmp7_.name);
	_tmp7_.name = _tmp0_;
	_g_free0 (_tmp7_.comment);
	_tmp7_.comment = _tmp1_;
	_g_free0 (_tmp7_.icon);
	_tmp7_.icon = _tmp2_;
	_tmp7_.active = _tmp4_;
	_g_free0 (_tmp7_.path);
	_tmp7_.path = _tmp6_;
	*result = _tmp7_;
	return;
}

gboolean
startup_backend_key_file_get_active (StartupBackendKeyFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (startup_backend_key_file_keyfile_has_key (self, STARTUP_BACKEND_KEY_FILE_KEY_GNOME_AUTOSTART_ENABLED)) {
		result = startup_backend_key_file_keyfile_get_bool (self, STARTUP_BACKEND_KEY_FILE_KEY_GNOME_AUTOSTART_ENABLED);
		return result;
	}
	result = !startup_backend_key_file_keyfile_get_bool (self, G_KEY_FILE_DESKTOP_KEY_HIDDEN);
	return result;
}

void
startup_backend_key_file_set_active (StartupBackendKeyFile* self,
                                     gboolean value)
{
	GKeyFile* _tmp1_;
	g_return_if_fail (self != NULL);
	if (startup_backend_key_file_keyfile_has_key (self, STARTUP_BACKEND_KEY_FILE_KEY_GNOME_AUTOSTART_ENABLED)) {
		GKeyFile* _tmp0_;
		_tmp0_ = self->priv->keyfile;
		g_key_file_set_boolean (_tmp0_, G_KEY_FILE_DESKTOP_GROUP, STARTUP_BACKEND_KEY_FILE_KEY_GNOME_AUTOSTART_ENABLED, value);
		return;
	}
	_tmp1_ = self->priv->keyfile;
	g_key_file_set_boolean (_tmp1_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_HIDDEN, !value);
	g_object_notify_by_pspec ((GObject *) self, startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY]);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
startup_backend_key_file_get_show (StartupBackendKeyFile* self)
{
	gboolean result;
	gchar** current_desktop = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint current_desktop_length1;
	gint _current_desktop_size_;
	gchar** only_show_in = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint only_show_in_length1;
	gint _only_show_in_size_;
	gchar** not_show_in = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint not_show_in_length1;
	gint _not_show_in_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	if (startup_backend_key_file_keyfile_get_bool (self, G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ":", 0);
	current_desktop = _tmp2_;
	current_desktop_length1 = _vala_array_length (_tmp1_);
	_current_desktop_size_ = current_desktop_length1;
	_tmp3_ = startup_backend_key_file_keyfile_get_string (self, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	only_show_in = _tmp7_;
	only_show_in_length1 = _tmp7__length1;
	_only_show_in_size_ = only_show_in_length1;
	_tmp8_ = startup_backend_key_file_keyfile_get_string (self, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN);
	_tmp9_ = _tmp8_;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ":", 0);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	_g_free0 (_tmp9_);
	not_show_in = _tmp12_;
	not_show_in_length1 = _tmp12__length1;
	_not_show_in_size_ = not_show_in_length1;
	_tmp13_ = current_desktop;
	_tmp13__length1 = current_desktop_length1;
	{
		gchar** desktop_collection = NULL;
		gint desktop_collection_length1 = 0;
		gint _desktop_collection_size_ = 0;
		gint desktop_it = 0;
		desktop_collection = _tmp13_;
		desktop_collection_length1 = _tmp13__length1;
		for (desktop_it = 0; desktop_it < desktop_collection_length1; desktop_it = desktop_it + 1) {
			const gchar* desktop = NULL;
			desktop = desktop_collection[desktop_it];
			{
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				_tmp14_ = desktop;
				_tmp15_ = only_show_in;
				_tmp15__length1 = only_show_in_length1;
				if (_vala_string_array_contains (_tmp15_, _tmp15__length1, _tmp14_)) {
					result = TRUE;
					not_show_in = (_vala_array_free (not_show_in, not_show_in_length1, (GDestroyNotify) g_free), NULL);
					only_show_in = (_vala_array_free (only_show_in, only_show_in_length1, (GDestroyNotify) g_free), NULL);
					current_desktop = (_vala_array_free (current_desktop, current_desktop_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp16_ = desktop;
				_tmp17_ = not_show_in;
				_tmp17__length1 = not_show_in_length1;
				if (_vala_string_array_contains (_tmp17_, _tmp17__length1, _tmp16_)) {
					result = FALSE;
					not_show_in = (_vala_array_free (not_show_in, not_show_in_length1, (GDestroyNotify) g_free), NULL);
					only_show_in = (_vala_array_free (only_show_in, only_show_in_length1, (GDestroyNotify) g_free), NULL);
					current_desktop = (_vala_array_free (current_desktop, current_desktop_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	result = !startup_backend_key_file_keyfile_has_key (self, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN);
	not_show_in = (_vala_array_free (not_show_in, not_show_in_length1, (GDestroyNotify) g_free), NULL);
	only_show_in = (_vala_array_free (only_show_in, only_show_in_length1, (GDestroyNotify) g_free), NULL);
	current_desktop = (_vala_array_free (current_desktop, current_desktop_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

const gchar*
startup_backend_key_file_get_path (StartupBackendKeyFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}

void
startup_backend_key_file_set_path (StartupBackendKeyFile* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = startup_backend_key_file_get_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY]);
	}
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
startup_backend_key_file_class_init (StartupBackendKeyFileClass * klass,
                                     gpointer klass_data)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	startup_backend_key_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartupBackendKeyFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_startup_backend_key_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_startup_backend_key_file_set_property;
	G_OBJECT_CLASS (klass)->finalize = startup_backend_key_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY, startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STARTUP_BACKEND_KEY_FILE_SHOW_PROPERTY, startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_SHOW_PROPERTY] = g_param_spec_boolean ("show", "show", "show", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY, startup_backend_key_file_properties[STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup2 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	startup_backend_key_file_languages = (_vala_array_free (startup_backend_key_file_languages, startup_backend_key_file_languages_length1, (GDestroyNotify) g_free), NULL);
	startup_backend_key_file_languages = _tmp2_;
	startup_backend_key_file_languages_length1 = _tmp2__length1;
	_startup_backend_key_file_languages_size_ = startup_backend_key_file_languages_length1;
	_tmp3_ = startup_backend_key_file_languages;
	_tmp3__length1 = startup_backend_key_file_languages_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (startup_backend_key_file_preferred_language);
	startup_backend_key_file_preferred_language = _tmp5_;
}

static void
startup_backend_key_file_instance_init (StartupBackendKeyFile * self,
                                        gpointer klass)
{
	self->priv = startup_backend_key_file_get_instance_private (self);
}

static void
startup_backend_key_file_finalize (GObject * obj)
{
	StartupBackendKeyFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_BACKEND_TYPE_KEY_FILE, StartupBackendKeyFile);
	_g_free0 (self->priv->_path);
	_g_key_file_unref0 (self->priv->keyfile);
	G_OBJECT_CLASS (startup_backend_key_file_parent_class)->finalize (obj);
}

/**
 * Stores information about an app found in it's .desktop file
 * and allows us to modify it.
 * http://standards.freedesktop.org/desktop-entry-spec/latest/index.html
 */
static GType
startup_backend_key_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartupBackendKeyFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) startup_backend_key_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartupBackendKeyFile), 0, (GInstanceInitFunc) startup_backend_key_file_instance_init, NULL };
	GType startup_backend_key_file_type_id;
	startup_backend_key_file_type_id = g_type_register_static (G_TYPE_OBJECT, "StartupBackendKeyFile", &g_define_type_info, 0);
	StartupBackendKeyFile_private_offset = g_type_add_instance_private (startup_backend_key_file_type_id, sizeof (StartupBackendKeyFilePrivate));
	return startup_backend_key_file_type_id;
}

GType
startup_backend_key_file_get_type (void)
{
	static volatile gsize startup_backend_key_file_type_id__once = 0;
	if (g_once_init_enter (&startup_backend_key_file_type_id__once)) {
		GType startup_backend_key_file_type_id;
		startup_backend_key_file_type_id = startup_backend_key_file_get_type_once ();
		g_once_init_leave (&startup_backend_key_file_type_id__once, startup_backend_key_file_type_id);
	}
	return startup_backend_key_file_type_id__once;
}

static void
_vala_startup_backend_key_file_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	StartupBackendKeyFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STARTUP_BACKEND_TYPE_KEY_FILE, StartupBackendKeyFile);
	switch (property_id) {
		case STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY:
		g_value_set_boolean (value, startup_backend_key_file_get_active (self));
		break;
		case STARTUP_BACKEND_KEY_FILE_SHOW_PROPERTY:
		g_value_set_boolean (value, startup_backend_key_file_get_show (self));
		break;
		case STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY:
		g_value_set_string (value, startup_backend_key_file_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_startup_backend_key_file_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	StartupBackendKeyFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STARTUP_BACKEND_TYPE_KEY_FILE, StartupBackendKeyFile);
	switch (property_id) {
		case STARTUP_BACKEND_KEY_FILE_ACTIVE_PROPERTY:
		startup_backend_key_file_set_active (self, g_value_get_boolean (value));
		break;
		case STARTUP_BACKEND_KEY_FILE_PATH_PROPERTY:
		startup_backend_key_file_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

