/* FirmwareReleaseView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FirmwareReleaseView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Marius Meisenzahl <mariusmeisenzahl@gmail.com>
 */

#include "system.h"
#include <fwupd.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <appstream.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define ABOUT_GETTEXT_PACKAGE "io.elementary.settings.system"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_0_PROPERTY,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES
};
static GParamSpec* about_firmware_release_view_properties[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL,
	ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS
};
static guint about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_NUM_SIGNALS] = {0};

struct _AboutFirmwareReleaseViewPrivate {
	FwupdDevice* device;
	FwupdRelease* release;
	GranitePlaceholder* placeholder;
	GtkScrolledWindow* scrolled_window;
	GtkStack* stack;
	GtkRevealer* update_button_revealer;
	GtkButton* update_button;
	GtkLabel* title_label;
	GtkLabel* summary_label;
	GtkLabel* description_label;
	GtkLabel* version_value_label;
	GtkLabel* vendor_value_label;
	GtkLabel* size_value_label;
	GtkLabel* install_duration_value_label;
};

static gint AboutFirmwareReleaseView_private_offset;
static gpointer about_firmware_release_view_parent_class = NULL;

static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * about_firmware_release_view_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _about_firmware_release_view___lambda21_ (AboutFirmwareReleaseView* self);
static void __about_firmware_release_view___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void about_firmware_release_view_finalize (GObject * obj);
static GType about_firmware_release_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
about_firmware_release_view_get_instance_private (AboutFirmwareReleaseView* self)
{
	return G_STRUCT_MEMBER_P (self, AboutFirmwareReleaseView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
about_firmware_release_view_update_view (AboutFirmwareReleaseView* self,
                                         FwupdDevice* device,
                                         FwupdRelease* release)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	gchar* device_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkStack* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	gchar* release_version = NULL;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GtkLabel* _tmp34_;
	const gchar* _tmp35_;
	GtkLabel* _tmp43_;
	const gchar* _tmp44_;
	GtkLabel* _tmp45_;
	const gchar* _tmp46_;
	GtkLabel* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	guint32 duration_minutes = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->device);
	self->priv->device = _tmp0_;
	_tmp1_ = _g_object_ref0 (release);
	_g_object_unref0 (self->priv->release);
	self->priv->release = _tmp1_;
	_tmp2_ = fwupd_device_get_name (device);
	_tmp3_ = g_strdup (_tmp2_);
	device_name = _tmp3_;
	_tmp4_ = device_name;
	adw_navigation_page_set_title ((AdwNavigationPage*) self, _tmp4_);
	_tmp5_ = self->priv->update_button_revealer;
	gtk_revealer_set_reveal_child (_tmp5_, release != NULL);
	if (release == NULL) {
		GranitePlaceholder* _tmp6_;
		const gchar* _tmp7_;
		GPtrArray* icons = NULL;
		GPtrArray* _tmp8_;
		GPtrArray* _tmp9_;
		GPtrArray* _tmp10_;
		gpointer* _tmp11_;
		gint _tmp11__length1;
		GtkStack* _tmp21_;
		GranitePlaceholder* _tmp22_;
		_tmp6_ = self->priv->placeholder;
		_tmp7_ = device_name;
		granite_placeholder_set_title (_tmp6_, _tmp7_);
		_tmp8_ = fwupd_device_get_icons (device);
		_tmp9_ = _g_ptr_array_ref0 (_tmp8_);
		icons = _tmp9_;
		_tmp10_ = icons;
		_tmp11_ = _tmp10_->pdata;
		_tmp11__length1 = _tmp10_->len;
		if (_tmp11_ != NULL) {
			GranitePlaceholder* _tmp12_;
			GPtrArray* _tmp13_;
			gpointer* _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			GThemedIcon* _tmp16_;
			GThemedIcon* _tmp17_;
			_tmp12_ = self->priv->placeholder;
			_tmp13_ = icons;
			_tmp14_ = _tmp13_->pdata;
			_tmp14__length1 = _tmp13_->len;
			_tmp15_ = _tmp14_[0];
			_tmp16_ = (GThemedIcon*) g_themed_icon_new (_tmp15_);
			_tmp17_ = _tmp16_;
			granite_placeholder_set_icon (_tmp12_, (GIcon*) _tmp17_);
			_g_object_unref0 (_tmp17_);
		} else {
			GranitePlaceholder* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			_tmp18_ = self->priv->placeholder;
			_tmp19_ = (GThemedIcon*) g_themed_icon_new ("application-x-firmware");
			_tmp20_ = _tmp19_;
			granite_placeholder_set_icon (_tmp18_, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
		_tmp21_ = self->priv->stack;
		_tmp22_ = self->priv->placeholder;
		gtk_stack_set_visible_child (_tmp21_, (GtkWidget*) _tmp22_);
		_g_ptr_array_unref0 (icons);
		_g_free0 (device_name);
		return;
	}
	_tmp23_ = self->priv->stack;
	_tmp24_ = self->priv->scrolled_window;
	gtk_stack_set_visible_child (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = fwupd_release_get_version (release);
	_tmp26_ = g_strdup (_tmp25_);
	release_version = _tmp26_;
	if (fwupd_release_get_flags (release) == FWUPD_RELEASE_FLAG_IS_UPGRADE) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = release_version;
		_tmp29_ = fwupd_device_get_version (device);
		_tmp27_ = g_strcmp0 (_tmp28_, _tmp29_) != 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		GtkButton* _tmp30_;
		GtkButton* _tmp31_;
		_tmp30_ = self->priv->update_button;
		gtk_button_set_label (_tmp30_, _ ("Update"));
		_tmp31_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, TRUE);
	} else {
		GtkButton* _tmp32_;
		GtkButton* _tmp33_;
		_tmp32_ = self->priv->update_button;
		gtk_button_set_label (_tmp32_, _ ("Up to date"));
		_tmp33_ = self->priv->update_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, FALSE);
	}
	_tmp34_ = self->priv->summary_label;
	_tmp35_ = fwupd_release_get_summary (release);
	gtk_label_set_label (_tmp34_, _tmp35_);
	{
		gchar* _tmp36_ = NULL;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		GtkLabel* _tmp39_;
		_tmp37_ = fwupd_release_get_description (release);
		_tmp38_ = as_markup_convert (_tmp37_, AS_MARKUP_KIND_XML, &_inner_error0_);
		_tmp36_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp39_ = self->priv->description_label;
		gtk_label_set_label (_tmp39_, _tmp36_);
		_g_free0 (_tmp36_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = self->priv->description_label;
		gtk_label_set_label (_tmp40_, "");
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("FirmwareReleaseView.vala:212: Could not convert markup of release: %s", _tmp42_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (release_version);
		_g_free0 (device_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp43_ = self->priv->version_value_label;
	_tmp44_ = release_version;
	gtk_label_set_label (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->vendor_value_label;
	_tmp46_ = fwupd_release_get_vendor (release);
	gtk_label_set_label (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->size_value_label;
	_tmp48_ = g_format_size_full (fwupd_release_get_size (release), G_FORMAT_SIZE_DEFAULT);
	_tmp49_ = _tmp48_;
	gtk_label_set_label (_tmp47_, _tmp49_);
	_g_free0 (_tmp49_);
	duration_minutes = fwupd_release_get_install_duration (release) / 60;
	if (duration_minutes < ((guint32) 1)) {
		GtkLabel* _tmp50_;
		_tmp50_ = self->priv->install_duration_value_label;
		gtk_label_set_label (_tmp50_, _ ("less than a minute"));
	} else {
		GtkLabel* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp51_ = self->priv->install_duration_value_label;
		_tmp52_ = g_strdup_printf (g_dngettext (ABOUT_GETTEXT_PACKAGE, "%llu minute", "%llu minutes", (gulong) duration_minutes), duration_minutes);
		_tmp53_ = _tmp52_;
		gtk_label_set_label (_tmp51_, _tmp53_);
		_g_free0 (_tmp53_);
	}
	_g_free0 (release_version);
	_g_free0 (device_name);
}

AboutFirmwareReleaseView*
about_firmware_release_view_construct (GType object_type)
{
	AboutFirmwareReleaseView * self = NULL;
	self = (AboutFirmwareReleaseView*) g_object_new (object_type, NULL);
	return self;
}

AboutFirmwareReleaseView*
about_firmware_release_view_new (void)
{
	return about_firmware_release_view_construct (ABOUT_TYPE_FIRMWARE_RELEASE_VIEW);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_about_firmware_release_view___lambda21_ (AboutFirmwareReleaseView* self)
{
	FwupdDevice* _tmp0_;
	FwupdRelease* _tmp1_;
	gtk_widget_activate_action ((GtkWidget*) self, "navigation.pop", NULL, NULL);
	_tmp0_ = self->priv->device;
	_tmp1_ = self->priv->release;
	g_signal_emit (self, about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL], 0, _tmp0_, _tmp1_);
}

static void
__about_firmware_release_view___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_about_firmware_release_view___lambda21_ ((AboutFirmwareReleaseView*) self);
}

static GObject *
about_firmware_release_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutFirmwareReleaseView * self;
	GtkButton* back_button = NULL;
	gchar* _tmp0_;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkWidget* _tmp8_;
	GtkRevealer* _tmp9_ = NULL;
	GtkHeaderBar* header_bar = NULL;
	GtkLabel* _tmp10_;
	GtkWidget* _tmp11_;
	GtkHeaderBar* _tmp12_ = NULL;
	GtkHeaderBar* _tmp13_;
	GtkButton* _tmp14_;
	GtkHeaderBar* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* version_label = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* vendor_label = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* size_label = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* install_duration_label = NULL;
	GtkLabel* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkGrid* key_val_grid = NULL;
	GtkGrid* _tmp28_ = NULL;
	GtkGrid* _tmp29_;
	GtkGrid* _tmp30_;
	GtkLabel* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkLabel* _tmp41_;
	GtkGrid* _tmp42_;
	GtkLabel* _tmp43_;
	GtkGrid* _tmp44_;
	GtkLabel* _tmp45_;
	gchar* _tmp46_;
	GranitePlaceholder* _tmp47_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp48_ = NULL;
	GtkBox* _tmp49_;
	GtkLabel* _tmp50_;
	GtkBox* _tmp51_;
	GtkLabel* _tmp52_;
	GtkBox* _tmp53_;
	GtkGrid* _tmp54_;
	GtkBox* _tmp55_;
	GtkWidget* _tmp56_;
	GtkScrolledWindow* _tmp57_ = NULL;
	GtkStack* _tmp58_;
	GtkStack* _tmp59_;
	GranitePlaceholder* _tmp60_;
	GtkStack* _tmp61_;
	GtkScrolledWindow* _tmp62_;
	AdwToolbarView* toolbarview = NULL;
	GtkStack* _tmp63_;
	GtkWidget* _tmp64_;
	AdwToolbarView* _tmp65_ = NULL;
	AdwToolbarView* _tmp66_;
	GtkHeaderBar* _tmp67_;
	AdwToolbarView* _tmp68_;
	GtkButton* _tmp69_;
	GtkLabel* _tmp70_;
	parent_class = G_OBJECT_CLASS (about_firmware_release_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_tmp0_ = g_strdup ("navigation.pop");
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("All Updates"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp1_);
	back_button = _tmp1_;
	_tmp2_ = back_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_BACK_BUTTON);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp3_;
	_tmp4_ = self->priv->title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "title");
	_tmp5_ = (GtkButton*) gtk_button_new_with_label ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_END);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->update_button);
	self->priv->update_button = _tmp5_;
	_tmp6_ = self->priv->update_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = self->priv->update_button;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->update_button_revealer);
	self->priv->update_button_revealer = _tmp9_;
	_tmp10_ = self->priv->title_label;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	gtk_header_bar_set_show_title_buttons (_tmp12_, FALSE);
	gtk_header_bar_set_title_widget (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	header_bar = _tmp12_;
	_tmp13_ = header_bar;
	_tmp14_ = back_button;
	gtk_header_bar_pack_start (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = header_bar;
	_tmp16_ = self->priv->update_button_revealer;
	gtk_header_bar_pack_end (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_label_set_wrap (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->summary_label);
	self->priv->summary_label = _tmp17_;
	_tmp18_ = self->priv->summary_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp19_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	gtk_label_set_wrap (_tmp19_, TRUE);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->description_label);
	self->priv->description_label = _tmp19_;
	_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Version:"));
	gtk_label_set_xalign (_tmp20_, (gfloat) 1);
	g_object_ref_sink (_tmp20_);
	version_label = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp21_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->version_value_label);
	self->priv->version_value_label = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_ ("Vendor:"));
	gtk_label_set_xalign (_tmp22_, (gfloat) 1);
	g_object_ref_sink (_tmp22_);
	vendor_label = _tmp22_;
	_tmp23_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp23_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->vendor_value_label);
	self->priv->vendor_value_label = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new (_ ("Size:"));
	gtk_label_set_xalign (_tmp24_, (gfloat) 1);
	g_object_ref_sink (_tmp24_);
	size_label = _tmp24_;
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp25_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->size_value_label);
	self->priv->size_value_label = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Estimated time to install:"));
	gtk_label_set_xalign (_tmp26_, (gfloat) 1);
	g_object_ref_sink (_tmp26_);
	install_duration_label = _tmp26_;
	_tmp27_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp27_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->install_duration_value_label);
	self->priv->install_duration_value_label = _tmp27_;
	_tmp28_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_homogeneous (_tmp28_, TRUE);
	gtk_grid_set_column_spacing (_tmp28_, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 12);
	gtk_grid_set_row_spacing (_tmp28_, 3);
	g_object_ref_sink (_tmp28_);
	key_val_grid = _tmp28_;
	_tmp29_ = key_val_grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp30_ = key_val_grid;
	_tmp31_ = version_label;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 0, 0, 1, 1);
	_tmp32_ = key_val_grid;
	_tmp33_ = self->priv->version_value_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 1, 0, 1, 1);
	_tmp34_ = key_val_grid;
	_tmp35_ = vendor_label;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 1, 1, 1);
	_tmp36_ = key_val_grid;
	_tmp37_ = self->priv->vendor_value_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
	_tmp38_ = key_val_grid;
	_tmp39_ = size_label;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 0, 2, 1, 1);
	_tmp40_ = key_val_grid;
	_tmp41_ = self->priv->size_value_label;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 1, 2, 1, 1);
	_tmp42_ = key_val_grid;
	_tmp43_ = install_duration_label;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 0, 3, 1, 1);
	_tmp44_ = key_val_grid;
	_tmp45_ = self->priv->install_duration_value_label;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 1, 3, 1, 1);
	_tmp46_ = g_strdup (_ ("There are no releases available for this device."));
	_tmp47_ = granite_placeholder_new ("");
	granite_placeholder_set_description (_tmp47_, _tmp46_);
	_g_free0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp47_;
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	gtk_widget_set_halign ((GtkWidget*) _tmp48_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp48_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp48_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp48_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp48_, 12);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp48_, TRUE);
	g_object_ref_sink (_tmp48_);
	box = _tmp48_;
	_tmp49_ = box;
	_tmp50_ = self->priv->summary_label;
	gtk_box_append (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = box;
	_tmp52_ = self->priv->description_label;
	gtk_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = box;
	_tmp54_ = key_val_grid;
	gtk_box_append (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = box;
	_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
	_tmp57_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp57_, _tmp56_);
	_g_object_unref0 (_tmp56_);
	g_object_set (_tmp57_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp57_, TRUE);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp57_;
	_tmp58_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp58_;
	_tmp59_ = self->priv->stack;
	_tmp60_ = self->priv->placeholder;
	gtk_stack_add_child (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->stack;
	_tmp62_ = self->priv->scrolled_window;
	gtk_stack_add_child (_tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = self->priv->stack;
	_tmp64_ = _g_object_ref0 ((GtkWidget*) _tmp63_);
	_tmp65_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp65_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	adw_toolbar_view_set_top_bar_style (_tmp65_, ADW_TOOLBAR_RAISED_BORDER);
	g_object_ref_sink (_tmp65_);
	toolbarview = _tmp65_;
	_tmp66_ = toolbarview;
	_tmp67_ = header_bar;
	adw_toolbar_view_add_top_bar (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = toolbarview;
	adw_navigation_page_set_child ((AdwNavigationPage*) self, (GtkWidget*) _tmp68_);
	_tmp69_ = self->priv->update_button;
	g_signal_connect_object (_tmp69_, "clicked", (GCallback) __about_firmware_release_view___lambda21__gtk_button_clicked, self, 0);
	_tmp70_ = self->priv->title_label;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp70_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (toolbarview);
	_g_object_unref0 (box);
	_g_object_unref0 (key_val_grid);
	_g_object_unref0 (install_duration_label);
	_g_object_unref0 (size_label);
	_g_object_unref0 (vendor_label);
	_g_object_unref0 (version_label);
	_g_object_unref0 (header_bar);
	_g_object_unref0 (back_button);
	return obj;
}

static void
about_firmware_release_view_class_init (AboutFirmwareReleaseViewClass * klass,
                                        gpointer klass_data)
{
	about_firmware_release_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutFirmwareReleaseView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = about_firmware_release_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_firmware_release_view_finalize;
	about_firmware_release_view_signals[ABOUT_FIRMWARE_RELEASE_VIEW_UPDATE_SIGNAL] = g_signal_new ("update", ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, fwupd_device_get_type (), fwupd_release_get_type ());
}

static void
about_firmware_release_view_instance_init (AboutFirmwareReleaseView * self,
                                           gpointer klass)
{
	self->priv = about_firmware_release_view_get_instance_private (self);
}

static void
about_firmware_release_view_finalize (GObject * obj)
{
	AboutFirmwareReleaseView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_FIRMWARE_RELEASE_VIEW, AboutFirmwareReleaseView);
	_g_object_unref0 (self->priv->device);
	_g_object_unref0 (self->priv->release);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->update_button_revealer);
	_g_object_unref0 (self->priv->update_button);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->summary_label);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->version_value_label);
	_g_object_unref0 (self->priv->vendor_value_label);
	_g_object_unref0 (self->priv->size_value_label);
	_g_object_unref0 (self->priv->install_duration_value_label);
	G_OBJECT_CLASS (about_firmware_release_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_firmware_release_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutFirmwareReleaseViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_firmware_release_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutFirmwareReleaseView), 0, (GInstanceInitFunc) about_firmware_release_view_instance_init, NULL };
	GType about_firmware_release_view_type_id;
	about_firmware_release_view_type_id = g_type_register_static (adw_navigation_page_get_type (), "AboutFirmwareReleaseView", &g_define_type_info, 0);
	AboutFirmwareReleaseView_private_offset = g_type_add_instance_private (about_firmware_release_view_type_id, sizeof (AboutFirmwareReleaseViewPrivate));
	return about_firmware_release_view_type_id;
}

GType
about_firmware_release_view_get_type (void)
{
	static volatile gsize about_firmware_release_view_type_id__once = 0;
	if (g_once_init_enter (&about_firmware_release_view_type_id__once)) {
		GType about_firmware_release_view_type_id;
		about_firmware_release_view_type_id = about_firmware_release_view_get_type_once ();
		g_once_init_leave (&about_firmware_release_view_type_id__once, about_firmware_release_view_type_id);
	}
	return about_firmware_release_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

