/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkPatchBasedDenoisingImageFilter.h"
#include "itkPatchBasedDenoisingImageFilter.h"

// Additional include files
#include "itkGaussianRandomSpatialNeighborSubsampler.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
PatchBasedDenoisingImageFilter::PatchBasedDenoisingImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
PatchBasedDenoisingImageFilter::~PatchBasedDenoisingImageFilter() = default;



//
// ToString
//
std::string PatchBasedDenoisingImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::PatchBasedDenoisingImageFilter\n";
  out << "  KernelBandwidthSigma: ";
  this->ToStringHelper(out, this->m_KernelBandwidthSigma);
  out << std::endl;
  out << "  PatchRadius: ";
  this->ToStringHelper(out, this->m_PatchRadius);
  out << std::endl;
  out << "  NumberOfIterations: ";
  this->ToStringHelper(out, this->m_NumberOfIterations);
  out << std::endl;
  out << "  NumberOfSamplePatches: ";
  this->ToStringHelper(out, this->m_NumberOfSamplePatches);
  out << std::endl;
  out << "  SampleVariance: ";
  this->ToStringHelper(out, this->m_SampleVariance);
  out << std::endl;
  out << "  NoiseModel: ";
  this->ToStringHelper(out, this->m_NoiseModel);
  out << std::endl;
  out << "  NoiseSigma: ";
  this->ToStringHelper(out, this->m_NoiseSigma);
  out << std::endl;
  out << "  NoiseModelFidelityWeight: ";
  this->ToStringHelper(out, this->m_NoiseModelFidelityWeight);
  out << std::endl;
  out << "  AlwaysTreatComponentsAsEuclidean: ";
  this->ToStringHelper(out, this->m_AlwaysTreatComponentsAsEuclidean);
  out << std::endl;
  out << "  KernelBandwidthEstimation: ";
  this->ToStringHelper(out, this->m_KernelBandwidthEstimation);
  out << std::endl;
  out << "  KernelBandwidthMultiplicationFactor: ";
  this->ToStringHelper(out, this->m_KernelBandwidthMultiplicationFactor);
  out << std::endl;
  out << "  KernelBandwidthUpdateFrequency: ";
  this->ToStringHelper(out, this->m_KernelBandwidthUpdateFrequency);
  out << std::endl;
  out << "  KernelBandwidthFractionPixelsForEstimation: ";
  this->ToStringHelper(out, this->m_KernelBandwidthFractionPixelsForEstimation);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image PatchBasedDenoisingImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image PatchBasedDenoisingImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::PatchBasedDenoisingImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( image1 );
  using SamplerType = itk::Statistics::GaussianRandomSpatialNeighborSubsampler< typename FilterType::PatchSampleType, typename InputImageType::RegionType>;
  typename SamplerType::Pointer sampler = SamplerType::New();
  sampler->SetVariance(m_SampleVariance);
  sampler->SetRadius(itk::Math::Floor<unsigned int>(std::sqrt(m_SampleVariance)*2.5));
  sampler->SetNumberOfResultsRequested(m_NumberOfSamplePatches);
  filter->SetSampler(sampler);


  typename FilterType::RealArrayType a(image1->GetNumberOfComponentsPerPixel());
  a.Fill(m_KernelBandwidthSigma);
  filter->SetKernelBandwidthSigma(a);
  filter->SetPatchRadius ( this->m_PatchRadius );
  filter->SetNumberOfIterations ( this->m_NumberOfIterations );
  
  
  filter->SetNoiseModel ( typename FilterType::NoiseModelEnum ( int( this->m_NoiseModel ) ) );
  if (this->m_NoiseSigma != 0.0) filter->SetNoiseSigma(this->m_NoiseSigma);
  filter->SetNoiseModelFidelityWeight ( this->m_NoiseModelFidelityWeight );
  filter->SetAlwaysTreatComponentsAsEuclidean ( this->m_AlwaysTreatComponentsAsEuclidean );
  filter->SetKernelBandwidthEstimation ( this->m_KernelBandwidthEstimation );
  filter->SetKernelBandwidthMultiplicationFactor ( this->m_KernelBandwidthMultiplicationFactor );
  filter->SetKernelBandwidthUpdateFrequency ( this->m_KernelBandwidthUpdateFrequency );
  filter->SetKernelBandwidthFractionPixelsForEstimation ( this->m_KernelBandwidthFractionPixelsForEstimation );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------




}
