/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkNormalizedCorrelationImageFilter.h"
#include "itkNormalizedCorrelationImageFilter.h"

// Additional include files
#include "sitkImageToKernel.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
NormalizedCorrelationImageFilter::NormalizedCorrelationImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
NormalizedCorrelationImageFilter::~NormalizedCorrelationImageFilter() = default;



//
// ToString
//
std::string NormalizedCorrelationImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::NormalizedCorrelationImageFilter\n";

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image NormalizedCorrelationImageFilter::Execute ( const Image & image, const Image & maskImage, const Image & templateImage )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, maskImage, "maskImage" );
  CheckImageMatchingSize(  image, maskImage, "maskImage" );
  CheckImageMatchingDimension(  image, templateImage, "templateImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, &maskImage, &templateImage );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image NormalizedCorrelationImageFilter::ExecuteInternal ( const Image * inImage, const Image * inMaskImage, const Image * inTemplateImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< typename itk::NumericTraits<typename InputImageType::PixelType>::RealType, InputImageType::ImageDimension >;



  using FilterType = itk::NormalizedCorrelationImageFilter<InputImageType, InputImageType, OutputImageType, typename InputImageType::PixelType >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inMaskImage != nullptr );
  typename FilterType::MaskImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::MaskImageType>( *inMaskImage );
  filter->SetMaskImage( image2 );
  assert( inTemplateImage != nullptr );
  filter->SetTemplate( *CreateOperatorFromImage( this->CastImageToITK<typename FilterType::InputImageType>(*inTemplateImage).GetPointer() ).get() );






  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image NormalizedCorrelation ( const Image & image, const Image & maskImage, const Image & templateImage )
{
  NormalizedCorrelationImageFilter filter;

  return filter.Execute ( image, maskImage, templateImage );
}


}
