/* Face.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Face.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define FACE_TYPENAME "face"
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;
typedef struct _ContainerSourceCollectionPrivate ContainerSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_FACE_SOURCE_COLLECTION (face_source_collection_get_type ())
#define FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection))
#define FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))
#define IS_FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_SOURCE_COLLECTION))
#define IS_FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_SOURCE_COLLECTION))
#define FACE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))

typedef struct _FaceSourceCollection FaceSourceCollection;
typedef struct _FaceSourceCollectionClass FaceSourceCollectionClass;
typedef struct _FaceSourceCollectionPrivate FaceSourceCollectionPrivate;

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_FACE_ID (face_id_get_type ())
typedef struct _FaceID FaceID;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DataObjectPrivate DataObjectPrivate;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_PROXYABLE (proxyable_get_type ())
#define PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROXYABLE, Proxyable))
#define IS_PROXYABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROXYABLE))
#define PROXYABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROXYABLE, ProxyableIface))

typedef struct _Proxyable Proxyable;
typedef struct _ProxyableIface ProxyableIface;

#define TYPE_SOURCE_PROXY (source_proxy_get_type ())
#define SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_PROXY, SourceProxy))
#define SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_PROXY, SourceProxyClass))
#define IS_SOURCE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_PROXY))
#define IS_SOURCE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_PROXY))
#define SOURCE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_PROXY, SourceProxyClass))

typedef struct _SourceProxy SourceProxy;
typedef struct _SourceProxyClass SourceProxyClass;

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;
typedef struct _FacePrivate FacePrivate;

#define TYPE_FACE_ROW (face_row_get_type ())
#define FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_ROW, FaceRow))
#define FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_ROW, FaceRowClass))
#define IS_FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_ROW))
#define IS_FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_ROW))
#define FACE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_ROW, FaceRowClass))

typedef struct _FaceRow FaceRow;
typedef struct _FaceRowClass FaceRowClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;
enum  {
	FACE_0_PROPERTY,
	FACE_NUM_PROPERTIES
};
static GParamSpec* face_properties[FACE_NUM_PROPERTIES];

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
#define _face_row_unref0(var) ((var == NULL) ? NULL : (var = (face_row_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _FaceRowPrivate FaceRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
#define _photo_id_free0(var) ((var == NULL) ? NULL : (var = (photo_id_free (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_FACE_TABLE (face_table_get_type ())
#define FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_TABLE, FaceTable))
#define FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_TABLE, FaceTableClass))
#define IS_FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_TABLE))
#define IS_FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_TABLE))
#define FACE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_TABLE, FaceTableClass))

typedef struct _FaceTable FaceTable;
typedef struct _FaceTableClass FaceTableClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FACE_DETECT_INTERFACE (face_detect_interface_get_type ())
#define FACE_DETECT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_DETECT_INTERFACE, FaceDetectInterface))
#define IS_FACE_DETECT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_DETECT_INTERFACE))
#define FACE_DETECT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FACE_DETECT_INTERFACE, FaceDetectInterfaceIface))

typedef struct _FaceDetectInterface FaceDetectInterface;
typedef struct _FaceDetectInterfaceIface FaceDetectInterfaceIface;

#define TYPE_FACE_DETECT_INTERFACE_PROXY (face_detect_interface_proxy_get_type ())

#define TYPE_FACE_RECT (face_rect_get_type ())
typedef struct _FaceRect FaceRect;
typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())

#define FACE_TYPE_FACE_SNAPSHOT (face_face_snapshot_get_type ())
#define FACE_FACE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshot))
#define FACE_FACE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshotClass))
#define FACE_IS_FACE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FACE_TYPE_FACE_SNAPSHOT))
#define FACE_IS_FACE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FACE_TYPE_FACE_SNAPSHOT))
#define FACE_FACE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshotClass))

typedef struct _FaceFaceSnapshot FaceFaceSnapshot;
typedef struct _FaceFaceSnapshotClass FaceFaceSnapshotClass;

#define FACE_TYPE_FACE_PROXY (face_face_proxy_get_type ())
#define FACE_FACE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FACE_TYPE_FACE_PROXY, FaceFaceProxy))
#define FACE_FACE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FACE_TYPE_FACE_PROXY, FaceFaceProxyClass))
#define FACE_IS_FACE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FACE_TYPE_FACE_PROXY))
#define FACE_IS_FACE_PROXY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FACE_TYPE_FACE_PROXY))
#define FACE_FACE_PROXY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FACE_TYPE_FACE_PROXY, FaceFaceProxyClass))

typedef struct _FaceFaceProxy FaceFaceProxy;
typedef struct _FaceFaceProxyClass FaceFaceProxyClass;
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_FACE_LOCATION (face_location_get_type ())
#define FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION, FaceLocation))
#define FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION, FaceLocationClass))
#define IS_FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION))
#define IS_FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION))
#define FACE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION, FaceLocationClass))

typedef struct _FaceLocation FaceLocation;
typedef struct _FaceLocationClass FaceLocationClass;
typedef DataView* (*CreateView) (DataSource* source, gpointer user_data);
typedef gboolean (*CreateViewPredicate) (DataSource* source, gpointer user_data);
typedef struct _SourceSnapshotPrivate SourceSnapshotPrivate;
typedef struct _FaceFaceSnapshotPrivate FaceFaceSnapshotPrivate;
typedef struct _SourceProxyPrivate SourceProxyPrivate;
typedef struct _FaceFaceProxyPrivate FaceFaceProxyPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

struct _ContainerSourceCollection {
	DatabaseSourceCollection parent_instance;
	ContainerSourceCollectionPrivate * priv;
};

struct _ContainerSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	void (*notify_container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*notify_container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*notify_container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*notify_backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
	GeeCollection* (*get_containers_holding_source) (ContainerSourceCollection* self, DataSource* source);
	ContainerSource* (*convert_backlink_to_container) (ContainerSourceCollection* self, SourceBacklink* backlink);
	void (*container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
};

struct _FaceSourceCollection {
	ContainerSourceCollection parent_instance;
	FaceSourceCollectionPrivate * priv;
};

struct _FaceSourceCollectionClass {
	ContainerSourceCollectionClass parent_class;
};

struct _FaceSourceCollectionPrivate {
	GeeHashMap* name_map;
	GeeHashMap* source_map;
};

struct _FaceID {
	gint64 id;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ProxyableIface {
	GTypeInterface parent_iface;
	SourceProxy* (*get_proxy) (Proxyable* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _Face {
	DataSource parent_instance;
	FacePrivate * priv;
};

struct _FaceClass {
	DataSourceClass parent_class;
};

struct _FacePrivate {
	FaceRow* row;
	ViewCollection* media_views;
	gchar* name_collation_key;
	gboolean unlinking;
	gboolean relinking;
	gchar* indexable_keywords;
};

struct _PhotoID {
	gint64 id;
};

struct _FaceRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceRowPrivate * priv;
	FaceID face_id;
	gchar* name;
	gint64 time_created;
	PhotoID ref;
	gchar* vec;
};

struct _FaceRowClass {
	GTypeClass parent_class;
	void (*finalize) (FaceRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _FaceRect {
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
	gdouble* vec;
	gint vec_length1;
};

struct _FaceDetectInterfaceIface {
	GTypeInterface parent_iface;
	FaceRect* (*detect_faces) (FaceDetectInterface* self, const gchar* inputName, const gchar* cascadeName, gdouble scale, gboolean infer, gint* result_length1, GError** error);
	gboolean (*load_net) (FaceDetectInterface* self, const gchar* netFile, GError** error);
	void (*terminate) (FaceDetectInterface* self, GError** error);
};

struct _SourceSnapshot {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceSnapshotPrivate * priv;
};

struct _SourceSnapshotClass {
	GTypeClass parent_class;
	void (*finalize) (SourceSnapshot *self);
	void (*notify_broken) (SourceSnapshot* self);
	void (*broken) (SourceSnapshot* self);
};

struct _FaceFaceSnapshot {
	SourceSnapshot parent_instance;
	FaceFaceSnapshotPrivate * priv;
};

struct _FaceFaceSnapshotClass {
	SourceSnapshotClass parent_class;
};

struct _FaceFaceSnapshotPrivate {
	FaceRow* row;
	GeeHashSet* sources;
};

struct _SourceProxy {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceProxyPrivate * priv;
};

struct _SourceProxyClass {
	GTypeClass parent_class;
	void (*finalize) (SourceProxy *self);
	DataSource* (*reconstitute) (SourceProxy* self, gint64 object_id, SourceSnapshot* snapshot);
	void (*notify_reconstituted) (SourceProxy* self, DataSource* source);
	void (*notify_dehydrated) (SourceProxy* self);
	void (*notify_broken) (SourceProxy* self);
	void (*reconstituted) (SourceProxy* self, DataSource* source);
	void (*dehydrated) (SourceProxy* self);
	void (*broken) (SourceProxy* self);
};

struct _FaceFaceProxy {
	SourceProxy parent_instance;
	FaceFaceProxyPrivate * priv;
};

struct _FaceFaceProxyClass {
	SourceProxyClass parent_class;
};

static gint FaceSourceCollection_private_offset;
static gpointer face_source_collection_parent_class = NULL;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
static gint Face_private_offset;
static gpointer face_parent_class = NULL;
VALA_EXTERN FaceSourceCollection* face_global;
FaceSourceCollection* face_global = NULL;
VALA_EXTERN FaceDetectInterface* face_detect_face_detect_proxy;
static gint FaceFaceSnapshot_private_offset;
static gpointer face_face_snapshot_parent_class = NULL;
static gpointer face_face_proxy_parent_class = NULL;
static ContainerSourceIface * face_container_source_parent_iface = NULL;
static ProxyableIface * face_proxyable_parent_iface = NULL;
static IndexableIface * face_indexable_parent_iface = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSource, g_object_unref)
VALA_EXTERN GType face_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceSourceCollection, data_collection_unref)
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
VALA_EXTERN GeeCollection* container_source_collection_get_containers_holding_source (ContainerSourceCollection* self,
                                                                          DataSource* source);
VALA_EXTERN ContainerSource* container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                            SourceBacklink* backlink);
VALA_EXTERN void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
VALA_EXTERN void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
VALA_EXTERN void data_collection_notify_items_altered (DataCollection* self,
                                           GeeMap* items);
VALA_EXTERN void container_source_collection_notify_container_contents_added (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked);
VALA_EXTERN void container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
VALA_EXTERN guint face_hash_name_string (void* a);
VALA_EXTERN gboolean face_equal_name_strings (void* a,
                                  void* b);
VALA_EXTERN FaceSourceCollection* face_source_collection_new (void);
VALA_EXTERN FaceSourceCollection* face_source_collection_construct (GType object_type);
static gint64 face_source_collection_get_face_key (DataSource* source);
static gint64 _face_source_collection_get_face_key_get_source_database_key (DataSource* source,
                                                                     gpointer self);
VALA_EXTERN ContainerSourceCollection* container_source_collection_construct (GType object_type,
                                                                  const gchar* backlink_name,
                                                                  const gchar* name,
                                                                  GetSourceDatabaseKey source_key_func,
                                                                  gpointer source_key_func_target);
VALA_EXTERN void container_source_collection_attach_collection (ContainerSourceCollection* self,
                                                    SourceCollection* collection);
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
static gboolean face_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                           DataSource* source);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
static GeeCollection* face_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                                          DataSource* source);
VALA_EXTERN GeeList* face_source_collection_fetch_for_source (FaceSourceCollection* self,
                                                  MediaSource* source);
static ContainerSource* face_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                                            SourceBacklink* backlink);
VALA_EXTERN GType face_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceID* face_id_dup (const FaceID* self);
VALA_EXTERN void face_id_free (FaceID* self);
VALA_EXTERN gint64 source_backlink_get_instance_id (SourceBacklink* self);
VALA_EXTERN void face_id_init (FaceID *self,
                   gint64 id);
VALA_EXTERN Face* face_source_collection_fetch (FaceSourceCollection* self,
                                    FaceID* face_id);
VALA_EXTERN GeeCollection* container_source_collection_get_holding_tank (ContainerSourceCollection* self);
VALA_EXTERN void face_get_face_id (Face* self,
                       FaceID* result);
VALA_EXTERN DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
VALA_EXTERN gboolean face_source_collection_exists (FaceSourceCollection* self,
                                        const gchar* name);
VALA_EXTERN GeeCollection* face_source_collection_get_all_names (FaceSourceCollection* self);
VALA_EXTERN Face* face_source_collection_fetch_by_name (FaceSourceCollection* self,
                                            const gchar* name);
VALA_EXTERN Face* face_source_collection_restore_face_from_holding_tank (FaceSourceCollection* self,
                                                             const gchar* name);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gboolean container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self,
                                                               ContainerSource* source);
static void face_source_collection_real_notify_items_added (DataCollection* base,
                                                     GeeIterable* added);
static void face_source_collection_real_notify_items_removed (DataCollection* base,
                                                       GeeIterable* removed);
static void face_source_collection_real_notify_items_altered (DataCollection* base,
                                                       GeeMap* map);
VALA_EXTERN gboolean data_source_equals (DataSource* self,
                             DataSource* source);
static void face_source_collection_real_notify_container_contents_added (ContainerSourceCollection* base,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinking);
static void face_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* base,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinking);
static void face_source_collection_finalize (DataCollection * obj);
static GType face_source_collection_get_type_once (void);
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN gpointer source_proxy_ref (gpointer instance);
VALA_EXTERN void source_proxy_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_proxy (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_source_proxy (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_source_proxy (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_source_proxy (const GValue* value);
VALA_EXTERN GType source_proxy_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceProxy, source_proxy_unref)
VALA_EXTERN GType proxyable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Proxyable, g_object_unref)
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN gpointer face_row_ref (gpointer instance);
VALA_EXTERN void face_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_row (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_face_row (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_face_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_face_row (const GValue* value);
VALA_EXTERN GType face_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceRow, face_row_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN gchar* data_source_get_typename (DataSource* self);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN SourceSnapshot* data_source_save_snapshot (DataSource* self);
VALA_EXTERN void data_source_destroy (DataSource* self);
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
static void face_on_media_views_contents_altered (Face* self,
                                           GeeIterable* added,
                                           GeeIterable* removed);
static void _face_on_media_views_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                             GeeIterable* added,
                                                                             GeeIterable* removed,
                                                                             gpointer self);
static void face_on_sources_destroyed (Face* self,
                                GeeCollection* sources);
static void _face_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                   GeeCollection* destroyed,
                                                                   gpointer self);
static Face* face_new (FaceRow* row,
                gint64 object_id);
static Face* face_construct (GType object_type,
                      FaceRow* row,
                      gint64 object_id);
VALA_EXTERN DataSource* data_source_construct (GType object_type,
                                   gint64 object_id);
VALA_EXTERN gchar* face_prep_face_name (const gchar* name);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN GeeSet* face_location_get_photo_ids_by_face (Face* face);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN MediaSource* media_source_collection_fetch_by_source_id (MediaSourceCollection* self,
                                                         const gchar* source_id);
VALA_EXTERN gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
VALA_EXTERN ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
VALA_EXTERN ThumbnailView* thumbnail_view_construct (GType object_type,
                                         ThumbnailSource* source);
VALA_EXTERN ViewCollection* view_collection_new (const gchar* name);
VALA_EXTERN ViewCollection* view_collection_construct (GType object_type,
                                           const gchar* name);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
VALA_EXTERN void container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* added,
                                                                    gboolean relinked,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
static void face_update_indexable_keywords (Face* self);
VALA_EXTERN void face_init (ProgressMonitor monitor,
                gpointer monitor_target);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType face_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceTable, database_table_unref)
VALA_EXTERN FaceTable* face_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeList* face_table_get_all_rows (FaceTable* self,
                                  GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void face_table_remove (FaceTable* self,
                        FaceID* face_id,
                        GError** error);
VALA_EXTERN gint face_get_sources_count (Face* self);
VALA_EXTERN gboolean container_source_has_links (ContainerSource* self);
VALA_EXTERN void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
VALA_EXTERN gboolean data_source_destroy_orphan (DataSource* self,
                                     gboolean delete_backing);
VALA_EXTERN void container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self,
                                                         GeeCollection* unlinked);
VALA_EXTERN void face_terminate (void);
VALA_EXTERN GType face_detect_interface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint face_detect_interface_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType face_rect_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceRect* face_rect_dup (const FaceRect* self);
VALA_EXTERN void face_rect_free (FaceRect* self);
VALA_EXTERN void face_rect_copy (const FaceRect* self,
                     FaceRect* dest);
VALA_EXTERN void face_rect_destroy (FaceRect* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FaceRect, face_rect_destroy)
VALA_EXTERN GType face_detect_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceDetectInterface, g_object_unref)
VALA_EXTERN void face_detect_interface_terminate (FaceDetectInterface* self,
                                      GError** error);
VALA_EXTERN gint face_compare_names (void* a,
                         void* b);
VALA_EXTERN gint string_precollated_compare (const gchar* astr,
                                 const gchar* akey,
                                 const gchar* bstr,
                                 const gchar* bkey);
VALA_EXTERN gchar* face_get_name_collation_key (Face* self);
VALA_EXTERN guint string_collated_hash (void* ptr);
VALA_EXTERN gboolean string_collated_equals (void* a,
                                 void* b);
VALA_EXTERN Face* face_for_name (const gchar* name);
VALA_EXTERN FaceRow* face_table_add (FaceTable* self,
                         const gchar* name,
                         GError** error);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GType prepare_input_text_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* prepare_input_text (const gchar* text,
                           PrepareInputTextOptions options,
                           gint dest_length);
static gchar* face_real_get_typename (DataSource* base);
static gint64 face_real_get_instance_id (DataSource* base);
static gchar* face_real_get_name (DataObject* base);
static gchar* face_real_to_string (DataObject* base);
VALA_EXTERN gint data_collection_get_count (DataCollection* self);
static gboolean face_real_equals (DataSource* base,
                           DataSource* source);
static SourceSnapshot* face_real_save_snapshot (DataSource* base);
static FaceFaceSnapshot* face_face_snapshot_new (Face* face);
static FaceFaceSnapshot* face_face_snapshot_construct (GType object_type,
                                                Face* face);
static GType face_face_snapshot_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceFaceSnapshot, source_snapshot_unref)
static SourceProxy* face_real_get_proxy (Proxyable* base);
static FaceFaceProxy* face_face_proxy_new (Face* face);
static FaceFaceProxy* face_face_proxy_construct (GType object_type,
                                          Face* face);
static GType face_face_proxy_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceFaceProxy, source_proxy_unref)
static Face* face_reconstitute (gint64 object_id,
                         FaceRow* row);
VALA_EXTERN void face_table_create_from_row (FaceTable* self,
                                 FaceRow* row,
                                 FaceID* result,
                                 GError** error);
static gboolean face_real_has_links (ContainerSource* base);
VALA_EXTERN gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
VALA_EXTERN SourceBacklink* container_source_get_backlink (ContainerSource* self);
static SourceBacklink* face_real_get_backlink (ContainerSource* base);
VALA_EXTERN SourceBacklink* source_backlink_new_from_source (DataSource* source);
VALA_EXTERN SourceBacklink* source_backlink_construct_from_source (GType object_type,
                                                       DataSource* source);
static void face_real_break_link (ContainerSource* base,
                           DataSource* source);
VALA_EXTERN gboolean face_detach (Face* self,
                      MediaSource* source);
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
static void face_real_break_link_many (ContainerSource* base,
                                GeeCollection* sources);
VALA_EXTERN gint face_detach_many (Face* self,
                       GeeCollection* sources);
static void face_real_establish_link (ContainerSource* base,
                               DataSource* source);
VALA_EXTERN void face_attach (Face* self,
                  MediaSource* source);
static void face_real_establish_link_many (ContainerSource* base,
                                    GeeCollection* sources);
VALA_EXTERN void face_attach_many (Face* self,
                       GeeCollection* sources);
VALA_EXTERN gchar* indexable_prepare_indexable_string (const gchar* str);
static const gchar* face_real_get_indexable_keywords (Indexable* base);
VALA_EXTERN gboolean view_collection_has_view_for_source (ViewCollection* self,
                                              DataSource* source);
VALA_EXTERN DataView* view_collection_get_view_for_source (ViewCollection* self,
                                               DataSource* source);
VALA_EXTERN void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
VALA_EXTERN Marker* data_collection_mark (DataCollection* self,
                              DataObject* object);
VALA_EXTERN Marker* data_collection_start_marking (DataCollection* self);
VALA_EXTERN void marker_mark (Marker* self,
                  DataObject* object);
VALA_EXTERN gboolean face_rename (Face* self,
                      const gchar* name);
VALA_EXTERN void face_table_rename (FaceTable* self,
                        FaceID* face_id,
                        const gchar* new_name,
                        GError** error);
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN Alteration* alteration_new_from_list (const gchar* list);
VALA_EXTERN Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
VALA_EXTERN GType face_location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocation, g_object_unref)
VALA_EXTERN gboolean face_set_reference (Face* self,
                             FaceLocation* face_loc);
VALA_EXTERN void face_table_set_reference (FaceTable* self,
                               FaceID* face_id,
                               PhotoID* photo_id,
                               GError** error);
VALA_EXTERN void face_location_get_photo_id (FaceLocation* self,
                                 PhotoID* result);
VALA_EXTERN gboolean face_contains (Face* self,
                        MediaSource* source);
VALA_EXTERN GeeCollection* face_get_sources (Face* self);
VALA_EXTERN GeeCollection* view_collection_get_sources (ViewCollection* self);
VALA_EXTERN void face_mirror_sources (Face* self,
                          ViewCollection* view,
                          CreateView mirroring_ctor,
                          gpointer mirroring_ctor_target);
VALA_EXTERN void view_collection_mirror (ViewCollection* self,
                             ViewCollection* to_mirror,
                             CreateView mirroring_ctor,
                             gpointer mirroring_ctor_target,
                             CreateViewPredicate should_mirror,
                             gpointer should_mirror_target);
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN void photo_get_photo_id (Photo* self,
                         PhotoID* result);
VALA_EXTERN void face_location_destroy (FaceID* face_id,
                            PhotoID* photo_id);
VALA_EXTERN void container_source_collection_evaporate (ContainerSourceCollection* self,
                                            ContainerSource* container);
static void face_real_destroy (DataSource* base);
VALA_EXTERN void data_collection_clear (DataCollection* self);
VALA_EXTERN void source_snapshot_notify_broken (SourceSnapshot* self);
static void face_face_snapshot_on_source_destroyed (FaceFaceSnapshot* self,
                                             DataSource* source);
static void _face_face_snapshot_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                               DataSource* source,
                                                                               gpointer self);
VALA_EXTERN SourceSnapshot* source_snapshot_construct (GType object_type);
static FaceRow* face_face_snapshot_get_row (FaceFaceSnapshot* self);
static void face_face_snapshot_real_notify_broken (SourceSnapshot* base);
VALA_EXTERN FaceRow* face_row_new (void);
VALA_EXTERN FaceRow* face_row_construct (GType object_type);
static void face_face_snapshot_finalize (SourceSnapshot * obj);
static GType face_face_snapshot_get_type_once (void);
VALA_EXTERN DataSource* source_proxy_reconstitute (SourceProxy* self,
                                       gint64 object_id,
                                       SourceSnapshot* snapshot);
VALA_EXTERN SourceProxy* source_proxy_construct (GType object_type,
                                     DataSource* source);
static DataSource* face_face_proxy_real_reconstitute (SourceProxy* base,
                                               gint64 object_id,
                                               SourceSnapshot* snapshot);
static GType face_face_proxy_get_type_once (void);
VALA_EXTERN void container_source_break_link (ContainerSource* self,
                                  DataSource* source);
VALA_EXTERN void container_source_break_link_many (ContainerSource* self,
                                       GeeCollection* sources);
VALA_EXTERN void container_source_establish_link (ContainerSource* self,
                                      DataSource* source);
VALA_EXTERN void container_source_establish_link_many (ContainerSource* self,
                                           GeeCollection* sources);
VALA_EXTERN SourceProxy* proxyable_get_proxy (Proxyable* self);
VALA_EXTERN const gchar* indexable_get_indexable_keywords (Indexable* self);
static void face_finalize (GObject * obj);
static GType face_get_type_once (void);

static inline gpointer
face_source_collection_get_instance_private (FaceSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, FaceSourceCollection_private_offset);
}

static gint64
_face_source_collection_get_face_key_get_source_database_key (DataSource* source,
                                                              gpointer self)
{
	gint64 result;
	result = face_source_collection_get_face_key (source);
	return result;
}

FaceSourceCollection*
face_source_collection_construct (GType object_type)
{
	FaceSourceCollection* self = NULL;
	LibraryPhotoSourceCollection* _tmp0_;
	self = (FaceSourceCollection*) container_source_collection_construct (object_type, FACE_TYPENAME, "FaceSourceCollection", _face_source_collection_get_face_key_get_source_database_key, NULL);
	_tmp0_ = library_photo_global;
	container_source_collection_attach_collection (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection));
	return self;
}

FaceSourceCollection*
face_source_collection_new (void)
{
	return face_source_collection_construct (TYPE_FACE_SOURCE_COLLECTION);
}

static gboolean
face_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                  DataSource* source)
{
	FaceSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = IS_FACE (source);
	return result;
}

static gint64
face_source_collection_get_face_key (DataSource* source)
{
	gint64 result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
	result = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_FACE, Face), TYPE_DATA_SOURCE, DataSource));
	return result;
}

static GeeCollection*
face_source_collection_real_get_containers_holding_source (ContainerSourceCollection* base,
                                                           DataSource* source)
{
	FaceSourceCollection * self;
	GeeList* _tmp0_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_val_if_fail (IS_DATA_SOURCE (source), NULL);
	_tmp0_ = face_source_collection_fetch_for_source (self, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ContainerSource*
face_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* base,
                                                           SourceBacklink* backlink)
{
	FaceSourceCollection * self;
	FaceID face_id = {0};
	gint64 _tmp0_;
	gint64 _tmp1_;
	Face* face = NULL;
	FaceID _tmp2_;
	Face* _tmp3_;
	Face* _tmp4_;
	ContainerSource* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), NULL);
	_tmp0_ = source_backlink_get_instance_id (backlink);
	_tmp1_ = _tmp0_;
	face_id_init (&face_id, _tmp1_);
	_tmp2_ = face_id;
	_tmp3_ = face_source_collection_fetch (self, &_tmp2_);
	face = _tmp3_;
	_tmp4_ = face;
	if (_tmp4_ != NULL) {
		result = G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_CONTAINER_SOURCE, ContainerSource);
		return result;
	}
	{
		GeeIterator* _container_it = NULL;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp5_ = container_source_collection_get_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection));
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_container_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			ContainerSource* _tmp12_;
			Face* _tmp13_;
			Face* _tmp14_;
			FaceID _tmp15_ = {0};
			FaceID _tmp16_;
			_tmp9_ = _container_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _container_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			container = (ContainerSource*) _tmp11_;
			_tmp12_ = container;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_FACE, Face));
			_g_object_unref0 (face);
			face = _tmp13_;
			_tmp14_ = face;
			face_get_face_id (_tmp14_, &_tmp15_);
			_tmp16_ = face_id;
			if (_tmp15_.id == _tmp16_.id) {
				result = G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_CONTAINER_SOURCE, ContainerSource);
				_g_object_unref0 (container);
				_g_object_unref0 (_container_it);
				return result;
			}
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	result = NULL;
	_g_object_unref0 (face);
	return result;
}

Face*
face_source_collection_fetch (FaceSourceCollection* self,
                              FaceID* face_id)
{
	FaceID _tmp0_;
	DataSource* _tmp1_;
	Face* result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	_tmp0_ = *face_id;
	_tmp1_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_FACE, Face);
	return result;
}

gboolean
face_source_collection_exists (FaceSourceCollection* self,
                               const gchar* name)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->name_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
	return result;
}

GeeCollection*
face_source_collection_get_all_names (FaceSourceCollection* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->name_map;
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeList*
face_source_collection_fetch_for_source (FaceSourceCollection* self,
                                         MediaSource* source)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), source);
	result = (GeeList*) _tmp1_;
	return result;
}

Face*
face_source_collection_fetch_by_name (FaceSourceCollection* self,
                                      const gchar* name)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	Face* result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->name_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
	result = (Face*) _tmp1_;
	return result;
}

Face*
face_source_collection_restore_face_from_holding_tank (FaceSourceCollection* self,
                                                       const gchar* name)
{
	Face* found = NULL;
	Face* _tmp15_;
	Face* result;
	g_return_val_if_fail (IS_FACE_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	found = NULL;
	{
		GeeIterator* _container_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = container_source_collection_get_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection));
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_container_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Face* face = NULL;
			ContainerSource* _tmp7_;
			Face* _tmp8_;
			Face* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			_tmp4_ = _container_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _container_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			container = (ContainerSource*) _tmp6_;
			_tmp7_ = container;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_FACE, Face));
			face = _tmp8_;
			_tmp9_ = face;
			_tmp10_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, name) == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				Face* _tmp13_;
				Face* _tmp14_;
				_tmp13_ = face;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				_g_object_unref0 (found);
				found = _tmp14_;
				_g_object_unref0 (face);
				_g_object_unref0 (container);
				break;
			}
			_g_object_unref0 (face);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	_tmp15_ = found;
	if (_tmp15_ != NULL) {
		gboolean relinked = FALSE;
		Face* _tmp16_;
		_tmp16_ = found;
		relinked = container_source_collection_relink_from_holding_tank (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_CONTAINER_SOURCE, ContainerSource));
		_vala_assert (relinked, "relinked");
	}
	result = found;
	return result;
}

static void
face_source_collection_real_notify_items_added (DataCollection* base,
                                                GeeIterable* added)
{
	FaceSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Face* face = NULL;
			DataObject* _tmp4_;
			Face* _tmp5_;
			GeeHashMap* _tmp6_;
			Face* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GeeHashMap* _tmp10_;
			Face* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			Face* _tmp14_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_FACE, Face));
			face = _tmp5_;
			_tmp6_ = self->priv->name_map;
			_tmp7_ = face;
			_tmp8_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
			_tmp9_ = _tmp8_;
			_vala_assert (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_), "!name_map.has_key(face.get_name())");
			_g_free0 (_tmp9_);
			_tmp10_ = self->priv->name_map;
			_tmp11_ = face;
			_tmp12_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
			_tmp13_ = _tmp12_;
			_tmp14_ = face;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
			_g_free0 (_tmp13_);
			_g_object_unref0 (face);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (face_source_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added);
}

static void
face_source_collection_real_notify_items_removed (DataCollection* base,
                                                  GeeIterable* removed)
{
	FaceSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			Face* face = NULL;
			DataObject* _tmp4_;
			Face* _tmp5_;
			gboolean unset = FALSE;
			GeeHashMap* _tmp6_;
			Face* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_FACE, Face));
			face = _tmp5_;
			_tmp6_ = self->priv->name_map;
			_tmp7_ = face;
			_tmp8_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_OBJECT, DataObject));
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, NULL);
			_g_free0 (_tmp9_);
			unset = _tmp10_;
			_vala_assert (unset, "unset");
			_g_object_unref0 (face);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (face_source_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), removed);
}

static void
face_source_collection_real_notify_items_altered (DataCollection* base,
                                                  GeeMap* map)
{
	FaceSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Face* face = NULL;
			DataObject* _tmp8_;
			Face* _tmp9_;
			gchar* old_name = NULL;
			GeeMapIterator* iter = NULL;
			GeeHashMap* _tmp10_;
			GeeMapIterator* _tmp11_;
			const gchar* _tmp20_;
			Face* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gboolean _tmp25_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_FACE, Face));
			face = _tmp9_;
			old_name = NULL;
			_tmp10_ = self->priv->name_map;
			_tmp11_ = gee_abstract_map_map_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
			iter = _tmp11_;
			while (TRUE) {
				GeeMapIterator* _tmp12_;
				GeeMapIterator* _tmp13_;
				gpointer _tmp14_;
				Face* _tmp15_;
				Face* _tmp16_;
				gboolean _tmp17_;
				GeeMapIterator* _tmp18_;
				gpointer _tmp19_;
				_tmp12_ = iter;
				if (!gee_map_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = iter;
				_tmp14_ = gee_map_iterator_get_value (_tmp13_);
				_tmp15_ = (Face*) _tmp14_;
				_tmp16_ = face;
				_tmp17_ = !data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_SOURCE, DataSource));
				_g_object_unref0 (_tmp15_);
				if (_tmp17_) {
					continue;
				}
				_tmp18_ = iter;
				_tmp19_ = gee_map_iterator_get_key (_tmp18_);
				_g_free0 (old_name);
				old_name = (gchar*) _tmp19_;
				break;
			}
			_tmp20_ = old_name;
			_vala_assert (_tmp20_ != NULL, "old_name != null");
			_tmp21_ = face;
			_tmp22_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_OBJECT, DataObject));
			_tmp23_ = _tmp22_;
			_tmp24_ = old_name;
			_tmp25_ = g_strcmp0 (_tmp23_, _tmp24_) != 0;
			_g_free0 (_tmp23_);
			if (_tmp25_) {
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				GeeHashMap* _tmp28_;
				Face* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				Face* _tmp32_;
				_tmp26_ = self->priv->name_map;
				_tmp27_ = old_name;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, NULL);
				_tmp28_ = self->priv->name_map;
				_tmp29_ = face;
				_tmp30_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_OBJECT, DataObject));
				_tmp31_ = _tmp30_;
				_tmp32_ = face;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp31_, _tmp32_);
				_g_free0 (_tmp31_);
			}
			_g_object_unref0 (iter);
			_g_free0 (old_name);
			_g_object_unref0 (face);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (face_source_collection_parent_class)->notify_items_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), TYPE_DATA_COLLECTION, DataCollection), map);
}

static void
face_source_collection_real_notify_container_contents_added (ContainerSourceCollection* base,
                                                             ContainerSource* container,
                                                             GeeCollection* added,
                                                             gboolean relinking)
{
	FaceSourceCollection * self;
	Face* face = NULL;
	Face* _tmp0_;
	GeeCollection* sources = NULL;
	GeeCollection* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_FACE, Face));
	face = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection));
	sources = _tmp1_;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = sources;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* faces = NULL;
			GeeHashMap* _tmp7_;
			MediaSource* _tmp8_;
			gpointer _tmp9_;
			GeeList* _tmp10_;
			gboolean is_added = FALSE;
			GeeList* _tmp15_;
			Face* _tmp16_;
			_tmp4_ = _source_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _source_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			source = (MediaSource*) _tmp6_;
			_tmp7_ = self->priv->source_map;
			_tmp8_ = source;
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
			faces = (GeeList*) _tmp9_;
			_tmp10_ = faces;
			if (_tmp10_ == NULL) {
				GeeArrayList* _tmp11_;
				GeeHashMap* _tmp12_;
				MediaSource* _tmp13_;
				GeeList* _tmp14_;
				_tmp11_ = gee_array_list_new (TYPE_FACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
				_g_object_unref0 (faces);
				faces = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_LIST, GeeList);
				_tmp12_ = self->priv->source_map;
				_tmp13_ = source;
				_tmp14_ = faces;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
			}
			_tmp15_ = faces;
			_tmp16_ = face;
			is_added = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
			_vala_assert (is_added, "is_added");
			_g_object_unref0 (faces);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	CONTAINER_SOURCE_COLLECTION_CLASS (face_source_collection_parent_class)->notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), container, added, relinking);
	_g_object_unref0 (sources);
	_g_object_unref0 (face);
}

static void
face_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* base,
                                                               ContainerSource* container,
                                                               GeeCollection* removed,
                                                               gboolean unlinking)
{
	FaceSourceCollection * self;
	Face* face = NULL;
	Face* _tmp0_;
	GeeCollection* sources = NULL;
	GeeCollection* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_FACE, Face));
	face = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
	sources = _tmp1_;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = sources;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSource* source = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeList* faces = NULL;
			GeeHashMap* _tmp7_;
			MediaSource* _tmp8_;
			gpointer _tmp9_;
			GeeList* _tmp10_;
			gboolean is_removed = FALSE;
			GeeList* _tmp11_;
			Face* _tmp12_;
			GeeList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp4_ = _source_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _source_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			source = (MediaSource*) _tmp6_;
			_tmp7_ = self->priv->source_map;
			_tmp8_ = source;
			_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
			faces = (GeeList*) _tmp9_;
			_tmp10_ = faces;
			_vala_assert (_tmp10_ != NULL, "faces != null");
			_tmp11_ = faces;
			_tmp12_ = face;
			is_removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
			_vala_assert (is_removed, "is_removed");
			_tmp13_ = faces;
			_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp15_ = _tmp14_;
			if (_tmp15_ == 0) {
				GeeHashMap* _tmp16_;
				MediaSource* _tmp17_;
				_tmp16_ = self->priv->source_map;
				_tmp17_ = source;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_, NULL);
			}
			_g_object_unref0 (faces);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	CONTAINER_SOURCE_COLLECTION_CLASS (face_source_collection_parent_class)->notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), container, removed, unlinking);
	_g_object_unref0 (sources);
	_g_object_unref0 (face);
}

static void
face_source_collection_class_init (FaceSourceCollectionClass * klass,
                                   gpointer klass_data)
{
	face_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = face_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &FaceSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) face_source_collection_real_holds_type_of_source;
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection*, DataSource*)) face_source_collection_real_get_containers_holding_source;
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection*, SourceBacklink*)) face_source_collection_real_convert_backlink_to_container;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) face_source_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) face_source_collection_real_notify_items_removed;
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection*, GeeMap*)) face_source_collection_real_notify_items_altered;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_added = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) face_source_collection_real_notify_container_contents_added;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_removed = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) face_source_collection_real_notify_container_contents_removed;
}

static void
face_source_collection_instance_init (FaceSourceCollection * self,
                                      gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = face_source_collection_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_FACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) face_hash_name_string, NULL, NULL, (GeeEqualDataFunc) face_equal_name_strings, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->source_map = _tmp1_;
}

static void
face_source_collection_finalize (DataCollection * obj)
{
	FaceSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection);
	_g_object_unref0 (self->priv->name_map);
	_g_object_unref0 (self->priv->source_map);
	DATA_COLLECTION_CLASS (face_source_collection_parent_class)->finalize (obj);
}

static GType
face_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceSourceCollection), 0, (GInstanceInitFunc) face_source_collection_instance_init, NULL };
	GType face_source_collection_type_id;
	face_source_collection_type_id = g_type_register_static (TYPE_CONTAINER_SOURCE_COLLECTION, "FaceSourceCollection", &g_define_type_info, 0);
	FaceSourceCollection_private_offset = g_type_add_instance_private (face_source_collection_type_id, sizeof (FaceSourceCollectionPrivate));
	return face_source_collection_type_id;
}

GType
face_source_collection_get_type (void)
{
	static volatile gsize face_source_collection_type_id__once = 0;
	if (g_once_init_enter (&face_source_collection_type_id__once)) {
		GType face_source_collection_type_id;
		face_source_collection_type_id = face_source_collection_get_type_once ();
		g_once_init_leave (&face_source_collection_type_id__once, face_source_collection_type_id);
	}
	return face_source_collection_type_id__once;
}

static inline gpointer
face_get_instance_private (Face* self)
{
	return G_STRUCT_MEMBER_P (self, Face_private_offset);
}

static void
_face_on_media_views_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                        GeeIterable* added,
                                                                        GeeIterable* removed,
                                                                        gpointer self)
{
	face_on_media_views_contents_altered ((Face*) self, added, removed);
}

static void
_face_on_sources_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                              GeeCollection* destroyed,
                                                              gpointer self)
{
	face_on_sources_destroyed ((Face*) self, destroyed);
}

static gpointer
_face_row_ref0 (gpointer self)
{
	return self ? face_row_ref (self) : NULL;
}

static Face*
face_construct (GType object_type,
                FaceRow* row,
                gint64 object_id)
{
	Face * self = NULL;
	FaceRow* _tmp0_;
	FaceRow* _tmp1_;
	FaceRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeSet* photo_id_list = NULL;
	GeeSet* _tmp5_;
	GeeArrayList* photo_list = NULL;
	GeeArrayList* _tmp6_;
	GeeArrayList* thumbnail_views = NULL;
	GeeArrayList* _tmp7_;
	GeeSet* _tmp8_;
	FaceID _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	ViewCollection* _tmp34_;
	ViewCollection* _tmp35_;
	GeeArrayList* _tmp36_;
	GeeCollection* _tmp37_;
	GeeCollection* _tmp38_;
	GeeArrayList* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	ViewCollection* _tmp46_;
	LibraryPhotoSourceCollection* _tmp47_;
	g_return_val_if_fail (IS_FACE_ROW (row), NULL);
	self = (Face*) data_source_construct (object_type, object_id);
	_tmp0_ = _face_row_ref0 (row);
	_face_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	_tmp1_ = self->priv->row;
	_tmp2_ = self->priv->row;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = face_prep_face_name (_tmp3_);
	_g_free0 (_tmp1_->name);
	_tmp1_->name = _tmp4_;
	_tmp5_ = face_location_get_photo_ids_by_face (self);
	photo_id_list = _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photo_list = _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	thumbnail_views = _tmp7_;
	_tmp8_ = photo_id_list;
	if (_tmp8_ != NULL) {
		{
			GeeIterator* _photo_id_it = NULL;
			GeeSet* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = photo_id_list;
			_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
			_photo_id_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				PhotoID photo_id = {0};
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				PhotoID* _tmp14_;
				PhotoID _tmp15_;
				MediaSource* current_source = NULL;
				LibraryPhotoSourceCollection* _tmp16_;
				PhotoID _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				MediaSource* _tmp20_;
				MediaSource* _tmp21_;
				MediaSource* _tmp22_;
				GeeArrayList* _tmp23_;
				MediaSource* _tmp24_;
				GeeArrayList* _tmp25_;
				MediaSource* _tmp26_;
				ThumbnailView* _tmp27_;
				ThumbnailView* _tmp28_;
				_tmp11_ = _photo_id_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _photo_id_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				_tmp14_ = (PhotoID*) _tmp13_;
				_tmp15_ = *_tmp14_;
				_photo_id_free0 (_tmp14_);
				photo_id = _tmp15_;
				_tmp16_ = library_photo_global;
				_tmp17_ = photo_id;
				_tmp18_ = photo_id_upgrade_photo_id_to_source_id (&_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = media_source_collection_fetch_by_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				current_source = _tmp21_;
				_tmp22_ = current_source;
				if (_tmp22_ == NULL) {
					_g_object_unref0 (current_source);
					continue;
				}
				_tmp23_ = photo_list;
				_tmp24_ = current_source;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PHOTO, Photo));
				_tmp25_ = thumbnail_views;
				_tmp26_ = current_source;
				_tmp27_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
				_tmp28_ = _tmp27_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp28_);
				_g_object_unref0 (_tmp28_);
				_g_object_unref0 (current_source);
			}
			_g_object_unref0 (_photo_id_it);
		}
	}
	_tmp29_ = row->face_id;
	_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp29_.id);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("ViewCollection for face %s", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = view_collection_new (_tmp33_);
	_data_collection_unref0 (self->priv->media_views);
	self->priv->media_views = _tmp34_;
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp35_ = self->priv->media_views;
	_tmp36_ = thumbnail_views;
	_tmp37_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (_tmp38_);
	_tmp39_ = photo_list;
	_tmp40_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp41_ = _tmp40_;
	if (_tmp41_ > 0) {
		FaceSourceCollection* _tmp42_;
		GeeArrayList* _tmp43_;
		FaceSourceCollection* _tmp44_;
		GeeArrayList* _tmp45_;
		_tmp42_ = face_global;
		_tmp43_ = photo_list;
		container_source_collection_notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
		_tmp44_ = face_global;
		_tmp45_ = photo_list;
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_COLLECTION, GeeCollection), FALSE, NULL, FALSE);
	}
	_tmp46_ = self->priv->media_views;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _face_on_media_views_contents_altered_data_collection_contents_altered, self, 0);
	_tmp47_ = library_photo_global;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_SOURCE_COLLECTION, SourceCollection), "items-destroyed", (GCallback) _face_on_sources_destroyed_source_collection_items_destroyed, self, 0);
	face_update_indexable_keywords (self);
	_g_object_unref0 (thumbnail_views);
	_g_object_unref0 (photo_list);
	_g_object_unref0 (photo_id_list);
	return self;
}

static Face*
face_new (FaceRow* row,
          gint64 object_id)
{
	return face_construct (TYPE_FACE, row, object_id);
}

void
face_init (ProgressMonitor monitor,
           gpointer monitor_target)
{
	FaceSourceCollection* _tmp0_;
	GeeList* rows = NULL;
	GeeArrayList* faces = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* unlinked = NULL;
	GeeArrayList* _tmp9_;
	gint count = 0;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	FaceSourceCollection* _tmp48_;
	GeeArrayList* _tmp49_;
	GeeCollection* _tmp50_;
	GeeCollection* _tmp51_;
	FaceSourceCollection* _tmp52_;
	GeeArrayList* _tmp53_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = face_source_collection_new ();
	_data_collection_unref0 (face_global);
	face_global = _tmp0_;
	rows = NULL;
	{
		GeeList* _tmp1_ = NULL;
		FaceTable* _tmp2_;
		FaceTable* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		_tmp2_ = face_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = face_table_get_all_rows (_tmp3_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_database_table_unref0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (rows);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (rows);
		rows = _tmp6_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		app_window_database_error (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (rows);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = gee_array_list_new (TYPE_FACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	faces = _tmp8_;
	_tmp9_ = gee_array_list_new (TYPE_FACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unlinked = _tmp9_;
	_tmp10_ = rows;
	_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp12_ = _tmp11_;
	count = _tmp12_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				FaceRow* row = NULL;
				GeeList* _tmp15_;
				gpointer _tmp16_;
				gchar* name = NULL;
				FaceRow* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				FaceRow* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				Face* face = NULL;
				FaceRow* _tmp34_;
				Face* _tmp35_;
				Face* _tmp36_;
				Face* _tmp39_;
				Face* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				Face* _tmp47_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = ctr;
					ctr = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp15_ = rows;
				_tmp16_ = gee_list_get (_tmp15_, ctr);
				row = (FaceRow*) _tmp16_;
				_tmp17_ = row;
				_tmp18_ = _tmp17_->name;
				_tmp19_ = face_prep_face_name (_tmp18_);
				name = _tmp19_;
				_tmp20_ = name;
				if (_tmp20_ == NULL) {
					FaceRow* _tmp21_;
					const gchar* _tmp22_;
					_tmp21_ = row;
					_tmp22_ = _tmp21_->name;
					g_warning ("Face.vala:312: Invalid face name \"%s\": removing from database", _tmp22_);
					{
						FaceTable* _tmp23_;
						FaceTable* _tmp24_;
						FaceRow* _tmp25_;
						FaceID _tmp26_;
						_tmp23_ = face_table_get_instance ();
						_tmp24_ = _tmp23_;
						_tmp25_ = row;
						_tmp26_ = _tmp25_->face_id;
						face_table_remove (_tmp24_, &_tmp26_, &_inner_error0_);
						_database_table_unref0 (_tmp24_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == DATABASE_ERROR) {
								goto __catch1_database_error;
							}
							_g_free0 (name);
							_face_row_unref0 (row);
							_g_object_unref0 (unlinked);
							_g_object_unref0 (faces);
							_g_object_unref0 (rows);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					goto __finally1;
					__catch1_database_error:
					{
						GError* err = NULL;
						FaceRow* _tmp27_;
						const gchar* _tmp28_;
						GError* _tmp29_;
						const gchar* _tmp30_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp27_ = row;
						_tmp28_ = _tmp27_->name;
						_tmp29_ = err;
						_tmp30_ = _tmp29_->message;
						g_warning ("Face.vala:316: Unable to delete face \"%s\": %s", _tmp28_, _tmp30_);
						_g_error_free0 (err);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (name);
						_face_row_unref0 (row);
						_g_object_unref0 (unlinked);
						_g_object_unref0 (faces);
						_g_object_unref0 (rows);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_free0 (name);
					_face_row_unref0 (row);
					continue;
				}
				_tmp31_ = row;
				_tmp32_ = name;
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (_tmp31_->name);
				_tmp31_->name = _tmp33_;
				_tmp34_ = row;
				_tmp35_ = face_new (_tmp34_, DATA_OBJECT_INVALID_OBJECT_ID);
				face = _tmp35_;
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_tmp36_ = face;
				if (face_get_sources_count (_tmp36_) != 0) {
					GeeArrayList* _tmp37_;
					Face* _tmp38_;
					_tmp37_ = faces;
					_tmp38_ = face;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp38_);
					_g_object_unref0 (face);
					_g_free0 (name);
					_face_row_unref0 (row);
					continue;
				}
				_tmp39_ = face;
				if (container_source_has_links (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_CONTAINER_SOURCE, ContainerSource))) {
					Face* _tmp40_;
					FaceSourceCollection* _tmp41_;
					GeeArrayList* _tmp42_;
					Face* _tmp43_;
					_tmp40_ = face;
					_tmp41_ = face_global;
					data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_SOURCE_COLLECTION, SourceCollection), NULL);
					_tmp42_ = unlinked;
					_tmp43_ = face;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp43_);
					_g_object_unref0 (face);
					_g_free0 (name);
					_face_row_unref0 (row);
					continue;
				}
				_tmp44_ = face;
				_tmp45_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_DATA_OBJECT, DataObject));
				_tmp46_ = _tmp45_;
				g_warning ("Face.vala:341: Empty face %s found with no backlinks, destroying", _tmp46_);
				_g_free0 (_tmp46_);
				_tmp47_ = face;
				data_source_destroy_orphan (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_DATA_SOURCE, DataSource), TRUE);
				_g_object_unref0 (face);
				_g_free0 (name);
				_face_row_unref0 (row);
			}
		}
	}
	_tmp48_ = face_global;
	_tmp49_ = faces;
	_tmp50_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp51_ = _tmp50_;
	_g_object_unref0 (_tmp51_);
	_tmp52_ = face_global;
	_tmp53_ = unlinked;
	container_source_collection_init_add_many_unlinked (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (unlinked);
	_g_object_unref0 (faces);
	_g_object_unref0 (rows);
}

void
face_terminate (void)
{
	GError* _inner_error0_ = NULL;
	{
		FaceDetectInterface* _tmp0_;
		_tmp0_ = face_detect_face_detect_proxy;
		if (_tmp0_ != NULL) {
			FaceDetectInterface* _tmp1_;
			_tmp1_ = face_detect_face_detect_proxy;
			face_detect_interface_terminate (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gint
face_compare_names (void* a,
                    void* b)
{
	Face* aface = NULL;
	Face* bface = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint result;
	aface = (Face*) a;
	bface = (Face*) b;
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (aface, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = face_get_name_collation_key (G_TYPE_CHECK_INSTANCE_CAST (aface, TYPE_FACE, Face));
	_tmp3_ = _tmp2_;
	_tmp4_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (bface, TYPE_DATA_OBJECT, DataObject));
	_tmp5_ = _tmp4_;
	_tmp6_ = face_get_name_collation_key (G_TYPE_CHECK_INSTANCE_CAST (bface, TYPE_FACE, Face));
	_tmp7_ = _tmp6_;
	_tmp8_ = string_precollated_compare (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp8_;
	return result;
}

guint
face_hash_name_string (void* a)
{
	guint result;
	result = string_collated_hash (a);
	return result;
}

gboolean
face_equal_name_strings (void* a,
                         void* b)
{
	gboolean result;
	result = string_collated_equals (a, b);
	return result;
}

Face*
face_for_name (const gchar* name)
{
	Face* face = NULL;
	FaceSourceCollection* _tmp0_;
	Face* _tmp1_;
	Face* _tmp2_;
	Face* _tmp5_;
	FaceSourceCollection* _tmp13_;
	Face* _tmp14_;
	GError* _inner_error0_ = NULL;
	Face* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = face_global;
	_tmp1_ = face_source_collection_fetch_by_name (_tmp0_, name);
	face = _tmp1_;
	_tmp2_ = face;
	if (_tmp2_ == NULL) {
		FaceSourceCollection* _tmp3_;
		Face* _tmp4_;
		_tmp3_ = face_global;
		_tmp4_ = face_source_collection_restore_face_from_holding_tank (_tmp3_, name);
		_g_object_unref0 (face);
		face = _tmp4_;
	}
	_tmp5_ = face;
	if (_tmp5_ != NULL) {
		result = face;
		return result;
	}
	{
		FaceRow* _tmp6_ = NULL;
		FaceTable* _tmp7_;
		FaceTable* _tmp8_;
		FaceRow* _tmp9_;
		FaceRow* _tmp10_;
		Face* _tmp11_;
		_tmp7_ = face_table_get_instance ();
		_tmp8_ = _tmp7_;
		_tmp9_ = face_table_add (_tmp8_, name, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_database_table_unref0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (face);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp11_ = face_new (_tmp6_, DATA_OBJECT_INVALID_OBJECT_ID);
		_g_object_unref0 (face);
		face = _tmp11_;
		_face_row_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = err;
		app_window_database_error (_tmp12_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (face);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp13_ = face_global;
	_tmp14_ = face;
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_OBJECT, DataObject));
	result = face;
	return result;
}

gchar*
face_prep_face_name (const gchar* name)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = prepare_input_text (name, PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, DEFAULT_USER_TEXT_INPUT_LENGTH);
	result = _tmp0_;
	return result;
}

static gchar*
face_real_get_typename (DataSource* base)
{
	Face * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = g_strdup (FACE_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
face_real_get_instance_id (DataSource* base)
{
	Face * self;
	FaceID _tmp0_ = {0};
	gint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	face_get_face_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gchar*
face_real_get_name (DataObject* base)
{
	Face * self;
	FaceRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
face_get_name_collation_key (Face* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (IS_FACE (self), NULL);
	_tmp0_ = self->priv->name_collation_key;
	if (_tmp0_ == NULL) {
		FaceRow* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->row;
		_tmp2_ = _tmp1_->name;
		_tmp3_ = g_utf8_collate_key (_tmp2_, (gssize) -1);
		_g_free0 (self->priv->name_collation_key);
		self->priv->name_collation_key = _tmp3_;
	}
	_tmp4_ = self->priv->name_collation_key;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
face_real_to_string (DataObject* base)
{
	Face * self;
	FaceRow* _tmp0_;
	const gchar* _tmp1_;
	ViewCollection* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = self->priv->media_views;
	_tmp3_ = g_strdup_printf ("Face %s (%d sources)", _tmp1_, data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection)));
	result = _tmp3_;
	return result;
}

static gboolean
face_real_equals (DataSource* base,
                  DataSource* source)
{
	Face * self;
	Face* face = NULL;
	Face* _tmp0_;
	Face* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
	_tmp0_ = _g_object_ref0 (IS_FACE (source) ? ((Face*) source) : NULL);
	face = _tmp0_;
	_tmp1_ = face;
	if (_tmp1_ != NULL) {
		Face* _tmp2_;
		_tmp2_ = face;
		if (_tmp2_ != self) {
			Face* _tmp3_;
			FaceRow* _tmp4_;
			FaceID _tmp5_;
			FaceRow* _tmp6_;
			FaceID _tmp7_;
			_tmp3_ = face;
			_tmp4_ = _tmp3_->priv->row;
			_tmp5_ = _tmp4_->face_id;
			_tmp6_ = self->priv->row;
			_tmp7_ = _tmp6_->face_id;
			_vala_assert (_tmp5_.id != _tmp7_.id, "face.row.face_id.id != row.face_id.id");
		}
	}
	result = DATA_SOURCE_CLASS (face_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), source);
	_g_object_unref0 (face);
	return result;
}

void
face_get_face_id (Face* self,
                  FaceID* result)
{
	FaceRow* _tmp0_;
	FaceID _tmp1_;
	g_return_if_fail (IS_FACE (self));
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->face_id;
	*result = _tmp1_;
	return;
}

static SourceSnapshot*
face_real_save_snapshot (DataSource* base)
{
	Face * self;
	FaceFaceSnapshot* _tmp0_;
	SourceSnapshot* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = face_face_snapshot_new (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_SNAPSHOT, SourceSnapshot);
	return result;
}

static SourceProxy*
face_real_get_proxy (Proxyable* base)
{
	Face * self;
	FaceFaceProxy* _tmp0_;
	SourceProxy* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = face_face_proxy_new (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_PROXY, SourceProxy);
	return result;
}

static Face*
face_reconstitute (gint64 object_id,
                   FaceRow* row)
{
	Face* face = NULL;
	Face* _tmp6_;
	FaceSourceCollection* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	Face* result;
	g_return_val_if_fail (IS_FACE_ROW (row), NULL);
	{
		FaceID _tmp0_ = {0};
		FaceTable* _tmp1_;
		FaceTable* _tmp2_;
		FaceID _tmp3_ = {0};
		FaceID _tmp4_;
		_tmp1_ = face_table_get_instance ();
		_tmp2_ = _tmp1_;
		face_table_create_from_row (_tmp2_, row, &_tmp3_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		row->face_id = _tmp0_;
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		app_window_database_error (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = face_new (row, object_id);
	face = _tmp6_;
	_tmp7_ = face_global;
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_DATA_OBJECT, DataObject));
	_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_DATA_OBJECT, DataObject));
	_tmp9_ = _tmp8_;
	g_debug ("Face.vala:473: Reconstituted %s", _tmp9_);
	_g_free0 (_tmp9_);
	result = face;
	return result;
}

static gboolean
face_real_has_links (ContainerSource* base)
{
	Face * self;
	LibraryPhotoSourceCollection* _tmp0_;
	SourceBacklink* _tmp1_;
	SourceBacklink* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = library_photo_global;
	_tmp1_ = container_source_get_backlink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource));
	_tmp2_ = _tmp1_;
	_tmp3_ = source_collection_has_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp2_);
	_source_backlink_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static SourceBacklink*
face_real_get_backlink (ContainerSource* base)
{
	Face * self;
	SourceBacklink* _tmp0_;
	SourceBacklink* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = source_backlink_new_from_source (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
	result = _tmp0_;
	return result;
}

static void
face_real_break_link (ContainerSource* base,
                      DataSource* source)
{
	Face * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	g_return_if_fail (IS_DATA_SOURCE (source));
	self->priv->unlinking = TRUE;
	face_detach (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
	self->priv->unlinking = FALSE;
}

static void
face_real_break_link_many (ContainerSource* base,
                           GeeCollection* sources)
{
	Face * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	self->priv->unlinking = TRUE;
	face_detach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
	self->priv->unlinking = FALSE;
}

static void
face_real_establish_link (ContainerSource* base,
                          DataSource* source)
{
	Face * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	g_return_if_fail (IS_DATA_SOURCE (source));
	self->priv->relinking = TRUE;
	face_attach (self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
	self->priv->relinking = FALSE;
}

static void
face_real_establish_link_many (ContainerSource* base,
                               GeeCollection* sources)
{
	Face * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	self->priv->relinking = TRUE;
	face_attach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
	self->priv->relinking = FALSE;
}

static void
face_update_indexable_keywords (Face* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (IS_FACE (self));
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = indexable_prepare_indexable_string (_tmp1_);
	_g_free0 (self->priv->indexable_keywords);
	self->priv->indexable_keywords = _tmp2_;
	_g_free0 (_tmp1_);
}

static const gchar*
face_real_get_indexable_keywords (Indexable* base)
{
	Face * self;
	const gchar* _tmp0_;
	const gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = self->priv->indexable_keywords;
	result = _tmp0_;
	return result;
}

void
face_attach (Face* self,
             MediaSource* source)
{
	ViewCollection* _tmp0_;
	g_return_if_fail (IS_FACE (self));
	g_return_if_fail (IS_MEDIA_SOURCE (source));
	_tmp0_ = self->priv->media_views;
	if (!view_collection_has_view_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource))) {
		ViewCollection* _tmp1_;
		ThumbnailView* _tmp2_;
		ThumbnailView* _tmp3_;
		_tmp1_ = self->priv->media_views;
		_tmp2_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
		_tmp3_ = _tmp2_;
		data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_OBJECT, DataObject));
		_g_object_unref0 (_tmp3_);
	}
}

void
face_attach_many (Face* self,
                  GeeCollection* sources)
{
	GeeArrayList* view_list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (IS_FACE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_array_list_new (TYPE_THUMBNAIL_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	view_list = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ViewCollection* _tmp5_;
			MediaSource* _tmp6_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (MediaSource*) _tmp4_;
			_tmp5_ = self->priv->media_views;
			_tmp6_ = source;
			if (!view_collection_has_view_for_source (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_SOURCE, DataSource))) {
				GeeArrayList* _tmp7_;
				MediaSource* _tmp8_;
				ThumbnailView* _tmp9_;
				ThumbnailView* _tmp10_;
				_tmp7_ = view_list;
				_tmp8_ = source;
				_tmp9_ = thumbnail_view_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
				_tmp10_ = _tmp9_;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
				_g_object_unref0 (_tmp10_);
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp11_ = view_list;
	_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		ViewCollection* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		_tmp14_ = self->priv->media_views;
		_tmp15_ = view_list;
		_tmp16_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp17_);
	}
	_g_object_unref0 (view_list);
}

gboolean
face_detach (Face* self,
             MediaSource* source)
{
	DataView* view = NULL;
	ViewCollection* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	DataView* _tmp5_;
	Marker* _tmp6_;
	Marker* _tmp7_;
	gboolean result;
	g_return_val_if_fail (IS_FACE (self), FALSE);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = self->priv->media_views;
	_tmp1_ = view_collection_get_view_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	view = _tmp1_;
	_tmp2_ = view;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp3_ = self->priv->media_views;
	_tmp4_ = self->priv->media_views;
	_tmp5_ = view;
	_tmp6_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
	_tmp7_ = _tmp6_;
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), _tmp7_);
	_g_object_unref0 (_tmp7_);
	result = TRUE;
	_g_object_unref0 (view);
	return result;
}

gint
face_detach_many (Face* self,
                  GeeCollection* sources)
{
	gint count = 0;
	Marker* marker = NULL;
	ViewCollection* _tmp0_;
	Marker* _tmp1_;
	ViewCollection* _tmp13_;
	Marker* _tmp14_;
	gint result;
	g_return_val_if_fail (IS_FACE (self), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION), 0);
	count = 0;
	_tmp0_ = self->priv->media_views;
	_tmp1_ = data_collection_start_marking (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
	marker = _tmp1_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MediaSource* source = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataView* view = NULL;
			ViewCollection* _tmp6_;
			MediaSource* _tmp7_;
			DataView* _tmp8_;
			DataView* _tmp9_;
			Marker* _tmp10_;
			DataView* _tmp11_;
			gint _tmp12_;
			_tmp3_ = _source_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _source_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			source = (MediaSource*) _tmp5_;
			_tmp6_ = self->priv->media_views;
			_tmp7_ = source;
			_tmp8_ = view_collection_get_view_for_source (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource));
			view = _tmp8_;
			_tmp9_ = view;
			if (_tmp9_ == NULL) {
				_g_object_unref0 (view);
				_g_object_unref0 (source);
				continue;
			}
			_tmp10_ = marker;
			_tmp11_ = view;
			marker_mark (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
			_tmp12_ = count;
			count = _tmp12_ + 1;
			_g_object_unref0 (view);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp13_ = self->priv->media_views;
	_tmp14_ = marker;
	data_collection_remove_marked (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), _tmp14_);
	result = count;
	_g_object_unref0 (marker);
	return result;
}

gboolean
face_rename (Face* self,
             const gchar* name)
{
	gchar* new_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	FaceSourceCollection* _tmp2_;
	const gchar* _tmp3_;
	FaceRow* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	Alteration* _tmp15_;
	Alteration* _tmp16_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_FACE (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = face_prep_face_name (name);
	new_name = _tmp0_;
	_tmp1_ = new_name;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_free0 (new_name);
		return result;
	}
	_tmp2_ = face_global;
	_tmp3_ = new_name;
	if (face_source_collection_exists (_tmp2_, _tmp3_)) {
		result = FALSE;
		_g_free0 (new_name);
		return result;
	}
	{
		FaceTable* _tmp4_;
		FaceTable* _tmp5_;
		FaceRow* _tmp6_;
		FaceID _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = face_table_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->row;
		_tmp7_ = _tmp6_->face_id;
		_tmp8_ = new_name;
		face_table_rename (_tmp5_, &_tmp7_, _tmp8_, &_inner_error0_);
		_database_table_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_free0 (new_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		app_window_database_error (_tmp10_);
		result = FALSE;
		_g_error_free0 (err);
		_g_free0 (new_name);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		_g_free0 (new_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = self->priv->row;
	_tmp13_ = new_name;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (_tmp12_->name);
	_tmp12_->name = _tmp14_;
	_g_free0 (self->priv->name_collation_key);
	self->priv->name_collation_key = NULL;
	face_update_indexable_keywords (self);
	_tmp15_ = alteration_new_from_list ("metadata:name, indexable:keywords");
	_tmp16_ = _tmp15_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp16_);
	_alteration_unref0 (_tmp16_);
	result = TRUE;
	_g_free0 (new_name);
	return result;
}

gboolean
face_set_reference (Face* self,
                    FaceLocation* face_loc)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_FACE (self), FALSE);
	g_return_val_if_fail (IS_FACE_LOCATION (face_loc), FALSE);
	{
		FaceTable* _tmp0_;
		FaceTable* _tmp1_;
		FaceRow* _tmp2_;
		FaceID _tmp3_;
		PhotoID _tmp4_ = {0};
		_tmp0_ = face_table_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = self->priv->row;
		_tmp3_ = _tmp2_->face_id;
		face_location_get_photo_id (face_loc, &_tmp4_);
		face_table_set_reference (_tmp1_, &_tmp3_, &_tmp4_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		app_window_database_error (_tmp6_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

gboolean
face_contains (Face* self,
               MediaSource* source)
{
	ViewCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_FACE (self), FALSE);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = self->priv->media_views;
	result = view_collection_has_view_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	return result;
}

gint
face_get_sources_count (Face* self)
{
	ViewCollection* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_FACE (self), 0);
	_tmp0_ = self->priv->media_views;
	result = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
	return result;
}

GeeCollection*
face_get_sources (Face* self)
{
	ViewCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (IS_FACE (self), NULL);
	_tmp0_ = self->priv->media_views;
	_tmp1_ = view_collection_get_sources (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

void
face_mirror_sources (Face* self,
                     ViewCollection* view,
                     CreateView mirroring_ctor,
                     gpointer mirroring_ctor_target)
{
	ViewCollection* _tmp0_;
	g_return_if_fail (IS_FACE (self));
	g_return_if_fail (IS_VIEW_COLLECTION (view));
	_tmp0_ = self->priv->media_views;
	view_collection_mirror (view, _tmp0_, mirroring_ctor, mirroring_ctor_target, NULL, NULL);
}

static void
face_on_media_views_contents_altered (Face* self,
                                      GeeIterable* added,
                                      GeeIterable* removed)
{
	GeeSet* photo_id_list = NULL;
	GeeSet* _tmp0_;
	GeeCollection* added_photos = NULL;
	GeeCollection* removed_photos = NULL;
	GeeCollection* _tmp27_;
	GeeCollection* _tmp36_;
	GeeCollection* _tmp39_;
	gboolean _tmp42_ = FALSE;
	GeeCollection* _tmp43_;
	ViewCollection* _tmp48_;
	g_return_if_fail (IS_FACE (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	_tmp0_ = face_location_get_photo_ids_by_face (self);
	photo_id_list = _tmp0_;
	added_photos = NULL;
	if (added != NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (added_photos);
		added_photos = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
		{
			GeeIterator* _view_it = NULL;
			GeeIterator* _tmp2_;
			_tmp2_ = gee_iterable_iterator (added);
			_view_it = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				DataView* view = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				Photo* photo = NULL;
				DataView* _tmp6_;
				DataSource* _tmp7_;
				GeeSet* _tmp8_;
				gboolean is_added = FALSE;
				GeeCollection* _tmp12_;
				Photo* _tmp13_;
				_tmp3_ = _view_it;
				if (!gee_iterator_next (_tmp3_)) {
					break;
				}
				_tmp4_ = _view_it;
				_tmp5_ = gee_iterator_get (_tmp4_);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				_tmp7_ = data_view_get_source (_tmp6_);
				photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO, Photo);
				_tmp8_ = photo_id_list;
				if (_tmp8_ != NULL) {
					GeeSet* _tmp9_;
					Photo* _tmp10_;
					PhotoID _tmp11_ = {0};
					_tmp9_ = photo_id_list;
					_tmp10_ = photo;
					photo_get_photo_id (_tmp10_, &_tmp11_);
					_vala_assert (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp11_), "!photo_id_list.contains(photo.get_photo_id())");
				}
				_tmp12_ = added_photos;
				_tmp13_ = photo;
				is_added = gee_collection_add (_tmp12_, _tmp13_);
				_vala_assert (is_added, "is_added");
				_g_object_unref0 (photo);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
	}
	removed_photos = NULL;
	if (removed != NULL) {
		GeeSet* _tmp14_;
		GeeArrayList* _tmp15_;
		_tmp14_ = photo_id_list;
		_vala_assert (_tmp14_ != NULL, "photo_id_list != null");
		_tmp15_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (removed_photos);
		removed_photos = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection);
		{
			GeeIterator* _view_it = NULL;
			GeeIterator* _tmp16_;
			_tmp16_ = gee_iterable_iterator (removed);
			_view_it = _tmp16_;
			while (TRUE) {
				GeeIterator* _tmp17_;
				DataView* view = NULL;
				GeeIterator* _tmp18_;
				gpointer _tmp19_;
				Photo* photo = NULL;
				DataView* _tmp20_;
				DataSource* _tmp21_;
				GeeSet* _tmp22_;
				Photo* _tmp23_;
				PhotoID _tmp24_ = {0};
				gboolean is_added = FALSE;
				GeeCollection* _tmp25_;
				Photo* _tmp26_;
				_tmp17_ = _view_it;
				if (!gee_iterator_next (_tmp17_)) {
					break;
				}
				_tmp18_ = _view_it;
				_tmp19_ = gee_iterator_get (_tmp18_);
				view = (DataView*) _tmp19_;
				_tmp20_ = view;
				_tmp21_ = data_view_get_source (_tmp20_);
				photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_PHOTO, Photo);
				_tmp22_ = photo_id_list;
				_tmp23_ = photo;
				photo_get_photo_id (_tmp23_, &_tmp24_);
				_vala_assert (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp24_), "photo_id_list.contains(photo.get_photo_id())");
				_tmp25_ = removed_photos;
				_tmp26_ = photo;
				is_added = gee_collection_add (_tmp25_, _tmp26_);
				_vala_assert (is_added, "is_added");
				_g_object_unref0 (photo);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
	}
	_tmp27_ = removed_photos;
	if (_tmp27_ != NULL) {
		{
			GeeIterator* _photo_it = NULL;
			GeeCollection* _tmp28_;
			GeeIterator* _tmp29_;
			_tmp28_ = removed_photos;
			_tmp29_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ITERABLE, GeeIterable));
			_photo_it = _tmp29_;
			while (TRUE) {
				GeeIterator* _tmp30_;
				Photo* photo = NULL;
				GeeIterator* _tmp31_;
				gpointer _tmp32_;
				FaceID _tmp33_ = {0};
				Photo* _tmp34_;
				PhotoID _tmp35_ = {0};
				_tmp30_ = _photo_it;
				if (!gee_iterator_next (_tmp30_)) {
					break;
				}
				_tmp31_ = _photo_it;
				_tmp32_ = gee_iterator_get (_tmp31_);
				photo = (Photo*) _tmp32_;
				face_get_face_id (self, &_tmp33_);
				_tmp34_ = photo;
				photo_get_photo_id (_tmp34_, &_tmp35_);
				face_location_destroy (&_tmp33_, &_tmp35_);
				_g_object_unref0 (photo);
			}
			_g_object_unref0 (_photo_it);
		}
	}
	_tmp36_ = added_photos;
	if (_tmp36_ != NULL) {
		FaceSourceCollection* _tmp37_;
		GeeCollection* _tmp38_;
		_tmp37_ = face_global;
		_tmp38_ = added_photos;
		container_source_collection_notify_container_contents_added (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp38_, self->priv->relinking);
	}
	_tmp39_ = removed_photos;
	if (_tmp39_ != NULL) {
		FaceSourceCollection* _tmp40_;
		GeeCollection* _tmp41_;
		_tmp40_ = face_global;
		_tmp41_ = removed_photos;
		container_source_collection_notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp41_, self->priv->unlinking);
	}
	_tmp43_ = added_photos;
	if (_tmp43_ != NULL) {
		_tmp42_ = TRUE;
	} else {
		GeeCollection* _tmp44_;
		_tmp44_ = removed_photos;
		_tmp42_ = _tmp44_ != NULL;
	}
	if (_tmp42_) {
		FaceSourceCollection* _tmp45_;
		GeeCollection* _tmp46_;
		GeeCollection* _tmp47_;
		_tmp45_ = face_global;
		_tmp46_ = added_photos;
		_tmp47_ = removed_photos;
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), _tmp46_, self->priv->relinking, _tmp47_, self->priv->unlinking);
	}
	_tmp48_ = self->priv->media_views;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_DATA_COLLECTION, DataCollection)) == 0) {
		FaceSourceCollection* _tmp49_;
		_tmp49_ = face_global;
		container_source_collection_evaporate (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource));
	}
	_g_object_unref0 (removed_photos);
	_g_object_unref0 (added_photos);
	_g_object_unref0 (photo_id_list);
}

static void
face_on_sources_destroyed (Face* self,
                           GeeCollection* sources)
{
	g_return_if_fail (IS_FACE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	face_detach_many (self, G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_COLLECTION, GeeCollection));
}

static void
face_real_destroy (DataSource* base)
{
	Face * self;
	ViewCollection* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE, Face);
	_tmp0_ = self->priv->media_views;
	if (data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection)) > 0) {
		ViewCollection* _tmp1_;
		guint _tmp2_;
		GeeArrayList* removed = NULL;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		ViewCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		ViewCollection* _tmp8_;
		FaceSourceCollection* _tmp9_;
		GeeArrayList* _tmp10_;
		FaceSourceCollection* _tmp11_;
		GeeArrayList* _tmp12_;
		ViewCollection* _tmp13_;
		_tmp1_ = self->priv->media_views;
		g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _face_on_media_views_contents_altered_data_collection_contents_altered, self);
		_tmp3_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		removed = _tmp3_;
		_tmp4_ = removed;
		_tmp5_ = self->priv->media_views;
		_tmp6_ = view_collection_get_sources (_tmp5_);
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
		gee_array_list_add_all (_tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = self->priv->media_views;
		data_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection));
		_tmp9_ = face_global;
		_tmp10_ = removed;
		container_source_collection_notify_container_contents_removed (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
		_tmp11_ = face_global;
		_tmp12_ = removed;
		container_source_collection_notify_container_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONTAINER_SOURCE, ContainerSource), NULL, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), FALSE);
		_tmp13_ = self->priv->media_views;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _face_on_media_views_contents_altered_data_collection_contents_altered, self, 0);
		_g_object_unref0 (removed);
	}
	{
		FaceTable* _tmp14_;
		FaceTable* _tmp15_;
		FaceRow* _tmp16_;
		FaceID _tmp17_;
		_tmp14_ = face_table_get_instance ();
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->row;
		_tmp17_ = _tmp16_->face_id;
		face_table_remove (_tmp15_, &_tmp17_, &_inner_error0_);
		_database_table_unref0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = err;
		app_window_database_error (_tmp18_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (face_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
}

static inline gpointer
face_face_snapshot_get_instance_private (FaceFaceSnapshot* self)
{
	return G_STRUCT_MEMBER_P (self, FaceFaceSnapshot_private_offset);
}

static void
_face_face_snapshot_on_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                          DataSource* source,
                                                                          gpointer self)
{
	face_face_snapshot_on_source_destroyed ((FaceFaceSnapshot*) self, source);
}

static FaceFaceSnapshot*
face_face_snapshot_construct (GType object_type,
                              Face* face)
{
	FaceFaceSnapshot* self = NULL;
	FaceRow* _tmp0_;
	FaceRow* _tmp1_;
	LibraryPhotoSourceCollection* _tmp11_;
	g_return_val_if_fail (IS_FACE (face), NULL);
	self = (FaceFaceSnapshot*) source_snapshot_construct (object_type);
	_tmp0_ = face->priv->row;
	_tmp1_ = _face_row_ref0 (_tmp0_);
	_face_row_unref0 (self->priv->row);
	self->priv->row = _tmp1_;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp2_ = face_get_sources (face);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_source_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			MediaSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeHashSet* _tmp9_;
			MediaSource* _tmp10_;
			_tmp6_ = _source_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _source_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			source = (MediaSource*) _tmp8_;
			_tmp9_ = self->priv->sources;
			_tmp10_ = source;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp11_ = library_photo_global;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SOURCE_COLLECTION, SourceCollection), "item-destroyed", (GCallback) _face_face_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
	return self;
}

static FaceFaceSnapshot*
face_face_snapshot_new (Face* face)
{
	return face_face_snapshot_construct (FACE_TYPE_FACE_SNAPSHOT, face);
}

static FaceRow*
face_face_snapshot_get_row (FaceFaceSnapshot* self)
{
	FaceRow* _tmp0_;
	FaceRow* _tmp1_;
	FaceRow* result;
	g_return_val_if_fail (FACE_IS_FACE_SNAPSHOT (self), NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _face_row_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
face_face_snapshot_real_notify_broken (SourceSnapshot* base)
{
	FaceFaceSnapshot * self;
	FaceRow* _tmp0_;
	GeeHashSet* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshot);
	_tmp0_ = face_row_new ();
	_face_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	_tmp1_ = self->priv->sources;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	SOURCE_SNAPSHOT_CLASS (face_face_snapshot_parent_class)->notify_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_SNAPSHOT, SourceSnapshot));
}

static void
face_face_snapshot_on_source_destroyed (FaceFaceSnapshot* self,
                                        DataSource* source)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (FACE_IS_FACE_SNAPSHOT (self));
	g_return_if_fail (IS_DATA_SOURCE (source));
	_tmp0_ = self->priv->sources;
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_MEDIA_SOURCE, MediaSource))) {
		source_snapshot_notify_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_SNAPSHOT, SourceSnapshot));
	}
}

static void
face_face_snapshot_class_init (FaceFaceSnapshotClass * klass,
                               gpointer klass_data)
{
	face_face_snapshot_parent_class = g_type_class_peek_parent (klass);
	((SourceSnapshotClass *) klass)->finalize = face_face_snapshot_finalize;
	g_type_class_adjust_private_offset (klass, &FaceFaceSnapshot_private_offset);
	((SourceSnapshotClass *) klass)->notify_broken = (void (*) (SourceSnapshot*)) face_face_snapshot_real_notify_broken;
}

static void
face_face_snapshot_instance_init (FaceFaceSnapshot * self,
                                  gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = face_face_snapshot_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->sources = _tmp0_;
}

static void
face_face_snapshot_finalize (SourceSnapshot * obj)
{
	FaceFaceSnapshot * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshot);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _face_face_snapshot_on_source_destroyed_source_collection_item_destroyed, self);
	_face_row_unref0 (self->priv->row);
	_g_object_unref0 (self->priv->sources);
	SOURCE_SNAPSHOT_CLASS (face_face_snapshot_parent_class)->finalize (obj);
}

static GType
face_face_snapshot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceFaceSnapshotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_face_snapshot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceFaceSnapshot), 0, (GInstanceInitFunc) face_face_snapshot_instance_init, NULL };
	GType face_face_snapshot_type_id;
	face_face_snapshot_type_id = g_type_register_static (TYPE_SOURCE_SNAPSHOT, "FaceFaceSnapshot", &g_define_type_info, 0);
	FaceFaceSnapshot_private_offset = g_type_add_instance_private (face_face_snapshot_type_id, sizeof (FaceFaceSnapshotPrivate));
	return face_face_snapshot_type_id;
}

static GType
face_face_snapshot_get_type (void)
{
	static volatile gsize face_face_snapshot_type_id__once = 0;
	if (g_once_init_enter (&face_face_snapshot_type_id__once)) {
		GType face_face_snapshot_type_id;
		face_face_snapshot_type_id = face_face_snapshot_get_type_once ();
		g_once_init_leave (&face_face_snapshot_type_id__once, face_face_snapshot_type_id);
	}
	return face_face_snapshot_type_id__once;
}

static FaceFaceProxy*
face_face_proxy_construct (GType object_type,
                           Face* face)
{
	FaceFaceProxy* self = NULL;
	g_return_val_if_fail (IS_FACE (face), NULL);
	self = (FaceFaceProxy*) source_proxy_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (face, TYPE_DATA_SOURCE, DataSource));
	return self;
}

static FaceFaceProxy*
face_face_proxy_new (Face* face)
{
	return face_face_proxy_construct (FACE_TYPE_FACE_PROXY, face);
}

static DataSource*
face_face_proxy_real_reconstitute (SourceProxy* base,
                                   gint64 object_id,
                                   SourceSnapshot* snapshot)
{
	FaceFaceProxy * self;
	FaceRow* _tmp0_;
	FaceRow* _tmp1_;
	Face* _tmp2_;
	DataSource* _tmp3_;
	DataSource* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, FACE_TYPE_FACE_PROXY, FaceFaceProxy);
	g_return_val_if_fail (IS_SOURCE_SNAPSHOT (snapshot), NULL);
	_tmp0_ = face_face_snapshot_get_row (G_TYPE_CHECK_INSTANCE_CAST (snapshot, FACE_TYPE_FACE_SNAPSHOT, FaceFaceSnapshot));
	_tmp1_ = _tmp0_;
	_tmp2_ = face_reconstitute (object_id, _tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_SOURCE, DataSource);
	_face_row_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
face_face_proxy_class_init (FaceFaceProxyClass * klass,
                            gpointer klass_data)
{
	face_face_proxy_parent_class = g_type_class_peek_parent (klass);
	((SourceProxyClass *) klass)->reconstitute = (DataSource* (*) (SourceProxy*, gint64, SourceSnapshot*)) face_face_proxy_real_reconstitute;
}

static void
face_face_proxy_instance_init (FaceFaceProxy * self,
                               gpointer klass)
{
}

static GType
face_face_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceFaceProxyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_face_proxy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceFaceProxy), 0, (GInstanceInitFunc) face_face_proxy_instance_init, NULL };
	GType face_face_proxy_type_id;
	face_face_proxy_type_id = g_type_register_static (TYPE_SOURCE_PROXY, "FaceFaceProxy", &g_define_type_info, 0);
	return face_face_proxy_type_id;
}

static GType
face_face_proxy_get_type (void)
{
	static volatile gsize face_face_proxy_type_id__once = 0;
	if (g_once_init_enter (&face_face_proxy_type_id__once)) {
		GType face_face_proxy_type_id;
		face_face_proxy_type_id = face_face_proxy_get_type_once ();
		g_once_init_leave (&face_face_proxy_type_id__once, face_face_proxy_type_id);
	}
	return face_face_proxy_type_id__once;
}

static void
face_class_init (FaceClass * klass,
                 gpointer klass_data)
{
	face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Face_private_offset);
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) face_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) face_real_get_instance_id;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) face_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) face_real_to_string;
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource*, DataSource*)) face_real_equals;
	((DataSourceClass *) klass)->save_snapshot = (SourceSnapshot* (*) (DataSource*)) face_real_save_snapshot;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) face_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = face_finalize;
}

static void
face_container_source_interface_init (ContainerSourceIface * iface,
                                      gpointer iface_data)
{
	face_container_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_links = (gboolean (*) (ContainerSource*)) face_real_has_links;
	iface->get_backlink = (SourceBacklink* (*) (ContainerSource*)) face_real_get_backlink;
	iface->break_link = (void (*) (ContainerSource*, DataSource*)) face_real_break_link;
	iface->break_link_many = (void (*) (ContainerSource*, GeeCollection*)) face_real_break_link_many;
	iface->establish_link = (void (*) (ContainerSource*, DataSource*)) face_real_establish_link;
	iface->establish_link_many = (void (*) (ContainerSource*, GeeCollection*)) face_real_establish_link_many;
}

static void
face_proxyable_interface_init (ProxyableIface * iface,
                               gpointer iface_data)
{
	face_proxyable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_proxy = (SourceProxy* (*) (Proxyable*)) face_real_get_proxy;
}

static void
face_indexable_interface_init (IndexableIface * iface,
                               gpointer iface_data)
{
	face_indexable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_indexable_keywords = (const gchar* (*) (Indexable*)) face_real_get_indexable_keywords;
}

static void
face_instance_init (Face * self,
                    gpointer klass)
{
	self->priv = face_get_instance_private (self);
	self->priv->name_collation_key = NULL;
	self->priv->unlinking = FALSE;
	self->priv->relinking = FALSE;
	self->priv->indexable_keywords = NULL;
}

static void
face_finalize (GObject * obj)
{
	Face * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	LibraryPhotoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE, Face);
	_tmp0_ = self->priv->media_views;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _face_on_media_views_contents_altered_data_collection_contents_altered, self);
	_tmp2_ = library_photo_global;
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _face_on_sources_destroyed_source_collection_items_destroyed, self);
	_face_row_unref0 (self->priv->row);
	_data_collection_unref0 (self->priv->media_views);
	_g_free0 (self->priv->name_collation_key);
	_g_free0 (self->priv->indexable_keywords);
	G_OBJECT_CLASS (face_parent_class)->finalize (obj);
}

static GType
face_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Face), 0, (GInstanceInitFunc) face_instance_init, NULL };
	static const GInterfaceInfo container_source_info = { (GInterfaceInitFunc) face_container_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo proxyable_info = { (GInterfaceInitFunc) face_proxyable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) face_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType face_type_id;
	face_type_id = g_type_register_static (TYPE_DATA_SOURCE, "Face", &g_define_type_info, 0);
	g_type_add_interface_static (face_type_id, TYPE_CONTAINER_SOURCE, &container_source_info);
	g_type_add_interface_static (face_type_id, TYPE_PROXYABLE, &proxyable_info);
	g_type_add_interface_static (face_type_id, TYPE_INDEXABLE, &indexable_info);
	Face_private_offset = g_type_add_instance_private (face_type_id, sizeof (FacePrivate));
	return face_type_id;
}

GType
face_get_type (void)
{
	static volatile gsize face_type_id__once = 0;
	if (g_once_init_enter (&face_type_id__once)) {
		GType face_type_id;
		face_type_id = face_get_type_once ();
		g_once_init_leave (&face_type_id__once, face_type_id);
	}
	return face_type_id__once;
}

