/* SavedSearchDBTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SavedSearchDBTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>

#define SAVED_SEARCH_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SAVED_SEARCH_ID (saved_search_id_get_type ())
typedef struct _SavedSearchID SavedSearchID;

#define TYPE_SAVED_SEARCH_ROW (saved_search_row_get_type ())
#define SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRow))
#define SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))
#define IS_SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_ROW))
#define IS_SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_ROW))
#define SAVED_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))

typedef struct _SavedSearchRow SavedSearchRow;
typedef struct _SavedSearchRowClass SavedSearchRowClass;
typedef struct _SavedSearchRowPrivate SavedSearchRowPrivate;
typedef enum  {
	SEARCH_OPERATOR_ANY = 0,
	SEARCH_OPERATOR_ALL,
	SEARCH_OPERATOR_NONE
} SearchOperator;

#define TYPE_SEARCH_OPERATOR (search_operator_get_type ())

#define TYPE_SEARCH_CONDITION (search_condition_get_type ())
#define SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION, SearchCondition))
#define SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION, SearchConditionClass))
#define IS_SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION))
#define IS_SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION))
#define SEARCH_CONDITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION, SearchConditionClass))

typedef struct _SearchCondition SearchCondition;
typedef struct _SearchConditionClass SearchConditionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecSavedSearchRow ParamSpecSavedSearchRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_SAVED_SEARCH_DB_TABLE (saved_search_db_table_get_type ())
#define SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable))
#define SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))
#define IS_SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_DB_TABLE))
#define IS_SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_DB_TABLE))
#define SAVED_SEARCH_DB_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))

typedef struct _SavedSearchDBTable SavedSearchDBTable;
typedef struct _SavedSearchDBTableClass SavedSearchDBTableClass;
typedef struct _SavedSearchDBTablePrivate SavedSearchDBTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))

#define TYPE_SEARCH_CONDITION_TEXT (search_condition_text_get_type ())
#define SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionText))
#define SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))
#define IS_SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_TEXT))
#define IS_SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_TEXT))
#define SEARCH_CONDITION_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))

typedef struct _SearchConditionText SearchConditionText;
typedef struct _SearchConditionTextClass SearchConditionTextClass;
typedef enum  {
	SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT = 0,
	SEARCH_CONDITION_SEARCH_TYPE_TITLE,
	SEARCH_CONDITION_SEARCH_TYPE_TAG,
	SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FACE,
	SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE,
	SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_RATING,
	SEARCH_CONDITION_SEARCH_TYPE_COMMENT,
	SEARCH_CONDITION_SEARCH_TYPE_DATE
} SearchConditionSearchType;

#define SEARCH_CONDITION_TYPE_SEARCH_TYPE (search_condition_search_type_get_type ())
typedef enum  {
	SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS = 0,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY,
	SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_SET
} SearchConditionTextContext;

#define SEARCH_CONDITION_TEXT_TYPE_CONTEXT (search_condition_text_context_get_type ())

#define TYPE_SEARCH_CONDITION_MEDIA_TYPE (search_condition_media_type_get_type ())
#define SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType))
#define SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))
#define IS_SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define IS_SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define SEARCH_CONDITION_MEDIA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))

typedef struct _SearchConditionMediaType SearchConditionMediaType;
typedef struct _SearchConditionMediaTypeClass SearchConditionMediaTypeClass;
typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS = 0,
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT
} SearchConditionMediaTypeContext;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_CONTEXT (search_condition_media_type_context_get_type ())
typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL = 0,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO
} SearchConditionMediaTypeMediaType;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_MEDIA_TYPE (search_condition_media_type_media_type_get_type ())

#define TYPE_SEARCH_CONDITION_FLAGGED (search_condition_flagged_get_type ())
#define SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged))
#define SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))
#define IS_SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_FLAGGED))
#define IS_SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_FLAGGED))
#define SEARCH_CONDITION_FLAGGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))

typedef struct _SearchConditionFlagged SearchConditionFlagged;
typedef struct _SearchConditionFlaggedClass SearchConditionFlaggedClass;
typedef enum  {
	SEARCH_CONDITION_FLAGGED_STATE_FLAGGED = 0,
	SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED
} SearchConditionFlaggedState;

#define SEARCH_CONDITION_FLAGGED_TYPE_STATE (search_condition_flagged_state_get_type ())

#define TYPE_SEARCH_CONDITION_MODIFIED (search_condition_modified_get_type ())
#define SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified))
#define SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))
#define IS_SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MODIFIED))
#define IS_SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MODIFIED))
#define SEARCH_CONDITION_MODIFIED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))

typedef struct _SearchConditionModified SearchConditionModified;
typedef struct _SearchConditionModifiedClass SearchConditionModifiedClass;
typedef enum  {
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS = 0,
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO
} SearchConditionModifiedContext;

#define SEARCH_CONDITION_MODIFIED_TYPE_CONTEXT (search_condition_modified_context_get_type ())
typedef enum  {
	SEARCH_CONDITION_MODIFIED_STATE_MODIFIED = 0,
	SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES,
	SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES
} SearchConditionModifiedState;

#define SEARCH_CONDITION_MODIFIED_TYPE_STATE (search_condition_modified_state_get_type ())

#define TYPE_SEARCH_CONDITION_RATING (search_condition_rating_get_type ())
#define SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRating))
#define SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))
#define IS_SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_RATING))
#define IS_SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_RATING))
#define SEARCH_CONDITION_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))

typedef struct _SearchConditionRating SearchConditionRating;
typedef struct _SearchConditionRatingClass SearchConditionRatingClass;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER = 0,
	SEARCH_CONDITION_RATING_CONTEXT_ONLY,
	SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER
} SearchConditionRatingContext;

#define SEARCH_CONDITION_RATING_TYPE_CONTEXT (search_condition_rating_context_get_type ())

#define TYPE_SEARCH_CONDITION_DATE (search_condition_date_get_type ())
#define SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDate))
#define SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))
#define IS_SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_DATE))
#define IS_SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_DATE))
#define SEARCH_CONDITION_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))

typedef struct _SearchConditionDate SearchConditionDate;
typedef struct _SearchConditionDateClass SearchConditionDateClass;
typedef enum  {
	SEARCH_CONDITION_DATE_CONTEXT_EXACT = 0,
	SEARCH_CONDITION_DATE_CONTEXT_AFTER,
	SEARCH_CONDITION_DATE_CONTEXT_BEFORE,
	SEARCH_CONDITION_DATE_CONTEXT_BETWEEN,
	SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET
} SearchConditionDateContext;

#define SEARCH_CONDITION_DATE_TYPE_CONTEXT (search_condition_date_context_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SavedSearchID {
	gint64 id;
};

struct _SavedSearchRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchRowPrivate * priv;
	SavedSearchID search_id;
	gchar* name;
	SearchOperator operator;
	GeeList* conditions;
};

struct _SavedSearchRowClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchRow *self);
};

struct _ParamSpecSavedSearchRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _SavedSearchDBTable {
	DatabaseTable parent_instance;
	SavedSearchDBTablePrivate * priv;
};

struct _SavedSearchDBTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer saved_search_row_parent_class = NULL;
static gpointer saved_search_db_table_parent_class = NULL;
static SavedSearchDBTable* saved_search_db_table_instance;
static SavedSearchDBTable* saved_search_db_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN GType saved_search_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SavedSearchID* saved_search_id_dup (const SavedSearchID* self);
VALA_EXTERN void saved_search_id_free (SavedSearchID* self);
VALA_EXTERN void saved_search_id_init (SavedSearchID *self,
                           gint64 id);
VALA_EXTERN gboolean saved_search_id_is_invalid (SavedSearchID *self);
VALA_EXTERN gboolean saved_search_id_is_valid (SavedSearchID *self);
VALA_EXTERN gpointer saved_search_row_ref (gpointer instance);
VALA_EXTERN void saved_search_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_saved_search_row (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_saved_search_row (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_saved_search_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_saved_search_row (const GValue* value);
VALA_EXTERN GType saved_search_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearchRow, saved_search_row_unref)
VALA_EXTERN GType search_operator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer search_condition_ref (gpointer instance);
VALA_EXTERN void search_condition_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_search_condition (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_search_condition (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_search_condition (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_search_condition (const GValue* value);
VALA_EXTERN GType search_condition_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchCondition, search_condition_unref)
VALA_EXTERN SavedSearchRow* saved_search_row_new (void);
VALA_EXTERN SavedSearchRow* saved_search_row_construct (GType object_type);
static void saved_search_row_finalize (SavedSearchRow * obj);
static GType saved_search_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType saved_search_db_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearchDBTable, database_table_unref)
static SavedSearchDBTable* saved_search_db_table_new (void);
static SavedSearchDBTable* saved_search_db_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN SavedSearchDBTable* saved_search_db_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self,
                                           const gchar* name,
                                           SearchOperator operator,
                                           GeeArrayList* conditions,
                                           GError** error);
VALA_EXTERN gchar* search_operator_to_string (SearchOperator self);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
static void saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                          SavedSearchID* id,
                                          SearchCondition* condition,
                                          GError** error);
VALA_EXTERN GType search_condition_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionText, search_condition_unref)
VALA_EXTERN GType search_condition_search_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionSearchType search_condition_get_search_type (SearchCondition* self);
VALA_EXTERN gchar* search_condition_search_type_to_string (SearchConditionSearchType self);
VALA_EXTERN GType search_condition_text_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self);
VALA_EXTERN gchar* search_condition_text_context_to_string (SearchConditionTextContext self);
VALA_EXTERN const gchar* search_condition_text_get_text (SearchConditionText* self);
VALA_EXTERN GType search_condition_media_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionMediaType, search_condition_unref)
VALA_EXTERN GType search_condition_media_type_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self);
VALA_EXTERN gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self);
VALA_EXTERN GType search_condition_media_type_media_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self);
VALA_EXTERN gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self);
VALA_EXTERN GType search_condition_flagged_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionFlagged, search_condition_unref)
VALA_EXTERN GType search_condition_flagged_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self);
VALA_EXTERN gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self);
VALA_EXTERN GType search_condition_modified_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionModified, search_condition_unref)
VALA_EXTERN GType search_condition_modified_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self);
VALA_EXTERN gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self);
VALA_EXTERN GType search_condition_modified_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self);
VALA_EXTERN gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self);
VALA_EXTERN GType search_condition_rating_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionRating, search_condition_unref)
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Rating search_condition_rating_get_rating (SearchConditionRating* self);
VALA_EXTERN gint rating_serialize (Rating self);
VALA_EXTERN GType search_condition_rating_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self);
VALA_EXTERN gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self);
VALA_EXTERN GType search_condition_date_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionDate, search_condition_unref)
VALA_EXTERN GType search_condition_date_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self);
VALA_EXTERN gchar* search_condition_date_context_to_string (SearchConditionDateContext self);
VALA_EXTERN GDateTime* search_condition_date_get_date_one (SearchConditionDate* self);
VALA_EXTERN GDateTime* search_condition_date_get_date_two (SearchConditionDate* self);
static void saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                            SavedSearchID* search_id,
                                                            GError** error);
static void saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                        const gchar* table_name,
                                                        SavedSearchID* search_id,
                                                        GError** error);
static GeeList* saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                                      SavedSearchID* search_id,
                                                      GError** error);
VALA_EXTERN SearchConditionSearchType search_condition_search_type_from_string (const gchar* str);
VALA_EXTERN SearchConditionTextContext search_condition_text_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type,
                                                const gchar* text,
                                                SearchConditionTextContext context);
VALA_EXTERN SearchConditionText* search_condition_text_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      const gchar* text,
                                                      SearchConditionTextContext context);
VALA_EXTERN SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str);
VALA_EXTERN SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type,
                                                           SearchConditionMediaTypeContext context,
                                                           SearchConditionMediaTypeMediaType media_type);
VALA_EXTERN SearchConditionMediaType* search_condition_media_type_construct (GType object_type,
                                                                 SearchConditionSearchType search_type,
                                                                 SearchConditionMediaTypeContext context,
                                                                 SearchConditionMediaTypeMediaType media_type);
VALA_EXTERN SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str);
VALA_EXTERN SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type,
                                                      SearchConditionFlaggedState state);
VALA_EXTERN SearchConditionFlagged* search_condition_flagged_construct (GType object_type,
                                                            SearchConditionSearchType search_type,
                                                            SearchConditionFlaggedState state);
VALA_EXTERN SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str);
VALA_EXTERN SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type,
                                                        SearchConditionModifiedContext context,
                                                        SearchConditionModifiedState state);
VALA_EXTERN SearchConditionModified* search_condition_modified_construct (GType object_type,
                                                              SearchConditionSearchType search_type,
                                                              SearchConditionModifiedContext context,
                                                              SearchConditionModifiedState state);
VALA_EXTERN Rating rating_unserialize (gint value);
VALA_EXTERN SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type,
                                                    Rating rating,
                                                    SearchConditionRatingContext context);
VALA_EXTERN SearchConditionRating* search_condition_rating_construct (GType object_type,
                                                          SearchConditionSearchType search_type,
                                                          Rating rating,
                                                          SearchConditionRatingContext context);
VALA_EXTERN SearchConditionDateContext search_condition_date_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type,
                                                SearchConditionDateContext context,
                                                GDateTime* date_one,
                                                GDateTime* date_two);
VALA_EXTERN SearchConditionDate* search_condition_date_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      SearchConditionDateContext context,
                                                      GDateTime* date_one,
                                                      GDateTime* date_two);
VALA_EXTERN void saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                            SavedSearchRow* row,
                                            SavedSearchID* result,
                                            GError** error);
VALA_EXTERN void saved_search_db_table_remove (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN SavedSearchRow* saved_search_db_table_get_row (SavedSearchDBTable* self,
                                               SavedSearchID* search_id,
                                               GError** error);
VALA_EXTERN SearchOperator search_operator_from_string (const gchar* str);
VALA_EXTERN GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                             GError** error);
VALA_EXTERN void saved_search_db_table_rename (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   const gchar* new_name,
                                   GError** error);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
static void saved_search_db_table_finalize (DatabaseTable * obj);
static GType saved_search_db_table_get_type_once (void);

void
saved_search_id_init (SavedSearchID *self,
                      gint64 id)
{
	memset (self, 0, sizeof (SavedSearchID));
	(*self).id = id;
}

gboolean
saved_search_id_is_invalid (SavedSearchID *self)
{
	gboolean result;
	result = (*self).id == SAVED_SEARCH_ID_INVALID;
	return result;
}

gboolean
saved_search_id_is_valid (SavedSearchID *self)
{
	gboolean result;
	result = (*self).id != SAVED_SEARCH_ID_INVALID;
	return result;
}

SavedSearchID*
saved_search_id_dup (const SavedSearchID* self)
{
	SavedSearchID* dup;
	dup = g_new0 (SavedSearchID, 1);
	memcpy (dup, self, sizeof (SavedSearchID));
	return dup;
}

void
saved_search_id_free (SavedSearchID* self)
{
	g_free (self);
}

static GType
saved_search_id_get_type_once (void)
{
	GType saved_search_id_type_id;
	saved_search_id_type_id = g_boxed_type_register_static ("SavedSearchID", (GBoxedCopyFunc) saved_search_id_dup, (GBoxedFreeFunc) saved_search_id_free);
	return saved_search_id_type_id;
}

GType
saved_search_id_get_type (void)
{
	static volatile gsize saved_search_id_type_id__once = 0;
	if (g_once_init_enter (&saved_search_id_type_id__once)) {
		GType saved_search_id_type_id;
		saved_search_id_type_id = saved_search_id_get_type_once ();
		g_once_init_leave (&saved_search_id_type_id__once, saved_search_id_type_id);
	}
	return saved_search_id_type_id__once;
}

SavedSearchRow*
saved_search_row_construct (GType object_type)
{
	SavedSearchRow* self = NULL;
	self = (SavedSearchRow*) g_type_create_instance (object_type);
	return self;
}

SavedSearchRow*
saved_search_row_new (void)
{
	return saved_search_row_construct (TYPE_SAVED_SEARCH_ROW);
}

static void
value_saved_search_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_saved_search_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		saved_search_row_unref (value->data[0].v_pointer);
	}
}

static void
value_saved_search_row_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = saved_search_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_saved_search_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_saved_search_row_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SavedSearchRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = saved_search_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_saved_search_row_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SavedSearchRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = saved_search_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_saved_search_row (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSavedSearchRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_saved_search_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_saved_search_row (GValue* value,
                            gpointer v_object)
{
	SavedSearchRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		saved_search_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_row_unref (old);
	}
}

void
value_take_saved_search_row (GValue* value,
                             gpointer v_object)
{
	SavedSearchRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_row_unref (old);
	}
}

static void
saved_search_row_class_init (SavedSearchRowClass * klass,
                             gpointer klass_data)
{
	saved_search_row_parent_class = g_type_class_peek_parent (klass);
	((SavedSearchRowClass *) klass)->finalize = saved_search_row_finalize;
}

static void
saved_search_row_instance_init (SavedSearchRow * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
saved_search_row_finalize (SavedSearchRow * obj)
{
	SavedSearchRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_ROW, SavedSearchRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_object_unref0 (self->conditions);
}

static GType
saved_search_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_saved_search_row_init, value_saved_search_row_free_value, value_saved_search_row_copy_value, value_saved_search_row_peek_pointer, "p", value_saved_search_row_collect_value, "p", value_saved_search_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchRow), 0, (GInstanceInitFunc) saved_search_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType saved_search_row_type_id;
	saved_search_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return saved_search_row_type_id;
}

GType
saved_search_row_get_type (void)
{
	static volatile gsize saved_search_row_type_id__once = 0;
	if (g_once_init_enter (&saved_search_row_type_id__once)) {
		GType saved_search_row_type_id;
		saved_search_row_type_id = saved_search_row_get_type_once ();
		g_once_init_leave (&saved_search_row_type_id__once, saved_search_row_type_id);
	}
	return saved_search_row_type_id__once;
}

gpointer
saved_search_row_ref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
saved_search_row_unref (gpointer instance)
{
	SavedSearchRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SAVED_SEARCH_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static SavedSearchDBTable*
saved_search_db_table_construct (GType object_type)
{
	SavedSearchDBTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	sqlite3* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	sqlite3* _tmp12_;
	sqlite3_stmt* _tmp13_ = NULL;
	gint _tmp14_;
	sqlite3_stmt* _tmp15_;
	sqlite3* _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3* _tmp20_;
	sqlite3_stmt* _tmp21_ = NULL;
	gint _tmp22_;
	sqlite3_stmt* _tmp23_;
	sqlite3* _tmp24_;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_;
	sqlite3_stmt* _tmp27_;
	sqlite3* _tmp28_;
	sqlite3_stmt* _tmp29_ = NULL;
	gint _tmp30_;
	sqlite3_stmt* _tmp31_;
	sqlite3* _tmp32_;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_;
	sqlite3_stmt* _tmp35_;
	sqlite3* _tmp36_;
	sqlite3_stmt* _tmp37_ = NULL;
	gint _tmp38_;
	sqlite3_stmt* _tmp39_;
	sqlite3* _tmp40_;
	sqlite3_stmt* _tmp41_ = NULL;
	gint _tmp42_;
	sqlite3_stmt* _tmp43_;
	sqlite3* _tmp44_;
	sqlite3_stmt* _tmp45_ = NULL;
	gint _tmp46_;
	sqlite3_stmt* _tmp47_;
	sqlite3* _tmp48_;
	sqlite3_stmt* _tmp49_ = NULL;
	gint _tmp50_;
	sqlite3_stmt* _tmp51_;
	self = (SavedSearchDBTable*) database_table_construct (object_type);
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "SavedSearchDBTable");
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable " "(" "id INTEGER PRIMARY KEY, " "name TEXT UNIQUE NOT NULL, " "operator TEXT NOT NULL" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable", res);
	}
	_tmp4_ = database_table_db;
	_tmp6_ = sqlite3_prepare_v2 (_tmp4_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Text " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "text TEXT" ")", -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp5_;
	res = _tmp6_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Text", res);
	}
	_tmp8_ = database_table_db;
	_tmp10_ = sqlite3_prepare_v2 (_tmp8_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_MediaType " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "type TEXT NOT_NULL" ")", -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	res = _tmp10_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp11_ = stmt;
	res = sqlite3_step (_tmp11_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_MediaType", res);
	}
	_tmp12_ = database_table_db;
	_tmp14_ = sqlite3_prepare_v2 (_tmp12_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Flagged " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "flag_state TEXT NOT NULL" ")", -1, &_tmp13_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp13_;
	res = _tmp14_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp15_ = stmt;
	res = sqlite3_step (_tmp15_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Flagged", res);
	}
	_tmp16_ = database_table_db;
	_tmp18_ = sqlite3_prepare_v2 (_tmp16_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Modified " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "modified_state TEXT NOT NULL" ")", -1, &_tmp17_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp17_;
	res = _tmp18_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp19_ = stmt;
	res = sqlite3_step (_tmp19_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Modified", res);
	}
	_tmp20_ = database_table_db;
	_tmp22_ = sqlite3_prepare_v2 (_tmp20_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Rating " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "rating INTEGER NOT_NULL, " "context TEXT NOT NULL" ")", -1, &_tmp21_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp21_;
	res = _tmp22_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp23_ = stmt;
	res = sqlite3_step (_tmp23_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Rating", res);
	}
	_tmp24_ = database_table_db;
	_tmp26_ = sqlite3_prepare_v2 (_tmp24_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Date " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "date_one INTEGER NOT_NULL, " "date_two INTEGER NOT_NULL" ")", -1, &_tmp25_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp25_;
	res = _tmp26_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp27_ = stmt;
	res = sqlite3_step (_tmp27_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Rating", res);
	}
	_tmp28_ = database_table_db;
	_tmp30_ = sqlite3_prepare_v2 (_tmp28_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Text_Index " "ON SavedSearchDBTable_Text(search_id)", -1, &_tmp29_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp29_;
	res = _tmp30_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp31_ = stmt;
	res = sqlite3_step (_tmp31_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Text_Index", res);
	}
	_tmp32_ = database_table_db;
	_tmp34_ = sqlite3_prepare_v2 (_tmp32_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_MediaType_Index " "ON SavedSearchDBTable_MediaType(search_id)", -1, &_tmp33_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp33_;
	res = _tmp34_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp35_ = stmt;
	res = sqlite3_step (_tmp35_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_MediaType_Index", res);
	}
	_tmp36_ = database_table_db;
	_tmp38_ = sqlite3_prepare_v2 (_tmp36_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Flagged_Index " "ON SavedSearchDBTable_Flagged(search_id)", -1, &_tmp37_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp37_;
	res = _tmp38_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp39_ = stmt;
	res = sqlite3_step (_tmp39_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Flagged_Index", res);
	}
	_tmp40_ = database_table_db;
	_tmp42_ = sqlite3_prepare_v2 (_tmp40_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Modified_Index " "ON SavedSearchDBTable_Modified(search_id)", -1, &_tmp41_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp41_;
	res = _tmp42_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp43_ = stmt;
	res = sqlite3_step (_tmp43_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Modified_Index", res);
	}
	_tmp44_ = database_table_db;
	_tmp46_ = sqlite3_prepare_v2 (_tmp44_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Rating_Index " "ON SavedSearchDBTable_Rating(search_id)", -1, &_tmp45_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp45_;
	res = _tmp46_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp47_ = stmt;
	res = sqlite3_step (_tmp47_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Rating_Index", res);
	}
	_tmp48_ = database_table_db;
	_tmp50_ = sqlite3_prepare_v2 (_tmp48_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Date_Index " "ON SavedSearchDBTable_Date(search_id)", -1, &_tmp49_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp49_;
	res = _tmp50_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp51_ = stmt;
	res = sqlite3_step (_tmp51_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create SavedSearchDBTable_Date_Index", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static SavedSearchDBTable*
saved_search_db_table_new (void)
{
	return saved_search_db_table_construct (TYPE_SAVED_SEARCH_DB_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

SavedSearchDBTable*
saved_search_db_table_get_instance (void)
{
	SavedSearchDBTable* _tmp0_;
	SavedSearchDBTable* _tmp2_;
	SavedSearchDBTable* _tmp3_;
	SavedSearchDBTable* result;
	_tmp0_ = saved_search_db_table_instance;
	if (_tmp0_ == NULL) {
		SavedSearchDBTable* _tmp1_;
		_tmp1_ = saved_search_db_table_new ();
		_database_table_unref0 (saved_search_db_table_instance);
		saved_search_db_table_instance = _tmp1_;
	}
	_tmp2_ = saved_search_db_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SavedSearchRow*
saved_search_db_table_add (SavedSearchDBTable* self,
                           const gchar* name,
                           SearchOperator operator,
                           GeeArrayList* conditions,
                           GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	sqlite3_stmt* _tmp9_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp10_;
	SavedSearchRow* _tmp11_;
	sqlite3* _tmp12_;
	SavedSearchRow* _tmp13_;
	gchar* _tmp14_;
	SavedSearchRow* _tmp15_;
	SavedSearchRow* _tmp16_;
	GeeList* _tmp17_;
	GError* _inner_error0_ = NULL;
	SavedSearchRow* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conditions, GEE_TYPE_ARRAY_LIST), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = g_strdup (name);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	_tmp7_ = search_operator_to_string (operator);
	_tmp8_ = g_free;
	res = sqlite3_bind_text (_tmp6_, 2, _tmp7_, -1, _tmp8_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp9_ = stmt;
	res = sqlite3_step (_tmp9_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("SavedSearchDBTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp10_ = saved_search_row_new ();
	row = _tmp10_;
	_tmp11_ = row;
	_tmp12_ = database_table_db;
	saved_search_id_init (&_tmp11_->search_id, sqlite3_last_insert_rowid (_tmp12_));
	_tmp13_ = row;
	_tmp14_ = g_strdup (name);
	_g_free0 (_tmp13_->name);
	_tmp13_->name = _tmp14_;
	_tmp15_ = row;
	_tmp15_->operator = operator;
	_tmp16_ = row;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (conditions, GEE_TYPE_LIST, GeeList));
	_g_object_unref0 (_tmp16_->conditions);
	_tmp16_->conditions = _tmp17_;
	{
		GeeArrayList* _sc_list = NULL;
		gint _sc_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _sc_index = 0;
		_sc_list = conditions;
		_tmp18_ = _sc_list;
		_tmp19_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp20_ = _tmp19_;
		_sc_size = _tmp20_;
		_sc_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			SearchCondition* sc = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			SavedSearchRow* _tmp25_;
			SavedSearchID _tmp26_;
			SearchCondition* _tmp27_;
			_sc_index = _sc_index + 1;
			_tmp21_ = _sc_index;
			_tmp22_ = _sc_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _sc_list;
			_tmp24_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _sc_index);
			sc = (SearchCondition*) _tmp24_;
			_tmp25_ = row;
			_tmp26_ = _tmp25_->search_id;
			_tmp27_ = sc;
			saved_search_db_table_add_condition (self, &_tmp26_, _tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_search_condition_unref0 (sc);
					_saved_search_row_unref0 (row);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_search_condition_unref0 (sc);
					_saved_search_row_unref0 (row);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_search_condition_unref0 (sc);
		}
	}
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

static gpointer
_search_condition_ref0 (gpointer self)
{
	return self ? search_condition_ref (self) : NULL;
}

static void
saved_search_db_table_add_condition (SavedSearchDBTable* self,
                                     SavedSearchID* id,
                                     SearchCondition* condition,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (id != NULL);
	g_return_if_fail (IS_SEARCH_CONDITION (condition));
	if (IS_SEARCH_CONDITION_TEXT (condition)) {
		SearchConditionText* text = NULL;
		SearchConditionText* _tmp0_;
		sqlite3_stmt* stmt = NULL;
		gint res = 0;
		sqlite3* _tmp1_;
		sqlite3_stmt* _tmp2_ = NULL;
		gint _tmp3_;
		sqlite3_stmt* _tmp4_;
		SavedSearchID _tmp5_;
		sqlite3_stmt* _tmp6_;
		SearchConditionText* _tmp7_;
		SearchConditionSearchType _tmp8_;
		SearchConditionSearchType _tmp9_;
		gchar* _tmp10_;
		GDestroyNotify _tmp11_;
		sqlite3_stmt* _tmp12_;
		SearchConditionText* _tmp13_;
		SearchConditionTextContext _tmp14_;
		SearchConditionTextContext _tmp15_;
		gchar* _tmp16_;
		GDestroyNotify _tmp17_;
		sqlite3_stmt* _tmp18_;
		SearchConditionText* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		GDestroyNotify _tmp23_;
		sqlite3_stmt* _tmp24_;
		_tmp0_ = _search_condition_ref0 (IS_SEARCH_CONDITION_TEXT (condition) ? ((SearchConditionText*) condition) : NULL);
		text = _tmp0_;
		_tmp1_ = database_table_db;
		_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "INSERT INTO SavedSearchDBTable_Text (search_id, search_type, context, " "text) VALUES (?, ?, ?, ?)", -1, &_tmp2_, NULL);
		_sqlite3_finalize0 (stmt);
		stmt = _tmp2_;
		res = _tmp3_;
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
		_tmp4_ = stmt;
		_tmp5_ = *id;
		res = sqlite3_bind_int64 (_tmp4_, 1, _tmp5_.id);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
		_tmp6_ = stmt;
		_tmp7_ = text;
		_tmp8_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp9_ = _tmp8_;
		_tmp10_ = search_condition_search_type_to_string (_tmp9_);
		_tmp11_ = g_free;
		res = sqlite3_bind_text (_tmp6_, 2, _tmp10_, -1, _tmp11_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
		_tmp12_ = stmt;
		_tmp13_ = text;
		_tmp14_ = search_condition_text_get_context (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = search_condition_text_context_to_string (_tmp15_);
		_tmp17_ = g_free;
		res = sqlite3_bind_text (_tmp12_, 3, _tmp16_, -1, _tmp17_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
		_tmp18_ = stmt;
		_tmp19_ = text;
		_tmp20_ = search_condition_text_get_text (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = g_free;
		res = sqlite3_bind_text (_tmp18_, 4, _tmp22_, -1, _tmp23_);
		_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
		_tmp24_ = stmt;
		res = sqlite3_step (_tmp24_);
		if (res != SQLITE_DONE) {
			database_table_throw_error ("SavedSearchDBTable_Text.add", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (text);
					return;
				} else {
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (text);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		_sqlite3_finalize0 (stmt);
		_search_condition_unref0 (text);
	} else {
		if (IS_SEARCH_CONDITION_MEDIA_TYPE (condition)) {
			SearchConditionMediaType* media_type = NULL;
			SearchConditionMediaType* _tmp25_;
			sqlite3_stmt* stmt = NULL;
			gint res = 0;
			sqlite3* _tmp26_;
			sqlite3_stmt* _tmp27_ = NULL;
			gint _tmp28_;
			sqlite3_stmt* _tmp29_;
			SavedSearchID _tmp30_;
			sqlite3_stmt* _tmp31_;
			SearchConditionMediaType* _tmp32_;
			SearchConditionSearchType _tmp33_;
			SearchConditionSearchType _tmp34_;
			gchar* _tmp35_;
			GDestroyNotify _tmp36_;
			sqlite3_stmt* _tmp37_;
			SearchConditionMediaType* _tmp38_;
			SearchConditionMediaTypeContext _tmp39_;
			SearchConditionMediaTypeContext _tmp40_;
			gchar* _tmp41_;
			GDestroyNotify _tmp42_;
			sqlite3_stmt* _tmp43_;
			SearchConditionMediaType* _tmp44_;
			SearchConditionMediaTypeMediaType _tmp45_;
			SearchConditionMediaTypeMediaType _tmp46_;
			gchar* _tmp47_;
			GDestroyNotify _tmp48_;
			sqlite3_stmt* _tmp49_;
			_tmp25_ = _search_condition_ref0 (IS_SEARCH_CONDITION_MEDIA_TYPE (condition) ? ((SearchConditionMediaType*) condition) : NULL);
			media_type = _tmp25_;
			_tmp26_ = database_table_db;
			_tmp28_ = sqlite3_prepare_v2 (_tmp26_, "INSERT INTO SavedSearchDBTable_MediaType (search_id, search_type, cont" \
"ext, " "type) VALUES (?, ?, ?, ?)", -1, &_tmp27_, NULL);
			_sqlite3_finalize0 (stmt);
			stmt = _tmp27_;
			res = _tmp28_;
			_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			_tmp29_ = stmt;
			_tmp30_ = *id;
			res = sqlite3_bind_int64 (_tmp29_, 1, _tmp30_.id);
			_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			_tmp31_ = stmt;
			_tmp32_ = media_type;
			_tmp33_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_SEARCH_CONDITION, SearchCondition));
			_tmp34_ = _tmp33_;
			_tmp35_ = search_condition_search_type_to_string (_tmp34_);
			_tmp36_ = g_free;
			res = sqlite3_bind_text (_tmp31_, 2, _tmp35_, -1, _tmp36_);
			_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			_tmp37_ = stmt;
			_tmp38_ = media_type;
			_tmp39_ = search_condition_media_type_get_context (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = search_condition_media_type_context_to_string (_tmp40_);
			_tmp42_ = g_free;
			res = sqlite3_bind_text (_tmp37_, 3, _tmp41_, -1, _tmp42_);
			_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			_tmp43_ = stmt;
			_tmp44_ = media_type;
			_tmp45_ = search_condition_media_type_get_media_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = search_condition_media_type_media_type_to_string (_tmp46_);
			_tmp48_ = g_free;
			res = sqlite3_bind_text (_tmp43_, 4, _tmp47_, -1, _tmp48_);
			_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
			_tmp49_ = stmt;
			res = sqlite3_step (_tmp49_);
			if (res != SQLITE_DONE) {
				database_table_throw_error ("SavedSearchDBTable_MediaType.add", res, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (media_type);
						return;
					} else {
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (media_type);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
			_sqlite3_finalize0 (stmt);
			_search_condition_unref0 (media_type);
		} else {
			if (IS_SEARCH_CONDITION_FLAGGED (condition)) {
				SearchConditionFlagged* flag_state = NULL;
				SearchConditionFlagged* _tmp50_;
				sqlite3_stmt* stmt = NULL;
				gint res = 0;
				sqlite3* _tmp51_;
				sqlite3_stmt* _tmp52_ = NULL;
				gint _tmp53_;
				sqlite3_stmt* _tmp54_;
				SavedSearchID _tmp55_;
				sqlite3_stmt* _tmp56_;
				SearchConditionFlagged* _tmp57_;
				SearchConditionSearchType _tmp58_;
				SearchConditionSearchType _tmp59_;
				gchar* _tmp60_;
				GDestroyNotify _tmp61_;
				sqlite3_stmt* _tmp62_;
				SearchConditionFlagged* _tmp63_;
				SearchConditionFlaggedState _tmp64_;
				SearchConditionFlaggedState _tmp65_;
				gchar* _tmp66_;
				GDestroyNotify _tmp67_;
				sqlite3_stmt* _tmp68_;
				_tmp50_ = _search_condition_ref0 (IS_SEARCH_CONDITION_FLAGGED (condition) ? ((SearchConditionFlagged*) condition) : NULL);
				flag_state = _tmp50_;
				_tmp51_ = database_table_db;
				_tmp53_ = sqlite3_prepare_v2 (_tmp51_, "INSERT INTO SavedSearchDBTable_Flagged (search_id, search_type, " "flag_state) VALUES (?, ?, ?)", -1, &_tmp52_, NULL);
				_sqlite3_finalize0 (stmt);
				stmt = _tmp52_;
				res = _tmp53_;
				_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
				_tmp54_ = stmt;
				_tmp55_ = *id;
				res = sqlite3_bind_int64 (_tmp54_, 1, _tmp55_.id);
				_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
				_tmp56_ = stmt;
				_tmp57_ = flag_state;
				_tmp58_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, TYPE_SEARCH_CONDITION, SearchCondition));
				_tmp59_ = _tmp58_;
				_tmp60_ = search_condition_search_type_to_string (_tmp59_);
				_tmp61_ = g_free;
				res = sqlite3_bind_text (_tmp56_, 2, _tmp60_, -1, _tmp61_);
				_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
				_tmp62_ = stmt;
				_tmp63_ = flag_state;
				_tmp64_ = search_condition_flagged_get_state (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = search_condition_flagged_state_to_string (_tmp65_);
				_tmp67_ = g_free;
				res = sqlite3_bind_text (_tmp62_, 3, _tmp66_, -1, _tmp67_);
				_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
				_tmp68_ = stmt;
				res = sqlite3_step (_tmp68_);
				if (res != SQLITE_DONE) {
					database_table_throw_error ("SavedSearchDBTable_Flagged.add", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_search_condition_unref0 (flag_state);
							return;
						} else {
							_sqlite3_finalize0 (stmt);
							_search_condition_unref0 (flag_state);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				_sqlite3_finalize0 (stmt);
				_search_condition_unref0 (flag_state);
			} else {
				if (IS_SEARCH_CONDITION_MODIFIED (condition)) {
					SearchConditionModified* modified_state = NULL;
					SearchConditionModified* _tmp69_;
					sqlite3_stmt* stmt = NULL;
					gint res = 0;
					sqlite3* _tmp70_;
					sqlite3_stmt* _tmp71_ = NULL;
					gint _tmp72_;
					sqlite3_stmt* _tmp73_;
					SavedSearchID _tmp74_;
					sqlite3_stmt* _tmp75_;
					SearchConditionModified* _tmp76_;
					SearchConditionSearchType _tmp77_;
					SearchConditionSearchType _tmp78_;
					gchar* _tmp79_;
					GDestroyNotify _tmp80_;
					sqlite3_stmt* _tmp81_;
					SearchConditionModified* _tmp82_;
					SearchConditionModifiedContext _tmp83_;
					SearchConditionModifiedContext _tmp84_;
					gchar* _tmp85_;
					GDestroyNotify _tmp86_;
					sqlite3_stmt* _tmp87_;
					SearchConditionModified* _tmp88_;
					SearchConditionModifiedState _tmp89_;
					SearchConditionModifiedState _tmp90_;
					gchar* _tmp91_;
					GDestroyNotify _tmp92_;
					sqlite3_stmt* _tmp93_;
					_tmp69_ = _search_condition_ref0 (IS_SEARCH_CONDITION_MODIFIED (condition) ? ((SearchConditionModified*) condition) : NULL);
					modified_state = _tmp69_;
					_tmp70_ = database_table_db;
					_tmp72_ = sqlite3_prepare_v2 (_tmp70_, "INSERT INTO SavedSearchDBTable_Modified (search_id, search_type, conte" \
"xt, " "modified_state) VALUES (?, ?, ?, ?)", -1, &_tmp71_, NULL);
					_sqlite3_finalize0 (stmt);
					stmt = _tmp71_;
					res = _tmp72_;
					_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
					_tmp73_ = stmt;
					_tmp74_ = *id;
					res = sqlite3_bind_int64 (_tmp73_, 1, _tmp74_.id);
					_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
					_tmp75_ = stmt;
					_tmp76_ = modified_state;
					_tmp77_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_SEARCH_CONDITION, SearchCondition));
					_tmp78_ = _tmp77_;
					_tmp79_ = search_condition_search_type_to_string (_tmp78_);
					_tmp80_ = g_free;
					res = sqlite3_bind_text (_tmp75_, 2, _tmp79_, -1, _tmp80_);
					_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
					_tmp81_ = stmt;
					_tmp82_ = modified_state;
					_tmp83_ = search_condition_modified_get_context (_tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = search_condition_modified_context_to_string (_tmp84_);
					_tmp86_ = g_free;
					res = sqlite3_bind_text (_tmp81_, 3, _tmp85_, -1, _tmp86_);
					_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
					_tmp87_ = stmt;
					_tmp88_ = modified_state;
					_tmp89_ = search_condition_modified_get_state (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = search_condition_modified_state_to_string (_tmp90_);
					_tmp92_ = g_free;
					res = sqlite3_bind_text (_tmp87_, 4, _tmp91_, -1, _tmp92_);
					_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
					_tmp93_ = stmt;
					res = sqlite3_step (_tmp93_);
					if (res != SQLITE_DONE) {
						database_table_throw_error ("SavedSearchDBTable_Modified.add", res, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == DATABASE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_sqlite3_finalize0 (stmt);
								_search_condition_unref0 (modified_state);
								return;
							} else {
								_sqlite3_finalize0 (stmt);
								_search_condition_unref0 (modified_state);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
					}
					_sqlite3_finalize0 (stmt);
					_search_condition_unref0 (modified_state);
				} else {
					if (IS_SEARCH_CONDITION_RATING (condition)) {
						SearchConditionRating* rating = NULL;
						SearchConditionRating* _tmp94_;
						sqlite3_stmt* stmt = NULL;
						gint res = 0;
						sqlite3* _tmp95_;
						sqlite3_stmt* _tmp96_ = NULL;
						gint _tmp97_;
						sqlite3_stmt* _tmp98_;
						SavedSearchID _tmp99_;
						sqlite3_stmt* _tmp100_;
						SearchConditionRating* _tmp101_;
						SearchConditionSearchType _tmp102_;
						SearchConditionSearchType _tmp103_;
						gchar* _tmp104_;
						GDestroyNotify _tmp105_;
						sqlite3_stmt* _tmp106_;
						SearchConditionRating* _tmp107_;
						Rating _tmp108_;
						Rating _tmp109_;
						sqlite3_stmt* _tmp110_;
						SearchConditionRating* _tmp111_;
						SearchConditionRatingContext _tmp112_;
						SearchConditionRatingContext _tmp113_;
						gchar* _tmp114_;
						GDestroyNotify _tmp115_;
						sqlite3_stmt* _tmp116_;
						_tmp94_ = _search_condition_ref0 (IS_SEARCH_CONDITION_RATING (condition) ? ((SearchConditionRating*) condition) : NULL);
						rating = _tmp94_;
						_tmp95_ = database_table_db;
						_tmp97_ = sqlite3_prepare_v2 (_tmp95_, "INSERT INTO SavedSearchDBTable_Rating (search_id, search_type, rating," \
" " "context) VALUES (?, ?, ?, ?)", -1, &_tmp96_, NULL);
						_sqlite3_finalize0 (stmt);
						stmt = _tmp96_;
						res = _tmp97_;
						_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
						_tmp98_ = stmt;
						_tmp99_ = *id;
						res = sqlite3_bind_int64 (_tmp98_, 1, _tmp99_.id);
						_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
						_tmp100_ = stmt;
						_tmp101_ = rating;
						_tmp102_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, TYPE_SEARCH_CONDITION, SearchCondition));
						_tmp103_ = _tmp102_;
						_tmp104_ = search_condition_search_type_to_string (_tmp103_);
						_tmp105_ = g_free;
						res = sqlite3_bind_text (_tmp100_, 2, _tmp104_, -1, _tmp105_);
						_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
						_tmp106_ = stmt;
						_tmp107_ = rating;
						_tmp108_ = search_condition_rating_get_rating (_tmp107_);
						_tmp109_ = _tmp108_;
						res = sqlite3_bind_int (_tmp106_, 3, rating_serialize (_tmp109_));
						_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
						_tmp110_ = stmt;
						_tmp111_ = rating;
						_tmp112_ = search_condition_rating_get_context (_tmp111_);
						_tmp113_ = _tmp112_;
						_tmp114_ = search_condition_rating_context_to_string (_tmp113_);
						_tmp115_ = g_free;
						res = sqlite3_bind_text (_tmp110_, 4, _tmp114_, -1, _tmp115_);
						_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
						_tmp116_ = stmt;
						res = sqlite3_step (_tmp116_);
						if (res != SQLITE_DONE) {
							database_table_throw_error ("SavedSearchDBTable_Rating.add", res, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == DATABASE_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_sqlite3_finalize0 (stmt);
									_search_condition_unref0 (rating);
									return;
								} else {
									_sqlite3_finalize0 (stmt);
									_search_condition_unref0 (rating);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return;
								}
							}
						}
						_sqlite3_finalize0 (stmt);
						_search_condition_unref0 (rating);
					} else {
						if (IS_SEARCH_CONDITION_DATE (condition)) {
							SearchConditionDate* date = NULL;
							SearchConditionDate* _tmp117_;
							sqlite3_stmt* stmt = NULL;
							gint res = 0;
							sqlite3* _tmp118_;
							sqlite3_stmt* _tmp119_ = NULL;
							gint _tmp120_;
							sqlite3_stmt* _tmp121_;
							SavedSearchID _tmp122_;
							sqlite3_stmt* _tmp123_;
							SearchConditionDate* _tmp124_;
							SearchConditionSearchType _tmp125_;
							SearchConditionSearchType _tmp126_;
							gchar* _tmp127_;
							GDestroyNotify _tmp128_;
							sqlite3_stmt* _tmp129_;
							SearchConditionDate* _tmp130_;
							SearchConditionDateContext _tmp131_;
							SearchConditionDateContext _tmp132_;
							gchar* _tmp133_;
							GDestroyNotify _tmp134_;
							sqlite3_stmt* _tmp135_;
							SearchConditionDate* _tmp136_;
							GDateTime* _tmp137_;
							GDateTime* _tmp138_;
							sqlite3_stmt* _tmp139_;
							SearchConditionDate* _tmp140_;
							GDateTime* _tmp141_;
							GDateTime* _tmp142_;
							sqlite3_stmt* _tmp143_;
							_tmp117_ = _search_condition_ref0 (IS_SEARCH_CONDITION_DATE (condition) ? ((SearchConditionDate*) condition) : NULL);
							date = _tmp117_;
							_tmp118_ = database_table_db;
							_tmp120_ = sqlite3_prepare_v2 (_tmp118_, "INSERT INTO SavedSearchDBTable_Date (search_id, search_type, " "context, date_one, date_two) VALUES (?, ?, ?, ?, ?)", -1, &_tmp119_, NULL);
							_sqlite3_finalize0 (stmt);
							stmt = _tmp119_;
							res = _tmp120_;
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp121_ = stmt;
							_tmp122_ = *id;
							res = sqlite3_bind_int64 (_tmp121_, 1, _tmp122_.id);
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp123_ = stmt;
							_tmp124_ = date;
							_tmp125_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, TYPE_SEARCH_CONDITION, SearchCondition));
							_tmp126_ = _tmp125_;
							_tmp127_ = search_condition_search_type_to_string (_tmp126_);
							_tmp128_ = g_free;
							res = sqlite3_bind_text (_tmp123_, 2, _tmp127_, -1, _tmp128_);
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp129_ = stmt;
							_tmp130_ = date;
							_tmp131_ = search_condition_date_get_context (_tmp130_);
							_tmp132_ = _tmp131_;
							_tmp133_ = search_condition_date_context_to_string (_tmp132_);
							_tmp134_ = g_free;
							res = sqlite3_bind_text (_tmp129_, 3, _tmp133_, -1, _tmp134_);
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp135_ = stmt;
							_tmp136_ = date;
							_tmp137_ = search_condition_date_get_date_one (_tmp136_);
							_tmp138_ = _tmp137_;
							res = sqlite3_bind_int64 (_tmp135_, 4, g_date_time_to_unix (_tmp138_));
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp139_ = stmt;
							_tmp140_ = date;
							_tmp141_ = search_condition_date_get_date_two (_tmp140_);
							_tmp142_ = _tmp141_;
							res = sqlite3_bind_int64 (_tmp139_, 5, g_date_time_to_unix (_tmp142_));
							_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
							_tmp143_ = stmt;
							res = sqlite3_step (_tmp143_);
							if (res != SQLITE_DONE) {
								database_table_throw_error ("SavedSearchDBTable_Date.add", res, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == DATABASE_ERROR) {
										g_propagate_error (error, _inner_error0_);
										_sqlite3_finalize0 (stmt);
										_search_condition_unref0 (date);
										return;
									} else {
										_sqlite3_finalize0 (stmt);
										_search_condition_unref0 (date);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
								}
							}
							_sqlite3_finalize0 (stmt);
							_search_condition_unref0 (date);
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
		}
	}
}

static void
saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self,
                                                       SavedSearchID* search_id,
                                                       GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	SavedSearchID _tmp2_;
	SavedSearchID _tmp3_;
	SavedSearchID _tmp4_;
	SavedSearchID _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (search_id != NULL);
	_tmp0_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Text", &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_MediaType", &_tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp2_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Flagged", &_tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp3_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Modified", &_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Rating", &_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = *search_id;
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Date", &_tmp5_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self,
                                                   const gchar* table_name,
                                                   SavedSearchID* search_id,
                                                   GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	SavedSearchID _tmp7_;
	sqlite3_stmt* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (table_name != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = database_table_db;
	_tmp1_ = g_strdup_printf ("DELETE FROM %s WHERE search_id=?", table_name);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	res = _tmp5_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	_tmp7_ = *search_id;
	res = sqlite3_bind_int64 (_tmp6_, 1, _tmp7_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_DONE) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_strdup_printf ("%s.remove", table_name);
		_tmp10_ = _tmp9_;
		database_table_throw_error (_tmp10_, res, &_inner_error0_);
		_g_free0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

static GeeList*
saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self,
                                             SavedSearchID* search_id,
                                             GError** error)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	SavedSearchID _tmp5_;
	sqlite3* _tmp17_;
	sqlite3_stmt* _tmp18_ = NULL;
	gint _tmp19_;
	sqlite3_stmt* _tmp20_;
	SavedSearchID _tmp21_;
	sqlite3* _tmp33_;
	sqlite3_stmt* _tmp34_ = NULL;
	gint _tmp35_;
	sqlite3_stmt* _tmp36_;
	SavedSearchID _tmp37_;
	sqlite3* _tmp47_;
	sqlite3_stmt* _tmp48_ = NULL;
	gint _tmp49_;
	sqlite3_stmt* _tmp50_;
	SavedSearchID _tmp51_;
	sqlite3* _tmp63_;
	sqlite3_stmt* _tmp64_ = NULL;
	gint _tmp65_;
	sqlite3_stmt* _tmp66_;
	SavedSearchID _tmp67_;
	sqlite3* _tmp78_;
	sqlite3_stmt* _tmp79_ = NULL;
	gint _tmp80_;
	sqlite3_stmt* _tmp81_;
	SavedSearchID _tmp82_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
	g_return_val_if_fail (search_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SEARCH_CONDITION, (GBoxedCopyFunc) search_condition_ref, (GDestroyNotify) search_condition_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = database_table_db;
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "SELECT search_type, context, text FROM SavedSearchDBTable_Text " "WHERE search_id=?", -1, &_tmp2_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp2_;
	res = _tmp3_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp4_ = stmt;
	_tmp5_ = *search_id;
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp5_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp7_;
			SearchConditionText* condition = NULL;
			sqlite3_stmt* _tmp8_;
			const gchar* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			sqlite3_stmt* _tmp12_;
			const gchar* _tmp13_;
			SearchConditionText* _tmp14_;
			GeeList* _tmp15_;
			SearchConditionText* _tmp16_;
			if (!_tmp6_) {
			}
			_tmp6_ = FALSE;
			_tmp7_ = stmt;
			res = sqlite3_step (_tmp7_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Text.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp8_ = stmt;
			_tmp9_ = (const gchar*) sqlite3_column_text (_tmp8_, 0);
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 2);
			_tmp12_ = stmt;
			_tmp13_ = (const gchar*) sqlite3_column_text (_tmp12_, 1);
			_tmp14_ = search_condition_text_new (search_condition_search_type_from_string (_tmp9_), _tmp11_, search_condition_text_context_from_string (_tmp13_));
			condition = _tmp14_;
			_tmp15_ = list;
			_tmp16_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	_tmp17_ = database_table_db;
	_tmp19_ = sqlite3_prepare_v2 (_tmp17_, "SELECT search_type, context, type FROM SavedSearchDBTable_MediaType " "WHERE search_id=?", -1, &_tmp18_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp18_;
	res = _tmp19_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp20_ = stmt;
	_tmp21_ = *search_id;
	res = sqlite3_bind_int64 (_tmp20_, 1, _tmp21_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp22_ = FALSE;
		_tmp22_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp23_;
			SearchConditionMediaType* condition = NULL;
			sqlite3_stmt* _tmp24_;
			const gchar* _tmp25_;
			sqlite3_stmt* _tmp26_;
			const gchar* _tmp27_;
			sqlite3_stmt* _tmp28_;
			const gchar* _tmp29_;
			SearchConditionMediaType* _tmp30_;
			GeeList* _tmp31_;
			SearchConditionMediaType* _tmp32_;
			if (!_tmp22_) {
			}
			_tmp22_ = FALSE;
			_tmp23_ = stmt;
			res = sqlite3_step (_tmp23_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_MediaType.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp24_ = stmt;
			_tmp25_ = (const gchar*) sqlite3_column_text (_tmp24_, 0);
			_tmp26_ = stmt;
			_tmp27_ = (const gchar*) sqlite3_column_text (_tmp26_, 1);
			_tmp28_ = stmt;
			_tmp29_ = (const gchar*) sqlite3_column_text (_tmp28_, 2);
			_tmp30_ = search_condition_media_type_new (search_condition_search_type_from_string (_tmp25_), search_condition_media_type_context_from_string (_tmp27_), search_condition_media_type_media_type_from_string (_tmp29_));
			condition = _tmp30_;
			_tmp31_ = list;
			_tmp32_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	_tmp33_ = database_table_db;
	_tmp35_ = sqlite3_prepare_v2 (_tmp33_, "SELECT search_type, flag_state FROM SavedSearchDBTable_Flagged " "WHERE search_id=?", -1, &_tmp34_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp34_;
	res = _tmp35_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp36_ = stmt;
	_tmp37_ = *search_id;
	res = sqlite3_bind_int64 (_tmp36_, 1, _tmp37_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp38_ = FALSE;
		_tmp38_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp39_;
			SearchConditionFlagged* condition = NULL;
			sqlite3_stmt* _tmp40_;
			const gchar* _tmp41_;
			sqlite3_stmt* _tmp42_;
			const gchar* _tmp43_;
			SearchConditionFlagged* _tmp44_;
			GeeList* _tmp45_;
			SearchConditionFlagged* _tmp46_;
			if (!_tmp38_) {
			}
			_tmp38_ = FALSE;
			_tmp39_ = stmt;
			res = sqlite3_step (_tmp39_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Flagged.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp40_ = stmt;
			_tmp41_ = (const gchar*) sqlite3_column_text (_tmp40_, 0);
			_tmp42_ = stmt;
			_tmp43_ = (const gchar*) sqlite3_column_text (_tmp42_, 1);
			_tmp44_ = search_condition_flagged_new (search_condition_search_type_from_string (_tmp41_), search_condition_flagged_state_from_string (_tmp43_));
			condition = _tmp44_;
			_tmp45_ = list;
			_tmp46_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	_tmp47_ = database_table_db;
	_tmp49_ = sqlite3_prepare_v2 (_tmp47_, "SELECT search_type, context, modified_state FROM SavedSearchDBTable_Mo" \
"dified " "WHERE search_id=?", -1, &_tmp48_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp48_;
	res = _tmp49_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp50_ = stmt;
	_tmp51_ = *search_id;
	res = sqlite3_bind_int64 (_tmp50_, 1, _tmp51_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp52_ = FALSE;
		_tmp52_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp53_;
			SearchConditionModified* condition = NULL;
			sqlite3_stmt* _tmp54_;
			const gchar* _tmp55_;
			sqlite3_stmt* _tmp56_;
			const gchar* _tmp57_;
			sqlite3_stmt* _tmp58_;
			const gchar* _tmp59_;
			SearchConditionModified* _tmp60_;
			GeeList* _tmp61_;
			SearchConditionModified* _tmp62_;
			if (!_tmp52_) {
			}
			_tmp52_ = FALSE;
			_tmp53_ = stmt;
			res = sqlite3_step (_tmp53_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Modified.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp54_ = stmt;
			_tmp55_ = (const gchar*) sqlite3_column_text (_tmp54_, 0);
			_tmp56_ = stmt;
			_tmp57_ = (const gchar*) sqlite3_column_text (_tmp56_, 1);
			_tmp58_ = stmt;
			_tmp59_ = (const gchar*) sqlite3_column_text (_tmp58_, 2);
			_tmp60_ = search_condition_modified_new (search_condition_search_type_from_string (_tmp55_), search_condition_modified_context_from_string (_tmp57_), search_condition_modified_state_from_string (_tmp59_));
			condition = _tmp60_;
			_tmp61_ = list;
			_tmp62_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	_tmp63_ = database_table_db;
	_tmp65_ = sqlite3_prepare_v2 (_tmp63_, "SELECT search_type, rating, context FROM SavedSearchDBTable_Rating " "WHERE search_id=?", -1, &_tmp64_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp64_;
	res = _tmp65_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp66_ = stmt;
	_tmp67_ = *search_id;
	res = sqlite3_bind_int64 (_tmp66_, 1, _tmp67_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp68_ = FALSE;
		_tmp68_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp69_;
			SearchConditionRating* condition = NULL;
			sqlite3_stmt* _tmp70_;
			const gchar* _tmp71_;
			sqlite3_stmt* _tmp72_;
			sqlite3_stmt* _tmp73_;
			const gchar* _tmp74_;
			SearchConditionRating* _tmp75_;
			GeeList* _tmp76_;
			SearchConditionRating* _tmp77_;
			if (!_tmp68_) {
			}
			_tmp68_ = FALSE;
			_tmp69_ = stmt;
			res = sqlite3_step (_tmp69_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Rating.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp70_ = stmt;
			_tmp71_ = (const gchar*) sqlite3_column_text (_tmp70_, 0);
			_tmp72_ = stmt;
			_tmp73_ = stmt;
			_tmp74_ = (const gchar*) sqlite3_column_text (_tmp73_, 2);
			_tmp75_ = search_condition_rating_new (search_condition_search_type_from_string (_tmp71_), rating_unserialize (sqlite3_column_int (_tmp72_, 1)), search_condition_rating_context_from_string (_tmp74_));
			condition = _tmp75_;
			_tmp76_ = list;
			_tmp77_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	_tmp78_ = database_table_db;
	_tmp80_ = sqlite3_prepare_v2 (_tmp78_, "SELECT search_type, context, date_one, date_two FROM SavedSearchDBTabl" \
"e_Date " "WHERE search_id=?", -1, &_tmp79_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp79_;
	res = _tmp80_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp81_ = stmt;
	_tmp82_ = *search_id;
	res = sqlite3_bind_int64 (_tmp81_, 1, _tmp82_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	{
		gboolean _tmp83_ = FALSE;
		_tmp83_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp84_;
			SearchConditionDate* condition = NULL;
			sqlite3_stmt* _tmp85_;
			const gchar* _tmp86_;
			sqlite3_stmt* _tmp87_;
			const gchar* _tmp88_;
			sqlite3_stmt* _tmp89_;
			GDateTime* _tmp90_;
			GDateTime* _tmp91_;
			sqlite3_stmt* _tmp92_;
			GDateTime* _tmp93_;
			GDateTime* _tmp94_;
			SearchConditionDate* _tmp95_;
			SearchConditionDate* _tmp96_;
			GeeList* _tmp97_;
			SearchConditionDate* _tmp98_;
			if (!_tmp83_) {
			}
			_tmp83_ = FALSE;
			_tmp84_ = stmt;
			res = sqlite3_step (_tmp84_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable_Date.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							return NULL;
						} else {
							_sqlite3_finalize0 (stmt);
							_g_object_unref0 (list);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp85_ = stmt;
			_tmp86_ = (const gchar*) sqlite3_column_text (_tmp85_, 0);
			_tmp87_ = stmt;
			_tmp88_ = (const gchar*) sqlite3_column_text (_tmp87_, 1);
			_tmp89_ = stmt;
			_tmp90_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp89_, 2));
			_tmp91_ = _tmp90_;
			_tmp92_ = stmt;
			_tmp93_ = g_date_time_new_from_unix_local (sqlite3_column_int64 (_tmp92_, 3));
			_tmp94_ = _tmp93_;
			_tmp95_ = search_condition_date_new (search_condition_search_type_from_string (_tmp86_), search_condition_date_context_from_string (_tmp88_), _tmp91_, _tmp94_);
			_tmp96_ = _tmp95_;
			_g_date_time_unref0 (_tmp94_);
			_g_date_time_unref0 (_tmp91_);
			condition = _tmp96_;
			_tmp97_ = list;
			_tmp98_ = condition;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, TYPE_SEARCH_CONDITION, SearchCondition));
			_search_condition_unref0 (condition);
		}
	}
	result = list;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                       SavedSearchRow* row,
                                       SavedSearchID* result,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	gchar* _tmp8_;
	GDestroyNotify _tmp9_;
	sqlite3_stmt* _tmp10_;
	SavedSearchID search_id = {0};
	sqlite3* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (IS_SAVED_SEARCH_ROW (row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = row->name;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	_tmp8_ = search_operator_to_string (row->operator);
	_tmp9_ = g_free;
	res = sqlite3_bind_text (_tmp7_, 2, _tmp8_, -1, _tmp9_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp10_ = stmt;
	res = sqlite3_step (_tmp10_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("SavedSearchDBTable.create_from_row", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp11_ = database_table_db;
	saved_search_id_init (&search_id, sqlite3_last_insert_rowid (_tmp11_));
	{
		GeeList* _sc_list = NULL;
		GeeList* _tmp12_;
		gint _sc_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _sc_index = 0;
		_tmp12_ = row->conditions;
		_sc_list = _tmp12_;
		_tmp13_ = _sc_list;
		_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp15_ = _tmp14_;
		_sc_size = _tmp15_;
		_sc_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			SearchCondition* sc = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			SavedSearchID _tmp20_;
			SearchCondition* _tmp21_;
			_sc_index = _sc_index + 1;
			_tmp16_ = _sc_index;
			_tmp17_ = _sc_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _sc_list;
			_tmp19_ = gee_list_get (_tmp18_, _sc_index);
			sc = (SearchCondition*) _tmp19_;
			_tmp20_ = search_id;
			_tmp21_ = sc;
			saved_search_db_table_add_condition (self, &_tmp20_, _tmp21_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_search_condition_unref0 (sc);
					_sqlite3_finalize0 (stmt);
					return;
				} else {
					_search_condition_unref0 (sc);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_search_condition_unref0 (sc);
		}
	}
	*result = search_id;
	_sqlite3_finalize0 (stmt);
	return;
}

void
saved_search_db_table_remove (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              GError** error)
{
	SavedSearchID _tmp0_;
	SavedSearchID _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (search_id != NULL);
	_tmp0_ = *search_id;
	saved_search_db_table_remove_conditions_for_search_id (self, &_tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp1_ = *search_id;
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

SavedSearchRow*
saved_search_db_table_get_row (SavedSearchDBTable* self,
                               SavedSearchID* search_id,
                               GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	SavedSearchID _tmp4_;
	sqlite3_stmt* _tmp5_;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp6_;
	SavedSearchRow* _tmp7_;
	SavedSearchID _tmp8_;
	SavedSearchRow* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	SavedSearchRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	SavedSearchRow* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
	g_return_val_if_fail (search_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, operator FROM SavedSearchDBTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *search_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("SavedSearchDBTable.get_row", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp6_ = saved_search_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *search_id;
	_tmp7_->search_id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = stmt;
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 0);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp9_->name);
	_tmp9_->name = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 1);
	_tmp13_->operator = search_operator_from_string (_tmp15_);
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeList*
saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, operator FROM SavedSearchDBTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_SAVED_SEARCH_ROW, (GBoxedCopyFunc) saved_search_row_ref, (GDestroyNotify) saved_search_row_unref, NULL, NULL, NULL);
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			SavedSearchRow* row = NULL;
			SavedSearchRow* _tmp6_;
			SavedSearchRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			SavedSearchRow* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			SavedSearchRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_;
			GeeList* _tmp16_ = NULL;
			SavedSearchRow* _tmp17_;
			SavedSearchID _tmp18_;
			GeeList* _tmp19_;
			SavedSearchRow* _tmp20_;
			GeeList* _tmp21_;
			GeeList* _tmp22_;
			SavedSearchRow* _tmp23_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("SavedSearchDBTable.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = saved_search_row_new ();
			row = _tmp6_;
			_tmp7_ = row;
			_tmp8_ = stmt;
			saved_search_id_init (&_tmp7_->search_id, sqlite3_column_int64 (_tmp8_, 0));
			_tmp9_ = row;
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp9_->name);
			_tmp9_->name = _tmp12_;
			_tmp13_ = row;
			_tmp14_ = stmt;
			_tmp15_ = (const gchar*) sqlite3_column_text (_tmp14_, 2);
			_tmp13_->operator = search_operator_from_string (_tmp15_);
			_tmp17_ = row;
			_tmp18_ = _tmp17_->search_id;
			_tmp19_ = saved_search_db_table_get_conditions_for_id (self, &_tmp18_, &_inner_error0_);
			_tmp16_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_saved_search_row_unref0 (row);
					_g_object_unref0 (rows);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_saved_search_row_unref0 (row);
					_g_object_unref0 (rows);
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp20_ = row;
			_tmp21_ = _tmp16_;
			_tmp16_ = NULL;
			_g_object_unref0 (_tmp20_->conditions);
			_tmp20_->conditions = _tmp21_;
			_tmp22_ = rows;
			_tmp23_ = row;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
			_g_object_unref0 (_tmp16_);
			_saved_search_row_unref0 (row);
		}
	}
	result = rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
saved_search_db_table_rename (SavedSearchDBTable* self,
                              SavedSearchID* search_id,
                              const gchar* new_name,
                              GError** error)
{
	SavedSearchID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
	g_return_if_fail (search_id != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = *search_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "name", new_name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
saved_search_db_table_class_init (SavedSearchDBTableClass * klass,
                                  gpointer klass_data)
{
	saved_search_db_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = saved_search_db_table_finalize;
}

static void
saved_search_db_table_instance_init (SavedSearchDBTable * self,
                                     gpointer klass)
{
}

static void
saved_search_db_table_finalize (DatabaseTable * obj)
{
	SavedSearchDBTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable);
	DATABASE_TABLE_CLASS (saved_search_db_table_parent_class)->finalize (obj);
}

static GType
saved_search_db_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchDBTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_db_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchDBTable), 0, (GInstanceInitFunc) saved_search_db_table_instance_init, NULL };
	GType saved_search_db_table_type_id;
	saved_search_db_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "SavedSearchDBTable", &g_define_type_info, 0);
	return saved_search_db_table_type_id;
}

GType
saved_search_db_table_get_type (void)
{
	static volatile gsize saved_search_db_table_type_id__once = 0;
	if (g_once_init_enter (&saved_search_db_table_type_id__once)) {
		GType saved_search_db_table_type_id;
		saved_search_db_table_type_id = saved_search_db_table_get_type_once ();
		g_once_init_leave (&saved_search_db_table_type_id__once, saved_search_db_table_type_id);
	}
	return saved_search_db_table_type_id__once;
}

