/* GPhoto.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gphoto2/gphoto2-context.h>
#include <shotwell-gphoto-helper.h>
#include <gobject/gvaluecollector.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto2/gphoto2-filesys.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-file.h>
#include "metadata.h"
#include <gphoto2/gphoto2-port-info-list.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>

#define IMPORT_PREVIEW_MAX_SCALE 128
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GPHOTO_ERROR (gphoto_error_get_type ())

#define GP_TYPE_CONTEXT_WRAPPER (gp_context_wrapper_get_type ())
#define GP_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper))
#define GP_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))
#define GP_IS_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_CONTEXT_WRAPPER))
#define GP_IS_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_CONTEXT_WRAPPER))
#define GP_CONTEXT_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))

typedef struct _GPContextWrapper GPContextWrapper;
typedef struct _GPContextWrapperClass GPContextWrapperClass;
typedef struct _GPContextWrapperPrivate GPContextWrapperPrivate;
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
typedef struct _GPParamSpecContextWrapper GPParamSpecContextWrapper;

#define GP_TYPE_SPIN_IDLE_WRAPPER (gp_spin_idle_wrapper_get_type ())
#define GP_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper))
#define GP_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))
#define GP_IS_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_IS_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_SPIN_IDLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))

typedef struct _GPSpinIdleWrapper GPSpinIdleWrapper;
typedef struct _GPSpinIdleWrapperClass GPSpinIdleWrapperClass;
typedef struct _GPSpinIdleWrapperPrivate GPSpinIdleWrapperPrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _gp_file_unref0(var) ((var == NULL) ? NULL : (var = (gp_file_unref (var), NULL)))

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()

struct _GPContextWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPContextWrapperPrivate * priv;
	GPContext* context;
};

struct _GPContextWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GPContextWrapper *self);
	void (*idle) (GPContextWrapper* self);
	void (*error) (GPContextWrapper* self, const gchar* text, void* data);
	void (*status) (GPContextWrapper* self, const gchar* text, void* data);
	void (*message) (GPContextWrapper* self, const gchar* text, void* data);
	void (*progress_start) (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
	void (*progress_update) (GPContextWrapper* self, gfloat current, void* data);
	void (*progress_stop) (GPContextWrapper* self);
};

struct _GPParamSpecContextWrapper {
	GParamSpec parent_instance;
};

struct _GPSpinIdleWrapper {
	GPContextWrapper parent_instance;
	GPSpinIdleWrapperPrivate * priv;
};

struct _GPSpinIdleWrapperClass {
	GPContextWrapperClass parent_class;
};

static gpointer gp_context_wrapper_parent_class = NULL;
static gpointer gp_spin_idle_wrapper_parent_class = NULL;

VALA_EXTERN GQuark gphoto_error_quark (void);
VALA_EXTERN GType gphoto_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer gp_context_wrapper_ref (gpointer instance);
VALA_EXTERN void gp_context_wrapper_unref (gpointer instance);
VALA_EXTERN GParamSpec* gp_param_spec_context_wrapper (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void gp_value_set_context_wrapper (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void gp_value_take_context_wrapper (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer gp_value_get_context_wrapper (const GValue* value);
VALA_EXTERN GType gp_context_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GPContextWrapper, gp_context_wrapper_unref)
VALA_EXTERN void gp_context_wrapper_idle (GPContextWrapper* self);
VALA_EXTERN void gp_context_wrapper_error (GPContextWrapper* self,
                               const gchar* text,
                               void* data);
VALA_EXTERN void gp_context_wrapper_status (GPContextWrapper* self,
                                const gchar* text,
                                void* data);
VALA_EXTERN void gp_context_wrapper_message (GPContextWrapper* self,
                                 const gchar* text,
                                 void* data);
VALA_EXTERN void gp_context_wrapper_progress_start (GPContextWrapper* self,
                                        gfloat current,
                                        const gchar* text,
                                        void* data);
VALA_EXTERN void gp_context_wrapper_progress_update (GPContextWrapper* self,
                                         gfloat current,
                                         void* data);
VALA_EXTERN void gp_context_wrapper_progress_stop (GPContextWrapper* self);
VALA_EXTERN GPContextWrapper* gp_context_wrapper_new (void);
VALA_EXTERN GPContextWrapper* gp_context_wrapper_construct (GType object_type);
static void gp_context_wrapper_on_idle (GPContextWrapper* self,
                                 GPContext* context);
static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context,
                                                       gpointer self);
static void gp_context_wrapper_on_error (GPContextWrapper* self,
                                  GPContext* context,
                                  const gchar* text);
static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context,
                                                         const gchar* text,
                                                         gpointer self);
static void gp_context_wrapper_on_status (GPContextWrapper* self,
                                   GPContext* context,
                                   const gchar* text);
static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context,
                                                           const gchar* text,
                                                           gpointer self);
static void gp_context_wrapper_on_message (GPContextWrapper* self,
                                    GPContext* context,
                                    const gchar* text);
static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context,
                                                             const gchar* text,
                                                             gpointer self);
static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self,
                                            GPContext* context,
                                            gfloat target,
                                            const gchar* text);
static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context,
                                                                            gfloat target,
                                                                            const gchar* text,
                                                                            gpointer self);
static void gp_context_wrapper_on_progress_update (GPContextWrapper* self,
                                            GPContext* context,
                                            guint id,
                                            gfloat current);
static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context,
                                                                             guint id,
                                                                             gfloat current,
                                                                             gpointer self);
static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self,
                                          GPContext* context,
                                          guint id);
static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context,
                                                                         guint id,
                                                                         gpointer self);
static void gp_context_wrapper_real_idle (GPContextWrapper* self);
static void gp_context_wrapper_real_error (GPContextWrapper* self,
                                    const gchar* text,
                                    void* data);
static void gp_context_wrapper_real_status (GPContextWrapper* self,
                                     const gchar* text,
                                     void* data);
static void gp_context_wrapper_real_message (GPContextWrapper* self,
                                      const gchar* text,
                                      void* data);
static void gp_context_wrapper_real_progress_start (GPContextWrapper* self,
                                             gfloat current,
                                             const gchar* text,
                                             void* data);
static void gp_context_wrapper_real_progress_update (GPContextWrapper* self,
                                              gfloat current,
                                              void* data);
static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_finalize (GPContextWrapper * obj);
static GType gp_context_wrapper_get_type_once (void);
VALA_EXTERN GType gp_spin_idle_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GPSpinIdleWrapper, gp_context_wrapper_unref)
VALA_EXTERN GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void);
VALA_EXTERN GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type);
static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base);
VALA_EXTERN void spin_event_loop (void);
static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base,
                                                gfloat current,
                                                void* data);
static GType gp_spin_idle_wrapper_get_type_once (void);
VALA_EXTERN gboolean gp_get_info (GPContext* context,
                      Camera* camera,
                      const gchar* folder,
                      const gchar* filename,
                      CameraFileInfo* info,
                      GError** error);
VALA_EXTERN GBytes* gp_camera_file_to_bytes (GPContext* context,
                                 CameraFile* file);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* gp_get_fallback_metadata (Camera* camera,
                                         GPContext* context,
                                         const gchar* folder,
                                         const gchar* filename);
VALA_EXTERN PhotoMetadata* photo_metadata_new (void);
VALA_EXTERN PhotoMetadata* photo_metadata_construct (GType object_type);
VALA_EXTERN GdkPixbuf* gp_load_preview (GPContext* context,
                            Camera* camera,
                            const gchar* folder,
                            const gchar* filename,
                            gchar** preview_md5,
                            GError** error);
VALA_EXTERN GBytes* gp_load_file_into_buffer (GPContext* context,
                                  Camera* camera,
                                  const gchar* folder,
                                  const gchar* filename,
                                  CameraFileType filetype,
                                  GError** error);
VALA_EXTERN guint photo_metadata_get_preview_count (PhotoMetadata* self);
VALA_EXTERN gpointer photo_preview_ref (gpointer instance);
VALA_EXTERN void photo_preview_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_photo_preview (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_photo_preview (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_photo_preview (const GValue* value);
VALA_EXTERN GType photo_preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoPreview, photo_preview_unref)
VALA_EXTERN PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
VALA_EXTERN GBytes* photo_preview_flatten (PhotoPreview* self,
                               GError** error);
VALA_EXTERN GdkPixbuf* gp_load_image (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          GError** error);
VALA_EXTERN GInputStream* gp_load_file_into_stream (GPContext* context,
                                        Camera* camera,
                                        const gchar* folder,
                                        const gchar* filename,
                                        CameraFileType filetype,
                                        GError** error);
VALA_EXTERN void gp_save_image (GPContext* context,
                    Camera* camera,
                    const gchar* folder,
                    const gchar* filename,
                    GFile* dest_file,
                    GError** error);
VALA_EXTERN PhotoMetadata* gp_load_metadata (GPContext* context,
                                 Camera* camera,
                                 const gchar* folder,
                                 const gchar* filename,
                                 GError** error);
VALA_EXTERN void photo_metadata_read_from_app1_segment (PhotoMetadata* self,
                                            GBytes* buffer,
                                            GError** error);
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
gphoto_error_quark (void)
{
	return g_quark_from_static_string ("gphoto-error-quark");
}

static GType
gphoto_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GPHOTO_ERROR_LIBRARY, "GPHOTO_ERROR_LIBRARY", "library"}, {0, NULL, NULL}};
	GType gphoto_error_type_id;
	gphoto_error_type_id = g_enum_register_static ("GPhotoError", values);
	return gphoto_error_type_id;
}

GType
gphoto_error_get_type (void)
{
	static volatile gsize gphoto_error_type_id__once = 0;
	if (g_once_init_enter (&gphoto_error_type_id__once)) {
		GType gphoto_error_type_id;
		gphoto_error_type_id = gphoto_error_get_type_once ();
		g_once_init_leave (&gphoto_error_type_id__once, gphoto_error_type_id);
	}
	return gphoto_error_type_id__once;
}

static void
_gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context,
                                                  gpointer self)
{
	gp_context_wrapper_on_idle ((GPContextWrapper*) self, context);
}

static void
_gp_context_wrapper_on_error_gp_context_error_func (GPContext* context,
                                                    const gchar* text,
                                                    gpointer self)
{
	gp_context_wrapper_on_error ((GPContextWrapper*) self, context, text);
}

static void
_gp_context_wrapper_on_status_gp_context_status_func (GPContext* context,
                                                      const gchar* text,
                                                      gpointer self)
{
	gp_context_wrapper_on_status ((GPContextWrapper*) self, context, text);
}

static void
_gp_context_wrapper_on_message_gp_context_message_func (GPContext* context,
                                                        const gchar* text,
                                                        gpointer self)
{
	gp_context_wrapper_on_message ((GPContextWrapper*) self, context, text);
}

static guint
_gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context,
                                                                      gfloat target,
                                                                      const gchar* text,
                                                                      gpointer self)
{
	guint result;
	result = gp_context_wrapper_on_progress_start ((GPContextWrapper*) self, context, target, text);
	return result;
}

static void
_gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context,
                                                                        guint id,
                                                                        gfloat current,
                                                                        gpointer self)
{
	gp_context_wrapper_on_progress_update ((GPContextWrapper*) self, context, id, current);
}

static void
_gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context,
                                                                    guint id,
                                                                    gpointer self)
{
	gp_context_wrapper_on_progress_stop ((GPContextWrapper*) self, context, id);
}

GPContextWrapper*
gp_context_wrapper_construct (GType object_type)
{
	GPContextWrapper* self = NULL;
	GPContext* _tmp0_;
	GPContext* _tmp1_;
	GPContext* _tmp2_;
	GPContext* _tmp3_;
	GPContext* _tmp4_;
	self = (GPContextWrapper*) g_type_create_instance (object_type);
	_tmp0_ = self->context;
	gp_context_set_idle_func (_tmp0_, _gp_context_wrapper_on_idle_gp_context_idle_func, self);
	_tmp1_ = self->context;
	gp_context_set_error_func (_tmp1_, _gp_context_wrapper_on_error_gp_context_error_func, self);
	_tmp2_ = self->context;
	gp_context_set_status_func (_tmp2_, _gp_context_wrapper_on_status_gp_context_status_func, self);
	_tmp3_ = self->context;
	gp_context_set_message_func (_tmp3_, _gp_context_wrapper_on_message_gp_context_message_func, self);
	_tmp4_ = self->context;
	gp_context_set_progress_funcs (_tmp4_, _gp_context_wrapper_on_progress_start_gp_context_progress_start_func, _gp_context_wrapper_on_progress_update_gp_context_progress_update_func, _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func, self);
	return self;
}

GPContextWrapper*
gp_context_wrapper_new (void)
{
	return gp_context_wrapper_construct (GP_TYPE_CONTEXT_WRAPPER);
}

static void
gp_context_wrapper_real_idle (GPContextWrapper* self)
{
}

void
gp_context_wrapper_idle (GPContextWrapper* self)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->idle) {
		_klass_->idle (self);
	}
}

static void
gp_context_wrapper_real_error (GPContextWrapper* self,
                               const gchar* text,
                               void* data)
{
	g_return_if_fail (text != NULL);
}

void
gp_context_wrapper_error (GPContextWrapper* self,
                          const gchar* text,
                          void* data)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->error) {
		_klass_->error (self, text, data);
	}
}

static void
gp_context_wrapper_real_status (GPContextWrapper* self,
                                const gchar* text,
                                void* data)
{
	g_return_if_fail (text != NULL);
}

void
gp_context_wrapper_status (GPContextWrapper* self,
                           const gchar* text,
                           void* data)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->status) {
		_klass_->status (self, text, data);
	}
}

static void
gp_context_wrapper_real_message (GPContextWrapper* self,
                                 const gchar* text,
                                 void* data)
{
	g_return_if_fail (text != NULL);
}

void
gp_context_wrapper_message (GPContextWrapper* self,
                            const gchar* text,
                            void* data)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->message) {
		_klass_->message (self, text, data);
	}
}

static void
gp_context_wrapper_real_progress_start (GPContextWrapper* self,
                                        gfloat current,
                                        const gchar* text,
                                        void* data)
{
	g_return_if_fail (text != NULL);
}

void
gp_context_wrapper_progress_start (GPContextWrapper* self,
                                   gfloat current,
                                   const gchar* text,
                                   void* data)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->progress_start) {
		_klass_->progress_start (self, current, text, data);
	}
}

static void
gp_context_wrapper_real_progress_update (GPContextWrapper* self,
                                         gfloat current,
                                         void* data)
{
}

void
gp_context_wrapper_progress_update (GPContextWrapper* self,
                                    gfloat current,
                                    void* data)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->progress_update) {
		_klass_->progress_update (self, current, data);
	}
}

static void
gp_context_wrapper_real_progress_stop (GPContextWrapper* self)
{
}

void
gp_context_wrapper_progress_stop (GPContextWrapper* self)
{
	GPContextWrapperClass* _klass_;
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	_klass_ = GP_CONTEXT_WRAPPER_GET_CLASS (self);
	if (_klass_->progress_stop) {
		_klass_->progress_stop (self);
	}
}

static void
gp_context_wrapper_on_idle (GPContextWrapper* self,
                            GPContext* context)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	gp_context_wrapper_idle (self);
}

static void
gp_context_wrapper_on_error (GPContextWrapper* self,
                             GPContext* context,
                             const gchar* text)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	gp_context_wrapper_error (self, text, NULL);
}

static void
gp_context_wrapper_on_status (GPContextWrapper* self,
                              GPContext* context,
                              const gchar* text)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	gp_context_wrapper_status (self, text, NULL);
}

static void
gp_context_wrapper_on_message (GPContextWrapper* self,
                               GPContext* context,
                               const gchar* text)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	gp_context_wrapper_message (self, text, NULL);
}

static guint
gp_context_wrapper_on_progress_start (GPContextWrapper* self,
                                      GPContext* context,
                                      gfloat target,
                                      const gchar* text)
{
	guint result;
	g_return_val_if_fail (GP_IS_CONTEXT_WRAPPER (self), 0U);
	g_return_val_if_fail (context != NULL, 0U);
	g_return_val_if_fail (text != NULL, 0U);
	gp_context_wrapper_progress_start (self, target, text, NULL);
	result = (guint) 0;
	return result;
}

static void
gp_context_wrapper_on_progress_update (GPContextWrapper* self,
                                       GPContext* context,
                                       guint id,
                                       gfloat current)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	gp_context_wrapper_progress_update (self, current, NULL);
}

static void
gp_context_wrapper_on_progress_stop (GPContextWrapper* self,
                                     GPContext* context,
                                     guint id)
{
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
	g_return_if_fail (context != NULL);
	gp_context_wrapper_progress_stop (self);
}

static void
gp_value_context_wrapper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gp_value_context_wrapper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gp_context_wrapper_unref (value->data[0].v_pointer);
	}
}

static void
gp_value_context_wrapper_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gp_context_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gp_value_context_wrapper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gp_value_context_wrapper_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GPContextWrapper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gp_context_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gp_value_context_wrapper_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GPContextWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gp_context_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gp_param_spec_context_wrapper (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GPParamSpecContextWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GP_TYPE_CONTEXT_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gp_value_get_context_wrapper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER), NULL);
	return value->data[0].v_pointer;
}

void
gp_value_set_context_wrapper (GValue* value,
                              gpointer v_object)
{
	GPContextWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gp_context_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gp_context_wrapper_unref (old);
	}
}

void
gp_value_take_context_wrapper (GValue* value,
                               gpointer v_object)
{
	GPContextWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gp_context_wrapper_unref (old);
	}
}

static void
gp_context_wrapper_class_init (GPContextWrapperClass * klass,
                               gpointer klass_data)
{
	gp_context_wrapper_parent_class = g_type_class_peek_parent (klass);
	((GPContextWrapperClass *) klass)->finalize = gp_context_wrapper_finalize;
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper*)) gp_context_wrapper_real_idle;
	((GPContextWrapperClass *) klass)->error = (void (*) (GPContextWrapper*, const gchar*, void*)) gp_context_wrapper_real_error;
	((GPContextWrapperClass *) klass)->status = (void (*) (GPContextWrapper*, const gchar*, void*)) gp_context_wrapper_real_status;
	((GPContextWrapperClass *) klass)->message = (void (*) (GPContextWrapper*, const gchar*, void*)) gp_context_wrapper_real_message;
	((GPContextWrapperClass *) klass)->progress_start = (void (*) (GPContextWrapper*, gfloat, const gchar*, void*)) gp_context_wrapper_real_progress_start;
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper*, gfloat, void*)) gp_context_wrapper_real_progress_update;
	((GPContextWrapperClass *) klass)->progress_stop = (void (*) (GPContextWrapper*)) gp_context_wrapper_real_progress_stop;
}

static void
gp_context_wrapper_instance_init (GPContextWrapper * self,
                                  gpointer klass)
{
	GPContext* _tmp0_;
	_tmp0_ = gp_context_new ();
	self->context = _tmp0_;
	self->ref_count = 1;
}

static void
gp_context_wrapper_finalize (GPContextWrapper * obj)
{
	GPContextWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper);
	g_signal_handlers_destroy (self);
	_gp_context_unref0 (self->context);
}

static GType
gp_context_wrapper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gp_value_context_wrapper_init, gp_value_context_wrapper_free_value, gp_value_context_wrapper_copy_value, gp_value_context_wrapper_peek_pointer, "p", gp_value_context_wrapper_collect_value, "p", gp_value_context_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GPContextWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_context_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPContextWrapper), 0, (GInstanceInitFunc) gp_context_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gp_context_wrapper_type_id;
	gp_context_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GPContextWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gp_context_wrapper_type_id;
}

GType
gp_context_wrapper_get_type (void)
{
	static volatile gsize gp_context_wrapper_type_id__once = 0;
	if (g_once_init_enter (&gp_context_wrapper_type_id__once)) {
		GType gp_context_wrapper_type_id;
		gp_context_wrapper_type_id = gp_context_wrapper_get_type_once ();
		g_once_init_leave (&gp_context_wrapper_type_id__once, gp_context_wrapper_type_id);
	}
	return gp_context_wrapper_type_id__once;
}

gpointer
gp_context_wrapper_ref (gpointer instance)
{
	GPContextWrapper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gp_context_wrapper_unref (gpointer instance)
{
	GPContextWrapper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GP_CONTEXT_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GPSpinIdleWrapper*
gp_spin_idle_wrapper_construct (GType object_type)
{
	GPSpinIdleWrapper* self = NULL;
	self = (GPSpinIdleWrapper*) gp_context_wrapper_construct (object_type);
	return self;
}

GPSpinIdleWrapper*
gp_spin_idle_wrapper_new (void)
{
	return gp_spin_idle_wrapper_construct (GP_TYPE_SPIN_IDLE_WRAPPER);
}

static void
gp_spin_idle_wrapper_real_idle (GPContextWrapper* base)
{
	GPSpinIdleWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->idle (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper));
	spin_event_loop ();
}

static void
gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base,
                                           gfloat current,
                                           void* data)
{
	GPSpinIdleWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->progress_update (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper), current, data);
	spin_event_loop ();
}

static void
gp_spin_idle_wrapper_class_init (GPSpinIdleWrapperClass * klass,
                                 gpointer klass_data)
{
	gp_spin_idle_wrapper_parent_class = g_type_class_peek_parent (klass);
	((GPContextWrapperClass *) klass)->idle = (void (*) (GPContextWrapper*)) gp_spin_idle_wrapper_real_idle;
	((GPContextWrapperClass *) klass)->progress_update = (void (*) (GPContextWrapper*, gfloat, void*)) gp_spin_idle_wrapper_real_progress_update;
}

static void
gp_spin_idle_wrapper_instance_init (GPSpinIdleWrapper * self,
                                    gpointer klass)
{
}

static GType
gp_spin_idle_wrapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GPSpinIdleWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_spin_idle_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPSpinIdleWrapper), 0, (GInstanceInitFunc) gp_spin_idle_wrapper_instance_init, NULL };
	GType gp_spin_idle_wrapper_type_id;
	gp_spin_idle_wrapper_type_id = g_type_register_static (GP_TYPE_CONTEXT_WRAPPER, "GPSpinIdleWrapper", &g_define_type_info, 0);
	return gp_spin_idle_wrapper_type_id;
}

GType
gp_spin_idle_wrapper_get_type (void)
{
	static volatile gsize gp_spin_idle_wrapper_type_id__once = 0;
	if (g_once_init_enter (&gp_spin_idle_wrapper_type_id__once)) {
		GType gp_spin_idle_wrapper_type_id;
		gp_spin_idle_wrapper_type_id = gp_spin_idle_wrapper_get_type_once ();
		g_once_init_leave (&gp_spin_idle_wrapper_type_id__once, gp_spin_idle_wrapper_type_id);
	}
	return gp_spin_idle_wrapper_type_id__once;
}

gboolean
gp_get_info (GPContext* context,
             Camera* camera,
             const gchar* folder,
             const gchar* filename,
             CameraFileInfo* info,
             GError** error)
{
	CameraFileInfo _vala_info = {0};
	int res = 0;
	CameraFileInfo _tmp0_ = {0};
	int _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (camera != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp1_ = gp_camera_file_get_info (camera, folder, filename, &_tmp0_, context);
	 (_vala_info);
	_vala_info = _tmp0_;
	res = _tmp1_;
	if (res != GP_OK) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = gp_port_result_as_string (res);
		_tmp3_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file information for %s/%s: %s", (gint) res, folder, filename, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		 (_vala_info);
		return _tmp4_;
	}
	result = TRUE;
	if (info) {
		*info = _vala_info;
	} else {
		 (_vala_info);
	}
	return result;
}

static gpointer
_GPHOTO_REF_FILE0 (gpointer self)
{
	return self ? GPHOTO_REF_FILE (self) : NULL;
}

GBytes*
gp_camera_file_to_bytes (GPContext* context,
                         CameraFile* file)
{
	guint8* buffer = NULL;
	gint buffer_length1;
	gint _buffer_size_;
	int res = 0;
	guint8* _tmp0_ = NULL;
	gulong _tmp1_ = 0;
	int _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	CameraFile* _tmp4_;
	GBytes* _tmp5_;
	GBytes* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	buffer = NULL;
	buffer_length1 = 0;
	_buffer_size_ = buffer_length1;
	_tmp2_ = gp_file_get_data_and_size (file, &_tmp0_, &_tmp1_);
	buffer = _tmp0_;
	buffer_length1 = _tmp1_;
	_buffer_size_ = buffer_length1;
	res = _tmp2_;
	if (res != GP_OK) {
		result = NULL;
		return result;
	}
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = _GPHOTO_REF_FILE0 (file);
	_tmp5_ = g_bytes_new_with_free_func (_tmp3_, (gsize) _tmp3__length1, gp_file_unref, _tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

PhotoMetadata*
gp_get_fallback_metadata (Camera* camera,
                          GPContext* context,
                          const gchar* folder,
                          const gchar* filename)
{
	CameraStorageInformation* sifs = NULL;
	gint sifs_length1;
	gint _sifs_size_;
	CameraStorageInformation* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GPPortInfo port_info = {0};
	GPPortInfo _tmp2_ = {0};
	gchar* path = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* prefix = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp14_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	sifs = NULL;
	sifs_length1 = 0;
	_sifs_size_ = sifs_length1;
	gp_camera_get_storageinfo (camera, &_tmp0_, &_tmp1_, context);
	sifs = (g_free (sifs), NULL);
	sifs = _tmp0_;
	sifs_length1 = _tmp1_;
	_sifs_size_ = sifs_length1;
	gp_camera_get_port_info (camera, &_tmp2_);
	 (port_info);
	port_info = _tmp2_;
	gp_port_info_get_path (port_info, &_tmp3_);
	_g_free0 (path);
	_tmp4_ = g_strdup (_tmp3_);
	path = _tmp4_;
	_tmp5_ = g_strdup ("disk:");
	prefix = _tmp5_;
	_tmp6_ = path;
	if (g_str_has_prefix (_tmp6_, prefix)) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		_tmp7_ = path;
		_tmp8_ = strlen (prefix);
		_tmp9_ = _tmp8_;
		_tmp10_ = path;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_slice (_tmp7_, (glong) _tmp9_, (glong) _tmp12_);
		_g_free0 (path);
		path = _tmp13_;
	} else {
		result = NULL;
		_g_free0 (prefix);
		_g_free0 (path);
		 (port_info);
		sifs = (g_free (sifs), NULL);
		return result;
	}
	_tmp14_ = photo_metadata_new ();
	metadata = _tmp14_;
	{
		PhotoMetadata* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		_tmp15_ = metadata;
		_tmp16_ = path;
		_tmp17_ = g_strconcat (_tmp16_, folder, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, filename, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_new_for_path (_tmp22_);
		_tmp24_ = _tmp23_;
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp24_, &_inner_error0_);
		_g_object_unref0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_media_metadata_unref0 (metadata);
		metadata = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_media_metadata_unref0 (metadata);
		_g_free0 (prefix);
		_g_free0 (path);
		 (port_info);
		sifs = (g_free (sifs), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = metadata;
	_g_free0 (prefix);
	_g_free0 (path);
	 (port_info);
	sifs = (g_free (sifs), NULL);
	return result;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

GdkPixbuf*
gp_load_preview (GPContext* context,
                 Camera* camera,
                 const gchar* folder,
                 const gchar* filename,
                 gchar** preview_md5,
                 GError** error)
{
	gchar* _vala_preview_md5 = NULL;
	GBytes* raw = NULL;
	GBytes* out_bytes = NULL;
	GBytes* _tmp15_;
	GBytes* _tmp16_;
	GBytes* _tmp17_;
	gchar* _tmp18_;
	GMemoryInputStream* mins = NULL;
	GBytes* _tmp19_;
	GMemoryInputStream* _tmp20_;
	GdkPixbuf* _tmp21_ = NULL;
	GMemoryInputStream* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	raw = NULL;
	out_bytes = NULL;
	_g_free0 (_vala_preview_md5);
	_vala_preview_md5 = NULL;
	{
		GBytes* _tmp0_ = NULL;
		GBytes* _tmp1_;
		GBytes* _tmp2_;
		_tmp1_ = gp_load_file_into_buffer (context, camera, folder, filename, GP_FILE_TYPE_PREVIEW, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_bytes_unref0 (raw);
		raw = _tmp2_;
		_g_bytes_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp3_;
		PhotoMetadata* _tmp4_;
		PhotoMetadata* _tmp5_;
		PhotoPreview* preview = NULL;
		PhotoMetadata* _tmp6_;
		PhotoMetadata* _tmp7_;
		PhotoPreview* _tmp8_;
		GBytes* _tmp9_ = NULL;
		PhotoPreview* _tmp10_;
		GBytes* _tmp11_;
		GBytes* _tmp12_;
		GBytes* _tmp13_;
		gchar* _tmp14_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = gp_get_fallback_metadata (camera, context, folder, filename);
		metadata = _tmp3_;
		_tmp4_ = metadata;
		if (NULL == _tmp4_) {
			result = NULL;
			_media_metadata_unref0 (metadata);
			_g_bytes_unref0 (out_bytes);
			_g_bytes_unref0 (raw);
			if (preview_md5) {
				*preview_md5 = _vala_preview_md5;
			} else {
				_g_free0 (_vala_preview_md5);
			}
			return result;
		}
		_tmp5_ = metadata;
		if (((guint) 0) == photo_metadata_get_preview_count (_tmp5_)) {
			result = NULL;
			_media_metadata_unref0 (metadata);
			_g_bytes_unref0 (out_bytes);
			_g_bytes_unref0 (raw);
			if (preview_md5) {
				*preview_md5 = _vala_preview_md5;
			} else {
				_g_free0 (_vala_preview_md5);
			}
			return result;
		}
		_tmp6_ = metadata;
		_tmp7_ = metadata;
		_tmp8_ = photo_metadata_get_preview (_tmp6_, photo_metadata_get_preview_count (_tmp7_) - 1);
		preview = _tmp8_;
		_tmp10_ = preview;
		_tmp11_ = photo_preview_flatten (_tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_photo_preview_unref0 (preview);
			_media_metadata_unref0 (metadata);
			goto __finally0;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_bytes_unref0 (raw);
		raw = _tmp12_;
		_tmp13_ = raw;
		_tmp14_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp13_);
		_g_free0 (_vala_preview_md5);
		_vala_preview_md5 = _tmp14_;
		_g_bytes_unref0 (_tmp9_);
		_photo_preview_unref0 (preview);
		_media_metadata_unref0 (metadata);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_bytes_unref0 (out_bytes);
		_g_bytes_unref0 (raw);
		_g_free0 (_vala_preview_md5);
		return NULL;
	}
	_tmp15_ = raw;
	_tmp16_ = _g_bytes_ref0 (_tmp15_);
	_g_bytes_unref0 (out_bytes);
	out_bytes = _tmp16_;
	_tmp17_ = out_bytes;
	_tmp18_ = g_compute_checksum_for_bytes (G_CHECKSUM_MD5, _tmp17_);
	_g_free0 (_vala_preview_md5);
	_vala_preview_md5 = _tmp18_;
	_tmp19_ = raw;
	_tmp20_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp19_);
	mins = _tmp20_;
	_tmp22_ = mins;
	_tmp23_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_input_stream_get_type (), GInputStream), IMPORT_PREVIEW_MAX_SCALE, IMPORT_PREVIEW_MAX_SCALE, TRUE, NULL, &_inner_error0_);
	_tmp21_ = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (mins);
		_g_bytes_unref0 (out_bytes);
		_g_bytes_unref0 (raw);
		_g_free0 (_vala_preview_md5);
		return NULL;
	}
	_tmp24_ = _tmp21_;
	_tmp21_ = NULL;
	result = _tmp24_;
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (mins);
	_g_bytes_unref0 (out_bytes);
	_g_bytes_unref0 (raw);
	if (preview_md5) {
		*preview_md5 = _vala_preview_md5;
	} else {
		_g_free0 (_vala_preview_md5);
	}
	return result;
}

GdkPixbuf*
gp_load_image (GPContext* context,
               Camera* camera,
               const gchar* folder,
               const gchar* filename,
               GError** error)
{
	GInputStream* ins = NULL;
	GInputStream* _tmp0_;
	GInputStream* _tmp1_;
	GdkPixbuf* _tmp2_ = NULL;
	GInputStream* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = gp_load_file_into_stream (context, camera, folder, filename, GP_FILE_TYPE_NORMAL, &_inner_error0_);
	ins = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = ins;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (ins);
		return result;
	}
	_tmp3_ = ins;
	_tmp4_ = gdk_pixbuf_new_from_stream (_tmp3_, NULL, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ins);
		return NULL;
	}
	_tmp5_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp5_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (ins);
	return result;
}

void
gp_save_image (GPContext* context,
               Camera* camera,
               const gchar* folder,
               const gchar* filename,
               GFile* dest_file,
               GError** error)
{
	gint fd = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp7_ = NULL;
	int _tmp8_;
	CameraFile* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (context != NULL);
	g_return_if_fail (camera != NULL);
	g_return_if_fail (folder != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest_file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (dest_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = creat (_tmp1_, (mode_t) 0640);
	_g_free0 (_tmp1_);
	fd = _tmp2_;
	if (fd < 0) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = g_file_get_path (dest_file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "[%d] Error creating file %s: %m", errno, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp8_ = gp_file_new_from_fd (&_tmp7_, fd);
	_gp_file_unref0 (camera_file);
	camera_file = _tmp7_;
	res = _tmp8_;
	if (res != GP_OK) {
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp9_ = gp_port_result_as_string (res);
		_tmp10_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) res, _tmp9_);
		_inner_error0_ = _tmp10_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return;
	}
	_tmp11_ = camera_file;
	res = gp_camera_file_get (camera, folder, filename, GP_FILE_TYPE_NORMAL, _tmp11_, context);
	if (res != GP_OK) {
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp12_ = gp_port_result_as_string (res);
		_tmp13_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) res, folder, filename, _tmp12_);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return;
	}
	_gp_file_unref0 (camera_file);
}

static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_bytes_get_size (self);
	return result;
}

PhotoMetadata*
gp_load_metadata (GPContext* context,
                  Camera* camera,
                  const gchar* folder,
                  const gchar* filename,
                  GError** error)
{
	GBytes* camera_raw = NULL;
	gboolean _tmp4_ = FALSE;
	GBytes* _tmp5_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp9_;
	PhotoMetadata* _tmp10_;
	GBytes* _tmp11_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	camera_raw = NULL;
	{
		GBytes* _tmp0_ = NULL;
		GBytes* _tmp1_;
		GBytes* _tmp2_;
		_tmp1_ = gp_load_file_into_buffer (context, camera, folder, filename, GP_FILE_TYPE_EXIF, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_bytes_unref0 (camera_raw);
		camera_raw = _tmp2_;
		_g_bytes_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		PhotoMetadata* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = gp_get_fallback_metadata (camera, context, folder, filename);
		result = _tmp3_;
		_g_bytes_unref0 (camera_raw);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_bytes_unref0 (camera_raw);
		return NULL;
	}
	_tmp5_ = camera_raw;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		GBytes* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = camera_raw;
		_tmp7_ = _vala_g_bytes_get_length (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		result = NULL;
		_g_bytes_unref0 (camera_raw);
		return result;
	}
	_tmp9_ = photo_metadata_new ();
	metadata = _tmp9_;
	_tmp10_ = metadata;
	_tmp11_ = camera_raw;
	photo_metadata_read_from_app1_segment (_tmp10_, _tmp11_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_g_bytes_unref0 (camera_raw);
		return NULL;
	}
	result = metadata;
	_g_bytes_unref0 (camera_raw);
	return result;
}

GInputStream*
gp_load_file_into_stream (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          CameraFileType filetype,
                          GError** error)
{
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	GBytes* bytes = NULL;
	GBytes* _tmp6_;
	GBytes* _tmp7_;
	GFile* temp = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GFileInputStream* _tmp23_ = NULL;
	GFile* _tmp24_;
	GFileInputStream* _tmp25_;
	GFileInputStream* _tmp26_;
	GError* _inner_error0_ = NULL;
	GInputStream* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = gp_file_new (&_tmp0_);
	_gp_file_unref0 (camera_file);
	camera_file = _tmp0_;
	res = _tmp1_;
	if (res != GP_OK) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = gp_port_result_as_string (res);
		_tmp3_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) res, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	res = gp_camera_file_get (camera, folder, filename, filetype, camera_file, context);
	if (res != GP_OK) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp4_ = gp_port_result_as_string (res);
		_tmp5_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) res, folder, filename, _tmp4_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	_tmp6_ = gp_camera_file_to_bytes (context, camera_file);
	bytes = _tmp6_;
	_tmp7_ = bytes;
	if (_tmp7_ != NULL) {
		GBytes* _tmp8_;
		GMemoryInputStream* _tmp9_;
		_tmp8_ = bytes;
		_tmp9_ = (GMemoryInputStream*) g_memory_input_stream_new_from_bytes (_tmp8_);
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_input_stream_get_type (), GInputStream);
		_g_bytes_unref0 (bytes);
		_gp_file_unref0 (camera_file);
		return result;
	}
	_tmp10_ = app_dirs_get_temp_dir ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_child (_tmp11_, "import.tmp");
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	temp = _tmp13_;
	_tmp14_ = temp;
	_tmp15_ = g_file_get_path (_tmp14_);
	_tmp16_ = _tmp15_;
	res = gp_file_save (camera_file, _tmp16_);
	_g_free0 (_tmp16_);
	if (res != GP_OK) {
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		_tmp17_ = temp;
		_tmp18_ = g_file_get_path (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gp_port_result_as_string (res);
		_tmp21_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error copying file %s/%s to %s: %s", (gint) res, folder, filename, _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp19_);
		_inner_error0_ = _tmp22_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (temp);
		_g_bytes_unref0 (bytes);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	_tmp24_ = temp;
	_tmp25_ = g_file_read (_tmp24_, NULL, &_inner_error0_);
	_tmp23_ = _tmp25_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (temp);
		_g_bytes_unref0 (bytes);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	_tmp26_ = _tmp23_;
	_tmp23_ = NULL;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, g_input_stream_get_type (), GInputStream);
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (temp);
	_g_bytes_unref0 (bytes);
	_gp_file_unref0 (camera_file);
	return result;
}

GBytes*
gp_load_file_into_buffer (GPContext* context,
                          Camera* camera,
                          const gchar* folder,
                          const gchar* filename,
                          CameraFileType filetype,
                          GError** error)
{
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_;
	CameraFile* _tmp4_;
	CameraFile* _tmp7_;
	GBytes* _tmp8_;
	GError* _inner_error0_ = NULL;
	GBytes* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = gp_file_new (&_tmp0_);
	_gp_file_unref0 (camera_file);
	camera_file = _tmp0_;
	res = _tmp1_;
	if (res != GP_OK) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = gp_port_result_as_string (res);
		_tmp3_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) res, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	_tmp4_ = camera_file;
	res = gp_camera_file_get (camera, folder, filename, filetype, _tmp4_, context);
	if (res != GP_OK) {
		const gchar* _tmp5_;
		GError* _tmp6_;
		_tmp5_ = gp_port_result_as_string (res);
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) res, folder, filename, _tmp5_);
		_inner_error0_ = _tmp6_;
		g_propagate_error (error, _inner_error0_);
		_gp_file_unref0 (camera_file);
		return NULL;
	}
	_tmp7_ = camera_file;
	_tmp8_ = gp_camera_file_to_bytes (context, _tmp7_);
	result = _tmp8_;
	_gp_file_unref0 (camera_file);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

