/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2010-2014 - Hans-Kristian Arntzen
 *  Copyright (C) 2011-2017 - Daniel De Matteis
 *
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __RARCH_FONT_BITMAP_H
#define __RARCH_FONT_BITMAP_H

#include <stdint.h>

#define FONT_WIDTH 5
#define FONT_HEIGHT 10
/* FONT_HEIGHT_BASELINE_OFFSET:
 * Distance in pixels from top of character
 * to baseline */
#define FONT_HEIGHT_BASELINE_OFFSET 8
#define FONT_WIDTH_STRIDE (FONT_WIDTH + 1)
#define FONT_HEIGHT_STRIDE (FONT_HEIGHT + 1)

#define FONT_OFFSET(x) ((x) * ((FONT_HEIGHT * FONT_WIDTH + 7) / 8))

static const unsigned char bitmap_bin[1792] = {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x00 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x01 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x02 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x03 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x04 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x05 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x06 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x07 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x08 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x09 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0a */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0b */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0c */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0d */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0e */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x0f */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x10 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x11 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x12 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x13 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x14 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x15 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x16 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x17 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x18 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x19 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1a */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1b */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1c */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1d */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1e */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x1f */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x20 */
   0x80,0x10,0x42,0x08,0x20,0x00,0x00, /* code=0x21 */
   0x4A,0x29,0x00,0x00,0x00,0x00,0x00, /* code=0x22 */
   0x00,0xA8,0xAF,0xD4,0x57,0x00,0x00, /* code=0x23 */
   0x80,0xF8,0xE2,0xE8,0x23,0x00,0x00, /* code=0x24 */
   0x60,0x4E,0x44,0x44,0xCE,0x00,0x00, /* code=0x25 */
   0xC0,0xA4,0x64,0x6A,0xB2,0x00,0x00, /* code=0x26 */
   0x84,0x10,0x00,0x00,0x00,0x00,0x00, /* code=0x27 */
   0x88,0x08,0x21,0x84,0x20,0x08,0x00, /* code=0x28 */
   0x82,0x20,0x84,0x10,0x22,0x02,0x00, /* code=0x29 */
   0x00,0x90,0xEA,0x2A,0x01,0x00,0x00, /* code=0x2a */
   0x00,0x10,0xF2,0x09,0x01,0x00,0x00, /* code=0x2b */
   0x00,0x00,0x00,0x00,0x20,0x02,0x00, /* code=0x2c */
   0x00,0x00,0xF0,0x01,0x00,0x00,0x00, /* code=0x2d */
   0x00,0x00,0x00,0x00,0x20,0x00,0x00, /* code=0x2e */
   0x10,0x22,0x44,0x88,0x10,0x01,0x00, /* code=0x2f */
   0xC0,0xC5,0x58,0x63,0x74,0x00,0x00, /* code=0x30 */
   0x80,0x18,0x42,0x08,0x71,0x00,0x00, /* code=0x31 */
   0xC0,0x45,0xC8,0x44,0xF8,0x00,0x00, /* code=0x32 */
   0xC0,0x45,0xC8,0x60,0x74,0x00,0x00, /* code=0x33 */
   0x00,0x31,0x95,0x3E,0x42,0x00,0x00, /* code=0x34 */
   0xE0,0x87,0xF0,0x60,0x74,0x00,0x00, /* code=0x35 */
   0x80,0x89,0xF0,0x62,0x74,0x00,0x00, /* code=0x36 */
   0xE0,0x43,0x84,0x08,0x11,0x00,0x00, /* code=0x37 */
   0xC0,0xC5,0xE8,0x62,0x74,0x00,0x00, /* code=0x38 */
   0xC0,0xC5,0xE8,0x21,0x32,0x00,0x00, /* code=0x39 */
   0x00,0x00,0x02,0x00,0x01,0x00,0x00, /* code=0x3a */
   0x00,0x00,0x02,0x00,0x11,0x00,0x00, /* code=0x3b */
   0x00,0x40,0x36,0x18,0x04,0x00,0x00, /* code=0x3c */
   0x00,0x80,0x0F,0x3E,0x00,0x00,0x00, /* code=0x3d */
   0x00,0x04,0x83,0x4D,0x00,0x00,0x00, /* code=0x3e */
   0xC0,0x45,0x88,0x08,0x20,0x00,0x00, /* code=0x3f */
   0xC0,0xC5,0x5A,0x7B,0xF0,0x00,0x00, /* code=0x40 */
   0x80,0x10,0xA5,0x5C,0x8C,0x00,0x00, /* code=0x41 */
   0xE0,0xC5,0xF8,0x62,0x7C,0x00,0x00, /* code=0x42 */
   0xC0,0xC5,0x10,0x42,0x74,0x00,0x00, /* code=0x43 */
   0xE0,0xA4,0x18,0x63,0x3A,0x00,0x00, /* code=0x44 */
   0xE0,0x87,0xF0,0x42,0xF8,0x00,0x00, /* code=0x45 */
   0xE0,0x87,0xF0,0x42,0x08,0x00,0x00, /* code=0x46 */
   0xC0,0xC5,0x90,0x63,0xF4,0x00,0x00, /* code=0x47 */
   0x20,0xC6,0xF8,0x63,0x8C,0x00,0x00, /* code=0x48 */
   0xC0,0x11,0x42,0x08,0x71,0x00,0x00, /* code=0x49 */
   0x80,0x43,0x08,0x21,0x7C,0x00,0x00, /* code=0x4a */
   0x20,0xA6,0x32,0x4A,0x8A,0x00,0x00, /* code=0x4b */
   0x20,0x84,0x10,0x42,0xF8,0x00,0x00, /* code=0x4c */
   0x20,0xC6,0xBD,0x6B,0x8D,0x00,0x00, /* code=0x4d */
   0x60,0xCE,0x5A,0x6B,0xCE,0x00,0x00, /* code=0x4e */
   0xC0,0xC5,0x18,0x63,0x74,0x00,0x00, /* code=0x4f */
   0xE0,0xC5,0xF8,0x42,0x08,0x00,0x00, /* code=0x50 */
   0xC0,0xC5,0x18,0x63,0xF6,0x00,0x00, /* code=0x51 */
   0xE0,0xC5,0xF8,0x62,0x8C,0x00,0x00, /* code=0x52 */
   0xC0,0xC5,0xE0,0x60,0x74,0x00,0x00, /* code=0x53 */
   0xE0,0x13,0x42,0x08,0x21,0x00,0x00, /* code=0x54 */
   0x20,0xC6,0x18,0x63,0x74,0x00,0x00, /* code=0x55 */
   0x20,0xC6,0xA8,0x14,0x21,0x00,0x00, /* code=0x56 */
   0x20,0xD6,0x5A,0x95,0x52,0x00,0x00, /* code=0x57 */
   0x20,0x46,0x45,0x54,0x8C,0x00,0x00, /* code=0x58 */
   0x20,0xC6,0xE8,0x08,0x21,0x00,0x00, /* code=0x59 */
   0xE0,0x43,0x44,0x44,0xF8,0x00,0x00, /* code=0x5a */
   0x4E,0x08,0x21,0x84,0x10,0x0E,0x00, /* code=0x5b */
   0x21,0x08,0x41,0x08,0x42,0x10,0x00, /* code=0x5c */
   0x0E,0x21,0x84,0x10,0x42,0x0E,0x00, /* code=0x5d */
   0x80,0xA8,0x08,0x00,0x00,0x00,0x00, /* code=0x5e */
   0x00,0x00,0x00,0x00,0x00,0x1F,0x00, /* code=0x5f */
   0x80,0x20,0x00,0x00,0x00,0x00,0x00, /* code=0x60 */
   0x00,0x00,0x07,0x7D,0xF4,0x00,0x00, /* code=0x61 */
   0x21,0x84,0x17,0x63,0x7C,0x00,0x00, /* code=0x62 */
   0x00,0x00,0x1F,0x42,0xF0,0x00,0x00, /* code=0x63 */
   0x10,0x42,0x1F,0x63,0xF4,0x00,0x00, /* code=0x64 */
   0x00,0x00,0x17,0x7F,0xF0,0x00,0x00, /* code=0x65 */
   0x5C,0x88,0x27,0x84,0x10,0x00,0x00, /* code=0x66 */
   0x00,0x00,0x17,0x63,0xF4,0xD0,0x01, /* code=0x67 */
   0x21,0x84,0x17,0x63,0x8C,0x00,0x00, /* code=0x68 */
   0x80,0x00,0x43,0x08,0x21,0x00,0x00, /* code=0x69 */
   0x00,0x01,0x86,0x10,0x42,0xE8,0x00, /* code=0x6a */
   0x42,0x08,0xA9,0x8C,0x92,0x00,0x00, /* code=0x6b */
   0x86,0x10,0x42,0x08,0x21,0x00,0x00, /* code=0x6c */
   0x00,0x80,0x55,0x6B,0xAD,0x00,0x00, /* code=0x6d */
   0x00,0x80,0x17,0x63,0x8C,0x00,0x00, /* code=0x6e */
   0x00,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0x6f */
   0x00,0x80,0x17,0x63,0x7C,0x21,0x00, /* code=0x70 */
   0x00,0x00,0x1F,0x63,0xF4,0x10,0x02, /* code=0x71 */
   0x00,0x80,0x36,0x43,0x08,0x00,0x00, /* code=0x72 */
   0x00,0x00,0x1F,0x1C,0x7C,0x00,0x00, /* code=0x73 */
   0x40,0x08,0x27,0x84,0xE0,0x00,0x00, /* code=0x74 */
   0x00,0x80,0x18,0x63,0xF4,0x00,0x00, /* code=0x75 */
   0x00,0x80,0x18,0x95,0x22,0x00,0x00, /* code=0x76 */
   0x00,0x80,0x58,0xAB,0x52,0x00,0x00, /* code=0x77 */
   0x00,0x80,0xA8,0x88,0x8A,0x00,0x00, /* code=0x78 */
   0x00,0x80,0x18,0x63,0xF4,0xD0,0x01, /* code=0x79 */
   0x00,0x80,0x8F,0x88,0xF8,0x00,0x00, /* code=0x7a */
   0x88,0x10,0x22,0x08,0x21,0x08,0x00, /* code=0x7b */
   0x84,0x10,0x42,0x08,0x21,0x04,0x00, /* code=0x7c */
   0x82,0x10,0x82,0x08,0x21,0x02,0x00, /* code=0x7d */
   0x00,0x00,0x60,0x1B,0x00,0x00,0x00, /* code=0x7e */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x7f */
   0x3F,0xC6,0x18,0x63,0x8C,0xF1,0x03, /* code=0x80 */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x81 */
   0x00,0x00,0x00,0x00,0x40,0x04,0x00, /* code=0x82 */
   0x98,0x10,0x47,0x08,0x21,0x44,0x00, /* code=0x83 */
   0x00,0x00,0x00,0x00,0x50,0x0A,0x00, /* code=0x84 */
   0x00,0x00,0x00,0x00,0xA8,0x00,0x00, /* code=0x85 */
   0x84,0x7C,0x42,0x08,0x21,0x04,0x00, /* code=0x86 */
   0x84,0x7C,0xF2,0x09,0x21,0x04,0x00, /* code=0x87 */
   0x44,0x01,0x00,0x00,0x00,0x00,0x00, /* code=0x88 */
   0x60,0x4E,0x44,0x44,0xAD,0x00,0x00, /* code=0x89 */
   0x8A,0x00,0x1F,0x3E,0x7C,0x00,0x00, /* code=0x8a */
   0x00,0x00,0x44,0x04,0x41,0x00,0x00, /* code=0x8b */
   0x40,0x97,0xD2,0x4A,0xD1,0x00,0x00, /* code=0x8c */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x8d */
   0x8A,0x80,0x8F,0x88,0xF8,0x00,0x00, /* code=0x8e */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x8f */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x90 */
   0x84,0x20,0x00,0x00,0x00,0x00,0x00, /* code=0x91 */
   0x08,0x11,0x00,0x00,0x00,0x00,0x00, /* code=0x92 */
   0x4A,0x51,0x00,0x00,0x00,0x00,0x00, /* code=0x93 */
   0x94,0x2A,0x00,0x00,0x00,0x00,0x00, /* code=0x94 */
   0x00,0x00,0xC0,0x18,0x00,0x00,0x00, /* code=0x95 */
   0x00,0x00,0x00,0x3E,0x00,0x00,0x00, /* code=0x96 */
   0x00,0x00,0x00,0x3E,0x00,0x00,0x00, /* code=0x97 */
   0x00,0x00,0x40,0x15,0x00,0x00,0x00, /* code=0x98 */
   0x00,0x80,0xAF,0xB5,0x06,0x00,0x00, /* code=0x99 */
   0x8A,0x00,0x1F,0x1C,0x7C,0x00,0x00, /* code=0x9a */
   0x00,0x00,0x82,0x20,0x22,0x00,0x00, /* code=0x9b */
   0x00,0x00,0x5D,0x5A,0xD1,0x00,0x00, /* code=0x9c */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0x9d */
   0x8A,0x80,0x8F,0x88,0xF8,0x00,0x00, /* code=0x9e */
   0x0A,0xC4,0x18,0x1D,0x21,0x00,0x00, /* code=0x9f */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0xa0 */
   0x00,0x00,0x02,0x08,0x21,0x84,0x00, /* code=0xa1 */
   0x00,0x20,0xAE,0x14,0x47,0x00,0x00, /* code=0xa2 */
   0x98,0x10,0x4F,0x44,0xF8,0x00,0x00, /* code=0xa3 */
   0x00,0x44,0xA7,0x5C,0x04,0x00,0x00, /* code=0xa4 */
   0x20,0x46,0x47,0x3E,0x21,0x00,0x00, /* code=0xa5 */
   0x84,0x10,0x02,0x08,0x21,0x04,0x00, /* code=0xa6 */
   0x98,0x10,0x17,0xA3,0x23,0x64,0x00, /* code=0xa7 */
   0x40,0x01,0x00,0x00,0x00,0x00,0x00, /* code=0xa8 */
   0xC0,0xC5,0x3B,0x6F,0x74,0x00,0x00, /* code=0xa9 */
   0x04,0x31,0xC5,0x00,0x00,0x00,0x00, /* code=0xaa */
   0x00,0x00,0xAA,0x8A,0xA2,0x00,0x00, /* code=0xab */
   0x00,0x00,0xE0,0x21,0x84,0x00,0x00, /* code=0xac */
   0x00,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0xad */
   0xC0,0xC5,0x3A,0x67,0x74,0x00,0x00, /* code=0xae */
   0xE0,0x03,0x00,0x00,0x00,0x00,0x00, /* code=0xaf */
   0x80,0x38,0x02,0x00,0x00,0x00,0x00, /* code=0xb0 */
   0x00,0x10,0xF2,0x09,0xF9,0x00,0x00, /* code=0xb1 */
   0x06,0x11,0xE1,0x00,0x00,0x00,0x00, /* code=0xb2 */
   0x06,0x19,0x64,0x00,0x00,0x00,0x00, /* code=0xb3 */
   0x88,0x00,0x00,0x00,0x00,0x00,0x00, /* code=0xb4 */
   0x00,0x80,0x94,0x52,0xBA,0x21,0x00, /* code=0xb5 */
   0xC0,0xDF,0x6B,0x29,0xA5,0x94,0x02, /* code=0xb6 */
   0x00,0x00,0x40,0x00,0x00,0x00,0x00, /* code=0xb7 */
   0x00,0x00,0x00,0x00,0x60,0x88,0x00, /* code=0xb8 */
   0xC4,0x10,0xE2,0x00,0x00,0x00,0x00, /* code=0xb9 */
   0x44,0x29,0x02,0x00,0x00,0x00,0x00, /* code=0xba */
   0x00,0x80,0xA2,0xA8,0x2A,0x00,0x00, /* code=0xbb */
   0x30,0xC6,0x44,0x75,0x8F,0x01,0x00, /* code=0xbc */
   0x30,0xA6,0xA2,0x63,0xCA,0x01,0x00, /* code=0xbd */
   0x51,0x4E,0x55,0x75,0x8F,0x01,0x00, /* code=0xbe */
   0x00,0x00,0x02,0x88,0x08,0xD1,0x01, /* code=0xbf */
   0x82,0x00,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc0 */
   0x88,0x00,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc1 */
   0x44,0x01,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc2 */
   0x54,0x01,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc3 */
   0x40,0x01,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc4 */
   0xC4,0x11,0xE2,0x5C,0x8C,0x00,0x00, /* code=0xc5 */
   0xC0,0x1B,0xE3,0x4A,0xE9,0x00,0x00, /* code=0xc6 */
   0xC0,0xC5,0x10,0x42,0x74,0x44,0x00, /* code=0xc7 */
   0x82,0x80,0x1F,0x5E,0xF8,0x00,0x00, /* code=0xc8 */
   0x88,0x80,0x1F,0x5E,0xF8,0x00,0x00, /* code=0xc9 */
   0x44,0x81,0x1F,0x5E,0xF8,0x00,0x00, /* code=0xca */
   0x40,0x81,0x1F,0x5E,0xF8,0x00,0x00, /* code=0xcb */
   0x82,0x00,0x47,0x08,0x71,0x00,0x00, /* code=0xcc */
   0x88,0x00,0x47,0x08,0x71,0x00,0x00, /* code=0xcd */
   0x44,0x01,0x47,0x08,0x71,0x00,0x00, /* code=0xce */
   0x40,0x01,0x47,0x08,0x71,0x00,0x00, /* code=0xcf */
   0xC0,0x28,0x79,0xA5,0x32,0x00,0x00, /* code=0xd0 */
   0x54,0x81,0x59,0x6B,0xCE,0x00,0x00, /* code=0xd1 */
   0x82,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0xd2 */
   0x88,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0xd3 */
   0x44,0x01,0x17,0x63,0x74,0x00,0x00, /* code=0xd4 */
   0x54,0x01,0x17,0x63,0x74,0x00,0x00, /* code=0xd5 */
   0x40,0x01,0x17,0x63,0x74,0x00,0x00, /* code=0xd6 */
   0x00,0x44,0x45,0x54,0x04,0x00,0x00, /* code=0xd7 */
   0xC0,0xC5,0x5C,0x67,0x74,0x00,0x00, /* code=0xd8 */
   0x82,0x80,0x18,0x63,0x74,0x00,0x00, /* code=0xd9 */
   0x88,0x80,0x18,0x63,0x74,0x00,0x00, /* code=0xda */
   0x44,0x81,0x18,0x63,0x74,0x00,0x00, /* code=0xdb */
   0x40,0x81,0x18,0x63,0x74,0x00,0x00, /* code=0xdc */
   0x88,0xC4,0x18,0x1D,0x21,0x00,0x00, /* code=0xdd */
   0x40,0x08,0x27,0xA5,0x13,0x02,0x00, /* code=0xde */
   0xC0,0x49,0xE9,0xA4,0x74,0x01,0x00, /* code=0xdf */
   0x82,0x00,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe0 */
   0x88,0x00,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe1 */
   0x44,0x01,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe2 */
   0x54,0x01,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe3 */
   0x40,0x01,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe4 */
   0xC4,0x11,0x07,0x7D,0xF4,0x00,0x00, /* code=0xe5 */
   0x00,0x00,0x45,0x5D,0xD1,0x00,0x00, /* code=0xe6 */
   0x00,0x00,0x1F,0x42,0xF0,0x44,0x00, /* code=0xe7 */
   0x82,0x00,0x17,0x7F,0xF0,0x00,0x00, /* code=0xe8 */
   0x88,0x00,0x17,0x7F,0xF0,0x00,0x00, /* code=0xe9 */
   0x44,0x01,0x17,0x7F,0xF0,0x00,0x00, /* code=0xea */
   0x40,0x01,0x17,0x7F,0xF0,0x00,0x00, /* code=0xeb */
   0x82,0x00,0x43,0x08,0x21,0x00,0x00, /* code=0xec */
   0x88,0x00,0x43,0x08,0x21,0x00,0x00, /* code=0xed */
   0x44,0x01,0x43,0x08,0x21,0x00,0x00, /* code=0xee */
   0x40,0x01,0x43,0x08,0x21,0x00,0x00, /* code=0xef */
   0xC0,0x22,0xE8,0x63,0x74,0x00,0x00, /* code=0xf0 */
   0x54,0x81,0x17,0x63,0x8C,0x00,0x00, /* code=0xf1 */
   0x82,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0xf2 */
   0x88,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0xf3 */
   0x44,0x01,0x17,0x63,0x74,0x00,0x00, /* code=0xf4 */
   0xAA,0x00,0x17,0x63,0x74,0x00,0x00, /* code=0xf5 */
   0x40,0x01,0x17,0x63,0x74,0x00,0x00, /* code=0xf6 */
   0x00,0x10,0xF0,0x01,0x01,0x00,0x00, /* code=0xf7 */
   0x00,0x00,0x97,0xEB,0x74,0x00,0x00, /* code=0xf8 */
   0x82,0x80,0x18,0x63,0xF4,0x00,0x00, /* code=0xf9 */
   0x88,0x80,0x18,0x63,0xF4,0x00,0x00, /* code=0xfa */
   0x44,0x81,0x18,0x63,0xF4,0x00,0x00, /* code=0xfb */
   0x40,0x81,0x18,0x63,0xF4,0x00,0x00, /* code=0xfc */
   0x88,0x80,0x18,0x63,0xF4,0xD0,0x01, /* code=0xfd */
   0x20,0x84,0x17,0x63,0x7C,0x21,0x00, /* code=0xfe */
   0x40,0x81,0x18,0x63,0xF4,0xD0,0x01  /* code=0xff */
};

typedef struct
{
   bool **lut;
   uint16_t glyph_min;
   uint16_t glyph_max;
} bitmapfont_lut_t;

/* Generates a boolean LUT:
 *   lut[num_glyphs][glyph_width * glyph_height]
 * LUT value is 'true' if glyph pixel has a
 * non-zero value.
 * Returned object must be freed using
 * bitmapfont_free_lut().
 * Returns NULL in the event of an error. */
bitmapfont_lut_t *bitmapfont_get_lut(void);

void bitmapfont_free_lut(bitmapfont_lut_t *font);

#endif
