/*
qtractor - An Audio/MIDI multi-track sequencer.

   Copyright (C) 2005-2024, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qtractorExportForm.ui'
**
** Created by: Qt User Interface Compiler version 6.10.1
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QTRACTOREXPORTFORM_H
#define UI_QTRACTOREXPORTFORM_H

#include <QtCore/QVariant>
#include <QtGui/QIcon>
#include <QtWidgets/QAbstractButton>
#include <QtWidgets/QApplication>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QComboBox>
#include <QtWidgets/QDialog>
#include <QtWidgets/QDialogButtonBox>
#include <QtWidgets/QGridLayout>
#include <QtWidgets/QGroupBox>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QLabel>
#include <QtWidgets/QListWidget>
#include <QtWidgets/QRadioButton>
#include <QtWidgets/QSpacerItem>
#include <QtWidgets/QSpinBox>
#include <QtWidgets/QStackedWidget>
#include <QtWidgets/QToolButton>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QWidget>
#include "qtractorComboBox.h"
#include "qtractorSpinBox.h"

QT_BEGIN_NAMESPACE

class Ui_qtractorExportForm
{
public:
    QGridLayout *gridLayout;
    QLabel *ExportPathTextLabel;
    QHBoxLayout *hboxLayout;
    QComboBox *ExportPathComboBox;
    QToolButton *ExportPathToolButton;
    QStackedWidget *ExportTypeWidget;
    QWidget *AudioExportTypePage;
    QGridLayout *gridLayout1;
    QLabel *AudioExportTypeTextLabel;
    qtractorAudioFileTypeComboBox *AudioExportTypeComboBox;
    QLabel *AudioExportFormatTextLabel;
    qtractorAudioFileFormatComboBox *AudioExportFormatComboBox;
    QLabel *AudioExportQualityTextLabel;
    QSpinBox *AudioExportQualitySpinBox;
    QSpacerItem *spacerItem;
    QWidget *MidiExportTypePage;
    QGridLayout *gridLayout2;
    QLabel *MidiExportFormatTextLabel;
    qtractorMidiFileFormatComboBox *MidiExportFormatComboBox;
    QSpacerItem *spacerItem1;
    QGroupBox *ExportRangeGroupBox;
    QGridLayout *gridLayout3;
    QRadioButton *SessionRangeRadioButton;
    QRadioButton *LoopRangeRadioButton;
    QRadioButton *PunchRangeRadioButton;
    QRadioButton *EditRangeRadioButton;
    QRadioButton *CustomRangeRadioButton;
    QSpacerItem *spacerItem2;
    QLabel *ExportStartTextLLabel;
    qtractorTimeSpinBox *ExportStartSpinBox;
    QLabel *ExportEndTextLLabel;
    qtractorTimeSpinBox *ExportEndSpinBox;
    QSpacerItem *spacerItem3;
    QGroupBox *ExportBusGroupBox;
    QHBoxLayout *hboxLayout1;
    QListWidget *ExportBusNameListBox;
    QGroupBox *FormatGroupBox;
    QVBoxLayout *vboxLayout;
    QComboBox *FormatComboBox;
    QHBoxLayout *hboxLayout2;
    QCheckBox *AddTrackCheckBox;
    QDialogButtonBox *DialogButtonBox;

    void setupUi(QDialog *qtractorExportForm)
    {
        if (qtractorExportForm->objectName().isEmpty())
            qtractorExportForm->setObjectName("qtractorExportForm");
        qtractorExportForm->resize(440, 240);
        qtractorExportForm->setFocusPolicy(Qt::StrongFocus);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/qtractor.svg"));
        qtractorExportForm->setWindowIcon(icon);
        gridLayout = new QGridLayout(qtractorExportForm);
        gridLayout->setSpacing(4);
        gridLayout->setContentsMargins(8, 8, 8, 8);
        gridLayout->setObjectName("gridLayout");
        ExportPathTextLabel = new QLabel(qtractorExportForm);
        ExportPathTextLabel->setObjectName("ExportPathTextLabel");

        gridLayout->addWidget(ExportPathTextLabel, 0, 0, 1, 2);

        hboxLayout = new QHBoxLayout();
        hboxLayout->setSpacing(4);
        hboxLayout->setContentsMargins(0, 0, 0, 0);
        hboxLayout->setObjectName("hboxLayout");
        ExportPathComboBox = new QComboBox(qtractorExportForm);
        ExportPathComboBox->setObjectName("ExportPathComboBox");
        ExportPathComboBox->setMinimumSize(QSize(320, 22));
        ExportPathComboBox->setEditable(true);

        hboxLayout->addWidget(ExportPathComboBox);

        ExportPathToolButton = new QToolButton(qtractorExportForm);
        ExportPathToolButton->setObjectName("ExportPathToolButton");
        ExportPathToolButton->setMinimumSize(QSize(22, 22));
        ExportPathToolButton->setMaximumSize(QSize(24, 24));
        ExportPathToolButton->setFocusPolicy(Qt::TabFocus);
        QIcon icon1(QIcon::fromTheme(QString::fromUtf8("fileOpen")));
        ExportPathToolButton->setIcon(icon1);

        hboxLayout->addWidget(ExportPathToolButton);


        gridLayout->addLayout(hboxLayout, 1, 0, 1, 2);

        ExportTypeWidget = new QStackedWidget(qtractorExportForm);
        ExportTypeWidget->setObjectName("ExportTypeWidget");
        AudioExportTypePage = new QWidget();
        AudioExportTypePage->setObjectName("AudioExportTypePage");
        gridLayout1 = new QGridLayout(AudioExportTypePage);
        gridLayout1->setSpacing(4);
        gridLayout1->setContentsMargins(4, 4, 4, 4);
        gridLayout1->setObjectName("gridLayout1");
        AudioExportTypeTextLabel = new QLabel(AudioExportTypePage);
        AudioExportTypeTextLabel->setObjectName("AudioExportTypeTextLabel");
        QFont font;
        font.setBold(false);
        AudioExportTypeTextLabel->setFont(font);
        AudioExportTypeTextLabel->setAlignment(Qt::AlignRight|Qt::AlignVCenter);

        gridLayout1->addWidget(AudioExportTypeTextLabel, 0, 0, 1, 1);

        AudioExportTypeComboBox = new qtractorAudioFileTypeComboBox(AudioExportTypePage);
        AudioExportTypeComboBox->setObjectName("AudioExportTypeComboBox");
        AudioExportTypeComboBox->setFont(font);

        gridLayout1->addWidget(AudioExportTypeComboBox, 0, 1, 1, 3);

        AudioExportFormatTextLabel = new QLabel(AudioExportTypePage);
        AudioExportFormatTextLabel->setObjectName("AudioExportFormatTextLabel");
        AudioExportFormatTextLabel->setFont(font);
        AudioExportFormatTextLabel->setAlignment(Qt::AlignRight|Qt::AlignVCenter);

        gridLayout1->addWidget(AudioExportFormatTextLabel, 1, 0, 1, 1);

        AudioExportFormatComboBox = new qtractorAudioFileFormatComboBox(AudioExportTypePage);
        AudioExportFormatComboBox->setObjectName("AudioExportFormatComboBox");
        AudioExportFormatComboBox->setFont(font);

        gridLayout1->addWidget(AudioExportFormatComboBox, 1, 1, 1, 1);

        AudioExportQualityTextLabel = new QLabel(AudioExportTypePage);
        AudioExportQualityTextLabel->setObjectName("AudioExportQualityTextLabel");
        AudioExportQualityTextLabel->setFont(font);
        AudioExportQualityTextLabel->setAlignment(Qt::AlignRight|Qt::AlignVCenter);

        gridLayout1->addWidget(AudioExportQualityTextLabel, 1, 2, 1, 1);

        AudioExportQualitySpinBox = new QSpinBox(AudioExportTypePage);
        AudioExportQualitySpinBox->setObjectName("AudioExportQualitySpinBox");
        AudioExportQualitySpinBox->setMaximumSize(QSize(60, 32767));
        AudioExportQualitySpinBox->setFont(font);
        AudioExportQualitySpinBox->setMinimum(0);
        AudioExportQualitySpinBox->setMaximum(10);
        AudioExportQualitySpinBox->setSingleStep(1);
        AudioExportQualitySpinBox->setValue(4);

        gridLayout1->addWidget(AudioExportQualitySpinBox, 1, 3, 1, 1);

        spacerItem = new QSpacerItem(22, 22, QSizePolicy::Policy::Fixed, QSizePolicy::Policy::Minimum);

        gridLayout1->addItem(spacerItem, 0, 4, 2, 1);

        ExportTypeWidget->addWidget(AudioExportTypePage);
        MidiExportTypePage = new QWidget();
        MidiExportTypePage->setObjectName("MidiExportTypePage");
        gridLayout2 = new QGridLayout(MidiExportTypePage);
        gridLayout2->setSpacing(4);
        gridLayout2->setContentsMargins(4, 4, 4, 4);
        gridLayout2->setObjectName("gridLayout2");
        MidiExportFormatTextLabel = new QLabel(MidiExportTypePage);
        MidiExportFormatTextLabel->setObjectName("MidiExportFormatTextLabel");
        MidiExportFormatTextLabel->setFont(font);
        MidiExportFormatTextLabel->setAlignment(Qt::AlignRight|Qt::AlignVCenter);

        gridLayout2->addWidget(MidiExportFormatTextLabel, 0, 0, 1, 2);

        MidiExportFormatComboBox = new qtractorMidiFileFormatComboBox(MidiExportTypePage);
        MidiExportFormatComboBox->setObjectName("MidiExportFormatComboBox");
        MidiExportFormatComboBox->setFont(font);

        gridLayout2->addWidget(MidiExportFormatComboBox, 0, 2, 1, 1);

        spacerItem1 = new QSpacerItem(22, 22, QSizePolicy::Policy::Fixed, QSizePolicy::Policy::Minimum);

        gridLayout2->addItem(spacerItem1, 0, 3, 1, 1);

        ExportTypeWidget->addWidget(MidiExportTypePage);

        gridLayout->addWidget(ExportTypeWidget, 2, 0, 1, 2);

        ExportRangeGroupBox = new QGroupBox(qtractorExportForm);
        ExportRangeGroupBox->setObjectName("ExportRangeGroupBox");
        gridLayout3 = new QGridLayout(ExportRangeGroupBox);
        gridLayout3->setSpacing(4);
        gridLayout3->setContentsMargins(8, 8, 8, 8);
        gridLayout3->setObjectName("gridLayout3");
        gridLayout3->setContentsMargins(8, 8, 8, 8);
        SessionRangeRadioButton = new QRadioButton(ExportRangeGroupBox);
        SessionRangeRadioButton->setObjectName("SessionRangeRadioButton");
        SessionRangeRadioButton->setChecked(false);

        gridLayout3->addWidget(SessionRangeRadioButton, 0, 0, 1, 3);

        LoopRangeRadioButton = new QRadioButton(ExportRangeGroupBox);
        LoopRangeRadioButton->setObjectName("LoopRangeRadioButton");
        LoopRangeRadioButton->setChecked(false);

        gridLayout3->addWidget(LoopRangeRadioButton, 1, 0, 1, 3);

        PunchRangeRadioButton = new QRadioButton(ExportRangeGroupBox);
        PunchRangeRadioButton->setObjectName("PunchRangeRadioButton");
        PunchRangeRadioButton->setChecked(false);

        gridLayout3->addWidget(PunchRangeRadioButton, 2, 0, 1, 3);

        EditRangeRadioButton = new QRadioButton(ExportRangeGroupBox);
        EditRangeRadioButton->setObjectName("EditRangeRadioButton");
        EditRangeRadioButton->setChecked(false);

        gridLayout3->addWidget(EditRangeRadioButton, 3, 0, 1, 3);

        CustomRangeRadioButton = new QRadioButton(ExportRangeGroupBox);
        CustomRangeRadioButton->setObjectName("CustomRangeRadioButton");
        CustomRangeRadioButton->setChecked(true);

        gridLayout3->addWidget(CustomRangeRadioButton, 4, 0, 1, 3);

        spacerItem2 = new QSpacerItem(16, 16, QSizePolicy::Policy::Fixed, QSizePolicy::Policy::Minimum);

        gridLayout3->addItem(spacerItem2, 5, 0, 2, 1);

        ExportStartTextLLabel = new QLabel(ExportRangeGroupBox);
        ExportStartTextLLabel->setObjectName("ExportStartTextLLabel");

        gridLayout3->addWidget(ExportStartTextLLabel, 5, 1, 1, 1);

        ExportStartSpinBox = new qtractorTimeSpinBox(ExportRangeGroupBox);
        ExportStartSpinBox->setObjectName("ExportStartSpinBox");
        ExportStartSpinBox->setMinimumSize(QSize(120, 0));

        gridLayout3->addWidget(ExportStartSpinBox, 5, 2, 1, 1);

        ExportEndTextLLabel = new QLabel(ExportRangeGroupBox);
        ExportEndTextLLabel->setObjectName("ExportEndTextLLabel");

        gridLayout3->addWidget(ExportEndTextLLabel, 6, 1, 1, 1);

        ExportEndSpinBox = new qtractorTimeSpinBox(ExportRangeGroupBox);
        ExportEndSpinBox->setObjectName("ExportEndSpinBox");
        ExportEndSpinBox->setMinimumSize(QSize(120, 0));

        gridLayout3->addWidget(ExportEndSpinBox, 6, 2, 1, 1);

        spacerItem3 = new QSpacerItem(20, 20, QSizePolicy::Policy::Expanding, QSizePolicy::Policy::Minimum);

        gridLayout3->addItem(spacerItem3, 0, 3, 7, 1);


        gridLayout->addWidget(ExportRangeGroupBox, 3, 0, 2, 1);

        ExportBusGroupBox = new QGroupBox(qtractorExportForm);
        ExportBusGroupBox->setObjectName("ExportBusGroupBox");
        ExportBusGroupBox->setMinimumSize(QSize(160, 120));
        hboxLayout1 = new QHBoxLayout(ExportBusGroupBox);
        hboxLayout1->setSpacing(4);
        hboxLayout1->setContentsMargins(4, 4, 4, 4);
        hboxLayout1->setObjectName("hboxLayout1");
        ExportBusNameListBox = new QListWidget(ExportBusGroupBox);
        ExportBusNameListBox->setObjectName("ExportBusNameListBox");
        ExportBusNameListBox->setSelectionMode(QAbstractItemView::ExtendedSelection);

        hboxLayout1->addWidget(ExportBusNameListBox);


        gridLayout->addWidget(ExportBusGroupBox, 3, 1, 1, 1);

        FormatGroupBox = new QGroupBox(qtractorExportForm);
        FormatGroupBox->setObjectName("FormatGroupBox");
        vboxLayout = new QVBoxLayout(FormatGroupBox);
        vboxLayout->setSpacing(4);
        vboxLayout->setContentsMargins(8, 8, 8, 8);
        vboxLayout->setObjectName("vboxLayout");
        FormatComboBox = new QComboBox(FormatGroupBox);
        FormatComboBox->addItem(QString());
        FormatComboBox->addItem(QString());
        FormatComboBox->addItem(QString());
        FormatComboBox->setObjectName("FormatComboBox");

        vboxLayout->addWidget(FormatComboBox);


        gridLayout->addWidget(FormatGroupBox, 4, 1, 1, 1);

        hboxLayout2 = new QHBoxLayout();
        hboxLayout2->setSpacing(4);
        hboxLayout2->setContentsMargins(8, 8, 8, 8);
        hboxLayout2->setObjectName("hboxLayout2");
        AddTrackCheckBox = new QCheckBox(qtractorExportForm);
        AddTrackCheckBox->setObjectName("AddTrackCheckBox");

        hboxLayout2->addWidget(AddTrackCheckBox);

        DialogButtonBox = new QDialogButtonBox(qtractorExportForm);
        DialogButtonBox->setObjectName("DialogButtonBox");
        DialogButtonBox->setOrientation(Qt::Horizontal);
        DialogButtonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);

        hboxLayout2->addWidget(DialogButtonBox);


        gridLayout->addLayout(hboxLayout2, 5, 0, 1, 2);

#if QT_CONFIG(shortcut)
        ExportPathTextLabel->setBuddy(ExportPathComboBox);
        AudioExportTypeTextLabel->setBuddy(AudioExportTypeComboBox);
        AudioExportFormatTextLabel->setBuddy(AudioExportFormatComboBox);
        AudioExportQualityTextLabel->setBuddy(AudioExportQualitySpinBox);
        MidiExportFormatTextLabel->setBuddy(MidiExportFormatComboBox);
        ExportStartTextLLabel->setBuddy(ExportStartSpinBox);
        ExportEndTextLLabel->setBuddy(ExportEndSpinBox);
#endif // QT_CONFIG(shortcut)
        QWidget::setTabOrder(ExportPathComboBox, ExportPathToolButton);
        QWidget::setTabOrder(ExportPathToolButton, AudioExportTypeComboBox);
        QWidget::setTabOrder(AudioExportTypeComboBox, AudioExportFormatComboBox);
        QWidget::setTabOrder(AudioExportFormatComboBox, AudioExportQualitySpinBox);
        QWidget::setTabOrder(AudioExportQualitySpinBox, MidiExportFormatComboBox);
        QWidget::setTabOrder(MidiExportFormatComboBox, SessionRangeRadioButton);
        QWidget::setTabOrder(SessionRangeRadioButton, LoopRangeRadioButton);
        QWidget::setTabOrder(LoopRangeRadioButton, PunchRangeRadioButton);
        QWidget::setTabOrder(PunchRangeRadioButton, EditRangeRadioButton);
        QWidget::setTabOrder(EditRangeRadioButton, CustomRangeRadioButton);
        QWidget::setTabOrder(CustomRangeRadioButton, ExportStartSpinBox);
        QWidget::setTabOrder(ExportStartSpinBox, ExportEndSpinBox);
        QWidget::setTabOrder(ExportEndSpinBox, ExportBusNameListBox);
        QWidget::setTabOrder(ExportBusNameListBox, FormatComboBox);
        QWidget::setTabOrder(FormatComboBox, AddTrackCheckBox);

        retranslateUi(qtractorExportForm);

        QMetaObject::connectSlotsByName(qtractorExportForm);
    } // setupUi

    void retranslateUi(QDialog *qtractorExportForm)
    {
        qtractorExportForm->setWindowTitle(QCoreApplication::translate("qtractorExportForm", "Export", nullptr));
        ExportPathTextLabel->setText(QCoreApplication::translate("qtractorExportForm", "&File:", nullptr));
#if QT_CONFIG(tooltip)
        ExportPathComboBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Export file name", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        ExportPathToolButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Browse export file name", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioExportTypeTextLabel->setText(QCoreApplication::translate("qtractorExportForm", "File &type:", nullptr));
#if QT_CONFIG(tooltip)
        AudioExportTypeComboBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Audio file type to use on export", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioExportFormatTextLabel->setText(QCoreApplication::translate("qtractorExportForm", "Sample &format:", nullptr));
#if QT_CONFIG(tooltip)
        AudioExportFormatComboBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Audio sample format to use on export", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioExportQualityTextLabel->setText(QCoreApplication::translate("qtractorExportForm", "&Quality:", nullptr));
#if QT_CONFIG(tooltip)
        AudioExportQualitySpinBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Audio compression quality to use on export", nullptr));
#endif // QT_CONFIG(tooltip)
        AudioExportQualitySpinBox->setSuffix(QString());
        MidiExportFormatTextLabel->setText(QCoreApplication::translate("qtractorExportForm", "File &format:", nullptr));
#if QT_CONFIG(tooltip)
        MidiExportFormatComboBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "MIDI file format to use on export", nullptr));
#endif // QT_CONFIG(tooltip)
        ExportRangeGroupBox->setTitle(QCoreApplication::translate("qtractorExportForm", "Range", nullptr));
#if QT_CONFIG(tooltip)
        SessionRangeRadioButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Session range", nullptr));
#endif // QT_CONFIG(tooltip)
        SessionRangeRadioButton->setText(QCoreApplication::translate("qtractorExportForm", "&Session", nullptr));
#if QT_CONFIG(tooltip)
        LoopRangeRadioButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Loop range", nullptr));
#endif // QT_CONFIG(tooltip)
        LoopRangeRadioButton->setText(QCoreApplication::translate("qtractorExportForm", "&Loop", nullptr));
#if QT_CONFIG(tooltip)
        PunchRangeRadioButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Punch range", nullptr));
#endif // QT_CONFIG(tooltip)
        PunchRangeRadioButton->setText(QCoreApplication::translate("qtractorExportForm", "&Punch", nullptr));
#if QT_CONFIG(tooltip)
        EditRangeRadioButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Edit range", nullptr));
#endif // QT_CONFIG(tooltip)
        EditRangeRadioButton->setText(QCoreApplication::translate("qtractorExportForm", "&Edit", nullptr));
#if QT_CONFIG(tooltip)
        CustomRangeRadioButton->setToolTip(QCoreApplication::translate("qtractorExportForm", "Custom range", nullptr));
#endif // QT_CONFIG(tooltip)
        CustomRangeRadioButton->setText(QCoreApplication::translate("qtractorExportForm", "&Custom", nullptr));
        ExportStartTextLLabel->setText(QCoreApplication::translate("qtractorExportForm", "St&art:", nullptr));
#if QT_CONFIG(tooltip)
        ExportStartSpinBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Custom start", nullptr));
#endif // QT_CONFIG(tooltip)
        ExportEndTextLLabel->setText(QCoreApplication::translate("qtractorExportForm", "En&d:", nullptr));
#if QT_CONFIG(tooltip)
        ExportEndSpinBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Custom end", nullptr));
#endif // QT_CONFIG(tooltip)
        ExportBusGroupBox->setTitle(QCoreApplication::translate("qtractorExportForm", "Outputs", nullptr));
#if QT_CONFIG(tooltip)
        ExportBusNameListBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Output bus names", nullptr));
#endif // QT_CONFIG(tooltip)
        FormatGroupBox->setTitle(QCoreApplication::translate("qtractorExportForm", "Format", nullptr));
        FormatComboBox->setItemText(0, QCoreApplication::translate("qtractorExportForm", "Frames", nullptr));
        FormatComboBox->setItemText(1, QCoreApplication::translate("qtractorExportForm", "Time", nullptr));
        FormatComboBox->setItemText(2, QCoreApplication::translate("qtractorExportForm", "BBT", nullptr));

#if QT_CONFIG(tooltip)
        FormatComboBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Time display format", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(tooltip)
        AddTrackCheckBox->setToolTip(QCoreApplication::translate("qtractorExportForm", "Whether to add/import new track(s) with export result", nullptr));
#endif // QT_CONFIG(tooltip)
        AddTrackCheckBox->setText(QCoreApplication::translate("qtractorExportForm", "&Add new track(s)", nullptr));
    } // retranslateUi

};

namespace Ui {
    class qtractorExportForm: public Ui_qtractorExportForm {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QTRACTOREXPORTFORM_H
