// This file is generated by kconfig_compiler_kf6 from colorssettings.kcfg.
// All changes you do to this file will be lost.
#ifndef COLORSSETTINGS_H
#define COLORSSETTINGS_H

#include <qglobal.h>
#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class ColorsSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:

    ColorsSettings( QObject *parent = nullptr );
    ~ColorsSettings() override;

    /**
      Set Color scheme name
    */
    void setColorScheme( const QString & v )
    {
      if (v != mColorScheme && !isColorSchemeImmutable()) {
        mColorScheme = v;
        Q_EMIT colorSchemeChanged();
      }
    }

    Q_PROPERTY(QString colorScheme READ colorScheme WRITE setColorScheme NOTIFY colorSchemeChanged)
    Q_PROPERTY(bool isColorSchemeImmutable READ isColorSchemeImmutable CONSTANT)
    Q_PROPERTY(QString defaultColorSchemeValue READ defaultColorSchemeValue CONSTANT)
    /**
      Get Color scheme name
    */
    QString colorScheme() const
    {
      return mColorScheme;
    }

    /**
      Is Color scheme name Immutable
    */
    bool isColorSchemeImmutable() const
    {
      return isImmutable( QStringLiteral( "colorScheme" ) );
    }

    /**
      Get Color scheme name default value
    */
    QString defaultColorSchemeValue() const
    {
        return defaultColorSchemeValue_helper();
    }

    /**
      Set Accent color
    */
    void setAccentColor( const QColor & v )
    {
      if (v != mAccentColor && !isAccentColorImmutable()) {
        mAccentColor = v;
        Q_EMIT accentColorChanged();
      }
    }

    Q_PROPERTY(QColor accentColor READ accentColor WRITE setAccentColor NOTIFY accentColorChanged)
    Q_PROPERTY(bool isAccentColorImmutable READ isAccentColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultAccentColorValue READ defaultAccentColorValue CONSTANT)
    /**
      Get Accent color
    */
    QColor accentColor() const
    {
      return mAccentColor;
    }

    /**
      Is Accent color Immutable
    */
    bool isAccentColorImmutable() const
    {
      return isImmutable( QStringLiteral( "accentColor" ) );
    }

    /**
      Get Accent color default value
    */
    QColor defaultAccentColorValue() const
    {
        return defaultAccentColorValue_helper();
    }

    /**
      Set The last used custom accent color before user switched to wallpaper generated color or default color
    */
    void setLastUsedCustomAccentColor( const QColor & v )
    {
      if (v != mLastUsedCustomAccentColor && !isLastUsedCustomAccentColorImmutable()) {
        mLastUsedCustomAccentColor = v;
        Q_EMIT lastUsedCustomAccentColorChanged();
      }
    }

    Q_PROPERTY(QColor lastUsedCustomAccentColor READ lastUsedCustomAccentColor WRITE setLastUsedCustomAccentColor NOTIFY lastUsedCustomAccentColorChanged)
    Q_PROPERTY(bool isLastUsedCustomAccentColorImmutable READ isLastUsedCustomAccentColorImmutable CONSTANT)
    Q_PROPERTY(QColor defaultLastUsedCustomAccentColorValue READ defaultLastUsedCustomAccentColorValue CONSTANT)
    /**
      Get The last used custom accent color before user switched to wallpaper generated color or default color
    */
    QColor lastUsedCustomAccentColor() const
    {
      return mLastUsedCustomAccentColor;
    }

    /**
      Is The last used custom accent color before user switched to wallpaper generated color or default color Immutable
    */
    bool isLastUsedCustomAccentColorImmutable() const
    {
      return isImmutable( QStringLiteral( "lastUsedCustomAccentColor" ) );
    }

    /**
      Get The last used custom accent color before user switched to wallpaper generated color or default color default value
    */
    QColor defaultLastUsedCustomAccentColorValue() const
    {
        return defaultLastUsedCustomAccentColorValue_helper();
    }

    /**
      Set Whether accent color from wallpaper should be applied
    */
    void setAccentColorFromWallpaper( bool v )
    {
      if (v != mAccentColorFromWallpaper && !isAccentColorFromWallpaperImmutable()) {
        mAccentColorFromWallpaper = v;
        Q_EMIT accentColorFromWallpaperChanged();
      }
    }

    Q_PROPERTY(bool accentColorFromWallpaper READ accentColorFromWallpaper WRITE setAccentColorFromWallpaper NOTIFY accentColorFromWallpaperChanged)
    Q_PROPERTY(bool isAccentColorFromWallpaperImmutable READ isAccentColorFromWallpaperImmutable CONSTANT)
    Q_PROPERTY(bool defaultAccentColorFromWallpaperValue READ defaultAccentColorFromWallpaperValue CONSTANT)
    /**
      Get Whether accent color from wallpaper should be applied
    */
    bool accentColorFromWallpaper() const
    {
      return mAccentColorFromWallpaper;
    }

    /**
      Is Whether accent color from wallpaper should be applied Immutable
    */
    bool isAccentColorFromWallpaperImmutable() const
    {
      return isImmutable( QStringLiteral( "accentColorFromWallpaper" ) );
    }

    /**
      Get Whether accent color from wallpaper should be applied default value
    */
    bool defaultAccentColorFromWallpaperValue() const
    {
        return defaultAccentColorFromWallpaperValue_helper();
    }


    enum {
      signalColorSchemeChanged = 1,
      signalAccentColorChanged = 2,
      signalLastUsedCustomAccentColorChanged = 3,
      signalAccentColorFromWallpaperChanged = 4
    };

  Q_SIGNALS:
    void colorSchemeChanged();

    void accentColorChanged();

    void lastUsedCustomAccentColorChanged();

    void accentColorFromWallpaperChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:

    // General
    QString mColorScheme;
    QString defaultColorSchemeValue_helper() const;
    QColor mAccentColor;
    QColor defaultAccentColorValue_helper() const;
    QColor mLastUsedCustomAccentColor;
    QColor defaultLastUsedCustomAccentColorValue_helper() const;
    bool mAccentColorFromWallpaper;
    bool defaultAccentColorFromWallpaperValue_helper() const;
};

#endif

