/* Generated by wayland-scanner 1.24.0 */

#ifndef PHOSH_CLIENT_PROTOCOL_H
#define PHOSH_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_phosh The phosh protocol
 * @section page_ifaces_phosh Interfaces
 * - @subpage page_iface_phosh_private - Phone shell extensions
 * - @subpage page_iface_phosh_private_keyboard_event - Interface for additional keyboard events
 * - @subpage page_iface_phosh_private_xdg_switcher - Interface to list and raise xdg surfaces
 * - @subpage page_iface_phosh_private_startup_tracker - Interface to track application startup
 */
struct phosh_private;
struct phosh_private_keyboard_event;
struct phosh_private_startup_tracker;
struct phosh_private_xdg_switcher;
struct wl_surface;
struct zwlr_foreign_toplevel_handle_v1;
struct zwlr_screencopy_frame_v1;

#ifndef PHOSH_PRIVATE_INTERFACE
#define PHOSH_PRIVATE_INTERFACE
/**
 * @page page_iface_phosh_private phosh_private
 * @section page_iface_phosh_private_desc Description
 *
 * Private protocol between phosh and the compositor.
 * @section page_iface_phosh_private_api API
 * See @ref iface_phosh_private.
 */
/**
 * @defgroup iface_phosh_private The phosh_private interface
 *
 * Private protocol between phosh and the compositor.
 */
extern const struct wl_interface phosh_private_interface;
#endif
#ifndef PHOSH_PRIVATE_KEYBOARD_EVENT_INTERFACE
#define PHOSH_PRIVATE_KEYBOARD_EVENT_INTERFACE
/**
 * @page page_iface_phosh_private_keyboard_event phosh_private_keyboard_event
 * @section page_iface_phosh_private_keyboard_event_desc Description
 *
 * The interface is meant to allow subscription and forwarding of keyboard events.
 * @section page_iface_phosh_private_keyboard_event_api API
 * See @ref iface_phosh_private_keyboard_event.
 */
/**
 * @defgroup iface_phosh_private_keyboard_event The phosh_private_keyboard_event interface
 *
 * The interface is meant to allow subscription and forwarding of keyboard events.
 */
extern const struct wl_interface phosh_private_keyboard_event_interface;
#endif
#ifndef PHOSH_PRIVATE_XDG_SWITCHER_INTERFACE
#define PHOSH_PRIVATE_XDG_SWITCHER_INTERFACE
/**
 * @page page_iface_phosh_private_xdg_switcher phosh_private_xdg_switcher
 * @section page_iface_phosh_private_xdg_switcher_desc Description
 *
 * This interface is unused, ignore. Use wlr-foreign-toplevel-management instead.
 * @section page_iface_phosh_private_xdg_switcher_api API
 * See @ref iface_phosh_private_xdg_switcher.
 */
/**
 * @defgroup iface_phosh_private_xdg_switcher The phosh_private_xdg_switcher interface
 *
 * This interface is unused, ignore. Use wlr-foreign-toplevel-management instead.
 */
extern const struct wl_interface phosh_private_xdg_switcher_interface;
#endif
#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_INTERFACE
#define PHOSH_PRIVATE_STARTUP_TRACKER_INTERFACE
/**
 * @page page_iface_phosh_private_startup_tracker phosh_private_startup_tracker
 * @section page_iface_phosh_private_startup_tracker_desc Description
 *
 * Allows shells to track application startup.
 * @section page_iface_phosh_private_startup_tracker_api API
 * See @ref iface_phosh_private_startup_tracker.
 */
/**
 * @defgroup iface_phosh_private_startup_tracker The phosh_private_startup_tracker interface
 *
 * Allows shells to track application startup.
 */
extern const struct wl_interface phosh_private_startup_tracker_interface;
#endif

#ifndef PHOSH_PRIVATE_ERROR_ENUM
#define PHOSH_PRIVATE_ERROR_ENUM
enum phosh_private_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* PHOSH_PRIVATE_ERROR_ENUM */

#ifndef PHOSH_PRIVATE_SHELL_STATE_ENUM
#define PHOSH_PRIVATE_SHELL_STATE_ENUM
enum phosh_private_shell_state {
	/**
	 * shell state unknown
	 */
	PHOSH_PRIVATE_SHELL_STATE_UNKNOWN = 0,
	/**
	 * shell is up and running
	 */
	PHOSH_PRIVATE_SHELL_STATE_UP = 1,
};
#endif /* PHOSH_PRIVATE_SHELL_STATE_ENUM */

#define PHOSH_PRIVATE_ROTATE_DISPLAY 0
#define PHOSH_PRIVATE_GET_XDG_SWITCHER 1
#define PHOSH_PRIVATE_GET_THUMBNAIL 2
#define PHOSH_PRIVATE_GET_KEYBOARD_EVENT 3
#define PHOSH_PRIVATE_GET_STARTUP_TRACKER 4
#define PHOSH_PRIVATE_SET_SHELL_STATE 5


/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_ROTATE_DISPLAY_SINCE_VERSION 1
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_XDG_SWITCHER_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_THUMBNAIL_SINCE_VERSION 4
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_KEYBOARD_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_STARTUP_TRACKER_SINCE_VERSION 6
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_SET_SHELL_STATE_SINCE_VERSION 6

/** @ingroup iface_phosh_private */
static inline void
phosh_private_set_user_data(struct phosh_private *phosh_private, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) phosh_private, user_data);
}

/** @ingroup iface_phosh_private */
static inline void *
phosh_private_get_user_data(struct phosh_private *phosh_private)
{
	return wl_proxy_get_user_data((struct wl_proxy *) phosh_private);
}

static inline uint32_t
phosh_private_get_version(struct phosh_private *phosh_private)
{
	return wl_proxy_get_version((struct wl_proxy *) phosh_private);
}

/** @ingroup iface_phosh_private */
static inline void
phosh_private_destroy(struct phosh_private *phosh_private)
{
	wl_proxy_destroy((struct wl_proxy *) phosh_private);
}

/**
 * @ingroup iface_phosh_private
 *
 * This request is unused, ignore. Use wlr-output-management instead.
 */
static inline void
phosh_private_rotate_display(struct phosh_private *phosh_private, struct wl_surface *surface, uint32_t degree)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_ROTATE_DISPLAY, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, surface, degree);
}

/**
 * @ingroup iface_phosh_private
 *
 * This request is unused, ignore. Use wlr-foreign-toplevel-management instead.
 */
static inline struct phosh_private_xdg_switcher *
phosh_private_get_xdg_switcher(struct phosh_private *phosh_private)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_GET_XDG_SWITCHER, &phosh_private_xdg_switcher_interface, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, NULL);

	return (struct phosh_private_xdg_switcher *) id;
}

/**
 * @ingroup iface_phosh_private
 *
 * Allows to retrieve a window thumbnail image for a given foreign
 * toplevel via wlr_screencopy protocol.
 *
 * The thumbnail will be scaled down to the size provided by
 * max_width and max_height arguments, preserving original aspect
 * ratio. Pass 0 to leave it unconstrained.
 */
static inline struct zwlr_screencopy_frame_v1 *
phosh_private_get_thumbnail(struct phosh_private *phosh_private, struct zwlr_foreign_toplevel_handle_v1 *toplevel, uint32_t max_width, uint32_t max_height)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_GET_THUMBNAIL, &zwlr_screencopy_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, NULL, toplevel, max_width, max_height);

	return (struct zwlr_screencopy_frame_v1 *) id;
}

/**
 * @ingroup iface_phosh_private
 *
 * Allows to subscribe to specific keyboard events.
 *
 * The client grabs an accelerator by a string and gets an action id returned.
 * When the accelerator is used the client will be informed via the corresponding
 * action id.
 */
static inline struct phosh_private_keyboard_event *
phosh_private_get_keyboard_event(struct phosh_private *phosh_private)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_GET_KEYBOARD_EVENT, &phosh_private_keyboard_event_interface, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, NULL);

	return (struct phosh_private_keyboard_event *) id;
}

/**
 * @ingroup iface_phosh_private
 *
 * Allows to track application startup.
 */
static inline struct phosh_private_startup_tracker *
phosh_private_get_startup_tracker(struct phosh_private *phosh_private)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_GET_STARTUP_TRACKER, &phosh_private_startup_tracker_interface, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, NULL);

	return (struct phosh_private_startup_tracker *) id;
}

/**
 * @ingroup iface_phosh_private
 *
 * This allows the shell to report it's current state. This can
 * e.g. be used to notify the compositor that the shell is up.
 */
static inline void
phosh_private_set_shell_state(struct phosh_private *phosh_private, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private,
			 PHOSH_PRIVATE_SET_SHELL_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private), 0, state);
}

#ifndef PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM
enum phosh_private_keyboard_event_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_ARGUMENT = 0,
	/**
	 * keysym not subscribeable
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_KEYSYM = 1,
	/**
	 * accelerator has already been subscribed to
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ALREADY_SUBSCRIBED = 2,
	/**
	 * an miscellaneous error has occured
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_MISC_ERROR = 3,
};
#endif /* PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private_keyboard_event
 * @struct phosh_private_keyboard_event_listener
 */
struct phosh_private_keyboard_event_listener {
	/**
	 * Report an accelerator press
	 *
	 * The subscribed accelerator has been pressed.
	 * @param action_id The previously assigned action_id
	 * @param timestamp The timestamp when the key has been pressed
	 * @since 5
	 */
	void (*accelerator_activated_event)(void *data,
					    struct phosh_private_keyboard_event *phosh_private_keyboard_event,
					    uint32_t action_id,
					    uint32_t timestamp);
	/**
	 * Report subscription failure
	 *
	 * A previous accelerator grab request has failed.
	 * @param accelerator The failed accelerator
	 * @param error The error code
	 * @since 5
	 */
	void (*grab_failed_event)(void *data,
				  struct phosh_private_keyboard_event *phosh_private_keyboard_event,
				  const char *accelerator,
				  uint32_t error);
	/**
	 * Report subscription success
	 *
	 * A previous accelerator grab request has succeeded.
	 * @param accelerator The subscribed accelerator
	 * @param action_id The id that has been assigned to the accelerator
	 * @since 5
	 */
	void (*grab_success_event)(void *data,
				   struct phosh_private_keyboard_event *phosh_private_keyboard_event,
				   const char *accelerator,
				   uint32_t action_id);
	/**
	 * Report unsubscription failure
	 *
	 * A previous accelerator ungrab request has failed.
	 * @param action_id The failed action
	 * @param error The error code
	 * @since 5
	 */
	void (*ungrab_failed_event)(void *data,
				    struct phosh_private_keyboard_event *phosh_private_keyboard_event,
				    uint32_t action_id,
				    uint32_t error);
	/**
	 * Report unsubscription success
	 *
	 * A previous accelerator ungrab request has suceeded.
	 * @param action The unsubscribed action
	 * @since 5
	 */
	void (*ungrab_success_event)(void *data,
				     struct phosh_private_keyboard_event *phosh_private_keyboard_event,
				     uint32_t action);
	/**
	 * Report an accelerator release
	 *
	 * The subscribed accelerator has been released.
	 * @param action_id The previously assigned action_id
	 * @param timestamp The timestamp when the key has been released
	 * @since 7
	 */
	void (*accelerator_released_event)(void *data,
					   struct phosh_private_keyboard_event *phosh_private_keyboard_event,
					   uint32_t action_id,
					   uint32_t timestamp);
};

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
static inline int
phosh_private_keyboard_event_add_listener(struct phosh_private_keyboard_event *phosh_private_keyboard_event,
					  const struct phosh_private_keyboard_event_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) phosh_private_keyboard_event,
				     (void (**)(void)) listener, data);
}

#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_ACCELERATOR_REQUEST 0
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_ACCELERATOR_REQUEST 1
#define PHOSH_PRIVATE_KEYBOARD_EVENT_DESTROY 2

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_ACTIVATED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_FAILED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_SUCCESS_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_FAILED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_SUCCESS_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_RELEASED_EVENT_SINCE_VERSION 7

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_ACCELERATOR_REQUEST_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_ACCELERATOR_REQUEST_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_DESTROY_SINCE_VERSION 5

/** @ingroup iface_phosh_private_keyboard_event */
static inline void
phosh_private_keyboard_event_set_user_data(struct phosh_private_keyboard_event *phosh_private_keyboard_event, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) phosh_private_keyboard_event, user_data);
}

/** @ingroup iface_phosh_private_keyboard_event */
static inline void *
phosh_private_keyboard_event_get_user_data(struct phosh_private_keyboard_event *phosh_private_keyboard_event)
{
	return wl_proxy_get_user_data((struct wl_proxy *) phosh_private_keyboard_event);
}

static inline uint32_t
phosh_private_keyboard_event_get_version(struct phosh_private_keyboard_event *phosh_private_keyboard_event)
{
	return wl_proxy_get_version((struct wl_proxy *) phosh_private_keyboard_event);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 *
 * Client subscribes to a specific accelerator.
 */
static inline void
phosh_private_keyboard_event_grab_accelerator_request(struct phosh_private_keyboard_event *phosh_private_keyboard_event, const char *accelerator)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_keyboard_event,
			 PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_ACCELERATOR_REQUEST, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_keyboard_event), 0, accelerator);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 *
 * Client unsubscribes a specific accelerator"
 */
static inline void
phosh_private_keyboard_event_ungrab_accelerator_request(struct phosh_private_keyboard_event *phosh_private_keyboard_event, uint32_t action_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_keyboard_event,
			 PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_ACCELERATOR_REQUEST, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_keyboard_event), 0, action_id);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
static inline void
phosh_private_keyboard_event_destroy(struct phosh_private_keyboard_event *phosh_private_keyboard_event)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_keyboard_event,
			 PHOSH_PRIVATE_KEYBOARD_EVENT_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_keyboard_event), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
#define PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
enum phosh_private_xdg_switcher_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_XDG_SWITCHER_ERROR_INVALID_ARGUMENT = 0,
};
#endif /* PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * @struct phosh_private_xdg_switcher_listener
 */
struct phosh_private_xdg_switcher_listener {
	/**
	 * report an xdg surface
	 *
	 * 
	 * @param app_id the app_id of the xdg surface
	 * @param title the title of the xdg surface
	 * @since 2
	 */
	void (*xdg_surface)(void *data,
			    struct phosh_private_xdg_switcher *phosh_private_xdg_switcher,
			    const char *app_id,
			    const char *title);
	/**
	 * all xdg surfaces were sent
	 *
	 * 
	 * @since 2
	 */
	void (*list_xdg_surfaces_done)(void *data,
				       struct phosh_private_xdg_switcher *phosh_private_xdg_switcher);
};

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
static inline int
phosh_private_xdg_switcher_add_listener(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher,
					const struct phosh_private_xdg_switcher_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) phosh_private_xdg_switcher,
				     (void (**)(void)) listener, data);
}

#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES 0
#define PHOSH_PRIVATE_XDG_SWITCHER_DESTROY 1
#define PHOSH_PRIVATE_XDG_SWITCHER_RAISE_XDG_SURFACE 2
#define PHOSH_PRIVATE_XDG_SWITCHER_CLOSE_XDG_SURFACE 3

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_RAISE_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_CLOSE_XDG_SURFACE_SINCE_VERSION 3

/** @ingroup iface_phosh_private_xdg_switcher */
static inline void
phosh_private_xdg_switcher_set_user_data(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) phosh_private_xdg_switcher, user_data);
}

/** @ingroup iface_phosh_private_xdg_switcher */
static inline void *
phosh_private_xdg_switcher_get_user_data(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher)
{
	return wl_proxy_get_user_data((struct wl_proxy *) phosh_private_xdg_switcher);
}

static inline uint32_t
phosh_private_xdg_switcher_get_version(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher)
{
	return wl_proxy_get_version((struct wl_proxy *) phosh_private_xdg_switcher);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
static inline void
phosh_private_xdg_switcher_list_xdg_surfaces(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_xdg_switcher,
			 PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_xdg_switcher), 0);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
static inline void
phosh_private_xdg_switcher_destroy(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_xdg_switcher,
			 PHOSH_PRIVATE_XDG_SWITCHER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_xdg_switcher), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
static inline void
phosh_private_xdg_switcher_raise_xdg_surface(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher, const char *app_id, const char *title)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_xdg_switcher,
			 PHOSH_PRIVATE_XDG_SWITCHER_RAISE_XDG_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_xdg_switcher), 0, app_id, title);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
static inline void
phosh_private_xdg_switcher_close_xdg_surface(struct phosh_private_xdg_switcher *phosh_private_xdg_switcher, const char *app_id, const char *title)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_xdg_switcher,
			 PHOSH_PRIVATE_XDG_SWITCHER_CLOSE_XDG_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_xdg_switcher), 0, app_id, title);
}

#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM
#define PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM
enum phosh_private_startup_tracker_flag {
	/**
	 * no flags
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_NONE = 0,
};
#endif /* PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM */

#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM
#define PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM
enum phosh_private_startup_tracker_protocol {
	/**
	 * unknown protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_UNKNOWN = 0,
	/**
	 * x11 startup notification protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_X11 = 1,
	/**
	 * gtk_shell protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_GTK_SHELL = 2,
	/**
	 * xdg_activation protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_XDG_ACTIVATION = 3,
};
#endif /* PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM */

/**
 * @ingroup iface_phosh_private_startup_tracker
 * @struct phosh_private_startup_tracker_listener
 */
struct phosh_private_startup_tracker_listener {
	/**
	 * Report a startup id
	 *
	 * This event indicates that the client sent it's startup id.
	 * (which implies the app is running).
	 * @param startup_id The startup_id
	 * @param protocol The protocol
	 * @param flags flags
	 */
	void (*startup_id)(void *data,
			   struct phosh_private_startup_tracker *phosh_private_startup_tracker,
			   const char *startup_id,
			   uint32_t protocol,
			   uint32_t flags);
	/**
	 * Report an application launch
	 *
	 * This event indicates that the launcher spawned the app.
	 * @param startup_id The startup_id
	 * @param protocol The protocol
	 * @param flags flags
	 */
	void (*launched)(void *data,
			 struct phosh_private_startup_tracker *phosh_private_startup_tracker,
			 const char *startup_id,
			 uint32_t protocol,
			 uint32_t flags);
};

/**
 * @ingroup iface_phosh_private_startup_tracker
 */
static inline int
phosh_private_startup_tracker_add_listener(struct phosh_private_startup_tracker *phosh_private_startup_tracker,
					   const struct phosh_private_startup_tracker_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) phosh_private_startup_tracker,
				     (void (**)(void)) listener, data);
}

#define PHOSH_PRIVATE_STARTUP_TRACKER_DESTROY 0

/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_STARTUP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_LAUNCHED_SINCE_VERSION 1

/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_DESTROY_SINCE_VERSION 1

/** @ingroup iface_phosh_private_startup_tracker */
static inline void
phosh_private_startup_tracker_set_user_data(struct phosh_private_startup_tracker *phosh_private_startup_tracker, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) phosh_private_startup_tracker, user_data);
}

/** @ingroup iface_phosh_private_startup_tracker */
static inline void *
phosh_private_startup_tracker_get_user_data(struct phosh_private_startup_tracker *phosh_private_startup_tracker)
{
	return wl_proxy_get_user_data((struct wl_proxy *) phosh_private_startup_tracker);
}

static inline uint32_t
phosh_private_startup_tracker_get_version(struct phosh_private_startup_tracker *phosh_private_startup_tracker)
{
	return wl_proxy_get_version((struct wl_proxy *) phosh_private_startup_tracker);
}

/**
 * @ingroup iface_phosh_private_startup_tracker
 *
 * The Client should invoke this when done using the interface.
 */
static inline void
phosh_private_startup_tracker_destroy(struct phosh_private_startup_tracker *phosh_private_startup_tracker)
{
	wl_proxy_marshal_flags((struct wl_proxy *) phosh_private_startup_tracker,
			 PHOSH_PRIVATE_STARTUP_TRACKER_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) phosh_private_startup_tracker), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
