#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDummyCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDummyController_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFieldDataSerializer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiProcessController_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiProcessStream_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPDirectory_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProcess_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProcessGroup_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPSystemTools_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSocketCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSocketController_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSubCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSubGroup_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkParallelCoreCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCommunicator_Init(csi);
  vtkDummyCommunicator_Init(csi);
  vtkDummyController_Init(csi);
  vtkFieldDataSerializer_Init(csi);
  vtkMultiProcessController_Init(csi);
  vtkMultiProcessStream_Init(csi);
  vtkPDirectory_Init(csi);
  vtkProcess_Init(csi);
  vtkProcessGroup_Init(csi);
  vtkPSystemTools_Init(csi);
  vtkSocketCommunicator_Init(csi);
  vtkSocketController_Init(csi);
  vtkSubCommunicator_Init(csi);
  vtkSubGroup_Init(csi);
}
