#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkPainterCommunicator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBatchedSurfaceLICMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeSurfaceLICMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeSurfaceLICMapperDelegator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDataLIC2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLineIntegralConvolution2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridLIC2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSurfaceLICComposite_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSurfaceLICInterface_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSurfaceLICMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTextureIO_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingLICOpenGL2CS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkPainterCommunicator_Init(csi);
  vtkBatchedSurfaceLICMapper_Init(csi);
  vtkCompositeSurfaceLICMapper_Init(csi);
  vtkCompositeSurfaceLICMapperDelegator_Init(csi);
  vtkImageDataLIC2D_Init(csi);
  vtkLineIntegralConvolution2D_Init(csi);
  vtkStructuredGridLIC2D_Init(csi);
  vtkSurfaceLICComposite_Init(csi);
  vtkSurfaceLICInterface_Init(csi);
  vtkSurfaceLICMapper_Init(csi);
  vtkTextureIO_Init(csi);
}
