// python wrapper for vtkSMRemoteObject
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMRemoteObject.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMRemoteObject(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMRemoteObject_ClassNew(); }

#ifndef DECLARED_PyvtkSMSessionObject_ClassNew
extern "C" { PyObject *PyvtkSMSessionObject_ClassNew(); }
#define DECLARED_PyvtkSMSessionObject_ClassNew
#endif

static PyObject *
PyvtkSMRemoteObject_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMRemoteObject::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMRemoteObject::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMRemoteObject *tempr = vtkSMRemoteObject::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMRemoteObject *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMRemoteObject::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMRemoteObject::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMRemoteObject::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_SetLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLocation(temp0);
    }
    else
    {
      op->vtkSMRemoteObject::SetLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_GetLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetLocation() :
      op->vtkSMRemoteObject::GetLocation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_SetSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  vtkSMSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSession"))
  {
    if (ap.IsBound())
    {
      op->SetSession(temp0);
    }
    else
    {
      op->vtkSMRemoteObject::SetSession(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_GetGlobalID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetGlobalID() :
      op->vtkSMRemoteObject::GetGlobalID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_GetGlobalIDAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalIDAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetGlobalIDAsString() :
      op->vtkSMRemoteObject::GetGlobalIDAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_HasGlobalID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasGlobalID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasGlobalID() :
      op->vtkSMRemoteObject::HasGlobalID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_PrototypeOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrototypeOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrototypeOn();
    }
    else
    {
      op->vtkSMRemoteObject::PrototypeOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_PrototypeOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrototypeOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrototypeOff();
    }
    else
    {
      op->vtkSMRemoteObject::PrototypeOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_IsPrototype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsPrototype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsPrototype() :
      op->vtkSMRemoteObject::IsPrototype());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_SetPrototype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPrototype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPrototype(temp0);
    }
    else
    {
      op->vtkSMRemoteObject::SetPrototype(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_EnableLocalPushOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableLocalPushOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableLocalPushOnly();
    }
    else
    {
      op->vtkSMRemoteObject::EnableLocalPushOnly();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_DisableLocalPushOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableLocalPushOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableLocalPushOnly();
    }
    else
    {
      op->vtkSMRemoteObject::DisableLocalPushOnly();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMRemoteObject_IsLocalPushOnly(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsLocalPushOnly");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMRemoteObject *op = static_cast<vtkSMRemoteObject *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsLocalPushOnly() :
      op->vtkSMRemoteObject::IsLocalPushOnly());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMRemoteObject_Methods[] = {
  {"IsTypeOf", PyvtkSMRemoteObject_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMRemoteObject_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMRemoteObject_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMRemoteObject\nC++: static vtkSMRemoteObject *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMRemoteObject_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMRemoteObject\nC++: vtkSMRemoteObject *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMRemoteObject_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMRemoteObject_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLocation", PyvtkSMRemoteObject_SetLocation, METH_VARARGS,
   "SetLocation(self, _arg:int) -> None\nC++: virtual void SetLocation(vtkTypeUInt32 _arg)\n\nGet/Set the location where the underlying VTK-objects are\ncreated. The value can be constructed by or-ing\nvtkSMSession::ServerFlags\n"},
  {"GetLocation", PyvtkSMRemoteObject_GetLocation, METH_VARARGS,
   "GetLocation(self) -> int\nC++: virtual vtkTypeUInt32 GetLocation()\n\n"},
  {"SetSession", PyvtkSMRemoteObject_SetSession, METH_VARARGS,
   "SetSession(self, __a:vtkSMSession) -> None\nC++: void SetSession(vtkSMSession *) override;\n\nOverride the SetSession so if the object already have an ID we\nautomatically register it to the associated session\n"},
  {"GetGlobalID", PyvtkSMRemoteObject_GetGlobalID, METH_VARARGS,
   "GetGlobalID(self) -> int\nC++: virtual vtkTypeUInt32 GetGlobalID()\n\nGet the global unique id for this object. If none is set and the\nsession is valid, a new global id will be assigned automatically.\n"},
  {"GetGlobalIDAsString", PyvtkSMRemoteObject_GetGlobalIDAsString, METH_VARARGS,
   "GetGlobalIDAsString(self) -> str\nC++: const char *GetGlobalIDAsString()\n\n"},
  {"HasGlobalID", PyvtkSMRemoteObject_HasGlobalID, METH_VARARGS,
   "HasGlobalID(self) -> bool\nC++: bool HasGlobalID()\n\nAllow the user to test if the RemoteObject has already a GlobalID\nwithout assigning a new one to it.\n"},
  {"PrototypeOn", PyvtkSMRemoteObject_PrototypeOn, METH_VARARGS,
   "PrototypeOn(self) -> None\nC++: virtual void PrototypeOn()\n\nAllow user to set the remote object to be discard for Undo/Redo\naction. By default, any remote object is Undoable.\n"},
  {"PrototypeOff", PyvtkSMRemoteObject_PrototypeOff, METH_VARARGS,
   "PrototypeOff(self) -> None\nC++: virtual void PrototypeOff()\n\n"},
  {"IsPrototype", PyvtkSMRemoteObject_IsPrototype, METH_VARARGS,
   "IsPrototype(self) -> bool\nC++: bool IsPrototype()\n\n"},
  {"SetPrototype", PyvtkSMRemoteObject_SetPrototype, METH_VARARGS,
   "SetPrototype(self, _arg:bool) -> None\nC++: virtual void SetPrototype(bool _arg)\n\n"},
  {"EnableLocalPushOnly", PyvtkSMRemoteObject_EnableLocalPushOnly, METH_VARARGS,
   "EnableLocalPushOnly(self) -> None\nC++: virtual void EnableLocalPushOnly()\n\nAllow to switch off any push of state change to the server for\nthat particular object. This is used when we load a state based\non a server notification. In that particular case, the server is\nalready aware of that new state, so we keep those changes local.\n"},
  {"DisableLocalPushOnly", PyvtkSMRemoteObject_DisableLocalPushOnly, METH_VARARGS,
   "DisableLocalPushOnly(self) -> None\nC++: virtual void DisableLocalPushOnly()\n\nEnable the given remote object to communicate its state normally\nto the server location.\n"},
  {"IsLocalPushOnly", PyvtkSMRemoteObject_IsLocalPushOnly, METH_VARARGS,
   "IsLocalPushOnly(self) -> bool\nC++: virtual bool IsLocalPushOnly()\n\nLet the session be aware that even if the Location is client\nonly, the message should not be send to the server for a general\nbroadcast\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMRemoteObject_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("location"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRemoteObject_GetLocation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMRemoteObject_SetLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMRemoteObject_SetLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLocation/SetLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("session"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMRemoteObject_SetSession(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMRemoteObject_SetSession(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSession\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("prototype"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMRemoteObject_SetPrototype(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMRemoteObject_SetPrototype(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPrototype\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMRemoteObject_GetGlobalID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalID\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMRemoteObject_Doc =
  "vtkSMRemoteObject - baseclass for all proxy-objects that have counter\nparts on server as well as client processes.\n\n"
  "Superclass: vtkSMSessionObject\n\n"
  "Abstract class involved in ServerManager class hierarchy that has a\n"
  "corresponding SIObject which can be local or remote.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMRemoteObject_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMRemoteObject", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMRemoteObject_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkSMRemoteObject_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMRemoteObject_Type, PyvtkSMRemoteObject_Methods,
    "vtkSMRemoteObject",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMSessionObject_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMRemoteObject_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMRemoteObject(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMRemoteObject_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMRemoteObject", o) != 0)
  {
    Py_DECREF(o);
  }

}

