// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VsPluginInfo.C
// ****************************************************************************

#include <VsPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Vs,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Vs,General)

// ****************************************************************************
//  Method: VsGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VsGeneralPluginInfo::GetName() const
{
    return "Vs";
}

// ****************************************************************************
//  Method: VsGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VsGeneralPluginInfo::GetVersion() const
{
    return "3.0.0";
}

// ****************************************************************************
//  Method: VsGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VsGeneralPluginInfo::GetID() const
{
    return "Vs_3.0.0";
}
// ****************************************************************************
//  Method: VsGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VsGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: VsGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VsGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  VsGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Vs database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
VsGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*vsh5");
    defaultPatterns.push_back("*.h5");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  VsGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Vs database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VsGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  VsGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Vs plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
VsGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
