/* PreferencesDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PreferencesDialog.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2011-2024 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Giulio Collura <random.cpp@gmail.com>
 *              Mario Guerriero <mario@elementaryos.org>
 *              Fabio Zaramella <ffabio.96.x@gmail.com>
 */

#include "codecore.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <atk/atk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_DIALOGS_PREFERENCES_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_properties[SCRATCH_DIALOGS_PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH (scratch_dialogs_preferences_setting_switch_get_type ())
#define SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitch))
#define SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitchClass))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTING_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTING_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitchClass))

typedef struct _ScratchDialogsPreferencesSettingSwitch ScratchDialogsPreferencesSettingSwitch;
typedef struct _ScratchDialogsPreferencesSettingSwitchClass ScratchDialogsPreferencesSettingSwitchClass;
typedef struct _ScratchDialogsPreferencesSettingSwitchPrivate ScratchDialogsPreferencesSettingSwitchPrivate;
enum  {
	SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block9Data Block9Data;

struct _ScratchDialogsPreferencesPrivate {
	ScratchServicesPluginsManager* _plugins;
};

struct _ScratchDialogsPreferencesSettingSwitch {
	GtkGrid parent_instance;
	ScratchDialogsPreferencesSettingSwitchPrivate * priv;
};

struct _ScratchDialogsPreferencesSettingSwitchClass {
	GtkGridClass parent_class;
};

struct _ScratchDialogsPreferencesSettingSwitchPrivate {
	gchar* _label;
	gchar* _settings_key;
	gchar* _description;
};

struct _Block9Data {
	int _ref_count_;
	ScratchDialogsPreferences* self;
	GtkComboBoxText* drawspaces_combobox;
	GtkStack* stack;
};

static gint ScratchDialogsPreferences_private_offset;
static gpointer scratch_dialogs_preferences_parent_class = NULL;
static gint ScratchDialogsPreferencesSettingSwitch_private_offset;
static gpointer scratch_dialogs_preferences_setting_switch_parent_class = NULL;

static GType scratch_dialogs_preferences_setting_switch_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchDialogsPreferencesSettingSwitch* scratch_dialogs_preferences_setting_switch_new (const gchar* label,
                                                                                        const gchar* settings_key,
                                                                                        const gchar* description);
static ScratchDialogsPreferencesSettingSwitch* scratch_dialogs_preferences_setting_switch_construct (GType object_type,
                                                                                              const gchar* label,
                                                                                              const gchar* settings_key,
                                                                                              const gchar* description);
static const gchar* scratch_dialogs_preferences_setting_switch_get_label (ScratchDialogsPreferencesSettingSwitch* self);
static void scratch_dialogs_preferences_setting_switch_set_label (ScratchDialogsPreferencesSettingSwitch* self,
                                                           const gchar* value);
static const gchar* scratch_dialogs_preferences_setting_switch_get_settings_key (ScratchDialogsPreferencesSettingSwitch* self);
static void scratch_dialogs_preferences_setting_switch_set_settings_key (ScratchDialogsPreferencesSettingSwitch* self,
                                                                  const gchar* value);
static const gchar* scratch_dialogs_preferences_setting_switch_get_description (ScratchDialogsPreferencesSettingSwitch* self);
static void scratch_dialogs_preferences_setting_switch_set_description (ScratchDialogsPreferencesSettingSwitch* self,
                                                                 const gchar* value);
static GObject * scratch_dialogs_preferences_setting_switch_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties);
static void scratch_dialogs_preferences_setting_switch_finalize (GObject * obj);
static GType scratch_dialogs_preferences_setting_switch_get_type_once (void);
static void _vala_scratch_dialogs_preferences_setting_switch_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_scratch_dialogs_preferences_setting_switch_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);
static GObject * scratch_dialogs_preferences_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _scratch_dialogs_preferences___lambda67_ (Block9Data* _data9_);
static void __scratch_dialogs_preferences___lambda67__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self);
static void _scratch_dialogs_preferences___lambda70_ (ScratchDialogsPreferences* self);
static void __scratch_dialogs_preferences___lambda70__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _scratch_dialogs_preferences___lambda71_ (Block9Data* _data9_);
static void __scratch_dialogs_preferences___lambda71__gtk_widget_realize (GtkWidget* _sender,
                                                                   gpointer self);
static void scratch_dialogs_preferences_finalize (GObject * obj);
static GType scratch_dialogs_preferences_get_type_once (void);
static void _vala_scratch_dialogs_preferences_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_scratch_dialogs_preferences_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
scratch_dialogs_preferences_get_instance_private (ScratchDialogsPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchDialogsPreferences_private_offset);
}

ScratchDialogsPreferences*
scratch_dialogs_preferences_construct (GType object_type,
                                       GtkWindow* parent,
                                       ScratchServicesPluginsManager* plugins)
{
	ScratchDialogsPreferences * self = NULL;
	g_return_val_if_fail (plugins != NULL, NULL);
	self = (ScratchDialogsPreferences*) g_object_new (object_type, "title", _ ("Preferences"), "transient-for", parent, "plugins", plugins, NULL);
	return self;
}

ScratchDialogsPreferences*
scratch_dialogs_preferences_new (GtkWindow* parent,
                                 ScratchServicesPluginsManager* plugins)
{
	return scratch_dialogs_preferences_construct (SCRATCH_DIALOGS_TYPE_PREFERENCES, parent, plugins);
}

ScratchServicesPluginsManager*
scratch_dialogs_preferences_get_plugins (ScratchDialogsPreferences* self)
{
	ScratchServicesPluginsManager* result;
	ScratchServicesPluginsManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugins;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scratch_dialogs_preferences_set_plugins (ScratchDialogsPreferences* self,
                                         ScratchServicesPluginsManager* value)
{
	ScratchServicesPluginsManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_preferences_get_plugins (self);
	if (old_value != value) {
		ScratchServicesPluginsManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plugins);
		self->priv->_plugins = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_preferences_properties[SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY]);
	}
}

static inline gpointer
scratch_dialogs_preferences_setting_switch_get_instance_private (ScratchDialogsPreferencesSettingSwitch* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchDialogsPreferencesSettingSwitch_private_offset);
}

static ScratchDialogsPreferencesSettingSwitch*
scratch_dialogs_preferences_setting_switch_construct (GType object_type,
                                                      const gchar* label,
                                                      const gchar* settings_key,
                                                      const gchar* description)
{
	ScratchDialogsPreferencesSettingSwitch * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (settings_key != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (ScratchDialogsPreferencesSettingSwitch*) g_object_new (object_type, "description", description, "label", label, "settings-key", settings_key, NULL);
	return self;
}

static ScratchDialogsPreferencesSettingSwitch*
scratch_dialogs_preferences_setting_switch_new (const gchar* label,
                                                const gchar* settings_key,
                                                const gchar* description)
{
	return scratch_dialogs_preferences_setting_switch_construct (SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, label, settings_key, description);
}

static const gchar*
scratch_dialogs_preferences_setting_switch_get_label (ScratchDialogsPreferencesSettingSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_preferences_setting_switch_set_label (ScratchDialogsPreferencesSettingSwitch* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_preferences_setting_switch_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY]);
	}
}

static const gchar*
scratch_dialogs_preferences_setting_switch_get_settings_key (ScratchDialogsPreferencesSettingSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings_key;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_preferences_setting_switch_set_settings_key (ScratchDialogsPreferencesSettingSwitch* self,
                                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_preferences_setting_switch_get_settings_key (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_settings_key);
		self->priv->_settings_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY]);
	}
}

static const gchar*
scratch_dialogs_preferences_setting_switch_get_description (ScratchDialogsPreferencesSettingSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_preferences_setting_switch_set_description (ScratchDialogsPreferencesSettingSwitch* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_dialogs_preferences_setting_switch_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY]);
	}
}

static GObject *
scratch_dialogs_preferences_setting_switch_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsPreferencesSettingSwitch * self;
	GtkSwitch* switch_widget = NULL;
	GtkSwitch* _tmp0_ = NULL;
	GtkLabel* label_widget = NULL;
	const gchar* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkWidget* _tmp3_;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkSwitch* _tmp6_;
	const gchar* _tmp7_;
	GSettings* _tmp18_;
	const gchar* _tmp19_;
	GtkSwitch* _tmp20_;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_preferences_setting_switch_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitch);
	_tmp0_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp0_);
	switch_widget = _tmp0_;
	_tmp1_ = self->priv->_label;
	_tmp2_ = switch_widget;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp1_);
	gtk_widget_set_halign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	gtk_label_set_mnemonic_widget (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	label_widget = _tmp4_;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	_tmp5_ = label_widget;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp5_, 0, 0, 1, 1);
	_tmp6_ = switch_widget;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp6_, 1, 0, 1, 2);
	_tmp7_ = self->priv->_description;
	if (g_strcmp0 (_tmp7_, "") != 0) {
		GtkLabel* description_label = NULL;
		const gchar* _tmp8_;
		GtkLabel* _tmp9_ = NULL;
		GtkLabel* _tmp10_;
		GtkStyleContext* _tmp11_;
		GtkLabel* _tmp12_;
		GtkStyleContext* _tmp13_;
		GtkLabel* _tmp14_;
		GtkSwitch* _tmp15_;
		AtkObject* _tmp16_;
		const gchar* _tmp17_;
		_tmp8_ = self->priv->_description;
		_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
		gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
		g_object_set (_tmp9_, "wrap", TRUE, NULL);
		gtk_label_set_xalign (_tmp9_, (gfloat) 0);
		g_object_ref_sink (_tmp9_);
		description_label = _tmp9_;
		_tmp10_ = description_label;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_add_class (_tmp11_, GTK_STYLE_CLASS_DIM_LABEL);
		_tmp12_ = description_label;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
		gtk_style_context_add_class (_tmp13_, GRANITE_STYLE_CLASS_SMALL_LABEL);
		_tmp14_ = description_label;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 0, 1, 1, 1);
		_tmp15_ = switch_widget;
		_tmp16_ = gtk_widget_get_accessible ((GtkWidget*) _tmp15_);
		_tmp17_ = self->priv->_description;
		g_object_set (_tmp16_, "accessible-description", _tmp17_, NULL);
		_g_object_unref0 (description_label);
	}
	_tmp18_ = scratch_settings;
	_tmp19_ = self->priv->_settings_key;
	_tmp20_ = switch_widget;
	g_settings_bind (_tmp18_, _tmp19_, (GObject*) _tmp20_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (label_widget);
	_g_object_unref0 (switch_widget);
	return obj;
}

static void
scratch_dialogs_preferences_setting_switch_class_init (ScratchDialogsPreferencesSettingSwitchClass * klass,
                                                       gpointer klass_data)
{
	scratch_dialogs_preferences_setting_switch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchDialogsPreferencesSettingSwitch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_dialogs_preferences_setting_switch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_dialogs_preferences_setting_switch_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_preferences_setting_switch_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_dialogs_preferences_setting_switch_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY] = g_param_spec_string ("settings-key", "settings-key", "settings-key", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY, scratch_dialogs_preferences_setting_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_dialogs_preferences_setting_switch_instance_init (ScratchDialogsPreferencesSettingSwitch * self,
                                                          gpointer klass)
{
	self->priv = scratch_dialogs_preferences_setting_switch_get_instance_private (self);
}

static void
scratch_dialogs_preferences_setting_switch_finalize (GObject * obj)
{
	ScratchDialogsPreferencesSettingSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitch);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_settings_key);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (scratch_dialogs_preferences_setting_switch_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_dialogs_preferences_setting_switch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesSettingSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_setting_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferencesSettingSwitch), 0, (GInstanceInitFunc) scratch_dialogs_preferences_setting_switch_instance_init, NULL };
	GType scratch_dialogs_preferences_setting_switch_type_id;
	scratch_dialogs_preferences_setting_switch_type_id = g_type_register_static (gtk_grid_get_type (), "ScratchDialogsPreferencesSettingSwitch", &g_define_type_info, 0);
	ScratchDialogsPreferencesSettingSwitch_private_offset = g_type_add_instance_private (scratch_dialogs_preferences_setting_switch_type_id, sizeof (ScratchDialogsPreferencesSettingSwitchPrivate));
	return scratch_dialogs_preferences_setting_switch_type_id;
}

static GType
scratch_dialogs_preferences_setting_switch_get_type (void)
{
	static gsize scratch_dialogs_preferences_setting_switch_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_setting_switch_type_id__once)) {
		GType scratch_dialogs_preferences_setting_switch_type_id;
		scratch_dialogs_preferences_setting_switch_type_id = scratch_dialogs_preferences_setting_switch_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_setting_switch_type_id__once, scratch_dialogs_preferences_setting_switch_type_id);
	}
	return scratch_dialogs_preferences_setting_switch_type_id__once;
}

static void
_vala_scratch_dialogs_preferences_setting_switch_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchDialogsPreferencesSettingSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitch);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY:
		g_value_set_string (value, scratch_dialogs_preferences_setting_switch_get_label (self));
		break;
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY:
		g_value_set_string (value, scratch_dialogs_preferences_setting_switch_get_settings_key (self));
		break;
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY:
		g_value_set_string (value, scratch_dialogs_preferences_setting_switch_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_dialogs_preferences_setting_switch_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchDialogsPreferencesSettingSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTING_SWITCH, ScratchDialogsPreferencesSettingSwitch);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_LABEL_PROPERTY:
		scratch_dialogs_preferences_setting_switch_set_label (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_SETTINGS_KEY_PROPERTY:
		scratch_dialogs_preferences_setting_switch_set_settings_key (self, g_value_get_string (value));
		break;
		case SCRATCH_DIALOGS_PREFERENCES_SETTING_SWITCH_DESCRIPTION_PROPERTY:
		scratch_dialogs_preferences_setting_switch_set_description (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ScratchDialogsPreferences* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->stack);
		_g_object_unref0 (_data9_->drawspaces_combobox);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_scratch_dialogs_preferences___lambda67_ (Block9Data* _data9_)
{
	ScratchDialogsPreferences* self;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data9_->self;
	_tmp0_ = _data9_->drawspaces_combobox;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 0:
		{
			GSettings* _tmp3_;
			_tmp3_ = scratch_settings;
			g_settings_set_enum (_tmp3_, "draw-spaces", (gint) SCRATCH_SCRATCH_DRAW_SPACES_STATE_NEVER);
			break;
		}
		case 1:
		{
			GSettings* _tmp4_;
			_tmp4_ = scratch_settings;
			g_settings_set_enum (_tmp4_, "draw-spaces", (gint) SCRATCH_SCRATCH_DRAW_SPACES_STATE_CURRENT);
			break;
		}
		case 2:
		{
			GSettings* _tmp5_;
			_tmp5_ = scratch_settings;
			g_settings_set_enum (_tmp5_, "draw-spaces", (gint) SCRATCH_SCRATCH_DRAW_SPACES_STATE_ALWAYS);
			break;
		}
		default:
		break;
	}
}

static void
__scratch_dialogs_preferences___lambda67__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self)
{
	_scratch_dialogs_preferences___lambda67_ (self);
}

static void
_scratch_dialogs_preferences___lambda70_ (ScratchDialogsPreferences* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__scratch_dialogs_preferences___lambda70__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_scratch_dialogs_preferences___lambda70_ ((ScratchDialogsPreferences*) self);
}

static void
_scratch_dialogs_preferences___lambda71_ (Block9Data* _data9_)
{
	ScratchDialogsPreferences* self;
	GtkStack* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "behavior");
}

static void
__scratch_dialogs_preferences___lambda71__gtk_widget_realize (GtkWidget* _sender,
                                                              gpointer self)
{
	_scratch_dialogs_preferences___lambda71_ (self);
}

static GObject *
scratch_dialogs_preferences_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsPreferences * self;
	Block9Data* _data9_;
	GtkBox* general_box = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GraniteHeaderLabel* _tmp2_;
	GraniteHeaderLabel* _tmp3_;
	GtkBox* _tmp4_;
	ScratchDialogsPreferencesSettingSwitch* _tmp5_;
	ScratchDialogsPreferencesSettingSwitch* _tmp6_;
	GtkBox* _tmp7_;
	ScratchDialogsPreferencesSettingSwitch* _tmp8_;
	ScratchDialogsPreferencesSettingSwitch* _tmp9_;
	GtkBox* _tmp10_;
	ScratchDialogsPreferencesSettingSwitch* _tmp11_;
	ScratchDialogsPreferencesSettingSwitch* _tmp12_;
	GtkSpinButton* indent_width = NULL;
	GtkSpinButton* _tmp13_;
	GSettings* _tmp14_;
	GtkSpinButton* _tmp15_;
	GtkLabel* indent_width_label = NULL;
	GtkSpinButton* _tmp16_;
	GtkWidget* _tmp17_;
	GtkLabel* _tmp18_ = NULL;
	GtkBox* indent_width_box = NULL;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkBox* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkBox* indentation_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GraniteHeaderLabel* _tmp26_;
	GraniteHeaderLabel* _tmp27_;
	GtkBox* _tmp28_;
	ScratchDialogsPreferencesSettingSwitch* _tmp29_;
	ScratchDialogsPreferencesSettingSwitch* _tmp30_;
	GtkBox* _tmp31_;
	ScratchDialogsPreferencesSettingSwitch* _tmp32_;
	ScratchDialogsPreferencesSettingSwitch* _tmp33_;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkEntry* build_dir_entry = NULL;
	gchar* _tmp36_;
	GtkEntry* _tmp37_ = NULL;
	GSettings* _tmp38_;
	GtkEntry* _tmp39_;
	GtkLabel* buid_dir_label = NULL;
	GtkEntry* _tmp40_;
	GtkWidget* _tmp41_;
	GtkLabel* _tmp42_ = NULL;
	GtkBox* build_dir_box = NULL;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkEntry* _tmp47_;
	GtkBox* projects_box = NULL;
	GtkBox* _tmp48_;
	GtkBox* _tmp49_;
	GraniteHeaderLabel* _tmp50_;
	GraniteHeaderLabel* _tmp51_;
	GtkBox* _tmp52_;
	GtkBox* _tmp53_;
	GtkBox* behavior_box = NULL;
	GtkBox* _tmp54_;
	GtkBox* _tmp55_;
	GtkBox* _tmp56_;
	GtkBox* _tmp57_;
	GtkBox* _tmp58_;
	GtkBox* _tmp59_;
	GtkBox* _tmp60_;
	GtkComboBoxText* _tmp61_ = NULL;
	GtkComboBoxText* _tmp62_;
	GtkComboBoxText* _tmp63_;
	GtkComboBoxText* _tmp64_;
	GtkComboBoxText* _tmp65_;
	GSettings* _tmp66_;
	GtkComboBoxText* _tmp67_;
	GtkLabel* draw_spaces_label = NULL;
	GtkComboBoxText* _tmp68_;
	GtkWidget* _tmp69_;
	GtkLabel* _tmp70_ = NULL;
	GtkBox* draw_spaces_box = NULL;
	GtkBox* _tmp71_;
	GtkBox* _tmp72_;
	GtkLabel* _tmp73_;
	GtkBox* _tmp74_;
	GtkComboBoxText* _tmp75_;
	GtkSpinButton* right_margin_position = NULL;
	GtkSpinButton* _tmp76_;
	GSettings* _tmp77_;
	GtkSpinButton* _tmp78_;
	GSettings* _tmp79_;
	GtkSpinButton* _tmp80_;
	GtkBox* editor_box = NULL;
	GtkBox* _tmp81_;
	GtkBox* _tmp82_;
	GraniteHeaderLabel* _tmp83_;
	GraniteHeaderLabel* _tmp84_;
	GtkBox* _tmp85_;
	ScratchDialogsPreferencesSettingSwitch* _tmp86_;
	ScratchDialogsPreferencesSettingSwitch* _tmp87_;
	GtkBox* _tmp88_;
	GtkBox* _tmp89_;
	GtkBox* _tmp90_;
	ScratchDialogsPreferencesSettingSwitch* _tmp91_;
	ScratchDialogsPreferencesSettingSwitch* _tmp92_;
	GtkBox* _tmp93_;
	ScratchDialogsPreferencesSettingSwitch* _tmp94_;
	ScratchDialogsPreferencesSettingSwitch* _tmp95_;
	GtkBox* _tmp96_;
	ScratchDialogsPreferencesSettingSwitch* _tmp97_;
	ScratchDialogsPreferencesSettingSwitch* _tmp98_;
	GtkBox* _tmp99_;
	GtkSpinButton* _tmp100_;
	GtkFontButton* select_font = NULL;
	GtkFontButton* _tmp101_;
	GSettings* _tmp102_;
	GtkFontButton* _tmp103_;
	GSettings* _tmp104_;
	GtkFontButton* _tmp105_;
	GtkBox* font_box = NULL;
	GtkBox* _tmp106_;
	GtkBox* _tmp107_;
	GraniteHeaderLabel* _tmp108_;
	GraniteHeaderLabel* _tmp109_;
	GtkBox* _tmp110_;
	ScratchDialogsPreferencesSettingSwitch* _tmp111_;
	ScratchDialogsPreferencesSettingSwitch* _tmp112_;
	GtkBox* _tmp113_;
	GtkFontButton* _tmp114_;
	GtkBox* interface_box = NULL;
	GtkBox* _tmp115_;
	GtkBox* _tmp116_;
	GtkBox* _tmp117_;
	GtkBox* _tmp118_;
	GtkBox* _tmp119_;
	GtkStack* _tmp120_ = NULL;
	GtkStack* _tmp121_;
	GtkBox* _tmp122_;
	GtkStack* _tmp123_;
	GtkBox* _tmp124_;
	GtkStackSwitcher* stackswitcher = NULL;
	GtkStackSwitcher* _tmp125_;
	GtkStackSwitcher* _tmp126_;
	GtkStack* _tmp127_;
	GtkStackSwitcher* _tmp128_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp129_;
	GtkBox* _tmp130_;
	GtkStackSwitcher* _tmp131_;
	GtkBox* _tmp132_;
	GtkStack* _tmp133_;
	ScratchServicesPluginsManager* _tmp134_;
	ScratchServicesPluginsManager* _tmp135_;
	GtkBox* _tmp141_;
	GtkBox* _tmp142_;
	GtkButton* close_button = NULL;
	GtkWidget* _tmp143_;
	GtkButton* _tmp144_;
	GtkButton* _tmp145_;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp0_);
	general_box = _tmp0_;
	_tmp1_ = general_box;
	_tmp2_ = granite_header_label_new (_ ("General"));
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = general_box;
	_tmp5_ = scratch_dialogs_preferences_setting_switch_new (_ ("Save files when changed"), "autosave", "");
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = general_box;
	_tmp8_ = scratch_dialogs_preferences_setting_switch_new (_ ("Strip trailing whitespace on save"), "strip-trailing-on-save", "");
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = general_box;
	_tmp11_ = scratch_dialogs_preferences_setting_switch_new (_ ("Smart cut/copy lines"), "smart-cut-copy", _ ("Cutting or copying without an active selection will cut or copy the en" \
"tire current line"));
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 24, (gdouble) 1);
	g_object_ref_sink (_tmp13_);
	indent_width = _tmp13_;
	_tmp14_ = scratch_settings;
	_tmp15_ = indent_width;
	g_settings_bind (_tmp14_, "indent-width", (GObject*) _tmp15_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp16_ = indent_width;
	_tmp17_ = _g_object_ref0 ((GtkWidget*) _tmp16_);
	_tmp18_ = (GtkLabel*) gtk_label_new (_ ("Indentation width"));
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp18_, TRUE);
	gtk_label_set_mnemonic_widget (_tmp18_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_object_ref_sink (_tmp18_);
	indent_width_label = _tmp18_;
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp19_);
	indent_width_box = _tmp19_;
	_tmp20_ = indent_width_box;
	_tmp21_ = indent_width_label;
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = indent_width_box;
	_tmp23_ = indent_width;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp24_);
	indentation_box = _tmp24_;
	_tmp25_ = indentation_box;
	_tmp26_ = granite_header_label_new (_ ("Indentation"));
	g_object_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = indentation_box;
	_tmp29_ = scratch_dialogs_preferences_setting_switch_new (_ ("Automatic indentation"), "auto-indent", "");
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = indentation_box;
	_tmp32_ = scratch_dialogs_preferences_setting_switch_new (_ ("Insert spaces instead of tabs"), "spaces-instead-of-tabs", "");
	g_object_ref_sink (_tmp32_);
	_tmp33_ = _tmp32_;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	_tmp34_ = indentation_box;
	_tmp35_ = indent_width_box;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = g_strdup (".");
	_tmp37_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp37_, TRUE);
	gtk_entry_set_placeholder_text (_tmp37_, _tmp36_);
	_g_free0 (_tmp36_);
	g_object_ref_sink (_tmp37_);
	build_dir_entry = _tmp37_;
	_tmp38_ = scratch_settings;
	_tmp39_ = build_dir_entry;
	g_settings_bind (_tmp38_, "default-build-directory", (GObject*) _tmp39_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp40_ = build_dir_entry;
	_tmp41_ = _g_object_ref0 ((GtkWidget*) _tmp40_);
	_tmp42_ = (GtkLabel*) gtk_label_new (_ ("Default build directory"));
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_START);
	gtk_label_set_mnemonic_widget (_tmp42_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	g_object_ref_sink (_tmp42_);
	buid_dir_label = _tmp42_;
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp43_);
	build_dir_box = _tmp43_;
	_tmp44_ = build_dir_box;
	_tmp45_ = buid_dir_label;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = build_dir_box;
	_tmp47_ = build_dir_entry;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp48_);
	projects_box = _tmp48_;
	_tmp49_ = projects_box;
	_tmp50_ = granite_header_label_new (_ ("Projects"));
	g_object_ref_sink (_tmp50_);
	_tmp51_ = _tmp50_;
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = projects_box;
	_tmp53_ = build_dir_box;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp54_);
	behavior_box = _tmp54_;
	_tmp55_ = behavior_box;
	_tmp56_ = general_box;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = behavior_box;
	_tmp58_ = indentation_box;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = behavior_box;
	_tmp60_ = projects_box;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp61_, TRUE);
	g_object_ref_sink (_tmp61_);
	_data9_->drawspaces_combobox = _tmp61_;
	_tmp62_ = _data9_->drawspaces_combobox;
	gtk_combo_box_text_append_text (_tmp62_, _ ("None"));
	_tmp63_ = _data9_->drawspaces_combobox;
	gtk_combo_box_text_append_text (_tmp63_, _ ("Current Line"));
	_tmp64_ = _data9_->drawspaces_combobox;
	gtk_combo_box_text_append_text (_tmp64_, _ ("All"));
	_tmp65_ = _data9_->drawspaces_combobox;
	_tmp66_ = scratch_settings;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp65_, CLAMP (g_settings_get_enum (_tmp66_, "draw-spaces"), 0, 2));
	_tmp67_ = _data9_->drawspaces_combobox;
	g_signal_connect_data ((GtkComboBox*) _tmp67_, "changed", (GCallback) __scratch_dialogs_preferences___lambda67__gtk_combo_box_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp68_ = _data9_->drawspaces_combobox;
	_tmp69_ = _g_object_ref0 ((GtkWidget*) _tmp68_);
	_tmp70_ = (GtkLabel*) gtk_label_new (_ ("Whitespace visible when not selected"));
	gtk_widget_set_halign ((GtkWidget*) _tmp70_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp70_, TRUE);
	gtk_label_set_mnemonic_widget (_tmp70_, _tmp69_);
	_g_object_unref0 (_tmp69_);
	g_object_ref_sink (_tmp70_);
	draw_spaces_label = _tmp70_;
	_tmp71_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp71_);
	draw_spaces_box = _tmp71_;
	_tmp72_ = draw_spaces_box;
	_tmp73_ = draw_spaces_label;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = draw_spaces_box;
	_tmp75_ = _data9_->drawspaces_combobox;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 250, (gdouble) 1);
	g_object_ref_sink (_tmp76_);
	right_margin_position = _tmp76_;
	_tmp77_ = scratch_settings;
	_tmp78_ = right_margin_position;
	g_settings_bind (_tmp77_, "right-margin-position", (GObject*) _tmp78_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp79_ = scratch_settings;
	_tmp80_ = right_margin_position;
	g_settings_bind (_tmp79_, "show-right-margin", (GObject*) _tmp80_, "sensitive", G_SETTINGS_BIND_DEFAULT);
	_tmp81_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp81_);
	editor_box = _tmp81_;
	_tmp82_ = editor_box;
	_tmp83_ = granite_header_label_new (_ ("Editor"));
	g_object_ref_sink (_tmp83_);
	_tmp84_ = _tmp83_;
	gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp84_);
	_g_object_unref0 (_tmp84_);
	_tmp85_ = editor_box;
	_tmp86_ = scratch_dialogs_preferences_setting_switch_new (_ ("Highlight matching brackets"), "highlight-matching-brackets", "");
	g_object_ref_sink (_tmp86_);
	_tmp87_ = _tmp86_;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp87_);
	_g_object_unref0 (_tmp87_);
	_tmp88_ = editor_box;
	_tmp89_ = draw_spaces_box;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = editor_box;
	_tmp91_ = scratch_dialogs_preferences_setting_switch_new (_ ("Mini Map"), "show-mini-map", "");
	g_object_ref_sink (_tmp91_);
	_tmp92_ = _tmp91_;
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp92_);
	_g_object_unref0 (_tmp92_);
	_tmp93_ = editor_box;
	_tmp94_ = scratch_dialogs_preferences_setting_switch_new (_ ("Wrap lines"), "line-wrap", "");
	g_object_ref_sink (_tmp94_);
	_tmp95_ = _tmp94_;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp95_);
	_g_object_unref0 (_tmp95_);
	_tmp96_ = editor_box;
	_tmp97_ = scratch_dialogs_preferences_setting_switch_new (_ ("Line width guide"), "show-right-margin", "");
	g_object_ref_sink (_tmp97_);
	_tmp98_ = _tmp97_;
	gtk_container_add ((GtkContainer*) _tmp96_, (GtkWidget*) _tmp98_);
	_g_object_unref0 (_tmp98_);
	_tmp99_ = editor_box;
	_tmp100_ = right_margin_position;
	gtk_container_add ((GtkContainer*) _tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = (GtkFontButton*) gtk_font_button_new ();
	g_object_ref_sink (_tmp101_);
	select_font = _tmp101_;
	_tmp102_ = scratch_settings;
	_tmp103_ = select_font;
	g_settings_bind (_tmp102_, "font", (GObject*) _tmp103_, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp104_ = scratch_settings;
	_tmp105_ = select_font;
	g_settings_bind (_tmp104_, "use-system-font", (GObject*) _tmp105_, "sensitive", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp106_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp106_);
	font_box = _tmp106_;
	_tmp107_ = font_box;
	_tmp108_ = granite_header_label_new (_ ("Font"));
	g_object_ref_sink (_tmp108_);
	_tmp109_ = _tmp108_;
	gtk_container_add ((GtkContainer*) _tmp107_, (GtkWidget*) _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = font_box;
	_tmp111_ = scratch_dialogs_preferences_setting_switch_new (_ ("Use system font"), "use-system-font", "");
	g_object_ref_sink (_tmp111_);
	_tmp112_ = _tmp111_;
	gtk_container_add ((GtkContainer*) _tmp110_, (GtkWidget*) _tmp112_);
	_g_object_unref0 (_tmp112_);
	_tmp113_ = font_box;
	_tmp114_ = select_font;
	gtk_container_add ((GtkContainer*) _tmp113_, (GtkWidget*) _tmp114_);
	_tmp115_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp115_);
	interface_box = _tmp115_;
	_tmp116_ = interface_box;
	_tmp117_ = editor_box;
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = interface_box;
	_tmp119_ = font_box;
	gtk_container_add ((GtkContainer*) _tmp118_, (GtkWidget*) _tmp119_);
	_tmp120_ = (GtkStack*) gtk_stack_new ();
	g_object_set ((GtkWidget*) _tmp120_, "margin", 12, NULL);
	gtk_stack_set_vhomogeneous (_tmp120_, TRUE);
	g_object_ref_sink (_tmp120_);
	_data9_->stack = _tmp120_;
	_tmp121_ = _data9_->stack;
	_tmp122_ = behavior_box;
	gtk_stack_add_titled (_tmp121_, (GtkWidget*) _tmp122_, "behavior", _ ("Behavior"));
	_tmp123_ = _data9_->stack;
	_tmp124_ = interface_box;
	gtk_stack_add_titled (_tmp123_, (GtkWidget*) _tmp124_, "interface", _ ("Interface"));
	_tmp125_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp125_);
	stackswitcher = _tmp125_;
	_tmp126_ = stackswitcher;
	_tmp127_ = _data9_->stack;
	gtk_stack_switcher_set_stack (_tmp126_, _tmp127_);
	_tmp128_ = stackswitcher;
	gtk_widget_set_halign ((GtkWidget*) _tmp128_, GTK_ALIGN_CENTER);
	_tmp129_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp129_);
	main_box = _tmp129_;
	_tmp130_ = main_box;
	_tmp131_ = stackswitcher;
	gtk_container_add ((GtkContainer*) _tmp130_, (GtkWidget*) _tmp131_);
	_tmp132_ = main_box;
	_tmp133_ = _data9_->stack;
	gtk_container_add ((GtkContainer*) _tmp132_, (GtkWidget*) _tmp133_);
	_tmp134_ = self->priv->_plugins;
	g_signal_emit_by_name (_tmp134_, "hook-preferences-dialog", self);
	_tmp135_ = self->priv->_plugins;
	if (scratch_services_plugins_manager_get_n_plugins (_tmp135_) > ((guint) 0)) {
		GtkWidget* pbox = NULL;
		ScratchServicesPluginsManager* _tmp136_;
		GtkWidget* _tmp137_;
		GtkWidget* _tmp138_;
		GtkStack* _tmp139_;
		GtkWidget* _tmp140_;
		_tmp136_ = self->priv->_plugins;
		_tmp137_ = scratch_services_plugins_manager_get_view (_tmp136_);
		pbox = _tmp137_;
		_tmp138_ = pbox;
		gtk_widget_set_vexpand (_tmp138_, TRUE);
		_tmp139_ = _data9_->stack;
		_tmp140_ = pbox;
		gtk_stack_add_titled (_tmp139_, _tmp140_, "extensions", _ ("Extensions"));
		_g_object_unref0 (pbox);
	}
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	_tmp141_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp142_ = main_box;
	gtk_container_add ((GtkContainer*) _tmp141_, (GtkWidget*) _tmp142_);
	_tmp143_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp144_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, gtk_button_get_type (), GtkButton));
	close_button = _tmp144_;
	_tmp145_ = close_button;
	g_signal_connect_object (_tmp145_, "clicked", (GCallback) __scratch_dialogs_preferences___lambda70__gtk_button_clicked, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) __scratch_dialogs_preferences___lambda71__gtk_widget_realize, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (main_box);
	_g_object_unref0 (stackswitcher);
	_g_object_unref0 (interface_box);
	_g_object_unref0 (font_box);
	_g_object_unref0 (select_font);
	_g_object_unref0 (editor_box);
	_g_object_unref0 (right_margin_position);
	_g_object_unref0 (draw_spaces_box);
	_g_object_unref0 (draw_spaces_label);
	_g_object_unref0 (behavior_box);
	_g_object_unref0 (projects_box);
	_g_object_unref0 (build_dir_box);
	_g_object_unref0 (buid_dir_label);
	_g_object_unref0 (build_dir_entry);
	_g_object_unref0 (indentation_box);
	_g_object_unref0 (indent_width_box);
	_g_object_unref0 (indent_width_label);
	_g_object_unref0 (indent_width);
	_g_object_unref0 (general_box);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return obj;
}

static void
scratch_dialogs_preferences_class_init (ScratchDialogsPreferencesClass * klass,
                                        gpointer klass_data)
{
	scratch_dialogs_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchDialogsPreferences_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_dialogs_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_dialogs_preferences_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_dialogs_preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY, scratch_dialogs_preferences_properties[SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY] = g_param_spec_object ("plugins", "plugins", "plugins", SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_dialogs_preferences_instance_init (ScratchDialogsPreferences * self,
                                           gpointer klass)
{
	self->priv = scratch_dialogs_preferences_get_instance_private (self);
}

static void
scratch_dialogs_preferences_finalize (GObject * obj)
{
	ScratchDialogsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	_g_object_unref0 (self->priv->_plugins);
	G_OBJECT_CLASS (scratch_dialogs_preferences_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_dialogs_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferences), 0, (GInstanceInitFunc) scratch_dialogs_preferences_instance_init, NULL };
	GType scratch_dialogs_preferences_type_id;
	scratch_dialogs_preferences_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "ScratchDialogsPreferences", &g_define_type_info, 0);
	ScratchDialogsPreferences_private_offset = g_type_add_instance_private (scratch_dialogs_preferences_type_id, sizeof (ScratchDialogsPreferencesPrivate));
	return scratch_dialogs_preferences_type_id;
}

GType
scratch_dialogs_preferences_get_type (void)
{
	static gsize scratch_dialogs_preferences_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_type_id__once)) {
		GType scratch_dialogs_preferences_type_id;
		scratch_dialogs_preferences_type_id = scratch_dialogs_preferences_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_type_id__once, scratch_dialogs_preferences_type_id);
	}
	return scratch_dialogs_preferences_type_id__once;
}

static void
_vala_scratch_dialogs_preferences_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ScratchDialogsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY:
		g_value_set_object (value, scratch_dialogs_preferences_get_plugins (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_dialogs_preferences_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ScratchDialogsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_PLUGINS_PROPERTY:
		scratch_dialogs_preferences_set_plugins (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

