/* SourceRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SourceRow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2013-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <float.h>
#include <math.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CALENDAR_TYPE_SOURCE_ROW (calendar_source_row_get_type ())
#define CALENDAR_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow))
#define CALENDAR_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))
#define CALENDAR_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))

typedef struct _CalendarSourceRow CalendarSourceRow;
typedef struct _CalendarSourceRowClass CalendarSourceRowClass;
typedef struct _CalendarSourceRowPrivate CalendarSourceRowPrivate;
enum  {
	CALENDAR_SOURCE_ROW_0_PROPERTY,
	CALENDAR_SOURCE_ROW_LOCATION_PROPERTY,
	CALENDAR_SOURCE_ROW_LABEL_PROPERTY,
	CALENDAR_SOURCE_ROW_SOURCE_PROPERTY,
	CALENDAR_SOURCE_ROW_NUM_PROPERTIES
};
static GParamSpec* calendar_source_row_properties[CALENDAR_SOURCE_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block34Data Block34Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL,
	CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL,
	CALENDAR_SOURCE_ROW_NUM_SIGNALS
};
static guint calendar_source_row_signals[CALENDAR_SOURCE_ROW_NUM_SIGNALS] = {0};

struct _CalendarSourceRow {
	GtkListBoxRow parent_instance;
	CalendarSourceRowPrivate * priv;
};

struct _CalendarSourceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _CalendarSourceRowPrivate {
	gchar* _location;
	gchar* _label;
	ESource* _source;
	GtkStack* stack;
	GtkBox* info_box;
	GtkButton* delete_button;
	GtkButton* edit_button;
	GtkLabel* calendar_name_label;
	GtkLabel* message_label;
	GtkCheckButton* visible_checkbutton;
};

struct _Block34Data {
	int _ref_count_;
	CalendarSourceRow* self;
	ESourceCalendar* cal;
	GtkEventBox* calendar_event_box;
	ESource* source;
};

static gint CalendarSourceRow_private_offset;
static gpointer calendar_source_row_parent_class = NULL;

VALA_EXTERN GType calendar_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarSourceRow, g_object_unref)
VALA_EXTERN CalendarSourceRow* calendar_source_row_new (ESource* source);
VALA_EXTERN CalendarSourceRow* calendar_source_row_construct (GType object_type,
                                                  ESource* source);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void calendar_source_row_set_source (CalendarSourceRow* self,
                                     ESource* value);
static void calendar_source_row_set_label (CalendarSourceRow* self,
                                    const gchar* value);
static void calendar_source_row_set_location (CalendarSourceRow* self,
                                       const gchar* value);
static void __lambda154_ (Block34Data* _data34_);
static void ___lambda154__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void calendar_source_row_style_calendar_color (CalendarSourceRow* self,
                                               const gchar* color);
static void __lambda155_ (CalendarSourceRow* self);
static void ___lambda155__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda156_ (Block34Data* _data34_);
static void ___lambda156__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda157_ (Block34Data* _data34_);
static void ___lambda157__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda158_ (Block34Data* _data34_);
static void ___lambda158__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN void calendar_source_row_source_has_changed (CalendarSourceRow* self);
static void _calendar_source_row_source_has_changed_e_source_changed (ESource* _sender,
                                                               gpointer self);
VALA_EXTERN ESource* calendar_source_row_get_source (CalendarSourceRow* self);
VALA_EXTERN void calendar_source_row_show_calendar_removed (CalendarSourceRow* self);
VALA_EXTERN const gchar* calendar_source_row_get_location (CalendarSourceRow* self);
VALA_EXTERN const gchar* calendar_source_row_get_label (CalendarSourceRow* self);
static void calendar_source_row_finalize (GObject * obj);
static GType calendar_source_row_get_type_once (void);
static void _vala_calendar_source_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_calendar_source_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
calendar_source_row_get_instance_private (CalendarSourceRow* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarSourceRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		CalendarSourceRow* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->calendar_event_box);
		_g_object_unref0 (_data34_->cal);
		_g_object_unref0 (_data34_->source);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static void
__lambda154_ (Block34Data* _data34_)
{
	CalendarSourceRow* self;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ESourceCalendar* _tmp6_;
	GtkCheckButton* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	self = _data34_->self;
	_tmp0_ = calendar_event_store_get_default ();
	calmodel = _tmp0_;
	_tmp1_ = self->priv->visible_checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == TRUE) {
		CalendarEventStore* _tmp4_;
		_tmp4_ = calmodel;
		calendar_event_store_add_source (_tmp4_, _data34_->source);
	} else {
		CalendarEventStore* _tmp5_;
		_tmp5_ = calmodel;
		calendar_event_store_remove_source (_tmp5_, _data34_->source);
	}
	_tmp6_ = _data34_->cal;
	_tmp7_ = self->priv->visible_checkbutton;
	_tmp8_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp7_);
	_tmp9_ = _tmp8_;
	e_source_selectable_set_selected ((ESourceSelectable*) _tmp6_, _tmp9_);
	{
		e_source_write_sync (_data34_->source, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_critical ("SourceRow.vala:56: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (calmodel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (calmodel);
}

static void
___lambda154__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda154_ (self);
}

static void
__lambda155_ (CalendarSourceRow* self)
{
	gtk_widget_hide ((GtkWidget*) self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda155__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda155_ ((CalendarSourceRow*) self);
}

static void
__lambda156_ (Block34Data* _data34_)
{
	CalendarSourceRow* self;
	self = _data34_->self;
	g_signal_emit (self, calendar_source_row_signals[CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL], 0, _data34_->source);
}

static void
___lambda156__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda156_ (self);
}

static void
__lambda157_ (Block34Data* _data34_)
{
	CalendarSourceRow* self;
	self = _data34_->self;
	g_signal_emit (self, calendar_source_row_signals[CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL], 0, _data34_->source);
}

static void
___lambda157__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda157_ (self);
}

static void
__lambda158_ (Block34Data* _data34_)
{
	CalendarSourceRow* self;
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	GtkStack* _tmp2_;
	self = _data34_->self;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_restore_calendar (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->stack;
	gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _data34_->calendar_event_box);
}

static void
___lambda158__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda158_ (self);
}

static void
_calendar_source_row_source_has_changed_e_source_changed (ESource* _sender,
                                                          gpointer self)
{
	calendar_source_row_source_has_changed ((CalendarSourceRow*) self);
}

CalendarSourceRow*
calendar_source_row_construct (GType object_type,
                               ESource* source)
{
	CalendarSourceRow * self = NULL;
	Block34Data* _data34_;
	ESource* _tmp0_;
	ESourceExtension* _tmp1_;
	ESourceCalendar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ESourceCalendar* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_;
	ESourceCalendar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gchar* _tmp23_;
	GtkButton* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gchar* _tmp30_;
	GtkButton* _tmp31_ = NULL;
	GtkBox* calendar_box = NULL;
	GtkBox* _tmp32_ = NULL;
	GtkCheckButton* _tmp33_;
	GtkLabel* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkEventBox* _tmp37_;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp38_ = NULL;
	GtkButton* close_button = NULL;
	GtkButton* _tmp39_ = NULL;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkLabel* _tmp44_ = NULL;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkLabel* _tmp48_;
	GtkBox* _tmp49_;
	GtkStack* _tmp50_ = NULL;
	GtkStack* _tmp51_;
	GtkBox* _tmp52_;
	GtkStack* _tmp53_;
	GtkStack* _tmp54_;
	GtkStack* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	g_return_val_if_fail (source != NULL, NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data34_->source);
	_data34_->source = _tmp0_;
	self = (CalendarSourceRow*) g_object_new (object_type, NULL);
	_data34_->self = g_object_ref (self);
	calendar_source_row_set_source (self, _data34_->source);
	_tmp1_ = e_source_get_extension (_data34_->source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_calendar_get_type (), ESourceCalendar));
	_data34_->cal = _tmp2_;
	_tmp3_ = e_source_dup_display_name (_data34_->source);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->calendar_name_label);
	self->priv->calendar_name_label = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = e_source_dup_display_name (_data34_->source);
	_tmp7_ = _tmp6_;
	calendar_source_row_set_label (self, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = maya_util_get_source_location (_data34_->source);
	_tmp9_ = _tmp8_;
	calendar_source_row_set_location (self, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = _data34_->cal;
	_tmp11_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkCheckButton*) gtk_check_button_new ();
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, _tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->visible_checkbutton);
	self->priv->visible_checkbutton = _tmp13_;
	_tmp14_ = self->priv->visible_checkbutton;
	g_signal_connect_data ((GtkToggleButton*) _tmp14_, "toggled", (GCallback) ___lambda154__gtk_toggle_button_toggled, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	_tmp15_ = _data34_->cal;
	_tmp16_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp15_);
	_tmp17_ = _tmp16_;
	calendar_source_row_style_calendar_color (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp19_ = e_source_get_removable (_data34_->source);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		_tmp18_ = _ ("Remove");
	} else {
		_tmp18_ = _ ("Not Removable");
	}
	_tmp21_ = e_source_get_removable (_data34_->source);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup (_tmp18_);
	_tmp24_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, _tmp22_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _tmp23_);
	_g_free0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->delete_button);
	self->priv->delete_button = _tmp24_;
	_tmp26_ = e_source_get_writable (_data34_->source);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		_tmp25_ = _ ("Edit…");
	} else {
		_tmp25_ = _ ("Not Editable");
	}
	_tmp28_ = e_source_get_writable (_data34_->source);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup (_tmp25_);
	_tmp31_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, _tmp29_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->edit_button);
	self->priv->edit_button = _tmp31_;
	_tmp32_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp32_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp32_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp32_, 12);
	g_object_ref_sink (_tmp32_);
	calendar_box = _tmp32_;
	_tmp33_ = self->priv->visible_checkbutton;
	gtk_container_add ((GtkContainer*) calendar_box, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->calendar_name_label;
	gtk_container_add ((GtkContainer*) calendar_box, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->delete_button;
	gtk_container_add ((GtkContainer*) calendar_box, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->edit_button;
	gtk_container_add ((GtkContainer*) calendar_box, (GtkWidget*) _tmp36_);
	_tmp37_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp37_);
	_data34_->calendar_event_box = _tmp37_;
	gtk_container_add ((GtkContainer*) _data34_->calendar_event_box, (GtkWidget*) calendar_box);
	gtk_widget_show ((GtkWidget*) _data34_->calendar_event_box);
	_tmp38_ = (GtkButton*) gtk_button_new_with_label (_ ("Undo"));
	gtk_widget_set_margin_end ((GtkWidget*) _tmp38_, 6);
	g_object_ref_sink (_tmp38_);
	undo_button = _tmp38_;
	_tmp39_ = (GtkButton*) gtk_button_new_from_icon_name ("process-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	gtk_button_set_relief (_tmp39_, GTK_RELIEF_NONE);
	g_object_ref_sink (_tmp39_);
	close_button = _tmp39_;
	_tmp40_ = e_source_get_display_name (_data34_->source);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf (_ ("\"%s\" removed"), _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = (GtkLabel*) gtk_label_new (_tmp43_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp44_, TRUE);
	gtk_label_set_xalign (_tmp44_, (gfloat) 0);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->message_label);
	self->priv->message_label = _tmp44_;
	_g_free0 (_tmp43_);
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->info_box);
	self->priv->info_box = _tmp45_;
	_tmp46_ = self->priv->info_box;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) close_button);
	_tmp47_ = self->priv->info_box;
	_tmp48_ = self->priv->message_label;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->info_box;
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) undo_button);
	_tmp50_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp50_, GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT);
	g_object_ref_sink (_tmp50_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp50_;
	_tmp51_ = self->priv->stack;
	_tmp52_ = self->priv->info_box;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _data34_->calendar_event_box);
	_tmp54_ = self->priv->stack;
	gtk_stack_set_visible_child (_tmp54_, (GtkWidget*) _data34_->calendar_event_box);
	_tmp55_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp55_);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda155__gtk_button_clicked, self, 0);
	_tmp56_ = self->priv->delete_button;
	g_signal_connect_data (_tmp56_, "clicked", (GCallback) ___lambda156__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	_tmp57_ = self->priv->edit_button;
	g_signal_connect_data (_tmp57_, "clicked", (GCallback) ___lambda157__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	g_signal_connect_data (undo_button, "clicked", (GCallback) ___lambda158__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	g_signal_connect_object (_data34_->source, "changed", (GCallback) _calendar_source_row_source_has_changed_e_source_changed, self, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (calendar_box);
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return self;
}

CalendarSourceRow*
calendar_source_row_new (ESource* source)
{
	return calendar_source_row_construct (CALENDAR_TYPE_SOURCE_ROW, source);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
calendar_source_row_style_calendar_color (CalendarSourceRow* self,
                                          const gchar* color)
{
	gchar* css_color = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = string_slice (color, (glong) 0, (glong) 7);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("@define-color accent_color %s;", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	css_color = _tmp3_;
	_tmp4_ = gtk_css_provider_new ();
	style_provider = _tmp4_;
	{
		gint _tmp5_;
		gint _tmp6_;
		GtkCheckButton* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp5_ = strlen (css_color);
		_tmp6_ = _tmp5_;
		gtk_css_provider_load_from_data (style_provider, css_color, (gssize) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->visible_checkbutton;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_provider (_tmp8_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("SourceRow.vala:140: Could not create CSS Provider: %s\n" \
"Stylesheet:\n" \
"%s", _tmp10_, css_color);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (style_provider);
		_g_free0 (css_color);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (style_provider);
	_g_free0 (css_color);
}

void
calendar_source_row_source_has_changed (CalendarSourceRow* self)
{
	GtkLabel* _tmp0_;
	ESource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	ESource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ESourceCalendar* cal = NULL;
	ESource* _tmp10_;
	ESourceExtension* _tmp11_;
	ESourceCalendar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkCheckButton* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->calendar_name_label;
	_tmp1_ = self->priv->_source;
	_tmp2_ = e_source_dup_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->message_label;
	_tmp5_ = self->priv->_source;
	_tmp6_ = e_source_get_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("\"%s\" removed"), _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->_source;
	_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp12_;
	_tmp13_ = e_source_selectable_dup_color ((ESourceSelectable*) cal);
	_tmp14_ = _tmp13_;
	calendar_source_row_style_calendar_color (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->visible_checkbutton;
	_tmp16_ = e_source_selectable_get_selected ((ESourceSelectable*) cal);
	_tmp17_ = _tmp16_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, _tmp17_);
	_g_object_unref0 (cal);
}

void
calendar_source_row_show_calendar_removed (CalendarSourceRow* self)
{
	GtkStack* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->info_box;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
}

const gchar*
calendar_source_row_get_location (CalendarSourceRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_location (CalendarSourceRow* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_location (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LOCATION_PROPERTY]);
	}
}

const gchar*
calendar_source_row_get_label (CalendarSourceRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_label (CalendarSourceRow* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LABEL_PROPERTY]);
	}
}

ESource*
calendar_source_row_get_source (CalendarSourceRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_source (CalendarSourceRow* self,
                                ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_SOURCE_PROPERTY]);
	}
}

static void
calendar_source_row_class_init (CalendarSourceRowClass * klass,
                                gpointer klass_data)
{
	calendar_source_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarSourceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_source_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_source_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = calendar_source_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_LOCATION_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LOCATION_PROPERTY] = g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_LABEL_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_SOURCE_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	calendar_source_row_signals[CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL] = g_signal_new ("remove-request", CALENDAR_TYPE_SOURCE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_source_get_type ());
	calendar_source_row_signals[CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL] = g_signal_new ("edit-request", CALENDAR_TYPE_SOURCE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_source_get_type ());
}

static void
calendar_source_row_instance_init (CalendarSourceRow * self,
                                   gpointer klass)
{
	self->priv = calendar_source_row_get_instance_private (self);
}

static void
calendar_source_row_finalize (GObject * obj)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	_g_free0 (self->priv->_location);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->info_box);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->calendar_name_label);
	_g_object_unref0 (self->priv->message_label);
	_g_object_unref0 (self->priv->visible_checkbutton);
	G_OBJECT_CLASS (calendar_source_row_parent_class)->finalize (obj);
}

static GType
calendar_source_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarSourceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_source_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarSourceRow), 0, (GInstanceInitFunc) calendar_source_row_instance_init, NULL };
	GType calendar_source_row_type_id;
	calendar_source_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "CalendarSourceRow", &g_define_type_info, 0);
	CalendarSourceRow_private_offset = g_type_add_instance_private (calendar_source_row_type_id, sizeof (CalendarSourceRowPrivate));
	return calendar_source_row_type_id;
}

GType
calendar_source_row_get_type (void)
{
	static volatile gsize calendar_source_row_type_id__once = 0;
	if (g_once_init_enter (&calendar_source_row_type_id__once)) {
		GType calendar_source_row_type_id;
		calendar_source_row_type_id = calendar_source_row_get_type_once ();
		g_once_init_leave (&calendar_source_row_type_id__once, calendar_source_row_type_id);
	}
	return calendar_source_row_type_id__once;
}

static void
_vala_calendar_source_row_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	switch (property_id) {
		case CALENDAR_SOURCE_ROW_LOCATION_PROPERTY:
		g_value_set_string (value, calendar_source_row_get_location (self));
		break;
		case CALENDAR_SOURCE_ROW_LABEL_PROPERTY:
		g_value_set_string (value, calendar_source_row_get_label (self));
		break;
		case CALENDAR_SOURCE_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, calendar_source_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_source_row_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	switch (property_id) {
		case CALENDAR_SOURCE_ROW_LOCATION_PROPERTY:
		calendar_source_row_set_location (self, g_value_get_string (value));
		break;
		case CALENDAR_SOURCE_ROW_LABEL_PROPERTY:
		calendar_source_row_set_label (self, g_value_get_string (value));
		break;
		case CALENDAR_SOURCE_ROW_SOURCE_PROPERTY:
		calendar_source_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

