/* EventDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EventDialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jaap Broekhuizen
 */

#include <glib-object.h>
#include <granite.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	MAYA_VIEW_EVENT_TYPE_ADD,
	MAYA_VIEW_EVENT_TYPE_EDIT
} MayaViewEventType;

#define MAYA_VIEW_TYPE_EVENT_TYPE (maya_view_event_type_get_type ())

#define MAYA_VIEW_TYPE_EVENT_DIALOG (maya_view_event_dialog_get_type ())
#define MAYA_VIEW_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog))
#define MAYA_VIEW_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))
#define MAYA_VIEW_IS_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_IS_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))

typedef struct _MayaViewEventDialog MayaViewEventDialog;
typedef struct _MayaViewEventDialogClass MayaViewEventDialogClass;
typedef struct _MayaViewEventDialogPrivate MayaViewEventDialogPrivate;

#define MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL (maya_view_event_edition_guests_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_GUESTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL, MayaViewEventEditionGuestsPanel))
#define MAYA_VIEW_EVENT_EDITION_GUESTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL, MayaViewEventEditionGuestsPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_GUESTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_GUESTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL))
#define MAYA_VIEW_EVENT_EDITION_GUESTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_GUESTS_PANEL, MayaViewEventEditionGuestsPanelClass))

typedef struct _MayaViewEventEditionGuestsPanel MayaViewEventEditionGuestsPanel;
typedef struct _MayaViewEventEditionGuestsPanelClass MayaViewEventEditionGuestsPanelClass;

#define MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL (maya_view_event_edition_info_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_INFO_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL, MayaViewEventEditionInfoPanel))
#define MAYA_VIEW_EVENT_EDITION_INFO_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL, MayaViewEventEditionInfoPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_INFO_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_INFO_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL))
#define MAYA_VIEW_EVENT_EDITION_INFO_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_INFO_PANEL, MayaViewEventEditionInfoPanelClass))

typedef struct _MayaViewEventEditionInfoPanel MayaViewEventEditionInfoPanel;
typedef struct _MayaViewEventEditionInfoPanelClass MayaViewEventEditionInfoPanelClass;

#define MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL (maya_view_event_edition_location_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_LOCATION_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL, MayaViewEventEditionLocationPanel))
#define MAYA_VIEW_EVENT_EDITION_LOCATION_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL, MayaViewEventEditionLocationPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_LOCATION_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_LOCATION_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL))
#define MAYA_VIEW_EVENT_EDITION_LOCATION_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_LOCATION_PANEL, MayaViewEventEditionLocationPanelClass))

typedef struct _MayaViewEventEditionLocationPanel MayaViewEventEditionLocationPanel;
typedef struct _MayaViewEventEditionLocationPanelClass MayaViewEventEditionLocationPanelClass;

#define MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL (maya_view_event_edition_reminder_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanel))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanelClass))

typedef struct _MayaViewEventEditionReminderPanel MayaViewEventEditionReminderPanel;
typedef struct _MayaViewEventEditionReminderPanelClass MayaViewEventEditionReminderPanelClass;

#define MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL (maya_view_event_edition_repeat_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanel))
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_REPEAT_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_REPEAT_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL))
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanelClass))

typedef struct _MayaViewEventEditionRepeatPanel MayaViewEventEditionRepeatPanel;
typedef struct _MayaViewEventEditionRepeatPanelClass MayaViewEventEditionRepeatPanelClass;
enum  {
	MAYA_VIEW_EVENT_DIALOG_0_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY,
	MAYA_VIEW_EVENT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define MAYA_SERVICES_TYPE_EVENT_PARSER (maya_services_event_parser_get_type ())
#define MAYA_SERVICES_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParser))
#define MAYA_SERVICES_IS_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER))
#define MAYA_SERVICES_EVENT_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParserIface))

typedef struct _MayaServicesEventParser MayaServicesEventParser;
typedef struct _MayaServicesEventParserIface MayaServicesEventParserIface;

#define MAYA_SERVICES_TYPE_PARSED_EVENT (maya_services_parsed_event_get_type ())
#define MAYA_SERVICES_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEvent))
#define MAYA_SERVICES_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))
#define MAYA_SERVICES_IS_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_IS_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_PARSED_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))

typedef struct _MayaServicesParsedEvent MayaServicesParsedEvent;
typedef struct _MayaServicesParsedEventClass MayaServicesParsedEventClass;
typedef struct _Block9Data Block9Data;

#define MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER (maya_services_event_parser_handler_get_type ())
#define MAYA_SERVICES_EVENT_PARSER_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER, MayaServicesEventParserHandler))
#define MAYA_SERVICES_EVENT_PARSER_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER, MayaServicesEventParserHandlerClass))
#define MAYA_SERVICES_IS_EVENT_PARSER_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER))
#define MAYA_SERVICES_IS_EVENT_PARSER_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER))
#define MAYA_SERVICES_EVENT_PARSER_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER_HANDLER, MayaServicesEventParserHandlerClass))

typedef struct _MayaServicesEventParserHandler MayaServicesEventParserHandler;
typedef struct _MayaServicesEventParserHandlerClass MayaServicesEventParserHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
typedef struct _MayaViewEventEditionInfoPanelPrivate MayaViewEventEditionInfoPanelPrivate;
typedef struct _MayaServicesParsedEventPrivate MayaServicesParsedEventPrivate;

#define CALENDAR_TYPE_DELETE_EVENT_DIALOG (calendar_delete_event_dialog_get_type ())
#define CALENDAR_DELETE_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_DELETE_EVENT_DIALOG, CalendarDeleteEventDialog))
#define CALENDAR_DELETE_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_DELETE_EVENT_DIALOG, CalendarDeleteEventDialogClass))
#define CALENDAR_IS_DELETE_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_DELETE_EVENT_DIALOG))
#define CALENDAR_IS_DELETE_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_DELETE_EVENT_DIALOG))
#define CALENDAR_DELETE_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_DELETE_EVENT_DIALOG, CalendarDeleteEventDialogClass))

typedef struct _CalendarDeleteEventDialog CalendarDeleteEventDialog;
typedef struct _CalendarDeleteEventDialogClass CalendarDeleteEventDialogClass;
typedef struct _Block11Data Block11Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MayaViewEventDialog {
	GraniteDialog parent_instance;
	MayaViewEventDialogPrivate * priv;
	gboolean can_edit;
};

struct _MayaViewEventDialogClass {
	GraniteDialogClass parent_class;
};

struct _MayaViewEventDialogPrivate {
	ESource* _source;
	ESource* _original_source;
	ECalComponent* _ecal;
	ECalComponent* _original_ecal;
	GDateTime* _date_time;
	ECalObjModType _mod_type;
	MayaViewEventType _event_type;
	MayaViewEventEditionGuestsPanel* guests_panel;
	MayaViewEventEditionInfoPanel* info_panel;
	MayaViewEventEditionLocationPanel* location_panel;
	MayaViewEventEditionReminderPanel* reminder_panel;
	MayaViewEventEditionRepeatPanel* repeat_panel;
};

struct _MayaServicesEventParserIface {
	GTypeInterface parent_iface;
	MayaServicesParsedEvent* (*parse_source) (MayaServicesEventParser* self, const gchar* source);
	gchar* (*get_language) (MayaServicesEventParser* self);
};

struct _Block9Data {
	int _ref_count_;
	MayaViewEventDialog* self;
	MayaServicesEventParser* parser;
	GtkButton* create_button;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	gboolean event_parsed;
};

struct _MayaViewEventEditionInfoPanel {
	GtkGrid parent_instance;
	MayaViewEventEditionInfoPanelPrivate * priv;
	gboolean nl_parsing_enabled;
};

struct _MayaViewEventEditionInfoPanelClass {
	GtkGridClass parent_class;
};

struct _MayaServicesParsedEvent {
	GObject parent_instance;
	MayaServicesParsedEventPrivate * priv;
	gchar* title;
	gchar* location;
	gchar* participants;
	GDateTime* from;
	GDateTime* to;
	gboolean* all_day;
	gboolean date_parsed;
	gboolean time_parsed;
};

struct _MayaServicesParsedEventClass {
	GObjectClass parent_class;
};

struct _Block11Data {
	int _ref_count_;
	MayaViewEventDialog* self;
	CalendarDeleteEventDialog* delete_dialog;
};

static gint MayaViewEventDialog_private_offset;
static gpointer maya_view_event_dialog_parent_class = NULL;

VALA_EXTERN GType maya_view_event_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType maya_view_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventDialog, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_guests_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionGuestsPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_info_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionInfoPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_location_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionLocationPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_reminder_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionReminderPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_repeat_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionRepeatPanel, g_object_unref)
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_new (ECalComponent* ecal,
                                                 GDateTime* date_time,
                                                 GtkWindow* parent);
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_construct (GType object_type,
                                                       ECalComponent* ecal,
                                                       GDateTime* date_time,
                                                       GtkWindow* parent);
VALA_EXTERN GType maya_services_parsed_event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParsedEvent, g_object_unref)
VALA_EXTERN GType maya_services_event_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesEventParser, g_object_unref)
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void maya_view_event_dialog_set_original_source (MayaViewEventDialog* self,
                                                 ESource* value);
VALA_EXTERN void maya_view_event_dialog_set_ecal (MayaViewEventDialog* self,
                                      ECalComponent* value);
VALA_EXTERN void maya_view_event_dialog_set_date_time (MayaViewEventDialog* self,
                                           GDateTime* value);
static void maya_view_event_dialog_set_original_ecal (MayaViewEventDialog* self,
                                               ECalComponent* value);
static void maya_view_event_dialog_set_event_type (MayaViewEventDialog* self,
                                            MayaViewEventType value);
VALA_EXTERN MayaViewEventEditionGuestsPanel* maya_view_event_edition_guests_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionGuestsPanel* maya_view_event_edition_guests_panel_construct (GType object_type,
                                                                                 MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionInfoPanel* maya_view_event_edition_info_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionInfoPanel* maya_view_event_edition_info_panel_construct (GType object_type,
                                                                             MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionLocationPanel* maya_view_event_edition_location_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionLocationPanel* maya_view_event_edition_location_panel_construct (GType object_type,
                                                                                     MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionReminderPanel* maya_view_event_edition_reminder_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionReminderPanel* maya_view_event_edition_reminder_panel_construct (GType object_type,
                                                                                     MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionRepeatPanel* maya_view_event_edition_repeat_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionRepeatPanel* maya_view_event_edition_repeat_panel_construct (GType object_type,
                                                                                 MayaViewEventDialog* parent_dialog);
VALA_EXTERN GType maya_services_event_parser_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesEventParserHandler, g_object_unref)
VALA_EXTERN MayaServicesEventParserHandler* maya_services_event_parser_handler_new (const gchar* lang);
VALA_EXTERN MayaServicesEventParserHandler* maya_services_event_parser_handler_construct (GType object_type,
                                                                              const gchar* lang);
VALA_EXTERN MayaServicesEventParser* maya_services_event_parser_handler_get_parser (MayaServicesEventParserHandler* self,
                                                                        const gchar* lang);
VALA_EXTERN const gchar* maya_services_event_parser_handler_get_locale (MayaServicesEventParserHandler* self);
VALA_EXTERN gchar* maya_services_event_parser_get_language (MayaServicesEventParser* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void ___lambda126_ (Block10Data* _data10_,
                    const gchar* ev_str);
VALA_EXTERN MayaServicesParsedEvent* maya_services_event_parser_parse_source (MayaServicesEventParser* self,
                                                                  const gchar* source);
VALA_EXTERN void maya_view_event_edition_info_panel_set_title (MayaViewEventEditionInfoPanel* self,
                                                   const gchar* value);
VALA_EXTERN void maya_view_event_edition_info_panel_set_from_date (MayaViewEventEditionInfoPanel* self,
                                                       GDateTime* value);
VALA_EXTERN void maya_view_event_edition_info_panel_set_to_date (MayaViewEventEditionInfoPanel* self,
                                                     GDateTime* value);
VALA_EXTERN void maya_view_event_edition_info_panel_set_from_time (MayaViewEventEditionInfoPanel* self,
                                                       GDateTime* value);
VALA_EXTERN void maya_view_event_edition_info_panel_set_to_time (MayaViewEventEditionInfoPanel* self,
                                                     GDateTime* value);
VALA_EXTERN void maya_view_event_edition_info_panel_set_all_day (MayaViewEventEditionInfoPanel* self,
                                                     gboolean value);
VALA_EXTERN const gchar* maya_view_event_edition_guests_panel_get_guests (MayaViewEventEditionGuestsPanel* self);
VALA_EXTERN void maya_view_event_edition_guests_panel_set_guests (MayaViewEventEditionGuestsPanel* self,
                                                      const gchar* value);
VALA_EXTERN void maya_view_event_edition_location_panel_set_location (MayaViewEventEditionLocationPanel* self,
                                                          const gchar* value);
static void maya_view_event_dialog_save_dialog (MayaViewEventDialog* self);
static void ____lambda126__maya_view_event_edition_info_panel_parse_event (MayaViewEventEditionInfoPanel* _sender,
                                                                    const gchar* event_str,
                                                                    gpointer self);
static void maya_view_event_dialog_remove_event (MayaViewEventDialog* self);
static void _maya_view_event_dialog_remove_event_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _maya_view_event_dialog_save_dialog_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void __lambda128_ (MayaViewEventDialog* self);
static void ___lambda128__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda129_ (Block9Data* _data9_,
                   gboolean is_valid);
static void ___lambda129__maya_view_event_edition_info_panel_valid_event (MayaViewEventEditionInfoPanel* _sender,
                                                                   gboolean is_valid,
                                                                   gpointer self);
VALA_EXTERN void maya_view_event_edition_info_panel_save (MayaViewEventEditionInfoPanel* self);
VALA_EXTERN void maya_view_event_edition_location_panel_save (MayaViewEventEditionLocationPanel* self);
VALA_EXTERN void maya_view_event_edition_guests_panel_save (MayaViewEventEditionGuestsPanel* self);
VALA_EXTERN void maya_view_event_edition_reminder_panel_save (MayaViewEventEditionReminderPanel* self);
VALA_EXTERN void maya_view_event_edition_repeat_panel_save (MayaViewEventEditionRepeatPanel* self);
static MayaViewEventType maya_view_event_dialog_get_event_type (MayaViewEventDialog* self);
VALA_EXTERN ESource* maya_view_event_dialog_get_source (MayaViewEventDialog* self);
VALA_EXTERN ECalComponent* maya_view_event_dialog_get_ecal (MayaViewEventDialog* self);
VALA_EXTERN ESource* maya_view_event_dialog_get_original_source (MayaViewEventDialog* self);
static ECalObjModType maya_view_event_dialog_get_mod_type (MayaViewEventDialog* self);
VALA_EXTERN ECalComponent* maya_view_event_dialog_get_original_ecal (MayaViewEventDialog* self);
VALA_EXTERN GType calendar_delete_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarDeleteEventDialog, g_object_unref)
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN CalendarDeleteEventDialog* calendar_delete_event_dialog_new (ESource* source,
                                                             ECalComponent* ecal_event,
                                                             ECalObjModType mod_type_prop);
VALA_EXTERN CalendarDeleteEventDialog* calendar_delete_event_dialog_construct (GType object_type,
                                                                   ESource* source,
                                                                   ECalComponent* ecal_event,
                                                                   ECalObjModType mod_type_prop);
static void __lambda127_ (Block11Data* _data11_,
                   gint response);
static void ___lambda127__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN void maya_view_event_dialog_set_source (MayaViewEventDialog* self,
                                        ESource* value);
VALA_EXTERN GDateTime* maya_view_event_dialog_get_date_time (MayaViewEventDialog* self);
static void maya_view_event_dialog_set_mod_type (MayaViewEventDialog* self,
                                          ECalObjModType value);
static void maya_view_event_dialog_finalize (GObject * obj);
static GType maya_view_event_dialog_get_type_once (void);
static void _vala_maya_view_event_dialog_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_maya_view_event_dialog_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static GType
maya_view_event_type_get_type_once (void)
{
	static const GEnumValue values[] = {{MAYA_VIEW_EVENT_TYPE_ADD, "MAYA_VIEW_EVENT_TYPE_ADD", "add"}, {MAYA_VIEW_EVENT_TYPE_EDIT, "MAYA_VIEW_EVENT_TYPE_EDIT", "edit"}, {0, NULL, NULL}};
	GType maya_view_event_type_type_id;
	maya_view_event_type_type_id = g_enum_register_static ("MayaViewEventType", values);
	return maya_view_event_type_type_id;
}

GType
maya_view_event_type_get_type (void)
{
	static volatile gsize maya_view_event_type_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_type_type_id__once)) {
		GType maya_view_event_type_type_id;
		maya_view_event_type_type_id = maya_view_event_type_get_type_once ();
		g_once_init_leave (&maya_view_event_type_type_id__once, maya_view_event_type_type_id);
	}
	return maya_view_event_type_type_id__once;
}

static inline gpointer
maya_view_event_dialog_get_instance_private (MayaViewEventDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventDialog_private_offset);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		MayaViewEventDialog* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->create_button);
		_g_object_unref0 (_data9_->parser);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		MayaViewEventDialog* self;
		self = _data10_->_data9_->self;
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static void
___lambda126_ (Block10Data* _data10_,
               const gchar* ev_str)
{
	Block9Data* _data9_;
	MayaViewEventDialog* self;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	g_return_if_fail (ev_str != NULL);
	if (!_data10_->event_parsed) {
		MayaServicesParsedEvent* ev = NULL;
		MayaServicesEventParser* _tmp0_;
		MayaServicesParsedEvent* _tmp1_;
		MayaViewEventEditionInfoPanel* _tmp2_;
		MayaServicesParsedEvent* _tmp3_;
		const gchar* _tmp4_;
		MayaServicesParsedEvent* _tmp5_;
		MayaServicesParsedEvent* _tmp12_;
		MayaServicesParsedEvent* _tmp19_;
		gboolean* _tmp20_;
		MayaViewEventEditionGuestsPanel* _tmp24_;
		MayaViewEventEditionGuestsPanel* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		MayaServicesParsedEvent* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		MayaServicesParsedEvent* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp0_ = _data9_->parser;
		_tmp1_ = maya_services_event_parser_parse_source (_tmp0_, ev_str);
		ev = _tmp1_;
		_tmp2_ = self->priv->info_panel;
		_tmp3_ = ev;
		_tmp4_ = _tmp3_->title;
		maya_view_event_edition_info_panel_set_title (_tmp2_, _tmp4_);
		_tmp5_ = ev;
		if (_tmp5_->date_parsed) {
			MayaViewEventEditionInfoPanel* _tmp6_;
			MayaServicesParsedEvent* _tmp7_;
			GDateTime* _tmp8_;
			MayaViewEventEditionInfoPanel* _tmp9_;
			MayaServicesParsedEvent* _tmp10_;
			GDateTime* _tmp11_;
			_tmp6_ = self->priv->info_panel;
			_tmp7_ = ev;
			_tmp8_ = _tmp7_->from;
			maya_view_event_edition_info_panel_set_from_date (_tmp6_, _tmp8_);
			_tmp9_ = self->priv->info_panel;
			_tmp10_ = ev;
			_tmp11_ = _tmp10_->to;
			maya_view_event_edition_info_panel_set_to_date (_tmp9_, _tmp11_);
		}
		_tmp12_ = ev;
		if (_tmp12_->time_parsed) {
			MayaViewEventEditionInfoPanel* _tmp13_;
			MayaServicesParsedEvent* _tmp14_;
			GDateTime* _tmp15_;
			MayaViewEventEditionInfoPanel* _tmp16_;
			MayaServicesParsedEvent* _tmp17_;
			GDateTime* _tmp18_;
			_tmp13_ = self->priv->info_panel;
			_tmp14_ = ev;
			_tmp15_ = _tmp14_->from;
			maya_view_event_edition_info_panel_set_from_time (_tmp13_, _tmp15_);
			_tmp16_ = self->priv->info_panel;
			_tmp17_ = ev;
			_tmp18_ = _tmp17_->to;
			maya_view_event_edition_info_panel_set_to_time (_tmp16_, _tmp18_);
		}
		_tmp19_ = ev;
		_tmp20_ = _tmp19_->all_day;
		if (_tmp20_ != NULL) {
			MayaViewEventEditionInfoPanel* _tmp21_;
			MayaServicesParsedEvent* _tmp22_;
			gboolean* _tmp23_;
			_tmp21_ = self->priv->info_panel;
			_tmp22_ = ev;
			_tmp23_ = _tmp22_->all_day;
			maya_view_event_edition_info_panel_set_all_day (_tmp21_, *_tmp23_);
		}
		_tmp24_ = self->priv->guests_panel;
		_tmp25_ = self->priv->guests_panel;
		_tmp26_ = maya_view_event_edition_guests_panel_get_guests (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = ev;
		_tmp29_ = _tmp28_->participants;
		_tmp30_ = g_strconcat (_tmp27_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		maya_view_event_edition_guests_panel_set_guests (_tmp25_, _tmp31_);
		_g_free0 (_tmp31_);
		_tmp32_ = ev;
		_tmp33_ = _tmp32_->location;
		_tmp34_ = strlen (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ > 0) {
			MayaViewEventEditionLocationPanel* _tmp36_;
			MayaServicesParsedEvent* _tmp37_;
			const gchar* _tmp38_;
			_tmp36_ = self->priv->location_panel;
			_tmp37_ = ev;
			_tmp38_ = _tmp37_->location;
			maya_view_event_edition_location_panel_set_location (_tmp36_, _tmp38_);
		}
		_data10_->event_parsed = TRUE;
		_g_object_unref0 (ev);
	} else {
		maya_view_event_dialog_save_dialog (self);
	}
}

static void
____lambda126__maya_view_event_edition_info_panel_parse_event (MayaViewEventEditionInfoPanel* _sender,
                                                               const gchar* event_str,
                                                               gpointer self)
{
	___lambda126_ (self, event_str);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_maya_view_event_dialog_remove_event_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	maya_view_event_dialog_remove_event ((MayaViewEventDialog*) self);
}

static void
_maya_view_event_dialog_save_dialog_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	maya_view_event_dialog_save_dialog ((MayaViewEventDialog*) self);
}

static void
__lambda128_ (MayaViewEventDialog* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda128__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda128_ ((MayaViewEventDialog*) self);
}

static void
__lambda129_ (Block9Data* _data9_,
              gboolean is_valid)
{
	MayaViewEventDialog* self;
	GtkButton* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->create_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, is_valid);
}

static void
___lambda129__maya_view_event_edition_info_panel_valid_event (MayaViewEventEditionInfoPanel* _sender,
                                                              gboolean is_valid,
                                                              gpointer self)
{
	__lambda129_ (self, is_valid);
}

MayaViewEventDialog*
maya_view_event_dialog_construct (GType object_type,
                                  ECalComponent* ecal,
                                  GDateTime* date_time,
                                  GtkWindow* parent)
{
	MayaViewEventDialog * self = NULL;
	Block9Data* _data9_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	MayaViewEventEditionGuestsPanel* _tmp3_;
	MayaViewEventEditionInfoPanel* _tmp4_;
	MayaViewEventEditionLocationPanel* _tmp5_;
	MayaViewEventEditionReminderPanel* _tmp6_;
	MayaViewEventEditionRepeatPanel* _tmp7_;
	MayaServicesEventParserHandler* handler = NULL;
	MayaServicesEventParserHandler* _tmp8_;
	MayaServicesEventParserHandler* _tmp9_;
	MayaServicesEventParserHandler* _tmp10_;
	const gchar* _tmp11_;
	MayaServicesEventParser* _tmp12_;
	MayaServicesEventParserHandler* _tmp13_;
	const gchar* _tmp14_;
	MayaServicesEventParser* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	GtkStack* stack = NULL;
	GtkStack* _tmp21_;
	GtkStack* _tmp22_;
	MayaViewEventEditionInfoPanel* _tmp23_;
	GtkStack* _tmp24_;
	MayaViewEventEditionLocationPanel* _tmp25_;
	GtkStack* _tmp26_;
	MayaViewEventEditionGuestsPanel* _tmp27_;
	GtkStack* _tmp28_;
	MayaViewEventEditionReminderPanel* _tmp29_;
	GtkStack* _tmp30_;
	MayaViewEventEditionRepeatPanel* _tmp31_;
	GtkStack* _tmp32_;
	MayaViewEventEditionInfoPanel* _tmp33_;
	GValue _tmp34_ = {0};
	GtkStack* _tmp35_;
	MayaViewEventEditionLocationPanel* _tmp36_;
	GValue _tmp37_ = {0};
	GtkStack* _tmp38_;
	MayaViewEventEditionGuestsPanel* _tmp39_;
	GValue _tmp40_ = {0};
	GtkStack* _tmp41_;
	MayaViewEventEditionReminderPanel* _tmp42_;
	GValue _tmp43_ = {0};
	GtkStack* _tmp44_;
	MayaViewEventEditionRepeatPanel* _tmp45_;
	GValue _tmp46_ = {0};
	GtkStackSwitcher* stack_switcher = NULL;
	GtkStack* _tmp47_;
	GtkStack* _tmp48_;
	GtkStackSwitcher* _tmp49_ = NULL;
	GtkBox* buttonbox = NULL;
	GtkBox* _tmp50_ = NULL;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkStyleContext* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkButton* _tmp67_;
	GtkSizeGroup* button_sizegroup = NULL;
	GtkSizeGroup* _tmp68_;
	GtkButton* _tmp69_;
	GtkBox* box = NULL;
	GtkBox* _tmp70_;
	GtkStackSwitcher* _tmp71_;
	GtkStack* _tmp72_;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	MayaViewEventEditionInfoPanel* _tmp75_;
	GtkStack* _tmp76_;
	g_return_val_if_fail (parent != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	self = (MayaViewEventDialog*) granite_dialog_construct (object_type);
	_data9_->self = g_object_ref (self);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	if (ecal != NULL) {
		gconstpointer _tmp0_;
		_tmp0_ = g_object_get_data ((GObject*) ecal, "source");
		maya_view_event_dialog_set_original_source (self, (ESource*) _tmp0_);
	}
	maya_view_event_dialog_set_ecal (self, ecal);
	maya_view_event_dialog_set_date_time (self, date_time);
	_tmp1_ = maya_util_copy_ecal_component (ecal);
	_tmp2_ = _tmp1_;
	maya_view_event_dialog_set_original_ecal (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	if (date_time != NULL) {
		gtk_window_set_title ((GtkWindow*) self, _ ("Add Event"));
		maya_view_event_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_ADD);
	} else {
		gtk_window_set_title ((GtkWindow*) self, _ ("Edit Event"));
		maya_view_event_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_EDIT);
	}
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER_ON_PARENT, NULL);
	gtk_window_set_type_hint ((GtkWindow*) self, GDK_WINDOW_TYPE_HINT_DIALOG);
	_tmp3_ = maya_view_event_edition_guests_panel_new (self);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->guests_panel);
	self->priv->guests_panel = _tmp3_;
	_tmp4_ = maya_view_event_edition_info_panel_new (self);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->info_panel);
	self->priv->info_panel = _tmp4_;
	_tmp5_ = maya_view_event_edition_location_panel_new (self);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->location_panel);
	self->priv->location_panel = _tmp5_;
	_tmp6_ = maya_view_event_edition_reminder_panel_new (self);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->reminder_panel);
	self->priv->reminder_panel = _tmp6_;
	_tmp7_ = maya_view_event_edition_repeat_panel_new (self);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->repeat_panel);
	self->priv->repeat_panel = _tmp7_;
	_tmp8_ = maya_services_event_parser_handler_new (NULL);
	handler = _tmp8_;
	_tmp9_ = handler;
	_tmp10_ = handler;
	_tmp11_ = maya_services_event_parser_handler_get_locale (_tmp10_);
	_tmp12_ = maya_services_event_parser_handler_get_parser (_tmp9_, _tmp11_);
	_data9_->parser = _tmp12_;
	_tmp13_ = handler;
	_tmp14_ = maya_services_event_parser_handler_get_locale (_tmp13_);
	_tmp15_ = _data9_->parser;
	_tmp16_ = maya_services_event_parser_get_language (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_contains (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	if (_tmp18_) {
		Block10Data* _data10_;
		MayaViewEventEditionInfoPanel* _tmp19_;
		MayaViewEventEditionInfoPanel* _tmp20_;
		_data10_ = g_slice_new0 (Block10Data);
		_data10_->_ref_count_ = 1;
		_data10_->_data9_ = block9_data_ref (_data9_);
		_tmp19_ = self->priv->info_panel;
		_tmp19_->nl_parsing_enabled = TRUE;
		_data10_->event_parsed = FALSE;
		_tmp20_ = self->priv->info_panel;
		g_signal_connect_data (_tmp20_, "parse-event", (GCallback) ____lambda126__maya_view_event_edition_info_panel_parse_event, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
		block10_data_unref (_data10_);
		_data10_ = NULL;
	}
	_tmp21_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp21_);
	stack = _tmp21_;
	_tmp22_ = stack;
	_tmp23_ = self->priv->info_panel;
	gtk_stack_add_titled (_tmp22_, (GtkWidget*) _tmp23_, "infopanel", _ ("General Informations"));
	_tmp24_ = stack;
	_tmp25_ = self->priv->location_panel;
	gtk_stack_add_titled (_tmp24_, (GtkWidget*) _tmp25_, "locationpanel", _ ("Location"));
	_tmp26_ = stack;
	_tmp27_ = self->priv->guests_panel;
	gtk_stack_add_titled (_tmp26_, (GtkWidget*) _tmp27_, "guestspanel", _ ("Guests"));
	_tmp28_ = stack;
	_tmp29_ = self->priv->reminder_panel;
	gtk_stack_add_titled (_tmp28_, (GtkWidget*) _tmp29_, "reminderpanel", _ ("Reminders"));
	_tmp30_ = stack;
	_tmp31_ = self->priv->repeat_panel;
	gtk_stack_add_titled (_tmp30_, (GtkWidget*) _tmp31_, "repeatpanel", C_ ("Section Header", "Repeat"));
	_tmp32_ = stack;
	_tmp33_ = self->priv->info_panel;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, "office-calendar-symbolic");
	gtk_container_child_set_property ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_, "icon-name", &_tmp34_);
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
	_tmp35_ = stack;
	_tmp36_ = self->priv->location_panel;
	g_value_init (&_tmp37_, G_TYPE_STRING);
	g_value_set_string (&_tmp37_, "mark-location-symbolic");
	gtk_container_child_set_property ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_, "icon-name", &_tmp37_);
	G_IS_VALUE (&_tmp37_) ? (g_value_unset (&_tmp37_), NULL) : NULL;
	_tmp38_ = stack;
	_tmp39_ = self->priv->guests_panel;
	g_value_init (&_tmp40_, G_TYPE_STRING);
	g_value_set_string (&_tmp40_, "system-users-symbolic");
	gtk_container_child_set_property ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_, "icon-name", &_tmp40_);
	G_IS_VALUE (&_tmp40_) ? (g_value_unset (&_tmp40_), NULL) : NULL;
	_tmp41_ = stack;
	_tmp42_ = self->priv->reminder_panel;
	g_value_init (&_tmp43_, G_TYPE_STRING);
	g_value_set_string (&_tmp43_, "alarm-symbolic");
	gtk_container_child_set_property ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_, "icon-name", &_tmp43_);
	G_IS_VALUE (&_tmp43_) ? (g_value_unset (&_tmp43_), NULL) : NULL;
	_tmp44_ = stack;
	_tmp45_ = self->priv->repeat_panel;
	g_value_init (&_tmp46_, G_TYPE_STRING);
	g_value_set_string (&_tmp46_, "media-playlist-repeat-symbolic");
	gtk_container_child_set_property ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_, "icon-name", &_tmp46_);
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
	_tmp47_ = stack;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	_tmp49_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	gtk_box_set_homogeneous ((GtkBox*) _tmp49_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp49_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp49_, 12);
	gtk_stack_switcher_set_stack (_tmp49_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	g_object_ref_sink (_tmp49_);
	stack_switcher = _tmp49_;
	_tmp50_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_box_set_baseline_position (_tmp50_, GTK_BASELINE_POSITION_CENTER);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp50_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp50_, 12);
	g_object_ref_sink (_tmp50_);
	buttonbox = _tmp50_;
	if (date_time == NULL) {
		GtkButton* delete_button = NULL;
		GtkButton* _tmp51_ = NULL;
		GtkButton* _tmp52_;
		GtkStyleContext* _tmp53_;
		GtkButton* _tmp54_;
		GtkBox* _tmp55_;
		GtkButton* _tmp56_;
		_tmp51_ = (GtkButton*) gtk_button_new_with_label (_ ("Delete Event…"));
		gtk_widget_set_halign ((GtkWidget*) _tmp51_, GTK_ALIGN_START);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp51_, TRUE);
		g_object_ref_sink (_tmp51_);
		delete_button = _tmp51_;
		_tmp52_ = delete_button;
		_tmp53_ = gtk_widget_get_style_context ((GtkWidget*) _tmp52_);
		gtk_style_context_add_class (_tmp53_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_tmp54_ = delete_button;
		g_signal_connect_object (_tmp54_, "clicked", (GCallback) _maya_view_event_dialog_remove_event_gtk_button_clicked, self, 0);
		_tmp55_ = buttonbox;
		_tmp56_ = delete_button;
		gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
		_g_object_unref0 (delete_button);
	}
	_tmp57_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp57_);
	_data9_->create_button = _tmp57_;
	_tmp58_ = _data9_->create_button;
	_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
	gtk_style_context_add_class (_tmp59_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp60_ = _data9_->create_button;
	g_signal_connect_object (_tmp60_, "clicked", (GCallback) _maya_view_event_dialog_save_dialog_gtk_button_clicked, self, 0);
	if (date_time != NULL) {
		GtkButton* _tmp61_;
		GtkButton* _tmp62_;
		_tmp61_ = _data9_->create_button;
		gtk_button_set_label (_tmp61_, _ ("Create Event"));
		_tmp62_ = _data9_->create_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp62_, FALSE);
	} else {
		GtkButton* _tmp63_;
		_tmp63_ = _data9_->create_button;
		gtk_button_set_label (_tmp63_, _ ("Save Changes"));
	}
	_tmp64_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp64_);
	cancel_button = _tmp64_;
	g_signal_connect_object (cancel_button, "clicked", (GCallback) ___lambda128__gtk_button_clicked, self, 0);
	_tmp65_ = buttonbox;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) cancel_button);
	_tmp66_ = buttonbox;
	_tmp67_ = _data9_->create_button;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	button_sizegroup = _tmp68_;
	gtk_size_group_add_widget (button_sizegroup, (GtkWidget*) cancel_button);
	_tmp69_ = _data9_->create_button;
	gtk_size_group_add_widget (button_sizegroup, (GtkWidget*) _tmp69_);
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp70_);
	box = _tmp70_;
	_tmp71_ = stack_switcher;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp71_);
	_tmp72_ = stack;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp72_);
	_tmp73_ = buttonbox;
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) _tmp73_);
	gtk_widget_show_all ((GtkWidget*) box);
	_tmp74_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) box);
	_tmp75_ = self->priv->info_panel;
	g_signal_connect_data (_tmp75_, "valid-event", (GCallback) ___lambda129__maya_view_event_edition_info_panel_valid_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp76_ = stack;
	gtk_stack_set_visible_child_name (_tmp76_, "infopanel");
	_g_object_unref0 (box);
	_g_object_unref0 (button_sizegroup);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (buttonbox);
	_g_object_unref0 (stack_switcher);
	_g_object_unref0 (stack);
	_g_object_unref0 (handler);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return self;
}

MayaViewEventDialog*
maya_view_event_dialog_new (ECalComponent* ecal,
                            GDateTime* date_time,
                            GtkWindow* parent)
{
	return maya_view_event_dialog_construct (MAYA_VIEW_TYPE_EVENT_DIALOG, ecal, date_time, parent);
}

static void
maya_view_event_dialog_save_dialog (MayaViewEventDialog* self)
{
	MayaViewEventEditionInfoPanel* _tmp0_;
	MayaViewEventEditionLocationPanel* _tmp1_;
	MayaViewEventEditionGuestsPanel* _tmp2_;
	MayaViewEventEditionReminderPanel* _tmp3_;
	MayaViewEventEditionRepeatPanel* _tmp4_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp5_;
	MayaViewEventType _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_panel;
	maya_view_event_edition_info_panel_save (_tmp0_);
	_tmp1_ = self->priv->location_panel;
	maya_view_event_edition_location_panel_save (_tmp1_);
	_tmp2_ = self->priv->guests_panel;
	maya_view_event_edition_guests_panel_save (_tmp2_);
	_tmp3_ = self->priv->reminder_panel;
	maya_view_event_edition_reminder_panel_save (_tmp3_);
	_tmp4_ = self->priv->repeat_panel;
	maya_view_event_edition_repeat_panel_save (_tmp4_);
	_tmp5_ = calendar_event_store_get_default ();
	calmodel = _tmp5_;
	_tmp6_ = self->priv->_event_type;
	if (_tmp6_ == MAYA_VIEW_EVENT_TYPE_ADD) {
		CalendarEventStore* _tmp7_;
		ESource* _tmp8_;
		ECalComponent* _tmp9_;
		_tmp7_ = calmodel;
		_tmp8_ = self->priv->_source;
		_tmp9_ = self->priv->_ecal;
		calendar_event_store_add_event (_tmp7_, _tmp8_, _tmp9_);
	} else {
		ESource* _tmp10_;
		ESource* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		ESource* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gboolean _tmp17_;
		_tmp10_ = self->priv->_original_source;
		_vala_assert (_tmp10_ != NULL, "original_source != null");
		_tmp11_ = self->priv->_original_source;
		_tmp12_ = e_source_dup_uid (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_source;
		_tmp15_ = e_source_dup_uid (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strcmp0 (_tmp13_, _tmp16_) == 0;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		if (_tmp17_) {
			CalendarEventStore* _tmp18_;
			ESource* _tmp19_;
			ECalComponent* _tmp20_;
			ECalObjModType _tmp21_;
			_tmp18_ = calmodel;
			_tmp19_ = self->priv->_source;
			_tmp20_ = self->priv->_ecal;
			_tmp21_ = self->priv->_mod_type;
			calendar_event_store_update_event (_tmp18_, _tmp19_, _tmp20_, _tmp21_);
		} else {
			CalendarEventStore* _tmp22_;
			ESource* _tmp23_;
			ECalComponent* _tmp24_;
			ECalObjModType _tmp25_;
			CalendarEventStore* _tmp26_;
			ESource* _tmp27_;
			ECalComponent* _tmp28_;
			_tmp22_ = calmodel;
			_tmp23_ = self->priv->_original_source;
			_tmp24_ = self->priv->_original_ecal;
			_tmp25_ = self->priv->_mod_type;
			calendar_event_store_remove_event (_tmp22_, _tmp23_, _tmp24_, _tmp25_);
			_tmp26_ = calmodel;
			_tmp27_ = self->priv->_source;
			_tmp28_ = self->priv->_ecal;
			calendar_event_store_add_event (_tmp26_, _tmp27_, _tmp28_);
		}
	}
	gtk_widget_destroy ((GtkWidget*) self);
	_g_object_unref0 (calmodel);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		MayaViewEventDialog* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->delete_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda127_ (Block11Data* _data11_,
              gint response)
{
	MayaViewEventDialog* self;
	self = _data11_->self;
	if (response == ((gint) GTK_RESPONSE_YES)) {
		gtk_widget_destroy ((GtkWidget*) self);
	}
	gtk_widget_destroy ((GtkWidget*) _data11_->delete_dialog);
}

static void
___lambda127__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda127_ (self, response_id);
}

static void
maya_view_event_dialog_remove_event (MayaViewEventDialog* self)
{
	Block11Data* _data11_;
	ESource* _tmp0_;
	ESource* _tmp1_;
	ECalComponent* _tmp2_;
	ECalObjModType _tmp3_;
	GtkWindow* _tmp4_;
	CalendarDeleteEventDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = self->priv->_original_source;
	_vala_assert (_tmp0_ != NULL, "original_source != null");
	_tmp1_ = self->priv->_original_source;
	_tmp2_ = self->priv->_ecal;
	_tmp3_ = self->priv->_mod_type;
	_tmp4_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp5_ = calendar_delete_event_dialog_new (_tmp1_, _tmp2_, _tmp3_);
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_data11_->delete_dialog = _tmp5_;
	g_signal_connect_data ((GtkDialog*) _data11_->delete_dialog, "response", (GCallback) ___lambda127__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data11_->delete_dialog);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

ESource*
maya_view_event_dialog_get_source (MayaViewEventDialog* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

void
maya_view_event_dialog_set_source (MayaViewEventDialog* self,
                                   ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_dialog_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY]);
	}
}

ESource*
maya_view_event_dialog_get_original_source (MayaViewEventDialog* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_original_source;
	result = _tmp0_;
	return result;
}

static void
maya_view_event_dialog_set_original_source (MayaViewEventDialog* self,
                                            ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_dialog_get_original_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_original_source);
		self->priv->_original_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY]);
	}
}

ECalComponent*
maya_view_event_dialog_get_ecal (MayaViewEventDialog* self)
{
	ECalComponent* result;
	ECalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ecal;
	result = _tmp0_;
	return result;
}

void
maya_view_event_dialog_set_ecal (MayaViewEventDialog* self,
                                 ECalComponent* value)
{
	ECalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_dialog_get_ecal (self);
	if (old_value != value) {
		ECalComponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_ecal);
		self->priv->_ecal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY]);
	}
}

ECalComponent*
maya_view_event_dialog_get_original_ecal (MayaViewEventDialog* self)
{
	ECalComponent* result;
	ECalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_original_ecal;
	result = _tmp0_;
	return result;
}

static void
maya_view_event_dialog_set_original_ecal (MayaViewEventDialog* self,
                                          ECalComponent* value)
{
	ECalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_dialog_get_original_ecal (self);
	if (old_value != value) {
		ECalComponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_original_ecal);
		self->priv->_original_ecal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY]);
	}
}

GDateTime*
maya_view_event_dialog_get_date_time (MayaViewEventDialog* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_time;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
maya_view_event_dialog_set_date_time (MayaViewEventDialog* self,
                                      GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_event_dialog_get_date_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_date_time);
		self->priv->_date_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY]);
	}
}

static ECalObjModType
maya_view_event_dialog_get_mod_type (MayaViewEventDialog* self)
{
	ECalObjModType result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_mod_type;
	return result;
}

static void
maya_view_event_dialog_set_mod_type (MayaViewEventDialog* self,
                                     ECalObjModType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mod_type = value;
}

static MayaViewEventType
maya_view_event_dialog_get_event_type (MayaViewEventDialog* self)
{
	MayaViewEventType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_event_type;
	return result;
}

static void
maya_view_event_dialog_set_event_type (MayaViewEventDialog* self,
                                       MayaViewEventType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_event_type = value;
}

static void
maya_view_event_dialog_class_init (MayaViewEventDialogClass * klass,
                                   gpointer klass_data)
{
	maya_view_event_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_event_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_event_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY] = g_param_spec_object ("original-source", "original-source", "original-source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY] = g_param_spec_object ("ecal", "ecal", "ecal", e_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY] = g_param_spec_object ("original-ecal", "original-ecal", "original-ecal", e_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY, maya_view_event_dialog_properties[MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY] = g_param_spec_boxed ("date-time", "date-time", "date-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
maya_view_event_dialog_instance_init (MayaViewEventDialog * self,
                                      gpointer klass)
{
	self->priv = maya_view_event_dialog_get_instance_private (self);
	self->can_edit = TRUE;
	self->priv->_mod_type = E_CAL_OBJ_MOD_ALL;
}

static void
maya_view_event_dialog_finalize (GObject * obj)
{
	MayaViewEventDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->_original_source);
	_g_object_unref0 (self->priv->_ecal);
	_g_object_unref0 (self->priv->_original_ecal);
	_g_date_time_unref0 (self->priv->_date_time);
	_g_object_unref0 (self->priv->guests_panel);
	_g_object_unref0 (self->priv->info_panel);
	_g_object_unref0 (self->priv->location_panel);
	_g_object_unref0 (self->priv->reminder_panel);
	_g_object_unref0 (self->priv->repeat_panel);
	G_OBJECT_CLASS (maya_view_event_dialog_parent_class)->finalize (obj);
}

static GType
maya_view_event_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventDialog), 0, (GInstanceInitFunc) maya_view_event_dialog_instance_init, NULL };
	GType maya_view_event_dialog_type_id;
	maya_view_event_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "MayaViewEventDialog", &g_define_type_info, 0);
	MayaViewEventDialog_private_offset = g_type_add_instance_private (maya_view_event_dialog_type_id, sizeof (MayaViewEventDialogPrivate));
	return maya_view_event_dialog_type_id;
}

GType
maya_view_event_dialog_get_type (void)
{
	static volatile gsize maya_view_event_dialog_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_dialog_type_id__once)) {
		GType maya_view_event_dialog_type_id;
		maya_view_event_dialog_type_id = maya_view_event_dialog_get_type_once ();
		g_once_init_leave (&maya_view_event_dialog_type_id__once, maya_view_event_dialog_type_id);
	}
	return maya_view_event_dialog_type_id__once;
}

static void
_vala_maya_view_event_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MayaViewEventDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog);
	switch (property_id) {
		case MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY:
		g_value_set_object (value, maya_view_event_dialog_get_source (self));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY:
		g_value_set_object (value, maya_view_event_dialog_get_original_source (self));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY:
		g_value_set_object (value, maya_view_event_dialog_get_ecal (self));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY:
		g_value_set_object (value, maya_view_event_dialog_get_original_ecal (self));
		break;
		case MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY:
		g_value_set_boxed (value, maya_view_event_dialog_get_date_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_event_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MayaViewEventDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog);
	switch (property_id) {
		case MAYA_VIEW_EVENT_DIALOG_SOURCE_PROPERTY:
		maya_view_event_dialog_set_source (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ORIGINAL_SOURCE_PROPERTY:
		maya_view_event_dialog_set_original_source (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ECAL_PROPERTY:
		maya_view_event_dialog_set_ecal (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_EVENT_DIALOG_ORIGINAL_ECAL_PROPERTY:
		maya_view_event_dialog_set_original_ecal (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_EVENT_DIALOG_DATE_TIME_PROPERTY:
		maya_view_event_dialog_set_date_time (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

