// This file is part of OpenCV project.
// It is subject to the license terms in the LICENSE file found in the top-level directory
// of this distribution and at http://opencv.org/license.html

namespace {



/**
  * Dictionaries are stored as a list of bytes in its four rotations
  * On each rotation, the marker is divided in bytes assuming a row-major order
  * This format allows a faster marker identification.
  * For a dictionary composed by M markers of NxN bits, the structure dimensions should be:
  * const char name[nMarkers][4rotations][nBytes], or more specifically:
  * const char name[M][4][ceil(NxN/8)]
  * The element [i][j][k] represents the k-th byte of the i-th marker in the dictionary
  * in its j-th rotation.
  * Each rotation implies a 90 degree rotation of the marker in anticlockwise direction.
  */

static unsigned char DICT_ARUCO_BYTES[][4][4] = {
    { { 132, 33, 8, 0 },
      { 0, 0, 15, 1 },
      { 8, 66, 16, 1 },
      { 248, 0, 0, 0 }, },
    { { 132, 33, 11, 1 },
      { 8, 66, 15, 1 },
      { 232, 66, 16, 1 },
      { 248, 33, 8, 0 }, },
    { { 132, 33, 4, 1 },
      { 8, 0, 31, 0 },
      { 144, 66, 16, 1 },
      { 124, 0, 8, 0 }, },
    { { 132, 33, 7, 0 },
      { 0, 66, 31, 0 },
      { 112, 66, 16, 1 },
      { 124, 33, 0, 0 }, },
    { { 132, 33, 120, 0 },
      { 16, 132, 15, 1 },
      { 15, 66, 16, 1 },
      { 248, 16, 132, 0 }, },
    { { 132, 33, 123, 1 },
      { 24, 198, 15, 1 },
      { 239, 66, 16, 1 },
      { 248, 49, 140, 0 }, },
    { { 132, 33, 116, 1 },
      { 24, 132, 31, 0 },
      { 151, 66, 16, 1 },
      { 124, 16, 140, 0 }, },
    { { 132, 33, 119, 0 },
      { 16, 198, 31, 0 },
      { 119, 66, 16, 1 },
      { 124, 49, 132, 0 }, },
    { { 132, 32, 152, 0 },
      { 16, 0, 46, 1 },
      { 12, 130, 16, 1 },
      { 186, 0, 4, 0 }, },
    { { 132, 32, 155, 1 },
      { 24, 66, 46, 1 },
      { 236, 130, 16, 1 },
      { 186, 33, 12, 0 }, },
    { { 132, 32, 148, 1 },
      { 24, 0, 62, 0 },
      { 148, 130, 16, 1 },
      { 62, 0, 12, 0 }, },
    { { 132, 32, 151, 0 },
      { 16, 66, 62, 0 },
      { 116, 130, 16, 1 },
      { 62, 33, 4, 0 }, },
    { { 132, 32, 232, 0 },
      { 0, 132, 46, 1 },
      { 11, 130, 16, 1 },
      { 186, 16, 128, 0 }, },
    { { 132, 32, 235, 1 },
      { 8, 198, 46, 1 },
      { 235, 130, 16, 1 },
      { 186, 49, 136, 0 }, },
    { { 132, 32, 228, 1 },
      { 8, 132, 62, 0 },
      { 147, 130, 16, 1 },
      { 62, 16, 136, 0 }, },
    { { 132, 32, 231, 0 },
      { 0, 198, 62, 0 },
      { 115, 130, 16, 1 },
      { 62, 49, 128, 0 }, },
    { { 132, 47, 8, 0 },
      { 33, 8, 15, 1 },
      { 8, 122, 16, 1 },
      { 248, 8, 66, 0 }, },
    { { 132, 47, 11, 1 },
      { 41, 74, 15, 1 },
      { 232, 122, 16, 1 },
      { 248, 41, 74, 0 }, },
    { { 132, 47, 4, 1 },
      { 41, 8, 31, 0 },
      { 144, 122, 16, 1 },
      { 124, 8, 74, 0 }, },
    { { 132, 47, 7, 0 },
      { 33, 74, 31, 0 },
      { 112, 122, 16, 1 },
      { 124, 41, 66, 0 }, },
    { { 132, 47, 120, 0 },
      { 49, 140, 15, 1 },
      { 15, 122, 16, 1 },
      { 248, 24, 198, 0 }, },
    { { 132, 47, 123, 1 },
      { 57, 206, 15, 1 },
      { 239, 122, 16, 1 },
      { 248, 57, 206, 0 }, },
    { { 132, 47, 116, 1 },
      { 57, 140, 31, 0 },
      { 151, 122, 16, 1 },
      { 124, 24, 206, 0 }, },
    { { 132, 47, 119, 0 },
      { 49, 206, 31, 0 },
      { 119, 122, 16, 1 },
      { 124, 57, 198, 0 }, },
    { { 132, 46, 152, 0 },
      { 49, 8, 46, 1 },
      { 12, 186, 16, 1 },
      { 186, 8, 70, 0 }, },
    { { 132, 46, 155, 1 },
      { 57, 74, 46, 1 },
      { 236, 186, 16, 1 },
      { 186, 41, 78, 0 }, },
    { { 132, 46, 148, 1 },
      { 57, 8, 62, 0 },
      { 148, 186, 16, 1 },
      { 62, 8, 78, 0 }, },
    { { 132, 46, 151, 0 },
      { 49, 74, 62, 0 },
      { 116, 186, 16, 1 },
      { 62, 41, 70, 0 }, },
    { { 132, 46, 232, 0 },
      { 33, 140, 46, 1 },
      { 11, 186, 16, 1 },
      { 186, 24, 194, 0 }, },
    { { 132, 46, 235, 1 },
      { 41, 206, 46, 1 },
      { 235, 186, 16, 1 },
      { 186, 57, 202, 0 }, },
    { { 132, 46, 228, 1 },
      { 41, 140, 62, 0 },
      { 147, 186, 16, 1 },
      { 62, 24, 202, 0 }, },
    { { 132, 46, 231, 0 },
      { 33, 206, 62, 0 },
      { 115, 186, 16, 1 },
      { 62, 57, 194, 0 }, },
    { { 132, 19, 8, 0 },
      { 32, 0, 77, 1 },
      { 8, 100, 16, 1 },
      { 217, 0, 2, 0 }, },
    { { 132, 19, 11, 1 },
      { 40, 66, 77, 1 },
      { 232, 100, 16, 1 },
      { 217, 33, 10, 0 }, },
    { { 132, 19, 4, 1 },
      { 40, 0, 93, 0 },
      { 144, 100, 16, 1 },
      { 93, 0, 10, 0 }, },
    { { 132, 19, 7, 0 },
      { 32, 66, 93, 0 },
      { 112, 100, 16, 1 },
      { 93, 33, 2, 0 }, },
    { { 132, 19, 120, 0 },
      { 48, 132, 77, 1 },
      { 15, 100, 16, 1 },
      { 217, 16, 134, 0 }, },
    { { 132, 19, 123, 1 },
      { 56, 198, 77, 1 },
      { 239, 100, 16, 1 },
      { 217, 49, 142, 0 }, },
    { { 132, 19, 116, 1 },
      { 56, 132, 93, 0 },
      { 151, 100, 16, 1 },
      { 93, 16, 142, 0 }, },
    { { 132, 19, 119, 0 },
      { 48, 198, 93, 0 },
      { 119, 100, 16, 1 },
      { 93, 49, 134, 0 }, },
    { { 132, 18, 152, 0 },
      { 48, 0, 108, 1 },
      { 12, 164, 16, 1 },
      { 155, 0, 6, 0 }, },
    { { 132, 18, 155, 1 },
      { 56, 66, 108, 1 },
      { 236, 164, 16, 1 },
      { 155, 33, 14, 0 }, },
    { { 132, 18, 148, 1 },
      { 56, 0, 124, 0 },
      { 148, 164, 16, 1 },
      { 31, 0, 14, 0 }, },
    { { 132, 18, 151, 0 },
      { 48, 66, 124, 0 },
      { 116, 164, 16, 1 },
      { 31, 33, 6, 0 }, },
    { { 132, 18, 232, 0 },
      { 32, 132, 108, 1 },
      { 11, 164, 16, 1 },
      { 155, 16, 130, 0 }, },
    { { 132, 18, 235, 1 },
      { 40, 198, 108, 1 },
      { 235, 164, 16, 1 },
      { 155, 49, 138, 0 }, },
    { { 132, 18, 228, 1 },
      { 40, 132, 124, 0 },
      { 147, 164, 16, 1 },
      { 31, 16, 138, 0 }, },
    { { 132, 18, 231, 0 },
      { 32, 198, 124, 0 },
      { 115, 164, 16, 1 },
      { 31, 49, 130, 0 }, },
    { { 132, 29, 8, 0 },
      { 1, 8, 77, 1 },
      { 8, 92, 16, 1 },
      { 217, 8, 64, 0 }, },
    { { 132, 29, 11, 1 },
      { 9, 74, 77, 1 },
      { 232, 92, 16, 1 },
      { 217, 41, 72, 0 }, },
    { { 132, 29, 4, 1 },
      { 9, 8, 93, 0 },
      { 144, 92, 16, 1 },
      { 93, 8, 72, 0 }, },
    { { 132, 29, 7, 0 },
      { 1, 74, 93, 0 },
      { 112, 92, 16, 1 },
      { 93, 41, 64, 0 }, },
    { { 132, 29, 120, 0 },
      { 17, 140, 77, 1 },
      { 15, 92, 16, 1 },
      { 217, 24, 196, 0 }, },
    { { 132, 29, 123, 1 },
      { 25, 206, 77, 1 },
      { 239, 92, 16, 1 },
      { 217, 57, 204, 0 }, },
    { { 132, 29, 116, 1 },
      { 25, 140, 93, 0 },
      { 151, 92, 16, 1 },
      { 93, 24, 204, 0 }, },
    { { 132, 29, 119, 0 },
      { 17, 206, 93, 0 },
      { 119, 92, 16, 1 },
      { 93, 57, 196, 0 }, },
    { { 132, 28, 152, 0 },
      { 17, 8, 108, 1 },
      { 12, 156, 16, 1 },
      { 155, 8, 68, 0 }, },
    { { 132, 28, 155, 1 },
      { 25, 74, 108, 1 },
      { 236, 156, 16, 1 },
      { 155, 41, 76, 0 }, },
    { { 132, 28, 148, 1 },
      { 25, 8, 124, 0 },
      { 148, 156, 16, 1 },
      { 31, 8, 76, 0 }, },
    { { 132, 28, 151, 0 },
      { 17, 74, 124, 0 },
      { 116, 156, 16, 1 },
      { 31, 41, 68, 0 }, },
    { { 132, 28, 232, 0 },
      { 1, 140, 108, 1 },
      { 11, 156, 16, 1 },
      { 155, 24, 192, 0 }, },
    { { 132, 28, 235, 1 },
      { 9, 206, 108, 1 },
      { 235, 156, 16, 1 },
      { 155, 57, 200, 0 }, },
    { { 132, 28, 228, 1 },
      { 9, 140, 124, 0 },
      { 147, 156, 16, 1 },
      { 31, 24, 200, 0 }, },
    { { 132, 28, 231, 0 },
      { 1, 206, 124, 0 },
      { 115, 156, 16, 1 },
      { 31, 57, 192, 0 }, },
    { { 133, 225, 8, 0 },
      { 66, 16, 15, 1 },
      { 8, 67, 208, 1 },
      { 248, 4, 33, 0 }, },
    { { 133, 225, 11, 1 },
      { 74, 82, 15, 1 },
      { 232, 67, 208, 1 },
      { 248, 37, 41, 0 }, },
    { { 133, 225, 4, 1 },
      { 74, 16, 31, 0 },
      { 144, 67, 208, 1 },
      { 124, 4, 41, 0 }, },
    { { 133, 225, 7, 0 },
      { 66, 82, 31, 0 },
      { 112, 67, 208, 1 },
      { 124, 37, 33, 0 }, },
    { { 133, 225, 120, 0 },
      { 82, 148, 15, 1 },
      { 15, 67, 208, 1 },
      { 248, 20, 165, 0 }, },
    { { 133, 225, 123, 1 },
      { 90, 214, 15, 1 },
      { 239, 67, 208, 1 },
      { 248, 53, 173, 0 }, },
    { { 133, 225, 116, 1 },
      { 90, 148, 31, 0 },
      { 151, 67, 208, 1 },
      { 124, 20, 173, 0 }, },
    { { 133, 225, 119, 0 },
      { 82, 214, 31, 0 },
      { 119, 67, 208, 1 },
      { 124, 53, 165, 0 }, },
    { { 133, 224, 152, 0 },
      { 82, 16, 46, 1 },
      { 12, 131, 208, 1 },
      { 186, 4, 37, 0 }, },
    { { 133, 224, 155, 1 },
      { 90, 82, 46, 1 },
      { 236, 131, 208, 1 },
      { 186, 37, 45, 0 }, },
    { { 133, 224, 148, 1 },
      { 90, 16, 62, 0 },
      { 148, 131, 208, 1 },
      { 62, 4, 45, 0 }, },
    { { 133, 224, 151, 0 },
      { 82, 82, 62, 0 },
      { 116, 131, 208, 1 },
      { 62, 37, 37, 0 }, },
    { { 133, 224, 232, 0 },
      { 66, 148, 46, 1 },
      { 11, 131, 208, 1 },
      { 186, 20, 161, 0 }, },
    { { 133, 224, 235, 1 },
      { 74, 214, 46, 1 },
      { 235, 131, 208, 1 },
      { 186, 53, 169, 0 }, },
    { { 133, 224, 228, 1 },
      { 74, 148, 62, 0 },
      { 147, 131, 208, 1 },
      { 62, 20, 169, 0 }, },
    { { 133, 224, 231, 0 },
      { 66, 214, 62, 0 },
      { 115, 131, 208, 1 },
      { 62, 53, 161, 0 }, },
    { { 133, 239, 8, 0 },
      { 99, 24, 15, 1 },
      { 8, 123, 208, 1 },
      { 248, 12, 99, 0 }, },
    { { 133, 239, 11, 1 },
      { 107, 90, 15, 1 },
      { 232, 123, 208, 1 },
      { 248, 45, 107, 0 }, },
    { { 133, 239, 4, 1 },
      { 107, 24, 31, 0 },
      { 144, 123, 208, 1 },
      { 124, 12, 107, 0 }, },
    { { 133, 239, 7, 0 },
      { 99, 90, 31, 0 },
      { 112, 123, 208, 1 },
      { 124, 45, 99, 0 }, },
    { { 133, 239, 120, 0 },
      { 115, 156, 15, 1 },
      { 15, 123, 208, 1 },
      { 248, 28, 231, 0 }, },
    { { 133, 239, 123, 1 },
      { 123, 222, 15, 1 },
      { 239, 123, 208, 1 },
      { 248, 61, 239, 0 }, },
    { { 133, 239, 116, 1 },
      { 123, 156, 31, 0 },
      { 151, 123, 208, 1 },
      { 124, 28, 239, 0 }, },
    { { 133, 239, 119, 0 },
      { 115, 222, 31, 0 },
      { 119, 123, 208, 1 },
      { 124, 61, 231, 0 }, },
    { { 133, 238, 152, 0 },
      { 115, 24, 46, 1 },
      { 12, 187, 208, 1 },
      { 186, 12, 103, 0 }, },
    { { 133, 238, 155, 1 },
      { 123, 90, 46, 1 },
      { 236, 187, 208, 1 },
      { 186, 45, 111, 0 }, },
    { { 133, 238, 148, 1 },
      { 123, 24, 62, 0 },
      { 148, 187, 208, 1 },
      { 62, 12, 111, 0 }, },
    { { 133, 238, 151, 0 },
      { 115, 90, 62, 0 },
      { 116, 187, 208, 1 },
      { 62, 45, 103, 0 }, },
    { { 133, 238, 232, 0 },
      { 99, 156, 46, 1 },
      { 11, 187, 208, 1 },
      { 186, 28, 227, 0 }, },
    { { 133, 238, 235, 1 },
      { 107, 222, 46, 1 },
      { 235, 187, 208, 1 },
      { 186, 61, 235, 0 }, },
    { { 133, 238, 228, 1 },
      { 107, 156, 62, 0 },
      { 147, 187, 208, 1 },
      { 62, 28, 235, 0 }, },
    { { 133, 238, 231, 0 },
      { 99, 222, 62, 0 },
      { 115, 187, 208, 1 },
      { 62, 61, 227, 0 }, },
    { { 133, 211, 8, 0 },
      { 98, 16, 77, 1 },
      { 8, 101, 208, 1 },
      { 217, 4, 35, 0 }, },
    { { 133, 211, 11, 1 },
      { 106, 82, 77, 1 },
      { 232, 101, 208, 1 },
      { 217, 37, 43, 0 }, },
    { { 133, 211, 4, 1 },
      { 106, 16, 93, 0 },
      { 144, 101, 208, 1 },
      { 93, 4, 43, 0 }, },
    { { 133, 211, 7, 0 },
      { 98, 82, 93, 0 },
      { 112, 101, 208, 1 },
      { 93, 37, 35, 0 }, },
    { { 133, 211, 120, 0 },
      { 114, 148, 77, 1 },
      { 15, 101, 208, 1 },
      { 217, 20, 167, 0 }, },
    { { 133, 211, 123, 1 },
      { 122, 214, 77, 1 },
      { 239, 101, 208, 1 },
      { 217, 53, 175, 0 }, },
    { { 133, 211, 116, 1 },
      { 122, 148, 93, 0 },
      { 151, 101, 208, 1 },
      { 93, 20, 175, 0 }, },
    { { 133, 211, 119, 0 },
      { 114, 214, 93, 0 },
      { 119, 101, 208, 1 },
      { 93, 53, 167, 0 }, },
    { { 133, 210, 152, 0 },
      { 114, 16, 108, 1 },
      { 12, 165, 208, 1 },
      { 155, 4, 39, 0 }, },
    { { 133, 210, 155, 1 },
      { 122, 82, 108, 1 },
      { 236, 165, 208, 1 },
      { 155, 37, 47, 0 }, },
    { { 133, 210, 148, 1 },
      { 122, 16, 124, 0 },
      { 148, 165, 208, 1 },
      { 31, 4, 47, 0 }, },
    { { 133, 210, 151, 0 },
      { 114, 82, 124, 0 },
      { 116, 165, 208, 1 },
      { 31, 37, 39, 0 }, },
    { { 133, 210, 232, 0 },
      { 98, 148, 108, 1 },
      { 11, 165, 208, 1 },
      { 155, 20, 163, 0 }, },
    { { 133, 210, 235, 1 },
      { 106, 214, 108, 1 },
      { 235, 165, 208, 1 },
      { 155, 53, 171, 0 }, },
    { { 133, 210, 228, 1 },
      { 106, 148, 124, 0 },
      { 147, 165, 208, 1 },
      { 31, 20, 171, 0 }, },
    { { 133, 210, 231, 0 },
      { 98, 214, 124, 0 },
      { 115, 165, 208, 1 },
      { 31, 53, 163, 0 }, },
    { { 133, 221, 8, 0 },
      { 67, 24, 77, 1 },
      { 8, 93, 208, 1 },
      { 217, 12, 97, 0 }, },
    { { 133, 221, 11, 1 },
      { 75, 90, 77, 1 },
      { 232, 93, 208, 1 },
      { 217, 45, 105, 0 }, },
    { { 133, 221, 4, 1 },
      { 75, 24, 93, 0 },
      { 144, 93, 208, 1 },
      { 93, 12, 105, 0 }, },
    { { 133, 221, 7, 0 },
      { 67, 90, 93, 0 },
      { 112, 93, 208, 1 },
      { 93, 45, 97, 0 }, },
    { { 133, 221, 120, 0 },
      { 83, 156, 77, 1 },
      { 15, 93, 208, 1 },
      { 217, 28, 229, 0 }, },
    { { 133, 221, 123, 1 },
      { 91, 222, 77, 1 },
      { 239, 93, 208, 1 },
      { 217, 61, 237, 0 }, },
    { { 133, 221, 116, 1 },
      { 91, 156, 93, 0 },
      { 151, 93, 208, 1 },
      { 93, 28, 237, 0 }, },
    { { 133, 221, 119, 0 },
      { 83, 222, 93, 0 },
      { 119, 93, 208, 1 },
      { 93, 61, 229, 0 }, },
    { { 133, 220, 152, 0 },
      { 83, 24, 108, 1 },
      { 12, 157, 208, 1 },
      { 155, 12, 101, 0 }, },
    { { 133, 220, 155, 1 },
      { 91, 90, 108, 1 },
      { 236, 157, 208, 1 },
      { 155, 45, 109, 0 }, },
    { { 133, 220, 148, 1 },
      { 91, 24, 124, 0 },
      { 148, 157, 208, 1 },
      { 31, 12, 109, 0 }, },
    { { 133, 220, 151, 0 },
      { 83, 90, 124, 0 },
      { 116, 157, 208, 1 },
      { 31, 45, 101, 0 }, },
    { { 133, 220, 232, 0 },
      { 67, 156, 108, 1 },
      { 11, 157, 208, 1 },
      { 155, 28, 225, 0 }, },
    { { 133, 220, 235, 1 },
      { 75, 222, 108, 1 },
      { 235, 157, 208, 1 },
      { 155, 61, 233, 0 }, },
    { { 133, 220, 228, 1 },
      { 75, 156, 124, 0 },
      { 147, 157, 208, 1 },
      { 31, 28, 233, 0 }, },
    { { 133, 220, 231, 0 },
      { 67, 222, 124, 0 },
      { 115, 157, 208, 1 },
      { 31, 61, 225, 0 }, },
    { { 130, 97, 8, 0 },
      { 64, 0, 139, 1 },
      { 8, 67, 32, 1 },
      { 232, 128, 1, 0 }, },
    { { 130, 97, 11, 1 },
      { 72, 66, 139, 1 },
      { 232, 67, 32, 1 },
      { 232, 161, 9, 0 }, },
    { { 130, 97, 4, 1 },
      { 72, 0, 155, 0 },
      { 144, 67, 32, 1 },
      { 108, 128, 9, 0 }, },
    { { 130, 97, 7, 0 },
      { 64, 66, 155, 0 },
      { 112, 67, 32, 1 },
      { 108, 161, 1, 0 }, },
    { { 130, 97, 120, 0 },
      { 80, 132, 139, 1 },
      { 15, 67, 32, 1 },
      { 232, 144, 133, 0 }, },
    { { 130, 97, 123, 1 },
      { 88, 198, 139, 1 },
      { 239, 67, 32, 1 },
      { 232, 177, 141, 0 }, },
    { { 130, 97, 116, 1 },
      { 88, 132, 155, 0 },
      { 151, 67, 32, 1 },
      { 108, 144, 141, 0 }, },
    { { 130, 97, 119, 0 },
      { 80, 198, 155, 0 },
      { 119, 67, 32, 1 },
      { 108, 177, 133, 0 }, },
    { { 130, 96, 152, 0 },
      { 80, 0, 170, 1 },
      { 12, 131, 32, 1 },
      { 170, 128, 5, 0 }, },
    { { 130, 96, 155, 1 },
      { 88, 66, 170, 1 },
      { 236, 131, 32, 1 },
      { 170, 161, 13, 0 }, },
    { { 130, 96, 148, 1 },
      { 88, 0, 186, 0 },
      { 148, 131, 32, 1 },
      { 46, 128, 13, 0 }, },
    { { 130, 96, 151, 0 },
      { 80, 66, 186, 0 },
      { 116, 131, 32, 1 },
      { 46, 161, 5, 0 }, },
    { { 130, 96, 232, 0 },
      { 64, 132, 170, 1 },
      { 11, 131, 32, 1 },
      { 170, 144, 129, 0 }, },
    { { 130, 96, 235, 1 },
      { 72, 198, 170, 1 },
      { 235, 131, 32, 1 },
      { 170, 177, 137, 0 }, },
    { { 130, 96, 228, 1 },
      { 72, 132, 186, 0 },
      { 147, 131, 32, 1 },
      { 46, 144, 137, 0 }, },
    { { 130, 96, 231, 0 },
      { 64, 198, 186, 0 },
      { 115, 131, 32, 1 },
      { 46, 177, 129, 0 }, },
    { { 130, 111, 8, 0 },
      { 97, 8, 139, 1 },
      { 8, 123, 32, 1 },
      { 232, 136, 67, 0 }, },
    { { 130, 111, 11, 1 },
      { 105, 74, 139, 1 },
      { 232, 123, 32, 1 },
      { 232, 169, 75, 0 }, },
    { { 130, 111, 4, 1 },
      { 105, 8, 155, 0 },
      { 144, 123, 32, 1 },
      { 108, 136, 75, 0 }, },
    { { 130, 111, 7, 0 },
      { 97, 74, 155, 0 },
      { 112, 123, 32, 1 },
      { 108, 169, 67, 0 }, },
    { { 130, 111, 120, 0 },
      { 113, 140, 139, 1 },
      { 15, 123, 32, 1 },
      { 232, 152, 199, 0 }, },
    { { 130, 111, 123, 1 },
      { 121, 206, 139, 1 },
      { 239, 123, 32, 1 },
      { 232, 185, 207, 0 }, },
    { { 130, 111, 116, 1 },
      { 121, 140, 155, 0 },
      { 151, 123, 32, 1 },
      { 108, 152, 207, 0 }, },
    { { 130, 111, 119, 0 },
      { 113, 206, 155, 0 },
      { 119, 123, 32, 1 },
      { 108, 185, 199, 0 }, },
    { { 130, 110, 152, 0 },
      { 113, 8, 170, 1 },
      { 12, 187, 32, 1 },
      { 170, 136, 71, 0 }, },
    { { 130, 110, 155, 1 },
      { 121, 74, 170, 1 },
      { 236, 187, 32, 1 },
      { 170, 169, 79, 0 }, },
    { { 130, 110, 148, 1 },
      { 121, 8, 186, 0 },
      { 148, 187, 32, 1 },
      { 46, 136, 79, 0 }, },
    { { 130, 110, 151, 0 },
      { 113, 74, 186, 0 },
      { 116, 187, 32, 1 },
      { 46, 169, 71, 0 }, },
    { { 130, 110, 232, 0 },
      { 97, 140, 170, 1 },
      { 11, 187, 32, 1 },
      { 170, 152, 195, 0 }, },
    { { 130, 110, 235, 1 },
      { 105, 206, 170, 1 },
      { 235, 187, 32, 1 },
      { 170, 185, 203, 0 }, },
    { { 130, 110, 228, 1 },
      { 105, 140, 186, 0 },
      { 147, 187, 32, 1 },
      { 46, 152, 203, 0 }, },
    { { 130, 110, 231, 0 },
      { 97, 206, 186, 0 },
      { 115, 187, 32, 1 },
      { 46, 185, 195, 0 }, },
    { { 130, 83, 8, 0 },
      { 96, 0, 201, 1 },
      { 8, 101, 32, 1 },
      { 201, 128, 3, 0 }, },
    { { 130, 83, 11, 1 },
      { 104, 66, 201, 1 },
      { 232, 101, 32, 1 },
      { 201, 161, 11, 0 }, },
    { { 130, 83, 4, 1 },
      { 104, 0, 217, 0 },
      { 144, 101, 32, 1 },
      { 77, 128, 11, 0 }, },
    { { 130, 83, 7, 0 },
      { 96, 66, 217, 0 },
      { 112, 101, 32, 1 },
      { 77, 161, 3, 0 }, },
    { { 130, 83, 120, 0 },
      { 112, 132, 201, 1 },
      { 15, 101, 32, 1 },
      { 201, 144, 135, 0 }, },
    { { 130, 83, 123, 1 },
      { 120, 198, 201, 1 },
      { 239, 101, 32, 1 },
      { 201, 177, 143, 0 }, },
    { { 130, 83, 116, 1 },
      { 120, 132, 217, 0 },
      { 151, 101, 32, 1 },
      { 77, 144, 143, 0 }, },
    { { 130, 83, 119, 0 },
      { 112, 198, 217, 0 },
      { 119, 101, 32, 1 },
      { 77, 177, 135, 0 }, },
    { { 130, 82, 152, 0 },
      { 112, 0, 232, 1 },
      { 12, 165, 32, 1 },
      { 139, 128, 7, 0 }, },
    { { 130, 82, 155, 1 },
      { 120, 66, 232, 1 },
      { 236, 165, 32, 1 },
      { 139, 161, 15, 0 }, },
    { { 130, 82, 148, 1 },
      { 120, 0, 248, 0 },
      { 148, 165, 32, 1 },
      { 15, 128, 15, 0 }, },
    { { 130, 82, 151, 0 },
      { 112, 66, 248, 0 },
      { 116, 165, 32, 1 },
      { 15, 161, 7, 0 }, },
    { { 130, 82, 232, 0 },
      { 96, 132, 232, 1 },
      { 11, 165, 32, 1 },
      { 139, 144, 131, 0 }, },
    { { 130, 82, 235, 1 },
      { 104, 198, 232, 1 },
      { 235, 165, 32, 1 },
      { 139, 177, 139, 0 }, },
    { { 130, 82, 228, 1 },
      { 104, 132, 248, 0 },
      { 147, 165, 32, 1 },
      { 15, 144, 139, 0 }, },
    { { 130, 82, 231, 0 },
      { 96, 198, 248, 0 },
      { 115, 165, 32, 1 },
      { 15, 177, 131, 0 }, },
    { { 130, 93, 8, 0 },
      { 65, 8, 201, 1 },
      { 8, 93, 32, 1 },
      { 201, 136, 65, 0 }, },
    { { 130, 93, 11, 1 },
      { 73, 74, 201, 1 },
      { 232, 93, 32, 1 },
      { 201, 169, 73, 0 }, },
    { { 130, 93, 4, 1 },
      { 73, 8, 217, 0 },
      { 144, 93, 32, 1 },
      { 77, 136, 73, 0 }, },
    { { 130, 93, 7, 0 },
      { 65, 74, 217, 0 },
      { 112, 93, 32, 1 },
      { 77, 169, 65, 0 }, },
    { { 130, 93, 120, 0 },
      { 81, 140, 201, 1 },
      { 15, 93, 32, 1 },
      { 201, 152, 197, 0 }, },
    { { 130, 93, 123, 1 },
      { 89, 206, 201, 1 },
      { 239, 93, 32, 1 },
      { 201, 185, 205, 0 }, },
    { { 130, 93, 116, 1 },
      { 89, 140, 217, 0 },
      { 151, 93, 32, 1 },
      { 77, 152, 205, 0 }, },
    { { 130, 93, 119, 0 },
      { 81, 206, 217, 0 },
      { 119, 93, 32, 1 },
      { 77, 185, 197, 0 }, },
    { { 130, 92, 152, 0 },
      { 81, 8, 232, 1 },
      { 12, 157, 32, 1 },
      { 139, 136, 69, 0 }, },
    { { 130, 92, 155, 1 },
      { 89, 74, 232, 1 },
      { 236, 157, 32, 1 },
      { 139, 169, 77, 0 }, },
    { { 130, 92, 148, 1 },
      { 89, 8, 248, 0 },
      { 148, 157, 32, 1 },
      { 15, 136, 77, 0 }, },
    { { 130, 92, 151, 0 },
      { 81, 74, 248, 0 },
      { 116, 157, 32, 1 },
      { 15, 169, 69, 0 }, },
    { { 130, 92, 232, 0 },
      { 65, 140, 232, 1 },
      { 11, 157, 32, 1 },
      { 139, 152, 193, 0 }, },
    { { 130, 92, 235, 1 },
      { 73, 206, 232, 1 },
      { 235, 157, 32, 1 },
      { 139, 185, 201, 0 }, },
    { { 130, 92, 228, 1 },
      { 73, 140, 248, 0 },
      { 147, 157, 32, 1 },
      { 15, 152, 201, 0 }, },
    { { 130, 92, 231, 0 },
      { 65, 206, 248, 0 },
      { 115, 157, 32, 1 },
      { 15, 185, 193, 0 }, },
    { { 131, 161, 8, 0 },
      { 2, 16, 139, 1 },
      { 8, 66, 224, 1 },
      { 232, 132, 32, 0 }, },
    { { 131, 161, 11, 1 },
      { 10, 82, 139, 1 },
      { 232, 66, 224, 1 },
      { 232, 165, 40, 0 }, },
    { { 131, 161, 4, 1 },
      { 10, 16, 155, 0 },
      { 144, 66, 224, 1 },
      { 108, 132, 40, 0 }, },
    { { 131, 161, 7, 0 },
      { 2, 82, 155, 0 },
      { 112, 66, 224, 1 },
      { 108, 165, 32, 0 }, },
    { { 131, 161, 120, 0 },
      { 18, 148, 139, 1 },
      { 15, 66, 224, 1 },
      { 232, 148, 164, 0 }, },
    { { 131, 161, 123, 1 },
      { 26, 214, 139, 1 },
      { 239, 66, 224, 1 },
      { 232, 181, 172, 0 }, },
    { { 131, 161, 116, 1 },
      { 26, 148, 155, 0 },
      { 151, 66, 224, 1 },
      { 108, 148, 172, 0 }, },
    { { 131, 161, 119, 0 },
      { 18, 214, 155, 0 },
      { 119, 66, 224, 1 },
      { 108, 181, 164, 0 }, },
    { { 131, 160, 152, 0 },
      { 18, 16, 170, 1 },
      { 12, 130, 224, 1 },
      { 170, 132, 36, 0 }, },
    { { 131, 160, 155, 1 },
      { 26, 82, 170, 1 },
      { 236, 130, 224, 1 },
      { 170, 165, 44, 0 }, },
    { { 131, 160, 148, 1 },
      { 26, 16, 186, 0 },
      { 148, 130, 224, 1 },
      { 46, 132, 44, 0 }, },
    { { 131, 160, 151, 0 },
      { 18, 82, 186, 0 },
      { 116, 130, 224, 1 },
      { 46, 165, 36, 0 }, },
    { { 131, 160, 232, 0 },
      { 2, 148, 170, 1 },
      { 11, 130, 224, 1 },
      { 170, 148, 160, 0 }, },
    { { 131, 160, 235, 1 },
      { 10, 214, 170, 1 },
      { 235, 130, 224, 1 },
      { 170, 181, 168, 0 }, },
    { { 131, 160, 228, 1 },
      { 10, 148, 186, 0 },
      { 147, 130, 224, 1 },
      { 46, 148, 168, 0 }, },
    { { 131, 160, 231, 0 },
      { 2, 214, 186, 0 },
      { 115, 130, 224, 1 },
      { 46, 181, 160, 0 }, },
    { { 131, 175, 8, 0 },
      { 35, 24, 139, 1 },
      { 8, 122, 224, 1 },
      { 232, 140, 98, 0 }, },
    { { 131, 175, 11, 1 },
      { 43, 90, 139, 1 },
      { 232, 122, 224, 1 },
      { 232, 173, 106, 0 }, },
    { { 131, 175, 4, 1 },
      { 43, 24, 155, 0 },
      { 144, 122, 224, 1 },
      { 108, 140, 106, 0 }, },
    { { 131, 175, 7, 0 },
      { 35, 90, 155, 0 },
      { 112, 122, 224, 1 },
      { 108, 173, 98, 0 }, },
    { { 131, 175, 120, 0 },
      { 51, 156, 139, 1 },
      { 15, 122, 224, 1 },
      { 232, 156, 230, 0 }, },
    { { 131, 175, 123, 1 },
      { 59, 222, 139, 1 },
      { 239, 122, 224, 1 },
      { 232, 189, 238, 0 }, },
    { { 131, 175, 116, 1 },
      { 59, 156, 155, 0 },
      { 151, 122, 224, 1 },
      { 108, 156, 238, 0 }, },
    { { 131, 175, 119, 0 },
      { 51, 222, 155, 0 },
      { 119, 122, 224, 1 },
      { 108, 189, 230, 0 }, },
    { { 131, 174, 152, 0 },
      { 51, 24, 170, 1 },
      { 12, 186, 224, 1 },
      { 170, 140, 102, 0 }, },
    { { 131, 174, 155, 1 },
      { 59, 90, 170, 1 },
      { 236, 186, 224, 1 },
      { 170, 173, 110, 0 }, },
    { { 131, 174, 148, 1 },
      { 59, 24, 186, 0 },
      { 148, 186, 224, 1 },
      { 46, 140, 110, 0 }, },
    { { 131, 174, 151, 0 },
      { 51, 90, 186, 0 },
      { 116, 186, 224, 1 },
      { 46, 173, 102, 0 }, },
    { { 131, 174, 232, 0 },
      { 35, 156, 170, 1 },
      { 11, 186, 224, 1 },
      { 170, 156, 226, 0 }, },
    { { 131, 174, 235, 1 },
      { 43, 222, 170, 1 },
      { 235, 186, 224, 1 },
      { 170, 189, 234, 0 }, },
    { { 131, 174, 228, 1 },
      { 43, 156, 186, 0 },
      { 147, 186, 224, 1 },
      { 46, 156, 234, 0 }, },
    { { 131, 174, 231, 0 },
      { 35, 222, 186, 0 },
      { 115, 186, 224, 1 },
      { 46, 189, 226, 0 }, },
    { { 131, 147, 8, 0 },
      { 34, 16, 201, 1 },
      { 8, 100, 224, 1 },
      { 201, 132, 34, 0 }, },
    { { 131, 147, 11, 1 },
      { 42, 82, 201, 1 },
      { 232, 100, 224, 1 },
      { 201, 165, 42, 0 }, },
    { { 131, 147, 4, 1 },
      { 42, 16, 217, 0 },
      { 144, 100, 224, 1 },
      { 77, 132, 42, 0 }, },
    { { 131, 147, 7, 0 },
      { 34, 82, 217, 0 },
      { 112, 100, 224, 1 },
      { 77, 165, 34, 0 }, },
    { { 131, 147, 120, 0 },
      { 50, 148, 201, 1 },
      { 15, 100, 224, 1 },
      { 201, 148, 166, 0 }, },
    { { 131, 147, 123, 1 },
      { 58, 214, 201, 1 },
      { 239, 100, 224, 1 },
      { 201, 181, 174, 0 }, },
    { { 131, 147, 116, 1 },
      { 58, 148, 217, 0 },
      { 151, 100, 224, 1 },
      { 77, 148, 174, 0 }, },
    { { 131, 147, 119, 0 },
      { 50, 214, 217, 0 },
      { 119, 100, 224, 1 },
      { 77, 181, 166, 0 }, },
    { { 131, 146, 152, 0 },
      { 50, 16, 232, 1 },
      { 12, 164, 224, 1 },
      { 139, 132, 38, 0 }, },
    { { 131, 146, 155, 1 },
      { 58, 82, 232, 1 },
      { 236, 164, 224, 1 },
      { 139, 165, 46, 0 }, },
    { { 131, 146, 148, 1 },
      { 58, 16, 248, 0 },
      { 148, 164, 224, 1 },
      { 15, 132, 46, 0 }, },
    { { 131, 146, 151, 0 },
      { 50, 82, 248, 0 },
      { 116, 164, 224, 1 },
      { 15, 165, 38, 0 }, },
    { { 131, 146, 232, 0 },
      { 34, 148, 232, 1 },
      { 11, 164, 224, 1 },
      { 139, 148, 162, 0 }, },
    { { 131, 146, 235, 1 },
      { 42, 214, 232, 1 },
      { 235, 164, 224, 1 },
      { 139, 181, 170, 0 }, },
    { { 131, 146, 228, 1 },
      { 42, 148, 248, 0 },
      { 147, 164, 224, 1 },
      { 15, 148, 170, 0 }, },
    { { 131, 146, 231, 0 },
      { 34, 214, 248, 0 },
      { 115, 164, 224, 1 },
      { 15, 181, 162, 0 }, },
    { { 131, 157, 8, 0 },
      { 3, 24, 201, 1 },
      { 8, 92, 224, 1 },
      { 201, 140, 96, 0 }, },
    { { 131, 157, 11, 1 },
      { 11, 90, 201, 1 },
      { 232, 92, 224, 1 },
      { 201, 173, 104, 0 }, },
    { { 131, 157, 4, 1 },
      { 11, 24, 217, 0 },
      { 144, 92, 224, 1 },
      { 77, 140, 104, 0 }, },
    { { 131, 157, 7, 0 },
      { 3, 90, 217, 0 },
      { 112, 92, 224, 1 },
      { 77, 173, 96, 0 }, },
    { { 131, 157, 120, 0 },
      { 19, 156, 201, 1 },
      { 15, 92, 224, 1 },
      { 201, 156, 228, 0 }, },
    { { 131, 157, 123, 1 },
      { 27, 222, 201, 1 },
      { 239, 92, 224, 1 },
      { 201, 189, 236, 0 }, },
    { { 131, 157, 116, 1 },
      { 27, 156, 217, 0 },
      { 151, 92, 224, 1 },
      { 77, 156, 236, 0 }, },
    { { 131, 157, 119, 0 },
      { 19, 222, 217, 0 },
      { 119, 92, 224, 1 },
      { 77, 189, 228, 0 }, },
    { { 131, 156, 152, 0 },
      { 19, 24, 232, 1 },
      { 12, 156, 224, 1 },
      { 139, 140, 100, 0 }, },
    { { 131, 156, 155, 1 },
      { 27, 90, 232, 1 },
      { 236, 156, 224, 1 },
      { 139, 173, 108, 0 }, },
    { { 131, 156, 148, 1 },
      { 27, 24, 248, 0 },
      { 148, 156, 224, 1 },
      { 15, 140, 108, 0 }, },
    { { 131, 156, 151, 0 },
      { 19, 90, 248, 0 },
      { 116, 156, 224, 1 },
      { 15, 173, 100, 0 }, },
    { { 131, 156, 232, 0 },
      { 3, 156, 232, 1 },
      { 11, 156, 224, 1 },
      { 139, 156, 224, 0 }, },
    { { 131, 156, 235, 1 },
      { 11, 222, 232, 1 },
      { 235, 156, 224, 1 },
      { 139, 189, 232, 0 }, },
    { { 131, 156, 228, 1 },
      { 11, 156, 248, 0 },
      { 147, 156, 224, 1 },
      { 15, 156, 232, 0 }, },
    { { 131, 156, 231, 0 },
      { 3, 222, 248, 0 },
      { 115, 156, 224, 1 },
      { 15, 189, 224, 0 }, },
    { { 188, 33, 8, 0 },
      { 132, 32, 15, 1 },
      { 8, 66, 30, 1 },
      { 248, 2, 16, 1 }, },
    { { 188, 33, 11, 1 },
      { 140, 98, 15, 1 },
      { 232, 66, 30, 1 },
      { 248, 35, 24, 1 }, },
    { { 188, 33, 4, 1 },
      { 140, 32, 31, 0 },
      { 144, 66, 30, 1 },
      { 124, 2, 24, 1 }, },
    { { 188, 33, 7, 0 },
      { 132, 98, 31, 0 },
      { 112, 66, 30, 1 },
      { 124, 35, 16, 1 }, },
    { { 188, 33, 120, 0 },
      { 148, 164, 15, 1 },
      { 15, 66, 30, 1 },
      { 248, 18, 148, 1 }, },
    { { 188, 33, 123, 1 },
      { 156, 230, 15, 1 },
      { 239, 66, 30, 1 },
      { 248, 51, 156, 1 }, },
    { { 188, 33, 116, 1 },
      { 156, 164, 31, 0 },
      { 151, 66, 30, 1 },
      { 124, 18, 156, 1 }, },
    { { 188, 33, 119, 0 },
      { 148, 230, 31, 0 },
      { 119, 66, 30, 1 },
      { 124, 51, 148, 1 }, },
    { { 188, 32, 152, 0 },
      { 148, 32, 46, 1 },
      { 12, 130, 30, 1 },
      { 186, 2, 20, 1 }, },
    { { 188, 32, 155, 1 },
      { 156, 98, 46, 1 },
      { 236, 130, 30, 1 },
      { 186, 35, 28, 1 }, },
    { { 188, 32, 148, 1 },
      { 156, 32, 62, 0 },
      { 148, 130, 30, 1 },
      { 62, 2, 28, 1 }, },
    { { 188, 32, 151, 0 },
      { 148, 98, 62, 0 },
      { 116, 130, 30, 1 },
      { 62, 35, 20, 1 }, },
    { { 188, 32, 232, 0 },
      { 132, 164, 46, 1 },
      { 11, 130, 30, 1 },
      { 186, 18, 144, 1 }, },
    { { 188, 32, 235, 1 },
      { 140, 230, 46, 1 },
      { 235, 130, 30, 1 },
      { 186, 51, 152, 1 }, },
    { { 188, 32, 228, 1 },
      { 140, 164, 62, 0 },
      { 147, 130, 30, 1 },
      { 62, 18, 152, 1 }, },
    { { 188, 32, 231, 0 },
      { 132, 230, 62, 0 },
      { 115, 130, 30, 1 },
      { 62, 51, 144, 1 }, },
    { { 188, 47, 8, 0 },
      { 165, 40, 15, 1 },
      { 8, 122, 30, 1 },
      { 248, 10, 82, 1 }, },
    { { 188, 47, 11, 1 },
      { 173, 106, 15, 1 },
      { 232, 122, 30, 1 },
      { 248, 43, 90, 1 }, },
    { { 188, 47, 4, 1 },
      { 173, 40, 31, 0 },
      { 144, 122, 30, 1 },
      { 124, 10, 90, 1 }, },
    { { 188, 47, 7, 0 },
      { 165, 106, 31, 0 },
      { 112, 122, 30, 1 },
      { 124, 43, 82, 1 }, },
    { { 188, 47, 120, 0 },
      { 181, 172, 15, 1 },
      { 15, 122, 30, 1 },
      { 248, 26, 214, 1 }, },
    { { 188, 47, 123, 1 },
      { 189, 238, 15, 1 },
      { 239, 122, 30, 1 },
      { 248, 59, 222, 1 }, },
    { { 188, 47, 116, 1 },
      { 189, 172, 31, 0 },
      { 151, 122, 30, 1 },
      { 124, 26, 222, 1 }, },
    { { 188, 47, 119, 0 },
      { 181, 238, 31, 0 },
      { 119, 122, 30, 1 },
      { 124, 59, 214, 1 }, },
    { { 188, 46, 152, 0 },
      { 181, 40, 46, 1 },
      { 12, 186, 30, 1 },
      { 186, 10, 86, 1 }, },
    { { 188, 46, 155, 1 },
      { 189, 106, 46, 1 },
      { 236, 186, 30, 1 },
      { 186, 43, 94, 1 }, },
    { { 188, 46, 148, 1 },
      { 189, 40, 62, 0 },
      { 148, 186, 30, 1 },
      { 62, 10, 94, 1 }, },
    { { 188, 46, 151, 0 },
      { 181, 106, 62, 0 },
      { 116, 186, 30, 1 },
      { 62, 43, 86, 1 }, },
    { { 188, 46, 232, 0 },
      { 165, 172, 46, 1 },
      { 11, 186, 30, 1 },
      { 186, 26, 210, 1 }, },
    { { 188, 46, 235, 1 },
      { 173, 238, 46, 1 },
      { 235, 186, 30, 1 },
      { 186, 59, 218, 1 }, },
    { { 188, 46, 228, 1 },
      { 173, 172, 62, 0 },
      { 147, 186, 30, 1 },
      { 62, 26, 218, 1 }, },
    { { 188, 46, 231, 0 },
      { 165, 238, 62, 0 },
      { 115, 186, 30, 1 },
      { 62, 59, 210, 1 }, },
    { { 188, 19, 8, 0 },
      { 164, 32, 77, 1 },
      { 8, 100, 30, 1 },
      { 217, 2, 18, 1 }, },
    { { 188, 19, 11, 1 },
      { 172, 98, 77, 1 },
      { 232, 100, 30, 1 },
      { 217, 35, 26, 1 }, },
    { { 188, 19, 4, 1 },
      { 172, 32, 93, 0 },
      { 144, 100, 30, 1 },
      { 93, 2, 26, 1 }, },
    { { 188, 19, 7, 0 },
      { 164, 98, 93, 0 },
      { 112, 100, 30, 1 },
      { 93, 35, 18, 1 }, },
    { { 188, 19, 120, 0 },
      { 180, 164, 77, 1 },
      { 15, 100, 30, 1 },
      { 217, 18, 150, 1 }, },
    { { 188, 19, 123, 1 },
      { 188, 230, 77, 1 },
      { 239, 100, 30, 1 },
      { 217, 51, 158, 1 }, },
    { { 188, 19, 116, 1 },
      { 188, 164, 93, 0 },
      { 151, 100, 30, 1 },
      { 93, 18, 158, 1 }, },
    { { 188, 19, 119, 0 },
      { 180, 230, 93, 0 },
      { 119, 100, 30, 1 },
      { 93, 51, 150, 1 }, },
    { { 188, 18, 152, 0 },
      { 180, 32, 108, 1 },
      { 12, 164, 30, 1 },
      { 155, 2, 22, 1 }, },
    { { 188, 18, 155, 1 },
      { 188, 98, 108, 1 },
      { 236, 164, 30, 1 },
      { 155, 35, 30, 1 }, },
    { { 188, 18, 148, 1 },
      { 188, 32, 124, 0 },
      { 148, 164, 30, 1 },
      { 31, 2, 30, 1 }, },
    { { 188, 18, 151, 0 },
      { 180, 98, 124, 0 },
      { 116, 164, 30, 1 },
      { 31, 35, 22, 1 }, },
    { { 188, 18, 232, 0 },
      { 164, 164, 108, 1 },
      { 11, 164, 30, 1 },
      { 155, 18, 146, 1 }, },
    { { 188, 18, 235, 1 },
      { 172, 230, 108, 1 },
      { 235, 164, 30, 1 },
      { 155, 51, 154, 1 }, },
    { { 188, 18, 228, 1 },
      { 172, 164, 124, 0 },
      { 147, 164, 30, 1 },
      { 31, 18, 154, 1 }, },
    { { 188, 18, 231, 0 },
      { 164, 230, 124, 0 },
      { 115, 164, 30, 1 },
      { 31, 51, 146, 1 }, },
    { { 188, 29, 8, 0 },
      { 133, 40, 77, 1 },
      { 8, 92, 30, 1 },
      { 217, 10, 80, 1 }, },
    { { 188, 29, 11, 1 },
      { 141, 106, 77, 1 },
      { 232, 92, 30, 1 },
      { 217, 43, 88, 1 }, },
    { { 188, 29, 4, 1 },
      { 141, 40, 93, 0 },
      { 144, 92, 30, 1 },
      { 93, 10, 88, 1 }, },
    { { 188, 29, 7, 0 },
      { 133, 106, 93, 0 },
      { 112, 92, 30, 1 },
      { 93, 43, 80, 1 }, },
    { { 188, 29, 120, 0 },
      { 149, 172, 77, 1 },
      { 15, 92, 30, 1 },
      { 217, 26, 212, 1 }, },
    { { 188, 29, 123, 1 },
      { 157, 238, 77, 1 },
      { 239, 92, 30, 1 },
      { 217, 59, 220, 1 }, },
    { { 188, 29, 116, 1 },
      { 157, 172, 93, 0 },
      { 151, 92, 30, 1 },
      { 93, 26, 220, 1 }, },
    { { 188, 29, 119, 0 },
      { 149, 238, 93, 0 },
      { 119, 92, 30, 1 },
      { 93, 59, 212, 1 }, },
    { { 188, 28, 152, 0 },
      { 149, 40, 108, 1 },
      { 12, 156, 30, 1 },
      { 155, 10, 84, 1 }, },
    { { 188, 28, 155, 1 },
      { 157, 106, 108, 1 },
      { 236, 156, 30, 1 },
      { 155, 43, 92, 1 }, },
    { { 188, 28, 148, 1 },
      { 157, 40, 124, 0 },
      { 148, 156, 30, 1 },
      { 31, 10, 92, 1 }, },
    { { 188, 28, 151, 0 },
      { 149, 106, 124, 0 },
      { 116, 156, 30, 1 },
      { 31, 43, 84, 1 }, },
    { { 188, 28, 232, 0 },
      { 133, 172, 108, 1 },
      { 11, 156, 30, 1 },
      { 155, 26, 208, 1 }, },
    { { 188, 28, 235, 1 },
      { 141, 238, 108, 1 },
      { 235, 156, 30, 1 },
      { 155, 59, 216, 1 }, },
    { { 188, 28, 228, 1 },
      { 141, 172, 124, 0 },
      { 147, 156, 30, 1 },
      { 31, 26, 216, 1 }, },
    { { 188, 28, 231, 0 },
      { 133, 238, 124, 0 },
      { 115, 156, 30, 1 },
      { 31, 59, 208, 1 }, },
    { { 189, 225, 8, 0 },
      { 198, 48, 15, 1 },
      { 8, 67, 222, 1 },
      { 248, 6, 49, 1 }, },
    { { 189, 225, 11, 1 },
      { 206, 114, 15, 1 },
      { 232, 67, 222, 1 },
      { 248, 39, 57, 1 }, },
    { { 189, 225, 4, 1 },
      { 206, 48, 31, 0 },
      { 144, 67, 222, 1 },
      { 124, 6, 57, 1 }, },
    { { 189, 225, 7, 0 },
      { 198, 114, 31, 0 },
      { 112, 67, 222, 1 },
      { 124, 39, 49, 1 }, },
    { { 189, 225, 120, 0 },
      { 214, 180, 15, 1 },
      { 15, 67, 222, 1 },
      { 248, 22, 181, 1 }, },
    { { 189, 225, 123, 1 },
      { 222, 246, 15, 1 },
      { 239, 67, 222, 1 },
      { 248, 55, 189, 1 }, },
    { { 189, 225, 116, 1 },
      { 222, 180, 31, 0 },
      { 151, 67, 222, 1 },
      { 124, 22, 189, 1 }, },
    { { 189, 225, 119, 0 },
      { 214, 246, 31, 0 },
      { 119, 67, 222, 1 },
      { 124, 55, 181, 1 }, },
    { { 189, 224, 152, 0 },
      { 214, 48, 46, 1 },
      { 12, 131, 222, 1 },
      { 186, 6, 53, 1 }, },
    { { 189, 224, 155, 1 },
      { 222, 114, 46, 1 },
      { 236, 131, 222, 1 },
      { 186, 39, 61, 1 }, },
    { { 189, 224, 148, 1 },
      { 222, 48, 62, 0 },
      { 148, 131, 222, 1 },
      { 62, 6, 61, 1 }, },
    { { 189, 224, 151, 0 },
      { 214, 114, 62, 0 },
      { 116, 131, 222, 1 },
      { 62, 39, 53, 1 }, },
    { { 189, 224, 232, 0 },
      { 198, 180, 46, 1 },
      { 11, 131, 222, 1 },
      { 186, 22, 177, 1 }, },
    { { 189, 224, 235, 1 },
      { 206, 246, 46, 1 },
      { 235, 131, 222, 1 },
      { 186, 55, 185, 1 }, },
    { { 189, 224, 228, 1 },
      { 206, 180, 62, 0 },
      { 147, 131, 222, 1 },
      { 62, 22, 185, 1 }, },
    { { 189, 224, 231, 0 },
      { 198, 246, 62, 0 },
      { 115, 131, 222, 1 },
      { 62, 55, 177, 1 }, },
    { { 189, 239, 8, 0 },
      { 231, 56, 15, 1 },
      { 8, 123, 222, 1 },
      { 248, 14, 115, 1 }, },
    { { 189, 239, 11, 1 },
      { 239, 122, 15, 1 },
      { 232, 123, 222, 1 },
      { 248, 47, 123, 1 }, },
    { { 189, 239, 4, 1 },
      { 239, 56, 31, 0 },
      { 144, 123, 222, 1 },
      { 124, 14, 123, 1 }, },
    { { 189, 239, 7, 0 },
      { 231, 122, 31, 0 },
      { 112, 123, 222, 1 },
      { 124, 47, 115, 1 }, },
    { { 189, 239, 120, 0 },
      { 247, 188, 15, 1 },
      { 15, 123, 222, 1 },
      { 248, 30, 247, 1 }, },
    { { 189, 239, 123, 1 },
      { 255, 254, 15, 1 },
      { 239, 123, 222, 1 },
      { 248, 63, 255, 1 }, },
    { { 189, 239, 116, 1 },
      { 255, 188, 31, 0 },
      { 151, 123, 222, 1 },
      { 124, 30, 255, 1 }, },
    { { 189, 239, 119, 0 },
      { 247, 254, 31, 0 },
      { 119, 123, 222, 1 },
      { 124, 63, 247, 1 }, },
    { { 189, 238, 152, 0 },
      { 247, 56, 46, 1 },
      { 12, 187, 222, 1 },
      { 186, 14, 119, 1 }, },
    { { 189, 238, 155, 1 },
      { 255, 122, 46, 1 },
      { 236, 187, 222, 1 },
      { 186, 47, 127, 1 }, },
    { { 189, 238, 148, 1 },
      { 255, 56, 62, 0 },
      { 148, 187, 222, 1 },
      { 62, 14, 127, 1 }, },
    { { 189, 238, 151, 0 },
      { 247, 122, 62, 0 },
      { 116, 187, 222, 1 },
      { 62, 47, 119, 1 }, },
    { { 189, 238, 232, 0 },
      { 231, 188, 46, 1 },
      { 11, 187, 222, 1 },
      { 186, 30, 243, 1 }, },
    { { 189, 238, 235, 1 },
      { 239, 254, 46, 1 },
      { 235, 187, 222, 1 },
      { 186, 63, 251, 1 }, },
    { { 189, 238, 228, 1 },
      { 239, 188, 62, 0 },
      { 147, 187, 222, 1 },
      { 62, 30, 251, 1 }, },
    { { 189, 238, 231, 0 },
      { 231, 254, 62, 0 },
      { 115, 187, 222, 1 },
      { 62, 63, 243, 1 }, },
    { { 189, 211, 8, 0 },
      { 230, 48, 77, 1 },
      { 8, 101, 222, 1 },
      { 217, 6, 51, 1 }, },
    { { 189, 211, 11, 1 },
      { 238, 114, 77, 1 },
      { 232, 101, 222, 1 },
      { 217, 39, 59, 1 }, },
    { { 189, 211, 4, 1 },
      { 238, 48, 93, 0 },
      { 144, 101, 222, 1 },
      { 93, 6, 59, 1 }, },
    { { 189, 211, 7, 0 },
      { 230, 114, 93, 0 },
      { 112, 101, 222, 1 },
      { 93, 39, 51, 1 }, },
    { { 189, 211, 120, 0 },
      { 246, 180, 77, 1 },
      { 15, 101, 222, 1 },
      { 217, 22, 183, 1 }, },
    { { 189, 211, 123, 1 },
      { 254, 246, 77, 1 },
      { 239, 101, 222, 1 },
      { 217, 55, 191, 1 }, },
    { { 189, 211, 116, 1 },
      { 254, 180, 93, 0 },
      { 151, 101, 222, 1 },
      { 93, 22, 191, 1 }, },
    { { 189, 211, 119, 0 },
      { 246, 246, 93, 0 },
      { 119, 101, 222, 1 },
      { 93, 55, 183, 1 }, },
    { { 189, 210, 152, 0 },
      { 246, 48, 108, 1 },
      { 12, 165, 222, 1 },
      { 155, 6, 55, 1 }, },
    { { 189, 210, 155, 1 },
      { 254, 114, 108, 1 },
      { 236, 165, 222, 1 },
      { 155, 39, 63, 1 }, },
    { { 189, 210, 148, 1 },
      { 254, 48, 124, 0 },
      { 148, 165, 222, 1 },
      { 31, 6, 63, 1 }, },
    { { 189, 210, 151, 0 },
      { 246, 114, 124, 0 },
      { 116, 165, 222, 1 },
      { 31, 39, 55, 1 }, },
    { { 189, 210, 232, 0 },
      { 230, 180, 108, 1 },
      { 11, 165, 222, 1 },
      { 155, 22, 179, 1 }, },
    { { 189, 210, 235, 1 },
      { 238, 246, 108, 1 },
      { 235, 165, 222, 1 },
      { 155, 55, 187, 1 }, },
    { { 189, 210, 228, 1 },
      { 238, 180, 124, 0 },
      { 147, 165, 222, 1 },
      { 31, 22, 187, 1 }, },
    { { 189, 210, 231, 0 },
      { 230, 246, 124, 0 },
      { 115, 165, 222, 1 },
      { 31, 55, 179, 1 }, },
    { { 189, 221, 8, 0 },
      { 199, 56, 77, 1 },
      { 8, 93, 222, 1 },
      { 217, 14, 113, 1 }, },
    { { 189, 221, 11, 1 },
      { 207, 122, 77, 1 },
      { 232, 93, 222, 1 },
      { 217, 47, 121, 1 }, },
    { { 189, 221, 4, 1 },
      { 207, 56, 93, 0 },
      { 144, 93, 222, 1 },
      { 93, 14, 121, 1 }, },
    { { 189, 221, 7, 0 },
      { 199, 122, 93, 0 },
      { 112, 93, 222, 1 },
      { 93, 47, 113, 1 }, },
    { { 189, 221, 120, 0 },
      { 215, 188, 77, 1 },
      { 15, 93, 222, 1 },
      { 217, 30, 245, 1 }, },
    { { 189, 221, 123, 1 },
      { 223, 254, 77, 1 },
      { 239, 93, 222, 1 },
      { 217, 63, 253, 1 }, },
    { { 189, 221, 116, 1 },
      { 223, 188, 93, 0 },
      { 151, 93, 222, 1 },
      { 93, 30, 253, 1 }, },
    { { 189, 221, 119, 0 },
      { 215, 254, 93, 0 },
      { 119, 93, 222, 1 },
      { 93, 63, 245, 1 }, },
    { { 189, 220, 152, 0 },
      { 215, 56, 108, 1 },
      { 12, 157, 222, 1 },
      { 155, 14, 117, 1 }, },
    { { 189, 220, 155, 1 },
      { 223, 122, 108, 1 },
      { 236, 157, 222, 1 },
      { 155, 47, 125, 1 }, },
    { { 189, 220, 148, 1 },
      { 223, 56, 124, 0 },
      { 148, 157, 222, 1 },
      { 31, 14, 125, 1 }, },
    { { 189, 220, 151, 0 },
      { 215, 122, 124, 0 },
      { 116, 157, 222, 1 },
      { 31, 47, 117, 1 }, },
    { { 189, 220, 232, 0 },
      { 199, 188, 108, 1 },
      { 11, 157, 222, 1 },
      { 155, 30, 241, 1 }, },
    { { 189, 220, 235, 1 },
      { 207, 254, 108, 1 },
      { 235, 157, 222, 1 },
      { 155, 63, 249, 1 }, },
    { { 189, 220, 228, 1 },
      { 207, 188, 124, 0 },
      { 147, 157, 222, 1 },
      { 31, 30, 249, 1 }, },
    { { 189, 220, 231, 0 },
      { 199, 254, 124, 0 },
      { 115, 157, 222, 1 },
      { 31, 63, 241, 1 }, },
    { { 186, 97, 8, 0 },
      { 196, 32, 139, 1 },
      { 8, 67, 46, 1 },
      { 232, 130, 17, 1 }, },
    { { 186, 97, 11, 1 },
      { 204, 98, 139, 1 },
      { 232, 67, 46, 1 },
      { 232, 163, 25, 1 }, },
    { { 186, 97, 4, 1 },
      { 204, 32, 155, 0 },
      { 144, 67, 46, 1 },
      { 108, 130, 25, 1 }, },
    { { 186, 97, 7, 0 },
      { 196, 98, 155, 0 },
      { 112, 67, 46, 1 },
      { 108, 163, 17, 1 }, },
    { { 186, 97, 120, 0 },
      { 212, 164, 139, 1 },
      { 15, 67, 46, 1 },
      { 232, 146, 149, 1 }, },
    { { 186, 97, 123, 1 },
      { 220, 230, 139, 1 },
      { 239, 67, 46, 1 },
      { 232, 179, 157, 1 }, },
    { { 186, 97, 116, 1 },
      { 220, 164, 155, 0 },
      { 151, 67, 46, 1 },
      { 108, 146, 157, 1 }, },
    { { 186, 97, 119, 0 },
      { 212, 230, 155, 0 },
      { 119, 67, 46, 1 },
      { 108, 179, 149, 1 }, },
    { { 186, 96, 152, 0 },
      { 212, 32, 170, 1 },
      { 12, 131, 46, 1 },
      { 170, 130, 21, 1 }, },
    { { 186, 96, 155, 1 },
      { 220, 98, 170, 1 },
      { 236, 131, 46, 1 },
      { 170, 163, 29, 1 }, },
    { { 186, 96, 148, 1 },
      { 220, 32, 186, 0 },
      { 148, 131, 46, 1 },
      { 46, 130, 29, 1 }, },
    { { 186, 96, 151, 0 },
      { 212, 98, 186, 0 },
      { 116, 131, 46, 1 },
      { 46, 163, 21, 1 }, },
    { { 186, 96, 232, 0 },
      { 196, 164, 170, 1 },
      { 11, 131, 46, 1 },
      { 170, 146, 145, 1 }, },
    { { 186, 96, 235, 1 },
      { 204, 230, 170, 1 },
      { 235, 131, 46, 1 },
      { 170, 179, 153, 1 }, },
    { { 186, 96, 228, 1 },
      { 204, 164, 186, 0 },
      { 147, 131, 46, 1 },
      { 46, 146, 153, 1 }, },
    { { 186, 96, 231, 0 },
      { 196, 230, 186, 0 },
      { 115, 131, 46, 1 },
      { 46, 179, 145, 1 }, },
    { { 186, 111, 8, 0 },
      { 229, 40, 139, 1 },
      { 8, 123, 46, 1 },
      { 232, 138, 83, 1 }, },
    { { 186, 111, 11, 1 },
      { 237, 106, 139, 1 },
      { 232, 123, 46, 1 },
      { 232, 171, 91, 1 }, },
    { { 186, 111, 4, 1 },
      { 237, 40, 155, 0 },
      { 144, 123, 46, 1 },
      { 108, 138, 91, 1 }, },
    { { 186, 111, 7, 0 },
      { 229, 106, 155, 0 },
      { 112, 123, 46, 1 },
      { 108, 171, 83, 1 }, },
    { { 186, 111, 120, 0 },
      { 245, 172, 139, 1 },
      { 15, 123, 46, 1 },
      { 232, 154, 215, 1 }, },
    { { 186, 111, 123, 1 },
      { 253, 238, 139, 1 },
      { 239, 123, 46, 1 },
      { 232, 187, 223, 1 }, },
    { { 186, 111, 116, 1 },
      { 253, 172, 155, 0 },
      { 151, 123, 46, 1 },
      { 108, 154, 223, 1 }, },
    { { 186, 111, 119, 0 },
      { 245, 238, 155, 0 },
      { 119, 123, 46, 1 },
      { 108, 187, 215, 1 }, },
    { { 186, 110, 152, 0 },
      { 245, 40, 170, 1 },
      { 12, 187, 46, 1 },
      { 170, 138, 87, 1 }, },
    { { 186, 110, 155, 1 },
      { 253, 106, 170, 1 },
      { 236, 187, 46, 1 },
      { 170, 171, 95, 1 }, },
    { { 186, 110, 148, 1 },
      { 253, 40, 186, 0 },
      { 148, 187, 46, 1 },
      { 46, 138, 95, 1 }, },
    { { 186, 110, 151, 0 },
      { 245, 106, 186, 0 },
      { 116, 187, 46, 1 },
      { 46, 171, 87, 1 }, },
    { { 186, 110, 232, 0 },
      { 229, 172, 170, 1 },
      { 11, 187, 46, 1 },
      { 170, 154, 211, 1 }, },
    { { 186, 110, 235, 1 },
      { 237, 238, 170, 1 },
      { 235, 187, 46, 1 },
      { 170, 187, 219, 1 }, },
    { { 186, 110, 228, 1 },
      { 237, 172, 186, 0 },
      { 147, 187, 46, 1 },
      { 46, 154, 219, 1 }, },
    { { 186, 110, 231, 0 },
      { 229, 238, 186, 0 },
      { 115, 187, 46, 1 },
      { 46, 187, 211, 1 }, },
    { { 186, 83, 8, 0 },
      { 228, 32, 201, 1 },
      { 8, 101, 46, 1 },
      { 201, 130, 19, 1 }, },
    { { 186, 83, 11, 1 },
      { 236, 98, 201, 1 },
      { 232, 101, 46, 1 },
      { 201, 163, 27, 1 }, },
    { { 186, 83, 4, 1 },
      { 236, 32, 217, 0 },
      { 144, 101, 46, 1 },
      { 77, 130, 27, 1 }, },
    { { 186, 83, 7, 0 },
      { 228, 98, 217, 0 },
      { 112, 101, 46, 1 },
      { 77, 163, 19, 1 }, },
    { { 186, 83, 120, 0 },
      { 244, 164, 201, 1 },
      { 15, 101, 46, 1 },
      { 201, 146, 151, 1 }, },
    { { 186, 83, 123, 1 },
      { 252, 230, 201, 1 },
      { 239, 101, 46, 1 },
      { 201, 179, 159, 1 }, },
    { { 186, 83, 116, 1 },
      { 252, 164, 217, 0 },
      { 151, 101, 46, 1 },
      { 77, 146, 159, 1 }, },
    { { 186, 83, 119, 0 },
      { 244, 230, 217, 0 },
      { 119, 101, 46, 1 },
      { 77, 179, 151, 1 }, },
    { { 186, 82, 152, 0 },
      { 244, 32, 232, 1 },
      { 12, 165, 46, 1 },
      { 139, 130, 23, 1 }, },
    { { 186, 82, 155, 1 },
      { 252, 98, 232, 1 },
      { 236, 165, 46, 1 },
      { 139, 163, 31, 1 }, },
    { { 186, 82, 148, 1 },
      { 252, 32, 248, 0 },
      { 148, 165, 46, 1 },
      { 15, 130, 31, 1 }, },
    { { 186, 82, 151, 0 },
      { 244, 98, 248, 0 },
      { 116, 165, 46, 1 },
      { 15, 163, 23, 1 }, },
    { { 186, 82, 232, 0 },
      { 228, 164, 232, 1 },
      { 11, 165, 46, 1 },
      { 139, 146, 147, 1 }, },
    { { 186, 82, 235, 1 },
      { 236, 230, 232, 1 },
      { 235, 165, 46, 1 },
      { 139, 179, 155, 1 }, },
    { { 186, 82, 228, 1 },
      { 236, 164, 248, 0 },
      { 147, 165, 46, 1 },
      { 15, 146, 155, 1 }, },
    { { 186, 82, 231, 0 },
      { 228, 230, 248, 0 },
      { 115, 165, 46, 1 },
      { 15, 179, 147, 1 }, },
    { { 186, 93, 8, 0 },
      { 197, 40, 201, 1 },
      { 8, 93, 46, 1 },
      { 201, 138, 81, 1 }, },
    { { 186, 93, 11, 1 },
      { 205, 106, 201, 1 },
      { 232, 93, 46, 1 },
      { 201, 171, 89, 1 }, },
    { { 186, 93, 4, 1 },
      { 205, 40, 217, 0 },
      { 144, 93, 46, 1 },
      { 77, 138, 89, 1 }, },
    { { 186, 93, 7, 0 },
      { 197, 106, 217, 0 },
      { 112, 93, 46, 1 },
      { 77, 171, 81, 1 }, },
    { { 186, 93, 120, 0 },
      { 213, 172, 201, 1 },
      { 15, 93, 46, 1 },
      { 201, 154, 213, 1 }, },
    { { 186, 93, 123, 1 },
      { 221, 238, 201, 1 },
      { 239, 93, 46, 1 },
      { 201, 187, 221, 1 }, },
    { { 186, 93, 116, 1 },
      { 221, 172, 217, 0 },
      { 151, 93, 46, 1 },
      { 77, 154, 221, 1 }, },
    { { 186, 93, 119, 0 },
      { 213, 238, 217, 0 },
      { 119, 93, 46, 1 },
      { 77, 187, 213, 1 }, },
    { { 186, 92, 152, 0 },
      { 213, 40, 232, 1 },
      { 12, 157, 46, 1 },
      { 139, 138, 85, 1 }, },
    { { 186, 92, 155, 1 },
      { 221, 106, 232, 1 },
      { 236, 157, 46, 1 },
      { 139, 171, 93, 1 }, },
    { { 186, 92, 148, 1 },
      { 221, 40, 248, 0 },
      { 148, 157, 46, 1 },
      { 15, 138, 93, 1 }, },
    { { 186, 92, 151, 0 },
      { 213, 106, 248, 0 },
      { 116, 157, 46, 1 },
      { 15, 171, 85, 1 }, },
    { { 186, 92, 232, 0 },
      { 197, 172, 232, 1 },
      { 11, 157, 46, 1 },
      { 139, 154, 209, 1 }, },
    { { 186, 92, 235, 1 },
      { 205, 238, 232, 1 },
      { 235, 157, 46, 1 },
      { 139, 187, 217, 1 }, },
    { { 186, 92, 228, 1 },
      { 205, 172, 248, 0 },
      { 147, 157, 46, 1 },
      { 15, 154, 217, 1 }, },
    { { 186, 92, 231, 0 },
      { 197, 238, 248, 0 },
      { 115, 157, 46, 1 },
      { 15, 187, 209, 1 }, },
    { { 187, 161, 8, 0 },
      { 134, 48, 139, 1 },
      { 8, 66, 238, 1 },
      { 232, 134, 48, 1 }, },
    { { 187, 161, 11, 1 },
      { 142, 114, 139, 1 },
      { 232, 66, 238, 1 },
      { 232, 167, 56, 1 }, },
    { { 187, 161, 4, 1 },
      { 142, 48, 155, 0 },
      { 144, 66, 238, 1 },
      { 108, 134, 56, 1 }, },
    { { 187, 161, 7, 0 },
      { 134, 114, 155, 0 },
      { 112, 66, 238, 1 },
      { 108, 167, 48, 1 }, },
    { { 187, 161, 120, 0 },
      { 150, 180, 139, 1 },
      { 15, 66, 238, 1 },
      { 232, 150, 180, 1 }, },
    { { 187, 161, 123, 1 },
      { 158, 246, 139, 1 },
      { 239, 66, 238, 1 },
      { 232, 183, 188, 1 }, },
    { { 187, 161, 116, 1 },
      { 158, 180, 155, 0 },
      { 151, 66, 238, 1 },
      { 108, 150, 188, 1 }, },
    { { 187, 161, 119, 0 },
      { 150, 246, 155, 0 },
      { 119, 66, 238, 1 },
      { 108, 183, 180, 1 }, },
    { { 187, 160, 152, 0 },
      { 150, 48, 170, 1 },
      { 12, 130, 238, 1 },
      { 170, 134, 52, 1 }, },
    { { 187, 160, 155, 1 },
      { 158, 114, 170, 1 },
      { 236, 130, 238, 1 },
      { 170, 167, 60, 1 }, },
    { { 187, 160, 148, 1 },
      { 158, 48, 186, 0 },
      { 148, 130, 238, 1 },
      { 46, 134, 60, 1 }, },
    { { 187, 160, 151, 0 },
      { 150, 114, 186, 0 },
      { 116, 130, 238, 1 },
      { 46, 167, 52, 1 }, },
    { { 187, 160, 232, 0 },
      { 134, 180, 170, 1 },
      { 11, 130, 238, 1 },
      { 170, 150, 176, 1 }, },
    { { 187, 160, 235, 1 },
      { 142, 246, 170, 1 },
      { 235, 130, 238, 1 },
      { 170, 183, 184, 1 }, },
    { { 187, 160, 228, 1 },
      { 142, 180, 186, 0 },
      { 147, 130, 238, 1 },
      { 46, 150, 184, 1 }, },
    { { 187, 160, 231, 0 },
      { 134, 246, 186, 0 },
      { 115, 130, 238, 1 },
      { 46, 183, 176, 1 }, },
    { { 187, 175, 8, 0 },
      { 167, 56, 139, 1 },
      { 8, 122, 238, 1 },
      { 232, 142, 114, 1 }, },
    { { 187, 175, 11, 1 },
      { 175, 122, 139, 1 },
      { 232, 122, 238, 1 },
      { 232, 175, 122, 1 }, },
    { { 187, 175, 4, 1 },
      { 175, 56, 155, 0 },
      { 144, 122, 238, 1 },
      { 108, 142, 122, 1 }, },
    { { 187, 175, 7, 0 },
      { 167, 122, 155, 0 },
      { 112, 122, 238, 1 },
      { 108, 175, 114, 1 }, },
    { { 187, 175, 120, 0 },
      { 183, 188, 139, 1 },
      { 15, 122, 238, 1 },
      { 232, 158, 246, 1 }, },
    { { 187, 175, 123, 1 },
      { 191, 254, 139, 1 },
      { 239, 122, 238, 1 },
      { 232, 191, 254, 1 }, },
    { { 187, 175, 116, 1 },
      { 191, 188, 155, 0 },
      { 151, 122, 238, 1 },
      { 108, 158, 254, 1 }, },
    { { 187, 175, 119, 0 },
      { 183, 254, 155, 0 },
      { 119, 122, 238, 1 },
      { 108, 191, 246, 1 }, },
    { { 187, 174, 152, 0 },
      { 183, 56, 170, 1 },
      { 12, 186, 238, 1 },
      { 170, 142, 118, 1 }, },
    { { 187, 174, 155, 1 },
      { 191, 122, 170, 1 },
      { 236, 186, 238, 1 },
      { 170, 175, 126, 1 }, },
    { { 187, 174, 148, 1 },
      { 191, 56, 186, 0 },
      { 148, 186, 238, 1 },
      { 46, 142, 126, 1 }, },
    { { 187, 174, 151, 0 },
      { 183, 122, 186, 0 },
      { 116, 186, 238, 1 },
      { 46, 175, 118, 1 }, },
    { { 187, 174, 232, 0 },
      { 167, 188, 170, 1 },
      { 11, 186, 238, 1 },
      { 170, 158, 242, 1 }, },
    { { 187, 174, 235, 1 },
      { 175, 254, 170, 1 },
      { 235, 186, 238, 1 },
      { 170, 191, 250, 1 }, },
    { { 187, 174, 228, 1 },
      { 175, 188, 186, 0 },
      { 147, 186, 238, 1 },
      { 46, 158, 250, 1 }, },
    { { 187, 174, 231, 0 },
      { 167, 254, 186, 0 },
      { 115, 186, 238, 1 },
      { 46, 191, 242, 1 }, },
    { { 187, 147, 8, 0 },
      { 166, 48, 201, 1 },
      { 8, 100, 238, 1 },
      { 201, 134, 50, 1 }, },
    { { 187, 147, 11, 1 },
      { 174, 114, 201, 1 },
      { 232, 100, 238, 1 },
      { 201, 167, 58, 1 }, },
    { { 187, 147, 4, 1 },
      { 174, 48, 217, 0 },
      { 144, 100, 238, 1 },
      { 77, 134, 58, 1 }, },
    { { 187, 147, 7, 0 },
      { 166, 114, 217, 0 },
      { 112, 100, 238, 1 },
      { 77, 167, 50, 1 }, },
    { { 187, 147, 120, 0 },
      { 182, 180, 201, 1 },
      { 15, 100, 238, 1 },
      { 201, 150, 182, 1 }, },
    { { 187, 147, 123, 1 },
      { 190, 246, 201, 1 },
      { 239, 100, 238, 1 },
      { 201, 183, 190, 1 }, },
    { { 187, 147, 116, 1 },
      { 190, 180, 217, 0 },
      { 151, 100, 238, 1 },
      { 77, 150, 190, 1 }, },
    { { 187, 147, 119, 0 },
      { 182, 246, 217, 0 },
      { 119, 100, 238, 1 },
      { 77, 183, 182, 1 }, },
    { { 187, 146, 152, 0 },
      { 182, 48, 232, 1 },
      { 12, 164, 238, 1 },
      { 139, 134, 54, 1 }, },
    { { 187, 146, 155, 1 },
      { 190, 114, 232, 1 },
      { 236, 164, 238, 1 },
      { 139, 167, 62, 1 }, },
    { { 187, 146, 148, 1 },
      { 190, 48, 248, 0 },
      { 148, 164, 238, 1 },
      { 15, 134, 62, 1 }, },
    { { 187, 146, 151, 0 },
      { 182, 114, 248, 0 },
      { 116, 164, 238, 1 },
      { 15, 167, 54, 1 }, },
    { { 187, 146, 232, 0 },
      { 166, 180, 232, 1 },
      { 11, 164, 238, 1 },
      { 139, 150, 178, 1 }, },
    { { 187, 146, 235, 1 },
      { 174, 246, 232, 1 },
      { 235, 164, 238, 1 },
      { 139, 183, 186, 1 }, },
    { { 187, 146, 228, 1 },
      { 174, 180, 248, 0 },
      { 147, 164, 238, 1 },
      { 15, 150, 186, 1 }, },
    { { 187, 146, 231, 0 },
      { 166, 246, 248, 0 },
      { 115, 164, 238, 1 },
      { 15, 183, 178, 1 }, },
    { { 187, 157, 8, 0 },
      { 135, 56, 201, 1 },
      { 8, 92, 238, 1 },
      { 201, 142, 112, 1 }, },
    { { 187, 157, 11, 1 },
      { 143, 122, 201, 1 },
      { 232, 92, 238, 1 },
      { 201, 175, 120, 1 }, },
    { { 187, 157, 4, 1 },
      { 143, 56, 217, 0 },
      { 144, 92, 238, 1 },
      { 77, 142, 120, 1 }, },
    { { 187, 157, 7, 0 },
      { 135, 122, 217, 0 },
      { 112, 92, 238, 1 },
      { 77, 175, 112, 1 }, },
    { { 187, 157, 120, 0 },
      { 151, 188, 201, 1 },
      { 15, 92, 238, 1 },
      { 201, 158, 244, 1 }, },
    { { 187, 157, 123, 1 },
      { 159, 254, 201, 1 },
      { 239, 92, 238, 1 },
      { 201, 191, 252, 1 }, },
    { { 187, 157, 116, 1 },
      { 159, 188, 217, 0 },
      { 151, 92, 238, 1 },
      { 77, 158, 252, 1 }, },
    { { 187, 157, 119, 0 },
      { 151, 254, 217, 0 },
      { 119, 92, 238, 1 },
      { 77, 191, 244, 1 }, },
    { { 187, 156, 152, 0 },
      { 151, 56, 232, 1 },
      { 12, 156, 238, 1 },
      { 139, 142, 116, 1 }, },
    { { 187, 156, 155, 1 },
      { 159, 122, 232, 1 },
      { 236, 156, 238, 1 },
      { 139, 175, 124, 1 }, },
    { { 187, 156, 148, 1 },
      { 159, 56, 248, 0 },
      { 148, 156, 238, 1 },
      { 15, 142, 124, 1 }, },
    { { 187, 156, 151, 0 },
      { 151, 122, 248, 0 },
      { 116, 156, 238, 1 },
      { 15, 175, 116, 1 }, },
    { { 187, 156, 232, 0 },
      { 135, 188, 232, 1 },
      { 11, 156, 238, 1 },
      { 139, 158, 240, 1 }, },
    { { 187, 156, 235, 1 },
      { 143, 254, 232, 1 },
      { 235, 156, 238, 1 },
      { 139, 191, 248, 1 }, },
    { { 187, 156, 228, 1 },
      { 143, 188, 248, 0 },
      { 147, 156, 238, 1 },
      { 15, 158, 248, 1 }, },
    { { 187, 156, 231, 0 },
      { 135, 254, 248, 0 },
      { 115, 156, 238, 1 },
      { 15, 191, 240, 1 }, },
    { { 76, 33, 8, 0 },
      { 128, 1, 7, 1 },
      { 8, 66, 25, 0 },
      { 240, 64, 0, 1 }, },
    { { 76, 33, 11, 1 },
      { 136, 67, 7, 1 },
      { 232, 66, 25, 0 },
      { 240, 97, 8, 1 }, },
    { { 76, 33, 4, 1 },
      { 136, 1, 23, 0 },
      { 144, 66, 25, 0 },
      { 116, 64, 8, 1 }, },
    { { 76, 33, 7, 0 },
      { 128, 67, 23, 0 },
      { 112, 66, 25, 0 },
      { 116, 97, 0, 1 }, },
    { { 76, 33, 120, 0 },
      { 144, 133, 7, 1 },
      { 15, 66, 25, 0 },
      { 240, 80, 132, 1 }, },
    { { 76, 33, 123, 1 },
      { 152, 199, 7, 1 },
      { 239, 66, 25, 0 },
      { 240, 113, 140, 1 }, },
    { { 76, 33, 116, 1 },
      { 152, 133, 23, 0 },
      { 151, 66, 25, 0 },
      { 116, 80, 140, 1 }, },
    { { 76, 33, 119, 0 },
      { 144, 199, 23, 0 },
      { 119, 66, 25, 0 },
      { 116, 113, 132, 1 }, },
    { { 76, 32, 152, 0 },
      { 144, 1, 38, 1 },
      { 12, 130, 25, 0 },
      { 178, 64, 4, 1 }, },
    { { 76, 32, 155, 1 },
      { 152, 67, 38, 1 },
      { 236, 130, 25, 0 },
      { 178, 97, 12, 1 }, },
    { { 76, 32, 148, 1 },
      { 152, 1, 54, 0 },
      { 148, 130, 25, 0 },
      { 54, 64, 12, 1 }, },
    { { 76, 32, 151, 0 },
      { 144, 67, 54, 0 },
      { 116, 130, 25, 0 },
      { 54, 97, 4, 1 }, },
    { { 76, 32, 232, 0 },
      { 128, 133, 38, 1 },
      { 11, 130, 25, 0 },
      { 178, 80, 128, 1 }, },
    { { 76, 32, 235, 1 },
      { 136, 199, 38, 1 },
      { 235, 130, 25, 0 },
      { 178, 113, 136, 1 }, },
    { { 76, 32, 228, 1 },
      { 136, 133, 54, 0 },
      { 147, 130, 25, 0 },
      { 54, 80, 136, 1 }, },
    { { 76, 32, 231, 0 },
      { 128, 199, 54, 0 },
      { 115, 130, 25, 0 },
      { 54, 113, 128, 1 }, },
    { { 76, 47, 8, 0 },
      { 161, 9, 7, 1 },
      { 8, 122, 25, 0 },
      { 240, 72, 66, 1 }, },
    { { 76, 47, 11, 1 },
      { 169, 75, 7, 1 },
      { 232, 122, 25, 0 },
      { 240, 105, 74, 1 }, },
    { { 76, 47, 4, 1 },
      { 169, 9, 23, 0 },
      { 144, 122, 25, 0 },
      { 116, 72, 74, 1 }, },
    { { 76, 47, 7, 0 },
      { 161, 75, 23, 0 },
      { 112, 122, 25, 0 },
      { 116, 105, 66, 1 }, },
    { { 76, 47, 120, 0 },
      { 177, 141, 7, 1 },
      { 15, 122, 25, 0 },
      { 240, 88, 198, 1 }, },
    { { 76, 47, 123, 1 },
      { 185, 207, 7, 1 },
      { 239, 122, 25, 0 },
      { 240, 121, 206, 1 }, },
    { { 76, 47, 116, 1 },
      { 185, 141, 23, 0 },
      { 151, 122, 25, 0 },
      { 116, 88, 206, 1 }, },
    { { 76, 47, 119, 0 },
      { 177, 207, 23, 0 },
      { 119, 122, 25, 0 },
      { 116, 121, 198, 1 }, },
    { { 76, 46, 152, 0 },
      { 177, 9, 38, 1 },
      { 12, 186, 25, 0 },
      { 178, 72, 70, 1 }, },
    { { 76, 46, 155, 1 },
      { 185, 75, 38, 1 },
      { 236, 186, 25, 0 },
      { 178, 105, 78, 1 }, },
    { { 76, 46, 148, 1 },
      { 185, 9, 54, 0 },
      { 148, 186, 25, 0 },
      { 54, 72, 78, 1 }, },
    { { 76, 46, 151, 0 },
      { 177, 75, 54, 0 },
      { 116, 186, 25, 0 },
      { 54, 105, 70, 1 }, },
    { { 76, 46, 232, 0 },
      { 161, 141, 38, 1 },
      { 11, 186, 25, 0 },
      { 178, 88, 194, 1 }, },
    { { 76, 46, 235, 1 },
      { 169, 207, 38, 1 },
      { 235, 186, 25, 0 },
      { 178, 121, 202, 1 }, },
    { { 76, 46, 228, 1 },
      { 169, 141, 54, 0 },
      { 147, 186, 25, 0 },
      { 54, 88, 202, 1 }, },
    { { 76, 46, 231, 0 },
      { 161, 207, 54, 0 },
      { 115, 186, 25, 0 },
      { 54, 121, 194, 1 }, },
    { { 76, 19, 8, 0 },
      { 160, 1, 69, 1 },
      { 8, 100, 25, 0 },
      { 209, 64, 2, 1 }, },
    { { 76, 19, 11, 1 },
      { 168, 67, 69, 1 },
      { 232, 100, 25, 0 },
      { 209, 97, 10, 1 }, },
    { { 76, 19, 4, 1 },
      { 168, 1, 85, 0 },
      { 144, 100, 25, 0 },
      { 85, 64, 10, 1 }, },
    { { 76, 19, 7, 0 },
      { 160, 67, 85, 0 },
      { 112, 100, 25, 0 },
      { 85, 97, 2, 1 }, },
    { { 76, 19, 120, 0 },
      { 176, 133, 69, 1 },
      { 15, 100, 25, 0 },
      { 209, 80, 134, 1 }, },
    { { 76, 19, 123, 1 },
      { 184, 199, 69, 1 },
      { 239, 100, 25, 0 },
      { 209, 113, 142, 1 }, },
    { { 76, 19, 116, 1 },
      { 184, 133, 85, 0 },
      { 151, 100, 25, 0 },
      { 85, 80, 142, 1 }, },
    { { 76, 19, 119, 0 },
      { 176, 199, 85, 0 },
      { 119, 100, 25, 0 },
      { 85, 113, 134, 1 }, },
    { { 76, 18, 152, 0 },
      { 176, 1, 100, 1 },
      { 12, 164, 25, 0 },
      { 147, 64, 6, 1 }, },
    { { 76, 18, 155, 1 },
      { 184, 67, 100, 1 },
      { 236, 164, 25, 0 },
      { 147, 97, 14, 1 }, },
    { { 76, 18, 148, 1 },
      { 184, 1, 116, 0 },
      { 148, 164, 25, 0 },
      { 23, 64, 14, 1 }, },
    { { 76, 18, 151, 0 },
      { 176, 67, 116, 0 },
      { 116, 164, 25, 0 },
      { 23, 97, 6, 1 }, },
    { { 76, 18, 232, 0 },
      { 160, 133, 100, 1 },
      { 11, 164, 25, 0 },
      { 147, 80, 130, 1 }, },
    { { 76, 18, 235, 1 },
      { 168, 199, 100, 1 },
      { 235, 164, 25, 0 },
      { 147, 113, 138, 1 }, },
    { { 76, 18, 228, 1 },
      { 168, 133, 116, 0 },
      { 147, 164, 25, 0 },
      { 23, 80, 138, 1 }, },
    { { 76, 18, 231, 0 },
      { 160, 199, 116, 0 },
      { 115, 164, 25, 0 },
      { 23, 113, 130, 1 }, },
    { { 76, 29, 8, 0 },
      { 129, 9, 69, 1 },
      { 8, 92, 25, 0 },
      { 209, 72, 64, 1 }, },
    { { 76, 29, 11, 1 },
      { 137, 75, 69, 1 },
      { 232, 92, 25, 0 },
      { 209, 105, 72, 1 }, },
    { { 76, 29, 4, 1 },
      { 137, 9, 85, 0 },
      { 144, 92, 25, 0 },
      { 85, 72, 72, 1 }, },
    { { 76, 29, 7, 0 },
      { 129, 75, 85, 0 },
      { 112, 92, 25, 0 },
      { 85, 105, 64, 1 }, },
    { { 76, 29, 120, 0 },
      { 145, 141, 69, 1 },
      { 15, 92, 25, 0 },
      { 209, 88, 196, 1 }, },
    { { 76, 29, 123, 1 },
      { 153, 207, 69, 1 },
      { 239, 92, 25, 0 },
      { 209, 121, 204, 1 }, },
    { { 76, 29, 116, 1 },
      { 153, 141, 85, 0 },
      { 151, 92, 25, 0 },
      { 85, 88, 204, 1 }, },
    { { 76, 29, 119, 0 },
      { 145, 207, 85, 0 },
      { 119, 92, 25, 0 },
      { 85, 121, 196, 1 }, },
    { { 76, 28, 152, 0 },
      { 145, 9, 100, 1 },
      { 12, 156, 25, 0 },
      { 147, 72, 68, 1 }, },
    { { 76, 28, 155, 1 },
      { 153, 75, 100, 1 },
      { 236, 156, 25, 0 },
      { 147, 105, 76, 1 }, },
    { { 76, 28, 148, 1 },
      { 153, 9, 116, 0 },
      { 148, 156, 25, 0 },
      { 23, 72, 76, 1 }, },
    { { 76, 28, 151, 0 },
      { 145, 75, 116, 0 },
      { 116, 156, 25, 0 },
      { 23, 105, 68, 1 }, },
    { { 76, 28, 232, 0 },
      { 129, 141, 100, 1 },
      { 11, 156, 25, 0 },
      { 147, 88, 192, 1 }, },
    { { 76, 28, 235, 1 },
      { 137, 207, 100, 1 },
      { 235, 156, 25, 0 },
      { 147, 121, 200, 1 }, },
    { { 76, 28, 228, 1 },
      { 137, 141, 116, 0 },
      { 147, 156, 25, 0 },
      { 23, 88, 200, 1 }, },
    { { 76, 28, 231, 0 },
      { 129, 207, 116, 0 },
      { 115, 156, 25, 0 },
      { 23, 121, 192, 1 }, },
    { { 77, 225, 8, 0 },
      { 194, 17, 7, 1 },
      { 8, 67, 217, 0 },
      { 240, 68, 33, 1 }, },
    { { 77, 225, 11, 1 },
      { 202, 83, 7, 1 },
      { 232, 67, 217, 0 },
      { 240, 101, 41, 1 }, },
    { { 77, 225, 4, 1 },
      { 202, 17, 23, 0 },
      { 144, 67, 217, 0 },
      { 116, 68, 41, 1 }, },
    { { 77, 225, 7, 0 },
      { 194, 83, 23, 0 },
      { 112, 67, 217, 0 },
      { 116, 101, 33, 1 }, },
    { { 77, 225, 120, 0 },
      { 210, 149, 7, 1 },
      { 15, 67, 217, 0 },
      { 240, 84, 165, 1 }, },
    { { 77, 225, 123, 1 },
      { 218, 215, 7, 1 },
      { 239, 67, 217, 0 },
      { 240, 117, 173, 1 }, },
    { { 77, 225, 116, 1 },
      { 218, 149, 23, 0 },
      { 151, 67, 217, 0 },
      { 116, 84, 173, 1 }, },
    { { 77, 225, 119, 0 },
      { 210, 215, 23, 0 },
      { 119, 67, 217, 0 },
      { 116, 117, 165, 1 }, },
    { { 77, 224, 152, 0 },
      { 210, 17, 38, 1 },
      { 12, 131, 217, 0 },
      { 178, 68, 37, 1 }, },
    { { 77, 224, 155, 1 },
      { 218, 83, 38, 1 },
      { 236, 131, 217, 0 },
      { 178, 101, 45, 1 }, },
    { { 77, 224, 148, 1 },
      { 218, 17, 54, 0 },
      { 148, 131, 217, 0 },
      { 54, 68, 45, 1 }, },
    { { 77, 224, 151, 0 },
      { 210, 83, 54, 0 },
      { 116, 131, 217, 0 },
      { 54, 101, 37, 1 }, },
    { { 77, 224, 232, 0 },
      { 194, 149, 38, 1 },
      { 11, 131, 217, 0 },
      { 178, 84, 161, 1 }, },
    { { 77, 224, 235, 1 },
      { 202, 215, 38, 1 },
      { 235, 131, 217, 0 },
      { 178, 117, 169, 1 }, },
    { { 77, 224, 228, 1 },
      { 202, 149, 54, 0 },
      { 147, 131, 217, 0 },
      { 54, 84, 169, 1 }, },
    { { 77, 224, 231, 0 },
      { 194, 215, 54, 0 },
      { 115, 131, 217, 0 },
      { 54, 117, 161, 1 }, },
    { { 77, 239, 8, 0 },
      { 227, 25, 7, 1 },
      { 8, 123, 217, 0 },
      { 240, 76, 99, 1 }, },
    { { 77, 239, 11, 1 },
      { 235, 91, 7, 1 },
      { 232, 123, 217, 0 },
      { 240, 109, 107, 1 }, },
    { { 77, 239, 4, 1 },
      { 235, 25, 23, 0 },
      { 144, 123, 217, 0 },
      { 116, 76, 107, 1 }, },
    { { 77, 239, 7, 0 },
      { 227, 91, 23, 0 },
      { 112, 123, 217, 0 },
      { 116, 109, 99, 1 }, },
    { { 77, 239, 120, 0 },
      { 243, 157, 7, 1 },
      { 15, 123, 217, 0 },
      { 240, 92, 231, 1 }, },
    { { 77, 239, 123, 1 },
      { 251, 223, 7, 1 },
      { 239, 123, 217, 0 },
      { 240, 125, 239, 1 }, },
    { { 77, 239, 116, 1 },
      { 251, 157, 23, 0 },
      { 151, 123, 217, 0 },
      { 116, 92, 239, 1 }, },
    { { 77, 239, 119, 0 },
      { 243, 223, 23, 0 },
      { 119, 123, 217, 0 },
      { 116, 125, 231, 1 }, },
    { { 77, 238, 152, 0 },
      { 243, 25, 38, 1 },
      { 12, 187, 217, 0 },
      { 178, 76, 103, 1 }, },
    { { 77, 238, 155, 1 },
      { 251, 91, 38, 1 },
      { 236, 187, 217, 0 },
      { 178, 109, 111, 1 }, },
    { { 77, 238, 148, 1 },
      { 251, 25, 54, 0 },
      { 148, 187, 217, 0 },
      { 54, 76, 111, 1 }, },
    { { 77, 238, 151, 0 },
      { 243, 91, 54, 0 },
      { 116, 187, 217, 0 },
      { 54, 109, 103, 1 }, },
    { { 77, 238, 232, 0 },
      { 227, 157, 38, 1 },
      { 11, 187, 217, 0 },
      { 178, 92, 227, 1 }, },
    { { 77, 238, 235, 1 },
      { 235, 223, 38, 1 },
      { 235, 187, 217, 0 },
      { 178, 125, 235, 1 }, },
    { { 77, 238, 228, 1 },
      { 235, 157, 54, 0 },
      { 147, 187, 217, 0 },
      { 54, 92, 235, 1 }, },
    { { 77, 238, 231, 0 },
      { 227, 223, 54, 0 },
      { 115, 187, 217, 0 },
      { 54, 125, 227, 1 }, },
    { { 77, 211, 8, 0 },
      { 226, 17, 69, 1 },
      { 8, 101, 217, 0 },
      { 209, 68, 35, 1 }, },
    { { 77, 211, 11, 1 },
      { 234, 83, 69, 1 },
      { 232, 101, 217, 0 },
      { 209, 101, 43, 1 }, },
    { { 77, 211, 4, 1 },
      { 234, 17, 85, 0 },
      { 144, 101, 217, 0 },
      { 85, 68, 43, 1 }, },
    { { 77, 211, 7, 0 },
      { 226, 83, 85, 0 },
      { 112, 101, 217, 0 },
      { 85, 101, 35, 1 }, },
    { { 77, 211, 120, 0 },
      { 242, 149, 69, 1 },
      { 15, 101, 217, 0 },
      { 209, 84, 167, 1 }, },
    { { 77, 211, 123, 1 },
      { 250, 215, 69, 1 },
      { 239, 101, 217, 0 },
      { 209, 117, 175, 1 }, },
    { { 77, 211, 116, 1 },
      { 250, 149, 85, 0 },
      { 151, 101, 217, 0 },
      { 85, 84, 175, 1 }, },
    { { 77, 211, 119, 0 },
      { 242, 215, 85, 0 },
      { 119, 101, 217, 0 },
      { 85, 117, 167, 1 }, },
    { { 77, 210, 152, 0 },
      { 242, 17, 100, 1 },
      { 12, 165, 217, 0 },
      { 147, 68, 39, 1 }, },
    { { 77, 210, 155, 1 },
      { 250, 83, 100, 1 },
      { 236, 165, 217, 0 },
      { 147, 101, 47, 1 }, },
    { { 77, 210, 148, 1 },
      { 250, 17, 116, 0 },
      { 148, 165, 217, 0 },
      { 23, 68, 47, 1 }, },
    { { 77, 210, 151, 0 },
      { 242, 83, 116, 0 },
      { 116, 165, 217, 0 },
      { 23, 101, 39, 1 }, },
    { { 77, 210, 232, 0 },
      { 226, 149, 100, 1 },
      { 11, 165, 217, 0 },
      { 147, 84, 163, 1 }, },
    { { 77, 210, 235, 1 },
      { 234, 215, 100, 1 },
      { 235, 165, 217, 0 },
      { 147, 117, 171, 1 }, },
    { { 77, 210, 228, 1 },
      { 234, 149, 116, 0 },
      { 147, 165, 217, 0 },
      { 23, 84, 171, 1 }, },
    { { 77, 210, 231, 0 },
      { 226, 215, 116, 0 },
      { 115, 165, 217, 0 },
      { 23, 117, 163, 1 }, },
    { { 77, 221, 8, 0 },
      { 195, 25, 69, 1 },
      { 8, 93, 217, 0 },
      { 209, 76, 97, 1 }, },
    { { 77, 221, 11, 1 },
      { 203, 91, 69, 1 },
      { 232, 93, 217, 0 },
      { 209, 109, 105, 1 }, },
    { { 77, 221, 4, 1 },
      { 203, 25, 85, 0 },
      { 144, 93, 217, 0 },
      { 85, 76, 105, 1 }, },
    { { 77, 221, 7, 0 },
      { 195, 91, 85, 0 },
      { 112, 93, 217, 0 },
      { 85, 109, 97, 1 }, },
    { { 77, 221, 120, 0 },
      { 211, 157, 69, 1 },
      { 15, 93, 217, 0 },
      { 209, 92, 229, 1 }, },
    { { 77, 221, 123, 1 },
      { 219, 223, 69, 1 },
      { 239, 93, 217, 0 },
      { 209, 125, 237, 1 }, },
    { { 77, 221, 116, 1 },
      { 219, 157, 85, 0 },
      { 151, 93, 217, 0 },
      { 85, 92, 237, 1 }, },
    { { 77, 221, 119, 0 },
      { 211, 223, 85, 0 },
      { 119, 93, 217, 0 },
      { 85, 125, 229, 1 }, },
    { { 77, 220, 152, 0 },
      { 211, 25, 100, 1 },
      { 12, 157, 217, 0 },
      { 147, 76, 101, 1 }, },
    { { 77, 220, 155, 1 },
      { 219, 91, 100, 1 },
      { 236, 157, 217, 0 },
      { 147, 109, 109, 1 }, },
    { { 77, 220, 148, 1 },
      { 219, 25, 116, 0 },
      { 148, 157, 217, 0 },
      { 23, 76, 109, 1 }, },
    { { 77, 220, 151, 0 },
      { 211, 91, 116, 0 },
      { 116, 157, 217, 0 },
      { 23, 109, 101, 1 }, },
    { { 77, 220, 232, 0 },
      { 195, 157, 100, 1 },
      { 11, 157, 217, 0 },
      { 147, 92, 225, 1 }, },
    { { 77, 220, 235, 1 },
      { 203, 223, 100, 1 },
      { 235, 157, 217, 0 },
      { 147, 125, 233, 1 }, },
    { { 77, 220, 228, 1 },
      { 203, 157, 116, 0 },
      { 147, 157, 217, 0 },
      { 23, 92, 233, 1 }, },
    { { 77, 220, 231, 0 },
      { 195, 223, 116, 0 },
      { 115, 157, 217, 0 },
      { 23, 125, 225, 1 }, },
    { { 74, 97, 8, 0 },
      { 192, 1, 131, 1 },
      { 8, 67, 41, 0 },
      { 224, 192, 1, 1 }, },
    { { 74, 97, 11, 1 },
      { 200, 67, 131, 1 },
      { 232, 67, 41, 0 },
      { 224, 225, 9, 1 }, },
    { { 74, 97, 4, 1 },
      { 200, 1, 147, 0 },
      { 144, 67, 41, 0 },
      { 100, 192, 9, 1 }, },
    { { 74, 97, 7, 0 },
      { 192, 67, 147, 0 },
      { 112, 67, 41, 0 },
      { 100, 225, 1, 1 }, },
    { { 74, 97, 120, 0 },
      { 208, 133, 131, 1 },
      { 15, 67, 41, 0 },
      { 224, 208, 133, 1 }, },
    { { 74, 97, 123, 1 },
      { 216, 199, 131, 1 },
      { 239, 67, 41, 0 },
      { 224, 241, 141, 1 }, },
    { { 74, 97, 116, 1 },
      { 216, 133, 147, 0 },
      { 151, 67, 41, 0 },
      { 100, 208, 141, 1 }, },
    { { 74, 97, 119, 0 },
      { 208, 199, 147, 0 },
      { 119, 67, 41, 0 },
      { 100, 241, 133, 1 }, },
    { { 74, 96, 152, 0 },
      { 208, 1, 162, 1 },
      { 12, 131, 41, 0 },
      { 162, 192, 5, 1 }, },
    { { 74, 96, 155, 1 },
      { 216, 67, 162, 1 },
      { 236, 131, 41, 0 },
      { 162, 225, 13, 1 }, },
    { { 74, 96, 148, 1 },
      { 216, 1, 178, 0 },
      { 148, 131, 41, 0 },
      { 38, 192, 13, 1 }, },
    { { 74, 96, 151, 0 },
      { 208, 67, 178, 0 },
      { 116, 131, 41, 0 },
      { 38, 225, 5, 1 }, },
    { { 74, 96, 232, 0 },
      { 192, 133, 162, 1 },
      { 11, 131, 41, 0 },
      { 162, 208, 129, 1 }, },
    { { 74, 96, 235, 1 },
      { 200, 199, 162, 1 },
      { 235, 131, 41, 0 },
      { 162, 241, 137, 1 }, },
    { { 74, 96, 228, 1 },
      { 200, 133, 178, 0 },
      { 147, 131, 41, 0 },
      { 38, 208, 137, 1 }, },
    { { 74, 96, 231, 0 },
      { 192, 199, 178, 0 },
      { 115, 131, 41, 0 },
      { 38, 241, 129, 1 }, },
    { { 74, 111, 8, 0 },
      { 225, 9, 131, 1 },
      { 8, 123, 41, 0 },
      { 224, 200, 67, 1 }, },
    { { 74, 111, 11, 1 },
      { 233, 75, 131, 1 },
      { 232, 123, 41, 0 },
      { 224, 233, 75, 1 }, },
    { { 74, 111, 4, 1 },
      { 233, 9, 147, 0 },
      { 144, 123, 41, 0 },
      { 100, 200, 75, 1 }, },
    { { 74, 111, 7, 0 },
      { 225, 75, 147, 0 },
      { 112, 123, 41, 0 },
      { 100, 233, 67, 1 }, },
    { { 74, 111, 120, 0 },
      { 241, 141, 131, 1 },
      { 15, 123, 41, 0 },
      { 224, 216, 199, 1 }, },
    { { 74, 111, 123, 1 },
      { 249, 207, 131, 1 },
      { 239, 123, 41, 0 },
      { 224, 249, 207, 1 }, },
    { { 74, 111, 116, 1 },
      { 249, 141, 147, 0 },
      { 151, 123, 41, 0 },
      { 100, 216, 207, 1 }, },
    { { 74, 111, 119, 0 },
      { 241, 207, 147, 0 },
      { 119, 123, 41, 0 },
      { 100, 249, 199, 1 }, },
    { { 74, 110, 152, 0 },
      { 241, 9, 162, 1 },
      { 12, 187, 41, 0 },
      { 162, 200, 71, 1 }, },
    { { 74, 110, 155, 1 },
      { 249, 75, 162, 1 },
      { 236, 187, 41, 0 },
      { 162, 233, 79, 1 }, },
    { { 74, 110, 148, 1 },
      { 249, 9, 178, 0 },
      { 148, 187, 41, 0 },
      { 38, 200, 79, 1 }, },
    { { 74, 110, 151, 0 },
      { 241, 75, 178, 0 },
      { 116, 187, 41, 0 },
      { 38, 233, 71, 1 }, },
    { { 74, 110, 232, 0 },
      { 225, 141, 162, 1 },
      { 11, 187, 41, 0 },
      { 162, 216, 195, 1 }, },
    { { 74, 110, 235, 1 },
      { 233, 207, 162, 1 },
      { 235, 187, 41, 0 },
      { 162, 249, 203, 1 }, },
    { { 74, 110, 228, 1 },
      { 233, 141, 178, 0 },
      { 147, 187, 41, 0 },
      { 38, 216, 203, 1 }, },
    { { 74, 110, 231, 0 },
      { 225, 207, 178, 0 },
      { 115, 187, 41, 0 },
      { 38, 249, 195, 1 }, },
    { { 74, 83, 8, 0 },
      { 224, 1, 193, 1 },
      { 8, 101, 41, 0 },
      { 193, 192, 3, 1 }, },
    { { 74, 83, 11, 1 },
      { 232, 67, 193, 1 },
      { 232, 101, 41, 0 },
      { 193, 225, 11, 1 }, },
    { { 74, 83, 4, 1 },
      { 232, 1, 209, 0 },
      { 144, 101, 41, 0 },
      { 69, 192, 11, 1 }, },
    { { 74, 83, 7, 0 },
      { 224, 67, 209, 0 },
      { 112, 101, 41, 0 },
      { 69, 225, 3, 1 }, },
    { { 74, 83, 120, 0 },
      { 240, 133, 193, 1 },
      { 15, 101, 41, 0 },
      { 193, 208, 135, 1 }, },
    { { 74, 83, 123, 1 },
      { 248, 199, 193, 1 },
      { 239, 101, 41, 0 },
      { 193, 241, 143, 1 }, },
    { { 74, 83, 116, 1 },
      { 248, 133, 209, 0 },
      { 151, 101, 41, 0 },
      { 69, 208, 143, 1 }, },
    { { 74, 83, 119, 0 },
      { 240, 199, 209, 0 },
      { 119, 101, 41, 0 },
      { 69, 241, 135, 1 }, },
    { { 74, 82, 152, 0 },
      { 240, 1, 224, 1 },
      { 12, 165, 41, 0 },
      { 131, 192, 7, 1 }, },
    { { 74, 82, 155, 1 },
      { 248, 67, 224, 1 },
      { 236, 165, 41, 0 },
      { 131, 225, 15, 1 }, },
    { { 74, 82, 148, 1 },
      { 248, 1, 240, 0 },
      { 148, 165, 41, 0 },
      { 7, 192, 15, 1 }, },
    { { 74, 82, 151, 0 },
      { 240, 67, 240, 0 },
      { 116, 165, 41, 0 },
      { 7, 225, 7, 1 }, },
    { { 74, 82, 232, 0 },
      { 224, 133, 224, 1 },
      { 11, 165, 41, 0 },
      { 131, 208, 131, 1 }, },
    { { 74, 82, 235, 1 },
      { 232, 199, 224, 1 },
      { 235, 165, 41, 0 },
      { 131, 241, 139, 1 }, },
    { { 74, 82, 228, 1 },
      { 232, 133, 240, 0 },
      { 147, 165, 41, 0 },
      { 7, 208, 139, 1 }, },
    { { 74, 82, 231, 0 },
      { 224, 199, 240, 0 },
      { 115, 165, 41, 0 },
      { 7, 241, 131, 1 }, },
    { { 74, 93, 8, 0 },
      { 193, 9, 193, 1 },
      { 8, 93, 41, 0 },
      { 193, 200, 65, 1 }, },
    { { 74, 93, 11, 1 },
      { 201, 75, 193, 1 },
      { 232, 93, 41, 0 },
      { 193, 233, 73, 1 }, },
    { { 74, 93, 4, 1 },
      { 201, 9, 209, 0 },
      { 144, 93, 41, 0 },
      { 69, 200, 73, 1 }, },
    { { 74, 93, 7, 0 },
      { 193, 75, 209, 0 },
      { 112, 93, 41, 0 },
      { 69, 233, 65, 1 }, },
    { { 74, 93, 120, 0 },
      { 209, 141, 193, 1 },
      { 15, 93, 41, 0 },
      { 193, 216, 197, 1 }, },
    { { 74, 93, 123, 1 },
      { 217, 207, 193, 1 },
      { 239, 93, 41, 0 },
      { 193, 249, 205, 1 }, },
    { { 74, 93, 116, 1 },
      { 217, 141, 209, 0 },
      { 151, 93, 41, 0 },
      { 69, 216, 205, 1 }, },
    { { 74, 93, 119, 0 },
      { 209, 207, 209, 0 },
      { 119, 93, 41, 0 },
      { 69, 249, 197, 1 }, },
    { { 74, 92, 152, 0 },
      { 209, 9, 224, 1 },
      { 12, 157, 41, 0 },
      { 131, 200, 69, 1 }, },
    { { 74, 92, 155, 1 },
      { 217, 75, 224, 1 },
      { 236, 157, 41, 0 },
      { 131, 233, 77, 1 }, },
    { { 74, 92, 148, 1 },
      { 217, 9, 240, 0 },
      { 148, 157, 41, 0 },
      { 7, 200, 77, 1 }, },
    { { 74, 92, 151, 0 },
      { 209, 75, 240, 0 },
      { 116, 157, 41, 0 },
      { 7, 233, 69, 1 }, },
    { { 74, 92, 232, 0 },
      { 193, 141, 224, 1 },
      { 11, 157, 41, 0 },
      { 131, 216, 193, 1 }, },
    { { 74, 92, 235, 1 },
      { 201, 207, 224, 1 },
      { 235, 157, 41, 0 },
      { 131, 249, 201, 1 }, },
    { { 74, 92, 228, 1 },
      { 201, 141, 240, 0 },
      { 147, 157, 41, 0 },
      { 7, 216, 201, 1 }, },
    { { 74, 92, 231, 0 },
      { 193, 207, 240, 0 },
      { 115, 157, 41, 0 },
      { 7, 249, 193, 1 }, },
    { { 75, 161, 8, 0 },
      { 130, 17, 131, 1 },
      { 8, 66, 233, 0 },
      { 224, 196, 32, 1 }, },
    { { 75, 161, 11, 1 },
      { 138, 83, 131, 1 },
      { 232, 66, 233, 0 },
      { 224, 229, 40, 1 }, },
    { { 75, 161, 4, 1 },
      { 138, 17, 147, 0 },
      { 144, 66, 233, 0 },
      { 100, 196, 40, 1 }, },
    { { 75, 161, 7, 0 },
      { 130, 83, 147, 0 },
      { 112, 66, 233, 0 },
      { 100, 229, 32, 1 }, },
    { { 75, 161, 120, 0 },
      { 146, 149, 131, 1 },
      { 15, 66, 233, 0 },
      { 224, 212, 164, 1 }, },
    { { 75, 161, 123, 1 },
      { 154, 215, 131, 1 },
      { 239, 66, 233, 0 },
      { 224, 245, 172, 1 }, },
    { { 75, 161, 116, 1 },
      { 154, 149, 147, 0 },
      { 151, 66, 233, 0 },
      { 100, 212, 172, 1 }, },
    { { 75, 161, 119, 0 },
      { 146, 215, 147, 0 },
      { 119, 66, 233, 0 },
      { 100, 245, 164, 1 }, },
    { { 75, 160, 152, 0 },
      { 146, 17, 162, 1 },
      { 12, 130, 233, 0 },
      { 162, 196, 36, 1 }, },
    { { 75, 160, 155, 1 },
      { 154, 83, 162, 1 },
      { 236, 130, 233, 0 },
      { 162, 229, 44, 1 }, },
    { { 75, 160, 148, 1 },
      { 154, 17, 178, 0 },
      { 148, 130, 233, 0 },
      { 38, 196, 44, 1 }, },
    { { 75, 160, 151, 0 },
      { 146, 83, 178, 0 },
      { 116, 130, 233, 0 },
      { 38, 229, 36, 1 }, },
    { { 75, 160, 232, 0 },
      { 130, 149, 162, 1 },
      { 11, 130, 233, 0 },
      { 162, 212, 160, 1 }, },
    { { 75, 160, 235, 1 },
      { 138, 215, 162, 1 },
      { 235, 130, 233, 0 },
      { 162, 245, 168, 1 }, },
    { { 75, 160, 228, 1 },
      { 138, 149, 178, 0 },
      { 147, 130, 233, 0 },
      { 38, 212, 168, 1 }, },
    { { 75, 160, 231, 0 },
      { 130, 215, 178, 0 },
      { 115, 130, 233, 0 },
      { 38, 245, 160, 1 }, },
    { { 75, 175, 8, 0 },
      { 163, 25, 131, 1 },
      { 8, 122, 233, 0 },
      { 224, 204, 98, 1 }, },
    { { 75, 175, 11, 1 },
      { 171, 91, 131, 1 },
      { 232, 122, 233, 0 },
      { 224, 237, 106, 1 }, },
    { { 75, 175, 4, 1 },
      { 171, 25, 147, 0 },
      { 144, 122, 233, 0 },
      { 100, 204, 106, 1 }, },
    { { 75, 175, 7, 0 },
      { 163, 91, 147, 0 },
      { 112, 122, 233, 0 },
      { 100, 237, 98, 1 }, },
    { { 75, 175, 120, 0 },
      { 179, 157, 131, 1 },
      { 15, 122, 233, 0 },
      { 224, 220, 230, 1 }, },
    { { 75, 175, 123, 1 },
      { 187, 223, 131, 1 },
      { 239, 122, 233, 0 },
      { 224, 253, 238, 1 }, },
    { { 75, 175, 116, 1 },
      { 187, 157, 147, 0 },
      { 151, 122, 233, 0 },
      { 100, 220, 238, 1 }, },
    { { 75, 175, 119, 0 },
      { 179, 223, 147, 0 },
      { 119, 122, 233, 0 },
      { 100, 253, 230, 1 }, },
    { { 75, 174, 152, 0 },
      { 179, 25, 162, 1 },
      { 12, 186, 233, 0 },
      { 162, 204, 102, 1 }, },
    { { 75, 174, 155, 1 },
      { 187, 91, 162, 1 },
      { 236, 186, 233, 0 },
      { 162, 237, 110, 1 }, },
    { { 75, 174, 148, 1 },
      { 187, 25, 178, 0 },
      { 148, 186, 233, 0 },
      { 38, 204, 110, 1 }, },
    { { 75, 174, 151, 0 },
      { 179, 91, 178, 0 },
      { 116, 186, 233, 0 },
      { 38, 237, 102, 1 }, },
    { { 75, 174, 232, 0 },
      { 163, 157, 162, 1 },
      { 11, 186, 233, 0 },
      { 162, 220, 226, 1 }, },
    { { 75, 174, 235, 1 },
      { 171, 223, 162, 1 },
      { 235, 186, 233, 0 },
      { 162, 253, 234, 1 }, },
    { { 75, 174, 228, 1 },
      { 171, 157, 178, 0 },
      { 147, 186, 233, 0 },
      { 38, 220, 234, 1 }, },
    { { 75, 174, 231, 0 },
      { 163, 223, 178, 0 },
      { 115, 186, 233, 0 },
      { 38, 253, 226, 1 }, },
    { { 75, 147, 8, 0 },
      { 162, 17, 193, 1 },
      { 8, 100, 233, 0 },
      { 193, 196, 34, 1 }, },
    { { 75, 147, 11, 1 },
      { 170, 83, 193, 1 },
      { 232, 100, 233, 0 },
      { 193, 229, 42, 1 }, },
    { { 75, 147, 4, 1 },
      { 170, 17, 209, 0 },
      { 144, 100, 233, 0 },
      { 69, 196, 42, 1 }, },
    { { 75, 147, 7, 0 },
      { 162, 83, 209, 0 },
      { 112, 100, 233, 0 },
      { 69, 229, 34, 1 }, },
    { { 75, 147, 120, 0 },
      { 178, 149, 193, 1 },
      { 15, 100, 233, 0 },
      { 193, 212, 166, 1 }, },
    { { 75, 147, 123, 1 },
      { 186, 215, 193, 1 },
      { 239, 100, 233, 0 },
      { 193, 245, 174, 1 }, },
    { { 75, 147, 116, 1 },
      { 186, 149, 209, 0 },
      { 151, 100, 233, 0 },
      { 69, 212, 174, 1 }, },
    { { 75, 147, 119, 0 },
      { 178, 215, 209, 0 },
      { 119, 100, 233, 0 },
      { 69, 245, 166, 1 }, },
    { { 75, 146, 152, 0 },
      { 178, 17, 224, 1 },
      { 12, 164, 233, 0 },
      { 131, 196, 38, 1 }, },
    { { 75, 146, 155, 1 },
      { 186, 83, 224, 1 },
      { 236, 164, 233, 0 },
      { 131, 229, 46, 1 }, },
    { { 75, 146, 148, 1 },
      { 186, 17, 240, 0 },
      { 148, 164, 233, 0 },
      { 7, 196, 46, 1 }, },
    { { 75, 146, 151, 0 },
      { 178, 83, 240, 0 },
      { 116, 164, 233, 0 },
      { 7, 229, 38, 1 }, },
    { { 75, 146, 232, 0 },
      { 162, 149, 224, 1 },
      { 11, 164, 233, 0 },
      { 131, 212, 162, 1 }, },
    { { 75, 146, 235, 1 },
      { 170, 215, 224, 1 },
      { 235, 164, 233, 0 },
      { 131, 245, 170, 1 }, },
    { { 75, 146, 228, 1 },
      { 170, 149, 240, 0 },
      { 147, 164, 233, 0 },
      { 7, 212, 170, 1 }, },
    { { 75, 146, 231, 0 },
      { 162, 215, 240, 0 },
      { 115, 164, 233, 0 },
      { 7, 245, 162, 1 }, },
    { { 75, 157, 8, 0 },
      { 131, 25, 193, 1 },
      { 8, 92, 233, 0 },
      { 193, 204, 96, 1 }, },
    { { 75, 157, 11, 1 },
      { 139, 91, 193, 1 },
      { 232, 92, 233, 0 },
      { 193, 237, 104, 1 }, },
    { { 75, 157, 4, 1 },
      { 139, 25, 209, 0 },
      { 144, 92, 233, 0 },
      { 69, 204, 104, 1 }, },
    { { 75, 157, 7, 0 },
      { 131, 91, 209, 0 },
      { 112, 92, 233, 0 },
      { 69, 237, 96, 1 }, },
    { { 75, 157, 120, 0 },
      { 147, 157, 193, 1 },
      { 15, 92, 233, 0 },
      { 193, 220, 228, 1 }, },
    { { 75, 157, 123, 1 },
      { 155, 223, 193, 1 },
      { 239, 92, 233, 0 },
      { 193, 253, 236, 1 }, },
    { { 75, 157, 116, 1 },
      { 155, 157, 209, 0 },
      { 151, 92, 233, 0 },
      { 69, 220, 236, 1 }, },
    { { 75, 157, 119, 0 },
      { 147, 223, 209, 0 },
      { 119, 92, 233, 0 },
      { 69, 253, 228, 1 }, },
    { { 75, 156, 152, 0 },
      { 147, 25, 224, 1 },
      { 12, 156, 233, 0 },
      { 131, 204, 100, 1 }, },
    { { 75, 156, 155, 1 },
      { 155, 91, 224, 1 },
      { 236, 156, 233, 0 },
      { 131, 237, 108, 1 }, },
    { { 75, 156, 148, 1 },
      { 155, 25, 240, 0 },
      { 148, 156, 233, 0 },
      { 7, 204, 108, 1 }, },
    { { 75, 156, 151, 0 },
      { 147, 91, 240, 0 },
      { 116, 156, 233, 0 },
      { 7, 237, 100, 1 }, },
    { { 75, 156, 232, 0 },
      { 131, 157, 224, 1 },
      { 11, 156, 233, 0 },
      { 131, 220, 224, 1 }, },
    { { 75, 156, 235, 1 },
      { 139, 223, 224, 1 },
      { 235, 156, 233, 0 },
      { 131, 253, 232, 1 }, },
    { { 75, 156, 228, 1 },
      { 139, 157, 240, 0 },
      { 147, 156, 233, 0 },
      { 7, 220, 232, 1 }, },
    { { 75, 156, 231, 0 },
      { 131, 223, 240, 0 },
      { 115, 156, 233, 0 },
      { 7, 253, 224, 1 }, },
    { { 116, 33, 8, 0 },
      { 4, 33, 7, 1 },
      { 8, 66, 23, 0 },
      { 240, 66, 16, 0 }, },
    { { 116, 33, 11, 1 },
      { 12, 99, 7, 1 },
      { 232, 66, 23, 0 },
      { 240, 99, 24, 0 }, },
    { { 116, 33, 4, 1 },
      { 12, 33, 23, 0 },
      { 144, 66, 23, 0 },
      { 116, 66, 24, 0 }, },
    { { 116, 33, 7, 0 },
      { 4, 99, 23, 0 },
      { 112, 66, 23, 0 },
      { 116, 99, 16, 0 }, },
    { { 116, 33, 120, 0 },
      { 20, 165, 7, 1 },
      { 15, 66, 23, 0 },
      { 240, 82, 148, 0 }, },
    { { 116, 33, 123, 1 },
      { 28, 231, 7, 1 },
      { 239, 66, 23, 0 },
      { 240, 115, 156, 0 }, },
    { { 116, 33, 116, 1 },
      { 28, 165, 23, 0 },
      { 151, 66, 23, 0 },
      { 116, 82, 156, 0 }, },
    { { 116, 33, 119, 0 },
      { 20, 231, 23, 0 },
      { 119, 66, 23, 0 },
      { 116, 115, 148, 0 }, },
    { { 116, 32, 152, 0 },
      { 20, 33, 38, 1 },
      { 12, 130, 23, 0 },
      { 178, 66, 20, 0 }, },
    { { 116, 32, 155, 1 },
      { 28, 99, 38, 1 },
      { 236, 130, 23, 0 },
      { 178, 99, 28, 0 }, },
    { { 116, 32, 148, 1 },
      { 28, 33, 54, 0 },
      { 148, 130, 23, 0 },
      { 54, 66, 28, 0 }, },
    { { 116, 32, 151, 0 },
      { 20, 99, 54, 0 },
      { 116, 130, 23, 0 },
      { 54, 99, 20, 0 }, },
    { { 116, 32, 232, 0 },
      { 4, 165, 38, 1 },
      { 11, 130, 23, 0 },
      { 178, 82, 144, 0 }, },
    { { 116, 32, 235, 1 },
      { 12, 231, 38, 1 },
      { 235, 130, 23, 0 },
      { 178, 115, 152, 0 }, },
    { { 116, 32, 228, 1 },
      { 12, 165, 54, 0 },
      { 147, 130, 23, 0 },
      { 54, 82, 152, 0 }, },
    { { 116, 32, 231, 0 },
      { 4, 231, 54, 0 },
      { 115, 130, 23, 0 },
      { 54, 115, 144, 0 }, },
    { { 116, 47, 8, 0 },
      { 37, 41, 7, 1 },
      { 8, 122, 23, 0 },
      { 240, 74, 82, 0 }, },
    { { 116, 47, 11, 1 },
      { 45, 107, 7, 1 },
      { 232, 122, 23, 0 },
      { 240, 107, 90, 0 }, },
    { { 116, 47, 4, 1 },
      { 45, 41, 23, 0 },
      { 144, 122, 23, 0 },
      { 116, 74, 90, 0 }, },
    { { 116, 47, 7, 0 },
      { 37, 107, 23, 0 },
      { 112, 122, 23, 0 },
      { 116, 107, 82, 0 }, },
    { { 116, 47, 120, 0 },
      { 53, 173, 7, 1 },
      { 15, 122, 23, 0 },
      { 240, 90, 214, 0 }, },
    { { 116, 47, 123, 1 },
      { 61, 239, 7, 1 },
      { 239, 122, 23, 0 },
      { 240, 123, 222, 0 }, },
    { { 116, 47, 116, 1 },
      { 61, 173, 23, 0 },
      { 151, 122, 23, 0 },
      { 116, 90, 222, 0 }, },
    { { 116, 47, 119, 0 },
      { 53, 239, 23, 0 },
      { 119, 122, 23, 0 },
      { 116, 123, 214, 0 }, },
    { { 116, 46, 152, 0 },
      { 53, 41, 38, 1 },
      { 12, 186, 23, 0 },
      { 178, 74, 86, 0 }, },
    { { 116, 46, 155, 1 },
      { 61, 107, 38, 1 },
      { 236, 186, 23, 0 },
      { 178, 107, 94, 0 }, },
    { { 116, 46, 148, 1 },
      { 61, 41, 54, 0 },
      { 148, 186, 23, 0 },
      { 54, 74, 94, 0 }, },
    { { 116, 46, 151, 0 },
      { 53, 107, 54, 0 },
      { 116, 186, 23, 0 },
      { 54, 107, 86, 0 }, },
    { { 116, 46, 232, 0 },
      { 37, 173, 38, 1 },
      { 11, 186, 23, 0 },
      { 178, 90, 210, 0 }, },
    { { 116, 46, 235, 1 },
      { 45, 239, 38, 1 },
      { 235, 186, 23, 0 },
      { 178, 123, 218, 0 }, },
    { { 116, 46, 228, 1 },
      { 45, 173, 54, 0 },
      { 147, 186, 23, 0 },
      { 54, 90, 218, 0 }, },
    { { 116, 46, 231, 0 },
      { 37, 239, 54, 0 },
      { 115, 186, 23, 0 },
      { 54, 123, 210, 0 }, },
    { { 116, 19, 8, 0 },
      { 36, 33, 69, 1 },
      { 8, 100, 23, 0 },
      { 209, 66, 18, 0 }, },
    { { 116, 19, 11, 1 },
      { 44, 99, 69, 1 },
      { 232, 100, 23, 0 },
      { 209, 99, 26, 0 }, },
    { { 116, 19, 4, 1 },
      { 44, 33, 85, 0 },
      { 144, 100, 23, 0 },
      { 85, 66, 26, 0 }, },
    { { 116, 19, 7, 0 },
      { 36, 99, 85, 0 },
      { 112, 100, 23, 0 },
      { 85, 99, 18, 0 }, },
    { { 116, 19, 120, 0 },
      { 52, 165, 69, 1 },
      { 15, 100, 23, 0 },
      { 209, 82, 150, 0 }, },
    { { 116, 19, 123, 1 },
      { 60, 231, 69, 1 },
      { 239, 100, 23, 0 },
      { 209, 115, 158, 0 }, },
    { { 116, 19, 116, 1 },
      { 60, 165, 85, 0 },
      { 151, 100, 23, 0 },
      { 85, 82, 158, 0 }, },
    { { 116, 19, 119, 0 },
      { 52, 231, 85, 0 },
      { 119, 100, 23, 0 },
      { 85, 115, 150, 0 }, },
    { { 116, 18, 152, 0 },
      { 52, 33, 100, 1 },
      { 12, 164, 23, 0 },
      { 147, 66, 22, 0 }, },
    { { 116, 18, 155, 1 },
      { 60, 99, 100, 1 },
      { 236, 164, 23, 0 },
      { 147, 99, 30, 0 }, },
    { { 116, 18, 148, 1 },
      { 60, 33, 116, 0 },
      { 148, 164, 23, 0 },
      { 23, 66, 30, 0 }, },
    { { 116, 18, 151, 0 },
      { 52, 99, 116, 0 },
      { 116, 164, 23, 0 },
      { 23, 99, 22, 0 }, },
    { { 116, 18, 232, 0 },
      { 36, 165, 100, 1 },
      { 11, 164, 23, 0 },
      { 147, 82, 146, 0 }, },
    { { 116, 18, 235, 1 },
      { 44, 231, 100, 1 },
      { 235, 164, 23, 0 },
      { 147, 115, 154, 0 }, },
    { { 116, 18, 228, 1 },
      { 44, 165, 116, 0 },
      { 147, 164, 23, 0 },
      { 23, 82, 154, 0 }, },
    { { 116, 18, 231, 0 },
      { 36, 231, 116, 0 },
      { 115, 164, 23, 0 },
      { 23, 115, 146, 0 }, },
    { { 116, 29, 8, 0 },
      { 5, 41, 69, 1 },
      { 8, 92, 23, 0 },
      { 209, 74, 80, 0 }, },
    { { 116, 29, 11, 1 },
      { 13, 107, 69, 1 },
      { 232, 92, 23, 0 },
      { 209, 107, 88, 0 }, },
    { { 116, 29, 4, 1 },
      { 13, 41, 85, 0 },
      { 144, 92, 23, 0 },
      { 85, 74, 88, 0 }, },
    { { 116, 29, 7, 0 },
      { 5, 107, 85, 0 },
      { 112, 92, 23, 0 },
      { 85, 107, 80, 0 }, },
    { { 116, 29, 120, 0 },
      { 21, 173, 69, 1 },
      { 15, 92, 23, 0 },
      { 209, 90, 212, 0 }, },
    { { 116, 29, 123, 1 },
      { 29, 239, 69, 1 },
      { 239, 92, 23, 0 },
      { 209, 123, 220, 0 }, },
    { { 116, 29, 116, 1 },
      { 29, 173, 85, 0 },
      { 151, 92, 23, 0 },
      { 85, 90, 220, 0 }, },
    { { 116, 29, 119, 0 },
      { 21, 239, 85, 0 },
      { 119, 92, 23, 0 },
      { 85, 123, 212, 0 }, },
    { { 116, 28, 152, 0 },
      { 21, 41, 100, 1 },
      { 12, 156, 23, 0 },
      { 147, 74, 84, 0 }, },
    { { 116, 28, 155, 1 },
      { 29, 107, 100, 1 },
      { 236, 156, 23, 0 },
      { 147, 107, 92, 0 }, },
    { { 116, 28, 148, 1 },
      { 29, 41, 116, 0 },
      { 148, 156, 23, 0 },
      { 23, 74, 92, 0 }, },
    { { 116, 28, 151, 0 },
      { 21, 107, 116, 0 },
      { 116, 156, 23, 0 },
      { 23, 107, 84, 0 }, },
    { { 116, 28, 232, 0 },
      { 5, 173, 100, 1 },
      { 11, 156, 23, 0 },
      { 147, 90, 208, 0 }, },
    { { 116, 28, 235, 1 },
      { 13, 239, 100, 1 },
      { 235, 156, 23, 0 },
      { 147, 123, 216, 0 }, },
    { { 116, 28, 228, 1 },
      { 13, 173, 116, 0 },
      { 147, 156, 23, 0 },
      { 23, 90, 216, 0 }, },
    { { 116, 28, 231, 0 },
      { 5, 239, 116, 0 },
      { 115, 156, 23, 0 },
      { 23, 123, 208, 0 }, },
    { { 117, 225, 8, 0 },
      { 70, 49, 7, 1 },
      { 8, 67, 215, 0 },
      { 240, 70, 49, 0 }, },
    { { 117, 225, 11, 1 },
      { 78, 115, 7, 1 },
      { 232, 67, 215, 0 },
      { 240, 103, 57, 0 }, },
    { { 117, 225, 4, 1 },
      { 78, 49, 23, 0 },
      { 144, 67, 215, 0 },
      { 116, 70, 57, 0 }, },
    { { 117, 225, 7, 0 },
      { 70, 115, 23, 0 },
      { 112, 67, 215, 0 },
      { 116, 103, 49, 0 }, },
    { { 117, 225, 120, 0 },
      { 86, 181, 7, 1 },
      { 15, 67, 215, 0 },
      { 240, 86, 181, 0 }, },
    { { 117, 225, 123, 1 },
      { 94, 247, 7, 1 },
      { 239, 67, 215, 0 },
      { 240, 119, 189, 0 }, },
    { { 117, 225, 116, 1 },
      { 94, 181, 23, 0 },
      { 151, 67, 215, 0 },
      { 116, 86, 189, 0 }, },
    { { 117, 225, 119, 0 },
      { 86, 247, 23, 0 },
      { 119, 67, 215, 0 },
      { 116, 119, 181, 0 }, },
    { { 117, 224, 152, 0 },
      { 86, 49, 38, 1 },
      { 12, 131, 215, 0 },
      { 178, 70, 53, 0 }, },
    { { 117, 224, 155, 1 },
      { 94, 115, 38, 1 },
      { 236, 131, 215, 0 },
      { 178, 103, 61, 0 }, },
    { { 117, 224, 148, 1 },
      { 94, 49, 54, 0 },
      { 148, 131, 215, 0 },
      { 54, 70, 61, 0 }, },
    { { 117, 224, 151, 0 },
      { 86, 115, 54, 0 },
      { 116, 131, 215, 0 },
      { 54, 103, 53, 0 }, },
    { { 117, 224, 232, 0 },
      { 70, 181, 38, 1 },
      { 11, 131, 215, 0 },
      { 178, 86, 177, 0 }, },
    { { 117, 224, 235, 1 },
      { 78, 247, 38, 1 },
      { 235, 131, 215, 0 },
      { 178, 119, 185, 0 }, },
    { { 117, 224, 228, 1 },
      { 78, 181, 54, 0 },
      { 147, 131, 215, 0 },
      { 54, 86, 185, 0 }, },
    { { 117, 224, 231, 0 },
      { 70, 247, 54, 0 },
      { 115, 131, 215, 0 },
      { 54, 119, 177, 0 }, },
    { { 117, 239, 8, 0 },
      { 103, 57, 7, 1 },
      { 8, 123, 215, 0 },
      { 240, 78, 115, 0 }, },
    { { 117, 239, 11, 1 },
      { 111, 123, 7, 1 },
      { 232, 123, 215, 0 },
      { 240, 111, 123, 0 }, },
    { { 117, 239, 4, 1 },
      { 111, 57, 23, 0 },
      { 144, 123, 215, 0 },
      { 116, 78, 123, 0 }, },
    { { 117, 239, 7, 0 },
      { 103, 123, 23, 0 },
      { 112, 123, 215, 0 },
      { 116, 111, 115, 0 }, },
    { { 117, 239, 120, 0 },
      { 119, 189, 7, 1 },
      { 15, 123, 215, 0 },
      { 240, 94, 247, 0 }, },
    { { 117, 239, 123, 1 },
      { 127, 255, 7, 1 },
      { 239, 123, 215, 0 },
      { 240, 127, 255, 0 }, },
    { { 117, 239, 116, 1 },
      { 127, 189, 23, 0 },
      { 151, 123, 215, 0 },
      { 116, 94, 255, 0 }, },
    { { 117, 239, 119, 0 },
      { 119, 255, 23, 0 },
      { 119, 123, 215, 0 },
      { 116, 127, 247, 0 }, },
    { { 117, 238, 152, 0 },
      { 119, 57, 38, 1 },
      { 12, 187, 215, 0 },
      { 178, 78, 119, 0 }, },
    { { 117, 238, 155, 1 },
      { 127, 123, 38, 1 },
      { 236, 187, 215, 0 },
      { 178, 111, 127, 0 }, },
    { { 117, 238, 148, 1 },
      { 127, 57, 54, 0 },
      { 148, 187, 215, 0 },
      { 54, 78, 127, 0 }, },
    { { 117, 238, 151, 0 },
      { 119, 123, 54, 0 },
      { 116, 187, 215, 0 },
      { 54, 111, 119, 0 }, },
    { { 117, 238, 232, 0 },
      { 103, 189, 38, 1 },
      { 11, 187, 215, 0 },
      { 178, 94, 243, 0 }, },
    { { 117, 238, 235, 1 },
      { 111, 255, 38, 1 },
      { 235, 187, 215, 0 },
      { 178, 127, 251, 0 }, },
    { { 117, 238, 228, 1 },
      { 111, 189, 54, 0 },
      { 147, 187, 215, 0 },
      { 54, 94, 251, 0 }, },
    { { 117, 238, 231, 0 },
      { 103, 255, 54, 0 },
      { 115, 187, 215, 0 },
      { 54, 127, 243, 0 }, },
    { { 117, 211, 8, 0 },
      { 102, 49, 69, 1 },
      { 8, 101, 215, 0 },
      { 209, 70, 51, 0 }, },
    { { 117, 211, 11, 1 },
      { 110, 115, 69, 1 },
      { 232, 101, 215, 0 },
      { 209, 103, 59, 0 }, },
    { { 117, 211, 4, 1 },
      { 110, 49, 85, 0 },
      { 144, 101, 215, 0 },
      { 85, 70, 59, 0 }, },
    { { 117, 211, 7, 0 },
      { 102, 115, 85, 0 },
      { 112, 101, 215, 0 },
      { 85, 103, 51, 0 }, },
    { { 117, 211, 120, 0 },
      { 118, 181, 69, 1 },
      { 15, 101, 215, 0 },
      { 209, 86, 183, 0 }, },
    { { 117, 211, 123, 1 },
      { 126, 247, 69, 1 },
      { 239, 101, 215, 0 },
      { 209, 119, 191, 0 }, },
    { { 117, 211, 116, 1 },
      { 126, 181, 85, 0 },
      { 151, 101, 215, 0 },
      { 85, 86, 191, 0 }, },
    { { 117, 211, 119, 0 },
      { 118, 247, 85, 0 },
      { 119, 101, 215, 0 },
      { 85, 119, 183, 0 }, },
    { { 117, 210, 152, 0 },
      { 118, 49, 100, 1 },
      { 12, 165, 215, 0 },
      { 147, 70, 55, 0 }, },
    { { 117, 210, 155, 1 },
      { 126, 115, 100, 1 },
      { 236, 165, 215, 0 },
      { 147, 103, 63, 0 }, },
    { { 117, 210, 148, 1 },
      { 126, 49, 116, 0 },
      { 148, 165, 215, 0 },
      { 23, 70, 63, 0 }, },
    { { 117, 210, 151, 0 },
      { 118, 115, 116, 0 },
      { 116, 165, 215, 0 },
      { 23, 103, 55, 0 }, },
    { { 117, 210, 232, 0 },
      { 102, 181, 100, 1 },
      { 11, 165, 215, 0 },
      { 147, 86, 179, 0 }, },
    { { 117, 210, 235, 1 },
      { 110, 247, 100, 1 },
      { 235, 165, 215, 0 },
      { 147, 119, 187, 0 }, },
    { { 117, 210, 228, 1 },
      { 110, 181, 116, 0 },
      { 147, 165, 215, 0 },
      { 23, 86, 187, 0 }, },
    { { 117, 210, 231, 0 },
      { 102, 247, 116, 0 },
      { 115, 165, 215, 0 },
      { 23, 119, 179, 0 }, },
    { { 117, 221, 8, 0 },
      { 71, 57, 69, 1 },
      { 8, 93, 215, 0 },
      { 209, 78, 113, 0 }, },
    { { 117, 221, 11, 1 },
      { 79, 123, 69, 1 },
      { 232, 93, 215, 0 },
      { 209, 111, 121, 0 }, },
    { { 117, 221, 4, 1 },
      { 79, 57, 85, 0 },
      { 144, 93, 215, 0 },
      { 85, 78, 121, 0 }, },
    { { 117, 221, 7, 0 },
      { 71, 123, 85, 0 },
      { 112, 93, 215, 0 },
      { 85, 111, 113, 0 }, },
    { { 117, 221, 120, 0 },
      { 87, 189, 69, 1 },
      { 15, 93, 215, 0 },
      { 209, 94, 245, 0 }, },
    { { 117, 221, 123, 1 },
      { 95, 255, 69, 1 },
      { 239, 93, 215, 0 },
      { 209, 127, 253, 0 }, },
    { { 117, 221, 116, 1 },
      { 95, 189, 85, 0 },
      { 151, 93, 215, 0 },
      { 85, 94, 253, 0 }, },
    { { 117, 221, 119, 0 },
      { 87, 255, 85, 0 },
      { 119, 93, 215, 0 },
      { 85, 127, 245, 0 }, },
    { { 117, 220, 152, 0 },
      { 87, 57, 100, 1 },
      { 12, 157, 215, 0 },
      { 147, 78, 117, 0 }, },
    { { 117, 220, 155, 1 },
      { 95, 123, 100, 1 },
      { 236, 157, 215, 0 },
      { 147, 111, 125, 0 }, },
    { { 117, 220, 148, 1 },
      { 95, 57, 116, 0 },
      { 148, 157, 215, 0 },
      { 23, 78, 125, 0 }, },
    { { 117, 220, 151, 0 },
      { 87, 123, 116, 0 },
      { 116, 157, 215, 0 },
      { 23, 111, 117, 0 }, },
    { { 117, 220, 232, 0 },
      { 71, 189, 100, 1 },
      { 11, 157, 215, 0 },
      { 147, 94, 241, 0 }, },
    { { 117, 220, 235, 1 },
      { 79, 255, 100, 1 },
      { 235, 157, 215, 0 },
      { 147, 127, 249, 0 }, },
    { { 117, 220, 228, 1 },
      { 79, 189, 116, 0 },
      { 147, 157, 215, 0 },
      { 23, 94, 249, 0 }, },
    { { 117, 220, 231, 0 },
      { 71, 255, 116, 0 },
      { 115, 157, 215, 0 },
      { 23, 127, 241, 0 }, },
    { { 114, 97, 8, 0 },
      { 68, 33, 131, 1 },
      { 8, 67, 39, 0 },
      { 224, 194, 17, 0 }, },
    { { 114, 97, 11, 1 },
      { 76, 99, 131, 1 },
      { 232, 67, 39, 0 },
      { 224, 227, 25, 0 }, },
    { { 114, 97, 4, 1 },
      { 76, 33, 147, 0 },
      { 144, 67, 39, 0 },
      { 100, 194, 25, 0 }, },
    { { 114, 97, 7, 0 },
      { 68, 99, 147, 0 },
      { 112, 67, 39, 0 },
      { 100, 227, 17, 0 }, },
    { { 114, 97, 120, 0 },
      { 84, 165, 131, 1 },
      { 15, 67, 39, 0 },
      { 224, 210, 149, 0 }, },
    { { 114, 97, 123, 1 },
      { 92, 231, 131, 1 },
      { 239, 67, 39, 0 },
      { 224, 243, 157, 0 }, },
    { { 114, 97, 116, 1 },
      { 92, 165, 147, 0 },
      { 151, 67, 39, 0 },
      { 100, 210, 157, 0 }, },
    { { 114, 97, 119, 0 },
      { 84, 231, 147, 0 },
      { 119, 67, 39, 0 },
      { 100, 243, 149, 0 }, },
    { { 114, 96, 152, 0 },
      { 84, 33, 162, 1 },
      { 12, 131, 39, 0 },
      { 162, 194, 21, 0 }, },
    { { 114, 96, 155, 1 },
      { 92, 99, 162, 1 },
      { 236, 131, 39, 0 },
      { 162, 227, 29, 0 }, },
    { { 114, 96, 148, 1 },
      { 92, 33, 178, 0 },
      { 148, 131, 39, 0 },
      { 38, 194, 29, 0 }, },
    { { 114, 96, 151, 0 },
      { 84, 99, 178, 0 },
      { 116, 131, 39, 0 },
      { 38, 227, 21, 0 }, },
    { { 114, 96, 232, 0 },
      { 68, 165, 162, 1 },
      { 11, 131, 39, 0 },
      { 162, 210, 145, 0 }, },
    { { 114, 96, 235, 1 },
      { 76, 231, 162, 1 },
      { 235, 131, 39, 0 },
      { 162, 243, 153, 0 }, },
    { { 114, 96, 228, 1 },
      { 76, 165, 178, 0 },
      { 147, 131, 39, 0 },
      { 38, 210, 153, 0 }, },
    { { 114, 96, 231, 0 },
      { 68, 231, 178, 0 },
      { 115, 131, 39, 0 },
      { 38, 243, 145, 0 }, },
    { { 114, 111, 8, 0 },
      { 101, 41, 131, 1 },
      { 8, 123, 39, 0 },
      { 224, 202, 83, 0 }, },
    { { 114, 111, 11, 1 },
      { 109, 107, 131, 1 },
      { 232, 123, 39, 0 },
      { 224, 235, 91, 0 }, },
    { { 114, 111, 4, 1 },
      { 109, 41, 147, 0 },
      { 144, 123, 39, 0 },
      { 100, 202, 91, 0 }, },
    { { 114, 111, 7, 0 },
      { 101, 107, 147, 0 },
      { 112, 123, 39, 0 },
      { 100, 235, 83, 0 }, },
    { { 114, 111, 120, 0 },
      { 117, 173, 131, 1 },
      { 15, 123, 39, 0 },
      { 224, 218, 215, 0 }, },
    { { 114, 111, 123, 1 },
      { 125, 239, 131, 1 },
      { 239, 123, 39, 0 },
      { 224, 251, 223, 0 }, },
    { { 114, 111, 116, 1 },
      { 125, 173, 147, 0 },
      { 151, 123, 39, 0 },
      { 100, 218, 223, 0 }, },
    { { 114, 111, 119, 0 },
      { 117, 239, 147, 0 },
      { 119, 123, 39, 0 },
      { 100, 251, 215, 0 }, },
    { { 114, 110, 152, 0 },
      { 117, 41, 162, 1 },
      { 12, 187, 39, 0 },
      { 162, 202, 87, 0 }, },
    { { 114, 110, 155, 1 },
      { 125, 107, 162, 1 },
      { 236, 187, 39, 0 },
      { 162, 235, 95, 0 }, },
    { { 114, 110, 148, 1 },
      { 125, 41, 178, 0 },
      { 148, 187, 39, 0 },
      { 38, 202, 95, 0 }, },
    { { 114, 110, 151, 0 },
      { 117, 107, 178, 0 },
      { 116, 187, 39, 0 },
      { 38, 235, 87, 0 }, },
    { { 114, 110, 232, 0 },
      { 101, 173, 162, 1 },
      { 11, 187, 39, 0 },
      { 162, 218, 211, 0 }, },
    { { 114, 110, 235, 1 },
      { 109, 239, 162, 1 },
      { 235, 187, 39, 0 },
      { 162, 251, 219, 0 }, },
    { { 114, 110, 228, 1 },
      { 109, 173, 178, 0 },
      { 147, 187, 39, 0 },
      { 38, 218, 219, 0 }, },
    { { 114, 110, 231, 0 },
      { 101, 239, 178, 0 },
      { 115, 187, 39, 0 },
      { 38, 251, 211, 0 }, },
    { { 114, 83, 8, 0 },
      { 100, 33, 193, 1 },
      { 8, 101, 39, 0 },
      { 193, 194, 19, 0 }, },
    { { 114, 83, 11, 1 },
      { 108, 99, 193, 1 },
      { 232, 101, 39, 0 },
      { 193, 227, 27, 0 }, },
    { { 114, 83, 4, 1 },
      { 108, 33, 209, 0 },
      { 144, 101, 39, 0 },
      { 69, 194, 27, 0 }, },
    { { 114, 83, 7, 0 },
      { 100, 99, 209, 0 },
      { 112, 101, 39, 0 },
      { 69, 227, 19, 0 }, },
    { { 114, 83, 120, 0 },
      { 116, 165, 193, 1 },
      { 15, 101, 39, 0 },
      { 193, 210, 151, 0 }, },
    { { 114, 83, 123, 1 },
      { 124, 231, 193, 1 },
      { 239, 101, 39, 0 },
      { 193, 243, 159, 0 }, },
    { { 114, 83, 116, 1 },
      { 124, 165, 209, 0 },
      { 151, 101, 39, 0 },
      { 69, 210, 159, 0 }, },
    { { 114, 83, 119, 0 },
      { 116, 231, 209, 0 },
      { 119, 101, 39, 0 },
      { 69, 243, 151, 0 }, },
    { { 114, 82, 152, 0 },
      { 116, 33, 224, 1 },
      { 12, 165, 39, 0 },
      { 131, 194, 23, 0 }, },
    { { 114, 82, 155, 1 },
      { 124, 99, 224, 1 },
      { 236, 165, 39, 0 },
      { 131, 227, 31, 0 }, },
    { { 114, 82, 148, 1 },
      { 124, 33, 240, 0 },
      { 148, 165, 39, 0 },
      { 7, 194, 31, 0 }, },
    { { 114, 82, 151, 0 },
      { 116, 99, 240, 0 },
      { 116, 165, 39, 0 },
      { 7, 227, 23, 0 }, },
    { { 114, 82, 232, 0 },
      { 100, 165, 224, 1 },
      { 11, 165, 39, 0 },
      { 131, 210, 147, 0 }, },
    { { 114, 82, 235, 1 },
      { 108, 231, 224, 1 },
      { 235, 165, 39, 0 },
      { 131, 243, 155, 0 }, },
    { { 114, 82, 228, 1 },
      { 108, 165, 240, 0 },
      { 147, 165, 39, 0 },
      { 7, 210, 155, 0 }, },
    { { 114, 82, 231, 0 },
      { 100, 231, 240, 0 },
      { 115, 165, 39, 0 },
      { 7, 243, 147, 0 }, },
    { { 114, 93, 8, 0 },
      { 69, 41, 193, 1 },
      { 8, 93, 39, 0 },
      { 193, 202, 81, 0 }, },
    { { 114, 93, 11, 1 },
      { 77, 107, 193, 1 },
      { 232, 93, 39, 0 },
      { 193, 235, 89, 0 }, },
    { { 114, 93, 4, 1 },
      { 77, 41, 209, 0 },
      { 144, 93, 39, 0 },
      { 69, 202, 89, 0 }, },
    { { 114, 93, 7, 0 },
      { 69, 107, 209, 0 },
      { 112, 93, 39, 0 },
      { 69, 235, 81, 0 }, },
    { { 114, 93, 120, 0 },
      { 85, 173, 193, 1 },
      { 15, 93, 39, 0 },
      { 193, 218, 213, 0 }, },
    { { 114, 93, 123, 1 },
      { 93, 239, 193, 1 },
      { 239, 93, 39, 0 },
      { 193, 251, 221, 0 }, },
    { { 114, 93, 116, 1 },
      { 93, 173, 209, 0 },
      { 151, 93, 39, 0 },
      { 69, 218, 221, 0 }, },
    { { 114, 93, 119, 0 },
      { 85, 239, 209, 0 },
      { 119, 93, 39, 0 },
      { 69, 251, 213, 0 }, },
    { { 114, 92, 152, 0 },
      { 85, 41, 224, 1 },
      { 12, 157, 39, 0 },
      { 131, 202, 85, 0 }, },
    { { 114, 92, 155, 1 },
      { 93, 107, 224, 1 },
      { 236, 157, 39, 0 },
      { 131, 235, 93, 0 }, },
    { { 114, 92, 148, 1 },
      { 93, 41, 240, 0 },
      { 148, 157, 39, 0 },
      { 7, 202, 93, 0 }, },
    { { 114, 92, 151, 0 },
      { 85, 107, 240, 0 },
      { 116, 157, 39, 0 },
      { 7, 235, 85, 0 }, },
    { { 114, 92, 232, 0 },
      { 69, 173, 224, 1 },
      { 11, 157, 39, 0 },
      { 131, 218, 209, 0 }, },
    { { 114, 92, 235, 1 },
      { 77, 239, 224, 1 },
      { 235, 157, 39, 0 },
      { 131, 251, 217, 0 }, },
    { { 114, 92, 228, 1 },
      { 77, 173, 240, 0 },
      { 147, 157, 39, 0 },
      { 7, 218, 217, 0 }, },
    { { 114, 92, 231, 0 },
      { 69, 239, 240, 0 },
      { 115, 157, 39, 0 },
      { 7, 251, 209, 0 }, },
    { { 115, 161, 8, 0 },
      { 6, 49, 131, 1 },
      { 8, 66, 231, 0 },
      { 224, 198, 48, 0 }, },
    { { 115, 161, 11, 1 },
      { 14, 115, 131, 1 },
      { 232, 66, 231, 0 },
      { 224, 231, 56, 0 }, },
    { { 115, 161, 4, 1 },
      { 14, 49, 147, 0 },
      { 144, 66, 231, 0 },
      { 100, 198, 56, 0 }, },
    { { 115, 161, 7, 0 },
      { 6, 115, 147, 0 },
      { 112, 66, 231, 0 },
      { 100, 231, 48, 0 }, },
    { { 115, 161, 120, 0 },
      { 22, 181, 131, 1 },
      { 15, 66, 231, 0 },
      { 224, 214, 180, 0 }, },
    { { 115, 161, 123, 1 },
      { 30, 247, 131, 1 },
      { 239, 66, 231, 0 },
      { 224, 247, 188, 0 }, },
    { { 115, 161, 116, 1 },
      { 30, 181, 147, 0 },
      { 151, 66, 231, 0 },
      { 100, 214, 188, 0 }, },
    { { 115, 161, 119, 0 },
      { 22, 247, 147, 0 },
      { 119, 66, 231, 0 },
      { 100, 247, 180, 0 }, },
    { { 115, 160, 152, 0 },
      { 22, 49, 162, 1 },
      { 12, 130, 231, 0 },
      { 162, 198, 52, 0 }, },
    { { 115, 160, 155, 1 },
      { 30, 115, 162, 1 },
      { 236, 130, 231, 0 },
      { 162, 231, 60, 0 }, },
    { { 115, 160, 148, 1 },
      { 30, 49, 178, 0 },
      { 148, 130, 231, 0 },
      { 38, 198, 60, 0 }, },
    { { 115, 160, 151, 0 },
      { 22, 115, 178, 0 },
      { 116, 130, 231, 0 },
      { 38, 231, 52, 0 }, },
    { { 115, 160, 232, 0 },
      { 6, 181, 162, 1 },
      { 11, 130, 231, 0 },
      { 162, 214, 176, 0 }, },
    { { 115, 160, 235, 1 },
      { 14, 247, 162, 1 },
      { 235, 130, 231, 0 },
      { 162, 247, 184, 0 }, },
    { { 115, 160, 228, 1 },
      { 14, 181, 178, 0 },
      { 147, 130, 231, 0 },
      { 38, 214, 184, 0 }, },
    { { 115, 160, 231, 0 },
      { 6, 247, 178, 0 },
      { 115, 130, 231, 0 },
      { 38, 247, 176, 0 }, },
    { { 115, 175, 8, 0 },
      { 39, 57, 131, 1 },
      { 8, 122, 231, 0 },
      { 224, 206, 114, 0 }, },
    { { 115, 175, 11, 1 },
      { 47, 123, 131, 1 },
      { 232, 122, 231, 0 },
      { 224, 239, 122, 0 }, },
    { { 115, 175, 4, 1 },
      { 47, 57, 147, 0 },
      { 144, 122, 231, 0 },
      { 100, 206, 122, 0 }, },
    { { 115, 175, 7, 0 },
      { 39, 123, 147, 0 },
      { 112, 122, 231, 0 },
      { 100, 239, 114, 0 }, },
    { { 115, 175, 120, 0 },
      { 55, 189, 131, 1 },
      { 15, 122, 231, 0 },
      { 224, 222, 246, 0 }, },
    { { 115, 175, 123, 1 },
      { 63, 255, 131, 1 },
      { 239, 122, 231, 0 },
      { 224, 255, 254, 0 }, },
    { { 115, 175, 116, 1 },
      { 63, 189, 147, 0 },
      { 151, 122, 231, 0 },
      { 100, 222, 254, 0 }, },
    { { 115, 175, 119, 0 },
      { 55, 255, 147, 0 },
      { 119, 122, 231, 0 },
      { 100, 255, 246, 0 }, },
    { { 115, 174, 152, 0 },
      { 55, 57, 162, 1 },
      { 12, 186, 231, 0 },
      { 162, 206, 118, 0 }, },
    { { 115, 174, 155, 1 },
      { 63, 123, 162, 1 },
      { 236, 186, 231, 0 },
      { 162, 239, 126, 0 }, },
    { { 115, 174, 148, 1 },
      { 63, 57, 178, 0 },
      { 148, 186, 231, 0 },
      { 38, 206, 126, 0 }, },
    { { 115, 174, 151, 0 },
      { 55, 123, 178, 0 },
      { 116, 186, 231, 0 },
      { 38, 239, 118, 0 }, },
    { { 115, 174, 232, 0 },
      { 39, 189, 162, 1 },
      { 11, 186, 231, 0 },
      { 162, 222, 242, 0 }, },
    { { 115, 174, 235, 1 },
      { 47, 255, 162, 1 },
      { 235, 186, 231, 0 },
      { 162, 255, 250, 0 }, },
    { { 115, 174, 228, 1 },
      { 47, 189, 178, 0 },
      { 147, 186, 231, 0 },
      { 38, 222, 250, 0 }, },
    { { 115, 174, 231, 0 },
      { 39, 255, 178, 0 },
      { 115, 186, 231, 0 },
      { 38, 255, 242, 0 }, },
    { { 115, 147, 8, 0 },
      { 38, 49, 193, 1 },
      { 8, 100, 231, 0 },
      { 193, 198, 50, 0 }, },
    { { 115, 147, 11, 1 },
      { 46, 115, 193, 1 },
      { 232, 100, 231, 0 },
      { 193, 231, 58, 0 }, },
    { { 115, 147, 4, 1 },
      { 46, 49, 209, 0 },
      { 144, 100, 231, 0 },
      { 69, 198, 58, 0 }, },
    { { 115, 147, 7, 0 },
      { 38, 115, 209, 0 },
      { 112, 100, 231, 0 },
      { 69, 231, 50, 0 }, },
    { { 115, 147, 120, 0 },
      { 54, 181, 193, 1 },
      { 15, 100, 231, 0 },
      { 193, 214, 182, 0 }, },
    { { 115, 147, 123, 1 },
      { 62, 247, 193, 1 },
      { 239, 100, 231, 0 },
      { 193, 247, 190, 0 }, },
    { { 115, 147, 116, 1 },
      { 62, 181, 209, 0 },
      { 151, 100, 231, 0 },
      { 69, 214, 190, 0 }, },
    { { 115, 147, 119, 0 },
      { 54, 247, 209, 0 },
      { 119, 100, 231, 0 },
      { 69, 247, 182, 0 }, },
    { { 115, 146, 152, 0 },
      { 54, 49, 224, 1 },
      { 12, 164, 231, 0 },
      { 131, 198, 54, 0 }, },
    { { 115, 146, 155, 1 },
      { 62, 115, 224, 1 },
      { 236, 164, 231, 0 },
      { 131, 231, 62, 0 }, },
    { { 115, 146, 148, 1 },
      { 62, 49, 240, 0 },
      { 148, 164, 231, 0 },
      { 7, 198, 62, 0 }, },
    { { 115, 146, 151, 0 },
      { 54, 115, 240, 0 },
      { 116, 164, 231, 0 },
      { 7, 231, 54, 0 }, },
    { { 115, 146, 232, 0 },
      { 38, 181, 224, 1 },
      { 11, 164, 231, 0 },
      { 131, 214, 178, 0 }, },
    { { 115, 146, 235, 1 },
      { 46, 247, 224, 1 },
      { 235, 164, 231, 0 },
      { 131, 247, 186, 0 }, },
    { { 115, 146, 228, 1 },
      { 46, 181, 240, 0 },
      { 147, 164, 231, 0 },
      { 7, 214, 186, 0 }, },
    { { 115, 146, 231, 0 },
      { 38, 247, 240, 0 },
      { 115, 164, 231, 0 },
      { 7, 247, 178, 0 }, },
    { { 115, 157, 8, 0 },
      { 7, 57, 193, 1 },
      { 8, 92, 231, 0 },
      { 193, 206, 112, 0 }, },
    { { 115, 157, 11, 1 },
      { 15, 123, 193, 1 },
      { 232, 92, 231, 0 },
      { 193, 239, 120, 0 }, },
    { { 115, 157, 4, 1 },
      { 15, 57, 209, 0 },
      { 144, 92, 231, 0 },
      { 69, 206, 120, 0 }, },
    { { 115, 157, 7, 0 },
      { 7, 123, 209, 0 },
      { 112, 92, 231, 0 },
      { 69, 239, 112, 0 }, },
    { { 115, 157, 120, 0 },
      { 23, 189, 193, 1 },
      { 15, 92, 231, 0 },
      { 193, 222, 244, 0 }, },
    { { 115, 157, 123, 1 },
      { 31, 255, 193, 1 },
      { 239, 92, 231, 0 },
      { 193, 255, 252, 0 }, },
    { { 115, 157, 116, 1 },
      { 31, 189, 209, 0 },
      { 151, 92, 231, 0 },
      { 69, 222, 252, 0 }, },
    { { 115, 157, 119, 0 },
      { 23, 255, 209, 0 },
      { 119, 92, 231, 0 },
      { 69, 255, 244, 0 }, },
    { { 115, 156, 152, 0 },
      { 23, 57, 224, 1 },
      { 12, 156, 231, 0 },
      { 131, 206, 116, 0 }, },
    { { 115, 156, 155, 1 },
      { 31, 123, 224, 1 },
      { 236, 156, 231, 0 },
      { 131, 239, 124, 0 }, },
    { { 115, 156, 148, 1 },
      { 31, 57, 240, 0 },
      { 148, 156, 231, 0 },
      { 7, 206, 124, 0 }, },
    { { 115, 156, 151, 0 },
      { 23, 123, 240, 0 },
      { 116, 156, 231, 0 },
      { 7, 239, 116, 0 }, },
    { { 115, 156, 232, 0 },
      { 7, 189, 224, 1 },
      { 11, 156, 231, 0 },
      { 131, 222, 240, 0 }, },
    { { 115, 156, 235, 1 },
      { 15, 255, 224, 1 },
      { 235, 156, 231, 0 },
      { 131, 255, 248, 0 }, },
    { { 115, 156, 228, 1 },
      { 15, 189, 240, 0 },
      { 147, 156, 231, 0 },
      { 7, 222, 248, 0 }, },
    { { 115, 156, 231, 0 },
      { 7, 255, 240, 0 },
      { 115, 156, 231, 0 },
      { 7, 255, 240, 0 }, },
};

static unsigned char DICT_4X4_1000_BYTES[][4][2] =
    { { { 181, 50 },
        { 235, 72 },
        { 76, 173 },
        { 18, 215 }, },
      { { 15, 154 },
        { 101, 71 },
        { 89, 240 },
        { 226, 166 }, },
      { { 51, 45 },
        { 222, 17 },
        { 180, 204 },
        { 136, 123 }, },
      { { 153, 70 },
        { 193, 60 },
        { 98, 153 },
        { 60, 131 }, },
      { { 84, 158 },
        { 161, 211 },
        { 121, 42 },
        { 203, 133 }, },
      { { 121, 205 },
        { 216, 183 },
        { 179, 158 },
        { 237, 27 }, },
      { { 158, 46 },
        { 135, 93 },
        { 116, 121 },
        { 186, 225 }, },
      { { 196, 242 },
        { 35, 234 },
        { 79, 35 },
        { 87, 196 }, },
      { { 254, 218 },
        { 173, 239 },
        { 91, 127 },
        { 247, 181 }, },
      { { 207, 86 },
        { 101, 252 },
        { 106, 243 },
        { 63, 166 }, },
      { { 249, 145 },
        { 248, 142 },
        { 137, 159 },
        { 113, 31 }, },
      { { 17, 167 },
        { 211, 18 },
        { 229, 136 },
        { 72, 203 }, },
      { { 14, 183 },
        { 55, 86 },
        { 237, 112 },
        { 106, 236 }, },
      { { 42, 15 },
        { 29, 21 },
        { 240, 84 },
        { 168, 184 }, },
      { { 36, 177 },
        { 58, 66 },
        { 141, 36 },
        { 66, 92 }, },
      { { 38, 62 },
        { 47, 81 },
        { 124, 100 },
        { 138, 244 }, },
      { { 70, 101 },
        { 22, 240 },
        { 166, 98 },
        { 15, 104 }, },
      { { 102, 0 },
        { 12, 192 },
        { 0, 102 },
        { 3, 48 }, },
      { { 108, 94 },
        { 41, 245 },
        { 122, 54 },
        { 175, 148 }, },
      { { 118, 175 },
        { 159, 211 },
        { 245, 110 },
        { 203, 249 }, },
      { { 134, 139 },
        { 21, 75 },
        { 209, 97 },
        { 210, 168 }, },
      { { 176, 43 },
        { 155, 9 },
        { 212, 13 },
        { 144, 217 }, },
      { { 204, 213 },
        { 48, 254 },
        { 171, 51 },
        { 127, 12 }, },
      { { 221, 130 },
        { 193, 206 },
        { 65, 187 },
        { 115, 131 }, },
      { { 254, 71 },
        { 157, 252 },
        { 226, 127 },
        { 63, 185 }, },
      { { 148, 113 },
        { 178, 104 },
        { 142, 41 },
        { 22, 77 }, },
      { { 172, 228 },
        { 10, 126 },
        { 39, 53 },
        { 126, 80 }, },
      { { 165, 84 },
        { 104, 120 },
        { 42, 165 },
        { 30, 22 }, },
      { { 33, 35 },
        { 91, 0 },
        { 196, 132 },
        { 0, 218 }, },
      { { 52, 111 },
        { 155, 113 },
        { 246, 44 },
        { 142, 217 }, },
      { { 68, 21 },
        { 48, 208 },
        { 168, 34 },
        { 11, 12 }, },
      { { 87, 178 },
        { 231, 194 },
        { 77, 234 },
        { 67, 231 }, },
      { { 158, 207 },
        { 149, 127 },
        { 243, 121 },
        { 254, 169 }, },
      { { 240, 203 },
        { 153, 171 },
        { 211, 15 },
        { 213, 153 }, },
      { { 8, 174 },
        { 3, 23 },
        { 117, 16 },
        { 232, 192 }, },
      { { 9, 41 },
        { 82, 5 },
        { 148, 144 },
        { 160, 74 }, },
      { { 24, 117 },
        { 178, 52 },
        { 174, 24 },
        { 44, 77 }, },
      { { 4, 255 },
        { 51, 115 },
        { 255, 32 },
        { 206, 204 }, },
      { { 13, 246 },
        { 99, 118 },
        { 111, 176 },
        { 110, 198 }, },
      { { 28, 90 },
        { 161, 101 },
        { 90, 56 },
        { 166, 133 }, },
      { { 23, 24 },
        { 228, 65 },
        { 24, 232 },
        { 130, 39 }, },
      { { 42, 40 },
        { 14, 5 },
        { 20, 84 },
        { 160, 112 }, },
      { { 50, 140 },
        { 140, 19 },
        { 49, 76 },
        { 200, 49 }, },
      { { 56, 178 },
        { 171, 6 },
        { 77, 28 },
        { 96, 213 }, },
      { { 36, 232 },
        { 10, 99 },
        { 23, 36 },
        { 198, 80 }, },
      { { 46, 235 },
        { 31, 103 },
        { 215, 116 },
        { 230, 248 }, },
      { { 45, 63 },
        { 123, 85 },
        { 252, 180 },
        { 170, 222 }, },
      { { 75, 100 },
        { 70, 180 },
        { 38, 210 },
        { 45, 98 }, },
      { { 80, 46 },
        { 131, 145 },
        { 116, 10 },
        { 137, 193 }, },
      { { 80, 19 },
        { 177, 128 },
        { 200, 10 },
        { 1, 141 }, },
      { { 81, 148 },
        { 224, 146 },
        { 41, 138 },
        { 73, 7 }, },
      { { 85, 104 },
        { 194, 225 },
        { 22, 170 },
        { 135, 67 }, },
      { { 93, 65 },
        { 208, 228 },
        { 130, 186 },
        { 39, 11 }, },
      { { 95, 151 },
        { 245, 214 },
        { 233, 250 },
        { 107, 175 }, },
      { { 104, 1 },
        { 24, 132 },
        { 128, 22 },
        { 33, 24 }, },
      { { 104, 103 },
        { 27, 180 },
        { 230, 22 },
        { 45, 216 }, },
      { { 97, 36 },
        { 74, 144 },
        { 36, 134 },
        { 9, 82 }, },
      { { 97, 233 },
        { 90, 163 },
        { 151, 134 },
        { 197, 90 }, },
      { { 107, 18 },
        { 109, 132 },
        { 72, 214 },
        { 33, 182 }, },
      { { 111, 229 },
        { 94, 246 },
        { 167, 246 },
        { 111, 122 }, },
      { { 103, 223 },
        { 125, 243 },
        { 251, 230 },
        { 207, 190 }, },
      { { 126, 27 },
        { 189, 197 },
        { 216, 126 },
        { 163, 189 }, },
      { { 128, 160 },
        { 2, 10 },
        { 5, 1 },
        { 80, 64 }, },
      { { 131, 68 },
        { 68, 56 },
        { 34, 193 },
        { 28, 34 }, },
      { { 139, 162 },
        { 71, 14 },
        { 69, 209 },
        { 112, 226 }, },
      { { 147, 122 },
        { 231, 41 },
        { 94, 201 },
        { 148, 231 }, },
      { { 132, 108 },
        { 2, 121 },
        { 54, 33 },
        { 158, 64 }, },
      { { 133, 42 },
        { 67, 73 },
        { 84, 161 },
        { 146, 194 }, },
      { { 133, 156 },
        { 96, 91 },
        { 57, 161 },
        { 218, 6 }, },
      { { 156, 137 },
        { 144, 79 },
        { 145, 57 },
        { 242, 9 }, },
      { { 159, 161 },
        { 214, 78 },
        { 133, 249 },
        { 114, 107 }, },
      { { 187, 124 },
        { 238, 61 },
        { 62, 221 },
        { 188, 119 }, },
      { { 188, 4 },
        { 136, 92 },
        { 32, 61 },
        { 58, 17 }, },
      { { 182, 91 },
        { 189, 105 },
        { 218, 109 },
        { 150, 189 }, },
      { { 191, 200 },
        { 204, 111 },
        { 19, 253 },
        { 246, 51 }, },
      { { 183, 171 },
        { 223, 75 },
        { 213, 237 },
        { 210, 251 }, },
      { { 202, 31 },
        { 53, 157 },
        { 248, 83 },
        { 185, 172 }, },
      { { 201, 98 },
        { 67, 172 },
        { 70, 147 },
        { 53, 194 }, },
      { { 217, 88 },
        { 224, 173 },
        { 26, 155 },
        { 181, 7 }, },
      { { 211, 213 },
        { 244, 186 },
        { 171, 203 },
        { 93, 47 }, },
      { { 204, 152 },
        { 32, 207 },
        { 25, 51 },
        { 243, 4 }, },
      { { 199, 160 },
        { 70, 202 },
        { 5, 227 },
        { 83, 98 }, },
      { { 197, 55 },
        { 115, 216 },
        { 236, 163 },
        { 27, 206 }, },
      { { 233, 93 },
        { 120, 189 },
        { 186, 151 },
        { 189, 30 }, },
      { { 249, 37 },
        { 218, 156 },
        { 164, 159 },
        { 57, 91 }, },
      { { 251, 187 },
        { 255, 143 },
        { 221, 223 },
        { 241, 255 }, },
      { { 238, 42 },
        { 15, 205 },
        { 84, 119 },
        { 179, 240 }, },
      { { 247, 77 },
        { 220, 249 },
        { 178, 239 },
        { 159, 59 }, },
      { { 53, 117 },
        { 250, 112 },
        { 174, 172 },
        { 14, 95 }, },
      { { 138, 173 },
        { 22, 31 },
        { 181, 81 },
        { 248, 104 }, },
      { { 118, 23 },
        { 189, 208 },
        { 232, 110 },
        { 11, 189 }, },
      { { 10, 207 },
        { 21, 55 },
        { 243, 80 },
        { 236, 168 }, },
      { { 6, 75 },
        { 21, 97 },
        { 210, 96 },
        { 134, 168 }, },
      { { 45, 193 },
        { 88, 102 },
        { 131, 180 },
        { 102, 26 }, },
      { { 73, 216 },
        { 96, 167 },
        { 27, 146 },
        { 229, 6 }, },
      { { 67, 244 },
        { 102, 178 },
        { 47, 194 },
        { 77, 102 }, },
      { { 79, 54 },
        { 103, 212 },
        { 108, 242 },
        { 43, 230 }, },
      { { 79, 211 },
        { 117, 230 },
        { 203, 242 },
        { 103, 174 }, },
      { { 105, 228 },
        { 74, 182 },
        { 39, 150 },
        { 109, 82 }, },
      { { 112, 199 },
        { 153, 178 },
        { 227, 14 },
        { 77, 153 }, },
      { { 122, 110 },
        { 143, 181 },
        { 118, 94 },
        { 173, 241 }, },
      { { 180, 234 },
        { 139, 107 },
        { 87, 45 },
        { 214, 209 }, },
      { { 237, 79 },
        { 89, 253 },
        { 242, 183 },
        { 191, 154 }, },
      { { 252, 231 },
        { 155, 254 },
        { 231, 63 },
        { 127, 217 }, },
      { { 254, 166 },
        { 143, 222 },
        { 101, 127 },
        { 123, 241 }, },
      { { 0, 37 },
        { 18, 16 },
        { 164, 0 },
        { 8, 72 }, },
      { { 0, 67 },
        { 17, 32 },
        { 194, 0 },
        { 4, 136 }, },
      { { 10, 136 },
        { 4, 7 },
        { 17, 80 },
        { 224, 32 }, },
      { { 10, 134 },
        { 5, 22 },
        { 97, 80 },
        { 104, 160 }, },
      { { 2, 111 },
        { 23, 49 },
        { 246, 64 },
        { 140, 232 }, },
      { { 0, 28 },
        { 32, 17 },
        { 56, 0 },
        { 136, 4 }, },
      { { 0, 151 },
        { 49, 18 },
        { 233, 0 },
        { 72, 140 }, },
      { { 8, 55 },
        { 51, 20 },
        { 236, 16 },
        { 40, 204 }, },
      { { 10, 49 },
        { 54, 4 },
        { 140, 80 },
        { 32, 108 }, },
      { { 9, 198 },
        { 65, 54 },
        { 99, 144 },
        { 108, 130 }, },
      { { 11, 1 },
        { 84, 4 },
        { 128, 208 },
        { 32, 42 }, },
      { { 9, 251 },
        { 115, 39 },
        { 223, 144 },
        { 228, 206 }, },
      { { 11, 88 },
        { 100, 37 },
        { 26, 208 },
        { 164, 38 }, },
      { { 16, 130 },
        { 129, 2 },
        { 65, 8 },
        { 64, 129 }, },
      { { 24, 45 },
        { 146, 21 },
        { 180, 24 },
        { 168, 73 }, },
      { { 16, 120 },
        { 162, 33 },
        { 30, 8 },
        { 132, 69 }, },
      { { 16, 115 },
        { 179, 32 },
        { 206, 8 },
        { 4, 205 }, },
      { { 18, 116 },
        { 166, 48 },
        { 46, 72 },
        { 12, 101 }, },
      { { 18, 177 },
        { 182, 2 },
        { 141, 72 },
        { 64, 109 }, },
      { { 26, 249 },
        { 182, 39 },
        { 159, 88 },
        { 228, 109 }, },
      { { 19, 6 },
        { 197, 16 },
        { 96, 200 },
        { 8, 163 }, },
      { { 12, 14 },
        { 1, 85 },
        { 112, 48 },
        { 170, 128 }, },
      { { 12, 241 },
        { 50, 102 },
        { 143, 48 },
        { 102, 76 }, },
      { { 4, 51 },
        { 51, 64 },
        { 204, 32 },
        { 2, 204 }, },
      { { 12, 159 },
        { 49, 87 },
        { 249, 48 },
        { 234, 140 }, },
      { { 14, 242 },
        { 39, 102 },
        { 79, 112 },
        { 102, 228 }, },
      { { 14, 253 },
        { 54, 119 },
        { 191, 112 },
        { 238, 108 }, },
      { { 7, 76 },
        { 68, 113 },
        { 50, 224 },
        { 142, 34 }, },
      { { 15, 164 },
        { 70, 86 },
        { 37, 240 },
        { 106, 98 }, },
      { { 7, 47 },
        { 87, 81 },
        { 244, 224 },
        { 138, 234 }, },
      { { 5, 181 },
        { 114, 82 },
        { 173, 160 },
        { 74, 78 }, },
      { { 15, 145 },
        { 116, 70 },
        { 137, 240 },
        { 98, 46 }, },
      { { 7, 219 },
        { 117, 99 },
        { 219, 224 },
        { 198, 174 }, },
      { { 30, 228 },
        { 134, 118 },
        { 39, 120 },
        { 110, 97 }, },
      { { 20, 57 },
        { 178, 65 },
        { 156, 40 },
        { 130, 77 }, },
      { { 29, 128 },
        { 192, 70 },
        { 1, 184 },
        { 98, 3 }, },
      { { 21, 200 },
        { 192, 99 },
        { 19, 168 },
        { 198, 3 }, },
      { { 31, 139 },
        { 213, 71 },
        { 209, 248 },
        { 226, 171 }, },
      { { 21, 186 },
        { 227, 67 },
        { 93, 168 },
        { 194, 199 }, },
      { { 29, 177 },
        { 242, 70 },
        { 141, 184 },
        { 98, 79 }, },
      { { 32, 128 },
        { 8, 2 },
        { 1, 4 },
        { 64, 16 }, },
      { { 40, 233 },
        { 26, 39 },
        { 151, 20 },
        { 228, 88 }, },
      { { 34, 162 },
        { 15, 2 },
        { 69, 68 },
        { 64, 240 }, },
      { { 40, 83 },
        { 57, 36 },
        { 202, 20 },
        { 36, 156 }, },
      { { 42, 240 },
        { 46, 38 },
        { 15, 84 },
        { 100, 116 }, },
      { { 34, 247 },
        { 63, 50 },
        { 239, 68 },
        { 76, 252 }, },
      { { 41, 64 },
        { 72, 36 },
        { 2, 148 },
        { 36, 18 }, },
      { { 33, 70 },
        { 73, 48 },
        { 98, 132 },
        { 12, 146 }, },
      { { 41, 185 },
        { 122, 7 },
        { 157, 148 },
        { 224, 94 }, },
      { { 43, 156 },
        { 108, 23 },
        { 57, 212 },
        { 232, 54 }, },
      { { 43, 178 },
        { 111, 6 },
        { 77, 212 },
        { 96, 246 }, },
      { { 56, 202 },
        { 137, 39 },
        { 83, 28 },
        { 228, 145 }, },
      { { 56, 46 },
        { 139, 21 },
        { 116, 28 },
        { 168, 209 }, },
      { { 48, 7 },
        { 153, 16 },
        { 224, 12 },
        { 8, 153 }, },
      { { 56, 231 },
        { 155, 54 },
        { 231, 28 },
        { 108, 217 }, },
      { { 58, 73 },
        { 156, 37 },
        { 146, 92 },
        { 164, 57 }, },
      { { 58, 101 },
        { 158, 52 },
        { 166, 92 },
        { 44, 121 }, },
      { { 50, 93 },
        { 188, 49 },
        { 186, 76 },
        { 140, 61 }, },
      { { 59, 136 },
        { 204, 7 },
        { 17, 220 },
        { 224, 51 }, },
      { { 57, 29 },
        { 248, 21 },
        { 184, 156 },
        { 168, 31 }, },
      { { 59, 211 },
        { 253, 38 },
        { 203, 220 },
        { 100, 191 }, },
      { { 38, 71 },
        { 29, 112 },
        { 226, 100 },
        { 14, 184 }, },
      { { 39, 128 },
        { 76, 66 },
        { 1, 228 },
        { 66, 50 }, },
      { { 47, 170 },
        { 79, 71 },
        { 85, 244 },
        { 226, 242 }, },
      { { 45, 20 },
        { 104, 84 },
        { 40, 180 },
        { 42, 22 }, },
      { { 37, 222 },
        { 105, 115 },
        { 123, 164 },
        { 206, 150 }, },
      { { 37, 83 },
        { 121, 96 },
        { 202, 164 },
        { 6, 158 }, },
      { { 47, 119 },
        { 127, 116 },
        { 238, 244 },
        { 46, 254 }, },
      { { 52, 72 },
        { 136, 97 },
        { 18, 44 },
        { 134, 17 }, },
      { { 60, 168 },
        { 138, 71 },
        { 21, 60 },
        { 226, 81 }, },
      { { 60, 65 },
        { 152, 100 },
        { 130, 60 },
        { 38, 25 }, },
      { { 52, 13 },
        { 152, 81 },
        { 176, 44 },
        { 138, 25 }, },
      { { 52, 251 },
        { 187, 99 },
        { 223, 44 },
        { 198, 221 }, },
      { { 54, 154 },
        { 173, 67 },
        { 89, 108 },
        { 194, 181 }, },
      { { 61, 224 },
        { 202, 102 },
        { 7, 188 },
        { 102, 83 }, },
      { { 53, 106 },
        { 203, 97 },
        { 86, 172 },
        { 134, 211 }, },
      { { 61, 9 },
        { 216, 69 },
        { 144, 188 },
        { 162, 27 }, },
      { { 61, 237 },
        { 218, 119 },
        { 183, 188 },
        { 238, 91 }, },
      { { 63, 196 },
        { 204, 118 },
        { 35, 252 },
        { 110, 51 }, },
      { { 63, 108 },
        { 206, 117 },
        { 54, 252 },
        { 174, 115 }, },
      { { 55, 206 },
        { 205, 115 },
        { 115, 236 },
        { 206, 179 }, },
      { { 61, 92 },
        { 232, 117 },
        { 58, 188 },
        { 174, 23 }, },
      { { 61, 118 },
        { 235, 116 },
        { 110, 188 },
        { 46, 215 }, },
      { { 55, 176 },
        { 238, 66 },
        { 13, 236 },
        { 66, 119 }, },
      { { 63, 23 },
        { 253, 84 },
        { 232, 252 },
        { 42, 191 }, },
      { { 63, 255 },
        { 255, 119 },
        { 255, 252 },
        { 238, 255 }, },
      { { 72, 229 },
        { 18, 182 },
        { 167, 18 },
        { 109, 72 }, },
      { { 66, 104 },
        { 6, 161 },
        { 22, 66 },
        { 133, 96 }, },
      { { 74, 45 },
        { 22, 149 },
        { 180, 82 },
        { 169, 104 }, },
      { { 65, 96 },
        { 66, 160 },
        { 6, 130 },
        { 5, 66 }, },
      { { 73, 81 },
        { 112, 164 },
        { 138, 146 },
        { 37, 14 }, },
      { { 65, 221 },
        { 112, 179 },
        { 187, 130 },
        { 205, 14 }, },
      { { 75, 223 },
        { 117, 183 },
        { 251, 210 },
        { 237, 174 }, },
      { { 88, 79 },
        { 145, 181 },
        { 242, 26 },
        { 173, 137 }, },
      { { 90, 72 },
        { 132, 165 },
        { 18, 90 },
        { 165, 33 }, },
      { { 88, 22 },
        { 161, 148 },
        { 104, 26 },
        { 41, 133 }, },
      { { 80, 93 },
        { 176, 177 },
        { 186, 10 },
        { 141, 13 }, },
      { { 90, 250 },
        { 167, 167 },
        { 95, 90 },
        { 229, 229 }, },
      { { 90, 181 },
        { 182, 150 },
        { 173, 90 },
        { 105, 109 }, },
      { { 81, 35 },
        { 211, 128 },
        { 196, 138 },
        { 1, 203 }, },
      { { 91, 138 },
        { 197, 135 },
        { 81, 218 },
        { 225, 163 }, },
      { { 89, 25 },
        { 240, 133 },
        { 152, 154 },
        { 161, 15 }, },
      { { 81, 53 },
        { 242, 144 },
        { 172, 138 },
        { 9, 79 }, },
      { { 76, 105 },
        { 18, 229 },
        { 150, 50 },
        { 167, 72 }, },
      { { 70, 193 },
        { 20, 226 },
        { 131, 98 },
        { 71, 40 }, },
      { { 78, 11 },
        { 21, 197 },
        { 208, 114 },
        { 163, 168 }, },
      { { 68, 95 },
        { 49, 241 },
        { 250, 34 },
        { 143, 140 }, },
      { { 78, 89 },
        { 52, 229 },
        { 154, 114 },
        { 167, 44 }, },
      { { 77, 131 },
        { 81, 198 },
        { 193, 178 },
        { 99, 138 }, },
      { { 77, 125 },
        { 114, 245 },
        { 190, 178 },
        { 175, 78 }, },
      { { 71, 216 },
        { 100, 227 },
        { 27, 226 },
        { 199, 38 }, },
      { { 71, 115 },
        { 119, 224 },
        { 206, 226 },
        { 7, 238 }, },
      { { 92, 133 },
        { 144, 214 },
        { 161, 58 },
        { 107, 9 }, },
      { { 94, 68 },
        { 132, 244 },
        { 34, 122 },
        { 47, 33 }, },
      { { 86, 43 },
        { 151, 193 },
        { 212, 106 },
        { 131, 233 }, },
      { { 92, 187 },
        { 179, 199 },
        { 221, 58 },
        { 227, 205 }, },
      { { 85, 195 },
        { 209, 226 },
        { 195, 170 },
        { 71, 139 }, },
      { { 95, 110 },
        { 199, 245 },
        { 118, 250 },
        { 175, 227 }, },
      { { 95, 235 },
        { 215, 231 },
        { 215, 250 },
        { 231, 235 }, },
      { { 93, 18 },
        { 225, 196 },
        { 72, 186 },
        { 35, 135 }, },
      { { 85, 94 },
        { 225, 241 },
        { 122, 170 },
        { 143, 135 }, },
      { { 98, 112 },
        { 46, 160 },
        { 14, 70 },
        { 5, 116 }, },
      { { 98, 21 },
        { 60, 144 },
        { 168, 70 },
        { 9, 60 }, },
      { { 97, 194 },
        { 73, 162 },
        { 67, 134 },
        { 69, 146 }, },
      { { 107, 32 },
        { 78, 132 },
        { 4, 214 },
        { 33, 114 }, },
      { { 99, 69 },
        { 92, 176 },
        { 162, 198 },
        { 13, 58 }, },
      { { 107, 92 },
        { 108, 181 },
        { 58, 214 },
        { 173, 54 }, },
      { { 107, 91 },
        { 125, 165 },
        { 218, 214 },
        { 165, 190 }, },
      { { 120, 12 },
        { 136, 149 },
        { 48, 30 },
        { 169, 17 }, },
      { { 122, 207 },
        { 157, 183 },
        { 243, 94 },
        { 237, 185 }, },
      { { 120, 127 },
        { 187, 181 },
        { 254, 30 },
        { 173, 221 }, },
      { { 121, 128 },
        { 200, 134 },
        { 1, 158 },
        { 97, 19 }, },
      { { 113, 229 },
        { 218, 178 },
        { 167, 142 },
        { 77, 91 }, },
      { { 113, 116 },
        { 234, 176 },
        { 46, 142 },
        { 13, 87 }, },
      { { 121, 182 },
        { 235, 150 },
        { 109, 158 },
        { 105, 215 }, },
      { { 113, 211 },
        { 249, 162 },
        { 203, 142 },
        { 69, 159 }, },
      { { 123, 51 },
        { 255, 132 },
        { 204, 222 },
        { 33, 255 }, },
      { { 100, 106 },
        { 11, 225 },
        { 86, 38 },
        { 135, 208 }, },
      { { 102, 168 },
        { 14, 195 },
        { 21, 102 },
        { 195, 112 }, },
      { { 110, 167 },
        { 31, 214 },
        { 229, 118 },
        { 107, 248 }, },
      { { 110, 145 },
        { 60, 198 },
        { 137, 118 },
        { 99, 60 }, },
      { { 101, 34 },
        { 75, 192 },
        { 68, 166 },
        { 3, 210 }, },
      { { 109, 203 },
        { 89, 231 },
        { 211, 182 },
        { 231, 154 }, },
      { { 103, 141 },
        { 92, 211 },
        { 177, 230 },
        { 203, 58 }, },
      { { 109, 49 },
        { 122, 196 },
        { 140, 182 },
        { 35, 94 }, },
      { { 126, 128 },
        { 140, 198 },
        { 1, 126 },
        { 99, 49 }, },
      { { 126, 226 },
        { 143, 230 },
        { 71, 126 },
        { 103, 241 }, },
      { { 126, 141 },
        { 156, 215 },
        { 177, 126 },
        { 235, 57 }, },
      { { 116, 210 },
        { 169, 226 },
        { 75, 46 },
        { 71, 149 }, },
      { { 124, 50 },
        { 171, 196 },
        { 76, 62 },
        { 35, 213 }, },
      { { 126, 53 },
        { 190, 212 },
        { 172, 126 },
        { 43, 125 }, },
      { { 117, 171 },
        { 219, 195 },
        { 213, 174 },
        { 195, 219 }, },
      { { 119, 5 },
        { 220, 208 },
        { 160, 238 },
        { 11, 59 }, },
      { { 127, 43 },
        { 223, 197 },
        { 212, 254 },
        { 163, 251 }, },
      { { 125, 218 },
        { 233, 231 },
        { 91, 190 },
        { 231, 151 }, },
      { { 127, 146 },
        { 237, 198 },
        { 73, 254 },
        { 99, 183 }, },
      { { 128, 117 },
        { 50, 56 },
        { 174, 1 },
        { 28, 76 }, },
      { { 128, 243 },
        { 51, 42 },
        { 207, 1 },
        { 84, 204 }, },
      { { 129, 166 },
        { 67, 26 },
        { 101, 129 },
        { 88, 194 }, },
      { { 137, 237 },
        { 82, 63 },
        { 183, 145 },
        { 252, 74 }, },
      { { 129, 252 },
        { 98, 59 },
        { 63, 129 },
        { 220, 70 }, },
      { { 152, 166 },
        { 131, 30 },
        { 101, 25 },
        { 120, 193 }, },
      { { 154, 32 },
        { 134, 12 },
        { 4, 89 },
        { 48, 97 }, },
      { { 145, 67 },
        { 209, 40 },
        { 194, 137 },
        { 20, 139 }, },
      { { 153, 249 },
        { 242, 47 },
        { 159, 153 },
        { 244, 79 }, },
      { { 145, 147 },
        { 241, 10 },
        { 201, 137 },
        { 80, 143 }, },
      { { 155, 212 },
        { 228, 62 },
        { 43, 217 },
        { 124, 39 }, },
      { { 132, 9 },
        { 16, 73 },
        { 144, 33 },
        { 146, 8 }, },
      { { 132, 107 },
        { 19, 105 },
        { 214, 33 },
        { 150, 200 }, },
      { { 134, 196 },
        { 4, 122 },
        { 35, 97 },
        { 94, 32 }, },
      { { 142, 100 },
        { 6, 124 },
        { 38, 113 },
        { 62, 96 }, },
      { { 134, 26 },
        { 37, 73 },
        { 88, 97 },
        { 146, 164 }, },
      { { 133, 78 },
        { 65, 121 },
        { 114, 161 },
        { 158, 130 }, },
      { { 141, 203 },
        { 81, 111 },
        { 211, 177 },
        { 246, 138 }, },
      { { 133, 103 },
        { 83, 120 },
        { 230, 161 },
        { 30, 202 }, },
      { { 133, 175 },
        { 83, 91 },
        { 245, 161 },
        { 218, 202 }, },
      { { 133, 215 },
        { 113, 122 },
        { 235, 161 },
        { 94, 142 }, },
      { { 135, 179 },
        { 119, 74 },
        { 205, 225 },
        { 82, 238 }, },
      { { 156, 225 },
        { 146, 110 },
        { 135, 57 },
        { 118, 73 }, },
      { { 156, 242 },
        { 163, 110 },
        { 79, 57 },
        { 118, 197 }, },
      { { 148, 23 },
        { 177, 88 },
        { 232, 41 },
        { 26, 141 }, },
      { { 149, 0 },
        { 192, 72 },
        { 0, 169 },
        { 18, 3 }, },
      { { 149, 162 },
        { 195, 74 },
        { 69, 169 },
        { 82, 195 }, },
      { { 157, 35 },
        { 211, 76 },
        { 196, 185 },
        { 50, 203 }, },
      { { 159, 98 },
        { 199, 108 },
        { 70, 249 },
        { 54, 227 }, },
      { { 157, 82 },
        { 225, 108 },
        { 74, 185 },
        { 54, 135 }, },
      { { 149, 218 },
        { 225, 107 },
        { 91, 169 },
        { 214, 135 }, },
      { { 160, 197 },
        { 24, 58 },
        { 163, 5 },
        { 92, 24 }, },
      { { 170, 205 },
        { 28, 63 },
        { 179, 85 },
        { 252, 56 }, },
      { { 162, 216 },
        { 44, 43 },
        { 27, 69 },
        { 212, 52 }, },
      { { 162, 87 },
        { 61, 56 },
        { 234, 69 },
        { 28, 188 }, },
      { { 169, 61 },
        { 122, 29 },
        { 188, 149 },
        { 184, 94 }, },
      { { 169, 87 },
        { 121, 60 },
        { 234, 149 },
        { 60, 158 }, },
      { { 171, 82 },
        { 109, 44 },
        { 74, 213 },
        { 52, 182 }, },
      { { 163, 54 },
        { 111, 24 },
        { 108, 197 },
        { 24, 246 }, },
      { { 163, 89 },
        { 124, 41 },
        { 154, 197 },
        { 148, 62 }, },
      { { 176, 244 },
        { 170, 58 },
        { 47, 13 },
        { 92, 85 }, },
      { { 184, 18 },
        { 169, 12 },
        { 72, 29 },
        { 48, 149 }, },
      { { 176, 191 },
        { 187, 27 },
        { 253, 13 },
        { 216, 221 }, },
      { { 178, 157 },
        { 188, 27 },
        { 185, 77 },
        { 216, 61 }, },
      { { 187, 237 },
        { 222, 63 },
        { 183, 221 },
        { 252, 123 }, },
      { { 185, 114 },
        { 235, 44 },
        { 78, 157 },
        { 52, 215 }, },
      { { 185, 150 },
        { 233, 30 },
        { 105, 157 },
        { 120, 151 }, },
      { { 164, 195 },
        { 25, 106 },
        { 195, 37 },
        { 86, 152 }, },
      { { 172, 210 },
        { 41, 110 },
        { 75, 53 },
        { 118, 148 }, },
      { { 174, 177 },
        { 62, 78 },
        { 141, 117 },
        { 114, 124 }, },
      { { 165, 130 },
        { 73, 74 },
        { 65, 165 },
        { 82, 146 }, },
      { { 175, 101 },
        { 94, 124 },
        { 166, 245 },
        { 62, 122 }, },
      { { 165, 123 },
        { 123, 105 },
        { 222, 165 },
        { 150, 222 }, },
      { { 175, 250 },
        { 111, 111 },
        { 95, 245 },
        { 246, 246 }, },
      { { 180, 100 },
        { 138, 120 },
        { 38, 45 },
        { 30, 81 }, },
      { { 188, 98 },
        { 139, 108 },
        { 70, 61 },
        { 54, 209 }, },
      { { 180, 129 },
        { 152, 74 },
        { 129, 45 },
        { 82, 25 }, },
      { { 182, 160 },
        { 142, 74 },
        { 5, 109 },
        { 82, 113 }, },
      { { 190, 238 },
        { 143, 127 },
        { 119, 125 },
        { 254, 241 }, },
      { { 190, 13 },
        { 156, 93 },
        { 176, 125 },
        { 186, 57 }, },
      { { 188, 217 },
        { 184, 111 },
        { 155, 61 },
        { 246, 29 }, },
      { { 190, 248 },
        { 174, 111 },
        { 31, 125 },
        { 246, 117 }, },
      { { 181, 40 },
        { 202, 73 },
        { 20, 173 },
        { 146, 83 }, },
      { { 183, 9 },
        { 220, 73 },
        { 144, 237 },
        { 146, 59 }, },
      { { 183, 210 },
        { 237, 106 },
        { 75, 237 },
        { 86, 183 }, },
      { { 192, 234 },
        { 3, 171 },
        { 87, 3 },
        { 213, 192 }, },
      { { 192, 25 },
        { 48, 137 },
        { 152, 3 },
        { 145, 12 }, },
      { { 192, 253 },
        { 50, 187 },
        { 191, 3 },
        { 221, 76 }, },
      { { 200, 211 },
        { 49, 174 },
        { 203, 19 },
        { 117, 140 }, },
      { { 202, 90 },
        { 37, 173 },
        { 90, 83 },
        { 181, 164 }, },
      { { 193, 77 },
        { 80, 185 },
        { 178, 131 },
        { 157, 10 }, },
      { { 201, 180 },
        { 98, 158 },
        { 45, 147 },
        { 121, 70 }, },
      { { 193, 87 },
        { 113, 184 },
        { 234, 131 },
        { 29, 142 }, },
      { { 195, 152 },
        { 100, 139 },
        { 25, 195 },
        { 209, 38 }, },
      { { 195, 29 },
        { 116, 153 },
        { 184, 195 },
        { 153, 46 }, },
      { { 216, 128 },
        { 128, 142 },
        { 1, 27 },
        { 113, 1 }, },
      { { 216, 239 },
        { 147, 191 },
        { 247, 27 },
        { 253, 201 }, },
      { { 218, 43 },
        { 151, 141 },
        { 212, 91 },
        { 177, 233 }, },
      { { 208, 30 },
        { 161, 153 },
        { 120, 11 },
        { 153, 133 }, },
      { { 209, 5 },
        { 208, 152 },
        { 160, 139 },
        { 25, 11 }, },
      { { 211, 173 },
        { 214, 155 },
        { 181, 203 },
        { 217, 107 }, },
      { { 219, 167 },
        { 215, 158 },
        { 229, 219 },
        { 121, 235 }, },
      { { 196, 201 },
        { 16, 235 },
        { 147, 35 },
        { 215, 8 }, },
      { { 204, 120 },
        { 34, 237 },
        { 30, 51 },
        { 183, 68 }, },
      { { 205, 69 },
        { 80, 252 },
        { 162, 179 },
        { 63, 10 }, },
      { { 197, 11 },
        { 81, 201 },
        { 208, 163 },
        { 147, 138 }, },
      { { 207, 207 },
        { 85, 255 },
        { 243, 243 },
        { 255, 170 }, },
      { { 220, 172 },
        { 130, 223 },
        { 53, 59 },
        { 251, 65 }, },
      { { 212, 2 },
        { 129, 200 },
        { 64, 43 },
        { 19, 129 }, },
      { { 220, 99 },
        { 147, 236 },
        { 198, 59 },
        { 55, 201 }, },
      { { 212, 39 },
        { 147, 216 },
        { 228, 43 },
        { 27, 201 }, },
      { { 212, 245 },
        { 178, 250 },
        { 175, 43 },
        { 95, 77 }, },
      { { 214, 120 },
        { 166, 233 },
        { 30, 107 },
        { 151, 101 }, },
      { { 222, 184 },
        { 166, 207 },
        { 29, 123 },
        { 243, 101 }, },
      { { 221, 230 },
        { 195, 254 },
        { 103, 187 },
        { 127, 195 }, },
      { { 213, 93 },
        { 240, 249 },
        { 186, 171 },
        { 159, 15 }, },
      { { 221, 189 },
        { 242, 223 },
        { 189, 187 },
        { 251, 79 }, },
      { { 223, 29 },
        { 244, 221 },
        { 184, 251 },
        { 187, 47 }, },
      { { 226, 202 },
        { 13, 171 },
        { 83, 71 },
        { 213, 176 }, },
      { { 234, 107 },
        { 31, 173 },
        { 214, 87 },
        { 181, 248 }, },
      { { 224, 180 },
        { 42, 154 },
        { 45, 7 },
        { 89, 84 }, },
      { { 226, 56 },
        { 46, 137 },
        { 28, 71 },
        { 145, 116 }, },
      { { 226, 212 },
        { 44, 186 },
        { 43, 71 },
        { 93, 52 }, },
      { { 227, 34 },
        { 79, 136 },
        { 68, 199 },
        { 17, 242 }, },
      { { 225, 216 },
        { 104, 171 },
        { 27, 135 },
        { 213, 22 }, },
      { { 240, 3 },
        { 153, 136 },
        { 192, 15 },
        { 17, 153 }, },
      { { 242, 204 },
        { 140, 187 },
        { 51, 79 },
        { 221, 49 }, },
      { { 248, 246 },
        { 171, 190 },
        { 111, 31 },
        { 125, 213 }, },
      { { 241, 73 },
        { 216, 169 },
        { 146, 143 },
        { 149, 27 }, },
      { { 243, 234 },
        { 207, 171 },
        { 87, 207 },
        { 213, 243 }, },
      { { 241, 156 },
        { 232, 155 },
        { 57, 143 },
        { 217, 23 }, },
      { { 249, 245 },
        { 250, 190 },
        { 175, 159 },
        { 125, 95 }, },
      { { 241, 59 },
        { 251, 137 },
        { 220, 143 },
        { 145, 223 }, },
      { { 236, 141 },
        { 24, 223 },
        { 177, 55 },
        { 251, 24 }, },
      { { 238, 201 },
        { 28, 239 },
        { 147, 119 },
        { 247, 56 }, },
      { { 230, 15 },
        { 29, 217 },
        { 240, 103 },
        { 155, 184 }, },
      { { 228, 247 },
        { 59, 250 },
        { 239, 39 },
        { 95, 220 }, },
      { { 231, 96 },
        { 78, 232 },
        { 6, 231 },
        { 23, 114 }, },
      { { 239, 232 },
        { 78, 239 },
        { 23, 247 },
        { 247, 114 }, },
      { { 237, 178 },
        { 107, 206 },
        { 77, 183 },
        { 115, 214 }, },
      { { 229, 21 },
        { 120, 216 },
        { 168, 167 },
        { 27, 30 }, },
      { { 239, 209 },
        { 124, 238 },
        { 139, 247 },
        { 119, 62 }, },
      { { 244, 134 },
        { 137, 218 },
        { 97, 47 },
        { 91, 145 }, },
      { { 252, 1 },
        { 152, 204 },
        { 128, 63 },
        { 51, 25 }, },
      { { 246, 195 },
        { 157, 234 },
        { 195, 111 },
        { 87, 185 }, },
      { { 244, 124 },
        { 170, 249 },
        { 62, 47 },
        { 159, 85 }, },
      { { 252, 147 },
        { 185, 206 },
        { 201, 63 },
        { 115, 157 }, },
      { { 245, 66 },
        { 201, 232 },
        { 66, 175 },
        { 23, 147 }, },
      { { 253, 152 },
        { 232, 207 },
        { 25, 191 },
        { 243, 23 }, },
      { { 245, 61 },
        { 250, 217 },
        { 188, 175 },
        { 155, 95 }, },
      { { 2, 189 },
        { 54, 19 },
        { 189, 64 },
        { 200, 108 }, },
      { { 0, 225 },
        { 18, 34 },
        { 135, 0 },
        { 68, 72 }, },
      { { 2, 226 },
        { 7, 34 },
        { 71, 64 },
        { 68, 224 }, },
      { { 2, 174 },
        { 7, 19 },
        { 117, 64 },
        { 200, 224 }, },
      { { 8, 120 },
        { 34, 37 },
        { 30, 16 },
        { 164, 68 }, },
      { { 0, 116 },
        { 34, 48 },
        { 46, 0 },
        { 12, 68 }, },
      { { 8, 158 },
        { 33, 23 },
        { 121, 16 },
        { 232, 132 }, },
      { { 8, 209 },
        { 48, 38 },
        { 139, 16 },
        { 100, 12 }, },
      { { 8, 125 },
        { 50, 53 },
        { 190, 16 },
        { 172, 76 }, },
      { { 10, 50 },
        { 39, 4 },
        { 76, 80 },
        { 32, 228 }, },
      { { 10, 222 },
        { 37, 55 },
        { 123, 80 },
        { 236, 164 }, },
      { { 2, 81 },
        { 52, 32 },
        { 138, 64 },
        { 4, 44 }, },
      { { 1, 162 },
        { 67, 2 },
        { 69, 128 },
        { 64, 194 }, },
      { { 3, 128 },
        { 68, 2 },
        { 1, 192 },
        { 64, 34 }, },
      { { 11, 131 },
        { 85, 6 },
        { 193, 208 },
        { 96, 170 }, },
      { { 11, 75 },
        { 85, 37 },
        { 210, 208 },
        { 164, 170 }, },
      { { 11, 39 },
        { 87, 20 },
        { 228, 208 },
        { 40, 234 }, },
      { { 11, 239 },
        { 87, 55 },
        { 247, 208 },
        { 236, 234 }, },
      { { 9, 182 },
        { 99, 22 },
        { 109, 144 },
        { 104, 198 }, },
      { { 9, 89 },
        { 112, 37 },
        { 154, 144 },
        { 164, 14 }, },
      { { 9, 147 },
        { 113, 6 },
        { 201, 144 },
        { 96, 142 }, },
      { { 11, 248 },
        { 102, 39 },
        { 31, 208 },
        { 228, 102 }, },
      { { 3, 217 },
        { 116, 35 },
        { 155, 192 },
        { 196, 46 }, },
      { { 3, 241 },
        { 118, 34 },
        { 143, 192 },
        { 68, 110 }, },
      { { 16, 196 },
        { 128, 50 },
        { 35, 8 },
        { 76, 1 }, },
      { { 24, 171 },
        { 147, 7 },
        { 213, 24 },
        { 224, 201 }, },
      { { 26, 160 },
        { 134, 6 },
        { 5, 88 },
        { 96, 97 }, },
      { { 26, 4 },
        { 132, 20 },
        { 32, 88 },
        { 40, 33 }, },
      { { 26, 108 },
        { 134, 53 },
        { 54, 88 },
        { 172, 97 }, },
      { { 26, 174 },
        { 135, 23 },
        { 117, 88 },
        { 232, 225 }, },
      { { 18, 137 },
        { 148, 3 },
        { 145, 72 },
        { 192, 41 }, },
      { { 16, 23 },
        { 177, 16 },
        { 232, 8 },
        { 8, 141 }, },
      { { 26, 243 },
        { 183, 38 },
        { 207, 88 },
        { 100, 237 }, },
      { { 25, 64 },
        { 192, 36 },
        { 2, 152 },
        { 36, 3 }, },
      { { 17, 2 },
        { 193, 0 },
        { 64, 136 },
        { 0, 131 }, },
      { { 17, 43 },
        { 211, 1 },
        { 212, 136 },
        { 128, 203 }, },
      { { 17, 207 },
        { 209, 51 },
        { 243, 136 },
        { 204, 139 }, },
      { { 27, 34 },
        { 199, 4 },
        { 68, 216 },
        { 32, 227 }, },
      { { 19, 46 },
        { 199, 17 },
        { 116, 200 },
        { 136, 227 }, },
      { { 17, 21 },
        { 240, 16 },
        { 168, 136 },
        { 8, 15 }, },
      { { 19, 187 },
        { 247, 3 },
        { 221, 200 },
        { 192, 239 }, },
      { { 12, 32 },
        { 2, 68 },
        { 4, 48 },
        { 34, 64 }, },
      { { 12, 201 },
        { 16, 103 },
        { 147, 48 },
        { 230, 8 }, },
      { { 12, 220 },
        { 32, 119 },
        { 59, 48 },
        { 238, 4 }, },
      { { 12, 54 },
        { 35, 84 },
        { 108, 48 },
        { 42, 196 }, },
      { { 6, 20 },
        { 36, 80 },
        { 40, 96 },
        { 10, 36 }, },
      { { 6, 114 },
        { 39, 96 },
        { 78, 96 },
        { 6, 228 }, },
      { { 13, 97 },
        { 82, 100 },
        { 134, 176 },
        { 38, 74 }, },
      { { 5, 13 },
        { 80, 81 },
        { 176, 160 },
        { 138, 10 }, },
      { { 13, 143 },
        { 81, 87 },
        { 241, 176 },
        { 234, 138 }, },
      { { 15, 224 },
        { 70, 102 },
        { 7, 240 },
        { 102, 98 }, },
      { { 15, 73 },
        { 84, 101 },
        { 146, 240 },
        { 166, 42 }, },
      { { 7, 133 },
        { 84, 82 },
        { 161, 224 },
        { 74, 42 }, },
      { { 5, 144 },
        { 96, 66 },
        { 9, 160 },
        { 66, 6 }, },
      { { 13, 51 },
        { 115, 68 },
        { 204, 176 },
        { 34, 206 }, },
      { { 15, 150 },
        { 101, 86 },
        { 105, 240 },
        { 106, 166 }, },
      { { 15, 118 },
        { 103, 116 },
        { 110, 240 },
        { 46, 230 }, },
      { { 20, 96 },
        { 130, 96 },
        { 6, 40 },
        { 6, 65 }, },
      { { 28, 141 },
        { 144, 87 },
        { 177, 56 },
        { 234, 9 }, },
      { { 20, 218 },
        { 161, 99 },
        { 91, 40 },
        { 198, 133 }, },
      { { 28, 115 },
        { 179, 100 },
        { 206, 56 },
        { 38, 205 }, },
      { { 30, 148 },
        { 164, 86 },
        { 41, 120 },
        { 106, 37 }, },
      { { 30, 186 },
        { 167, 71 },
        { 93, 120 },
        { 226, 229 }, },
      { { 22, 217 },
        { 180, 99 },
        { 155, 104 },
        { 198, 45 }, },
      { { 30, 61 },
        { 182, 85 },
        { 188, 120 },
        { 170, 109 }, },
      { { 22, 251 },
        { 183, 99 },
        { 223, 104 },
        { 198, 237 }, },
      { { 29, 233 },
        { 210, 103 },
        { 151, 184 },
        { 230, 75 }, },
      { { 29, 254 },
        { 227, 119 },
        { 127, 184 },
        { 238, 199 }, },
      { { 31, 159 },
        { 245, 87 },
        { 249, 248 },
        { 234, 175 }, },
      { { 40, 139 },
        { 25, 7 },
        { 209, 20 },
        { 224, 152 }, },
      { { 32, 175 },
        { 27, 19 },
        { 245, 4 },
        { 200, 216 }, },
      { { 34, 14 },
        { 13, 17 },
        { 112, 68 },
        { 136, 176 }, },
      { { 34, 169 },
        { 30, 3 },
        { 149, 68 },
        { 192, 120 }, },
      { { 42, 141 },
        { 28, 23 },
        { 177, 84 },
        { 232, 56 }, },
      { { 42, 163 },
        { 31, 6 },
        { 197, 84 },
        { 96, 248 }, },
      { { 42, 239 },
        { 31, 55 },
        { 247, 84 },
        { 236, 248 }, },
      { { 40, 144 },
        { 40, 6 },
        { 9, 20 },
        { 96, 20 }, },
      { { 40, 59 },
        { 59, 5 },
        { 220, 20 },
        { 160, 220 }, },
      { { 42, 88 },
        { 44, 37 },
        { 26, 84 },
        { 164, 52 }, },
      { { 34, 51 },
        { 63, 0 },
        { 204, 68 },
        { 0, 252 }, },
      { { 33, 160 },
        { 74, 2 },
        { 5, 132 },
        { 64, 82 }, },
      { { 33, 2 },
        { 73, 0 },
        { 64, 132 },
        { 0, 146 }, },
      { { 33, 165 },
        { 90, 18 },
        { 165, 132 },
        { 72, 90 }, },
      { { 33, 199 },
        { 89, 50 },
        { 227, 132 },
        { 76, 154 }, },
      { { 43, 3 },
        { 93, 4 },
        { 192, 212 },
        { 32, 186 }, },
      { { 35, 103 },
        { 95, 48 },
        { 230, 196 },
        { 12, 250 }, },
      { { 41, 48 },
        { 106, 4 },
        { 12, 148 },
        { 32, 86 }, },
      { { 41, 210 },
        { 105, 38 },
        { 75, 148 },
        { 100, 150 }, },
      { { 43, 25 },
        { 124, 5 },
        { 152, 212 },
        { 160, 62 }, },
      { { 43, 155 },
        { 125, 7 },
        { 217, 212 },
        { 224, 190 }, },
      { { 43, 151 },
        { 125, 22 },
        { 233, 212 },
        { 104, 190 }, },
      { { 56, 40 },
        { 138, 5 },
        { 20, 28 },
        { 160, 81 }, },
      { { 56, 165 },
        { 154, 22 },
        { 165, 28 },
        { 104, 89 }, },
      { { 58, 134 },
        { 141, 22 },
        { 97, 92 },
        { 104, 177 }, },
      { { 50, 1 },
        { 156, 0 },
        { 128, 76 },
        { 0, 57 }, },
      { { 56, 159 },
        { 185, 23 },
        { 249, 28 },
        { 232, 157 }, },
      { { 50, 210 },
        { 173, 34 },
        { 75, 76 },
        { 68, 181 }, },
      { { 58, 153 },
        { 188, 7 },
        { 153, 92 },
        { 224, 61 }, },
      { { 58, 213 },
        { 188, 54 },
        { 171, 92 },
        { 108, 61 }, },
      { { 57, 232 },
        { 202, 39 },
        { 23, 156 },
        { 228, 83 }, },
      { { 59, 193 },
        { 220, 38 },
        { 131, 220 },
        { 100, 59 }, },
      { { 51, 67 },
        { 221, 32 },
        { 194, 204 },
        { 4, 187 }, },
      { { 59, 231 },
        { 223, 54 },
        { 231, 220 },
        { 108, 251 }, },
      { { 49, 154 },
        { 233, 3 },
        { 89, 140 },
        { 192, 151 }, },
      { { 51, 144 },
        { 236, 2 },
        { 9, 204 },
        { 64, 55 }, },
      { { 59, 158 },
        { 237, 23 },
        { 121, 220 },
        { 232, 183 }, },
      { { 36, 196 },
        { 8, 114 },
        { 35, 36 },
        { 78, 16 }, },
      { { 44, 74 },
        { 9, 101 },
        { 82, 52 },
        { 166, 144 }, },
      { { 44, 173 },
        { 26, 87 },
        { 181, 52 },
        { 234, 88 }, },
      { { 44, 207 },
        { 25, 119 },
        { 243, 52 },
        { 238, 152 }, },
      { { 44, 103 },
        { 27, 116 },
        { 230, 52 },
        { 46, 216 }, },
      { { 38, 234 },
        { 15, 99 },
        { 87, 100 },
        { 198, 240 }, },
      { { 46, 229 },
        { 30, 118 },
        { 167, 116 },
        { 110, 120 }, },
      { { 44, 112 },
        { 42, 100 },
        { 14, 52 },
        { 38, 84 }, },
      { { 46, 18 },
        { 45, 68 },
        { 72, 116 },
        { 34, 180 }, },
      { { 46, 209 },
        { 60, 102 },
        { 139, 116 },
        { 102, 60 }, },
      { { 46, 57 },
        { 62, 69 },
        { 156, 116 },
        { 162, 124 }, },
      { { 37, 100 },
        { 74, 112 },
        { 38, 164 },
        { 14, 82 }, },
      { { 37, 231 },
        { 91, 114 },
        { 231, 164 },
        { 78, 218 }, },
      { { 47, 204 },
        { 76, 119 },
        { 51, 244 },
        { 238, 50 }, },
      { { 45, 188 },
        { 106, 87 },
        { 61, 180 },
        { 234, 86 }, },
      { { 45, 113 },
        { 122, 100 },
        { 142, 180 },
        { 38, 94 }, },
      { { 37, 213 },
        { 120, 114 },
        { 171, 164 },
        { 78, 30 }, },
      { { 37, 155 },
        { 121, 67 },
        { 217, 164 },
        { 194, 158 }, },
      { { 39, 16 },
        { 108, 64 },
        { 8, 228 },
        { 2, 54 }, },
      { { 47, 124 },
        { 110, 117 },
        { 62, 244 },
        { 174, 118 }, },
      { { 39, 242 },
        { 111, 98 },
        { 79, 228 },
        { 70, 246 }, },
      { { 39, 58 },
        { 111, 65 },
        { 92, 228 },
        { 130, 246 }, },
      { { 47, 182 },
        { 111, 86 },
        { 109, 244 },
        { 106, 246 }, },
      { { 39, 211 },
        { 125, 98 },
        { 203, 228 },
        { 70, 190 }, },
      { { 47, 179 },
        { 127, 70 },
        { 205, 244 },
        { 98, 254 }, },
      { { 39, 31 },
        { 125, 81 },
        { 248, 228 },
        { 138, 190 }, },
      { { 60, 75 },
        { 153, 101 },
        { 210, 60 },
        { 166, 153 }, },
      { { 54, 192 },
        { 140, 98 },
        { 3, 108 },
        { 70, 49 }, },
      { { 54, 238 },
        { 143, 115 },
        { 119, 108 },
        { 206, 241 }, },
      { { 62, 233 },
        { 158, 103 },
        { 151, 124 },
        { 230, 121 }, },
      { { 52, 184 },
        { 170, 67 },
        { 29, 44 },
        { 194, 85 }, },
      { { 60, 20 },
        { 168, 84 },
        { 40, 60 },
        { 42, 21 }, },
      { { 60, 82 },
        { 169, 100 },
        { 74, 60 },
        { 38, 149 }, },
      { { 52, 114 },
        { 171, 96 },
        { 78, 44 },
        { 6, 213 }, },
      { { 52, 126 },
        { 171, 113 },
        { 126, 44 },
        { 142, 213 }, },
      { { 52, 191 },
        { 187, 83 },
        { 253, 44 },
        { 202, 221 }, },
      { { 62, 113 },
        { 190, 100 },
        { 142, 124 },
        { 38, 125 }, },
      { { 62, 83 },
        { 189, 100 },
        { 202, 124 },
        { 38, 189 }, },
      { { 61, 140 },
        { 200, 87 },
        { 49, 188 },
        { 234, 19 }, },
      { { 53, 162 },
        { 203, 66 },
        { 69, 172 },
        { 66, 211 }, },
      { { 53, 46 },
        { 203, 81 },
        { 116, 172 },
        { 138, 211 }, },
      { { 53, 45 },
        { 218, 81 },
        { 180, 172 },
        { 138, 91 }, },
      { { 55, 172 },
        { 206, 83 },
        { 53, 236 },
        { 202, 115 }, },
      { { 53, 112 },
        { 234, 96 },
        { 14, 172 },
        { 6, 87 }, },
      { { 55, 250 },
        { 239, 99 },
        { 95, 236 },
        { 198, 247 }, },
      { { 63, 241 },
        { 254, 102 },
        { 143, 252 },
        { 102, 127 }, },
      { { 63, 219 },
        { 253, 103 },
        { 219, 252 },
        { 230, 191 }, },
      { { 72, 196 },
        { 0, 182 },
        { 35, 18 },
        { 109, 0 }, },
      { { 72, 233 },
        { 18, 167 },
        { 151, 18 },
        { 229, 72 }, },
      { { 74, 194 },
        { 5, 166 },
        { 67, 82 },
        { 101, 160 }, },
      { { 74, 65 },
        { 20, 164 },
        { 130, 82 },
        { 37, 40 }, },
      { { 66, 235 },
        { 23, 163 },
        { 215, 66 },
        { 197, 232 }, },
      { { 72, 19 },
        { 49, 132 },
        { 200, 18 },
        { 33, 140 }, },
      { { 74, 216 },
        { 36, 167 },
        { 27, 82 },
        { 229, 36 }, },
      { { 66, 253 },
        { 54, 179 },
        { 191, 66 },
        { 205, 108 }, },
      { { 74, 23 },
        { 53, 148 },
        { 232, 82 },
        { 41, 172 }, },
      { { 73, 99 },
        { 83, 164 },
        { 198, 146 },
        { 37, 202 }, },
      { { 67, 110 },
        { 71, 177 },
        { 118, 194 },
        { 141, 226 }, },
      { { 65, 58 },
        { 99, 129 },
        { 92, 130 },
        { 129, 198 }, },
      { { 73, 177 },
        { 114, 134 },
        { 141, 146 },
        { 97, 78 }, },
      { { 65, 61 },
        { 114, 145 },
        { 188, 130 },
        { 137, 78 }, },
      { { 75, 146 },
        { 101, 134 },
        { 73, 210 },
        { 97, 166 }, },
      { { 75, 155 },
        { 117, 135 },
        { 217, 210 },
        { 225, 174 }, },
      { { 67, 63 },
        { 119, 145 },
        { 252, 194 },
        { 137, 238 }, },
      { { 88, 34 },
        { 131, 132 },
        { 68, 26 },
        { 33, 193 }, },
      { { 80, 170 },
        { 131, 131 },
        { 85, 10 },
        { 193, 193 }, },
      { { 88, 39 },
        { 147, 148 },
        { 228, 26 },
        { 41, 201 }, },
      { { 82, 200 },
        { 132, 163 },
        { 19, 74 },
        { 197, 33 }, },
      { { 82, 132 },
        { 132, 146 },
        { 33, 74 },
        { 73, 33 }, },
      { { 82, 10 },
        { 133, 129 },
        { 80, 74 },
        { 129, 161 }, },
      { { 90, 15 },
        { 149, 149 },
        { 240, 90 },
        { 169, 169 }, },
      { { 88, 152 },
        { 160, 135 },
        { 25, 26 },
        { 225, 5 }, },
      { { 88, 92 },
        { 160, 181 },
        { 58, 26 },
        { 173, 5 }, },
      { { 80, 219 },
        { 177, 163 },
        { 219, 10 },
        { 197, 141 }, },
      { { 80, 247 },
        { 179, 178 },
        { 239, 10 },
        { 77, 205 }, },
      { { 90, 244 },
        { 166, 182 },
        { 47, 90 },
        { 109, 101 }, },
      { { 81, 236 },
        { 194, 179 },
        { 55, 138 },
        { 205, 67 }, },
      { { 81, 66 },
        { 193, 160 },
        { 66, 138 },
        { 5, 131 }, },
      { { 81, 13 },
        { 208, 145 },
        { 176, 138 },
        { 137, 11 }, },
      { { 91, 3 },
        { 213, 132 },
        { 192, 218 },
        { 33, 171 }, },
      { { 83, 235 },
        { 215, 163 },
        { 215, 202 },
        { 197, 235 }, },
      { { 81, 118 },
        { 227, 176 },
        { 110, 138 },
        { 13, 199 }, },
      { { 89, 113 },
        { 242, 164 },
        { 142, 154 },
        { 37, 79 }, },
      { { 81, 147 },
        { 241, 130 },
        { 201, 138 },
        { 65, 143 }, },
      { { 83, 249 },
        { 246, 163 },
        { 159, 202 },
        { 197, 111 }, },
      { { 91, 179 },
        { 247, 134 },
        { 205, 218 },
        { 97, 239 }, },
      { { 83, 151 },
        { 245, 146 },
        { 233, 202 },
        { 73, 175 }, },
      { { 76, 76 },
        { 0, 245 },
        { 50, 50 },
        { 175, 0 }, },
      { { 68, 75 },
        { 17, 225 },
        { 210, 34 },
        { 135, 136 }, },
      { { 76, 35 },
        { 19, 196 },
        { 196, 50 },
        { 35, 200 }, },
      { { 70, 140 },
        { 4, 211 },
        { 49, 98 },
        { 203, 32 }, },
      { { 78, 39 },
        { 23, 212 },
        { 228, 114 },
        { 43, 232 }, },
      { { 70, 144 },
        { 36, 194 },
        { 9, 98 },
        { 67, 36 }, },
      { { 78, 212 },
        { 36, 246 },
        { 43, 114 },
        { 111, 36 }, },
      { { 69, 206 },
        { 65, 243 },
        { 115, 162 },
        { 207, 130 }, },
      { { 69, 229 },
        { 82, 242 },
        { 167, 162 },
        { 79, 74 }, },
      { { 69, 39 },
        { 83, 208 },
        { 228, 162 },
        { 11, 202 }, },
      { { 79, 193 },
        { 84, 230 },
        { 131, 242 },
        { 103, 42 }, },
      { { 71, 5 },
        { 84, 208 },
        { 160, 226 },
        { 11, 42 }, },
      { { 69, 52 },
        { 98, 208 },
        { 44, 162 },
        { 11, 70 }, },
      { { 69, 114 },
        { 99, 224 },
        { 78, 162 },
        { 7, 198 }, },
      { { 92, 200 },
        { 128, 231 },
        { 19, 58 },
        { 231, 1 }, },
      { { 92, 14 },
        { 129, 213 },
        { 112, 58 },
        { 171, 129 }, },
      { { 84, 235 },
        { 147, 227 },
        { 215, 42 },
        { 199, 201 }, },
      { { 86, 137 },
        { 148, 195 },
        { 145, 106 },
        { 195, 41 }, },
      { { 86, 67 },
        { 149, 224 },
        { 194, 106 },
        { 7, 169 }, },
      { { 94, 231 },
        { 151, 246 },
        { 231, 122 },
        { 111, 233 }, },
      { { 92, 112 },
        { 162, 228 },
        { 14, 58 },
        { 39, 69 }, },
      { { 84, 178 },
        { 163, 194 },
        { 77, 42 },
        { 67, 197 }, },
      { { 94, 121 },
        { 182, 229 },
        { 158, 122 },
        { 167, 109 }, },
      { { 86, 243 },
        { 183, 226 },
        { 207, 106 },
        { 71, 237 }, },
      { { 93, 163 },
        { 211, 198 },
        { 197, 186 },
        { 99, 203 }, },
      { { 93, 242 },
        { 227, 230 },
        { 79, 186 },
        { 103, 199 }, },
      { { 85, 29 },
        { 240, 209 },
        { 184, 170 },
        { 139, 15 }, },
      { { 93, 157 },
        { 240, 215 },
        { 185, 186 },
        { 235, 15 }, },
      { { 87, 252 },
        { 230, 243 },
        { 63, 234 },
        { 207, 103 }, },
      { { 87, 210 },
        { 229, 226 },
        { 75, 234 },
        { 71, 167 }, },
      { { 95, 115 },
        { 247, 228 },
        { 206, 250 },
        { 39, 239 }, },
      { { 104, 45 },
        { 26, 149 },
        { 180, 22 },
        { 169, 88 }, },
      { { 104, 195 },
        { 25, 166 },
        { 195, 22 },
        { 101, 152 }, },
      { { 104, 135 },
        { 25, 150 },
        { 225, 22 },
        { 105, 152 }, },
      { { 106, 74 },
        { 13, 165 },
        { 82, 86 },
        { 165, 176 }, },
      { { 98, 105 },
        { 30, 161 },
        { 150, 70 },
        { 133, 120 }, },
      { { 96, 185 },
        { 58, 131 },
        { 157, 6 },
        { 193, 92 }, },
      { { 104, 255 },
        { 59, 183 },
        { 255, 22 },
        { 237, 220 }, },
      { { 106, 220 },
        { 44, 183 },
        { 59, 86 },
        { 237, 52 }, },
      { { 106, 218 },
        { 45, 167 },
        { 91, 86 },
        { 229, 180 }, },
      { { 106, 62 },
        { 47, 149 },
        { 124, 86 },
        { 169, 244 }, },
      { { 106, 81 },
        { 60, 164 },
        { 138, 86 },
        { 37, 60 }, },
      { { 106, 49 },
        { 62, 132 },
        { 140, 86 },
        { 33, 124 }, },
      { { 98, 215 },
        { 61, 178 },
        { 235, 70 },
        { 77, 188 }, },
      { { 97, 204 },
        { 72, 179 },
        { 51, 134 },
        { 205, 18 }, },
      { { 107, 130 },
        { 77, 134 },
        { 65, 214 },
        { 97, 178 }, },
      { { 107, 227 },
        { 95, 166 },
        { 199, 214 },
        { 101, 250 }, },
      { { 105, 58 },
        { 107, 133 },
        { 92, 150 },
        { 161, 214 }, },
      { { 97, 158 },
        { 105, 147 },
        { 121, 134 },
        { 201, 150 }, },
      { { 97, 149 },
        { 120, 146 },
        { 169, 134 },
        { 73, 30 }, },
      { { 97, 117 },
        { 122, 176 },
        { 174, 134 },
        { 13, 94 }, },
      { { 105, 95 },
        { 121, 181 },
        { 250, 150 },
        { 173, 158 }, },
      { { 105, 55 },
        { 123, 148 },
        { 236, 150 },
        { 41, 222 }, },
      { { 99, 218 },
        { 109, 163 },
        { 91, 198 },
        { 197, 182 }, },
      { { 112, 2 },
        { 137, 128 },
        { 64, 14 },
        { 1, 145 }, },
      { { 120, 99 },
        { 155, 164 },
        { 198, 30 },
        { 37, 217 }, },
      { { 112, 79 },
        { 153, 177 },
        { 242, 14 },
        { 141, 153 }, },
      { { 114, 202 },
        { 141, 163 },
        { 83, 78 },
        { 197, 177 }, },
      { { 122, 173 },
        { 158, 151 },
        { 181, 94 },
        { 233, 121 }, },
      { { 112, 123 },
        { 187, 161 },
        { 222, 14 },
        { 133, 221 }, },
      { { 122, 20 },
        { 172, 148 },
        { 40, 94 },
        { 41, 53 }, },
      { { 122, 249 },
        { 190, 167 },
        { 159, 94 },
        { 229, 125 }, },
      { { 122, 211 },
        { 189, 166 },
        { 203, 94 },
        { 101, 189 }, },
      { { 122, 187 },
        { 191, 135 },
        { 221, 94 },
        { 225, 253 }, },
      { { 121, 226 },
        { 203, 166 },
        { 71, 158 },
        { 101, 211 }, },
      { { 113, 41 },
        { 218, 129 },
        { 148, 142 },
        { 129, 91 }, },
      { { 123, 103 },
        { 223, 180 },
        { 230, 222 },
        { 45, 251 }, },
      { { 113, 208 },
        { 232, 162 },
        { 11, 142 },
        { 69, 23 }, },
      { { 121, 57 },
        { 250, 133 },
        { 156, 158 },
        { 161, 95 }, },
      { { 115, 48 },
        { 238, 128 },
        { 12, 206 },
        { 1, 119 }, },
      { { 115, 185 },
        { 254, 131 },
        { 157, 206 },
        { 193, 127 }, },
      { { 115, 83 },
        { 253, 160 },
        { 202, 206 },
        { 5, 191 }, },
      { { 115, 255 },
        { 255, 179 },
        { 255, 206 },
        { 205, 255 }, },
      { { 108, 136 },
        { 8, 199 },
        { 17, 54 },
        { 227, 16 }, },
      { { 100, 9 },
        { 24, 193 },
        { 144, 38 },
        { 131, 24 }, },
      { { 108, 67 },
        { 25, 228 },
        { 194, 54 },
        { 39, 152 }, },
      { { 102, 6 },
        { 13, 208 },
        { 96, 102 },
        { 11, 176 }, },
      { { 102, 131 },
        { 29, 194 },
        { 193, 102 },
        { 67, 184 }, },
      { { 100, 176 },
        { 42, 194 },
        { 13, 38 },
        { 67, 84 }, },
      { { 100, 218 },
        { 41, 227 },
        { 91, 38 },
        { 199, 148 }, },
      { { 110, 159 },
        { 61, 215 },
        { 249, 118 },
        { 235, 188 }, },
      { { 103, 200 },
        { 76, 227 },
        { 19, 230 },
        { 199, 50 }, },
      { { 111, 238 },
        { 79, 247 },
        { 119, 246 },
        { 239, 242 }, },
      { { 109, 59 },
        { 123, 197 },
        { 220, 182 },
        { 163, 222 }, },
      { { 111, 210 },
        { 109, 230 },
        { 75, 246 },
        { 103, 182 }, },
      { { 116, 128 },
        { 136, 194 },
        { 1, 46 },
        { 67, 17 }, },
      { { 124, 171 },
        { 155, 199 },
        { 213, 62 },
        { 227, 217 }, },
      { { 126, 104 },
        { 142, 229 },
        { 22, 126 },
        { 167, 113 }, },
      { { 126, 2 },
        { 141, 196 },
        { 64, 126 },
        { 35, 177 }, },
      { { 124, 156 },
        { 168, 215 },
        { 57, 62 },
        { 235, 21 }, },
      { { 116, 54 },
        { 171, 208 },
        { 108, 46 },
        { 11, 213 }, },
      { { 124, 17 },
        { 184, 196 },
        { 136, 62 },
        { 35, 29 }, },
      { { 126, 222 },
        { 173, 247 },
        { 123, 126 },
        { 239, 181 }, },
      { { 126, 182 },
        { 175, 214 },
        { 109, 126 },
        { 107, 245 }, },
      { { 118, 219 },
        { 189, 227 },
        { 219, 110 },
        { 199, 189 }, },
      { { 125, 196 },
        { 200, 246 },
        { 35, 190 },
        { 111, 19 }, },
      { { 125, 138 },
        { 201, 199 },
        { 81, 190 },
        { 227, 147 }, },
      { { 117, 109 },
        { 218, 241 },
        { 182, 174 },
        { 143, 91 }, },
      { { 119, 136 },
        { 204, 195 },
        { 17, 238 },
        { 195, 51 }, },
      { { 119, 32 },
        { 206, 192 },
        { 4, 238 },
        { 3, 115 }, },
      { { 119, 65 },
        { 220, 224 },
        { 130, 238 },
        { 7, 59 }, },
      { { 117, 56 },
        { 234, 193 },
        { 28, 174 },
        { 131, 87 }, },
      { { 117, 190 },
        { 235, 211 },
        { 125, 174 },
        { 203, 215 }, },
      { { 125, 155 },
        { 249, 199 },
        { 217, 190 },
        { 227, 159 }, },
      { { 119, 87 },
        { 253, 240 },
        { 234, 238 },
        { 15, 191 }, },
      { { 136, 40 },
        { 2, 13 },
        { 20, 17 },
        { 176, 64 }, },
      { { 128, 172 },
        { 2, 27 },
        { 53, 1 },
        { 216, 64 }, },
      { { 136, 13 },
        { 16, 29 },
        { 176, 17 },
        { 184, 8 }, },
      { { 136, 103 },
        { 19, 60 },
        { 230, 17 },
        { 60, 200 }, },
      { { 130, 78 },
        { 5, 57 },
        { 114, 65 },
        { 156, 160 }, },
      { { 138, 161 },
        { 22, 14 },
        { 133, 81 },
        { 112, 104 }, },
      { { 130, 43 },
        { 23, 9 },
        { 212, 65 },
        { 144, 232 }, },
      { { 128, 24 },
        { 32, 9 },
        { 24, 1 },
        { 144, 4 }, },
      { { 136, 249 },
        { 50, 47 },
        { 159, 17 },
        { 244, 76 }, },
      { { 128, 157 },
        { 48, 27 },
        { 185, 1 },
        { 216, 12 }, },
      { { 138, 156 },
        { 36, 31 },
        { 57, 81 },
        { 248, 36 }, },
      { { 130, 49 },
        { 54, 8 },
        { 140, 65 },
        { 16, 108 }, },
      { { 138, 117 },
        { 54, 60 },
        { 174, 81 },
        { 60, 108 }, },
      { { 130, 151 },
        { 53, 26 },
        { 233, 65 },
        { 88, 172 }, },
      { { 129, 9 },
        { 80, 9 },
        { 144, 129 },
        { 144, 10 }, },
      { { 129, 235 },
        { 83, 43 },
        { 215, 129 },
        { 212, 202 }, },
      { { 129, 7 },
        { 81, 24 },
        { 224, 129 },
        { 24, 138 }, },
      { { 139, 40 },
        { 70, 13 },
        { 20, 209 },
        { 176, 98 }, },
      { { 139, 172 },
        { 70, 31 },
        { 53, 209 },
        { 248, 98 }, },
      { { 131, 46 },
        { 71, 25 },
        { 116, 193 },
        { 152, 226 }, },
      { { 131, 229 },
        { 86, 58 },
        { 167, 193 },
        { 92, 106 }, },
      { { 129, 80 },
        { 96, 40 },
        { 10, 129 },
        { 20, 6 }, },
      { { 137, 50 },
        { 99, 12 },
        { 76, 145 },
        { 48, 198 }, },
      { { 139, 122 },
        { 103, 45 },
        { 94, 209 },
        { 180, 230 }, },
      { { 139, 150 },
        { 101, 30 },
        { 105, 209 },
        { 120, 166 }, },
      { { 131, 125 },
        { 118, 57 },
        { 190, 193 },
        { 156, 110 }, },
      { { 144, 135 },
        { 145, 26 },
        { 225, 9 },
        { 88, 137 }, },
      { { 154, 252 },
        { 166, 63 },
        { 63, 89 },
        { 252, 101 }, },
      { { 146, 245 },
        { 182, 58 },
        { 175, 73 },
        { 92, 109 }, },
      { { 145, 170 },
        { 195, 11 },
        { 85, 137 },
        { 208, 195 }, },
      { { 147, 65 },
        { 212, 40 },
        { 130, 201 },
        { 20, 43 }, },
      { { 147, 37 },
        { 214, 24 },
        { 164, 201 },
        { 24, 107 }, },
      { { 155, 235 },
        { 215, 47 },
        { 215, 217 },
        { 244, 235 }, },
      { { 153, 52 },
        { 226, 28 },
        { 44, 153 },
        { 56, 71 }, },
      { { 145, 247 },
        { 243, 58 },
        { 239, 137 },
        { 92, 207 }, },
      { { 155, 218 },
        { 229, 47 },
        { 91, 217 },
        { 244, 167 }, },
      { { 147, 86 },
        { 229, 56 },
        { 106, 201 },
        { 28, 167 }, },
      { { 132, 66 },
        { 1, 104 },
        { 66, 33 },
        { 22, 128 }, },
      { { 140, 129 },
        { 16, 78 },
        { 129, 49 },
        { 114, 8 }, },
      { { 140, 79 },
        { 17, 125 },
        { 242, 49 },
        { 190, 136 }, },
      { { 134, 72 },
        { 4, 105 },
        { 18, 97 },
        { 150, 32 }, },
      { { 134, 166 },
        { 7, 90 },
        { 101, 97 },
        { 90, 224 }, },
      { { 142, 3 },
        { 21, 76 },
        { 192, 113 },
        { 50, 168 }, },
      { { 134, 227 },
        { 23, 106 },
        { 199, 97 },
        { 86, 232 }, },
      { { 134, 111 },
        { 23, 121 },
        { 246, 97 },
        { 158, 232 }, },
      { { 142, 175 },
        { 23, 95 },
        { 245, 113 },
        { 250, 232 }, },
      { { 132, 94 },
        { 33, 121 },
        { 122, 33 },
        { 158, 132 }, },
      { { 132, 119 },
        { 51, 120 },
        { 238, 33 },
        { 30, 204 }, },
      { { 134, 250 },
        { 39, 107 },
        { 95, 97 },
        { 214, 228 }, },
      { { 142, 30 },
        { 37, 93 },
        { 120, 113 },
        { 186, 164 }, },
      { { 142, 55 },
        { 55, 92 },
        { 236, 113 },
        { 58, 236 }, },
      { { 135, 10 },
        { 69, 73 },
        { 80, 225 },
        { 146, 162 }, },
      { { 143, 138 },
        { 69, 79 },
        { 81, 241 },
        { 242, 162 }, },
      { { 143, 38 },
        { 71, 92 },
        { 100, 241 },
        { 58, 226 }, },
      { { 135, 33 },
        { 86, 72 },
        { 132, 225 },
        { 18, 106 }, },
      { { 135, 13 },
        { 84, 89 },
        { 176, 225 },
        { 154, 42 }, },
      { { 133, 114 },
        { 99, 104 },
        { 78, 161 },
        { 22, 198 }, },
      { { 135, 62 },
        { 103, 89 },
        { 124, 225 },
        { 154, 230 }, },
      { { 156, 67 },
        { 145, 108 },
        { 194, 57 },
        { 54, 137 }, },
      { { 158, 97 },
        { 150, 108 },
        { 134, 121 },
        { 54, 105 }, },
      { { 148, 88 },
        { 160, 105 },
        { 26, 41 },
        { 150, 5 }, },
      { { 148, 248 },
        { 162, 107 },
        { 31, 41 },
        { 214, 69 }, },
      { { 156, 50 },
        { 163, 76 },
        { 76, 57 },
        { 50, 197 }, },
      { { 148, 118 },
        { 163, 120 },
        { 110, 41 },
        { 30, 197 }, },
      { { 148, 177 },
        { 178, 74 },
        { 141, 41 },
        { 82, 77 }, },
      { { 148, 221 },
        { 176, 123 },
        { 187, 41 },
        { 222, 13 }, },
      { { 148, 155 },
        { 177, 75 },
        { 217, 41 },
        { 210, 141 }, },
      { { 156, 219 },
        { 177, 111 },
        { 219, 57 },
        { 246, 141 }, },
      { { 158, 156 },
        { 164, 95 },
        { 57, 121 },
        { 250, 37 }, },
      { { 158, 210 },
        { 165, 110 },
        { 75, 121 },
        { 118, 165 }, },
      { { 150, 25 },
        { 180, 73 },
        { 152, 105 },
        { 146, 45 }, },
      { { 158, 177 },
        { 182, 78 },
        { 141, 121 },
        { 114, 109 }, },
      { { 149, 105 },
        { 210, 105 },
        { 150, 169 },
        { 150, 75 }, },
      { { 159, 109 },
        { 214, 125 },
        { 182, 249 },
        { 190, 107 }, },
      { { 151, 43 },
        { 215, 73 },
        { 212, 233 },
        { 146, 235 }, },
      { { 149, 182 },
        { 227, 90 },
        { 109, 169 },
        { 90, 199 }, },
      { { 149, 185 },
        { 242, 75 },
        { 157, 169 },
        { 210, 79 }, },
      { { 157, 61 },
        { 242, 93 },
        { 188, 185 },
        { 186, 79 }, },
      { { 157, 87 },
        { 241, 124 },
        { 234, 185 },
        { 62, 143 }, },
      { { 168, 236 },
        { 10, 63 },
        { 55, 21 },
        { 252, 80 }, },
      { { 168, 37 },
        { 26, 28 },
        { 164, 21 },
        { 56, 88 }, },
      { { 162, 172 },
        { 14, 27 },
        { 53, 69 },
        { 216, 112 }, },
      { { 162, 2 },
        { 13, 8 },
        { 64, 69 },
        { 16, 176 }, },
      { { 170, 102 },
        { 15, 60 },
        { 102, 85 },
        { 60, 240 }, },
      { { 170, 143 },
        { 29, 31 },
        { 241, 85 },
        { 248, 184 }, },
      { { 170, 231 },
        { 31, 62 },
        { 231, 85 },
        { 124, 248 }, },
      { { 168, 48 },
        { 42, 12 },
        { 12, 21 },
        { 48, 84 }, },
      { { 168, 122 },
        { 43, 45 },
        { 94, 21 },
        { 180, 212 }, },
      { { 168, 246 },
        { 43, 62 },
        { 111, 21 },
        { 124, 212 }, },
      { { 168, 147 },
        { 57, 14 },
        { 201, 21 },
        { 112, 156 }, },
      { { 162, 20 },
        { 44, 24 },
        { 40, 69 },
        { 24, 52 }, },
      { { 170, 52 },
        { 46, 28 },
        { 44, 85 },
        { 56, 116 }, },
      { { 162, 114 },
        { 47, 40 },
        { 78, 69 },
        { 20, 244 }, },
      { { 170, 242 },
        { 47, 46 },
        { 79, 85 },
        { 116, 244 }, },
      { { 162, 241 },
        { 62, 42 },
        { 143, 69 },
        { 84, 124 }, },
      { { 161, 64 },
        { 72, 40 },
        { 2, 133 },
        { 20, 18 }, },
      { { 169, 10 },
        { 73, 13 },
        { 80, 149 },
        { 176, 146 }, },
      { { 161, 38 },
        { 75, 24 },
        { 100, 133 },
        { 24, 210 }, },
      { { 169, 197 },
        { 88, 62 },
        { 163, 149 },
        { 124, 26 }, },
      { { 169, 207 },
        { 89, 63 },
        { 243, 149 },
        { 252, 154 }, },
      { { 161, 52 },
        { 106, 24 },
        { 44, 133 },
        { 24, 86 }, },
      { { 169, 18 },
        { 105, 12 },
        { 72, 149 },
        { 48, 150 }, },
      { { 161, 250 },
        { 107, 43 },
        { 95, 133 },
        { 212, 214 }, },
      { { 171, 152 },
        { 108, 15 },
        { 25, 213 },
        { 240, 54 }, },
      { { 163, 247 },
        { 127, 58 },
        { 239, 197 },
        { 92, 254 }, },
      { { 176, 6 },
        { 137, 24 },
        { 96, 13 },
        { 24, 145 }, },
      { { 176, 69 },
        { 152, 56 },
        { 162, 13 },
        { 28, 25 }, },
      { { 184, 141 },
        { 152, 31 },
        { 177, 29 },
        { 248, 25 }, },
      { { 178, 132 },
        { 140, 26 },
        { 33, 77 },
        { 88, 49 }, },
      { { 184, 240 },
        { 170, 46 },
        { 15, 29 },
        { 116, 85 }, },
      { { 184, 85 },
        { 184, 60 },
        { 170, 29 },
        { 60, 29 }, },
      { { 178, 118 },
        { 175, 56 },
        { 110, 77 },
        { 28, 245 }, },
      { { 186, 145 },
        { 188, 14 },
        { 137, 93 },
        { 112, 61 }, },
      { { 178, 113 },
        { 190, 40 },
        { 142, 77 },
        { 20, 125 }, },
      { { 185, 192 },
        { 200, 46 },
        { 3, 157 },
        { 116, 19 }, },
      { { 185, 66 },
        { 201, 44 },
        { 66, 157 },
        { 52, 147 }, },
      { { 185, 42 },
        { 203, 13 },
        { 84, 157 },
        { 176, 211 }, },
      { { 179, 140 },
        { 204, 27 },
        { 49, 205 },
        { 216, 51 }, },
      { { 179, 202 },
        { 205, 43 },
        { 83, 205 },
        { 212, 179 }, },
      { { 187, 102 },
        { 207, 60 },
        { 102, 221 },
        { 60, 243 }, },
      { { 179, 15 },
        { 221, 25 },
        { 240, 205 },
        { 152, 187 }, },
      { { 177, 218 },
        { 233, 43 },
        { 91, 141 },
        { 212, 151 }, },
      { { 187, 20 },
        { 236, 28 },
        { 40, 221 },
        { 56, 55 }, },
      { { 187, 246 },
        { 239, 62 },
        { 111, 221 },
        { 124, 247 }, },
      { { 179, 19 },
        { 253, 8 },
        { 200, 205 },
        { 16, 191 }, },
      { { 164, 104 },
        { 10, 105 },
        { 22, 37 },
        { 150, 80 }, },
      { { 172, 44 },
        { 10, 93 },
        { 52, 53 },
        { 186, 80 }, },
      { { 172, 161 },
        { 26, 78 },
        { 133, 53 },
        { 114, 88 }, },
      { { 172, 235 },
        { 27, 111 },
        { 215, 53 },
        { 246, 216 }, },
      { { 172, 199 },
        { 25, 126 },
        { 227, 53 },
        { 126, 152 }, },
      { { 164, 103 },
        { 27, 120 },
        { 230, 37 },
        { 30, 216 }, },
      { { 166, 192 },
        { 12, 106 },
        { 3, 101 },
        { 86, 48 }, },
      { { 174, 224 },
        { 14, 110 },
        { 7, 117 },
        { 118, 112 }, },
      { { 166, 35 },
        { 31, 72 },
        { 196, 101 },
        { 18, 248 }, },
      { { 173, 232 },
        { 74, 111 },
        { 23, 181 },
        { 246, 82 }, },
      { { 165, 204 },
        { 72, 123 },
        { 51, 165 },
        { 222, 18 }, },
      { { 167, 236 },
        { 78, 123 },
        { 55, 229 },
        { 222, 114 }, },
      { { 173, 124 },
        { 106, 125 },
        { 62, 181 },
        { 190, 86 }, },
      { { 165, 26 },
        { 105, 73 },
        { 88, 165 },
        { 146, 150 }, },
      { { 165, 145 },
        { 120, 74 },
        { 137, 165 },
        { 82, 30 }, },
      { { 173, 25 },
        { 120, 77 },
        { 152, 181 },
        { 178, 30 }, },
      { { 165, 151 },
        { 121, 90 },
        { 233, 165 },
        { 90, 158 }, },
      { { 180, 109 },
        { 154, 121 },
        { 182, 45 },
        { 158, 89 }, },
      { { 190, 203 },
        { 157, 111 },
        { 211, 125 },
        { 246, 185 }, },
      { { 188, 58 },
        { 171, 77 },
        { 92, 61 },
        { 178, 213 }, },
      { { 188, 245 },
        { 186, 126 },
        { 175, 61 },
        { 126, 93 }, },
      { { 190, 189 },
        { 190, 95 },
        { 189, 125 },
        { 250, 125 }, },
      { { 190, 243 },
        { 191, 110 },
        { 207, 125 },
        { 118, 253 }, },
      { { 181, 37 },
        { 218, 88 },
        { 164, 173 },
        { 26, 91 }, },
      { { 181, 143 },
        { 217, 91 },
        { 241, 173 },
        { 218, 155 }, },
      { { 183, 104 },
        { 206, 105 },
        { 22, 237 },
        { 150, 115 }, },
      { { 191, 228 },
        { 206, 126 },
        { 39, 253 },
        { 126, 115 }, },
      { { 189, 254 },
        { 235, 127 },
        { 127, 189 },
        { 254, 215 }, },
      { { 189, 157 },
        { 248, 95 },
        { 185, 189 },
        { 250, 31 }, },
      { { 181, 245 },
        { 250, 122 },
        { 175, 173 },
        { 94, 95 }, },
      { { 181, 243 },
        { 251, 106 },
        { 207, 173 },
        { 86, 223 }, },
      { { 191, 176 },
        { 238, 78 },
        { 13, 253 },
        { 114, 119 }, },
      { { 183, 90 },
        { 237, 105 },
        { 90, 237 },
        { 150, 183 }, },
      { { 191, 62 },
        { 239, 93 },
        { 124, 253 },
        { 186, 247 }, },
      { { 183, 57 },
        { 254, 73 },
        { 156, 237 },
        { 146, 127 }, },
      { { 191, 213 },
        { 252, 126 },
        { 171, 253 },
        { 126, 63 }, },
      { { 183, 29 },
        { 252, 89 },
        { 184, 237 },
        { 154, 63 }, },
      { { 191, 53 },
        { 254, 92 },
        { 172, 253 },
        { 58, 127 }, },
      { { 183, 127 },
        { 255, 121 },
        { 254, 237 },
        { 158, 255 }, },
      { { 200, 1 },
        { 16, 140 },
        { 128, 19 },
        { 49, 8 }, },
      { { 192, 165 },
        { 18, 154 },
        { 165, 3 },
        { 89, 72 }, },
      { { 194, 130 },
        { 5, 138 },
        { 65, 67 },
        { 81, 160 }, },
      { { 200, 189 },
        { 50, 159 },
        { 189, 19 },
        { 249, 76 }, },
      { { 194, 252 },
        { 38, 187 },
        { 63, 67 },
        { 221, 100 }, },
      { { 202, 145 },
        { 52, 142 },
        { 137, 83 },
        { 113, 44 }, },
      { { 194, 91 },
        { 53, 169 },
        { 218, 67 },
        { 149, 172 }, },
      { { 201, 68 },
        { 64, 188 },
        { 34, 147 },
        { 61, 2 }, },
      { { 193, 42 },
        { 67, 137 },
        { 84, 131 },
        { 145, 194 }, },
      { { 195, 192 },
        { 68, 170 },
        { 3, 195 },
        { 85, 34 }, },
      { { 201, 122 },
        { 99, 173 },
        { 94, 147 },
        { 181, 198 }, },
      { { 193, 185 },
        { 114, 139 },
        { 157, 131 },
        { 209, 78 }, },
      { { 201, 117 },
        { 114, 188 },
        { 174, 147 },
        { 61, 78 }, },
      { { 193, 247 },
        { 115, 186 },
        { 239, 131 },
        { 93, 206 }, },
      { { 203, 177 },
        { 118, 142 },
        { 141, 211 },
        { 113, 110 }, },
      { { 208, 108 },
        { 130, 185 },
        { 54, 11 },
        { 157, 65 }, },
      { { 216, 135 },
        { 145, 158 },
        { 225, 27 },
        { 121, 137 }, },
      { { 208, 175 },
        { 147, 155 },
        { 245, 11 },
        { 217, 201 }, },
      { { 218, 196 },
        { 132, 190 },
        { 35, 91 },
        { 125, 33 }, },
      { { 210, 12 },
        { 132, 153 },
        { 48, 75 },
        { 153, 33 }, },
      { { 218, 9 },
        { 148, 141 },
        { 144, 91 },
        { 177, 41 }, },
      { { 208, 48 },
        { 162, 136 },
        { 12, 11 },
        { 17, 69 }, },
      { { 216, 148 },
        { 160, 158 },
        { 41, 27 },
        { 121, 5 }, },
      { { 208, 58 },
        { 163, 137 },
        { 92, 11 },
        { 145, 197 }, },
      { { 208, 182 },
        { 163, 154 },
        { 109, 11 },
        { 89, 197 }, },
      { { 208, 117 },
        { 178, 184 },
        { 174, 11 },
        { 29, 77 }, },
      { { 210, 118 },
        { 167, 184 },
        { 110, 75 },
        { 29, 229 }, },
      { { 218, 93 },
        { 180, 189 },
        { 186, 91 },
        { 189, 45 }, },
      { { 218, 53 },
        { 182, 156 },
        { 172, 91 },
        { 57, 109 }, },
      { { 210, 23 },
        { 181, 152 },
        { 232, 75 },
        { 25, 173 }, },
      { { 217, 2 },
        { 193, 140 },
        { 64, 155 },
        { 49, 131 }, },
      { { 211, 232 },
        { 198, 171 },
        { 23, 203 },
        { 213, 99 }, },
      { { 211, 229 },
        { 214, 186 },
        { 167, 203 },
        { 93, 107 }, },
      { { 209, 154 },
        { 225, 139 },
        { 89, 139 },
        { 209, 135 }, },
      { { 209, 246 },
        { 227, 186 },
        { 111, 139 },
        { 93, 199 }, },
      { { 209, 81 },
        { 240, 168 },
        { 138, 139 },
        { 21, 15 }, },
      { { 219, 20 },
        { 228, 156 },
        { 40, 219 },
        { 57, 39 }, },
      { { 211, 62 },
        { 231, 153 },
        { 124, 203 },
        { 153, 231 }, },
      { { 211, 211 },
        { 245, 170 },
        { 203, 203 },
        { 85, 175 }, },
      { { 196, 96 },
        { 2, 232 },
        { 6, 35 },
        { 23, 64 }, },
      { { 204, 167 },
        { 19, 222 },
        { 229, 51 },
        { 123, 200 }, },
      { { 198, 66 },
        { 5, 232 },
        { 66, 99 },
        { 23, 160 }, },
      { { 198, 71 },
        { 21, 248 },
        { 226, 99 },
        { 31, 168 }, },
      { { 206, 231 },
        { 23, 254 },
        { 231, 115 },
        { 127, 232 }, },
      { { 196, 92 },
        { 32, 249 },
        { 58, 35 },
        { 159, 4 }, },
      { { 204, 29 },
        { 48, 221 },
        { 184, 51 },
        { 187, 12 }, },
      { { 204, 53 },
        { 50, 220 },
        { 172, 51 },
        { 59, 76 }, },
      { { 198, 188 },
        { 38, 219 },
        { 61, 99 },
        { 219, 100 }, },
      { { 205, 168 },
        { 66, 207 },
        { 21, 179 },
        { 243, 66 }, },
      { { 197, 12 },
        { 64, 217 },
        { 48, 163 },
        { 155, 2 }, },
      { { 197, 228 },
        { 66, 250 },
        { 39, 163 },
        { 95, 66 }, },
      { { 197, 194 },
        { 65, 234 },
        { 67, 163 },
        { 87, 130 }, },
      { { 205, 45 },
        { 82, 221 },
        { 180, 179 },
        { 187, 74 }, },
      { { 205, 89 },
        { 112, 237 },
        { 154, 179 },
        { 183, 14 }, },
      { { 205, 149 },
        { 112, 222 },
        { 169, 179 },
        { 123, 14 }, },
      { { 197, 147 },
        { 113, 202 },
        { 201, 163 },
        { 83, 142 }, },
      { { 199, 95 },
        { 117, 249 },
        { 250, 227 },
        { 159, 174 }, },
      { { 212, 197 },
        { 144, 250 },
        { 163, 43 },
        { 95, 9 }, },
      { { 222, 136 },
        { 132, 207 },
        { 17, 123 },
        { 243, 33 }, },
      { { 214, 36 },
        { 134, 216 },
        { 36, 107 },
        { 27, 97 }, },
      { { 222, 236 },
        { 134, 255 },
        { 55, 123 },
        { 255, 97 }, },
      { { 214, 226 },
        { 135, 234 },
        { 71, 107 },
        { 87, 225 }, },
      { { 222, 198 },
        { 133, 254 },
        { 99, 123 },
        { 127, 161 }, },
      { { 222, 35 },
        { 151, 204 },
        { 196, 123 },
        { 51, 233 }, },
      { { 220, 220 },
        { 160, 255 },
        { 59, 59 },
        { 255, 5 }, },
      { { 220, 26 },
        { 161, 205 },
        { 88, 59 },
        { 179, 133 }, },
      { { 212, 17 },
        { 176, 200 },
        { 136, 43 },
        { 19, 13 }, },
      { { 222, 84 },
        { 164, 252 },
        { 42, 123 },
        { 63, 37 }, },
      { { 214, 148 },
        { 164, 218 },
        { 41, 107 },
        { 91, 37 }, },
      { { 222, 157 },
        { 180, 223 },
        { 185, 123 },
        { 251, 45 }, },
      { { 221, 129 },
        { 208, 206 },
        { 129, 187 },
        { 115, 11 }, },
      { { 213, 165 },
        { 210, 218 },
        { 165, 171 },
        { 91, 75 }, },
      { { 215, 172 },
        { 198, 219 },
        { 53, 235 },
        { 219, 99 }, },
      { { 215, 102 },
        { 199, 248 },
        { 102, 235 },
        { 31, 227 }, },
      { { 223, 169 },
        { 214, 207 },
        { 149, 251 },
        { 243, 107 }, },
      { { 213, 220 },
        { 224, 251 },
        { 59, 171 },
        { 223, 7 }, },
      { { 221, 31 },
        { 241, 221 },
        { 248, 187 },
        { 187, 143 }, },
      { { 223, 240 },
        { 230, 238 },
        { 15, 251 },
        { 119, 103 }, },
      { { 226, 72 },
        { 12, 169 },
        { 18, 71 },
        { 149, 48 }, },
      { { 226, 232 },
        { 14, 171 },
        { 23, 71 },
        { 213, 112 }, },
      { { 226, 7 },
        { 29, 152 },
        { 224, 71 },
        { 25, 184 }, },
      { { 224, 93 },
        { 56, 185 },
        { 186, 7 },
        { 157, 28 }, },
      { { 234, 245 },
        { 62, 190 },
        { 175, 87 },
        { 125, 124 }, },
      { { 235, 38 },
        { 79, 156 },
        { 100, 215 },
        { 57, 242 }, },
      { { 235, 237 },
        { 94, 191 },
        { 183, 215 },
        { 253, 122 }, },
      { { 225, 82 },
        { 105, 168 },
        { 74, 135 },
        { 21, 150 }, },
      { { 225, 126 },
        { 107, 185 },
        { 126, 135 },
        { 157, 214 }, },
      { { 233, 219 },
        { 121, 175 },
        { 219, 151 },
        { 245, 158 }, },
      { { 248, 6 },
        { 137, 156 },
        { 96, 31 },
        { 57, 145 }, },
      { { 240, 238 },
        { 139, 187 },
        { 119, 15 },
        { 221, 209 }, },
      { { 248, 161 },
        { 154, 142 },
        { 133, 31 },
        { 113, 89 }, },
      { { 250, 0 },
        { 140, 140 },
        { 0, 95 },
        { 49, 49 }, },
      { { 250, 194 },
        { 141, 174 },
        { 67, 95 },
        { 117, 177 }, },
      { { 240, 155 },
        { 185, 139 },
        { 217, 15 },
        { 209, 157 }, },
      { { 250, 244 },
        { 174, 190 },
        { 47, 95 },
        { 125, 117 }, },
      { { 250, 60 },
        { 174, 157 },
        { 60, 95 },
        { 185, 117 }, },
      { { 242, 252 },
        { 174, 187 },
        { 63, 79 },
        { 221, 117 }, },
      { { 242, 189 },
        { 190, 155 },
        { 189, 79 },
        { 217, 125 }, },
      { { 242, 147 },
        { 189, 138 },
        { 201, 79 },
        { 81, 189 }, },
      { { 241, 96 },
        { 202, 168 },
        { 6, 143 },
        { 21, 83 }, },
      { { 249, 236 },
        { 202, 191 },
        { 55, 159 },
        { 253, 83 }, },
      { { 241, 70 },
        { 201, 184 },
        { 98, 143 },
        { 29, 147 }, },
      { { 249, 225 },
        { 218, 174 },
        { 135, 159 },
        { 117, 91 }, },
      { { 243, 72 },
        { 204, 169 },
        { 18, 207 },
        { 149, 51 }, },
      { { 243, 174 },
        { 207, 155 },
        { 117, 207 },
        { 217, 243 }, },
      { { 243, 193 },
        { 220, 170 },
        { 131, 207 },
        { 85, 59 }, },
      { { 243, 139 },
        { 221, 139 },
        { 209, 207 },
        { 209, 187 }, },
      { { 243, 167 },
        { 223, 154 },
        { 229, 207 },
        { 89, 251 }, },
      { { 241, 115 },
        { 251, 168 },
        { 206, 143 },
        { 21, 223 }, },
      { { 241, 151 },
        { 249, 154 },
        { 233, 143 },
        { 89, 159 }, },
      { { 243, 244 },
        { 238, 186 },
        { 47, 207 },
        { 93, 119 }, },
      { { 251, 50 },
        { 239, 140 },
        { 76, 223 },
        { 49, 247 }, },
      { { 228, 7 },
        { 25, 216 },
        { 224, 39 },
        { 27, 152 }, },
      { { 230, 77 },
        { 28, 249 },
        { 178, 103 },
        { 159, 56 }, },
      { { 236, 85 },
        { 56, 252 },
        { 170, 55 },
        { 63, 28 }, },
      { { 237, 192 },
        { 72, 238 },
        { 3, 183 },
        { 119, 18 }, },
      { { 237, 133 },
        { 88, 222 },
        { 161, 183 },
        { 123, 26 }, },
      { { 239, 162 },
        { 79, 206 },
        { 69, 247 },
        { 115, 242 }, },
      { { 231, 78 },
        { 77, 249 },
        { 114, 231 },
        { 159, 178 }, },
      { { 229, 213 },
        { 120, 250 },
        { 171, 167 },
        { 95, 30 }, },
      { { 239, 80 },
        { 108, 236 },
        { 10, 247 },
        { 55, 54 }, },
      { { 244, 34 },
        { 139, 200 },
        { 68, 47 },
        { 19, 209 }, },
      { { 244, 137 },
        { 152, 203 },
        { 145, 47 },
        { 211, 25 }, },
      { { 244, 41 },
        { 154, 201 },
        { 148, 47 },
        { 147, 89 }, },
      { { 246, 106 },
        { 143, 233 },
        { 86, 111 },
        { 151, 241 }, },
      { { 254, 11 },
        { 157, 205 },
        { 208, 127 },
        { 179, 185 }, },
      { { 254, 111 },
        { 159, 253 },
        { 246, 127 },
        { 191, 249 }, },
      { { 244, 149 },
        { 184, 218 },
        { 169, 47 },
        { 91, 29 }, },
      { { 244, 53 },
        { 186, 216 },
        { 172, 47 },
        { 27, 93 }, },
      { { 244, 31 },
        { 185, 217 },
        { 248, 47 },
        { 155, 157 }, },
      { { 246, 176 },
        { 174, 202 },
        { 13, 111 },
        { 83, 117 }, },
      { { 245, 232 },
        { 202, 235 },
        { 23, 175 },
        { 215, 83 }, },
      { { 245, 197 },
        { 216, 250 },
        { 163, 175 },
        { 95, 27 }, },
      { { 253, 35 },
        { 219, 204 },
        { 196, 191 },
        { 51, 219 }, },
      { { 255, 192 },
        { 204, 238 },
        { 3, 255 },
        { 119, 51 }, },
      { { 247, 204 },
        { 204, 251 },
        { 51, 239 },
        { 223, 51 }, },
      { { 247, 233 },
        { 222, 235 },
        { 151, 239 },
        { 215, 123 }, },
      { { 245, 188 },
        { 234, 219 },
        { 61, 175 },
        { 219, 87 }, },
      { { 253, 246 },
        { 235, 254 },
        { 111, 191 },
        { 127, 215 }, },
      { { 245, 217 },
        { 248, 235 },
        { 155, 175 },
        { 215, 31 }, },
      { { 253, 151 },
        { 249, 222 },
        { 233, 191 },
        { 123, 159 }, },
      { { 253, 63 },
        { 251, 221 },
        { 252, 191 },
        { 187, 223 }, },
      { { 255, 156 },
        { 236, 223 },
        { 57, 255 },
        { 251, 55 }, },
      { { 255, 90 },
        { 237, 237 },
        { 90, 255 },
        { 183, 183 }, },
      { { 247, 254 },
        { 239, 251 },
        { 127, 239 },
        { 223, 247 }, },
      { { 255, 17 },
        { 252, 204 },
        { 136, 255 },
        { 51, 63 }, },
      { { 247, 191 },
        { 255, 219 },
        { 253, 239 },
        { 219, 255 }, }, };

static unsigned char DICT_5X5_1000_BYTES[][4][4] =
    { { { 162, 217, 94, 0 },
        { 82, 46, 217, 1 },
        { 61, 77, 162, 1 },
        { 205, 186, 37, 0 }, },
      { { 14, 3, 115, 0 },
        { 176, 198, 133, 0 },
        { 103, 96, 56, 0 },
        { 80, 177, 134, 1 }, },
      { { 215, 135, 110, 1 },
        { 47, 151, 157, 1 },
        { 187, 112, 245, 1 },
        { 220, 244, 250, 0 }, },
      { { 129, 202, 251, 1 },
        { 122, 222, 40, 1 },
        { 239, 169, 192, 1 },
        { 138, 61, 175, 0 }, },
      { { 215, 90, 146, 0 },
        { 116, 27, 236, 0 },
        { 36, 173, 117, 1 },
        { 27, 236, 23, 0 }, },
      { { 234, 4, 22, 1 },
        { 153, 35, 152, 0 },
        { 180, 16, 43, 1 },
        { 12, 226, 76, 1 }, },
      { { 105, 235, 246, 0 },
        { 242, 191, 51, 0 },
        { 55, 235, 203, 0 },
        { 102, 126, 167, 1 }, },
      { { 113, 10, 53, 1 },
        { 60, 249, 16, 0 },
        { 214, 40, 71, 0 },
        { 4, 79, 158, 0 }, },
      { { 134, 176, 153, 0 },
        { 18, 64, 238, 1 },
        { 76, 134, 176, 1 },
        { 187, 129, 36, 0 }, },
      { { 152, 159, 210, 1 },
        { 191, 14, 105, 0 },
        { 165, 252, 140, 1 },
        { 75, 56, 126, 1 }, },
      { { 158, 119, 1, 1 },
        { 237, 64, 207, 0 },
        { 192, 119, 60, 1 },
        { 121, 129, 91, 1 }, },
      { { 209, 109, 96, 0 },
        { 69, 157, 11, 0 },
        { 3, 91, 69, 1 },
        { 104, 92, 209, 0 }, },
      { { 243, 21, 136, 1 },
        { 13, 49, 233, 1 },
        { 136, 212, 103, 1 },
        { 203, 198, 88, 0 }, },
      { { 47, 56, 179, 0 },
        { 144, 250, 230, 0 },
        { 102, 142, 122, 0 },
        { 51, 175, 132, 1 }, },
      { { 254, 126, 84, 0 },
        { 245, 45, 222, 0 },
        { 21, 63, 63, 1 },
        { 61, 218, 87, 1 }, },
      { { 40, 241, 191, 1 },
        { 218, 226, 115, 1 },
        { 254, 199, 138, 0 },
        { 231, 35, 173, 1 }, },
      { { 75, 211, 172, 0 },
        { 226, 145, 241, 1 },
        { 26, 229, 233, 0 },
        { 199, 196, 163, 1 }, },
      { { 95, 81, 55, 1 },
        { 220, 211, 213, 0 },
        { 246, 69, 125, 0 },
        { 85, 229, 157, 1 }, },
      { { 123, 38, 226, 0 },
        { 165, 183, 162, 0 },
        { 35, 178, 111, 0 },
        { 34, 246, 210, 1 }, },
      { { 131, 14, 244, 0 },
        { 49, 156, 184, 0 },
        { 23, 184, 96, 1 },
        { 14, 156, 198, 0 }, },
      { { 150, 237, 58, 1 },
        { 95, 138, 143, 1 },
        { 174, 91, 180, 1 },
        { 248, 168, 253, 0 }, },
      { { 168, 114, 32, 0 },
        { 224, 160, 74, 0 },
        { 2, 39, 10, 1 },
        { 41, 2, 131, 1 }, },
      { { 181, 134, 80, 1 },
        { 63, 52, 12, 0 },
        { 133, 48, 214, 1 },
        { 24, 22, 126, 0 }, },
      { { 93, 9, 111, 0 },
        { 132, 223, 21, 1 },
        { 123, 72, 93, 0 },
        { 212, 125, 144, 1 }, },
      { { 206, 104, 17, 1 },
        { 216, 73, 142, 0 },
        { 196, 11, 57, 1 },
        { 56, 201, 13, 1 }, },
      { { 210, 204, 185, 0 },
        { 87, 201, 168, 1 },
        { 78, 153, 165, 1 },
        { 138, 201, 245, 0 }, },
      { { 225, 231, 69, 1 },
        { 107, 117, 27, 0 },
        { 209, 115, 195, 1 },
        { 108, 87, 107, 0 }, },
      { { 17, 33, 35, 0 },
        { 4, 210, 3, 0 },
        { 98, 66, 68, 0 },
        { 96, 37, 144, 0 }, },
      { { 29, 203, 57, 0 },
        { 246, 216, 5, 1 },
        { 78, 105, 220, 0 },
        { 208, 13, 183, 1 }, },
      { { 18, 17, 29, 1 },
        { 28, 64, 209, 1 },
        { 220, 68, 36, 0 },
        { 197, 129, 28, 0 }, },
      { { 19, 155, 183, 0 },
        { 54, 218, 241, 0 },
        { 118, 236, 228, 0 },
        { 71, 173, 182, 0 }, },
      { { 27, 68, 57, 1 },
        { 221, 208, 128, 1 },
        { 206, 17, 108, 0 },
        { 128, 133, 221, 1 }, },
      { { 32, 104, 103, 0 },
        { 64, 238, 18, 0 },
        { 115, 11, 2, 0 },
        { 36, 59, 129, 0 }, },
      { { 37, 85, 100, 0 },
        { 65, 180, 85, 0 },
        { 19, 85, 82, 0 },
        { 85, 22, 193, 0 }, },
      { { 35, 33, 221, 0 },
        { 16, 116, 179, 1 },
        { 93, 194, 98, 0 },
        { 230, 151, 4, 0 }, },
      { { 61, 55, 245, 0 },
        { 181, 244, 119, 0 },
        { 87, 246, 94, 0 },
        { 119, 23, 214, 1 }, },
      { { 76, 197, 86, 0 },
        { 211, 7, 21, 0 },
        { 53, 81, 153, 0 },
        { 84, 112, 101, 1 }, },
      { { 65, 104, 128, 1 },
        { 72, 25, 34, 0 },
        { 128, 139, 65, 0 },
        { 34, 76, 9, 0 }, },
      { { 77, 86, 142, 1 },
        { 233, 19, 116, 1 },
        { 184, 181, 89, 0 },
        { 151, 100, 75, 1 }, },
      { { 67, 30, 57, 0 },
        { 49, 217, 192, 1 },
        { 78, 60, 97, 0 },
        { 129, 205, 198, 0 }, },
      { { 86, 148, 18, 1 },
        { 31, 3, 196, 0 },
        { 164, 20, 181, 0 },
        { 17, 224, 124, 0 }, },
      { { 82, 151, 207, 0 },
        { 39, 71, 241, 1 },
        { 121, 244, 165, 0 },
        { 199, 241, 114, 0 }, },
      { { 108, 36, 251, 1 },
        { 153, 231, 38, 1 },
        { 239, 146, 27, 0 },
        { 178, 115, 204, 1 }, },
      { { 97, 132, 236, 1 },
        { 11, 181, 48, 1 },
        { 155, 144, 195, 0 },
        { 134, 86, 232, 0 }, },
      { { 109, 63, 24, 1 },
        { 185, 57, 71, 1 },
        { 140, 126, 91, 0 },
        { 241, 78, 78, 1 }, },
      { { 116, 177, 61, 0 },
        { 22, 225, 87, 1 },
        { 94, 70, 151, 0 },
        { 245, 67, 180, 0 }, },
      { { 116, 220, 203, 1 },
        { 79, 111, 100, 1 },
        { 233, 157, 151, 0 },
        { 147, 123, 121, 0 }, },
      { { 124, 164, 3, 0 },
        { 135, 99, 6, 0 },
        { 96, 18, 159, 0 },
        { 48, 99, 112, 1 }, },
      { { 122, 200, 146, 1 },
        { 222, 43, 160, 0 },
        { 164, 137, 175, 0 },
        { 2, 234, 61, 1 }, },
      { { 123, 91, 235, 1 },
        { 236, 255, 225, 1 },
        { 235, 237, 111, 0 },
        { 195, 255, 155, 1 }, },
      { { 141, 172, 114, 0 },
        { 147, 158, 14, 0 },
        { 39, 26, 216, 1 },
        { 56, 60, 228, 1 }, },
      { { 141, 105, 60, 1 },
        { 216, 152, 31, 1 },
        { 158, 75, 88, 1 },
        { 252, 12, 141, 1 }, },
      { { 143, 28, 5, 1 },
        { 137, 88, 220, 0 },
        { 208, 28, 120, 1 },
        { 29, 141, 72, 1 }, },
      { { 139, 74, 34, 1 },
        { 232, 154, 136, 0 },
        { 162, 41, 104, 1 },
        { 8, 172, 139, 1 }, },
      { { 151, 253, 165, 0 },
        { 71, 216, 255, 0 },
        { 82, 223, 244, 1 },
        { 127, 141, 241, 0 }, },
      { { 172, 101, 198, 1 },
        { 201, 38, 63, 0 },
        { 177, 211, 26, 1 },
        { 126, 50, 73, 1 }, },
      { { 172, 195, 248, 0 },
        { 242, 164, 45, 1 },
        { 15, 225, 154, 1 },
        { 218, 18, 167, 1 }, },
      { { 161, 23, 239, 1 },
        { 41, 246, 121, 1 },
        { 251, 244, 66, 1 },
        { 207, 55, 202, 0 }, },
      { { 167, 9, 19, 1 },
        { 24, 122, 141, 0 },
        { 228, 72, 114, 1 },
        { 88, 175, 12, 0 }, },
      { { 171, 111, 145, 0 },
        { 241, 120, 171, 0 },
        { 68, 251, 106, 1 },
        { 106, 143, 71, 1 }, },
      { { 185, 237, 248, 1 },
        { 223, 188, 43, 1 },
        { 143, 219, 206, 1 },
        { 234, 30, 253, 1 }, },
      { { 178, 100, 158, 0 },
        { 85, 34, 186, 1 },
        { 60, 147, 38, 1 },
        { 174, 162, 85, 0 }, },
      { { 190, 93, 195, 0 },
        { 197, 110, 237, 0 },
        { 97, 221, 62, 1 },
        { 91, 187, 81, 1 }, },
      { { 196, 5, 67, 1 },
        { 9, 71, 13, 0 },
        { 225, 80, 17, 1 },
        { 88, 113, 72, 0 }, },
      { { 200, 163, 238, 1 },
        { 170, 135, 59, 1 },
        { 187, 226, 137, 1 },
        { 238, 112, 170, 1 }, },
      { { 194, 117, 197, 0 },
        { 65, 69, 251, 0 },
        { 81, 215, 33, 1 },
        { 111, 209, 65, 0 }, },
      { { 198, 194, 214, 1 },
        { 122, 7, 188, 0 },
        { 181, 161, 177, 1 },
        { 30, 240, 47, 0 }, },
      { { 217, 102, 212, 1 },
        { 253, 21, 58, 0 },
        { 149, 179, 77, 1 },
        { 46, 84, 95, 1 }, },
      { { 221, 94, 185, 1 },
        { 253, 217, 108, 1 },
        { 206, 189, 93, 1 },
        { 155, 77, 223, 1 }, },
      { { 244, 234, 25, 0 },
        { 118, 105, 14, 1 },
        { 76, 43, 151, 1 },
        { 184, 75, 55, 0 }, },
      { { 243, 178, 148, 0 },
        { 54, 49, 250, 0 },
        { 20, 166, 231, 1 },
        { 47, 198, 54, 0 }, },
      { { 122, 186, 5, 0 },
        { 166, 105, 210, 0 },
        { 80, 46, 175, 0 },
        { 37, 203, 50, 1 }, },
      { { 216, 141, 41, 1 },
        { 143, 201, 9, 1 },
        { 202, 88, 141, 1 },
        { 200, 73, 248, 1 }, },
      { { 12, 103, 50, 1 },
        { 249, 130, 7, 0 },
        { 166, 115, 24, 0 },
        { 112, 32, 207, 1 }, },
      { { 21, 89, 12, 1 },
        { 76, 24, 85, 1 },
        { 152, 77, 84, 0 },
        { 213, 12, 25, 0 }, },
      { { 76, 116, 192, 1 },
        { 201, 5, 102, 0 },
        { 129, 151, 25, 0 },
        { 51, 80, 73, 1 }, },
      { { 84, 3, 14, 0 },
        { 36, 3, 21, 1 },
        { 56, 96, 21, 0 },
        { 212, 96, 18, 0 }, },
      { { 160, 208, 172, 0 },
        { 66, 160, 120, 1 },
        { 26, 133, 130, 1 },
        { 143, 2, 161, 0 }, },
      { { 194, 152, 166, 0 },
        { 2, 139, 248, 0 },
        { 50, 140, 161, 1 },
        { 15, 232, 160, 0 }, },
      { { 203, 104, 150, 0 },
        { 208, 27, 186, 0 },
        { 52, 139, 105, 1 },
        { 46, 236, 5, 1 }, },
      { { 253, 105, 209, 0 },
        { 212, 125, 47, 0 },
        { 69, 203, 95, 1 },
        { 122, 95, 21, 1 }, },
      { { 4, 145, 90, 1 },
        { 26, 6, 69, 1 },
        { 173, 68, 144, 0 },
        { 209, 48, 44, 0 }, },
      { { 12, 222, 112, 0 },
        { 243, 140, 68, 0 },
        { 7, 61, 152, 0 },
        { 17, 24, 231, 1 }, },
      { { 5, 170, 62, 0 },
        { 50, 154, 22, 1 },
        { 62, 42, 208, 0 },
        { 180, 44, 166, 0 }, },
      { { 1, 99, 183, 1 },
        { 120, 210, 51, 0 },
        { 246, 227, 64, 0 },
        { 102, 37, 143, 0 }, },
      { { 9, 145, 68, 1 },
        { 138, 20, 81, 0 },
        { 145, 68, 200, 0 },
        { 69, 20, 40, 1 }, },
      { { 9, 105, 83, 1 },
        { 216, 94, 3, 0 },
        { 229, 75, 72, 0 },
        { 96, 61, 13, 1 }, },
      { { 6, 37, 161, 1 },
        { 9, 192, 167, 0 },
        { 194, 210, 48, 0 },
        { 114, 129, 200, 0 }, },
      { { 3, 61, 226, 1 },
        { 9, 158, 227, 0 },
        { 163, 222, 96, 0 },
        { 99, 188, 200, 0 }, },
      { { 7, 213, 6, 1 },
        { 75, 18, 213, 0 },
        { 176, 85, 240, 0 },
        { 85, 164, 105, 0 }, },
      { { 15, 143, 170, 0 },
        { 163, 154, 165, 1 },
        { 42, 248, 248, 0 },
        { 210, 172, 226, 1 }, },
      { { 28, 116, 60, 1 },
        { 221, 128, 86, 1 },
        { 158, 23, 28, 0 },
        { 181, 0, 221, 1 }, },
      { { 25, 29, 145, 1 },
        { 157, 88, 97, 0 },
        { 196, 220, 76, 0 },
        { 67, 13, 92, 1 }, },
      { { 22, 27, 35, 1 },
        { 44, 202, 197, 0 },
        { 226, 108, 52, 0 },
        { 81, 169, 154, 0 }, },
      { { 22, 210, 141, 1 },
        { 110, 64, 244, 1 },
        { 216, 165, 180, 0 },
        { 151, 129, 59, 0 }, },
      { { 23, 78, 198, 1 },
        { 109, 30, 180, 0 },
        { 177, 185, 116, 0 },
        { 22, 188, 91, 0 }, },
      { { 19, 226, 177, 0 },
        { 118, 208, 162, 0 },
        { 70, 163, 228, 0 },
        { 34, 133, 183, 0 }, },
      { { 31, 126, 250, 1 },
        { 253, 158, 230, 1 },
        { 175, 191, 124, 0 },
        { 179, 188, 223, 1 }, },
      { { 41, 15, 112, 0 },
        { 177, 188, 1, 0 },
        { 7, 120, 74, 0 },
        { 64, 30, 198, 1 }, },
      { { 34, 71, 126, 1 },
        { 121, 166, 145, 1 },
        { 191, 113, 34, 0 },
        { 196, 178, 207, 0 }, },
      { { 42, 23, 192, 1 },
        { 169, 36, 225, 0 },
        { 129, 244, 42, 0 },
        { 67, 146, 74, 1 }, },
      { { 42, 251, 100, 1 },
        { 234, 172, 211, 0 },
        { 147, 111, 170, 0 },
        { 101, 154, 171, 1 }, },
      { { 35, 240, 4, 0 },
        { 66, 48, 210, 0 },
        { 16, 7, 226, 0 },
        { 37, 134, 33, 0 }, },
      { { 39, 205, 252, 0 },
        { 83, 188, 181, 1 },
        { 31, 217, 242, 0 },
        { 214, 158, 229, 0 }, },
      { { 35, 106, 172, 0 },
        { 96, 184, 178, 1 },
        { 26, 171, 98, 0 },
        { 166, 142, 131, 0 }, },
      { { 47, 123, 47, 0 },
        { 224, 250, 215, 1 },
        { 122, 111, 122, 0 },
        { 245, 175, 131, 1 }, },
      { { 52, 144, 196, 0 },
        { 6, 36, 116, 0 },
        { 17, 132, 150, 0 },
        { 23, 18, 48, 0 }, },
      { { 48, 9, 214, 1 },
        { 28, 46, 49, 0 },
        { 181, 200, 6, 0 },
        { 70, 58, 28, 0 }, },
      { { 52, 94, 16, 1 },
        { 125, 40, 68, 0 },
        { 132, 61, 22, 0 },
        { 17, 10, 95, 0 }, },
      { { 57, 82, 232, 0 },
        { 228, 180, 96, 1 },
        { 11, 165, 78, 0 },
        { 131, 22, 147, 1 }, },
      { { 50, 0, 113, 0 },
        { 20, 228, 128, 0 },
        { 71, 0, 38, 0 },
        { 0, 147, 148, 0 }, },
      { { 54, 231, 29, 0 },
        { 119, 96, 151, 1 },
        { 92, 115, 182, 0 },
        { 244, 131, 119, 0 }, },
      { { 68, 138, 4, 1 },
        { 42, 9, 20, 0 },
        { 144, 40, 145, 0 },
        { 20, 72, 42, 0 }, },
      { { 68, 236, 254, 1 },
        { 91, 143, 54, 1 },
        { 191, 155, 145, 0 },
        { 182, 120, 237, 0 }, },
      { { 69, 31, 114, 1 },
        { 57, 159, 69, 0 },
        { 167, 124, 81, 0 },
        { 81, 124, 206, 0 }, },
      { { 69, 74, 149, 0 },
        { 112, 89, 52, 0 },
        { 84, 169, 81, 0 },
        { 22, 77, 7, 0 }, },
      { { 70, 19, 190, 1 },
        { 56, 131, 245, 1 },
        { 190, 228, 49, 0 },
        { 215, 224, 142, 0 }, },
      { { 78, 131, 9, 0 },
        { 162, 65, 133, 1 },
        { 72, 96, 185, 0 },
        { 208, 193, 34, 1 }, },
      { { 71, 114, 153, 1 },
        { 120, 81, 230, 1 },
        { 204, 167, 113, 0 },
        { 179, 197, 15, 0 }, },
      { { 79, 130, 125, 1 },
        { 186, 213, 148, 1 },
        { 223, 32, 249, 0 },
        { 148, 213, 174, 1 }, },
      { { 92, 55, 141, 1 },
        { 173, 65, 119, 1 },
        { 216, 246, 29, 0 },
        { 247, 65, 90, 1 }, },
      { { 88, 253, 119, 0 },
        { 215, 207, 83, 0 },
        { 119, 95, 141, 0 },
        { 101, 121, 245, 1 }, },
      { { 81, 183, 248, 0 },
        { 55, 149, 99, 1 },
        { 15, 246, 197, 0 },
        { 227, 84, 246, 0 }, },
      { { 89, 58, 251, 0 },
        { 180, 223, 98, 1 },
        { 111, 174, 77, 0 },
        { 163, 125, 150, 1 }, },
      { { 90, 153, 153, 0 },
        { 150, 73, 225, 1 },
        { 76, 204, 173, 0 },
        { 195, 201, 52, 1 }, },
      { { 83, 1, 240, 1 },
        { 28, 149, 161, 0 },
        { 135, 192, 101, 0 },
        { 66, 212, 156, 0 }, },
      { { 83, 204, 103, 1 },
        { 79, 223, 144, 0 },
        { 243, 25, 229, 0 },
        { 4, 253, 249, 0 }, },
      { { 83, 110, 1, 0 },
        { 101, 89, 130, 0 },
        { 64, 59, 101, 0 },
        { 32, 205, 83, 0 }, },
      { { 91, 37, 175, 1 },
        { 141, 211, 179, 1 },
        { 250, 210, 109, 0 },
        { 230, 229, 216, 1 }, },
      { { 95, 213, 204, 1 },
        { 207, 21, 245, 1 },
        { 153, 213, 253, 0 },
        { 215, 212, 121, 1 }, },
      { { 101, 102, 66, 1 },
        { 105, 55, 6, 0 },
        { 161, 51, 83, 0 },
        { 48, 118, 75, 0 }, },
      { { 101, 199, 175, 0 },
        { 99, 243, 53, 1 },
        { 122, 241, 211, 0 },
        { 214, 103, 227, 0 }, },
      { { 102, 55, 81, 0 },
        { 49, 101, 199, 0 },
        { 69, 118, 51, 0 },
        { 113, 211, 70, 0 }, },
      { { 103, 12, 197, 1 },
        { 9, 125, 180, 0 },
        { 209, 152, 115, 0 },
        { 22, 223, 72, 0 }, },
      { { 112, 150, 93, 1 },
        { 63, 101, 80, 1 },
        { 221, 52, 135, 0 },
        { 133, 83, 126, 0 }, },
      { { 124, 99, 128, 1 },
        { 236, 33, 39, 0 },
        { 128, 227, 31, 0 },
        { 114, 66, 27, 1 }, },
      { { 121, 171, 169, 0 },
        { 166, 249, 35, 1 },
        { 74, 234, 207, 0 },
        { 226, 79, 178, 1 }, },
      { { 114, 61, 70, 0 },
        { 5, 47, 211, 0 },
        { 49, 94, 39, 0 },
        { 101, 250, 80, 0 }, },
      { { 115, 229, 178, 1 },
        { 95, 179, 163, 0 },
        { 166, 211, 231, 0 },
        { 98, 230, 253, 0 }, },
      { { 132, 38, 140, 0 },
        { 33, 0, 62, 1 },
        { 24, 178, 16, 1 },
        { 190, 0, 66, 0 }, },
      { { 137, 241, 1, 0 },
        { 194, 80, 75, 0 },
        { 64, 71, 200, 1 },
        { 105, 5, 33, 1 }, },
      { { 134, 174, 233, 1 },
        { 43, 204, 174, 1 },
        { 203, 186, 176, 1 },
        { 186, 153, 234, 0 }, },
      { { 138, 35, 249, 1 },
        { 184, 196, 171, 1 },
        { 207, 226, 40, 1 },
        { 234, 145, 142, 1 }, },
      { { 148, 53, 113, 1 },
        { 29, 196, 79, 0 },
        { 199, 86, 20, 1 },
        { 121, 17, 220, 0 }, },
      { { 156, 69, 27, 0 },
        { 213, 66, 13, 1 },
        { 108, 81, 28, 1 },
        { 216, 33, 85, 1 }, },
      { { 149, 31, 164, 1 },
        { 45, 152, 125, 0 },
        { 146, 252, 84, 1 },
        { 95, 12, 218, 0 }, },
      { { 150, 141, 144, 0 },
        { 23, 8, 173, 0 },
        { 4, 216, 180, 1 },
        { 90, 136, 116, 0 }, },
      { { 151, 38, 183, 0 },
        { 53, 210, 190, 0 },
        { 118, 178, 116, 1 },
        { 62, 165, 214, 0 }, },
      { { 155, 55, 103, 0 },
        { 165, 214, 219, 0 },
        { 115, 118, 108, 1 },
        { 109, 181, 210, 1 }, },
      { { 155, 198, 224, 1 },
        { 239, 148, 168, 0 },
        { 131, 177, 236, 1 },
        { 10, 148, 251, 1 }, },
      { { 160, 154, 110, 1 },
        { 42, 174, 88, 1 },
        { 187, 44, 130, 1 },
        { 141, 58, 170, 0 }, },
      { { 164, 82, 134, 1 },
        { 104, 34, 124, 0 },
        { 176, 165, 18, 1 },
        { 31, 34, 11, 0 }, },
      { { 168, 176, 133, 1 },
        { 138, 96, 122, 0 },
        { 208, 134, 138, 1 },
        { 47, 3, 40, 1 }, },
      { { 173, 155, 66, 0 },
        { 162, 62, 77, 0 },
        { 33, 108, 218, 1 },
        { 89, 62, 34, 1 }, },
      { { 175, 240, 88, 1 },
        { 218, 52, 206, 1 },
        { 141, 7, 250, 1 },
        { 185, 150, 45, 1 }, },
      { { 176, 46, 99, 1 },
        { 45, 238, 10, 0 },
        { 227, 58, 6, 1 },
        { 40, 59, 218, 0 }, },
      { { 176, 15, 24, 0 },
        { 53, 40, 9, 1 },
        { 12, 120, 6, 1 },
        { 200, 10, 86, 0 }, },
      { { 188, 234, 178, 1 },
        { 254, 170, 46, 0 },
        { 166, 171, 158, 1 },
        { 58, 42, 191, 1 }, },
      { { 190, 196, 76, 1 },
        { 207, 36, 156, 1 },
        { 153, 17, 190, 1 },
        { 156, 146, 121, 1 }, },
      { { 179, 130, 250, 0 },
        { 54, 182, 168, 1 },
        { 47, 160, 230, 1 },
        { 138, 182, 182, 0 }, },
      { { 179, 88, 60, 1 },
        { 92, 184, 216, 1 },
        { 158, 13, 102, 1 },
        { 141, 142, 157, 0 }, },
      { { 191, 69, 238, 0 },
        { 197, 182, 189, 1 },
        { 59, 209, 126, 1 },
        { 222, 182, 209, 1 }, },
      { { 191, 86, 51, 1 },
        { 253, 242, 204, 0 },
        { 230, 53, 126, 1 },
        { 25, 167, 223, 1 }, },
      { { 196, 58, 240, 0 },
        { 48, 141, 110, 0 },
        { 7, 174, 17, 1 },
        { 59, 88, 134, 0 }, },
      { { 204, 233, 131, 0 },
        { 194, 75, 47, 0 },
        { 96, 203, 153, 1 },
        { 122, 105, 33, 1 }, },
      { { 197, 51, 0, 1 },
        { 40, 17, 79, 0 },
        { 128, 102, 81, 1 },
        { 121, 68, 10, 0 }, },
      { { 205, 34, 99, 1 },
        { 168, 215, 14, 0 },
        { 227, 34, 89, 1 },
        { 56, 117, 138, 1 }, },
      { { 198, 8, 138, 1 },
        { 8, 11, 172, 1 },
        { 168, 136, 49, 1 },
        { 154, 232, 8, 0 }, },
      { { 198, 148, 63, 0 },
        { 19, 195, 220, 1 },
        { 126, 20, 177, 1 },
        { 157, 225, 228, 0 }, },
      { { 202, 238, 132, 1 },
        { 235, 9, 186, 0 },
        { 144, 187, 169, 1 },
        { 46, 200, 107, 1 }, },
      { { 207, 167, 18, 1 },
        { 187, 19, 143, 0 },
        { 164, 114, 249, 1 },
        { 120, 228, 110, 1 }, },
      { { 203, 97, 226, 1 },
        { 200, 151, 171, 0 },
        { 163, 195, 105, 1 },
        { 106, 244, 137, 1 }, },
      { { 208, 2, 233, 0 },
        { 36, 197, 40, 1 },
        { 75, 160, 5, 1 },
        { 138, 81, 146, 0 }, },
      { { 220, 183, 70, 0 },
        { 167, 7, 95, 0 },
        { 49, 118, 157, 1 },
        { 125, 112, 114, 1 }, },
      { { 217, 139, 132, 1 },
        { 174, 25, 57, 0 },
        { 144, 232, 205, 1 },
        { 78, 76, 58, 1 }, },
      { { 217, 206, 178, 0 },
        { 247, 155, 40, 0 },
        { 38, 185, 205, 1 },
        { 10, 108, 247, 1 }, },
      { { 210, 153, 64, 1 },
        { 14, 13, 201, 0 },
        { 129, 76, 165, 1 },
        { 73, 216, 56, 0 }, },
      { { 210, 209, 23, 0 },
        { 86, 67, 217, 0 },
        { 116, 69, 165, 1 },
        { 77, 225, 53, 0 }, },
      { { 222, 90, 110, 1 },
        { 236, 143, 220, 1 },
        { 187, 45, 61, 1 },
        { 157, 248, 155, 1 }, },
      { { 218, 71, 66, 1 },
        { 237, 7, 137, 0 },
        { 161, 113, 45, 1 },
        { 72, 240, 91, 1 }, },
      { { 219, 60, 16, 0 },
        { 149, 25, 202, 0 },
        { 4, 30, 109, 1 },
        { 41, 204, 84, 1 }, },
      { { 219, 143, 201, 0 },
        { 167, 93, 169, 1 },
        { 73, 248, 237, 1 },
        { 202, 221, 114, 1 }, },
      { { 232, 24, 227, 1 },
        { 136, 239, 104, 0 },
        { 227, 140, 11, 1 },
        { 11, 123, 136, 1 }, },
      { { 229, 28, 111, 0 },
        { 1, 255, 92, 1 },
        { 123, 28, 83, 1 },
        { 157, 127, 192, 0 }, },
      { { 225, 174, 56, 1 },
        { 59, 185, 10, 1 },
        { 142, 58, 195, 1 },
        { 168, 78, 238, 0 }, },
      { { 237, 185, 123, 1 },
        { 154, 255, 79, 1 },
        { 239, 78, 219, 1 },
        { 249, 127, 172, 1 }, },
      { { 233, 224, 50, 0 },
        { 210, 179, 10, 0 },
        { 38, 3, 203, 1 },
        { 40, 102, 165, 1 }, },
      { { 235, 93, 12, 0 },
        { 193, 57, 217, 1 },
        { 24, 93, 107, 1 },
        { 205, 206, 65, 1 }, },
      { { 239, 249, 157, 0 },
        { 210, 121, 255, 1 },
        { 92, 207, 251, 1 },
        { 255, 207, 37, 1 }, },
      { { 248, 17, 1, 0 },
        { 132, 97, 73, 0 },
        { 64, 68, 15, 1 },
        { 73, 67, 16, 1 }, },
      { { 248, 7, 211, 0 },
        { 181, 103, 41, 0 },
        { 101, 240, 15, 1 },
        { 74, 115, 86, 1 }, },
      { { 246, 2, 32, 1 },
        { 44, 161, 140, 0 },
        { 130, 32, 55, 1 },
        { 24, 194, 154, 0 }, },
      { { 246, 27, 95, 1 },
        { 60, 111, 221, 1 },
        { 253, 108, 55, 1 },
        { 221, 251, 30, 0 }, },
      { { 254, 181, 237, 0 },
        { 135, 229, 255, 1 },
        { 91, 214, 191, 1 },
        { 255, 211, 240, 1 }, },
      { { 250, 51, 56, 1 },
        { 188, 161, 203, 1 },
        { 142, 102, 47, 1 },
        { 233, 194, 158, 1 }, },
      { { 250, 74, 193, 1 },
        { 236, 109, 168, 0 },
        { 193, 169, 47, 1 },
        { 10, 219, 27, 1 }, },
      { { 247, 47, 112, 1 },
        { 61, 189, 143, 0 },
        { 135, 122, 119, 1 },
        { 120, 222, 222, 0 }, },
      { { 247, 234, 252, 1 },
        { 126, 189, 190, 1 },
        { 159, 171, 247, 1 },
        { 190, 222, 191, 0 }, },
      { { 255, 24, 148, 1 },
        { 156, 57, 252, 0 },
        { 148, 140, 127, 1 },
        { 31, 206, 28, 1 }, },
      { { 251, 163, 94, 0 },
        { 182, 55, 155, 1 },
        { 61, 98, 239, 1 },
        { 236, 246, 54, 1 }, },
      { { 104, 184, 47, 0 },
        { 130, 235, 82, 1 },
        { 122, 14, 139, 0 },
        { 165, 107, 160, 1 }, },
      { { 153, 15, 11, 1 },
        { 173, 90, 9, 1 },
        { 232, 120, 76, 1 },
        { 200, 45, 90, 1 }, },
      { { 153, 216, 38, 1 },
        { 206, 154, 88, 0 },
        { 178, 13, 204, 1 },
        { 13, 44, 185, 1 }, },
      { { 228, 95, 14, 1 },
        { 105, 43, 93, 1 },
        { 184, 125, 19, 1 },
        { 221, 106, 75, 0 }, },
      { { 29, 16, 110, 1 },
        { 140, 150, 84, 1 },
        { 187, 4, 92, 0 },
        { 149, 52, 152, 1 }, },
      { { 42, 193, 48, 1 },
        { 218, 160, 129, 0 },
        { 134, 65, 170, 0 },
        { 64, 130, 173, 1 }, },
      { { 52, 65, 99, 1 },
        { 76, 230, 5, 0 },
        { 227, 65, 22, 0 },
        { 80, 51, 153, 0 }, },
      { { 55, 192, 116, 1 },
        { 94, 180, 148, 0 },
        { 151, 1, 246, 0 },
        { 20, 150, 189, 0 }, },
      { { 63, 53, 203, 1 },
        { 141, 118, 231, 1 },
        { 233, 214, 126, 0 },
        { 243, 183, 88, 1 }, },
      { { 86, 160, 76, 0 },
        { 6, 5, 150, 1 },
        { 25, 2, 181, 0 },
        { 180, 208, 48, 0 }, },
      { { 87, 56, 57, 1 },
        { 28, 217, 198, 1 },
        { 206, 14, 117, 0 },
        { 177, 205, 156, 0 }, },
      { { 102, 152, 184, 0 },
        { 18, 169, 228, 1 },
        { 14, 140, 179, 0 },
        { 147, 202, 164, 0 }, },
      { { 115, 165, 23, 0 },
        { 23, 115, 147, 0 },
        { 116, 82, 231, 0 },
        { 100, 231, 116, 0 }, },
      { { 127, 44, 253, 1 },
        { 157, 253, 182, 1 },
        { 223, 154, 127, 0 },
        { 182, 223, 220, 1 }, },
      { { 139, 71, 233, 0 },
        { 225, 212, 169, 1 },
        { 75, 241, 104, 1 },
        { 202, 149, 195, 1 }, },
      { { 165, 195, 151, 0 },
        { 114, 114, 61, 0 },
        { 116, 225, 210, 1 },
        { 94, 39, 39, 0 }, },
      { { 169, 169, 235, 0 },
        { 130, 254, 43, 1 },
        { 107, 202, 202, 1 },
        { 234, 63, 160, 1 }, },
      { { 181, 25, 183, 0 },
        { 20, 250, 125, 0 },
        { 118, 204, 86, 1 },
        { 95, 47, 148, 0 }, },
      { { 178, 218, 153, 1 },
        { 126, 104, 232, 1 },
        { 204, 173, 166, 1 },
        { 139, 139, 63, 0 }, },
      { { 196, 193, 244, 0 },
        { 82, 133, 61, 0 },
        { 23, 193, 145, 1 },
        { 94, 80, 165, 0 }, },
      { { 202, 185, 30, 0 },
        { 146, 11, 219, 1 },
        { 60, 78, 169, 1 },
        { 237, 232, 36, 1 }, },
      { { 216, 111, 163, 1 },
        { 237, 203, 43, 0 },
        { 226, 251, 13, 1 },
        { 106, 105, 219, 1 }, },
      { { 223, 141, 142, 0 },
        { 135, 27, 189, 1 },
        { 56, 216, 253, 1 },
        { 222, 236, 112, 1 }, },
      { { 229, 102, 143, 1 },
        { 105, 115, 62, 1 },
        { 248, 179, 83, 1 },
        { 190, 103, 75, 0 }, },
      { { 237, 71, 26, 1 },
        { 249, 51, 13, 1 },
        { 172, 113, 91, 1 },
        { 216, 102, 79, 1 }, },
      { { 240, 103, 134, 1 },
        { 109, 35, 59, 0 },
        { 176, 243, 7, 1 },
        { 110, 98, 91, 0 }, },
      { { 4, 41, 238, 1 },
        { 8, 142, 55, 1 },
        { 187, 202, 16, 0 },
        { 246, 56, 136, 0 }, },
      { { 0, 35, 71, 1 },
        { 40, 70, 19, 0 },
        { 241, 98, 0, 0 },
        { 100, 49, 10, 0 }, },
      { { 0, 162, 251, 0 },
        { 50, 198, 34, 1 },
        { 111, 162, 128, 0 },
        { 162, 49, 166, 0 }, },
      { { 4, 200, 206, 0 },
        { 66, 14, 52, 1 },
        { 57, 137, 144, 0 },
        { 150, 56, 33, 0 }, },
      { { 0, 210, 225, 1 },
        { 106, 196, 96, 0 },
        { 195, 165, 128, 0 },
        { 3, 17, 171, 0 }, },
      { { 12, 10, 15, 0 },
        { 160, 74, 20, 1 },
        { 120, 40, 24, 0 },
        { 148, 41, 2, 1 }, },
      { { 8, 139, 198, 0 },
        { 162, 14, 49, 0 },
        { 49, 232, 136, 0 },
        { 70, 56, 34, 1 }, },
      { { 12, 134, 91, 0 },
        { 179, 70, 4, 1 },
        { 109, 48, 152, 0 },
        { 144, 49, 102, 1 }, },
      { { 5, 129, 253, 0 },
        { 18, 212, 53, 1 },
        { 95, 192, 208, 0 },
        { 214, 21, 164, 0 }, },
      { { 1, 113, 30, 0 },
        { 80, 18, 83, 1 },
        { 60, 71, 64, 0 },
        { 229, 36, 5, 0 }, },
      { { 1, 194, 21, 1 },
        { 122, 80, 16, 0 },
        { 212, 33, 192, 0 },
        { 4, 5, 47, 0 }, },
      { { 1, 231, 113, 0 },
        { 115, 212, 3, 0 },
        { 71, 115, 192, 0 },
        { 96, 21, 231, 0 }, },
      { { 9, 41, 191, 0 },
        { 144, 218, 51, 1 },
        { 126, 202, 72, 0 },
        { 230, 45, 132, 1 }, },
      { { 13, 16, 27, 1 },
        { 152, 82, 68, 1 },
        { 236, 4, 88, 0 },
        { 145, 37, 12, 1 }, },
      { { 13, 5, 24, 0 },
        { 145, 16, 5, 1 },
        { 12, 80, 88, 0 },
        { 208, 4, 68, 1 }, },
      { { 13, 237, 47, 1 },
        { 203, 218, 23, 1 },
        { 250, 91, 216, 0 },
        { 244, 45, 233, 1 }, },
      { { 13, 102, 222, 0 },
        { 241, 22, 54, 1 },
        { 61, 179, 88, 0 },
        { 182, 52, 71, 1 }, },
      { { 9, 242, 118, 0 },
        { 242, 150, 82, 0 },
        { 55, 39, 200, 0 },
        { 37, 52, 167, 1 }, },
      { { 2, 208, 130, 1 },
        { 74, 2, 224, 0 },
        { 160, 133, 160, 0 },
        { 3, 160, 41, 0 }, },
      { { 2, 98, 201, 0 },
        { 96, 68, 162, 1 },
        { 73, 163, 32, 0 },
        { 162, 145, 3, 0 }, },
      { { 6, 243, 169, 0 },
        { 98, 192, 231, 1 },
        { 74, 231, 176, 0 },
        { 243, 129, 163, 0 }, },
      { { 6, 239, 35, 0 },
        { 99, 202, 135, 0 },
        { 98, 123, 176, 0 },
        { 112, 169, 227, 0 }, },
      { { 14, 62, 18, 0 },
        { 177, 10, 198, 0 },
        { 36, 62, 56, 0 },
        { 49, 168, 70, 1 }, },
      { { 10, 154, 221, 1 },
        { 186, 76, 240, 1 },
        { 221, 172, 168, 0 },
        { 135, 153, 46, 1 }, },
      { { 10, 97, 109, 1 },
        { 200, 196, 147, 1 },
        { 219, 67, 40, 0 },
        { 228, 145, 137, 1 }, },
      { { 10, 255, 81, 0 },
        { 243, 76, 195, 0 },
        { 69, 127, 168, 0 },
        { 97, 153, 103, 1 }, },
      { { 7, 230, 114, 1 },
        { 123, 150, 134, 0 },
        { 167, 51, 240, 0 },
        { 48, 180, 239, 0 }, },
      { { 11, 154, 1, 0 },
        { 162, 88, 192, 0 },
        { 64, 44, 232, 0 },
        { 1, 141, 34, 1 }, },
      { { 15, 208, 142, 0 },
        { 194, 18, 244, 1 },
        { 56, 133, 248, 0 },
        { 151, 164, 33, 1 }, },
      { { 15, 73, 147, 0 },
        { 208, 90, 165, 0 },
        { 100, 201, 120, 0 },
        { 82, 173, 5, 1 }, },
      { { 15, 247, 123, 0 },
        { 243, 214, 199, 1 },
        { 111, 119, 248, 0 },
        { 241, 181, 231, 1 }, },
      { { 16, 158, 96, 1 },
        { 47, 140, 64, 0 },
        { 131, 60, 132, 0 },
        { 1, 24, 250, 0 }, },
      { { 16, 81, 237, 0 },
        { 68, 196, 113, 1 },
        { 91, 197, 4, 0 },
        { 199, 17, 145, 0 }, },
      { { 20, 122, 222, 1 },
        { 124, 14, 118, 1 },
        { 189, 175, 20, 0 },
        { 183, 56, 31, 0 }, },
      { { 28, 133, 62, 1 },
        { 159, 130, 21, 1 },
        { 190, 80, 156, 0 },
        { 212, 32, 252, 1 }, },
      { { 28, 35, 104, 0 },
        { 164, 132, 7, 1 },
        { 11, 98, 28, 0 },
        { 240, 16, 146, 1 }, },
      { { 24, 199, 52, 0 },
        { 247, 128, 17, 0 },
        { 22, 113, 140, 0 },
        { 68, 0, 247, 1 }, },
      { { 21, 251, 130, 1 },
        { 110, 26, 103, 0 },
        { 160, 239, 212, 0 },
        { 115, 44, 59, 0 }, },
      { { 17, 78, 147, 1 },
        { 125, 90, 32, 0 },
        { 228, 185, 68, 0 },
        { 2, 45, 95, 0 }, },
      { { 25, 160, 234, 1 },
        { 142, 150, 34, 1 },
        { 171, 130, 204, 0 },
        { 162, 52, 184, 1 }, },
      { { 18, 24, 76, 0 },
        { 4, 12, 208, 1 },
        { 25, 12, 36, 0 },
        { 133, 152, 16, 0 }, },
      { { 18, 163, 174, 0 },
        { 38, 130, 179, 1 },
        { 58, 226, 164, 0 },
        { 230, 160, 178, 0 }, },
      { { 30, 172, 60, 0 },
        { 151, 136, 150, 1 },
        { 30, 26, 188, 0 },
        { 180, 136, 244, 1 }, },
      { { 30, 201, 108, 0 },
        { 198, 140, 149, 1 },
        { 27, 73, 188, 0 },
        { 212, 152, 177, 1 }, },
      { { 30, 233, 163, 1 },
        { 206, 202, 167, 0 },
        { 226, 203, 188, 0 },
        { 114, 169, 185, 1 }, },
      { { 26, 118, 216, 0 },
        { 245, 4, 226, 1 },
        { 13, 183, 44, 0 },
        { 163, 144, 87, 1 }, },
      { { 19, 182, 7, 1 },
        { 47, 82, 210, 0 },
        { 240, 54, 228, 0 },
        { 37, 165, 122, 0 }, },
      { { 23, 70, 188, 0 },
        { 117, 144, 180, 1 },
        { 30, 177, 116, 0 },
        { 150, 132, 215, 0 }, },
      { { 31, 21, 121, 0 },
        { 149, 212, 197, 1 },
        { 79, 84, 124, 0 },
        { 209, 149, 212, 1 }, },
      { { 27, 35, 125, 0 },
        { 180, 212, 147, 1 },
        { 95, 98, 108, 0 },
        { 228, 149, 150, 1 }, },
      { { 27, 191, 146, 0 },
        { 183, 26, 227, 0 },
        { 36, 254, 236, 0 },
        { 99, 172, 118, 1 }, },
      { { 31, 150, 154, 1 },
        { 191, 18, 228, 1 },
        { 172, 180, 252, 0 },
        { 147, 164, 126, 1 }, },
      { { 27, 72, 235, 0 },
        { 196, 222, 160, 1 },
        { 107, 137, 108, 0 },
        { 130, 189, 145, 1 }, },
      { { 32, 12, 253, 0 },
        { 17, 236, 48, 1 },
        { 95, 152, 2, 0 },
        { 134, 27, 196, 0 }, },
      { { 32, 23, 86, 0 },
        { 49, 38, 81, 0 },
        { 53, 116, 2, 0 },
        { 69, 50, 70, 0 }, },
      { { 40, 1, 153, 1 },
        { 152, 96, 33, 1 },
        { 204, 192, 10, 0 },
        { 194, 3, 12, 1 }, },
      { { 44, 50, 55, 1 },
        { 184, 226, 86, 0 },
        { 246, 38, 26, 0 },
        { 53, 35, 142, 1 }, },
      { { 37, 140, 230, 0 },
        { 3, 190, 52, 0 },
        { 51, 152, 210, 0 },
        { 22, 62, 224, 0 }, },
      { { 33, 30, 140, 0 },
        { 33, 56, 112, 1 },
        { 24, 188, 66, 0 },
        { 135, 14, 66, 0 }, },
      { { 45, 125, 105, 0 },
        { 193, 252, 71, 1 },
        { 75, 95, 90, 0 },
        { 241, 31, 193, 1 }, },
      { { 41, 192, 73, 0 },
        { 194, 116, 0, 1 },
        { 73, 1, 202, 0 },
        { 128, 23, 33, 1 }, },
      { { 38, 177, 32, 0 },
        { 2, 160, 199, 0 },
        { 2, 70, 178, 0 },
        { 113, 130, 160, 0 }, },
      { { 38, 128, 28, 1 },
        { 26, 32, 148, 1 },
        { 156, 0, 178, 0 },
        { 148, 130, 44, 0 }, },
      { { 34, 180, 26, 0 },
        { 19, 34, 194, 1 },
        { 44, 22, 162, 0 },
        { 161, 162, 100, 0 }, },
      { { 38, 42, 68, 1 },
        { 40, 44, 150, 0 },
        { 145, 42, 50, 0 },
        { 52, 154, 10, 0 }, },
      { { 38, 171, 89, 0 },
        { 50, 108, 135, 1 },
        { 77, 106, 178, 0 },
        { 240, 155, 38, 0 }, },
      { { 38, 201, 132, 0 },
        { 66, 40, 181, 0 },
        { 16, 201, 178, 0 },
        { 86, 138, 33, 0 }, },
      { { 42, 48, 98, 1 },
        { 136, 166, 194, 0 },
        { 163, 6, 42, 0 },
        { 33, 178, 136, 1 }, },
      { { 46, 50, 173, 0 },
        { 160, 224, 246, 1 },
        { 90, 166, 58, 0 },
        { 183, 131, 130, 1 }, },
      { { 35, 63, 1, 1 },
        { 41, 120, 195, 0 },
        { 192, 126, 98, 0 },
        { 97, 143, 74, 0 }, },
      { { 35, 131, 80, 0 },
        { 50, 52, 129, 0 },
        { 5, 96, 226, 0 },
        { 64, 150, 38, 0 }, },
      { { 39, 100, 46, 1 },
        { 73, 178, 150, 1 },
        { 186, 19, 114, 0 },
        { 180, 166, 201, 0 }, },
      { { 39, 212, 176, 1 },
        { 91, 176, 228, 0 },
        { 134, 149, 242, 0 },
        { 19, 134, 237, 0 }, },
      { { 47, 186, 44, 1 },
        { 170, 184, 214, 1 },
        { 154, 46, 250, 0 },
        { 181, 142, 170, 1 }, },
      { { 43, 38, 186, 1 },
        { 185, 178, 162, 1 },
        { 174, 178, 106, 0 },
        { 162, 166, 206, 1 }, },
      { { 48, 11, 141, 0 },
        { 36, 104, 49, 1 },
        { 88, 232, 6, 0 },
        { 198, 11, 18, 0 }, },
      { { 52, 38, 146, 1 },
        { 61, 34, 38, 0 },
        { 164, 178, 22, 0 },
        { 50, 34, 94, 0 }, },
      { { 48, 130, 25, 0 },
        { 54, 96, 0, 1 },
        { 76, 32, 134, 0 },
        { 128, 3, 54, 0 }, },
      { { 48, 123, 44, 1 },
        { 108, 168, 83, 1 },
        { 154, 111, 6, 0 },
        { 229, 10, 155, 0 }, },
      { { 60, 184, 59, 1 },
        { 158, 234, 70, 1 },
        { 238, 14, 158, 0 },
        { 177, 43, 188, 1 }, },
      { { 60, 38, 15, 1 },
        { 173, 98, 22, 1 },
        { 248, 50, 30, 0 },
        { 180, 35, 90, 1 }, },
      { { 56, 233, 220, 0 },
        { 214, 44, 51, 1 },
        { 29, 203, 142, 0 },
        { 230, 26, 53, 1 }, },
      { { 60, 192, 247, 0 },
        { 214, 230, 52, 0 },
        { 119, 129, 158, 0 },
        { 22, 51, 181, 1 }, },
      { { 56, 247, 84, 1 },
        { 255, 36, 83, 0 },
        { 149, 119, 142, 0 },
        { 101, 18, 127, 1 }, },
      { { 49, 5, 180, 1 },
        { 29, 176, 49, 0 },
        { 150, 208, 70, 0 },
        { 70, 6, 220, 0 }, },
      { { 53, 184, 254, 1 },
        { 30, 190, 118, 1 },
        { 191, 142, 214, 0 },
        { 183, 62, 188, 0 }, },
      { { 53, 178, 211, 1 },
        { 62, 118, 102, 0 },
        { 229, 166, 214, 0 },
        { 51, 55, 62, 0 }, },
      { { 57, 155, 206, 1 },
        { 174, 62, 113, 1 },
        { 185, 236, 206, 0 },
        { 199, 62, 58, 1 }, },
      { { 57, 109, 46, 0 },
        { 197, 186, 19, 1 },
        { 58, 91, 78, 0 },
        { 228, 46, 209, 1 }, },
      { { 61, 224, 131, 1 },
        { 206, 114, 38, 0 },
        { 224, 131, 222, 0 },
        { 50, 39, 57, 1 }, },
      { { 57, 244, 208, 0 },
        { 215, 52, 98, 0 },
        { 5, 151, 206, 0 },
        { 35, 22, 117, 1 }, },
      { { 57, 255, 32, 0 },
        { 231, 184, 67, 0 },
        { 2, 127, 206, 0 },
        { 97, 14, 243, 1 }, },
      { { 57, 199, 136, 1 },
        { 239, 48, 33, 1 },
        { 136, 241, 206, 0 },
        { 194, 6, 123, 1 }, },
      { { 54, 15, 36, 0 },
        { 37, 168, 149, 0 },
        { 18, 120, 54, 0 },
        { 84, 138, 210, 0 }, },
      { { 50, 30, 213, 0 },
        { 53, 108, 240, 0 },
        { 85, 188, 38, 0 },
        { 7, 155, 86, 0 }, },
      { { 54, 191, 209, 1 },
        { 63, 108, 231, 0 },
        { 197, 254, 182, 0 },
        { 115, 155, 126, 0 }, },
      { { 54, 70, 235, 0 },
        { 101, 230, 164, 1 },
        { 107, 177, 54, 0 },
        { 146, 179, 211, 0 }, },
      { { 58, 45, 168, 0 },
        { 133, 168, 163, 1 },
        { 10, 218, 46, 0 },
        { 226, 138, 208, 1 }, },
      { { 58, 147, 187, 0 },
        { 182, 226, 225, 1 },
        { 110, 228, 174, 0 },
        { 195, 163, 182, 1 }, },
      { { 55, 149, 173, 0 },
        { 7, 240, 245, 1 },
        { 90, 212, 246, 0 },
        { 215, 135, 240, 0 }, },
      { { 55, 4, 147, 0 },
        { 21, 114, 164, 0 },
        { 100, 144, 118, 0 },
        { 18, 167, 84, 0 }, },
      { { 51, 160, 216, 1 },
        { 30, 52, 162, 1 },
        { 141, 130, 230, 0 },
        { 162, 150, 60, 0 }, },
      { { 55, 67, 167, 0 },
        { 100, 242, 181, 0 },
        { 114, 225, 118, 0 },
        { 86, 167, 147, 0 }, },
      { { 51, 250, 92, 0 },
        { 118, 60, 210, 1 },
        { 29, 47, 230, 0 },
        { 165, 158, 55, 0 }, },
      { { 63, 131, 110, 0 },
        { 166, 182, 149, 1 },
        { 59, 96, 254, 0 },
        { 212, 182, 178, 1 }, },
      { { 63, 107, 96, 0 },
        { 228, 188, 135, 0 },
        { 3, 107, 126, 0 },
        { 112, 158, 147, 1 }, },
      { { 64, 225, 205, 0 },
        { 66, 69, 51, 1 },
        { 89, 195, 129, 0 },
        { 230, 81, 33, 0 }, },
      { { 76, 144, 234, 0 },
        { 130, 135, 100, 1 },
        { 43, 132, 153, 0 },
        { 147, 112, 160, 1 }, },
      { { 72, 154, 105, 1 },
        { 170, 205, 64, 1 },
        { 203, 44, 137, 0 },
        { 129, 89, 170, 1 }, },
      { { 76, 190, 247, 0 },
        { 179, 207, 118, 0 },
        { 119, 190, 153, 0 },
        { 55, 121, 230, 1 }, },
      { { 72, 235, 138, 1 },
        { 234, 11, 35, 1 },
        { 168, 235, 137, 0 },
        { 226, 104, 43, 1 }, },
      { { 72, 211, 7, 1 },
        { 234, 67, 81, 0 },
        { 240, 101, 137, 0 },
        { 69, 97, 43, 1 }, },
      { { 76, 90, 152, 1 },
        { 248, 9, 100, 1 },
        { 140, 173, 25, 0 },
        { 147, 72, 15, 1 }, },
      { { 65, 36, 19, 1 },
        { 25, 83, 2, 0 },
        { 228, 18, 65, 0 },
        { 32, 101, 76, 0 }, },
      { { 77, 11, 248, 0 },
        { 176, 157, 37, 1 },
        { 15, 232, 89, 0 },
        { 210, 92, 134, 1 }, },
      { { 73, 91, 189, 1 },
        { 248, 217, 113, 1 },
        { 222, 237, 73, 0 },
        { 199, 77, 143, 1 }, },
      { { 70, 141, 101, 0 },
        { 3, 205, 149, 0 },
        { 83, 88, 177, 0 },
        { 84, 217, 224, 0 }, },
      { { 66, 181, 107, 1 },
        { 11, 199, 195, 1 },
        { 235, 86, 161, 0 },
        { 225, 241, 232, 0 }, },
      { { 70, 92, 131, 0 },
        { 65, 75, 228, 0 },
        { 96, 157, 49, 0 },
        { 19, 233, 65, 0 }, },
      { { 70, 244, 103, 0 },
        { 67, 199, 214, 0 },
        { 115, 23, 177, 0 },
        { 53, 241, 225, 0 }, },
      { { 70, 121, 187, 0 },
        { 80, 203, 231, 1 },
        { 110, 207, 49, 0 },
        { 243, 233, 133, 0 }, },
      { { 74, 163, 157, 1 },
        { 186, 65, 179, 1 },
        { 220, 226, 169, 0 },
        { 230, 193, 46, 1 }, },
      { { 78, 65, 78, 1 },
        { 200, 7, 149, 1 },
        { 185, 65, 57, 0 },
        { 212, 240, 9, 1 }, },
      { { 78, 75, 194, 0 },
        { 224, 15, 165, 0 },
        { 33, 233, 57, 0 },
        { 82, 248, 3, 1 }, },
      { { 67, 137, 211, 1 },
        { 26, 95, 161, 0 },
        { 229, 200, 225, 0 },
        { 66, 253, 44, 0 }, },
      { { 71, 170, 200, 1 },
        { 42, 29, 166, 1 },
        { 137, 170, 241, 0 },
        { 178, 220, 42, 0 }, },
      { { 67, 59, 19, 0 },
        { 48, 91, 195, 0 },
        { 100, 110, 97, 0 },
        { 97, 237, 6, 0 }, },
      { { 71, 74, 105, 1 },
        { 104, 221, 132, 1 },
        { 203, 41, 113, 0 },
        { 144, 221, 139, 0 }, },
      { { 79, 22, 235, 1 },
        { 169, 215, 228, 1 },
        { 235, 180, 121, 0 },
        { 147, 245, 202, 1 }, },
      { { 79, 69, 160, 0 },
        { 193, 145, 165, 0 },
        { 2, 209, 121, 0 },
        { 82, 196, 193, 1 }, },
      { { 80, 145, 108, 1 },
        { 14, 133, 81, 1 },
        { 155, 68, 133, 0 },
        { 197, 80, 184, 0 }, },
      { { 84, 16, 187, 0 },
        { 20, 195, 100, 1 },
        { 110, 132, 21, 0 },
        { 147, 97, 148, 0 }, },
      { { 80, 90, 77, 1 },
        { 108, 77, 80, 1 },
        { 217, 45, 5, 0 },
        { 133, 89, 27, 0 }, },
      { { 80, 114, 212, 0 },
        { 116, 5, 114, 0 },
        { 21, 167, 5, 0 },
        { 39, 80, 23, 0 }, },
      { { 84, 234, 241, 1 },
        { 126, 205, 38, 0 },
        { 199, 171, 149, 0 },
        { 50, 89, 191, 0 }, },
      { { 88, 9, 195, 1 },
        { 140, 79, 33, 0 },
        { 225, 200, 13, 0 },
        { 66, 121, 24, 1 }, },
      { { 92, 89, 121, 0 },
        { 212, 205, 69, 1 },
        { 79, 77, 29, 0 },
        { 209, 89, 149, 1 }, },
      { { 88, 107, 27, 0 },
        { 244, 75, 3, 1 },
        { 108, 107, 13, 0 },
        { 224, 105, 23, 1 }, },
      { { 81, 52, 246, 1 },
        { 29, 151, 114, 0 },
        { 183, 150, 69, 0 },
        { 39, 116, 220, 0 }, },
      { { 85, 169, 118, 1 },
        { 30, 159, 23, 0 },
        { 183, 74, 213, 0 },
        { 116, 124, 188, 0 }, },
      { { 85, 151, 183, 1 },
        { 63, 211, 117, 0 },
        { 246, 244, 213, 0 },
        { 87, 101, 254, 0 }, },
      { { 85, 72, 67, 1 },
        { 76, 95, 4, 0 },
        { 225, 9, 85, 0 },
        { 16, 125, 25, 0 }, },
      { { 81, 203, 28, 0 },
        { 118, 25, 17, 1 },
        { 28, 105, 197, 0 },
        { 196, 76, 55, 0 }, },
      { { 89, 103, 105, 1 },
        { 237, 213, 3, 1 },
        { 203, 115, 77, 0 },
        { 224, 85, 219, 1 }, },
      { { 89, 87, 155, 0 },
        { 245, 83, 97, 1 },
        { 108, 245, 77, 0 },
        { 195, 101, 87, 1 }, },
      { { 86, 160, 171, 1 },
        { 14, 195, 166, 1 },
        { 234, 130, 181, 0 },
        { 178, 225, 184, 0 }, },
      { { 82, 76, 88, 0 },
        { 85, 13, 128, 1 },
        { 13, 25, 37, 0 },
        { 128, 216, 85, 0 }, },
      { { 86, 87, 68, 1 },
        { 109, 5, 213, 0 },
        { 145, 117, 53, 0 },
        { 85, 208, 91, 0 }, },
      { { 94, 1, 56, 0 },
        { 148, 129, 133, 1 },
        { 14, 64, 61, 0 },
        { 208, 192, 148, 1 }, },
      { { 90, 1, 255, 0 },
        { 148, 199, 177, 1 },
        { 127, 192, 45, 0 },
        { 198, 241, 148, 1 }, },
      { { 90, 53, 19, 1 },
        { 157, 67, 195, 0 },
        { 228, 86, 45, 0 },
        { 97, 225, 92, 1 }, },
      { { 94, 29, 215, 1 },
        { 157, 79, 245, 0 },
        { 245, 220, 61, 0 },
        { 87, 249, 92, 1 }, },
      { { 94, 146, 70, 1 },
        { 174, 7, 212, 0 },
        { 177, 36, 189, 0 },
        { 21, 240, 58, 1 }, },
      { { 90, 108, 162, 0 },
        { 197, 139, 162, 0 },
        { 34, 155, 45, 0 },
        { 34, 232, 209, 1 }, },
      { { 87, 57, 5, 0 },
        { 4, 89, 215, 0 },
        { 80, 78, 117, 0 },
        { 117, 205, 16, 0 }, },
      { { 87, 185, 238, 0 },
        { 6, 159, 247, 1 },
        { 59, 206, 245, 0 },
        { 247, 252, 176, 0 }, },
      { { 83, 27, 44, 1 },
        { 44, 153, 209, 1 },
        { 154, 108, 101, 0 },
        { 197, 204, 154, 0 }, },
      { { 87, 134, 8, 0 },
        { 39, 17, 132, 1 },
        { 8, 48, 245, 0 },
        { 144, 196, 114, 0 }, },
      { { 87, 179, 31, 1 },
        { 62, 83, 215, 1 },
        { 252, 102, 245, 0 },
        { 245, 229, 62, 0 }, },
      { { 87, 175, 125, 0 },
        { 55, 221, 151, 1 },
        { 95, 122, 245, 0 },
        { 244, 221, 246, 0 }, },
      { { 83, 240, 235, 0 },
        { 70, 215, 226, 1 },
        { 107, 135, 229, 0 },
        { 163, 245, 177, 0 }, },
      { { 91, 30, 236, 0 },
        { 165, 157, 240, 1 },
        { 27, 188, 109, 0 },
        { 135, 220, 210, 1 }, },
      { { 95, 6, 166, 1 },
        { 173, 147, 180, 0 },
        { 178, 176, 125, 0 },
        { 22, 228, 218, 1 }, },
      { { 95, 46, 87, 1 },
        { 189, 95, 150, 0 },
        { 245, 58, 125, 0 },
        { 52, 253, 94, 1 }, },
      { { 91, 89, 192, 0 },
        { 196, 29, 225, 0 },
        { 1, 205, 109, 0 },
        { 67, 220, 17, 1 }, },
      { { 91, 221, 125, 1 },
        { 223, 221, 209, 1 },
        { 223, 93, 237, 0 },
        { 197, 221, 253, 1 }, },
      { { 91, 78, 47, 0 },
        { 229, 219, 144, 1 },
        { 122, 57, 109, 0 },
        { 132, 237, 211, 1 }, },
      { { 95, 111, 137, 1 },
        { 237, 89, 167, 1 },
        { 200, 251, 125, 0 },
        { 242, 205, 91, 1 }, },
      { { 91, 99, 218, 0 },
        { 244, 23, 163, 1 },
        { 45, 227, 109, 0 },
        { 226, 244, 23, 1 }, },
      { { 96, 32, 36, 1 },
        { 8, 161, 18, 0 },
        { 146, 2, 3, 0 },
        { 36, 66, 136, 0 }, },
      { { 100, 167, 30, 1 },
        { 59, 35, 23, 1 },
        { 188, 114, 147, 0 },
        { 244, 98, 110, 0 }, },
      { { 96, 84, 84, 1 },
        { 89, 37, 80, 0 },
        { 149, 21, 3, 0 },
        { 5, 82, 77, 0 }, },
      { { 104, 166, 103, 0 },
        { 163, 231, 18, 0 },
        { 115, 50, 139, 0 },
        { 36, 115, 226, 1 }, },
      { { 108, 235, 188, 1 },
        { 250, 169, 55, 1 },
        { 158, 235, 155, 0 },
        { 246, 74, 175, 1 }, },
      { { 105, 70, 205, 1 },
        { 233, 117, 48, 1 },
        { 217, 177, 75, 0 },
        { 134, 87, 75, 1 }, },
      { { 109, 243, 169, 1 },
        { 234, 241, 103, 1 },
        { 202, 231, 219, 0 },
        { 243, 71, 171, 1 }, },
      { { 109, 94, 31, 0 },
        { 241, 123, 84, 1 },
        { 124, 61, 91, 0 },
        { 149, 111, 71, 1 }, },
      { { 102, 32, 99, 0 },
        { 0, 231, 134, 0 },
        { 99, 2, 51, 0 },
        { 48, 243, 128, 0 }, },
      { { 102, 219, 83, 1 },
        { 122, 111, 197, 0 },
        { 229, 109, 179, 0 },
        { 81, 251, 47, 0 }, },
      { { 98, 215, 16, 1 },
        { 123, 33, 193, 0 },
        { 132, 117, 163, 0 },
        { 65, 194, 111, 0 }, },
      { { 106, 165, 84, 1 },
        { 155, 37, 147, 0 },
        { 149, 82, 171, 0 },
        { 100, 210, 108, 1 }, },
      { { 110, 46, 41, 1 },
        { 169, 233, 134, 1 },
        { 202, 58, 59, 0 },
        { 176, 203, 202, 1 }, },
      { { 103, 54, 146, 0 },
        { 49, 51, 230, 0 },
        { 36, 182, 115, 0 },
        { 51, 230, 70, 0 }, },
      { { 103, 196, 202, 0 },
        { 67, 55, 164, 1 },
        { 41, 145, 243, 0 },
        { 146, 246, 97, 0 }, },
      { { 99, 83, 34, 1 },
        { 104, 179, 193, 0 },
        { 162, 101, 99, 0 },
        { 65, 230, 139, 0 }, },
      { { 107, 59, 196, 1 },
        { 168, 61, 243, 0 },
        { 145, 238, 107, 0 },
        { 103, 222, 10, 1 }, },
      { { 111, 22, 80, 1 },
        { 185, 53, 196, 0 },
        { 133, 52, 123, 0 },
        { 17, 214, 78, 1 }, },
      { { 107, 88, 37, 1 },
        { 200, 249, 208, 0 },
        { 210, 13, 107, 0 },
        { 5, 207, 137, 1 }, },
      { { 111, 99, 213, 1 },
        { 248, 117, 183, 0 },
        { 213, 227, 123, 0 },
        { 118, 215, 15, 1 }, },
      { { 112, 192, 248, 1 },
        { 94, 165, 32, 1 },
        { 143, 129, 135, 0 },
        { 130, 82, 189, 0 }, },
      { { 116, 215, 208, 0 },
        { 119, 37, 101, 0 },
        { 5, 245, 151, 0 },
        { 83, 82, 119, 0 }, },
      { { 113, 43, 110, 1 },
        { 44, 191, 19, 1 },
        { 187, 106, 71, 0 },
        { 228, 126, 154, 0 }, },
      { { 113, 121, 27, 1 },
        { 92, 123, 67, 1 },
        { 236, 79, 71, 0 },
        { 225, 111, 29, 0 }, },
      { { 113, 66, 210, 0 },
        { 116, 55, 32, 0 },
        { 37, 161, 71, 0 },
        { 2, 118, 23, 0 }, },
      { { 113, 99, 253, 0 },
        { 116, 245, 51, 1 },
        { 95, 227, 71, 0 },
        { 230, 87, 151, 0 }, },
      { { 117, 254, 122, 1 },
        { 127, 191, 70, 1 },
        { 175, 63, 215, 0 },
        { 177, 126, 255, 0 }, },
      { { 125, 152, 140, 0 },
        { 134, 57, 116, 1 },
        { 24, 140, 223, 0 },
        { 151, 78, 48, 1 }, },
      { { 125, 185, 247, 0 },
        { 150, 255, 119, 0 },
        { 119, 206, 223, 0 },
        { 119, 127, 180, 1 }, },
      { { 125, 19, 147, 1 },
        { 188, 115, 101, 0 },
        { 228, 228, 95, 0 },
        { 83, 103, 30, 1 }, },
      { { 121, 71, 103, 0 },
        { 229, 247, 17, 0 },
        { 115, 113, 79, 0 },
        { 68, 119, 211, 1 }, },
      { { 125, 223, 195, 0 },
        { 231, 127, 101, 0 },
        { 97, 253, 223, 0 },
        { 83, 127, 115, 1 }, },
      { { 121, 239, 82, 1 },
        { 255, 63, 3, 0 },
        { 165, 123, 207, 0 },
        { 96, 126, 127, 1 }, },
      { { 114, 0, 182, 0 },
        { 20, 163, 176, 0 },
        { 54, 128, 39, 0 },
        { 6, 226, 148, 0 }, },
      { { 118, 68, 152, 1 },
        { 93, 33, 164, 1 },
        { 140, 145, 55, 0 },
        { 146, 194, 93, 0 }, },
      { { 118, 122, 66, 0 },
        { 100, 47, 198, 0 },
        { 33, 47, 55, 0 },
        { 49, 250, 19, 0 }, },
      { { 126, 11, 181, 1 },
        { 188, 233, 181, 0 },
        { 214, 232, 63, 0 },
        { 86, 203, 158, 1 }, },
      { { 115, 58, 225, 1 },
        { 44, 253, 226, 0 },
        { 195, 174, 103, 0 },
        { 35, 223, 154, 0 }, },
      { { 119, 139, 59, 1 },
        { 62, 251, 133, 1 },
        { 238, 104, 247, 0 },
        { 208, 239, 190, 0 }, },
      { { 119, 93, 234, 0 },
        { 69, 191, 229, 1 },
        { 43, 221, 119, 0 },
        { 211, 254, 209, 0 }, },
      { { 127, 76, 0, 1 },
        { 205, 57, 132, 0 },
        { 128, 25, 127, 0 },
        { 16, 206, 89, 1 }, },
      { { 123, 117, 224, 1 },
        { 205, 181, 227, 0 },
        { 131, 215, 111, 0 },
        { 99, 214, 217, 1 }, },
      { { 127, 226, 186, 0 },
        { 246, 179, 166, 1 },
        { 46, 163, 255, 0 },
        { 178, 230, 183, 1 }, },
      { { 128, 176, 67, 1 },
        { 10, 70, 74, 0 },
        { 225, 6, 128, 1 },
        { 41, 49, 40, 0 }, },
      { { 128, 188, 61, 0 },
        { 19, 200, 90, 1 },
        { 94, 30, 128, 1 },
        { 173, 9, 228, 0 }, },
      { { 128, 50, 88, 0 },
        { 48, 4, 74, 1 },
        { 13, 38, 0, 1 },
        { 169, 16, 6, 0 }, },
      { { 128, 92, 26, 1 },
        { 89, 10, 72, 1 },
        { 172, 29, 0, 1 },
        { 137, 40, 77, 0 }, },
      { { 132, 251, 36, 0 },
        { 98, 136, 95, 0 },
        { 18, 111, 144, 1 },
        { 125, 8, 163, 0 }, },
      { { 128, 127, 245, 1 },
        { 121, 204, 123, 0 },
        { 215, 255, 0, 1 },
        { 111, 25, 207, 0 }, },
      { { 136, 45, 197, 1 },
        { 137, 76, 59, 0 },
        { 209, 218, 8, 1 },
        { 110, 25, 72, 1 }, },
      { { 136, 153, 224, 1 },
        { 138, 140, 105, 0 },
        { 131, 204, 136, 1 },
        { 75, 24, 168, 1 }, },
      { { 136, 25, 149, 0 },
        { 144, 72, 121, 0 },
        { 84, 204, 8, 1 },
        { 79, 9, 4, 1 }, },
      { { 133, 29, 199, 1 },
        { 9, 94, 125, 0 },
        { 241, 220, 80, 1 },
        { 95, 61, 72, 0 }, },
      { { 129, 187, 135, 0 },
        { 34, 90, 123, 0 },
        { 112, 238, 192, 1 },
        { 111, 45, 34, 0 }, },
      { { 129, 225, 96, 1 },
        { 74, 148, 11, 0 },
        { 131, 67, 192, 1 },
        { 104, 20, 169, 0 }, },
      { { 133, 126, 33, 1 },
        { 105, 216, 78, 0 },
        { 194, 63, 80, 1 },
        { 57, 13, 203, 0 }, },
      { { 129, 242, 146, 0 },
        { 114, 18, 106, 0 },
        { 36, 167, 192, 1 },
        { 43, 36, 39, 0 }, },
      { { 137, 61, 108, 1 },
        { 137, 156, 91, 1 },
        { 155, 94, 72, 1 },
        { 237, 28, 200, 1 }, },
      { { 137, 100, 178, 1 },
        { 217, 146, 42, 0 },
        { 166, 147, 72, 1 },
        { 42, 36, 205, 1 }, },
      { { 141, 212, 30, 1 },
        { 219, 18, 92, 1 },
        { 188, 21, 216, 1 },
        { 157, 36, 109, 1 }, },
      { { 137, 94, 209, 1 },
        { 249, 92, 104, 0 },
        { 197, 189, 72, 1 },
        { 11, 29, 79, 1 }, },
      { { 138, 4, 172, 0 },
        { 129, 128, 184, 1 },
        { 26, 144, 40, 1 },
        { 142, 128, 192, 1 }, },
      { { 142, 200, 22, 0 },
        { 210, 10, 156, 0 },
        { 52, 9, 184, 1 },
        { 28, 168, 37, 1 }, },
      { { 142, 242, 252, 1 },
        { 250, 132, 254, 1 },
        { 159, 167, 184, 1 },
        { 191, 144, 175, 1 }, },
      { { 131, 11, 137, 0 },
        { 32, 88, 169, 1 },
        { 72, 232, 96, 1 },
        { 202, 141, 2, 0 }, },
      { { 135, 43, 109, 0 },
        { 32, 220, 159, 1 },
        { 91, 106, 112, 1 },
        { 252, 157, 130, 0 }, },
      { { 135, 69, 49, 0 },
        { 81, 208, 141, 0 },
        { 70, 81, 112, 1 },
        { 88, 133, 197, 0 }, },
      { { 131, 108, 120, 1 },
        { 89, 156, 138, 1 },
        { 143, 27, 96, 1 },
        { 168, 156, 205, 0 }, },
      { { 135, 238, 13, 0 },
        { 99, 88, 158, 1 },
        { 88, 59, 240, 1 },
        { 188, 141, 99, 0 }, },
      { { 139, 177, 43, 1 },
        { 138, 210, 203, 1 },
        { 234, 70, 232, 1 },
        { 233, 165, 168, 1 }, },
      { { 139, 145, 216, 0 },
        { 146, 20, 233, 1 },
        { 13, 196, 232, 1 },
        { 203, 148, 36, 1 }, },
      { { 139, 89, 102, 0 },
        { 192, 158, 217, 0 },
        { 51, 77, 104, 1 },
        { 77, 188, 129, 1 }, },
      { { 143, 229, 85, 0 },
        { 211, 84, 159, 0 },
        { 85, 83, 248, 1 },
        { 124, 149, 101, 1 }, },
      { { 143, 243, 101, 1 },
        { 234, 212, 223, 0 },
        { 211, 103, 248, 1 },
        { 125, 149, 171, 1 }, },
      { { 148, 26, 21, 0 },
        { 52, 72, 92, 0 },
        { 84, 44, 20, 1 },
        { 29, 9, 22, 0 }, },
      { { 144, 225, 167, 0 },
        { 70, 194, 59, 0 },
        { 114, 195, 132, 1 },
        { 110, 33, 177, 0 }, },
      { { 144, 71, 255, 0 },
        { 117, 198, 57, 1 },
        { 127, 241, 4, 1 },
        { 206, 49, 215, 0 }, },
      { { 156, 188, 213, 0 },
        { 151, 76, 126, 0 },
        { 85, 158, 156, 1 },
        { 63, 25, 116, 1 }, },
      { { 152, 146, 244, 0 },
        { 182, 132, 120, 0 },
        { 23, 164, 140, 1 },
        { 15, 16, 182, 1 }, },
      { { 156, 83, 168, 1 },
        { 236, 128, 109, 1 },
        { 138, 229, 28, 1 },
        { 219, 0, 155, 1 }, },
      { { 152, 195, 107, 0 },
        { 230, 198, 9, 1 },
        { 107, 97, 140, 1 },
        { 200, 49, 179, 1 }, },
      { { 152, 114, 63, 1 },
        { 252, 194, 90, 1 },
        { 254, 39, 12, 1 },
        { 173, 33, 159, 1 }, },
      { { 145, 19, 213, 0 },
        { 52, 84, 121, 0 },
        { 85, 228, 68, 1 },
        { 79, 21, 22, 0 }, },
      { { 149, 191, 251, 0 },
        { 55, 222, 111, 1 },
        { 111, 254, 212, 1 },
        { 251, 61, 246, 0 }, },
      { { 149, 69, 22, 1 },
        { 93, 18, 29, 0 },
        { 180, 81, 84, 1 },
        { 92, 36, 93, 0 }, },
      { { 149, 238, 216, 0 },
        { 119, 28, 46, 1 },
        { 13, 187, 212, 1 },
        { 186, 28, 119, 0 }, },
      { { 157, 214, 4, 0 },
        { 231, 16, 92, 0 },
        { 16, 53, 220, 1 },
        { 29, 4, 115, 1 }, },
      { { 157, 98, 112, 0 },
        { 244, 148, 14, 0 },
        { 7, 35, 92, 1 },
        { 56, 20, 151, 1 }, },
      { { 150, 175, 206, 0 },
        { 39, 14, 191, 1 },
        { 57, 250, 180, 1 },
        { 254, 184, 114, 0 }, },
      { { 150, 186, 24, 1 },
        { 62, 8, 206, 1 },
        { 140, 46, 180, 1 },
        { 185, 136, 62, 0 }, },
      { { 150, 217, 61, 1 },
        { 94, 200, 221, 1 },
        { 222, 77, 180, 1 },
        { 221, 137, 189, 0 }, },
      { { 158, 33, 46, 0 },
        { 132, 130, 159, 1 },
        { 58, 66, 60, 1 },
        { 252, 160, 144, 1 }, },
      { { 154, 185, 132, 0 },
        { 134, 8, 251, 0 },
        { 16, 206, 172, 1 },
        { 111, 136, 48, 1 }, },
      { { 154, 129, 79, 1 },
        { 142, 70, 153, 1 },
        { 249, 64, 172, 1 },
        { 204, 177, 56, 1 }, },
      { { 154, 59, 54, 1 },
        { 188, 138, 219, 0 },
        { 182, 110, 44, 1 },
        { 109, 168, 158, 1 }, },
      { { 158, 195, 37, 0 },
        { 230, 192, 157, 0 },
        { 82, 97, 188, 1 },
        { 92, 129, 179, 1 }, },
      { { 147, 149, 40, 0 },
        { 7, 144, 201, 1 },
        { 10, 84, 228, 1 },
        { 201, 132, 240, 0 }, },
      { { 151, 50, 46, 1 },
        { 44, 146, 222, 1 },
        { 186, 38, 116, 1 },
        { 189, 164, 154, 0 }, },
      { { 151, 211, 152, 0 },
        { 118, 16, 237, 1 },
        { 12, 229, 244, 1 },
        { 219, 132, 55, 0 }, },
      { { 155, 157, 163, 1 },
        { 143, 218, 233, 0 },
        { 226, 220, 236, 1 },
        { 75, 173, 248, 1 }, },
      { { 159, 28, 240, 0 },
        { 149, 156, 236, 0 },
        { 7, 156, 124, 1 },
        { 27, 156, 212, 1 }, },
      { { 159, 51, 82, 1 },
        { 188, 22, 207, 0 },
        { 165, 102, 124, 1 },
        { 121, 180, 30, 1 }, },
      { { 155, 250, 202, 0 },
        { 230, 30, 234, 1 },
        { 41, 175, 236, 1 },
        { 171, 188, 51, 1 }, },
      { { 159, 250, 148, 0 },
        { 246, 24, 254, 0 },
        { 20, 175, 252, 1 },
        { 63, 140, 55, 1 }, },
      { { 160, 60, 203, 1 },
        { 9, 110, 106, 1 },
        { 233, 158, 2, 1 },
        { 171, 59, 72, 0 }, },
      { { 164, 168, 105, 0 },
        { 2, 236, 14, 1 },
        { 75, 10, 146, 1 },
        { 184, 27, 160, 0 }, },
      { { 160, 179, 245, 0 },
        { 50, 228, 123, 0 },
        { 87, 230, 130, 1 },
        { 111, 19, 166, 0 }, },
      { { 164, 106, 191, 0 },
        { 112, 234, 62, 1 },
        { 126, 171, 18, 1 },
        { 190, 43, 135, 0 }, },
      { { 160, 91, 120, 1 },
        { 120, 172, 73, 1 },
        { 143, 109, 2, 1 },
        { 201, 26, 143, 0 }, },
      { { 168, 104, 152, 1 },
        { 216, 40, 42, 1 },
        { 140, 139, 10, 1 },
        { 170, 10, 13, 1 }, },
      { { 172, 205, 54, 1 },
        { 219, 170, 29, 0 },
        { 182, 89, 154, 1 },
        { 92, 42, 237, 1 }, },
      { { 172, 220, 121, 1 },
        { 219, 236, 76, 1 },
        { 207, 29, 154, 1 },
        { 153, 27, 237, 1 }, },
      { { 161, 73, 35, 0 },
        { 64, 250, 9, 0 },
        { 98, 73, 66, 1 },
        { 72, 47, 129, 0 }, },
      { { 161, 67, 217, 0 },
        { 112, 116, 41, 1 },
        { 77, 225, 66, 1 },
        { 202, 23, 7, 0 }, },
      { { 173, 176, 209, 0 },
        { 146, 116, 110, 0 },
        { 69, 134, 218, 1 },
        { 59, 23, 36, 1 }, },
      { { 169, 155, 28, 1 },
        { 186, 56, 89, 1 },
        { 156, 108, 202, 1 },
        { 205, 14, 46, 1 }, },
      { { 169, 138, 215, 1 },
        { 186, 126, 56, 0 },
        { 245, 168, 202, 1 },
        { 14, 63, 46, 1 }, },
      { { 173, 84, 106, 1 },
        { 201, 182, 76, 1 },
        { 171, 21, 90, 1 },
        { 153, 54, 201, 1 }, },
      { { 173, 235, 81, 1 },
        { 250, 124, 15, 0 },
        { 197, 107, 218, 1 },
        { 120, 31, 47, 1 }, },
      { { 166, 29, 142, 0 },
        { 1, 42, 253, 1 },
        { 56, 220, 50, 1 },
        { 223, 170, 64, 0 }, },
      { { 166, 92, 102, 1 },
        { 73, 174, 220, 0 },
        { 179, 29, 50, 1 },
        { 29, 186, 201, 0 }, },
      { { 174, 188, 36, 0 },
        { 131, 168, 222, 0 },
        { 18, 30, 186, 1 },
        { 61, 138, 224, 1 }, },
      { { 170, 171, 48, 0 },
        { 178, 168, 139, 0 },
        { 6, 106, 170, 1 },
        { 104, 138, 166, 1 }, },
      { { 174, 204, 216, 0 },
        { 211, 44, 172, 1 },
        { 13, 153, 186, 1 },
        { 154, 154, 101, 1 }, },
      { { 170, 237, 187, 0 },
        { 211, 234, 171, 1 },
        { 110, 219, 170, 1 },
        { 234, 171, 229, 1 }, },
      { { 174, 227, 205, 1 },
        { 234, 100, 191, 1 },
        { 217, 227, 186, 1 },
        { 254, 147, 43, 1 }, },
      { { 167, 54, 8, 1 },
        { 41, 48, 206, 1 },
        { 136, 54, 114, 1 },
        { 185, 134, 74, 0 }, },
      { { 163, 236, 229, 0 },
        { 67, 252, 186, 0 },
        { 83, 155, 226, 1 },
        { 46, 159, 225, 0 }, },
      { { 163, 193, 155, 1 },
        { 90, 114, 169, 1 },
        { 236, 193, 226, 1 },
        { 202, 167, 45, 0 }, },
      { { 167, 250, 58, 0 },
        { 114, 186, 206, 1 },
        { 46, 47, 242, 1 },
        { 185, 174, 167, 0 }, },
      { { 175, 165, 105, 1 },
        { 139, 244, 143, 1 },
        { 203, 82, 250, 1 },
        { 248, 151, 232, 1 }, },
      { { 175, 200, 189, 1 },
        { 218, 248, 188, 1 },
        { 222, 137, 250, 1 },
        { 158, 143, 173, 1 }, },
      { { 175, 239, 164, 0 },
        { 227, 184, 191, 0 },
        { 18, 251, 250, 1 },
        { 126, 142, 227, 1 }, },
      { { 171, 103, 246, 0 },
        { 241, 182, 187, 0 },
        { 55, 243, 106, 1 },
        { 110, 182, 199, 1 }, },
      { { 180, 28, 82, 0 },
        { 21, 46, 76, 0 },
        { 37, 28, 22, 1 },
        { 25, 58, 84, 0 }, },
      { { 180, 63, 68, 1 },
        { 45, 44, 95, 0 },
        { 145, 126, 22, 1 },
        { 125, 26, 90, 0 }, },
      { { 180, 240, 202, 0 },
        { 70, 38, 110, 1 },
        { 41, 135, 150, 1 },
        { 187, 50, 49, 0 }, },
      { { 184, 24, 45, 0 },
        { 132, 232, 88, 1 },
        { 90, 12, 14, 1 },
        { 141, 11, 144, 1 }, },
      { { 188, 191, 136, 1 },
        { 175, 40, 111, 1 },
        { 136, 254, 158, 1 },
        { 251, 10, 122, 1 }, },
      { { 184, 142, 4, 1 },
        { 175, 40, 24, 0 },
        { 144, 56, 142, 1 },
        { 12, 10, 122, 1 }, },
      { { 188, 120, 40, 1 },
        { 204, 168, 78, 1 },
        { 138, 15, 30, 1 },
        { 185, 10, 153, 1 }, },
      { { 184, 200, 67, 1 },
        { 206, 110, 8, 0 },
        { 225, 9, 142, 1 },
        { 8, 59, 57, 1 }, },
      { { 188, 243, 60, 1 },
        { 254, 160, 95, 1 },
        { 158, 103, 158, 1 },
        { 253, 2, 191, 1 }, },
      { { 181, 19, 12, 0 },
        { 36, 48, 93, 1 },
        { 24, 100, 86, 1 },
        { 221, 6, 18, 0 }, },
      { { 177, 63, 106, 0 },
        { 37, 190, 75, 1 },
        { 43, 126, 70, 1 },
        { 233, 62, 210, 0 }, },
      { { 177, 101, 123, 1 },
        { 93, 246, 11, 1 },
        { 239, 83, 70, 1 },
        { 232, 55, 221, 0 }, },
      { { 177, 203, 237, 0 },
        { 102, 252, 57, 1 },
        { 91, 233, 198, 1 },
        { 206, 31, 179, 0 }, },
      { { 177, 194, 103, 1 },
        { 110, 246, 24, 0 },
        { 243, 33, 198, 1 },
        { 12, 55, 187, 0 }, },
      { { 177, 90, 242, 1 },
        { 124, 190, 104, 0 },
        { 167, 173, 70, 1 },
        { 11, 62, 159, 0 }, },
      { { 181, 238, 31, 1 },
        { 127, 122, 30, 1 },
        { 252, 59, 214, 1 },
        { 188, 47, 127, 0 }, },
      { { 185, 144, 112, 1 },
        { 158, 180, 72, 0 },
        { 135, 4, 206, 1 },
        { 9, 22, 188, 1 }, },
      { { 185, 163, 64, 1 },
        { 174, 52, 11, 0 },
        { 129, 98, 206, 1 },
        { 104, 22, 58, 1 }, },
      { { 185, 120, 90, 0 },
        { 212, 62, 74, 1 },
        { 45, 15, 78, 1 },
        { 169, 62, 21, 1 }, },
      { { 185, 247, 203, 0 },
        { 231, 118, 107, 1 },
        { 105, 247, 206, 1 },
        { 235, 55, 115, 1 }, },
      { { 182, 5, 1, 1 },
        { 13, 96, 141, 0 },
        { 192, 80, 54, 1 },
        { 88, 131, 88, 0 }, },
      { { 178, 255, 194, 0 },
        { 103, 46, 235, 0 },
        { 33, 255, 166, 1 },
        { 107, 186, 115, 0 }, },
      { { 178, 123, 21, 0 },
        { 116, 104, 219, 0 },
        { 84, 111, 38, 1 },
        { 109, 139, 23, 0 }, },
      { { 178, 110, 90, 1 },
        { 125, 46, 138, 1 },
        { 173, 59, 38, 1 },
        { 168, 186, 95, 0 }, },
      { { 190, 181, 243, 1 },
        { 159, 230, 239, 0 },
        { 231, 214, 190, 1 },
        { 123, 179, 252, 1 }, },
      { { 186, 167, 161, 0 },
        { 167, 224, 171, 0 },
        { 66, 242, 174, 1 },
        { 106, 131, 242, 1 }, },
      { { 186, 114, 10, 1 },
        { 236, 34, 202, 1 },
        { 168, 39, 46, 1 },
        { 169, 162, 27, 1 }, },
      { { 179, 48, 64, 0 },
        { 4, 52, 202, 0 },
        { 1, 6, 102, 1 },
        { 41, 150, 16, 0 }, },
      { { 183, 181, 52, 1 },
        { 31, 176, 223, 0 },
        { 150, 86, 246, 1 },
        { 125, 134, 252, 0 }, },
      { { 183, 105, 76, 0 },
        { 68, 60, 159, 1 },
        { 25, 75, 118, 1 },
        { 252, 158, 17, 0 }, },
      { { 183, 197, 193, 0 },
        { 71, 116, 173, 0 },
        { 65, 209, 246, 1 },
        { 90, 151, 113, 0 }, },
      { { 179, 87, 222, 0 },
        { 117, 54, 249, 1 },
        { 61, 245, 102, 1 },
        { 207, 182, 87, 0 }, },
      { { 187, 84, 251, 0 },
        { 213, 246, 232, 1 },
        { 111, 149, 110, 1 },
        { 139, 183, 213, 1 }, },
      { { 187, 202, 108, 1 },
        { 238, 188, 152, 1 },
        { 155, 41, 238, 1 },
        { 140, 158, 187, 1 }, },
      { { 187, 251, 225, 1 },
        { 238, 252, 235, 0 },
        { 195, 239, 238, 1 },
        { 107, 159, 187, 1 }, },
      { { 191, 246, 134, 1 },
        { 239, 50, 254, 0 },
        { 176, 183, 254, 1 },
        { 63, 166, 123, 1 }, },
      { { 196, 45, 124, 0 },
        { 17, 141, 31, 1 },
        { 31, 90, 17, 1 },
        { 252, 88, 196, 0 }, },
      { { 200, 28, 52, 0 },
        { 145, 137, 88, 0 },
        { 22, 28, 9, 1 },
        { 13, 72, 196, 1 }, },
      { { 204, 67, 229, 1 },
        { 232, 197, 61, 0 },
        { 211, 225, 25, 1 },
        { 94, 81, 139, 1 }, },
      { { 197, 53, 174, 1 },
        { 9, 147, 127, 1 },
        { 186, 214, 81, 1 },
        { 255, 100, 200, 0 }, },
      { { 193, 146, 192, 0 },
        { 34, 21, 104, 0 },
        { 1, 164, 193, 1 },
        { 11, 84, 34, 0 }, },
      { { 197, 35, 247, 0 },
        { 48, 215, 63, 0 },
        { 119, 226, 81, 1 },
        { 126, 117, 134, 0 }, },
      { { 193, 159, 254, 0 },
        { 51, 159, 121, 1 },
        { 63, 252, 193, 1 },
        { 207, 124, 230, 0 }, },
      { { 193, 84, 97, 0 },
        { 65, 213, 72, 0 },
        { 67, 21, 65, 1 },
        { 9, 85, 193, 0 }, },
      { { 193, 87, 130, 0 },
        { 97, 19, 105, 0 },
        { 32, 245, 65, 1 },
        { 75, 100, 67, 0 }, },
      { { 193, 199, 55, 1 },
        { 123, 211, 25, 0 },
        { 246, 113, 193, 1 },
        { 76, 101, 239, 0 }, },
      { { 201, 140, 239, 1 },
        { 139, 223, 56, 1 },
        { 251, 152, 201, 1 },
        { 142, 125, 232, 1 }, },
      { { 205, 240, 111, 0 },
        { 194, 215, 94, 1 },
        { 123, 7, 217, 1 },
        { 189, 117, 161, 1 }, },
      { { 201, 95, 103, 1 },
        { 233, 223, 89, 0 },
        { 243, 125, 73, 1 },
        { 77, 125, 203, 1 }, },
      { { 201, 119, 241, 0 },
        { 241, 213, 107, 0 },
        { 71, 247, 73, 1 },
        { 107, 85, 199, 1 }, },
      { { 205, 226, 149, 1 },
        { 250, 81, 62, 0 },
        { 212, 163, 217, 1 },
        { 62, 69, 47, 1 }, },
      { { 198, 191, 7, 1 },
        { 43, 75, 223, 0 },
        { 240, 126, 177, 1 },
        { 125, 233, 106, 0 }, },
      { { 198, 191, 184, 0 },
        { 51, 137, 239, 1 },
        { 14, 254, 177, 1 },
        { 251, 200, 230, 0 }, },
      { { 198, 219, 201, 1 },
        { 106, 77, 237, 1 },
        { 201, 237, 177, 1 },
        { 219, 217, 43, 0 }, },
      { { 202, 49, 136, 0 },
        { 128, 1, 235, 1 },
        { 8, 198, 41, 1 },
        { 235, 192, 0, 1 }, },
      { { 206, 222, 45, 1 },
        { 235, 201, 220, 1 },
        { 218, 61, 185, 1 },
        { 157, 201, 235, 1 }, },
      { { 199, 120, 44, 1 },
        { 72, 153, 222, 1 },
        { 154, 15, 113, 1 },
        { 189, 204, 137, 0 }, },
      { { 203, 171, 75, 1 },
        { 170, 95, 139, 1 },
        { 233, 106, 233, 1 },
        { 232, 253, 42, 1 }, },
      { { 207, 67, 191, 0 },
        { 240, 211, 189, 1 },
        { 126, 225, 121, 1 },
        { 222, 229, 135, 1 }, },
      { { 208, 174, 86, 1 },
        { 63, 15, 26, 0 },
        { 181, 58, 133, 1 },
        { 44, 120, 126, 0 }, },
      { { 208, 115, 51, 0 },
        { 116, 195, 75, 0 },
        { 102, 103, 5, 1 },
        { 105, 97, 151, 0 }, },
      { { 216, 20, 152, 0 },
        { 149, 1, 104, 1 },
        { 12, 148, 13, 1 },
        { 139, 64, 84, 1 }, },
      { { 220, 96, 159, 1 },
        { 220, 67, 62, 1 },
        { 252, 131, 29, 1 },
        { 190, 97, 29, 1 }, },
      { { 213, 117, 88, 0 },
        { 85, 21, 79, 1 },
        { 13, 87, 85, 1 },
        { 249, 84, 85, 0 }, },
      { { 209, 224, 215, 0 },
        { 86, 87, 58, 0 },
        { 117, 131, 197, 1 },
        { 46, 117, 53, 0 }, },
      { { 213, 251, 177, 0 },
        { 118, 217, 111, 0 },
        { 70, 239, 213, 1 },
        { 123, 77, 183, 0 }, },
      { { 213, 218, 116, 1 },
        { 126, 157, 92, 0 },
        { 151, 45, 213, 1 },
        { 29, 92, 191, 0 }, },
      { { 221, 60, 116, 1 },
        { 157, 157, 94, 0 },
        { 151, 30, 93, 1 },
        { 61, 92, 220, 1 }, },
      { { 221, 151, 109, 0 },
        { 167, 213, 93, 1 },
        { 91, 116, 221, 1 },
        { 221, 85, 242, 1 }, },
      { { 217, 27, 49, 0 },
        { 180, 217, 73, 0 },
        { 70, 108, 77, 1 },
        { 73, 77, 150, 1 }, },
      { { 217, 98, 166, 0 },
        { 228, 147, 58, 0 },
        { 50, 163, 77, 1 },
        { 46, 100, 147, 1 }, },
      { { 210, 171, 124, 1 },
        { 62, 141, 155, 1 },
        { 159, 106, 165, 1 },
        { 236, 216, 190, 0 }, },
      { { 210, 197, 236, 0 },
        { 71, 133, 185, 1 },
        { 27, 209, 165, 1 },
        { 206, 208, 241, 0 }, },
      { { 210, 202, 106, 0 },
        { 102, 143, 136, 1 },
        { 43, 41, 165, 1 },
        { 136, 248, 179, 0 }, },
      { { 210, 107, 214, 0 },
        { 116, 15, 187, 0 },
        { 53, 235, 37, 1 },
        { 110, 248, 23, 0 }, },
      { { 222, 155, 52, 0 },
        { 182, 137, 221, 0 },
        { 22, 108, 189, 1 },
        { 93, 200, 182, 1 }, },
      { { 222, 146, 158, 0 },
        { 182, 3, 252, 1 },
        { 60, 164, 189, 1 },
        { 159, 224, 54, 1 }, },
      { { 218, 96, 216, 1 },
        { 220, 5, 170, 1 },
        { 141, 131, 45, 1 },
        { 170, 208, 29, 1 }, },
      { { 215, 57, 178, 1 },
        { 28, 155, 239, 0 },
        { 166, 206, 117, 1 },
        { 123, 236, 156, 0 }, },
      { { 215, 95, 38, 0 },
        { 101, 155, 221, 0 },
        { 50, 125, 117, 1 },
        { 93, 236, 211, 0 }, },
      { { 223, 1, 65, 1 },
        { 140, 85, 141, 0 },
        { 193, 64, 125, 1 },
        { 88, 213, 24, 1 }, },
      { { 223, 121, 15, 1 },
        { 204, 91, 223, 1 },
        { 248, 79, 125, 1 },
        { 253, 237, 25, 1 }, },
      { { 219, 247, 116, 0 },
        { 247, 149, 219, 0 },
        { 23, 119, 237, 1 },
        { 109, 212, 247, 1 }, },
      { { 224, 67, 79, 1 },
        { 104, 103, 25, 1 },
        { 249, 97, 3, 1 },
        { 204, 115, 11, 0 }, },
      { { 224, 198, 227, 0 },
        { 99, 231, 40, 0 },
        { 99, 177, 131, 1 },
        { 10, 115, 227, 0 }, },
      { { 236, 56, 189, 1 },
        { 152, 233, 126, 1 },
        { 222, 142, 27, 1 },
        { 191, 75, 140, 1 }, },
      { { 236, 81, 253, 0 },
        { 208, 229, 125, 1 },
        { 95, 197, 27, 1 },
        { 223, 83, 133, 1 }, },
      { { 229, 141, 36, 0 },
        { 3, 185, 29, 0 },
        { 18, 88, 211, 1 },
        { 92, 78, 224, 0 }, },
      { { 229, 5, 121, 1 },
        { 25, 245, 13, 1 },
        { 207, 80, 83, 1 },
        { 216, 87, 204, 0 }, },
      { { 225, 78, 248, 0 },
        { 113, 189, 40, 1 },
        { 15, 185, 67, 1 },
        { 138, 94, 199, 0 }, },
      { { 229, 87, 220, 1 },
        { 121, 53, 125, 1 },
        { 157, 245, 83, 1 },
        { 223, 86, 79, 0 }, },
      { { 225, 247, 242, 1 },
        { 123, 183, 107, 0 },
        { 167, 247, 195, 1 },
        { 107, 118, 239, 0 }, },
      { { 226, 133, 77, 0 },
        { 3, 101, 153, 1 },
        { 89, 80, 163, 1 },
        { 204, 211, 96, 0 }, },
      { { 226, 24, 26, 0 },
        { 16, 43, 200, 1 },
        { 44, 12, 35, 1 },
        { 137, 234, 4, 0 }, },
      { { 226, 43, 203, 0 },
        { 32, 111, 171, 1 },
        { 105, 234, 35, 1 },
        { 234, 251, 2, 0 }, },
      { { 230, 236, 2, 0 },
        { 67, 43, 142, 0 },
        { 32, 27, 179, 1 },
        { 56, 234, 97, 0 }, },
      { { 230, 98, 129, 0 },
        { 96, 97, 174, 0 },
        { 64, 163, 51, 1 },
        { 58, 195, 3, 0 }, },
      { { 234, 38, 64, 0 },
        { 161, 37, 138, 0 },
        { 1, 50, 43, 1 },
        { 40, 210, 66, 1 }, },
      { { 234, 224, 196, 0 },
        { 194, 37, 186, 0 },
        { 17, 131, 171, 1 },
        { 46, 210, 33, 1 }, },
      { { 234, 114, 148, 1 },
        { 248, 33, 250, 0 },
        { 148, 167, 43, 1 },
        { 47, 194, 15, 1 }, },
      { { 227, 17, 63, 1 },
        { 24, 243, 217, 1 },
        { 254, 68, 99, 1 },
        { 205, 231, 140, 0 }, },
      { { 231, 11, 230, 1 },
        { 40, 191, 189, 0 },
        { 179, 232, 115, 1 },
        { 94, 254, 138, 0 }, },
      { { 227, 100, 241, 1 },
        { 89, 245, 170, 0 },
        { 199, 147, 99, 1 },
        { 42, 215, 205, 0 }, },
      { { 231, 250, 226, 1 },
        { 106, 191, 238, 0 },
        { 163, 175, 243, 1 },
        { 59, 254, 171, 0 }, },
      { { 227, 219, 243, 0 },
        { 114, 255, 233, 0 },
        { 103, 237, 227, 1 },
        { 75, 255, 167, 0 }, },
      { { 239, 135, 98, 0 },
        { 163, 183, 141, 0 },
        { 35, 112, 251, 1 },
        { 88, 246, 226, 1 }, },
      { { 239, 93, 112, 0 },
        { 209, 189, 205, 0 },
        { 7, 93, 123, 1 },
        { 89, 222, 197, 1 }, },
      { { 235, 102, 14, 0 },
        { 225, 51, 154, 1 },
        { 56, 51, 107, 1 },
        { 172, 230, 67, 1 }, },
      { { 239, 74, 60, 0 },
        { 240, 185, 156, 1 },
        { 30, 41, 123, 1 },
        { 156, 206, 135, 1 }, },
      { { 240, 178, 33, 1 },
        { 46, 225, 74, 0 },
        { 194, 38, 135, 1 },
        { 41, 67, 186, 0 }, },
      { { 240, 175, 79, 0 },
        { 39, 111, 27, 1 },
        { 121, 122, 135, 1 },
        { 236, 123, 114, 0 }, },
      { { 244, 159, 60, 1 },
        { 63, 169, 93, 1 },
        { 158, 124, 151, 1 },
        { 221, 74, 254, 0 }, },
      { { 240, 245, 4, 0 },
        { 71, 33, 91, 0 },
        { 16, 87, 135, 1 },
        { 109, 66, 113, 0 }, },
      { { 240, 242, 120, 0 },
        { 118, 165, 74, 1 },
        { 15, 39, 135, 1 },
        { 169, 82, 183, 0 }, },
      { { 248, 52, 99, 0 },
        { 133, 231, 74, 0 },
        { 99, 22, 15, 1 },
        { 41, 115, 208, 1 }, },
      { { 252, 219, 143, 0 },
        { 230, 107, 125, 1 },
        { 120, 237, 159, 1 },
        { 223, 107, 51, 1 }, },
      { { 252, 254, 77, 1 },
        { 239, 109, 94, 1 },
        { 217, 63, 159, 1 },
        { 189, 91, 123, 1 }, },
      { { 253, 176, 69, 1 },
        { 142, 117, 94, 0 },
        { 209, 6, 223, 1 },
        { 61, 87, 56, 1 }, },
      { { 253, 51, 235, 0 },
        { 164, 247, 111, 1 },
        { 107, 230, 95, 1 },
        { 251, 119, 146, 1 }, },
      { { 249, 196, 217, 1 },
        { 223, 117, 40, 1 },
        { 205, 145, 207, 1 },
        { 138, 87, 125, 1 }, },
      { { 242, 35, 145, 1 },
        { 60, 97, 171, 0 },
        { 196, 226, 39, 1 },
        { 106, 195, 30, 0 }, },
      { { 246, 210, 251, 1 },
        { 126, 231, 236, 1 },
        { 239, 165, 183, 1 },
        { 155, 243, 191, 0 }, },
      { { 254, 239, 211, 1 },
        { 255, 111, 175, 0 },
        { 229, 251, 191, 1 },
        { 122, 251, 127, 1 }, },
      { { 243, 176, 58, 1 },
        { 30, 179, 202, 1 },
        { 174, 6, 231, 1 },
        { 169, 230, 188, 0 }, },
      { { 247, 138, 77, 1 },
        { 46, 125, 156, 1 },
        { 217, 40, 247, 1 },
        { 156, 223, 58, 0 }, },
      { { 243, 143, 157, 1 },
        { 63, 121, 185, 1 },
        { 220, 248, 231, 1 },
        { 206, 207, 126, 0 }, },
      { { 247, 242, 39, 0 },
        { 102, 243, 222, 0 },
        { 114, 39, 247, 1 },
        { 61, 231, 179, 0 }, },
      { { 255, 189, 133, 1 },
        { 143, 121, 255, 0 },
        { 208, 222, 255, 1 },
        { 127, 207, 120, 1 }, },
      { { 255, 38, 197, 1 },
        { 173, 117, 190, 0 },
        { 209, 178, 127, 1 },
        { 62, 215, 90, 1 }, },
      { { 251, 224, 97, 0 },
        { 198, 245, 138, 0 },
        { 67, 3, 239, 1 },
        { 40, 215, 177, 1 }, },
      { { 255, 220, 26, 0 },
        { 215, 59, 204, 1 },
        { 44, 29, 255, 1 },
        { 153, 238, 117, 1 }, },
      { { 25, 248, 99, 1 },
        { 206, 222, 66, 0 },
        { 227, 15, 204, 0 },
        { 33, 61, 185, 1 }, },
      { { 169, 93, 31, 1 },
        { 217, 122, 89, 1 },
        { 252, 93, 74, 1 },
        { 205, 47, 77, 1 }, },
      { { 0, 184, 72, 1 },
        { 10, 12, 66, 1 },
        { 137, 14, 128, 0 },
        { 161, 24, 40, 0 }, },
      { { 0, 236, 225, 0 },
        { 67, 204, 34, 0 },
        { 67, 155, 128, 0 },
        { 34, 25, 225, 0 }, },
      { { 8, 97, 102, 0 },
        { 192, 134, 19, 0 },
        { 51, 67, 8, 0 },
        { 100, 48, 129, 1 }, },
      { { 8, 244, 131, 0 },
        { 195, 66, 98, 0 },
        { 96, 151, 136, 0 },
        { 35, 33, 97, 1 }, },
      { { 12, 248, 157, 0 },
        { 210, 72, 118, 1 },
        { 92, 143, 152, 0 },
        { 183, 9, 37, 1 }, },
      { { 8, 192, 62, 1 },
        { 218, 130, 16, 1 },
        { 190, 1, 136, 0 },
        { 132, 32, 173, 1 }, },
      { { 1, 57, 192, 0 },
        { 0, 28, 99, 0 },
        { 1, 206, 64, 0 },
        { 99, 28, 0, 0 }, },
      { { 1, 40, 10, 0 },
        { 0, 26, 2, 1 },
        { 40, 10, 64, 0 },
        { 160, 44, 0, 0 }, },
      { { 1, 190, 179, 1 },
        { 59, 218, 98, 0 },
        { 230, 190, 192, 0 },
        { 35, 45, 238, 0 }, },
      { { 13, 128, 85, 0 },
        { 146, 84, 20, 0 },
        { 85, 0, 216, 0 },
        { 20, 21, 36, 1 }, },
      { { 13, 175, 99, 1 },
        { 171, 222, 7, 0 },
        { 227, 122, 216, 0 },
        { 112, 61, 234, 1 }, },
      { { 6, 181, 236, 0 },
        { 3, 132, 247, 1 },
        { 27, 214, 176, 0 },
        { 247, 144, 224, 0 }, },
      { { 2, 153, 54, 1 },
        { 26, 138, 209, 0 },
        { 182, 76, 160, 0 },
        { 69, 168, 172, 0 }, },
      { { 6, 182, 143, 0 },
        { 35, 66, 246, 1 },
        { 120, 182, 176, 0 },
        { 183, 161, 98, 0 }, },
      { { 6, 125, 64, 1 },
        { 73, 12, 199, 0 },
        { 129, 95, 48, 0 },
        { 113, 152, 73, 0 }, },
      { { 2, 114, 104, 1 },
        { 104, 132, 194, 1 },
        { 139, 39, 32, 0 },
        { 161, 144, 139, 0 }, },
      { { 6, 203, 237, 1 },
        { 106, 204, 181, 1 },
        { 219, 233, 176, 0 },
        { 214, 153, 171, 0 }, },
      { { 14, 15, 61, 0 },
        { 177, 200, 149, 1 },
        { 94, 120, 56, 0 },
        { 212, 137, 198, 1 }, },
      { { 14, 213, 203, 0 },
        { 195, 70, 229, 1 },
        { 105, 213, 184, 0 },
        { 211, 177, 97, 1 }, },
      { { 3, 125, 39, 1 },
        { 73, 218, 211, 0 },
        { 242, 95, 96, 0 },
        { 101, 173, 201, 0 }, },
      { { 3, 233, 143, 0 },
        { 66, 90, 179, 1 },
        { 120, 203, 224, 0 },
        { 230, 173, 33, 0 }, },
      { { 7, 250, 159, 1 },
        { 122, 90, 246, 1 },
        { 252, 175, 240, 0 },
        { 183, 173, 47, 0 }, },
      { { 11, 76, 16, 0 },
        { 209, 24, 128, 0 },
        { 4, 25, 104, 0 },
        { 0, 140, 69, 1 }, },
      { { 16, 185, 87, 1 },
        { 30, 78, 83, 0 },
        { 245, 78, 132, 0 },
        { 101, 57, 60, 0 }, },
      { { 16, 22, 41, 0 },
        { 37, 192, 64, 1 },
        { 74, 52, 4, 0 },
        { 129, 1, 210, 0 }, },
      { { 16, 98, 139, 1 },
        { 108, 66, 34, 1 },
        { 232, 163, 4, 0 },
        { 162, 33, 27, 0 }, },
      { { 24, 157, 182, 0 },
        { 151, 138, 113, 0 },
        { 54, 220, 140, 0 },
        { 71, 40, 244, 1 }, },
      { { 24, 109, 0, 1 },
        { 205, 8, 3, 0 },
        { 128, 91, 12, 0 },
        { 96, 8, 89, 1 }, },
      { { 28, 118, 42, 0 },
        { 229, 130, 70, 1 },
        { 42, 55, 28, 0 },
        { 177, 32, 211, 1 }, },
      { { 24, 95, 228, 1 },
        { 237, 140, 113, 0 },
        { 147, 253, 12, 0 },
        { 71, 24, 219, 1 }, },
      { { 28, 66, 22, 0 },
        { 244, 2, 20, 0 },
        { 52, 33, 28, 0 },
        { 20, 32, 23, 1 }, },
      { { 17, 60, 169, 0 },
        { 5, 216, 98, 1 },
        { 74, 158, 68, 0 },
        { 163, 13, 208, 0 }, },
      { { 17, 152, 57, 1 },
        { 30, 216, 64, 1 },
        { 206, 12, 196, 0 },
        { 129, 13, 188, 0 }, },
      { { 21, 58, 99, 0 },
        { 36, 222, 70, 0 },
        { 99, 46, 84, 0 },
        { 49, 61, 146, 0 }, },
      { { 21, 18, 117, 1 },
        { 60, 212, 84, 0 },
        { 215, 36, 84, 0 },
        { 21, 21, 158, 0 }, },
      { { 21, 222, 162, 0 },
        { 103, 154, 100, 0 },
        { 34, 189, 212, 0 },
        { 19, 44, 243, 0 }, },
      { { 21, 106, 24, 1 },
        { 124, 24, 6, 1 },
        { 140, 43, 84, 0 },
        { 176, 12, 31, 0 }, },
      { { 29, 209, 40, 0 },
        { 198, 144, 69, 1 },
        { 10, 69, 220, 0 },
        { 209, 4, 177, 1 }, },
      { { 29, 113, 148, 1 },
        { 220, 16, 119, 0 },
        { 148, 199, 92, 0 },
        { 119, 4, 29, 1 }, },
      { { 18, 57, 139, 1 },
        { 12, 74, 227, 1 },
        { 232, 206, 36, 0 },
        { 227, 169, 24, 0 }, },
      { { 18, 5, 152, 0 },
        { 21, 0, 161, 1 },
        { 12, 208, 36, 0 },
        { 194, 128, 84, 0 }, },
      { { 22, 2, 152, 1 },
        { 60, 0, 164, 1 },
        { 140, 160, 52, 0 },
        { 146, 128, 30, 0 }, },
      { { 26, 52, 127, 1 },
        { 157, 198, 210, 1 },
        { 255, 22, 44, 0 },
        { 165, 177, 220, 1 }, },
      { { 30, 220, 239, 1 },
        { 207, 206, 244, 1 },
        { 251, 157, 188, 0 },
        { 151, 185, 249, 1 }, },
      { { 30, 112, 115, 0 },
        { 212, 198, 198, 0 },
        { 103, 7, 60, 0 },
        { 49, 177, 149, 1 }, },
      { { 26, 67, 149, 0 },
        { 244, 64, 177, 0 },
        { 84, 225, 44, 0 },
        { 70, 129, 23, 1 }, },
      { { 26, 126, 27, 1 },
        { 253, 74, 194, 1 },
        { 236, 63, 44, 0 },
        { 161, 169, 95, 1 }, },
      { { 23, 173, 194, 0 },
        { 7, 30, 167, 0 },
        { 33, 218, 244, 0 },
        { 114, 188, 112, 0 }, },
      { { 19, 25, 222, 1 },
        { 28, 30, 241, 1 },
        { 189, 204, 100, 0 },
        { 199, 188, 28, 0 }, },
      { { 27, 168, 147, 1 },
        { 158, 90, 162, 0 },
        { 228, 138, 236, 0 },
        { 34, 173, 60, 1 }, },
      { { 27, 147, 73, 1 },
        { 174, 84, 193, 1 },
        { 201, 100, 236, 0 },
        { 193, 149, 58, 1 }, },
      { { 27, 208, 27, 0 },
        { 214, 82, 192, 1 },
        { 108, 5, 236, 0 },
        { 129, 165, 53, 1 }, },
      { { 31, 66, 219, 1 },
        { 252, 86, 164, 1 },
        { 237, 161, 124, 0 },
        { 146, 181, 31, 1 }, },
      { { 32, 185, 170, 0 },
        { 2, 170, 99, 1 },
        { 42, 206, 130, 0 },
        { 227, 42, 160, 0 }, },
      { { 36, 196, 186, 0 },
        { 83, 162, 36, 1 },
        { 46, 145, 146, 0 },
        { 146, 34, 229, 0 }, },
      { { 40, 173, 5, 0 },
        { 131, 104, 19, 0 },
        { 80, 90, 138, 0 },
        { 100, 11, 96, 1 }, },
      { { 44, 35, 100, 1 },
        { 168, 164, 23, 0 },
        { 147, 98, 26, 0 },
        { 116, 18, 138, 1 }, },
      { { 44, 14, 154, 1 },
        { 185, 42, 36, 1 },
        { 172, 184, 26, 0 },
        { 146, 42, 78, 1 }, },
      { { 44, 81, 3, 1 },
        { 200, 98, 69, 0 },
        { 224, 69, 26, 0 },
        { 81, 35, 9, 1 }, },
      { { 37, 197, 207, 1 },
        { 75, 118, 53, 1 },
        { 249, 209, 210, 0 },
        { 214, 55, 105, 0 }, },
      { { 37, 200, 211, 1 },
        { 90, 126, 36, 0 },
        { 229, 137, 210, 0 },
        { 18, 63, 45, 0 }, },
      { { 33, 119, 232, 1 },
        { 105, 180, 99, 1 },
        { 139, 247, 66, 0 },
        { 227, 22, 203, 0 }, },
      { { 34, 141, 218, 1 },
        { 27, 46, 161, 1 },
        { 173, 216, 162, 0 },
        { 194, 186, 108, 0 }, },
      { { 34, 10, 238, 0 },
        { 32, 174, 176, 1 },
        { 59, 168, 34, 0 },
        { 134, 186, 130, 0 }, },
      { { 46, 134, 44, 0 },
        { 163, 160, 148, 1 },
        { 26, 48, 186, 0 },
        { 148, 130, 226, 1 }, },
      { { 42, 182, 47, 1 },
        { 171, 226, 210, 1 },
        { 250, 54, 170, 0 },
        { 165, 163, 234, 1 }, },
      { { 39, 60, 45, 0 },
        { 1, 248, 214, 1 },
        { 90, 30, 114, 0 },
        { 181, 143, 192, 0 }, },
      { { 39, 157, 74, 0 },
        { 3, 62, 197, 1 },
        { 41, 92, 242, 0 },
        { 209, 190, 96, 0 }, },
      { { 39, 155, 7, 1 },
        { 42, 122, 213, 0 },
        { 240, 108, 242, 0 },
        { 85, 175, 42, 0 }, },
      { { 35, 87, 132, 0 },
        { 97, 48, 241, 0 },
        { 16, 245, 98, 0 },
        { 71, 134, 67, 0 }, },
      { { 35, 78, 67, 1 },
        { 105, 126, 128, 0 },
        { 225, 57, 98, 0 },
        { 0, 191, 75, 0 }, },
      { { 47, 171, 185, 1 },
        { 186, 248, 167, 1 },
        { 206, 234, 250, 0 },
        { 242, 143, 174, 1 }, },
      { { 48, 176, 46, 1 },
        { 14, 162, 82, 1 },
        { 186, 6, 134, 0 },
        { 165, 34, 184, 0 }, },
      { { 48, 40, 122, 0 },
        { 20, 174, 2, 1 },
        { 47, 10, 6, 0 },
        { 160, 58, 148, 0 }, },
      { { 52, 253, 160, 1 },
        { 79, 168, 103, 0 },
        { 130, 223, 150, 0 },
        { 115, 10, 249, 0 }, },
      { { 60, 214, 137, 0 },
        { 231, 96, 100, 1 },
        { 72, 181, 158, 0 },
        { 147, 3, 115, 1 }, },
      { { 56, 126, 182, 0 },
        { 245, 170, 114, 0 },
        { 54, 191, 14, 0 },
        { 39, 42, 215, 1 }, },
      { { 49, 0, 109, 0 },
        { 4, 244, 16, 1 },
        { 91, 0, 70, 0 },
        { 132, 23, 144, 0 }, },
      { { 49, 23, 219, 1 },
        { 61, 118, 97, 1 },
        { 237, 244, 70, 0 },
        { 195, 55, 94, 0 }, },
      { { 49, 167, 119, 1 },
        { 63, 246, 19, 0 },
        { 247, 114, 198, 0 },
        { 100, 55, 254, 0 }, },
      { { 61, 128, 10, 1 },
        { 142, 50, 4, 1 },
        { 168, 0, 222, 0 },
        { 144, 38, 56, 1 }, },
      { { 61, 226, 157, 0 },
        { 246, 112, 54, 1 },
        { 92, 163, 222, 0 },
        { 182, 7, 55, 1 }, },
      { { 54, 106, 119, 1 },
        { 124, 238, 150, 0 },
        { 247, 43, 54, 0 },
        { 52, 187, 159, 0 }, },
      { { 54, 199, 190, 1 },
        { 127, 162, 181, 1 },
        { 190, 241, 182, 0 },
        { 214, 162, 255, 0 }, },
      { { 62, 187, 41, 0 },
        { 166, 232, 199, 1 },
        { 74, 110, 190, 0 },
        { 241, 139, 178, 1 }, },
      { { 62, 104, 154, 0 },
        { 212, 42, 166, 1 },
        { 44, 139, 62, 0 },
        { 178, 170, 21, 1 }, },
      { { 62, 95, 2, 1 },
        { 237, 42, 197, 0 },
        { 160, 125, 62, 0 },
        { 81, 170, 91, 1 }, },
      { { 58, 86, 206, 1 },
        { 237, 38, 240, 1 },
        { 185, 181, 46, 0 },
        { 135, 178, 91, 1 }, },
      { { 62, 95, 252, 0 },
        { 245, 172, 245, 1 },
        { 31, 253, 62, 0 },
        { 215, 154, 215, 1 }, },
      { { 51, 185, 172, 0 },
        { 6, 184, 243, 1 },
        { 26, 206, 230, 0 },
        { 231, 142, 176, 0 }, },
      { { 51, 84, 174, 0 },
        { 69, 178, 240, 1 },
        { 58, 149, 102, 0 },
        { 135, 166, 209, 0 }, },
      { { 63, 25, 160, 0 },
        { 132, 184, 229, 0 },
        { 2, 204, 126, 0 },
        { 83, 142, 144, 1 }, },
      { { 59, 173, 97, 1 },
        { 143, 252, 131, 0 },
        { 195, 90, 238, 0 },
        { 96, 159, 248, 1 }, },
      { { 59, 112, 47, 1 },
        { 204, 242, 210, 1 },
        { 250, 7, 110, 0 },
        { 165, 167, 153, 1 }, },
      { { 59, 235, 58, 1 },
        { 254, 186, 131, 1 },
        { 174, 107, 238, 0 },
        { 224, 174, 191, 1 }, },
      { { 64, 83, 90, 0 },
        { 112, 7, 65, 1 },
        { 45, 101, 1, 0 },
        { 193, 112, 7, 0 }, },
      { { 65, 152, 22, 0 },
        { 18, 27, 80, 0 },
        { 52, 12, 193, 0 },
        { 5, 108, 36, 0 }, },
      { { 65, 143, 177, 0 },
        { 51, 217, 33, 0 },
        { 70, 248, 193, 0 },
        { 66, 77, 230, 0 }, },
      { { 69, 217, 33, 1 },
        { 74, 217, 69, 0 },
        { 194, 77, 209, 0 },
        { 81, 77, 169, 0 }, },
      { { 69, 235, 1, 0 },
        { 98, 89, 7, 0 },
        { 64, 107, 209, 0 },
        { 112, 77, 35, 0 }, },
      { { 73, 157, 82, 0 },
        { 147, 31, 65, 0 },
        { 37, 92, 201, 0 },
        { 65, 124, 100, 1 }, },
      { { 66, 56, 79, 1 },
        { 8, 79, 210, 1 },
        { 249, 14, 33, 0 },
        { 165, 249, 8, 0 }, },
      { { 74, 166, 163, 1 },
        { 171, 195, 162, 0 },
        { 226, 178, 169, 0 },
        { 34, 225, 234, 1 }, },
      { { 74, 197, 42, 1 },
        { 203, 131, 129, 1 },
        { 170, 81, 169, 0 },
        { 192, 224, 233, 1 }, },
      { { 74, 200, 115, 0 },
        { 210, 207, 128, 0 },
        { 103, 9, 169, 0 },
        { 0, 249, 165, 1 }, },
      { { 71, 180, 198, 1 },
        { 11, 23, 246, 0 },
        { 177, 150, 241, 0 },
        { 55, 244, 104, 0 }, },
      { { 67, 147, 93, 0 },
        { 50, 85, 209, 1 },
        { 93, 100, 225, 0 },
        { 197, 213, 38, 0 }, },
      { { 67, 120, 117, 0 },
        { 80, 221, 210, 0 },
        { 87, 15, 97, 0 },
        { 37, 221, 133, 0 }, },
      { { 79, 58, 175, 1 },
        { 168, 219, 246, 1 },
        { 250, 174, 121, 0 },
        { 183, 237, 138, 1 }, },
      { { 79, 135, 68, 1 },
        { 171, 21, 149, 0 },
        { 145, 112, 249, 0 },
        { 84, 212, 106, 1 }, },
      { { 79, 135, 223, 0 },
        { 179, 87, 181, 1 },
        { 125, 240, 249, 0 },
        { 214, 245, 102, 1 }, },
      { { 79, 196, 222, 1 },
        { 219, 23, 180, 1 },
        { 189, 145, 249, 0 },
        { 150, 244, 109, 1 }, },
      { { 84, 31, 71, 0 },
        { 37, 79, 85, 0 },
        { 113, 124, 21, 0 },
        { 85, 121, 82, 0 }, },
      { { 80, 31, 148, 0 },
        { 53, 9, 113, 0 },
        { 20, 252, 5, 0 },
        { 71, 72, 86, 0 }, },
      { { 92, 145, 67, 0 },
        { 134, 71, 69, 0 },
        { 97, 68, 157, 0 },
        { 81, 113, 48, 1 }, },
      { { 88, 189, 239, 1 },
        { 143, 207, 115, 1 },
        { 251, 222, 141, 0 },
        { 231, 121, 248, 1 }, },
      { { 92, 221, 7, 1 },
        { 207, 75, 85, 0 },
        { 240, 93, 157, 0 },
        { 85, 105, 121, 1 }, },
      { { 92, 102, 88, 1 },
        { 253, 5, 6, 1 },
        { 141, 51, 29, 0 },
        { 176, 80, 95, 1 }, },
      { { 92, 219, 50, 1 },
        { 254, 139, 69, 0 },
        { 166, 109, 157, 0 },
        { 81, 104, 191, 1 }, },
      { { 85, 69, 212, 0 },
        { 85, 21, 53, 0 },
        { 21, 209, 85, 0 },
        { 86, 84, 85, 0 }, },
      { { 81, 68, 62, 0 },
        { 85, 147, 16, 1 },
        { 62, 17, 69, 0 },
        { 132, 100, 213, 0 }, },
      { { 81, 231, 230, 0 },
        { 103, 151, 51, 0 },
        { 51, 243, 197, 0 },
        { 102, 116, 243, 0 }, },
      { { 89, 11, 167, 0 },
        { 164, 219, 49, 0 },
        { 114, 232, 77, 0 },
        { 70, 109, 146, 1 }, },
      { { 93, 186, 56, 1 },
        { 190, 153, 70, 1 },
        { 142, 46, 221, 0 },
        { 177, 76, 190, 1 }, },
      { { 93, 166, 55, 1 },
        { 191, 211, 22, 0 },
        { 246, 50, 221, 0 },
        { 52, 101, 254, 1 }, },
      { { 89, 249, 149, 0 },
        { 214, 89, 115, 0 },
        { 84, 207, 205, 0 },
        { 103, 77, 53, 1 }, },
      { { 93, 255, 236, 0 },
        { 231, 157, 119, 1 },
        { 27, 255, 221, 0 },
        { 247, 92, 243, 1 }, },
      { { 82, 157, 58, 0 },
        { 23, 139, 193, 1 },
        { 46, 92, 165, 0 },
        { 193, 232, 244, 0 }, },
      { { 86, 58, 151, 0 },
        { 52, 75, 246, 0 },
        { 116, 174, 53, 0 },
        { 55, 233, 22, 0 }, },
      { { 82, 99, 34, 0 },
        { 100, 131, 131, 0 },
        { 34, 99, 37, 0 },
        { 96, 224, 147, 0 }, },
      { { 82, 203, 49, 1 },
        { 126, 201, 129, 0 },
        { 198, 105, 165, 0 },
        { 64, 201, 191, 0 }, },
      { { 90, 139, 204, 1 },
        { 174, 13, 177, 1 },
        { 153, 232, 173, 0 },
        { 198, 216, 58, 1 }, },
      { { 83, 33, 106, 0 },
        { 4, 151, 131, 1 },
        { 43, 66, 101, 0 },
        { 224, 244, 144, 0 }, },
      { { 87, 245, 17, 0 },
        { 87, 81, 199, 0 },
        { 68, 87, 245, 0 },
        { 113, 197, 117, 0 }, },
      { { 95, 220, 33, 0 },
        { 199, 217, 196, 0 },
        { 66, 29, 253, 0 },
        { 17, 205, 241, 1 }, },
      { { 96, 140, 28, 0 },
        { 19, 41, 16, 1 },
        { 28, 24, 131, 0 },
        { 132, 74, 100, 0 }, },
      { { 96, 162, 213, 1 },
        { 58, 101, 50, 0 },
        { 213, 162, 131, 0 },
        { 38, 83, 46, 0 }, },
      { { 96, 222, 5, 1 },
        { 107, 105, 80, 0 },
        { 208, 61, 131, 0 },
        { 5, 75, 107, 0 }, },
      { { 108, 76, 110, 0 },
        { 193, 175, 20, 1 },
        { 59, 25, 27, 0 },
        { 148, 122, 193, 1 }, },
      { { 104, 82, 12, 0 },
        { 224, 33, 80, 1 },
        { 24, 37, 11, 0 },
        { 133, 66, 3, 1 }, },
      { { 101, 59, 167, 0 },
        { 32, 251, 119, 0 },
        { 114, 238, 83, 0 },
        { 119, 111, 130, 0 }, },
      { { 97, 170, 234, 0 },
        { 34, 191, 34, 1 },
        { 43, 170, 195, 0 },
        { 162, 126, 162, 0 }, },
      { { 101, 113, 110, 1 },
        { 72, 183, 87, 1 },
        { 187, 71, 83, 0 },
        { 245, 118, 137, 0 }, },
      { { 101, 124, 89, 1 },
        { 89, 125, 70, 1 },
        { 205, 31, 83, 0 },
        { 177, 95, 77, 0 }, },
      { { 105, 131, 46, 1 },
        { 170, 179, 17, 1 },
        { 186, 96, 203, 0 },
        { 196, 102, 170, 1 }, },
      { { 109, 196, 12, 0 },
        { 195, 49, 20, 1 },
        { 24, 17, 219, 0 },
        { 148, 70, 97, 1 }, },
      { { 109, 210, 20, 1 },
        { 250, 49, 84, 0 },
        { 148, 37, 219, 0 },
        { 21, 70, 47, 1 }, },
      { { 98, 150, 165, 1 },
        { 43, 225, 240, 0 },
        { 210, 180, 163, 0 },
        { 7, 195, 234, 0 }, },
      { { 98, 117, 38, 1 },
        { 73, 163, 211, 0 },
        { 178, 87, 35, 0 },
        { 101, 226, 201, 0 }, },
      { { 98, 100, 214, 1 },
        { 89, 39, 178, 0 },
        { 181, 147, 35, 0 },
        { 38, 242, 77, 0 }, },
      { { 98, 91, 220, 1 },
        { 120, 45, 241, 1 },
        { 157, 237, 35, 0 },
        { 199, 218, 15, 0 }, },
      { { 110, 51, 2, 1 },
        { 168, 35, 199, 0 },
        { 160, 102, 59, 0 },
        { 113, 226, 10, 1 }, },
      { { 110, 90, 137, 0 },
        { 224, 105, 228, 1 },
        { 72, 173, 59, 0 },
        { 147, 203, 3, 1 }, },
      { { 99, 209, 212, 0 },
        { 82, 53, 241, 0 },
        { 21, 197, 227, 0 },
        { 71, 214, 37, 0 }, },
      { { 99, 75, 129, 1 },
        { 104, 121, 161, 0 },
        { 192, 233, 99, 0 },
        { 66, 207, 11, 0 }, },
      { { 107, 56, 145, 1 },
        { 152, 121, 226, 0 },
        { 196, 142, 107, 0 },
        { 35, 207, 12, 1 }, },
      { { 107, 122, 42, 0 },
        { 224, 187, 194, 1 },
        { 42, 47, 107, 0 },
        { 161, 238, 131, 1 }, },
      { { 116, 56, 51, 0 },
        { 20, 235, 70, 0 },
        { 102, 14, 23, 0 },
        { 49, 107, 148, 0 }, },
      { { 112, 6, 44, 0 },
        { 37, 161, 16, 1 },
        { 26, 48, 7, 0 },
        { 132, 66, 210, 0 }, },
      { { 116, 170, 141, 1 },
        { 46, 105, 54, 1 },
        { 216, 170, 151, 0 },
        { 182, 75, 58, 0 }, },
      { { 116, 76, 143, 0 },
        { 69, 107, 52, 1 },
        { 120, 153, 23, 0 },
        { 150, 107, 81, 0 }, },
      { { 124, 183, 167, 0 },
        { 167, 227, 119, 0 },
        { 114, 246, 159, 0 },
        { 119, 99, 242, 1 }, },
      { { 120, 3, 22, 1 },
        { 188, 35, 17, 0 },
        { 180, 96, 15, 0 },
        { 68, 98, 30, 1 }, },
      { { 124, 199, 198, 1 },
        { 239, 39, 53, 0 },
        { 177, 241, 159, 0 },
        { 86, 114, 123, 1 }, },
      { { 117, 182, 4, 1 },
        { 47, 49, 86, 0 },
        { 144, 54, 215, 0 },
        { 53, 70, 122, 0 }, },
      { { 113, 254, 101, 0 },
        { 103, 253, 82, 0 },
        { 83, 63, 199, 0 },
        { 37, 95, 243, 0 }, },
      { { 113, 79, 154, 1 },
        { 125, 59, 33, 1 },
        { 172, 249, 71, 0 },
        { 194, 110, 95, 0 }, },
      { { 121, 32, 119, 0 },
        { 148, 247, 18, 0 },
        { 119, 2, 79, 0 },
        { 36, 119, 148, 1 }, },
      { { 125, 121, 205, 0 },
        { 196, 125, 119, 1 },
        { 89, 207, 95, 0 },
        { 247, 95, 17, 1 }, },
      { { 125, 67, 92, 0 },
        { 244, 53, 21, 1 },
        { 29, 97, 95, 0 },
        { 212, 86, 23, 1 }, },
      { { 125, 127, 59, 0 },
        { 245, 251, 71, 1 },
        { 110, 127, 95, 0 },
        { 241, 111, 215, 1 }, },
      { { 118, 85, 8, 0 },
        { 69, 33, 197, 1 },
        { 8, 85, 55, 0 },
        { 209, 194, 81, 0 }, },
      { { 122, 152, 199, 0 },
        { 134, 111, 240, 0 },
        { 113, 140, 175, 0 },
        { 7, 251, 48, 1 }, },
      { { 126, 19, 192, 0 },
        { 164, 37, 229, 0 },
        { 1, 228, 63, 0 },
        { 83, 210, 18, 1 }, },
      { { 126, 94, 89, 1 },
        { 253, 109, 196, 1 },
        { 205, 61, 63, 0 },
        { 145, 219, 95, 1 }, },
      { { 115, 36, 132, 0 },
        { 5, 49, 178, 0 },
        { 16, 146, 103, 0 },
        { 38, 198, 80, 0 }, },
      { { 115, 46, 39, 1 },
        { 45, 251, 146, 0 },
        { 242, 58, 103, 0 },
        { 36, 239, 218, 0 }, },
      { { 115, 139, 84, 1 },
        { 62, 61, 145, 0 },
        { 149, 104, 231, 0 },
        { 68, 222, 62, 0 }, },
      { { 132, 4, 34, 0 },
        { 1, 130, 12, 0 },
        { 34, 16, 16, 1 },
        { 24, 32, 192, 0 }, },
      { { 128, 232, 46, 0 },
        { 66, 138, 26, 1 },
        { 58, 11, 128, 1 },
        { 172, 40, 161, 0 }, },
      { { 128, 237, 48, 0 },
        { 83, 136, 11, 0 },
        { 6, 91, 128, 1 },
        { 104, 8, 229, 0 }, },
      { { 140, 53, 96, 0 },
        { 129, 132, 79, 0 },
        { 3, 86, 24, 1 },
        { 121, 16, 192, 1 }, },
      { { 140, 120, 240, 1 },
        { 216, 140, 110, 0 },
        { 135, 143, 24, 1 },
        { 59, 24, 141, 1 }, },
      { { 136, 194, 128, 1 },
        { 234, 0, 40, 0 },
        { 128, 161, 136, 1 },
        { 10, 0, 43, 1 }, },
      { { 129, 26, 100, 1 },
        { 40, 156, 88, 0 },
        { 147, 44, 64, 1 },
        { 13, 28, 138, 0 }, },
      { { 129, 38, 163, 0 },
        { 33, 210, 42, 0 },
        { 98, 178, 64, 1 },
        { 42, 37, 194, 0 }, },
      { { 133, 154, 140, 1 },
        { 42, 24, 124, 1 },
        { 152, 172, 208, 1 },
        { 159, 12, 42, 0 }, },
      { { 137, 19, 23, 1 },
        { 184, 82, 89, 0 },
        { 244, 100, 72, 1 },
        { 77, 37, 14, 1 }, },
      { { 130, 9, 37, 0 },
        { 0, 200, 153, 0 },
        { 82, 72, 32, 1 },
        { 76, 137, 128, 0 }, },
      { { 130, 183, 201, 1 },
        { 43, 68, 235, 1 },
        { 201, 246, 160, 1 },
        { 235, 145, 106, 0 }, },
      { { 142, 185, 191, 1 },
        { 154, 202, 255, 1 },
        { 254, 206, 184, 1 },
        { 255, 169, 172, 1 }, },
      { { 138, 159, 236, 0 },
        { 163, 140, 249, 1 },
        { 27, 252, 168, 1 },
        { 207, 152, 226, 1 }, },
      { { 142, 228, 226, 0 },
        { 195, 134, 174, 0 },
        { 35, 147, 184, 1 },
        { 58, 176, 225, 1 }, },
      { { 135, 32, 232, 0 },
        { 0, 148, 174, 1 },
        { 11, 130, 112, 1 },
        { 186, 148, 128, 0 }, },
      { { 135, 205, 96, 1 },
        { 75, 156, 141, 0 },
        { 131, 89, 240, 1 },
        { 88, 156, 233, 0 }, },
      { { 135, 71, 172, 1 },
        { 105, 144, 189, 1 },
        { 154, 241, 112, 1 },
        { 222, 132, 203, 0 }, },
      { { 139, 10, 91, 0 },
        { 176, 94, 136, 1 },
        { 109, 40, 104, 1 },
        { 136, 189, 6, 1 }, },
      { { 139, 92, 190, 1 },
        { 217, 154, 248, 1 },
        { 190, 157, 104, 1 },
        { 143, 172, 205, 1 }, },
      { { 143, 213, 180, 0 },
        { 211, 144, 253, 0 },
        { 22, 213, 248, 1 },
        { 95, 132, 229, 1 }, },
      { { 139, 118, 41, 0 },
        { 225, 208, 202, 1 },
        { 74, 55, 104, 1 },
        { 169, 133, 195, 1 }, },
      { { 148, 51, 175, 0 },
        { 36, 194, 127, 1 },
        { 122, 230, 20, 1 },
        { 255, 33, 146, 0 }, },
      { { 144, 85, 72, 1 },
        { 77, 4, 73, 1 },
        { 137, 85, 4, 1 },
        { 201, 16, 89, 0 }, },
      { { 156, 62, 39, 0 },
        { 165, 202, 94, 0 },
        { 114, 62, 28, 1 },
        { 61, 41, 210, 1 }, },
      { { 152, 151, 159, 0 },
        { 183, 66, 121, 1 },
        { 124, 244, 140, 1 },
        { 207, 33, 118, 1 }, },
      { { 152, 88, 144, 1 },
        { 220, 8, 104, 0 },
        { 132, 141, 12, 1 },
        { 11, 8, 29, 1 }, },
      { { 149, 182, 31, 0 },
        { 55, 82, 94, 1 },
        { 124, 54, 212, 1 },
        { 189, 37, 118, 0 }, },
      { { 145, 64, 55, 0 },
        { 84, 210, 24, 0 },
        { 118, 1, 68, 1 },
        { 12, 37, 149, 0 }, },
      { { 157, 179, 128, 0 },
        { 166, 16, 111, 0 },
        { 0, 230, 220, 1 },
        { 123, 4, 50, 1 }, },
      { { 153, 65, 137, 1 },
        { 204, 80, 41, 1 },
        { 200, 193, 76, 1 },
        { 202, 5, 25, 1 }, },
      { { 146, 173, 38, 0 },
        { 7, 138, 155, 0 },
        { 50, 90, 164, 1 },
        { 108, 168, 240, 0 }, },
      { { 146, 101, 228, 1 },
        { 77, 132, 187, 0 },
        { 147, 211, 36, 1 },
        { 110, 144, 217, 0 }, },
      { { 146, 111, 141, 1 },
        { 109, 72, 187, 1 },
        { 216, 251, 36, 1 },
        { 238, 137, 91, 0 }, },
      { { 150, 94, 153, 0 },
        { 117, 72, 236, 1 },
        { 76, 189, 52, 1 },
        { 155, 137, 87, 0 }, },
      { { 154, 11, 77, 0 },
        { 164, 76, 153, 1 },
        { 89, 104, 44, 1 },
        { 204, 153, 18, 1 }, },
      { { 154, 221, 17, 0 },
        { 215, 72, 201, 0 },
        { 68, 93, 172, 1 },
        { 73, 137, 117, 1 }, },
      { { 147, 246, 156, 1 },
        { 127, 16, 250, 1 },
        { 156, 183, 228, 1 },
        { 175, 132, 127, 0 }, },
      { { 159, 52, 189, 1 },
        { 157, 208, 254, 1 },
        { 222, 150, 124, 1 },
        { 191, 133, 220, 1 }, },
      { { 159, 80, 9, 0 },
        { 196, 80, 204, 1 },
        { 72, 5, 124, 1 },
        { 153, 133, 17, 1 }, },
      { { 160, 153, 27, 1 },
        { 26, 106, 73, 1 },
        { 236, 76, 130, 1 },
        { 201, 43, 44, 0 }, },
      { { 164, 15, 234, 0 },
        { 33, 174, 45, 1 },
        { 43, 248, 18, 1 },
        { 218, 58, 194, 0 }, },
      { { 160, 15, 83, 1 },
        { 57, 110, 9, 0 },
        { 229, 120, 2, 1 },
        { 72, 59, 78, 0 }, },
      { { 168, 2, 105, 1 },
        { 168, 228, 8, 1 },
        { 203, 32, 10, 1 },
        { 136, 19, 138, 1 }, },
      { { 172, 27, 205, 1 },
        { 168, 108, 125, 1 },
        { 217, 236, 26, 1 },
        { 223, 27, 10, 1 }, },
      { { 172, 135, 77, 0 },
        { 163, 100, 29, 1 },
        { 89, 112, 154, 1 },
        { 220, 19, 98, 1 }, },
      { { 172, 118, 200, 0 },
        { 225, 36, 110, 1 },
        { 9, 183, 26, 1 },
        { 187, 18, 67, 1 }, },
      { { 165, 68, 167, 0 },
        { 65, 242, 60, 0 },
        { 114, 145, 82, 1 },
        { 30, 39, 193, 0 }, },
      { { 161, 244, 92, 0 },
        { 83, 52, 90, 1 },
        { 29, 23, 194, 1 },
        { 173, 22, 101, 0 }, },
      { { 169, 157, 169, 0 },
        { 131, 248, 105, 1 },
        { 74, 220, 202, 1 },
        { 203, 15, 224, 1 }, },
      { { 169, 135, 255, 0 },
        { 179, 246, 57, 1 },
        { 127, 240, 202, 1 },
        { 206, 55, 230, 1 }, },
      { { 169, 71, 98, 1 },
        { 233, 182, 9, 0 },
        { 163, 113, 74, 1 },
        { 72, 54, 203, 1 }, },
      { { 166, 129, 114, 1 },
        { 26, 166, 141, 0 },
        { 167, 64, 178, 1 },
        { 88, 178, 172, 0 }, },
      { { 166, 249, 172, 1 },
        { 74, 168, 255, 1 },
        { 154, 207, 178, 1 },
        { 255, 138, 169, 0 }, },
      { { 162, 196, 38, 0 },
        { 67, 162, 152, 0 },
        { 50, 17, 162, 1 },
        { 12, 162, 225, 0 }, },
      { { 170, 53, 101, 1 },
        { 137, 228, 219, 0 },
        { 211, 86, 42, 1 },
        { 109, 147, 200, 1 }, },
      { { 170, 168, 102, 0 },
        { 130, 174, 154, 0 },
        { 51, 10, 170, 1 },
        { 44, 186, 160, 1 }, },
      { { 170, 200, 143, 0 },
        { 194, 106, 184, 1 },
        { 120, 137, 170, 1 },
        { 142, 171, 33, 1 }, },
      { { 167, 110, 148, 1 },
        { 121, 56, 190, 0 },
        { 148, 187, 114, 1 },
        { 62, 142, 79, 0 }, },
      { { 175, 4, 36, 1 },
        { 137, 176, 156, 0 },
        { 146, 16, 122, 1 },
        { 28, 134, 200, 1 }, },
      { { 176, 65, 44, 0 },
        { 68, 160, 25, 1 },
        { 26, 65, 6, 1 },
        { 204, 2, 145, 0 }, },
      { { 176, 208, 227, 0 },
        { 70, 230, 104, 0 },
        { 99, 133, 134, 1 },
        { 11, 51, 177, 0 }, },
      { { 176, 237, 129, 1 },
        { 79, 104, 43, 0 },
        { 192, 219, 134, 1 },
        { 106, 11, 121, 0 }, },
      { { 180, 231, 236, 0 },
        { 103, 164, 63, 1 },
        { 27, 243, 150, 1 },
        { 254, 18, 243, 0 }, },
      { { 184, 160, 236, 1 },
        { 142, 164, 58, 1 },
        { 155, 130, 142, 1 },
        { 174, 18, 184, 1 }, },
      { { 184, 188, 60, 1 },
        { 159, 168, 90, 1 },
        { 158, 30, 142, 1 },
        { 173, 10, 252, 1 }, },
      { { 177, 102, 224, 1 },
        { 109, 180, 42, 0 },
        { 131, 179, 70, 1 },
        { 42, 22, 219, 0 }, },
      { { 189, 49, 10, 1 },
        { 140, 50, 79, 1 },
        { 168, 70, 94, 1 },
        { 249, 38, 24, 1 }, },
      { { 189, 63, 186, 1 },
        { 189, 186, 111, 1 },
        { 174, 254, 94, 1 },
        { 251, 46, 222, 1 }, },
      { { 185, 190, 220, 0 },
        { 183, 60, 122, 1 },
        { 29, 190, 206, 1 },
        { 175, 30, 118, 1 }, },
      { { 178, 58, 240, 1 },
        { 60, 172, 234, 0 },
        { 135, 174, 38, 1 },
        { 43, 154, 158, 0 }, },
      { { 182, 207, 169, 0 },
        { 103, 232, 173, 1 },
        { 74, 249, 182, 1 },
        { 218, 139, 243, 0 }, },
      { { 186, 35, 226, 1 },
        { 172, 166, 171, 0 },
        { 163, 226, 46, 1 },
        { 106, 178, 154, 1 }, },
      { { 183, 36, 171, 1 },
        { 13, 242, 174, 1 },
        { 234, 146, 118, 1 },
        { 186, 167, 216, 0 }, },
      { { 183, 41, 251, 0 },
        { 20, 254, 175, 1 },
        { 111, 202, 118, 1 },
        { 250, 191, 148, 0 }, },
      { { 179, 174, 8, 0 },
        { 39, 56, 138, 1 },
        { 8, 58, 230, 1 },
        { 168, 142, 114, 0 }, },
      { { 183, 86, 202, 1 },
        { 109, 54, 236, 1 },
        { 169, 181, 118, 1 },
        { 155, 182, 91, 0 }, },
      { { 191, 168, 244, 0 },
        { 150, 188, 190, 0 },
        { 23, 138, 254, 1 },
        { 62, 158, 180, 1 }, },
      { { 191, 148, 18, 1 },
        { 159, 50, 204, 0 },
        { 164, 20, 254, 1 },
        { 25, 166, 124, 1 }, },
      { { 191, 122, 64, 1 },
        { 236, 60, 206, 0 },
        { 129, 47, 126, 1 },
        { 57, 158, 27, 1 }, },
      { { 196, 133, 200, 0 },
        { 3, 5, 45, 1 },
        { 9, 208, 145, 1 },
        { 218, 80, 96, 0 }, },
      { { 192, 14, 9, 1 },
        { 41, 73, 8, 1 },
        { 200, 56, 1, 1 },
        { 136, 73, 74, 0 }, },
      { { 192, 112, 254, 0 },
        { 80, 135, 122, 1 },
        { 63, 135, 1, 1 },
        { 175, 112, 133, 0 }, },
      { { 204, 116, 17, 0 },
        { 209, 65, 78, 0 },
        { 68, 23, 25, 1 },
        { 57, 65, 69, 1 }, },
      { { 193, 8, 90, 1 },
        { 24, 31, 8, 1 },
        { 173, 8, 65, 1 },
        { 136, 124, 12, 0 }, },
      { { 193, 47, 130, 1 },
        { 41, 27, 43, 0 },
        { 160, 250, 65, 1 },
        { 106, 108, 74, 0 }, },
      { { 193, 35, 120, 0 },
        { 48, 149, 11, 1 },
        { 15, 98, 65, 1 },
        { 232, 84, 134, 0 }, },
      { { 198, 52, 219, 1 },
        { 25, 71, 238, 1 },
        { 237, 150, 49, 1 },
        { 187, 241, 76, 0 }, },
      { { 198, 164, 244, 1 },
        { 27, 133, 190, 0 },
        { 151, 146, 177, 1 },
        { 62, 208, 236, 0 }, },
      { { 194, 228, 25, 0 },
        { 83, 65, 138, 1 },
        { 76, 19, 161, 1 },
        { 168, 193, 101, 0 }, },
      { { 195, 29, 35, 0 },
        { 1, 219, 201, 0 },
        { 98, 92, 97, 1 },
        { 73, 237, 192, 0 }, },
      { { 195, 242, 196, 1 },
        { 106, 21, 250, 0 },
        { 145, 167, 225, 1 },
        { 47, 212, 43, 0 }, },
      { { 199, 95, 223, 0 },
        { 113, 95, 253, 1 },
        { 125, 253, 113, 1 },
        { 223, 253, 71, 0 }, },
      { { 203, 101, 189, 0 },
        { 209, 209, 187, 1 },
        { 94, 211, 105, 1 },
        { 238, 197, 197, 1 }, },
      { { 203, 199, 15, 1 },
        { 235, 83, 153, 1 },
        { 248, 113, 233, 1 },
        { 204, 229, 107, 1 }, },
      { { 207, 246, 185, 0 },
        { 243, 209, 238, 1 },
        { 78, 183, 249, 1 },
        { 187, 197, 231, 1 }, },
      { { 212, 84, 239, 0 },
        { 69, 199, 124, 1 },
        { 123, 149, 21, 1 },
        { 159, 113, 209, 0 }, },
      { { 212, 251, 220, 0 },
        { 118, 13, 127, 1 },
        { 29, 239, 149, 1 },
        { 255, 88, 55, 0 }, },
      { { 220, 232, 84, 0 },
        { 214, 13, 30, 0 },
        { 21, 11, 157, 1 },
        { 60, 88, 53, 1 }, },
      { { 213, 177, 150, 0 },
        { 22, 19, 127, 0 },
        { 52, 198, 213, 1 },
        { 127, 100, 52, 0 }, },
      { { 209, 159, 7, 1 },
        { 47, 91, 89, 0 },
        { 240, 124, 197, 1 },
        { 77, 109, 122, 0 }, },
      { { 209, 93, 126, 1 },
        { 93, 159, 89, 1 },
        { 191, 93, 69, 1 },
        { 205, 124, 221, 0 }, },
      { { 217, 164, 134, 1 },
        { 143, 19, 58, 0 },
        { 176, 146, 205, 1 },
        { 46, 100, 120, 1 }, },
      { { 221, 9, 48, 1 },
        { 156, 153, 13, 0 },
        { 134, 72, 93, 1 },
        { 88, 76, 156, 1 }, },
      { { 217, 180, 57, 1 },
        { 159, 209, 74, 1 },
        { 206, 22, 205, 1 },
        { 169, 69, 252, 1 }, },
      { { 221, 171, 105, 1 },
        { 174, 221, 15, 1 },
        { 203, 106, 221, 1 },
        { 248, 93, 186, 1 }, },
      { { 217, 203, 66, 0 },
        { 230, 31, 9, 0 },
        { 33, 105, 205, 1 },
        { 72, 124, 51, 1 }, },
      { { 210, 33, 13, 0 },
        { 4, 65, 155, 1 },
        { 88, 66, 37, 1 },
        { 236, 193, 16, 0 }, },
      { { 214, 73, 4, 0 },
        { 68, 9, 157, 0 },
        { 16, 73, 53, 1 },
        { 92, 200, 17, 0 }, },
      { { 210, 216, 219, 0 },
        { 86, 79, 232, 1 },
        { 109, 141, 165, 1 },
        { 139, 249, 53, 0 }, },
      { { 218, 63, 69, 1 },
        { 173, 77, 219, 0 },
        { 209, 126, 45, 1 },
        { 109, 217, 90, 1 }, },
      { { 218, 125, 218, 0 },
        { 213, 15, 235, 1 },
        { 45, 223, 45, 1 },
        { 235, 248, 85, 1 }, },
      { { 218, 211, 230, 0 },
        { 230, 135, 249, 0 },
        { 51, 229, 173, 1 },
        { 79, 240, 179, 1 }, },
      { { 211, 51, 189, 0 },
        { 52, 209, 251, 1 },
        { 94, 230, 101, 1 },
        { 239, 197, 150, 0 }, },
      { { 215, 225, 237, 1 },
        { 78, 213, 191, 1 },
        { 219, 195, 245, 1 },
        { 254, 213, 185, 0 }, },
      { { 219, 197, 122, 0 },
        { 215, 151, 137, 1 },
        { 47, 81, 237, 1 },
        { 200, 244, 245, 1 }, },
      { { 224, 128, 59, 1 },
        { 26, 227, 8, 1 },
        { 238, 0, 131, 1 },
        { 136, 99, 172, 0 }, },
      { { 224, 207, 105, 1 },
        { 107, 237, 9, 1 },
        { 203, 121, 131, 1 },
        { 200, 91, 235, 0 }, },
      { { 228, 71, 48, 1 },
        { 121, 161, 13, 0 },
        { 134, 113, 19, 1 },
        { 88, 66, 207, 0 }, },
      { { 232, 29, 86, 1 },
        { 153, 47, 89, 0 },
        { 181, 92, 11, 1 },
        { 77, 122, 76, 1 }, },
      { { 232, 243, 72, 1 },
        { 234, 37, 75, 1 },
        { 137, 103, 139, 1 },
        { 233, 82, 43, 1 }, },
      { { 232, 254, 175, 0 },
        { 227, 235, 122, 1 },
        { 122, 191, 139, 1 },
        { 175, 107, 227, 1 }, },
      { { 236, 231, 159, 0 },
        { 243, 99, 63, 1 },
        { 124, 243, 155, 1 },
        { 254, 99, 103, 1 }, },
      { { 225, 60, 212, 1 },
        { 25, 61, 122, 0 },
        { 149, 158, 67, 1 },
        { 47, 94, 76, 0 }, },
      { { 229, 204, 106, 1 },
        { 75, 191, 12, 1 },
        { 171, 25, 211, 1 },
        { 152, 126, 233, 0 }, },
      { { 233, 175, 154, 0 },
        { 179, 59, 43, 1 },
        { 44, 250, 203, 1 },
        { 234, 110, 102, 1 }, },
      { { 227, 0, 237, 0 },
        { 0, 245, 184, 1 },
        { 91, 128, 99, 1 },
        { 142, 215, 128, 0 }, },
      { { 231, 177, 14, 0 },
        { 2, 51, 223, 1 },
        { 56, 70, 243, 1 },
        { 253, 230, 32, 0 }, },
      { { 227, 192, 126, 0 },
        { 82, 183, 152, 1 },
        { 63, 1, 227, 1 },
        { 140, 246, 165, 0 }, },
      { { 235, 140, 163, 0 },
        { 131, 251, 168, 0 },
        { 98, 152, 235, 1 },
        { 10, 239, 224, 1 }, },
      { { 235, 159, 109, 1 },
        { 171, 253, 217, 1 },
        { 219, 124, 235, 1 },
        { 205, 223, 234, 1 }, },
      { { 239, 65, 11, 0 },
        { 192, 115, 141, 1 },
        { 104, 65, 123, 1 },
        { 216, 231, 1, 1 }, },
      { { 239, 194, 195, 0 },
        { 226, 119, 172, 0 },
        { 97, 161, 251, 1 },
        { 26, 247, 35, 1 }, },
      { { 240, 168, 32, 0 },
        { 6, 169, 10, 0 },
        { 2, 10, 135, 1 },
        { 40, 74, 176, 0 }, },
      { { 244, 25, 211, 0 },
        { 20, 111, 109, 0 },
        { 101, 204, 23, 1 },
        { 91, 123, 20, 0 }, },
      { { 244, 133, 191, 1 },
        { 31, 227, 61, 1 },
        { 254, 208, 151, 1 },
        { 222, 99, 252, 0 }, },
      { { 240, 106, 204, 0 },
        { 100, 45, 58, 1 },
        { 25, 171, 7, 1 },
        { 174, 90, 19, 0 }, },
      { { 240, 123, 107, 1 },
        { 108, 239, 75, 1 },
        { 235, 111, 7, 1 },
        { 233, 123, 155, 0 }, },
      { { 244, 251, 170, 0 },
        { 102, 171, 111, 1 },
        { 42, 239, 151, 1 },
        { 251, 106, 179, 0 }, },
      { { 252, 198, 47, 0 },
        { 231, 227, 28, 1 },
        { 122, 49, 159, 1 },
        { 156, 99, 243, 1 }, },
      { { 248, 111, 16, 0 },
        { 245, 41, 11, 0 },
        { 4, 123, 15, 1 },
        { 104, 74, 87, 1 }, },
      { { 252, 127, 120, 1 },
        { 253, 173, 79, 1 },
        { 143, 127, 31, 1 },
        { 249, 90, 223, 1 }, },
      { { 241, 171, 217, 0 },
        { 54, 125, 43, 1 },
        { 77, 234, 199, 1 },
        { 234, 95, 54, 0 }, },
      { { 245, 81, 143, 1 },
        { 76, 115, 125, 1 },
        { 248, 197, 87, 1 },
        { 223, 103, 25, 0 }, },
      { { 241, 248, 166, 1 },
        { 78, 187, 122, 0 },
        { 178, 143, 199, 1 },
        { 47, 110, 185, 0 }, },
      { { 241, 86, 24, 0 },
        { 117, 49, 72, 1 },
        { 12, 53, 71, 1 },
        { 137, 70, 87, 0 }, },
      { { 253, 132, 196, 0 },
        { 135, 53, 60, 0 },
        { 17, 144, 223, 1 },
        { 30, 86, 112, 1 }, },
      { { 249, 141, 114, 1 },
        { 159, 191, 9, 0 },
        { 167, 88, 207, 1 },
        { 72, 126, 252, 1 }, },
      { { 253, 15, 85, 1 },
        { 189, 125, 29, 0 },
        { 213, 120, 95, 1 },
        { 92, 95, 94, 1 }, },
      { { 242, 156, 111, 1 },
        { 15, 239, 216, 1 },
        { 251, 28, 167, 1 },
        { 141, 251, 248, 0 }, },
      { { 246, 136, 24, 1 },
        { 30, 41, 140, 1 },
        { 140, 8, 183, 1 },
        { 152, 202, 60, 0 }, },
      { { 246, 7, 197, 0 },
        { 37, 101, 189, 0 },
        { 81, 240, 55, 1 },
        { 94, 211, 82, 0 }, },
      { { 242, 65, 215, 0 },
        { 84, 103, 185, 0 },
        { 117, 193, 39, 1 },
        { 78, 243, 21, 0 }, },
      { { 246, 241, 27, 0 },
        { 86, 99, 207, 1 },
        { 108, 71, 183, 1 },
        { 249, 227, 53, 0 }, },
      { { 242, 230, 203, 1 },
        { 111, 103, 170, 1 },
        { 233, 179, 167, 1 },
        { 170, 243, 123, 0 }, },
      { { 250, 213, 32, 1 },
        { 207, 161, 201, 0 },
        { 130, 85, 175, 1 },
        { 73, 194, 249, 1 }, },
      { { 254, 67, 233, 0 },
        { 228, 229, 173, 1 },
        { 75, 225, 63, 1 },
        { 218, 211, 147, 1 }, },
      { { 243, 251, 142, 0 },
        { 102, 59, 251, 1 },
        { 56, 239, 231, 1 },
        { 239, 238, 51, 0 }, },
      { { 255, 187, 218, 0 },
        { 182, 63, 239, 1 },
        { 45, 238, 255, 1 },
        { 251, 254, 54, 1 }, },
      { { 251, 201, 14, 1 },
        { 206, 59, 153, 1 },
        { 184, 73, 239, 1 },
        { 204, 238, 57, 1 }, }, };

static unsigned char DICT_6X6_1000_BYTES[][4][5] =
    { { { 30, 61, 216, 42, 6 },
        { 227, 186, 70, 49, 9 },
        { 101, 65, 187, 199, 8 },
        { 152, 198, 37, 220, 7 }, },
      { { 14, 251, 163, 137, 1 },
        { 215, 230, 24, 5, 14 },
        { 137, 28, 93, 247, 0 },
        { 122, 1, 134, 126, 11 }, },
      { { 21, 144, 126, 172, 13 },
        { 236, 105, 87, 80, 6 },
        { 179, 87, 224, 154, 8 },
        { 96, 174, 169, 99, 7 }, },
      { { 201, 27, 48, 105, 14 },
        { 66, 50, 75, 222, 12 },
        { 121, 96, 205, 137, 3 },
        { 55, 189, 36, 196, 2 }, },
      { { 214, 7, 214, 225, 5 },
        { 164, 203, 74, 191, 2 },
        { 168, 118, 190, 6, 11 },
        { 79, 213, 45, 50, 5 }, },
      { { 216, 232, 224, 230, 8 },
        { 43, 140, 19, 138, 15 },
        { 22, 112, 113, 113, 11 },
        { 245, 28, 131, 29, 4 }, },
      { { 66, 104, 180, 31, 5 },
        { 13, 165, 192, 149, 13 },
        { 175, 130, 209, 100, 2 },
        { 186, 144, 58, 91, 0 }, },
      { { 136, 165, 15, 41, 10 },
        { 19, 115, 23, 38, 0 },
        { 89, 79, 10, 81, 1 },
        { 6, 78, 140, 236, 8 }, },
      { { 48, 125, 82, 79, 13 },
        { 109, 110, 97, 60, 9 },
        { 191, 36, 171, 224, 12 },
        { 147, 200, 103, 107, 6 }, },
      { { 60, 47, 52, 179, 12 },
        { 131, 11, 235, 52, 15 },
        { 60, 210, 207, 67, 12 },
        { 242, 205, 125, 12, 1 }, },
      { { 69, 223, 199, 78, 3 },
        { 252, 247, 24, 232, 9 },
        { 199, 46, 63, 186, 2 },
        { 145, 113, 142, 243, 15 }, },
      { { 72, 216, 91, 37, 7 },
        { 126, 84, 86, 148, 8 },
        { 234, 77, 161, 177, 2 },
        { 18, 150, 162, 167, 14 }, },
      { { 113, 5, 88, 252, 6 },
        { 40, 58, 230, 248, 2 },
        { 99, 241, 170, 8, 14 },
        { 65, 246, 117, 193, 4 }, },
      { { 134, 220, 250, 208, 7 },
        { 228, 212, 212, 59, 14 },
        { 224, 181, 243, 182, 1 },
        { 125, 194, 178, 178, 7 }, },
      { { 141, 114, 169, 63, 6 },
        { 219, 180, 206, 70, 5 },
        { 111, 201, 84, 235, 1 },
        { 166, 39, 50, 221, 11 }, },
      { { 162, 184, 157, 205, 14 },
        { 89, 177, 117, 31, 10 },
        { 123, 59, 145, 212, 5 },
        { 95, 138, 232, 217, 10 }, },
      { { 9, 253, 30, 156, 4 },
        { 75, 103, 212, 112, 10 },
        { 35, 151, 139, 249, 0 },
        { 80, 226, 190, 109, 2 }, },
      { { 21, 77, 189, 24, 15 },
        { 148, 191, 197, 112, 12 },
        { 241, 139, 219, 42, 8 },
        { 48, 234, 63, 210, 9 }, },
      { { 48, 10, 49, 14, 2 },
        { 24, 56, 40, 16, 13 },
        { 71, 8, 197, 0, 12 },
        { 176, 129, 65, 193, 8 }, },
      { { 72, 7, 239, 175, 13 },
        { 62, 227, 79, 164, 7 },
        { 191, 95, 126, 1, 2 },
        { 226, 95, 44, 119, 12 }, },
      { { 86, 223, 17, 219, 6 },
        { 208, 62, 216, 189, 11 },
        { 109, 184, 143, 182, 10 },
        { 219, 209, 183, 192, 11 }, },
      { { 102, 136, 50, 116, 12 },
        { 136, 64, 243, 153, 12 },
        { 50, 228, 193, 22, 6 },
        { 57, 156, 240, 33, 1 }, },
      { { 118, 232, 203, 120, 1 },
        { 181, 236, 182, 137, 8 },
        { 129, 237, 49, 118, 14 },
        { 25, 22, 211, 122, 13 }, },
      { { 154, 83, 217, 207, 3 },
        { 126, 190, 12, 31, 3 },
        { 207, 57, 188, 165, 9 },
        { 207, 131, 7, 215, 14 }, },
      { { 169, 203, 132, 2, 4 },
        { 2, 135, 120, 66, 9 },
        { 36, 2, 29, 57, 5 },
        { 148, 33, 238, 20, 0 }, },
      { { 198, 117, 73, 73, 0 },
        { 241, 38, 4, 175, 0 },
        { 9, 41, 42, 230, 3 },
        { 15, 82, 6, 72, 15 }, },
      { { 193, 210, 136, 148, 1 },
        { 76, 132, 156, 194, 2 },
        { 130, 145, 20, 184, 3 },
        { 68, 51, 146, 19, 2 }, },
      { { 231, 72, 8, 82, 11 },
        { 132, 20, 165, 203, 9 },
        { 212, 161, 1, 46, 7 },
        { 157, 58, 82, 130, 1 }, },
      { { 234, 47, 202, 132, 8 },
        { 43, 194, 45, 163, 10 },
        { 18, 21, 63, 69, 7 },
        { 92, 91, 68, 61, 4 }, },
      { { 233, 99, 183, 123, 1 },
        { 23, 231, 170, 222, 5 },
        { 141, 238, 220, 105, 7 },
        { 167, 181, 94, 126, 8 }, },
      { { 250, 54, 101, 42, 15 },
        { 119, 57, 107, 163, 5 },
        { 245, 74, 102, 197, 15 },
        { 172, 93, 105, 206, 14 }, },
      { { 6, 91, 255, 123, 13 },
        { 244, 231, 207, 29, 13 },
        { 189, 239, 253, 166, 0 },
        { 187, 143, 62, 114, 15 }, },
      { { 5, 65, 215, 45, 6 },
        { 184, 247, 66, 84, 0 },
        { 107, 78, 184, 42, 0 },
        { 2, 164, 46, 241, 13 }, },
      { { 12, 247, 36, 106, 2 },
        { 195, 55, 26, 40, 5 },
        { 69, 98, 78, 243, 0 },
        { 161, 69, 142, 204, 3 }, },
      { { 19, 56, 163, 158, 11 },
        { 93, 248, 129, 65, 15 },
        { 215, 156, 81, 204, 8 },
        { 248, 40, 17, 251, 10 }, },
      { { 21, 168, 147, 231, 4 },
        { 153, 200, 82, 92, 11 },
        { 46, 124, 145, 90, 8 },
        { 211, 164, 161, 57, 9 }, },
      { { 58, 65, 126, 233, 14 },
        { 34, 127, 103, 29, 6 },
        { 121, 119, 232, 37, 12 },
        { 107, 142, 111, 228, 4 }, },
      { { 79, 17, 226, 108, 0 },
        { 234, 226, 2, 201, 4 },
        { 3, 100, 120, 143, 2 },
        { 41, 52, 4, 117, 7 }, },
      { { 83, 13, 182, 210, 0 },
        { 0, 203, 128, 249, 15 },
        { 4, 182, 219, 12, 10 },
        { 249, 240, 29, 48, 0 }, },
      { { 88, 155, 250, 227, 4 },
        { 98, 202, 94, 156, 15 },
        { 44, 117, 253, 145, 10 },
        { 243, 151, 165, 52, 6 }, },
      { { 100, 9, 232, 160, 11 },
        { 164, 146, 39, 128, 14 },
        { 208, 81, 121, 2, 6 },
        { 112, 30, 68, 146, 5 }, },
      { { 96, 83, 122, 137, 1 },
        { 100, 102, 44, 148, 6 },
        { 137, 21, 236, 160, 6 },
        { 98, 147, 70, 98, 6 }, },
      { { 97, 89, 6, 155, 10 },
        { 64, 119, 161, 196, 11 },
        { 93, 150, 9, 168, 6 },
        { 210, 56, 94, 224, 2 }, },
      { { 107, 255, 120, 215, 11 },
        { 111, 22, 189, 253, 15 },
        { 222, 177, 239, 253, 6 },
        { 251, 251, 214, 143, 6 }, },
      { { 112, 173, 150, 164, 15 },
        { 13, 219, 115, 176, 10 },
        { 242, 86, 155, 80, 14 },
        { 80, 220, 237, 187, 0 }, },
      { { 117, 132, 111, 113, 10 },
        { 176, 89, 183, 236, 4 },
        { 88, 239, 98, 26, 14 },
        { 35, 126, 217, 160, 13 }, },
      { { 122, 149, 25, 47, 12 },
        { 90, 42, 119, 181, 1 },
        { 63, 73, 138, 149, 14 },
        { 138, 222, 229, 69, 10 }, },
      { { 134, 9, 118, 10, 10 },
        { 160, 115, 1, 19, 13 },
        { 85, 6, 233, 6, 1 },
        { 188, 136, 12, 224, 5 }, },
      { { 138, 45, 68, 195, 15 },
        { 39, 19, 65, 47, 11 },
        { 252, 50, 43, 69, 1 },
        { 223, 72, 44, 142, 4 }, },
      { { 147, 235, 120, 177, 4 },
        { 33, 14, 222, 87, 14 },
        { 40, 209, 237, 124, 9 },
        { 126, 167, 183, 8, 4 }, },
      { { 152, 141, 168, 77, 4 },
        { 10, 170, 84, 46, 12 },
        { 43, 33, 91, 17, 9 },
        { 55, 66, 165, 85, 0 }, },
      { { 158, 222, 43, 60, 8 },
        { 218, 108, 159, 35, 12 },
        { 19, 205, 71, 183, 9 },
        { 60, 79, 147, 101, 11 }, },
      { { 165, 41, 224, 123, 8 },
        { 161, 162, 163, 78, 13 },
        { 29, 224, 121, 74, 5 },
        { 183, 44, 84, 88, 5 }, },
      { { 181, 147, 184, 85, 15 },
        { 204, 154, 253, 94, 4 },
        { 250, 161, 220, 154, 13 },
        { 39, 171, 245, 147, 3 }, },
      { { 183, 248, 228, 38, 15 },
        { 237, 157, 115, 67, 13 },
        { 246, 66, 113, 254, 13 },
        { 188, 44, 235, 155, 7 }, },
      { { 188, 32, 82, 37, 14 },
        { 171, 88, 99, 22, 0 },
        { 122, 68, 160, 67, 13 },
        { 6, 140, 97, 173, 5 }, },
      { { 192, 68, 135, 118, 5 },
        { 28, 197, 194, 170, 1 },
        { 166, 238, 18, 32, 3 },
        { 133, 84, 58, 51, 8 }, },
      { { 196, 195, 36, 37, 9 },
        { 140, 7, 27, 134, 4 },
        { 154, 66, 76, 50, 3 },
        { 38, 29, 142, 3, 1 }, },
      { { 197, 169, 27, 216, 13 },
        { 149, 98, 213, 218, 10 },
        { 177, 189, 137, 90, 3 },
        { 85, 186, 180, 106, 9 }, },
      { { 206, 115, 230, 178, 12 },
        { 227, 199, 203, 131, 7 },
        { 52, 214, 124, 231, 3 },
        { 236, 29, 62, 60, 7 }, },
      { { 205, 12, 166, 39, 2 },
        { 138, 209, 2, 230, 13 },
        { 78, 70, 83, 11, 3 },
        { 182, 116, 8, 181, 1 }, },
      { { 201, 67, 93, 68, 13 },
        { 62, 7, 77, 218, 0 },
        { 178, 43, 172, 41, 3 },
        { 5, 187, 46, 7, 12 }, },
      { { 207, 190, 128, 243, 4 },
        { 195, 128, 218, 239, 11 },
        { 44, 240, 23, 223, 3 },
        { 223, 117, 176, 28, 3 }, },
      { { 229, 125, 21, 135, 7 },
        { 221, 23, 96, 246, 11 },
        { 238, 26, 139, 234, 7 },
        { 214, 240, 110, 139, 11 }, },
      { { 239, 198, 133, 142, 9 },
        { 158, 165, 57, 227, 3 },
        { 151, 26, 22, 63, 7 },
        { 204, 121, 202, 87, 9 }, },
      { { 247, 126, 243, 119, 2 },
        { 249, 220, 170, 255, 13 },
        { 78, 236, 247, 238, 15 },
        { 191, 245, 83, 185, 15 }, },
      { { 44, 228, 63, 37, 4 },
        { 155, 69, 118, 52, 4 },
        { 42, 79, 194, 115, 4 },
        { 34, 198, 234, 45, 9 }, },
      { { 43, 220, 255, 75, 3 },
        { 118, 245, 52, 125, 13 },
        { 205, 47, 243, 189, 4 },
        { 187, 226, 202, 246, 14 }, },
      { { 55, 199, 221, 189, 10 },
        { 184, 191, 191, 117, 2 },
        { 91, 219, 190, 62, 12 },
        { 74, 239, 223, 209, 13 }, },
      { { 161, 162, 84, 224, 15 },
        { 37, 17, 123, 90, 2 },
        { 240, 114, 164, 88, 5 },
        { 69, 173, 232, 138, 4 }, },
      { { 169, 130, 193, 187, 5 },
        { 54, 160, 250, 70, 3 },
        { 173, 216, 52, 25, 5 },
        { 198, 37, 240, 86, 12 }, },
      { { 216, 27, 73, 176, 8 },
        { 114, 10, 143, 130, 10 },
        { 16, 217, 45, 129, 11 },
        { 84, 31, 21, 4, 14 }, },
      { { 3, 88, 41, 248, 6 },
        { 80, 52, 198, 73, 14 },
        { 97, 249, 65, 172, 0 },
        { 121, 38, 50, 192, 10 }, },
      { { 7, 196, 9, 95, 12 },
        { 152, 36, 213, 109, 1 },
        { 63, 169, 2, 62, 0 },
        { 139, 106, 178, 65, 9 }, },
      { { 15, 226, 102, 23, 11 },
        { 175, 85, 153, 69, 5 },
        { 222, 134, 100, 127, 0 },
        { 170, 41, 154, 175, 5 }, },
      { { 20, 72, 54, 68, 1 },
        { 140, 77, 0, 24, 12 },
        { 130, 38, 193, 34, 8 },
        { 49, 128, 11, 35, 1 }, },
      { { 16, 173, 95, 251, 7 },
        { 53, 123, 214, 60, 11 },
        { 237, 255, 171, 80, 8 },
        { 211, 198, 189, 234, 12 }, },
      { { 18, 130, 149, 83, 15 },
        { 20, 153, 217, 29, 1 },
        { 252, 170, 148, 20, 8 },
        { 139, 137, 185, 146, 8 }, },
      { { 22, 225, 49, 132, 12 },
        { 153, 14, 81, 17, 6 },
        { 50, 24, 200, 118, 8 },
        { 104, 136, 167, 9, 9 }, },
      { { 24, 122, 73, 107, 0 },
        { 115, 44, 14, 12, 9 },
        { 13, 105, 37, 225, 8 },
        { 147, 7, 3, 76, 14 }, },
      { { 26, 232, 134, 17, 2 },
        { 3, 221, 144, 5, 8 },
        { 72, 134, 17, 117, 8 },
        { 26, 0, 155, 188, 0 }, },
      { { 25, 19, 174, 10, 1 },
        { 70, 235, 12, 64, 5 },
        { 133, 7, 92, 137, 8 },
        { 160, 35, 13, 118, 2 }, },
      { { 27, 103, 181, 161, 7 },
        { 23, 159, 74, 117, 6 },
        { 232, 90, 222, 109, 8 },
        { 106, 229, 47, 158, 8 }, },
      { { 37, 220, 149, 240, 11 },
        { 212, 149, 179, 120, 10 },
        { 208, 250, 147, 186, 4 },
        { 81, 236, 218, 146, 11 }, },
      { { 40, 137, 97, 247, 6 },
        { 58, 18, 242, 12, 15 },
        { 110, 248, 105, 17, 4 },
        { 243, 4, 244, 133, 12 }, },
      { { 51, 84, 20, 106, 10 },
        { 64, 61, 35, 121, 1 },
        { 85, 98, 130, 172, 12 },
        { 137, 236, 75, 192, 2 }, },
      { { 49, 193, 108, 31, 7 },
        { 44, 63, 244, 68, 5 },
        { 239, 131, 104, 56, 12 },
        { 162, 34, 255, 195, 4 }, },
      { { 51, 203, 24, 198, 6 },
        { 8, 30, 124, 89, 11 },
        { 102, 49, 141, 60, 12 },
        { 217, 163, 231, 129, 0 }, },
      { { 62, 207, 228, 144, 15 },
        { 166, 159, 249, 33, 14 },
        { 240, 146, 127, 55, 12 },
        { 120, 73, 255, 150, 5 }, },
      { { 70, 69, 24, 163, 15 },
        { 132, 22, 71, 181, 3 },
        { 252, 81, 138, 38, 2 },
        { 202, 222, 38, 130, 1 }, },
      { { 68, 186, 112, 182, 7 },
        { 237, 16, 218, 144, 15 },
        { 230, 208, 229, 210, 2 },
        { 240, 149, 176, 139, 7 }, },
      { { 65, 156, 98, 62, 8 },
        { 104, 96, 147, 224, 13 },
        { 23, 196, 99, 152, 2 },
        { 176, 124, 144, 97, 6 }, },
      { { 72, 209, 145, 74, 1 },
        { 86, 166, 16, 152, 1 },
        { 133, 40, 152, 177, 2 },
        { 129, 144, 134, 86, 10 }, },
      { { 84, 244, 153, 246, 13 },
        { 221, 140, 215, 184, 3 },
        { 182, 249, 146, 242, 10 },
        { 193, 222, 179, 27, 11 }, },
      { { 87, 90, 156, 129, 3 },
        { 196, 157, 12, 213, 10 },
        { 200, 19, 149, 174, 10 },
        { 90, 179, 11, 146, 3 }, },
      { { 85, 131, 85, 178, 12 },
        { 176, 11, 219, 208, 3 },
        { 52, 218, 172, 26, 10 },
        { 192, 189, 189, 0, 13 }, },
      { { 87, 183, 118, 16, 15 },
        { 229, 91, 217, 241, 4 },
        { 240, 134, 238, 222, 10 },
        { 40, 249, 189, 170, 7 }, },
      { { 92, 52, 54, 254, 4 },
        { 203, 105, 194, 184, 7 },
        { 39, 246, 194, 195, 10 },
        { 225, 212, 57, 109, 3 }, },
      { { 92, 72, 252, 119, 14 },
        { 170, 157, 199, 156, 13 },
        { 126, 227, 241, 35, 10 },
        { 179, 158, 59, 149, 5 }, },
      { { 94, 110, 239, 64, 2 },
        { 179, 221, 12, 169, 12 },
        { 64, 47, 119, 103, 10 },
        { 57, 83, 11, 188, 13 }, },
      { { 95, 35, 59, 111, 15 },
        { 159, 122, 79, 221, 5 },
        { 255, 109, 204, 79, 10 },
        { 171, 191, 37, 239, 9 }, },
      { { 91, 116, 42, 99, 2 },
        { 67, 92, 6, 237, 5 },
        { 76, 101, 66, 237, 10 },
        { 171, 118, 3, 172, 2 }, },
      { { 101, 15, 163, 58, 14 },
        { 144, 242, 235, 224, 13 },
        { 117, 204, 95, 10, 6 },
        { 176, 125, 116, 240, 9 }, },
      { { 101, 211, 23, 92, 12 },
        { 216, 103, 249, 216, 0 },
        { 51, 174, 140, 186, 6 },
        { 1, 185, 254, 97, 11 }, },
      { { 106, 156, 36, 90, 14 },
        { 66, 49, 241, 169, 13 },
        { 117, 162, 67, 149, 6 },
        { 185, 88, 248, 196, 2 }, },
      { { 105, 197, 243, 4, 2 },
        { 58, 214, 48, 240, 4 },
        { 66, 12, 250, 57, 6 },
        { 32, 240, 198, 181, 12 }, },
      { { 105, 210, 72, 78, 10 },
        { 106, 52, 61, 200, 1 },
        { 87, 33, 36, 185, 6 },
        { 129, 59, 194, 197, 6 }, },
      { { 116, 121, 226, 222, 6 },
        { 233, 254, 224, 136, 15 },
        { 103, 180, 121, 226, 14 },
        { 241, 16, 119, 249, 7 }, },
      { { 114, 207, 35, 234, 11 },
        { 20, 126, 59, 169, 15 },
        { 213, 124, 79, 52, 14 },
        { 249, 93, 199, 226, 8 }, },
      { { 119, 177, 220, 65, 4 },
        { 225, 139, 116, 221, 0 },
        { 40, 35, 184, 222, 14 },
        { 11, 178, 237, 24, 7 }, },
      { { 126, 12, 7, 33, 7 },
        { 150, 89, 98, 165, 8 },
        { 232, 78, 3, 7, 14 },
        { 26, 84, 105, 166, 9 }, },
      { { 122, 105, 112, 100, 7 },
        { 47, 30, 98, 153, 12 },
        { 226, 96, 233, 101, 14 },
        { 57, 148, 103, 143, 4 }, },
      { { 120, 178, 216, 112, 7 },
        { 103, 152, 254, 152, 0 },
        { 224, 225, 180, 209, 14 },
        { 1, 151, 241, 158, 6 }, },
      { { 121, 197, 133, 121, 4 },
        { 18, 175, 242, 236, 0 },
        { 41, 234, 26, 57, 14 },
        { 3, 116, 255, 84, 8 }, },
      { { 134, 111, 89, 252, 6 },
        { 185, 54, 206, 59, 10 },
        { 99, 249, 175, 102, 1 },
        { 93, 199, 54, 201, 13 }, },
      { { 130, 246, 114, 127, 5 },
        { 109, 100, 218, 63, 5 },
        { 175, 228, 230, 244, 1 },
        { 175, 197, 178, 107, 6 }, },
      { { 133, 78, 47, 65, 4 },
        { 144, 69, 76, 110, 12 },
        { 40, 47, 71, 42, 1 },
        { 55, 99, 42, 32, 9 }, },
      { { 154, 17, 133, 147, 4 },
        { 82, 139, 192, 7, 3 },
        { 44, 154, 24, 133, 9 },
        { 206, 0, 61, 20, 10 }, },
      { { 156, 113, 96, 201, 7 },
        { 231, 62, 64, 14, 6 },
        { 233, 48, 104, 227, 9 },
        { 103, 0, 39, 206, 7 }, },
      { { 157, 209, 148, 253, 8 },
        { 202, 175, 147, 94, 2 },
        { 27, 242, 152, 187, 9 },
        { 71, 172, 159, 85, 3 }, },
      { { 162, 30, 18, 227, 8 },
        { 64, 64, 43, 63, 11 },
        { 28, 116, 135, 132, 5 },
        { 223, 205, 64, 32, 2 }, },
      { { 174, 112, 28, 130, 12 },
        { 195, 5, 101, 19, 3 },
        { 52, 19, 128, 231, 5 },
        { 204, 138, 106, 12, 3 }, },
      { { 173, 1, 33, 156, 1 },
        { 158, 34, 160, 66, 6 },
        { 131, 152, 72, 11, 5 },
        { 100, 32, 84, 71, 9 }, },
      { { 176, 53, 31, 158, 14 },
        { 89, 123, 229, 50, 3 },
        { 119, 159, 138, 192, 13 },
        { 196, 202, 125, 233, 10 }, },
      { { 182, 74, 216, 13, 4 },
        { 168, 172, 108, 23, 8 },
        { 43, 1, 181, 38, 13 },
        { 30, 131, 99, 81, 5 }, },
      { { 181, 55, 49, 75, 4 },
        { 209, 42, 104, 126, 5 },
        { 45, 40, 206, 202, 13 },
        { 167, 225, 101, 72, 11 }, },
      { { 190, 170, 199, 227, 11 },
        { 183, 217, 59, 15, 11 },
        { 220, 126, 53, 87, 13 },
        { 223, 13, 201, 190, 13 }, },
      { { 187, 104, 61, 188, 15 },
        { 31, 61, 231, 83, 14 },
        { 243, 219, 193, 109, 13 },
        { 124, 174, 123, 207, 8 }, },
      { { 198, 114, 247, 44, 1 },
        { 253, 229, 10, 147, 4 },
        { 131, 78, 244, 230, 3 },
        { 44, 149, 10, 123, 15 }, },
      { { 193, 231, 77, 186, 11 },
        { 53, 55, 159, 226, 3 },
        { 213, 219, 46, 120, 3 },
        { 196, 127, 158, 202, 12 }, },
      { { 203, 85, 238, 89, 13 },
        { 102, 231, 197, 239, 4 },
        { 185, 167, 122, 173, 3 },
        { 47, 122, 62, 118, 6 }, },
      { { 203, 160, 83, 114, 4 },
        { 51, 64, 210, 219, 1 },
        { 36, 236, 160, 93, 3 },
        { 141, 180, 176, 44, 12 }, },
      { { 208, 9, 15, 207, 1 },
        { 28, 107, 4, 142, 11 },
        { 143, 63, 9, 0, 11 },
        { 215, 18, 13, 99, 8 }, },
      { { 208, 108, 58, 213, 4 },
        { 9, 76, 196, 190, 14 },
        { 42, 181, 195, 96, 11 },
        { 119, 210, 51, 41, 0 }, },
      { { 211, 241, 32, 87, 4 },
        { 73, 14, 208, 207, 5 },
        { 46, 160, 72, 252, 11 },
        { 175, 48, 183, 9, 2 }, },
      { { 230, 227, 59, 26, 7 },
        { 149, 118, 252, 147, 5 },
        { 229, 141, 204, 118, 7 },
        { 172, 147, 246, 234, 9 }, },
      { { 227, 83, 62, 164, 10 },
        { 72, 87, 47, 211, 6 },
        { 82, 87, 204, 172, 7 },
        { 108, 191, 78, 161, 2 }, },
      { { 232, 6, 142, 177, 4 },
        { 2, 193, 238, 166, 2 },
        { 40, 215, 22, 1, 7 },
        { 70, 87, 120, 52, 0 }, },
      { { 236, 7, 192, 89, 7 },
        { 166, 178, 232, 174, 0 },
        { 233, 160, 62, 3, 7 },
        { 7, 81, 116, 214, 5 }, },
      { { 234, 243, 128, 61, 10 },
        { 75, 182, 187, 135, 0 },
        { 91, 192, 28, 245, 7 },
        { 14, 29, 214, 221, 2 }, },
      { { 246, 59, 39, 216, 8 },
        { 209, 107, 169, 139, 14 },
        { 17, 190, 77, 198, 15 },
        { 125, 25, 93, 104, 11 }, },
      { { 243, 7, 152, 55, 9 },
        { 12, 138, 175, 247, 1 },
        { 158, 193, 158, 12, 15 },
        { 142, 255, 85, 19, 0 }, },
      { { 254, 75, 186, 155, 9 },
        { 134, 238, 173, 151, 15 },
        { 157, 149, 221, 39, 15 },
        { 254, 155, 87, 118, 1 }, },
      { { 171, 165, 125, 134, 11 },
        { 63, 19, 53, 115, 7 },
        { 214, 27, 234, 93, 5 },
        { 236, 234, 204, 143, 12 }, },
      { { 192, 209, 98, 90, 11 },
        { 100, 118, 145, 138, 5 },
        { 213, 164, 104, 176, 3 },
        { 165, 24, 150, 226, 6 }, },
      { { 19, 206, 123, 174, 7 },
        { 60, 124, 94, 113, 15 },
        { 231, 93, 231, 60, 8 },
        { 248, 231, 163, 227, 12 }, },
      { { 78, 129, 253, 97, 7 },
        { 182, 147, 86, 157, 4 },
        { 232, 107, 248, 23, 2 },
        { 43, 150, 172, 150, 13 }, },
      { { 86, 224, 118, 50, 0 },
        { 161, 77, 146, 145, 5 },
        { 4, 198, 224, 118, 10 },
        { 168, 148, 155, 40, 5 }, },
      { { 106, 112, 138, 84, 0 },
        { 75, 196, 164, 137, 0 },
        { 2, 165, 16, 229, 6 },
        { 9, 18, 82, 61, 2 }, },
      { { 114, 168, 152, 161, 8 },
        { 1, 136, 55, 149, 10 },
        { 24, 81, 145, 84, 14 },
        { 90, 158, 193, 24, 0 }, },
      { { 129, 93, 66, 248, 0 },
        { 96, 102, 130, 106, 10 },
        { 1, 244, 43, 168, 1 },
        { 85, 100, 22, 96, 6 }, },
      { { 207, 76, 195, 213, 15 },
        { 190, 212, 193, 239, 10 },
        { 250, 188, 51, 47, 3 },
        { 95, 120, 50, 183, 13 }, },
      { { 214, 187, 101, 134, 4 },
        { 249, 11, 88, 131, 15 },
        { 38, 26, 109, 214, 11 },
        { 252, 17, 173, 9, 15 }, },
      { { 236, 211, 19, 163, 1 },
        { 214, 70, 58, 150, 3 },
        { 140, 92, 140, 179, 7 },
        { 198, 149, 198, 38, 11 }, },
      { { 245, 33, 245, 32, 7 },
        { 181, 155, 98, 210, 4 },
        { 224, 74, 248, 74, 15 },
        { 36, 180, 109, 154, 13 }, },
      { { 249, 31, 165, 223, 7 },
        { 94, 187, 232, 238, 15 },
        { 239, 186, 95, 137, 15 },
        { 247, 113, 125, 215, 10 }, },
      { { 0, 36, 244, 122, 7 },
        { 37, 177, 194, 56, 5 },
        { 229, 226, 242, 64, 0 },
        { 161, 196, 56, 218, 4 }, },
      { { 0, 8, 77, 136, 2 },
        { 48, 49, 4, 0, 10 },
        { 65, 27, 33, 0, 0 },
        { 80, 2, 8, 192, 12 }, },
      { { 4, 60, 194, 242, 9 },
        { 229, 192, 131, 40, 11 },
        { 148, 244, 51, 194, 0 },
        { 209, 76, 16, 58, 7 }, },
      { { 4, 123, 80, 33, 1 },
        { 229, 6, 10, 20, 8 },
        { 136, 64, 173, 226, 0 },
        { 18, 133, 6, 10, 7 }, },
      { { 6, 122, 228, 193, 13 },
        { 229, 133, 73, 13, 14 },
        { 184, 50, 117, 230, 0 },
        { 123, 9, 42, 26, 7 }, },
      { { 0, 170, 150, 138, 3 },
        { 5, 241, 24, 16, 11 },
        { 197, 22, 149, 80, 0 },
        { 208, 129, 136, 250, 0 }, },
      { { 4, 209, 56, 233, 4 },
        { 192, 38, 86, 28, 6 },
        { 41, 113, 200, 178, 0 },
        { 99, 134, 166, 64, 3 }, },
      { { 5, 16, 168, 13, 10 },
        { 200, 176, 5, 68, 4 },
        { 91, 1, 80, 138, 0 },
        { 34, 42, 0, 209, 3 }, },
      { { 1, 64, 176, 0, 7 },
        { 4, 148, 64, 80, 4 },
        { 224, 0, 208, 40, 0 },
        { 32, 160, 34, 146, 0 }, },
      { { 1, 157, 156, 238, 1 },
        { 76, 163, 22, 120, 11 },
        { 135, 115, 155, 152, 0 },
        { 209, 230, 140, 83, 2 }, },
      { { 8, 16, 87, 227, 11 },
        { 118, 81, 3, 28, 3 },
        { 220, 126, 160, 129, 0 },
        { 195, 140, 8, 166, 14 }, },
      { { 8, 107, 151, 182, 6 },
        { 27, 215, 202, 16, 11 },
        { 102, 222, 157, 97, 0 },
        { 208, 133, 62, 189, 8 }, },
      { { 14, 232, 184, 96, 10 },
        { 131, 148, 23, 25, 12 },
        { 80, 97, 209, 119, 0 },
        { 57, 142, 130, 156, 1 }, },
      { { 11, 108, 118, 185, 11 },
        { 39, 117, 131, 117, 14 },
        { 217, 214, 227, 109, 0 },
        { 122, 236, 26, 238, 4 }, },
      { { 15, 220, 185, 140, 11 },
        { 222, 180, 21, 113, 14 },
        { 211, 25, 211, 191, 0 },
        { 120, 234, 130, 215, 11 }, },
      { { 15, 202, 207, 58, 0 },
        { 178, 229, 158, 65, 9 },
        { 5, 207, 53, 63, 0 },
        { 152, 39, 154, 116, 13 }, },
      { { 20, 36, 159, 217, 8 },
        { 145, 233, 133, 60, 2 },
        { 25, 191, 146, 66, 8 },
        { 67, 202, 25, 120, 9 }, },
      { { 20, 7, 32, 31, 13 },
        { 140, 42, 201, 36, 5 },
        { 191, 128, 78, 2, 8 },
        { 162, 73, 53, 67, 1 }, },
      { { 21, 9, 16, 213, 7 },
        { 140, 26, 192, 92, 10 },
        { 234, 176, 137, 10, 8 },
        { 83, 160, 53, 131, 1 }, },
      { { 19, 92, 215, 48, 7 },
        { 116, 221, 194, 113, 8 },
        { 224, 206, 179, 172, 8 },
        { 24, 228, 59, 178, 14 }, },
      { { 17, 71, 154, 187, 6 },
        { 0, 254, 206, 116, 3 },
        { 109, 213, 158, 40, 8 },
        { 194, 231, 55, 240, 0 }, },
      { { 28, 185, 169, 35, 8 },
        { 211, 138, 23, 4, 13 },
        { 28, 73, 89, 211, 8 },
        { 178, 14, 133, 28, 11 }, },
      { { 28, 221, 7, 118, 6 },
        { 218, 95, 210, 40, 9 },
        { 102, 238, 11, 179, 8 },
        { 145, 68, 191, 165, 11 }, },
      { { 31, 46, 124, 36, 11 },
        { 175, 25, 15, 113, 12 },
        { 210, 67, 231, 79, 8 },
        { 56, 239, 9, 143, 5 }, },
      { { 25, 102, 66, 71, 7 },
        { 47, 92, 72, 108, 1 },
        { 238, 36, 38, 105, 8 },
        { 131, 97, 35, 175, 4 }, },
      { { 25, 87, 212, 200, 4 },
        { 98, 175, 72, 120, 2 },
        { 33, 50, 190, 169, 8 },
        { 65, 225, 47, 84, 6 }, },
      { { 31, 168, 244, 240, 4 },
        { 163, 137, 210, 89, 14 },
        { 32, 242, 241, 95, 8 },
        { 121, 164, 185, 28, 5 }, },
      { { 27, 130, 70, 237, 8 },
        { 42, 105, 27, 77, 2 },
        { 27, 118, 36, 29, 8 },
        { 75, 45, 137, 101, 4 }, },
      { { 27, 174, 225, 15, 14 },
        { 59, 184, 89, 101, 13 },
        { 127, 8, 119, 93, 8 },
        { 186, 105, 161, 221, 12 }, },
      { { 34, 164, 182, 60, 10 },
        { 9, 241, 179, 49, 4 },
        { 83, 198, 210, 84, 4 },
        { 40, 204, 216, 249, 0 }, },
      { { 34, 191, 144, 18, 15 },
        { 69, 146, 249, 49, 9 },
        { 244, 128, 159, 212, 4 },
        { 152, 201, 244, 154, 2 }, },
      { { 35, 44, 21, 180, 0 },
        { 25, 1, 162, 113, 10 },
        { 2, 218, 131, 76, 4 },
        { 88, 228, 88, 9, 8 }, },
      { { 37, 90, 169, 102, 12 },
        { 216, 132, 111, 72, 13 },
        { 54, 105, 85, 170, 4 },
        { 177, 47, 98, 17, 11 }, },
      { { 39, 165, 175, 169, 7 },
        { 149, 243, 118, 101, 6 },
        { 233, 95, 90, 94, 4 },
        { 106, 102, 236, 250, 9 }, },
      { { 37, 244, 14, 66, 5 },
        { 197, 69, 116, 104, 1 },
        { 164, 39, 2, 250, 4 },
        { 129, 98, 234, 42, 3 }, },
      { { 40, 102, 85, 205, 14 },
        { 59, 53, 105, 60, 2 },
        { 123, 58, 166, 97, 4 },
        { 67, 201, 106, 205, 12 }, },
      { { 44, 66, 126, 14, 0 },
        { 170, 101, 44, 16, 5 },
        { 7, 7, 228, 35, 4 },
        { 160, 131, 74, 101, 5 }, },
      { { 42, 185, 124, 189, 0 },
        { 107, 35, 182, 21, 14 },
        { 11, 211, 233, 213, 4 },
        { 122, 134, 220, 77, 6 }, },
      { { 41, 70, 225, 210, 3 },
        { 54, 148, 168, 104, 7 },
        { 196, 184, 118, 41, 4 },
        { 225, 97, 82, 150, 12 }, },
      { { 45, 166, 40, 65, 0 },
        { 131, 0, 60, 108, 4 },
        { 8, 33, 70, 91, 4 },
        { 35, 99, 192, 12, 1 }, },
      { { 43, 251, 32, 154, 6 },
        { 67, 54, 248, 65, 15 },
        { 101, 144, 77, 253, 4 },
        { 248, 33, 246, 204, 2 }, },
      { { 54, 140, 214, 107, 12 },
        { 160, 233, 115, 61, 9 },
        { 61, 102, 179, 22, 12 },
        { 155, 204, 233, 112, 5 }, },
      { { 52, 135, 119, 124, 7 },
        { 188, 123, 250, 56, 4 },
        { 227, 238, 238, 18, 12 },
        { 33, 197, 253, 227, 13 }, },
      { { 52, 221, 235, 132, 0 },
        { 248, 206, 52, 32, 14 },
        { 2, 29, 123, 178, 12 },
        { 112, 66, 199, 49, 15 }, },
      { { 55, 145, 247, 111, 1 },
        { 252, 235, 50, 93, 5 },
        { 143, 110, 248, 158, 12 },
        { 171, 164, 205, 115, 15 }, },
      { { 58, 34, 142, 23, 5 },
        { 15, 201, 236, 5, 1 },
        { 174, 135, 20, 69, 12 },
        { 138, 3, 121, 63, 0 }, },
      { { 62, 19, 189, 64, 8 },
        { 210, 139, 45, 25, 4 },
        { 16, 43, 220, 135, 12 },
        { 41, 139, 77, 20, 11 }, },
      { { 60, 152, 67, 202, 2 },
        { 242, 120, 48, 8, 11 },
        { 69, 60, 33, 147, 12 },
        { 209, 0, 193, 228, 15 }, },
      { { 57, 88, 157, 23, 9 },
        { 94, 141, 165, 84, 9 },
        { 158, 139, 145, 169, 12 },
        { 146, 170, 91, 23, 10 }, },
      { { 57, 116, 218, 238, 11 },
        { 111, 252, 39, 120, 3 },
        { 215, 117, 178, 233, 12 },
        { 193, 238, 67, 255, 6 }, },
      { { 63, 109, 188, 115, 1 },
        { 135, 143, 166, 125, 13 },
        { 140, 227, 219, 111, 12 },
        { 187, 230, 95, 30, 1 }, },
      { { 61, 107, 192, 80, 12 },
        { 163, 142, 233, 72, 8 },
        { 48, 160, 61, 107, 12 },
        { 17, 41, 119, 28, 5 }, },
      { { 57, 171, 39, 73, 7 },
        { 23, 123, 120, 76, 12 },
        { 233, 46, 77, 89, 12 },
        { 51, 33, 237, 238, 8 }, },
      { { 70, 2, 78, 37, 14 },
        { 168, 81, 79, 133, 0 },
        { 122, 71, 36, 6, 2 },
        { 10, 31, 40, 161, 5 }, },
      { { 70, 130, 186, 11, 12 },
        { 128, 224, 93, 149, 5 },
        { 61, 5, 212, 22, 2 },
        { 170, 155, 160, 112, 1 }, },
      { { 66, 233, 205, 90, 14 },
        { 49, 183, 213, 137, 9 },
        { 117, 171, 57, 116, 2 },
        { 153, 26, 190, 216, 12 }, },
      { { 68, 201, 183, 179, 15 },
        { 148, 215, 211, 148, 15 },
        { 252, 222, 217, 50, 2 },
        { 242, 156, 190, 178, 9 }, },
      { { 64, 199, 212, 30, 9 },
        { 44, 167, 153, 176, 1 },
        { 151, 130, 190, 48, 2 },
        { 128, 217, 158, 83, 4 }, },
      { { 70, 210, 180, 204, 14 },
        { 200, 181, 89, 153, 6 },
        { 115, 50, 212, 182, 2 },
        { 105, 153, 170, 209, 3 }, },
      { { 67, 25, 83, 86, 11 },
        { 124, 82, 129, 217, 9 },
        { 214, 172, 169, 140, 2 },
        { 153, 184, 20, 163, 14 }, },
      { { 65, 34, 230, 221, 9 },
        { 45, 225, 137, 204, 6 },
        { 155, 182, 116, 72, 2 },
        { 99, 57, 24, 123, 4 }, },
      { { 71, 83, 165, 154, 11 },
        { 212, 183, 137, 193, 7 },
        { 213, 154, 92, 174, 2 },
        { 232, 57, 30, 210, 11 }, },
      { { 78, 30, 241, 224, 8 },
        { 242, 128, 11, 185, 14 },
        { 16, 120, 247, 135, 2 },
        { 121, 221, 0, 20, 15 }, },
      { { 78, 74, 192, 150, 0 },
        { 170, 132, 136, 129, 11 },
        { 6, 144, 53, 39, 2 },
        { 216, 17, 18, 21, 5 }, },
      { { 78, 95, 170, 6, 15 },
        { 206, 214, 77, 161, 13 },
        { 246, 5, 95, 167, 2 },
        { 184, 91, 38, 183, 3 }, },
      { { 74, 141, 50, 148, 3 },
        { 14, 82, 144, 177, 14 },
        { 194, 148, 203, 21, 2 },
        { 120, 208, 148, 167, 0 }, },
      { { 73, 21, 148, 179, 9 },
        { 70, 131, 131, 244, 3 },
        { 156, 210, 154, 137, 2 },
        { 194, 252, 28, 22, 2 }, },
      { { 77, 77, 219, 98, 1 },
        { 182, 198, 6, 248, 9 },
        { 132, 109, 187, 43, 2 },
        { 145, 246, 6, 54, 13 }, },
      { { 75, 167, 97, 232, 1 },
        { 55, 34, 26, 233, 6 },
        { 129, 120, 110, 93, 2 },
        { 105, 117, 132, 78, 12 }, },
      { { 73, 212, 131, 216, 14 },
        { 82, 244, 209, 232, 2 },
        { 113, 188, 18, 185, 2 },
        { 65, 120, 178, 244, 10 }, },
      { { 86, 41, 14, 246, 12 },
        { 137, 75, 199, 137, 11 },
        { 54, 247, 9, 70, 10 },
        { 217, 30, 61, 41, 1 }, },
      { { 83, 126, 213, 255, 12 },
        { 121, 173, 203, 253, 11 },
        { 63, 250, 183, 236, 10 },
        { 219, 253, 59, 89, 14 }, },
      { { 85, 245, 167, 175, 10 },
        { 217, 255, 19, 228, 7 },
        { 95, 94, 90, 250, 10 },
        { 226, 124, 143, 249, 11 }, },
      { { 85, 213, 234, 100, 15 },
        { 236, 222, 87, 232, 4 },
        { 242, 101, 122, 186, 10 },
        { 33, 126, 167, 179, 7 }, },
      { { 88, 27, 171, 29, 10 },
        { 90, 250, 141, 132, 12 },
        { 91, 141, 93, 129, 10 },
        { 50, 27, 21, 245, 10 }, },
      { { 94, 190, 146, 109, 13 },
        { 207, 232, 91, 189, 8 },
        { 187, 100, 151, 215, 10 },
        { 27, 221, 161, 127, 3 }, },
      { { 95, 16, 249, 155, 5 },
        { 246, 168, 196, 213, 7 },
        { 173, 153, 240, 143, 10 },
        { 234, 178, 49, 86, 15 }, },
      { { 93, 30, 223, 165, 12 },
        { 250, 201, 79, 244, 10 },
        { 58, 95, 183, 139, 10 },
        { 82, 255, 41, 53, 15 }, },
      { { 95, 113, 141, 240, 2 },
        { 211, 159, 134, 201, 2 },
        { 64, 251, 24, 239, 10 },
        { 73, 54, 31, 156, 11 }, },
      { { 93, 225, 30, 70, 8 },
        { 139, 79, 21, 216, 1 },
        { 22, 39, 136, 123, 10 },
        { 129, 186, 143, 45, 1 }, },
      { { 96, 51, 187, 36, 7 },
        { 93, 210, 110, 144, 4 },
        { 226, 77, 220, 192, 6 },
        { 32, 151, 100, 187, 10 }, },
      { { 100, 88, 26, 254, 1 },
        { 204, 100, 166, 152, 11 },
        { 135, 245, 129, 162, 6 },
        { 209, 150, 82, 99, 3 }, },
      { { 99, 200, 221, 167, 6 },
        { 56, 149, 118, 213, 11 },
        { 110, 91, 177, 60, 6 },
        { 218, 182, 234, 145, 12 }, },
      { { 97, 218, 61, 143, 13 },
        { 92, 37, 125, 212, 15 },
        { 191, 27, 197, 184, 6 },
        { 242, 187, 234, 67, 10 }, },
      { { 110, 58, 34, 175, 10 },
        { 203, 112, 43, 133, 15 },
        { 95, 84, 69, 199, 6 },
        { 250, 29, 64, 237, 3 }, },
      { { 110, 97, 5, 183, 1 },
        { 159, 7, 162, 133, 3 },
        { 142, 218, 8, 103, 6 },
        { 202, 20, 94, 15, 9 }, },
      { { 106, 137, 169, 232, 12 },
        { 18, 162, 119, 137, 14 },
        { 49, 121, 89, 21, 6 },
        { 121, 30, 228, 84, 8 }, },
      { { 106, 151, 34, 79, 5 },
        { 78, 98, 120, 173, 5 },
        { 175, 36, 78, 149, 6 },
        { 171, 81, 228, 103, 2 }, },
      { { 107, 18, 195, 128, 1 },
        { 118, 192, 40, 193, 2 },
        { 128, 28, 52, 141, 6 },
        { 72, 49, 64, 54, 14 }, },
      { { 107, 104, 75, 34, 10 },
        { 51, 84, 39, 193, 9 },
        { 84, 77, 33, 109, 6 },
        { 152, 62, 66, 172, 12 }, },
      { { 111, 148, 193, 87, 9 },
        { 254, 128, 177, 237, 1 },
        { 158, 168, 50, 159, 6 },
        { 139, 120, 208, 23, 15 }, },
      { { 109, 166, 254, 160, 13 },
        { 167, 193, 127, 240, 6 },
        { 176, 87, 246, 91, 6 },
        { 96, 255, 232, 62, 5 }, },
      { { 111, 234, 202, 69, 7 },
        { 175, 212, 124, 205, 8 },
        { 234, 37, 53, 127, 6 },
        { 27, 51, 226, 191, 5 }, },
      { { 112, 61, 56, 166, 0 },
        { 73, 10, 38, 176, 15 },
        { 6, 81, 203, 192, 14 },
        { 240, 214, 69, 9, 2 }, },
      { { 118, 108, 53, 231, 8 },
        { 153, 13, 35, 189, 15 },
        { 30, 122, 195, 102, 14 },
        { 251, 220, 75, 9, 9 }, },
      { { 112, 74, 13, 255, 6 },
        { 24, 61, 238, 140, 11 },
        { 111, 251, 5, 32, 14 },
        { 211, 23, 123, 193, 8 }, },
      { { 117, 120, 169, 200, 0 },
        { 209, 172, 36, 200, 14 },
        { 1, 57, 81, 234, 14 },
        { 113, 50, 67, 88, 11 }, },
      { { 113, 74, 112, 19, 8 },
        { 32, 12, 169, 212, 13 },
        { 28, 128, 229, 40, 14 },
        { 178, 185, 83, 0, 4 }, },
      { { 117, 127, 140, 187, 9 },
        { 197, 175, 175, 228, 11 },
        { 157, 211, 31, 234, 14 },
        { 210, 127, 95, 90, 3 }, },
      { { 124, 35, 104, 51, 1 },
        { 167, 10, 174, 132, 5 },
        { 140, 193, 108, 67, 14 },
        { 162, 23, 85, 14, 5 }, },
      { { 124, 181, 167, 211, 1 },
        { 215, 203, 176, 172, 7 },
        { 140, 190, 90, 211, 14 },
        { 227, 80, 221, 62, 11 }, },
      { { 124, 248, 44, 237, 14 },
        { 203, 61, 119, 140, 14 },
        { 123, 115, 65, 243, 14 },
        { 115, 30, 235, 205, 3 }, },
      { { 127, 36, 226, 52, 15 },
        { 175, 216, 227, 225, 4 },
        { 242, 196, 114, 79, 14 },
        { 40, 124, 113, 191, 5 }, },
      { { 127, 71, 41, 141, 8 },
        { 154, 46, 45, 229, 6 },
        { 27, 25, 78, 47, 14 },
        { 106, 123, 71, 69, 9 }, },
      { { 134, 216, 3, 209, 9 },
        { 212, 68, 145, 15, 10 },
        { 152, 188, 1, 182, 1 },
        { 95, 8, 146, 34, 11 }, },
      { { 131, 139, 27, 161, 3 },
        { 20, 82, 30, 87, 10 },
        { 200, 93, 141, 28, 1 },
        { 94, 167, 132, 162, 8 }, },
      { { 135, 162, 121, 197, 9 },
        { 189, 0, 29, 95, 6 },
        { 154, 57, 228, 94, 1 },
        { 111, 171, 128, 11, 13 }, },
      { { 138, 67, 100, 140, 14 },
        { 42, 55, 73, 3, 6 },
        { 115, 18, 108, 37, 1 },
        { 108, 9, 46, 197, 4 }, },
      { { 136, 147, 59, 76, 8 },
        { 90, 98, 29, 26, 4 },
        { 19, 45, 204, 145, 1 },
        { 37, 139, 132, 101, 10 }, },
      { { 143, 33, 223, 78, 3 },
        { 191, 243, 4, 91, 1 },
        { 199, 47, 184, 79, 1 },
        { 141, 162, 12, 255, 13 }, },
      { { 141, 132, 53, 114, 9 },
        { 150, 1, 147, 122, 5 },
        { 148, 234, 194, 27, 1 },
        { 165, 236, 152, 6, 9 }, },
      { { 141, 136, 215, 31, 13 },
        { 190, 225, 209, 86, 9 },
        { 191, 142, 177, 27, 1 },
        { 150, 168, 184, 119, 13 }, },
      { { 137, 159, 120, 252, 13 },
        { 110, 34, 223, 122, 14 },
        { 179, 241, 239, 153, 1 },
        { 117, 239, 180, 71, 6 }, },
      { { 146, 107, 22, 121, 12 },
        { 1, 111, 203, 31, 8 },
        { 57, 230, 141, 100, 9 },
        { 31, 141, 63, 104, 0 }, },
      { { 148, 142, 34, 241, 2 },
        { 128, 88, 154, 46, 14 },
        { 72, 244, 71, 18, 9 },
        { 119, 69, 145, 160, 1 }, },
      { { 144, 229, 230, 49, 7 },
        { 37, 223, 210, 38, 4 },
        { 232, 198, 122, 112, 9 },
        { 38, 68, 191, 186, 4 }, },
      { { 150, 216, 133, 42, 1 },
        { 212, 173, 18, 3, 9 },
        { 133, 74, 17, 182, 9 },
        { 156, 4, 139, 82, 11 }, },
      { { 149, 57, 59, 164, 6 },
        { 217, 90, 70, 82, 14 },
        { 98, 93, 201, 202, 9 },
        { 116, 166, 37, 169, 11 }, },
      { { 149, 60, 251, 77, 13 },
        { 253, 232, 69, 126, 12 },
        { 187, 45, 243, 202, 9 },
        { 55, 234, 33, 123, 15 }, },
      { { 145, 62, 170, 18, 6 },
        { 65, 216, 204, 98, 13 },
        { 100, 133, 87, 200, 9 },
        { 180, 99, 49, 184, 2 }, },
      { { 151, 111, 90, 175, 9 },
        { 173, 110, 15, 119, 11 },
        { 159, 85, 175, 110, 9 },
        { 222, 239, 7, 107, 5 }, },
      { { 145, 178, 41, 253, 10 },
        { 89, 56, 159, 78, 6 },
        { 91, 249, 68, 216, 9 },
        { 103, 47, 145, 201, 10 }, },
      { { 145, 211, 250, 118, 1 },
        { 108, 206, 158, 90, 5 },
        { 134, 229, 252, 184, 9 },
        { 165, 167, 151, 51, 6 }, },
      { { 154, 112, 134, 200, 8 },
        { 67, 237, 1, 11, 2 },
        { 17, 54, 16, 229, 9 },
        { 77, 8, 11, 124, 2 }, },
      { { 152, 142, 205, 3, 1 },
        { 54, 137, 28, 38, 9 },
        { 140, 11, 55, 17, 9 },
        { 150, 67, 137, 22, 12 }, },
      { { 152, 199, 16, 151, 10 },
        { 10, 30, 153, 54, 3 },
        { 94, 144, 142, 49, 9 },
        { 198, 201, 151, 133, 0 }, },
      { { 157, 203, 235, 70, 6 },
        { 186, 222, 92, 74, 13 },
        { 102, 45, 125, 59, 9 },
        { 181, 35, 167, 181, 13 }, },
      { { 164, 40, 245, 182, 14 },
        { 185, 145, 227, 18, 15 },
        { 118, 218, 241, 66, 5 },
        { 244, 140, 120, 153, 13 }, },
      { { 163, 55, 241, 121, 3 },
        { 117, 178, 170, 127, 4 },
        { 201, 232, 254, 204, 5 },
        { 47, 229, 84, 218, 14 }, },
      { { 163, 68, 64, 245, 10 },
        { 40, 20, 163, 111, 2 },
        { 90, 240, 34, 44, 5 },
        { 79, 108, 82, 129, 4 }, },
      { { 161, 127, 173, 133, 8 },
        { 89, 135, 45, 102, 14 },
        { 26, 27, 95, 232, 5 },
        { 118, 107, 78, 25, 10 }, },
      { { 167, 210, 150, 35, 13 },
        { 196, 197, 123, 87, 1 },
        { 188, 70, 148, 190, 5 },
        { 142, 173, 234, 50, 3 }, },
      { { 168, 69, 112, 43, 11 },
        { 38, 54, 35, 54, 5 },
        { 221, 64, 234, 33, 5 },
        { 166, 204, 70, 198, 4 }, },
      { { 174, 72, 127, 160, 9 },
        { 182, 69, 39, 19, 14 },
        { 144, 95, 225, 39, 5 },
        { 124, 142, 74, 38, 13 }, },
      { { 172, 79, 182, 214, 8 },
        { 138, 199, 169, 58, 15 },
        { 22, 182, 223, 35, 5 },
        { 245, 201, 94, 53, 1 }, },
      { { 168, 168, 211, 133, 3 },
        { 63, 208, 48, 22, 10 },
        { 202, 28, 177, 81, 5 },
        { 86, 128, 192, 191, 12 }, },
      { { 169, 139, 10, 203, 8 },
        { 2, 98, 61, 78, 11 },
        { 29, 53, 13, 25, 5 },
        { 215, 43, 196, 100, 0 }, },
      { { 173, 254, 140, 222, 2 },
        { 203, 181, 188, 106, 11 },
        { 71, 179, 23, 251, 5 },
        { 213, 99, 218, 221, 3 }, },
      { { 180, 239, 46, 46, 14 },
        { 137, 127, 127, 34, 13 },
        { 119, 71, 79, 114, 13 },
        { 180, 79, 239, 233, 1 }, },
      { { 183, 153, 137, 199, 0 },
        { 216, 138, 52, 79, 11 },
        { 14, 57, 25, 158, 13 },
        { 223, 34, 197, 17, 11 }, },
      { { 190, 12, 162, 14, 12 },
        { 138, 232, 97, 35, 13 },
        { 55, 4, 83, 7, 13 },
        { 188, 72, 97, 117, 1 }, },
      { { 188, 112, 34, 122, 9 },
        { 199, 108, 163, 10, 5 },
        { 149, 228, 64, 227, 13 },
        { 165, 12, 83, 110, 3 }, },
      { { 190, 188, 47, 145, 10 },
        { 211, 89, 181, 39, 14 },
        { 88, 159, 67, 215, 13 },
        { 126, 74, 217, 172, 11 }, },
      { { 184, 233, 10, 152, 3 },
        { 7, 126, 180, 2, 10 },
        { 193, 149, 9, 113, 13 },
        { 84, 2, 215, 238, 0 }, },
      { { 189, 10, 48, 236, 8 },
        { 138, 40, 43, 90, 14 },
        { 19, 112, 197, 11, 13 },
        { 117, 173, 65, 69, 1 }, },
      { { 194, 2, 224, 243, 1 },
        { 36, 128, 138, 143, 7 },
        { 140, 240, 116, 4, 3 },
        { 239, 21, 16, 18, 4 }, },
      { { 194, 107, 50, 227, 7 },
        { 5, 86, 74, 159, 15 },
        { 236, 116, 205, 100, 3 },
        { 255, 149, 38, 170, 0 }, },
      { { 198, 202, 66, 106, 8 },
        { 160, 100, 27, 139, 9 },
        { 21, 100, 37, 54, 3 },
        { 157, 29, 130, 96, 5 }, },
      { { 199, 30, 238, 104, 14 },
        { 224, 241, 79, 235, 12 },
        { 113, 103, 119, 142, 3 },
        { 61, 127, 40, 240, 7 }, },
      { { 199, 125, 46, 145, 3 },
        { 197, 87, 132, 231, 14 },
        { 200, 151, 75, 238, 3 },
        { 126, 114, 30, 170, 3 }, },
      { { 206, 60, 32, 116, 2 },
        { 203, 16, 130, 171, 12 },
        { 66, 224, 67, 199, 3 },
        { 61, 84, 16, 141, 3 }, },
      { { 204, 74, 185, 197, 7 },
        { 158, 148, 76, 158, 14 },
        { 234, 57, 213, 35, 3 },
        { 119, 147, 34, 151, 9 }, },
      { { 206, 247, 99, 220, 13 },
        { 255, 102, 217, 171, 6 },
        { 179, 188, 110, 247, 3 },
        { 109, 89, 182, 111, 15 }, },
      { { 205, 67, 34, 202, 2 },
        { 130, 118, 8, 202, 7 },
        { 69, 52, 76, 43, 3 },
        { 229, 49, 6, 228, 1 }, },
      { { 207, 183, 204, 29, 0 },
        { 235, 163, 156, 231, 0 },
        { 11, 131, 62, 223, 3 },
        { 14, 115, 156, 93, 7 }, },
      { { 201, 206, 200, 53, 10 },
        { 42, 148, 159, 230, 8 },
        { 90, 193, 55, 57, 3 },
        { 22, 127, 146, 149, 4 }, },
      { { 207, 243, 75, 113, 3 },
        { 247, 86, 158, 207, 0 },
        { 200, 237, 44, 255, 3 },
        { 15, 55, 150, 174, 15 }, },
      { { 214, 46, 123, 112, 13 },
        { 181, 72, 207, 187, 12 },
        { 176, 237, 231, 70, 11 },
        { 61, 223, 49, 42, 13 }, },
      { { 212, 23, 75, 59, 4 },
        { 240, 106, 206, 166, 1 },
        { 45, 205, 46, 130, 11 },
        { 134, 87, 53, 96, 15 }, },
      { { 215, 141, 250, 151, 14 },
        { 168, 218, 213, 247, 15 },
        { 126, 149, 251, 30, 11 },
        { 254, 250, 181, 177, 5 }, },
      { { 209, 216, 245, 85, 1 },
        { 124, 141, 144, 222, 12 },
        { 138, 170, 241, 184, 11 },
        { 55, 176, 155, 19, 14 }, },
      { { 213, 207, 225, 211, 9 },
        { 180, 142, 153, 238, 15 },
        { 156, 184, 127, 58, 11 },
        { 247, 121, 151, 18, 13 }, },
      { { 218, 22, 168, 204, 9 },
        { 78, 168, 13, 171, 6 },
        { 147, 49, 86, 133, 11 },
        { 109, 91, 1, 87, 2 }, },
      { { 216, 76, 68, 133, 9 },
        { 46, 13, 1, 166, 10 },
        { 154, 18, 35, 33, 11 },
        { 86, 88, 11, 7, 4 }, },
      { { 220, 217, 114, 142, 13 },
        { 238, 110, 81, 146, 15 },
        { 183, 20, 233, 179, 11 },
        { 244, 152, 167, 103, 7 }, },
      { { 223, 103, 17, 126, 8 },
        { 155, 46, 139, 251, 1 },
        { 23, 232, 142, 111, 11 },
        { 141, 253, 23, 77, 9 }, },
      { { 219, 153, 125, 230, 7 },
        { 126, 27, 86, 219, 15 },
        { 230, 123, 233, 157, 11 },
        { 253, 182, 173, 135, 14 }, },
      { { 221, 171, 142, 49, 14 },
        { 131, 219, 223, 198, 8 },
        { 120, 199, 29, 91, 11 },
        { 22, 63, 189, 188, 1 }, },
      { { 224, 25, 8, 76, 13 },
        { 76, 34, 101, 138, 8 },
        { 179, 33, 9, 128, 7 },
        { 21, 26, 100, 67, 2 }, },
      { { 230, 54, 218, 82, 1 },
        { 229, 192, 172, 187, 1 },
        { 132, 165, 182, 198, 7 },
        { 141, 211, 80, 58, 7 }, },
      { { 226, 172, 199, 155, 0 },
        { 49, 225, 176, 167, 11 },
        { 13, 158, 51, 84, 7 },
        { 222, 80, 216, 120, 12 }, },
      { { 228, 141, 33, 98, 0 },
        { 144, 2, 50, 170, 13 },
        { 4, 104, 75, 18, 7 },
        { 181, 84, 196, 0, 9 }, },
      { { 226, 254, 208, 197, 1 },
        { 109, 132, 56, 191, 10 },
        { 138, 48, 183, 244, 7 },
        { 95, 209, 194, 27, 6 }, },
      { { 225, 58, 125, 2, 10 },
        { 113, 17, 45, 210, 13 },
        { 84, 11, 229, 200, 7 },
        { 180, 187, 72, 136, 14 }, },
      { { 231, 208, 91, 142, 5 },
        { 252, 100, 116, 211, 3 },
        { 167, 29, 160, 190, 7 },
        { 204, 178, 226, 99, 15 }, },
      { { 236, 48, 156, 107, 5 },
        { 199, 161, 102, 158, 1 },
        { 173, 99, 144, 195, 7 },
        { 135, 150, 104, 94, 3 }, },
      { { 236, 170, 73, 210, 0 },
        { 179, 0, 188, 138, 11 },
        { 4, 185, 37, 83, 7 },
        { 213, 19, 208, 12, 13 }, },
      { { 238, 179, 122, 196, 6 },
        { 235, 82, 124, 155, 6 },
        { 98, 53, 236, 215, 7 },
        { 109, 147, 228, 173, 7 }, },
      { { 232, 224, 103, 46, 2 },
        { 59, 117, 50, 130, 5 },
        { 71, 78, 96, 113, 7 },
        { 164, 20, 202, 237, 12 }, },
      { { 234, 229, 213, 36, 12 },
        { 59, 135, 115, 179, 0 },
        { 50, 74, 186, 117, 7 },
        { 12, 220, 238, 29, 12 }, },
      { { 237, 107, 28, 44, 2 },
        { 139, 55, 46, 210, 8 },
        { 67, 67, 141, 107, 7 },
        { 20, 183, 78, 205, 1 }, },
      { { 235, 200, 175, 29, 6 },
        { 26, 245, 244, 199, 12 },
        { 107, 143, 81, 61, 7 },
        { 62, 50, 250, 245, 8 }, },
      { { 242, 5, 98, 212, 5 },
        { 44, 74, 224, 171, 6 },
        { 162, 180, 106, 4, 15 },
        { 109, 80, 117, 35, 4 }, },
      { { 246, 25, 188, 251, 2 },
        { 192, 187, 166, 159, 15 },
        { 77, 243, 217, 134, 15 },
        { 255, 150, 93, 208, 3 }, },
      { { 246, 163, 92, 109, 11 },
        { 173, 59, 63, 159, 0 },
        { 219, 99, 172, 86, 15 },
        { 15, 159, 205, 203, 5 }, },
      { { 244, 241, 189, 15, 0 },
        { 217, 175, 52, 150, 5 },
        { 15, 11, 216, 242, 15 },
        { 166, 146, 207, 89, 11 }, },
      { { 241, 106, 155, 67, 5 },
        { 21, 204, 108, 222, 9 },
        { 172, 45, 149, 104, 15 },
        { 151, 179, 99, 58, 8 }, },
      { { 241, 178, 145, 41, 14 },
        { 81, 184, 123, 214, 0 },
        { 121, 72, 148, 216, 15 },
        { 6, 189, 225, 216, 10 }, },
      { { 250, 84, 91, 243, 5 },
        { 118, 76, 230, 191, 3 },
        { 172, 253, 162, 165, 15 },
        { 207, 214, 115, 38, 14 }, },
      { { 254, 110, 134, 124, 6 },
        { 139, 253, 234, 171, 8 },
        { 99, 230, 23, 103, 15 },
        { 29, 85, 123, 253, 1 }, },
      { { 249, 13, 185, 67, 2 },
        { 18, 154, 36, 254, 13 },
        { 76, 41, 219, 9, 15 },
        { 183, 242, 69, 148, 8 }, },
      { { 249, 105, 102, 43, 13 },
        { 39, 111, 99, 198, 13 },
        { 189, 70, 105, 105, 15 },
        { 182, 60, 111, 110, 4 }, },
      { { 251, 65, 203, 72, 4 },
        { 50, 238, 100, 203, 0 },
        { 33, 45, 56, 45, 15 },
        { 13, 50, 103, 116, 12 }, },
      { { 253, 87, 191, 152, 5 },
        { 214, 239, 236, 242, 6 },
        { 161, 159, 222, 171, 15 },
        { 100, 243, 127, 118, 11 }, },
      { { 251, 152, 144, 126, 6 },
        { 74, 184, 242, 219, 9 },
        { 103, 224, 145, 157, 15 },
        { 157, 180, 241, 213, 2 }, },
      { { 255, 234, 33, 198, 3 },
        { 159, 28, 56, 203, 15 },
        { 198, 56, 69, 127, 15 },
        { 253, 49, 195, 143, 9 }, },
      { { 163, 165, 111, 69, 0 },
        { 57, 67, 52, 111, 4 },
        { 10, 47, 106, 92, 5 },
        { 47, 98, 204, 41, 12 }, },
      { { 161, 152, 104, 48, 2 },
        { 96, 16, 182, 66, 12 },
        { 64, 193, 97, 152, 5 },
        { 52, 38, 208, 128, 6 }, },
      { { 15, 55, 131, 43, 0 },
        { 211, 226, 10, 101, 1 },
        { 13, 76, 30, 207, 0 },
        { 138, 101, 4, 124, 11 }, },
      { { 38, 236, 72, 39, 2 },
        { 169, 20, 54, 37, 9 },
        { 78, 65, 35, 118, 4 },
        { 154, 70, 194, 137, 5 }, },
      { { 65, 152, 184, 168, 15 },
        { 68, 176, 87, 208, 14 },
        { 241, 81, 209, 152, 2 },
        { 112, 190, 160, 210, 2 }, },
      { { 78, 181, 67, 138, 4 },
        { 243, 98, 80, 161, 3 },
        { 37, 28, 42, 215, 2 },
        { 200, 80, 164, 108, 15 }, },
      { { 99, 197, 227, 123, 10 },
        { 48, 246, 179, 237, 5 },
        { 93, 236, 122, 60, 6 },
        { 171, 124, 214, 240, 12 }, },
      { { 110, 89, 221, 230, 12 },
        { 250, 135, 103, 153, 11 },
        { 54, 123, 185, 167, 6 },
        { 217, 158, 110, 21, 15 }, },
      { { 128, 212, 89, 240, 8 },
        { 112, 4, 151, 58, 2 },
        { 16, 249, 162, 176, 1 },
        { 69, 206, 146, 0, 14 }, },
      { { 152, 8, 136, 159, 13 },
        { 14, 168, 197, 6, 11 },
        { 191, 145, 17, 1, 9 },
        { 214, 10, 49, 87, 0 }, },
      { { 163, 6, 103, 166, 15 },
        { 60, 81, 107, 99, 7 },
        { 246, 94, 102, 12, 5 },
        { 236, 109, 104, 163, 12 }, },
      { { 2, 25, 166, 20, 7 },
        { 76, 211, 192, 1, 12 },
        { 226, 134, 89, 132, 0 },
        { 56, 0, 60, 179, 2 }, },
      { { 2, 21, 202, 78, 2 },
        { 104, 242, 4, 41, 1 },
        { 71, 37, 58, 132, 0 },
        { 137, 66, 4, 241, 6 }, },
      { { 0, 104, 204, 57, 9 },
        { 37, 165, 135, 4, 8 },
        { 153, 195, 49, 96, 0 },
        { 18, 14, 26, 90, 4 }, },
      { { 0, 161, 19, 254, 8 },
        { 25, 98, 147, 24, 3 },
        { 23, 252, 136, 80, 0 },
        { 193, 140, 148, 105, 8 }, },
      { { 2, 185, 86, 117, 5 },
        { 109, 67, 210, 29, 8 },
        { 170, 230, 169, 212, 0 },
        { 27, 132, 188, 43, 6 }, },
      { { 2, 198, 187, 83, 2 },
        { 16, 212, 156, 61, 5 },
        { 76, 173, 214, 52, 0 },
        { 171, 195, 146, 176, 8 }, },
      { { 2, 243, 31, 29, 9 },
        { 93, 103, 157, 21, 0 },
        { 155, 143, 140, 244, 0 },
        { 10, 139, 158, 107, 10 }, },
      { { 7, 42, 193, 126, 3 },
        { 189, 176, 138, 73, 9 },
        { 199, 232, 53, 78, 0 },
        { 153, 37, 16, 219, 13 }, },
      { { 7, 55, 141, 151, 2 },
        { 217, 147, 140, 101, 3 },
        { 78, 155, 30, 206, 0 },
        { 202, 99, 28, 153, 11 }, },
      { { 1, 111, 31, 231, 5 },
        { 29, 71, 78, 124, 11 },
        { 174, 127, 143, 104, 0 },
        { 211, 231, 46, 43, 8 }, },
      { { 1, 119, 48, 21, 5 },
        { 77, 6, 200, 116, 4 },
        { 170, 128, 206, 232, 0 },
        { 34, 225, 54, 11, 2 }, },
      { { 7, 149, 114, 65, 10 },
        { 224, 82, 17, 125, 4 },
        { 88, 36, 234, 158, 0 },
        { 43, 232, 132, 160, 7 }, },
      { { 7, 200, 163, 134, 14 },
        { 152, 212, 81, 65, 15 },
        { 118, 28, 81, 62, 0 },
        { 248, 40, 162, 177, 9 }, },
      { { 5, 254, 251, 247, 9 },
        { 253, 196, 159, 124, 15 },
        { 158, 253, 247, 250, 0 },
        { 243, 239, 146, 59, 15 }, },
      { { 12, 21, 243, 16, 1 },
        { 246, 194, 128, 48, 4 },
        { 128, 140, 250, 131, 0 },
        { 32, 192, 20, 54, 15 }, },
      { { 10, 68, 98, 226, 14 },
        { 34, 84, 67, 41, 7 },
        { 116, 116, 98, 37, 0 },
        { 233, 76, 34, 164, 4 }, },
      { { 8, 94, 55, 238, 9 },
        { 94, 101, 11, 56, 15 },
        { 151, 126, 199, 161, 0 },
        { 241, 205, 10, 103, 10 }, },
      { { 8, 82, 222, 18, 13 },
        { 102, 197, 205, 16, 1 },
        { 180, 135, 180, 161, 0 },
        { 128, 139, 58, 54, 6 }, },
      { { 12, 102, 136, 3, 9 },
        { 135, 132, 13, 36, 1 },
        { 156, 1, 22, 99, 0 },
        { 130, 75, 2, 30, 1 }, },
      { { 8, 140, 186, 71, 15 },
        { 14, 208, 85, 60, 13 },
        { 254, 37, 211, 17, 0 },
        { 179, 202, 160, 183, 0 }, },
      { { 12, 172, 39, 30, 5 },
        { 159, 97, 208, 32, 13 },
        { 167, 142, 67, 83, 0 },
        { 176, 64, 184, 111, 9 }, },
      { { 8, 179, 56, 11, 15 },
        { 71, 50, 93, 20, 5 },
        { 253, 1, 204, 209, 0 },
        { 162, 139, 164, 206, 2 }, },
      { { 12, 162, 165, 217, 4 },
        { 147, 161, 216, 12, 6 },
        { 41, 186, 84, 83, 0 },
        { 99, 1, 184, 92, 9 }, },
      { { 8, 227, 82, 192, 1 },
        { 39, 70, 24, 24, 2 },
        { 128, 52, 172, 113, 0 },
        { 65, 129, 134, 46, 4 }, },
      { { 14, 255, 68, 245, 14 },
        { 235, 23, 219, 45, 10 },
        { 122, 242, 47, 247, 0 },
        { 91, 77, 190, 141, 7 }, },
      { { 14, 255, 93, 234, 11 },
        { 247, 55, 31, 57, 11 },
        { 213, 123, 175, 247, 0 },
        { 217, 207, 142, 206, 15 }, },
      { { 11, 52, 109, 201, 14 },
        { 115, 49, 69, 109, 6 },
        { 121, 59, 98, 205, 0 },
        { 107, 106, 40, 204, 14 }, },
      { { 13, 9, 254, 187, 3 },
        { 166, 243, 134, 84, 15 },
        { 205, 215, 249, 11, 0 },
        { 242, 166, 28, 246, 5 }, },
      { { 15, 16, 170, 146, 6 },
        { 194, 208, 196, 65, 7 },
        { 100, 149, 80, 143, 0 },
        { 232, 34, 48, 180, 3 }, },
      { { 13, 31, 101, 167, 14 },
        { 250, 19, 75, 100, 15 },
        { 126, 90, 111, 139, 0 },
        { 242, 109, 44, 133, 15 }, },
      { { 15, 177, 95, 160, 0 },
        { 243, 67, 22, 81, 2 },
        { 0, 95, 168, 223, 0 },
        { 72, 166, 140, 44, 15 }, },
      { { 13, 162, 5, 35, 3 },
        { 151, 17, 26, 68, 1 },
        { 204, 74, 4, 91, 0 },
        { 130, 37, 136, 142, 9 }, },
      { { 13, 175, 35, 219, 11 },
        { 151, 114, 153, 108, 15 },
        { 221, 188, 79, 91, 0 },
        { 243, 105, 148, 238, 9 }, },
      { { 11, 240, 165, 238, 4 },
        { 91, 165, 82, 73, 7 },
        { 39, 122, 80, 253, 0 },
        { 233, 36, 170, 93, 10 }, },
      { { 13, 200, 153, 251, 14 },
        { 146, 180, 215, 92, 11 },
        { 125, 249, 145, 59, 0 },
        { 211, 174, 178, 212, 9 }, },
      { { 15, 253, 48, 39, 7 },
        { 207, 22, 82, 117, 13 },
        { 238, 64, 203, 255, 0 },
        { 186, 228, 166, 143, 3 }, },
      { { 11, 199, 93, 86, 2 },
        { 58, 23, 156, 121, 1 },
        { 70, 171, 174, 61, 0 },
        { 137, 227, 158, 133, 12 }, },
      { { 18, 47, 163, 1, 13 },
        { 21, 202, 73, 37, 12 },
        { 184, 12, 95, 68, 8 },
        { 58, 73, 37, 58, 8 }, },
      { { 18, 117, 72, 114, 5 },
        { 101, 14, 198, 41, 1 },
        { 164, 225, 42, 228, 8 },
        { 137, 70, 55, 10, 6 }, },
      { { 16, 79, 174, 98, 7 },
        { 4, 223, 78, 40, 13 },
        { 228, 103, 95, 32, 8 },
        { 177, 71, 47, 178, 0 }, },
      { { 16, 140, 138, 232, 11 },
        { 4, 248, 23, 40, 10 },
        { 209, 117, 19, 16, 8 },
        { 81, 78, 129, 242, 0 }, },
      { { 16, 243, 244, 46, 14 },
        { 105, 191, 91, 16, 5 },
        { 119, 66, 252, 240, 8 },
        { 160, 141, 175, 217, 6 }, },
      { { 19, 55, 238, 112, 2 },
        { 97, 219, 142, 105, 4 },
        { 64, 231, 126, 204, 8 },
        { 41, 103, 29, 184, 6 }, },
      { { 23, 11, 35, 235, 0 },
        { 144, 106, 10, 77, 15 },
        { 13, 124, 77, 14, 8 },
        { 251, 37, 5, 96, 9 }, },
      { { 21, 2, 111, 27, 11 },
        { 180, 121, 141, 68, 5 },
        { 221, 143, 100, 10, 8 },
        { 162, 43, 25, 226, 13 }, },
      { { 17, 161, 171, 203, 2 },
        { 17, 250, 20, 76, 7 },
        { 77, 61, 88, 88, 8 },
        { 227, 34, 133, 248, 8 }, },
      { { 19, 166, 74, 200, 13 },
        { 37, 104, 93, 105, 2 },
        { 177, 53, 38, 92, 8 },
        { 73, 107, 161, 106, 4 }, },
      { { 23, 142, 53, 205, 3 },
        { 156, 57, 24, 125, 14 },
        { 203, 58, 199, 30, 8 },
        { 123, 225, 137, 195, 9 }, },
      { { 21, 139, 229, 157, 12 },
        { 184, 171, 217, 68, 14 },
        { 59, 154, 125, 26, 8 },
        { 114, 41, 189, 81, 13 }, },
      { { 23, 166, 249, 125, 4 },
        { 185, 168, 222, 125, 4 },
        { 43, 233, 246, 94, 8 },
        { 43, 231, 177, 89, 13 }, },
      { { 21, 220, 164, 180, 4 },
        { 200, 141, 210, 96, 14 },
        { 34, 210, 83, 186, 8 },
        { 112, 100, 187, 17, 3 }, },
      { { 17, 223, 5, 67, 12 },
        { 80, 15, 89, 108, 9 },
        { 60, 42, 15, 184, 8 },
        { 147, 105, 175, 0, 10 }, },
      { { 21, 210, 1, 147, 5 },
        { 212, 12, 216, 68, 3 },
        { 172, 152, 4, 186, 8 },
        { 194, 33, 179, 2, 11 }, },
      { { 24, 31, 173, 250, 10 },
        { 82, 187, 143, 40, 15 },
        { 85, 251, 95, 129, 8 },
        { 241, 79, 29, 212, 10 }, },
      { { 28, 64, 14, 171, 13 },
        { 134, 109, 71, 4, 3 },
        { 189, 87, 0, 35, 8 },
        { 194, 14, 43, 102, 1 }, },
      { { 30, 76, 93, 61, 2 },
        { 186, 61, 134, 53, 8 },
        { 75, 203, 163, 39, 8 },
        { 26, 198, 27, 197, 13 }, },
      { { 24, 111, 246, 127, 9 },
        { 47, 239, 139, 60, 13 },
        { 159, 230, 255, 97, 8 },
        { 179, 205, 31, 127, 4 }, },
      { { 24, 87, 52, 184, 15 },
        { 70, 63, 203, 48, 6 },
        { 241, 210, 206, 161, 8 },
        { 96, 205, 63, 198, 2 }, },
      { { 30, 86, 137, 227, 4 },
        { 210, 140, 78, 45, 3 },
        { 44, 121, 22, 167, 8 },
        { 203, 71, 35, 20, 11 }, },
      { { 26, 149, 209, 132, 5 },
        { 126, 138, 80, 49, 2 },
        { 162, 24, 186, 149, 8 },
        { 72, 192, 165, 23, 14 }, },
      { { 24, 167, 255, 2, 10 },
        { 51, 219, 29, 48, 5 },
        { 84, 15, 254, 81, 8 },
        { 160, 203, 141, 188, 12 }, },
      { { 24, 158, 177, 201, 14 },
        { 82, 184, 89, 60, 14 },
        { 121, 56, 215, 145, 8 },
        { 115, 201, 161, 212, 10 }, },
      { { 28, 178, 10, 96, 10 },
        { 195, 88, 31, 8, 0 },
        { 80, 101, 4, 211, 8 },
        { 1, 15, 129, 172, 3 }, },
      { { 28, 146, 53, 136, 1 },
        { 214, 41, 24, 16, 6 },
        { 129, 26, 196, 147, 8 },
        { 96, 129, 137, 70, 11 }, },
      { { 28, 147, 183, 214, 13 },
        { 222, 203, 217, 24, 7 },
        { 182, 190, 220, 147, 8 },
        { 225, 137, 189, 55, 11 }, },
      { { 26, 202, 188, 88, 1 },
        { 6, 173, 156, 25, 12 },
        { 129, 163, 213, 53, 8 },
        { 57, 131, 155, 86, 0 }, },
      { { 28, 226, 172, 181, 8 },
        { 139, 141, 159, 4, 6 },
        { 26, 211, 84, 115, 8 },
        { 98, 15, 155, 29, 1 }, },
      { { 27, 121, 237, 6, 4 },
        { 123, 143, 68, 65, 13 },
        { 38, 11, 121, 237, 8 },
        { 184, 34, 47, 29, 14 }, },
      { { 31, 106, 57, 19, 2 },
        { 147, 28, 140, 85, 13 },
        { 76, 137, 197, 111, 8 },
        { 186, 163, 19, 140, 9 }, },
      { { 29, 152, 56, 117, 0 },
        { 202, 8, 150, 92, 12 },
        { 10, 225, 193, 155, 8 },
        { 51, 166, 145, 5, 3 }, },
      { { 32, 13, 193, 3, 15 },
        { 52, 146, 97, 36, 9 },
        { 252, 8, 59, 0, 4 },
        { 146, 72, 100, 146, 12 }, },
      { { 38, 53, 212, 232, 0 },
        { 225, 163, 34, 57, 2 },
        { 1, 114, 186, 198, 4 },
        { 73, 196, 76, 88, 7 }, },
      { { 38, 117, 44, 47, 8 },
        { 201, 39, 39, 37, 5 },
        { 31, 67, 74, 230, 4 },
        { 170, 78, 78, 73, 3 }, },
      { { 32, 83, 133, 143, 6 },
        { 88, 183, 104, 4, 3 },
        { 111, 26, 28, 160, 4 },
        { 194, 1, 110, 209, 10 }, },
      { { 34, 136, 31, 122, 3 },
        { 20, 113, 182, 25, 9 },
        { 197, 239, 129, 20, 4 },
        { 153, 134, 216, 226, 8 }, },
      { { 39, 44, 250, 229, 5 },
        { 173, 192, 102, 125, 14 },
        { 170, 117, 243, 78, 4 },
        { 123, 230, 96, 59, 5 }, },
      { { 33, 107, 76, 67, 11 },
        { 37, 23, 45, 76, 9 },
        { 220, 35, 45, 104, 4 },
        { 147, 43, 78, 138, 4 }, },
      { { 37, 188, 103, 11, 10 },
        { 241, 113, 49, 100, 13 },
        { 93, 14, 99, 218, 4 },
        { 178, 104, 200, 232, 15 }, },
      { { 33, 163, 233, 176, 14 },
        { 49, 146, 255, 64, 6 },
        { 112, 217, 124, 88, 4 },
        { 96, 47, 244, 152, 12 }, },
      { { 33, 150, 242, 145, 15 },
        { 100, 208, 249, 116, 6 },
        { 248, 148, 246, 152, 4 },
        { 98, 233, 240, 178, 6 }, },
      { { 39, 162, 43, 140, 10 },
        { 153, 112, 61, 65, 6 },
        { 83, 29, 68, 94, 4 },
        { 104, 43, 192, 233, 9 }, },
      { { 39, 159, 72, 50, 8 },
        { 224, 2, 191, 97, 9 },
        { 20, 193, 47, 158, 4 },
        { 152, 111, 212, 0, 7 }, },
      { { 35, 226, 188, 201, 7 },
        { 5, 181, 124, 93, 6 },
        { 233, 51, 212, 124, 4 },
        { 107, 163, 234, 218, 0 }, },
      { { 33, 194, 87, 244, 1 },
        { 60, 69, 186, 88, 2 },
        { 130, 254, 164, 56, 4 },
        { 65, 165, 218, 35, 12 }, },
      { { 39, 207, 186, 248, 11 },
        { 132, 246, 191, 121, 14 },
        { 209, 245, 223, 62, 4 },
        { 121, 239, 214, 242, 1 }, },
      { { 42, 47, 189, 228, 11 },
        { 31, 147, 47, 57, 14 },
        { 210, 123, 223, 69, 4 },
        { 121, 207, 76, 159, 8 }, },
      { { 42, 84, 58, 140, 12 },
        { 74, 100, 101, 49, 6 },
        { 51, 21, 194, 165, 4 },
        { 104, 202, 98, 101, 2 }, },
      { { 42, 209, 187, 151, 15 },
        { 94, 214, 245, 21, 7 },
        { 254, 157, 216, 181, 4 },
        { 234, 138, 246, 183, 10 }, },
      { { 40, 255, 58, 99, 1 },
        { 71, 70, 62, 60, 13 },
        { 140, 101, 207, 241, 4 },
        { 179, 199, 198, 46, 2 }, },
      { { 43, 84, 197, 185, 8 },
        { 114, 165, 163, 101, 2 },
        { 25, 218, 50, 173, 4 },
        { 74, 108, 90, 84, 14 }, },
      { { 45, 97, 175, 26, 10 },
        { 147, 247, 165, 64, 5 },
        { 85, 143, 88, 107, 4 },
        { 160, 42, 94, 252, 9 }, },
      { { 43, 188, 219, 62, 6 },
        { 123, 240, 246, 113, 9 },
        { 103, 205, 179, 221, 4 },
        { 152, 230, 240, 253, 14 }, },
      { { 45, 159, 154, 13, 2 },
        { 202, 242, 60, 116, 8 },
        { 75, 5, 159, 155, 4 },
        { 18, 227, 196, 245, 3 }, },
      { { 47, 187, 114, 106, 3 },
        { 231, 114, 58, 89, 13 },
        { 197, 100, 237, 223, 4 },
        { 185, 165, 196, 238, 7 }, },
      { { 43, 217, 204, 255, 7 },
        { 110, 183, 246, 77, 11 },
        { 239, 243, 57, 189, 4 },
        { 219, 38, 254, 215, 6 }, },
      { { 41, 198, 223, 142, 12 },
        { 58, 229, 125, 112, 3 },
        { 55, 31, 182, 57, 4 },
        { 192, 235, 234, 117, 12 }, },
      { { 52, 12, 63, 195, 5 },
        { 148, 73, 100, 60, 15 },
        { 172, 63, 195, 2, 12 },
        { 243, 194, 105, 34, 9 }, },
      { { 48, 3, 27, 40, 14 },
        { 16, 122, 111, 16, 0 },
        { 113, 77, 140, 0, 12 },
        { 0, 143, 101, 224, 8 }, },
      { { 48, 113, 29, 236, 3 },
        { 93, 63, 38, 24, 2 },
        { 195, 123, 136, 224, 12 },
        { 65, 134, 79, 203, 10 }, },
      { { 52, 76, 222, 162, 10 },
        { 160, 221, 39, 48, 11 },
        { 84, 87, 179, 34, 12 },
        { 208, 206, 75, 176, 5 }, },
      { { 50, 122, 138, 139, 12 },
        { 65, 236, 109, 5, 11 },
        { 61, 21, 21, 228, 12 },
        { 218, 11, 99, 120, 2 }, },
      { { 54, 87, 99, 215, 2 },
        { 248, 94, 168, 45, 7 },
        { 78, 188, 110, 166, 12 },
        { 235, 65, 87, 161, 15 }, },
      { { 52, 141, 50, 170, 6 },
        { 128, 122, 114, 48, 15 },
        { 101, 84, 203, 18, 12 },
        { 240, 196, 229, 224, 1 }, },
      { { 54, 129, 250, 177, 1 },
        { 164, 202, 182, 21, 6 },
        { 136, 213, 248, 22, 12 },
        { 106, 134, 213, 50, 5 }, },
      { { 54, 153, 111, 21, 13 },
        { 252, 75, 245, 5, 12 },
        { 186, 143, 105, 150, 12 },
        { 58, 10, 253, 35, 15 }, },
      { { 50, 204, 108, 49, 14 },
        { 32, 29, 247, 37, 12 },
        { 120, 195, 99, 52, 12 },
        { 58, 78, 251, 128, 4 }, },
      { { 54, 224, 7, 77, 4 },
        { 153, 109, 112, 13, 0 },
        { 43, 46, 0, 118, 12 },
        { 11, 0, 235, 105, 9 }, },
      { { 51, 64, 141, 156, 5 },
        { 28, 173, 228, 65, 2 },
        { 163, 155, 16, 44, 12 },
        { 72, 34, 123, 83, 8 }, },
      { { 51, 125, 174, 182, 10 },
        { 73, 223, 167, 97, 15 },
        { 86, 215, 91, 236, 12 },
        { 248, 110, 95, 185, 2 }, },
      { { 49, 94, 255, 61, 1 },
        { 124, 237, 174, 116, 12 },
        { 139, 207, 247, 168, 12 },
        { 50, 231, 91, 115, 14 }, },
      { { 53, 164, 249, 40, 11 },
        { 181, 184, 55, 112, 4 },
        { 209, 73, 242, 90, 12 },
        { 32, 238, 193, 218, 13 }, },
      { { 51, 134, 161, 198, 4 },
        { 24, 136, 120, 105, 7 },
        { 38, 56, 86, 28, 12 },
        { 233, 97, 225, 17, 8 }, },
      { { 53, 232, 26, 158, 12 },
        { 137, 108, 245, 80, 11 },
        { 55, 149, 129, 122, 12 },
        { 208, 170, 243, 105, 1 }, },
      { { 55, 216, 88, 186, 3 },
        { 228, 60, 182, 81, 11 },
        { 197, 209, 161, 190, 12 },
        { 216, 166, 211, 194, 7 }, },
      { { 56, 21, 51, 89, 12 },
        { 82, 106, 225, 60, 4 },
        { 57, 172, 202, 129, 12 },
        { 35, 200, 117, 100, 10 }, },
      { { 56, 27, 98, 106, 12 },
        { 98, 106, 107, 8, 13 },
        { 53, 100, 109, 129, 12 },
        { 177, 13, 101, 100, 6 }, },
      { { 58, 54, 80, 219, 10 },
        { 99, 56, 169, 61, 3 },
        { 93, 176, 166, 197, 12 },
        { 203, 201, 81, 204, 6 }, },
      { { 56, 136, 209, 242, 9 },
        { 54, 136, 179, 24, 11 },
        { 148, 248, 177, 17, 12 },
        { 209, 140, 209, 22, 12 }, },
      { { 58, 204, 141, 200, 2 },
        { 18, 189, 52, 41, 10 },
        { 65, 59, 19, 53, 12 },
        { 89, 66, 203, 212, 8 }, },
      { { 60, 252, 249, 7, 11 },
        { 255, 156, 53, 52, 13 },
        { 222, 9, 243, 243, 12 },
        { 178, 202, 195, 159, 15 }, },
      { { 60, 246, 137, 57, 12 },
        { 211, 172, 255, 36, 0 },
        { 57, 201, 22, 243, 12 },
        { 2, 79, 243, 92, 11 }, },
      { { 59, 15, 174, 199, 9 },
        { 14, 203, 45, 109, 15 },
        { 158, 55, 95, 13, 12 },
        { 251, 107, 77, 55, 0 }, },
      { { 61, 11, 95, 245, 6 },
        { 186, 91, 238, 92, 10 },
        { 106, 255, 173, 11, 12 },
        { 83, 167, 125, 165, 13 }, },
      { { 57, 73, 131, 170, 6 },
        { 18, 254, 98, 64, 11 },
        { 101, 92, 25, 41, 12 },
        { 208, 36, 103, 244, 8 }, },
      { { 61, 92, 175, 229, 6 },
        { 218, 221, 102, 108, 14 },
        { 106, 127, 83, 171, 12 },
        { 115, 102, 107, 181, 11 }, },
      { { 59, 111, 209, 254, 2 },
        { 59, 190, 170, 121, 11 },
        { 71, 248, 191, 109, 12 },
        { 217, 229, 87, 221, 12 }, },
      { { 61, 114, 229, 206, 7 },
        { 255, 189, 104, 72, 7 },
        { 231, 58, 116, 235, 12 },
        { 225, 33, 107, 223, 15 }, },
      { { 59, 165, 24, 48, 4 },
        { 3, 10, 246, 113, 0 },
        { 32, 193, 138, 93, 12 },
        { 8, 230, 245, 12, 0 }, },
      { { 59, 215, 215, 116, 14 },
        { 122, 223, 251, 121, 0 },
        { 114, 238, 190, 189, 12 },
        { 9, 237, 255, 181, 14 }, },
      { { 66, 21, 7, 134, 1 },
        { 92, 67, 0, 161, 3 },
        { 134, 30, 10, 132, 2 },
        { 200, 80, 12, 35, 10 }, },
      { { 68, 42, 51, 204, 5 },
        { 157, 96, 72, 152, 14 },
        { 163, 60, 197, 66, 2 },
        { 113, 145, 32, 107, 9 }, },
      { { 64, 105, 62, 32, 12 },
        { 1, 71, 71, 144, 12 },
        { 48, 71, 201, 96, 2 },
        { 48, 158, 46, 40, 0 }, },
      { { 68, 76, 84, 241, 12 },
        { 160, 5, 195, 188, 10 },
        { 56, 242, 163, 34, 2 },
        { 83, 220, 58, 0, 5 }, },
      { { 64, 78, 207, 5, 5 },
        { 60, 197, 76, 164, 8 },
        { 170, 15, 55, 32, 2 },
        { 18, 83, 42, 51, 12 }, },
      { { 64, 223, 74, 196, 6 },
        { 104, 86, 92, 168, 10 },
        { 98, 53, 47, 176, 2 },
        { 81, 83, 166, 161, 6 }, },
      { { 70, 218, 103, 26, 14 },
        { 240, 117, 217, 129, 13 },
        { 117, 142, 101, 182, 2 },
        { 184, 25, 186, 224, 15 }, },
      { { 67, 32, 239, 178, 13 },
        { 53, 193, 199, 193, 7 },
        { 180, 223, 112, 76, 2 },
        { 232, 62, 56, 58, 12 }, },
      { { 65, 99, 121, 242, 7 },
        { 53, 22, 206, 216, 7 },
        { 228, 249, 236, 104, 2 },
        { 225, 183, 54, 138, 12 }, },
      { { 71, 127, 169, 44, 10 },
        { 217, 182, 15, 225, 12 },
        { 83, 73, 95, 238, 2 },
        { 56, 127, 6, 217, 11 }, },
      { { 67, 168, 36, 115, 10 },
        { 1, 17, 147, 205, 13 },
        { 92, 226, 65, 92, 2 },
        { 187, 60, 152, 136, 0 }, },
      { { 69, 174, 2, 166, 1 },
        { 141, 64, 26, 224, 11 },
        { 134, 84, 7, 90, 2 },
        { 208, 117, 128, 43, 1 }, },
      { { 72, 29, 125, 107, 6 },
        { 114, 51, 70, 188, 13 },
        { 109, 107, 235, 129, 2 },
        { 179, 214, 44, 196, 14 }, },
      { { 72, 68, 41, 14, 4 },
        { 26, 36, 68, 160, 5 },
        { 39, 9, 66, 33, 2 },
        { 160, 82, 34, 69, 8 }, },
      { { 76, 93, 176, 242, 6 },
        { 194, 150, 194, 184, 15 },
        { 100, 240, 219, 163, 2 },
        { 241, 212, 54, 148, 3 }, },
      { { 72, 79, 166, 76, 0 },
        { 10, 231, 8, 168, 12 },
        { 3, 38, 95, 33, 2 },
        { 49, 81, 14, 117, 0 }, },
      { { 72, 129, 242, 45, 11 },
        { 46, 242, 19, 148, 4 },
        { 219, 68, 248, 17, 2 },
        { 34, 156, 132, 247, 4 }, },
      { { 72, 140, 105, 154, 11 },
        { 54, 48, 149, 160, 15 },
        { 213, 153, 99, 17, 2 },
        { 240, 90, 144, 198, 12 }, },
      { { 76, 230, 39, 197, 2 },
        { 155, 85, 24, 172, 6 },
        { 74, 62, 70, 115, 2 },
        { 99, 81, 138, 173, 9 }, },
      { { 79, 61, 163, 205, 7 },
        { 223, 242, 64, 237, 14 },
        { 235, 60, 91, 207, 2 },
        { 123, 112, 36, 255, 11 }, },
      { { 73, 73, 253, 184, 8 },
        { 50, 167, 135, 208, 14 },
        { 17, 219, 249, 41, 2 },
        { 112, 190, 30, 84, 12 }, },
      { { 77, 89, 111, 25, 7 },
        { 246, 119, 196, 196, 12 },
        { 233, 143, 105, 171, 2 },
        { 50, 50, 62, 230, 15 }, },
      { { 79, 79, 213, 39, 11 },
        { 190, 151, 11, 245, 9 },
        { 222, 74, 191, 47, 2 },
        { 154, 253, 14, 151, 13 }, },
      { { 75, 148, 100, 228, 11 },
        { 110, 17, 19, 233, 6 },
        { 210, 114, 98, 157, 2 },
        { 105, 124, 136, 135, 6 }, },
      { { 77, 160, 106, 169, 14 },
        { 163, 112, 87, 196, 6 },
        { 121, 85, 96, 91, 2 },
        { 98, 62, 160, 236, 5 }, },
      { { 75, 146, 209, 251, 2 },
        { 114, 176, 154, 221, 3 },
        { 77, 248, 180, 157, 2 },
        { 203, 181, 144, 212, 14 }, },
      { { 79, 237, 128, 190, 11 },
        { 143, 182, 147, 225, 11 },
        { 215, 208, 27, 127, 2 },
        { 216, 124, 150, 223, 1 }, },
      { { 73, 250, 110, 175, 3 },
        { 111, 117, 30, 196, 15 },
        { 207, 87, 101, 249, 2 },
        { 242, 55, 138, 239, 6 }, },
      { { 84, 32, 172, 167, 7 },
        { 141, 153, 70, 132, 7 },
        { 238, 83, 80, 66, 10 },
        { 226, 22, 41, 155, 1 }, },
      { { 84, 25, 164, 142, 8 },
        { 200, 171, 1, 128, 15 },
        { 23, 18, 89, 130, 10 },
        { 240, 24, 13, 81, 3 }, },
      { { 86, 116, 218, 31, 8 },
        { 233, 236, 133, 181, 1 },
        { 31, 133, 178, 230, 10 },
        { 138, 218, 19, 121, 7 }, },
      { { 82, 70, 69, 212, 11 },
        { 60, 29, 137, 169, 2 },
        { 210, 186, 38, 36, 10 },
        { 73, 89, 27, 131, 12 }, },
      { { 80, 153, 112, 192, 3 },
        { 100, 26, 16, 152, 14 },
        { 192, 48, 233, 144, 10 },
        { 113, 144, 133, 130, 6 }, },
      { { 82, 162, 196, 106, 5 },
        { 37, 169, 90, 137, 1 },
        { 165, 98, 52, 84, 10 },
        { 137, 21, 169, 90, 4 }, },
      { { 80, 232, 170, 66, 4 },
        { 1, 204, 84, 136, 13 },
        { 36, 37, 81, 112, 10 },
        { 177, 18, 163, 56, 0 }, },
      { { 82, 242, 173, 89, 8 },
        { 81, 173, 157, 141, 4 },
        { 25, 171, 84, 244, 10 },
        { 43, 27, 155, 88, 10 }, },
      { { 82, 218, 235, 246, 10 },
        { 120, 220, 159, 137, 15 },
        { 86, 253, 117, 180, 10 },
        { 249, 31, 147, 177, 14 }, },
      { { 85, 46, 248, 226, 2 },
        { 161, 152, 14, 248, 15 },
        { 68, 113, 247, 74, 10 },
        { 241, 247, 1, 152, 5 }, },
      { { 81, 65, 96, 182, 2 },
        { 40, 30, 130, 192, 7 },
        { 70, 208, 104, 40, 10 },
        { 224, 52, 23, 129, 4 }, },
      { { 85, 104, 6, 21, 8 },
        { 137, 77, 129, 196, 8 },
        { 26, 134, 1, 106, 10 },
        { 18, 56, 27, 41, 1 }, },
      { { 83, 74, 126, 75, 13 },
        { 36, 109, 77, 221, 13 },
        { 189, 39, 229, 44, 10 },
        { 187, 187, 43, 98, 4 }, },
      { { 83, 107, 211, 224, 11 },
        { 53, 222, 11, 217, 10 },
        { 208, 124, 189, 108, 10 },
        { 89, 189, 7, 186, 12 }, },
      { { 87, 114, 130, 210, 7 },
        { 197, 220, 200, 201, 3 },
        { 228, 180, 20, 238, 10 },
        { 201, 49, 51, 186, 3 }, },
      { { 87, 129, 213, 88, 2 },
        { 176, 187, 144, 217, 0 },
        { 65, 170, 184, 30, 10 },
        { 9, 176, 157, 208, 13 }, },
      { { 87, 164, 195, 74, 8 },
        { 177, 232, 17, 233, 1 },
        { 21, 44, 50, 94, 10 },
        { 137, 120, 129, 120, 13 }, },
      { { 81, 151, 175, 148, 8 },
        { 88, 203, 157, 224, 6 },
        { 18, 159, 94, 152, 10 },
        { 96, 123, 157, 49, 10 }, },
      { { 87, 143, 23, 115, 11 },
        { 148, 91, 155, 253, 9 },
        { 220, 238, 143, 30, 10 },
        { 155, 253, 157, 162, 9 }, },
      { { 85, 194, 224, 207, 0 },
        { 168, 172, 24, 204, 7 },
        { 15, 48, 116, 58, 10 },
        { 227, 49, 131, 81, 5 }, },
      { { 87, 246, 164, 229, 1 },
        { 205, 141, 26, 237, 6 },
        { 138, 114, 86, 254, 10 },
        { 107, 117, 139, 27, 3 }, },
      { { 92, 5, 94, 2, 5 },
        { 166, 75, 68, 176, 1 },
        { 164, 7, 170, 3, 10 },
        { 128, 210, 45, 38, 5 }, },
      { { 94, 56, 204, 77, 0 },
        { 235, 169, 4, 141, 8 },
        { 11, 35, 49, 199, 10 },
        { 27, 18, 9, 93, 7 }, },
      { { 94, 101, 102, 31, 5 },
        { 175, 111, 192, 165, 5 },
        { 175, 134, 106, 103, 10 },
        { 170, 80, 63, 111, 5 }, },
      { { 90, 165, 235, 123, 5 },
        { 55, 234, 214, 173, 5 },
        { 173, 237, 122, 85, 10 },
        { 171, 86, 181, 126, 12 }, },
      { { 94, 173, 81, 224, 13 },
        { 183, 10, 83, 185, 10 },
        { 176, 120, 171, 87, 10 },
        { 89, 220, 165, 14, 13 }, },
      { { 88, 179, 133, 252, 1 },
        { 95, 171, 154, 136, 2 },
        { 131, 250, 28, 209, 10 },
        { 65, 21, 157, 95, 10 }, },
      { { 90, 197, 248, 110, 0 },
        { 42, 174, 22, 185, 5 },
        { 7, 97, 250, 53, 10 },
        { 169, 214, 135, 85, 4 }, },
      { { 88, 241, 107, 96, 0 },
        { 115, 78, 22, 136, 4 },
        { 0, 109, 104, 241, 10 },
        { 33, 22, 135, 44, 14 }, },
      { { 91, 48, 177, 32, 8 },
        { 83, 136, 3, 209, 4 },
        { 16, 72, 208, 205, 10 },
        { 40, 188, 1, 28, 10 }, },
      { { 95, 52, 239, 231, 11 },
        { 255, 217, 7, 237, 7 },
        { 222, 127, 114, 207, 10 },
        { 235, 126, 9, 191, 15 }, },
      { { 89, 64, 115, 102, 9 },
        { 62, 76, 3, 216, 5 },
        { 150, 108, 224, 41, 10 },
        { 161, 188, 3, 39, 12 }, },
      { { 93, 105, 19, 173, 1 },
        { 159, 110, 2, 212, 10 },
        { 139, 92, 137, 107, 10 },
        { 82, 180, 7, 111, 9 }, },
      { { 89, 82, 185, 227, 11 },
        { 86, 156, 15, 220, 7 },
        { 220, 121, 212, 169, 10 },
        { 227, 191, 3, 150, 10 }, },
      { { 93, 70, 244, 172, 2 },
        { 170, 189, 10, 240, 6 },
        { 67, 82, 246, 43, 10 },
        { 96, 245, 11, 213, 5 }, },
      { { 95, 128, 157, 46, 8 },
        { 154, 169, 23, 209, 1 },
        { 23, 75, 144, 31, 10 },
        { 136, 190, 137, 85, 9 }, },
      { { 95, 224, 251, 80, 14 },
        { 179, 220, 213, 217, 4 },
        { 112, 173, 240, 127, 10 },
        { 41, 186, 179, 188, 13 }, },
      { { 95, 235, 211, 215, 0 },
        { 187, 206, 152, 221, 11 },
        { 14, 188, 189, 127, 10 },
        { 219, 177, 151, 61, 13 }, },
      { { 100, 105, 134, 115, 5 },
        { 133, 199, 226, 140, 9 },
        { 172, 230, 25, 98, 6 },
        { 147, 20, 126, 58, 1 }, },
      { { 96, 188, 232, 205, 8 },
        { 105, 160, 53, 172, 14 },
        { 27, 49, 115, 208, 6 },
        { 115, 90, 192, 89, 6 }, },
      { { 100, 158, 227, 5, 6 },
        { 248, 208, 120, 164, 12 },
        { 106, 12, 119, 146, 6 },
        { 50, 81, 224, 177, 15 }, },
      { { 98, 212, 165, 37, 13 },
        { 92, 133, 115, 165, 4 },
        { 186, 74, 82, 180, 6 },
        { 42, 92, 234, 19, 10 }, },
      { { 98, 246, 143, 142, 3 },
        { 93, 245, 60, 161, 3 },
        { 199, 31, 22, 244, 6 },
        { 200, 83, 202, 251, 10 }, },
      { { 101, 96, 72, 36, 7 },
        { 173, 20, 102, 192, 0 },
        { 226, 65, 32, 106, 6 },
        { 0, 54, 98, 139, 5 }, },
      { { 99, 180, 12, 145, 8 },
        { 65, 1, 181, 229, 2 },
        { 24, 147, 2, 220, 6 },
        { 74, 122, 216, 8, 2 }, },
      { { 99, 159, 233, 153, 13 },
        { 116, 162, 253, 229, 14 },
        { 185, 153, 127, 156, 6 },
        { 122, 123, 244, 82, 14 }, },
      { { 101, 237, 229, 156, 7 },
        { 189, 183, 240, 224, 14 },
        { 227, 154, 123, 122, 6 },
        { 112, 112, 254, 219, 13 }, },
      { { 103, 235, 231, 112, 4 },
        { 177, 199, 250, 201, 12 },
        { 32, 238, 125, 126, 6 },
        { 57, 53, 254, 56, 13 }, },
      { { 106, 1, 200, 157, 4 },
        { 42, 162, 228, 133, 2 },
        { 43, 145, 56, 5, 6 },
        { 74, 18, 116, 85, 4 }, },
      { { 104, 61, 242, 11, 0 },
        { 99, 226, 32, 180, 13 },
        { 13, 4, 251, 193, 6 },
        { 178, 208, 68, 124, 6 }, },
      { { 104, 24, 102, 125, 13 },
        { 110, 97, 227, 140, 12 },
        { 187, 230, 97, 129, 6 },
        { 51, 28, 120, 103, 6 }, },
      { { 108, 84, 97, 80, 15 },
        { 246, 20, 225, 168, 4 },
        { 240, 168, 98, 163, 6 },
        { 33, 88, 114, 134, 15 }, },
      { { 104, 75, 24, 245, 13 },
        { 14, 6, 239, 156, 10 },
        { 186, 241, 141, 33, 6 },
        { 83, 159, 118, 7, 0 }, },
      { { 104, 79, 21, 129, 0 },
        { 18, 7, 40, 180, 10 },
        { 8, 26, 143, 33, 6 },
        { 82, 209, 78, 4, 8 }, },
      { { 110, 110, 244, 89, 0 },
        { 163, 165, 168, 189, 12 },
        { 9, 162, 247, 103, 6 },
        { 59, 209, 90, 92, 5 }, },
      { { 110, 152, 128, 38, 5 },
        { 206, 128, 114, 129, 9 },
        { 166, 64, 17, 151, 6 },
        { 152, 20, 224, 23, 3 }, },
      { { 110, 144, 99, 51, 3 },
        { 246, 80, 178, 133, 5 },
        { 204, 204, 96, 151, 6 },
        { 170, 20, 208, 166, 15 }, },
      { { 110, 241, 228, 10, 7 },
        { 231, 183, 112, 129, 5 },
        { 229, 2, 120, 247, 6 },
        { 168, 16, 238, 222, 7 }, },
      { { 108, 195, 36, 252, 0 },
        { 138, 39, 186, 136, 6 },
        { 3, 242, 76, 51, 6 },
        { 97, 21, 222, 69, 1 }, },
      { { 105, 0, 81, 91, 15 },
        { 54, 48, 225, 220, 1 },
        { 253, 168, 160, 9, 6 },
        { 131, 184, 112, 198, 12 }, },
      { { 107, 64, 14, 250, 12 },
        { 2, 101, 231, 201, 3 },
        { 53, 247, 0, 45, 6 },
        { 201, 62, 122, 100, 0 }, },
      { { 107, 124, 181, 68, 7 },
        { 95, 149, 96, 249, 12 },
        { 226, 42, 211, 237, 6 },
        { 57, 240, 106, 159, 10 }, },
      { { 105, 172, 245, 202, 2 },
        { 51, 177, 48, 248, 15 },
        { 69, 58, 243, 89, 6 },
        { 241, 240, 200, 220, 12 }, },
      { { 105, 167, 102, 247, 12 },
        { 43, 67, 251, 236, 7 },
        { 62, 246, 110, 89, 6 },
        { 227, 125, 252, 45, 4 }, },
      { { 109, 235, 50, 140, 11 },
        { 143, 118, 57, 208, 14 },
        { 211, 20, 205, 123, 6 },
        { 112, 185, 198, 239, 1 }, },
      { { 116, 23, 252, 110, 12 },
        { 232, 171, 111, 184, 5 },
        { 55, 99, 254, 130, 14 },
        { 161, 223, 109, 81, 7 }, },
      { { 112, 97, 170, 185, 4 },
        { 1, 238, 230, 132, 6 },
        { 41, 213, 88, 96, 14 },
        { 98, 22, 119, 120, 0 }, },
      { { 116, 67, 17, 82, 1 },
        { 148, 14, 168, 152, 1 },
        { 132, 168, 140, 34, 14 },
        { 129, 145, 87, 2, 9 }, },
      { { 112, 185, 187, 138, 9 },
        { 85, 234, 53, 144, 15 },
        { 149, 29, 217, 208, 14 },
        { 240, 154, 197, 122, 10 }, },
      { { 118, 148, 62, 229, 4 },
        { 200, 73, 118, 189, 6 },
        { 42, 119, 194, 150, 14 },
        { 107, 214, 233, 33, 3 }, },
      { { 118, 188, 96, 18, 9 },
        { 229, 8, 177, 161, 13 },
        { 148, 128, 99, 214, 14 },
        { 184, 88, 209, 10, 7 }, },
      { { 112, 155, 7, 165, 4 },
        { 88, 75, 122, 132, 10 },
        { 42, 94, 13, 144, 14 },
        { 82, 21, 237, 33, 10 }, },
      { { 116, 139, 191, 1, 3 },
        { 148, 219, 60, 148, 12 },
        { 200, 15, 221, 18, 14 },
        { 50, 147, 205, 178, 9 }, },
      { { 114, 248, 93, 79, 11 },
        { 125, 61, 53, 157, 9 },
        { 223, 43, 161, 244, 14 },
        { 155, 154, 203, 203, 14 }, },
      { { 118, 211, 218, 167, 15 },
        { 236, 222, 127, 149, 3 },
        { 254, 85, 188, 182, 14 },
        { 202, 159, 231, 179, 7 }, },
      { { 117, 36, 208, 249, 9 },
        { 165, 168, 163, 252, 2 },
        { 153, 240, 178, 74, 14 },
        { 67, 252, 81, 90, 5 }, },
      { { 117, 60, 188, 48, 6 },
        { 193, 153, 230, 240, 12 },
        { 96, 195, 211, 202, 14 },
        { 48, 246, 121, 152, 3 }, },
      { { 119, 3, 201, 213, 15 },
        { 188, 154, 237, 205, 2 },
        { 250, 185, 60, 14, 14 },
        { 75, 59, 117, 147, 13 }, },
      { { 113, 69, 59, 42, 5 },
        { 20, 110, 102, 240, 5 },
        { 165, 77, 202, 40, 14 },
        { 160, 246, 103, 98, 8 }, },
      { { 115, 108, 25, 223, 1 },
        { 29, 44, 164, 253, 11 },
        { 143, 185, 131, 108, 14 },
        { 219, 242, 83, 75, 8 }, },
      { { 113, 72, 238, 44, 10 },
        { 40, 253, 39, 192, 12 },
        { 83, 71, 113, 40, 14 },
        { 48, 62, 75, 241, 4 }, },
      { { 115, 111, 34, 124, 0 },
        { 9, 110, 170, 233, 12 },
        { 3, 228, 79, 108, 14 },
        { 57, 117, 87, 105, 0 }, },
      { { 115, 145, 99, 174, 14 },
        { 120, 122, 115, 193, 7 },
        { 119, 92, 104, 156, 14 },
        { 232, 60, 229, 225, 14 }, },
      { { 117, 131, 158, 142, 9 },
        { 140, 235, 61, 208, 3 },
        { 151, 23, 156, 26, 14 },
        { 192, 187, 205, 115, 1 }, },
      { { 119, 191, 100, 123, 6 },
        { 225, 59, 250, 237, 13 },
        { 109, 226, 111, 222, 14 },
        { 187, 117, 253, 200, 7 }, },
      { { 115, 229, 189, 18, 10 },
        { 17, 159, 181, 241, 5 },
        { 84, 139, 218, 124, 14 },
        { 168, 250, 223, 152, 8 }, },
      { { 115, 207, 104, 128, 3 },
        { 36, 30, 60, 225, 14 },
        { 192, 17, 111, 60, 14 },
        { 120, 115, 199, 130, 4 }, },
      { { 113, 247, 74, 10, 0 },
        { 97, 110, 60, 224, 1 },
        { 5, 5, 46, 248, 14 },
        { 128, 115, 199, 104, 6 }, },
      { { 120, 45, 207, 39, 6 },
        { 59, 219, 102, 164, 9 },
        { 110, 79, 59, 65, 14 },
        { 146, 86, 109, 189, 12 }, },
      { { 124, 2, 58, 157, 7 },
        { 142, 120, 236, 148, 6 },
        { 235, 149, 196, 3, 14 },
        { 98, 147, 113, 231, 1 }, },
      { { 122, 92, 206, 58, 4 },
        { 98, 237, 230, 161, 9 },
        { 37, 199, 51, 165, 14 },
        { 152, 86, 123, 116, 6 }, },
      { { 122, 114, 16, 7, 7 },
        { 79, 28, 104, 149, 1 },
        { 238, 0, 132, 229, 14 },
        { 138, 145, 99, 143, 2 }, },
      { { 126, 178, 36, 208, 11 },
        { 199, 25, 185, 137, 6 },
        { 208, 178, 68, 215, 14 },
        { 105, 25, 217, 142, 3 }, },
      { { 120, 253, 197, 213, 2 },
        { 123, 159, 176, 172, 10 },
        { 74, 186, 59, 241, 14 },
        { 83, 80, 223, 157, 14 }, },
      { { 126, 232, 117, 158, 9 },
        { 191, 45, 177, 145, 15 },
        { 151, 154, 225, 119, 14 },
        { 248, 152, 219, 79, 13 }, },
      { { 123, 28, 43, 68, 14 },
        { 90, 88, 101, 233, 12 },
        { 114, 45, 67, 141, 14 },
        { 57, 122, 97, 165, 10 }, },
      { { 127, 4, 160, 250, 2 },
        { 130, 184, 162, 233, 7 },
        { 69, 240, 82, 15, 14 },
        { 233, 116, 81, 212, 1 }, },
      { { 123, 39, 78, 235, 3 },
        { 39, 123, 46, 237, 3 },
        { 205, 119, 46, 77, 14 },
        { 203, 119, 77, 238, 4 }, },
      { { 125, 38, 127, 122, 1 },
        { 183, 105, 174, 248, 5 },
        { 133, 239, 230, 75, 14 },
        { 161, 247, 89, 110, 13 }, },
      { { 127, 50, 169, 94, 10 },
        { 219, 184, 173, 201, 5 },
        { 87, 169, 84, 207, 14 },
        { 169, 59, 81, 221, 11 }, },
      { { 121, 180, 170, 170, 7 },
        { 71, 248, 118, 224, 7 },
        { 229, 85, 82, 217, 14 },
        { 224, 118, 225, 254, 2 }, },
      { { 125, 176, 215, 37, 3 },
        { 255, 217, 50, 212, 0 },
        { 202, 78, 176, 219, 14 },
        { 2, 180, 201, 191, 15 }, },
      { { 127, 147, 79, 12, 2 },
        { 250, 123, 60, 193, 0 },
        { 67, 15, 44, 159, 14 },
        { 8, 51, 205, 229, 15 }, },
      { { 125, 252, 16, 66, 2 },
        { 195, 28, 48, 248, 9 },
        { 68, 32, 131, 251, 14 },
        { 145, 240, 195, 140, 3 }, },
      { { 125, 213, 216, 211, 15 },
        { 230, 158, 245, 252, 3 },
        { 252, 177, 186, 187, 14 },
        { 195, 250, 247, 150, 7 }, },
      { { 128, 56, 32, 103, 11 },
        { 77, 16, 3, 14, 13 },
        { 222, 96, 65, 192, 1 },
        { 183, 12, 0, 139, 2 }, },
      { { 132, 17, 185, 214, 3 },
        { 220, 146, 132, 26, 7 },
        { 198, 185, 216, 130, 1 },
        { 229, 130, 20, 147, 11 }, },
      { { 128, 3, 252, 100, 10 },
        { 40, 147, 15, 26, 4 },
        { 82, 99, 252, 0, 1 },
        { 37, 143, 12, 145, 4 }, },
      { { 130, 59, 15, 187, 10 },
        { 81, 115, 143, 7, 11 },
        { 93, 223, 13, 196, 1 },
        { 222, 15, 28, 232, 10 }, },
      { { 134, 42, 167, 117, 10 },
        { 153, 209, 139, 15, 12 },
        { 90, 238, 85, 70, 1 },
        { 63, 13, 24, 185, 9 }, },
      { { 132, 27, 89, 75, 7 },
        { 244, 50, 76, 30, 9 },
        { 237, 41, 173, 130, 1 },
        { 151, 131, 36, 194, 15 }, },
      { { 130, 68, 49, 200, 10 },
        { 16, 52, 1, 59, 6 },
        { 81, 56, 194, 36, 1 },
        { 109, 200, 2, 192, 8 }, },
      { { 130, 89, 216, 117, 3 },
        { 108, 150, 134, 31, 8 },
        { 202, 225, 185, 164, 1 },
        { 31, 134, 22, 147, 6 }, },
      { { 132, 72, 31, 220, 14 },
        { 152, 117, 197, 26, 10 },
        { 115, 191, 129, 34, 1 },
        { 85, 138, 58, 225, 9 }, },
      { { 130, 181, 229, 107, 4 },
        { 113, 163, 82, 47, 5 },
        { 45, 106, 122, 212, 1 },
        { 175, 68, 172, 88, 14 }, },
      { { 128, 183, 10, 183, 0 },
        { 73, 66, 158, 38, 3 },
        { 14, 213, 14, 208, 1 },
        { 198, 71, 148, 41, 2 }, },
      { { 134, 178, 80, 25, 10 },
        { 225, 48, 153, 23, 0 },
        { 89, 128, 164, 214, 1 },
        { 14, 137, 144, 200, 7 }, },
      { { 128, 204, 47, 123, 8 },
        { 16, 101, 151, 46, 13 },
        { 29, 239, 67, 48, 1 },
        { 183, 78, 154, 96, 8 }, },
      { { 134, 253, 182, 100, 8 },
        { 201, 199, 19, 59, 12 },
        { 18, 102, 219, 246, 1 },
        { 61, 204, 142, 57, 3 }, },
      { { 129, 121, 60, 62, 9 },
        { 77, 39, 135, 82, 13 },
        { 151, 195, 201, 232, 1 },
        { 180, 174, 30, 75, 2 }, },
      { { 133, 96, 132, 133, 11 },
        { 141, 149, 1, 70, 2 },
        { 218, 18, 16, 106, 1 },
        { 70, 40, 10, 155, 1 }, },
      { { 131, 98, 22, 146, 5 },
        { 5, 69, 200, 83, 3 },
        { 164, 150, 132, 108, 1 },
        { 204, 161, 58, 42, 0 }, },
      { { 131, 128, 229, 221, 15 },
        { 60, 177, 209, 79, 6 },
        { 251, 186, 112, 28, 1 },
        { 111, 40, 184, 211, 12 }, },
      { { 135, 160, 76, 203, 2 },
        { 161, 49, 20, 79, 3 },
        { 77, 51, 32, 94, 1 },
        { 207, 34, 136, 200, 5 }, },
      { { 135, 184, 138, 180, 13 },
        { 205, 192, 215, 67, 10 },
        { 178, 213, 17, 222, 1 },
        { 92, 46, 176, 59, 3 }, },
      { { 142, 2, 6, 56, 4 },
        { 130, 97, 202, 3, 0 },
        { 33, 198, 4, 7, 1 },
        { 12, 5, 56, 100, 1 }, },
      { { 140, 54, 125, 172, 7 },
        { 255, 49, 78, 50, 6 },
        { 227, 91, 230, 195, 1 },
        { 100, 199, 40, 207, 15 }, },
      { { 140, 65, 233, 44, 2 },
        { 186, 182, 6, 2, 4 },
        { 67, 73, 120, 35, 1 },
        { 36, 6, 6, 213, 13 }, },
      { { 140, 152, 59, 175, 12 },
        { 218, 96, 87, 22, 15 },
        { 63, 93, 193, 147, 1 },
        { 246, 142, 160, 101, 11 }, },
      { { 136, 244, 107, 79, 11 },
        { 127, 116, 21, 46, 5 },
        { 223, 45, 98, 241, 1 },
        { 167, 74, 130, 239, 14 }, },
      { { 143, 44, 197, 204, 4 },
        { 187, 161, 64, 107, 10 },
        { 35, 58, 51, 79, 1 },
        { 93, 96, 40, 93, 13 }, },
      { { 141, 55, 126, 115, 3 },
        { 231, 83, 142, 126, 5 },
        { 204, 231, 238, 203, 1 },
        { 167, 231, 28, 174, 7 }, },
      { { 139, 69, 79, 63, 7 },
        { 62, 119, 198, 103, 1 },
        { 239, 207, 42, 45, 1 },
        { 142, 102, 62, 231, 12 }, },
      { { 141, 86, 37, 150, 0 },
        { 218, 5, 136, 98, 7 },
        { 6, 154, 70, 171, 1 },
        { 228, 97, 26, 5, 11 }, },
      { { 139, 191, 24, 57, 2 },
        { 67, 50, 158, 119, 8 },
        { 73, 193, 143, 221, 1 },
        { 30, 231, 148, 204, 2 }, },
      { { 141, 166, 67, 9, 4 },
        { 179, 96, 88, 102, 0 },
        { 41, 12, 38, 91, 1 },
        { 6, 97, 160, 108, 13 }, },
      { { 141, 208, 202, 166, 8 },
        { 234, 196, 23, 66, 3 },
        { 22, 85, 48, 187, 1 },
        { 196, 46, 130, 53, 7 }, },
      { { 139, 246, 152, 79, 4 },
        { 75, 164, 92, 127, 1 },
        { 47, 33, 150, 253, 1 },
        { 143, 227, 162, 93, 2 }, },
      { { 144, 18, 153, 165, 4 },
        { 88, 136, 78, 22, 2 },
        { 42, 89, 148, 128, 9 },
        { 70, 135, 33, 17, 10 }, },
      { { 150, 46, 4, 135, 5 },
        { 141, 9, 72, 39, 11 },
        { 174, 18, 7, 70, 9 },
        { 222, 65, 41, 11, 1 }, },
      { { 146, 92, 163, 212, 0 },
        { 88, 204, 128, 43, 14 },
        { 2, 188, 83, 164, 9 },
        { 125, 64, 19, 49, 10 }, },
      { { 146, 133, 143, 119, 10 },
        { 24, 219, 151, 47, 1 },
        { 94, 239, 26, 20, 9 },
        { 143, 78, 157, 177, 8 }, },
      { { 148, 169, 61, 69, 10 },
        { 153, 27, 21, 30, 12 },
        { 90, 43, 201, 82, 9 },
        { 55, 138, 141, 137, 9 }, },
      { { 145, 32, 243, 51, 2 },
        { 49, 216, 130, 86, 5 },
        { 76, 204, 240, 72, 9 },
        { 166, 164, 17, 184, 12 }, },
      { { 145, 39, 109, 79, 3 },
        { 61, 59, 12, 110, 5 },
        { 207, 43, 110, 72, 9 },
        { 167, 99, 13, 203, 12 }, },
      { { 151, 51, 253, 233, 10 },
        { 241, 187, 15, 95, 6 },
        { 89, 123, 252, 206, 9 },
        { 111, 175, 13, 216, 15 }, },
      { { 151, 72, 243, 129, 3 },
        { 180, 220, 0, 87, 14 },
        { 200, 28, 241, 46, 9 },
        { 126, 160, 3, 178, 13 }, },
      { { 151, 159, 160, 6, 9 },
        { 204, 138, 25, 99, 13 },
        { 150, 0, 95, 158, 9 },
        { 188, 105, 133, 19, 3 }, },
      { { 147, 208, 63, 215, 12 },
        { 88, 77, 213, 95, 7 },
        { 62, 191, 192, 188, 9 },
        { 239, 170, 187, 33, 10 }, },
      { { 149, 252, 208, 110, 0 },
        { 233, 172, 18, 122, 9 },
        { 7, 96, 179, 250, 9 },
        { 149, 228, 131, 89, 7 }, },
      { { 147, 195, 178, 11, 1 },
        { 4, 238, 24, 87, 5 },
        { 141, 4, 220, 60, 9 },
        { 174, 161, 135, 114, 0 }, },
      { { 145, 195, 66, 1, 14 },
        { 32, 94, 89, 70, 0 },
        { 120, 4, 44, 56, 9 },
        { 6, 41, 167, 160, 4 }, },
      { { 158, 10, 212, 208, 9 },
        { 166, 137, 137, 27, 10 },
        { 144, 178, 181, 7, 9 },
        { 93, 137, 25, 22, 5 }, },
      { { 158, 62, 24, 70, 8 },
        { 203, 8, 13, 59, 9 },
        { 22, 33, 135, 199, 9 },
        { 157, 203, 1, 13, 3 }, },
      { { 154, 97, 122, 220, 9 },
        { 47, 110, 133, 27, 6 },
        { 147, 181, 232, 101, 9 },
        { 109, 138, 23, 111, 4 }, },
      { { 152, 200, 135, 101, 13 },
        { 30, 205, 83, 14, 8 },
        { 186, 110, 17, 49, 9 },
        { 23, 12, 171, 55, 8 }, },
      { { 152, 193, 223, 48, 9 },
        { 54, 207, 151, 18, 0 },
        { 144, 207, 184, 49, 9 },
        { 4, 142, 159, 54, 12 }, },
      { { 158, 249, 40, 250, 12 },
        { 195, 46, 215, 11, 15 },
        { 53, 241, 73, 247, 9 },
        { 253, 14, 183, 76, 3 }, },
      { { 158, 240, 171, 22, 1 },
        { 223, 204, 148, 3, 5 },
        { 134, 141, 80, 247, 9 },
        { 172, 2, 147, 63, 11 }, },
      { { 152, 251, 117, 9, 13 },
        { 119, 47, 89, 22, 12 },
        { 185, 10, 237, 241, 9 },
        { 54, 137, 175, 78, 14 }, },
      { { 159, 32, 1, 53, 4 },
        { 155, 8, 194, 71, 0 },
        { 42, 200, 0, 79, 9 },
        { 14, 36, 49, 13, 9 }, },
      { { 153, 18, 120, 7, 12 },
        { 106, 8, 77, 86, 5 },
        { 62, 1, 228, 137, 9 },
        { 166, 171, 33, 5, 6 }, },
      { { 155, 131, 245, 126, 11 },
        { 62, 187, 155, 91, 5 },
        { 215, 234, 252, 29, 9 },
        { 173, 173, 157, 215, 12 }, },
      { { 153, 249, 200, 173, 5 },
        { 111, 174, 86, 70, 10 },
        { 171, 81, 57, 249, 9 },
        { 86, 38, 167, 95, 6 }, },
      { { 157, 228, 46, 236, 2 },
        { 139, 125, 22, 106, 6 },
        { 67, 119, 66, 123, 9 },
        { 101, 102, 139, 237, 1 }, },
      { { 155, 219, 144, 210, 3 },
        { 70, 158, 152, 91, 11 },
        { 196, 176, 157, 189, 9 },
        { 221, 161, 151, 150, 2 }, },
      { { 159, 254, 132, 153, 15 },
        { 199, 189, 217, 103, 10 },
        { 249, 146, 23, 255, 9 },
        { 94, 105, 187, 222, 3 }, },
      { { 162, 66, 140, 215, 9 },
        { 12, 133, 173, 15, 3 },
        { 158, 179, 20, 36, 5 },
        { 207, 11, 90, 19, 0 }, },
      { { 164, 205, 25, 53, 7 },
        { 156, 22, 246, 54, 8 },
        { 234, 201, 139, 50, 5 },
        { 22, 198, 246, 131, 9 }, },
      { { 166, 213, 162, 25, 0 },
        { 192, 230, 176, 39, 4 },
        { 9, 132, 90, 182, 5 },
        { 46, 64, 214, 112, 3 }, },
      { { 160, 223, 192, 176, 6 },
        { 96, 150, 250, 34, 10 },
        { 96, 208, 63, 176, 5 },
        { 84, 69, 246, 144, 6 }, },
      { { 163, 49, 180, 144, 4 },
        { 65, 131, 224, 83, 6 },
        { 32, 146, 216, 204, 5 },
        { 108, 160, 124, 24, 2 }, },
      { { 167, 32, 134, 58, 15 },
        { 133, 241, 227, 67, 1 },
        { 245, 198, 16, 78, 5 },
        { 140, 44, 120, 250, 1 }, },
      { { 167, 56, 45, 40, 13 },
        { 213, 33, 103, 67, 12 },
        { 177, 75, 65, 206, 5 },
        { 60, 46, 104, 74, 11 }, },
      { { 163, 63, 204, 220, 14 },
        { 105, 179, 237, 107, 10 },
        { 115, 179, 63, 204, 5 },
        { 93, 107, 124, 217, 6 }, },
      { { 165, 62, 179, 132, 11 },
        { 221, 208, 41, 114, 14 },
        { 210, 28, 215, 202, 5 },
        { 116, 233, 64, 187, 11 }, },
      { { 161, 112, 26, 189, 7 },
        { 77, 116, 230, 86, 2 },
        { 235, 213, 128, 232, 5 },
        { 70, 166, 114, 235, 2 }, },
      { { 167, 103, 101, 55, 9 },
        { 189, 7, 171, 103, 5 },
        { 158, 202, 110, 110, 5 },
        { 174, 109, 94, 11, 13 }, },
      { { 165, 123, 102, 174, 4 },
        { 233, 103, 106, 66, 15 },
        { 39, 86, 109, 234, 5 },
        { 244, 37, 110, 105, 7 }, },
      { { 161, 213, 29, 147, 2 },
        { 80, 23, 180, 118, 3 },
        { 76, 155, 138, 184, 5 },
        { 198, 226, 222, 128, 10 }, },
      { { 163, 248, 233, 155, 14 },
        { 113, 180, 245, 71, 15 },
        { 125, 153, 113, 252, 5 },
        { 254, 42, 242, 216, 14 }, },
      { { 165, 211, 131, 218, 3 },
        { 212, 246, 184, 74, 3 },
        { 197, 188, 28, 186, 5 },
        { 197, 33, 214, 242, 11 }, },
      { { 165, 214, 235, 188, 6 },
        { 248, 244, 254, 98, 6 },
        { 99, 221, 118, 186, 5 },
        { 100, 103, 242, 241, 15 }, },
      { { 170, 38, 227, 151, 9 },
        { 63, 192, 169, 39, 7 },
        { 158, 156, 118, 69, 5 },
        { 238, 73, 80, 63, 12 }, },
      { { 174, 30, 201, 63, 12 },
        { 250, 160, 239, 39, 9 },
        { 63, 201, 55, 135, 5 },
        { 158, 79, 112, 85, 15 }, },
      { { 172, 119, 184, 237, 2 },
        { 203, 182, 46, 62, 6 },
        { 75, 113, 222, 227, 5 },
        { 103, 199, 70, 221, 3 }, },
      { { 170, 169, 238, 77, 15 },
        { 47, 243, 117, 15, 12 },
        { 251, 39, 121, 85, 5 },
        { 63, 10, 236, 255, 4 }, },
      { { 170, 128, 121, 170, 6 },
        { 50, 48, 118, 19, 7 },
        { 101, 89, 224, 21, 5 },
        { 236, 134, 224, 196, 12 }, },
      { { 174, 194, 96, 202, 1 },
        { 166, 36, 56, 11, 7 },
        { 133, 48, 100, 55, 5 },
        { 237, 1, 194, 70, 5 }, },
      { { 169, 58, 152, 98, 11 },
        { 71, 144, 47, 90, 9 },
        { 212, 97, 149, 201, 5 },
        { 149, 175, 64, 158, 2 }, },
      { { 171, 18, 81, 200, 12 },
        { 114, 32, 105, 91, 2 },
        { 49, 56, 164, 141, 5 },
        { 77, 169, 96, 68, 14 }, },
      { { 173, 102, 219, 216, 13 },
        { 183, 228, 237, 122, 2 },
        { 177, 189, 182, 107, 5 },
        { 69, 235, 114, 126, 13 }, },
      { { 173, 82, 221, 74, 1 },
        { 246, 165, 44, 90, 1 },
        { 133, 43, 180, 171, 5 },
        { 133, 163, 74, 86, 15 }, },
      { { 169, 182, 113, 16, 8 },
        { 115, 0, 185, 114, 4 },
        { 16, 136, 230, 217, 5 },
        { 36, 233, 208, 12, 14 }, },
      { { 173, 186, 226, 53, 0 },
        { 235, 192, 186, 70, 12 },
        { 10, 196, 117, 219, 5 },
        { 54, 37, 208, 61, 7 }, },
      { { 173, 151, 65, 223, 12 },
        { 250, 34, 249, 110, 3 },
        { 63, 184, 46, 155, 5 },
        { 199, 105, 244, 69, 15 }, },
      { { 171, 243, 182, 44, 7 },
        { 79, 247, 122, 83, 4 },
        { 227, 70, 220, 253, 5 },
        { 44, 165, 238, 255, 2 }, },
      { { 182, 34, 108, 113, 12 },
        { 161, 9, 239, 15, 4 },
        { 56, 227, 100, 70, 13 },
        { 47, 15, 121, 8, 5 }, },
      { { 180, 30, 37, 122, 7 },
        { 212, 57, 234, 42, 13 },
        { 229, 234, 71, 130, 13 },
        { 181, 69, 121, 194, 11 }, },
      { { 182, 55, 195, 138, 3 },
        { 245, 250, 40, 35, 3 },
        { 197, 28, 62, 198, 13 },
        { 204, 65, 69, 250, 15 }, },
      { { 176, 76, 212, 55, 0 },
        { 40, 141, 162, 54, 9 },
        { 14, 194, 179, 32, 13 },
        { 150, 196, 91, 17, 4 }, },
      { { 178, 127, 139, 5, 3 },
        { 93, 222, 44, 39, 8 },
        { 202, 13, 31, 228, 13 },
        { 30, 67, 71, 187, 10 }, },
      { { 176, 173, 216, 34, 5 },
        { 37, 138, 118, 50, 9 },
        { 164, 65, 187, 80, 13 },
        { 148, 198, 229, 26, 4 }, },
      { { 180, 155, 130, 43, 11 },
        { 196, 250, 59, 6, 9 },
        { 221, 68, 29, 146, 13 },
        { 150, 13, 197, 242, 3 }, },
      { { 176, 211, 78, 194, 3 },
        { 100, 95, 60, 10, 3 },
        { 196, 55, 44, 176, 13 },
        { 197, 3, 207, 162, 6 }, },
      { { 177, 61, 126, 195, 14 },
        { 97, 91, 101, 126, 15 },
        { 124, 55, 235, 200, 13 },
        { 247, 234, 109, 168, 6 }, },
      { { 177, 6, 164, 99, 14 },
        { 0, 153, 107, 110, 5 },
        { 124, 98, 86, 8, 13 },
        { 167, 109, 105, 144, 0 }, },
      { { 179, 43, 116, 63, 14 },
        { 41, 59, 235, 87, 13 },
        { 127, 194, 237, 76, 13 },
        { 190, 173, 125, 201, 4 }, },
      { { 183, 31, 214, 70, 15 },
        { 236, 219, 105, 123, 9 },
        { 246, 38, 191, 142, 13 },
        { 157, 233, 109, 179, 7 }, },
      { { 177, 110, 241, 244, 5 },
        { 61, 140, 234, 122, 14 },
        { 162, 248, 247, 104, 13 },
        { 117, 229, 115, 27, 12 }, },
      { { 177, 126, 83, 138, 14 },
        { 113, 124, 105, 114, 11 },
        { 117, 28, 167, 232, 13 },
        { 212, 233, 99, 232, 14 }, },
      { { 183, 98, 223, 55, 7 },
        { 189, 221, 238, 87, 1 },
        { 238, 207, 180, 110, 13 },
        { 142, 167, 123, 187, 13 }, },
      { { 177, 169, 248, 148, 9 },
        { 45, 138, 181, 82, 14 },
        { 146, 145, 249, 88, 13 },
        { 116, 170, 213, 27, 4 }, },
      { { 179, 183, 217, 210, 4 },
        { 113, 138, 252, 123, 3 },
        { 36, 185, 190, 220, 13 },
        { 205, 227, 245, 24, 14 }, },
      { { 179, 238, 187, 76, 6 },
        { 25, 252, 124, 123, 12 },
        { 99, 45, 215, 124, 13 },
        { 61, 227, 227, 249, 8 }, },
      { { 184, 44, 165, 82, 4 },
        { 19, 137, 224, 42, 13 },
        { 36, 170, 83, 65, 13 },
        { 181, 64, 121, 28, 8 }, },
      { { 184, 20, 13, 235, 15 },
        { 86, 57, 103, 46, 3 },
        { 253, 123, 2, 129, 13 },
        { 199, 78, 105, 198, 10 }, },
      { { 188, 25, 220, 199, 7 },
        { 238, 155, 100, 30, 11 },
        { 238, 51, 185, 131, 13 },
        { 215, 130, 109, 151, 7 }, },
      { { 188, 84, 38, 185, 6 },
        { 194, 125, 226, 38, 6 },
        { 105, 214, 66, 163, 13 },
        { 102, 68, 123, 228, 3 }, },
      { { 190, 103, 55, 196, 5 },
        { 159, 79, 104, 59, 6 },
        { 162, 62, 206, 103, 13 },
        { 109, 193, 111, 47, 9 }, },
      { { 184, 250, 232, 211, 5 },
        { 103, 140, 252, 14, 15 },
        { 172, 177, 117, 241, 13 },
        { 247, 3, 243, 30, 6 }, },
      { { 190, 194, 26, 55, 8 },
        { 138, 76, 191, 23, 1 },
        { 30, 197, 132, 55, 13 },
        { 142, 143, 211, 37, 1 }, },
      { { 187, 24, 207, 164, 11 },
        { 126, 217, 39, 67, 10 },
        { 210, 95, 49, 141, 13 },
        { 92, 46, 73, 183, 14 }, },
      { { 189, 1, 126, 246, 13 },
        { 174, 75, 231, 90, 7 },
        { 182, 247, 232, 11, 13 },
        { 229, 174, 125, 39, 5 }, },
      { { 189, 34, 47, 210, 7 },
        { 151, 89, 236, 74, 7 },
        { 228, 191, 68, 75, 13 },
        { 229, 35, 121, 174, 9 }, },
      { { 189, 2, 85, 133, 5 },
        { 190, 9, 104, 86, 2 },
        { 170, 26, 164, 11, 13 },
        { 70, 161, 105, 7, 13 }, },
      { { 185, 114, 78, 96, 5 },
        { 103, 77, 110, 74, 0 },
        { 160, 103, 36, 233, 13 },
        { 5, 39, 107, 46, 6 }, },
      { { 189, 119, 92, 22, 15 },
        { 239, 31, 237, 114, 1 },
        { 246, 131, 174, 235, 13 },
        { 132, 235, 127, 143, 7 }, },
      { { 185, 136, 172, 46, 1 },
        { 14, 169, 54, 66, 13 },
        { 135, 67, 81, 25, 13 },
        { 180, 38, 201, 87, 0 }, },
      { { 191, 160, 38, 103, 5 },
        { 143, 73, 114, 79, 5 },
        { 174, 102, 64, 95, 13 },
        { 175, 36, 233, 47, 1 }, },
      { { 185, 130, 150, 168, 6 },
        { 2, 249, 122, 82, 2 },
        { 97, 86, 148, 25, 13 },
        { 68, 165, 233, 244, 0 }, },
      { { 189, 135, 23, 24, 10 },
        { 146, 123, 185, 114, 0 },
        { 81, 142, 142, 27, 13 },
        { 4, 233, 221, 228, 9 }, },
      { { 191, 190, 239, 45, 7 },
        { 255, 249, 126, 103, 12 },
        { 235, 79, 119, 223, 13 },
        { 62, 103, 233, 255, 15 }, },
      { { 189, 250, 159, 0, 7 },
        { 215, 221, 124, 82, 8 },
        { 224, 15, 149, 251, 13 },
        { 20, 163, 235, 190, 11 }, },
      { { 194, 112, 53, 187, 8 },
        { 81, 37, 131, 151, 7 },
        { 29, 218, 192, 228, 3 },
        { 238, 156, 26, 72, 10 }, },
      { { 196, 108, 5, 172, 13 },
        { 157, 37, 67, 162, 10 },
        { 179, 90, 3, 98, 3 },
        { 84, 92, 42, 75, 9 }, },
      { { 196, 121, 84, 220, 3 },
        { 237, 55, 128, 154, 10 },
        { 195, 178, 169, 226, 3 },
        { 85, 144, 30, 203, 7 }, },
      { { 194, 106, 81, 13, 8 },
        { 57, 36, 9, 151, 8 },
        { 27, 8, 165, 100, 3 },
        { 30, 153, 2, 73, 12 }, },
      { { 198, 164, 159, 104, 4 },
        { 145, 225, 86, 187, 0 },
        { 33, 111, 146, 86, 3 },
        { 13, 214, 168, 120, 9 }, },
      { { 192, 158, 44, 235, 4 },
        { 64, 33, 94, 174, 15 },
        { 45, 115, 71, 144, 3 },
        { 247, 87, 168, 64, 2 }, },
      { { 198, 146, 33, 73, 13 },
        { 212, 32, 89, 143, 4 },
        { 185, 40, 68, 150, 3 },
        { 47, 25, 160, 66, 11 }, },
      { { 196, 186, 131, 207, 8 },
        { 217, 224, 25, 142, 11 },
        { 31, 60, 21, 210, 3 },
        { 215, 25, 128, 121, 11 }, },
      { { 198, 231, 133, 67, 11 },
        { 149, 151, 25, 175, 1 },
        { 220, 42, 30, 118, 3 },
        { 143, 89, 142, 154, 9 }, },
      { { 198, 215, 175, 70, 4 },
        { 216, 199, 92, 171, 5 },
        { 38, 47, 94, 182, 3 },
        { 173, 83, 174, 49, 11 }, },
      { { 197, 54, 85, 77, 11 },
        { 253, 49, 9, 254, 0 },
        { 219, 42, 166, 202, 3 },
        { 7, 249, 8, 203, 15 }, },
      { { 195, 147, 255, 13, 7 },
        { 124, 243, 92, 215, 4 },
        { 235, 15, 252, 156, 3 },
        { 46, 179, 172, 243, 14 }, },
      { { 193, 245, 112, 165, 10 },
        { 105, 22, 19, 246, 6 },
        { 90, 80, 234, 248, 3 },
        { 102, 252, 134, 137, 6 }, },
      { { 204, 57, 113, 197, 0 },
        { 251, 2, 0, 158, 14 },
        { 10, 56, 233, 195, 3 },
        { 119, 144, 4, 13, 15 }, },
      { { 200, 2, 137, 73, 2 },
        { 18, 176, 12, 142, 0 },
        { 73, 41, 20, 1, 3 },
        { 7, 19, 0, 212, 8 }, },
      { { 200, 124, 100, 74, 5 },
        { 103, 37, 64, 170, 13 },
        { 165, 34, 99, 225, 3 },
        { 181, 80, 42, 78, 6 }, },
      { { 202, 103, 225, 13, 7 },
        { 63, 182, 72, 167, 4 },
        { 235, 8, 126, 101, 3 },
        { 46, 81, 38, 223, 12 }, },
      { { 200, 153, 231, 66, 2 },
        { 114, 211, 16, 138, 13 },
        { 68, 46, 121, 145, 3 },
        { 181, 16, 140, 180, 14 }, },
      { { 200, 170, 178, 16, 5 },
        { 7, 192, 216, 146, 12 },
        { 160, 132, 213, 81, 3 },
        { 52, 145, 176, 62, 0 }, },
      { { 204, 166, 213, 159, 3 },
        { 191, 177, 152, 182, 3 },
        { 207, 154, 182, 83, 3 },
        { 198, 209, 152, 223, 13 }, },
      { { 202, 229, 134, 251, 14 },
        { 3, 247, 211, 175, 3 },
        { 125, 246, 26, 117, 3 },
        { 207, 92, 190, 252, 0 }, },
      { { 202, 217, 124, 49, 15 },
        { 102, 23, 215, 151, 12 },
        { 248, 195, 233, 181, 3 },
        { 62, 158, 190, 134, 6 }, },
      { { 206, 228, 202, 14, 6 },
        { 171, 244, 84, 163, 1 },
        { 103, 5, 50, 119, 3 },
        { 140, 82, 162, 253, 5 }, },
      { { 203, 45, 164, 50, 12 },
        { 3, 131, 195, 227, 13 },
        { 52, 194, 91, 77, 3 },
        { 188, 124, 60, 28, 0 }, },
      { { 203, 87, 214, 130, 2 },
        { 98, 215, 8, 243, 3 },
        { 68, 22, 190, 173, 3 },
        { 204, 241, 14, 180, 6 }, },
      { { 201, 144, 33, 177, 0 },
        { 82, 0, 146, 198, 6 },
        { 8, 216, 64, 153, 3 },
        { 102, 52, 144, 4, 10 }, },
      { { 201, 130, 95, 176, 10 },
        { 50, 81, 159, 210, 2 },
        { 80, 223, 164, 25, 3 },
        { 68, 191, 152, 164, 12 }, },
      { { 203, 158, 212, 36, 7 },
        { 110, 145, 90, 243, 8 },
        { 226, 66, 183, 157, 3 },
        { 28, 245, 168, 151, 6 }, },
      { { 205, 134, 171, 157, 13 },
        { 158, 224, 221, 230, 6 },
        { 187, 157, 86, 27, 3 },
        { 102, 123, 176, 119, 9 }, },
      { { 201, 201, 176, 119, 5 },
        { 14, 134, 210, 222, 13 },
        { 174, 224, 217, 57, 3 },
        { 183, 180, 182, 23, 0 }, },
      { { 201, 250, 31, 99, 2 },
        { 83, 85, 30, 222, 9 },
        { 76, 111, 133, 249, 3 },
        { 151, 183, 138, 172, 10 }, },
      { { 203, 247, 64, 6, 9 },
        { 111, 6, 25, 227, 1 },
        { 150, 0, 46, 253, 3 },
        { 140, 121, 134, 15, 6 }, },
      { { 205, 218, 13, 28, 15 },
        { 222, 53, 221, 194, 8 },
        { 243, 139, 5, 187, 3 },
        { 20, 59, 186, 199, 11 }, },
      { { 208, 11, 130, 83, 15 },
        { 4, 218, 201, 142, 9 },
        { 252, 164, 29, 0, 11 },
        { 151, 25, 53, 178, 0 }, },
      { { 212, 59, 207, 214, 15 },
        { 253, 219, 205, 138, 11 },
        { 246, 191, 61, 194, 11 },
        { 213, 27, 61, 187, 15 }, },
      { { 214, 98, 171, 209, 11 },
        { 149, 220, 141, 143, 6 },
        { 216, 189, 84, 102, 11 },
        { 111, 27, 19, 186, 9 }, },
      { { 212, 102, 200, 58, 15 },
        { 165, 188, 207, 162, 1 },
        { 245, 193, 54, 98, 11 },
        { 132, 95, 51, 218, 5 }, },
      { { 209, 32, 28, 120, 10 },
        { 1, 57, 135, 218, 0 },
        { 81, 227, 128, 72, 11 },
        { 5, 190, 25, 200, 0 }, },
      { { 211, 57, 65, 195, 9 },
        { 117, 10, 1, 207, 11 },
        { 156, 56, 41, 204, 11 },
        { 223, 56, 5, 10, 14 }, },
      { { 209, 7, 160, 253, 4 },
        { 8, 170, 202, 238, 6 },
        { 43, 240, 94, 8, 11 },
        { 103, 117, 53, 81, 0 }, },
      { { 209, 149, 58, 14, 2 },
        { 72, 122, 20, 242, 5 },
        { 71, 5, 202, 152, 11 },
        { 164, 242, 133, 225, 2 }, },
      { { 215, 189, 66, 29, 13 },
        { 237, 106, 209, 231, 8 },
        { 187, 132, 43, 222, 11 },
        { 30, 120, 181, 107, 7 }, },
      { { 215, 192, 166, 80, 13 },
        { 132, 205, 209, 203, 4 },
        { 176, 166, 80, 62, 11 },
        { 45, 56, 187, 50, 1 }, },
      { { 215, 229, 141, 245, 12 },
        { 153, 143, 215, 239, 2 },
        { 58, 251, 26, 126, 11 },
        { 79, 126, 191, 25, 9 }, },
      { { 215, 197, 83, 246, 7 },
        { 188, 94, 210, 251, 3 },
        { 230, 252, 170, 62, 11 },
        { 205, 244, 183, 163, 13 }, },
      { { 213, 254, 112, 184, 8 },
        { 225, 44, 155, 242, 14 },
        { 17, 208, 231, 250, 11 },
        { 116, 253, 147, 72, 7 }, },
      { { 216, 12, 185, 190, 6 },
        { 26, 184, 198, 178, 15 },
        { 103, 217, 211, 1, 11 },
        { 244, 214, 49, 213, 8 }, },
      { { 222, 52, 186, 37, 6 },
        { 203, 216, 70, 183, 4 },
        { 106, 69, 210, 199, 11 },
        { 46, 214, 33, 189, 3 }, },
      { { 220, 14, 198, 139, 14 },
        { 162, 249, 73, 166, 11 },
        { 125, 22, 55, 3, 11 },
        { 214, 89, 41, 244, 5 }, },
      { { 222, 3, 247, 164, 11 },
        { 190, 219, 11, 147, 6 },
        { 210, 94, 252, 7, 11 },
        { 108, 157, 13, 183, 13 }, },
      { { 218, 93, 11, 138, 2 },
        { 82, 126, 4, 163, 11 },
        { 69, 29, 11, 165, 11 },
        { 220, 82, 7, 228, 10 }, },
      { { 216, 113, 249, 127, 15 },
        { 127, 190, 199, 158, 5 },
        { 255, 233, 248, 225, 11 },
        { 167, 158, 55, 223, 14 }, },
      { { 220, 189, 130, 231, 2 },
        { 203, 218, 18, 174, 11 },
        { 78, 116, 27, 211, 11 },
        { 215, 84, 133, 189, 3 }, },
      { { 220, 176, 90, 229, 5 },
        { 239, 72, 86, 158, 2 },
        { 170, 117, 160, 211, 11 },
        { 71, 150, 161, 47, 7 }, },
      { { 218, 147, 222, 80, 0 },
        { 98, 203, 156, 155, 0 },
        { 0, 167, 188, 149, 11 },
        { 13, 147, 157, 52, 6 }, },
      { { 218, 183, 241, 191, 8 },
        { 123, 170, 155, 183, 7 },
        { 31, 216, 254, 213, 11 },
        { 238, 221, 149, 93, 14 }, },
      { { 222, 159, 2, 50, 14 },
        { 194, 90, 219, 163, 9 },
        { 116, 196, 15, 151, 11 },
        { 156, 93, 181, 164, 3 }, },
      { { 218, 196, 13, 85, 0 },
        { 26, 13, 148, 175, 0 },
        { 10, 171, 2, 53, 11 },
        { 15, 82, 155, 5, 8 }, },
      { { 220, 197, 171, 128, 14 },
        { 146, 222, 85, 162, 6 },
        { 112, 29, 90, 51, 11 },
        { 100, 90, 167, 180, 9 }, },
      { { 218, 194, 178, 58, 10 },
        { 2, 252, 155, 147, 5 },
        { 85, 196, 212, 53, 11 },
        { 172, 157, 147, 244, 0 }, },
      { { 218, 218, 88, 253, 0 },
        { 106, 44, 158, 159, 10 },
        { 11, 241, 165, 181, 11 },
        { 95, 151, 147, 69, 6 }, },
      { { 217, 37, 142, 168, 1 },
        { 7, 235, 6, 226, 2 },
        { 129, 87, 26, 73, 11 },
        { 68, 118, 13, 126, 0 }, },
      { { 221, 5, 118, 59, 14 },
        { 162, 123, 195, 246, 5 },
        { 125, 198, 234, 11, 11 },
        { 166, 252, 61, 228, 5 }, },
      { { 221, 46, 153, 8, 12 },
        { 147, 168, 77, 242, 8 },
        { 49, 9, 151, 75, 11 },
        { 20, 251, 33, 92, 9 }, },
      { { 217, 85, 104, 199, 5 },
        { 110, 14, 68, 238, 7 },
        { 174, 49, 106, 169, 11 },
        { 231, 114, 39, 7, 6 }, },
      { { 219, 80, 109, 76, 3 },
        { 126, 61, 4, 203, 4 },
        { 195, 43, 96, 173, 11 },
        { 45, 50, 11, 199, 14 }, },
      { { 223, 104, 170, 56, 8 },
        { 131, 236, 135, 195, 12 },
        { 17, 197, 81, 111, 11 },
        { 60, 62, 19, 124, 1 }, },
      { { 219, 66, 135, 167, 5 },
        { 30, 205, 74, 199, 3 },
        { 174, 94, 20, 45, 11 },
        { 206, 53, 43, 55, 8 }, },
      { { 219, 129, 40, 179, 13 },
        { 6, 10, 215, 199, 7 },
        { 188, 209, 72, 29, 11 },
        { 238, 62, 181, 6, 0 }, },
      { { 217, 163, 194, 250, 13 },
        { 39, 234, 219, 202, 3 },
        { 181, 244, 60, 89, 11 },
        { 197, 61, 181, 126, 4 }, },
      { { 221, 179, 56, 211, 8 },
        { 195, 10, 157, 222, 7 },
        { 28, 177, 204, 219, 11 },
        { 231, 187, 149, 12, 3 }, },
      { { 217, 202, 123, 155, 1 },
        { 54, 108, 156, 214, 15 },
        { 141, 157, 229, 57, 11 },
        { 246, 179, 147, 102, 12 }, },
      { { 219, 246, 158, 176, 7 },
        { 71, 221, 222, 243, 2 },
        { 224, 215, 150, 253, 11 },
        { 76, 247, 187, 190, 2 }, },
      { { 226, 8, 108, 175, 8 },
        { 40, 33, 39, 135, 15 },
        { 31, 83, 97, 4, 7 },
        { 254, 30, 72, 65, 4 }, },
      { { 224, 27, 171, 150, 4 },
        { 88, 194, 236, 130, 15 },
        { 38, 157, 93, 128, 7 },
        { 244, 19, 116, 49, 10 }, },
      { { 224, 72, 115, 243, 0 },
        { 48, 68, 162, 158, 15 },
        { 12, 252, 225, 32, 7 },
        { 247, 148, 82, 32, 12 }, },
      { { 228, 117, 169, 91, 14 },
        { 209, 182, 229, 174, 5 },
        { 125, 169, 90, 226, 7 },
        { 167, 90, 118, 216, 11 }, },
      { { 230, 128, 236, 116, 9 },
        { 172, 129, 183, 139, 4 },
        { 146, 227, 112, 22, 7 },
        { 45, 30, 216, 19, 5 }, },
      { { 226, 175, 118, 72, 7 },
        { 37, 115, 120, 187, 12 },
        { 225, 38, 239, 84, 7 },
        { 61, 209, 236, 234, 4 }, },
      { { 224, 162, 200, 17, 13 },
        { 37, 128, 253, 134, 0 },
        { 184, 129, 52, 80, 7 },
        { 6, 27, 240, 26, 4 }, },
      { { 226, 203, 113, 80, 12 },
        { 48, 6, 249, 155, 12 },
        { 48, 168, 237, 52, 7 },
        { 61, 153, 246, 0, 12 }, },
      { { 224, 210, 73, 197, 15 },
        { 124, 20, 125, 142, 2 },
        { 250, 57, 36, 176, 7 },
        { 71, 27, 226, 131, 14 }, },
      { { 225, 12, 194, 130, 9 },
        { 36, 192, 33, 226, 11 },
        { 148, 20, 51, 8, 7 },
        { 212, 120, 64, 50, 4 }, },
      { { 225, 127, 68, 52, 3 },
        { 109, 23, 170, 226, 8 },
        { 194, 194, 47, 232, 7 },
        { 20, 117, 94, 139, 6 }, },
      { { 231, 173, 69, 177, 14 },
        { 177, 19, 243, 231, 10 },
        { 120, 218, 43, 94, 7 },
        { 94, 124, 252, 136, 13 }, },
      { { 225, 182, 90, 159, 9 },
        { 109, 96, 189, 246, 3 },
        { 159, 149, 166, 216, 7 },
        { 198, 251, 208, 107, 6 }, },
      { { 231, 252, 32, 65, 12 },
        { 193, 4, 113, 239, 12 },
        { 56, 32, 67, 254, 7 },
        { 63, 120, 226, 8, 3 }, },
      { { 238, 51, 65, 56, 1 },
        { 247, 34, 170, 131, 0 },
        { 129, 200, 44, 199, 7 },
        { 12, 21, 84, 78, 15 }, },
      { { 238, 124, 54, 51, 4 },
        { 195, 69, 226, 183, 13 },
        { 44, 198, 195, 231, 7 },
        { 190, 212, 122, 44, 3 }, },
      { { 236, 112, 123, 248, 10 },
        { 243, 116, 167, 154, 6 },
        { 81, 253, 224, 227, 7 },
        { 101, 158, 82, 236, 15 }, },
      { { 232, 123, 59, 230, 14 },
        { 91, 86, 111, 154, 15 },
        { 118, 125, 205, 225, 7 },
        { 245, 159, 102, 173, 10 }, },
      { { 232, 149, 232, 57, 1 },
        { 102, 162, 182, 166, 4 },
        { 137, 193, 122, 145, 7 },
        { 38, 86, 212, 86, 6 }, },
      { { 238, 172, 9, 125, 5 },
        { 159, 32, 246, 175, 8 },
        { 171, 233, 3, 87, 7 },
        { 31, 86, 240, 79, 9 }, },
      { { 236, 161, 201, 55, 4 },
        { 187, 130, 246, 134, 1 },
        { 46, 201, 56, 83, 7 },
        { 134, 22, 244, 29, 13 }, },
      { { 232, 151, 189, 197, 5 },
        { 94, 131, 124, 190, 6 },
        { 170, 59, 222, 145, 7 },
        { 103, 211, 236, 23, 10 }, },
      { { 232, 204, 18, 29, 0 },
        { 10, 100, 176, 182, 8 },
        { 11, 132, 131, 49, 7 },
        { 22, 208, 210, 101, 0 }, },
      { { 238, 193, 29, 105, 8 },
        { 146, 39, 55, 159, 0 },
        { 25, 107, 136, 55, 7 },
        { 15, 158, 206, 68, 9 }, },
      { { 237, 7, 255, 219, 10 },
        { 178, 243, 173, 254, 7 },
        { 93, 191, 254, 11, 7 },
        { 231, 251, 92, 244, 13 }, },
      { { 237, 105, 243, 54, 11 },
        { 191, 214, 163, 210, 13 },
        { 214, 204, 249, 107, 7 },
        { 180, 188, 86, 191, 13 }, },
      { { 237, 118, 20, 181, 12 },
        { 203, 5, 235, 246, 2 },
        { 58, 210, 134, 235, 7 },
        { 70, 253, 122, 13, 3 }, },
      { { 239, 132, 33, 209, 7 },
        { 150, 16, 240, 239, 6 },
        { 232, 184, 66, 31, 7 },
        { 111, 112, 240, 134, 9 }, },
      { { 235, 245, 218, 120, 2 },
        { 99, 246, 182, 251, 0 },
        { 65, 229, 186, 253, 7 },
        { 13, 246, 214, 252, 6 }, },
      { { 233, 249, 229, 214, 13 },
        { 127, 135, 241, 202, 15 },
        { 182, 186, 121, 249, 7 },
        { 245, 56, 254, 31, 14 }, },
      { { 235, 211, 15, 145, 9 },
        { 86, 71, 189, 199, 2 },
        { 152, 159, 12, 189, 7 },
        { 78, 59, 222, 38, 10 }, },
      { { 233, 219, 241, 32, 9 },
        { 118, 134, 59, 210, 12 },
        { 144, 72, 253, 185, 7 },
        { 52, 189, 198, 22, 14 }, },
      { { 244, 41, 139, 109, 8 },
        { 153, 234, 39, 142, 8 },
        { 27, 109, 25, 66, 15 },
        { 23, 30, 69, 121, 9 }, },
      { { 246, 10, 52, 34, 5 },
        { 132, 9, 106, 147, 13 },
        { 164, 66, 197, 6, 15 },
        { 188, 149, 105, 2, 1 }, },
      { { 244, 88, 85, 155, 1 },
        { 244, 45, 160, 150, 11 },
        { 141, 154, 161, 162, 15 },
        { 214, 144, 91, 66, 15 }, },
      { { 242, 118, 55, 97, 3 },
        { 85, 93, 42, 191, 4 },
        { 200, 110, 198, 228, 15 },
        { 47, 213, 75, 170, 10 }, },
      { { 244, 75, 10, 224, 6 },
        { 128, 94, 110, 138, 10 },
        { 96, 117, 13, 34, 15 },
        { 85, 23, 103, 160, 1 }, },
      { { 246, 110, 129, 75, 12 },
        { 145, 172, 105, 175, 9 },
        { 61, 40, 23, 102, 15 },
        { 159, 89, 99, 88, 9 }, },
      { { 246, 67, 29, 76, 6 },
        { 152, 63, 108, 155, 0 },
        { 99, 43, 140, 38, 15 },
        { 13, 147, 111, 193, 9 }, },
      { { 244, 87, 34, 238, 1 },
        { 204, 110, 42, 170, 7 },
        { 135, 116, 78, 162, 15 },
        { 229, 85, 71, 99, 3 }, },
      { { 244, 153, 83, 229, 11 },
        { 252, 90, 51, 158, 10 },
        { 218, 124, 169, 146, 15 },
        { 87, 156, 197, 163, 15 }, },
      { { 240, 252, 47, 27, 5 },
        { 85, 109, 244, 166, 13 },
        { 173, 143, 67, 240, 15 },
        { 182, 82, 251, 106, 10 }, },
      { { 247, 9, 30, 9, 12 },
        { 128, 107, 101, 215, 8 },
        { 57, 7, 137, 14, 15 },
        { 30, 186, 109, 96, 1 }, },
      { { 247, 38, 87, 194, 0 },
        { 177, 73, 40, 251, 3 },
        { 4, 62, 166, 78, 15 },
        { 205, 241, 73, 40, 13 }, },
      { { 241, 133, 27, 198, 13 },
        { 28, 74, 117, 250, 3 },
        { 182, 61, 138, 24, 15 },
        { 197, 250, 229, 35, 8 }, },
      { { 243, 136, 98, 232, 1 },
        { 36, 104, 50, 203, 14 },
        { 129, 116, 97, 28, 15 },
        { 125, 52, 193, 98, 4 }, },
      { { 247, 169, 183, 234, 6 },
        { 145, 251, 114, 219, 15 },
        { 101, 126, 217, 94, 15 },
        { 253, 180, 237, 248, 9 }, },
      { { 247, 138, 138, 92, 2 },
        { 136, 248, 188, 203, 8 },
        { 67, 165, 21, 30, 15 },
        { 29, 51, 209, 241, 1 }, },
      { { 243, 237, 194, 21, 2 },
        { 41, 222, 176, 231, 8 },
        { 74, 132, 59, 124, 15 },
        { 30, 112, 215, 185, 4 }, },
      { { 245, 245, 148, 242, 4 },
        { 193, 143, 242, 250, 3 },
        { 36, 242, 154, 250, 15 },
        { 197, 244, 255, 24, 3 }, },
      { { 248, 15, 62, 15, 4 },
        { 10, 107, 108, 182, 13 },
        { 47, 7, 207, 1, 15 },
        { 182, 211, 109, 101, 0 }, },
      { { 252, 190, 99, 125, 14 },
        { 251, 120, 251, 174, 12 },
        { 123, 236, 103, 211, 15 },
        { 55, 93, 241, 237, 15 }, },
      { { 248, 237, 33, 73, 11 },
        { 23, 62, 49, 174, 12 },
        { 217, 40, 75, 113, 15 },
        { 55, 88, 199, 206, 8 }, },
      { { 250, 216, 194, 128, 14 },
        { 98, 220, 113, 131, 10 },
        { 112, 20, 49, 181, 15 },
        { 92, 24, 227, 180, 6 }, },
      { { 254, 229, 5, 156, 6 },
        { 155, 63, 240, 163, 2 },
        { 99, 154, 10, 119, 15 },
        { 76, 80, 255, 205, 9 }, },
      { { 254, 196, 253, 27, 8 },
        { 178, 173, 181, 183, 5 },
        { 29, 139, 242, 55, 15 },
        { 174, 218, 219, 84, 13 }, },
      { { 250, 210, 225, 31, 4 },
        { 122, 172, 248, 135, 5 },
        { 47, 136, 116, 181, 15 },
        { 174, 17, 243, 85, 14 }, },
      { { 252, 195, 230, 115, 2 },
        { 162, 223, 186, 142, 5 },
        { 76, 230, 124, 51, 15 },
        { 167, 21, 223, 180, 5 }, },
      { { 249, 63, 162, 110, 11 },
        { 79, 250, 43, 234, 13 },
        { 215, 100, 95, 201, 15 },
        { 181, 125, 69, 255, 2 }, },
      { { 251, 86, 194, 94, 3 },
        { 110, 252, 168, 235, 1 },
        { 199, 164, 54, 173, 15 },
        { 141, 113, 83, 247, 6 }, },
      { { 255, 78, 140, 162, 15 },
        { 134, 157, 111, 227, 11 },
        { 244, 83, 23, 47, 15 },
        { 220, 127, 107, 150, 1 }, },
      { { 255, 79, 112, 226, 4 },
        { 162, 14, 106, 251, 15 },
        { 36, 112, 239, 47, 15 },
        { 253, 245, 103, 4, 5 }, },
      { { 249, 177, 42, 52, 9 },
        { 79, 74, 183, 194, 4 },
        { 146, 197, 72, 217, 15 },
        { 36, 62, 213, 47, 2 }, },
      { { 255, 135, 146, 120, 1 },
        { 134, 234, 186, 251, 0 },
        { 129, 228, 158, 31, 15 },
        { 13, 245, 213, 118, 1 }, },
      { { 249, 195, 188, 9, 10 },
        { 2, 191, 61, 214, 4 },
        { 89, 3, 220, 57, 15 },
        { 38, 187, 207, 212, 0 }, },
      { { 255, 202, 25, 209, 12 },
        { 146, 12, 253, 223, 10 },
        { 56, 185, 133, 63, 15 },
        { 95, 187, 243, 4, 9 }, },
      { { 255, 239, 23, 165, 10 },
        { 155, 95, 59, 247, 10 },
        { 90, 94, 143, 127, 15 },
        { 94, 253, 207, 173, 9 }, },
      { { 253, 254, 218, 140, 1 },
        { 239, 236, 60, 242, 10 },
        { 131, 21, 183, 251, 15 },
        { 84, 243, 195, 127, 7 }, },
      { { 6, 66, 233, 9, 7 },
        { 180, 180, 76, 5, 4 },
        { 233, 9, 116, 38, 0 },
        { 42, 3, 34, 210, 13 }, },
      { { 3, 36, 36, 70, 13 },
        { 13, 1, 65, 105, 5 },
        { 182, 34, 66, 76, 0 },
        { 169, 104, 40, 11, 0 }, },
      { { 7, 94, 92, 135, 12 },
        { 232, 5, 77, 117, 11 },
        { 62, 19, 167, 174, 0 },
        { 218, 235, 42, 1, 7 }, },
      { { 7, 136, 66, 250, 6 },
        { 160, 112, 210, 73, 11 },
        { 101, 244, 33, 30, 0 },
        { 217, 36, 176, 224, 5 }, },
      { { 10, 7, 178, 27, 11 },
        { 6, 242, 137, 53, 5 },
        { 221, 132, 222, 5, 0 },
        { 170, 201, 20, 246, 0 }, },
      { { 16, 148, 220, 241, 14 },
        { 96, 153, 215, 60, 2 },
        { 120, 243, 178, 144, 8 },
        { 67, 206, 185, 144, 6 }, },
      { { 22, 162, 90, 176, 15 },
        { 165, 88, 223, 17, 2 },
        { 240, 213, 164, 86, 8 },
        { 72, 143, 177, 170, 5 }, },
      { { 16, 253, 203, 109, 14 },
        { 121, 254, 87, 44, 8 },
        { 123, 109, 59, 240, 8 },
        { 19, 78, 167, 249, 14 }, },
      { { 17, 52, 172, 162, 12 },
        { 65, 137, 71, 96, 7 },
        { 52, 83, 82, 200, 8 },
        { 224, 110, 41, 24, 2 }, },
      { { 17, 166, 62, 16, 1 },
        { 5, 73, 156, 112, 4 },
        { 128, 135, 198, 88, 8 },
        { 32, 227, 153, 42, 0 }, },
      { { 30, 88, 44, 226, 2 },
        { 194, 29, 6, 9, 15 },
        { 68, 115, 65, 167, 8 },
        { 249, 6, 11, 132, 3 }, },
      { { 24, 99, 58, 139, 0 },
        { 3, 110, 12, 20, 7 },
        { 13, 21, 204, 97, 8 },
        { 226, 131, 7, 108, 0 }, },
      { { 26, 99, 1, 47, 13 },
        { 31, 46, 75, 5, 1 },
        { 191, 72, 12, 101, 8 },
        { 138, 13, 39, 79, 8 }, },
      { { 26, 241, 71, 206, 15 },
        { 127, 127, 81, 9, 3 },
        { 247, 62, 40, 245, 8 },
        { 201, 8, 175, 239, 14 }, },
      { { 25, 108, 177, 139, 1 },
        { 23, 172, 0, 116, 15 },
        { 141, 24, 211, 105, 8 },
        { 242, 224, 3, 94, 8 }, },
      { { 29, 149, 207, 92, 12 },
        { 250, 235, 213, 104, 0 },
        { 51, 175, 58, 155, 8 },
        { 1, 106, 189, 117, 15 }, },
      { { 25, 158, 56, 146, 2 },
        { 66, 24, 156, 112, 15 },
        { 68, 145, 199, 153, 8 },
        { 240, 227, 145, 132, 2 }, },
      { { 31, 252, 86, 35, 10 },
        { 227, 93, 19, 117, 9 },
        { 92, 70, 163, 255, 8 },
        { 154, 236, 139, 172, 7 }, },
      { { 36, 27, 41, 179, 3 },
        { 212, 18, 174, 4, 15 },
        { 204, 217, 77, 130, 4 },
        { 242, 7, 84, 130, 11 }, },
      { { 38, 231, 136, 133, 0 },
        { 137, 134, 60, 37, 2 },
        { 10, 17, 30, 118, 4 },
        { 74, 67, 198, 25, 1 }, },
      { { 33, 7, 54, 188, 1 },
        { 12, 99, 170, 112, 6 },
        { 131, 214, 206, 8, 4 },
        { 96, 229, 92, 99, 0 }, },
      { { 40, 77, 70, 86, 10 },
        { 42, 87, 161, 40, 9 },
        { 86, 166, 43, 33, 4 },
        { 145, 72, 94, 165, 4 }, },
      { { 46, 236, 227, 69, 8 },
        { 187, 196, 49, 45, 12 },
        { 26, 44, 115, 119, 4 },
        { 59, 72, 194, 61, 13 }, },
      { { 45, 79, 225, 77, 4 },
        { 186, 166, 104, 108, 12 },
        { 43, 40, 127, 43, 4 },
        { 51, 97, 102, 85, 13 }, },
      { { 45, 138, 40, 60, 7 },
        { 142, 48, 254, 64, 12 },
        { 227, 193, 69, 27, 4 },
        { 48, 39, 240, 199, 1 }, },
      { { 52, 248, 62, 55, 1 },
        { 205, 77, 182, 20, 13 },
        { 142, 199, 193, 242, 12 },
        { 178, 134, 219, 43, 3 }, },
      { { 56, 99, 93, 125, 8 },
        { 59, 47, 175, 28, 0 },
        { 27, 235, 172, 97, 12 },
        { 3, 143, 95, 77, 12 }, },
      { { 63, 162, 28, 196, 12 },
        { 139, 9, 125, 89, 2 },
        { 50, 51, 132, 95, 12 },
        { 73, 171, 233, 13, 1 }, },
      { { 66, 221, 151, 174, 14 },
        { 88, 247, 83, 177, 11 },
        { 119, 94, 155, 180, 2 },
        { 216, 220, 174, 241, 10 }, },
      { { 68, 223, 18, 214, 11 },
        { 204, 86, 153, 184, 11 },
        { 214, 180, 143, 178, 2 },
        { 209, 217, 150, 163, 3 }, },
      { { 65, 58, 205, 236, 8 },
        { 121, 161, 15, 200, 10 },
        { 19, 123, 53, 200, 2 },
        { 81, 63, 8, 89, 14 }, },
      { { 65, 192, 219, 73, 4 },
        { 48, 228, 84, 220, 0 },
        { 41, 45, 176, 56, 2 },
        { 3, 178, 162, 112, 12 }, },
      { { 76, 180, 0, 200, 13 },
        { 199, 32, 81, 168, 2 },
        { 177, 48, 2, 211, 2 },
        { 65, 88, 160, 78, 3 }, },
      { { 73, 35, 72, 149, 2 },
        { 43, 18, 140, 196, 2 },
        { 74, 145, 44, 73, 2 },
        { 66, 51, 20, 141, 4 }, },
      { { 82, 55, 185, 92, 6 },
        { 89, 186, 204, 185, 4 },
        { 99, 169, 222, 196, 10 },
        { 41, 211, 53, 217, 10 }, },
      { { 82, 81, 56, 221, 10 },
        { 72, 62, 133, 157, 6 },
        { 91, 177, 200, 164, 10 },
        { 107, 154, 23, 193, 2 }, },
      { { 94, 113, 146, 65, 3 },
        { 199, 222, 0, 157, 0 },
        { 200, 36, 152, 231, 10 },
        { 11, 144, 7, 190, 3 }, },
      { { 92, 178, 113, 235, 13 },
        { 247, 40, 91, 156, 7 },
        { 189, 120, 228, 211, 10 },
        { 227, 157, 161, 78, 15 }, },
      { { 91, 238, 55, 54, 6 },
        { 27, 93, 218, 241, 13 },
        { 102, 206, 199, 125, 10 },
        { 184, 245, 187, 173, 8 }, },
      { { 96, 5, 132, 21, 2 },
        { 8, 147, 160, 164, 0 },
        { 74, 130, 26, 0, 6 },
        { 2, 80, 92, 145, 0 }, },
      { { 100, 8, 128, 51, 8 },
        { 128, 128, 163, 132, 9 },
        { 28, 192, 17, 2, 6 },
        { 146, 28, 80, 16, 1 }, },
      { { 110, 40, 135, 140, 3 },
        { 159, 241, 32, 129, 10 },
        { 195, 30, 17, 71, 6 },
        { 88, 16, 72, 255, 9 }, },
      { { 108, 85, 84, 181, 7 },
        { 238, 23, 226, 180, 2 },
        { 234, 210, 170, 163, 6 },
        { 66, 212, 126, 135, 7 }, },
      { { 104, 186, 254, 70, 1 },
        { 111, 193, 60, 152, 13 },
        { 134, 39, 245, 209, 6 },
        { 177, 147, 200, 63, 6 }, },
      { { 104, 179, 85, 202, 7 },
        { 119, 51, 120, 152, 3 },
        { 229, 58, 172, 209, 6 },
        { 193, 145, 236, 206, 14 }, },
      { { 117, 156, 155, 102, 9 },
        { 220, 200, 55, 248, 9 },
        { 150, 109, 147, 154, 14 },
        { 145, 254, 193, 51, 11 }, },
      { { 124, 11, 200, 10, 0 },
        { 162, 170, 44, 128, 9 },
        { 5, 1, 61, 3, 14 },
        { 144, 19, 69, 84, 5 }, },
      { { 126, 89, 104, 196, 9 },
        { 238, 14, 37, 137, 14 },
        { 146, 49, 105, 167, 14 },
        { 121, 26, 71, 7, 7 }, },
      { { 120, 111, 61, 52, 5 },
        { 31, 15, 238, 176, 12 },
        { 162, 203, 207, 97, 14 },
        { 48, 215, 127, 15, 8 }, },
      { { 120, 193, 191, 255, 10 },
        { 26, 255, 183, 156, 7 },
        { 95, 255, 216, 49, 14 },
        { 227, 158, 223, 245, 8 }, },
      { { 122, 218, 185, 69, 10 },
        { 90, 156, 61, 157, 12 },
        { 90, 41, 213, 181, 14 },
        { 59, 155, 195, 149, 10 }, },
      { { 128, 60, 123, 156, 0 },
        { 121, 96, 132, 50, 14 },
        { 3, 157, 227, 192, 1 },
        { 116, 194, 16, 105, 14 }, },
      { { 135, 20, 88, 249, 7 },
        { 228, 48, 198, 127, 2 },
        { 233, 241, 162, 142, 1 },
        { 79, 230, 48, 194, 7 }, },
      { { 131, 27, 5, 165, 13 },
        { 92, 3, 75, 71, 10 },
        { 186, 90, 13, 140, 1 },
        { 94, 45, 44, 3, 10 }, },
      { { 136, 59, 180, 103, 4 },
        { 75, 131, 74, 30, 13 },
        { 46, 98, 221, 193, 1 },
        { 183, 133, 44, 29, 2 }, },
      { { 140, 169, 136, 156, 0 },
        { 139, 162, 148, 2, 10 },
        { 3, 145, 25, 83, 1 },
        { 84, 2, 148, 93, 1 }, },
      { { 142, 177, 3, 26, 11 },
        { 215, 114, 145, 3, 1 },
        { 213, 140, 8, 215, 1 },
        { 140, 8, 148, 238, 11 }, },
      { { 143, 39, 191, 54, 4 },
        { 155, 195, 206, 115, 5 },
        { 38, 207, 222, 79, 1 },
        { 172, 231, 60, 61, 9 }, },
      { { 143, 22, 179, 202, 0 },
        { 210, 224, 8, 123, 7 },
        { 5, 60, 214, 143, 1 },
        { 237, 225, 0, 116, 11 }, },
      { { 148, 24, 222, 74, 0 },
        { 224, 233, 4, 26, 9 },
        { 5, 39, 177, 130, 9 },
        { 149, 130, 9, 112, 7 }, },
      { { 147, 69, 36, 197, 0 },
        { 8, 15, 0, 111, 6 },
        { 10, 50, 74, 44, 9 },
        { 111, 96, 15, 1, 0 }, },
      { { 156, 253, 156, 216, 5 },
        { 199, 175, 212, 58, 10 },
        { 161, 179, 155, 243, 9 },
        { 85, 194, 191, 94, 3 }, },
      { { 155, 34, 55, 120, 13 },
        { 23, 105, 203, 91, 4 },
        { 177, 238, 196, 77, 9 },
        { 45, 173, 57, 110, 8 }, },
      { { 153, 250, 163, 209, 6 },
        { 83, 220, 216, 78, 14 },
        { 104, 188, 85, 249, 9 },
        { 119, 33, 179, 188, 10 }, },
      { { 162, 159, 28, 84, 3 },
        { 76, 19, 188, 59, 8 },
        { 194, 163, 143, 148, 5 },
        { 29, 195, 220, 131, 2 }, },
      { { 172, 79, 91, 26, 11 },
        { 182, 118, 173, 50, 9 },
        { 213, 141, 175, 35, 5 },
        { 148, 203, 86, 230, 13 }, },
      { { 172, 191, 109, 54, 6 },
        { 251, 19, 254, 34, 13 },
        { 102, 203, 111, 211, 5 },
        { 180, 71, 252, 141, 15 }, },
      { { 169, 185, 76, 64, 8 },
        { 99, 3, 53, 74, 8 },
        { 16, 35, 41, 217, 5 },
        { 21, 42, 204, 12, 6 }, },
      { { 182, 40, 233, 2, 12 },
        { 177, 136, 101, 3, 13 },
        { 52, 9, 113, 70, 13 },
        { 188, 10, 97, 24, 13 }, },
      { { 180, 109, 218, 222, 0 },
        { 169, 238, 164, 58, 11 },
        { 7, 181, 187, 98, 13 },
        { 213, 194, 87, 121, 5 }, },
      { { 178, 110, 246, 10, 1 },
        { 37, 237, 40, 51, 13 },
        { 133, 6, 247, 100, 13 },
        { 188, 193, 75, 122, 4 }, },
      { { 179, 37, 153, 105, 14 },
        { 17, 186, 103, 127, 0 },
        { 121, 105, 154, 76, 13 },
        { 15, 238, 101, 216, 8 }, },
      { { 179, 80, 40, 17, 5 },
        { 68, 12, 228, 71, 4 },
        { 168, 129, 64, 172, 13 },
        { 46, 34, 115, 2, 2 }, },
      { { 190, 28, 27, 59, 6 },
        { 210, 120, 230, 55, 9 },
        { 109, 205, 131, 135, 13 },
        { 158, 198, 113, 228, 11 }, },
      { { 188, 127, 85, 99, 14 },
        { 243, 31, 107, 62, 9 },
        { 124, 106, 175, 227, 13 },
        { 151, 205, 111, 140, 15 }, },
      { { 188, 175, 230, 141, 5 },
        { 175, 235, 120, 38, 14 },
        { 171, 22, 127, 83, 13 },
        { 118, 65, 237, 127, 5 }, },
      { { 189, 37, 146, 140, 4 },
        { 139, 234, 96, 114, 2 },
        { 35, 20, 154, 75, 13 },
        { 68, 224, 101, 125, 1 }, },
      { { 196, 27, 214, 183, 1 },
        { 236, 195, 138, 150, 11 },
        { 142, 214, 189, 130, 3 },
        { 214, 149, 28, 51, 7 }, },
      { { 198, 99, 190, 252, 14 },
        { 137, 247, 207, 155, 6 },
        { 115, 247, 220, 102, 3 },
        { 109, 159, 62, 249, 1 }, },
      { { 198, 86, 130, 19, 13 },
        { 196, 196, 201, 167, 1 },
        { 188, 132, 22, 166, 3 },
        { 142, 89, 50, 50, 3 }, },
      { { 198, 139, 73, 36, 10 },
        { 184, 18, 31, 131, 8 },
        { 82, 73, 45, 22, 3 },
        { 28, 31, 132, 129, 13 }, },
      { { 193, 61, 206, 190, 2 },
        { 105, 243, 134, 226, 11 },
        { 71, 215, 59, 200, 3 },
        { 212, 118, 28, 249, 6 }, },
      { { 197, 25, 109, 109, 1 },
        { 252, 35, 6, 206, 12 },
        { 139, 107, 105, 138, 3 },
        { 55, 54, 12, 67, 15 }, },
      { { 199, 77, 61, 239, 11 },
        { 156, 55, 7, 255, 15 },
        { 223, 123, 203, 46, 3 },
        { 255, 254, 14, 195, 9 }, },
      { { 193, 90, 43, 220, 9 },
        { 92, 100, 141, 202, 14 },
        { 147, 189, 69, 168, 3 },
        { 117, 59, 18, 99, 10 }, },
      { { 202, 35, 114, 33, 12 },
        { 35, 66, 75, 151, 4 },
        { 56, 68, 236, 69, 3 },
        { 46, 157, 36, 44, 4 }, },
      { { 207, 199, 244, 213, 9 },
        { 174, 135, 153, 255, 6 },
        { 154, 178, 254, 63, 3 },
        { 111, 249, 158, 23, 5 }, },
      { { 208, 49, 39, 226, 6 },
        { 81, 91, 66, 138, 7 },
        { 100, 126, 72, 192, 11 },
        { 229, 20, 45, 168, 10 }, },
      { { 212, 119, 84, 14, 0 },
        { 233, 47, 8, 178, 1 },
        { 7, 2, 174, 226, 11 },
        { 132, 209, 15, 73, 7 }, },
      { { 209, 134, 49, 90, 2 },
        { 16, 56, 152, 250, 5 },
        { 69, 168, 198, 24, 11 },
        { 165, 241, 145, 192, 8 }, },
      { { 219, 76, 100, 122, 11 },
        { 38, 61, 131, 235, 13 },
        { 213, 226, 99, 45, 11 },
        { 189, 124, 27, 198, 4 }, },
      { { 219, 132, 135, 144, 8 },
        { 18, 201, 145, 227, 2 },
        { 16, 158, 18, 29, 11 },
        { 76, 120, 153, 52, 8 }, },
      { { 223, 222, 6, 112, 0 },
        { 194, 77, 154, 235, 8 },
        { 0, 230, 7, 191, 11 },
        { 29, 117, 155, 36, 3 }, },
      { { 226, 41, 186, 96, 0 },
        { 1, 194, 38, 155, 12 },
        { 0, 101, 217, 68, 7 },
        { 61, 150, 68, 56, 0 }, },
      { { 225, 64, 224, 141, 6 },
        { 40, 180, 96, 198, 6 },
        { 107, 16, 112, 40, 7 },
        { 102, 48, 98, 209, 4 }, },
      { { 225, 154, 144, 165, 2 },
        { 72, 144, 58, 214, 10 },
        { 74, 80, 149, 152, 7 },
        { 86, 181, 192, 145, 2 }, },
      { { 231, 242, 192, 250, 9 },
        { 229, 164, 187, 203, 3 },
        { 149, 240, 52, 254, 7 },
        { 205, 61, 210, 90, 7 }, },
      { { 238, 173, 190, 131, 8 },
        { 131, 195, 53, 183, 15 },
        { 28, 23, 219, 87, 7 },
        { 254, 218, 204, 60, 1 }, },
      { { 240, 28, 242, 124, 1 },
        { 108, 232, 162, 186, 12 },
        { 131, 228, 243, 128, 15 },
        { 53, 212, 81, 115, 6 }, },
      { { 247, 101, 168, 38, 4 },
        { 137, 142, 102, 227, 5 },
        { 38, 65, 90, 110, 15 },
        { 172, 118, 103, 25, 1 }, },
      { { 247, 236, 195, 164, 13 },
        { 189, 204, 115, 227, 10 },
        { 178, 92, 51, 126, 15 },
        { 92, 124, 227, 59, 13 }, },
      { { 248, 45, 84, 113, 4 },
        { 35, 11, 226, 190, 8 },
        { 40, 226, 171, 65, 15 },
        { 23, 212, 125, 12, 4 }, },
      { { 254, 133, 143, 205, 11 },
        { 158, 251, 53, 175, 2 },
        { 219, 63, 26, 23, 15 },
        { 79, 90, 205, 247, 9 }, },
      { { 248, 227, 91, 11, 6 },
        { 51, 126, 124, 150, 1 },
        { 109, 13, 172, 113, 15 },
        { 134, 147, 231, 236, 12 }, },
      { { 254, 214, 62, 31, 15 },
        { 206, 125, 253, 183, 5 },
        { 255, 135, 198, 183, 15 },
        { 174, 219, 251, 231, 3 }, }, };

static unsigned char DICT_7X7_1000_BYTES[][4][7] =
    { { { 221, 92, 108, 165, 202, 10, 1 },
        { 99, 179, 173, 228, 49, 180, 0 },
        { 168, 41, 210, 155, 29, 93, 1 },
        { 22, 198, 19, 218, 230, 227, 0 }, },
      { { 228, 27, 241, 62, 64, 171, 0 },
        { 17, 253, 137, 11, 181, 42, 1 },
        { 106, 129, 62, 71, 236, 19, 1 },
        { 170, 86, 232, 72, 223, 196, 0 }, },
      { { 158, 170, 43, 172, 93, 39, 1 },
        { 163, 182, 158, 145, 75, 171, 1 },
        { 242, 93, 26, 234, 42, 188, 1 },
        { 234, 233, 68, 188, 182, 226, 1 }, },
      { { 166, 103, 5, 183, 233, 76, 0 },
        { 221, 48, 50, 221, 165, 172, 0 },
        { 25, 75, 246, 208, 115, 50, 1 },
        { 26, 210, 221, 166, 6, 93, 1 }, },
      { { 198, 188, 123, 19, 50, 86, 0 },
        { 253, 193, 139, 113, 154, 97, 0 },
        { 53, 38, 100, 111, 30, 177, 1 },
        { 67, 44, 199, 104, 193, 223, 1 }, },
      { { 88, 128, 20, 35, 89, 238, 0 },
        { 4, 122, 28, 80, 184, 133, 1 },
        { 59, 205, 98, 20, 0, 141, 0 },
        { 208, 142, 133, 28, 47, 16, 0 }, },
      { { 211, 107, 190, 111, 84, 72, 0 },
        { 164, 240, 198, 70, 247, 63, 0 },
        { 9, 21, 123, 62, 235, 101, 1 },
        { 126, 119, 177, 49, 135, 146, 1 }, },
      { { 60, 161, 109, 136, 139, 219, 0 },
        { 37, 14, 191, 169, 44, 198, 0 },
        { 109, 232, 136, 219, 66, 158, 0 },
        { 49, 154, 74, 254, 184, 82, 0 }, },
      { { 137, 7, 31, 86, 150, 158, 0 },
        { 112, 74, 104, 49, 231, 125, 0 },
        { 60, 180, 181, 124, 112, 72, 1 },
        { 95, 115, 198, 11, 41, 7, 0 }, },
      { { 187, 101, 177, 141, 110, 63, 0 },
        { 200, 86, 142, 255, 101, 242, 1 },
        { 126, 59, 88, 198, 211, 110, 1 },
        { 167, 211, 127, 184, 181, 9, 1 }, },
      { { 245, 0, 209, 130, 244, 144, 1 },
        { 11, 88, 37, 139, 208, 113, 0 },
        { 132, 151, 160, 197, 128, 87, 1 },
        { 71, 5, 232, 210, 13, 104, 0 }, },
      { { 2, 38, 112, 184, 84, 26, 0 },
        { 208, 112, 139, 128, 96, 75, 0 },
        { 44, 21, 14, 135, 50, 32, 0 },
        { 105, 3, 0, 232, 135, 5, 1 }, },
      { { 84, 243, 107, 151, 72, 240, 1 },
        { 55, 25, 135, 197, 159, 200, 1 },
        { 135, 137, 116, 235, 103, 149, 0 },
        { 137, 252, 209, 240, 204, 118, 0 }, },
      { { 158, 36, 136, 70, 35, 153, 1 },
        { 235, 14, 86, 34, 161, 96, 0 },
        { 204, 226, 49, 8, 146, 60, 1 },
        { 3, 66, 162, 53, 56, 107, 1 }, },
      { { 189, 255, 50, 107, 201, 203, 1 },
        { 71, 255, 254, 76, 174, 186, 0 },
        { 233, 201, 235, 38, 127, 222, 1 },
        { 46, 186, 153, 63, 255, 241, 0 }, },
      { { 206, 17, 5, 176, 90, 151, 1 },
        { 147, 63, 8, 177, 20, 229, 0 },
        { 244, 173, 6, 208, 68, 57, 1 },
        { 83, 148, 70, 136, 126, 100, 1 }, },
      { { 211, 240, 97, 114, 31, 139, 0 },
        { 144, 45, 223, 37, 248, 177, 0 },
        { 104, 252, 39, 67, 7, 229, 1 },
        { 70, 143, 210, 125, 218, 4, 1 }, },
      { { 1, 225, 158, 206, 200, 237, 1 },
        { 38, 92, 98, 150, 175, 150, 1 },
        { 219, 137, 185, 188, 195, 192, 0 },
        { 180, 250, 180, 163, 29, 50, 0 }, },
      { { 38, 203, 204, 42, 112, 120, 1 },
        { 175, 176, 1, 14, 172, 79, 1 },
        { 143, 7, 42, 25, 233, 178, 0 },
        { 249, 26, 184, 64, 6, 250, 1 }, },
      { { 56, 125, 77, 118, 65, 19, 0 },
        { 112, 183, 95, 13, 133, 68, 0 },
        { 100, 65, 55, 89, 95, 14, 0 },
        { 17, 80, 216, 125, 118, 135, 0 }, },
      { { 58, 144, 74, 233, 225, 233, 1 },
        { 174, 63, 117, 200, 42, 2, 1 },
        { 203, 195, 203, 169, 4, 174, 0 },
        { 160, 42, 9, 215, 126, 58, 1 }, },
      { { 70, 212, 132, 123, 60, 221, 0 },
        { 221, 45, 64, 86, 248, 199, 0 },
        { 93, 158, 111, 16, 149, 177, 0 },
        { 113, 143, 181, 1, 90, 93, 1 }, },
      { { 72, 146, 167, 222, 158, 43, 1 },
        { 18, 7, 232, 163, 251, 143, 1 },
        { 234, 60, 189, 242, 164, 137, 0 },
        { 248, 239, 226, 139, 240, 36, 0 }, },
      { { 94, 118, 195, 228, 152, 168, 0 },
        { 193, 43, 103, 135, 51, 137, 1 },
        { 10, 140, 147, 225, 183, 61, 0 },
        { 200, 230, 112, 243, 106, 65, 1 }, },
      { { 116, 162, 222, 250, 47, 136, 1 },
        { 59, 104, 87, 170, 250, 142, 0 },
        { 136, 250, 47, 189, 162, 151, 0 },
        { 56, 175, 170, 245, 11, 110, 0 }, },
      { { 148, 93, 226, 40, 19, 89, 0 },
        { 69, 165, 149, 38, 38, 99, 0 },
        { 77, 100, 10, 35, 221, 20, 1 },
        { 99, 50, 50, 84, 210, 209, 0 }, },
      { { 155, 18, 149, 100, 237, 163, 1 },
        { 138, 127, 124, 3, 65, 188, 1 },
        { 226, 219, 147, 84, 164, 108, 1 },
        { 158, 193, 96, 31, 127, 40, 1 }, },
      { { 161, 212, 148, 45, 130, 248, 0 },
        { 68, 105, 32, 110, 41, 118, 1 },
        { 15, 160, 218, 20, 149, 194, 1 },
        { 183, 74, 59, 2, 75, 17, 0 }, },
      { { 187, 120, 230, 49, 108, 208, 1 },
        { 158, 187, 135, 78, 66, 244, 0 },
        { 133, 155, 70, 51, 143, 110, 1 },
        { 23, 161, 57, 112, 238, 188, 1 }, },
      { { 203, 181, 221, 203, 219, 24, 0 },
        { 224, 83, 115, 227, 188, 247, 0 },
        { 12, 109, 233, 221, 214, 233, 1 },
        { 119, 158, 227, 231, 101, 3, 1 }, },
      { { 211, 229, 238, 183, 131, 51, 0 },
        { 240, 36, 191, 230, 159, 116, 1 },
        { 102, 96, 246, 187, 211, 229, 1 },
        { 151, 124, 179, 254, 146, 7, 1 }, },
      { { 242, 148, 35, 63, 209, 156, 1 },
        { 210, 57, 180, 89, 187, 99, 0 },
        { 156, 197, 254, 98, 20, 167, 1 },
        { 99, 110, 205, 22, 206, 37, 1 }, },
      { { 253, 214, 209, 159, 59, 230, 1 },
        { 95, 75, 29, 255, 153, 187, 1 },
        { 179, 238, 124, 197, 181, 223, 1 },
        { 238, 204, 255, 220, 105, 125, 0 }, },
      { { 58, 70, 36, 238, 132, 238, 1 },
        { 198, 42, 236, 156, 225, 14, 1 },
        { 187, 144, 187, 146, 49, 46, 0 },
        { 184, 67, 156, 155, 170, 49, 1 }, },
      { { 98, 24, 126, 36, 59, 15, 0 },
        { 168, 229, 153, 56, 51, 133, 0 },
        { 120, 110, 18, 63, 12, 35, 0 },
        { 80, 230, 14, 76, 211, 138, 1 }, },
      { { 10, 205, 67, 111, 157, 195, 0 },
        { 196, 174, 121, 69, 207, 131, 0 },
        { 97, 220, 251, 97, 89, 168, 0 },
        { 96, 249, 209, 79, 58, 145, 1 }, },
      { { 14, 64, 212, 195, 142, 2, 0 },
        { 129, 66, 105, 230, 192, 132, 0 },
        { 32, 56, 225, 149, 129, 56, 0 },
        { 16, 129, 179, 203, 33, 64, 1 }, },
      { { 20, 159, 217, 160, 98, 36, 0 },
        { 105, 241, 5, 179, 12, 8, 1 },
        { 18, 35, 2, 205, 252, 148, 0 },
        { 136, 24, 102, 208, 71, 203, 0 }, },
      { { 25, 162, 225, 26, 101, 237, 0 },
        { 28, 30, 151, 19, 232, 26, 1 },
        { 91, 211, 44, 67, 162, 204, 0 },
        { 172, 11, 228, 116, 188, 28, 0 }, },
      { { 43, 80, 130, 126, 27, 52, 0 },
        { 144, 35, 80, 62, 131, 211, 1 },
        { 22, 108, 63, 32, 133, 106, 0 },
        { 229, 224, 190, 5, 98, 4, 1 }, },
      { { 41, 105, 56, 146, 159, 163, 0 },
        { 48, 206, 186, 172, 196, 145, 1 },
        { 98, 252, 164, 142, 75, 74, 0 },
        { 196, 145, 154, 174, 185, 134, 0 }, },
      { { 44, 247, 84, 219, 244, 86, 1 },
        { 95, 83, 107, 220, 204, 79, 0 },
        { 181, 23, 237, 149, 119, 154, 0 },
        { 121, 25, 157, 235, 101, 125, 0 }, },
      { { 53, 233, 63, 158, 54, 124, 0 },
        { 61, 192, 134, 189, 239, 87, 1 },
        { 31, 54, 60, 254, 75, 214, 0 },
        { 245, 123, 222, 176, 129, 222, 0 }, },
      { { 63, 116, 171, 216, 61, 243, 1 },
        { 255, 15, 222, 143, 66, 211, 1 },
        { 231, 222, 13, 234, 151, 126, 0 },
        { 229, 161, 120, 189, 248, 127, 1 }, },
      { { 68, 208, 41, 244, 255, 64, 0 },
        { 61, 49, 240, 165, 89, 129, 0 },
        { 1, 127, 151, 202, 5, 145, 0 },
        { 64, 205, 82, 135, 198, 94, 0 }, },
      { { 72, 64, 228, 132, 42, 245, 0 },
        { 12, 14, 129, 182, 17, 196, 1 },
        { 87, 170, 16, 147, 129, 9, 0 },
        { 145, 196, 54, 192, 184, 24, 0 }, },
      { { 95, 25, 19, 104, 52, 2, 0 },
        { 137, 227, 76, 1, 86, 19, 0 },
        { 32, 22, 11, 100, 76, 125, 0 },
        { 100, 53, 64, 25, 99, 200, 1 }, },
      { { 94, 178, 114, 64, 61, 93, 1 },
        { 143, 71, 215, 16, 122, 201, 0 },
        { 221, 94, 1, 39, 38, 189, 0 },
        { 73, 175, 4, 117, 241, 120, 1 }, },
      { { 111, 155, 36, 31, 21, 194, 0 },
        { 149, 139, 152, 72, 221, 31, 0 },
        { 33, 212, 124, 18, 108, 251, 0 },
        { 124, 93, 137, 12, 232, 212, 1 }, },
      { { 114, 170, 249, 32, 168, 227, 1 },
        { 174, 236, 175, 11, 24, 136, 1 },
        { 227, 138, 130, 79, 170, 167, 0 },
        { 136, 140, 104, 122, 155, 186, 1 }, },
      { { 121, 136, 117, 59, 134, 54, 1 },
        { 18, 226, 173, 121, 216, 86, 1 },
        { 182, 48, 238, 87, 8, 207, 0 },
        { 181, 13, 207, 90, 163, 164, 0 }, },
      { { 123, 231, 19, 174, 121, 81, 1 },
        { 206, 118, 22, 141, 159, 219, 0 },
        { 197, 79, 58, 228, 115, 239, 0 },
        { 109, 252, 216, 180, 55, 57, 1 }, },
      { { 133, 106, 70, 201, 89, 224, 0 },
        { 5, 152, 83, 196, 2, 191, 1 },
        { 3, 205, 73, 177, 43, 80, 1 },
        { 254, 160, 17, 229, 12, 208, 0 }, },
      { { 142, 63, 238, 242, 217, 81, 1 },
        { 247, 183, 243, 130, 134, 237, 0 },
        { 197, 77, 167, 187, 254, 56, 1 },
        { 91, 176, 160, 231, 246, 247, 1 }, },
      { { 173, 56, 205, 33, 115, 103, 1 },
        { 47, 183, 27, 123, 0, 53, 1 },
        { 243, 103, 66, 89, 142, 90, 1 },
        { 214, 0, 111, 108, 118, 250, 0 }, },
      { { 177, 55, 37, 48, 185, 63, 1 },
        { 90, 37, 190, 25, 36, 253, 1 },
        { 254, 78, 134, 82, 118, 70, 1 },
        { 223, 146, 76, 62, 210, 45, 0 }, },
      { { 186, 195, 128, 210, 81, 219, 0 },
        { 148, 30, 92, 142, 172, 105, 0 },
        { 109, 197, 37, 128, 225, 174, 1 },
        { 75, 26, 184, 157, 60, 20, 1 }, },
      { { 193, 117, 109, 93, 24, 166, 1 },
        { 114, 9, 203, 85, 21, 183, 1 },
        { 178, 140, 93, 91, 87, 65, 1 },
        { 246, 212, 85, 105, 200, 39, 0 }, },
      { { 206, 97, 211, 126, 229, 17, 0 },
        { 153, 118, 115, 7, 215, 98, 0 },
        { 68, 83, 191, 101, 195, 57, 1 },
        { 35, 117, 240, 103, 55, 76, 1 }, },
      { { 210, 92, 152, 54, 221, 91, 1 },
        { 246, 245, 60, 6, 241, 225, 0 },
        { 237, 93, 182, 12, 157, 37, 1 },
        { 67, 199, 176, 30, 87, 183, 1 }, },
      { { 208, 106, 145, 233, 239, 206, 1 },
        { 14, 248, 126, 247, 112, 170, 0 },
        { 185, 251, 203, 196, 171, 5, 1 },
        { 42, 135, 119, 191, 15, 184, 0 }, },
      { { 73, 228, 227, 141, 169, 90, 1 },
        { 78, 2, 187, 199, 59, 210, 0 },
        { 173, 74, 216, 227, 147, 201, 0 },
        { 37, 238, 113, 238, 160, 57, 0 }, },
      { { 82, 209, 159, 40, 31, 179, 0 },
        { 160, 109, 28, 39, 94, 199, 1 },
        { 102, 252, 10, 124, 197, 165, 0 },
        { 241, 189, 114, 28, 91, 2, 1 }, },
      { { 2, 24, 175, 24, 115, 160, 1 },
        { 186, 153, 144, 35, 2, 7, 1 },
        { 130, 231, 12, 122, 140, 32, 0 },
        { 240, 32, 98, 4, 204, 174, 1 }, },
      { { 5, 192, 75, 56, 81, 119, 0 },
        { 53, 52, 25, 21, 10, 83, 1 },
        { 119, 69, 14, 105, 1, 208, 0 },
        { 229, 40, 84, 76, 22, 86, 0 }, },
      { { 15, 88, 169, 33, 137, 159, 0 },
        { 161, 175, 184, 87, 32, 208, 0 },
        { 124, 200, 194, 74, 141, 120, 0 },
        { 5, 130, 117, 14, 250, 194, 1 }, },
      { { 15, 206, 165, 68, 68, 26, 0 },
        { 193, 146, 200, 7, 105, 92, 0 },
        { 44, 17, 17, 82, 185, 248, 0 },
        { 29, 75, 112, 9, 164, 193, 1 }, },
      { { 21, 238, 211, 115, 20, 216, 1 },
        { 87, 232, 71, 71, 234, 89, 0 },
        { 141, 148, 103, 101, 187, 212, 0 },
        { 77, 43, 241, 113, 11, 245, 0 }, },
      { { 22, 241, 226, 252, 69, 158, 1 },
        { 147, 57, 223, 150, 111, 66, 0 },
        { 188, 209, 31, 163, 199, 180, 0 },
        { 33, 123, 52, 253, 206, 100, 1 }, },
      { { 30, 94, 76, 65, 59, 115, 0 },
        { 237, 135, 93, 100, 0, 205, 1 },
        { 103, 110, 65, 25, 61, 60, 0 },
        { 217, 128, 19, 93, 112, 219, 1 }, },
      { { 31, 194, 82, 102, 200, 118, 1 },
        { 135, 114, 109, 20, 139, 216, 1 },
        { 183, 9, 179, 37, 33, 252, 0 },
        { 141, 232, 148, 91, 39, 112, 1 }, },
      { { 39, 33, 22, 246, 49, 159, 1 },
        { 155, 108, 90, 152, 167, 85, 0 },
        { 252, 198, 55, 180, 66, 114, 0 },
        { 85, 114, 140, 173, 27, 108, 1 }, },
      { { 39, 155, 122, 137, 27, 220, 0 },
        { 165, 201, 145, 248, 46, 219, 0 },
        { 29, 236, 72, 175, 108, 242, 0 },
        { 109, 186, 15, 196, 201, 210, 1 }, },
      { { 46, 12, 48, 75, 106, 108, 0 },
        { 205, 210, 192, 120, 160, 130, 1 },
        { 27, 43, 105, 6, 24, 58, 0 },
        { 160, 130, 143, 1, 165, 217, 1 }, },
      { { 47, 169, 226, 121, 230, 43, 0 },
        { 153, 182, 235, 106, 110, 18, 1 },
        { 106, 51, 207, 35, 202, 250, 0 },
        { 164, 59, 43, 107, 182, 204, 1 }, },
      { { 44, 207, 211, 2, 147, 19, 1 },
        { 67, 198, 57, 47, 142, 73, 0 },
        { 228, 100, 160, 101, 249, 154, 0 },
        { 73, 56, 250, 78, 49, 225, 0 }, },
      { { 49, 83, 3, 2, 18, 230, 1 },
        { 6, 9, 12, 61, 134, 25, 1 },
        { 179, 164, 32, 96, 101, 70, 0 },
        { 204, 48, 222, 24, 72, 48, 0 }, },
      { { 48, 120, 115, 90, 253, 41, 1 },
        { 26, 213, 247, 13, 226, 131, 1 },
        { 202, 95, 173, 103, 15, 6, 0 },
        { 224, 163, 216, 119, 213, 172, 0 }, },
      { { 55, 226, 67, 44, 167, 160, 1 },
        { 139, 40, 55, 45, 75, 26, 1 },
        { 130, 242, 154, 97, 35, 246, 0 },
        { 172, 105, 90, 118, 10, 104, 1 }, },
      { { 76, 11, 79, 138, 255, 84, 0 },
        { 45, 146, 49, 177, 214, 207, 0 },
        { 21, 127, 168, 249, 104, 25, 0 },
        { 121, 181, 198, 198, 36, 218, 0 }, },
      { { 78, 218, 184, 202, 73, 33, 1 },
        { 163, 215, 208, 134, 152, 138, 1 },
        { 194, 73, 41, 142, 173, 185, 0 },
        { 168, 140, 176, 133, 245, 226, 1 }, },
      { { 76, 218, 221, 21, 152, 110, 0 },
        { 53, 195, 41, 87, 57, 141, 1 },
        { 59, 12, 212, 93, 173, 153, 0 },
        { 216, 206, 117, 74, 97, 214, 0 }, },
      { { 86, 123, 85, 187, 37, 96, 1 },
        { 159, 225, 23, 197, 212, 14, 1 },
        { 131, 82, 110, 213, 111, 53, 0 },
        { 184, 21, 209, 244, 67, 252, 1 }, },
      { { 84, 151, 117, 241, 41, 203, 0 },
        { 93, 109, 221, 193, 60, 140, 0 },
        { 105, 202, 71, 215, 116, 149, 0 },
        { 24, 158, 65, 221, 219, 93, 0 }, },
      { { 84, 152, 140, 205, 4, 162, 0 },
        { 33, 137, 76, 194, 89, 6, 1 },
        { 34, 144, 89, 152, 140, 149, 0 },
        { 176, 77, 33, 153, 72, 194, 0 }, },
      { { 94, 110, 164, 168, 119, 169, 0 },
        { 201, 190, 150, 166, 112, 15, 1 },
        { 74, 247, 10, 146, 187, 61, 0 },
        { 248, 7, 50, 180, 190, 201, 1 }, },
      { { 99, 4, 81, 119, 99, 178, 0 },
        { 216, 120, 89, 105, 145, 80, 1 },
        { 38, 227, 119, 69, 16, 99, 0 },
        { 133, 68, 203, 77, 15, 13, 1 }, },
      { { 105, 226, 58, 120, 116, 228, 1 },
        { 62, 122, 194, 28, 90, 27, 1 },
        { 147, 151, 15, 46, 35, 203, 0 },
        { 236, 45, 28, 33, 175, 62, 0 }, },
      { { 109, 23, 226, 74, 80, 28, 1 },
        { 67, 19, 193, 26, 182, 91, 0 },
        { 156, 5, 41, 35, 244, 91, 0 },
        { 109, 54, 172, 65, 228, 97, 0 }, },
      { { 112, 62, 128, 226, 203, 177, 0 },
        { 64, 189, 118, 170, 144, 200, 1 },
        { 70, 233, 163, 128, 190, 7, 0 },
        { 137, 132, 170, 183, 94, 129, 0 }, },
      { { 119, 80, 90, 139, 20, 43, 1 },
        { 163, 69, 13, 204, 242, 19, 1 },
        { 234, 20, 104, 173, 5, 119, 0 },
        { 228, 39, 153, 216, 81, 98, 1 }, },
      { { 130, 100, 225, 43, 36, 151, 1 },
        { 202, 44, 139, 87, 192, 98, 0 },
        { 244, 146, 106, 67, 147, 32, 1 },
        { 35, 1, 245, 104, 154, 41, 1 }, },
      { { 131, 253, 167, 209, 241, 197, 0 },
        { 220, 157, 242, 215, 14, 53, 0 },
        { 81, 199, 197, 242, 223, 224, 1 },
        { 86, 56, 117, 167, 220, 157, 1 }, },
      { { 147, 189, 107, 77, 96, 125, 1 },
        { 238, 149, 199, 81, 47, 114, 1 },
        { 223, 3, 89, 107, 94, 228, 1 },
        { 167, 122, 69, 113, 212, 187, 1 }, },
      { { 148, 216, 165, 194, 122, 237, 1 },
        { 15, 157, 196, 183, 168, 165, 1 },
        { 219, 175, 33, 210, 141, 148, 1 },
        { 210, 138, 246, 145, 220, 248, 0 }, },
      { { 148, 247, 189, 26, 15, 79, 1 },
        { 119, 69, 158, 55, 236, 174, 0 },
        { 249, 120, 44, 94, 247, 148, 1 },
        { 58, 155, 246, 60, 209, 119, 0 }, },
      { { 152, 241, 170, 62, 148, 248, 0 },
        { 52, 43, 166, 6, 239, 99, 1 },
        { 15, 148, 190, 42, 199, 140, 1 },
        { 227, 123, 176, 50, 234, 22, 0 }, },
      { { 169, 138, 223, 140, 87, 40, 0 },
        { 32, 210, 17, 171, 107, 63, 1 },
        { 10, 117, 24, 253, 168, 202, 1 },
        { 254, 107, 106, 196, 37, 130, 0 }, },
      { { 177, 14, 54, 223, 65, 63, 0 },
        { 80, 212, 220, 216, 163, 126, 1 },
        { 126, 65, 125, 182, 56, 70, 1 },
        { 191, 98, 141, 157, 149, 133, 0 }, },
      { { 185, 234, 28, 100, 226, 107, 0 },
        { 44, 246, 110, 44, 41, 60, 1 },
        { 107, 35, 147, 28, 43, 206, 1 },
        { 158, 74, 26, 59, 55, 154, 0 }, },
      { { 188, 38, 74, 240, 242, 183, 1 },
        { 123, 62, 111, 184, 2, 105, 1 },
        { 246, 167, 135, 169, 50, 30, 1 },
        { 203, 32, 14, 251, 62, 111, 0 }, },
      { { 189, 63, 146, 218, 126, 170, 0 },
        { 89, 219, 78, 170, 230, 187, 1 },
        { 42, 191, 45, 164, 254, 94, 1 },
        { 238, 179, 170, 185, 109, 205, 0 }, },
      { { 192, 53, 46, 74, 202, 87, 0 },
        { 100, 21, 234, 48, 150, 230, 0 },
        { 117, 41, 169, 58, 86, 1, 1 },
        { 51, 180, 134, 43, 212, 19, 0 }, },
      { { 194, 54, 220, 36, 22, 128, 1 },
        { 226, 105, 3, 34, 81, 45, 0 },
        { 128, 180, 18, 29, 182, 33, 1 },
        { 90, 69, 34, 96, 75, 35, 1 }, },
      { { 211, 79, 245, 172, 136, 118, 1 },
        { 198, 224, 173, 151, 21, 254, 1 },
        { 183, 8, 154, 215, 249, 101, 1 },
        { 191, 212, 116, 218, 131, 177, 1 }, },
      { { 215, 6, 210, 240, 31, 150, 0 },
        { 209, 104, 93, 178, 82, 249, 0 },
        { 52, 252, 7, 165, 176, 117, 1 },
        { 79, 165, 38, 221, 11, 69, 1 }, },
      { { 216, 50, 245, 201, 86, 5, 0 },
        { 0, 87, 199, 243, 80, 47, 0 },
        { 80, 53, 73, 215, 166, 13, 1 },
        { 122, 5, 103, 241, 245, 0, 0 }, },
      { { 216, 217, 65, 4, 131, 170, 0 },
        { 0, 139, 61, 37, 61, 32, 1 },
        { 42, 224, 144, 65, 77, 141, 1 },
        { 130, 94, 82, 94, 104, 128, 0 }, },
      { { 224, 211, 100, 108, 77, 209, 1 },
        { 6, 61, 209, 12, 93, 238, 0 },
        { 197, 217, 27, 19, 101, 131, 1 },
        { 59, 221, 24, 69, 222, 48, 0 }, },
      { { 225, 232, 37, 60, 152, 205, 0 },
        { 20, 172, 162, 29, 57, 183, 0 },
        { 89, 140, 158, 82, 11, 195, 1 },
        { 118, 206, 92, 34, 154, 148, 0 }, },
      { { 229, 118, 79, 139, 232, 157, 1 },
        { 107, 29, 35, 221, 178, 254, 0 },
        { 220, 139, 232, 249, 55, 83, 1 },
        { 63, 166, 221, 226, 92, 107, 0 }, },
      { { 232, 80, 250, 159, 250, 74, 0 },
        { 60, 83, 169, 238, 179, 163, 0 },
        { 41, 47, 252, 175, 133, 11, 1 },
        { 98, 230, 187, 202, 229, 30, 0 }, },
      { { 235, 128, 234, 240, 130, 92, 1 },
        { 182, 34, 225, 186, 58, 112, 0 },
        { 157, 32, 135, 171, 128, 235, 1 },
        { 7, 46, 46, 195, 162, 54, 1 }, },
      { { 239, 108, 113, 174, 69, 200, 1 },
        { 199, 250, 147, 141, 241, 50, 0 },
        { 137, 209, 58, 199, 27, 123, 1 },
        { 38, 71, 216, 228, 175, 241, 1 }, },
      { { 247, 217, 64, 237, 177, 12, 0 },
        { 137, 161, 117, 220, 61, 51, 0 },
        { 24, 70, 219, 129, 77, 247, 1 },
        { 102, 94, 29, 215, 66, 200, 1 }, },
      { { 254, 214, 40, 241, 92, 60, 1 },
        { 243, 51, 196, 220, 120, 233, 1 },
        { 158, 29, 71, 138, 53, 191, 1 },
        { 203, 143, 29, 145, 230, 103, 1 }, },
      { { 20, 199, 225, 220, 124, 3, 1 },
        { 91, 20, 205, 135, 77, 139, 0 },
        { 224, 31, 29, 195, 241, 148, 0 },
        { 104, 217, 112, 217, 148, 109, 0 }, },
      { { 34, 236, 79, 160, 255, 225, 0 },
        { 236, 188, 51, 173, 74, 133, 1 },
        { 67, 255, 130, 249, 27, 162, 0 },
        { 208, 169, 90, 230, 30, 155, 1 }, },
      { { 164, 134, 72, 34, 231, 234, 0 },
        { 109, 56, 57, 40, 232, 40, 1 },
        { 43, 243, 162, 9, 48, 146, 1 },
        { 138, 11, 138, 78, 14, 91, 0 }, },
      { { 179, 172, 156, 128, 134, 12, 1 },
        { 226, 192, 38, 186, 104, 52, 0 },
        { 152, 48, 128, 156, 154, 230, 1 },
        { 22, 11, 46, 178, 1, 163, 1 }, },
      { { 235, 197, 247, 106, 12, 68, 0 },
        { 196, 98, 193, 31, 222, 182, 0 },
        { 17, 24, 43, 119, 209, 235, 1 },
        { 54, 189, 252, 65, 163, 17, 1 }, },
      { { 0, 36, 28, 209, 199, 244, 0 },
        { 116, 88, 114, 240, 64, 68, 1 },
        { 23, 241, 197, 156, 18, 0, 0 },
        { 145, 1, 7, 167, 13, 23, 0 }, },
      { { 0, 65, 85, 60, 228, 236, 0 },
        { 28, 120, 33, 21, 101, 6, 1 },
        { 27, 147, 158, 85, 65, 0, 0 },
        { 176, 83, 84, 66, 15, 28, 0 }, },
      { { 2, 119, 133, 135, 91, 48, 1 },
        { 194, 17, 18, 231, 133, 205, 1 },
        { 134, 109, 112, 208, 247, 32, 0 },
        { 217, 208, 243, 164, 68, 33, 1 }, },
      { { 1, 218, 232, 155, 2, 227, 0 },
        { 52, 141, 137, 230, 136, 26, 1 },
        { 99, 160, 108, 139, 173, 192, 0 },
        { 172, 8, 179, 200, 216, 150, 0 }, },
      { { 4, 40, 5, 26, 111, 159, 0 },
        { 25, 156, 26, 49, 224, 198, 0 },
        { 124, 251, 44, 80, 10, 16, 0 },
        { 49, 131, 198, 44, 28, 204, 0 }, },
      { { 7, 145, 0, 75, 83, 171, 0 },
        { 129, 29, 88, 96, 172, 19, 1 },
        { 106, 229, 105, 0, 68, 240, 0 },
        { 228, 26, 131, 13, 92, 64, 1 }, },
      { { 10, 89, 153, 210, 227, 215, 1 },
        { 190, 223, 120, 183, 132, 64, 0 },
        { 245, 227, 165, 204, 205, 40, 0 },
        { 1, 16, 246, 143, 125, 190, 1 }, },
      { { 9, 178, 243, 249, 248, 177, 1 },
        { 26, 127, 227, 195, 10, 219, 1 },
        { 198, 143, 207, 231, 166, 200, 0 },
        { 237, 168, 97, 227, 255, 44, 0 }, },
      { { 13, 49, 205, 127, 92, 218, 1 },
        { 55, 59, 75, 67, 229, 215, 0 },
        { 173, 157, 127, 89, 198, 88, 0 },
        { 117, 211, 225, 105, 110, 118, 0 }, },
      { { 14, 110, 159, 79, 116, 37, 1 },
        { 235, 214, 66, 87, 195, 15, 1 },
        { 210, 23, 121, 124, 187, 56, 0 },
        { 248, 97, 245, 33, 53, 235, 1 }, },
      { { 23, 114, 128, 242, 245, 110, 0 },
        { 157, 49, 126, 150, 224, 25, 1 },
        { 59, 87, 167, 128, 167, 116, 0 },
        { 204, 3, 180, 191, 70, 92, 1 }, },
      { { 22, 255, 97, 63, 186, 238, 0 },
        { 221, 169, 175, 117, 173, 139, 1 },
        { 59, 174, 254, 67, 127, 180, 0 },
        { 232, 218, 215, 122, 202, 221, 1 }, },
      { { 25, 50, 221, 83, 147, 173, 1 },
        { 50, 79, 119, 115, 160, 29, 1 },
        { 218, 228, 229, 93, 166, 76, 0 },
        { 220, 2, 231, 119, 121, 38, 0 }, },
      { { 30, 55, 90, 161, 138, 28, 1 },
        { 227, 99, 39, 240, 38, 200, 0 },
        { 156, 40, 194, 173, 118, 60, 0 },
        { 9, 178, 7, 242, 99, 99, 1 }, },
      { { 30, 243, 155, 67, 46, 40, 0 },
        { 169, 67, 70, 103, 238, 136, 1 },
        { 10, 58, 97, 108, 231, 188, 0 },
        { 136, 187, 243, 49, 97, 74, 1 }, },
      { { 35, 152, 218, 66, 102, 77, 0 },
        { 172, 213, 65, 58, 234, 16, 0 },
        { 89, 51, 33, 45, 140, 226, 0 },
        { 4, 43, 174, 65, 85, 154, 1 }, },
      { { 35, 183, 98, 39, 73, 166, 1 },
        { 194, 57, 155, 88, 143, 152, 1 },
        { 178, 201, 114, 35, 118, 226, 0 },
        { 140, 248, 141, 108, 206, 33, 1 }, },
      { { 39, 232, 89, 247, 30, 7, 0 },
        { 177, 228, 75, 253, 201, 145, 0 },
        { 112, 60, 119, 205, 11, 242, 0 },
        { 68, 201, 223, 233, 19, 198, 1 }, },
      { { 41, 207, 36, 233, 56, 245, 0 },
        { 76, 174, 192, 220, 12, 223, 1 },
        { 87, 142, 75, 146, 121, 202, 0 },
        { 253, 152, 29, 129, 186, 153, 0 }, },
      { { 43, 202, 225, 232, 241, 71, 1 },
        { 142, 182, 249, 159, 8, 27, 0 },
        { 241, 71, 139, 195, 169, 234, 0 },
        { 108, 8, 124, 207, 182, 184, 1 }, },
      { { 46, 52, 167, 60, 136, 145, 0 },
        { 209, 47, 162, 11, 3, 198, 0 },
        { 68, 136, 158, 114, 150, 58, 0 },
        { 49, 224, 104, 34, 250, 69, 1 }, },
      { { 44, 130, 54, 130, 20, 241, 1 },
        { 7, 78, 128, 136, 202, 77, 1 },
        { 199, 148, 32, 182, 32, 154, 0 },
        { 217, 41, 136, 128, 185, 112, 0 }, },
      { { 52, 119, 39, 34, 124, 128, 0 },
        { 73, 57, 134, 13, 198, 141, 0 },
        { 0, 159, 34, 114, 119, 22, 0 },
        { 88, 177, 216, 48, 206, 73, 0 }, },
      { { 62, 106, 78, 239, 207, 36, 0 },
        { 161, 178, 119, 252, 195, 142, 1 },
        { 18, 121, 251, 185, 43, 62, 0 },
        { 184, 225, 159, 247, 38, 194, 1 }, },
      { { 61, 189, 0, 186, 135, 236, 0 },
        { 85, 171, 54, 184, 236, 18, 1 },
        { 27, 240, 174, 128, 94, 222, 0 },
        { 164, 27, 142, 182, 106, 213, 0 }, },
      { { 65, 89, 70, 17, 248, 154, 0 },
        { 24, 153, 41, 68, 54, 213, 0 },
        { 44, 143, 196, 49, 77, 65, 0 },
        { 85, 182, 17, 74, 76, 140, 0 }, },
      { { 66, 160, 192, 80, 251, 19, 1 },
        { 154, 20, 123, 34, 24, 193, 0 },
        { 228, 111, 133, 1, 130, 161, 0 },
        { 65, 140, 34, 111, 20, 44, 1 }, },
      { { 66, 215, 59, 80, 17, 218, 1 },
        { 246, 73, 216, 5, 62, 73, 0 },
        { 173, 196, 5, 110, 117, 161, 0 },
        { 73, 62, 80, 13, 201, 55, 1 }, },
      { { 71, 21, 159, 236, 40, 89, 1 },
        { 239, 101, 64, 131, 55, 214, 0 },
        { 205, 10, 27, 252, 212, 113, 0 },
        { 53, 246, 96, 129, 83, 123, 1 }, },
      { { 72, 72, 74, 156, 121, 141, 1 },
        { 58, 158, 17, 148, 51, 131, 0 },
        { 216, 207, 28, 169, 9, 9, 0 },
        { 96, 230, 20, 196, 60, 174, 0 }, },
      { { 75, 141, 239, 56, 120, 19, 0 },
        { 248, 182, 137, 3, 30, 215, 0 },
        { 100, 15, 14, 123, 216, 233, 0 },
        { 117, 188, 96, 72, 182, 143, 1 }, },
      { { 72, 197, 79, 119, 42, 255, 1 },
        { 126, 46, 73, 117, 191, 196, 1 },
        { 255, 170, 119, 121, 81, 137, 0 },
        { 145, 254, 215, 73, 58, 63, 0 }, },
      { { 73, 205, 149, 222, 250, 38, 0 },
        { 88, 210, 104, 183, 157, 151, 1 },
        { 50, 47, 189, 212, 217, 201, 0 },
        { 244, 220, 246, 139, 37, 141, 0 }, },
      { { 74, 248, 19, 154, 40, 250, 0 },
        { 156, 203, 10, 133, 186, 194, 1 },
        { 47, 138, 44, 228, 15, 169, 0 },
        { 161, 174, 208, 168, 105, 156, 1 }, },
      { { 76, 39, 45, 47, 65, 165, 0 },
        { 97, 62, 146, 81, 149, 14, 1 },
        { 82, 193, 122, 90, 114, 25, 0 },
        { 184, 84, 197, 36, 190, 67, 0 }, },
      { { 76, 63, 202, 163, 60, 106, 1 },
        { 111, 163, 11, 194, 246, 137, 1 },
        { 171, 30, 98, 169, 254, 25, 0 },
        { 200, 183, 161, 232, 98, 251, 0 }, },
      { { 76, 105, 150, 233, 240, 91, 0 },
        { 13, 246, 106, 198, 54, 71, 0 },
        { 109, 7, 203, 180, 203, 25, 0 },
        { 113, 54, 49, 171, 55, 216, 0 }, },
      { { 83, 59, 100, 210, 198, 162, 0 },
        { 144, 153, 239, 160, 212, 28, 1 },
        { 34, 177, 165, 147, 110, 101, 0 },
        { 156, 21, 130, 251, 204, 132, 1 }, },
      { { 81, 70, 77, 104, 180, 53, 1 },
        { 106, 36, 101, 21, 80, 95, 1 },
        { 214, 22, 139, 89, 49, 69, 0 },
        { 253, 5, 84, 83, 18, 43, 0 }, },
      { { 81, 86, 86, 98, 113, 201, 1 },
        { 78, 125, 85, 4, 178, 29, 0 },
        { 201, 199, 35, 53, 53, 69, 0 },
        { 92, 38, 144, 85, 95, 57, 0 }, },
      { { 80, 115, 53, 140, 113, 223, 1 },
        { 14, 93, 158, 149, 53, 79, 0 },
        { 253, 199, 24, 214, 103, 5, 0 },
        { 121, 86, 84, 188, 221, 56, 0 }, },
      { { 84, 74, 231, 46, 2, 158, 1 },
        { 3, 168, 141, 55, 179, 78, 0 },
        { 188, 160, 58, 115, 169, 21, 0 },
        { 57, 102, 246, 88, 138, 224, 0 }, },
      { { 84, 219, 22, 238, 94, 71, 0 },
        { 5, 245, 76, 180, 223, 143, 0 },
        { 113, 61, 59, 180, 109, 149, 0 },
        { 120, 253, 150, 153, 87, 208, 0 }, },
      { { 86, 240, 240, 30, 140, 100, 1 },
        { 151, 65, 167, 22, 217, 130, 1 },
        { 147, 24, 188, 7, 135, 181, 0 },
        { 160, 205, 180, 114, 193, 116, 1 }, },
      { { 91, 106, 3, 196, 23, 123, 1 },
        { 134, 134, 94, 165, 115, 89, 1 },
        { 239, 116, 17, 224, 43, 109, 0 },
        { 205, 103, 82, 189, 48, 176, 1 }, },
      { { 91, 249, 239, 82, 25, 108, 1 },
        { 182, 131, 215, 23, 190, 149, 1 },
        { 155, 76, 37, 123, 207, 237, 0 },
        { 212, 190, 244, 117, 224, 182, 1 }, },
      { { 92, 116, 249, 2, 251, 190, 0 },
        { 105, 91, 191, 55, 176, 193, 1 },
        { 62, 239, 160, 79, 151, 29, 0 },
        { 193, 134, 246, 126, 237, 75, 0 }, },
      { { 94, 157, 11, 47, 79, 122, 1 },
        { 231, 179, 28, 97, 255, 194, 1 },
        { 175, 121, 122, 104, 92, 189, 0 },
        { 161, 255, 195, 28, 102, 243, 1 }, },
      { { 99, 67, 213, 185, 201, 130, 0 },
        { 144, 120, 57, 207, 20, 158, 0 },
        { 32, 201, 206, 213, 225, 99, 0 },
        { 60, 148, 121, 206, 15, 4, 1 }, },
      { { 96, 93, 164, 245, 22, 155, 1 },
        { 82, 173, 200, 238, 117, 69, 0 },
        { 236, 180, 87, 146, 221, 3, 0 },
        { 81, 87, 59, 137, 218, 165, 0 }, },
      { { 100, 136, 47, 135, 72, 47, 0 },
        { 33, 148, 136, 217, 187, 132, 1 },
        { 122, 9, 112, 250, 8, 147, 0 },
        { 144, 238, 205, 136, 148, 194, 0 }, },
      { { 104, 106, 145, 148, 102, 64, 0 },
        { 28, 210, 2, 175, 81, 8, 0 },
        { 1, 51, 20, 196, 171, 11, 0 },
        { 8, 69, 122, 160, 37, 156, 0 }, },
      { { 108, 55, 209, 238, 204, 101, 1 },
        { 71, 119, 99, 155, 213, 138, 1 },
        { 211, 25, 187, 197, 246, 27, 0 },
        { 168, 213, 236, 227, 119, 113, 0 }, },
      { { 109, 89, 245, 135, 43, 42, 0 },
        { 9, 195, 153, 239, 181, 148, 1 },
        { 42, 106, 112, 215, 205, 91, 0 },
        { 148, 214, 251, 204, 225, 200, 0 }, },
      { { 115, 31, 7, 158, 40, 12, 0 },
        { 216, 129, 4, 153, 183, 158, 0 },
        { 24, 10, 60, 240, 124, 103, 0 },
        { 60, 246, 204, 144, 64, 141, 1 }, },
      { { 114, 38, 22, 146, 200, 199, 1 },
        { 214, 92, 46, 152, 146, 140, 0 },
        { 241, 137, 164, 180, 50, 39, 0 },
        { 24, 164, 140, 186, 29, 53, 1 }, },
      { { 115, 131, 239, 207, 199, 93, 1 },
        { 166, 20, 245, 251, 255, 94, 0 },
        { 221, 113, 249, 251, 224, 231, 0 },
        { 61, 127, 239, 215, 148, 50, 1 }, },
      { { 113, 246, 244, 181, 170, 13, 0 },
        { 88, 101, 167, 254, 57, 156, 0 },
        { 88, 42, 214, 151, 183, 199, 0 },
        { 28, 206, 63, 242, 211, 13, 0 }, },
      { { 118, 16, 2, 241, 170, 59, 0 },
        { 153, 37, 108, 232, 50, 192, 1 },
        { 110, 42, 199, 160, 4, 55, 0 },
        { 129, 166, 11, 155, 82, 76, 1 }, },
      { { 118, 84, 255, 84, 38, 33, 0 },
        { 249, 69, 197, 47, 83, 4, 1 },
        { 66, 50, 21, 127, 149, 55, 0 },
        { 144, 101, 122, 81, 209, 79, 1 }, },
      { { 122, 227, 200, 30, 38, 54, 0 },
        { 184, 2, 15, 62, 221, 74, 1 },
        { 54, 50, 60, 9, 227, 175, 0 },
        { 169, 93, 190, 120, 32, 14, 1 }, },
      { { 126, 32, 91, 27, 109, 102, 0 },
        { 189, 82, 31, 89, 210, 130, 1 },
        { 51, 91, 108, 109, 2, 63, 0 },
        { 160, 165, 205, 124, 37, 94, 1 }, },
      { { 124, 113, 102, 127, 179, 75, 1 },
        { 31, 39, 255, 108, 183, 7, 0 },
        { 233, 102, 255, 51, 71, 31, 0 },
        { 112, 118, 155, 127, 242, 124, 0 }, },
      { { 126, 136, 249, 129, 71, 26, 0 },
        { 161, 210, 157, 235, 120, 64, 0 },
        { 44, 113, 64, 207, 136, 191, 0 },
        { 1, 15, 107, 220, 165, 194, 1 }, },
      { { 127, 189, 182, 243, 152, 70, 0 },
        { 213, 227, 238, 218, 158, 149, 0 },
        { 49, 12, 231, 182, 222, 255, 0 },
        { 84, 188, 173, 187, 227, 213, 1 }, },
      { { 131, 186, 63, 66, 156, 103, 0 },
        { 164, 197, 234, 17, 202, 189, 1 },
        { 115, 28, 161, 126, 46, 224, 1 },
        { 222, 169, 196, 43, 209, 146, 1 }, },
      { { 131, 179, 163, 188, 159, 85, 1 },
        { 150, 37, 178, 179, 79, 251, 0 },
        { 213, 124, 158, 226, 230, 224, 1 },
        { 111, 249, 102, 166, 210, 52, 1 }, },
      { { 134, 184, 56, 238, 195, 91, 1 },
        { 167, 245, 250, 160, 169, 98, 0 },
        { 237, 97, 187, 142, 14, 176, 1 },
        { 35, 74, 130, 175, 215, 242, 1 }, },
      { { 138, 251, 116, 46, 23, 43, 0 },
        { 128, 231, 155, 36, 237, 47, 1 },
        { 106, 116, 58, 23, 111, 168, 1 },
        { 250, 91, 146, 108, 243, 128, 1 }, },
      { { 142, 5, 134, 252, 131, 42, 0 },
        { 209, 34, 120, 162, 39, 38, 1 },
        { 42, 96, 159, 176, 208, 56, 1 },
        { 178, 114, 34, 143, 34, 69, 1 }, },
      { { 143, 72, 60, 30, 32, 231, 0 },
        { 189, 206, 136, 20, 129, 54, 1 },
        { 115, 130, 60, 30, 9, 120, 1 },
        { 182, 64, 148, 8, 185, 222, 1 }, },
      { { 142, 83, 181, 252, 28, 224, 0 },
        { 149, 107, 192, 135, 69, 175, 1 },
        { 3, 156, 31, 214, 229, 56, 1 },
        { 250, 209, 112, 129, 235, 84, 1 }, },
      { { 141, 157, 35, 130, 73, 96, 0 },
        { 69, 147, 144, 129, 142, 176, 1 },
        { 3, 73, 32, 226, 92, 216, 1 },
        { 134, 184, 192, 132, 228, 209, 0 }, },
      { { 141, 185, 144, 117, 146, 156, 1 },
        { 19, 235, 98, 114, 45, 113, 0 },
        { 156, 164, 215, 4, 206, 216, 1 },
        { 71, 90, 39, 35, 107, 228, 0 }, },
      { { 144, 19, 230, 225, 162, 176, 0 },
        { 8, 41, 229, 226, 6, 108, 1 },
        { 6, 162, 195, 179, 228, 4, 1 },
        { 155, 48, 35, 211, 202, 8, 0 }, },
      { { 147, 155, 55, 123, 26, 144, 1 },
        { 146, 233, 196, 97, 142, 255, 0 },
        { 132, 172, 111, 118, 108, 228, 1 },
        { 127, 184, 195, 17, 203, 164, 1 }, },
      { { 151, 14, 49, 237, 242, 168, 1 },
        { 203, 248, 228, 225, 33, 59, 1 },
        { 138, 167, 219, 198, 56, 116, 1 },
        { 238, 66, 67, 147, 143, 233, 1 }, },
      { { 151, 52, 94, 59, 153, 170, 0 },
        { 241, 105, 63, 64, 162, 183, 1 },
        { 42, 204, 238, 61, 22, 116, 1 },
        { 246, 162, 129, 126, 75, 71, 1 }, },
      { { 149, 122, 253, 44, 125, 85, 0 },
        { 45, 245, 151, 23, 65, 255, 0 },
        { 85, 95, 26, 95, 175, 84, 1 },
        { 127, 193, 116, 116, 215, 218, 0 }, },
      { { 151, 221, 14, 6, 20, 80, 1 },
        { 231, 129, 4, 4, 207, 117, 0 },
        { 133, 20, 48, 56, 93, 244, 1 },
        { 87, 121, 144, 16, 64, 243, 1 }, },
      { { 154, 154, 4, 227, 189, 68, 1 },
        { 142, 163, 116, 208, 200, 173, 0 },
        { 145, 94, 227, 144, 44, 172, 1 },
        { 90, 137, 133, 151, 98, 184, 1 }, },
      { { 155, 190, 173, 173, 13, 248, 1 },
        { 230, 171, 150, 195, 105, 254, 1 },
        { 143, 216, 90, 218, 190, 236, 1 },
        { 191, 203, 97, 180, 234, 179, 1 }, },
      { { 157, 103, 144, 38, 24, 93, 0 },
        { 69, 102, 6, 22, 165, 249, 0 },
        { 93, 12, 50, 4, 243, 92, 1 },
        { 79, 210, 180, 48, 51, 81, 0 }, },
      { { 159, 129, 201, 246, 175, 127, 0 },
        { 189, 38, 125, 179, 237, 240, 1 },
        { 127, 122, 183, 201, 192, 252, 1 },
        { 135, 219, 230, 223, 50, 94, 1 }, },
      { { 159, 247, 196, 109, 149, 97, 1 },
        { 199, 39, 119, 70, 77, 63, 1 },
        { 195, 84, 219, 17, 247, 252, 1 },
        { 254, 89, 49, 119, 114, 113, 1 }, },
      { { 167, 3, 62, 38, 186, 122, 0 },
        { 173, 96, 168, 40, 167, 253, 1 },
        { 47, 46, 178, 62, 96, 114, 1 },
        { 223, 242, 138, 10, 131, 90, 1 }, },
      { { 166, 79, 109, 144, 30, 111, 0 },
        { 245, 132, 137, 189, 100, 173, 1 },
        { 123, 60, 4, 219, 121, 50, 1 },
        { 218, 147, 94, 200, 144, 215, 1 }, },
      { { 166, 84, 136, 155, 103, 3, 0 },
        { 249, 21, 24, 238, 192, 34, 0 },
        { 96, 115, 108, 136, 149, 50, 1 },
        { 34, 1, 187, 140, 84, 79, 1 }, },
      { { 164, 250, 171, 52, 23, 138, 0 },
        { 49, 169, 154, 47, 107, 41, 0 },
        { 40, 244, 22, 106, 175, 146, 1 },
        { 74, 107, 122, 44, 202, 198, 0 }, },
      { { 169, 35, 165, 79, 219, 255, 1 },
        { 6, 30, 250, 123, 165, 255, 1 },
        { 255, 237, 249, 82, 226, 74, 1 },
        { 255, 210, 239, 47, 188, 48, 0 }, },
      { { 175, 22, 89, 55, 116, 14, 1 },
        { 251, 115, 9, 89, 225, 57, 0 },
        { 184, 23, 118, 77, 52, 122, 1 },
        { 78, 67, 205, 72, 103, 111, 1 }, },
      { { 174, 60, 2, 96, 17, 226, 1 },
        { 199, 171, 90, 8, 2, 33, 1 },
        { 163, 196, 3, 32, 30, 58, 1 },
        { 194, 32, 8, 45, 106, 241, 1 }, },
      { { 174, 166, 70, 29, 70, 134, 0 },
        { 209, 26, 11, 120, 75, 46, 0 },
        { 48, 177, 92, 49, 50, 186, 1 },
        { 58, 105, 15, 104, 44, 69, 1 }, },
      { { 174, 169, 188, 206, 254, 64, 0 },
        { 173, 210, 226, 170, 205, 167, 0 },
        { 1, 63, 185, 158, 202, 186, 1 },
        { 114, 217, 170, 163, 165, 218, 1 }, },
      { { 177, 170, 233, 41, 210, 190, 0 },
        { 32, 184, 175, 123, 40, 123, 1 },
        { 62, 165, 202, 75, 170, 198, 1 },
        { 239, 10, 111, 122, 142, 130, 0 }, },
      { { 179, 236, 199, 247, 61, 40, 0 },
        { 216, 160, 87, 207, 235, 181, 1 },
        { 10, 94, 119, 241, 155, 230, 1 },
        { 214, 235, 249, 245, 2, 141, 1 }, },
      { { 179, 242, 249, 209, 5, 96, 1 },
        { 182, 65, 215, 207, 72, 56, 1 },
        { 131, 80, 69, 207, 167, 230, 1 },
        { 142, 9, 121, 245, 193, 54, 1 }, },
      { { 183, 83, 178, 95, 132, 147, 0 },
        { 145, 77, 236, 78, 199, 122, 0 },
        { 100, 144, 253, 38, 229, 118, 1 },
        { 47, 113, 185, 27, 217, 68, 1 }, },
      { { 180, 99, 115, 84, 106, 222, 0 },
        { 29, 88, 207, 61, 39, 232, 0 },
        { 61, 171, 21, 103, 99, 22, 1 },
        { 11, 242, 94, 121, 141, 92, 0 }, },
      { { 182, 97, 89, 33, 192, 136, 0 },
        { 161, 120, 39, 77, 36, 32, 0 },
        { 8, 129, 194, 77, 67, 54, 1 },
        { 2, 18, 89, 114, 15, 66, 1 }, },
      { { 186, 184, 208, 95, 68, 186, 1 },
        { 146, 219, 79, 74, 233, 98, 1 },
        { 174, 145, 125, 5, 142, 174, 1 },
        { 163, 75, 169, 121, 109, 164, 1 }, },
      { { 186, 192, 40, 124, 16, 3, 1 },
        { 178, 38, 204, 12, 9, 35, 0 },
        { 224, 4, 31, 10, 1, 174, 1 },
        { 98, 72, 24, 25, 178, 38, 1 }, },
      { { 188, 9, 19, 77, 135, 103, 0 },
        { 5, 198, 124, 121, 71, 34, 1 },
        { 115, 112, 217, 100, 72, 30, 1 },
        { 162, 113, 79, 31, 49, 208, 0 }, },
      { { 190, 60, 15, 68, 249, 12, 0 },
        { 233, 147, 118, 25, 35, 165, 0 },
        { 24, 79, 145, 120, 30, 62, 1 },
        { 82, 226, 76, 55, 100, 203, 1 }, },
      { { 193, 39, 249, 24, 172, 4, 0 },
        { 120, 64, 163, 19, 84, 186, 0 },
        { 16, 26, 140, 79, 242, 65, 1 },
        { 46, 149, 100, 98, 129, 15, 0 }, },
      { { 194, 54, 103, 175, 248, 99, 1 },
        { 206, 53, 171, 193, 147, 175, 1 },
        { 227, 15, 250, 243, 54, 33, 1 },
        { 250, 228, 193, 234, 214, 57, 1 }, },
      { { 194, 202, 232, 228, 90, 50, 0 },
        { 160, 176, 201, 166, 25, 233, 1 },
        { 38, 45, 19, 139, 169, 161, 1 },
        { 203, 204, 50, 201, 134, 130, 1 }, },
      { { 198, 18, 22, 32, 228, 28, 0 },
        { 137, 113, 32, 16, 114, 108, 0 },
        { 28, 19, 130, 52, 36, 49, 1 },
        { 27, 39, 4, 2, 71, 72, 1 }, },
      { { 199, 229, 93, 208, 65, 150, 0 },
        { 241, 88, 91, 149, 28, 116, 0 },
        { 52, 193, 5, 221, 83, 241, 1 },
        { 23, 28, 84, 237, 13, 71, 1 }, },
      { { 202, 89, 204, 102, 248, 236, 0 },
        { 172, 187, 97, 22, 181, 165, 1 },
        { 27, 143, 179, 25, 205, 41, 1 },
        { 210, 214, 180, 67, 110, 154, 1 }, },
      { { 200, 251, 13, 58, 124, 119, 1 },
        { 62, 183, 10, 21, 220, 239, 1 },
        { 247, 31, 46, 88, 111, 137, 1 },
        { 251, 157, 212, 40, 118, 190, 0 }, },
      { { 204, 35, 191, 4, 244, 230, 0 },
        { 45, 90, 170, 19, 87, 45, 1 },
        { 51, 151, 144, 126, 226, 25, 1 },
        { 218, 117, 100, 42, 173, 90, 0 }, },
      { { 204, 185, 29, 222, 17, 77, 0 },
        { 53, 199, 82, 145, 189, 39, 0 },
        { 89, 68, 61, 220, 78, 153, 1 },
        { 114, 94, 196, 165, 113, 214, 0 }, },
      { { 214, 71, 53, 203, 221, 81, 1 },
        { 199, 84, 244, 197, 212, 239, 0 },
        { 197, 93, 233, 214, 113, 53, 1 },
        { 123, 149, 209, 151, 149, 113, 1 }, },
      { { 212, 80, 13, 82, 140, 243, 1 },
        { 55, 13, 108, 5, 208, 228, 1 },
        { 231, 152, 165, 88, 5, 21, 1 },
        { 147, 133, 208, 27, 88, 118, 0 }, },
      { { 214, 126, 50, 1, 136, 117, 0 },
        { 197, 197, 166, 84, 18, 232, 1 },
        { 87, 8, 192, 38, 63, 53, 1 },
        { 139, 164, 21, 50, 209, 209, 1 }, },
      { { 214, 239, 103, 48, 199, 69, 1 },
        { 215, 180, 183, 53, 94, 44, 0 },
        { 209, 113, 134, 115, 123, 181, 1 },
        { 26, 61, 86, 118, 150, 245, 1 }, },
      { { 217, 10, 193, 255, 8, 72, 0 },
        { 20, 162, 69, 195, 177, 186, 0 },
        { 9, 8, 127, 193, 168, 77, 1 },
        { 46, 198, 225, 209, 34, 148, 0 }, },
      { { 218, 68, 144, 181, 192, 149, 0 },
        { 208, 126, 36, 214, 17, 96, 0 },
        { 84, 129, 214, 132, 145, 45, 1 },
        { 3, 68, 53, 146, 63, 5, 1 }, },
      { { 218, 142, 240, 138, 31, 78, 1 },
        { 198, 194, 157, 178, 248, 171, 0 },
        { 185, 124, 40, 135, 184, 173, 1 },
        { 106, 143, 166, 220, 161, 177, 1 }, },
      { { 226, 186, 72, 154, 71, 244, 1 },
        { 182, 153, 19, 184, 216, 106, 1 },
        { 151, 241, 44, 137, 46, 163, 1 },
        { 171, 13, 142, 228, 76, 182, 1 }, },
      { { 226, 251, 142, 197, 152, 25, 0 },
        { 160, 133, 98, 206, 63, 237, 0 },
        { 76, 12, 209, 184, 239, 163, 1 },
        { 91, 254, 57, 163, 80, 130, 1 }, },
      { { 229, 62, 6, 191, 131, 16, 1 },
        { 83, 161, 50, 232, 147, 126, 0 },
        { 132, 96, 254, 176, 62, 83, 1 },
        { 63, 100, 139, 166, 66, 229, 0 }, },
      { { 230, 135, 176, 105, 180, 112, 0 },
        { 205, 96, 224, 74, 92, 107, 1 },
        { 7, 22, 203, 6, 240, 179, 1 },
        { 235, 29, 41, 3, 131, 89, 1 }, },
      { { 229, 161, 35, 223, 231, 210, 0 },
        { 29, 24, 250, 233, 223, 114, 0 },
        { 37, 243, 253, 226, 66, 211, 1 },
        { 39, 125, 203, 175, 140, 92, 0 }, },
      { { 228, 231, 74, 54, 176, 3, 0 },
        { 121, 36, 43, 12, 159, 41, 0 },
        { 96, 6, 182, 41, 115, 147, 1 },
        { 74, 124, 152, 106, 18, 79, 0 }, },
      { { 235, 25, 74, 181, 219, 227, 0 },
        { 180, 191, 57, 232, 23, 177, 1 },
        { 99, 237, 214, 169, 76, 107, 1 },
        { 198, 244, 11, 206, 126, 150, 1 }, },
      { { 235, 104, 214, 214, 135, 188, 0 },
        { 144, 202, 115, 190, 243, 116, 1 },
        { 30, 240, 181, 181, 139, 107, 1 },
        { 151, 103, 190, 231, 41, 132, 1 }, },
      { { 239, 76, 157, 25, 92, 242, 0 },
        { 245, 218, 8, 79, 80, 247, 1 },
        { 39, 157, 76, 92, 153, 123, 1 },
        { 247, 133, 121, 8, 45, 215, 1 }, },
      { { 240, 140, 65, 178, 161, 79, 1 },
        { 94, 164, 61, 153, 184, 32, 0 },
        { 249, 66, 166, 193, 24, 135, 1 },
        { 2, 14, 204, 222, 18, 189, 0 }, },
      { { 245, 42, 227, 102, 145, 91, 0 },
        { 5, 164, 255, 11, 179, 121, 0 },
        { 109, 68, 179, 99, 170, 87, 1 },
        { 79, 102, 232, 127, 146, 208, 0 }, },
      { { 247, 127, 207, 238, 89, 167, 0 },
        { 225, 189, 95, 159, 151, 191, 1 },
        { 114, 205, 59, 249, 255, 119, 1 },
        { 254, 244, 252, 253, 94, 195, 1 }, },
      { { 248, 218, 47, 9, 127, 235, 0 },
        { 44, 159, 156, 109, 122, 175, 1 },
        { 107, 255, 72, 122, 45, 143, 1 },
        { 250, 175, 91, 28, 252, 154, 0 }, },
      { { 252, 25, 236, 171, 9, 228, 1 },
        { 39, 171, 149, 218, 148, 166, 1 },
        { 147, 200, 106, 155, 204, 31, 1 },
        { 178, 148, 173, 212, 234, 242, 0 }, },
      { { 147, 75, 97, 136, 48, 21, 0 },
        { 136, 132, 133, 149, 4, 123, 0 },
        { 84, 6, 8, 195, 105, 100, 1 },
        { 111, 16, 84, 208, 144, 136, 1 }, },
      { { 200, 173, 102, 37, 128, 21, 1 },
        { 66, 166, 163, 80, 31, 100, 0 },
        { 212, 0, 210, 51, 90, 137, 1 },
        { 19, 124, 5, 98, 178, 161, 0 }, },
      { { 28, 218, 21, 111, 160, 160, 1 },
        { 11, 235, 100, 69, 137, 14, 1 },
        { 130, 130, 251, 84, 45, 156, 0 },
        { 184, 72, 209, 19, 107, 232, 0 }, },
      { { 35, 147, 244, 147, 165, 30, 0 },
        { 152, 65, 185, 218, 236, 92, 0 },
        { 60, 82, 228, 151, 228, 226, 0 },
        { 29, 27, 173, 206, 193, 12, 1 }, },
      { { 47, 88, 146, 189, 228, 140, 1 },
        { 155, 251, 32, 222, 99, 18, 0 },
        { 152, 147, 222, 164, 141, 122, 0 },
        { 36, 99, 61, 130, 111, 236, 1 }, },
      { { 67, 161, 247, 150, 104, 223, 0 },
        { 156, 92, 139, 147, 191, 212, 0 },
        { 125, 139, 52, 247, 194, 225, 0 },
        { 21, 254, 228, 232, 157, 28, 1 }, },
      { { 73, 80, 111, 179, 116, 206, 1 },
        { 62, 59, 137, 213, 242, 21, 0 },
        { 185, 151, 102, 251, 5, 73, 0 },
        { 84, 39, 213, 200, 238, 62, 0 }, },
      { { 82, 96, 94, 14, 152, 127, 0 },
        { 164, 68, 47, 20, 179, 199, 1 },
        { 127, 12, 184, 61, 3, 37, 0 },
        { 241, 230, 148, 122, 17, 18, 1 }, },
      { { 82, 145, 24, 227, 252, 161, 0 },
        { 168, 125, 100, 192, 220, 129, 1 },
        { 66, 159, 227, 140, 68, 165, 0 },
        { 192, 157, 129, 147, 95, 10, 1 }, },
      { { 101, 223, 133, 82, 42, 63, 1 },
        { 91, 133, 72, 63, 188, 220, 1 },
        { 254, 42, 37, 80, 253, 211, 0 },
        { 157, 158, 254, 9, 80, 237, 0 }, },
      { { 113, 72, 12, 215, 43, 160, 0 },
        { 56, 136, 84, 236, 145, 148, 1 },
        { 2, 234, 117, 152, 9, 71, 0 },
        { 148, 196, 155, 149, 8, 142, 0 }, },
      { { 142, 6, 96, 125, 160, 37, 0 },
        { 217, 38, 225, 80, 1, 42, 1 },
        { 82, 2, 223, 3, 48, 56, 1 },
        { 170, 64, 5, 67, 178, 77, 1 }, },
      { { 150, 170, 33, 3, 84, 112, 1 },
        { 135, 144, 134, 65, 200, 105, 1 },
        { 135, 21, 96, 66, 42, 180, 1 },
        { 203, 9, 193, 48, 132, 240, 1 }, },
      { { 161, 37, 174, 137, 93, 100, 1 },
        { 102, 16, 146, 218, 70, 183, 1 },
        { 147, 93, 72, 186, 210, 66, 1 },
        { 246, 177, 45, 164, 132, 51, 0 }, },
      { { 188, 234, 86, 10, 46, 231, 1 },
        { 15, 206, 15, 60, 202, 174, 1 },
        { 243, 186, 40, 53, 43, 158, 1 },
        { 186, 169, 158, 120, 57, 248, 0 }, },
      { { 194, 210, 70, 164, 139, 68, 0 },
        { 132, 33, 49, 180, 27, 172, 0 },
        { 17, 104, 146, 177, 37, 161, 1 },
        { 26, 236, 22, 198, 66, 16, 1 }, },
      { { 218, 226, 149, 139, 69, 176, 0 },
        { 128, 90, 22, 199, 216, 110, 1 },
        { 6, 209, 104, 212, 163, 173, 1 },
        { 187, 13, 241, 180, 45, 0, 1 }, },
      { { 236, 63, 99, 213, 29, 216, 0 },
        { 85, 139, 211, 201, 119, 233, 0 },
        { 13, 220, 85, 227, 126, 27, 1 },
        { 75, 247, 73, 229, 232, 213, 0 }, },
      { { 255, 105, 45, 60, 107, 15, 0 },
        { 185, 182, 158, 61, 53, 182, 0 },
        { 120, 107, 30, 90, 75, 127, 1 },
        { 54, 214, 94, 60, 182, 206, 1 }, },
      { { 0, 28, 79, 167, 70, 146, 1 },
        { 98, 185, 9, 225, 195, 68, 0 },
        { 164, 177, 114, 249, 28, 0, 0 },
        { 17, 97, 195, 200, 78, 163, 0 }, },
      { { 2, 24, 244, 93, 202, 150, 0 },
        { 144, 217, 233, 114, 1, 198, 0 },
        { 52, 169, 221, 23, 140, 32, 0 },
        { 49, 192, 39, 75, 205, 132, 1 }, },
      { { 3, 209, 163, 72, 235, 88, 0 },
        { 140, 17, 240, 39, 46, 210, 0 },
        { 13, 107, 137, 98, 197, 224, 0 },
        { 37, 186, 114, 7, 196, 24, 1 }, },
      { { 4, 27, 131, 253, 41, 154, 1 },
        { 27, 169, 88, 195, 39, 202, 0 },
        { 172, 202, 95, 224, 236, 16, 0 },
        { 41, 242, 97, 141, 74, 236, 0 }, },
      { { 9, 141, 142, 139, 148, 215, 1 },
        { 102, 142, 40, 210, 206, 87, 0 },
        { 245, 148, 232, 184, 216, 200, 0 },
        { 117, 57, 165, 138, 56, 179, 0 }, },
      { { 8, 163, 222, 26, 89, 139, 0 },
        { 48, 94, 27, 2, 174, 143, 0 },
        { 104, 205, 44, 61, 226, 136, 0 },
        { 120, 186, 160, 108, 61, 6, 0 }, },
      { { 11, 188, 12, 8, 32, 24, 0 },
        { 232, 131, 2, 0, 40, 86, 0 },
        { 12, 2, 8, 24, 30, 232, 0 },
        { 53, 10, 0, 32, 96, 139, 1 }, },
      { { 8, 180, 118, 44, 124, 199, 0 },
        { 76, 127, 139, 16, 75, 135, 0 },
        { 113, 159, 26, 55, 22, 136, 0 },
        { 112, 233, 4, 104, 255, 25, 0 }, },
      { { 8, 252, 181, 200, 85, 47, 1 },
        { 66, 215, 218, 151, 104, 7, 1 },
        { 250, 85, 9, 214, 159, 136, 0 },
        { 240, 11, 116, 173, 245, 161, 0 }, },
      { { 14, 22, 54, 84, 254, 34, 0 },
        { 217, 83, 232, 32, 67, 141, 1 },
        { 34, 63, 149, 54, 52, 56, 0 },
        { 216, 225, 2, 11, 229, 77, 1 }, },
      { { 18, 44, 177, 159, 7, 34, 1 },
        { 210, 192, 158, 227, 193, 2, 1 },
        { 162, 112, 124, 198, 154, 36, 0 },
        { 160, 65, 227, 188, 129, 165, 1 }, },
      { { 18, 69, 156, 171, 22, 232, 0 },
        { 228, 104, 4, 230, 228, 7, 1 },
        { 11, 180, 106, 156, 209, 36, 0 },
        { 240, 19, 179, 144, 11, 19, 1 }, },
      { { 19, 147, 126, 245, 174, 67, 1 },
        { 190, 101, 237, 224, 79, 156, 0 },
        { 225, 58, 215, 191, 100, 228, 0 },
        { 28, 249, 3, 219, 211, 62, 1 }, },
      { { 22, 41, 244, 18, 48, 140, 0 },
        { 153, 200, 135, 18, 164, 5, 0 },
        { 24, 134, 36, 23, 202, 52, 0 },
        { 80, 18, 164, 112, 137, 204, 1 }, },
      { { 21, 124, 103, 88, 122, 66, 0 },
        { 93, 145, 207, 37, 2, 151, 0 },
        { 33, 47, 13, 115, 31, 84, 0 },
        { 116, 160, 82, 121, 196, 221, 0 }, },
      { { 21, 204, 177, 89, 131, 214, 1 },
        { 87, 200, 252, 119, 8, 82, 0 },
        { 181, 224, 205, 70, 153, 212, 0 },
        { 37, 8, 119, 31, 137, 245, 0 }, },
      { { 23, 227, 47, 161, 221, 185, 0 },
        { 161, 60, 182, 197, 110, 221, 1 },
        { 78, 221, 194, 250, 99, 244, 0 },
        { 221, 187, 81, 182, 158, 66, 1 }, },
      { { 27, 70, 90, 142, 239, 10, 1 },
        { 234, 82, 61, 164, 227, 154, 0 },
        { 168, 123, 184, 173, 49, 108, 0 },
        { 44, 227, 146, 222, 37, 43, 1 }, },
      { { 27, 105, 78, 73, 179, 188, 1 },
        { 170, 138, 119, 116, 38, 87, 1 },
        { 158, 230, 201, 57, 75, 108, 0 },
        { 245, 50, 23, 119, 40, 170, 1 }, },
      { { 27, 196, 203, 219, 144, 138, 1 },
        { 242, 10, 109, 199, 170, 19, 0 },
        { 168, 132, 237, 233, 145, 236, 0 },
        { 100, 42, 241, 219, 40, 39, 1 }, },
      { { 31, 44, 109, 141, 119, 17, 1 },
        { 235, 150, 151, 225, 65, 87, 0 },
        { 196, 119, 88, 219, 26, 124, 0 },
        { 117, 65, 67, 244, 180, 235, 1 }, },
      { { 31, 87, 63, 15, 8, 234, 1 },
        { 231, 75, 140, 69, 167, 158, 1 },
        { 171, 136, 120, 126, 117, 124, 0 },
        { 188, 242, 209, 24, 233, 115, 1 }, },
      { { 28, 109, 100, 176, 216, 126, 1 },
        { 87, 178, 175, 148, 36, 197, 1 },
        { 191, 13, 134, 147, 91, 28, 0 },
        { 209, 146, 20, 250, 166, 245, 0 }, },
      { { 31, 214, 51, 233, 39, 78, 1 },
        { 207, 99, 220, 245, 106, 26, 0 },
        { 185, 114, 75, 230, 53, 252, 0 },
        { 44, 43, 87, 157, 227, 121, 1 }, },
      { { 31, 237, 94, 0, 105, 171, 1 },
        { 235, 222, 31, 4, 46, 148, 1 },
        { 234, 203, 0, 61, 91, 252, 0 },
        { 148, 186, 16, 124, 61, 235, 1 }, },
      { { 32, 25, 133, 43, 191, 166, 0 },
        { 8, 169, 56, 123, 196, 135, 1 },
        { 50, 254, 234, 80, 204, 2, 0 },
        { 240, 145, 239, 14, 74, 136, 0 }, },
      { { 34, 61, 51, 120, 7, 207, 0 },
        { 212, 237, 218, 57, 102, 2, 0 },
        { 121, 240, 15, 102, 94, 34, 0 },
        { 32, 51, 78, 45, 219, 149, 1 }, },
      { { 32, 99, 33, 28, 107, 49, 0 },
        { 24, 20, 146, 45, 5, 202, 1 },
        { 70, 107, 28, 66, 99, 2, 0 },
        { 169, 208, 90, 36, 148, 12, 0 }, },
      { { 34, 110, 87, 72, 118, 216, 1 },
        { 206, 216, 67, 45, 98, 79, 0 },
        { 141, 183, 9, 117, 59, 34, 0 },
        { 121, 35, 90, 97, 13, 185, 1 }, },
      { { 32, 116, 241, 178, 248, 194, 1 },
        { 94, 121, 171, 143, 128, 129, 0 },
        { 161, 143, 166, 199, 151, 2, 0 },
        { 64, 128, 248, 234, 207, 61, 0 }, },
      { { 33, 172, 61, 93, 237, 110, 0 },
        { 124, 208, 250, 89, 105, 150, 1 },
        { 59, 91, 221, 94, 26, 194, 0 },
        { 180, 203, 77, 47, 133, 159, 0 }, },
      { { 33, 195, 23, 29, 144, 62, 1 },
        { 18, 64, 40, 93, 47, 95, 1 },
        { 190, 4, 220, 116, 97, 194, 0 },
        { 253, 122, 93, 10, 1, 36, 0 }, },
      { { 39, 47, 226, 196, 67, 84, 0 },
        { 197, 144, 211, 186, 7, 88, 0 },
        { 21, 97, 17, 163, 250, 114, 0 },
        { 13, 112, 46, 229, 132, 209, 1 }, },
      { { 39, 159, 50, 224, 232, 133, 0 },
        { 201, 253, 224, 152, 14, 152, 0 },
        { 80, 139, 131, 166, 124, 242, 0 },
        { 12, 184, 12, 131, 223, 201, 1 }, },
      { { 38, 190, 33, 114, 154, 9, 1 },
        { 211, 165, 226, 41, 168, 137, 0 },
        { 200, 44, 167, 66, 62, 178, 0 },
        { 72, 138, 202, 35, 210, 229, 1 }, },
      { { 42, 3, 57, 247, 158, 125, 1 },
        { 182, 102, 224, 249, 229, 201, 1 },
        { 223, 60, 247, 206, 96, 42, 0 },
        { 201, 211, 207, 131, 179, 54, 1 }, },
      { { 43, 24, 147, 239, 72, 235, 0 },
        { 132, 255, 72, 203, 163, 146, 1 },
        { 107, 137, 123, 228, 140, 106, 0 },
        { 164, 226, 233, 137, 127, 144, 1 }, },
      { { 41, 20, 232, 100, 42, 8, 0 },
        { 104, 35, 193, 42, 33, 144, 0 },
        { 8, 42, 19, 11, 148, 74, 0 },
        { 4, 194, 42, 65, 226, 11, 0 }, },
      { { 41, 104, 166, 84, 120, 185, 0 },
        { 24, 158, 194, 14, 35, 213, 1 },
        { 78, 143, 21, 50, 139, 74, 0 },
        { 213, 226, 56, 33, 188, 140, 0 }, },
      { { 42, 193, 129, 37, 248, 55, 0 },
        { 136, 54, 40, 95, 13, 193, 1 },
        { 118, 15, 210, 64, 193, 170, 0 },
        { 193, 216, 125, 10, 54, 8, 1 }, },
      { { 40, 212, 32, 190, 102, 221, 1 },
        { 94, 63, 128, 188, 233, 66, 0 },
        { 221, 179, 62, 130, 21, 138, 0 },
        { 33, 75, 158, 128, 254, 61, 0 }, },
      { { 41, 251, 7, 40, 147, 64, 0 },
        { 4, 163, 50, 45, 14, 31, 0 },
        { 1, 100, 138, 112, 111, 202, 0 },
        { 124, 56, 90, 38, 98, 144, 0 }, },
      { { 45, 79, 27, 209, 68, 171, 0 },
        { 113, 222, 72, 205, 102, 24, 1 },
        { 106, 145, 69, 236, 121, 90, 0 },
        { 140, 51, 89, 137, 61, 199, 0 }, },
      { { 44, 77, 58, 93, 125, 209, 0 },
        { 125, 222, 208, 76, 71, 195, 0 },
        { 69, 223, 93, 46, 89, 26, 0 },
        { 97, 241, 25, 5, 189, 223, 0 }, },
      { { 46, 201, 163, 115, 80, 78, 1 },
        { 151, 178, 200, 95, 174, 1, 0 },
        { 185, 5, 103, 98, 201, 186, 0 },
        { 64, 58, 253, 9, 166, 244, 1 }, },
      { { 47, 242, 157, 56, 166, 39, 0 },
        { 185, 103, 42, 63, 72, 30, 1 },
        { 114, 50, 142, 92, 167, 250, 0 },
        { 188, 9, 126, 42, 115, 78, 1 }, },
      { { 51, 14, 242, 29, 118, 78, 0 },
        { 220, 208, 141, 122, 99, 27, 0 },
        { 57, 55, 92, 39, 184, 102, 0 },
        { 108, 99, 47, 88, 133, 157, 1 }, },
      { { 51, 46, 161, 171, 153, 4, 0 },
        { 192, 160, 182, 219, 128, 155, 0 },
        { 16, 76, 234, 194, 186, 102, 0 },
        { 108, 128, 237, 182, 130, 129, 1 }, },
      { { 49, 41, 200, 243, 224, 220, 1 },
        { 62, 184, 103, 218, 164, 80, 0 },
        { 157, 131, 231, 137, 202, 70, 0 },
        { 5, 18, 173, 243, 14, 190, 0 }, },
      { { 53, 0, 254, 245, 196, 8, 0 },
        { 49, 112, 229, 202, 99, 20, 0 },
        { 8, 17, 215, 191, 128, 86, 0 },
        { 20, 99, 41, 211, 135, 70, 0 }, },
      { { 55, 36, 110, 62, 36, 63, 0 },
        { 249, 36, 143, 24, 227, 86, 1 },
        { 126, 18, 62, 59, 18, 118, 0 },
        { 181, 99, 140, 120, 146, 79, 1 }, },
      { { 53, 81, 121, 197, 146, 92, 1 },
        { 39, 65, 229, 253, 37, 81, 0 },
        { 157, 36, 209, 207, 69, 86, 0 },
        { 69, 82, 95, 211, 193, 114, 0 }, },
      { { 54, 184, 189, 91, 81, 60, 0 },
        { 177, 209, 214, 91, 168, 71, 1 },
        { 30, 69, 109, 94, 142, 182, 0 },
        { 241, 10, 237, 53, 197, 198, 1 }, },
      { { 54, 221, 188, 202, 44, 119, 0 },
        { 237, 197, 204, 158, 204, 198, 1 },
        { 119, 26, 41, 158, 221, 182, 0 },
        { 177, 153, 188, 153, 209, 219, 1 }, },
      { { 55, 221, 249, 250, 116, 140, 0 },
        { 249, 249, 197, 159, 236, 19, 0 },
        { 24, 151, 47, 207, 221, 246, 0 },
        { 100, 27, 252, 209, 207, 207, 1 }, },
      { { 57, 8, 64, 158, 68, 97, 1 },
        { 22, 150, 5, 136, 193, 18, 1 },
        { 195, 17, 60, 129, 8, 78, 0 },
        { 164, 65, 136, 208, 52, 180, 0 }, },
      { { 59, 1, 93, 14, 177, 201, 1 },
        { 174, 78, 53, 9, 165, 23, 0 },
        { 201, 198, 184, 93, 64, 110, 0 },
        { 116, 82, 200, 86, 57, 58, 1 }, },
      { { 58, 14, 216, 225, 88, 0, 1 },
        { 226, 242, 69, 202, 0, 137, 0 },
        { 128, 13, 67, 141, 184, 46, 0 },
        { 72, 128, 41, 209, 39, 163, 1 }, },
      { { 56, 110, 40, 10, 241, 243, 1 },
        { 110, 158, 190, 12, 128, 75, 1 },
        { 231, 199, 168, 10, 59, 14, 0 },
        { 233, 0, 152, 62, 188, 187, 0 }, },
      { { 57, 97, 243, 168, 199, 88, 1 },
        { 6, 114, 183, 175, 102, 82, 0 },
        { 141, 113, 138, 231, 195, 78, 0 },
        { 37, 51, 122, 246, 167, 48, 0 }, },
      { { 57, 175, 5, 221, 138, 171, 1 },
        { 82, 142, 110, 233, 45, 158, 1 },
        { 234, 168, 221, 208, 122, 206, 0 },
        { 188, 218, 75, 187, 56, 165, 0 }, },
      { { 57, 172, 253, 140, 32, 166, 1 },
        { 106, 202, 143, 155, 9, 22, 1 },
        { 178, 130, 24, 223, 154, 206, 0 },
        { 180, 72, 108, 248, 169, 171, 0 }, },
      { { 56, 215, 227, 25, 189, 206, 1 },
        { 94, 11, 189, 95, 110, 139, 0 },
        { 185, 222, 204, 99, 245, 142, 0 },
        { 104, 187, 125, 94, 232, 61, 0 }, },
      { { 62, 29, 177, 174, 155, 223, 1 },
        { 199, 239, 188, 187, 165, 195, 0 },
        { 253, 236, 186, 198, 220, 62, 0 },
        { 97, 210, 238, 158, 251, 241, 1 }, },
      { { 63, 57, 54, 16, 131, 58, 1 },
        { 147, 195, 190, 40, 38, 84, 1 },
        { 174, 96, 132, 54, 78, 126, 0 },
        { 149, 50, 10, 62, 225, 228, 1 }, },
      { { 61, 68, 172, 103, 73, 121, 1 },
        { 103, 54, 212, 78, 161, 212, 1 },
        { 207, 73, 115, 26, 145, 94, 0 },
        { 149, 194, 185, 21, 182, 115, 0 }, },
      { { 62, 216, 120, 160, 212, 247, 1 },
        { 167, 255, 173, 156, 72, 65, 1 },
        { 247, 149, 130, 143, 13, 190, 0 },
        { 193, 9, 28, 218, 255, 242, 1 }, },
      { { 67, 45, 92, 111, 10, 140, 0 },
        { 224, 232, 67, 112, 181, 150, 0 },
        { 24, 168, 123, 29, 90, 97, 0 },
        { 52, 214, 135, 97, 11, 131, 1 }, },
      { { 66, 52, 3, 145, 156, 82, 1 },
        { 214, 1, 42, 193, 82, 193, 0 },
        { 165, 28, 196, 224, 22, 33, 0 },
        { 65, 165, 65, 170, 64, 53, 1 }, },
      { { 64, 59, 107, 130, 137, 239, 0 },
        { 36, 141, 187, 145, 182, 136, 1 },
        { 123, 200, 160, 235, 110, 1, 0 },
        { 136, 182, 196, 238, 216, 146, 0 }, },
      { { 67, 109, 145, 73, 70, 116, 0 },
        { 196, 208, 66, 119, 84, 82, 1 },
        { 23, 49, 73, 68, 219, 97, 0 },
        { 165, 21, 119, 33, 5, 145, 1 }, },
      { { 67, 151, 133, 107, 233, 44, 1 },
        { 202, 49, 112, 83, 188, 158, 1 },
        { 154, 75, 235, 80, 244, 225, 0 },
        { 188, 158, 229, 7, 70, 41, 1 }, },
      { { 71, 29, 159, 177, 209, 0, 1 },
        { 243, 241, 48, 195, 22, 21, 0 },
        { 128, 69, 198, 252, 220, 113, 0 },
        { 84, 52, 97, 134, 71, 231, 1 }, },
      { { 70, 43, 251, 166, 87, 121, 0 },
        { 165, 244, 147, 163, 247, 73, 1 },
        { 79, 117, 50, 239, 234, 49, 0 },
        { 201, 119, 226, 228, 151, 210, 1 }, },
      { { 70, 92, 73, 248, 0, 58, 1 },
        { 243, 161, 73, 133, 48, 66, 1 },
        { 174, 0, 15, 201, 29, 49, 0 },
        { 161, 6, 80, 201, 66, 231, 1 }, },
      { { 69, 118, 247, 32, 48, 38, 1 },
        { 75, 97, 139, 23, 18, 29, 1 },
        { 178, 6, 2, 119, 183, 81, 0 },
        { 220, 36, 116, 104, 195, 105, 0 }, },
      { { 70, 168, 40, 69, 154, 252, 0 },
        { 165, 136, 226, 112, 57, 193, 1 },
        { 31, 172, 209, 10, 10, 177, 0 },
        { 193, 206, 7, 35, 136, 210, 1 }, },
      { { 68, 160, 107, 94, 1, 10, 0 },
        { 49, 0, 219, 1, 187, 2, 0 },
        { 40, 64, 61, 107, 2, 145, 0 },
        { 32, 110, 192, 109, 128, 70, 0 }, },
      { { 69, 185, 78, 113, 53, 37, 0 },
        { 57, 165, 83, 80, 94, 21, 1 },
        { 82, 86, 71, 57, 78, 209, 0 },
        { 212, 61, 5, 101, 82, 206, 0 }, },
      { { 75, 113, 215, 160, 253, 197, 1 },
        { 142, 127, 51, 151, 86, 149, 0 },
        { 209, 223, 130, 245, 199, 105, 0 },
        { 84, 181, 116, 230, 127, 56, 1 }, },
      { { 79, 60, 121, 82, 108, 209, 1 },
        { 255, 223, 195, 1, 208, 208, 0 },
        { 197, 155, 37, 79, 30, 121, 0 },
        { 5, 133, 192, 97, 253, 255, 1 }, },
      { { 79, 178, 80, 33, 70, 98, 0 },
        { 133, 115, 11, 96, 88, 24, 1 },
        { 35, 49, 66, 5, 38, 249, 0 },
        { 140, 13, 3, 104, 103, 80, 1 }, },
      { { 79, 239, 177, 247, 108, 238, 1 },
        { 223, 250, 202, 215, 253, 152, 1 },
        { 187, 155, 119, 198, 251, 249, 0 },
        { 140, 223, 245, 169, 175, 253, 1 }, },
      { { 82, 75, 82, 250, 189, 204, 0 },
        { 156, 232, 117, 148, 246, 139, 0 },
        { 25, 222, 175, 165, 105, 37, 0 },
        { 104, 183, 148, 215, 11, 156, 1 }, },
      { { 83, 200, 244, 221, 123, 200, 1 },
        { 158, 216, 213, 230, 57, 151, 0 },
        { 137, 239, 93, 151, 137, 229, 0 },
        { 116, 206, 51, 213, 141, 188, 1 }, },
      { { 87, 5, 99, 141, 134, 48, 0 },
        { 193, 0, 165, 225, 87, 82, 1 },
        { 6, 48, 216, 227, 80, 117, 0 },
        { 165, 117, 67, 210, 128, 65, 1 }, },
      { { 85, 75, 225, 85, 227, 0, 0 },
        { 25, 144, 245, 103, 21, 24, 0 },
        { 0, 99, 213, 67, 233, 85, 0 },
        { 12, 84, 115, 87, 132, 204, 0 }, },
      { { 85, 138, 47, 175, 183, 98, 0 },
        { 45, 160, 188, 225, 219, 31, 1 },
        { 35, 118, 250, 250, 40, 213, 0 },
        { 252, 109, 195, 158, 130, 218, 0 }, },
      { { 84, 153, 49, 31, 160, 83, 0 },
        { 29, 197, 172, 65, 157, 66, 0 },
        { 101, 2, 252, 70, 76, 149, 0 },
        { 33, 92, 193, 26, 209, 220, 0 }, },
      { { 88, 13, 255, 122, 69, 176, 1 },
        { 114, 250, 213, 3, 214, 70, 1 },
        { 134, 209, 47, 127, 216, 13, 0 },
        { 177, 53, 224, 85, 175, 167, 0 }, },
      { { 90, 18, 17, 208, 247, 52, 1 },
        { 154, 83, 116, 177, 80, 73, 1 },
        { 150, 119, 133, 196, 36, 45, 0 },
        { 201, 5, 70, 151, 101, 44, 1 }, },
      { { 95, 17, 24, 22, 24, 164, 0 },
        { 177, 75, 4, 16, 149, 145, 1 },
        { 18, 140, 52, 12, 68, 125, 0 },
        { 196, 212, 132, 16, 105, 70, 1 }, },
      { { 93, 61, 87, 179, 227, 47, 0 },
        { 89, 247, 63, 241, 182, 20, 1 },
        { 122, 99, 230, 245, 94, 93, 0 },
        { 148, 54, 199, 254, 119, 205, 0 }, },
      { { 93, 74, 155, 244, 162, 166, 0 },
        { 57, 234, 108, 183, 19, 24, 1 },
        { 50, 162, 151, 236, 169, 93, 0 },
        { 140, 100, 118, 155, 43, 206, 0 }, },
      { { 94, 137, 78, 179, 16, 89, 0 },
        { 181, 166, 5, 192, 190, 69, 0 },
        { 77, 4, 102, 185, 72, 189, 0 },
        { 81, 62, 129, 208, 50, 214, 1 }, },
      { { 95, 182, 4, 116, 142, 30, 1 },
        { 211, 35, 110, 48, 121, 220, 0 },
        { 188, 56, 151, 16, 54, 253, 0 },
        { 29, 207, 6, 59, 98, 101, 1 }, },
      { { 95, 252, 162, 7, 10, 47, 1 },
        { 195, 135, 142, 118, 187, 144, 1 },
        { 250, 40, 112, 34, 159, 253, 0 },
        { 132, 238, 183, 56, 240, 225, 1 }, },
      { { 98, 20, 52, 163, 198, 43, 1 },
        { 194, 117, 168, 232, 240, 4, 1 },
        { 234, 49, 226, 150, 20, 35, 0 },
        { 144, 7, 139, 138, 215, 33, 1 }, },
      { { 96, 69, 249, 159, 75, 213, 0 },
        { 116, 92, 145, 255, 149, 194, 0 },
        { 85, 233, 124, 207, 209, 3, 0 },
        { 33, 212, 255, 196, 157, 23, 0 }, },
      { { 96, 94, 235, 202, 23, 75, 1 },
        { 102, 133, 217, 175, 242, 11, 0 },
        { 233, 116, 41, 235, 189, 3, 0 },
        { 104, 39, 250, 205, 208, 179, 0 }, },
      { { 97, 111, 101, 43, 244, 79, 0 },
        { 76, 180, 171, 93, 244, 31, 0 },
        { 121, 23, 234, 83, 123, 67, 0 },
        { 124, 23, 221, 106, 150, 153, 0 }, },
      { { 96, 111, 231, 237, 175, 53, 0 },
        { 72, 164, 243, 255, 87, 206, 1 },
        { 86, 122, 219, 243, 251, 3, 0 },
        { 185, 245, 127, 231, 146, 137, 0 }, },
      { { 98, 227, 54, 39, 167, 213, 0 },
        { 140, 108, 178, 124, 223, 76, 0 },
        { 85, 242, 242, 54, 99, 163, 0 },
        { 25, 125, 159, 38, 155, 24, 1 }, },
      { { 101, 50, 13, 146, 242, 6, 0 },
        { 57, 17, 42, 185, 144, 29, 0 },
        { 48, 39, 164, 216, 38, 83, 0 },
        { 92, 4, 206, 170, 68, 78, 0 }, },
      { { 101, 174, 116, 178, 81, 246, 0 },
        { 85, 248, 155, 152, 152, 93, 1 },
        { 55, 197, 38, 151, 58, 211, 0 },
        { 221, 12, 140, 236, 143, 213, 0 }, },
      { { 106, 37, 233, 73, 31, 2, 1 },
        { 226, 2, 219, 107, 84, 131, 0 },
        { 160, 124, 73, 75, 210, 43, 0 },
        { 96, 149, 107, 109, 160, 35, 1 }, },
      { { 105, 154, 22, 139, 171, 78, 0 },
        { 12, 195, 56, 248, 186, 158, 0 },
        { 57, 106, 232, 180, 44, 203, 0 },
        { 60, 174, 143, 142, 97, 152, 0 }, },
      { { 104, 159, 185, 186, 26, 80, 0 },
        { 116, 227, 128, 171, 156, 203, 0 },
        { 5, 44, 46, 206, 252, 139, 0 },
        { 105, 156, 234, 128, 227, 151, 0 }, },
      { { 104, 172, 27, 248, 226, 27, 1 },
        { 122, 246, 106, 169, 58, 66, 0 },
        { 236, 35, 143, 236, 26, 139, 0 },
        { 33, 46, 74, 171, 55, 175, 0 }, },
      { { 107, 204, 220, 27, 224, 85, 0 },
        { 252, 214, 33, 94, 152, 86, 0 },
        { 85, 3, 236, 29, 153, 235, 0 },
        { 53, 12, 189, 66, 53, 159, 1 }, },
      { { 110, 70, 68, 174, 42, 27, 1 },
        { 203, 38, 9, 172, 177, 206, 0 },
        { 236, 42, 58, 145, 49, 59, 0 },
        { 57, 198, 154, 200, 50, 105, 1 }, },
      { { 110, 91, 221, 156, 85, 145, 1 },
        { 179, 223, 17, 143, 85, 79, 0 },
        { 196, 213, 28, 221, 237, 59, 0 },
        { 121, 85, 120, 196, 125, 230, 1 }, },
      { { 110, 114, 103, 14, 62, 109, 0 },
        { 141, 7, 131, 61, 243, 143, 1 },
        { 91, 62, 56, 115, 39, 59, 0 },
        { 248, 231, 222, 96, 240, 88, 1 }, },
      { { 111, 134, 147, 35, 45, 171, 0 },
        { 201, 110, 24, 75, 250, 152, 1 },
        { 106, 218, 98, 100, 176, 251, 0 },
        { 140, 175, 233, 12, 59, 73, 1 }, },
      { { 108, 137, 244, 64, 218, 114, 1 },
        { 7, 210, 233, 42, 28, 197, 1 },
        { 167, 45, 129, 23, 200, 155, 0 },
        { 209, 156, 42, 75, 165, 240, 0 }, },
      { { 111, 156, 82, 187, 178, 211, 1 },
        { 223, 239, 41, 232, 154, 83, 0 },
        { 229, 166, 238, 165, 28, 251, 0 },
        { 101, 44, 139, 202, 123, 253, 1 }, },
      { { 111, 148, 127, 90, 90, 175, 1 },
        { 243, 95, 201, 57, 186, 151, 1 },
        { 250, 173, 45, 127, 20, 251, 0 },
        { 244, 174, 206, 73, 253, 103, 1 }, },
      { { 110, 168, 22, 55, 188, 108, 1 },
        { 159, 226, 34, 88, 251, 133, 1 },
        { 155, 30, 246, 52, 10, 187, 0 },
        { 208, 239, 141, 34, 35, 252, 1 }, },
      { { 110, 177, 138, 108, 23, 81, 0 },
        { 165, 39, 82, 42, 95, 67, 0 },
        { 69, 116, 27, 40, 198, 187, 0 },
        { 97, 125, 42, 37, 114, 82, 1 }, },
      { { 111, 200, 142, 200, 247, 162, 0 },
        { 169, 154, 120, 174, 90, 23, 1 },
        { 34, 247, 137, 184, 137, 251, 0 },
        { 244, 45, 58, 143, 44, 202, 1 }, },
      { { 115, 81, 80, 190, 35, 239, 0 },
        { 156, 109, 29, 188, 181, 18, 1 },
        { 123, 226, 62, 133, 69, 103, 0 },
        { 164, 86, 158, 220, 91, 28, 1 }, },
      { { 112, 139, 71, 240, 27, 189, 0 },
        { 16, 172, 85, 185, 62, 205, 1 },
        { 94, 236, 7, 241, 104, 135, 0 },
        { 217, 190, 78, 213, 26, 132, 0 }, },
      { { 112, 149, 37, 251, 26, 110, 1 },
        { 86, 33, 204, 249, 188, 135, 1 },
        { 187, 44, 111, 210, 84, 135, 0 },
        { 240, 158, 207, 153, 194, 53, 0 }, },
      { { 114, 158, 255, 114, 99, 90, 0 },
        { 252, 241, 221, 43, 186, 76, 0 },
        { 45, 99, 39, 127, 188, 167, 0 },
        { 25, 46, 234, 93, 199, 159, 1 }, },
      { { 112, 171, 227, 124, 150, 208, 1 },
        { 22, 168, 231, 43, 95, 75, 0 },
        { 133, 180, 159, 99, 234, 135, 0 },
        { 105, 125, 106, 115, 138, 180, 0 }, },
      { { 114, 245, 151, 82, 179, 142, 0 },
        { 216, 73, 126, 63, 190, 5, 0 },
        { 56, 230, 165, 116, 215, 167, 0 },
        { 80, 62, 254, 63, 73, 13, 1 }, },
      { { 118, 5, 164, 230, 226, 221, 0 },
        { 205, 60, 228, 186, 181, 68, 0 },
        { 93, 163, 179, 146, 208, 55, 0 },
        { 17, 86, 174, 147, 158, 89, 1 }, },
      { { 116, 17, 6, 76, 105, 165, 0 },
        { 9, 29, 84, 24, 23, 134, 1 },
        { 82, 203, 25, 48, 68, 23, 0 },
        { 176, 244, 12, 21, 92, 72, 0 }, },
      { { 118, 36, 17, 60, 244, 246, 1 },
        { 223, 120, 46, 25, 81, 67, 1 },
        { 183, 151, 158, 68, 18, 55, 0 },
        { 225, 69, 76, 58, 15, 125, 1 }, },
      { { 116, 101, 193, 88, 187, 101, 1 },
        { 95, 4, 119, 63, 20, 131, 1 },
        { 211, 110, 141, 65, 211, 23, 0 },
        { 224, 148, 126, 119, 16, 125, 0 }, },
      { { 119, 125, 91, 58, 188, 225, 0 },
        { 253, 237, 39, 13, 214, 147, 1 },
        { 67, 158, 174, 109, 95, 119, 0 },
        { 228, 181, 216, 114, 91, 223, 1 }, },
      { { 119, 182, 15, 188, 123, 59, 0 },
        { 249, 53, 30, 169, 59, 223, 1 },
        { 110, 111, 30, 248, 54, 247, 0 },
        { 253, 238, 74, 188, 86, 79, 1 }, },
      { { 118, 180, 133, 0, 61, 168, 1 },
        { 203, 9, 22, 11, 120, 133, 1 },
        { 138, 222, 0, 80, 150, 183, 0 },
        { 208, 143, 104, 52, 72, 105, 1 }, },
      { { 117, 238, 187, 75, 14, 98, 1 },
        { 103, 192, 206, 111, 218, 154, 1 },
        { 163, 56, 105, 110, 187, 215, 0 },
        { 172, 173, 251, 57, 129, 243, 0 }, },
      { { 118, 250, 208, 216, 178, 184, 0 },
        { 153, 201, 103, 174, 56, 75, 1 },
        { 14, 166, 141, 133, 175, 183, 0 },
        { 233, 14, 58, 243, 73, 204, 1 }, },
      { { 120, 75, 97, 130, 218, 8, 1 },
        { 2, 146, 165, 173, 180, 137, 0 },
        { 136, 45, 160, 195, 105, 15, 0 },
        { 72, 150, 218, 210, 164, 160, 0 }, },
      { { 122, 187, 251, 47, 52, 31, 1 },
        { 170, 231, 143, 91, 255, 75, 0 },
        { 252, 22, 122, 111, 238, 175, 0 },
        { 105, 127, 237, 120, 243, 170, 1 }, },
      { { 127, 39, 5, 215, 84, 100, 0 },
        { 213, 18, 70, 217, 213, 29, 1 },
        { 19, 21, 117, 208, 114, 127, 0 },
        { 220, 85, 205, 177, 36, 85, 1 }, },
      { { 125, 227, 180, 31, 248, 152, 0 },
        { 25, 90, 166, 78, 189, 223, 0 },
        { 12, 143, 252, 22, 227, 223, 0 },
        { 125, 222, 185, 50, 173, 76, 0 }, },
      { { 127, 237, 141, 135, 251, 207, 1 },
        { 239, 158, 62, 255, 189, 149, 0 },
        { 249, 239, 240, 216, 219, 255, 0 },
        { 84, 222, 255, 190, 60, 251, 1 }, },
      { { 126, 246, 82, 55, 17, 197, 0 },
        { 213, 111, 23, 92, 155, 9, 0 },
        { 81, 196, 118, 37, 55, 191, 0 },
        { 72, 108, 157, 116, 123, 85, 1 }, },
      { { 129, 31, 240, 203, 185, 104, 1 },
        { 78, 193, 241, 194, 164, 187, 1 },
        { 139, 78, 233, 135, 252, 64, 1 },
        { 238, 146, 161, 199, 193, 185, 0 }, },
      { { 128, 46, 234, 6, 149, 52, 0 },
        { 96, 128, 179, 18, 195, 105, 1 },
        { 22, 84, 176, 43, 186, 0, 1 },
        { 203, 97, 164, 102, 128, 131, 0 }, },
      { { 130, 73, 255, 59, 138, 203, 1 },
        { 182, 236, 169, 103, 166, 166, 0 },
        { 233, 168, 238, 127, 201, 32, 1 },
        { 50, 178, 243, 74, 155, 182, 1 }, },
      { { 129, 200, 212, 49, 219, 37, 0 },
        { 16, 244, 49, 118, 8, 181, 1 },
        { 82, 109, 198, 21, 137, 192, 1 },
        { 214, 136, 55, 70, 23, 132, 0 }, },
      { { 132, 43, 15, 88, 160, 122, 0 },
        { 61, 128, 106, 1, 38, 110, 1 },
        { 47, 2, 141, 120, 106, 16, 1 },
        { 187, 50, 64, 43, 0, 222, 0 }, },
      { { 133, 43, 127, 179, 216, 14, 0 },
        { 49, 240, 171, 209, 166, 189, 0 },
        { 56, 13, 230, 255, 106, 80, 1 },
        { 94, 178, 197, 234, 135, 198, 0 }, },
      { { 134, 32, 167, 236, 235, 192, 1 },
        { 143, 56, 242, 163, 3, 166, 0 },
        { 129, 235, 155, 242, 130, 48, 1 },
        { 50, 224, 98, 167, 142, 120, 1 }, },
      { { 134, 89, 195, 75, 94, 119, 1 },
        { 135, 149, 73, 119, 198, 227, 1 },
        { 247, 61, 105, 97, 205, 48, 1 },
        { 227, 177, 247, 73, 84, 240, 1 }, },
      { { 135, 96, 6, 117, 87, 9, 0 },
        { 145, 52, 82, 100, 99, 53, 0 },
        { 72, 117, 87, 48, 3, 112, 1 },
        { 86, 99, 19, 37, 22, 68, 1 }, },
      { { 132, 219, 148, 26, 247, 200, 0 },
        { 29, 217, 48, 38, 236, 47, 0 },
        { 9, 247, 172, 20, 237, 144, 1 },
        { 122, 27, 178, 6, 77, 220, 0 }, },
      { { 138, 22, 181, 10, 57, 125, 0 },
        { 204, 71, 144, 19, 160, 239, 1 },
        { 95, 78, 40, 86, 180, 40, 1 },
        { 251, 130, 228, 4, 241, 25, 1 }, },
      { { 138, 63, 78, 17, 183, 8, 0 },
        { 248, 131, 51, 96, 102, 45, 0 },
        { 8, 118, 196, 57, 126, 40, 1 },
        { 90, 51, 3, 102, 96, 143, 1 }, },
      { { 137, 70, 134, 138, 98, 190, 0 },
        { 72, 26, 8, 182, 162, 126, 1 },
        { 62, 163, 40, 176, 177, 72, 1 },
        { 191, 34, 182, 136, 44, 9, 0 }, },
      { { 139, 122, 129, 163, 127, 219, 0 },
        { 140, 191, 26, 231, 224, 249, 0 },
        { 109, 255, 98, 192, 175, 104, 1 },
        { 79, 131, 243, 172, 126, 152, 1 }, },
      { { 137, 134, 220, 73, 174, 214, 0 },
        { 108, 74, 105, 114, 72, 254, 0 },
        { 53, 186, 201, 29, 176, 200, 1 },
        { 63, 137, 39, 75, 41, 27, 0 }, },
      { { 137, 153, 52, 70, 112, 178, 1 },
        { 10, 219, 200, 0, 141, 117, 1 },
        { 166, 135, 49, 22, 76, 200, 1 },
        { 215, 88, 128, 9, 237, 168, 0 }, },
      { { 139, 205, 202, 224, 85, 9, 1 },
        { 226, 182, 81, 134, 110, 49, 0 },
        { 200, 85, 3, 169, 217, 232, 1 },
        { 70, 59, 48, 197, 54, 163, 1 }, },
      { { 139, 222, 241, 118, 82, 104, 1 },
        { 214, 243, 193, 39, 169, 57, 1 },
        { 139, 37, 55, 71, 189, 232, 1 },
        { 206, 74, 242, 65, 231, 181, 1 }, },
      { { 142, 18, 98, 26, 198, 81, 1 },
        { 151, 23, 161, 32, 194, 106, 0 },
        { 197, 49, 172, 35, 36, 56, 1 },
        { 43, 33, 130, 66, 244, 116, 1 }, },
      { { 141, 46, 148, 181, 204, 168, 0 },
        { 81, 250, 34, 194, 97, 188, 1 },
        { 10, 153, 214, 148, 186, 88, 1 },
        { 158, 195, 33, 162, 47, 197, 0 }, },
      { { 140, 75, 185, 11, 82, 34, 0 },
        { 33, 210, 136, 103, 132, 43, 1 },
        { 34, 37, 104, 78, 233, 24, 1 },
        { 234, 16, 243, 8, 165, 194, 0 }, },
      { { 141, 153, 201, 208, 216, 171, 1 },
        { 51, 159, 105, 131, 44, 177, 1 },
        { 234, 141, 133, 201, 204, 216, 1 },
        { 198, 154, 96, 203, 124, 230, 0 }, },
      { { 144, 17, 129, 73, 60, 185, 1 },
        { 10, 13, 68, 67, 100, 227, 1 },
        { 206, 158, 73, 64, 196, 4, 1 },
        { 227, 147, 97, 17, 88, 40, 0 }, },
      { { 146, 45, 168, 84, 94, 84, 1 },
        { 246, 144, 198, 50, 69, 225, 0 },
        { 149, 61, 21, 10, 218, 36, 1 },
        { 67, 209, 38, 49, 132, 183, 1 }, },
      { { 144, 78, 120, 161, 56, 250, 1 },
        { 110, 232, 141, 196, 32, 233, 1 },
        { 175, 142, 66, 143, 57, 4, 1 },
        { 203, 130, 17, 216, 139, 187, 0 }, },
      { { 144, 151, 90, 16, 127, 241, 0 },
        { 124, 93, 21, 32, 78, 233, 1 },
        { 71, 255, 4, 45, 116, 132, 1 },
        { 203, 185, 2, 84, 93, 31, 0 }, },
      { { 144, 179, 61, 187, 100, 42, 0 },
        { 56, 113, 142, 193, 236, 46, 1 },
        { 42, 19, 110, 222, 102, 132, 1 },
        { 186, 27, 193, 184, 199, 14, 0 }, },
      { { 147, 192, 227, 79, 19, 241, 0 },
        { 132, 12, 213, 103, 139, 115, 1 },
        { 71, 228, 121, 99, 129, 228, 1 },
        { 231, 104, 243, 85, 152, 16, 1 }, },
      { { 151, 73, 34, 81, 12, 38, 0 },
        { 145, 128, 204, 84, 70, 176, 1 },
        { 50, 24, 69, 34, 73, 116, 1 },
        { 134, 177, 21, 25, 128, 196, 1 }, },
      { { 151, 74, 87, 164, 6, 195, 0 },
        { 133, 236, 13, 165, 67, 60, 0 },
        { 97, 176, 18, 245, 41, 116, 1 },
        { 30, 97, 82, 216, 27, 208, 1 }, },
      { { 150, 115, 104, 38, 246, 150, 1 },
        { 171, 57, 175, 52, 197, 105, 0 },
        { 180, 183, 178, 11, 103, 52, 1 },
        { 75, 81, 150, 122, 206, 106, 1 }, },
      { { 149, 138, 223, 218, 96, 3, 1 },
        { 59, 212, 77, 131, 138, 62, 0 },
        { 224, 3, 45, 253, 168, 212, 1 },
        { 62, 40, 224, 217, 21, 238, 0 }, },
      { { 150, 175, 46, 35, 58, 45, 0 },
        { 233, 164, 134, 112, 174, 173, 1 },
        { 90, 46, 98, 58, 122, 180, 1 },
        { 218, 186, 135, 48, 146, 203, 1 }, },
      { { 155, 7, 68, 229, 222, 47, 0 },
        { 192, 54, 109, 240, 101, 189, 1 },
        { 122, 61, 211, 145, 112, 108, 1 },
        { 222, 211, 7, 219, 54, 1, 1 }, },
      { { 152, 75, 88, 148, 206, 180, 0 },
        { 48, 218, 37, 180, 69, 232, 1 },
        { 22, 185, 148, 141, 105, 12, 1 },
        { 139, 209, 22, 210, 45, 134, 0 }, },
      { { 153, 122, 202, 55, 11, 119, 1 },
        { 54, 167, 31, 118, 131, 248, 1 },
        { 247, 104, 118, 41, 175, 76, 1 },
        { 143, 224, 183, 124, 114, 182, 0 }, },
      { { 156, 0, 144, 208, 133, 65, 1 },
        { 23, 70, 116, 130, 64, 32, 0 },
        { 193, 80, 133, 132, 128, 28, 1 },
        { 2, 1, 32, 151, 49, 116, 0 }, },
      { { 157, 117, 4, 69, 227, 242, 1 },
        { 79, 27, 126, 100, 5, 116, 1 },
        { 167, 227, 209, 16, 87, 92, 1 },
        { 151, 80, 19, 63, 108, 121, 0 }, },
      { { 160, 66, 244, 31, 20, 137, 1 },
        { 18, 76, 129, 78, 225, 47, 0 },
        { 200, 148, 124, 23, 161, 2, 1 },
        { 122, 67, 185, 64, 153, 36, 0 }, },
      { { 160, 154, 32, 41, 137, 97, 0 },
        { 4, 165, 176, 72, 8, 170, 1 },
        { 67, 72, 202, 2, 44, 130, 1 },
        { 170, 136, 9, 6, 210, 144, 0 }, },
      { { 161, 151, 65, 181, 6, 20, 0 },
        { 80, 33, 1, 249, 77, 120, 0 },
        { 20, 48, 86, 193, 116, 194, 1 },
        { 15, 89, 79, 192, 66, 5, 0 }, },
      { { 162, 199, 179, 237, 218, 219, 0 },
        { 196, 124, 232, 239, 47, 235, 0 },
        { 109, 173, 219, 230, 241, 162, 1 },
        { 107, 250, 123, 139, 159, 17, 1 }, },
      { { 163, 237, 115, 3, 171, 156, 0 },
        { 200, 200, 179, 125, 174, 240, 0 },
        { 28, 234, 224, 103, 91, 226, 1 },
        { 7, 186, 223, 102, 137, 137, 1 }, },
      { { 164, 14, 153, 123, 197, 24, 0 },
        { 113, 240, 112, 75, 224, 106, 0 },
        { 12, 81, 239, 76, 184, 18, 1 },
        { 43, 3, 233, 7, 7, 199, 0 }, },
      { { 166, 46, 211, 181, 170, 239, 0 },
        { 221, 236, 43, 251, 35, 168, 1 },
        { 123, 170, 214, 229, 186, 50, 1 },
        { 138, 226, 111, 234, 27, 221, 1 }, },
      { { 166, 72, 83, 81, 97, 91, 1 },
        { 159, 212, 89, 77, 34, 96, 0 },
        { 237, 67, 69, 101, 9, 50, 1 },
        { 3, 34, 89, 77, 21, 252, 1 }, },
      { { 166, 88, 46, 241, 183, 120, 1 },
        { 191, 161, 240, 236, 98, 101, 1 },
        { 143, 118, 199, 186, 13, 50, 1 },
        { 211, 35, 27, 135, 194, 254, 1 }, },
      { { 167, 125, 62, 203, 3, 105, 0 },
        { 229, 197, 210, 236, 166, 54, 1 },
        { 75, 96, 105, 190, 95, 114, 1 },
        { 182, 50, 155, 165, 209, 211, 1 }, },
      { { 165, 183, 40, 12, 100, 157, 0 },
        { 105, 29, 130, 24, 109, 122, 0 },
        { 92, 147, 24, 10, 118, 210, 1 },
        { 47, 91, 12, 32, 220, 75, 0 }, },
      { { 164, 207, 91, 78, 212, 244, 0 },
        { 101, 216, 97, 29, 207, 107, 1 },
        { 23, 149, 185, 109, 121, 146, 1 },
        { 235, 121, 220, 67, 13, 211, 0 }, },
      { { 171, 21, 211, 205, 48, 133, 0 },
        { 200, 79, 65, 219, 7, 51, 0 },
        { 80, 134, 89, 229, 212, 106, 1 },
        { 102, 112, 109, 193, 121, 9, 1 }, },
      { { 171, 47, 103, 30, 208, 8, 1 },
        { 210, 146, 163, 9, 167, 63, 0 },
        { 136, 5, 188, 115, 122, 106, 1 },
        { 126, 114, 200, 98, 164, 165, 1 }, },
      { { 168, 43, 177, 100, 80, 17, 1 },
        { 2, 246, 194, 11, 5, 105, 0 },
        { 196, 5, 19, 70, 234, 10, 1 },
        { 75, 80, 104, 33, 183, 160, 0 }, },
      { { 168, 67, 58, 121, 199, 250, 1 },
        { 54, 122, 248, 108, 102, 106, 1 },
        { 175, 241, 207, 46, 97, 10, 1 },
        { 171, 51, 27, 15, 175, 54, 0 }, },
      { { 168, 95, 145, 245, 169, 81, 0 },
        { 92, 231, 112, 207, 5, 232, 0 },
        { 69, 74, 215, 196, 253, 10, 1 },
        { 11, 208, 121, 135, 115, 157, 0 }, },
      { { 168, 126, 123, 132, 128, 94, 1 },
        { 102, 195, 171, 157, 35, 104, 0 },
        { 189, 0, 144, 239, 63, 10, 1 },
        { 11, 98, 92, 234, 225, 179, 0 }, },
      { { 168, 132, 121, 195, 96, 56, 1 },
        { 106, 82, 193, 201, 168, 96, 1 },
        { 142, 3, 97, 207, 16, 138, 1 },
        { 131, 10, 201, 193, 165, 43, 0 }, },
      { { 171, 163, 68, 207, 130, 112, 0 },
        { 132, 2, 99, 232, 141, 126, 1 },
        { 7, 32, 249, 145, 98, 234, 1 },
        { 191, 88, 139, 227, 32, 16, 1 }, },
      { { 171, 230, 49, 247, 179, 118, 0 },
        { 220, 98, 250, 253, 137, 121, 1 },
        { 55, 102, 247, 198, 51, 234, 1 },
        { 207, 72, 223, 175, 163, 29, 1 }, },
      { { 172, 22, 16, 22, 73, 151, 0 },
        { 81, 95, 24, 24, 129, 232, 0 },
        { 116, 201, 52, 4, 52, 26, 1 },
        { 11, 192, 140, 12, 125, 69, 0 }, },
      { { 174, 39, 216, 18, 235, 36, 1 },
        { 251, 82, 51, 58, 132, 168, 1 },
        { 146, 107, 164, 13, 242, 58, 1 },
        { 138, 144, 174, 102, 37, 111, 1 }, },
      { { 175, 59, 230, 2, 186, 159, 1 },
        { 139, 143, 171, 58, 166, 253, 0 },
        { 252, 174, 160, 51, 238, 122, 1 },
        { 95, 178, 174, 106, 248, 232, 1 }, },
      { { 174, 70, 26, 234, 137, 71, 1 },
        { 231, 102, 120, 156, 130, 170, 0 },
        { 241, 72, 171, 172, 49, 58, 1 },
        { 42, 160, 156, 143, 51, 115, 1 }, },
      { { 173, 66, 113, 218, 119, 159, 1 },
        { 27, 94, 217, 189, 224, 123, 0 },
        { 252, 247, 45, 199, 33, 90, 1 },
        { 111, 3, 222, 205, 189, 108, 0 }, },
      { { 173, 88, 23, 206, 43, 193, 1 },
        { 15, 207, 80, 173, 131, 182, 0 },
        { 193, 234, 57, 244, 13, 90, 1 },
        { 54, 224, 218, 133, 121, 248, 0 }, },
      { { 172, 151, 210, 208, 179, 77, 0 },
        { 93, 71, 113, 186, 46, 41, 0 },
        { 89, 102, 133, 165, 244, 154, 1 },
        { 74, 58, 46, 199, 113, 93, 0 }, },
      { { 173, 190, 197, 66, 11, 202, 0 },
        { 69, 139, 91, 43, 168, 188, 0 },
        { 41, 232, 33, 81, 190, 218, 1 },
        { 30, 138, 234, 109, 104, 209, 0 }, },
      { { 175, 250, 80, 85, 120, 101, 0 },
        { 157, 215, 67, 92, 9, 185, 1 },
        { 83, 15, 85, 5, 47, 250, 1 },
        { 206, 200, 29, 97, 117, 220, 1 }, },
      { { 176, 31, 206, 26, 12, 146, 1 },
        { 114, 137, 13, 10, 198, 238, 0 },
        { 164, 152, 44, 57, 252, 6, 1 },
        { 59, 177, 168, 88, 72, 167, 0 }, },
      { { 177, 112, 134, 190, 143, 137, 0 },
        { 16, 45, 54, 174, 227, 182, 0 },
        { 72, 248, 190, 176, 135, 70, 1 },
        { 54, 227, 186, 182, 90, 4, 0 }, },
      { { 183, 222, 54, 61, 41, 2, 0 },
        { 217, 225, 156, 76, 11, 190, 0 },
        { 32, 74, 94, 54, 61, 246, 1 },
        { 62, 232, 25, 28, 195, 205, 1 }, },
      { { 180, 229, 14, 234, 89, 126, 0 },
        { 101, 48, 94, 156, 174, 231, 1 },
        { 63, 77, 43, 184, 83, 150, 1 },
        { 243, 186, 156, 189, 6, 83, 0 }, },
      { { 186, 59, 44, 235, 91, 138, 0 },
        { 160, 187, 222, 232, 164, 175, 0 },
        { 40, 237, 107, 154, 110, 46, 1 },
        { 122, 146, 139, 189, 238, 130, 1 }, },
      { { 187, 123, 82, 243, 209, 20, 0 },
        { 144, 243, 119, 220, 134, 121, 0 },
        { 20, 69, 231, 165, 111, 110, 1 },
        { 79, 48, 157, 247, 103, 132, 1 }, },
      { { 186, 116, 182, 71, 89, 86, 1 },
        { 198, 83, 222, 94, 131, 229, 0 },
        { 181, 77, 113, 54, 151, 46, 1 },
        { 83, 224, 189, 61, 229, 49, 1 }, },
      { { 186, 139, 73, 97, 25, 111, 1 },
        { 166, 166, 93, 89, 44, 169, 1 },
        { 251, 76, 67, 73, 104, 174, 1 },
        { 202, 154, 77, 93, 50, 178, 1 }, },
      { { 187, 152, 233, 200, 28, 89, 0 },
        { 164, 135, 197, 139, 104, 243, 0 },
        { 77, 28, 9, 203, 140, 238, 1 },
        { 103, 139, 104, 209, 240, 146, 1 }, },
      { { 188, 30, 177, 81, 156, 163, 1 },
        { 83, 207, 236, 75, 64, 169, 1 },
        { 226, 156, 197, 70, 188, 30, 1 },
        { 202, 129, 105, 27, 249, 229, 0 }, },
      { { 188, 42, 52, 17, 27, 68, 1 },
        { 23, 194, 150, 120, 0, 173, 0 },
        { 145, 108, 68, 22, 42, 30, 1 },
        { 90, 128, 15, 52, 161, 244, 0 }, },
      { { 189, 81, 101, 27, 30, 213, 0 },
        { 21, 15, 133, 125, 196, 247, 0 },
        { 85, 188, 108, 83, 69, 94, 1 },
        { 119, 145, 223, 80, 248, 84, 0 }, },
      { { 190, 112, 117, 173, 51, 180, 1 },
        { 139, 107, 151, 253, 1, 103, 1 },
        { 150, 230, 90, 215, 7, 62, 1 },
        { 243, 64, 95, 244, 235, 104, 1 }, },
      { { 189, 255, 164, 161, 70, 198, 1 },
        { 71, 187, 142, 254, 76, 60, 0 },
        { 177, 177, 66, 146, 255, 222, 1 },
        { 30, 25, 63, 184, 238, 241, 0 }, },
      { { 193, 4, 151, 159, 155, 192, 0 },
        { 84, 72, 48, 227, 147, 183, 0 },
        { 1, 236, 252, 244, 144, 65, 1 },
        { 118, 228, 227, 134, 9, 21, 0 }, },
      { { 193, 30, 33, 36, 254, 38, 1 },
        { 74, 177, 168, 49, 81, 185, 1 },
        { 178, 63, 146, 66, 60, 65, 1 },
        { 206, 197, 70, 10, 198, 169, 0 }, },
      { { 192, 237, 72, 64, 106, 165, 0 },
        { 104, 156, 67, 52, 28, 160, 1 },
        { 82, 171, 1, 9, 91, 129, 1 },
        { 130, 156, 22, 97, 28, 139, 0 }, },
      { { 192, 234, 184, 166, 4, 229, 0 },
        { 36, 236, 130, 150, 217, 40, 1 },
        { 83, 144, 50, 142, 171, 129, 1 },
        { 138, 77, 180, 160, 155, 146, 0 }, },
      { { 198, 87, 250, 41, 77, 82, 1 },
        { 231, 113, 153, 70, 86, 234, 0 },
        { 165, 89, 74, 47, 245, 49, 1 },
        { 43, 181, 49, 76, 199, 115, 1 }, },
      { { 200, 111, 63, 193, 206, 104, 0 },
        { 100, 210, 226, 229, 118, 172, 1 },
        { 11, 57, 193, 254, 123, 9, 1 },
        { 154, 183, 83, 163, 165, 147, 0 }, },
      { { 200, 99, 86, 204, 12, 4, 1 },
        { 2, 66, 67, 148, 87, 174, 0 },
        { 144, 24, 25, 181, 99, 9, 1 },
        { 58, 245, 20, 225, 33, 32, 0 }, },
      { { 201, 215, 21, 97, 151, 171, 1 },
        { 66, 111, 120, 101, 124, 61, 1 },
        { 234, 244, 195, 84, 117, 201, 1 },
        { 222, 31, 83, 15, 123, 33, 0 }, },
      { { 203, 227, 118, 18, 26, 242, 1 },
        { 150, 74, 139, 36, 158, 253, 1 },
        { 167, 172, 36, 55, 99, 233, 1 },
        { 223, 188, 146, 104, 169, 52, 1 }, },
      { { 204, 23, 188, 202, 55, 164, 1 },
        { 107, 75, 208, 178, 212, 47, 1 },
        { 146, 246, 41, 158, 244, 25, 1 },
        { 250, 21, 166, 133, 233, 107, 0 }, },
      { { 204, 223, 166, 39, 145, 190, 0 },
        { 65, 171, 184, 86, 191, 109, 1 },
        { 62, 196, 242, 50, 253, 153, 1 },
        { 219, 126, 181, 14, 234, 193, 0 }, },
      { { 204, 235, 235, 67, 36, 93, 0 },
        { 45, 134, 195, 87, 254, 104, 0 },
        { 93, 18, 97, 107, 235, 153, 1 },
        { 11, 63, 245, 97, 176, 218, 0 }, },
      { { 209, 53, 155, 82, 5, 119, 0 },
        { 116, 69, 94, 19, 214, 112, 1 },
        { 119, 80, 37, 108, 214, 69, 1 },
        { 135, 53, 228, 61, 81, 23, 0 }, },
      { { 209, 91, 212, 112, 60, 106, 0 },
        { 28, 225, 77, 6, 116, 189, 1 },
        { 43, 30, 7, 21, 237, 69, 1 },
        { 222, 151, 48, 89, 67, 156, 0 }, },
      { { 215, 26, 117, 66, 163, 79, 1 },
        { 143, 197, 253, 49, 176, 60, 0 },
        { 249, 98, 161, 87, 44, 117, 1 },
        { 30, 6, 198, 95, 209, 248, 1 }, },
      { { 215, 230, 123, 63, 234, 215, 1 },
        { 255, 124, 175, 117, 155, 250, 0 },
        { 245, 171, 254, 111, 51, 245, 1 },
        { 47, 236, 215, 122, 159, 127, 1 }, },
      { { 219, 2, 186, 238, 81, 189, 1 },
        { 162, 126, 212, 146, 179, 123, 1 },
        { 222, 197, 59, 174, 160, 109, 1 },
        { 239, 102, 164, 149, 191, 34, 1 }, },
      { { 216, 126, 223, 70, 165, 187, 1 },
        { 106, 207, 127, 7, 243, 108, 1 },
        { 238, 210, 177, 125, 191, 13, 1 },
        { 155, 103, 240, 127, 121, 171, 0 }, },
      { { 216, 131, 133, 71, 132, 38, 1 },
        { 2, 2, 108, 83, 221, 44, 1 },
        { 178, 16, 241, 80, 224, 141, 1 },
        { 154, 93, 229, 27, 32, 32, 0 }, },
      { { 218, 189, 22, 192, 207, 231, 0 },
        { 196, 223, 126, 176, 94, 164, 1 },
        { 115, 249, 129, 180, 94, 173, 1 },
        { 146, 189, 6, 191, 125, 145, 1 }, },
      { { 219, 226, 77, 128, 236, 124, 1 },
        { 174, 18, 39, 149, 120, 252, 1 },
        { 159, 27, 128, 217, 35, 237, 1 },
        { 159, 143, 84, 242, 36, 58, 1 }, },
      { { 217, 244, 154, 237, 44, 69, 0 },
        { 108, 103, 70, 214, 91, 178, 0 },
        { 81, 26, 91, 172, 151, 205, 1 },
        { 38, 237, 53, 177, 115, 27, 0 }, },
      { { 222, 24, 187, 178, 78, 206, 1 },
        { 183, 251, 140, 179, 242, 160, 0 },
        { 185, 185, 38, 238, 140, 61, 1 },
        { 2, 167, 230, 152, 239, 246, 1 }, },
      { { 221, 25, 226, 31, 178, 162, 1 },
        { 27, 139, 173, 98, 151, 51, 1 },
        { 162, 166, 252, 35, 204, 93, 1 },
        { 230, 116, 163, 90, 232, 236, 0 }, },
      { { 222, 44, 65, 181, 149, 43, 0 },
        { 209, 166, 63, 193, 113, 33, 1 },
        { 106, 84, 214, 193, 26, 61, 1 },
        { 194, 71, 65, 254, 50, 197, 1 }, },
      { { 220, 75, 143, 150, 13, 97, 0 },
        { 53, 134, 20, 135, 215, 172, 1 },
        { 67, 88, 52, 248, 233, 29, 1 },
        { 154, 245, 240, 148, 48, 214, 0 }, },
      { { 221, 148, 173, 142, 18, 115, 1 },
        { 103, 7, 140, 163, 153, 119, 1 },
        { 231, 36, 56, 218, 148, 221, 1 },
        { 247, 76, 226, 152, 240, 115, 0 }, },
      { { 221, 209, 152, 178, 105, 248, 1 },
        { 63, 123, 20, 134, 188, 240, 1 },
        { 143, 203, 38, 140, 197, 221, 1 },
        { 135, 158, 176, 148, 111, 126, 0 }, },
      { { 225, 16, 129, 210, 125, 199, 0 },
        { 28, 29, 88, 155, 208, 177, 0 },
        { 113, 223, 37, 192, 132, 67, 1 },
        { 70, 133, 236, 141, 92, 28, 0 }, },
      { { 226, 29, 244, 60, 230, 69, 1 },
        { 222, 245, 161, 58, 85, 38, 0 },
        { 209, 51, 158, 23, 220, 35, 1 },
        { 50, 85, 46, 66, 215, 189, 1 }, },
      { { 227, 42, 142, 26, 117, 17, 0 },
        { 184, 148, 18, 10, 210, 127, 0 },
        { 68, 87, 44, 56, 170, 99, 1 },
        { 127, 37, 168, 36, 20, 142, 1 }, },
      { { 230, 127, 34, 189, 228, 63, 1 },
        { 219, 181, 170, 220, 119, 106, 1 },
        { 254, 19, 222, 162, 127, 51, 1 },
        { 171, 119, 29, 170, 214, 237, 1 }, },
      { { 230, 201, 244, 50, 47, 175, 1 },
        { 155, 236, 153, 62, 252, 164, 1 },
        { 250, 250, 38, 23, 201, 179, 1 },
        { 146, 159, 190, 76, 155, 236, 1 }, },
      { { 233, 65, 95, 6, 96, 115, 0 },
        { 44, 86, 9, 13, 151, 116, 1 },
        { 103, 3, 48, 125, 65, 75, 1 },
        { 151, 116, 216, 72, 53, 26, 0 }, },
      { { 232, 162, 221, 84, 147, 113, 0 },
        { 52, 70, 115, 43, 25, 109, 1 },
        { 71, 100, 149, 93, 162, 139, 1 },
        { 219, 76, 106, 103, 49, 22, 0 }, },
      { { 232, 216, 146, 243, 185, 171, 1 },
        { 26, 239, 120, 206, 186, 161, 1 },
        { 234, 206, 231, 164, 141, 139, 1 },
        { 194, 174, 185, 143, 123, 172, 0 }, },
      { { 234, 224, 242, 13, 25, 46, 0 },
        { 128, 66, 155, 94, 59, 163, 1 },
        { 58, 76, 88, 39, 131, 171, 1 },
        { 226, 238, 61, 108, 161, 0, 1 }, },
      { { 237, 183, 135, 120, 221, 244, 0 },
        { 85, 59, 114, 27, 94, 255, 1 },
        { 23, 221, 143, 112, 246, 219, 1 },
        { 255, 189, 108, 39, 110, 85, 0 }, },
      { { 237, 243, 41, 3, 202, 39, 1 },
        { 35, 23, 170, 125, 156, 184, 1 },
        { 242, 41, 224, 74, 103, 219, 1 },
        { 142, 156, 223, 42, 244, 98, 0 }, },
      { { 242, 9, 23, 170, 178, 81, 0 },
        { 140, 228, 36, 169, 150, 103, 0 },
        { 69, 38, 170, 244, 72, 39, 1 },
        { 115, 52, 202, 146, 19, 152, 1 }, },
      { { 242, 87, 191, 49, 98, 230, 1 },
        { 254, 121, 140, 127, 22, 44, 1 },
        { 179, 163, 70, 126, 245, 39, 1 },
        { 154, 52, 127, 24, 207, 63, 1 }, },
      { { 240, 161, 59, 114, 216, 194, 0 },
        { 52, 120, 238, 9, 158, 161, 0 },
        { 33, 141, 167, 110, 66, 135, 1 },
        { 66, 188, 200, 59, 143, 22, 0 }, },
      { { 242, 204, 10, 145, 3, 251, 0 },
        { 244, 140, 28, 236, 58, 96, 1 },
        { 111, 224, 68, 168, 25, 167, 1 },
        { 131, 46, 27, 156, 24, 151, 1 }, },
      { { 240, 197, 80, 127, 169, 160, 1 },
        { 90, 104, 117, 76, 157, 162, 1 },
        { 130, 202, 255, 5, 81, 135, 1 },
        { 162, 220, 153, 87, 11, 45, 0 }, },
      { { 241, 197, 159, 71, 93, 153, 1 },
        { 98, 92, 84, 79, 255, 245, 0 },
        { 204, 221, 113, 124, 209, 199, 1 },
        { 87, 255, 249, 21, 29, 35, 0 }, },
      { { 240, 244, 101, 147, 182, 176, 1 },
        { 90, 9, 167, 237, 216, 101, 1 },
        { 134, 182, 228, 211, 23, 135, 1 },
        { 211, 13, 219, 242, 200, 45, 0 }, },
      { { 244, 0, 37, 19, 37, 72, 0 },
        { 29, 0, 148, 73, 240, 36, 0 },
        { 9, 82, 100, 82, 0, 23, 1 },
        { 18, 7, 201, 20, 128, 92, 0 }, },
      { { 244, 111, 108, 190, 223, 216, 1 },
        { 119, 184, 183, 172, 245, 239, 0 },
        { 141, 253, 190, 155, 123, 23, 1 },
        { 123, 215, 154, 246, 142, 247, 0 }, },
      { { 247, 104, 114, 223, 78, 225, 0 },
        { 149, 220, 199, 236, 211, 178, 1 },
        { 67, 185, 125, 167, 11, 119, 1 },
        { 166, 229, 155, 241, 157, 212, 1 }, },
      { { 251, 140, 211, 46, 207, 23, 0 },
        { 192, 246, 61, 59, 219, 242, 0 },
        { 116, 121, 186, 101, 152, 239, 1 },
        { 39, 237, 238, 94, 55, 129, 1 }, },
      { { 249, 145, 73, 232, 47, 176, 0 },
        { 40, 43, 85, 169, 92, 242, 1 },
        { 6, 250, 11, 201, 68, 207, 1 },
        { 167, 157, 74, 213, 106, 10, 0 }, },
      { { 251, 204, 144, 194, 16, 228, 0 },
        { 196, 202, 68, 158, 152, 49, 1 },
        { 19, 132, 33, 132, 153, 239, 1 },
        { 198, 12, 188, 145, 41, 145, 1 }, },
      { { 248, 252, 106, 92, 170, 113, 1 },
        { 126, 135, 231, 44, 27, 226, 1 },
        { 199, 42, 157, 43, 31, 143, 1 },
        { 163, 236, 26, 115, 240, 191, 0 }, },
      { { 254, 15, 171, 22, 40, 191, 1 },
        { 251, 142, 140, 27, 183, 232, 1 },
        { 254, 138, 52, 106, 248, 63, 1 },
        { 139, 246, 236, 24, 184, 239, 1 }, },
      { { 252, 66, 14, 134, 208, 220, 0 },
        { 37, 26, 36, 156, 179, 109, 0 },
        { 29, 133, 176, 184, 33, 31, 1 },
        { 91, 102, 156, 146, 44, 82, 0 }, },
      { { 252, 124, 113, 120, 44, 31, 0 },
        { 89, 231, 207, 29, 112, 226, 0 },
        { 124, 26, 15, 71, 31, 31, 1 },
        { 35, 135, 92, 121, 243, 205, 0 }, },
      { { 255, 159, 183, 150, 227, 134, 1 },
        { 219, 219, 188, 187, 159, 60, 0 },
        { 176, 227, 180, 246, 252, 255, 1 },
        { 30, 124, 238, 158, 237, 237, 1 }, },
      { { 112, 127, 0, 71, 111, 110, 0 },
        { 76, 145, 94, 124, 245, 136, 1 },
        { 59, 123, 113, 0, 127, 7, 0 },
        { 136, 215, 159, 61, 68, 153, 0 }, },
      { { 131, 238, 196, 68, 55, 228, 0 },
        { 204, 136, 83, 54, 73, 61, 1 },
        { 19, 246, 17, 17, 187, 224, 1 },
        { 222, 73, 54, 101, 8, 153, 1 }, },
      { { 1, 32, 180, 5, 180, 95, 1 },
        { 14, 68, 170, 82, 97, 85, 0 },
        { 253, 22, 208, 22, 130, 64, 0 },
        { 85, 67, 37, 42, 145, 56, 0 }, },
      { { 0, 59, 124, 20, 69, 167, 0 },
        { 48, 221, 155, 16, 69, 12, 1 },
        { 114, 209, 20, 31, 110, 0, 0 },
        { 152, 81, 4, 108, 221, 134, 0 }, },
      { { 3, 79, 186, 190, 163, 12, 0 },
        { 248, 224, 176, 182, 167, 26, 0 },
        { 24, 98, 190, 174, 249, 96, 0 },
        { 44, 114, 182, 134, 131, 143, 1 }, },
      { { 1, 86, 37, 1, 21, 142, 0 },
        { 64, 9, 152, 85, 96, 29, 0 },
        { 56, 212, 64, 82, 53, 64, 0 },
        { 92, 3, 85, 12, 200, 1, 0 }, },
      { { 1, 143, 230, 168, 33, 42, 0 },
        { 72, 160, 153, 130, 46, 30, 1 },
        { 42, 66, 10, 179, 248, 192, 0 },
        { 188, 58, 32, 204, 130, 137, 0 }, },
      { { 0, 175, 103, 1, 210, 134, 0 },
        { 64, 152, 171, 113, 14, 13, 0 },
        { 48, 165, 192, 115, 122, 128, 0 },
        { 88, 56, 71, 106, 140, 129, 0 }, },
      { { 0, 217, 16, 247, 55, 249, 0 },
        { 28, 237, 80, 228, 237, 65, 1 },
        { 79, 246, 119, 132, 77, 128, 0 },
        { 193, 91, 147, 133, 91, 156, 0 }, },
      { { 3, 240, 9, 255, 186, 56, 0 },
        { 184, 33, 98, 229, 169, 211, 1 },
        { 14, 46, 255, 200, 7, 224, 0 },
        { 229, 202, 211, 163, 66, 14, 1 }, },
      { { 5, 92, 205, 107, 57, 177, 1 },
        { 107, 173, 81, 71, 128, 215, 1 },
        { 198, 206, 107, 89, 157, 80, 0 },
        { 245, 128, 241, 69, 90, 235, 0 }, },
      { { 6, 109, 146, 36, 128, 158, 1 },
        { 195, 232, 42, 22, 39, 64, 0 },
        { 188, 128, 146, 36, 219, 48, 0 },
        { 1, 114, 52, 42, 11, 225, 1 }, },
      { { 4, 166, 38, 247, 185, 66, 1 },
        { 95, 32, 250, 192, 139, 141, 0 },
        { 161, 78, 247, 178, 50, 144, 0 },
        { 88, 232, 129, 175, 130, 125, 0 }, },
      { { 4, 196, 160, 187, 5, 176, 0 },
        { 81, 40, 144, 198, 200, 66, 1 },
        { 6, 208, 110, 130, 145, 144, 0 },
        { 161, 9, 177, 132, 138, 69, 0 }, },
      { { 9, 4, 240, 102, 157, 166, 0 },
        { 64, 106, 249, 18, 193, 145, 1 },
        { 50, 220, 179, 7, 144, 72, 0 },
        { 196, 193, 164, 79, 171, 1, 0 }, },
      { { 8, 63, 162, 23, 251, 204, 1 },
        { 94, 155, 178, 114, 167, 137, 0 },
        { 153, 239, 244, 34, 254, 8, 0 },
        { 72, 242, 167, 38, 236, 189, 0 }, },
      { { 10, 107, 164, 59, 63, 71, 1 },
        { 158, 166, 154, 118, 196, 143, 0 },
        { 241, 126, 110, 18, 235, 40, 0 },
        { 120, 145, 183, 44, 178, 188, 1 }, },
      { { 9, 147, 68, 160, 208, 252, 0 },
        { 4, 59, 33, 144, 44, 93, 1 },
        { 31, 133, 130, 145, 100, 200, 0 },
        { 221, 26, 4, 194, 110, 16, 0 }, },
      { { 8, 210, 94, 4, 114, 98, 1 },
        { 46, 83, 9, 36, 11, 13, 1 },
        { 163, 39, 16, 61, 37, 136, 0 },
        { 216, 104, 18, 72, 101, 58, 0 }, },
      { { 14, 39, 43, 135, 201, 75, 1 },
        { 231, 22, 186, 193, 167, 136, 0 },
        { 233, 73, 240, 234, 114, 56, 0 },
        { 8, 242, 193, 174, 180, 115, 1 }, },
      { { 15, 42, 254, 150, 218, 227, 0 },
        { 181, 222, 171, 162, 131, 157, 1 },
        { 99, 173, 180, 191, 170, 120, 0 },
        { 220, 224, 162, 234, 189, 214, 1 }, },
      { { 13, 94, 114, 56, 152, 3, 0 },
        { 81, 231, 169, 4, 2, 155, 0 },
        { 96, 12, 142, 39, 61, 88, 0 },
        { 108, 160, 16, 74, 243, 197, 0 }, },
      { { 14, 87, 112, 167, 99, 99, 1 },
        { 207, 119, 153, 228, 133, 8, 1 },
        { 227, 99, 114, 135, 117, 56, 0 },
        { 136, 80, 147, 204, 247, 121, 1 }, },
      { { 13, 106, 169, 220, 27, 63, 0 },
        { 49, 134, 218, 183, 33, 219, 1 },
        { 126, 108, 29, 202, 171, 88, 0 },
        { 237, 194, 118, 173, 176, 198, 0 }, },
      { { 13, 118, 154, 128, 113, 208, 1 },
        { 111, 91, 18, 134, 2, 89, 0 },
        { 133, 199, 0, 172, 183, 88, 0 },
        { 77, 32, 48, 164, 109, 123, 0 }, },
      { { 14, 124, 197, 35, 226, 204, 1 },
        { 207, 187, 35, 119, 160, 4, 0 },
        { 153, 163, 226, 81, 159, 56, 0 },
        { 16, 2, 247, 98, 110, 249, 1 }, },
      { { 15, 139, 106, 20, 246, 21, 0 },
        { 185, 150, 161, 48, 79, 89, 0 },
        { 84, 55, 148, 43, 104, 248, 0 },
        { 77, 121, 6, 66, 180, 206, 1 }, },
      { { 13, 171, 134, 215, 206, 17, 1 },
        { 19, 150, 98, 226, 207, 220, 0 },
        { 196, 57, 245, 176, 234, 216, 0 },
        { 29, 249, 163, 163, 52, 228, 0 }, },
      { { 15, 203, 199, 97, 60, 150, 1 },
        { 139, 170, 73, 87, 78, 221, 0 },
        { 180, 158, 67, 113, 233, 248, 0 },
        { 93, 185, 117, 73, 42, 232, 1 }, },
      { { 14, 236, 63, 51, 174, 17, 1 },
        { 251, 230, 162, 101, 202, 196, 0 },
        { 196, 58, 230, 126, 27, 184, 0 },
        { 17, 169, 211, 34, 179, 239, 1 }, },
      { { 17, 15, 152, 165, 71, 82, 0 },
        { 100, 240, 28, 226, 69, 88, 0 },
        { 37, 113, 82, 140, 248, 68, 0 },
        { 13, 81, 35, 156, 7, 147, 0 }, },
      { { 17, 119, 210, 131, 226, 153, 0 },
        { 72, 93, 39, 230, 166, 88, 0 },
        { 76, 163, 224, 165, 247, 68, 0 },
        { 13, 50, 179, 242, 93, 9, 0 }, },
      { { 17, 151, 181, 190, 81, 161, 0 },
        { 80, 125, 148, 131, 141, 31, 1 },
        { 66, 197, 62, 214, 244, 196, 0 },
        { 252, 88, 224, 148, 223, 5, 0 }, },
      { { 18, 155, 152, 58, 105, 111, 1 },
        { 190, 245, 28, 18, 172, 138, 1 },
        { 251, 75, 46, 12, 236, 164, 0 },
        { 168, 154, 164, 28, 87, 190, 1 }, },
      { { 19, 233, 65, 189, 245, 218, 0 },
        { 156, 184, 63, 197, 109, 83, 0 },
        { 45, 215, 222, 193, 75, 228, 0 },
        { 101, 91, 81, 254, 14, 156, 1 }, },
      { { 22, 13, 83, 212, 169, 87, 0 },
        { 221, 196, 125, 145, 7, 192, 0 },
        { 117, 74, 149, 229, 88, 52, 0 },
        { 1, 240, 68, 223, 17, 221, 1 }, },
      { { 22, 61, 21, 111, 231, 73, 0 },
        { 205, 245, 118, 97, 229, 6, 0 },
        { 73, 115, 251, 84, 94, 52, 0 },
        { 48, 83, 195, 55, 87, 217, 1 }, },
      { { 20, 130, 100, 0, 95, 151, 1 },
        { 3, 28, 157, 48, 72, 205, 0 },
        { 244, 253, 0, 19, 32, 148, 0 },
        { 89, 137, 6, 92, 156, 96, 0 }, },
      { { 21, 130, 161, 143, 42, 56, 1 },
        { 11, 0, 132, 227, 169, 218, 1 },
        { 142, 42, 120, 194, 160, 212, 0 },
        { 173, 202, 227, 144, 128, 104, 0 }, },
      { { 21, 153, 34, 53, 74, 250, 0 },
        { 21, 185, 140, 96, 47, 208, 1 },
        { 47, 169, 86, 34, 76, 212, 0 },
        { 133, 250, 3, 24, 206, 212, 0 }, },
      { { 23, 156, 89, 25, 214, 46, 0 },
        { 241, 209, 45, 113, 104, 19, 1 },
        { 58, 53, 204, 77, 28, 244, 0 },
        { 228, 11, 71, 90, 69, 199, 1 }, },
      { { 21, 165, 87, 175, 25, 244, 1 },
        { 71, 104, 23, 209, 143, 215, 1 },
        { 151, 204, 122, 245, 82, 212, 0 },
        { 245, 248, 197, 244, 11, 113, 0 }, },
      { { 22, 185, 129, 147, 151, 243, 0 },
        { 149, 141, 62, 227, 204, 65, 1 },
        { 103, 244, 228, 192, 206, 180, 0 },
        { 193, 25, 227, 190, 88, 212, 1 }, },
      { { 20, 212, 174, 31, 83, 198, 0 },
        { 117, 25, 156, 118, 139, 7, 0 },
        { 49, 229, 124, 58, 149, 148, 0 },
        { 112, 104, 183, 28, 204, 87, 0 }, },
      { { 22, 222, 188, 166, 177, 46, 1 },
        { 235, 225, 188, 150, 169, 13, 1 },
        { 186, 70, 178, 158, 189, 180, 0 },
        { 216, 74, 180, 158, 195, 235, 1 }, },
      { { 21, 215, 231, 50, 136, 117, 0 },
        { 85, 37, 165, 23, 142, 220, 1 },
        { 87, 8, 166, 115, 245, 212, 0 },
        { 157, 184, 244, 82, 210, 85, 0 }, },
      { { 27, 5, 137, 184, 14, 199, 1 },
        { 246, 46, 12, 179, 68, 146, 0 },
        { 241, 184, 14, 200, 208, 108, 0 },
        { 36, 145, 102, 152, 58, 55, 1 }, },
      { { 24, 76, 13, 17, 16, 216, 1 },
        { 118, 138, 4, 69, 32, 69, 0 },
        { 141, 132, 68, 88, 25, 12, 0 },
        { 81, 2, 81, 16, 40, 183, 0 }, },
      { { 27, 80, 19, 3, 222, 147, 1 },
        { 130, 95, 44, 101, 194, 209, 0 },
        { 228, 189, 224, 100, 5, 108, 0 },
        { 69, 161, 211, 26, 125, 32, 1 }, },
      { { 26, 117, 67, 117, 230, 58, 0 },
        { 216, 51, 111, 101, 103, 64, 1 },
        { 46, 51, 215, 97, 87, 44, 0 },
        { 129, 115, 83, 123, 102, 13, 1 }, },
      { { 25, 139, 44, 109, 101, 206, 0 },
        { 44, 186, 220, 80, 109, 30, 0 },
        { 57, 211, 91, 26, 104, 204, 0 },
        { 60, 91, 5, 29, 174, 154, 0 }, },
      { { 24, 157, 237, 154, 191, 3, 0 },
        { 120, 135, 189, 163, 204, 135, 0 },
        { 96, 126, 172, 219, 220, 140, 0 },
        { 112, 153, 226, 222, 240, 143, 0 }, },
      { { 26, 163, 189, 21, 22, 74, 1 },
        { 182, 66, 142, 99, 109, 13, 0 },
        { 169, 52, 84, 94, 226, 172, 0 },
        { 88, 91, 99, 56, 161, 54, 1 }, },
      { { 24, 191, 221, 217, 136, 80, 1 },
        { 118, 195, 103, 195, 12, 206, 0 },
        { 133, 8, 205, 221, 254, 140, 0 },
        { 57, 152, 97, 243, 97, 183, 0 }, },
      { { 26, 187, 197, 128, 248, 166, 1 },
        { 138, 155, 47, 147, 12, 141, 1 },
        { 178, 143, 128, 209, 238, 172, 0 },
        { 216, 152, 100, 250, 108, 168, 1 }, },
      { { 24, 202, 200, 115, 174, 12, 1 },
        { 58, 162, 101, 118, 232, 136, 0 },
        { 152, 58, 231, 9, 169, 140, 0 },
        { 8, 139, 183, 83, 34, 174, 0 }, },
      { { 26, 251, 85, 224, 195, 153, 1 },
        { 130, 255, 119, 165, 44, 76, 0 },
        { 204, 225, 131, 213, 111, 172, 0 },
        { 25, 26, 82, 247, 127, 160, 1 }, },
      { { 25, 252, 172, 250, 123, 235, 0 },
        { 124, 191, 222, 166, 168, 151, 1 },
        { 107, 239, 47, 154, 159, 204, 0 },
        { 244, 138, 178, 189, 254, 159, 0 }, },
      { { 31, 33, 77, 51, 43, 129, 0 },
        { 185, 46, 23, 97, 132, 148, 0 },
        { 64, 234, 102, 89, 66, 124, 0 },
        { 20, 144, 195, 116, 58, 78, 1 }, },
      { { 29, 104, 97, 97, 80, 45, 1 },
        { 3, 182, 199, 85, 32, 17, 1 },
        { 218, 5, 67, 67, 11, 92, 0 },
        { 196, 2, 85, 113, 182, 224, 0 }, },
      { { 29, 113, 17, 105, 159, 205, 1 },
        { 7, 111, 118, 117, 100, 147, 0 },
        { 217, 252, 203, 68, 71, 92, 0 },
        { 100, 147, 87, 55, 123, 112, 0 }, },
      { { 28, 115, 52, 93, 58, 61, 1 },
        { 27, 71, 198, 116, 37, 207, 1 },
        { 222, 46, 93, 22, 103, 28, 0 },
        { 249, 210, 23, 49, 241, 108, 0 }, },
      { { 30, 167, 7, 22, 61, 22, 1 },
        { 219, 2, 30, 17, 207, 205, 0 },
        { 180, 94, 52, 112, 114, 188, 0 },
        { 89, 249, 196, 60, 32, 109, 1 }, },
      { { 32, 22, 241, 69, 239, 16, 1 },
        { 74, 81, 241, 107, 65, 200, 0 },
        { 132, 123, 209, 71, 180, 2, 0 },
        { 9, 193, 107, 71, 197, 41, 0 }, },
      { { 33, 37, 79, 144, 49, 77, 0 },
        { 124, 4, 19, 153, 38, 21, 0 },
        { 89, 70, 4, 249, 82, 66, 0 },
        { 84, 50, 76, 228, 16, 31, 0 }, },
      { { 35, 45, 115, 235, 220, 62, 1 },
        { 194, 240, 235, 217, 230, 211, 1 },
        { 190, 29, 235, 231, 90, 98, 0 },
        { 229, 179, 205, 235, 135, 161, 1 }, },
      { { 35, 72, 62, 43, 100, 184, 1 },
        { 170, 248, 128, 76, 226, 86, 1 },
        { 142, 147, 106, 62, 9, 98, 0 },
        { 181, 35, 153, 0, 143, 170, 1 }, },
      { { 35, 86, 58, 73, 248, 94, 1 },
        { 238, 81, 232, 92, 34, 219, 0 },
        { 189, 15, 201, 46, 53, 98, 0 },
        { 109, 162, 29, 11, 197, 59, 1 }, },
      { { 34, 138, 184, 17, 107, 194, 0 },
        { 188, 216, 152, 106, 8, 136, 0 },
        { 33, 235, 68, 14, 168, 162, 0 },
        { 8, 136, 43, 12, 141, 158, 1 }, },
      { { 32, 167, 72, 150, 66, 82, 1 },
        { 118, 16, 11, 168, 141, 72, 0 },
        { 165, 33, 52, 137, 114, 130, 0 },
        { 9, 88, 138, 232, 4, 55, 0 }, },
      { { 34, 164, 248, 245, 231, 39, 1 },
        { 250, 116, 251, 250, 73, 0, 1 },
        { 242, 115, 215, 143, 146, 162, 0 },
        { 128, 73, 47, 239, 151, 47, 1 }, },
      { { 33, 239, 227, 53, 220, 27, 1 },
        { 82, 180, 171, 79, 111, 217, 0 },
        { 236, 29, 214, 99, 251, 194, 0 },
        { 77, 251, 121, 106, 150, 165, 0 }, },
      { { 33, 255, 170, 148, 240, 254, 0 },
        { 124, 153, 170, 158, 47, 89, 1 },
        { 63, 135, 148, 170, 255, 194, 0 },
        { 205, 122, 60, 170, 204, 159, 0 }, },
      { { 37, 48, 68, 183, 73, 106, 0 },
        { 21, 49, 27, 200, 161, 148, 1 },
        { 43, 73, 118, 145, 6, 82, 0 },
        { 148, 194, 137, 236, 70, 84, 0 }, },
      { { 38, 55, 142, 202, 57, 200, 0 },
        { 237, 9, 82, 138, 166, 143, 0 },
        { 9, 206, 41, 184, 246, 50, 0 },
        { 120, 178, 168, 165, 72, 91, 1 }, },
      { { 39, 67, 65, 27, 226, 165, 0 },
        { 153, 28, 33, 125, 132, 26, 1 },
        { 82, 163, 236, 65, 97, 114, 0 },
        { 172, 16, 223, 66, 28, 76, 1 }, },
      { { 39, 119, 180, 37, 12, 229, 0 },
        { 197, 109, 130, 94, 69, 156, 1 },
        { 83, 152, 82, 22, 247, 114, 0 },
        { 156, 209, 61, 32, 219, 81, 1 }, },
      { { 36, 140, 97, 44, 211, 5, 0 },
        { 65, 180, 177, 57, 9, 3, 0 },
        { 80, 101, 154, 67, 24, 146, 0 },
        { 96, 72, 78, 70, 150, 193, 0 }, },
      { { 39, 181, 134, 58, 242, 110, 1 },
        { 223, 49, 42, 58, 174, 23, 1 },
        { 187, 39, 174, 48, 214, 242, 0 },
        { 244, 58, 174, 42, 70, 125, 1 }, },
      { { 37, 192, 47, 169, 170, 233, 1 },
        { 47, 44, 160, 237, 42, 150, 1 },
        { 203, 170, 202, 250, 1, 210, 0 },
        { 180, 170, 91, 130, 154, 122, 0 }, },
      { { 37, 193, 244, 243, 24, 172, 1 },
        { 19, 104, 193, 222, 172, 149, 1 },
        { 154, 140, 103, 151, 193, 210, 0 },
        { 212, 154, 189, 193, 139, 100, 0 }, },
      { { 38, 223, 180, 89, 168, 216, 1 },
        { 223, 201, 224, 78, 44, 206, 0 },
        { 141, 138, 205, 22, 253, 178, 0 },
        { 57, 154, 57, 3, 201, 253, 1 }, },
      { { 36, 229, 181, 254, 134, 140, 0 },
        { 81, 104, 226, 191, 237, 6, 0 },
        { 24, 176, 191, 214, 211, 146, 0 },
        { 48, 91, 254, 163, 139, 69, 0 }, },
      { { 36, 250, 147, 106, 49, 84, 1 },
        { 15, 225, 82, 31, 138, 75, 0 },
        { 149, 70, 43, 100, 175, 146, 0 },
        { 105, 40, 252, 37, 67, 248, 0 }, },
      { { 41, 33, 120, 64, 98, 223, 1 },
        { 46, 94, 203, 56, 36, 80, 0 },
        { 253, 163, 1, 15, 66, 74, 0 },
        { 5, 18, 14, 105, 189, 58, 0 }, },
      { { 42, 47, 218, 50, 70, 201, 1 },
        { 246, 254, 3, 42, 230, 8, 0 },
        { 201, 177, 38, 45, 250, 42, 0 },
        { 8, 51, 170, 96, 63, 183, 1 }, },
      { { 40, 62, 63, 42, 103, 4, 0 },
        { 104, 243, 146, 57, 194, 14, 0 },
        { 16, 115, 42, 126, 62, 10, 0 },
        { 56, 33, 206, 36, 231, 139, 0 }, },
      { { 43, 205, 185, 118, 1, 186, 0 },
        { 240, 234, 216, 15, 173, 80, 1 },
        { 46, 192, 55, 78, 217, 234, 0 },
        { 133, 90, 248, 13, 171, 135, 1 }, },
      { { 40, 234, 218, 205, 222, 126, 1 },
        { 38, 210, 107, 254, 107, 203, 1 },
        { 191, 61, 217, 173, 171, 138, 0 },
        { 233, 235, 63, 235, 37, 178, 0 }, },
      { { 44, 77, 140, 242, 231, 58, 1 },
        { 123, 178, 120, 174, 228, 68, 1 },
        { 174, 115, 167, 152, 217, 26, 0 },
        { 145, 19, 186, 143, 38, 239, 0 }, },
      { { 46, 88, 0, 228, 62, 206, 0 },
        { 141, 171, 72, 188, 97, 129, 0 },
        { 57, 190, 19, 128, 13, 58, 0 },
        { 64, 195, 30, 137, 106, 216, 1 }, },
      { { 45, 129, 187, 116, 79, 227, 1 },
        { 55, 126, 216, 43, 79, 144, 1 },
        { 227, 249, 23, 110, 192, 218, 0 },
        { 132, 249, 106, 13, 191, 118, 0 }, },
      { { 44, 145, 67, 129, 237, 29, 0 },
        { 9, 23, 49, 217, 110, 192, 0 },
        { 92, 91, 192, 225, 68, 154, 0 },
        { 1, 187, 77, 198, 116, 72, 0 }, },
      { { 45, 180, 8, 215, 116, 177, 1 },
        { 123, 31, 66, 200, 201, 81, 1 },
        { 198, 151, 117, 136, 22, 218, 0 },
        { 197, 73, 137, 161, 124, 111, 0 }, },
      { { 44, 224, 23, 61, 89, 3, 1 },
        { 19, 118, 26, 77, 11, 135, 0 },
        { 224, 77, 94, 116, 3, 154, 0 },
        { 112, 232, 89, 44, 55, 100, 0 }, },
      { { 48, 9, 23, 86, 236, 208, 1 },
        { 30, 216, 100, 9, 199, 196, 0 },
        { 133, 155, 181, 116, 72, 6, 0 },
        { 17, 241, 200, 19, 13, 188, 0 }, },
      { { 51, 70, 13, 15, 126, 150, 0 },
        { 232, 24, 12, 125, 193, 223, 0 },
        { 52, 191, 120, 88, 49, 102, 0 },
        { 125, 193, 223, 24, 12, 11, 1 }, },
      { { 50, 113, 60, 116, 164, 89, 0 },
        { 188, 101, 230, 12, 101, 68, 0 },
        { 77, 18, 151, 30, 71, 38, 0 },
        { 17, 83, 24, 51, 211, 30, 1 }, },
      { { 48, 167, 239, 179, 52, 231, 1 },
        { 126, 44, 143, 219, 206, 13, 1 },
        { 243, 150, 102, 251, 242, 134, 0 },
        { 216, 57, 237, 248, 154, 63, 0 }, },
      { { 48, 183, 244, 73, 95, 202, 0 },
        { 68, 89, 223, 106, 108, 143, 0 },
        { 41, 253, 73, 23, 246, 134, 0 },
        { 120, 155, 43, 125, 205, 17, 0 }, },
      { { 51, 236, 16, 56, 154, 82, 0 },
        { 212, 224, 46, 44, 8, 211, 0 },
        { 37, 44, 142, 4, 27, 230, 0 },
        { 101, 136, 26, 58, 3, 149, 1 }, },
      { { 53, 106, 133, 153, 65, 91, 0 },
        { 21, 148, 30, 207, 32, 94, 0 },
        { 109, 65, 76, 208, 171, 86, 0 },
        { 61, 2, 121, 188, 20, 212, 0 }, },
      { { 54, 125, 199, 249, 16, 137, 1 },
        { 211, 173, 71, 207, 38, 7, 0 },
        { 200, 132, 79, 241, 223, 54, 0 },
        { 112, 50, 121, 241, 90, 229, 1 }, },
      { { 53, 145, 236, 15, 52, 5, 1 },
        { 43, 5, 133, 90, 205, 23, 0 },
        { 208, 22, 120, 27, 196, 214, 0 },
        { 116, 89, 173, 80, 208, 106, 0 }, },
      { { 58, 31, 122, 71, 185, 141, 0 },
        { 232, 207, 245, 88, 167, 137, 0 },
        { 88, 206, 241, 47, 124, 46, 0 },
        { 72, 242, 141, 87, 249, 139, 1 }, },
      { { 58, 86, 77, 209, 166, 203, 1 },
        { 254, 15, 109, 237, 96, 12, 0 },
        { 233, 178, 197, 217, 53, 46, 0 },
        { 24, 3, 91, 219, 120, 63, 1 }, },
      { { 57, 105, 99, 159, 57, 176, 1 },
        { 26, 138, 151, 205, 135, 211, 1 },
        { 134, 206, 124, 227, 75, 78, 0 },
        { 229, 240, 217, 244, 168, 172, 0 }, },
      { { 59, 96, 103, 17, 227, 243, 0 },
        { 156, 30, 191, 109, 2, 84, 1 },
        { 103, 227, 196, 115, 3, 110, 0 },
        { 149, 32, 91, 126, 188, 28, 1 }, },
      { { 57, 204, 214, 65, 214, 205, 1 },
        { 70, 222, 101, 126, 106, 21, 0 },
        { 217, 181, 193, 53, 153, 206, 0 },
        { 84, 43, 63, 83, 61, 177, 0 }, },
      { { 60, 51, 21, 240, 128, 231, 0 },
        { 21, 111, 110, 153, 4, 12, 1 },
        { 115, 128, 135, 212, 102, 30, 0 },
        { 152, 16, 76, 187, 123, 84, 0 }, },
      { { 60, 51, 197, 75, 3, 115, 1 },
        { 7, 7, 95, 107, 132, 78, 1 },
        { 231, 96, 105, 81, 230, 30, 0 },
        { 185, 16, 235, 125, 112, 112, 0 }, },
      { { 61, 98, 186, 75, 99, 200, 0 },
        { 45, 90, 214, 110, 162, 26, 0 },
        { 9, 227, 105, 46, 163, 94, 0 },
        { 44, 34, 187, 53, 173, 90, 0 }, },
      { { 61, 117, 9, 162, 109, 95, 1 },
        { 111, 55, 30, 157, 228, 208, 0 },
        { 253, 91, 34, 200, 87, 94, 0 },
        { 5, 147, 220, 188, 118, 123, 0 }, },
      { { 63, 152, 179, 12, 62, 51, 1 },
        { 139, 199, 140, 43, 75, 211, 1 },
        { 230, 62, 24, 102, 140, 254, 0 },
        { 229, 233, 106, 24, 241, 232, 1 }, },
      { { 62, 205, 175, 189, 212, 43, 0 },
        { 241, 182, 172, 207, 111, 7, 1 },
        { 106, 21, 222, 250, 217, 190, 0 },
        { 240, 123, 121, 154, 182, 199, 1 }, },
      { { 63, 213, 180, 83, 119, 231, 1 },
        { 223, 95, 220, 126, 204, 21, 1 },
        { 243, 247, 101, 22, 213, 254, 0 },
        { 212, 25, 191, 29, 253, 125, 1 }, },
      { { 60, 233, 181, 48, 105, 180, 0 },
        { 25, 250, 150, 31, 12, 196, 1 },
        { 22, 203, 6, 86, 203, 158, 0 },
        { 145, 152, 124, 52, 175, 204, 0 }, },
      { { 64, 3, 93, 254, 66, 40, 1 },
        { 50, 112, 65, 161, 181, 14, 1 },
        { 138, 33, 63, 221, 96, 1, 0 },
        { 184, 86, 194, 193, 7, 38, 0 }, },
      { { 67, 106, 171, 8, 205, 110, 1 },
        { 166, 144, 186, 23, 114, 154, 1 },
        { 187, 89, 136, 106, 171, 97, 0 },
        { 172, 167, 116, 46, 132, 178, 1 }, },
      { { 67, 113, 229, 169, 206, 30, 1 },
        { 130, 49, 171, 247, 116, 214, 0 },
        { 188, 57, 202, 211, 199, 97, 0 },
        { 53, 151, 119, 234, 198, 32, 1 }, },
      { { 65, 168, 233, 191, 52, 145, 0 },
        { 56, 172, 131, 195, 217, 83, 0 },
        { 68, 150, 126, 203, 138, 193, 0 },
        { 101, 77, 225, 224, 154, 142, 0 }, },
      { { 65, 202, 197, 166, 227, 19, 0 },
        { 8, 180, 57, 167, 153, 92, 0 },
        { 100, 99, 178, 209, 169, 193, 0 },
        { 29, 76, 242, 206, 22, 136, 0 }, },
      { { 66, 247, 60, 189, 2, 52, 0 },
        { 240, 97, 130, 244, 29, 78, 1 },
        { 22, 32, 94, 158, 119, 161, 0 },
        { 185, 92, 23, 160, 195, 7, 1 }, },
      { { 68, 39, 29, 179, 182, 219, 1 },
        { 127, 108, 42, 225, 244, 77, 0 },
        { 237, 182, 230, 220, 114, 17, 0 },
        { 89, 23, 195, 170, 27, 127, 0 }, },
      { { 68, 76, 27, 64, 24, 97, 1 },
        { 103, 196, 64, 5, 18, 129, 1 },
        { 195, 12, 1, 108, 25, 17, 0 },
        { 192, 164, 80, 1, 17, 243, 0 }, },
      { { 70, 74, 152, 175, 201, 220, 0 },
        { 165, 248, 48, 214, 177, 202, 0 },
        { 29, 201, 250, 140, 169, 49, 0 },
        { 41, 198, 181, 134, 15, 210, 1 }, },
      { { 70, 131, 6, 249, 199, 224, 1 },
        { 151, 56, 112, 224, 94, 14, 1 },
        { 131, 241, 207, 176, 96, 177, 0 },
        { 184, 61, 3, 135, 14, 116, 1 }, },
      { { 68, 140, 202, 221, 114, 250, 1 },
        { 127, 152, 73, 226, 59, 67, 1 },
        { 175, 167, 93, 169, 152, 145, 0 },
        { 225, 110, 35, 201, 12, 255, 0 }, },
      { { 70, 158, 58, 59, 116, 65, 1 },
        { 255, 245, 128, 64, 218, 11, 0 },
        { 193, 23, 110, 46, 60, 177, 0 },
        { 104, 45, 129, 0, 215, 255, 1 }, },
      { { 73, 31, 143, 197, 190, 227, 0 },
        { 108, 143, 104, 227, 87, 157, 1 },
        { 99, 190, 209, 248, 252, 73, 0 },
        { 220, 245, 99, 139, 120, 155, 0 }, },
      { { 73, 75, 34, 203, 253, 35, 1 },
        { 10, 150, 248, 196, 214, 155, 1 },
        { 226, 95, 233, 162, 105, 73, 0 },
        { 236, 181, 145, 143, 180, 168, 0 }, },
      { { 73, 91, 8, 111, 19, 202, 1 },
        { 38, 171, 88, 100, 181, 27, 0 },
        { 169, 228, 123, 8, 109, 73, 0 },
        { 108, 86, 147, 13, 106, 178, 0 }, },
      { { 74, 177, 68, 70, 10, 33, 1 },
        { 130, 7, 67, 32, 157, 132, 1 },
        { 194, 40, 49, 17, 70, 169, 0 },
        { 144, 220, 130, 97, 112, 32, 1 }, },
      { { 75, 195, 24, 213, 28, 201, 0 },
        { 180, 78, 64, 196, 125, 153, 0 },
        { 73, 156, 85, 140, 97, 233, 0 },
        { 76, 223, 17, 129, 57, 22, 1 }, },
      { { 76, 116, 244, 77, 39, 23, 1 },
        { 75, 71, 219, 118, 81, 70, 0 },
        { 244, 114, 89, 23, 151, 25, 0 },
        { 49, 69, 55, 109, 241, 105, 0 }, },
      { { 78, 157, 120, 2, 250, 136, 1 },
        { 235, 219, 161, 32, 188, 129, 0 },
        { 136, 175, 160, 15, 92, 185, 0 },
        { 64, 158, 130, 66, 237, 235, 1 }, },
      { { 79, 168, 131, 36, 88, 72, 0 },
        { 133, 178, 2, 3, 59, 145, 0 },
        { 9, 13, 18, 96, 138, 249, 0 },
        { 68, 238, 96, 32, 38, 208, 1 }, },
      { { 77, 204, 62, 66, 47, 44, 0 },
        { 105, 194, 208, 52, 250, 148, 1 },
        { 26, 122, 33, 62, 25, 217, 0 },
        { 148, 175, 150, 5, 161, 203, 0 }, },
      { { 77, 205, 182, 47, 105, 192, 1 },
        { 79, 250, 144, 70, 159, 150, 0 },
        { 129, 203, 122, 54, 217, 217, 0 },
        { 52, 252, 177, 4, 175, 249, 0 }, },
      { { 76, 252, 81, 246, 35, 2, 0 },
        { 89, 227, 91, 165, 153, 0, 0 },
        { 32, 98, 55, 197, 31, 153, 0 },
        { 0, 76, 210, 237, 99, 205, 0 }, },
      { { 77, 248, 189, 181, 78, 179, 0 },
        { 49, 255, 138, 231, 89, 212, 1 },
        { 102, 185, 86, 222, 143, 217, 0 },
        { 149, 205, 115, 168, 255, 198, 0 }, },
      { { 78, 254, 206, 197, 81, 2, 1 },
        { 227, 147, 91, 198, 27, 13, 0 },
        { 160, 69, 81, 185, 191, 185, 0 },
        { 88, 108, 49, 237, 100, 227, 1 }, },
      { { 83, 45, 244, 148, 190, 11, 1 },
        { 218, 196, 175, 162, 117, 149, 0 },
        { 232, 62, 148, 151, 218, 101, 0 },
        { 84, 215, 34, 250, 145, 173, 1 }, },
      { { 83, 55, 48, 177, 237, 76, 1 },
        { 222, 113, 182, 208, 116, 152, 0 },
        { 153, 91, 198, 134, 118, 101, 0 },
        { 12, 151, 5, 182, 199, 61, 1 }, },
      { { 81, 138, 115, 76, 78, 26, 0 },
        { 0, 208, 205, 33, 123, 218, 0 },
        { 44, 57, 25, 103, 40, 197, 0 },
        { 45, 239, 66, 89, 133, 128, 0 }, },
      { { 81, 173, 41, 83, 250, 51, 0 },
        { 120, 148, 238, 97, 156, 209, 1 },
        { 102, 47, 229, 74, 90, 197, 0 },
        { 197, 156, 195, 59, 148, 143, 0 }, },
      { { 80, 244, 139, 181, 87, 23, 1 },
        { 114, 53, 30, 247, 91, 65, 0 },
        { 244, 117, 86, 232, 151, 133, 0 },
        { 65, 109, 119, 188, 86, 39, 0 }, },
      { { 83, 242, 216, 169, 125, 63, 0 },
        { 168, 117, 31, 214, 120, 219, 1 },
        { 126, 95, 74, 141, 167, 229, 0 },
        { 237, 143, 53, 252, 87, 10, 1 }, },
      { { 87, 46, 51, 92, 65, 229, 1 },
        { 215, 220, 214, 17, 19, 26, 1 },
        { 211, 193, 29, 102, 58, 117, 0 },
        { 172, 100, 68, 53, 157, 245, 1 }, },
      { { 85, 97, 138, 153, 243, 43, 1 },
        { 59, 20, 62, 230, 54, 19, 1 },
        { 234, 103, 204, 168, 195, 85, 0 },
        { 228, 54, 51, 190, 20, 110, 0 }, },
      { { 84, 114, 176, 221, 66, 144, 1 },
        { 19, 89, 198, 230, 17, 74, 0 },
        { 132, 161, 93, 134, 167, 21, 0 },
        { 41, 68, 51, 177, 205, 100, 0 }, },
      { { 87, 120, 188, 172, 178, 210, 1 },
        { 175, 233, 174, 166, 17, 87, 0 },
        { 165, 166, 154, 158, 143, 117, 0 },
        { 117, 68, 50, 186, 203, 250, 1 }, },
      { { 85, 178, 111, 85, 255, 238, 1 },
        { 63, 25, 255, 113, 123, 157, 1 },
        { 187, 255, 213, 123, 38, 213, 0 },
        { 220, 239, 71, 127, 204, 126, 0 }, },
      { { 87, 215, 193, 128, 15, 12, 1 },
        { 195, 1, 21, 183, 124, 152, 0 },
        { 152, 120, 0, 193, 245, 245, 0 },
        { 12, 159, 118, 212, 64, 97, 1 }, },
      { { 85, 243, 37, 159, 247, 53, 0 },
        { 25, 21, 182, 245, 221, 95, 1 },
        { 86, 119, 252, 210, 103, 213, 0 },
        { 253, 93, 215, 182, 212, 76, 0 }, },
      { { 90, 0, 169, 237, 210, 158, 0 },
        { 160, 58, 236, 243, 49, 67, 0 },
        { 60, 165, 219, 202, 128, 45, 0 },
        { 97, 70, 103, 155, 174, 2, 1 }, },
      { { 89, 39, 61, 104, 89, 78, 1 },
        { 102, 114, 222, 17, 52, 159, 0 },
        { 185, 77, 11, 94, 114, 77, 0 },
        { 124, 150, 68, 61, 167, 51, 0 }, },
      { { 89, 73, 179, 211, 30, 79, 0 },
        { 20, 198, 204, 247, 246, 145, 0 },
        { 121, 60, 101, 230, 201, 77, 0 },
        { 68, 183, 247, 153, 177, 148, 0 }, },
      { { 91, 92, 30, 37, 185, 241, 1 },
        { 238, 239, 52, 68, 19, 213, 1 },
        { 199, 206, 210, 60, 29, 109, 0 },
        { 213, 228, 17, 22, 123, 187, 1 }, },
      { { 89, 81, 133, 145, 139, 249, 0 },
        { 20, 15, 52, 231, 52, 212, 1 },
        { 79, 232, 196, 208, 197, 77, 0 },
        { 149, 150, 115, 150, 120, 20, 0 }, },
      { { 91, 156, 92, 115, 202, 248, 1 },
        { 246, 251, 101, 96, 184, 212, 1 },
        { 143, 169, 231, 29, 28, 237, 0 },
        { 149, 142, 131, 83, 111, 183, 1 }, },
      { { 90, 148, 209, 233, 34, 152, 1 },
        { 202, 107, 69, 227, 56, 66, 0 },
        { 140, 162, 75, 197, 148, 173, 0 },
        { 33, 14, 99, 209, 107, 41, 1 }, },
      { { 88, 170, 155, 107, 27, 52, 0 },
        { 32, 226, 86, 115, 154, 203, 1 },
        { 22, 108, 107, 108, 170, 141, 0 },
        { 233, 172, 231, 53, 35, 130, 0 }, },
      { { 90, 202, 163, 22, 250, 87, 1 },
        { 158, 150, 172, 55, 155, 201, 0 },
        { 245, 47, 180, 98, 169, 173, 0 },
        { 73, 236, 246, 26, 180, 188, 1 }, },
      { { 88, 216, 190, 3, 241, 57, 0 },
        { 40, 215, 180, 70, 186, 69, 1 },
        { 78, 71, 224, 62, 141, 141, 0 },
        { 209, 46, 177, 22, 245, 138, 0 }, },
      { { 90, 253, 27, 96, 216, 252, 0 },
        { 228, 251, 102, 21, 62, 193, 1 },
        { 31, 141, 131, 108, 95, 173, 0 },
        { 193, 190, 84, 51, 111, 147, 1 }, },
      { { 93, 40, 12, 244, 83, 170, 1 },
        { 51, 186, 94, 160, 49, 21, 1 },
        { 170, 229, 23, 152, 10, 93, 0 },
        { 212, 70, 2, 189, 46, 230, 0 }, },
      { { 94, 52, 215, 24, 145, 91, 0 },
        { 213, 71, 63, 3, 50, 71, 0 },
        { 109, 68, 140, 117, 150, 61, 0 },
        { 113, 38, 96, 126, 113, 85, 1 }, },
      { { 94, 140, 231, 129, 51, 103, 0 },
        { 205, 134, 157, 243, 26, 5, 1 },
        { 115, 102, 64, 243, 152, 189, 0 },
        { 208, 44, 103, 220, 176, 217, 1 }, },
      { { 92, 240, 52, 170, 32, 5, 0 },
        { 9, 103, 134, 148, 152, 6, 0 },
        { 80, 2, 42, 150, 7, 157, 0 },
        { 48, 12, 148, 176, 243, 72, 0 }, },
      { { 99, 47, 8, 198, 1, 227, 0 },
        { 228, 140, 90, 136, 149, 24, 1 },
        { 99, 192, 49, 136, 122, 99, 0 },
        { 140, 84, 136, 173, 24, 147, 1 }, },
      { { 97, 34, 240, 131, 154, 222, 0 },
        { 4, 72, 171, 250, 176, 217, 0 },
        { 61, 172, 224, 135, 162, 67, 0 },
        { 77, 134, 175, 234, 137, 16, 0 }, },
      { { 97, 64, 6, 28, 66, 91, 1 },
        { 22, 20, 8, 44, 51, 86, 0 },
        { 237, 33, 28, 48, 1, 67, 0 },
        { 53, 102, 26, 8, 20, 52, 0 }, },
      { { 99, 104, 252, 248, 31, 16, 0 },
        { 176, 224, 211, 174, 80, 215, 0 },
        { 4, 124, 15, 159, 139, 99, 0 },
        { 117, 133, 58, 229, 131, 134, 1 }, },
      { { 98, 163, 80, 160, 5, 206, 1 },
        { 134, 104, 27, 152, 124, 8, 0 },
        { 185, 208, 2, 133, 98, 163, 0 },
        { 8, 31, 12, 236, 11, 48, 1 }, },
      { { 96, 207, 8, 137, 207, 134, 1 },
        { 98, 152, 56, 252, 92, 138, 0 },
        { 176, 249, 200, 136, 121, 131, 0 },
        { 40, 157, 31, 142, 12, 163, 0 }, },
      { { 100, 31, 102, 147, 38, 250, 0 },
        { 93, 137, 137, 232, 246, 76, 1 },
        { 47, 178, 100, 179, 124, 19, 0 },
        { 153, 55, 139, 200, 200, 221, 0 }, },
      { { 103, 84, 36, 66, 155, 194, 1 },
        { 199, 9, 248, 44, 144, 149, 0 },
        { 161, 236, 161, 18, 21, 115, 0 },
        { 84, 132, 154, 15, 200, 113, 1 }, },
      { { 103, 94, 109, 245, 161, 167, 0 },
        { 249, 173, 249, 221, 17, 28, 1 },
        { 114, 194, 215, 219, 61, 115, 0 },
        { 156, 68, 93, 207, 218, 207, 1 }, },
      { { 100, 112, 128, 63, 112, 33, 0 },
        { 25, 53, 2, 78, 145, 3, 1 },
        { 66, 7, 126, 0, 135, 19, 0 },
        { 224, 68, 185, 32, 86, 76, 0 }, },
      { { 101, 113, 143, 62, 145, 182, 1 },
        { 51, 41, 58, 31, 151, 87, 1 },
        { 182, 196, 190, 120, 199, 83, 0 },
        { 245, 116, 252, 46, 74, 102, 0 }, },
      { { 103, 153, 192, 236, 194, 232, 1 },
        { 135, 185, 97, 170, 61, 18, 1 },
        { 139, 161, 155, 129, 204, 243, 0 },
        { 164, 94, 42, 195, 78, 240, 1 }, },
      { { 102, 181, 191, 1, 79, 214, 0 },
        { 229, 89, 154, 123, 94, 196, 0 },
        { 53, 249, 64, 126, 214, 179, 0 },
        { 17, 189, 111, 44, 205, 83, 1 }, },
      { { 103, 209, 57, 91, 135, 184, 0 },
        { 177, 73, 240, 109, 252, 82, 1 },
        { 14, 240, 237, 78, 69, 243, 0 },
        { 165, 31, 219, 7, 201, 70, 1 }, },
      { { 101, 214, 185, 83, 116, 18, 0 },
        { 121, 81, 200, 79, 216, 89, 0 },
        { 36, 23, 101, 78, 181, 211, 0 },
        { 77, 13, 249, 9, 197, 79, 0 }, },
      { { 107, 53, 69, 174, 190, 183, 0 },
        { 200, 47, 43, 185, 213, 215, 1 },
        { 118, 190, 186, 209, 86, 107, 0 },
        { 245, 213, 206, 234, 122, 9, 1 }, },
      { { 106, 85, 31, 116, 156, 15, 1 },
        { 242, 103, 104, 29, 119, 133, 0 },
        { 248, 28, 151, 124, 85, 43, 0 },
        { 80, 247, 92, 11, 115, 39, 1 }, },
      { { 105, 214, 240, 35, 1, 52, 0 },
        { 64, 99, 145, 94, 152, 88, 1 },
        { 22, 64, 98, 7, 181, 203, 0 },
        { 141, 12, 189, 68, 227, 1, 0 }, },
      { { 107, 214, 206, 166, 84, 232, 1 },
        { 230, 59, 1, 142, 251, 29, 1 },
        { 139, 149, 50, 185, 181, 235, 0 },
        { 220, 111, 184, 192, 110, 51, 1 }, },
      { { 108, 83, 126, 168, 65, 235, 0 },
        { 37, 127, 153, 140, 54, 14, 1 },
        { 107, 193, 10, 191, 101, 27, 0 },
        { 184, 54, 24, 204, 255, 82, 0 }, },
      { { 110, 99, 164, 20, 64, 36, 1 },
        { 147, 18, 130, 30, 21, 12, 1 },
        { 146, 1, 20, 18, 227, 59, 0 },
        { 152, 84, 60, 32, 164, 100, 1 }, },
      { { 108, 120, 204, 22, 132, 88, 1 },
        { 55, 131, 35, 14, 241, 68, 0 },
        { 141, 16, 180, 25, 143, 27, 0 },
        { 17, 71, 184, 98, 96, 246, 0 }, },
      { { 108, 206, 226, 122, 51, 47, 0 },
        { 89, 166, 217, 62, 186, 11, 1 },
        { 122, 102, 47, 35, 185, 155, 0 },
        { 232, 46, 190, 77, 178, 205, 0 }, },
      { { 111, 226, 98, 8, 71, 155, 0 },
        { 129, 30, 155, 44, 122, 90, 0 },
        { 108, 241, 8, 35, 35, 251, 0 },
        { 45, 47, 26, 108, 188, 64, 1 }, },
      { { 113, 2, 15, 225, 198, 243, 0 },
        { 36, 60, 108, 233, 82, 92, 1 },
        { 103, 177, 195, 248, 32, 71, 0 },
        { 157, 37, 75, 155, 30, 18, 0 }, },
      { { 113, 1, 66, 223, 219, 44, 0 },
        { 16, 16, 117, 248, 183, 147, 1 },
        { 26, 109, 253, 161, 64, 71, 0 },
        { 228, 246, 143, 215, 4, 4, 0 }, },
      { { 114, 10, 186, 206, 130, 96, 0 },
        { 164, 192, 228, 170, 147, 10, 1 },
        { 3, 32, 185, 174, 168, 39, 0 },
        { 168, 100, 170, 147, 129, 146, 1 }, },
      { { 114, 76, 255, 13, 215, 153, 0 },
        { 224, 220, 181, 111, 115, 71, 0 },
        { 76, 245, 216, 127, 153, 39, 0 },
        { 113, 103, 123, 86, 157, 131, 1 }, },
      { { 112, 148, 200, 167, 175, 228, 0 },
        { 108, 41, 53, 250, 217, 128, 1 },
        { 19, 250, 242, 137, 148, 135, 0 },
        { 128, 205, 175, 214, 74, 27, 0 }, },
      { { 115, 219, 92, 88, 31, 37, 1 },
        { 178, 197, 85, 60, 92, 159, 1 },
        { 210, 124, 13, 29, 109, 231, 0 },
        { 252, 157, 30, 85, 81, 166, 1 }, },
      { { 113, 220, 240, 226, 63, 213, 1 },
        { 78, 237, 213, 190, 216, 209, 0 },
        { 213, 254, 35, 135, 157, 199, 0 },
        { 69, 141, 190, 213, 219, 185, 0 }, },
      { { 115, 240, 217, 222, 113, 35, 1 },
        { 186, 85, 95, 143, 153, 19, 1 },
        { 226, 71, 61, 205, 135, 231, 0 },
        { 228, 76, 248, 253, 85, 46, 1 }, },
      { { 117, 16, 178, 106, 60, 109, 0 },
        { 13, 101, 196, 26, 242, 147, 1 },
        { 91, 30, 43, 38, 132, 87, 0 },
        { 228, 167, 172, 17, 211, 88, 0 }, },
      { { 117, 125, 232, 146, 6, 63, 0 },
        { 113, 133, 143, 190, 244, 80, 1 },
        { 126, 48, 36, 139, 223, 87, 0 },
        { 133, 23, 190, 248, 208, 199, 0 }, },
      { { 116, 159, 153, 133, 17, 253, 0 },
        { 101, 205, 20, 219, 61, 73, 1 },
        { 95, 196, 80, 204, 252, 151, 0 },
        { 201, 94, 109, 148, 89, 211, 0 }, },
      { { 122, 14, 219, 24, 154, 237, 0 },
        { 244, 206, 37, 59, 50, 139, 1 },
        { 91, 172, 140, 109, 184, 47, 0 },
        { 232, 166, 110, 82, 57, 151, 1 }, },
      { { 121, 22, 143, 58, 72, 165, 1 },
        { 114, 63, 4, 27, 146, 158, 1 },
        { 210, 137, 46, 120, 180, 79, 0 },
        { 188, 164, 236, 16, 126, 39, 0 }, },
      { { 121, 188, 129, 6, 112, 53, 0 },
        { 72, 151, 6, 27, 153, 81, 1 },
        { 86, 7, 48, 64, 158, 207, 0 },
        { 197, 76, 236, 48, 116, 137, 0 }, },
      { { 125, 77, 194, 163, 143, 129, 1 },
        { 67, 174, 53, 238, 214, 144, 0 },
        { 192, 248, 226, 161, 217, 95, 0 },
        { 4, 181, 187, 214, 58, 225, 0 }, },
      { { 124, 135, 26, 99, 181, 78, 0 },
        { 109, 98, 124, 88, 254, 9, 0 },
        { 57, 86, 227, 44, 112, 159, 0 },
        { 72, 63, 141, 31, 35, 91, 0 }, },
      { { 127, 162, 123, 214, 2, 146, 1 },
        { 179, 74, 207, 169, 155, 88, 0 },
        { 164, 160, 53, 239, 34, 255, 0 },
        { 13, 108, 202, 249, 169, 102, 1 }, },
      { { 125, 171, 223, 59, 221, 197, 1 },
        { 55, 254, 55, 91, 222, 159, 0 },
        { 209, 221, 238, 125, 234, 223, 0 },
        { 124, 189, 237, 118, 63, 246, 0 }, },
      { { 125, 187, 65, 173, 85, 124, 1 },
        { 7, 179, 23, 217, 125, 91, 1 },
        { 159, 85, 90, 193, 110, 223, 0 },
        { 237, 95, 77, 244, 102, 240, 0 }, },
      { { 131, 4, 66, 138, 233, 199, 0 },
        { 204, 28, 57, 144, 130, 178, 0 },
        { 113, 203, 168, 161, 16, 96, 1 },
        { 38, 160, 132, 206, 28, 25, 1 }, },
      { { 131, 43, 42, 216, 218, 107, 1 },
        { 182, 148, 234, 160, 38, 187, 1 },
        { 235, 45, 141, 170, 106, 96, 1 },
        { 238, 178, 2, 171, 148, 182, 1 }, },
      { { 129, 42, 82, 146, 228, 127, 0 },
        { 28, 212, 43, 144, 226, 120, 1 },
        { 127, 19, 164, 165, 42, 64, 1 },
        { 143, 35, 132, 234, 21, 156, 0 }, },
      { { 129, 56, 22, 164, 149, 242, 0 },
        { 4, 233, 58, 128, 67, 117, 1 },
        { 39, 212, 146, 180, 14, 64, 1 },
        { 215, 97, 0, 174, 75, 144, 0 }, },
      { { 129, 100, 221, 191, 156, 110, 1 },
        { 118, 96, 43, 215, 225, 183, 1 },
        { 187, 28, 254, 221, 147, 64, 1 },
        { 246, 195, 245, 234, 3, 55, 0 }, },
      { { 129, 123, 93, 252, 187, 253, 1 },
        { 62, 237, 115, 181, 37, 255, 1 },
        { 223, 238, 159, 221, 111, 64, 1 },
        { 255, 210, 86, 231, 91, 190, 0 }, },
      { { 130, 178, 225, 68, 80, 78, 0 },
        { 132, 17, 203, 19, 41, 41, 0 },
        { 57, 5, 17, 67, 166, 160, 1 },
        { 74, 74, 100, 105, 196, 16, 1 }, },
      { { 128, 247, 188, 97, 25, 21, 0 },
        { 96, 101, 210, 86, 12, 237, 0 },
        { 84, 76, 67, 30, 247, 128, 1 },
        { 91, 152, 53, 37, 211, 3, 0 }, },
      { { 135, 52, 106, 165, 125, 200, 0 },
        { 237, 57, 147, 192, 99, 177, 0 },
        { 9, 223, 82, 171, 22, 112, 1 },
        { 70, 227, 1, 228, 206, 91, 1 }, },
      { { 132, 140, 23, 210, 149, 239, 1 },
        { 87, 204, 120, 145, 234, 37, 1 },
        { 251, 212, 165, 244, 24, 144, 1 },
        { 210, 43, 196, 143, 25, 245, 0 }, },
      { { 132, 150, 182, 186, 170, 44, 0 },
        { 89, 97, 160, 178, 170, 174, 1 },
        { 26, 42, 174, 182, 180, 144, 1 },
        { 186, 170, 166, 130, 195, 77, 0 }, },
      { { 135, 156, 185, 242, 219, 180, 0 },
        { 241, 249, 240, 179, 136, 241, 1 },
        { 22, 237, 167, 206, 156, 240, 1 },
        { 199, 136, 230, 135, 207, 199, 1 }, },
      { { 132, 196, 118, 79, 240, 21, 1 },
        { 75, 84, 225, 84, 139, 103, 0 },
        { 212, 7, 249, 55, 17, 144, 1 },
        { 115, 104, 149, 67, 149, 105, 0 }, },
      { { 135, 196, 142, 129, 238, 18, 1 },
        { 235, 16, 40, 230, 74, 244, 0 },
        { 164, 59, 192, 184, 145, 240, 1 },
        { 23, 169, 51, 138, 4, 107, 1 }, },
      { { 133, 225, 245, 45, 64, 89, 1 },
        { 7, 116, 131, 71, 45, 118, 0 },
        { 205, 1, 90, 87, 195, 208, 1 },
        { 55, 90, 113, 96, 151, 112, 0 }, },
      { { 137, 14, 35, 66, 210, 193, 1 },
        { 70, 158, 224, 33, 130, 57, 0 },
        { 193, 165, 161, 98, 56, 72, 1 },
        { 78, 32, 194, 3, 188, 177, 0 }, },
      { { 138, 56, 218, 197, 237, 134, 1 },
        { 170, 219, 123, 210, 67, 160, 0 },
        { 176, 219, 209, 173, 142, 40, 1 },
        { 2, 225, 37, 239, 109, 170, 1 }, },
      { { 138, 149, 152, 168, 110, 21, 0 },
        { 232, 119, 0, 178, 76, 226, 0 },
        { 84, 59, 10, 140, 212, 168, 1 },
        { 35, 153, 38, 128, 119, 11, 1 }, },
      { { 141, 29, 47, 20, 46, 123, 1 },
        { 127, 135, 136, 33, 103, 244, 1 },
        { 239, 58, 20, 122, 92, 88, 1 },
        { 151, 243, 66, 8, 240, 255, 0 }, },
      { { 141, 111, 99, 41, 14, 170, 1 },
        { 67, 170, 139, 101, 102, 186, 1 },
        { 170, 184, 74, 99, 123, 88, 1 },
        { 174, 179, 83, 104, 170, 225, 0 }, },
      { { 142, 178, 140, 83, 176, 124, 1 },
        { 191, 3, 98, 82, 168, 109, 1 },
        { 159, 6, 229, 24, 166, 184, 1 },
        { 219, 10, 165, 35, 96, 126, 1 }, },
      { { 142, 222, 235, 43, 219, 30, 1 },
        { 227, 179, 185, 119, 170, 235, 0 },
        { 188, 109, 234, 107, 189, 184, 1 },
        { 107, 170, 247, 78, 230, 227, 1 }, },
      { { 141, 245, 6, 243, 158, 250, 0 },
        { 85, 43, 106, 228, 238, 245, 1 },
        { 47, 188, 231, 176, 87, 216, 1 },
        { 215, 187, 147, 171, 106, 85, 0 }, },
      { { 144, 23, 149, 47, 152, 143, 0 },
        { 64, 109, 44, 83, 165, 175, 0 },
        { 120, 140, 250, 84, 244, 4, 1 },
        { 122, 210, 229, 26, 91, 1, 0 }, },
      { { 145, 35, 7, 27, 254, 232, 0 },
        { 28, 24, 38, 97, 230, 191, 1 },
        { 11, 191, 236, 112, 98, 68, 1 },
        { 254, 179, 195, 50, 12, 28, 0 }, },
      { { 144, 37, 85, 177, 206, 2, 1 },
        { 82, 112, 47, 225, 68, 164, 0 },
        { 160, 57, 198, 213, 82, 4, 1 },
        { 18, 145, 67, 250, 7, 37, 0 }, },
      { { 144, 40, 188, 66, 77, 232, 0 },
        { 36, 216, 214, 2, 224, 164, 1 },
        { 11, 217, 33, 30, 138, 4, 1 },
        { 146, 131, 160, 53, 141, 146, 0 }, },
      { { 144, 57, 208, 138, 32, 54, 1 },
        { 10, 193, 15, 146, 132, 98, 1 },
        { 182, 2, 40, 133, 206, 4, 1 },
        { 163, 16, 164, 248, 65, 168, 0 }, },
      { { 147, 79, 149, 211, 130, 90, 0 },
        { 212, 192, 108, 231, 164, 124, 0 },
        { 45, 32, 229, 212, 249, 100, 1 },
        { 31, 18, 243, 155, 1, 149, 1 }, },
      { { 146, 164, 210, 234, 226, 74, 0 },
        { 204, 112, 111, 162, 170, 34, 0 },
        { 41, 35, 171, 165, 146, 164, 1 },
        { 34, 42, 162, 251, 7, 25, 1 }, },
      { { 145, 180, 112, 9, 138, 92, 1 },
        { 70, 65, 167, 112, 40, 242, 0 },
        { 157, 40, 200, 7, 22, 196, 1 },
        { 39, 138, 7, 114, 193, 49, 0 }, },
      { { 147, 222, 25, 219, 41, 219, 1 },
        { 254, 205, 92, 197, 168, 250, 0 },
        { 237, 202, 109, 204, 61, 228, 1 },
        { 47, 138, 209, 157, 89, 191, 1 }, },
      { { 145, 229, 150, 87, 118, 92, 0 },
        { 92, 80, 70, 118, 239, 117, 0 },
        { 29, 55, 117, 52, 211, 196, 1 },
        { 87, 123, 183, 49, 5, 29, 0 }, },
      { { 146, 236, 144, 218, 63, 135, 0 },
        { 216, 204, 94, 182, 200, 163, 0 },
        { 112, 254, 45, 132, 155, 164, 1 },
        { 98, 137, 182, 189, 25, 141, 1 }, },
      { { 146, 252, 112, 168, 201, 176, 0 },
        { 192, 249, 183, 132, 8, 226, 1 },
        { 6, 201, 138, 135, 31, 164, 1 },
        { 163, 136, 16, 246, 207, 129, 1 }, },
      { { 149, 25, 170, 136, 106, 158, 1 },
        { 43, 153, 140, 178, 38, 242, 0 },
        { 188, 171, 8, 170, 204, 84, 1 },
        { 39, 178, 38, 152, 204, 234, 0 }, },
      { { 148, 82, 41, 183, 65, 127, 0 },
        { 53, 53, 156, 213, 161, 104, 1 },
        { 127, 65, 118, 202, 37, 20, 1 },
        { 139, 66, 213, 156, 214, 86, 0 }, },
      { { 148, 87, 59, 92, 68, 38, 1 },
        { 115, 81, 204, 21, 71, 42, 1 },
        { 178, 17, 29, 110, 117, 20, 1 },
        { 170, 113, 84, 25, 197, 103, 0 }, },
      { { 151, 82, 5, 249, 168, 20, 0 },
        { 153, 33, 100, 213, 0, 254, 0 },
        { 20, 10, 207, 208, 37, 116, 1 },
        { 63, 128, 85, 147, 66, 76, 1 }, },
      { { 150, 156, 251, 61, 143, 160, 1 },
        { 243, 233, 181, 99, 75, 162, 1 },
        { 130, 248, 222, 111, 156, 180, 1 },
        { 162, 233, 99, 86, 203, 231, 1 }, },
      { { 151, 163, 111, 26, 69, 144, 1 },
        { 179, 24, 151, 1, 206, 126, 0 },
        { 132, 209, 44, 123, 98, 244, 1 },
        { 63, 57, 192, 116, 140, 102, 1 }, },
      { { 151, 170, 229, 229, 236, 98, 0 },
        { 141, 176, 239, 195, 73, 188, 1 },
        { 35, 27, 211, 211, 170, 244, 1 },
        { 158, 201, 97, 251, 134, 216, 1 }, },
      { { 151, 229, 170, 59, 113, 88, 1 },
        { 255, 48, 150, 70, 174, 115, 0 },
        { 141, 71, 110, 42, 211, 244, 1 },
        { 103, 58, 177, 52, 134, 127, 1 }, },
      { { 154, 32, 49, 130, 105, 146, 1 },
        { 138, 90, 158, 129, 128, 224, 0 },
        { 164, 203, 32, 198, 2, 44, 1 },
        { 3, 128, 192, 188, 173, 40, 1 }, },
      { { 153, 69, 56, 75, 61, 53, 1 },
        { 106, 70, 212, 84, 196, 243, 1 },
        { 214, 94, 105, 14, 81, 76, 1 },
        { 231, 145, 149, 21, 177, 43, 0 }, },
      { { 154, 177, 236, 143, 208, 111, 1 },
        { 166, 23, 175, 210, 173, 39, 1 },
        { 251, 5, 248, 155, 198, 172, 1 },
        { 242, 90, 165, 250, 244, 50, 1 }, },
      { { 154, 213, 151, 178, 63, 108, 1 },
        { 222, 99, 20, 183, 238, 165, 1 },
        { 155, 126, 38, 244, 213, 172, 1 },
        { 210, 187, 246, 148, 99, 61, 1 }, },
      { { 153, 249, 19, 79, 121, 230, 0 },
        { 12, 219, 94, 85, 143, 179, 1 },
        { 51, 207, 121, 100, 79, 204, 1 },
        { 230, 248, 213, 61, 109, 152, 0 }, },
      { { 158, 24, 232, 0, 191, 106, 1 },
        { 175, 131, 189, 34, 96, 161, 1 },
        { 171, 126, 128, 11, 140, 60, 1 },
        { 194, 131, 34, 94, 224, 250, 1 }, },
      { { 159, 72, 93, 163, 29, 40, 1 },
        { 163, 226, 21, 197, 224, 181, 1 },
        { 138, 92, 98, 221, 9, 124, 1 },
        { 214, 131, 209, 212, 35, 226, 1 }, },
      { { 159, 84, 21, 142, 137, 140, 0 },
        { 193, 75, 52, 149, 161, 182, 0 },
        { 24, 200, 184, 212, 21, 124, 1 },
        { 54, 194, 212, 150, 105, 65, 1 }, },
      { { 157, 106, 155, 82, 57, 78, 1 },
        { 63, 194, 94, 23, 162, 185, 0 },
        { 185, 78, 37, 108, 171, 92, 1 },
        { 78, 162, 244, 61, 33, 254, 0 }, },
      { { 158, 111, 156, 10, 159, 118, 0 },
        { 229, 194, 62, 54, 196, 239, 1 },
        { 55, 124, 168, 28, 251, 60, 1 },
        { 251, 145, 182, 62, 33, 211, 1 }, },
      { { 160, 9, 100, 5, 91, 91, 0 },
        { 4, 148, 153, 104, 37, 229, 0 },
        { 109, 109, 80, 19, 72, 2, 1 },
        { 83, 210, 11, 76, 148, 144, 0 }, },
      { { 162, 60, 219, 252, 54, 178, 0 },
        { 248, 233, 75, 171, 67, 99, 1 },
        { 38, 182, 31, 237, 158, 34, 1 },
        { 227, 97, 106, 233, 75, 143, 1 }, },
      { { 163, 91, 247, 118, 247, 143, 0 },
        { 152, 253, 249, 63, 231, 61, 0 },
        { 120, 247, 183, 119, 237, 98, 1 },
        { 94, 115, 254, 79, 223, 140, 1 }, },
      { { 162, 157, 115, 18, 132, 59, 0 },
        { 208, 197, 169, 9, 238, 96, 1 },
        { 110, 16, 164, 103, 92, 162, 1 },
        { 131, 59, 200, 74, 209, 133, 1 }, },
      { { 160, 206, 10, 169, 116, 87, 0 },
        { 108, 180, 8, 220, 74, 107, 0 },
        { 117, 23, 74, 168, 57, 130, 1 },
        { 107, 41, 29, 136, 22, 155, 0 }, },
      { { 160, 220, 172, 38, 43, 179, 1 },
        { 106, 173, 152, 46, 137, 228, 1 },
        { 230, 234, 50, 26, 157, 130, 1 },
        { 147, 200, 186, 12, 218, 171, 0 }, },
      { { 162, 245, 118, 116, 106, 43, 1 },
        { 218, 117, 203, 44, 47, 164, 1 },
        { 234, 43, 23, 55, 87, 162, 1 },
        { 146, 250, 26, 105, 215, 45, 1 }, },
      { { 166, 47, 214, 238, 159, 142, 1 },
        { 195, 232, 123, 186, 231, 175, 0 },
        { 184, 252, 187, 181, 250, 50, 1 },
        { 122, 243, 174, 239, 11, 225, 1 }, },
      { { 165, 56, 116, 248, 96, 115, 1 },
        { 31, 245, 203, 136, 0, 118, 1 },
        { 231, 3, 15, 151, 14, 82, 1 },
        { 183, 0, 8, 233, 215, 252, 0 }, },
      { { 164, 94, 71, 141, 231, 74, 0 },
        { 77, 145, 57, 237, 99, 46, 0 },
        { 41, 115, 216, 241, 61, 18, 1 },
        { 58, 99, 91, 206, 68, 217, 0 }, },
      { { 167, 93, 87, 124, 48, 116, 1 },
        { 223, 225, 65, 29, 7, 119, 1 },
        { 151, 6, 31, 117, 93, 114, 1 },
        { 247, 112, 92, 65, 67, 253, 1 }, },
      { { 166, 114, 149, 34, 69, 134, 0 },
        { 129, 121, 26, 31, 192, 44, 0 },
        { 48, 209, 34, 84, 167, 50, 1 },
        { 26, 1, 252, 44, 79, 64, 1 }, },
      { { 165, 131, 104, 82, 20, 90, 0 },
        { 53, 0, 201, 8, 236, 121, 0 },
        { 45, 20, 37, 11, 96, 210, 1 },
        { 79, 27, 136, 73, 128, 86, 0 }, },
      { { 164, 155, 84, 147, 194, 3, 0 },
        { 17, 213, 41, 232, 140, 44, 0 },
        { 96, 33, 228, 149, 108, 146, 1 },
        { 26, 24, 139, 202, 85, 196, 0 }, },
      { { 166, 189, 42, 131, 213, 14, 0 },
        { 225, 145, 186, 216, 238, 33, 0 },
        { 56, 85, 224, 170, 94, 178, 1 },
        { 66, 59, 141, 174, 196, 195, 1 }, },
      { { 169, 7, 89, 5, 251, 125, 0 },
        { 108, 86, 49, 121, 37, 249, 1 },
        { 95, 111, 208, 77, 112, 74, 1 },
        { 207, 210, 79, 70, 53, 27, 0 }, },
      { { 169, 21, 217, 154, 37, 235, 1 },
        { 126, 79, 25, 139, 228, 50, 1 },
        { 235, 210, 44, 205, 212, 74, 1 },
        { 166, 19, 232, 204, 121, 63, 0 }, },
      { { 171, 34, 146, 112, 50, 2, 0 },
        { 152, 98, 74, 42, 2, 57, 0 },
        { 32, 38, 7, 36, 162, 106, 1 },
        { 78, 32, 42, 41, 35, 12, 1 }, },
      { { 169, 55, 228, 166, 33, 245, 1 },
        { 78, 47, 147, 154, 133, 124, 1 },
        { 215, 194, 50, 147, 246, 74, 1 },
        { 159, 80, 172, 228, 250, 57, 0 }, },
      { { 170, 114, 189, 81, 74, 123, 0 },
        { 180, 87, 202, 111, 32, 236, 1 },
        { 111, 41, 69, 94, 167, 42, 1 },
        { 155, 130, 123, 41, 245, 22, 1 }, },
      { { 168, 137, 199, 107, 240, 9, 0 },
        { 8, 182, 97, 75, 174, 39, 0 },
        { 72, 7, 235, 113, 200, 138, 1 },
        { 114, 58, 233, 67, 54, 136, 0 }, },
      { { 170, 213, 171, 110, 131, 212, 1 },
        { 230, 43, 240, 63, 143, 98, 0 },
        { 149, 224, 187, 106, 213, 170, 1 },
        { 35, 120, 254, 7, 234, 51, 1 }, },
      { { 168, 211, 200, 181, 190, 175, 0 },
        { 56, 47, 41, 254, 109, 169, 1 },
        { 122, 190, 214, 137, 229, 138, 1 },
        { 202, 219, 63, 202, 122, 14, 0 }, },
      { { 174, 20, 19, 54, 167, 164, 0 },
        { 217, 107, 48, 57, 195, 32, 1 },
        { 18, 242, 182, 100, 20, 58, 1 },
        { 130, 97, 206, 6, 107, 77, 1 }, },
      { { 173, 100, 135, 249, 112, 220, 1 },
        { 95, 58, 66, 223, 34, 119, 0 },
        { 157, 135, 79, 240, 147, 90, 1 },
        { 119, 34, 125, 161, 46, 125, 0 }, },
      { { 175, 121, 76, 217, 234, 209, 1 },
        { 191, 159, 99, 236, 4, 246, 0 },
        { 197, 171, 205, 153, 79, 122, 1 },
        { 55, 144, 27, 227, 124, 254, 1 }, },
      { { 173, 154, 157, 184, 0, 254, 1 },
        { 55, 235, 8, 155, 40, 126, 1 },
        { 191, 128, 14, 220, 172, 218, 1 },
        { 191, 10, 108, 136, 107, 246, 0 }, },
      { { 175, 156, 136, 245, 213, 82, 0 },
        { 245, 179, 120, 202, 73, 113, 0 },
        { 37, 85, 215, 136, 156, 250, 1 },
        { 71, 73, 41, 143, 102, 215, 1 }, },
      { { 173, 207, 238, 79, 108, 35, 0 },
        { 105, 150, 201, 78, 207, 190, 1 },
        { 98, 27, 121, 59, 249, 218, 1 },
        { 190, 249, 185, 73, 180, 203, 0 }, },
      { { 173, 247, 163, 231, 58, 61, 1 },
        { 75, 39, 194, 255, 175, 249, 1 },
        { 222, 46, 115, 226, 247, 218, 1 },
        { 207, 250, 255, 161, 242, 105, 0 }, },
      { { 178, 65, 252, 215, 31, 187, 0 },
        { 176, 76, 221, 238, 229, 229, 1 },
        { 110, 252, 117, 159, 193, 38, 1 },
        { 211, 211, 187, 221, 153, 6, 1 }, },
      { { 179, 66, 216, 120, 217, 241, 1 },
        { 182, 124, 117, 14, 0, 251, 1 },
        { 199, 205, 143, 13, 161, 102, 1 },
        { 239, 128, 56, 87, 31, 54, 1 }, },
      { { 178, 97, 81, 226, 141, 99, 0 },
        { 132, 100, 127, 141, 196, 160, 1 },
        { 99, 88, 163, 197, 67, 38, 1 },
        { 130, 145, 216, 255, 19, 16, 1 }, },
      { { 179, 99, 173, 194, 60, 10, 1 },
        { 170, 0, 206, 143, 228, 189, 0 },
        { 168, 30, 33, 218, 227, 102, 1 },
        { 94, 147, 248, 185, 128, 42, 1 }, },
      { { 179, 122, 143, 78, 111, 189, 1 },
        { 170, 157, 86, 63, 227, 254, 1 },
        { 222, 251, 57, 120, 175, 102, 1 },
        { 191, 227, 254, 53, 92, 170, 1 }, },
      { { 176, 177, 13, 218, 203, 9, 1 },
        { 50, 21, 118, 169, 172, 166, 0 },
        { 200, 105, 173, 216, 70, 134, 1 },
        { 50, 154, 202, 183, 84, 38, 0 }, },
      { { 176, 187, 235, 133, 79, 183, 0 },
        { 32, 157, 159, 251, 79, 232, 1 },
        { 118, 249, 80, 235, 238, 134, 1 },
        { 139, 249, 111, 252, 220, 130, 0 }, },
      { { 177, 195, 46, 176, 79, 2, 0 },
        { 48, 48, 156, 172, 78, 188, 0 },
        { 32, 121, 6, 186, 97, 198, 1 },
        { 30, 185, 26, 156, 134, 6, 0 }, },
      { { 177, 202, 162, 122, 198, 206, 0 },
        { 20, 184, 236, 62, 234, 58, 0 },
        { 57, 177, 175, 34, 169, 198, 1 },
        { 46, 43, 190, 27, 142, 148, 0 }, },
      { { 180, 119, 47, 73, 43, 245, 0 },
        { 109, 13, 214, 125, 6, 238, 1 },
        { 87, 234, 73, 122, 119, 22, 1 },
        { 187, 176, 95, 53, 216, 91, 0 }, },
      { { 181, 174, 77, 39, 89, 131, 1 },
        { 99, 188, 31, 73, 137, 189, 0 },
        { 224, 205, 114, 89, 58, 214, 1 },
        { 94, 200, 201, 124, 30, 227, 0 }, },
      { { 183, 210, 205, 142, 206, 219, 0 },
        { 165, 29, 45, 175, 233, 254, 0 },
        { 109, 185, 184, 217, 165, 246, 1 },
        { 63, 203, 250, 218, 92, 82, 1 }, },
      { { 182, 235, 156, 93, 104, 151, 0 },
        { 185, 220, 78, 94, 13, 238, 0 },
        { 116, 139, 93, 28, 235, 182, 1 },
        { 59, 216, 61, 57, 29, 206, 1 }, },
      { { 180, 244, 103, 243, 78, 87, 0 },
        { 85, 53, 207, 253, 202, 228, 0 },
        { 117, 57, 103, 243, 23, 150, 1 },
        { 19, 169, 223, 249, 214, 85, 0 }, },
      { { 184, 15, 212, 222, 49, 7, 1 },
        { 90, 198, 93, 154, 133, 47, 0 },
        { 240, 70, 61, 149, 248, 14, 1 },
        { 122, 80, 172, 221, 49, 173, 0 }, },
      { { 184, 57, 126, 65, 128, 2, 0 },
        { 32, 195, 239, 72, 6, 36, 0 },
        { 32, 0, 193, 63, 78, 14, 1 },
        { 18, 48, 9, 123, 225, 130, 0 }, },
      { { 184, 56, 131, 182, 233, 190, 0 },
        { 24, 187, 62, 155, 163, 224, 1 },
        { 62, 203, 182, 224, 142, 14, 1 },
        { 131, 226, 236, 190, 110, 140, 0 }, },
      { { 184, 108, 6, 172, 40, 232, 0 },
        { 76, 170, 6, 140, 35, 166, 1 },
        { 11, 138, 26, 176, 27, 14, 1 },
        { 178, 226, 24, 176, 42, 153, 0 }, },
      { { 185, 136, 183, 154, 126, 192, 1 },
        { 30, 218, 132, 171, 202, 183, 0 },
        { 129, 191, 44, 246, 136, 206, 1 },
        { 118, 169, 234, 144, 173, 188, 0 }, },
      { { 184, 156, 165, 183, 60, 206, 0 },
        { 92, 171, 140, 219, 233, 165, 0 },
        { 57, 158, 118, 210, 156, 142, 1 },
        { 82, 203, 237, 152, 234, 157, 0 }, },
      { { 186, 207, 131, 167, 229, 28, 1 },
        { 202, 178, 52, 223, 239, 104, 0 },
        { 156, 83, 242, 224, 249, 174, 1 },
        { 11, 123, 253, 150, 38, 169, 1 }, },
      { { 184, 231, 17, 147, 88, 172, 1 },
        { 82, 90, 6, 221, 172, 169, 1 },
        { 154, 141, 100, 196, 115, 142, 1 },
        { 202, 154, 221, 176, 45, 37, 0 }, },
      { { 189, 114, 116, 100, 13, 206, 1 },
        { 7, 107, 223, 28, 97, 188, 0 },
        { 185, 216, 19, 23, 39, 94, 1 },
        { 30, 195, 28, 125, 235, 112, 0 }, },
      { { 188, 125, 134, 57, 75, 186, 1 },
        { 83, 187, 30, 110, 38, 230, 1 },
        { 174, 233, 78, 48, 223, 30, 1 },
        { 179, 178, 59, 60, 110, 229, 0 }, },
      { { 195, 30, 73, 175, 1, 169, 1 },
        { 226, 173, 17, 193, 177, 58, 1 },
        { 202, 192, 122, 201, 60, 97, 1 },
        { 174, 70, 193, 196, 90, 163, 1 }, },
      { { 192, 46, 91, 239, 41, 95, 0 },
        { 108, 228, 91, 209, 179, 234, 0 },
        { 125, 74, 123, 237, 58, 1, 1 },
        { 43, 230, 197, 237, 19, 155, 0 }, },
      { { 193, 78, 242, 15, 34, 121, 1 },
        { 78, 196, 129, 102, 179, 122, 1 },
        { 207, 34, 120, 39, 185, 65, 1 },
        { 175, 102, 179, 64, 145, 185, 0 }, },
      { { 193, 129, 72, 108, 154, 70, 1 },
        { 38, 32, 105, 48, 29, 179, 0 },
        { 177, 44, 155, 9, 64, 193, 1 },
        { 102, 220, 6, 75, 2, 50, 0 }, },
      { { 193, 153, 177, 237, 205, 191, 1 },
        { 2, 253, 248, 211, 125, 242, 1 },
        { 254, 217, 219, 198, 204, 193, 1 },
        { 167, 223, 101, 143, 223, 160, 0 }, },
      { { 193, 146, 177, 38, 19, 223, 1 },
        { 6, 109, 152, 51, 185, 121, 0 },
        { 253, 228, 50, 70, 164, 193, 1 },
        { 79, 78, 230, 12, 219, 48, 0 }, },
      { { 195, 183, 213, 56, 210, 51, 1 },
        { 210, 117, 43, 35, 28, 127, 1 },
        { 230, 37, 142, 85, 246, 225, 1 },
        { 255, 28, 98, 106, 87, 37, 1 }, },
      { { 193, 215, 25, 188, 235, 129, 1 },
        { 122, 125, 48, 165, 29, 186, 0 },
        { 192, 235, 158, 204, 117, 193, 1 },
        { 46, 220, 82, 134, 95, 47, 0 }, },
      { { 193, 246, 67, 78, 186, 232, 1 },
        { 78, 9, 99, 37, 187, 187, 1 },
        { 139, 174, 185, 97, 55, 193, 1 },
        { 238, 238, 210, 99, 72, 57, 0 }, },
      { { 196, 56, 145, 7, 35, 108, 1 },
        { 15, 193, 18, 115, 177, 32, 1 },
        { 155, 98, 112, 68, 142, 17, 1 },
        { 130, 70, 231, 36, 65, 248, 0 }, },
      { { 198, 77, 74, 227, 205, 183, 0 },
        { 225, 188, 121, 212, 214, 224, 1 },
        { 118, 217, 227, 169, 89, 49, 1 },
        { 131, 181, 149, 207, 30, 195, 1 }, },
      { { 199, 83, 172, 246, 95, 75, 1 },
        { 183, 53, 216, 166, 245, 189, 0 },
        { 233, 125, 55, 154, 229, 113, 1 },
        { 94, 215, 178, 141, 214, 118, 1 }, },
      { { 197, 126, 74, 113, 2, 75, 0 },
        { 117, 165, 75, 100, 50, 56, 0 },
        { 105, 32, 71, 41, 63, 81, 1 },
        { 14, 38, 19, 105, 82, 215, 0 }, },
      { { 198, 116, 217, 128, 138, 199, 1 },
        { 231, 77, 43, 183, 16, 160, 0 },
        { 241, 168, 128, 205, 151, 49, 1 },
        { 2, 132, 118, 234, 89, 115, 1 }, },
      { { 197, 136, 152, 47, 230, 202, 1 },
        { 47, 248, 40, 98, 249, 50, 0 },
        { 169, 179, 250, 12, 136, 209, 1 },
        { 38, 79, 163, 10, 15, 250, 0 }, },
      { { 197, 174, 39, 8, 53, 94, 1 },
        { 79, 128, 154, 17, 122, 127, 0 },
        { 189, 86, 8, 114, 58, 209, 1 },
        { 127, 47, 68, 44, 128, 249, 0 }, },
      { { 199, 188, 103, 248, 187, 33, 1 },
        { 219, 165, 243, 161, 26, 183, 1 },
        { 194, 110, 143, 243, 30, 241, 1 },
        { 246, 172, 66, 231, 210, 237, 1 }, },
      { { 196, 190, 140, 164, 243, 99, 0 },
        { 109, 181, 58, 162, 25, 45, 1 },
        { 99, 103, 146, 152, 190, 145, 1 },
        { 218, 76, 34, 174, 86, 219, 0 }, },
      { { 203, 15, 36, 114, 82, 53, 0 },
        { 208, 182, 192, 48, 148, 125, 1 },
        { 86, 37, 39, 18, 120, 105, 1 },
        { 223, 20, 134, 1, 182, 133, 1 }, },
      { { 201, 72, 89, 111, 111, 39, 1 },
        { 42, 246, 89, 117, 209, 178, 1 },
        { 242, 123, 123, 77, 9, 73, 1 },
        { 166, 197, 215, 77, 55, 170, 0 }, },
      { { 200, 85, 15, 64, 161, 129, 0 },
        { 104, 15, 112, 5, 22, 36, 0 },
        { 64, 194, 129, 120, 85, 9, 1 },
        { 18, 52, 80, 7, 120, 11, 0 }, },
      { { 203, 90, 139, 223, 86, 169, 0 },
        { 176, 159, 64, 231, 243, 59, 1 },
        { 74, 181, 125, 232, 173, 105, 1 },
        { 238, 103, 243, 129, 124, 134, 1 }, },
      { { 200, 115, 24, 175, 214, 16, 0 },
        { 32, 115, 34, 228, 213, 107, 0 },
        { 4, 53, 250, 140, 103, 9, 1 },
        { 107, 85, 147, 162, 103, 2, 0 }, },
      { { 201, 159, 158, 95, 56, 56, 0 },
        { 120, 195, 64, 66, 191, 255, 1 },
        { 14, 14, 125, 60, 252, 201, 1 },
        { 255, 254, 161, 1, 97, 143, 0 }, },
      { { 202, 191, 51, 44, 49, 240, 0 },
        { 204, 235, 146, 1, 31, 107, 1 },
        { 7, 198, 26, 102, 126, 169, 1 },
        { 235, 124, 64, 36, 235, 153, 1 }, },
      { { 201, 233, 181, 7, 221, 84, 0 },
        { 4, 210, 178, 87, 221, 245, 0 },
        { 21, 93, 240, 86, 203, 201, 1 },
        { 87, 221, 245, 38, 165, 144, 0 }, },
      { { 203, 240, 30, 59, 146, 129, 0 },
        { 176, 111, 34, 100, 154, 55, 0 },
        { 64, 164, 238, 60, 7, 233, 1 },
        { 118, 44, 147, 34, 123, 6, 1 }, },
      { { 204, 2, 72, 129, 217, 10, 0 },
        { 33, 18, 57, 192, 48, 169, 0 },
        { 40, 77, 192, 137, 32, 25, 1 },
        { 74, 134, 1, 206, 36, 66, 0 }, },
      { { 206, 44, 78, 124, 45, 3, 1 },
        { 251, 166, 91, 0, 83, 166, 0 },
        { 224, 90, 31, 57, 26, 57, 1 },
        { 50, 229, 0, 109, 50, 239, 1 }, },
      { { 205, 131, 179, 65, 153, 204, 1 },
        { 7, 74, 240, 83, 62, 185, 0 },
        { 153, 204, 193, 102, 224, 217, 1 },
        { 78, 190, 101, 7, 169, 112, 0 }, },
      { { 206, 128, 171, 157, 219, 17, 1 },
        { 179, 22, 176, 227, 27, 227, 0 },
        { 196, 109, 220, 234, 128, 185, 1 },
        { 99, 236, 99, 134, 180, 102, 1 }, },
      { { 204, 183, 70, 234, 75, 14, 1 },
        { 67, 51, 91, 176, 190, 174, 0 },
        { 184, 105, 43, 177, 118, 153, 1 },
        { 58, 190, 134, 237, 102, 97, 0 }, },
      { { 207, 228, 35, 113, 192, 123, 1 },
        { 215, 54, 234, 69, 58, 112, 1 },
        { 239, 1, 199, 98, 19, 249, 1 },
        { 135, 46, 81, 43, 182, 117, 1 }, },
      { { 205, 246, 59, 148, 188, 171, 1 },
        { 123, 79, 170, 133, 123, 185, 1 },
        { 234, 158, 148, 238, 55, 217, 1 },
        { 206, 239, 80, 170, 249, 111, 0 }, },
      { { 211, 23, 149, 186, 69, 222, 1 },
        { 214, 121, 28, 147, 244, 126, 0 },
        { 189, 209, 46, 212, 244, 101, 1 },
        { 63, 23, 228, 156, 79, 53, 1 }, },
      { { 208, 58, 34, 105, 80, 179, 0 },
        { 0, 189, 206, 64, 18, 107, 1 },
        { 102, 133, 75, 34, 46, 5, 1 },
        { 235, 36, 1, 57, 222, 128, 0 }, },
      { { 211, 54, 150, 219, 2, 36, 1 },
        { 210, 65, 70, 242, 146, 62, 1 },
        { 146, 32, 109, 180, 182, 101, 1 },
        { 190, 36, 167, 177, 65, 37, 1 }, },
      { { 210, 86, 224, 221, 145, 27, 0 },
        { 208, 5, 253, 198, 49, 107, 0 },
        { 108, 68, 221, 131, 181, 37, 1 },
        { 107, 70, 49, 223, 208, 5, 1 }, },
      { { 210, 188, 170, 228, 3, 129, 0 },
        { 224, 173, 214, 162, 27, 32, 0 },
        { 64, 224, 19, 170, 158, 165, 1 },
        { 2, 108, 34, 181, 218, 131, 1 }, },
      { { 211, 196, 238, 80, 249, 166, 0 },
        { 248, 24, 253, 22, 26, 181, 1 },
        { 50, 207, 133, 59, 145, 229, 1 },
        { 214, 172, 52, 95, 140, 15, 1 }, },
      { { 211, 228, 7, 252, 5, 226, 1 },
        { 214, 40, 94, 133, 91, 54, 1 },
        { 163, 208, 31, 240, 19, 229, 1 },
        { 182, 109, 80, 189, 10, 53, 1 }, },
      { { 211, 252, 28, 167, 191, 2, 0 },
        { 232, 225, 62, 228, 217, 181, 0 },
        { 32, 126, 242, 156, 31, 229, 1 },
        { 86, 205, 147, 190, 67, 139, 1 }, },
      { { 215, 68, 167, 168, 172, 223, 0 },
        { 205, 44, 172, 151, 114, 246, 0 },
        { 125, 154, 138, 242, 145, 117, 1 },
        { 55, 167, 116, 154, 154, 89, 1 }, },
      { { 214, 159, 244, 68, 89, 83, 0 },
        { 197, 213, 221, 2, 29, 237, 0 },
        { 101, 77, 17, 23, 252, 181, 1 },
        { 91, 220, 32, 93, 213, 209, 1 }, },
      { { 212, 175, 147, 230, 193, 68, 0 },
        { 69, 240, 118, 147, 159, 40, 0 },
        { 17, 65, 179, 228, 250, 149, 1 },
        { 10, 124, 228, 183, 7, 209, 0 }, },
      { { 217, 18, 102, 139, 15, 210, 1 },
        { 6, 11, 157, 224, 210, 254, 0 },
        { 165, 248, 104, 179, 36, 77, 1 },
        { 63, 165, 131, 220, 232, 48, 0 }, },
      { { 216, 81, 88, 45, 224, 190, 1 },
        { 42, 123, 45, 84, 53, 98, 1 },
        { 190, 131, 218, 13, 69, 13, 1 },
        { 163, 86, 21, 90, 111, 42, 0 }, },
      { { 216, 99, 102, 115, 129, 229, 0 },
        { 20, 46, 247, 84, 150, 44, 1 },
        { 83, 192, 231, 51, 99, 13, 1 },
        { 154, 52, 149, 119, 186, 20, 0 }, },
      { { 219, 108, 88, 112, 132, 206, 1 },
        { 246, 234, 111, 20, 112, 48, 0 },
        { 185, 144, 135, 13, 27, 109, 1 },
        { 6, 7, 20, 123, 43, 183, 1 }, },
      { { 217, 99, 155, 60, 255, 211, 0 },
        { 60, 126, 62, 39, 87, 251, 0 },
        { 101, 255, 158, 108, 227, 77, 1 },
        { 111, 245, 114, 62, 63, 30, 0 }, },
      { { 216, 138, 98, 229, 71, 244, 0 },
        { 4, 186, 213, 240, 91, 104, 1 },
        { 23, 241, 83, 163, 40, 141, 1 },
        { 139, 109, 7, 213, 174, 144, 0 }, },
      { { 217, 153, 210, 99, 213, 126, 1 },
        { 6, 243, 125, 82, 254, 113, 1 },
        { 191, 85, 227, 37, 204, 205, 1 },
        { 199, 63, 165, 95, 103, 176, 0 }, },
      { { 217, 162, 40, 145, 224, 209, 0 },
        { 60, 30, 166, 192, 24, 120, 0 },
        { 69, 131, 196, 138, 34, 205, 1 },
        { 15, 12, 1, 178, 188, 30, 0 }, },
      { { 219, 244, 50, 154, 65, 205, 0 },
        { 212, 95, 150, 148, 186, 50, 0 },
        { 89, 193, 44, 166, 23, 237, 1 },
        { 38, 46, 148, 180, 253, 21, 1 }, },
      { { 220, 29, 107, 96, 189, 237, 0 },
        { 109, 175, 245, 17, 118, 161, 1 },
        { 91, 222, 131, 107, 92, 29, 1 },
        { 194, 183, 68, 87, 250, 219, 0 }, },
      { { 222, 26, 217, 103, 197, 109, 0 },
        { 165, 247, 117, 83, 241, 40, 1 },
        { 91, 81, 243, 77, 172, 61, 1 },
        { 138, 71, 229, 87, 119, 210, 1 }, },
      { { 221, 114, 161, 214, 214, 204, 1 },
        { 23, 27, 230, 183, 241, 57, 0 },
        { 153, 181, 181, 194, 167, 93, 1 },
        { 78, 71, 246, 179, 236, 116, 0 }, },
      { { 221, 116, 213, 91, 237, 200, 1 },
        { 95, 91, 119, 71, 240, 182, 0 },
        { 137, 219, 237, 85, 151, 93, 1 },
        { 54, 135, 241, 119, 109, 125, 0 }, },
      { { 221, 134, 26, 161, 4, 19, 1 },
        { 99, 102, 12, 192, 90, 120, 0 },
        { 228, 16, 66, 172, 48, 221, 1 },
        { 15, 45, 1, 152, 51, 99, 0 }, },
      { { 223, 175, 27, 5, 181, 189, 1 },
        { 235, 206, 54, 81, 127, 121, 1 },
        { 222, 214, 208, 108, 122, 253, 1 },
        { 207, 127, 69, 54, 57, 235, 1 }, },
      { { 222, 176, 237, 214, 204, 22, 1 },
        { 179, 19, 239, 147, 217, 228, 0 },
        { 180, 25, 181, 219, 134, 189, 1 },
        { 19, 205, 228, 251, 228, 102, 1 }, },
      { { 223, 230, 10, 66, 93, 241, 0 },
        { 229, 30, 86, 4, 218, 249, 1 },
        { 71, 221, 33, 40, 51, 253, 1 },
        { 207, 173, 144, 53, 60, 83, 1 }, },
      { { 221, 251, 88, 81, 243, 143, 0 },
        { 57, 223, 127, 116, 60, 57, 0 },
        { 120, 231, 197, 13, 111, 221, 1 },
        { 78, 30, 23, 127, 125, 206, 0 }, },
      { { 227, 22, 68, 69, 140, 160, 0 },
        { 192, 9, 97, 72, 81, 188, 1 },
        { 2, 152, 209, 17, 52, 99, 1 },
        { 158, 197, 9, 67, 72, 1, 1 }, },
      { { 226, 26, 171, 99, 248, 21, 1 },
        { 170, 181, 224, 91, 146, 233, 0 },
        { 212, 15, 227, 106, 172, 35, 1 },
        { 75, 164, 237, 3, 214, 170, 1 }, },
      { { 226, 90, 168, 144, 16, 221, 1 },
        { 182, 141, 128, 158, 48, 105, 0 },
        { 221, 132, 4, 138, 173, 35, 1 },
        { 75, 6, 60, 128, 216, 182, 1 }, },
      { { 224, 126, 198, 224, 106, 118, 1 },
        { 78, 177, 75, 190, 18, 236, 1 },
        { 183, 43, 3, 177, 191, 3, 1 },
        { 155, 164, 62, 233, 70, 185, 0 }, },
      { { 225, 117, 204, 107, 230, 146, 0 },
        { 104, 57, 107, 110, 212, 118, 0 },
        { 36, 179, 235, 25, 215, 67, 1 },
        { 55, 21, 187, 107, 78, 11, 0 }, },
      { { 224, 221, 231, 62, 185, 106, 0 },
        { 92, 161, 185, 15, 191, 167, 1 },
        { 43, 78, 190, 115, 221, 131, 1 },
        { 242, 254, 248, 78, 194, 157, 0 }, },
      { { 231, 26, 89, 61, 43, 68, 0 },
        { 189, 225, 17, 121, 17, 186, 0 },
        { 17, 106, 94, 77, 44, 115, 1 },
        { 46, 196, 79, 68, 67, 222, 1 }, },
      { { 230, 61, 186, 78, 33, 23, 0 },
        { 233, 197, 218, 26, 151, 98, 0 },
        { 116, 66, 57, 46, 222, 51, 1 },
        { 35, 116, 172, 45, 209, 203, 1 }, },
      { { 231, 80, 110, 107, 241, 111, 0 },
        { 173, 53, 249, 92, 178, 55, 1 },
        { 123, 71, 235, 59, 5, 115, 1 },
        { 246, 38, 157, 79, 214, 90, 1 }, },
      { { 229, 83, 212, 72, 59, 179, 0 },
        { 9, 77, 89, 46, 20, 255, 1 },
        { 102, 238, 9, 21, 229, 83, 1 },
        { 255, 148, 58, 77, 89, 72, 0 }, },
      { { 228, 120, 9, 177, 15, 166, 1 },
        { 51, 169, 26, 253, 80, 160, 1 },
        { 178, 248, 70, 200, 15, 19, 1 },
        { 130, 133, 95, 172, 74, 230, 0 }, },
      { { 229, 122, 161, 185, 186, 74, 1 },
        { 31, 161, 170, 239, 48, 187, 0 },
        { 169, 46, 206, 194, 175, 83, 1 },
        { 110, 134, 123, 170, 194, 252, 0 }, },
      { { 231, 124, 180, 146, 88, 174, 1 },
        { 211, 217, 138, 158, 176, 181, 1 },
        { 186, 141, 36, 150, 159, 115, 1 },
        { 214, 134, 188, 168, 205, 229, 1 }, },
      { { 230, 164, 245, 240, 132, 66, 1 },
        { 215, 96, 235, 139, 88, 36, 0 },
        { 161, 16, 135, 215, 146, 179, 1 },
        { 18, 13, 104, 235, 131, 117, 1 }, },
      { { 229, 213, 42, 118, 142, 25, 1 },
        { 115, 37, 224, 44, 255, 240, 0 },
        { 204, 56, 183, 42, 85, 211, 1 },
        { 7, 255, 154, 3, 210, 103, 0 }, },
      { { 231, 215, 202, 210, 228, 123, 1 },
        { 255, 21, 105, 142, 254, 120, 1 },
        { 239, 19, 165, 169, 245, 243, 1 },
        { 143, 63, 184, 203, 84, 127, 1 }, },
      { { 228, 239, 89, 211, 239, 61, 1 },
        { 123, 212, 115, 253, 252, 232, 1 },
        { 222, 123, 229, 205, 123, 147, 1 },
        { 139, 159, 223, 231, 21, 239, 0 }, },
      { { 235, 27, 228, 239, 142, 205, 0 },
        { 132, 175, 225, 250, 245, 190, 0 },
        { 89, 184, 251, 147, 236, 107, 1 },
        { 62, 215, 175, 195, 250, 144, 1 }, },
      { { 233, 50, 9, 4, 85, 129, 1 },
        { 34, 31, 18, 9, 81, 57, 0 },
        { 192, 213, 16, 72, 38, 75, 1 },
        { 78, 69, 72, 36, 124, 34, 0 }, },
      { { 235, 52, 254, 217, 172, 58, 1 },
        { 250, 67, 235, 202, 114, 246, 1 },
        { 174, 26, 205, 191, 150, 107, 1 },
        { 183, 167, 41, 235, 225, 47, 1 }, },
      { { 234, 78, 19, 245, 78, 30, 0 },
        { 208, 242, 72, 253, 115, 232, 0 },
        { 60, 57, 87, 228, 57, 43, 1 },
        { 11, 231, 95, 137, 39, 133, 1 }, },
      { { 233, 176, 103, 32, 6, 254, 0 },
        { 4, 43, 139, 57, 122, 116, 1 },
        { 63, 176, 2, 115, 6, 203, 1 },
        { 151, 47, 78, 104, 234, 16, 0 }, },
      { { 234, 213, 177, 80, 109, 191, 0 },
        { 216, 95, 216, 31, 124, 224, 1 },
        { 126, 219, 5, 70, 213, 171, 1 },
        { 131, 159, 124, 13, 253, 13, 1 }, },
      { { 239, 10, 161, 134, 54, 174, 0 },
        { 137, 138, 136, 187, 241, 57, 1 },
        { 58, 182, 48, 194, 168, 123, 1 },
        { 206, 71, 238, 136, 168, 200, 1 }, },
      { { 237, 54, 239, 15, 39, 238, 1 },
        { 111, 11, 155, 123, 243, 62, 1 },
        { 187, 242, 120, 123, 182, 91, 1 },
        { 190, 103, 239, 108, 232, 123, 0 }, },
      { { 237, 74, 130, 29, 33, 213, 0 },
        { 29, 142, 16, 94, 19, 122, 0 },
        { 85, 194, 92, 32, 169, 91, 1 },
        { 47, 100, 61, 4, 56, 220, 0 }, },
      { { 236, 96, 189, 109, 140, 6, 0 },
        { 33, 98, 234, 95, 81, 166, 0 },
        { 48, 24, 219, 94, 131, 27, 1 },
        { 50, 197, 125, 43, 163, 66, 0 }, },
      { { 239, 130, 202, 100, 252, 71, 0 },
        { 173, 54, 105, 26, 91, 185, 0 },
        { 113, 31, 147, 41, 160, 251, 1 },
        { 78, 237, 44, 75, 54, 90, 1 }, },
      { { 238, 161, 127, 189, 151, 92, 0 },
        { 181, 98, 179, 249, 127, 103, 0 },
        { 29, 116, 222, 255, 66, 187, 1 },
        { 115, 127, 79, 230, 163, 86, 1 }, },
      { { 238, 209, 152, 137, 82, 229, 1 },
        { 167, 95, 0, 254, 28, 35, 1 },
        { 211, 165, 72, 140, 197, 187, 1 },
        { 226, 28, 63, 128, 125, 114, 1 }, },
      { { 241, 9, 85, 233, 4, 138, 1 },
        { 2, 232, 77, 201, 116, 54, 0 },
        { 168, 144, 75, 213, 72, 71, 1 },
        { 54, 23, 73, 217, 11, 160, 0 }, },
      { { 243, 42, 138, 178, 12, 104, 1 },
        { 182, 160, 6, 138, 242, 184, 1 },
        { 139, 24, 38, 168, 170, 103, 1 },
        { 142, 167, 168, 176, 2, 182, 1 }, },
      { { 243, 71, 148, 129, 100, 1, 1 },
        { 202, 84, 4, 206, 84, 60, 0 },
        { 192, 19, 64, 148, 241, 103, 1 },
        { 30, 21, 57, 144, 21, 41, 1 }, },
      { { 243, 136, 79, 37, 132, 41, 1 },
        { 162, 164, 37, 73, 123, 52, 1 },
        { 202, 16, 210, 121, 8, 231, 1 },
        { 150, 111, 73, 82, 18, 162, 1 }, },
      { { 240, 162, 31, 6, 126, 77, 1 },
        { 46, 84, 6, 57, 251, 173, 0 },
        { 217, 63, 48, 124, 34, 135, 1 },
        { 90, 239, 206, 48, 21, 58, 0 }, },
      { { 243, 170, 11, 255, 165, 205, 0 },
        { 188, 172, 118, 217, 251, 58, 0 },
        { 89, 210, 255, 232, 42, 231, 1 },
        { 46, 111, 205, 183, 26, 158, 1 }, },
      { { 240, 175, 124, 121, 142, 228, 0 },
        { 116, 232, 231, 120, 92, 174, 1 },
        { 19, 184, 207, 31, 122, 135, 1 },
        { 186, 157, 15, 115, 139, 151, 0 }, },
      { { 240, 217, 16, 212, 202, 31, 1 },
        { 18, 213, 108, 188, 61, 224, 0 },
        { 252, 41, 149, 132, 77, 135, 1 },
        { 3, 222, 30, 155, 85, 164, 0 }, },
      { { 245, 75, 179, 178, 85, 245, 1 },
        { 23, 252, 148, 159, 214, 121, 1 },
        { 215, 213, 38, 230, 233, 87, 1 },
        { 207, 53, 252, 148, 159, 244, 0 }, },
      { { 246, 81, 96, 41, 26, 234, 1 },
        { 135, 41, 141, 108, 52, 163, 1 },
        { 171, 172, 74, 3, 69, 55, 1 },
        { 226, 150, 27, 88, 202, 112, 1 }, },
      { { 246, 117, 82, 145, 217, 185, 1 },
        { 211, 93, 55, 204, 54, 225, 1 },
        { 206, 205, 196, 165, 87, 55, 1 },
        { 195, 182, 25, 246, 93, 101, 1 }, },
      { { 245, 114, 198, 173, 192, 65, 0 },
        { 5, 53, 39, 206, 19, 62, 0 },
        { 65, 1, 218, 177, 167, 87, 1 },
        { 62, 100, 57, 242, 86, 80, 0 }, },
      { { 247, 124, 210, 85, 227, 70, 0 },
        { 221, 209, 127, 126, 19, 48, 0 },
        { 49, 99, 213, 37, 159, 119, 1 },
        { 6, 100, 63, 127, 69, 221, 1 }, },
      { { 246, 132, 78, 31, 171, 28, 0 },
        { 249, 0, 53, 120, 187, 230, 0 },
        { 28, 106, 252, 57, 16, 183, 1 },
        { 51, 238, 143, 86, 0, 79, 1 }, },
      { { 248, 61, 136, 57, 165, 1, 1 },
        { 122, 167, 54, 74, 84, 34, 0 },
        { 192, 82, 206, 8, 222, 15, 1 },
        { 34, 21, 41, 54, 114, 175, 0 }, },
      { { 251, 54, 195, 223, 220, 215, 1 },
        { 214, 31, 111, 219, 211, 251, 0 },
        { 245, 157, 253, 225, 182, 111, 1 },
        { 111, 229, 237, 251, 124, 53, 1 }, },
      { { 248, 76, 172, 3, 76, 20, 1 },
        { 98, 146, 132, 94, 208, 228, 0 },
        { 148, 25, 96, 26, 153, 15, 1 },
        { 19, 133, 189, 16, 164, 163, 0 }, },
      { { 251, 160, 208, 185, 211, 75, 1 },
        { 150, 118, 63, 234, 56, 51, 0 },
        { 233, 101, 206, 133, 130, 239, 1 },
        { 102, 14, 43, 254, 55, 52, 1 }, },
      { { 250, 195, 132, 204, 125, 54, 1 },
        { 138, 18, 92, 158, 93, 239, 1 },
        { 182, 95, 25, 144, 225, 175, 1 },
        { 251, 221, 60, 157, 36, 40, 1 }, },
      { { 249, 231, 61, 60, 30, 97, 1 },
        { 118, 102, 134, 45, 93, 191, 1 },
        { 195, 60, 30, 94, 115, 207, 1 },
        { 254, 221, 90, 48, 179, 55, 0 }, },
      { { 248, 255, 88, 101, 6, 119, 1 },
        { 102, 231, 79, 124, 93, 104, 1 },
        { 247, 48, 83, 13, 127, 143, 1 },
        { 139, 93, 31, 121, 115, 179, 0 }, },
      { { 253, 11, 219, 85, 100, 56, 1 },
        { 59, 210, 69, 75, 119, 120, 1 },
        { 142, 19, 85, 109, 232, 95, 1 },
        { 143, 119, 105, 81, 37, 238, 0 }, },
      { { 253, 22, 174, 228, 229, 62, 1 },
        { 107, 51, 252, 154, 115, 124, 1 },
        { 190, 83, 147, 186, 180, 95, 1 },
        { 159, 103, 44, 159, 230, 107, 0 }, },
      { { 254, 73, 163, 120, 194, 52, 0 },
        { 145, 178, 228, 63, 22, 98, 1 },
        { 22, 33, 143, 98, 201, 63, 1 },
        { 163, 52, 126, 19, 166, 196, 1 }, },
      { { 253, 132, 226, 198, 107, 168, 1 },
        { 75, 26, 213, 170, 187, 176, 1 },
        { 138, 235, 49, 163, 144, 223, 1 },
        { 134, 238, 170, 213, 172, 105, 0 }, },
      { { 252, 149, 79, 148, 230, 207, 0 },
        { 125, 31, 45, 185, 127, 36, 0 },
        { 121, 179, 148, 249, 84, 159, 1 },
        { 18, 127, 78, 218, 124, 95, 0 }, },
      { { 254, 165, 35, 88, 48, 164, 1 },
        { 219, 10, 198, 25, 30, 35, 1 },
        { 146, 134, 13, 98, 82, 191, 1 },
        { 226, 60, 76, 49, 168, 109, 1 }, },
      { { 254, 168, 217, 255, 176, 118, 0 },
        { 189, 226, 111, 219, 153, 99, 1 },
        { 55, 6, 255, 205, 138, 191, 1 },
        { 227, 76, 237, 251, 35, 222, 1 }, },
      { { 255, 195, 135, 255, 162, 252, 1 },
        { 159, 42, 100, 255, 191, 126, 1 },
        { 159, 162, 255, 240, 225, 255, 1 },
        { 191, 126, 255, 147, 42, 124, 1 }, },
      { { 95, 114, 124, 241, 17, 248, 0 },
        { 181, 107, 215, 196, 48, 93, 1 },
        { 15, 196, 71, 159, 39, 125, 0 },
        { 221, 6, 17, 245, 235, 86, 1 }, },
      { { 135, 81, 63, 164, 61, 190, 1 },
        { 171, 105, 152, 149, 103, 245, 1 },
        { 190, 222, 18, 254, 69, 112, 1 },
        { 215, 243, 84, 140, 203, 106, 1 }, },
      { { 198, 147, 77, 53, 31, 189, 0 },
        { 177, 45, 17, 113, 125, 237, 1 },
        { 94, 252, 86, 89, 100, 177, 1 },
        { 219, 223, 71, 68, 90, 70, 1 }, },
      { { 231, 230, 150, 226, 6, 159, 1 },
        { 195, 108, 74, 190, 250, 124, 0 },
        { 252, 176, 35, 180, 179, 243, 1 },
        { 31, 47, 190, 169, 27, 97, 1 }, }, };

  static unsigned char DICT_ARUCO_MIP_36h12_BYTES[][4][5] = {{{210,182,58,9,13},{69,104,93,183,4},{185,5,198,212,11},{46,219,161,106,2}},{{96,1,19,78,5},{28,98,96,152,1},{167,44,136,0,6},{129,144,100,99,8}},{{18,6,251,231,2},{56,216,14,61,7},{78,125,246,4,8},{235,199,1,177,12}},{{255,138,214,203,4},{162,233,120,223,11},{45,54,181,31,15},{223,177,233,116,5}},{{133,218,155,196,9},{220,196,29,90,10},{146,61,149,186,1},{85,171,130,51,11}},{{180,97,175,233,12},{145,239,103,14,6},{57,127,88,98,13},{103,14,111,120,9}},{{109,181,31,225,3},{215,83,54,252,2},{200,127,138,219,6},{67,246,204,174,11}},{{82,72,197,65,15},{52,157,65,141,8},{248,42,49,36,10},{27,24,43,146,12}},{{0,143,52,80,3},{4,19,152,56,12},{192,162,207,16,0},{49,193,156,130,0}},{{142,164,98,236,14},{171,112,83,43,6},{115,116,98,87,1},{109,76,160,237,5}},{{234,194,190,118,13},{14,197,255,155,5},{182,231,212,53,7},{173,159,250,55,0}},{{26,246,21,196,4},{91,13,88,57,2},{34,58,134,245,8},{73,193,171,13,10}},{{180,138,73,242,7},{180,24,254,10,11},{228,249,37,18,13},{213,7,241,130,13}},{{46,78,18,131,11},{134,84,41,53,11},{220,20,135,39,4},{218,201,66,166,1}},{{120,177,242,250,8},{99,234,179,152,7},{21,244,248,209,14},{225,156,213,124,6}},{{39,211,79,87,14},{248,87,253,77,1},{126,175,44,190,4},{139,43,254,161,15}},{{137,34,47,255,1},{31,97,142,78,7},{143,255,68,73,1},{231,39,24,111,8}},{{76,22,105,64,6},{242,16,76,168,4},{96,41,102,131,2},{33,83,32,132,15}},{{191,73,179,81,1},{150,206,160,95,12},{136,172,217,47,13},{63,160,87,54,9}},{{220,25,28,213,13},{206,11,197,158,10},{186,179,137,131,11},{87,154,61,7,3}},{{17,215,195,248,5},{116,238,218,104,2},{161,252,62,184,8},{65,101,183,114,14}},{{22,161,48,227,5},{133,10,82,29,7},{172,112,200,86,8},{235,132,165,10,1}},{{226,159,39,239,15},{92,115,123,175,15},{255,126,79,148,7},{255,93,236,227,10}},{{66,141,138,224,12},{0,194,87,169,10},{48,117,27,20,2},{89,94,164,48,0}},{{144,213,72,71,7},{108,30,84,46,1},{238,33,42,176,9},{135,66,167,131,6}},{{35,25,203,201,3},{116,242,36,77,10},{201,61,57,140,4},{91,34,68,242,14}},{{195,176,195,223,12},{121,224,209,207,3},{63,188,48,220,3},{207,56,176,121,14}},{{4,36,188,204,9},{141,161,5,56,6},{147,51,210,66,0},{97,202,8,91,1}},{{42,8,29,99,0},{18,1,38,29,9},{12,107,129,5,4},{155,134,72,4,8}},{{118,39,67,217,6},{177,122,232,173,2},{105,188,46,70,14},{75,81,117,232,13}},{{208,100,91,241,9},{53,76,135,190,2},{152,253,162,96,11},{71,222,19,42,12}},{{243,141,127,214,0},{56,75,180,251,15},{6,191,235,28,15},{253,242,221,33,12}},{{198,203,249,161,0},{176,134,30,151,14},{8,89,253,54,3},{126,151,134,16,13}},{{60,27,231,198,5},{254,203,104,8,15},{166,62,125,131,12},{241,1,109,55,15}},{{39,111,117,230,3},{189,23,42,121,15},{198,122,239,110,4},{249,229,78,139,13}},{{68,144,163,246,3},{220,208,146,136,7},{198,252,80,146,2},{225,20,144,179,11}},{{218,96,172,213,2},{11,157,132,143,6},{74,179,80,101,11},{111,18,27,157,0}},{{60,198,141,245,9},{158,141,191,44,2},{154,251,22,51,12},{67,79,219,23,9}},{{171,70,249,218,14},{50,180,237,123,7},{117,185,246,45,5},{237,235,114,212,12}},{{136,213,51,215,8},{90,70,145,62,7},{30,188,202,177,1},{231,200,150,37,10}},{{182,214,46,194,1},{196,77,60,43,7},{132,55,70,182,13},{237,67,203,34,3}},{{179,192,43,100,6},{24,92,118,75,4},{98,109,64,60,13},{45,38,227,161,8}},{{34,229,109,64,8},{49,7,53,41,4},{16,43,106,116,4},{41,74,206,8,12}},{{172,95,87,112,10},{242,87,171,58,8},{80,238,175,163,5},{21,205,94,164,15}},{{170,169,147,246,6},{27,210,242,27,11},{102,252,153,85,5},{221,132,244,189,8}},{{76,170,7,200,13},{151,97,89,136,10},{177,62,5,83,2},{81,25,168,110,9}},{{92,155,79,123,0},{242,107,158,140,9},{13,239,45,147,10},{147,23,157,100,15}},{{170,158,240,224,5},{102,128,122,59,14},{160,112,247,149,5},{125,197,224,22,6}},{{7,5,197,117,0},{184,131,130,109,0},{10,234,58,14,0},{11,100,28,17,13}},{{172,129,245,69,14},{186,147,113,30,4},{122,42,248,19,5},{39,136,236,149,13}},{{115,91,145,231,4},{88,142,106,221,11},{46,120,157,172,14},{219,181,103,17,10}},{{140,195,92,238,4},{170,39,94,26,3},{39,115,172,51,1},{197,135,174,69,5}},{{228,70,148,208,4},{128,133,232,186,2},{32,178,150,34,7},{69,209,122,16,1}},{{181,225,33,222,0},{153,46,176,74,7},{7,184,72,122,13},{229,32,215,73,9}},{{38,16,23,208,15},{212,81,225,25,2},{240,190,128,134,4},{73,136,120,162,11}},{{241,212,57,235,5},{84,44,118,254,7},{173,121,194,184,15},{231,246,227,66,10}},{{161,163,58,201,6},{1,114,124,94,6},{105,53,204,88,5},{103,163,228,232,0}},{{23,76,98,192,2},{160,92,0,105,14},{64,52,99,46,8},{121,96,3,160,5}},{{30,226,127,113,6},{179,93,222,29,4},{104,239,228,119,8},{43,135,187,172,13}},{{139,28,94,206,9},{110,97,5,123,11},{151,55,163,141,1},{221,234,8,103,6}},{{106,5,176,198,10},{10,146,33,185,7},{86,48,218,5,6},{233,216,68,149,0}},{{13,5,104,223,12},{170,34,197,108,7},{63,177,106,11,0},{227,106,52,69,5}},{{25,45,37,229,15},{31,27,67,108,14},{250,122,75,73,8},{115,108,45,143,8}},{{26,219,236,204,8},{106,175,29,9,14},{19,51,125,181,8},{121,11,143,85,6}},{{207,236,135,240,0},{147,197,146,235,10},{0,254,19,127,3},{93,116,154,60,9}},{{208,185,221,231,10},{121,155,23,158,11},{94,123,185,208,11},{215,158,141,153,14}},{{136,220,239,129,14},{114,213,85,38,14},{120,31,115,177,1},{118,74,170,180,14}},{{68,86,129,203,9},{212,164,9,172,3},{157,56,22,162,2},{195,89,2,82,11}},{{219,178,255,200,3},{119,249,28,219,6},{193,63,244,221,11},{109,179,137,254,14}},{{164,141,150,223,1},{140,227,176,62,11},{143,182,155,18,5},{215,192,220,115,1}},{{183,44,194,231,13},{173,200,99,111,11},{190,116,51,78,13},{223,108,97,59,5}},{{12,41,91,83,15},{183,82,197,28,9},{252,173,169,67,0},{147,138,52,174,13}},{{244,152,50,112,4},{192,72,242,154,12},{32,228,193,146,15},{53,148,241,32,3}},{{153,104,237,194,9},{55,141,5,74,15},{148,59,113,105,9},{245,42,11,30,12}},{{158,78,26,248,5},{134,108,206,59,10},{161,245,135,39,9},{93,199,51,102,1}},{{134,131,226,209,11},{164,210,153,15,6},{216,180,124,22,1},{111,9,148,178,5}},{{129,11,69,192,4},{48,3,72,74,10},{32,58,45,8,1},{85,33,44,0,12}},{{106,196,75,254,2},{58,116,182,169,3},{71,253,34,53,6},{201,86,210,229,12}},{{100,83,70,97,5},{228,71,106,140,0},{168,102,44,162,6},{3,21,110,34,7}},{{57,144,189,89,8},{82,169,181,92,4},{25,171,208,153,12},{35,170,217,84,10}},{{28,158,208,246,10},{234,152,155,56,11},{86,240,183,147,8},{209,205,145,149,7}},{{194,103,41,214,5},{29,6,204,171,7},{166,185,78,100,3},{237,83,54,11,8}},{{131,153,63,121,5},{84,99,214,95,12},{169,239,201,156,1},{63,166,188,98,10}},{{58,192,90,197,13},{46,76,117,29,2},{186,53,160,53,12},{75,138,227,39,4}},{{53,122,223,243,11},{245,221,175,92,11},{220,255,181,234,12},{211,175,91,186,15}},{{13,92,5,86,5},{222,5,192,104,9},{166,170,3,171,0},{145,96,58,7,11}},{{47,84,126,244,4},{234,69,230,121,6},{34,247,226,175,4},{105,230,122,37,7}},{{134,193,21,4,1},{156,7,16,19,0},{130,10,136,54,1},{12,128,142,3,9}},{{100,15,217,229,15},{188,146,111,188,10},{250,121,191,2,6},{83,223,100,147,13}},{{206,8,187,207,7},{158,240,68,159,15},{239,61,209,7,3},{255,146,32,247,9}},{{16,155,179,67,14},{80,218,89,28,13},{124,44,221,144,8},{179,137,165,176,10}},{{194,20,53,201,2},{80,49,0,191,6},{73,58,194,132,3},{111,208,8,192,10}},{{53,180,223,206,4},{249,233,116,120,3},{39,63,178,218,12},{193,226,233,121,15}},{{69,151,82,207,2},{232,114,24,252,3},{79,52,174,154,2},{195,241,132,225,7}},{{236,145,91,130,12},{242,66,117,146,3},{52,29,168,147,7},{196,154,228,36,15}},{{81,136,30,237,0},{8,105,22,220,10},{11,119,129,24,10},{83,182,137,97,0}},{{45,218,125,201,7},{246,53,124,92,14},{233,59,229,187,4},{115,163,234,198,15}},{{46,1,66,20,4},{170,66,224,1,0},{34,132,40,7,4},{8,0,116,37,5}},{{66,232,144,249,9},{5,164,147,157,10},{153,240,145,116,2},{91,156,146,90,0}},{{154,136,86,82,7},{38,89,208,27,9},{228,166,161,21,9},{157,128,185,166,4}},{{142,128,217,216,0},{178,160,148,27,2},{1,185,176,23,1},{77,130,144,84,13}},{{137,28,188,243,4},{66,129,198,126,15},{44,243,211,137,1},{247,230,56,20,2}},{{37,221,130,65,0},{192,198,48,108,8},{8,36,27,186,4},{19,96,198,48,3}},{{35,149,81,211,4},{112,2,240,125,3},{44,184,170,156,4},{203,224,244,0,14}},{{143,232,240,199,0},{171,132,16,95,15},{14,48,241,127,1},{255,160,130,29,5}},{{148,16,106,151,0},{232,72,132,6,7},{14,149,96,130,9},{230,2,17,33,7}},{{130,96,155,64,12},{17,196,69,27,0},{48,45,144,100,1},{13,138,34,56,8}},{{15,201,202,243,6},{162,214,214,77,11},{108,245,57,63,0},{219,38,182,180,5}},{{104,129,129,209,1},{22,130,176,140,2},{136,184,24,17,6},{67,16,212,22,8}},{{113,134,19,192,8},{16,72,57,248,2},{16,60,134,24,14},{65,249,193,32,8}},{{15,26,183,98,9},{214,193,11,89,13},{148,110,213,143,0},{185,173,8,54,11}},{{163,87,191,193,8},{80,199,45,127,6},{24,63,222,172,5},{111,235,78,48,10}},{{76,3,183,164,6},{154,211,74,144,6},{98,94,220,3,2},{96,149,44,181,9}},{{32,77,237,206,6},{56,183,100,40,15},{103,59,123,32,4},{241,66,110,209,12}},{{173,99,0,211,7},{135,22,232,78,3},{236,176,12,107,5},{199,33,118,142,1}},{{132,204,76,208,9},{164,5,149,42,10},{144,179,35,50,1},{85,74,154,2,5}},{{66,22,14,92,4},{72,97,204,169,0},{35,167,6,132,2},{9,83,56,97,2}},{{135,210,173,250,8},{208,165,159,75,7},{21,251,84,190,1},{237,47,154,80,11}},{{120,80,231,116,9},{126,205,163,136,4},{146,238,112,161,14},{33,28,91,55,14}},{{78,117,15,199,12},{219,71,69,173,3},{62,63,10,231,2},{203,90,46,45,11}},{{191,46,93,253,10},{187,57,175,127,10},{91,251,167,79,13},{95,239,89,205,13}},{{216,131,36,218,5},{6,43,216,138,7},{165,178,76,17,11},{229,17,189,70,0}},{{35,75,82,248,0},{32,102,170,89,10},{1,244,173,44,4},{89,165,86,96,4}},{{55,130,4,81,4},{128,9,248,77,0},{40,162,4,30,12},{11,33,249,0,1}},{{171,223,42,213,3},{78,86,188,111,14},{202,181,79,189,5},{127,99,214,167,2}},{{54,94,120,239,9},{236,44,47,61,15},{159,113,231,166,12},{251,207,67,67,7}},{{73,202,166,202,2},{2,245,24,200,15},{69,54,85,57,2},{241,49,138,244,0}},{{3,195,157,223,3},{28,183,156,93,3},{207,187,156,60,0},{203,163,158,211,8}},{{198,140,83,133,13},{188,64,81,183,10},{186,28,163,22,3},{94,216,160,35,13}},{{91,252,187,246,7},{95,220,214,249,15},{230,253,211,253,10},{249,246,179,191,10}},{{98,50,65,226,1},{117,0,42,137,3},{132,120,36,196,6},{201,21,64,10,14}},{{171,201,13,92,12},{26,39,245,75,8},{51,171,9,61,5},{29,42,254,69,8}},{{56,140,111,232,5},{54,105,118,40,14},{161,127,99,17,12},{113,70,233,102,12}},{{218,14,45,98,13},{22,9,79,171,13},{180,107,71,5,11},{189,95,41,6,8}},{{16,133,93,254,9},{60,43,151,56,3},{151,251,170,16,8},{193,206,157,67,12}},{{77,70,239,214,11},{190,213,141,232,7},{214,191,118,43,2},{225,123,26,183,13}},{{118,234,18,214,1},{141,76,184,153,11},{134,180,133,118,14},{217,145,211,43,1}},{{157,179,119,211,13},{247,75,217,94,7},{188,190,236,219,9},{231,169,189,46,15}},{{238,208,239,167,1},{254,197,54,135,7},{142,95,112,183,7},{238,22,202,55,15}},{{230,236,58,226,15},{133,84,119,187,15},{244,117,195,118,7},{253,222,226,170,1}},{{68,31,174,232,3},{196,243,14,168,14},{193,119,95,130,2},{113,87,12,242,3}},{{186,25,200,255,5},{110,170,230,15,11},{175,241,57,133,13},{223,6,117,87,6}},{{49,48,53,234,11},{85,57,35,88,7},{213,122,192,200,12},{225,172,73,202,10}},{{108,232,247,98,5},{183,197,114,152,13},{164,110,241,115,6},{177,148,234,62,13}},{{136,13,171,88,13},{22,226,197,42,12},{177,173,91,1,1},{53,74,52,118,8}},{{141,52,9,224,13},{215,0,71,106,2},{176,121,2,203,1},{69,110,32,14,11}},{{43,233,46,226,1},{7,71,54,73,15},{132,119,73,125,4},{249,38,206,46,0}},{{214,3,2,198,12},{136,74,73,139,3},{54,52,12,6,11},{205,25,37,33,1}},{{70,159,252,114,4},{224,131,222,185,13},{36,227,255,150,2},{185,215,188,16,7}},{{135,238,190,237,3},{141,245,30,127,14},{203,119,215,126,1},{127,231,138,251,1}},{{66,88,126,247,10},{104,85,135,157,15},{94,247,225,164,2},{251,158,26,161,6}},{{122,140,196,229,2},{42,153,50,173,10},{74,114,51,21,14},{91,84,201,149,4}},{{118,164,55,101,0},{153,73,50,189,4},{10,110,194,86,14},{43,212,201,41,9}},{{153,158,65,239,4},{122,40,90,110,11},{47,120,39,153,9},{215,101,161,69,14}},{{125,9,105,228,2},{186,26,38,200,14},{66,121,105,11,14},{113,54,69,133,13}},{{192,43,175,70,11},{29,211,13,138,13},{214,47,93,64,3},{181,27,12,187,8}},{{146,89,243,228,7},{124,222,66,27,14},{226,124,249,164,9},{125,132,39,179,14}},{{33,22,161,220,0},{88,160,168,104,6},{3,184,86,136,4},{97,97,80,81,10}},{{159,45,228,216,4},{163,171,192,107,14},{33,178,123,79,9},{125,96,61,92,5}},{{0,239,250,194,9},{37,198,29,56,15},{148,53,255,112,0},{241,203,134,58,4}},{{123,55,31,248,12},{83,107,239,249,2},{49,255,142,205,14},{73,255,125,108,10}},{{102,131,57,218,9},{148,34,189,153,7},{149,185,204,22,6},{233,155,212,66,9}},{{208,16,174,227,15},{68,217,71,142,7},{252,119,80,128,11},{231,30,41,178,2}},{{28,208,11,76,0},{218,108,20,8,0},{3,45,0,179,8},{1,2,131,101,11}},{{149,7,15,195,11},{148,91,13,110,3},{220,63,14,10,9},{199,107,13,162,9}},{{248,76,154,119,0},{10,204,166,190,9},{14,229,147,33,15},{151,214,83,53,0}},{{56,248,99,215,6},{123,92,240,12,15},{110,188,97,241,12},{243,0,243,173,14}},{{54,70,255,4,5},{188,205,108,49,4},{162,15,246,38,12},{40,195,107,51,13}},{{206,27,150,65,2},{194,211,8,159,8},{72,38,157,135,3},{31,145,12,180,3}},{{122,93,69,218,8},{114,47,161,169,11},{21,186,43,165,14},{217,88,95,68,14}},{{20,224,14,246,12},{137,77,215,8,3},{54,247,0,114,8},{193,14,187,41,1}},{{94,149,171,253,8},{218,234,151,173,6},{27,253,90,151,10},{107,94,149,117,11}},{{178,233,203,114,9},{53,206,183,11,9},{148,237,57,116,13},{157,14,215,58,12}},{{3,108,71,221,7},{61,117,192,109,10},{235,190,35,108,0},{91,96,58,235,12}},{{184,238,151,198,11},{31,221,57,58,11},{214,62,151,113,13},{213,201,203,191,8}},{{14,158,143,101,7},{222,209,94,45,8},{234,111,23,151,0},{27,71,168,183,11}},{{212,173,46,241,10},{129,91,151,174,14},{88,247,75,82,11},{119,94,157,168,1}},{{136,17,199,243,2},{114,211,130,14,3},{76,254,56,129,1},{199,4,28,180,14}},{{71,189,231,195,1},{245,195,16,237,15},{140,62,123,222,2},{251,112,140,58,15}},{{58,218,223,182,4},{122,205,254,17,11},{38,223,181,181,12},{216,135,251,53,14}},{{110,91,40,87,4},{202,6,236,141,13},{46,161,77,167,6},{187,19,118,5,3}},{{51,230,124,217,1},{37,45,188,125,6},{137,179,230,124,12},{107,227,219,74,4}},{{42,185,253,210,13},{119,131,245,25,15},{180,187,249,213,4},{249,138,252,30,14}},{{138,250,103,242,11},{119,85,155,11,15},{212,254,101,245,1},{253,13,154,174,14}},{{230,162,143,197,14},{153,209,125,143,2},{122,63,20,86,7},{79,27,232,185,9}},{{114,4,156,219,13},{4,169,229,189,3},{189,179,146,4,14},{203,218,121,82,0}},{{174,101,218,193,2},{163,214,36,63,2},{72,53,186,103,5},{79,194,70,188,5}},{{18,81,164,82,6},{64,159,192,9,5},{100,162,88,164,8},{169,0,63,144,2}},{{16,137,171,132,1},{28,202,20,0,14},{130,29,89,16,8},{112,2,133,51,8}},{{226,240,150,238,0},{73,229,50,155,3},{7,118,144,244,7},{205,148,202,121,2}},{{176,202,238,87,3},{44,221,188,14,13},{206,167,117,48,13},{183,3,219,179,4}},{{253,102,119,232,6},{179,125,106,250,6},{97,126,230,107,15},{101,245,107,236,13}},{{68,75,63,81,8},{144,71,141,156,12},{24,175,205,34,2},{51,155,30,32,9}},{{190,139,58,86,10},{138,90,189,27,13},{86,165,205,23,13},{189,139,213,165,1}},{{104,10,117,207,12},{58,33,105,156,15},{63,58,229,1,6},{243,153,104,69,12}},{{172,2,186,234,8},{130,224,47,26,7},{21,117,212,3,5},{229,143,64,116,1}},{{151,216,21,225,12},{208,13,83,95,10},{56,122,129,190,9},{95,172,171,0,11}},{{29,67,134,224,8},{130,207,11,72,2},{16,118,28,43,8},{65,45,15,52,1}},{{26,20,245,176,14},{114,153,195,49,6},{112,218,242,133,8},{104,204,57,148,14}},{{230,88,168,216,1},{196,164,164,139,14},{129,177,81,166,7},{125,18,82,82,3}},{{163,134,142,250,7},{4,241,254,107,3},{229,247,22,28,5},{205,103,248,242,0}},{{54,104,169,103,3},{157,156,38,13,13},{206,105,81,102,12},{187,6,67,155,9}},{{232,252,83,216,5},{119,100,240,186,10},{161,188,163,241,7},{85,208,242,110,14}},{{46,43,126,221,5},{175,99,236,29,14},{171,183,237,71,4},{123,131,124,111,5}},{{139,36,112,241,3},{39,16,130,127,6},{200,240,226,77,1},{111,228,16,142,4}},{{246,151,149,243,2},{208,155,186,191,3},{76,250,158,150,15},{207,213,221,144,11}},{{69,137,255,200,14},{176,243,85,216,14},{113,63,249,26,2},{113,186,172,240,13}},{{46,32,128,201,12},{131,160,97,13,2},{57,48,16,71,4},{75,8,96,92,1}},{{6,66,101,247,13},{188,5,203,13,7},{190,250,100,38,0},{235,13,58,3,13}},{{61,113,77,209,0},{243,15,164,76,2},{8,187,40,235,12},{67,34,95,12,15}},{{22,146,198,239,1},{236,233,26,13,3},{143,118,52,150,8},{203,5,137,115,7}},{{62,103,242,244,9},{175,206,171,57,6},{146,244,254,103,12},{105,205,87,63,5}},{{80,65,218,214,3},{44,222,132,152,3},{198,181,184,32,10},{193,146,23,179,4}},{{26,21,3,65,5},{86,74,64,45,0},{168,44,10,133,8},{11,64,37,38,10}},{{100,193,140,116,2},{136,151,182,136,0},{66,227,24,50,6},{1,22,222,145,1}},{{10,114,238,195,5},{103,197,76,13,7},{172,55,116,229,0},{235,3,42,62,6}},{{31,15,157,198,0},{154,139,12,121,11},{6,59,159,15,8},{217,227,13,21,9}},{{169,85,155,198,7},{94,214,100,122,3},{230,61,154,169,5},{197,226,102,183,10}},{{243,41,17,208,13},{21,10,225,219,10},{176,184,137,76,15},{93,184,117,10,8}},{{33,192,212,255,12},{40,165,243,92,3},{63,242,176,56,4},{195,172,250,81,4}},{{224,28,239,91,0},{112,225,164,174,13},{13,175,115,128,7},{183,82,88,112,14}},{{78,35,163,82,0},{147,194,136,137,5},{4,172,92,71,2},{169,17,20,60,9}},{{170,79,4,228,9},{14,7,43,43,10},{146,114,15,37,5},{93,77,78,7,0}},{{225,196,252,196,3},{44,149,52,250,6},{194,51,242,56,7},{101,242,202,147,4}},{{32,142,143,110,8},{24,225,63,40,9},{23,111,23,16,4},{145,79,200,113,8}},{{132,134,119,74,5},{180,97,88,58,5},{165,46,230,18,1},{165,193,168,98,13}},{{158,152,199,85,8},{250,201,145,15,8},{26,174,49,151,9},{31,8,153,53,15}},{{44,89,251,125,12},{250,230,231,28,12},{59,237,249,163,4},{51,142,118,117,15}},{{148,70,164,97,3},{132,157,10,46,4},{200,98,86,34,9},{39,69,11,146,1}},{{130,146,220,194,14},{96,145,93,27,3},{116,51,180,148,1},{205,139,168,144,6}},{{0,77,97,99,1},{52,6,2,44,13},{140,104,107,32,0},{179,68,6,2,12}},{{208,85,39,128,9},{84,79,1,162,6},{144,30,74,160,11},{100,88,15,34,10}},{{160,22,56,82,13},{68,0,237,58,5},{180,161,198,128,5},{165,203,112,2,2}},{{143,101,127,99,9},{183,71,7,127,5},{156,111,234,111,1},{175,238,14,46,13}},{{204,166,195,227,7},{183,208,90,174,3},{236,124,54,83,3},{199,85,160,190,13}},{{203,19,107,199,10},{122,82,13,207,7},{94,61,108,141,3},{239,59,4,165,14}},{{252,90,131,229,3},{222,220,42,142,10},{202,124,21,163,15},{87,21,67,183,11}},{{154,164,79,195,0},{51,73,20,47,3},{12,63,34,85,9},{207,66,137,44,12}},{{189,236,27,211,12},{147,76,245,126,11},{60,189,131,123,13},{215,234,243,44,9}},{{224,32,185,247,12},{25,128,231,158,7},{62,249,208,64,7},{231,158,112,25,8}},{{75,143,53,251,0},{18,35,154,253,15},{13,250,207,29,2},{251,245,156,68,8}},{{184,22,95,99,7},{118,89,110,62,1},{236,111,166,129,13},{135,199,105,166,14}},{{51,220,136,214,9},{76,140,181,105,11},{150,177,19,188,12},{217,106,211,19,2}},{{16,162,247,228,13},{61,201,91,24,6},{178,126,244,80,8},{97,141,169,59,12}},{{200,203,95,245,3},{62,87,158,158,10},{202,255,173,49,3},{87,151,158,167,12}},{{222,37,159,246,11},{159,219,135,187,3},{214,255,154,71,11},{205,222,29,191,9}},{{70,208,112,221,4},{232,36,208,157,6},{43,176,224,182,2},{107,144,178,65,7}},{{50,211,185,116,1},{92,142,190,25,4},{130,233,220,180,12},{41,135,215,19,10}},{{112,117,241,192,4},{113,142,96,184,6},{32,56,250,224,14},{97,208,103,24,14}},{{77,88,219,234,0},{242,228,6,216,11},{5,125,177,171,2},{209,182,2,116,15}}};
}
