// Code generated by smithy-go/middleware/generate.go DO NOT EDIT.
package middleware

import (
	"context"
	"fmt"
)

// SerializeInput provides the input parameters for the SerializeMiddleware to
// consume. SerializeMiddleware may modify the Request value before forwarding
// SerializeInput along to the next SerializeHandler. The Parameters member
// should not be modified by SerializeMiddleware, InitializeMiddleware should
// be responsible for modifying the provided Parameter value.
type SerializeInput struct {
	Parameters interface{}
	Request    interface{}
}

// SerializeOutput provides the result returned by the next SerializeHandler.
type SerializeOutput struct {
	Result interface{}
}

// SerializeHandler provides the interface for the next handler the
// SerializeMiddleware will call in the middleware chain.
type SerializeHandler interface {
	HandleSerialize(ctx context.Context, in SerializeInput) (
		out SerializeOutput, metadata Metadata, err error,
	)
}

// SerializeMiddleware provides the interface for middleware specific to the
// serialize step. Delegates to the next SerializeHandler for further
// processing.
type SerializeMiddleware interface {
	// ID returns a unique ID for the middleware in the SerializeStep. The step does not
	// allow duplicate IDs.
	ID() string

	// HandleSerialize invokes the middleware behavior which must delegate to the next handler
	// for the middleware chain to continue. The method must return a result or
	// error to its caller.
	HandleSerialize(ctx context.Context, in SerializeInput, next SerializeHandler) (
		out SerializeOutput, metadata Metadata, err error,
	)
}

// SerializeMiddlewareFunc returns a SerializeMiddleware with the unique ID provided,
// and the func to be invoked.
func SerializeMiddlewareFunc(id string, fn func(context.Context, SerializeInput, SerializeHandler) (SerializeOutput, Metadata, error)) SerializeMiddleware {
	return serializeMiddlewareFunc{
		id: id,
		fn: fn,
	}
}

type serializeMiddlewareFunc struct {
	// Unique ID for the middleware.
	id string

	// Middleware function to be called.
	fn func(context.Context, SerializeInput, SerializeHandler) (
		SerializeOutput, Metadata, error,
	)
}

// ID returns the unique ID for the middleware.
func (s serializeMiddlewareFunc) ID() string { return s.id }

// HandleSerialize invokes the middleware Fn.
func (s serializeMiddlewareFunc) HandleSerialize(ctx context.Context, in SerializeInput, next SerializeHandler) (
	out SerializeOutput, metadata Metadata, err error,
) {
	return s.fn(ctx, in, next)
}

var _ SerializeMiddleware = (serializeMiddlewareFunc{})

// SerializeStep provides the ordered grouping of SerializeMiddleware to be
// invoked on a handler.
type SerializeStep struct {
	head       *decoratedSerializeHandler
	tail       *decoratedSerializeHandler
	newRequest func() interface{}
}

// NewSerializeStep returns an SerializeStep ready to have middleware for
// serialize added to it.
func NewSerializeStep(newRequest func() interface{}) *SerializeStep {
	return &SerializeStep{
		newRequest: newRequest,
	}
}

var _ Middleware = (*SerializeStep)(nil)

// ID returns the unique ID of the step as a middleware.
func (s *SerializeStep) ID() string {
	return "Serialize stack step"
}

// HandleMiddleware invokes the middleware by decorating the next handler
// provided. Returns the result of the middleware and handler being invoked.
//
// Implements Middleware interface.
func (s *SerializeStep) HandleMiddleware(ctx context.Context, in interface{}, next Handler) (
	out interface{}, metadata Metadata, err error,
) {
	sIn := SerializeInput{
		Parameters: in,
		Request:    s.newRequest(),
	}

	wh := &serializeWrapHandler{next}
	if s.head == nil {
		res, metadata, err := wh.HandleSerialize(ctx, sIn)
		return res.Result, metadata, err
	}

	s.tail.Next = wh
	res, metadata, err := s.head.HandleSerialize(ctx, sIn)
	return res.Result, metadata, err
}

// Get retrieves the middleware identified by id. If the middleware is not present, returns false.
func (s *SerializeStep) Get(id string) (SerializeMiddleware, bool) {
	found, _ := s.get(id)
	if found == nil {
		return nil, false
	}

	return found.With, true
}

// Add injects the middleware to the relative position of the middleware group.
//
// Add never returns an error. It used to for duplicate phases but this
// behavior has since been removed as part of a performance optimization. The
// return value from Add can be ignored.
func (s *SerializeStep) Add(m SerializeMiddleware, pos RelativePosition) error {
	if s.head == nil {
		s.head = &decoratedSerializeHandler{nil, m}
		s.tail = s.head
		return nil
	}

	if pos == Before {
		s.head = &decoratedSerializeHandler{s.head, m}
	} else {
		tail := &decoratedSerializeHandler{nil, m}
		s.tail.Next = tail
		s.tail = tail
	}

	return nil
}

// Insert injects the middleware relative to an existing middleware ID.
// Returns error if the original middleware does not exist, or the middleware
// being added already exists.
func (s *SerializeStep) Insert(m SerializeMiddleware, relativeTo string, pos RelativePosition) error {
	found, prev := s.get(relativeTo)
	if found == nil {
		return fmt.Errorf("not found: %s", m.ID())
	}

	if pos == Before {
		if prev == nil { // at the front
			s.head = &decoratedSerializeHandler{s.head, m}
		} else { // somewhere in the middle
			prev.Next = &decoratedSerializeHandler{found, m}
		}
	} else {
		if found.Next == nil { // at the end
			tail := &decoratedSerializeHandler{nil, m}
			s.tail.Next = tail
			s.tail = tail
		} else { // somewhere in the middle
			found.Next = &decoratedSerializeHandler{found.Next, m}
		}
	}

	return nil
}

// Swap removes the middleware by id, replacing it with the new middleware.
// Returns the middleware removed, or error if the middleware to be removed
// doesn't exist.
func (s *SerializeStep) Swap(id string, m SerializeMiddleware) (SerializeMiddleware, error) {
	found, _ := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", m.ID())
	}

	swapped := found.With
	found.With = m
	return swapped, nil
}

// Remove removes the middleware by id. Returns error if the middleware
// doesn't exist.
func (s *SerializeStep) Remove(id string) (SerializeMiddleware, error) {
	found, prev := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", id)
	}

	if s.head == s.tail { // it's the only one
		s.head = nil
		s.tail = nil
	} else if found == s.head { // at the front
		s.head = s.head.Next.(*decoratedSerializeHandler)
	} else if found == s.tail { // at the end
		prev.Next = nil
		s.tail = prev
	} else {
		prev.Next = found.Next // somewhere in the middle
	}

	return found.With, nil
}

// List returns a list of the middleware in the step.
func (s *SerializeStep) List() []string {
	var ids []string
	for h := s.head; h != nil; {
		ids = append(ids, h.With.ID())
		if h.Next == nil {
			break
		}

		// once executed, tail.Next of the list will be set to an
		// *serializeWrapHandler, make sure to check for that
		if hnext, ok := h.Next.(*decoratedSerializeHandler); ok {
			h = hnext
		} else {
			break
		}
	}
	return ids
}

// Clear removes all middleware in the step.
func (s *SerializeStep) Clear() {
	s.head = nil
	s.tail = nil
}

func (s *SerializeStep) get(id string) (found, prev *decoratedSerializeHandler) {
	for h := s.head; h != nil; {
		if h.With.ID() == id {
			found = h
			return
		}
		prev = h
		if h.Next == nil {
			return
		}

		// once executed, tail.Next of the list will be set to an
		// *serializeWrapHandler
		h, _ = h.Next.(*decoratedSerializeHandler)
	}
	return
}

type serializeWrapHandler struct {
	Next Handler
}

var _ SerializeHandler = (*serializeWrapHandler)(nil)

// HandleSerialize implements SerializeHandler, converts types and delegates to underlying
// generic handler.
func (w serializeWrapHandler) HandleSerialize(ctx context.Context, in SerializeInput) (
	out SerializeOutput, metadata Metadata, err error,
) {
	res, metadata, err := w.Next.Handle(ctx, in.Request)
	return SerializeOutput{
		Result: res,
	}, metadata, err
}

type decoratedSerializeHandler struct {
	Next SerializeHandler
	With SerializeMiddleware
}

var _ SerializeHandler = (*decoratedSerializeHandler)(nil)

func (h decoratedSerializeHandler) HandleSerialize(ctx context.Context, in SerializeInput) (
	out SerializeOutput, metadata Metadata, err error,
) {
	return h.With.HandleSerialize(ctx, in, h.Next)
}

// SerializeHandlerFunc provides a wrapper around a function to be used as serializeMiddleware.
type SerializeHandlerFunc func(context.Context, SerializeInput) (SerializeOutput, Metadata, error)

// HandleSerialize calls the wrapped function with the provided arguments.
func (f SerializeHandlerFunc) HandleSerialize(ctx context.Context, in SerializeInput) (SerializeOutput, Metadata, error) {
	return f(ctx, in)
}

var _ SerializeHandler = SerializeHandlerFunc(nil)
