// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from webkit-gir-files
// DO NOT EDIT

use crate::{
    ffi, AutomationSession, CacheModel, GeolocationManager, MemoryPressureSettings, NetworkSession,
    SecurityManager, SecurityOrigin, URISchemeRequest, UserMessage,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "WebKitWebContext")]
    pub struct WebContext(Object<ffi::WebKitWebContext, ffi::WebKitWebContextClass>);

    match fn {
        type_ => || ffi::webkit_web_context_get_type(),
    }
}

impl WebContext {
    #[doc(alias = "webkit_web_context_new")]
    pub fn new() -> WebContext {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::webkit_web_context_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`WebContext`] objects.
    ///
    /// This method returns an instance of [`WebContextBuilder`](crate::builders::WebContextBuilder) which can be used to create [`WebContext`] objects.
    pub fn builder() -> WebContextBuilder {
        WebContextBuilder::new()
    }

    #[doc(alias = "webkit_web_context_add_path_to_sandbox")]
    pub fn add_path_to_sandbox(&self, path: impl AsRef<std::path::Path>, read_only: bool) {
        unsafe {
            ffi::webkit_web_context_add_path_to_sandbox(
                self.to_glib_none().0,
                path.as_ref().to_glib_none().0,
                read_only.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_web_context_get_cache_model")]
    #[doc(alias = "get_cache_model")]
    pub fn cache_model(&self) -> CacheModel {
        unsafe {
            from_glib(ffi::webkit_web_context_get_cache_model(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_get_geolocation_manager")]
    #[doc(alias = "get_geolocation_manager")]
    pub fn geolocation_manager(&self) -> Option<GeolocationManager> {
        unsafe {
            from_glib_none(ffi::webkit_web_context_get_geolocation_manager(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_get_network_session_for_automation")]
    #[doc(alias = "get_network_session_for_automation")]
    pub fn network_session_for_automation(&self) -> Option<NetworkSession> {
        unsafe {
            from_glib_none(ffi::webkit_web_context_get_network_session_for_automation(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_get_security_manager")]
    #[doc(alias = "get_security_manager")]
    pub fn security_manager(&self) -> Option<SecurityManager> {
        unsafe {
            from_glib_none(ffi::webkit_web_context_get_security_manager(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_get_spell_checking_enabled")]
    #[doc(alias = "get_spell_checking_enabled")]
    pub fn is_spell_checking_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_web_context_get_spell_checking_enabled(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_get_spell_checking_languages")]
    #[doc(alias = "get_spell_checking_languages")]
    pub fn spell_checking_languages(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(
                ffi::webkit_web_context_get_spell_checking_languages(self.to_glib_none().0),
            )
        }
    }

    #[doc(alias = "webkit_web_context_get_time_zone_override")]
    #[doc(alias = "get_time_zone_override")]
    #[doc(alias = "time-zone-override")]
    pub fn time_zone_override(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_web_context_get_time_zone_override(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_initialize_notification_permissions")]
    pub fn initialize_notification_permissions(
        &self,
        allowed_origins: &[&SecurityOrigin],
        disallowed_origins: &[&SecurityOrigin],
    ) {
        unsafe {
            ffi::webkit_web_context_initialize_notification_permissions(
                self.to_glib_none().0,
                allowed_origins.to_glib_none().0,
                disallowed_origins.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_is_automation_allowed")]
    pub fn is_automation_allowed(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_web_context_is_automation_allowed(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "webkit_web_context_register_uri_scheme")]
    pub fn register_uri_scheme<P: Fn(&URISchemeRequest) + 'static>(
        &self,
        scheme: &str,
        callback: P,
    ) {
        let callback_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn callback_func<P: Fn(&URISchemeRequest) + 'static>(
            request: *mut ffi::WebKitURISchemeRequest,
            user_data: glib::ffi::gpointer,
        ) {
            let request = from_glib_borrow(request);
            let callback = &*(user_data as *mut P);
            (*callback)(&request)
        }
        let callback = Some(callback_func::<P> as _);
        unsafe extern "C" fn user_data_destroy_func_func<P: Fn(&URISchemeRequest) + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call4 = Some(user_data_destroy_func_func::<P> as _);
        let super_callback0: Box_<P> = callback_data;
        unsafe {
            ffi::webkit_web_context_register_uri_scheme(
                self.to_glib_none().0,
                scheme.to_glib_none().0,
                callback,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call4,
            );
        }
    }

    #[doc(alias = "webkit_web_context_send_message_to_all_extensions")]
    pub fn send_message_to_all_extensions(&self, message: &UserMessage) {
        unsafe {
            ffi::webkit_web_context_send_message_to_all_extensions(
                self.to_glib_none().0,
                message.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_automation_allowed")]
    pub fn set_automation_allowed(&self, allowed: bool) {
        unsafe {
            ffi::webkit_web_context_set_automation_allowed(
                self.to_glib_none().0,
                allowed.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_cache_model")]
    pub fn set_cache_model(&self, cache_model: CacheModel) {
        unsafe {
            ffi::webkit_web_context_set_cache_model(self.to_glib_none().0, cache_model.into_glib());
        }
    }

    #[doc(alias = "webkit_web_context_set_preferred_languages")]
    pub fn set_preferred_languages(&self, languages: &[&str]) {
        unsafe {
            ffi::webkit_web_context_set_preferred_languages(
                self.to_glib_none().0,
                languages.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_spell_checking_enabled")]
    pub fn set_spell_checking_enabled(&self, enabled: bool) {
        unsafe {
            ffi::webkit_web_context_set_spell_checking_enabled(
                self.to_glib_none().0,
                enabled.into_glib(),
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_spell_checking_languages")]
    pub fn set_spell_checking_languages(&self, languages: &[&str]) {
        unsafe {
            ffi::webkit_web_context_set_spell_checking_languages(
                self.to_glib_none().0,
                languages.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_web_process_extensions_directory")]
    pub fn set_web_process_extensions_directory(&self, directory: &str) {
        unsafe {
            ffi::webkit_web_context_set_web_process_extensions_directory(
                self.to_glib_none().0,
                directory.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_set_web_process_extensions_initialization_user_data")]
    pub fn set_web_process_extensions_initialization_user_data(&self, user_data: &glib::Variant) {
        unsafe {
            ffi::webkit_web_context_set_web_process_extensions_initialization_user_data(
                self.to_glib_none().0,
                user_data.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "webkit_web_context_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default() -> Option<WebContext> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::webkit_web_context_get_default()) }
    }

    #[doc(alias = "automation-started")]
    pub fn connect_automation_started<F: Fn(&Self, &AutomationSession) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn automation_started_trampoline<
            F: Fn(&WebContext, &AutomationSession) + 'static,
        >(
            this: *mut ffi::WebKitWebContext,
            session: *mut ffi::WebKitAutomationSession,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(session))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"automation-started".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    automation_started_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "initialize-notification-permissions")]
    pub fn connect_initialize_notification_permissions<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn initialize_notification_permissions_trampoline<
            F: Fn(&WebContext) + 'static,
        >(
            this: *mut ffi::WebKitWebContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"initialize-notification-permissions".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    initialize_notification_permissions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "initialize-web-process-extensions")]
    pub fn connect_initialize_web_process_extensions<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn initialize_web_process_extensions_trampoline<
            F: Fn(&WebContext) + 'static,
        >(
            this: *mut ffi::WebKitWebContext,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"initialize-web-process-extensions".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    initialize_web_process_extensions_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "user-message-received")]
    pub fn connect_user_message_received<F: Fn(&Self, &UserMessage) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn user_message_received_trampoline<
            F: Fn(&WebContext, &UserMessage) -> bool + 'static,
        >(
            this: *mut ffi::WebKitWebContext,
            message: *mut ffi::WebKitUserMessage,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message)).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"user-message-received".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    user_message_received_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for WebContext {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`WebContext`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct WebContextBuilder {
    builder: glib::object::ObjectBuilder<'static, WebContext>,
}

impl WebContextBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn memory_pressure_settings(
        self,
        memory_pressure_settings: &MemoryPressureSettings,
    ) -> Self {
        Self {
            builder: self
                .builder
                .property("memory-pressure-settings", memory_pressure_settings),
        }
    }

    pub fn time_zone_override(self, time_zone_override: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("time-zone-override", time_zone_override.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`WebContext`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> WebContext {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
