// This file was generated by gir (https://github.com/gtk-rs/gir)
// from 
// from ../gir-files-gstreamer
// from ../gir-files-gtk
// DO NOT EDIT

use crate::{ffi,Timeline};
use glib::{prelude::*,signal::{connect_raw, SignalHandlerId},translate::*};
use std::{boxed::Box as Box_};

glib::wrapper! {
    #[doc(alias = "ClapperMediaItem")]
    pub struct MediaItem(Object<ffi::ClapperMediaItem, ffi::ClapperMediaItemClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::clapper_media_item_get_type(),
    }
}

impl MediaItem {
    #[doc(alias = "clapper_media_item_new")]
    pub fn new(uri: &str) -> MediaItem {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::clapper_media_item_new(uri.to_glib_none().0))
        }
    }

    #[cfg(feature = "v0_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_8")))]
    #[doc(alias = "clapper_media_item_new_cached")]
    pub fn new_cached(uri: &str, location: Option<impl AsRef<std::path::Path>>) -> MediaItem {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::clapper_media_item_new_cached(uri.to_glib_none().0, location.as_ref().map(|p| p.as_ref()).to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(file: &impl IsA<gio::File>) -> MediaItem {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::clapper_media_item_new_from_file(file.as_ref().to_glib_none().0))
        }
    }

            // rustdoc-stripper-ignore-next
            /// Creates a new builder-pattern struct instance to construct [`MediaItem`] objects.
            ///
            /// This method returns an instance of [`MediaItemBuilder`](crate::builders::MediaItemBuilder) which can be used to create [`MediaItem`] objects.
            pub fn builder() -> MediaItemBuilder {
                MediaItemBuilder::new()
            }
        

    #[doc(alias = "clapper_media_item_get_container_format")]
    #[doc(alias = "get_container_format")]
    #[doc(alias = "container-format")]
    pub fn container_format(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::clapper_media_item_get_container_format(self.to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_get_duration")]
    #[doc(alias = "get_duration")]
    pub fn duration(&self) -> f64 {
        unsafe {
            ffi::clapper_media_item_get_duration(self.to_glib_none().0)
        }
    }

    #[doc(alias = "clapper_media_item_get_id")]
    #[doc(alias = "get_id")]
    pub fn id(&self) -> u32 {
        unsafe {
            ffi::clapper_media_item_get_id(self.to_glib_none().0)
        }
    }

    #[doc(alias = "clapper_media_item_get_suburi")]
    #[doc(alias = "get_suburi")]
    pub fn suburi(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::clapper_media_item_get_suburi(self.to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_get_timeline")]
    #[doc(alias = "get_timeline")]
    pub fn timeline(&self) -> Option<Timeline> {
        unsafe {
            from_glib_none(ffi::clapper_media_item_get_timeline(self.to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::clapper_media_item_get_title(self.to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_get_uri")]
    #[doc(alias = "get_uri")]
    pub fn uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::clapper_media_item_get_uri(self.to_glib_none().0))
        }
    }

    #[doc(alias = "clapper_media_item_set_suburi")]
    #[doc(alias = "suburi")]
    pub fn set_suburi(&self, suburi: &str) {
        unsafe {
            ffi::clapper_media_item_set_suburi(self.to_glib_none().0, suburi.to_glib_none().0);
        }
    }

    #[doc(alias = "container-format")]
    pub fn connect_container_format_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_container_format_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::container-format".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_container_format_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "duration")]
    pub fn connect_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_duration_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::duration".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_duration_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "id")]
    pub fn connect_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_id_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::id".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_id_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "suburi")]
    pub fn connect_suburi_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_suburi_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::suburi".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_suburi_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "timeline")]
    pub fn connect_timeline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_timeline_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::timeline".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_timeline_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&MediaItem) + 'static>(this: *mut ffi::ClapperMediaItem, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, c"notify::title".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(notify_title_trampoline::<F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl Default for MediaItem {
                     fn default() -> Self {
                         glib::object::Object::new::<Self>()
                     }
                 }

// rustdoc-stripper-ignore-next
        /// A [builder-pattern] type to construct [`MediaItem`] objects.
        ///
        /// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MediaItemBuilder {
            builder: glib::object::ObjectBuilder<'static, MediaItem>,
        }

        impl MediaItemBuilder {
        fn new() -> Self {
            Self { builder: glib::object::Object::builder() }
        }

                            #[cfg(feature = "v0_8")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v0_8")))]
    pub fn cache_location(self, cache_location: impl Into<glib::GString>) -> Self {
                            Self { builder: self.builder.property("cache-location", cache_location.into()), }
                        }

                            pub fn suburi(self, suburi: impl Into<glib::GString>) -> Self {
                            Self { builder: self.builder.property("suburi", suburi.into()), }
                        }

                            pub fn uri(self, uri: impl Into<glib::GString>) -> Self {
                            Self { builder: self.builder.property("uri", uri.into()), }
                        }

                            pub fn name(self, name: impl Into<glib::GString>) -> Self {
                            Self { builder: self.builder.property("name", name.into()), }
                        }

                            pub fn parent(self, parent: &impl IsA<gst::Object>) -> Self {
                            Self { builder: self.builder.property("parent", parent.clone().upcast()), }
                        }

    // rustdoc-stripper-ignore-next
    /// Build the [`MediaItem`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> MediaItem {
assert_initialized_main_thread!();
    self.builder.build() }
}
