// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigStackSlice(dest, src []*otlpprofiles.Stack) []*otlpprofiles.Stack {
	var newDest []*otlpprofiles.Stack
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Stack, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigStack()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigStack(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigStack()
		}
	}
	for i := range src {
		CopyOrigStack(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestStackSlice() []*otlpprofiles.Stack {
	orig := make([]*otlpprofiles.Stack, 5)
	orig[0] = NewOrigStack()
	orig[1] = GenTestOrigStack()
	orig[2] = NewOrigStack()
	orig[3] = GenTestOrigStack()
	orig[4] = NewOrigStack()
	return orig
}
