// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolSample = sync.Pool{
		New: func() any {
			return &otlpprofiles.Sample{}
		},
	}
)

func NewOrigSample() *otlpprofiles.Sample {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Sample{}
	}
	return protoPoolSample.Get().(*otlpprofiles.Sample)
}

func DeleteOrigSample(orig *otlpprofiles.Sample, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolSample.Put(orig)
	}
}

func CopyOrigSample(dest, src *otlpprofiles.Sample) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.StackIndex = src.StackIndex
	dest.Values = CopyOrigInt64Slice(dest.Values, src.Values)
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
	dest.LinkIndex = src.LinkIndex
	dest.TimestampsUnixNano = CopyOrigUint64Slice(dest.TimestampsUnixNano, src.TimestampsUnixNano)
}

func GenTestOrigSample() *otlpprofiles.Sample {
	orig := NewOrigSample()
	orig.StackIndex = int32(13)
	orig.Values = GenerateOrigTestInt64Slice()
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	orig.LinkIndex = int32(13)
	orig.TimestampsUnixNano = GenerateOrigTestUint64Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigSample(orig *otlpprofiles.Sample, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.StackIndex != int32(0) {
		dest.WriteObjectField("stackIndex")
		dest.WriteInt32(orig.StackIndex)
	}
	if len(orig.Values) > 0 {
		dest.WriteObjectField("values")
		dest.WriteArrayStart()
		dest.WriteInt64(orig.Values[0])
		for i := 1; i < len(orig.Values); i++ {
			dest.WriteMore()
			dest.WriteInt64(orig.Values[i])
		}
		dest.WriteArrayEnd()
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.LinkIndex != int32(0) {
		dest.WriteObjectField("linkIndex")
		dest.WriteInt32(orig.LinkIndex)
	}
	if len(orig.TimestampsUnixNano) > 0 {
		dest.WriteObjectField("timestampsUnixNano")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.TimestampsUnixNano[0])
		for i := 1; i < len(orig.TimestampsUnixNano); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.TimestampsUnixNano[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigSample unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigSample(orig *otlpprofiles.Sample, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "stackIndex", "stack_index":
			orig.StackIndex = iter.ReadInt32()
		case "values":
			for iter.ReadArray() {
				orig.Values = append(orig.Values, iter.ReadInt64())
			}

		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		case "linkIndex", "link_index":
			orig.LinkIndex = iter.ReadInt32()
		case "timestampsUnixNano", "timestamps_unix_nano":
			for iter.ReadArray() {
				orig.TimestampsUnixNano = append(orig.TimestampsUnixNano, iter.ReadUint64())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigSample(orig *otlpprofiles.Sample) int {
	var n int
	var l int
	_ = l
	if orig.StackIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.StackIndex))
	}
	if len(orig.Values) > 0 {
		l = 0
		for _, e := range orig.Values {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.LinkIndex != 0 {
		n += 1 + proto.Sov(uint64(orig.LinkIndex))
	}
	l = len(orig.TimestampsUnixNano)
	if l > 0 {
		l *= 8
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.StackIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.StackIndex))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.Values)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.Values[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x1a
	}
	if orig.LinkIndex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.LinkIndex))
		pos--
		buf[pos] = 0x20
	}
	l = len(orig.TimestampsUnixNano)
	if l > 0 {
		for i := l - 1; i >= 0; i-- {
			pos -= 8
			binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimestampsUnixNano[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(l*8))
		pos--
		buf[pos] = 0x2a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigSample(orig *otlpprofiles.Sample, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field StackIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.StackIndex = int32(num)
		case 2:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.Values = append(orig.Values, int64(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field Values", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.Values = append(orig.Values, int64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		case 3:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field LinkIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.LinkIndex = int32(num)
		case 5:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				size := length / 8
				orig.TimestampsUnixNano = make([]uint64, size)
				var num uint64
				for i := 0; i < size; i++ {
					num, startPos, err = proto.ConsumeI64(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.TimestampsUnixNano[i] = uint64(num)
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field TimestampsUnixNano", pos-startPos)
				}
			case proto.WireTypeI64:
				var num uint64
				num, pos, err = proto.ConsumeI64(buf, pos)
				if err != nil {
					return err
				}
				orig.TimestampsUnixNano = append(orig.TimestampsUnixNano, uint64(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampsUnixNano", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
