// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExportLogsServiceResponse = sync.Pool{
		New: func() any {
			return &otlpcollectorlogs.ExportLogsServiceResponse{}
		},
	}
)

func NewOrigExportLogsServiceResponse() *otlpcollectorlogs.ExportLogsServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectorlogs.ExportLogsServiceResponse{}
	}
	return protoPoolExportLogsServiceResponse.Get().(*otlpcollectorlogs.ExportLogsServiceResponse)
}

func DeleteOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigExportLogsPartialSuccess(&orig.PartialSuccess, false)

	orig.Reset()
	if nullable {
		protoPoolExportLogsServiceResponse.Put(orig)
	}
}

func CopyOrigExportLogsServiceResponse(dest, src *otlpcollectorlogs.ExportLogsServiceResponse) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigExportLogsPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)
}

func GenTestOrigExportLogsServiceResponse() *otlpcollectorlogs.ExportLogsServiceResponse {
	orig := NewOrigExportLogsServiceResponse()
	orig.PartialSuccess = *GenTestOrigExportLogsPartialSuccess()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	MarshalJSONOrigExportLogsPartialSuccess(&orig.PartialSuccess, dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportResponse unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":
			UnmarshalJSONOrigExportLogsPartialSuccess(&orig.PartialSuccess, iter)
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigExportLogsPartialSuccess(&orig.PartialSuccess)
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func MarshalProtoOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigExportLogsPartialSuccess(&orig.PartialSuccess, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func UnmarshalProtoOrigExportLogsServiceResponse(orig *otlpcollectorlogs.ExportLogsServiceResponse, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigExportLogsPartialSuccess(&orig.PartialSuccess, buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
