/*
 * Copyright Mesa3D Contributors
 * SPDX-License-Identifier: MIT
 *
 * Autogenerated file, do not edit
 */

#pragma once

#include "compiler/nir/nir.h"
#include "compiler/nir/nir_builder.h"

#include "util/u_printf.h"

#ifdef __cplusplus
extern "C" {
#endif
nir_def *
libagx_map_vertex_in_tri_strip(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_xfb_vertex_copy_in_strip(nir_builder *b, nir_def *n, nir_def *id, nir_def *length, nir_def *copy);

nir_def *
libagx_xfb_vertex_offset(nir_builder *b, nir_def *n, nir_def *invocation_base_prim, nir_def *strip_base_prim, nir_def *id_in_strip, nir_def *copy, nir_def *flatshade_first);

nir_def *
libagx_xfb_vertex_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *buffer, nir_def *stride, nir_def *output_offset);

nir_def *
libagx_vertex_id_for_line_loop(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims);

nir_def *
libagx_vertex_id_for_line_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *num_prims);

nir_def *
libagx_vertex_id_for_tri_fan(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_line_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert);

nir_def *
libagx_vertex_id_for_tri_strip_adj(nir_builder *b, nir_def *prim, nir_def *vert, nir_def *num_prims, nir_def *flatshade_first);

nir_def *
libagx_vertex_id_for_tri_adj_class(nir_builder *b, nir_def *mode, nir_def *prim, nir_def *vert, nir_def *nr, nir_def *flatshade_first);

nir_def *
libagx_map_to_line_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_map_to_line_strip_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_map_to_tri_strip_adj(nir_builder *b, nir_def *id);

nir_def *
libagx_load_index_buffer(nir_builder *b, nir_def *p, nir_def *id, nir_def *index_size);

nir_def *
libagx_setup_xfb_buffer(nir_builder *b, nir_def *p, nir_def *i, nir_def *stride, nir_def *max_output_end, nir_def *vertices_per_prim);

void
libagx_write_strip(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *prim_index_offset, nir_def *vertex_offset, nir_def *verts_in_prim, nir_def *info);

void
libagx_pad_index_gs(nir_builder *b, nir_def *index_buffer, nir_def *inv_index_offset, nir_def *nr_indices, nir_def *alloc);

nir_def *
libagx_vertex_output_address(nir_builder *b, nir_def *buffer, nir_def *mask, nir_def *vtx, nir_def *location);

nir_def *
libagx_geometry_input_address(nir_builder *b, nir_def *p, nir_def *vtx, nir_def *location);

nir_def *
libagx_input_vertices(nir_builder *b, nir_def *ia);

nir_def *
libagx_load_xfb_count_address(nir_builder *b, nir_def *p, nir_def *index, nir_def *count_words, nir_def *unrolled_id);

nir_def *
libagx_previous_xfb_primitives(nir_builder *b, nir_def *p, nir_def *static_count, nir_def *count_index, nir_def *count_words, nir_def *prefix_sum, nir_def *unrolled_id);

void
libagx_pre_gs(nir_builder *b, nir_def *p, nir_def *streams, nir_def *buffers_written, nir_def *buffer_to_stream, nir_def *count_index, nir_def *stride, nir_def *output_end, nir_def *static_count, nir_def *invocations, nir_def *vertices_per_prim, nir_def *gs_invocations, nir_def *gs_primitives, nir_def *c_primitives, nir_def *c_invocations);

nir_def *
libagx_tcs_patch_vertices_in(nir_builder *b, nir_def *p);

nir_def *
libagx_tes_patch_vertices_in(nir_builder *b, nir_def *p);

nir_def *
libagx_tcs_unrolled_id(nir_builder *b, nir_def *p, nir_def *wg_id);

nir_def *
libagx_tes_buffer(nir_builder *b, nir_def *p);

nir_def *
libagx_load_tes_index(nir_builder *b, nir_def *p, nir_def *index);

nir_def *
libagx_tcs_in_offset(nir_builder *b, nir_def *vtx, nir_def *location, nir_def *crosslane_vs_out_mask);

nir_def *
libagx_tcs_out_address(nir_builder *b, nir_def *p, nir_def *patch_id, nir_def *vtx_id, nir_def *location, nir_def *nr_patch_out, nir_def *out_patch_size, nir_def *vtx_out_mask);

nir_def *
libagx_tes_patch_id(nir_builder *b, nir_def *p, nir_def *raw_id);

nir_def *
libagx_load_tess_coord(nir_builder *b, nir_def *p, nir_def *raw_id);

nir_def *
libagx_tes_in_address(nir_builder *b, nir_def *p, nir_def *raw_id, nir_def *vtx_id, nir_def *location);

nir_def *
libagx_tess_level_outer_default(nir_builder *b, nir_def *p);

nir_def *
libagx_tess_level_inner_default(nir_builder *b, nir_def *p);

nir_def *
libagx_txs(nir_builder *b, nir_def *ptr, nir_def *lod, nir_def *nr_comps, nir_def *is_buffer, nir_def *is_1d, nir_def *is_2d, nir_def *is_cube, nir_def *is_array);

nir_def *
libagx_texture_samples(nir_builder *b, nir_def *ptr);

nir_def *
libagx_texture_levels(nir_builder *b, nir_def *ptr);

nir_def *
libagx_lower_txf_robustness(nir_builder *b, nir_def *ptr, nir_def *check_lod, nir_def *lod, nir_def *check_min_lod, nir_def *min_lod, nir_def *check_layer, nir_def *layer, nir_def *x);

nir_def *
libagx_twiddle_coordinates(nir_builder *b, nir_def *coord, nir_def *tile_w_px, nir_def *tile_h_px, nir_def *aligned_width_px);

nir_def *
libagx_image_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *sample_idx, nir_def *bytes_per_sample_B, nir_def *is_1d, nir_def *is_msaa, nir_def *is_layered, nir_def *return_index);

nir_def *
libagx_buffer_texel_address(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *bytes_per_pixel_B);

nir_def *
libagx_texture_is_rgb32(nir_builder *b, nir_def *ptr);

nir_def *
libagx_texture_load_rgb32(nir_builder *b, nir_def *ptr, nir_def *coord, nir_def *is_float);

nir_def *
libagx_buffer_texture_offset(nir_builder *b, nir_def *ptr, nir_def *x);

nir_def *
libagx_buffer_image_offset(nir_builder *b, nir_def *ptr, nir_def *x);

#ifdef __cplusplus
} /* extern C */
#endif
