/* parsed class NVA097 */

#include "nvtypes.h"
#include "cla097.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nva097_SET_OBJECT {
    uint32_t class_id;
    uint32_t engine_id;
};

static inline void
__NVA097_SET_OBJECT(uint32_t *val_out, struct nv_nva097_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.class_id < (1ULL << 16));
    val |= st.class_id << 0;
    
    assert(st.engine_id < (1ULL << 5));
    val |= st.engine_id << 16;
    *val_out = val;
}

#define V_NVA097_SET_OBJECT(val, args...) { \
    struct nv_nva097_SET_OBJECT __data = args; \
    __NVA097_SET_OBJECT(&val, __data); \
}

#define VA_NVA097_SET_OBJECT V_NVA097_SET_OBJECT

#define P_NVA097_SET_OBJECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nva097_NO_OPERATION {
    uint32_t v;
};

static inline void
__NVA097_NO_OPERATION(uint32_t *val_out, struct nv_nva097_NO_OPERATION st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_NO_OPERATION(val, args...) { \
    struct nv_nva097_NO_OPERATION __data = { .v = (args) }; \
    __NVA097_NO_OPERATION(&val, __data); \
}

#define VA_NVA097_NO_OPERATION V_NVA097_NO_OPERATION

#define P_NVA097_NO_OPERATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_NO_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_NO_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_NOTIFY_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_NOTIFY_A(uint32_t *val_out, struct nv_nva097_SET_NOTIFY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_NOTIFY_A(val, args...) { \
    struct nv_nva097_SET_NOTIFY_A __data = { .address_upper = (args) }; \
    __NVA097_SET_NOTIFY_A(&val, __data); \
}

#define VA_NVA097_SET_NOTIFY_A V_NVA097_SET_NOTIFY_A

#define P_NVA097_SET_NOTIFY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_NOTIFY_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_NOTIFY_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_NOTIFY_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_NOTIFY_B(uint32_t *val_out, struct nv_nva097_SET_NOTIFY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_NOTIFY_B(val, args...) { \
    struct nv_nva097_SET_NOTIFY_B __data = { .address_lower = (args) }; \
    __NVA097_SET_NOTIFY_B(&val, __data); \
}

#define VA_NVA097_SET_NOTIFY_B V_NVA097_SET_NOTIFY_B

#define P_NVA097_SET_NOTIFY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_NOTIFY_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_NOTIFY_B, nvk_p_ret); \
} while(0)

struct nv_nva097_NOTIFY {
    uint32_t type;
};

static inline void
__NVA097_NOTIFY(uint32_t *val_out, struct nv_nva097_NOTIFY st)
{
    uint32_t val = 0;
    
    val |= st.type;
    *val_out = val;
}

#define V_NVA097_NOTIFY(val, args...) { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVA097_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVA097_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    struct nv_nva097_NOTIFY __data = { .type = (args) }; \
    __NVA097_NOTIFY(&val, __data); \
}

#define VA_NVA097_NOTIFY V_NVA097_NOTIFY

#define P_NVA097_NOTIFY(push, args...) do { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVA097_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVA097_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    uint32_t nvk_p_ret; \
    V_NVA097_NOTIFY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_NOTIFY, nvk_p_ret); \
} while(0)

struct nv_nva097_WAIT_FOR_IDLE {
    uint32_t v;
};

static inline void
__NVA097_WAIT_FOR_IDLE(uint32_t *val_out, struct nv_nva097_WAIT_FOR_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_WAIT_FOR_IDLE(val, args...) { \
    struct nv_nva097_WAIT_FOR_IDLE __data = { .v = (args) }; \
    __NVA097_WAIT_FOR_IDLE(&val, __data); \
}

#define VA_NVA097_WAIT_FOR_IDLE V_NVA097_WAIT_FOR_IDLE

#define P_NVA097_WAIT_FOR_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_WAIT_FOR_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_WAIT_FOR_IDLE, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_MME_INSTRUCTION_RAM_POINTER {
    uint32_t v;
};

static inline void
__NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER(uint32_t *val_out, struct nv_nva097_LOAD_MME_INSTRUCTION_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER(val, args...) { \
    struct nv_nva097_LOAD_MME_INSTRUCTION_RAM_POINTER __data = { .v = (args) }; \
    __NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER(&val, __data); \
}

#define VA_NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER V_NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER

#define P_NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_MME_INSTRUCTION_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_MME_INSTRUCTION_RAM {
    uint32_t v;
};

static inline void
__NVA097_LOAD_MME_INSTRUCTION_RAM(uint32_t *val_out, struct nv_nva097_LOAD_MME_INSTRUCTION_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_MME_INSTRUCTION_RAM(val, args...) { \
    struct nv_nva097_LOAD_MME_INSTRUCTION_RAM __data = { .v = (args) }; \
    __NVA097_LOAD_MME_INSTRUCTION_RAM(&val, __data); \
}

#define VA_NVA097_LOAD_MME_INSTRUCTION_RAM V_NVA097_LOAD_MME_INSTRUCTION_RAM

#define P_NVA097_LOAD_MME_INSTRUCTION_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_MME_INSTRUCTION_RAM(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_MME_INSTRUCTION_RAM, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_MME_START_ADDRESS_RAM_POINTER {
    uint32_t v;
};

static inline void
__NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER(uint32_t *val_out, struct nv_nva097_LOAD_MME_START_ADDRESS_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER(val, args...) { \
    struct nv_nva097_LOAD_MME_START_ADDRESS_RAM_POINTER __data = { .v = (args) }; \
    __NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER(&val, __data); \
}

#define VA_NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER V_NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER

#define P_NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_MME_START_ADDRESS_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_MME_START_ADDRESS_RAM {
    uint32_t v;
};

static inline void
__NVA097_LOAD_MME_START_ADDRESS_RAM(uint32_t *val_out, struct nv_nva097_LOAD_MME_START_ADDRESS_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_MME_START_ADDRESS_RAM(val, args...) { \
    struct nv_nva097_LOAD_MME_START_ADDRESS_RAM __data = { .v = (args) }; \
    __NVA097_LOAD_MME_START_ADDRESS_RAM(&val, __data); \
}

#define VA_NVA097_LOAD_MME_START_ADDRESS_RAM V_NVA097_LOAD_MME_START_ADDRESS_RAM

#define P_NVA097_LOAD_MME_START_ADDRESS_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_MME_START_ADDRESS_RAM(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_MME_START_ADDRESS_RAM, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MME_SHADOW_RAM_CONTROL {
    uint32_t mode;
};

static inline void
__NVA097_SET_MME_SHADOW_RAM_CONTROL(uint32_t *val_out, struct nv_nva097_SET_MME_SHADOW_RAM_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA097_SET_MME_SHADOW_RAM_CONTROL(val, args...) { \
    UNUSED uint32_t MODE_METHOD_TRACK = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    struct nv_nva097_SET_MME_SHADOW_RAM_CONTROL __data = { .mode = (args) }; \
    __NVA097_SET_MME_SHADOW_RAM_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_MME_SHADOW_RAM_CONTROL V_NVA097_SET_MME_SHADOW_RAM_CONTROL

#define P_NVA097_SET_MME_SHADOW_RAM_CONTROL(push, args...) do { \
    UNUSED uint32_t MODE_METHOD_TRACK = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NVA097_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MME_SHADOW_RAM_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MME_SHADOW_RAM_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER {
    uint32_t v;
};

static inline void
__NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER(uint32_t *val_out, struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER(val, args...) { \
    struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER __data = { .v = (args) }; \
    __NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER(&val, __data); \
}

#define VA_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER

#define P_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PEER_SEMAPHORE_RELEASE_OFFSET_UPPER, nvk_p_ret); \
} while(0)

struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET {
    uint32_t v;
};

static inline void
__NVA097_PEER_SEMAPHORE_RELEASE_OFFSET(uint32_t *val_out, struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET(val, args...) { \
    struct nv_nva097_PEER_SEMAPHORE_RELEASE_OFFSET __data = { .v = (args) }; \
    __NVA097_PEER_SEMAPHORE_RELEASE_OFFSET(&val, __data); \
}

#define VA_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET

#define P_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PEER_SEMAPHORE_RELEASE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PEER_SEMAPHORE_RELEASE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_GLOBAL_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_RENDER_ENABLE_A(val, args...) { \
    struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_GLOBAL_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_RENDER_ENABLE_A V_NVA097_SET_GLOBAL_RENDER_ENABLE_A

#define P_NVA097_SET_GLOBAL_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_GLOBAL_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_RENDER_ENABLE_B(val, args...) { \
    struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_GLOBAL_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_RENDER_ENABLE_B V_NVA097_SET_GLOBAL_RENDER_ENABLE_B

#define P_NVA097_SET_GLOBAL_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVA097_SET_GLOBAL_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nva097_SET_GLOBAL_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVA097_SET_GLOBAL_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_RENDER_ENABLE_C V_NVA097_SET_GLOBAL_RENDER_ENABLE_C

#define P_NVA097_SET_GLOBAL_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA097_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SEND_GO_IDLE {
    uint32_t v;
};

static inline void
__NVA097_SEND_GO_IDLE(uint32_t *val_out, struct nv_nva097_SEND_GO_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SEND_GO_IDLE(val, args...) { \
    struct nv_nva097_SEND_GO_IDLE __data = { .v = (args) }; \
    __NVA097_SEND_GO_IDLE(&val, __data); \
}

#define VA_NVA097_SEND_GO_IDLE V_NVA097_SEND_GO_IDLE

#define P_NVA097_SEND_GO_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SEND_GO_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SEND_GO_IDLE, nvk_p_ret); \
} while(0)

struct nv_nva097_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVA097_PM_TRIGGER(uint32_t *val_out, struct nv_nva097_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PM_TRIGGER(val, args...) { \
    struct nv_nva097_PM_TRIGGER __data = { .v = (args) }; \
    __NVA097_PM_TRIGGER(&val, __data); \
}

#define VA_NVA097_PM_TRIGGER V_NVA097_PM_TRIGGER

#define P_NVA097_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nva097_PM_TRIGGER_WFI {
    uint32_t v;
};

static inline void
__NVA097_PM_TRIGGER_WFI(uint32_t *val_out, struct nv_nva097_PM_TRIGGER_WFI st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PM_TRIGGER_WFI(val, args...) { \
    struct nv_nva097_PM_TRIGGER_WFI __data = { .v = (args) }; \
    __NVA097_PM_TRIGGER_WFI(&val, __data); \
}

#define VA_NVA097_PM_TRIGGER_WFI V_NVA097_PM_TRIGGER_WFI

#define P_NVA097_PM_TRIGGER_WFI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PM_TRIGGER_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PM_TRIGGER_WFI, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INSTRUMENTATION_METHOD_HEADER {
    uint32_t v;
};

static inline void
__NVA097_SET_INSTRUMENTATION_METHOD_HEADER(uint32_t *val_out, struct nv_nva097_SET_INSTRUMENTATION_METHOD_HEADER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_INSTRUMENTATION_METHOD_HEADER(val, args...) { \
    struct nv_nva097_SET_INSTRUMENTATION_METHOD_HEADER __data = { .v = (args) }; \
    __NVA097_SET_INSTRUMENTATION_METHOD_HEADER(&val, __data); \
}

#define VA_NVA097_SET_INSTRUMENTATION_METHOD_HEADER V_NVA097_SET_INSTRUMENTATION_METHOD_HEADER

#define P_NVA097_SET_INSTRUMENTATION_METHOD_HEADER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INSTRUMENTATION_METHOD_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INSTRUMENTATION_METHOD_HEADER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INSTRUMENTATION_METHOD_DATA {
    uint32_t v;
};

static inline void
__NVA097_SET_INSTRUMENTATION_METHOD_DATA(uint32_t *val_out, struct nv_nva097_SET_INSTRUMENTATION_METHOD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_INSTRUMENTATION_METHOD_DATA(val, args...) { \
    struct nv_nva097_SET_INSTRUMENTATION_METHOD_DATA __data = { .v = (args) }; \
    __NVA097_SET_INSTRUMENTATION_METHOD_DATA(&val, __data); \
}

#define VA_NVA097_SET_INSTRUMENTATION_METHOD_DATA V_NVA097_SET_INSTRUMENTATION_METHOD_DATA

#define P_NVA097_SET_INSTRUMENTATION_METHOD_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INSTRUMENTATION_METHOD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INSTRUMENTATION_METHOD_DATA, nvk_p_ret); \
} while(0)

struct nv_nva097_LINE_LENGTH_IN {
    uint32_t value;
};

static inline void
__NVA097_LINE_LENGTH_IN(uint32_t *val_out, struct nv_nva097_LINE_LENGTH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA097_LINE_LENGTH_IN(val, args...) { \
    struct nv_nva097_LINE_LENGTH_IN __data = { .value = (args) }; \
    __NVA097_LINE_LENGTH_IN(&val, __data); \
}

#define VA_NVA097_LINE_LENGTH_IN V_NVA097_LINE_LENGTH_IN

#define P_NVA097_LINE_LENGTH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LINE_LENGTH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LINE_LENGTH_IN, nvk_p_ret); \
} while(0)

struct nv_nva097_LINE_COUNT {
    uint32_t value;
};

static inline void
__NVA097_LINE_COUNT(uint32_t *val_out, struct nv_nva097_LINE_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA097_LINE_COUNT(val, args...) { \
    struct nv_nva097_LINE_COUNT __data = { .value = (args) }; \
    __NVA097_LINE_COUNT(&val, __data); \
}

#define VA_NVA097_LINE_COUNT V_NVA097_LINE_COUNT

#define P_NVA097_LINE_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LINE_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LINE_COUNT, nvk_p_ret); \
} while(0)

struct nv_nva097_OFFSET_OUT_UPPER {
    uint32_t value;
};

static inline void
__NVA097_OFFSET_OUT_UPPER(uint32_t *val_out, struct nv_nva097_OFFSET_OUT_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.value < (1ULL << 8));
    val |= st.value << 0;
    *val_out = val;
}

#define V_NVA097_OFFSET_OUT_UPPER(val, args...) { \
    struct nv_nva097_OFFSET_OUT_UPPER __data = { .value = (args) }; \
    __NVA097_OFFSET_OUT_UPPER(&val, __data); \
}

#define VA_NVA097_OFFSET_OUT_UPPER V_NVA097_OFFSET_OUT_UPPER

#define P_NVA097_OFFSET_OUT_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_OFFSET_OUT_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_OFFSET_OUT_UPPER, nvk_p_ret); \
} while(0)

struct nv_nva097_OFFSET_OUT {
    uint32_t value;
};

static inline void
__NVA097_OFFSET_OUT(uint32_t *val_out, struct nv_nva097_OFFSET_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA097_OFFSET_OUT(val, args...) { \
    struct nv_nva097_OFFSET_OUT __data = { .value = (args) }; \
    __NVA097_OFFSET_OUT(&val, __data); \
}

#define VA_NVA097_OFFSET_OUT V_NVA097_OFFSET_OUT

#define P_NVA097_OFFSET_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_OFFSET_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_OFFSET_OUT, nvk_p_ret); \
} while(0)

struct nv_nva097_PITCH_OUT {
    uint32_t value;
};

static inline void
__NVA097_PITCH_OUT(uint32_t *val_out, struct nv_nva097_PITCH_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA097_PITCH_OUT(val, args...) { \
    struct nv_nva097_PITCH_OUT __data = { .value = (args) }; \
    __NVA097_PITCH_OUT(&val, __data); \
}

#define VA_NVA097_PITCH_OUT V_NVA097_PITCH_OUT

#define P_NVA097_PITCH_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PITCH_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PITCH_OUT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
};

static inline void
__NVA097_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nva097_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NVA097_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    struct nv_nva097_SET_DST_BLOCK_SIZE __data = args; \
    __NVA097_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA097_SET_DST_BLOCK_SIZE V_NVA097_SET_DST_BLOCK_SIZE

#define P_NVA097_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVA097_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_WIDTH(uint32_t *val_out, struct nv_nva097_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DST_WIDTH(val, args...) { \
    struct nv_nva097_SET_DST_WIDTH __data = { .v = (args) }; \
    __NVA097_SET_DST_WIDTH(&val, __data); \
}

#define VA_NVA097_SET_DST_WIDTH V_NVA097_SET_DST_WIDTH

#define P_NVA097_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nva097_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DST_HEIGHT(val, args...) { \
    struct nv_nva097_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NVA097_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NVA097_SET_DST_HEIGHT V_NVA097_SET_DST_HEIGHT

#define P_NVA097_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_DEPTH(uint32_t *val_out, struct nv_nva097_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DST_DEPTH(val, args...) { \
    struct nv_nva097_SET_DST_DEPTH __data = { .v = (args) }; \
    __NVA097_SET_DST_DEPTH(&val, __data); \
}

#define VA_NVA097_SET_DST_DEPTH V_NVA097_SET_DST_DEPTH

#define P_NVA097_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_LAYER(uint32_t *val_out, struct nv_nva097_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DST_LAYER(val, args...) { \
    struct nv_nva097_SET_DST_LAYER __data = { .v = (args) }; \
    __NVA097_SET_DST_LAYER(&val, __data); \
}

#define VA_NVA097_SET_DST_LAYER V_NVA097_SET_DST_LAYER

#define P_NVA097_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_ORIGIN_BYTES_X {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_ORIGIN_BYTES_X(uint32_t *val_out, struct nv_nva097_SET_DST_ORIGIN_BYTES_X st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 20));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_DST_ORIGIN_BYTES_X(val, args...) { \
    struct nv_nva097_SET_DST_ORIGIN_BYTES_X __data = { .v = (args) }; \
    __NVA097_SET_DST_ORIGIN_BYTES_X(&val, __data); \
}

#define VA_NVA097_SET_DST_ORIGIN_BYTES_X V_NVA097_SET_DST_ORIGIN_BYTES_X

#define P_NVA097_SET_DST_ORIGIN_BYTES_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_ORIGIN_BYTES_X(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_ORIGIN_BYTES_X, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DST_ORIGIN_SAMPLES_Y {
    uint32_t v;
};

static inline void
__NVA097_SET_DST_ORIGIN_SAMPLES_Y(uint32_t *val_out, struct nv_nva097_SET_DST_ORIGIN_SAMPLES_Y st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_DST_ORIGIN_SAMPLES_Y(val, args...) { \
    struct nv_nva097_SET_DST_ORIGIN_SAMPLES_Y __data = { .v = (args) }; \
    __NVA097_SET_DST_ORIGIN_SAMPLES_Y(&val, __data); \
}

#define VA_NVA097_SET_DST_ORIGIN_SAMPLES_Y V_NVA097_SET_DST_ORIGIN_SAMPLES_Y

#define P_NVA097_SET_DST_ORIGIN_SAMPLES_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DST_ORIGIN_SAMPLES_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DST_ORIGIN_SAMPLES_Y, nvk_p_ret); \
} while(0)

struct nv_nva097_LAUNCH_DMA {
    uint32_t dst_memory_layout;
    uint32_t completion_type;
    uint32_t interrupt_type;
    uint32_t semaphore_struct_size;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t sysmembar_disable;
};

static inline void
__NVA097_LAUNCH_DMA(uint32_t *val_out, struct nv_nva097_LAUNCH_DMA st)
{
    uint32_t val = 0;
    
    assert(st.dst_memory_layout < (1ULL << 1));
    val |= st.dst_memory_layout << 0;
    
    assert(st.completion_type < (1ULL << 2));
    val |= st.completion_type << 4;
    
    assert(st.interrupt_type < (1ULL << 2));
    val |= st.interrupt_type << 8;
    
    assert(st.semaphore_struct_size < (1ULL << 1));
    val |= st.semaphore_struct_size << 12;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 1;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 13;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 2;
    
    assert(st.sysmembar_disable < (1ULL << 1));
    val |= st.sysmembar_disable << 6;
    *val_out = val;
}

#define V_NVA097_LAUNCH_DMA(val, args...) { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA097_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA097_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVA097_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVA097_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVA097_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA097_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVA097_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVA097_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVA097_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA097_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA097_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA097_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA097_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVA097_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVA097_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    struct nv_nva097_LAUNCH_DMA __data = args; \
    __NVA097_LAUNCH_DMA(&val, __data); \
}

#define VA_NVA097_LAUNCH_DMA V_NVA097_LAUNCH_DMA

#define P_NVA097_LAUNCH_DMA(push, args...) do { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVA097_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVA097_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVA097_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVA097_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVA097_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVA097_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVA097_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVA097_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVA097_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA097_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA097_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA097_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA097_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA097_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVA097_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVA097_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_LAUNCH_DMA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LAUNCH_DMA, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_INLINE_DATA {
    uint32_t v;
};

static inline void
__NVA097_LOAD_INLINE_DATA(uint32_t *val_out, struct nv_nva097_LOAD_INLINE_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_INLINE_DATA(val, args...) { \
    struct nv_nva097_LOAD_INLINE_DATA __data = { .v = (args) }; \
    __NVA097_LOAD_INLINE_DATA(&val, __data); \
}

#define VA_NVA097_LOAD_INLINE_DATA V_NVA097_LOAD_INLINE_DATA

#define P_NVA097_LOAD_INLINE_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_INLINE_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_INLINE_DATA, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_I2M_SEMAPHORE_A(uint32_t *val_out, struct nv_nva097_SET_I2M_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SEMAPHORE_A(val, args...) { \
    struct nv_nva097_SET_I2M_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_I2M_SEMAPHORE_A(&val, __data); \
}

#define VA_NVA097_SET_I2M_SEMAPHORE_A V_NVA097_SET_I2M_SEMAPHORE_A

#define P_NVA097_SET_I2M_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_I2M_SEMAPHORE_B(uint32_t *val_out, struct nv_nva097_SET_I2M_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SEMAPHORE_B(val, args...) { \
    struct nv_nva097_SET_I2M_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_I2M_SEMAPHORE_B(&val, __data); \
}

#define VA_NVA097_SET_I2M_SEMAPHORE_B V_NVA097_SET_I2M_SEMAPHORE_B

#define P_NVA097_SET_I2M_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVA097_SET_I2M_SEMAPHORE_C(uint32_t *val_out, struct nv_nva097_SET_I2M_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SEMAPHORE_C(val, args...) { \
    struct nv_nva097_SET_I2M_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVA097_SET_I2M_SEMAPHORE_C(&val, __data); \
}

#define VA_NVA097_SET_I2M_SEMAPHORE_C V_NVA097_SET_I2M_SEMAPHORE_C

#define P_NVA097_SET_I2M_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SPARE_NOOP00 {
    uint32_t v;
};

static inline void
__NVA097_SET_I2M_SPARE_NOOP00(uint32_t *val_out, struct nv_nva097_SET_I2M_SPARE_NOOP00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SPARE_NOOP00(val, args...) { \
    struct nv_nva097_SET_I2M_SPARE_NOOP00 __data = { .v = (args) }; \
    __NVA097_SET_I2M_SPARE_NOOP00(&val, __data); \
}

#define VA_NVA097_SET_I2M_SPARE_NOOP00 V_NVA097_SET_I2M_SPARE_NOOP00

#define P_NVA097_SET_I2M_SPARE_NOOP00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SPARE_NOOP00(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SPARE_NOOP00, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NVA097_SET_I2M_SPARE_NOOP01(uint32_t *val_out, struct nv_nva097_SET_I2M_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SPARE_NOOP01(val, args...) { \
    struct nv_nva097_SET_I2M_SPARE_NOOP01 __data = { .v = (args) }; \
    __NVA097_SET_I2M_SPARE_NOOP01(&val, __data); \
}

#define VA_NVA097_SET_I2M_SPARE_NOOP01 V_NVA097_SET_I2M_SPARE_NOOP01

#define P_NVA097_SET_I2M_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NVA097_SET_I2M_SPARE_NOOP02(uint32_t *val_out, struct nv_nva097_SET_I2M_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SPARE_NOOP02(val, args...) { \
    struct nv_nva097_SET_I2M_SPARE_NOOP02 __data = { .v = (args) }; \
    __NVA097_SET_I2M_SPARE_NOOP02(&val, __data); \
}

#define VA_NVA097_SET_I2M_SPARE_NOOP02 V_NVA097_SET_I2M_SPARE_NOOP02

#define P_NVA097_SET_I2M_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_I2M_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NVA097_SET_I2M_SPARE_NOOP03(uint32_t *val_out, struct nv_nva097_SET_I2M_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_I2M_SPARE_NOOP03(val, args...) { \
    struct nv_nva097_SET_I2M_SPARE_NOOP03 __data = { .v = (args) }; \
    __NVA097_SET_I2M_SPARE_NOOP03(&val, __data); \
}

#define VA_NVA097_SET_I2M_SPARE_NOOP03 V_NVA097_SET_I2M_SPARE_NOOP03

#define P_NVA097_SET_I2M_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_I2M_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_I2M_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nva097_RUN_DS_NOW {
    uint32_t v;
};

static inline void
__NVA097_RUN_DS_NOW(uint32_t *val_out, struct nv_nva097_RUN_DS_NOW st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_RUN_DS_NOW(val, args...) { \
    struct nv_nva097_RUN_DS_NOW __data = { .v = (args) }; \
    __NVA097_RUN_DS_NOW(&val, __data); \
}

#define VA_NVA097_RUN_DS_NOW V_NVA097_RUN_DS_NOW

#define P_NVA097_RUN_DS_NOW(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RUN_DS_NOW(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RUN_DS_NOW, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS {
    uint32_t accumulated_prim_area_threshold;
};

static inline void
__NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS(uint32_t *val_out, struct nv_nva097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS st)
{
    uint32_t val = 0;
    
    assert(st.accumulated_prim_area_threshold < (1ULL << 5));
    val |= st.accumulated_prim_area_threshold << 0;
    *val_out = val;
}

#define V_NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS(val, args...) { \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__16 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__32 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__64 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__64; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__128 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__128; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__256 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__256; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__512 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__512; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__1024 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1024; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__2048 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2048; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__4096 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4096; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__8192 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__8192; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__16384 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16384; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__32768 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32768; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__65536 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__65536; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__131072 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__131072; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__262144 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__262144; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__524288 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__524288; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__1048576 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1048576; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__2097152 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2097152; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__4194304 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4194304; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS; \
    struct nv_nva097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS __data = { .accumulated_prim_area_threshold = (args) }; \
    __NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS(&val, __data); \
}

#define VA_NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS V_NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS

#define P_NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS(push, args...) do { \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_INSTANTANEOUS; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__16 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__32 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__64 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__64; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__128 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__128; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__256 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__256; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__512 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__512; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__1024 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1024; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__2048 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2048; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__4096 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4096; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__8192 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__8192; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__16384 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__16384; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__32768 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__32768; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__65536 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__65536; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__131072 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__131072; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__262144 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__262144; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__524288 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__524288; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__1048576 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__1048576; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__2097152 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__2097152; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD__4194304 = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD__4194304; \
    UNUSED uint32_t ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS = NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS_ACCUMULATED_PRIM_AREA_THRESHOLD_LATEZ_ALWAYS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_OPPORTUNISTIC_EARLY_Z_HYSTERESIS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RASTER_PIPE_SYNC_CONTROL {
    uint32_t prim_area_threshold;
    uint32_t enable;
};

static inline void
__NVA097_SET_RASTER_PIPE_SYNC_CONTROL(uint32_t *val_out, struct nv_nva097_SET_RASTER_PIPE_SYNC_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.prim_area_threshold < (1ULL << 22));
    val |= st.prim_area_threshold << 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 24;
    *val_out = val;
}

#define V_NVA097_SET_RASTER_PIPE_SYNC_CONTROL(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_TRUE; \
    struct nv_nva097_SET_RASTER_PIPE_SYNC_CONTROL __data = args; \
    __NVA097_SET_RASTER_PIPE_SYNC_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_RASTER_PIPE_SYNC_CONTROL V_NVA097_SET_RASTER_PIPE_SYNC_CONTROL

#define P_NVA097_SET_RASTER_PIPE_SYNC_CONTROL(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_RASTER_PIPE_SYNC_CONTROL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RASTER_PIPE_SYNC_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RASTER_PIPE_SYNC_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALIASED_LINE_WIDTH_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_ALIASED_LINE_WIDTH_ENABLE(uint32_t *val_out, struct nv_nva097_SET_ALIASED_LINE_WIDTH_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALIASED_LINE_WIDTH_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_ALIASED_LINE_WIDTH_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_ALIASED_LINE_WIDTH_ENABLE_V_TRUE; \
    struct nv_nva097_SET_ALIASED_LINE_WIDTH_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_ALIASED_LINE_WIDTH_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_ALIASED_LINE_WIDTH_ENABLE V_NVA097_SET_ALIASED_LINE_WIDTH_ENABLE

#define P_NVA097_SET_ALIASED_LINE_WIDTH_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_ALIASED_LINE_WIDTH_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_ALIASED_LINE_WIDTH_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALIASED_LINE_WIDTH_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALIASED_LINE_WIDTH_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_API_MANDATED_EARLY_Z {
    uint32_t enable;
};

static inline void
__NVA097_SET_API_MANDATED_EARLY_Z(uint32_t *val_out, struct nv_nva097_SET_API_MANDATED_EARLY_Z st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_API_MANDATED_EARLY_Z(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_API_MANDATED_EARLY_Z_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_API_MANDATED_EARLY_Z_ENABLE_TRUE; \
    struct nv_nva097_SET_API_MANDATED_EARLY_Z __data = { .enable = (args) }; \
    __NVA097_SET_API_MANDATED_EARLY_Z(&val, __data); \
}

#define VA_NVA097_SET_API_MANDATED_EARLY_Z V_NVA097_SET_API_MANDATED_EARLY_Z

#define P_NVA097_SET_API_MANDATED_EARLY_Z(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_API_MANDATED_EARLY_Z_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_API_MANDATED_EARLY_Z_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_API_MANDATED_EARLY_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_API_MANDATED_EARLY_Z, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GS_DM_FIFO {
    uint32_t size_raster_on;
    uint32_t size_raster_off;
    uint32_t spill_enabled;
};

static inline void
__NVA097_SET_GS_DM_FIFO(uint32_t *val_out, struct nv_nva097_SET_GS_DM_FIFO st)
{
    uint32_t val = 0;
    
    assert(st.size_raster_on < (1ULL << 13));
    val |= st.size_raster_on << 0;
    
    assert(st.size_raster_off < (1ULL << 13));
    val |= st.size_raster_off << 16;
    
    assert(st.spill_enabled < (1ULL << 1));
    val |= st.spill_enabled << 31;
    *val_out = val;
}

#define V_NVA097_SET_GS_DM_FIFO(val, args...) { \
    UNUSED uint32_t SPILL_ENABLED_FALSE = NVA097_SET_GS_DM_FIFO_SPILL_ENABLED_FALSE; \
    UNUSED uint32_t SPILL_ENABLED_TRUE = NVA097_SET_GS_DM_FIFO_SPILL_ENABLED_TRUE; \
    struct nv_nva097_SET_GS_DM_FIFO __data = args; \
    __NVA097_SET_GS_DM_FIFO(&val, __data); \
}

#define VA_NVA097_SET_GS_DM_FIFO V_NVA097_SET_GS_DM_FIFO

#define P_NVA097_SET_GS_DM_FIFO(push, args...) do { \
    UNUSED uint32_t SPILL_ENABLED_FALSE = NVA097_SET_GS_DM_FIFO_SPILL_ENABLED_FALSE; \
    UNUSED uint32_t SPILL_ENABLED_TRUE = NVA097_SET_GS_DM_FIFO_SPILL_ENABLED_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GS_DM_FIFO(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GS_DM_FIFO, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS {
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS(val, args...) { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS __data = { .policy = (args) }; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS(push, args...) do { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_PREFETCH_READ_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_SHADER_CACHES {
    uint32_t instruction;
    uint32_t data;
    uint32_t constant;
    uint32_t locks;
    uint32_t flush_data;
};

static inline void
__NVA097_INVALIDATE_SHADER_CACHES(uint32_t *val_out, struct nv_nva097_INVALIDATE_SHADER_CACHES st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.data < (1ULL << 1));
    val |= st.data << 4;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    
    assert(st.locks < (1ULL << 1));
    val |= st.locks << 1;
    
    assert(st.flush_data < (1ULL << 1));
    val |= st.flush_data << 2;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_SHADER_CACHES(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVA097_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVA097_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVA097_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVA097_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NVA097_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NVA097_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    struct nv_nva097_INVALIDATE_SHADER_CACHES __data = args; \
    __NVA097_INVALIDATE_SHADER_CACHES(&val, __data); \
}

#define VA_NVA097_INVALIDATE_SHADER_CACHES V_NVA097_INVALIDATE_SHADER_CACHES

#define P_NVA097_INVALIDATE_SHADER_CACHES(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVA097_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVA097_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVA097_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVA097_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NVA097_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NVA097_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_SHADER_CACHES(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_SHADER_CACHES, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_VERTEX3F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_VERTEX3F(uint32_t *val_out, struct nv_nva097_SET_VAB_VERTEX3F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_VERTEX3F(val, args...) { \
    struct nv_nva097_SET_VAB_VERTEX3F __data = { .v = (args) }; \
    __NVA097_SET_VAB_VERTEX3F(&val, __data); \
}

#define VA_NVA097_SET_VAB_VERTEX3F(i) V_NVA097_SET_VAB_VERTEX3F

#define P_NVA097_SET_VAB_VERTEX3F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_VERTEX3F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_VERTEX3F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_VERTEX4F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_VERTEX4F(uint32_t *val_out, struct nv_nva097_SET_VAB_VERTEX4F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_VERTEX4F(val, args...) { \
    struct nv_nva097_SET_VAB_VERTEX4F __data = { .v = (args) }; \
    __NVA097_SET_VAB_VERTEX4F(&val, __data); \
}

#define VA_NVA097_SET_VAB_VERTEX4F(i) V_NVA097_SET_VAB_VERTEX4F

#define P_NVA097_SET_VAB_VERTEX4F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_VERTEX4F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_VERTEX4F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_NORMAL3F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_NORMAL3F(uint32_t *val_out, struct nv_nva097_SET_VAB_NORMAL3F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_NORMAL3F(val, args...) { \
    struct nv_nva097_SET_VAB_NORMAL3F __data = { .v = (args) }; \
    __NVA097_SET_VAB_NORMAL3F(&val, __data); \
}

#define VA_NVA097_SET_VAB_NORMAL3F(i) V_NVA097_SET_VAB_NORMAL3F

#define P_NVA097_SET_VAB_NORMAL3F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_NORMAL3F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_NORMAL3F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_COLOR3F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_COLOR3F(uint32_t *val_out, struct nv_nva097_SET_VAB_COLOR3F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_COLOR3F(val, args...) { \
    struct nv_nva097_SET_VAB_COLOR3F __data = { .v = (args) }; \
    __NVA097_SET_VAB_COLOR3F(&val, __data); \
}

#define VA_NVA097_SET_VAB_COLOR3F(i) V_NVA097_SET_VAB_COLOR3F

#define P_NVA097_SET_VAB_COLOR3F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_COLOR3F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_COLOR3F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_COLOR4F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_COLOR4F(uint32_t *val_out, struct nv_nva097_SET_VAB_COLOR4F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_COLOR4F(val, args...) { \
    struct nv_nva097_SET_VAB_COLOR4F __data = { .v = (args) }; \
    __NVA097_SET_VAB_COLOR4F(&val, __data); \
}

#define VA_NVA097_SET_VAB_COLOR4F(i) V_NVA097_SET_VAB_COLOR4F

#define P_NVA097_SET_VAB_COLOR4F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_COLOR4F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_COLOR4F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_COLOR4UB {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_COLOR4UB(uint32_t *val_out, struct nv_nva097_SET_VAB_COLOR4UB st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_COLOR4UB(val, args...) { \
    struct nv_nva097_SET_VAB_COLOR4UB __data = { .v = (args) }; \
    __NVA097_SET_VAB_COLOR4UB(&val, __data); \
}

#define VA_NVA097_SET_VAB_COLOR4UB(i) V_NVA097_SET_VAB_COLOR4UB

#define P_NVA097_SET_VAB_COLOR4UB(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_COLOR4UB(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_COLOR4UB(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_TEX_COORD1F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_TEX_COORD1F(uint32_t *val_out, struct nv_nva097_SET_VAB_TEX_COORD1F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_TEX_COORD1F(val, args...) { \
    struct nv_nva097_SET_VAB_TEX_COORD1F __data = { .v = (args) }; \
    __NVA097_SET_VAB_TEX_COORD1F(&val, __data); \
}

#define VA_NVA097_SET_VAB_TEX_COORD1F(i) V_NVA097_SET_VAB_TEX_COORD1F

#define P_NVA097_SET_VAB_TEX_COORD1F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_TEX_COORD1F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_TEX_COORD1F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_TEX_COORD2F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_TEX_COORD2F(uint32_t *val_out, struct nv_nva097_SET_VAB_TEX_COORD2F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_TEX_COORD2F(val, args...) { \
    struct nv_nva097_SET_VAB_TEX_COORD2F __data = { .v = (args) }; \
    __NVA097_SET_VAB_TEX_COORD2F(&val, __data); \
}

#define VA_NVA097_SET_VAB_TEX_COORD2F(i) V_NVA097_SET_VAB_TEX_COORD2F

#define P_NVA097_SET_VAB_TEX_COORD2F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_TEX_COORD2F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_TEX_COORD2F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_TEX_COORD3F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_TEX_COORD3F(uint32_t *val_out, struct nv_nva097_SET_VAB_TEX_COORD3F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_TEX_COORD3F(val, args...) { \
    struct nv_nva097_SET_VAB_TEX_COORD3F __data = { .v = (args) }; \
    __NVA097_SET_VAB_TEX_COORD3F(&val, __data); \
}

#define VA_NVA097_SET_VAB_TEX_COORD3F(i) V_NVA097_SET_VAB_TEX_COORD3F

#define P_NVA097_SET_VAB_TEX_COORD3F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_TEX_COORD3F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_TEX_COORD3F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_TEX_COORD4F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_TEX_COORD4F(uint32_t *val_out, struct nv_nva097_SET_VAB_TEX_COORD4F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_TEX_COORD4F(val, args...) { \
    struct nv_nva097_SET_VAB_TEX_COORD4F __data = { .v = (args) }; \
    __NVA097_SET_VAB_TEX_COORD4F(&val, __data); \
}

#define VA_NVA097_SET_VAB_TEX_COORD4F(i) V_NVA097_SET_VAB_TEX_COORD4F

#define P_NVA097_SET_VAB_TEX_COORD4F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_TEX_COORD4F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_TEX_COORD4F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TASK_CIRCULAR_BUFFER_THROTTLE {
    uint32_t task_count;
};

static inline void
__NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE(uint32_t *val_out, struct nv_nva097_SET_TASK_CIRCULAR_BUFFER_THROTTLE st)
{
    uint32_t val = 0;
    
    assert(st.task_count < (1ULL << 22));
    val |= st.task_count << 0;
    *val_out = val;
}

#define V_NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE(val, args...) { \
    struct nv_nva097_SET_TASK_CIRCULAR_BUFFER_THROTTLE __data = { .task_count = (args) }; \
    __NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE(&val, __data); \
}

#define VA_NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE V_NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE

#define P_NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TASK_CIRCULAR_BUFFER_THROTTLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE {
    uint32_t prim_area;
};

static inline void
__NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE(uint32_t *val_out, struct nv_nva097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE st)
{
    uint32_t val = 0;
    
    assert(st.prim_area < (1ULL << 22));
    val |= st.prim_area << 0;
    *val_out = val;
}

#define V_NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE(val, args...) { \
    struct nv_nva097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE __data = { .prim_area = (args) }; \
    __NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE(&val, __data); \
}

#define VA_NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE V_NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE

#define P_NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PRIM_CIRCULAR_BUFFER_THROTTLE, nvk_p_ret); \
} while(0)

struct nv_nva097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE {
    uint32_t v;
};

static inline void
__NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(uint32_t *val_out, struct nv_nva097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(val, args...) { \
    struct nv_nva097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE __data = { .v = (args) }; \
    __NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(&val, __data); \
}

#define VA_NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE V_NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE

#define P_NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_FLUSH_AND_INVALIDATE_ROP_MINI_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_ID_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
};

static inline void
__NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_ID_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH_ONE_GOB; \
    struct nv_nva097_SET_SURFACE_CLIP_ID_BLOCK_SIZE __data = args; \
    __NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE V_NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE

#define P_NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE_DEPTH_ONE_GOB; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_ID_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_CIRCULAR_BUFFER_SIZE {
    uint32_t cache_lines_per_sm;
};

static inline void
__NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE(uint32_t *val_out, struct nv_nva097_SET_ALPHA_CIRCULAR_BUFFER_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.cache_lines_per_sm < (1ULL << 10));
    val |= st.cache_lines_per_sm << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE(val, args...) { \
    struct nv_nva097_SET_ALPHA_CIRCULAR_BUFFER_SIZE __data = { .cache_lines_per_sm = (args) }; \
    __NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE V_NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE

#define P_NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_CIRCULAR_BUFFER_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_ROP_BYPASS {
    uint32_t enable;
    uint32_t no_stall;
    uint32_t cull_everything;
    uint32_t threshold;
};

static inline void
__NVA097_SET_ZCULL_ROP_BYPASS(uint32_t *val_out, struct nv_nva097_SET_ZCULL_ROP_BYPASS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.no_stall < (1ULL << 1));
    val |= st.no_stall << 4;
    
    assert(st.cull_everything < (1ULL << 1));
    val |= st.cull_everything << 8;
    
    assert(st.threshold < (1ULL << 4));
    val |= st.threshold << 12;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_ROP_BYPASS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_ENABLE_TRUE; \
    UNUSED uint32_t NO_STALL_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE; \
    UNUSED uint32_t NO_STALL_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE; \
    UNUSED uint32_t CULL_EVERYTHING_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE; \
    UNUSED uint32_t CULL_EVERYTHING_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE; \
    struct nv_nva097_SET_ZCULL_ROP_BYPASS __data = args; \
    __NVA097_SET_ZCULL_ROP_BYPASS(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_ROP_BYPASS V_NVA097_SET_ZCULL_ROP_BYPASS

#define P_NVA097_SET_ZCULL_ROP_BYPASS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_ENABLE_TRUE; \
    UNUSED uint32_t NO_STALL_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_NO_STALL_FALSE; \
    UNUSED uint32_t NO_STALL_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_NO_STALL_TRUE; \
    UNUSED uint32_t CULL_EVERYTHING_FALSE = NVA097_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_FALSE; \
    UNUSED uint32_t CULL_EVERYTHING_TRUE = NVA097_SET_ZCULL_ROP_BYPASS_CULL_EVERYTHING_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_ROP_BYPASS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_ROP_BYPASS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_SUBREGION {
    uint32_t enable;
    uint32_t normalized_aliquots;
};

static inline void
__NVA097_SET_ZCULL_SUBREGION(uint32_t *val_out, struct nv_nva097_SET_ZCULL_SUBREGION st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.normalized_aliquots < (1ULL << 24));
    val |= st.normalized_aliquots << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_SUBREGION(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_ENABLE_TRUE; \
    struct nv_nva097_SET_ZCULL_SUBREGION __data = args; \
    __NVA097_SET_ZCULL_SUBREGION(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_SUBREGION V_NVA097_SET_ZCULL_SUBREGION

#define P_NVA097_SET_ZCULL_SUBREGION(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_SUBREGION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_SUBREGION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RASTER_BOUNDING_BOX {
    uint32_t mode;
    uint32_t pad;
};

static inline void
__NVA097_SET_RASTER_BOUNDING_BOX(uint32_t *val_out, struct nv_nva097_SET_RASTER_BOUNDING_BOX st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 1));
    val |= st.mode << 0;
    
    assert(st.pad < (1ULL << 8));
    val |= st.pad << 4;
    *val_out = val;
}

#define V_NVA097_SET_RASTER_BOUNDING_BOX(val, args...) { \
    UNUSED uint32_t MODE_BOUNDING_BOX = NVA097_SET_RASTER_BOUNDING_BOX_MODE_BOUNDING_BOX; \
    UNUSED uint32_t MODE_FULL_VIEWPORT = NVA097_SET_RASTER_BOUNDING_BOX_MODE_FULL_VIEWPORT; \
    struct nv_nva097_SET_RASTER_BOUNDING_BOX __data = args; \
    __NVA097_SET_RASTER_BOUNDING_BOX(&val, __data); \
}

#define VA_NVA097_SET_RASTER_BOUNDING_BOX V_NVA097_SET_RASTER_BOUNDING_BOX

#define P_NVA097_SET_RASTER_BOUNDING_BOX(push, args...) do { \
    UNUSED uint32_t MODE_BOUNDING_BOX = NVA097_SET_RASTER_BOUNDING_BOX_MODE_BOUNDING_BOX; \
    UNUSED uint32_t MODE_FULL_VIEWPORT = NVA097_SET_RASTER_BOUNDING_BOX_MODE_FULL_VIEWPORT; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RASTER_BOUNDING_BOX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RASTER_BOUNDING_BOX, nvk_p_ret); \
} while(0)

struct nv_nva097_PEER_SEMAPHORE_RELEASE {
    uint32_t v;
};

static inline void
__NVA097_PEER_SEMAPHORE_RELEASE(uint32_t *val_out, struct nv_nva097_PEER_SEMAPHORE_RELEASE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PEER_SEMAPHORE_RELEASE(val, args...) { \
    struct nv_nva097_PEER_SEMAPHORE_RELEASE __data = { .v = (args) }; \
    __NVA097_PEER_SEMAPHORE_RELEASE(&val, __data); \
}

#define VA_NVA097_PEER_SEMAPHORE_RELEASE V_NVA097_PEER_SEMAPHORE_RELEASE

#define P_NVA097_PEER_SEMAPHORE_RELEASE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PEER_SEMAPHORE_RELEASE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PEER_SEMAPHORE_RELEASE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_SUBREGION_ALLOCATION {
    uint32_t subregion_id;
    uint32_t aliquots;
    uint32_t format;
};

static inline void
__NVA097_SET_ZCULL_SUBREGION_ALLOCATION(uint32_t *val_out, struct nv_nva097_SET_ZCULL_SUBREGION_ALLOCATION st)
{
    uint32_t val = 0;
    
    assert(st.subregion_id < (1ULL << 8));
    val |= st.subregion_id << 0;
    
    assert(st.aliquots < (1ULL << 16));
    val |= st.aliquots << 8;
    
    assert(st.format < (1ULL << 4));
    val |= st.format << 24;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_SUBREGION_ALLOCATION(val, args...) { \
    UNUSED uint32_t FORMAT_Z_16X16X2_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4; \
    UNUSED uint32_t FORMAT_ZS_16X16_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4; \
    UNUSED uint32_t FORMAT_Z_16X16_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2; \
    UNUSED uint32_t FORMAT_Z_16X16_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4; \
    UNUSED uint32_t FORMAT_Z_16X8_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4; \
    UNUSED uint32_t FORMAT_Z_8X8_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2; \
    UNUSED uint32_t FORMAT_Z_8X8_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4; \
    UNUSED uint32_t FORMAT_Z_16X16_4X8 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8; \
    UNUSED uint32_t FORMAT_Z_4X8_2X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2; \
    UNUSED uint32_t FORMAT_ZS_16X8_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2; \
    UNUSED uint32_t FORMAT_ZS_16X8_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4; \
    UNUSED uint32_t FORMAT_ZS_8X8_2X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2; \
    UNUSED uint32_t FORMAT_Z_4X8_1X1 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1; \
    UNUSED uint32_t FORMAT_NONE = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE; \
    struct nv_nva097_SET_ZCULL_SUBREGION_ALLOCATION __data = args; \
    __NVA097_SET_ZCULL_SUBREGION_ALLOCATION(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_SUBREGION_ALLOCATION V_NVA097_SET_ZCULL_SUBREGION_ALLOCATION

#define P_NVA097_SET_ZCULL_SUBREGION_ALLOCATION(push, args...) do { \
    UNUSED uint32_t FORMAT_Z_16X16X2_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16X2_4X4; \
    UNUSED uint32_t FORMAT_ZS_16X16_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X16_4X4; \
    UNUSED uint32_t FORMAT_Z_16X16_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X2; \
    UNUSED uint32_t FORMAT_Z_16X16_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_2X4; \
    UNUSED uint32_t FORMAT_Z_16X8_4X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X8_4X4; \
    UNUSED uint32_t FORMAT_Z_8X8_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_4X2; \
    UNUSED uint32_t FORMAT_Z_8X8_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_8X8_2X4; \
    UNUSED uint32_t FORMAT_Z_16X16_4X8 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_16X16_4X8; \
    UNUSED uint32_t FORMAT_Z_4X8_2X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_2X2; \
    UNUSED uint32_t FORMAT_ZS_16X8_4X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_4X2; \
    UNUSED uint32_t FORMAT_ZS_16X8_2X4 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_16X8_2X4; \
    UNUSED uint32_t FORMAT_ZS_8X8_2X2 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_ZS_8X8_2X2; \
    UNUSED uint32_t FORMAT_Z_4X8_1X1 = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_Z_4X8_1X1; \
    UNUSED uint32_t FORMAT_NONE = NVA097_SET_ZCULL_SUBREGION_ALLOCATION_FORMAT_NONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_SUBREGION_ALLOCATION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_SUBREGION_ALLOCATION, nvk_p_ret); \
} while(0)

struct nv_nva097_ASSIGN_ZCULL_SUBREGIONS {
    uint32_t algorithm;
};

static inline void
__NVA097_ASSIGN_ZCULL_SUBREGIONS(uint32_t *val_out, struct nv_nva097_ASSIGN_ZCULL_SUBREGIONS st)
{
    uint32_t val = 0;
    
    assert(st.algorithm < (1ULL << 2));
    val |= st.algorithm << 0;
    *val_out = val;
}

#define V_NVA097_ASSIGN_ZCULL_SUBREGIONS(val, args...) { \
    UNUSED uint32_t ALGORITHM_Static = NVA097_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static; \
    UNUSED uint32_t ALGORITHM_Adaptive = NVA097_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive; \
    struct nv_nva097_ASSIGN_ZCULL_SUBREGIONS __data = { .algorithm = (args) }; \
    __NVA097_ASSIGN_ZCULL_SUBREGIONS(&val, __data); \
}

#define VA_NVA097_ASSIGN_ZCULL_SUBREGIONS V_NVA097_ASSIGN_ZCULL_SUBREGIONS

#define P_NVA097_ASSIGN_ZCULL_SUBREGIONS(push, args...) do { \
    UNUSED uint32_t ALGORITHM_Static = NVA097_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Static; \
    UNUSED uint32_t ALGORITHM_Adaptive = NVA097_ASSIGN_ZCULL_SUBREGIONS_ALGORITHM_Adaptive; \
    uint32_t nvk_p_ret; \
    V_NVA097_ASSIGN_ZCULL_SUBREGIONS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_ASSIGN_ZCULL_SUBREGIONS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE {
    uint32_t enable;
    uint32_t qualify_by_anti_alias_enable;
};

static inline void
__NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE(uint32_t *val_out, struct nv_nva097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.qualify_by_anti_alias_enable < (1ULL << 1));
    val |= st.qualify_by_anti_alias_enable << 1;
    *val_out = val;
}

#define V_NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_TRUE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE; \
    struct nv_nva097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE __data = args; \
    __NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE(&val, __data); \
}

#define VA_NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE V_NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE

#define P_NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_ENABLE_TRUE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE = NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PS_OUTPUT_SAMPLE_MASK_USAGE, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_ZERO_INDEX {
    uint32_t count;
};

static inline void
__NVA097_DRAW_ZERO_INDEX(uint32_t *val_out, struct nv_nva097_DRAW_ZERO_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVA097_DRAW_ZERO_INDEX(val, args...) { \
    struct nv_nva097_DRAW_ZERO_INDEX __data = { .count = (args) }; \
    __NVA097_DRAW_ZERO_INDEX(&val, __data); \
}

#define VA_NVA097_DRAW_ZERO_INDEX V_NVA097_DRAW_ZERO_INDEX

#define P_NVA097_DRAW_ZERO_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_ZERO_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_ZERO_INDEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L1_CONFIGURATION {
    uint32_t directly_addressable_memory;
};

static inline void
__NVA097_SET_L1_CONFIGURATION(uint32_t *val_out, struct nv_nva097_SET_L1_CONFIGURATION st)
{
    uint32_t val = 0;
    
    assert(st.directly_addressable_memory < (1ULL << 3));
    val |= st.directly_addressable_memory << 0;
    *val_out = val;
}

#define V_NVA097_SET_L1_CONFIGURATION(val, args...) { \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB = NVA097_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB = NVA097_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB; \
    struct nv_nva097_SET_L1_CONFIGURATION __data = { .directly_addressable_memory = (args) }; \
    __NVA097_SET_L1_CONFIGURATION(&val, __data); \
}

#define VA_NVA097_SET_L1_CONFIGURATION V_NVA097_SET_L1_CONFIGURATION

#define P_NVA097_SET_L1_CONFIGURATION(push, args...) do { \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB = NVA097_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB; \
    UNUSED uint32_t DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB = NVA097_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L1_CONFIGURATION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L1_CONFIGURATION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RENDER_ENABLE_CONTROL {
    uint32_t conditional_load_constant_buffer;
};

static inline void
__NVA097_SET_RENDER_ENABLE_CONTROL(uint32_t *val_out, struct nv_nva097_SET_RENDER_ENABLE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.conditional_load_constant_buffer < (1ULL << 1));
    val |= st.conditional_load_constant_buffer << 0;
    *val_out = val;
}

#define V_NVA097_SET_RENDER_ENABLE_CONTROL(val, args...) { \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE = NVA097_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE; \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE = NVA097_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE; \
    struct nv_nva097_SET_RENDER_ENABLE_CONTROL __data = { .conditional_load_constant_buffer = (args) }; \
    __NVA097_SET_RENDER_ENABLE_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_RENDER_ENABLE_CONTROL V_NVA097_SET_RENDER_ENABLE_CONTROL

#define P_NVA097_SET_RENDER_ENABLE_CONTROL(push, args...) do { \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE = NVA097_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_FALSE; \
    UNUSED uint32_t CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE = NVA097_SET_RENDER_ENABLE_CONTROL_CONDITIONAL_LOAD_CONSTANT_BUFFER_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RENDER_ENABLE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RENDER_ENABLE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPA_VERSION {
    uint32_t minor;
    uint32_t major;
};

static inline void
__NVA097_SET_SPA_VERSION(uint32_t *val_out, struct nv_nva097_SET_SPA_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.minor < (1ULL << 8));
    val |= st.minor << 0;
    
    assert(st.major < (1ULL << 8));
    val |= st.major << 8;
    *val_out = val;
}

#define V_NVA097_SET_SPA_VERSION(val, args...) { \
    struct nv_nva097_SET_SPA_VERSION __data = args; \
    __NVA097_SET_SPA_VERSION(&val, __data); \
}

#define VA_NVA097_SET_SPA_VERSION V_NVA097_SET_SPA_VERSION

#define P_NVA097_SET_SPA_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPA_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPA_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_IEEE_CLEAN_UPDATE {
    uint32_t enable;
};

static inline void
__NVA097_SET_IEEE_CLEAN_UPDATE(uint32_t *val_out, struct nv_nva097_SET_IEEE_CLEAN_UPDATE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_IEEE_CLEAN_UPDATE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_IEEE_CLEAN_UPDATE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_IEEE_CLEAN_UPDATE_ENABLE_TRUE; \
    struct nv_nva097_SET_IEEE_CLEAN_UPDATE __data = { .enable = (args) }; \
    __NVA097_SET_IEEE_CLEAN_UPDATE(&val, __data); \
}

#define VA_NVA097_SET_IEEE_CLEAN_UPDATE V_NVA097_SET_IEEE_CLEAN_UPDATE

#define P_NVA097_SET_IEEE_CLEAN_UPDATE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_IEEE_CLEAN_UPDATE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_IEEE_CLEAN_UPDATE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_IEEE_CLEAN_UPDATE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_IEEE_CLEAN_UPDATE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SNAP_GRID_LINE {
    uint32_t locations_per_pixel;
    uint32_t rounding_mode;
};

static inline void
__NVA097_SET_SNAP_GRID_LINE(uint32_t *val_out, struct nv_nva097_SET_SNAP_GRID_LINE st)
{
    uint32_t val = 0;
    
    assert(st.locations_per_pixel < (1ULL << 4));
    val |= st.locations_per_pixel << 0;
    
    assert(st.rounding_mode < (1ULL << 1));
    val |= st.rounding_mode << 8;
    *val_out = val;
}

#define V_NVA097_SET_SNAP_GRID_LINE(val, args...) { \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__2X2 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__2X2; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__4X4 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__4X4; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__8X8 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__8X8; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__16X16 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__16X16; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__32X32 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__32X32; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__64X64 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__64X64; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__128X128 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__128X128; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__256X256 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__256X256; \
    UNUSED uint32_t ROUNDING_MODE_RTNE = NVA097_SET_SNAP_GRID_LINE_ROUNDING_MODE_RTNE; \
    UNUSED uint32_t ROUNDING_MODE_TESLA = NVA097_SET_SNAP_GRID_LINE_ROUNDING_MODE_TESLA; \
    struct nv_nva097_SET_SNAP_GRID_LINE __data = args; \
    __NVA097_SET_SNAP_GRID_LINE(&val, __data); \
}

#define VA_NVA097_SET_SNAP_GRID_LINE V_NVA097_SET_SNAP_GRID_LINE

#define P_NVA097_SET_SNAP_GRID_LINE(push, args...) do { \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__2X2 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__2X2; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__4X4 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__4X4; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__8X8 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__8X8; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__16X16 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__16X16; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__32X32 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__32X32; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__64X64 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__64X64; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__128X128 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__128X128; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__256X256 = NVA097_SET_SNAP_GRID_LINE_LOCATIONS_PER_PIXEL__256X256; \
    UNUSED uint32_t ROUNDING_MODE_RTNE = NVA097_SET_SNAP_GRID_LINE_ROUNDING_MODE_RTNE; \
    UNUSED uint32_t ROUNDING_MODE_TESLA = NVA097_SET_SNAP_GRID_LINE_ROUNDING_MODE_TESLA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SNAP_GRID_LINE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SNAP_GRID_LINE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SNAP_GRID_NON_LINE {
    uint32_t locations_per_pixel;
    uint32_t rounding_mode;
};

static inline void
__NVA097_SET_SNAP_GRID_NON_LINE(uint32_t *val_out, struct nv_nva097_SET_SNAP_GRID_NON_LINE st)
{
    uint32_t val = 0;
    
    assert(st.locations_per_pixel < (1ULL << 4));
    val |= st.locations_per_pixel << 0;
    
    assert(st.rounding_mode < (1ULL << 1));
    val |= st.rounding_mode << 8;
    *val_out = val;
}

#define V_NVA097_SET_SNAP_GRID_NON_LINE(val, args...) { \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__2X2 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__2X2; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__4X4 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__4X4; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__8X8 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__8X8; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__16X16 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__16X16; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__32X32 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__32X32; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__64X64 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__64X64; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__128X128 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__128X128; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__256X256 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__256X256; \
    UNUSED uint32_t ROUNDING_MODE_RTNE = NVA097_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_RTNE; \
    UNUSED uint32_t ROUNDING_MODE_TESLA = NVA097_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_TESLA; \
    struct nv_nva097_SET_SNAP_GRID_NON_LINE __data = args; \
    __NVA097_SET_SNAP_GRID_NON_LINE(&val, __data); \
}

#define VA_NVA097_SET_SNAP_GRID_NON_LINE V_NVA097_SET_SNAP_GRID_NON_LINE

#define P_NVA097_SET_SNAP_GRID_NON_LINE(push, args...) do { \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__2X2 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__2X2; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__4X4 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__4X4; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__8X8 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__8X8; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__16X16 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__16X16; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__32X32 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__32X32; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__64X64 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__64X64; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__128X128 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__128X128; \
    UNUSED uint32_t LOCATIONS_PER_PIXEL__256X256 = NVA097_SET_SNAP_GRID_NON_LINE_LOCATIONS_PER_PIXEL__256X256; \
    UNUSED uint32_t ROUNDING_MODE_RTNE = NVA097_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_RTNE; \
    UNUSED uint32_t ROUNDING_MODE_TESLA = NVA097_SET_SNAP_GRID_NON_LINE_ROUNDING_MODE_TESLA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SNAP_GRID_NON_LINE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SNAP_GRID_NON_LINE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_PARAMETERS {
    uint32_t domain_type;
    uint32_t spacing;
    uint32_t output_primitives;
};

static inline void
__NVA097_SET_TESSELLATION_PARAMETERS(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_PARAMETERS st)
{
    uint32_t val = 0;
    
    assert(st.domain_type < (1ULL << 2));
    val |= st.domain_type << 0;
    
    assert(st.spacing < (1ULL << 2));
    val |= st.spacing << 4;
    
    assert(st.output_primitives < (1ULL << 2));
    val |= st.output_primitives << 8;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_PARAMETERS(val, args...) { \
    UNUSED uint32_t DOMAIN_TYPE_ISOLINE = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_ISOLINE; \
    UNUSED uint32_t DOMAIN_TYPE_TRIANGLE = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_TRIANGLE; \
    UNUSED uint32_t DOMAIN_TYPE_QUAD = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_QUAD; \
    UNUSED uint32_t SPACING_INTEGER = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_INTEGER; \
    UNUSED uint32_t SPACING_FRACTIONAL_ODD = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_ODD; \
    UNUSED uint32_t SPACING_FRACTIONAL_EVEN = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_EVEN; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_POINTS = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_POINTS; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_LINES = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_LINES; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_TRIANGLES_CW = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CW; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_TRIANGLES_CCW = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CCW; \
    struct nv_nva097_SET_TESSELLATION_PARAMETERS __data = args; \
    __NVA097_SET_TESSELLATION_PARAMETERS(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_PARAMETERS V_NVA097_SET_TESSELLATION_PARAMETERS

#define P_NVA097_SET_TESSELLATION_PARAMETERS(push, args...) do { \
    UNUSED uint32_t DOMAIN_TYPE_ISOLINE = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_ISOLINE; \
    UNUSED uint32_t DOMAIN_TYPE_TRIANGLE = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_TRIANGLE; \
    UNUSED uint32_t DOMAIN_TYPE_QUAD = NVA097_SET_TESSELLATION_PARAMETERS_DOMAIN_TYPE_QUAD; \
    UNUSED uint32_t SPACING_INTEGER = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_INTEGER; \
    UNUSED uint32_t SPACING_FRACTIONAL_ODD = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_ODD; \
    UNUSED uint32_t SPACING_FRACTIONAL_EVEN = NVA097_SET_TESSELLATION_PARAMETERS_SPACING_FRACTIONAL_EVEN; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_POINTS = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_POINTS; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_LINES = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_LINES; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_TRIANGLES_CW = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CW; \
    UNUSED uint32_t OUTPUT_PRIMITIVES_TRIANGLES_CCW = NVA097_SET_TESSELLATION_PARAMETERS_OUTPUT_PRIMITIVES_TRIANGLES_CCW; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_PARAMETERS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_PARAMETERS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_LOD_U0_OR_DENSITY {
    uint32_t v;
};

static inline void
__NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_LOD_U0_OR_DENSITY st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY(val, args...) { \
    struct nv_nva097_SET_TESSELLATION_LOD_U0_OR_DENSITY __data = { .v = (args) }; \
    __NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY V_NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY

#define P_NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_LOD_U0_OR_DENSITY, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_LOD_V0_OR_DETAIL {
    uint32_t v;
};

static inline void
__NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_LOD_V0_OR_DETAIL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL(val, args...) { \
    struct nv_nva097_SET_TESSELLATION_LOD_V0_OR_DETAIL __data = { .v = (args) }; \
    __NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL V_NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL

#define P_NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_LOD_V0_OR_DETAIL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_LOD_U1_OR_W0 {
    uint32_t v;
};

static inline void
__NVA097_SET_TESSELLATION_LOD_U1_OR_W0(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_LOD_U1_OR_W0 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_LOD_U1_OR_W0(val, args...) { \
    struct nv_nva097_SET_TESSELLATION_LOD_U1_OR_W0 __data = { .v = (args) }; \
    __NVA097_SET_TESSELLATION_LOD_U1_OR_W0(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_LOD_U1_OR_W0 V_NVA097_SET_TESSELLATION_LOD_U1_OR_W0

#define P_NVA097_SET_TESSELLATION_LOD_U1_OR_W0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_LOD_U1_OR_W0(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_LOD_U1_OR_W0, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_LOD_V1 {
    uint32_t v;
};

static inline void
__NVA097_SET_TESSELLATION_LOD_V1(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_LOD_V1 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_LOD_V1(val, args...) { \
    struct nv_nva097_SET_TESSELLATION_LOD_V1 __data = { .v = (args) }; \
    __NVA097_SET_TESSELLATION_LOD_V1(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_LOD_V1 V_NVA097_SET_TESSELLATION_LOD_V1

#define P_NVA097_SET_TESSELLATION_LOD_V1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_LOD_V1(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_LOD_V1, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TG_LOD_INTERIOR_U {
    uint32_t v;
};

static inline void
__NVA097_SET_TG_LOD_INTERIOR_U(uint32_t *val_out, struct nv_nva097_SET_TG_LOD_INTERIOR_U st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TG_LOD_INTERIOR_U(val, args...) { \
    struct nv_nva097_SET_TG_LOD_INTERIOR_U __data = { .v = (args) }; \
    __NVA097_SET_TG_LOD_INTERIOR_U(&val, __data); \
}

#define VA_NVA097_SET_TG_LOD_INTERIOR_U V_NVA097_SET_TG_LOD_INTERIOR_U

#define P_NVA097_SET_TG_LOD_INTERIOR_U(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TG_LOD_INTERIOR_U(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TG_LOD_INTERIOR_U, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TG_LOD_INTERIOR_V {
    uint32_t v;
};

static inline void
__NVA097_SET_TG_LOD_INTERIOR_V(uint32_t *val_out, struct nv_nva097_SET_TG_LOD_INTERIOR_V st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_TG_LOD_INTERIOR_V(val, args...) { \
    struct nv_nva097_SET_TG_LOD_INTERIOR_V __data = { .v = (args) }; \
    __NVA097_SET_TG_LOD_INTERIOR_V(&val, __data); \
}

#define VA_NVA097_SET_TG_LOD_INTERIOR_V V_NVA097_SET_TG_LOD_INTERIOR_V

#define P_NVA097_SET_TG_LOD_INTERIOR_V(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TG_LOD_INTERIOR_V(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TG_LOD_INTERIOR_V, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG07 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG07(uint32_t *val_out, struct nv_nva097_RESERVED_TG07 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG07(val, args...) { \
    struct nv_nva097_RESERVED_TG07 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG07(&val, __data); \
}

#define VA_NVA097_RESERVED_TG07 V_NVA097_RESERVED_TG07

#define P_NVA097_RESERVED_TG07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG07(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG07, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG08 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG08(uint32_t *val_out, struct nv_nva097_RESERVED_TG08 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG08(val, args...) { \
    struct nv_nva097_RESERVED_TG08 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG08(&val, __data); \
}

#define VA_NVA097_RESERVED_TG08 V_NVA097_RESERVED_TG08

#define P_NVA097_RESERVED_TG08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG08(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG08, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG09 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG09(uint32_t *val_out, struct nv_nva097_RESERVED_TG09 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG09(val, args...) { \
    struct nv_nva097_RESERVED_TG09 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG09(&val, __data); \
}

#define VA_NVA097_RESERVED_TG09 V_NVA097_RESERVED_TG09

#define P_NVA097_RESERVED_TG09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG09(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG09, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG10 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG10(uint32_t *val_out, struct nv_nva097_RESERVED_TG10 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG10(val, args...) { \
    struct nv_nva097_RESERVED_TG10 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG10(&val, __data); \
}

#define VA_NVA097_RESERVED_TG10 V_NVA097_RESERVED_TG10

#define P_NVA097_RESERVED_TG10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG10(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG10, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG11 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG11(uint32_t *val_out, struct nv_nva097_RESERVED_TG11 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG11(val, args...) { \
    struct nv_nva097_RESERVED_TG11 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG11(&val, __data); \
}

#define VA_NVA097_RESERVED_TG11 V_NVA097_RESERVED_TG11

#define P_NVA097_RESERVED_TG11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG11(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG11, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG12 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG12(uint32_t *val_out, struct nv_nva097_RESERVED_TG12 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG12(val, args...) { \
    struct nv_nva097_RESERVED_TG12 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG12(&val, __data); \
}

#define VA_NVA097_RESERVED_TG12 V_NVA097_RESERVED_TG12

#define P_NVA097_RESERVED_TG12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG12(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG12, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG13 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG13(uint32_t *val_out, struct nv_nva097_RESERVED_TG13 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG13(val, args...) { \
    struct nv_nva097_RESERVED_TG13 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG13(&val, __data); \
}

#define VA_NVA097_RESERVED_TG13 V_NVA097_RESERVED_TG13

#define P_NVA097_RESERVED_TG13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG13(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG13, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG14 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG14(uint32_t *val_out, struct nv_nva097_RESERVED_TG14 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG14(val, args...) { \
    struct nv_nva097_RESERVED_TG14 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG14(&val, __data); \
}

#define VA_NVA097_RESERVED_TG14 V_NVA097_RESERVED_TG14

#define P_NVA097_RESERVED_TG14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG14(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG14, nvk_p_ret); \
} while(0)

struct nv_nva097_RESERVED_TG15 {
    uint32_t v;
};

static inline void
__NVA097_RESERVED_TG15(uint32_t *val_out, struct nv_nva097_RESERVED_TG15 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_RESERVED_TG15(val, args...) { \
    struct nv_nva097_RESERVED_TG15 __data = { .v = (args) }; \
    __NVA097_RESERVED_TG15(&val, __data); \
}

#define VA_NVA097_RESERVED_TG15 V_NVA097_RESERVED_TG15

#define P_NVA097_RESERVED_TG15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_RESERVED_TG15(nvk_p_ret, args); \
    nv_push_val(push, NVA097_RESERVED_TG15, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SUBTILING_PERF_KNOB_A {
    uint32_t fraction_of_spm_register_file_per_subtile;
    uint32_t fraction_of_spm_pixel_output_buffer_per_subtile;
    uint32_t fraction_of_spm_triangle_ram_per_subtile;
    uint32_t fraction_of_max_quads_per_subtile;
};

static inline void
__NVA097_SET_SUBTILING_PERF_KNOB_A(uint32_t *val_out, struct nv_nva097_SET_SUBTILING_PERF_KNOB_A st)
{
    uint32_t val = 0;
    
    assert(st.fraction_of_spm_register_file_per_subtile < (1ULL << 8));
    val |= st.fraction_of_spm_register_file_per_subtile << 0;
    
    assert(st.fraction_of_spm_pixel_output_buffer_per_subtile < (1ULL << 8));
    val |= st.fraction_of_spm_pixel_output_buffer_per_subtile << 8;
    
    assert(st.fraction_of_spm_triangle_ram_per_subtile < (1ULL << 8));
    val |= st.fraction_of_spm_triangle_ram_per_subtile << 16;
    
    assert(st.fraction_of_max_quads_per_subtile < (1ULL << 8));
    val |= st.fraction_of_max_quads_per_subtile << 24;
    *val_out = val;
}

#define V_NVA097_SET_SUBTILING_PERF_KNOB_A(val, args...) { \
    struct nv_nva097_SET_SUBTILING_PERF_KNOB_A __data = args; \
    __NVA097_SET_SUBTILING_PERF_KNOB_A(&val, __data); \
}

#define VA_NVA097_SET_SUBTILING_PERF_KNOB_A V_NVA097_SET_SUBTILING_PERF_KNOB_A

#define P_NVA097_SET_SUBTILING_PERF_KNOB_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SUBTILING_PERF_KNOB_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SUBTILING_PERF_KNOB_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SUBTILING_PERF_KNOB_B {
    uint32_t fraction_of_max_primitives_per_subtile;
};

static inline void
__NVA097_SET_SUBTILING_PERF_KNOB_B(uint32_t *val_out, struct nv_nva097_SET_SUBTILING_PERF_KNOB_B st)
{
    uint32_t val = 0;
    
    assert(st.fraction_of_max_primitives_per_subtile < (1ULL << 8));
    val |= st.fraction_of_max_primitives_per_subtile << 0;
    *val_out = val;
}

#define V_NVA097_SET_SUBTILING_PERF_KNOB_B(val, args...) { \
    struct nv_nva097_SET_SUBTILING_PERF_KNOB_B __data = { .fraction_of_max_primitives_per_subtile = (args) }; \
    __NVA097_SET_SUBTILING_PERF_KNOB_B(&val, __data); \
}

#define VA_NVA097_SET_SUBTILING_PERF_KNOB_B V_NVA097_SET_SUBTILING_PERF_KNOB_B

#define P_NVA097_SET_SUBTILING_PERF_KNOB_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SUBTILING_PERF_KNOB_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SUBTILING_PERF_KNOB_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SUBTILING_PERF_KNOB_C {
    uint32_t reserved;
};

static inline void
__NVA097_SET_SUBTILING_PERF_KNOB_C(uint32_t *val_out, struct nv_nva097_SET_SUBTILING_PERF_KNOB_C st)
{
    uint32_t val = 0;
    
    assert(st.reserved < (1ULL << 1));
    val |= st.reserved << 0;
    *val_out = val;
}

#define V_NVA097_SET_SUBTILING_PERF_KNOB_C(val, args...) { \
    struct nv_nva097_SET_SUBTILING_PERF_KNOB_C __data = { .reserved = (args) }; \
    __NVA097_SET_SUBTILING_PERF_KNOB_C(&val, __data); \
}

#define VA_NVA097_SET_SUBTILING_PERF_KNOB_C V_NVA097_SET_SUBTILING_PERF_KNOB_C

#define P_NVA097_SET_SUBTILING_PERF_KNOB_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SUBTILING_PERF_KNOB_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SUBTILING_PERF_KNOB_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_SUBREGION_TO_REPORT {
    uint32_t enable;
    uint32_t subregion_id;
};

static inline void
__NVA097_SET_ZCULL_SUBREGION_TO_REPORT(uint32_t *val_out, struct nv_nva097_SET_ZCULL_SUBREGION_TO_REPORT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.subregion_id < (1ULL << 8));
    val |= st.subregion_id << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_SUBREGION_TO_REPORT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE; \
    struct nv_nva097_SET_ZCULL_SUBREGION_TO_REPORT __data = args; \
    __NVA097_SET_ZCULL_SUBREGION_TO_REPORT(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_SUBREGION_TO_REPORT V_NVA097_SET_ZCULL_SUBREGION_TO_REPORT

#define P_NVA097_SET_ZCULL_SUBREGION_TO_REPORT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_TO_REPORT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_SUBREGION_TO_REPORT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_SUBREGION_TO_REPORT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_SUBREGION_REPORT_TYPE {
    uint32_t enable;
    uint32_t type;
};

static inline void
__NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE(uint32_t *val_out, struct nv_nva097_SET_ZCULL_SUBREGION_REPORT_TYPE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.type < (1ULL << 3));
    val |= st.type << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE; \
    UNUSED uint32_t TYPE_DEPTH_TEST = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST; \
    UNUSED uint32_t TYPE_DEPTH_TEST_NO_ACCEPT = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT; \
    UNUSED uint32_t TYPE_DEPTH_TEST_LATE_Z = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z; \
    UNUSED uint32_t TYPE_STENCIL_TEST = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST; \
    struct nv_nva097_SET_ZCULL_SUBREGION_REPORT_TYPE __data = args; \
    __NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE V_NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE

#define P_NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_ENABLE_TRUE; \
    UNUSED uint32_t TYPE_DEPTH_TEST = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST; \
    UNUSED uint32_t TYPE_DEPTH_TEST_NO_ACCEPT = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_NO_ACCEPT; \
    UNUSED uint32_t TYPE_DEPTH_TEST_LATE_Z = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_DEPTH_TEST_LATE_Z; \
    UNUSED uint32_t TYPE_STENCIL_TEST = NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE_TYPE_STENCIL_TEST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_SUBREGION_REPORT_TYPE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BALANCED_PRIMITIVE_WORKLOAD {
    uint32_t in_unpartitioned_mode;
    uint32_t in_timesliced_mode;
};

static inline void
__NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD(uint32_t *val_out, struct nv_nva097_SET_BALANCED_PRIMITIVE_WORKLOAD st)
{
    uint32_t val = 0;
    
    assert(st.in_unpartitioned_mode < (1ULL << 1));
    val |= st.in_unpartitioned_mode << 0;
    
    assert(st.in_timesliced_mode < (1ULL << 1));
    val |= st.in_timesliced_mode << 4;
    *val_out = val;
}

#define V_NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD(val, args...) { \
    UNUSED uint32_t IN_UNPARTITIONED_MODE_FALSE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE; \
    UNUSED uint32_t IN_UNPARTITIONED_MODE_TRUE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE; \
    UNUSED uint32_t IN_TIMESLICED_MODE_FALSE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE; \
    UNUSED uint32_t IN_TIMESLICED_MODE_TRUE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE; \
    struct nv_nva097_SET_BALANCED_PRIMITIVE_WORKLOAD __data = args; \
    __NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD(&val, __data); \
}

#define VA_NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD V_NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD

#define P_NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD(push, args...) do { \
    UNUSED uint32_t IN_UNPARTITIONED_MODE_FALSE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_FALSE; \
    UNUSED uint32_t IN_UNPARTITIONED_MODE_TRUE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_UNPARTITIONED_MODE_TRUE; \
    UNUSED uint32_t IN_TIMESLICED_MODE_FALSE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_FALSE; \
    UNUSED uint32_t IN_TIMESLICED_MODE_TRUE = NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD_IN_TIMESLICED_MODE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BALANCED_PRIMITIVE_WORKLOAD, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MAX_PATCHES_PER_BATCH {
    uint32_t v;
};

static inline void
__NVA097_SET_MAX_PATCHES_PER_BATCH(uint32_t *val_out, struct nv_nva097_SET_MAX_PATCHES_PER_BATCH st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 6));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_MAX_PATCHES_PER_BATCH(val, args...) { \
    struct nv_nva097_SET_MAX_PATCHES_PER_BATCH __data = { .v = (args) }; \
    __NVA097_SET_MAX_PATCHES_PER_BATCH(&val, __data); \
}

#define VA_NVA097_SET_MAX_PATCHES_PER_BATCH V_NVA097_SET_MAX_PATCHES_PER_BATCH

#define P_NVA097_SET_MAX_PATCHES_PER_BATCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MAX_PATCHES_PER_BATCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MAX_PATCHES_PER_BATCH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RASTER_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_RASTER_ENABLE(uint32_t *val_out, struct nv_nva097_SET_RASTER_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_RASTER_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_RASTER_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_RASTER_ENABLE_V_TRUE; \
    struct nv_nva097_SET_RASTER_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_RASTER_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_RASTER_ENABLE V_NVA097_SET_RASTER_ENABLE

#define P_NVA097_SET_RASTER_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_RASTER_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_RASTER_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RASTER_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RASTER_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_BUFFER_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_STREAM_OUT_BUFFER_ENABLE(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_BUFFER_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_BUFFER_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_STREAM_OUT_BUFFER_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_STREAM_OUT_BUFFER_ENABLE_V_TRUE; \
    struct nv_nva097_SET_STREAM_OUT_BUFFER_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_STREAM_OUT_BUFFER_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_BUFFER_ENABLE(i) V_NVA097_SET_STREAM_OUT_BUFFER_ENABLE

#define P_NVA097_SET_STREAM_OUT_BUFFER_ENABLE(push, idx, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_STREAM_OUT_BUFFER_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_STREAM_OUT_BUFFER_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_BUFFER_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_BUFFER_ENABLE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_A {
    uint32_t upper;
};

static inline void
__NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_A __data = { .upper = (args) }; \
    __NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(i) V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A

#define P_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_B {
    uint32_t lower;
};

static inline void
__NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_BUFFER_ADDRESS_B __data = { .lower = (args) }; \
    __NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(i) V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B

#define P_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_BUFFER_ADDRESS_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_BUFFER_SIZE {
    uint32_t bytes;
};

static inline void
__NVA097_SET_STREAM_OUT_BUFFER_SIZE(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_BUFFER_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.bytes;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_BUFFER_SIZE(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_BUFFER_SIZE __data = { .bytes = (args) }; \
    __NVA097_SET_STREAM_OUT_BUFFER_SIZE(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_BUFFER_SIZE(i) V_NVA097_SET_STREAM_OUT_BUFFER_SIZE

#define P_NVA097_SET_STREAM_OUT_BUFFER_SIZE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_BUFFER_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_BUFFER_SIZE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER {
    uint32_t start_offset;
};

static inline void
__NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.start_offset;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER __data = { .start_offset = (args) }; \
    __NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(i) V_NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER

#define P_NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_BUFFER_LOAD_WRITE_POINTER(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_DATA_TYPELESS {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_DATA_TYPELESS(uint32_t *val_out, struct nv_nva097_SET_VAB_DATA_TYPELESS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_DATA_TYPELESS(val, args...) { \
    struct nv_nva097_SET_VAB_DATA_TYPELESS __data = { .v = (args) }; \
    __NVA097_SET_VAB_DATA_TYPELESS(&val, __data); \
}

#define VA_NVA097_SET_VAB_DATA_TYPELESS(i) V_NVA097_SET_VAB_DATA_TYPELESS

#define P_NVA097_SET_VAB_DATA_TYPELESS(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_DATA_TYPELESS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_DATA_TYPELESS(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_CONTROL_STREAM {
    uint32_t select;
};

static inline void
__NVA097_SET_STREAM_OUT_CONTROL_STREAM(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_CONTROL_STREAM st)
{
    uint32_t val = 0;
    
    assert(st.select < (1ULL << 2));
    val |= st.select << 0;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_CONTROL_STREAM(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_CONTROL_STREAM __data = { .select = (args) }; \
    __NVA097_SET_STREAM_OUT_CONTROL_STREAM(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_CONTROL_STREAM(i) V_NVA097_SET_STREAM_OUT_CONTROL_STREAM

#define P_NVA097_SET_STREAM_OUT_CONTROL_STREAM(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_CONTROL_STREAM(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_CONTROL_STREAM(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT {
    uint32_t max;
};

static inline void
__NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.max < (1ULL << 8));
    val |= st.max << 0;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT __data = { .max = (args) }; \
    __NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(i) V_NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT

#define P_NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_CONTROL_COMPONENT_COUNT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUT_CONTROL_STRIDE {
    uint32_t bytes;
};

static inline void
__NVA097_SET_STREAM_OUT_CONTROL_STRIDE(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUT_CONTROL_STRIDE st)
{
    uint32_t val = 0;
    
    val |= st.bytes;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUT_CONTROL_STRIDE(val, args...) { \
    struct nv_nva097_SET_STREAM_OUT_CONTROL_STRIDE __data = { .bytes = (args) }; \
    __NVA097_SET_STREAM_OUT_CONTROL_STRIDE(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUT_CONTROL_STRIDE(i) V_NVA097_SET_STREAM_OUT_CONTROL_STRIDE

#define P_NVA097_SET_STREAM_OUT_CONTROL_STRIDE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUT_CONTROL_STRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUT_CONTROL_STRIDE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RASTER_INPUT {
    uint32_t stream_select;
};

static inline void
__NVA097_SET_RASTER_INPUT(uint32_t *val_out, struct nv_nva097_SET_RASTER_INPUT st)
{
    uint32_t val = 0;
    
    assert(st.stream_select < (1ULL << 2));
    val |= st.stream_select << 0;
    *val_out = val;
}

#define V_NVA097_SET_RASTER_INPUT(val, args...) { \
    struct nv_nva097_SET_RASTER_INPUT __data = { .stream_select = (args) }; \
    __NVA097_SET_RASTER_INPUT(&val, __data); \
}

#define VA_NVA097_SET_RASTER_INPUT V_NVA097_SET_RASTER_INPUT

#define P_NVA097_SET_RASTER_INPUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RASTER_INPUT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RASTER_INPUT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STREAM_OUTPUT {
    uint32_t enable;
};

static inline void
__NVA097_SET_STREAM_OUTPUT(uint32_t *val_out, struct nv_nva097_SET_STREAM_OUTPUT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_STREAM_OUTPUT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_STREAM_OUTPUT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_STREAM_OUTPUT_ENABLE_TRUE; \
    struct nv_nva097_SET_STREAM_OUTPUT __data = { .enable = (args) }; \
    __NVA097_SET_STREAM_OUTPUT(&val, __data); \
}

#define VA_NVA097_SET_STREAM_OUTPUT V_NVA097_SET_STREAM_OUTPUT

#define P_NVA097_SET_STREAM_OUTPUT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_STREAM_OUTPUT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_STREAM_OUTPUT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STREAM_OUTPUT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STREAM_OUTPUT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE {
    uint32_t enable;
};

static inline void
__NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE(uint32_t *val_out, struct nv_nva097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_TRUE; \
    struct nv_nva097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE __data = { .enable = (args) }; \
    __NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE(&val, __data); \
}

#define VA_NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE V_NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE

#define P_NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_PRIMITIVE_RESTART_TOPOLOGY_CHANGE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_FRACTION {
    uint32_t v;
};

static inline void
__NVA097_SET_ALPHA_FRACTION(uint32_t *val_out, struct nv_nva097_SET_ALPHA_FRACTION st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_FRACTION(val, args...) { \
    struct nv_nva097_SET_ALPHA_FRACTION __data = { .v = (args) }; \
    __NVA097_SET_ALPHA_FRACTION(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_FRACTION V_NVA097_SET_ALPHA_FRACTION

#define P_NVA097_SET_ALPHA_FRACTION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_FRACTION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_FRACTION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_HYBRID_ANTI_ALIAS_CONTROL {
    uint32_t passes;
    uint32_t centroid;
};

static inline void
__NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL(uint32_t *val_out, struct nv_nva097_SET_HYBRID_ANTI_ALIAS_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.passes < (1ULL << 4));
    val |= st.passes << 0;
    
    assert(st.centroid < (1ULL << 1));
    val |= st.centroid << 4;
    *val_out = val;
}

#define V_NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL(val, args...) { \
    UNUSED uint32_t CENTROID_PER_FRAGMENT = NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT; \
    UNUSED uint32_t CENTROID_PER_PASS = NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS; \
    struct nv_nva097_SET_HYBRID_ANTI_ALIAS_CONTROL __data = args; \
    __NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL V_NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL

#define P_NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL(push, args...) do { \
    UNUSED uint32_t CENTROID_PER_FRAGMENT = NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_FRAGMENT; \
    UNUSED uint32_t CENTROID_PER_PASS = NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL_CENTROID_PER_PASS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_HYBRID_ANTI_ALIAS_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MAX_TI_WARPS_PER_BATCH {
    uint32_t v;
};

static inline void
__NVA097_SET_MAX_TI_WARPS_PER_BATCH(uint32_t *val_out, struct nv_nva097_SET_MAX_TI_WARPS_PER_BATCH st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 6));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_MAX_TI_WARPS_PER_BATCH(val, args...) { \
    struct nv_nva097_SET_MAX_TI_WARPS_PER_BATCH __data = { .v = (args) }; \
    __NVA097_SET_MAX_TI_WARPS_PER_BATCH(&val, __data); \
}

#define VA_NVA097_SET_MAX_TI_WARPS_PER_BATCH V_NVA097_SET_MAX_TI_WARPS_PER_BATCH

#define P_NVA097_SET_MAX_TI_WARPS_PER_BATCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MAX_TI_WARPS_PER_BATCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MAX_TI_WARPS_PER_BATCH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_WINDOW {
    uint32_t base_address;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_WINDOW st)
{
    uint32_t val = 0;
    
    val |= st.base_address;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_WINDOW __data = { .base_address = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW V_NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_WINDOW, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_A(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_A(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_A __data = { .address_upper = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_A(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_A V_NVA097_SET_SHADER_LOCAL_MEMORY_A

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_B(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_B(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_B __data = { .address_lower = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_B(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_B V_NVA097_SET_SHADER_LOCAL_MEMORY_B

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_C {
    uint32_t size_upper;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_C(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_C st)
{
    uint32_t val = 0;
    
    assert(st.size_upper < (1ULL << 6));
    val |= st.size_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_C(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_C __data = { .size_upper = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_C(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_C V_NVA097_SET_SHADER_LOCAL_MEMORY_C

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_D {
    uint32_t size_lower;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_D(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_D st)
{
    uint32_t val = 0;
    
    val |= st.size_lower;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_D(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_D __data = { .size_lower = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_D(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_D V_NVA097_SET_SHADER_LOCAL_MEMORY_D

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_D(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_D, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_LOCAL_MEMORY_E {
    uint32_t default_size_per_warp;
};

static inline void
__NVA097_SET_SHADER_LOCAL_MEMORY_E(uint32_t *val_out, struct nv_nva097_SET_SHADER_LOCAL_MEMORY_E st)
{
    uint32_t val = 0;
    
    assert(st.default_size_per_warp < (1ULL << 26));
    val |= st.default_size_per_warp << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_LOCAL_MEMORY_E(val, args...) { \
    struct nv_nva097_SET_SHADER_LOCAL_MEMORY_E __data = { .default_size_per_warp = (args) }; \
    __NVA097_SET_SHADER_LOCAL_MEMORY_E(&val, __data); \
}

#define VA_NVA097_SET_SHADER_LOCAL_MEMORY_E V_NVA097_SET_SHADER_LOCAL_MEMORY_E

#define P_NVA097_SET_SHADER_LOCAL_MEMORY_E(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_LOCAL_MEMORY_E(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_LOCAL_MEMORY_E, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_ZERO_BANDWIDTH_CLEAR {
    uint32_t slot_disable_mask;
};

static inline void
__NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR(uint32_t *val_out, struct nv_nva097_SET_COLOR_ZERO_BANDWIDTH_CLEAR st)
{
    uint32_t val = 0;
    
    assert(st.slot_disable_mask < (1ULL << 15));
    val |= st.slot_disable_mask << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR(val, args...) { \
    struct nv_nva097_SET_COLOR_ZERO_BANDWIDTH_CLEAR __data = { .slot_disable_mask = (args) }; \
    __NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR(&val, __data); \
}

#define VA_NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR V_NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR

#define P_NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_ZERO_BANDWIDTH_CLEAR, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_Z_ZERO_BANDWIDTH_CLEAR {
    uint32_t slot_disable_mask;
};

static inline void
__NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR(uint32_t *val_out, struct nv_nva097_SET_Z_ZERO_BANDWIDTH_CLEAR st)
{
    uint32_t val = 0;
    
    assert(st.slot_disable_mask < (1ULL << 15));
    val |= st.slot_disable_mask << 0;
    *val_out = val;
}

#define V_NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR(val, args...) { \
    struct nv_nva097_SET_Z_ZERO_BANDWIDTH_CLEAR __data = { .slot_disable_mask = (args) }; \
    __NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR(&val, __data); \
}

#define VA_NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR V_NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR

#define P_NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_Z_ZERO_BANDWIDTH_CLEAR, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ISBE_SAVE_RESTORE_PROGRAM {
    uint32_t offset;
};

static inline void
__NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM(uint32_t *val_out, struct nv_nva097_SET_ISBE_SAVE_RESTORE_PROGRAM st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM(val, args...) { \
    struct nv_nva097_SET_ISBE_SAVE_RESTORE_PROGRAM __data = { .offset = (args) }; \
    __NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM(&val, __data); \
}

#define VA_NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM V_NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM

#define P_NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ISBE_SAVE_RESTORE_PROGRAM, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_VERTEX2F {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_VERTEX2F(uint32_t *val_out, struct nv_nva097_SET_VAB_VERTEX2F st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_VERTEX2F(val, args...) { \
    struct nv_nva097_SET_VAB_VERTEX2F __data = { .v = (args) }; \
    __NVA097_SET_VAB_VERTEX2F(&val, __data); \
}

#define VA_NVA097_SET_VAB_VERTEX2F(i) V_NVA097_SET_VAB_VERTEX2F

#define P_NVA097_SET_VAB_VERTEX2F(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_VERTEX2F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_VERTEX2F(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_SIZE_A {
    uint32_t width;
};

static inline void
__NVA097_SET_ZCULL_REGION_SIZE_A(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_SIZE_A st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_SIZE_A(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_SIZE_A __data = { .width = (args) }; \
    __NVA097_SET_ZCULL_REGION_SIZE_A(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_SIZE_A V_NVA097_SET_ZCULL_REGION_SIZE_A

#define P_NVA097_SET_ZCULL_REGION_SIZE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_SIZE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_SIZE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_SIZE_B {
    uint32_t height;
};

static inline void
__NVA097_SET_ZCULL_REGION_SIZE_B(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_SIZE_B st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_SIZE_B(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_SIZE_B __data = { .height = (args) }; \
    __NVA097_SET_ZCULL_REGION_SIZE_B(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_SIZE_B V_NVA097_SET_ZCULL_REGION_SIZE_B

#define P_NVA097_SET_ZCULL_REGION_SIZE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_SIZE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_SIZE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_SIZE_C {
    uint32_t depth;
};

static inline void
__NVA097_SET_ZCULL_REGION_SIZE_C(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_SIZE_C st)
{
    uint32_t val = 0;
    
    assert(st.depth < (1ULL << 16));
    val |= st.depth << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_SIZE_C(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_SIZE_C __data = { .depth = (args) }; \
    __NVA097_SET_ZCULL_REGION_SIZE_C(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_SIZE_C V_NVA097_SET_ZCULL_REGION_SIZE_C

#define P_NVA097_SET_ZCULL_REGION_SIZE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_SIZE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_SIZE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_C {
    uint32_t depth;
};

static inline void
__NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_C st)
{
    uint32_t val = 0;
    
    assert(st.depth < (1ULL << 16));
    val |= st.depth << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_C __data = { .depth = (args) }; \
    __NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C

#define P_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CULL_BEFORE_FETCH {
    uint32_t fetch_streams_once;
};

static inline void
__NVA097_SET_CULL_BEFORE_FETCH(uint32_t *val_out, struct nv_nva097_SET_CULL_BEFORE_FETCH st)
{
    uint32_t val = 0;
    
    assert(st.fetch_streams_once < (1ULL << 1));
    val |= st.fetch_streams_once << 0;
    *val_out = val;
}

#define V_NVA097_SET_CULL_BEFORE_FETCH(val, args...) { \
    UNUSED uint32_t FETCH_STREAMS_ONCE_FALSE = NVA097_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_FALSE; \
    UNUSED uint32_t FETCH_STREAMS_ONCE_TRUE = NVA097_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_TRUE; \
    struct nv_nva097_SET_CULL_BEFORE_FETCH __data = { .fetch_streams_once = (args) }; \
    __NVA097_SET_CULL_BEFORE_FETCH(&val, __data); \
}

#define VA_NVA097_SET_CULL_BEFORE_FETCH V_NVA097_SET_CULL_BEFORE_FETCH

#define P_NVA097_SET_CULL_BEFORE_FETCH(push, args...) do { \
    UNUSED uint32_t FETCH_STREAMS_ONCE_FALSE = NVA097_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_FALSE; \
    UNUSED uint32_t FETCH_STREAMS_ONCE_TRUE = NVA097_SET_CULL_BEFORE_FETCH_FETCH_STREAMS_ONCE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CULL_BEFORE_FETCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CULL_BEFORE_FETCH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_LOCATION {
    uint32_t start_aliquot;
    uint32_t aliquot_count;
};

static inline void
__NVA097_SET_ZCULL_REGION_LOCATION(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_LOCATION st)
{
    uint32_t val = 0;
    
    assert(st.start_aliquot < (1ULL << 16));
    val |= st.start_aliquot << 0;
    
    assert(st.aliquot_count < (1ULL << 16));
    val |= st.aliquot_count << 16;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_LOCATION(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_LOCATION __data = args; \
    __NVA097_SET_ZCULL_REGION_LOCATION(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_LOCATION V_NVA097_SET_ZCULL_REGION_LOCATION

#define P_NVA097_SET_ZCULL_REGION_LOCATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_LOCATION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_LOCATION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_ALIQUOTS {
    uint32_t per_layer;
};

static inline void
__NVA097_SET_ZCULL_REGION_ALIQUOTS(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_ALIQUOTS st)
{
    uint32_t val = 0;
    
    assert(st.per_layer < (1ULL << 16));
    val |= st.per_layer << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_ALIQUOTS(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_ALIQUOTS __data = { .per_layer = (args) }; \
    __NVA097_SET_ZCULL_REGION_ALIQUOTS(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_ALIQUOTS V_NVA097_SET_ZCULL_REGION_ALIQUOTS

#define P_NVA097_SET_ZCULL_REGION_ALIQUOTS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_ALIQUOTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_ALIQUOTS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_STORAGE_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_ZCULL_STORAGE_A(uint32_t *val_out, struct nv_nva097_SET_ZCULL_STORAGE_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_STORAGE_A(val, args...) { \
    struct nv_nva097_SET_ZCULL_STORAGE_A __data = { .address_upper = (args) }; \
    __NVA097_SET_ZCULL_STORAGE_A(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_STORAGE_A V_NVA097_SET_ZCULL_STORAGE_A

#define P_NVA097_SET_ZCULL_STORAGE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_STORAGE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_STORAGE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_STORAGE_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_ZCULL_STORAGE_B(uint32_t *val_out, struct nv_nva097_SET_ZCULL_STORAGE_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_STORAGE_B(val, args...) { \
    struct nv_nva097_SET_ZCULL_STORAGE_B __data = { .address_lower = (args) }; \
    __NVA097_SET_ZCULL_STORAGE_B(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_STORAGE_B V_NVA097_SET_ZCULL_STORAGE_B

#define P_NVA097_SET_ZCULL_STORAGE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_STORAGE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_STORAGE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_STORAGE_C {
    uint32_t limit_address_upper;
};

static inline void
__NVA097_SET_ZCULL_STORAGE_C(uint32_t *val_out, struct nv_nva097_SET_ZCULL_STORAGE_C st)
{
    uint32_t val = 0;
    
    assert(st.limit_address_upper < (1ULL << 8));
    val |= st.limit_address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_STORAGE_C(val, args...) { \
    struct nv_nva097_SET_ZCULL_STORAGE_C __data = { .limit_address_upper = (args) }; \
    __NVA097_SET_ZCULL_STORAGE_C(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_STORAGE_C V_NVA097_SET_ZCULL_STORAGE_C

#define P_NVA097_SET_ZCULL_STORAGE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_STORAGE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_STORAGE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_STORAGE_D {
    uint32_t limit_address_lower;
};

static inline void
__NVA097_SET_ZCULL_STORAGE_D(uint32_t *val_out, struct nv_nva097_SET_ZCULL_STORAGE_D st)
{
    uint32_t val = 0;
    
    val |= st.limit_address_lower;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_STORAGE_D(val, args...) { \
    struct nv_nva097_SET_ZCULL_STORAGE_D __data = { .limit_address_lower = (args) }; \
    __NVA097_SET_ZCULL_STORAGE_D(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_STORAGE_D V_NVA097_SET_ZCULL_STORAGE_D

#define P_NVA097_SET_ZCULL_STORAGE_D(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_STORAGE_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_STORAGE_D, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_READ_ONLY {
    uint32_t enable_z;
    uint32_t enable_stencil;
};

static inline void
__NVA097_SET_ZT_READ_ONLY(uint32_t *val_out, struct nv_nva097_SET_ZT_READ_ONLY st)
{
    uint32_t val = 0;
    
    assert(st.enable_z < (1ULL << 1));
    val |= st.enable_z << 0;
    
    assert(st.enable_stencil < (1ULL << 1));
    val |= st.enable_stencil << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZT_READ_ONLY(val, args...) { \
    UNUSED uint32_t ENABLE_Z_FALSE = NVA097_SET_ZT_READ_ONLY_ENABLE_Z_FALSE; \
    UNUSED uint32_t ENABLE_Z_TRUE = NVA097_SET_ZT_READ_ONLY_ENABLE_Z_TRUE; \
    UNUSED uint32_t ENABLE_STENCIL_FALSE = NVA097_SET_ZT_READ_ONLY_ENABLE_STENCIL_FALSE; \
    UNUSED uint32_t ENABLE_STENCIL_TRUE = NVA097_SET_ZT_READ_ONLY_ENABLE_STENCIL_TRUE; \
    struct nv_nva097_SET_ZT_READ_ONLY __data = args; \
    __NVA097_SET_ZT_READ_ONLY(&val, __data); \
}

#define VA_NVA097_SET_ZT_READ_ONLY V_NVA097_SET_ZT_READ_ONLY

#define P_NVA097_SET_ZT_READ_ONLY(push, args...) do { \
    UNUSED uint32_t ENABLE_Z_FALSE = NVA097_SET_ZT_READ_ONLY_ENABLE_Z_FALSE; \
    UNUSED uint32_t ENABLE_Z_TRUE = NVA097_SET_ZT_READ_ONLY_ENABLE_Z_TRUE; \
    UNUSED uint32_t ENABLE_STENCIL_FALSE = NVA097_SET_ZT_READ_ONLY_ENABLE_STENCIL_FALSE; \
    UNUSED uint32_t ENABLE_STENCIL_TRUE = NVA097_SET_ZT_READ_ONLY_ENABLE_STENCIL_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_READ_ONLY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_READ_ONLY, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEXTURE_INSTRUCTION_OPERAND {
    uint32_t ordering;
};

static inline void
__NVA097_SET_TEXTURE_INSTRUCTION_OPERAND(uint32_t *val_out, struct nv_nva097_SET_TEXTURE_INSTRUCTION_OPERAND st)
{
    uint32_t val = 0;
    
    assert(st.ordering < (1ULL << 1));
    val |= st.ordering << 0;
    *val_out = val;
}

#define V_NVA097_SET_TEXTURE_INSTRUCTION_OPERAND(val, args...) { \
    UNUSED uint32_t ORDERING_FERMI_ORDER = NVA097_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_FERMI_ORDER; \
    UNUSED uint32_t ORDERING_KEPLER_ORDER = NVA097_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_KEPLER_ORDER; \
    struct nv_nva097_SET_TEXTURE_INSTRUCTION_OPERAND __data = { .ordering = (args) }; \
    __NVA097_SET_TEXTURE_INSTRUCTION_OPERAND(&val, __data); \
}

#define VA_NVA097_SET_TEXTURE_INSTRUCTION_OPERAND V_NVA097_SET_TEXTURE_INSTRUCTION_OPERAND

#define P_NVA097_SET_TEXTURE_INSTRUCTION_OPERAND(push, args...) do { \
    UNUSED uint32_t ORDERING_FERMI_ORDER = NVA097_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_FERMI_ORDER; \
    UNUSED uint32_t ORDERING_KEPLER_ORDER = NVA097_SET_TEXTURE_INSTRUCTION_OPERAND_ORDERING_KEPLER_ORDER; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEXTURE_INSTRUCTION_OPERAND(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEXTURE_INSTRUCTION_OPERAND, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_COLOR_TARGET_A(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_A(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_COLOR_TARGET_A(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_A(i) V_NVA097_SET_COLOR_TARGET_A

#define P_NVA097_SET_COLOR_TARGET_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_COLOR_TARGET_B(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_B(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_COLOR_TARGET_B(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_B(i) V_NVA097_SET_COLOR_TARGET_B

#define P_NVA097_SET_COLOR_TARGET_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_WIDTH {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_TARGET_WIDTH(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_WIDTH st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 28));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_WIDTH(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_WIDTH __data = { .v = (args) }; \
    __NVA097_SET_COLOR_TARGET_WIDTH(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_WIDTH(i) V_NVA097_SET_COLOR_TARGET_WIDTH

#define P_NVA097_SET_COLOR_TARGET_WIDTH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_WIDTH(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_HEIGHT {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_TARGET_HEIGHT(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_HEIGHT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 17));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_HEIGHT(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_HEIGHT __data = { .v = (args) }; \
    __NVA097_SET_COLOR_TARGET_HEIGHT(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_HEIGHT(i) V_NVA097_SET_COLOR_TARGET_HEIGHT

#define P_NVA097_SET_COLOR_TARGET_HEIGHT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_HEIGHT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_FORMAT {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_TARGET_FORMAT(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_FORMAT(val, args...) { \
    UNUSED uint32_t V_DISABLED = NVA097_SET_COLOR_TARGET_FORMAT_V_DISABLED; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RS32_GS32_BS32_AS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32; \
    UNUSED uint32_t V_RU32_GU32_BU32_AU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_RS32_GS32_BS32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32; \
    UNUSED uint32_t V_RU32_GU32_BU32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_RS16_GS16_BS16_AS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16; \
    UNUSED uint32_t V_RU16_GU16_BU16_AU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF32_GF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RS32_GS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32; \
    UNUSED uint32_t V_RU32_GU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_A8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2B10G10R10 = NVA097_SET_COLOR_TARGET_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_AU2BU10GU10RU10 = NVA097_SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10; \
    UNUSED uint32_t V_A8B8G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_AS8BS8GS8RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8; \
    UNUSED uint32_t V_AU8BU8GU8RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8; \
    UNUSED uint32_t V_R16_G16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_RS16_GS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16_GS16; \
    UNUSED uint32_t V_RU16_GU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16_GU16; \
    UNUSED uint32_t V_RF16_GF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_A2R10G10B10 = NVA097_SET_COLOR_TARGET_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_BF10GF11RF11 = NVA097_SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_RS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32; \
    UNUSED uint32_t V_RU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32; \
    UNUSED uint32_t V_RF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32; \
    UNUSED uint32_t V_X8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_R5G6B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_GS8RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GS8RS8; \
    UNUSED uint32_t V_GU8RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GU8RU8; \
    UNUSED uint32_t V_R16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16; \
    UNUSED uint32_t V_RN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16; \
    UNUSED uint32_t V_RS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16; \
    UNUSED uint32_t V_RU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16; \
    UNUSED uint32_t V_RF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16; \
    UNUSED uint32_t V_R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_R8; \
    UNUSED uint32_t V_RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN8; \
    UNUSED uint32_t V_RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS8; \
    UNUSED uint32_t V_RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU8; \
    UNUSED uint32_t V_A8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8; \
    UNUSED uint32_t V_X1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_X8B8G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_Z1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_R32 = NVA097_SET_COLOR_TARGET_FORMAT_V_R32; \
    UNUSED uint32_t V_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_A16; \
    UNUSED uint32_t V_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_AF16; \
    UNUSED uint32_t V_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_AF32; \
    UNUSED uint32_t V_A8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8R8; \
    UNUSED uint32_t V_R16_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_A16; \
    UNUSED uint32_t V_RF16_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_AF16; \
    UNUSED uint32_t V_RF32_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_AF32; \
    UNUSED uint32_t V_B8G8R8A8 = NVA097_SET_COLOR_TARGET_FORMAT_V_B8G8R8A8; \
    struct nv_nva097_SET_COLOR_TARGET_FORMAT __data = { .v = (args) }; \
    __NVA097_SET_COLOR_TARGET_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_FORMAT(i) V_NVA097_SET_COLOR_TARGET_FORMAT

#define P_NVA097_SET_COLOR_TARGET_FORMAT(push, idx, args...) do { \
    UNUSED uint32_t V_DISABLED = NVA097_SET_COLOR_TARGET_FORMAT_V_DISABLED; \
    UNUSED uint32_t V_RF32_GF32_BF32_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_AF32; \
    UNUSED uint32_t V_RS32_GS32_BS32_AS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_AS32; \
    UNUSED uint32_t V_RU32_GU32_BU32_AU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_AU32; \
    UNUSED uint32_t V_RF32_GF32_BF32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32_BF32_X32; \
    UNUSED uint32_t V_RS32_GS32_BS32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32_BS32_X32; \
    UNUSED uint32_t V_RU32_GU32_BU32_X32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32_BU32_X32; \
    UNUSED uint32_t V_R16_G16_B16_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_G16_B16_A16; \
    UNUSED uint32_t V_RN16_GN16_BN16_AN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16_GN16_BN16_AN16; \
    UNUSED uint32_t V_RS16_GS16_BS16_AS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16_GS16_BS16_AS16; \
    UNUSED uint32_t V_RU16_GU16_BU16_AU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16_GU16_BU16_AU16; \
    UNUSED uint32_t V_RF16_GF16_BF16_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_AF16; \
    UNUSED uint32_t V_RF32_GF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_GF32; \
    UNUSED uint32_t V_RS32_GS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32_GS32; \
    UNUSED uint32_t V_RU32_GU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32_GU32; \
    UNUSED uint32_t V_RF16_GF16_BF16_X16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16_BF16_X16; \
    UNUSED uint32_t V_A8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8R8G8B8; \
    UNUSED uint32_t V_A8RL8GL8BL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8RL8GL8BL8; \
    UNUSED uint32_t V_A2B10G10R10 = NVA097_SET_COLOR_TARGET_FORMAT_V_A2B10G10R10; \
    UNUSED uint32_t V_AU2BU10GU10RU10 = NVA097_SET_COLOR_TARGET_FORMAT_V_AU2BU10GU10RU10; \
    UNUSED uint32_t V_A8B8G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8B8G8R8; \
    UNUSED uint32_t V_A8BL8GL8RL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8BL8GL8RL8; \
    UNUSED uint32_t V_AN8BN8GN8RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AN8BN8GN8RN8; \
    UNUSED uint32_t V_AS8BS8GS8RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AS8BS8GS8RS8; \
    UNUSED uint32_t V_AU8BU8GU8RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_AU8BU8GU8RU8; \
    UNUSED uint32_t V_R16_G16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_G16; \
    UNUSED uint32_t V_RN16_GN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16_GN16; \
    UNUSED uint32_t V_RS16_GS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16_GS16; \
    UNUSED uint32_t V_RU16_GU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16_GU16; \
    UNUSED uint32_t V_RF16_GF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_GF16; \
    UNUSED uint32_t V_A2R10G10B10 = NVA097_SET_COLOR_TARGET_FORMAT_V_A2R10G10B10; \
    UNUSED uint32_t V_BF10GF11RF11 = NVA097_SET_COLOR_TARGET_FORMAT_V_BF10GF11RF11; \
    UNUSED uint32_t V_RS32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS32; \
    UNUSED uint32_t V_RU32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU32; \
    UNUSED uint32_t V_RF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32; \
    UNUSED uint32_t V_X8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8R8G8B8; \
    UNUSED uint32_t V_X8RL8GL8BL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8RL8GL8BL8; \
    UNUSED uint32_t V_R5G6B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_R5G6B5; \
    UNUSED uint32_t V_A1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_A1R5G5B5; \
    UNUSED uint32_t V_G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_G8R8; \
    UNUSED uint32_t V_GN8RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GN8RN8; \
    UNUSED uint32_t V_GS8RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GS8RS8; \
    UNUSED uint32_t V_GU8RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_GU8RU8; \
    UNUSED uint32_t V_R16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16; \
    UNUSED uint32_t V_RN16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN16; \
    UNUSED uint32_t V_RS16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS16; \
    UNUSED uint32_t V_RU16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU16; \
    UNUSED uint32_t V_RF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16; \
    UNUSED uint32_t V_R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_R8; \
    UNUSED uint32_t V_RN8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RN8; \
    UNUSED uint32_t V_RS8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RS8; \
    UNUSED uint32_t V_RU8 = NVA097_SET_COLOR_TARGET_FORMAT_V_RU8; \
    UNUSED uint32_t V_A8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8; \
    UNUSED uint32_t V_X1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_X1R5G5B5; \
    UNUSED uint32_t V_X8B8G8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8B8G8R8; \
    UNUSED uint32_t V_X8BL8GL8RL8 = NVA097_SET_COLOR_TARGET_FORMAT_V_X8BL8GL8RL8; \
    UNUSED uint32_t V_Z1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_Z1R5G5B5; \
    UNUSED uint32_t V_O1R5G5B5 = NVA097_SET_COLOR_TARGET_FORMAT_V_O1R5G5B5; \
    UNUSED uint32_t V_Z8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_Z8R8G8B8; \
    UNUSED uint32_t V_O8R8G8B8 = NVA097_SET_COLOR_TARGET_FORMAT_V_O8R8G8B8; \
    UNUSED uint32_t V_R32 = NVA097_SET_COLOR_TARGET_FORMAT_V_R32; \
    UNUSED uint32_t V_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_A16; \
    UNUSED uint32_t V_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_AF16; \
    UNUSED uint32_t V_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_AF32; \
    UNUSED uint32_t V_A8R8 = NVA097_SET_COLOR_TARGET_FORMAT_V_A8R8; \
    UNUSED uint32_t V_R16_A16 = NVA097_SET_COLOR_TARGET_FORMAT_V_R16_A16; \
    UNUSED uint32_t V_RF16_AF16 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF16_AF16; \
    UNUSED uint32_t V_RF32_AF32 = NVA097_SET_COLOR_TARGET_FORMAT_V_RF32_AF32; \
    UNUSED uint32_t V_B8G8R8A8 = NVA097_SET_COLOR_TARGET_FORMAT_V_B8G8R8A8; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_FORMAT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_MEMORY {
    uint32_t block_width;
    uint32_t block_height;
    uint32_t block_depth;
    uint32_t layout;
    uint32_t third_dimension_control;
};

static inline void
__NVA097_SET_COLOR_TARGET_MEMORY(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_MEMORY st)
{
    uint32_t val = 0;
    
    assert(st.block_width < (1ULL << 4));
    val |= st.block_width << 0;
    
    assert(st.block_height < (1ULL << 4));
    val |= st.block_height << 4;
    
    assert(st.block_depth < (1ULL << 4));
    val |= st.block_depth << 8;
    
    assert(st.layout < (1ULL << 1));
    val |= st.layout << 12;
    
    assert(st.third_dimension_control < (1ULL << 1));
    val |= st.third_dimension_control << 16;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_MEMORY(val, args...) { \
    UNUSED uint32_t BLOCK_WIDTH_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH_ONE_GOB; \
    UNUSED uint32_t BLOCK_HEIGHT_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_ONE_GOB; \
    UNUSED uint32_t BLOCK_HEIGHT_TWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_FOUR_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_EIGHT_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_SIXTEEN_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_THIRTYTWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_ONE_GOB; \
    UNUSED uint32_t BLOCK_DEPTH_TWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_TWO_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_FOUR_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_EIGHT_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_SIXTEEN_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_THIRTYTWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t LAYOUT_BLOCKLINEAR = NVA097_SET_COLOR_TARGET_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t LAYOUT_PITCH = NVA097_SET_COLOR_TARGET_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE = NVA097_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE; \
    UNUSED uint32_t THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE = NVA097_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE; \
    struct nv_nva097_SET_COLOR_TARGET_MEMORY __data = args; \
    __NVA097_SET_COLOR_TARGET_MEMORY(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_MEMORY(i) V_NVA097_SET_COLOR_TARGET_MEMORY

#define P_NVA097_SET_COLOR_TARGET_MEMORY(push, idx, args...) do { \
    UNUSED uint32_t BLOCK_WIDTH_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_WIDTH_ONE_GOB; \
    UNUSED uint32_t BLOCK_HEIGHT_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_ONE_GOB; \
    UNUSED uint32_t BLOCK_HEIGHT_TWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_FOUR_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_EIGHT_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_SIXTEEN_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t BLOCK_HEIGHT_THIRTYTWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_ONE_GOB = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_ONE_GOB; \
    UNUSED uint32_t BLOCK_DEPTH_TWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_TWO_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_FOUR_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_EIGHT_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_SIXTEEN_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t BLOCK_DEPTH_THIRTYTWO_GOBS = NVA097_SET_COLOR_TARGET_MEMORY_BLOCK_DEPTH_THIRTYTWO_GOBS; \
    UNUSED uint32_t LAYOUT_BLOCKLINEAR = NVA097_SET_COLOR_TARGET_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t LAYOUT_PITCH = NVA097_SET_COLOR_TARGET_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE = NVA097_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE; \
    UNUSED uint32_t THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE = NVA097_SET_COLOR_TARGET_MEMORY_THIRD_DIMENSION_CONTROL_THIRD_DIMENSION_DEFINES_DEPTH_SIZE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_MEMORY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_MEMORY(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_THIRD_DIMENSION {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_THIRD_DIMENSION st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 28));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_THIRD_DIMENSION __data = { .v = (args) }; \
    __NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(i) V_NVA097_SET_COLOR_TARGET_THIRD_DIMENSION

#define P_NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_THIRD_DIMENSION(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_ARRAY_PITCH {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_TARGET_ARRAY_PITCH(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_ARRAY_PITCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_ARRAY_PITCH(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_ARRAY_PITCH __data = { .v = (args) }; \
    __NVA097_SET_COLOR_TARGET_ARRAY_PITCH(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_ARRAY_PITCH(i) V_NVA097_SET_COLOR_TARGET_ARRAY_PITCH

#define P_NVA097_SET_COLOR_TARGET_ARRAY_PITCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_ARRAY_PITCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_ARRAY_PITCH(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_LAYER {
    uint32_t offset;
};

static inline void
__NVA097_SET_COLOR_TARGET_LAYER(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_LAYER st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 16));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_LAYER(val, args...) { \
    struct nv_nva097_SET_COLOR_TARGET_LAYER __data = { .offset = (args) }; \
    __NVA097_SET_COLOR_TARGET_LAYER(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_LAYER(i) V_NVA097_SET_COLOR_TARGET_LAYER

#define P_NVA097_SET_COLOR_TARGET_LAYER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_LAYER(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_TARGET_MARK {
    uint32_t ieee_clean;
};

static inline void
__NVA097_SET_COLOR_TARGET_MARK(uint32_t *val_out, struct nv_nva097_SET_COLOR_TARGET_MARK st)
{
    uint32_t val = 0;
    
    assert(st.ieee_clean < (1ULL << 1));
    val |= st.ieee_clean << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_TARGET_MARK(val, args...) { \
    UNUSED uint32_t IEEE_CLEAN_FALSE = NVA097_SET_COLOR_TARGET_MARK_IEEE_CLEAN_FALSE; \
    UNUSED uint32_t IEEE_CLEAN_TRUE = NVA097_SET_COLOR_TARGET_MARK_IEEE_CLEAN_TRUE; \
    struct nv_nva097_SET_COLOR_TARGET_MARK __data = { .ieee_clean = (args) }; \
    __NVA097_SET_COLOR_TARGET_MARK(&val, __data); \
}

#define VA_NVA097_SET_COLOR_TARGET_MARK(i) V_NVA097_SET_COLOR_TARGET_MARK

#define P_NVA097_SET_COLOR_TARGET_MARK(push, idx, args...) do { \
    UNUSED uint32_t IEEE_CLEAN_FALSE = NVA097_SET_COLOR_TARGET_MARK_IEEE_CLEAN_FALSE; \
    UNUSED uint32_t IEEE_CLEAN_TRUE = NVA097_SET_COLOR_TARGET_MARK_IEEE_CLEAN_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_TARGET_MARK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_TARGET_MARK(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_SCALE_X {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_SCALE_X(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_SCALE_X st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_SCALE_X(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_SCALE_X __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_SCALE_X(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_SCALE_X(i) V_NVA097_SET_VIEWPORT_SCALE_X

#define P_NVA097_SET_VIEWPORT_SCALE_X(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_SCALE_X(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_SCALE_X(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_SCALE_Y {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_SCALE_Y(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_SCALE_Y st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_SCALE_Y(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_SCALE_Y __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_SCALE_Y(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_SCALE_Y(i) V_NVA097_SET_VIEWPORT_SCALE_Y

#define P_NVA097_SET_VIEWPORT_SCALE_Y(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_SCALE_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_SCALE_Y(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_SCALE_Z {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_SCALE_Z(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_SCALE_Z st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_SCALE_Z(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_SCALE_Z __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_SCALE_Z(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_SCALE_Z(i) V_NVA097_SET_VIEWPORT_SCALE_Z

#define P_NVA097_SET_VIEWPORT_SCALE_Z(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_SCALE_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_SCALE_Z(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_OFFSET_X {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_OFFSET_X(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_OFFSET_X st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_OFFSET_X(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_OFFSET_X __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_OFFSET_X(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_OFFSET_X(i) V_NVA097_SET_VIEWPORT_OFFSET_X

#define P_NVA097_SET_VIEWPORT_OFFSET_X(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_OFFSET_X(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_OFFSET_X(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_OFFSET_Y {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_OFFSET_Y(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_OFFSET_Y st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_OFFSET_Y(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_OFFSET_Y __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_OFFSET_Y(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_OFFSET_Y(i) V_NVA097_SET_VIEWPORT_OFFSET_Y

#define P_NVA097_SET_VIEWPORT_OFFSET_Y(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_OFFSET_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_OFFSET_Y(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_OFFSET_Z {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_OFFSET_Z(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_OFFSET_Z st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_OFFSET_Z(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_OFFSET_Z __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_OFFSET_Z(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_OFFSET_Z(i) V_NVA097_SET_VIEWPORT_OFFSET_Z

#define P_NVA097_SET_VIEWPORT_OFFSET_Z(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_OFFSET_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_OFFSET_Z(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_CLIP_HORIZONTAL {
    uint32_t x0;
    uint32_t width;
};

static inline void
__NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_CLIP_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.x0 < (1ULL << 16));
    val |= st.x0 << 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 16;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_CLIP_HORIZONTAL __data = args; \
    __NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(i) V_NVA097_SET_VIEWPORT_CLIP_HORIZONTAL

#define P_NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_CLIP_HORIZONTAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_CLIP_VERTICAL {
    uint32_t y0;
    uint32_t height;
};

static inline void
__NVA097_SET_VIEWPORT_CLIP_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_CLIP_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.y0 < (1ULL << 16));
    val |= st.y0 << 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 16;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_CLIP_VERTICAL(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_CLIP_VERTICAL __data = args; \
    __NVA097_SET_VIEWPORT_CLIP_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_CLIP_VERTICAL(i) V_NVA097_SET_VIEWPORT_CLIP_VERTICAL

#define P_NVA097_SET_VIEWPORT_CLIP_VERTICAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_CLIP_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_CLIP_VERTICAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_CLIP_MIN_Z {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_CLIP_MIN_Z(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_CLIP_MIN_Z st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_CLIP_MIN_Z(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_CLIP_MIN_Z __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_CLIP_MIN_Z(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_CLIP_MIN_Z(i) V_NVA097_SET_VIEWPORT_CLIP_MIN_Z

#define P_NVA097_SET_VIEWPORT_CLIP_MIN_Z(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_CLIP_MIN_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_CLIP_MIN_Z(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_CLIP_MAX_Z {
    uint32_t v;
};

static inline void
__NVA097_SET_VIEWPORT_CLIP_MAX_Z(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_CLIP_MAX_Z st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_CLIP_MAX_Z(val, args...) { \
    struct nv_nva097_SET_VIEWPORT_CLIP_MAX_Z __data = { .v = (args) }; \
    __NVA097_SET_VIEWPORT_CLIP_MAX_Z(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_CLIP_MAX_Z(i) V_NVA097_SET_VIEWPORT_CLIP_MAX_Z

#define P_NVA097_SET_VIEWPORT_CLIP_MAX_Z(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_CLIP_MAX_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_CLIP_MAX_Z(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_CLIP_HORIZONTAL {
    uint32_t xmin;
    uint32_t xmax;
};

static inline void
__NVA097_SET_WINDOW_CLIP_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_WINDOW_CLIP_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.xmin < (1ULL << 16));
    val |= st.xmin << 0;
    
    assert(st.xmax < (1ULL << 16));
    val |= st.xmax << 16;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_CLIP_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_WINDOW_CLIP_HORIZONTAL __data = args; \
    __NVA097_SET_WINDOW_CLIP_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_CLIP_HORIZONTAL(i) V_NVA097_SET_WINDOW_CLIP_HORIZONTAL

#define P_NVA097_SET_WINDOW_CLIP_HORIZONTAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_CLIP_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_CLIP_HORIZONTAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_CLIP_VERTICAL {
    uint32_t ymin;
    uint32_t ymax;
};

static inline void
__NVA097_SET_WINDOW_CLIP_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_WINDOW_CLIP_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.ymin < (1ULL << 16));
    val |= st.ymin << 0;
    
    assert(st.ymax < (1ULL << 16));
    val |= st.ymax << 16;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_CLIP_VERTICAL(val, args...) { \
    struct nv_nva097_SET_WINDOW_CLIP_VERTICAL __data = args; \
    __NVA097_SET_WINDOW_CLIP_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_CLIP_VERTICAL(i) V_NVA097_SET_WINDOW_CLIP_VERTICAL

#define P_NVA097_SET_WINDOW_CLIP_VERTICAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_CLIP_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_CLIP_VERTICAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID_EXTENT_X {
    uint32_t minx;
    uint32_t width;
};

static inline void
__NVA097_SET_CLIP_ID_EXTENT_X(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID_EXTENT_X st)
{
    uint32_t val = 0;
    
    assert(st.minx < (1ULL << 16));
    val |= st.minx << 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID_EXTENT_X(val, args...) { \
    struct nv_nva097_SET_CLIP_ID_EXTENT_X __data = args; \
    __NVA097_SET_CLIP_ID_EXTENT_X(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID_EXTENT_X(i) V_NVA097_SET_CLIP_ID_EXTENT_X

#define P_NVA097_SET_CLIP_ID_EXTENT_X(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID_EXTENT_X(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID_EXTENT_X(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID_EXTENT_Y {
    uint32_t miny;
    uint32_t height;
};

static inline void
__NVA097_SET_CLIP_ID_EXTENT_Y(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID_EXTENT_Y st)
{
    uint32_t val = 0;
    
    assert(st.miny < (1ULL << 16));
    val |= st.miny << 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID_EXTENT_Y(val, args...) { \
    struct nv_nva097_SET_CLIP_ID_EXTENT_Y __data = args; \
    __NVA097_SET_CLIP_ID_EXTENT_Y(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID_EXTENT_Y(i) V_NVA097_SET_CLIP_ID_EXTENT_Y

#define P_NVA097_SET_CLIP_ID_EXTENT_Y(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID_EXTENT_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID_EXTENT_Y(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK {
    uint32_t v;
};

static inline void
__NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK(uint32_t *val_out, struct nv_nva097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 11));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK(val, args...) { \
    struct nv_nva097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK __data = { .v = (args) }; \
    __NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK(&val, __data); \
}

#define VA_NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK V_NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK

#define P_NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MAX_STREAM_OUTPUT_GS_INSTANCES_PER_TASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_API_VISIBLE_CALL_LIMIT {
    uint32_t v;
};

static inline void
__NVA097_SET_API_VISIBLE_CALL_LIMIT(uint32_t *val_out, struct nv_nva097_SET_API_VISIBLE_CALL_LIMIT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 4));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_API_VISIBLE_CALL_LIMIT(val, args...) { \
    UNUSED uint32_t V__0 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__0; \
    UNUSED uint32_t V__1 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__1; \
    UNUSED uint32_t V__2 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__2; \
    UNUSED uint32_t V__4 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__4; \
    UNUSED uint32_t V__8 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__8; \
    UNUSED uint32_t V__16 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__16; \
    UNUSED uint32_t V__32 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__32; \
    UNUSED uint32_t V__64 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__64; \
    UNUSED uint32_t V__128 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__128; \
    UNUSED uint32_t V_NO_CHECK = NVA097_SET_API_VISIBLE_CALL_LIMIT_V_NO_CHECK; \
    struct nv_nva097_SET_API_VISIBLE_CALL_LIMIT __data = { .v = (args) }; \
    __NVA097_SET_API_VISIBLE_CALL_LIMIT(&val, __data); \
}

#define VA_NVA097_SET_API_VISIBLE_CALL_LIMIT V_NVA097_SET_API_VISIBLE_CALL_LIMIT

#define P_NVA097_SET_API_VISIBLE_CALL_LIMIT(push, args...) do { \
    UNUSED uint32_t V__0 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__0; \
    UNUSED uint32_t V__1 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__1; \
    UNUSED uint32_t V__2 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__2; \
    UNUSED uint32_t V__4 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__4; \
    UNUSED uint32_t V__8 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__8; \
    UNUSED uint32_t V__16 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__16; \
    UNUSED uint32_t V__32 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__32; \
    UNUSED uint32_t V__64 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__64; \
    UNUSED uint32_t V__128 = NVA097_SET_API_VISIBLE_CALL_LIMIT_V__128; \
    UNUSED uint32_t V_NO_CHECK = NVA097_SET_API_VISIBLE_CALL_LIMIT_V_NO_CHECK; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_API_VISIBLE_CALL_LIMIT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_API_VISIBLE_CALL_LIMIT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STATISTICS_COUNTER {
    uint32_t da_vertices_generated_enable;
    uint32_t da_primitives_generated_enable;
    uint32_t vs_invocations_enable;
    uint32_t gs_invocations_enable;
    uint32_t gs_primitives_generated_enable;
    uint32_t streaming_primitives_succeeded_enable;
    uint32_t streaming_primitives_needed_enable;
    uint32_t clipper_invocations_enable;
    uint32_t clipper_primitives_generated_enable;
    uint32_t ps_invocations_enable;
    uint32_t ti_invocations_enable;
    uint32_t ts_invocations_enable;
    uint32_t ts_primitives_generated_enable;
    uint32_t total_streaming_primitives_needed_succeeded_enable;
    uint32_t vtg_primitives_out_enable;
    uint32_t alpha_beta_clocks_enable;
};

static inline void
__NVA097_SET_STATISTICS_COUNTER(uint32_t *val_out, struct nv_nva097_SET_STATISTICS_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.da_vertices_generated_enable < (1ULL << 1));
    val |= st.da_vertices_generated_enable << 0;
    
    assert(st.da_primitives_generated_enable < (1ULL << 1));
    val |= st.da_primitives_generated_enable << 1;
    
    assert(st.vs_invocations_enable < (1ULL << 1));
    val |= st.vs_invocations_enable << 2;
    
    assert(st.gs_invocations_enable < (1ULL << 1));
    val |= st.gs_invocations_enable << 3;
    
    assert(st.gs_primitives_generated_enable < (1ULL << 1));
    val |= st.gs_primitives_generated_enable << 4;
    
    assert(st.streaming_primitives_succeeded_enable < (1ULL << 1));
    val |= st.streaming_primitives_succeeded_enable << 5;
    
    assert(st.streaming_primitives_needed_enable < (1ULL << 1));
    val |= st.streaming_primitives_needed_enable << 6;
    
    assert(st.clipper_invocations_enable < (1ULL << 1));
    val |= st.clipper_invocations_enable << 7;
    
    assert(st.clipper_primitives_generated_enable < (1ULL << 1));
    val |= st.clipper_primitives_generated_enable << 8;
    
    assert(st.ps_invocations_enable < (1ULL << 1));
    val |= st.ps_invocations_enable << 9;
    
    assert(st.ti_invocations_enable < (1ULL << 1));
    val |= st.ti_invocations_enable << 11;
    
    assert(st.ts_invocations_enable < (1ULL << 1));
    val |= st.ts_invocations_enable << 12;
    
    assert(st.ts_primitives_generated_enable < (1ULL << 1));
    val |= st.ts_primitives_generated_enable << 13;
    
    assert(st.total_streaming_primitives_needed_succeeded_enable < (1ULL << 1));
    val |= st.total_streaming_primitives_needed_succeeded_enable << 14;
    
    assert(st.vtg_primitives_out_enable < (1ULL << 1));
    val |= st.vtg_primitives_out_enable << 10;
    
    assert(st.alpha_beta_clocks_enable < (1ULL << 1));
    val |= st.alpha_beta_clocks_enable << 15;
    *val_out = val;
}

#define V_NVA097_SET_STATISTICS_COUNTER(val, args...) { \
    UNUSED uint32_t DA_VERTICES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t DA_VERTICES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t DA_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t DA_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t VS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t VS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t GS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t GS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t GS_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t GS_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE; \
    UNUSED uint32_t CLIPPER_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t CLIPPER_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t PS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t PS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TI_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t TI_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t TS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TS_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t TS_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE; \
    UNUSED uint32_t TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE; \
    UNUSED uint32_t VTG_PRIMITIVES_OUT_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE; \
    UNUSED uint32_t VTG_PRIMITIVES_OUT_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE; \
    UNUSED uint32_t ALPHA_BETA_CLOCKS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE; \
    UNUSED uint32_t ALPHA_BETA_CLOCKS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE; \
    struct nv_nva097_SET_STATISTICS_COUNTER __data = args; \
    __NVA097_SET_STATISTICS_COUNTER(&val, __data); \
}

#define VA_NVA097_SET_STATISTICS_COUNTER V_NVA097_SET_STATISTICS_COUNTER

#define P_NVA097_SET_STATISTICS_COUNTER(push, args...) do { \
    UNUSED uint32_t DA_VERTICES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t DA_VERTICES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_DA_VERTICES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t DA_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t DA_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_DA_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t VS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t VS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_VS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t GS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t GS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_GS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t GS_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t GS_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_GS_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_FALSE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_SUCCEEDED_ENABLE_TRUE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_FALSE; \
    UNUSED uint32_t STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_STREAMING_PRIMITIVES_NEEDED_ENABLE_TRUE; \
    UNUSED uint32_t CLIPPER_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t CLIPPER_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_CLIPPER_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t PS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t PS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_PS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TI_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t TI_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TI_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TS_INVOCATIONS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_FALSE; \
    UNUSED uint32_t TS_INVOCATIONS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TS_INVOCATIONS_ENABLE_TRUE; \
    UNUSED uint32_t TS_PRIMITIVES_GENERATED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_FALSE; \
    UNUSED uint32_t TS_PRIMITIVES_GENERATED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TS_PRIMITIVES_GENERATED_ENABLE_TRUE; \
    UNUSED uint32_t TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_FALSE; \
    UNUSED uint32_t TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_TOTAL_STREAMING_PRIMITIVES_NEEDED_SUCCEEDED_ENABLE_TRUE; \
    UNUSED uint32_t VTG_PRIMITIVES_OUT_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_FALSE; \
    UNUSED uint32_t VTG_PRIMITIVES_OUT_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_VTG_PRIMITIVES_OUT_ENABLE_TRUE; \
    UNUSED uint32_t ALPHA_BETA_CLOCKS_ENABLE_FALSE = NVA097_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_FALSE; \
    UNUSED uint32_t ALPHA_BETA_CLOCKS_ENABLE_TRUE = NVA097_SET_STATISTICS_COUNTER_ALPHA_BETA_CLOCKS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STATISTICS_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STATISTICS_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLEAR_RECT_HORIZONTAL {
    uint32_t xmin;
    uint32_t xmax;
};

static inline void
__NVA097_SET_CLEAR_RECT_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_CLEAR_RECT_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.xmin < (1ULL << 16));
    val |= st.xmin << 0;
    
    assert(st.xmax < (1ULL << 16));
    val |= st.xmax << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLEAR_RECT_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_CLEAR_RECT_HORIZONTAL __data = args; \
    __NVA097_SET_CLEAR_RECT_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_CLEAR_RECT_HORIZONTAL V_NVA097_SET_CLEAR_RECT_HORIZONTAL

#define P_NVA097_SET_CLEAR_RECT_HORIZONTAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLEAR_RECT_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLEAR_RECT_HORIZONTAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLEAR_RECT_VERTICAL {
    uint32_t ymin;
    uint32_t ymax;
};

static inline void
__NVA097_SET_CLEAR_RECT_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_CLEAR_RECT_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.ymin < (1ULL << 16));
    val |= st.ymin << 0;
    
    assert(st.ymax < (1ULL << 16));
    val |= st.ymax << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLEAR_RECT_VERTICAL(val, args...) { \
    struct nv_nva097_SET_CLEAR_RECT_VERTICAL __data = args; \
    __NVA097_SET_CLEAR_RECT_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_CLEAR_RECT_VERTICAL V_NVA097_SET_CLEAR_RECT_VERTICAL

#define P_NVA097_SET_CLEAR_RECT_VERTICAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLEAR_RECT_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLEAR_RECT_VERTICAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_ARRAY_START {
    uint32_t v;
};

static inline void
__NVA097_SET_VERTEX_ARRAY_START(uint32_t *val_out, struct nv_nva097_SET_VERTEX_ARRAY_START st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_ARRAY_START(val, args...) { \
    struct nv_nva097_SET_VERTEX_ARRAY_START __data = { .v = (args) }; \
    __NVA097_SET_VERTEX_ARRAY_START(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_ARRAY_START V_NVA097_SET_VERTEX_ARRAY_START

#define P_NVA097_SET_VERTEX_ARRAY_START(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_ARRAY_START(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_ARRAY_START, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_VERTEX_ARRAY {
    uint32_t count;
};

static inline void
__NVA097_DRAW_VERTEX_ARRAY(uint32_t *val_out, struct nv_nva097_DRAW_VERTEX_ARRAY st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVA097_DRAW_VERTEX_ARRAY(val, args...) { \
    struct nv_nva097_DRAW_VERTEX_ARRAY __data = { .count = (args) }; \
    __NVA097_DRAW_VERTEX_ARRAY(&val, __data); \
}

#define VA_NVA097_DRAW_VERTEX_ARRAY V_NVA097_DRAW_VERTEX_ARRAY

#define P_NVA097_DRAW_VERTEX_ARRAY(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_VERTEX_ARRAY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_VERTEX_ARRAY, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_Z_CLIP {
    uint32_t range;
};

static inline void
__NVA097_SET_VIEWPORT_Z_CLIP(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_Z_CLIP st)
{
    uint32_t val = 0;
    
    assert(st.range < (1ULL << 1));
    val |= st.range << 0;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_Z_CLIP(val, args...) { \
    UNUSED uint32_t RANGE_NEGATIVE_W_TO_POSITIVE_W = NVA097_SET_VIEWPORT_Z_CLIP_RANGE_NEGATIVE_W_TO_POSITIVE_W; \
    UNUSED uint32_t RANGE_ZERO_TO_POSITIVE_W = NVA097_SET_VIEWPORT_Z_CLIP_RANGE_ZERO_TO_POSITIVE_W; \
    struct nv_nva097_SET_VIEWPORT_Z_CLIP __data = { .range = (args) }; \
    __NVA097_SET_VIEWPORT_Z_CLIP(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_Z_CLIP V_NVA097_SET_VIEWPORT_Z_CLIP

#define P_NVA097_SET_VIEWPORT_Z_CLIP(push, args...) do { \
    UNUSED uint32_t RANGE_NEGATIVE_W_TO_POSITIVE_W = NVA097_SET_VIEWPORT_Z_CLIP_RANGE_NEGATIVE_W_TO_POSITIVE_W; \
    UNUSED uint32_t RANGE_ZERO_TO_POSITIVE_W = NVA097_SET_VIEWPORT_Z_CLIP_RANGE_ZERO_TO_POSITIVE_W; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_Z_CLIP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_Z_CLIP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_CLEAR_VALUE {
    uint32_t v;
};

static inline void
__NVA097_SET_COLOR_CLEAR_VALUE(uint32_t *val_out, struct nv_nva097_SET_COLOR_CLEAR_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_CLEAR_VALUE(val, args...) { \
    struct nv_nva097_SET_COLOR_CLEAR_VALUE __data = { .v = (args) }; \
    __NVA097_SET_COLOR_CLEAR_VALUE(&val, __data); \
}

#define VA_NVA097_SET_COLOR_CLEAR_VALUE(i) V_NVA097_SET_COLOR_CLEAR_VALUE

#define P_NVA097_SET_COLOR_CLEAR_VALUE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_CLEAR_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_CLEAR_VALUE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_Z_CLEAR_VALUE {
    uint32_t v;
};

static inline void
__NVA097_SET_Z_CLEAR_VALUE(uint32_t *val_out, struct nv_nva097_SET_Z_CLEAR_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_Z_CLEAR_VALUE(val, args...) { \
    struct nv_nva097_SET_Z_CLEAR_VALUE __data = { .v = (args) }; \
    __NVA097_SET_Z_CLEAR_VALUE(&val, __data); \
}

#define VA_NVA097_SET_Z_CLEAR_VALUE V_NVA097_SET_Z_CLEAR_VALUE

#define P_NVA097_SET_Z_CLEAR_VALUE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_Z_CLEAR_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_Z_CLEAR_VALUE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_CACHE_CONTROL {
    uint32_t icache_prefetch_enable;
};

static inline void
__NVA097_SET_SHADER_CACHE_CONTROL(uint32_t *val_out, struct nv_nva097_SET_SHADER_CACHE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.icache_prefetch_enable < (1ULL << 1));
    val |= st.icache_prefetch_enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_CACHE_CONTROL(val, args...) { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NVA097_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NVA097_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    struct nv_nva097_SET_SHADER_CACHE_CONTROL __data = { .icache_prefetch_enable = (args) }; \
    __NVA097_SET_SHADER_CACHE_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_SHADER_CACHE_CONTROL V_NVA097_SET_SHADER_CACHE_CONTROL

#define P_NVA097_SET_SHADER_CACHE_CONTROL(push, args...) do { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NVA097_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NVA097_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_CACHE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_CACHE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_FORCE_TRANSITION_TO_BETA {
    uint32_t v;
};

static inline void
__NVA097_FORCE_TRANSITION_TO_BETA(uint32_t *val_out, struct nv_nva097_FORCE_TRANSITION_TO_BETA st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_FORCE_TRANSITION_TO_BETA(val, args...) { \
    struct nv_nva097_FORCE_TRANSITION_TO_BETA __data = { .v = (args) }; \
    __NVA097_FORCE_TRANSITION_TO_BETA(&val, __data); \
}

#define VA_NVA097_FORCE_TRANSITION_TO_BETA V_NVA097_FORCE_TRANSITION_TO_BETA

#define P_NVA097_FORCE_TRANSITION_TO_BETA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_FORCE_TRANSITION_TO_BETA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_FORCE_TRANSITION_TO_BETA, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_TRUE; \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_CLEAR_VALUE {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_CLEAR_VALUE(uint32_t *val_out, struct nv_nva097_SET_STENCIL_CLEAR_VALUE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_CLEAR_VALUE(val, args...) { \
    struct nv_nva097_SET_STENCIL_CLEAR_VALUE __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_CLEAR_VALUE(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_CLEAR_VALUE V_NVA097_SET_STENCIL_CLEAR_VALUE

#define P_NVA097_SET_STENCIL_CLEAR_VALUE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_CLEAR_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_CLEAR_VALUE, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_SHADER_CACHES_NO_WFI {
    uint32_t instruction;
    uint32_t global_data;
    uint32_t constant;
};

static inline void
__NVA097_INVALIDATE_SHADER_CACHES_NO_WFI(uint32_t *val_out, struct nv_nva097_INVALIDATE_SHADER_CACHES_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.global_data < (1ULL << 1));
    val |= st.global_data << 4;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_SHADER_CACHES_NO_WFI(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    struct nv_nva097_INVALIDATE_SHADER_CACHES_NO_WFI __data = args; \
    __NVA097_INVALIDATE_SHADER_CACHES_NO_WFI(&val, __data); \
}

#define VA_NVA097_INVALIDATE_SHADER_CACHES_NO_WFI V_NVA097_INVALIDATE_SHADER_CACHES_NO_WFI

#define P_NVA097_INVALIDATE_SHADER_CACHES_NO_WFI(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVA097_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_SHADER_CACHES_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_SHADER_CACHES_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FRONT_POLYGON_MODE {
    uint32_t v;
};

static inline void
__NVA097_SET_FRONT_POLYGON_MODE(uint32_t *val_out, struct nv_nva097_SET_FRONT_POLYGON_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FRONT_POLYGON_MODE(val, args...) { \
    UNUSED uint32_t V_POINT = NVA097_SET_FRONT_POLYGON_MODE_V_POINT; \
    UNUSED uint32_t V_LINE = NVA097_SET_FRONT_POLYGON_MODE_V_LINE; \
    UNUSED uint32_t V_FILL = NVA097_SET_FRONT_POLYGON_MODE_V_FILL; \
    struct nv_nva097_SET_FRONT_POLYGON_MODE __data = { .v = (args) }; \
    __NVA097_SET_FRONT_POLYGON_MODE(&val, __data); \
}

#define VA_NVA097_SET_FRONT_POLYGON_MODE V_NVA097_SET_FRONT_POLYGON_MODE

#define P_NVA097_SET_FRONT_POLYGON_MODE(push, args...) do { \
    UNUSED uint32_t V_POINT = NVA097_SET_FRONT_POLYGON_MODE_V_POINT; \
    UNUSED uint32_t V_LINE = NVA097_SET_FRONT_POLYGON_MODE_V_LINE; \
    UNUSED uint32_t V_FILL = NVA097_SET_FRONT_POLYGON_MODE_V_FILL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FRONT_POLYGON_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FRONT_POLYGON_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_POLYGON_MODE {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_POLYGON_MODE(uint32_t *val_out, struct nv_nva097_SET_BACK_POLYGON_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BACK_POLYGON_MODE(val, args...) { \
    UNUSED uint32_t V_POINT = NVA097_SET_BACK_POLYGON_MODE_V_POINT; \
    UNUSED uint32_t V_LINE = NVA097_SET_BACK_POLYGON_MODE_V_LINE; \
    UNUSED uint32_t V_FILL = NVA097_SET_BACK_POLYGON_MODE_V_FILL; \
    struct nv_nva097_SET_BACK_POLYGON_MODE __data = { .v = (args) }; \
    __NVA097_SET_BACK_POLYGON_MODE(&val, __data); \
}

#define VA_NVA097_SET_BACK_POLYGON_MODE V_NVA097_SET_BACK_POLYGON_MODE

#define P_NVA097_SET_BACK_POLYGON_MODE(push, args...) do { \
    UNUSED uint32_t V_POINT = NVA097_SET_BACK_POLYGON_MODE_V_POINT; \
    UNUSED uint32_t V_LINE = NVA097_SET_BACK_POLYGON_MODE_V_LINE; \
    UNUSED uint32_t V_FILL = NVA097_SET_BACK_POLYGON_MODE_V_FILL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_POLYGON_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_POLYGON_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLY_SMOOTH {
    uint32_t enable;
};

static inline void
__NVA097_SET_POLY_SMOOTH(uint32_t *val_out, struct nv_nva097_SET_POLY_SMOOTH st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POLY_SMOOTH(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_SMOOTH_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_SMOOTH_ENABLE_TRUE; \
    struct nv_nva097_SET_POLY_SMOOTH __data = { .enable = (args) }; \
    __NVA097_SET_POLY_SMOOTH(&val, __data); \
}

#define VA_NVA097_SET_POLY_SMOOTH V_NVA097_SET_POLY_SMOOTH

#define P_NVA097_SET_POLY_SMOOTH(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_SMOOTH_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_SMOOTH_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLY_SMOOTH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLY_SMOOTH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_MARK {
    uint32_t ieee_clean;
};

static inline void
__NVA097_SET_ZT_MARK(uint32_t *val_out, struct nv_nva097_SET_ZT_MARK st)
{
    uint32_t val = 0;
    
    assert(st.ieee_clean < (1ULL << 1));
    val |= st.ieee_clean << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_MARK(val, args...) { \
    UNUSED uint32_t IEEE_CLEAN_FALSE = NVA097_SET_ZT_MARK_IEEE_CLEAN_FALSE; \
    UNUSED uint32_t IEEE_CLEAN_TRUE = NVA097_SET_ZT_MARK_IEEE_CLEAN_TRUE; \
    struct nv_nva097_SET_ZT_MARK __data = { .ieee_clean = (args) }; \
    __NVA097_SET_ZT_MARK(&val, __data); \
}

#define VA_NVA097_SET_ZT_MARK V_NVA097_SET_ZT_MARK

#define P_NVA097_SET_ZT_MARK(push, args...) do { \
    UNUSED uint32_t IEEE_CLEAN_FALSE = NVA097_SET_ZT_MARK_IEEE_CLEAN_FALSE; \
    UNUSED uint32_t IEEE_CLEAN_TRUE = NVA097_SET_ZT_MARK_IEEE_CLEAN_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_MARK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_MARK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_DIR_FORMAT {
    uint32_t zdir;
    uint32_t zformat;
};

static inline void
__NVA097_SET_ZCULL_DIR_FORMAT(uint32_t *val_out, struct nv_nva097_SET_ZCULL_DIR_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.zdir < (1ULL << 16));
    val |= st.zdir << 0;
    
    assert(st.zformat < (1ULL << 16));
    val |= st.zformat << 16;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_DIR_FORMAT(val, args...) { \
    UNUSED uint32_t ZDIR_LESS = NVA097_SET_ZCULL_DIR_FORMAT_ZDIR_LESS; \
    UNUSED uint32_t ZDIR_GREATER = NVA097_SET_ZCULL_DIR_FORMAT_ZDIR_GREATER; \
    UNUSED uint32_t ZFORMAT_MSB = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_MSB; \
    UNUSED uint32_t ZFORMAT_FP = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_FP; \
    UNUSED uint32_t ZFORMAT_ZTRICK = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZTRICK; \
    UNUSED uint32_t ZFORMAT_ZF32_1 = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZF32_1; \
    struct nv_nva097_SET_ZCULL_DIR_FORMAT __data = args; \
    __NVA097_SET_ZCULL_DIR_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_DIR_FORMAT V_NVA097_SET_ZCULL_DIR_FORMAT

#define P_NVA097_SET_ZCULL_DIR_FORMAT(push, args...) do { \
    UNUSED uint32_t ZDIR_LESS = NVA097_SET_ZCULL_DIR_FORMAT_ZDIR_LESS; \
    UNUSED uint32_t ZDIR_GREATER = NVA097_SET_ZCULL_DIR_FORMAT_ZDIR_GREATER; \
    UNUSED uint32_t ZFORMAT_MSB = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_MSB; \
    UNUSED uint32_t ZFORMAT_FP = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_FP; \
    UNUSED uint32_t ZFORMAT_ZTRICK = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZTRICK; \
    UNUSED uint32_t ZFORMAT_ZF32_1 = NVA097_SET_ZCULL_DIR_FORMAT_ZFORMAT_ZF32_1; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_DIR_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_DIR_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLY_OFFSET_POINT {
    uint32_t enable;
};

static inline void
__NVA097_SET_POLY_OFFSET_POINT(uint32_t *val_out, struct nv_nva097_SET_POLY_OFFSET_POINT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POLY_OFFSET_POINT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_POINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_POINT_ENABLE_TRUE; \
    struct nv_nva097_SET_POLY_OFFSET_POINT __data = { .enable = (args) }; \
    __NVA097_SET_POLY_OFFSET_POINT(&val, __data); \
}

#define VA_NVA097_SET_POLY_OFFSET_POINT V_NVA097_SET_POLY_OFFSET_POINT

#define P_NVA097_SET_POLY_OFFSET_POINT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_POINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_POINT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLY_OFFSET_POINT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLY_OFFSET_POINT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLY_OFFSET_LINE {
    uint32_t enable;
};

static inline void
__NVA097_SET_POLY_OFFSET_LINE(uint32_t *val_out, struct nv_nva097_SET_POLY_OFFSET_LINE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POLY_OFFSET_LINE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_LINE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_LINE_ENABLE_TRUE; \
    struct nv_nva097_SET_POLY_OFFSET_LINE __data = { .enable = (args) }; \
    __NVA097_SET_POLY_OFFSET_LINE(&val, __data); \
}

#define VA_NVA097_SET_POLY_OFFSET_LINE V_NVA097_SET_POLY_OFFSET_LINE

#define P_NVA097_SET_POLY_OFFSET_LINE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_LINE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_LINE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLY_OFFSET_LINE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLY_OFFSET_LINE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLY_OFFSET_FILL {
    uint32_t enable;
};

static inline void
__NVA097_SET_POLY_OFFSET_FILL(uint32_t *val_out, struct nv_nva097_SET_POLY_OFFSET_FILL st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POLY_OFFSET_FILL(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_FILL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_FILL_ENABLE_TRUE; \
    struct nv_nva097_SET_POLY_OFFSET_FILL __data = { .enable = (args) }; \
    __NVA097_SET_POLY_OFFSET_FILL(&val, __data); \
}

#define VA_NVA097_SET_POLY_OFFSET_FILL V_NVA097_SET_POLY_OFFSET_FILL

#define P_NVA097_SET_POLY_OFFSET_FILL(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLY_OFFSET_FILL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLY_OFFSET_FILL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLY_OFFSET_FILL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLY_OFFSET_FILL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PATCH {
    uint32_t size;
};

static inline void
__NVA097_SET_PATCH(uint32_t *val_out, struct nv_nva097_SET_PATCH st)
{
    uint32_t val = 0;
    
    assert(st.size < (1ULL << 8));
    val |= st.size << 0;
    *val_out = val;
}

#define V_NVA097_SET_PATCH(val, args...) { \
    struct nv_nva097_SET_PATCH __data = { .size = (args) }; \
    __NVA097_SET_PATCH(&val, __data); \
}

#define VA_NVA097_SET_PATCH V_NVA097_SET_PATCH

#define P_NVA097_SET_PATCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PATCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PATCH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_CRITERION {
    uint32_t sfunc;
    uint32_t no_invalidate;
    uint32_t force_match;
    uint32_t sref;
    uint32_t smask;
};

static inline void
__NVA097_SET_ZCULL_CRITERION(uint32_t *val_out, struct nv_nva097_SET_ZCULL_CRITERION st)
{
    uint32_t val = 0;
    
    assert(st.sfunc < (1ULL << 8));
    val |= st.sfunc << 0;
    
    assert(st.no_invalidate < (1ULL << 1));
    val |= st.no_invalidate << 8;
    
    assert(st.force_match < (1ULL << 1));
    val |= st.force_match << 9;
    
    assert(st.sref < (1ULL << 8));
    val |= st.sref << 16;
    
    assert(st.smask < (1ULL << 8));
    val |= st.smask << 24;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_CRITERION(val, args...) { \
    UNUSED uint32_t SFUNC_NEVER = NVA097_SET_ZCULL_CRITERION_SFUNC_NEVER; \
    UNUSED uint32_t SFUNC_LESS = NVA097_SET_ZCULL_CRITERION_SFUNC_LESS; \
    UNUSED uint32_t SFUNC_EQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_EQUAL; \
    UNUSED uint32_t SFUNC_LEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_LEQUAL; \
    UNUSED uint32_t SFUNC_GREATER = NVA097_SET_ZCULL_CRITERION_SFUNC_GREATER; \
    UNUSED uint32_t SFUNC_NOTEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_NOTEQUAL; \
    UNUSED uint32_t SFUNC_GEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_GEQUAL; \
    UNUSED uint32_t SFUNC_ALWAYS = NVA097_SET_ZCULL_CRITERION_SFUNC_ALWAYS; \
    UNUSED uint32_t NO_INVALIDATE_FALSE = NVA097_SET_ZCULL_CRITERION_NO_INVALIDATE_FALSE; \
    UNUSED uint32_t NO_INVALIDATE_TRUE = NVA097_SET_ZCULL_CRITERION_NO_INVALIDATE_TRUE; \
    UNUSED uint32_t FORCE_MATCH_FALSE = NVA097_SET_ZCULL_CRITERION_FORCE_MATCH_FALSE; \
    UNUSED uint32_t FORCE_MATCH_TRUE = NVA097_SET_ZCULL_CRITERION_FORCE_MATCH_TRUE; \
    struct nv_nva097_SET_ZCULL_CRITERION __data = args; \
    __NVA097_SET_ZCULL_CRITERION(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_CRITERION V_NVA097_SET_ZCULL_CRITERION

#define P_NVA097_SET_ZCULL_CRITERION(push, args...) do { \
    UNUSED uint32_t SFUNC_NEVER = NVA097_SET_ZCULL_CRITERION_SFUNC_NEVER; \
    UNUSED uint32_t SFUNC_LESS = NVA097_SET_ZCULL_CRITERION_SFUNC_LESS; \
    UNUSED uint32_t SFUNC_EQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_EQUAL; \
    UNUSED uint32_t SFUNC_LEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_LEQUAL; \
    UNUSED uint32_t SFUNC_GREATER = NVA097_SET_ZCULL_CRITERION_SFUNC_GREATER; \
    UNUSED uint32_t SFUNC_NOTEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_NOTEQUAL; \
    UNUSED uint32_t SFUNC_GEQUAL = NVA097_SET_ZCULL_CRITERION_SFUNC_GEQUAL; \
    UNUSED uint32_t SFUNC_ALWAYS = NVA097_SET_ZCULL_CRITERION_SFUNC_ALWAYS; \
    UNUSED uint32_t NO_INVALIDATE_FALSE = NVA097_SET_ZCULL_CRITERION_NO_INVALIDATE_FALSE; \
    UNUSED uint32_t NO_INVALIDATE_TRUE = NVA097_SET_ZCULL_CRITERION_NO_INVALIDATE_TRUE; \
    UNUSED uint32_t FORCE_MATCH_FALSE = NVA097_SET_ZCULL_CRITERION_FORCE_MATCH_FALSE; \
    UNUSED uint32_t FORCE_MATCH_TRUE = NVA097_SET_ZCULL_CRITERION_FORCE_MATCH_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_CRITERION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_CRITERION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SM_TIMEOUT_INTERVAL {
    uint32_t counter_bit;
};

static inline void
__NVA097_SET_SM_TIMEOUT_INTERVAL(uint32_t *val_out, struct nv_nva097_SET_SM_TIMEOUT_INTERVAL st)
{
    uint32_t val = 0;
    
    assert(st.counter_bit < (1ULL << 6));
    val |= st.counter_bit << 0;
    *val_out = val;
}

#define V_NVA097_SET_SM_TIMEOUT_INTERVAL(val, args...) { \
    struct nv_nva097_SET_SM_TIMEOUT_INTERVAL __data = { .counter_bit = (args) }; \
    __NVA097_SET_SM_TIMEOUT_INTERVAL(&val, __data); \
}

#define VA_NVA097_SET_SM_TIMEOUT_INTERVAL V_NVA097_SET_SM_TIMEOUT_INTERVAL

#define P_NVA097_SET_SM_TIMEOUT_INTERVAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SM_TIMEOUT_INTERVAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SM_TIMEOUT_INTERVAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY {
    uint32_t enable;
};

static inline void
__NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY(uint32_t *val_out, struct nv_nva097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_TRUE; \
    struct nv_nva097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY __data = { .enable = (args) }; \
    __NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY(&val, __data); \
}

#define VA_NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY V_NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY

#define P_NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_PRIMITIVE_RESTART_VERTEX_ARRAY, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE {
    uint32_t enable;
};

static inline void
__NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE(uint32_t *val_out, struct nv_nva097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_TRUE; \
    struct nv_nva097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE __data = { .enable = (args) }; \
    __NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE(&val, __data); \
}

#define VA_NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE V_NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE

#define P_NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DRAW_INLINE_VERTEX_VAB_UPDATE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_OFFSET_X {
    uint32_t v;
};

static inline void
__NVA097_SET_WINDOW_OFFSET_X(uint32_t *val_out, struct nv_nva097_SET_WINDOW_OFFSET_X st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 17));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_OFFSET_X(val, args...) { \
    struct nv_nva097_SET_WINDOW_OFFSET_X __data = { .v = (args) }; \
    __NVA097_SET_WINDOW_OFFSET_X(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_OFFSET_X V_NVA097_SET_WINDOW_OFFSET_X

#define P_NVA097_SET_WINDOW_OFFSET_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_OFFSET_X(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_OFFSET_X, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_OFFSET_Y {
    uint32_t v;
};

static inline void
__NVA097_SET_WINDOW_OFFSET_Y(uint32_t *val_out, struct nv_nva097_SET_WINDOW_OFFSET_Y st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 18));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_OFFSET_Y(val, args...) { \
    struct nv_nva097_SET_WINDOW_OFFSET_Y __data = { .v = (args) }; \
    __NVA097_SET_WINDOW_OFFSET_Y(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_OFFSET_Y V_NVA097_SET_WINDOW_OFFSET_Y

#define P_NVA097_SET_WINDOW_OFFSET_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_OFFSET_Y(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_OFFSET_Y, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SCISSOR_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_SCISSOR_ENABLE(uint32_t *val_out, struct nv_nva097_SET_SCISSOR_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SCISSOR_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_SCISSOR_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_SCISSOR_ENABLE_V_TRUE; \
    struct nv_nva097_SET_SCISSOR_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_SCISSOR_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_SCISSOR_ENABLE(i) V_NVA097_SET_SCISSOR_ENABLE

#define P_NVA097_SET_SCISSOR_ENABLE(push, idx, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_SCISSOR_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_SCISSOR_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SCISSOR_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SCISSOR_ENABLE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SCISSOR_HORIZONTAL {
    uint32_t xmin;
    uint32_t xmax;
};

static inline void
__NVA097_SET_SCISSOR_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_SCISSOR_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.xmin < (1ULL << 16));
    val |= st.xmin << 0;
    
    assert(st.xmax < (1ULL << 16));
    val |= st.xmax << 16;
    *val_out = val;
}

#define V_NVA097_SET_SCISSOR_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_SCISSOR_HORIZONTAL __data = args; \
    __NVA097_SET_SCISSOR_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_SCISSOR_HORIZONTAL(i) V_NVA097_SET_SCISSOR_HORIZONTAL

#define P_NVA097_SET_SCISSOR_HORIZONTAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SCISSOR_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SCISSOR_HORIZONTAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SCISSOR_VERTICAL {
    uint32_t ymin;
    uint32_t ymax;
};

static inline void
__NVA097_SET_SCISSOR_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_SCISSOR_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.ymin < (1ULL << 16));
    val |= st.ymin << 0;
    
    assert(st.ymax < (1ULL << 16));
    val |= st.ymax << 16;
    *val_out = val;
}

#define V_NVA097_SET_SCISSOR_VERTICAL(val, args...) { \
    struct nv_nva097_SET_SCISSOR_VERTICAL __data = args; \
    __NVA097_SET_SCISSOR_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_SCISSOR_VERTICAL(i) V_NVA097_SET_SCISSOR_VERTICAL

#define P_NVA097_SET_SCISSOR_VERTICAL(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SCISSOR_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SCISSOR_VERTICAL(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_NORMAL3S {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_NORMAL3S(uint32_t *val_out, struct nv_nva097_SET_VAB_NORMAL3S st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_NORMAL3S(val, args...) { \
    struct nv_nva097_SET_VAB_NORMAL3S __data = { .v = (args) }; \
    __NVA097_SET_VAB_NORMAL3S(&val, __data); \
}

#define VA_NVA097_SET_VAB_NORMAL3S(i) V_NVA097_SET_VAB_NORMAL3S

#define P_NVA097_SET_VAB_NORMAL3S(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_NORMAL3S(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_NORMAL3S(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_FUNC_REF {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_FUNC_REF(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_FUNC_REF st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_FUNC_REF(val, args...) { \
    struct nv_nva097_SET_BACK_STENCIL_FUNC_REF __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_FUNC_REF(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_FUNC_REF V_NVA097_SET_BACK_STENCIL_FUNC_REF

#define P_NVA097_SET_BACK_STENCIL_FUNC_REF(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_FUNC_REF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_FUNC_REF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_MASK {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_MASK(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_MASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_MASK(val, args...) { \
    struct nv_nva097_SET_BACK_STENCIL_MASK __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_MASK(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_MASK V_NVA097_SET_BACK_STENCIL_MASK

#define P_NVA097_SET_BACK_STENCIL_MASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_MASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_MASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_FUNC_MASK {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_FUNC_MASK(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_FUNC_MASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_FUNC_MASK(val, args...) { \
    struct nv_nva097_SET_BACK_STENCIL_FUNC_MASK __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_FUNC_MASK(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_FUNC_MASK V_NVA097_SET_BACK_STENCIL_FUNC_MASK

#define P_NVA097_SET_BACK_STENCIL_FUNC_MASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_FUNC_MASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_FUNC_MASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_A __data = { .address_upper = (args) }; \
    __NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A

#define P_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_SUBSTITUTE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_SUBSTITUTE_B __data = { .address_lower = (args) }; \
    __NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B

#define P_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_SUBSTITUTE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_MODE_POLYGON_CLIP {
    uint32_t generated_edge;
};

static inline void
__NVA097_SET_LINE_MODE_POLYGON_CLIP(uint32_t *val_out, struct nv_nva097_SET_LINE_MODE_POLYGON_CLIP st)
{
    uint32_t val = 0;
    
    assert(st.generated_edge < (1ULL << 1));
    val |= st.generated_edge << 0;
    *val_out = val;
}

#define V_NVA097_SET_LINE_MODE_POLYGON_CLIP(val, args...) { \
    UNUSED uint32_t GENERATED_EDGE_DRAW_LINE = NVA097_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DRAW_LINE; \
    UNUSED uint32_t GENERATED_EDGE_DO_NOT_DRAW_LINE = NVA097_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DO_NOT_DRAW_LINE; \
    struct nv_nva097_SET_LINE_MODE_POLYGON_CLIP __data = { .generated_edge = (args) }; \
    __NVA097_SET_LINE_MODE_POLYGON_CLIP(&val, __data); \
}

#define VA_NVA097_SET_LINE_MODE_POLYGON_CLIP V_NVA097_SET_LINE_MODE_POLYGON_CLIP

#define P_NVA097_SET_LINE_MODE_POLYGON_CLIP(push, args...) do { \
    UNUSED uint32_t GENERATED_EDGE_DRAW_LINE = NVA097_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DRAW_LINE; \
    UNUSED uint32_t GENERATED_EDGE_DO_NOT_DRAW_LINE = NVA097_SET_LINE_MODE_POLYGON_CLIP_GENERATED_EDGE_DO_NOT_DRAW_LINE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_MODE_POLYGON_CLIP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_MODE_POLYGON_CLIP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SINGLE_CT_WRITE_CONTROL {
    uint32_t enable;
};

static inline void
__NVA097_SET_SINGLE_CT_WRITE_CONTROL(uint32_t *val_out, struct nv_nva097_SET_SINGLE_CT_WRITE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SINGLE_CT_WRITE_CONTROL(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_TRUE; \
    struct nv_nva097_SET_SINGLE_CT_WRITE_CONTROL __data = { .enable = (args) }; \
    __NVA097_SET_SINGLE_CT_WRITE_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_SINGLE_CT_WRITE_CONTROL V_NVA097_SET_SINGLE_CT_WRITE_CONTROL

#define P_NVA097_SET_SINGLE_CT_WRITE_CONTROL(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SINGLE_CT_WRITE_CONTROL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SINGLE_CT_WRITE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SINGLE_CT_WRITE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VTG_WARP_WATERMARKS {
    uint32_t low;
    uint32_t high;
};

static inline void
__NVA097_SET_VTG_WARP_WATERMARKS(uint32_t *val_out, struct nv_nva097_SET_VTG_WARP_WATERMARKS st)
{
    uint32_t val = 0;
    
    assert(st.low < (1ULL << 16));
    val |= st.low << 0;
    
    assert(st.high < (1ULL << 16));
    val |= st.high << 16;
    *val_out = val;
}

#define V_NVA097_SET_VTG_WARP_WATERMARKS(val, args...) { \
    struct nv_nva097_SET_VTG_WARP_WATERMARKS __data = args; \
    __NVA097_SET_VTG_WARP_WATERMARKS(&val, __data); \
}

#define VA_NVA097_SET_VTG_WARP_WATERMARKS V_NVA097_SET_VTG_WARP_WATERMARKS

#define P_NVA097_SET_VTG_WARP_WATERMARKS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VTG_WARP_WATERMARKS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VTG_WARP_WATERMARKS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BOUNDS_MIN {
    uint32_t v;
};

static inline void
__NVA097_SET_DEPTH_BOUNDS_MIN(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BOUNDS_MIN st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BOUNDS_MIN(val, args...) { \
    struct nv_nva097_SET_DEPTH_BOUNDS_MIN __data = { .v = (args) }; \
    __NVA097_SET_DEPTH_BOUNDS_MIN(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BOUNDS_MIN V_NVA097_SET_DEPTH_BOUNDS_MIN

#define P_NVA097_SET_DEPTH_BOUNDS_MIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BOUNDS_MIN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BOUNDS_MIN, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BOUNDS_MAX {
    uint32_t v;
};

static inline void
__NVA097_SET_DEPTH_BOUNDS_MAX(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BOUNDS_MAX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BOUNDS_MAX(val, args...) { \
    struct nv_nva097_SET_DEPTH_BOUNDS_MAX __data = { .v = (args) }; \
    __NVA097_SET_DEPTH_BOUNDS_MAX(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BOUNDS_MAX V_NVA097_SET_DEPTH_BOUNDS_MAX

#define P_NVA097_SET_DEPTH_BOUNDS_MAX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BOUNDS_MAX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BOUNDS_MAX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CT_MRT_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_CT_MRT_ENABLE(uint32_t *val_out, struct nv_nva097_SET_CT_MRT_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_CT_MRT_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_CT_MRT_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_CT_MRT_ENABLE_V_TRUE; \
    struct nv_nva097_SET_CT_MRT_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_CT_MRT_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_CT_MRT_ENABLE V_NVA097_SET_CT_MRT_ENABLE

#define P_NVA097_SET_CT_MRT_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_CT_MRT_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_CT_MRT_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CT_MRT_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CT_MRT_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_NONMULTISAMPLED_Z {
    uint32_t v;
};

static inline void
__NVA097_SET_NONMULTISAMPLED_Z(uint32_t *val_out, struct nv_nva097_SET_NONMULTISAMPLED_Z st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_NONMULTISAMPLED_Z(val, args...) { \
    UNUSED uint32_t V_PER_SAMPLE = NVA097_SET_NONMULTISAMPLED_Z_V_PER_SAMPLE; \
    UNUSED uint32_t V_AT_PIXEL_CENTER = NVA097_SET_NONMULTISAMPLED_Z_V_AT_PIXEL_CENTER; \
    struct nv_nva097_SET_NONMULTISAMPLED_Z __data = { .v = (args) }; \
    __NVA097_SET_NONMULTISAMPLED_Z(&val, __data); \
}

#define VA_NVA097_SET_NONMULTISAMPLED_Z V_NVA097_SET_NONMULTISAMPLED_Z

#define P_NVA097_SET_NONMULTISAMPLED_Z(push, args...) do { \
    UNUSED uint32_t V_PER_SAMPLE = NVA097_SET_NONMULTISAMPLED_Z_V_PER_SAMPLE; \
    UNUSED uint32_t V_AT_PIXEL_CENTER = NVA097_SET_NONMULTISAMPLED_Z_V_AT_PIXEL_CENTER; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_NONMULTISAMPLED_Z(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_NONMULTISAMPLED_Z, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SAMPLE_MASK_X0_Y0 {
    uint32_t v;
};

static inline void
__NVA097_SET_SAMPLE_MASK_X0_Y0(uint32_t *val_out, struct nv_nva097_SET_SAMPLE_MASK_X0_Y0 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SAMPLE_MASK_X0_Y0(val, args...) { \
    struct nv_nva097_SET_SAMPLE_MASK_X0_Y0 __data = { .v = (args) }; \
    __NVA097_SET_SAMPLE_MASK_X0_Y0(&val, __data); \
}

#define VA_NVA097_SET_SAMPLE_MASK_X0_Y0 V_NVA097_SET_SAMPLE_MASK_X0_Y0

#define P_NVA097_SET_SAMPLE_MASK_X0_Y0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SAMPLE_MASK_X0_Y0(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SAMPLE_MASK_X0_Y0, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SAMPLE_MASK_X1_Y0 {
    uint32_t v;
};

static inline void
__NVA097_SET_SAMPLE_MASK_X1_Y0(uint32_t *val_out, struct nv_nva097_SET_SAMPLE_MASK_X1_Y0 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SAMPLE_MASK_X1_Y0(val, args...) { \
    struct nv_nva097_SET_SAMPLE_MASK_X1_Y0 __data = { .v = (args) }; \
    __NVA097_SET_SAMPLE_MASK_X1_Y0(&val, __data); \
}

#define VA_NVA097_SET_SAMPLE_MASK_X1_Y0 V_NVA097_SET_SAMPLE_MASK_X1_Y0

#define P_NVA097_SET_SAMPLE_MASK_X1_Y0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SAMPLE_MASK_X1_Y0(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SAMPLE_MASK_X1_Y0, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SAMPLE_MASK_X0_Y1 {
    uint32_t v;
};

static inline void
__NVA097_SET_SAMPLE_MASK_X0_Y1(uint32_t *val_out, struct nv_nva097_SET_SAMPLE_MASK_X0_Y1 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SAMPLE_MASK_X0_Y1(val, args...) { \
    struct nv_nva097_SET_SAMPLE_MASK_X0_Y1 __data = { .v = (args) }; \
    __NVA097_SET_SAMPLE_MASK_X0_Y1(&val, __data); \
}

#define VA_NVA097_SET_SAMPLE_MASK_X0_Y1 V_NVA097_SET_SAMPLE_MASK_X0_Y1

#define P_NVA097_SET_SAMPLE_MASK_X0_Y1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SAMPLE_MASK_X0_Y1(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SAMPLE_MASK_X0_Y1, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SAMPLE_MASK_X1_Y1 {
    uint32_t v;
};

static inline void
__NVA097_SET_SAMPLE_MASK_X1_Y1(uint32_t *val_out, struct nv_nva097_SET_SAMPLE_MASK_X1_Y1 st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SAMPLE_MASK_X1_Y1(val, args...) { \
    struct nv_nva097_SET_SAMPLE_MASK_X1_Y1 __data = { .v = (args) }; \
    __NVA097_SET_SAMPLE_MASK_X1_Y1(&val, __data); \
}

#define VA_NVA097_SET_SAMPLE_MASK_X1_Y1 V_NVA097_SET_SAMPLE_MASK_X1_Y1

#define P_NVA097_SET_SAMPLE_MASK_X1_Y1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SAMPLE_MASK_X1_Y1(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SAMPLE_MASK_X1_Y1, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_SURFACE_CLIP_ID_MEMORY_A(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_A(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_SURFACE_CLIP_ID_MEMORY_A(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_ID_MEMORY_A V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_A

#define P_NVA097_SET_SURFACE_CLIP_ID_MEMORY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_ID_MEMORY_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_SURFACE_CLIP_ID_MEMORY_B(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_B(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_ID_MEMORY_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_SURFACE_CLIP_ID_MEMORY_B(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_ID_MEMORY_B V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_B

#define P_NVA097_SET_SURFACE_CLIP_ID_MEMORY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_ID_MEMORY_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_ID_MEMORY_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_OPT_CONTROL {
    uint32_t allow_float_pixel_kills;
};

static inline void
__NVA097_SET_BLEND_OPT_CONTROL(uint32_t *val_out, struct nv_nva097_SET_BLEND_OPT_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.allow_float_pixel_kills < (1ULL << 1));
    val |= st.allow_float_pixel_kills << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_OPT_CONTROL(val, args...) { \
    UNUSED uint32_t ALLOW_FLOAT_PIXEL_KILLS_FALSE = NVA097_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_FALSE; \
    UNUSED uint32_t ALLOW_FLOAT_PIXEL_KILLS_TRUE = NVA097_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_TRUE; \
    struct nv_nva097_SET_BLEND_OPT_CONTROL __data = { .allow_float_pixel_kills = (args) }; \
    __NVA097_SET_BLEND_OPT_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_BLEND_OPT_CONTROL V_NVA097_SET_BLEND_OPT_CONTROL

#define P_NVA097_SET_BLEND_OPT_CONTROL(push, args...) do { \
    UNUSED uint32_t ALLOW_FLOAT_PIXEL_KILLS_FALSE = NVA097_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_FALSE; \
    UNUSED uint32_t ALLOW_FLOAT_PIXEL_KILLS_TRUE = NVA097_SET_BLEND_OPT_CONTROL_ALLOW_FLOAT_PIXEL_KILLS_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_OPT_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_OPT_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_ZT_A(uint32_t *val_out, struct nv_nva097_SET_ZT_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_A(val, args...) { \
    struct nv_nva097_SET_ZT_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_ZT_A(&val, __data); \
}

#define VA_NVA097_SET_ZT_A V_NVA097_SET_ZT_A

#define P_NVA097_SET_ZT_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_ZT_B(uint32_t *val_out, struct nv_nva097_SET_ZT_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_ZT_B(val, args...) { \
    struct nv_nva097_SET_ZT_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_ZT_B(&val, __data); \
}

#define VA_NVA097_SET_ZT_B V_NVA097_SET_ZT_B

#define P_NVA097_SET_ZT_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_FORMAT {
    uint32_t v;
};

static inline void
__NVA097_SET_ZT_FORMAT(uint32_t *val_out, struct nv_nva097_SET_ZT_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 5));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_FORMAT(val, args...) { \
    UNUSED uint32_t V_Z16 = NVA097_SET_ZT_FORMAT_V_Z16; \
    UNUSED uint32_t V_Z24S8 = NVA097_SET_ZT_FORMAT_V_Z24S8; \
    UNUSED uint32_t V_X8Z24 = NVA097_SET_ZT_FORMAT_V_X8Z24; \
    UNUSED uint32_t V_S8Z24 = NVA097_SET_ZT_FORMAT_V_S8Z24; \
    UNUSED uint32_t V_V8Z24 = NVA097_SET_ZT_FORMAT_V_V8Z24; \
    UNUSED uint32_t V_ZF32 = NVA097_SET_ZT_FORMAT_V_ZF32; \
    UNUSED uint32_t V_ZF32_X24S8 = NVA097_SET_ZT_FORMAT_V_ZF32_X24S8; \
    UNUSED uint32_t V_X8Z24_X16V8S8 = NVA097_SET_ZT_FORMAT_V_X8Z24_X16V8S8; \
    UNUSED uint32_t V_ZF32_X16V8X8 = NVA097_SET_ZT_FORMAT_V_ZF32_X16V8X8; \
    UNUSED uint32_t V_ZF32_X16V8S8 = NVA097_SET_ZT_FORMAT_V_ZF32_X16V8S8; \
    struct nv_nva097_SET_ZT_FORMAT __data = { .v = (args) }; \
    __NVA097_SET_ZT_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_ZT_FORMAT V_NVA097_SET_ZT_FORMAT

#define P_NVA097_SET_ZT_FORMAT(push, args...) do { \
    UNUSED uint32_t V_Z16 = NVA097_SET_ZT_FORMAT_V_Z16; \
    UNUSED uint32_t V_Z24S8 = NVA097_SET_ZT_FORMAT_V_Z24S8; \
    UNUSED uint32_t V_X8Z24 = NVA097_SET_ZT_FORMAT_V_X8Z24; \
    UNUSED uint32_t V_S8Z24 = NVA097_SET_ZT_FORMAT_V_S8Z24; \
    UNUSED uint32_t V_V8Z24 = NVA097_SET_ZT_FORMAT_V_V8Z24; \
    UNUSED uint32_t V_ZF32 = NVA097_SET_ZT_FORMAT_V_ZF32; \
    UNUSED uint32_t V_ZF32_X24S8 = NVA097_SET_ZT_FORMAT_V_ZF32_X24S8; \
    UNUSED uint32_t V_X8Z24_X16V8S8 = NVA097_SET_ZT_FORMAT_V_X8Z24_X16V8S8; \
    UNUSED uint32_t V_ZF32_X16V8X8 = NVA097_SET_ZT_FORMAT_V_ZF32_X16V8X8; \
    UNUSED uint32_t V_ZF32_X16V8S8 = NVA097_SET_ZT_FORMAT_V_ZF32_X16V8S8; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
};

static inline void
__NVA097_SET_ZT_BLOCK_SIZE(uint32_t *val_out, struct nv_nva097_SET_ZT_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NVA097_SET_ZT_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_DEPTH_ONE_GOB; \
    struct nv_nva097_SET_ZT_BLOCK_SIZE __data = args; \
    __NVA097_SET_ZT_BLOCK_SIZE(&val, __data); \
}

#define VA_NVA097_SET_ZT_BLOCK_SIZE V_NVA097_SET_ZT_BLOCK_SIZE

#define P_NVA097_SET_ZT_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVA097_SET_ZT_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVA097_SET_ZT_BLOCK_SIZE_DEPTH_ONE_GOB; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_ARRAY_PITCH {
    uint32_t v;
};

static inline void
__NVA097_SET_ZT_ARRAY_PITCH(uint32_t *val_out, struct nv_nva097_SET_ZT_ARRAY_PITCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_ZT_ARRAY_PITCH(val, args...) { \
    struct nv_nva097_SET_ZT_ARRAY_PITCH __data = { .v = (args) }; \
    __NVA097_SET_ZT_ARRAY_PITCH(&val, __data); \
}

#define VA_NVA097_SET_ZT_ARRAY_PITCH V_NVA097_SET_ZT_ARRAY_PITCH

#define P_NVA097_SET_ZT_ARRAY_PITCH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_ARRAY_PITCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_ARRAY_PITCH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_HORIZONTAL {
    uint32_t x;
    uint32_t width;
};

static inline void
__NVA097_SET_SURFACE_CLIP_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.x < (1ULL << 16));
    val |= st.x << 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 16;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_HORIZONTAL __data = args; \
    __NVA097_SET_SURFACE_CLIP_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_HORIZONTAL V_NVA097_SET_SURFACE_CLIP_HORIZONTAL

#define P_NVA097_SET_SURFACE_CLIP_HORIZONTAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_HORIZONTAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_VERTICAL {
    uint32_t y;
    uint32_t height;
};

static inline void
__NVA097_SET_SURFACE_CLIP_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.y < (1ULL << 16));
    val |= st.y << 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 16;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_VERTICAL(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_VERTICAL __data = args; \
    __NVA097_SET_SURFACE_CLIP_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_VERTICAL V_NVA097_SET_SURFACE_CLIP_VERTICAL

#define P_NVA097_SET_SURFACE_CLIP_VERTICAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_VERTICAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS {
    uint32_t system_memory_volatile;
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.system_memory_volatile < (1ULL << 1));
    val |= st.system_memory_volatile << 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS(val, args...) { \
    UNUSED uint32_t SYSTEM_MEMORY_VOLATILE_FALSE = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_FALSE; \
    UNUSED uint32_t SYSTEM_MEMORY_VOLATILE_TRUE = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_TRUE; \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS __data = args; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS(push, args...) do { \
    UNUSED uint32_t SYSTEM_MEMORY_VOLATILE_FALSE = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_FALSE; \
    UNUSED uint32_t SYSTEM_MEMORY_VOLATILE_TRUE = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_SYSTEM_MEMORY_VOLATILE_TRUE; \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_VAF_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TESSELLATION_CUT_HEIGHT {
    uint32_t v;
};

static inline void
__NVA097_SET_TESSELLATION_CUT_HEIGHT(uint32_t *val_out, struct nv_nva097_SET_TESSELLATION_CUT_HEIGHT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 5));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_TESSELLATION_CUT_HEIGHT(val, args...) { \
    struct nv_nva097_SET_TESSELLATION_CUT_HEIGHT __data = { .v = (args) }; \
    __NVA097_SET_TESSELLATION_CUT_HEIGHT(&val, __data); \
}

#define VA_NVA097_SET_TESSELLATION_CUT_HEIGHT V_NVA097_SET_TESSELLATION_CUT_HEIGHT

#define P_NVA097_SET_TESSELLATION_CUT_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TESSELLATION_CUT_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TESSELLATION_CUT_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MAX_GS_INSTANCES_PER_TASK {
    uint32_t v;
};

static inline void
__NVA097_SET_MAX_GS_INSTANCES_PER_TASK(uint32_t *val_out, struct nv_nva097_SET_MAX_GS_INSTANCES_PER_TASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 11));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_MAX_GS_INSTANCES_PER_TASK(val, args...) { \
    struct nv_nva097_SET_MAX_GS_INSTANCES_PER_TASK __data = { .v = (args) }; \
    __NVA097_SET_MAX_GS_INSTANCES_PER_TASK(&val, __data); \
}

#define VA_NVA097_SET_MAX_GS_INSTANCES_PER_TASK V_NVA097_SET_MAX_GS_INSTANCES_PER_TASK

#define P_NVA097_SET_MAX_GS_INSTANCES_PER_TASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MAX_GS_INSTANCES_PER_TASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MAX_GS_INSTANCES_PER_TASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK {
    uint32_t v;
};

static inline void
__NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK(uint32_t *val_out, struct nv_nva097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK(val, args...) { \
    struct nv_nva097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK __data = { .v = (args) }; \
    __NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK(&val, __data); \
}

#define VA_NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK V_NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK

#define P_NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MAX_GS_OUTPUT_VERTICES_PER_TASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER {
    uint32_t v;
};

static inline void
__NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER(uint32_t *val_out, struct nv_nva097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 10));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER(val, args...) { \
    struct nv_nva097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER __data = { .v = (args) }; \
    __NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER(&val, __data); \
}

#define VA_NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER V_NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER

#define P_NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GS_OUTPUT_CB_STORAGE_MULTIPLIER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BETA_CB_STORAGE_CONSTRAINT {
    uint32_t enable;
};

static inline void
__NVA097_SET_BETA_CB_STORAGE_CONSTRAINT(uint32_t *val_out, struct nv_nva097_SET_BETA_CB_STORAGE_CONSTRAINT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_BETA_CB_STORAGE_CONSTRAINT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE; \
    struct nv_nva097_SET_BETA_CB_STORAGE_CONSTRAINT __data = { .enable = (args) }; \
    __NVA097_SET_BETA_CB_STORAGE_CONSTRAINT(&val, __data); \
}

#define VA_NVA097_SET_BETA_CB_STORAGE_CONSTRAINT V_NVA097_SET_BETA_CB_STORAGE_CONSTRAINT

#define P_NVA097_SET_BETA_CB_STORAGE_CONSTRAINT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BETA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BETA_CB_STORAGE_CONSTRAINT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BETA_CB_STORAGE_CONSTRAINT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER {
    uint32_t v;
};

static inline void
__NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER(uint32_t *val_out, struct nv_nva097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 10));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER(val, args...) { \
    struct nv_nva097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER __data = { .v = (args) }; \
    __NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER(&val, __data); \
}

#define VA_NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER V_NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER

#define P_NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TI_OUTPUT_CB_STORAGE_MULTIPLIER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_CB_STORAGE_CONSTRAINT {
    uint32_t enable;
};

static inline void
__NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT(uint32_t *val_out, struct nv_nva097_SET_ALPHA_CB_STORAGE_CONSTRAINT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE; \
    struct nv_nva097_SET_ALPHA_CB_STORAGE_CONSTRAINT __data = { .enable = (args) }; \
    __NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT V_NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT

#define P_NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_CB_STORAGE_CONSTRAINT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP00 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP00(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP00(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP00 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP00(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP00 V_NVA097_SET_SPARE_NOOP00

#define P_NVA097_SET_SPARE_NOOP00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP00(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP00, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP01(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP01(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP01 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP01(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP01 V_NVA097_SET_SPARE_NOOP01

#define P_NVA097_SET_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP02(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP02(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP02 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP02(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP02 V_NVA097_SET_SPARE_NOOP02

#define P_NVA097_SET_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP03(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP03(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP03 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP03(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP03 V_NVA097_SET_SPARE_NOOP03

#define P_NVA097_SET_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP04 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP04(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP04(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP04 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP04(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP04 V_NVA097_SET_SPARE_NOOP04

#define P_NVA097_SET_SPARE_NOOP04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP04(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP04, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP05 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP05(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP05(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP05 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP05(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP05 V_NVA097_SET_SPARE_NOOP05

#define P_NVA097_SET_SPARE_NOOP05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP05(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP05, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP06 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP06(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP06(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP06 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP06(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP06 V_NVA097_SET_SPARE_NOOP06

#define P_NVA097_SET_SPARE_NOOP06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP06(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP06, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP07 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP07(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP07(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP07 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP07(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP07 V_NVA097_SET_SPARE_NOOP07

#define P_NVA097_SET_SPARE_NOOP07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP07(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP07, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP08 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP08(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP08(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP08 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP08(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP08 V_NVA097_SET_SPARE_NOOP08

#define P_NVA097_SET_SPARE_NOOP08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP08(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP08, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP09 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP09(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP09(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP09 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP09(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP09 V_NVA097_SET_SPARE_NOOP09

#define P_NVA097_SET_SPARE_NOOP09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP09(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP09, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP10 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP10(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP10(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP10 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP10(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP10 V_NVA097_SET_SPARE_NOOP10

#define P_NVA097_SET_SPARE_NOOP10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP10(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP10, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP11 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP11(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP11(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP11 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP11(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP11 V_NVA097_SET_SPARE_NOOP11

#define P_NVA097_SET_SPARE_NOOP11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP11(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP11, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP12 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP12(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP12(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP12 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP12(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP12 V_NVA097_SET_SPARE_NOOP12

#define P_NVA097_SET_SPARE_NOOP12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP12(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP12, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP13 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP13(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP13(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP13 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP13(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP13 V_NVA097_SET_SPARE_NOOP13

#define P_NVA097_SET_SPARE_NOOP13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP13(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP13, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP14 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP14(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP14(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP14 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP14(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP14 V_NVA097_SET_SPARE_NOOP14

#define P_NVA097_SET_SPARE_NOOP14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP14(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP14, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE_NOOP15 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE_NOOP15(uint32_t *val_out, struct nv_nva097_SET_SPARE_NOOP15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE_NOOP15(val, args...) { \
    struct nv_nva097_SET_SPARE_NOOP15 __data = { .v = (args) }; \
    __NVA097_SET_SPARE_NOOP15(&val, __data); \
}

#define VA_NVA097_SET_SPARE_NOOP15 V_NVA097_SET_SPARE_NOOP15

#define P_NVA097_SET_SPARE_NOOP15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE_NOOP15(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE_NOOP15, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 8));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 8));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM8, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 8));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 8));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM10, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 8));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 8));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_UNORM16, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP11 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP11 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 6));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 6));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP11 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP11, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP16 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP16 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 8));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 8));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_FP16 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_FP16, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8 {
    uint32_t all_covered_all_hit_once;
    uint32_t all_covered;
};

static inline void
__NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8(uint32_t *val_out, struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8 st)
{
    uint32_t val = 0;
    
    assert(st.all_covered_all_hit_once < (1ULL << 8));
    val |= st.all_covered_all_hit_once << 0;
    
    assert(st.all_covered < (1ULL << 8));
    val |= st.all_covered << 16;
    *val_out = val;
}

#define V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8(val, args...) { \
    struct nv_nva097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8 __data = args; \
    __NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8(&val, __data); \
}

#define VA_NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8 V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8

#define P_NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REDUCE_COLOR_THRESHOLDS_SRGB8, nvk_p_ret); \
} while(0)

struct nv_nva097_UNBIND_ALL {
    uint32_t constant_buffers;
};

static inline void
__NVA097_UNBIND_ALL(uint32_t *val_out, struct nv_nva097_UNBIND_ALL st)
{
    uint32_t val = 0;
    
    assert(st.constant_buffers < (1ULL << 1));
    val |= st.constant_buffers << 8;
    *val_out = val;
}

#define V_NVA097_UNBIND_ALL(val, args...) { \
    UNUSED uint32_t CONSTANT_BUFFERS_FALSE = NVA097_UNBIND_ALL_CONSTANT_BUFFERS_FALSE; \
    UNUSED uint32_t CONSTANT_BUFFERS_TRUE = NVA097_UNBIND_ALL_CONSTANT_BUFFERS_TRUE; \
    struct nv_nva097_UNBIND_ALL __data = { .constant_buffers = (args) }; \
    __NVA097_UNBIND_ALL(&val, __data); \
}

#define VA_NVA097_UNBIND_ALL V_NVA097_UNBIND_ALL

#define P_NVA097_UNBIND_ALL(push, args...) do { \
    UNUSED uint32_t CONSTANT_BUFFERS_FALSE = NVA097_UNBIND_ALL_CONSTANT_BUFFERS_FALSE; \
    UNUSED uint32_t CONSTANT_BUFFERS_TRUE = NVA097_UNBIND_ALL_CONSTANT_BUFFERS_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_UNBIND_ALL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_UNBIND_ALL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLEAR_SURFACE_CONTROL {
    uint32_t respect_stencil_mask;
    uint32_t use_clear_rect;
    uint32_t use_scissor0;
    uint32_t use_viewport_clip0;
};

static inline void
__NVA097_SET_CLEAR_SURFACE_CONTROL(uint32_t *val_out, struct nv_nva097_SET_CLEAR_SURFACE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.respect_stencil_mask < (1ULL << 1));
    val |= st.respect_stencil_mask << 0;
    
    assert(st.use_clear_rect < (1ULL << 1));
    val |= st.use_clear_rect << 4;
    
    assert(st.use_scissor0 < (1ULL << 1));
    val |= st.use_scissor0 << 8;
    
    assert(st.use_viewport_clip0 < (1ULL << 1));
    val |= st.use_viewport_clip0 << 12;
    *val_out = val;
}

#define V_NVA097_SET_CLEAR_SURFACE_CONTROL(val, args...) { \
    UNUSED uint32_t RESPECT_STENCIL_MASK_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_FALSE; \
    UNUSED uint32_t RESPECT_STENCIL_MASK_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_TRUE; \
    UNUSED uint32_t USE_CLEAR_RECT_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_FALSE; \
    UNUSED uint32_t USE_CLEAR_RECT_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_TRUE; \
    UNUSED uint32_t USE_SCISSOR0_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_FALSE; \
    UNUSED uint32_t USE_SCISSOR0_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_TRUE; \
    UNUSED uint32_t USE_VIEWPORT_CLIP0_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_FALSE; \
    UNUSED uint32_t USE_VIEWPORT_CLIP0_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_TRUE; \
    struct nv_nva097_SET_CLEAR_SURFACE_CONTROL __data = args; \
    __NVA097_SET_CLEAR_SURFACE_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_CLEAR_SURFACE_CONTROL V_NVA097_SET_CLEAR_SURFACE_CONTROL

#define P_NVA097_SET_CLEAR_SURFACE_CONTROL(push, args...) do { \
    UNUSED uint32_t RESPECT_STENCIL_MASK_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_FALSE; \
    UNUSED uint32_t RESPECT_STENCIL_MASK_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_RESPECT_STENCIL_MASK_TRUE; \
    UNUSED uint32_t USE_CLEAR_RECT_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_FALSE; \
    UNUSED uint32_t USE_CLEAR_RECT_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_CLEAR_RECT_TRUE; \
    UNUSED uint32_t USE_SCISSOR0_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_FALSE; \
    UNUSED uint32_t USE_SCISSOR0_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_SCISSOR0_TRUE; \
    UNUSED uint32_t USE_VIEWPORT_CLIP0_FALSE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_FALSE; \
    UNUSED uint32_t USE_VIEWPORT_CLIP0_TRUE = NVA097_SET_CLEAR_SURFACE_CONTROL_USE_VIEWPORT_CLIP0_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLEAR_SURFACE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLEAR_SURFACE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS {
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS(val, args...) { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS __data = { .policy = (args) }; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS(push, args...) do { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_READ_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_NO_OPERATION_DATA_HI {
    uint32_t v;
};

static inline void
__NVA097_NO_OPERATION_DATA_HI(uint32_t *val_out, struct nv_nva097_NO_OPERATION_DATA_HI st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_NO_OPERATION_DATA_HI(val, args...) { \
    struct nv_nva097_NO_OPERATION_DATA_HI __data = { .v = (args) }; \
    __NVA097_NO_OPERATION_DATA_HI(&val, __data); \
}

#define VA_NVA097_NO_OPERATION_DATA_HI V_NVA097_NO_OPERATION_DATA_HI

#define P_NVA097_NO_OPERATION_DATA_HI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_NO_OPERATION_DATA_HI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_NO_OPERATION_DATA_HI, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BIAS_CONTROL {
    uint32_t depth_format_dependent;
};

static inline void
__NVA097_SET_DEPTH_BIAS_CONTROL(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BIAS_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.depth_format_dependent < (1ULL << 1));
    val |= st.depth_format_dependent << 0;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BIAS_CONTROL(val, args...) { \
    UNUSED uint32_t DEPTH_FORMAT_DEPENDENT_FALSE = NVA097_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_FALSE; \
    UNUSED uint32_t DEPTH_FORMAT_DEPENDENT_TRUE = NVA097_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_TRUE; \
    struct nv_nva097_SET_DEPTH_BIAS_CONTROL __data = { .depth_format_dependent = (args) }; \
    __NVA097_SET_DEPTH_BIAS_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BIAS_CONTROL V_NVA097_SET_DEPTH_BIAS_CONTROL

#define P_NVA097_SET_DEPTH_BIAS_CONTROL(push, args...) do { \
    UNUSED uint32_t DEPTH_FORMAT_DEPENDENT_FALSE = NVA097_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_FALSE; \
    UNUSED uint32_t DEPTH_FORMAT_DEPENDENT_TRUE = NVA097_SET_DEPTH_BIAS_CONTROL_DEPTH_FORMAT_DEPENDENT_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BIAS_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BIAS_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_PM_TRIGGER_END {
    uint32_t v;
};

static inline void
__NVA097_PM_TRIGGER_END(uint32_t *val_out, struct nv_nva097_PM_TRIGGER_END st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PM_TRIGGER_END(val, args...) { \
    struct nv_nva097_PM_TRIGGER_END __data = { .v = (args) }; \
    __NVA097_PM_TRIGGER_END(&val, __data); \
}

#define VA_NVA097_PM_TRIGGER_END V_NVA097_PM_TRIGGER_END

#define P_NVA097_PM_TRIGGER_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PM_TRIGGER_END(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PM_TRIGGER_END, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_ID_BASE {
    uint32_t v;
};

static inline void
__NVA097_SET_VERTEX_ID_BASE(uint32_t *val_out, struct nv_nva097_SET_VERTEX_ID_BASE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_ID_BASE(val, args...) { \
    struct nv_nva097_SET_VERTEX_ID_BASE __data = { .v = (args) }; \
    __NVA097_SET_VERTEX_ID_BASE(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_ID_BASE V_NVA097_SET_VERTEX_ID_BASE

#define P_NVA097_SET_VERTEX_ID_BASE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_ID_BASE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_ID_BASE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A {
    uint32_t attribute0_comp0;
    uint32_t attribute0_comp1;
    uint32_t attribute0_comp2;
    uint32_t attribute0_comp3;
    uint32_t attribute1_comp0;
    uint32_t attribute1_comp1;
    uint32_t attribute1_comp2;
    uint32_t attribute1_comp3;
    uint32_t attribute2_comp0;
    uint32_t attribute2_comp1;
    uint32_t attribute2_comp2;
    uint32_t attribute2_comp3;
    uint32_t attribute3_comp0;
    uint32_t attribute3_comp1;
    uint32_t attribute3_comp2;
    uint32_t attribute3_comp3;
    uint32_t attribute4_comp0;
    uint32_t attribute4_comp1;
    uint32_t attribute4_comp2;
    uint32_t attribute4_comp3;
    uint32_t attribute5_comp0;
    uint32_t attribute5_comp1;
    uint32_t attribute5_comp2;
    uint32_t attribute5_comp3;
    uint32_t attribute6_comp0;
    uint32_t attribute6_comp1;
    uint32_t attribute6_comp2;
    uint32_t attribute6_comp3;
    uint32_t attribute7_comp0;
    uint32_t attribute7_comp1;
    uint32_t attribute7_comp2;
    uint32_t attribute7_comp3;
};

static inline void
__NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(uint32_t *val_out, struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A st)
{
    uint32_t val = 0;
    
    assert(st.attribute0_comp0 < (1ULL << 1));
    val |= st.attribute0_comp0 << 0;
    
    assert(st.attribute0_comp1 < (1ULL << 1));
    val |= st.attribute0_comp1 << 1;
    
    assert(st.attribute0_comp2 < (1ULL << 1));
    val |= st.attribute0_comp2 << 2;
    
    assert(st.attribute0_comp3 < (1ULL << 1));
    val |= st.attribute0_comp3 << 3;
    
    assert(st.attribute1_comp0 < (1ULL << 1));
    val |= st.attribute1_comp0 << 4;
    
    assert(st.attribute1_comp1 < (1ULL << 1));
    val |= st.attribute1_comp1 << 5;
    
    assert(st.attribute1_comp2 < (1ULL << 1));
    val |= st.attribute1_comp2 << 6;
    
    assert(st.attribute1_comp3 < (1ULL << 1));
    val |= st.attribute1_comp3 << 7;
    
    assert(st.attribute2_comp0 < (1ULL << 1));
    val |= st.attribute2_comp0 << 8;
    
    assert(st.attribute2_comp1 < (1ULL << 1));
    val |= st.attribute2_comp1 << 9;
    
    assert(st.attribute2_comp2 < (1ULL << 1));
    val |= st.attribute2_comp2 << 10;
    
    assert(st.attribute2_comp3 < (1ULL << 1));
    val |= st.attribute2_comp3 << 11;
    
    assert(st.attribute3_comp0 < (1ULL << 1));
    val |= st.attribute3_comp0 << 12;
    
    assert(st.attribute3_comp1 < (1ULL << 1));
    val |= st.attribute3_comp1 << 13;
    
    assert(st.attribute3_comp2 < (1ULL << 1));
    val |= st.attribute3_comp2 << 14;
    
    assert(st.attribute3_comp3 < (1ULL << 1));
    val |= st.attribute3_comp3 << 15;
    
    assert(st.attribute4_comp0 < (1ULL << 1));
    val |= st.attribute4_comp0 << 16;
    
    assert(st.attribute4_comp1 < (1ULL << 1));
    val |= st.attribute4_comp1 << 17;
    
    assert(st.attribute4_comp2 < (1ULL << 1));
    val |= st.attribute4_comp2 << 18;
    
    assert(st.attribute4_comp3 < (1ULL << 1));
    val |= st.attribute4_comp3 << 19;
    
    assert(st.attribute5_comp0 < (1ULL << 1));
    val |= st.attribute5_comp0 << 20;
    
    assert(st.attribute5_comp1 < (1ULL << 1));
    val |= st.attribute5_comp1 << 21;
    
    assert(st.attribute5_comp2 < (1ULL << 1));
    val |= st.attribute5_comp2 << 22;
    
    assert(st.attribute5_comp3 < (1ULL << 1));
    val |= st.attribute5_comp3 << 23;
    
    assert(st.attribute6_comp0 < (1ULL << 1));
    val |= st.attribute6_comp0 << 24;
    
    assert(st.attribute6_comp1 < (1ULL << 1));
    val |= st.attribute6_comp1 << 25;
    
    assert(st.attribute6_comp2 < (1ULL << 1));
    val |= st.attribute6_comp2 << 26;
    
    assert(st.attribute6_comp3 < (1ULL << 1));
    val |= st.attribute6_comp3 << 27;
    
    assert(st.attribute7_comp0 < (1ULL << 1));
    val |= st.attribute7_comp0 << 28;
    
    assert(st.attribute7_comp1 < (1ULL << 1));
    val |= st.attribute7_comp1 << 29;
    
    assert(st.attribute7_comp2 < (1ULL << 1));
    val |= st.attribute7_comp2 << 30;
    
    assert(st.attribute7_comp3 < (1ULL << 1));
    val |= st.attribute7_comp3 << 31;
    *val_out = val;
}

#define V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(val, args...) { \
    UNUSED uint32_t ATTRIBUTE0_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_TRUE; \
    struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A __data = args; \
    __NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(&val, __data); \
}

#define VA_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(i) V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A

#define P_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(push, idx, args...) do { \
    UNUSED uint32_t ATTRIBUTE0_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE0_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE1_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE2_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE3_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE4_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE5_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE6_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A_ATTRIBUTE7_COMP3_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B {
    uint32_t attribute0_comp0;
    uint32_t attribute0_comp1;
    uint32_t attribute0_comp2;
    uint32_t attribute0_comp3;
    uint32_t attribute1_comp0;
    uint32_t attribute1_comp1;
    uint32_t attribute1_comp2;
    uint32_t attribute1_comp3;
    uint32_t attribute2_comp0;
    uint32_t attribute2_comp1;
    uint32_t attribute2_comp2;
    uint32_t attribute2_comp3;
    uint32_t attribute3_comp0;
    uint32_t attribute3_comp1;
    uint32_t attribute3_comp2;
    uint32_t attribute3_comp3;
    uint32_t attribute4_comp0;
    uint32_t attribute4_comp1;
    uint32_t attribute4_comp2;
    uint32_t attribute4_comp3;
    uint32_t attribute5_comp0;
    uint32_t attribute5_comp1;
    uint32_t attribute5_comp2;
    uint32_t attribute5_comp3;
    uint32_t attribute6_comp0;
    uint32_t attribute6_comp1;
    uint32_t attribute6_comp2;
    uint32_t attribute6_comp3;
    uint32_t attribute7_comp0;
    uint32_t attribute7_comp1;
    uint32_t attribute7_comp2;
    uint32_t attribute7_comp3;
};

static inline void
__NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(uint32_t *val_out, struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B st)
{
    uint32_t val = 0;
    
    assert(st.attribute0_comp0 < (1ULL << 1));
    val |= st.attribute0_comp0 << 0;
    
    assert(st.attribute0_comp1 < (1ULL << 1));
    val |= st.attribute0_comp1 << 1;
    
    assert(st.attribute0_comp2 < (1ULL << 1));
    val |= st.attribute0_comp2 << 2;
    
    assert(st.attribute0_comp3 < (1ULL << 1));
    val |= st.attribute0_comp3 << 3;
    
    assert(st.attribute1_comp0 < (1ULL << 1));
    val |= st.attribute1_comp0 << 4;
    
    assert(st.attribute1_comp1 < (1ULL << 1));
    val |= st.attribute1_comp1 << 5;
    
    assert(st.attribute1_comp2 < (1ULL << 1));
    val |= st.attribute1_comp2 << 6;
    
    assert(st.attribute1_comp3 < (1ULL << 1));
    val |= st.attribute1_comp3 << 7;
    
    assert(st.attribute2_comp0 < (1ULL << 1));
    val |= st.attribute2_comp0 << 8;
    
    assert(st.attribute2_comp1 < (1ULL << 1));
    val |= st.attribute2_comp1 << 9;
    
    assert(st.attribute2_comp2 < (1ULL << 1));
    val |= st.attribute2_comp2 << 10;
    
    assert(st.attribute2_comp3 < (1ULL << 1));
    val |= st.attribute2_comp3 << 11;
    
    assert(st.attribute3_comp0 < (1ULL << 1));
    val |= st.attribute3_comp0 << 12;
    
    assert(st.attribute3_comp1 < (1ULL << 1));
    val |= st.attribute3_comp1 << 13;
    
    assert(st.attribute3_comp2 < (1ULL << 1));
    val |= st.attribute3_comp2 << 14;
    
    assert(st.attribute3_comp3 < (1ULL << 1));
    val |= st.attribute3_comp3 << 15;
    
    assert(st.attribute4_comp0 < (1ULL << 1));
    val |= st.attribute4_comp0 << 16;
    
    assert(st.attribute4_comp1 < (1ULL << 1));
    val |= st.attribute4_comp1 << 17;
    
    assert(st.attribute4_comp2 < (1ULL << 1));
    val |= st.attribute4_comp2 << 18;
    
    assert(st.attribute4_comp3 < (1ULL << 1));
    val |= st.attribute4_comp3 << 19;
    
    assert(st.attribute5_comp0 < (1ULL << 1));
    val |= st.attribute5_comp0 << 20;
    
    assert(st.attribute5_comp1 < (1ULL << 1));
    val |= st.attribute5_comp1 << 21;
    
    assert(st.attribute5_comp2 < (1ULL << 1));
    val |= st.attribute5_comp2 << 22;
    
    assert(st.attribute5_comp3 < (1ULL << 1));
    val |= st.attribute5_comp3 << 23;
    
    assert(st.attribute6_comp0 < (1ULL << 1));
    val |= st.attribute6_comp0 << 24;
    
    assert(st.attribute6_comp1 < (1ULL << 1));
    val |= st.attribute6_comp1 << 25;
    
    assert(st.attribute6_comp2 < (1ULL << 1));
    val |= st.attribute6_comp2 << 26;
    
    assert(st.attribute6_comp3 < (1ULL << 1));
    val |= st.attribute6_comp3 << 27;
    
    assert(st.attribute7_comp0 < (1ULL << 1));
    val |= st.attribute7_comp0 << 28;
    
    assert(st.attribute7_comp1 < (1ULL << 1));
    val |= st.attribute7_comp1 << 29;
    
    assert(st.attribute7_comp2 < (1ULL << 1));
    val |= st.attribute7_comp2 << 30;
    
    assert(st.attribute7_comp3 < (1ULL << 1));
    val |= st.attribute7_comp3 << 31;
    *val_out = val;
}

#define V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(val, args...) { \
    UNUSED uint32_t ATTRIBUTE0_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_TRUE; \
    struct nv_nva097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B __data = args; \
    __NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(&val, __data); \
}

#define VA_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(i) V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B

#define P_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(push, idx, args...) do { \
    UNUSED uint32_t ATTRIBUTE0_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE0_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE0_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE1_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE1_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE2_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE2_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE3_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE3_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE4_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE4_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE5_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE5_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE6_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE6_COMP3_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP0_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP0_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP1_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP1_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP2_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP2_TRUE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_FALSE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_FALSE; \
    UNUSED uint32_t ATTRIBUTE7_COMP3_TRUE = NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B_ATTRIBUTE7_COMP3_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_OUTPUT_ATTRIBUTE_SKIP_MASK_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_FORMAT_ENABLE {
    uint32_t snorm8_unorm16_snorm16;
};

static inline void
__NVA097_SET_BLEND_PER_FORMAT_ENABLE(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_FORMAT_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.snorm8_unorm16_snorm16 < (1ULL << 1));
    val |= st.snorm8_unorm16_snorm16 << 4;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_FORMAT_ENABLE(val, args...) { \
    UNUSED uint32_t SNORM8_UNORM16_SNORM16_FALSE = NVA097_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_FALSE; \
    UNUSED uint32_t SNORM8_UNORM16_SNORM16_TRUE = NVA097_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_TRUE; \
    struct nv_nva097_SET_BLEND_PER_FORMAT_ENABLE __data = { .snorm8_unorm16_snorm16 = (args) }; \
    __NVA097_SET_BLEND_PER_FORMAT_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_FORMAT_ENABLE V_NVA097_SET_BLEND_PER_FORMAT_ENABLE

#define P_NVA097_SET_BLEND_PER_FORMAT_ENABLE(push, args...) do { \
    UNUSED uint32_t SNORM8_UNORM16_SNORM16_FALSE = NVA097_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_FALSE; \
    UNUSED uint32_t SNORM8_UNORM16_SNORM16_TRUE = NVA097_SET_BLEND_PER_FORMAT_ENABLE_SNORM8_UNORM16_SNORM16_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_FORMAT_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_FORMAT_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_FLUSH_PENDING_WRITES {
    uint32_t sm_does_global_store;
};

static inline void
__NVA097_FLUSH_PENDING_WRITES(uint32_t *val_out, struct nv_nva097_FLUSH_PENDING_WRITES st)
{
    uint32_t val = 0;
    
    assert(st.sm_does_global_store < (1ULL << 1));
    val |= st.sm_does_global_store << 0;
    *val_out = val;
}

#define V_NVA097_FLUSH_PENDING_WRITES(val, args...) { \
    struct nv_nva097_FLUSH_PENDING_WRITES __data = { .sm_does_global_store = (args) }; \
    __NVA097_FLUSH_PENDING_WRITES(&val, __data); \
}

#define VA_NVA097_FLUSH_PENDING_WRITES V_NVA097_FLUSH_PENDING_WRITES

#define P_NVA097_FLUSH_PENDING_WRITES(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_FLUSH_PENDING_WRITES(nvk_p_ret, args); \
    nv_push_val(push, NVA097_FLUSH_PENDING_WRITES, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_DATA_CONTROL {
    uint32_t vab_index;
    uint32_t component_count;
    uint32_t component_byte_width;
    uint32_t format;
};

static inline void
__NVA097_SET_VAB_DATA_CONTROL(uint32_t *val_out, struct nv_nva097_SET_VAB_DATA_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.vab_index < (1ULL << 8));
    val |= st.vab_index << 0;
    
    assert(st.component_count < (1ULL << 3));
    val |= st.component_count << 8;
    
    assert(st.component_byte_width < (1ULL << 3));
    val |= st.component_byte_width << 12;
    
    assert(st.format < (1ULL << 3));
    val |= st.format << 16;
    *val_out = val;
}

#define V_NVA097_SET_VAB_DATA_CONTROL(val, args...) { \
    UNUSED uint32_t FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VAB_DATA_CONTROL_FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t FORMAT_NUM_SNORM = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SNORM; \
    UNUSED uint32_t FORMAT_NUM_UNORM = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_UNORM; \
    UNUSED uint32_t FORMAT_NUM_SINT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SINT; \
    UNUSED uint32_t FORMAT_NUM_UINT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_UINT; \
    UNUSED uint32_t FORMAT_NUM_USCALED = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_USCALED; \
    UNUSED uint32_t FORMAT_NUM_SSCALED = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SSCALED; \
    UNUSED uint32_t FORMAT_NUM_FLOAT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_FLOAT; \
    struct nv_nva097_SET_VAB_DATA_CONTROL __data = args; \
    __NVA097_SET_VAB_DATA_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_VAB_DATA_CONTROL V_NVA097_SET_VAB_DATA_CONTROL

#define P_NVA097_SET_VAB_DATA_CONTROL(push, args...) do { \
    UNUSED uint32_t FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VAB_DATA_CONTROL_FORMAT_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t FORMAT_NUM_SNORM = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SNORM; \
    UNUSED uint32_t FORMAT_NUM_UNORM = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_UNORM; \
    UNUSED uint32_t FORMAT_NUM_SINT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SINT; \
    UNUSED uint32_t FORMAT_NUM_UINT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_UINT; \
    UNUSED uint32_t FORMAT_NUM_USCALED = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_USCALED; \
    UNUSED uint32_t FORMAT_NUM_SSCALED = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_SSCALED; \
    UNUSED uint32_t FORMAT_NUM_FLOAT = NVA097_SET_VAB_DATA_CONTROL_FORMAT_NUM_FLOAT; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_DATA_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_DATA_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_DATA {
    uint32_t v;
};

static inline void
__NVA097_SET_VAB_DATA(uint32_t *val_out, struct nv_nva097_SET_VAB_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VAB_DATA(val, args...) { \
    struct nv_nva097_SET_VAB_DATA __data = { .v = (args) }; \
    __NVA097_SET_VAB_DATA(&val, __data); \
}

#define VA_NVA097_SET_VAB_DATA(i) V_NVA097_SET_VAB_DATA

#define P_NVA097_SET_VAB_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_DATA(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_ATTRIBUTE_A {
    uint32_t stream;
    uint32_t source;
    uint32_t offset;
    uint32_t component_bit_widths;
    uint32_t numerical_type;
    uint32_t swap_r_and_b;
};

static inline void
__NVA097_SET_VERTEX_ATTRIBUTE_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_ATTRIBUTE_A st)
{
    uint32_t val = 0;
    
    assert(st.stream < (1ULL << 5));
    val |= st.stream << 0;
    
    assert(st.source < (1ULL << 1));
    val |= st.source << 6;
    
    assert(st.offset < (1ULL << 14));
    val |= st.offset << 7;
    
    assert(st.component_bit_widths < (1ULL << 6));
    val |= st.component_bit_widths << 21;
    
    assert(st.numerical_type < (1ULL << 3));
    val |= st.numerical_type << 27;
    
    assert(st.swap_r_and_b < (1ULL << 1));
    val |= st.swap_r_and_b << 31;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_ATTRIBUTE_A(val, args...) { \
    UNUSED uint32_t SOURCE_ACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_A_SOURCE_ACTIVE; \
    UNUSED uint32_t SOURCE_INACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_A_SOURCE_INACTIVE; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32_A32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16_A16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8_A8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_X8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_X8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A2B10G10R10 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A2B10G10R10; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_B10G11R11 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_B10G11R11; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8; \
    UNUSED uint32_t NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SNORM = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UNORM = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SINT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UINT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_USCALED = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_USCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SSCALED = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SSCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_FLOAT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_FLOAT; \
    UNUSED uint32_t SWAP_R_AND_B_FALSE = NVA097_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_FALSE; \
    UNUSED uint32_t SWAP_R_AND_B_TRUE = NVA097_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_TRUE; \
    struct nv_nva097_SET_VERTEX_ATTRIBUTE_A __data = args; \
    __NVA097_SET_VERTEX_ATTRIBUTE_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_ATTRIBUTE_A(i) V_NVA097_SET_VERTEX_ATTRIBUTE_A

#define P_NVA097_SET_VERTEX_ATTRIBUTE_A(push, idx, args...) do { \
    UNUSED uint32_t SOURCE_ACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_A_SOURCE_ACTIVE; \
    UNUSED uint32_t SOURCE_INACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_A_SOURCE_INACTIVE; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32_A32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32_B32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16_A16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32_G32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16_B16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8_A8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_X8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_X8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A2B10G10R10 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A2B10G10R10; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_B10G11R11 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_B10G11R11; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16_G16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8_B8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8_G8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8 = NVA097_SET_VERTEX_ATTRIBUTE_A_COMPONENT_BIT_WIDTHS_A8; \
    UNUSED uint32_t NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SNORM = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UNORM = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SINT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UINT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_UINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_USCALED = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_USCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SSCALED = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_SSCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_FLOAT = NVA097_SET_VERTEX_ATTRIBUTE_A_NUMERICAL_TYPE_NUM_FLOAT; \
    UNUSED uint32_t SWAP_R_AND_B_FALSE = NVA097_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_FALSE; \
    UNUSED uint32_t SWAP_R_AND_B_TRUE = NVA097_SET_VERTEX_ATTRIBUTE_A_SWAP_R_AND_B_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_ATTRIBUTE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_ATTRIBUTE_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_ATTRIBUTE_B {
    uint32_t stream;
    uint32_t source;
    uint32_t offset;
    uint32_t component_bit_widths;
    uint32_t numerical_type;
    uint32_t swap_r_and_b;
};

static inline void
__NVA097_SET_VERTEX_ATTRIBUTE_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_ATTRIBUTE_B st)
{
    uint32_t val = 0;
    
    assert(st.stream < (1ULL << 5));
    val |= st.stream << 0;
    
    assert(st.source < (1ULL << 1));
    val |= st.source << 6;
    
    assert(st.offset < (1ULL << 14));
    val |= st.offset << 7;
    
    assert(st.component_bit_widths < (1ULL << 6));
    val |= st.component_bit_widths << 21;
    
    assert(st.numerical_type < (1ULL << 3));
    val |= st.numerical_type << 27;
    
    assert(st.swap_r_and_b < (1ULL << 1));
    val |= st.swap_r_and_b << 31;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_ATTRIBUTE_B(val, args...) { \
    UNUSED uint32_t SOURCE_ACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_B_SOURCE_ACTIVE; \
    UNUSED uint32_t SOURCE_INACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_B_SOURCE_INACTIVE; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32_A32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16_A16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8_A8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_X8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_X8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A2B10G10R10 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A2B10G10R10; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_B10G11R11 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_B10G11R11; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8; \
    UNUSED uint32_t NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SNORM = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UNORM = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SINT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UINT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_USCALED = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_USCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SSCALED = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SSCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_FLOAT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_FLOAT; \
    UNUSED uint32_t SWAP_R_AND_B_FALSE = NVA097_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_FALSE; \
    UNUSED uint32_t SWAP_R_AND_B_TRUE = NVA097_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_TRUE; \
    struct nv_nva097_SET_VERTEX_ATTRIBUTE_B __data = args; \
    __NVA097_SET_VERTEX_ATTRIBUTE_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_ATTRIBUTE_B(i) V_NVA097_SET_VERTEX_ATTRIBUTE_B

#define P_NVA097_SET_VERTEX_ATTRIBUTE_B(push, idx, args...) do { \
    UNUSED uint32_t SOURCE_ACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_B_SOURCE_ACTIVE; \
    UNUSED uint32_t SOURCE_INACTIVE = NVA097_SET_VERTEX_ATTRIBUTE_B_SOURCE_INACTIVE; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32_A32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32_A32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32_B32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32_B32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16_A16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16_A16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32_G32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32_G32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16_B16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16_B16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8_A8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8_A8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_X8B8G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_X8B8G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A2B10G10R10 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A2B10G10R10; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_B10G11R11 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_B10G11R11; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16_G16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16_G16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R32 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R32; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8_B8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8_B8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_G8R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_G8R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8_G8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8_G8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R16 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R16; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_R8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_R8; \
    UNUSED uint32_t COMPONENT_BIT_WIDTHS_A8 = NVA097_SET_VERTEX_ATTRIBUTE_B_COMPONENT_BIT_WIDTHS_A8; \
    UNUSED uint32_t NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_UNUSED_ENUM_DO_NOT_USE_BECAUSE_IT_WILL_GO_AWAY; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SNORM = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UNORM = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UNORM; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SINT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_UINT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_UINT; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_USCALED = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_USCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_SSCALED = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_SSCALED; \
    UNUSED uint32_t NUMERICAL_TYPE_NUM_FLOAT = NVA097_SET_VERTEX_ATTRIBUTE_B_NUMERICAL_TYPE_NUM_FLOAT; \
    UNUSED uint32_t SWAP_R_AND_B_FALSE = NVA097_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_FALSE; \
    UNUSED uint32_t SWAP_R_AND_B_TRUE = NVA097_SET_VERTEX_ATTRIBUTE_B_SWAP_R_AND_B_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_ATTRIBUTE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_ATTRIBUTE_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST {
    uint32_t start_index;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST(uint32_t *val_out, struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST st)
{
    uint32_t val = 0;
    
    assert(st.start_index < (1ULL << 16));
    val |= st.start_index << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST __data = args; \
    __NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST(&val, __data); \
}

#define VA_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST

#define P_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_FIRST, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT {
    uint32_t start_index;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT(uint32_t *val_out, struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT st)
{
    uint32_t val = 0;
    
    assert(st.start_index < (1ULL << 16));
    val |= st.start_index << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT __data = args; \
    __NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT(&val, __data); \
}

#define VA_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT

#define P_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_VERTEX_ARRAY_BEGIN_END_INSTANCE_SUBSEQUENT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CT_SELECT {
    uint32_t target_count;
    uint32_t target0;
    uint32_t target1;
    uint32_t target2;
    uint32_t target3;
    uint32_t target4;
    uint32_t target5;
    uint32_t target6;
    uint32_t target7;
};

static inline void
__NVA097_SET_CT_SELECT(uint32_t *val_out, struct nv_nva097_SET_CT_SELECT st)
{
    uint32_t val = 0;
    
    assert(st.target_count < (1ULL << 4));
    val |= st.target_count << 0;
    
    assert(st.target0 < (1ULL << 3));
    val |= st.target0 << 4;
    
    assert(st.target1 < (1ULL << 3));
    val |= st.target1 << 7;
    
    assert(st.target2 < (1ULL << 3));
    val |= st.target2 << 10;
    
    assert(st.target3 < (1ULL << 3));
    val |= st.target3 << 13;
    
    assert(st.target4 < (1ULL << 3));
    val |= st.target4 << 16;
    
    assert(st.target5 < (1ULL << 3));
    val |= st.target5 << 19;
    
    assert(st.target6 < (1ULL << 3));
    val |= st.target6 << 22;
    
    assert(st.target7 < (1ULL << 3));
    val |= st.target7 << 25;
    *val_out = val;
}

#define V_NVA097_SET_CT_SELECT(val, args...) { \
    struct nv_nva097_SET_CT_SELECT __data = args; \
    __NVA097_SET_CT_SELECT(&val, __data); \
}

#define VA_NVA097_SET_CT_SELECT V_NVA097_SET_CT_SELECT

#define P_NVA097_SET_CT_SELECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CT_SELECT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CT_SELECT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COMPRESSION_THRESHOLD {
    uint32_t samples;
};

static inline void
__NVA097_SET_COMPRESSION_THRESHOLD(uint32_t *val_out, struct nv_nva097_SET_COMPRESSION_THRESHOLD st)
{
    uint32_t val = 0;
    
    assert(st.samples < (1ULL << 4));
    val |= st.samples << 0;
    *val_out = val;
}

#define V_NVA097_SET_COMPRESSION_THRESHOLD(val, args...) { \
    UNUSED uint32_t SAMPLES__0 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__0; \
    UNUSED uint32_t SAMPLES__1 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__1; \
    UNUSED uint32_t SAMPLES__2 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__2; \
    UNUSED uint32_t SAMPLES__4 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__4; \
    UNUSED uint32_t SAMPLES__8 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__8; \
    UNUSED uint32_t SAMPLES__16 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__16; \
    UNUSED uint32_t SAMPLES__32 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__32; \
    UNUSED uint32_t SAMPLES__64 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__64; \
    UNUSED uint32_t SAMPLES__128 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__128; \
    UNUSED uint32_t SAMPLES__256 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__256; \
    UNUSED uint32_t SAMPLES__512 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__512; \
    UNUSED uint32_t SAMPLES__1024 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__1024; \
    UNUSED uint32_t SAMPLES__2048 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__2048; \
    struct nv_nva097_SET_COMPRESSION_THRESHOLD __data = { .samples = (args) }; \
    __NVA097_SET_COMPRESSION_THRESHOLD(&val, __data); \
}

#define VA_NVA097_SET_COMPRESSION_THRESHOLD V_NVA097_SET_COMPRESSION_THRESHOLD

#define P_NVA097_SET_COMPRESSION_THRESHOLD(push, args...) do { \
    UNUSED uint32_t SAMPLES__0 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__0; \
    UNUSED uint32_t SAMPLES__1 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__1; \
    UNUSED uint32_t SAMPLES__2 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__2; \
    UNUSED uint32_t SAMPLES__4 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__4; \
    UNUSED uint32_t SAMPLES__8 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__8; \
    UNUSED uint32_t SAMPLES__16 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__16; \
    UNUSED uint32_t SAMPLES__32 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__32; \
    UNUSED uint32_t SAMPLES__64 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__64; \
    UNUSED uint32_t SAMPLES__128 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__128; \
    UNUSED uint32_t SAMPLES__256 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__256; \
    UNUSED uint32_t SAMPLES__512 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__512; \
    UNUSED uint32_t SAMPLES__1024 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__1024; \
    UNUSED uint32_t SAMPLES__2048 = NVA097_SET_COMPRESSION_THRESHOLD_SAMPLES__2048; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COMPRESSION_THRESHOLD(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COMPRESSION_THRESHOLD, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_SIZE_A {
    uint32_t width;
};

static inline void
__NVA097_SET_ZT_SIZE_A(uint32_t *val_out, struct nv_nva097_SET_ZT_SIZE_A st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 28));
    val |= st.width << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_SIZE_A(val, args...) { \
    struct nv_nva097_SET_ZT_SIZE_A __data = { .width = (args) }; \
    __NVA097_SET_ZT_SIZE_A(&val, __data); \
}

#define VA_NVA097_SET_ZT_SIZE_A V_NVA097_SET_ZT_SIZE_A

#define P_NVA097_SET_ZT_SIZE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_SIZE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_SIZE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_SIZE_B {
    uint32_t height;
};

static inline void
__NVA097_SET_ZT_SIZE_B(uint32_t *val_out, struct nv_nva097_SET_ZT_SIZE_B st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 17));
    val |= st.height << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_SIZE_B(val, args...) { \
    struct nv_nva097_SET_ZT_SIZE_B __data = { .height = (args) }; \
    __NVA097_SET_ZT_SIZE_B(&val, __data); \
}

#define VA_NVA097_SET_ZT_SIZE_B V_NVA097_SET_ZT_SIZE_B

#define P_NVA097_SET_ZT_SIZE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_SIZE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_SIZE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_SIZE_C {
    uint32_t third_dimension;
    uint32_t control;
};

static inline void
__NVA097_SET_ZT_SIZE_C(uint32_t *val_out, struct nv_nva097_SET_ZT_SIZE_C st)
{
    uint32_t val = 0;
    
    assert(st.third_dimension < (1ULL << 16));
    val |= st.third_dimension << 0;
    
    assert(st.control < (1ULL << 1));
    val |= st.control << 16;
    *val_out = val;
}

#define V_NVA097_SET_ZT_SIZE_C(val, args...) { \
    UNUSED uint32_t CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE = NVA097_SET_ZT_SIZE_C_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE; \
    UNUSED uint32_t CONTROL_ARRAY_SIZE_IS_ONE = NVA097_SET_ZT_SIZE_C_CONTROL_ARRAY_SIZE_IS_ONE; \
    struct nv_nva097_SET_ZT_SIZE_C __data = args; \
    __NVA097_SET_ZT_SIZE_C(&val, __data); \
}

#define VA_NVA097_SET_ZT_SIZE_C V_NVA097_SET_ZT_SIZE_C

#define P_NVA097_SET_ZT_SIZE_C(push, args...) do { \
    UNUSED uint32_t CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE = NVA097_SET_ZT_SIZE_C_CONTROL_THIRD_DIMENSION_DEFINES_ARRAY_SIZE; \
    UNUSED uint32_t CONTROL_ARRAY_SIZE_IS_ONE = NVA097_SET_ZT_SIZE_C_CONTROL_ARRAY_SIZE_IS_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_SIZE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_SIZE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SAMPLER_BINDING {
    uint32_t v;
};

static inline void
__NVA097_SET_SAMPLER_BINDING(uint32_t *val_out, struct nv_nva097_SET_SAMPLER_BINDING st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_SAMPLER_BINDING(val, args...) { \
    UNUSED uint32_t V_INDEPENDENTLY = NVA097_SET_SAMPLER_BINDING_V_INDEPENDENTLY; \
    UNUSED uint32_t V_VIA_HEADER_BINDING = NVA097_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING; \
    struct nv_nva097_SET_SAMPLER_BINDING __data = { .v = (args) }; \
    __NVA097_SET_SAMPLER_BINDING(&val, __data); \
}

#define VA_NVA097_SET_SAMPLER_BINDING V_NVA097_SET_SAMPLER_BINDING

#define P_NVA097_SET_SAMPLER_BINDING(push, args...) do { \
    UNUSED uint32_t V_INDEPENDENTLY = NVA097_SET_SAMPLER_BINDING_V_INDEPENDENTLY; \
    UNUSED uint32_t V_VIA_HEADER_BINDING = NVA097_SET_SAMPLER_BINDING_V_VIA_HEADER_BINDING; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SAMPLER_BINDING(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SAMPLER_BINDING, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_AUTO {
    uint32_t byte_count;
};

static inline void
__NVA097_DRAW_AUTO(uint32_t *val_out, struct nv_nva097_DRAW_AUTO st)
{
    uint32_t val = 0;
    
    val |= st.byte_count;
    *val_out = val;
}

#define V_NVA097_DRAW_AUTO(val, args...) { \
    struct nv_nva097_DRAW_AUTO __data = { .byte_count = (args) }; \
    __NVA097_DRAW_AUTO(&val, __data); \
}

#define VA_NVA097_DRAW_AUTO V_NVA097_DRAW_AUTO

#define P_NVA097_DRAW_AUTO(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_AUTO(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_AUTO, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CIRCULAR_BUFFER_SIZE {
    uint32_t cache_lines_per_sm;
};

static inline void
__NVA097_SET_CIRCULAR_BUFFER_SIZE(uint32_t *val_out, struct nv_nva097_SET_CIRCULAR_BUFFER_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.cache_lines_per_sm < (1ULL << 10));
    val |= st.cache_lines_per_sm << 0;
    *val_out = val;
}

#define V_NVA097_SET_CIRCULAR_BUFFER_SIZE(val, args...) { \
    struct nv_nva097_SET_CIRCULAR_BUFFER_SIZE __data = { .cache_lines_per_sm = (args) }; \
    __NVA097_SET_CIRCULAR_BUFFER_SIZE(&val, __data); \
}

#define VA_NVA097_SET_CIRCULAR_BUFFER_SIZE V_NVA097_SET_CIRCULAR_BUFFER_SIZE

#define P_NVA097_SET_CIRCULAR_BUFFER_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CIRCULAR_BUFFER_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CIRCULAR_BUFFER_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VTG_REGISTER_WATERMARKS {
    uint32_t low;
    uint32_t high;
};

static inline void
__NVA097_SET_VTG_REGISTER_WATERMARKS(uint32_t *val_out, struct nv_nva097_SET_VTG_REGISTER_WATERMARKS st)
{
    uint32_t val = 0;
    
    assert(st.low < (1ULL << 16));
    val |= st.low << 0;
    
    assert(st.high < (1ULL << 16));
    val |= st.high << 16;
    *val_out = val;
}

#define V_NVA097_SET_VTG_REGISTER_WATERMARKS(val, args...) { \
    struct nv_nva097_SET_VTG_REGISTER_WATERMARKS __data = args; \
    __NVA097_SET_VTG_REGISTER_WATERMARKS(&val, __data); \
}

#define VA_NVA097_SET_VTG_REGISTER_WATERMARKS V_NVA097_SET_VTG_REGISTER_WATERMARKS

#define P_NVA097_SET_VTG_REGISTER_WATERMARKS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VTG_REGISTER_WATERMARKS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VTG_REGISTER_WATERMARKS, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(uint32_t *val_out, struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI __data = args; \
    __NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI

#define P_NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS {
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS(val, args...) { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS __data = { .policy = (args) }; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS(push, args...) do { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_READ_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE {
    uint32_t v;
};

static inline void
__NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE(uint32_t *val_out, struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE(val, args...) { \
    struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE __data = { .v = (args) }; \
    __NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE(&val, __data); \
}

#define VA_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE

#define P_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_PRIMITIVE_RESTART_INDEX_TOPOLOGY_CHANGE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_SCHEDULING {
    uint32_t mode;
};

static inline void
__NVA097_SET_SHADER_SCHEDULING(uint32_t *val_out, struct nv_nva097_SET_SHADER_SCHEDULING st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 1));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_SCHEDULING(val, args...) { \
    UNUSED uint32_t MODE_OLDEST_THREAD_FIRST = NVA097_SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST; \
    UNUSED uint32_t MODE_ROUND_ROBIN = NVA097_SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN; \
    struct nv_nva097_SET_SHADER_SCHEDULING __data = { .mode = (args) }; \
    __NVA097_SET_SHADER_SCHEDULING(&val, __data); \
}

#define VA_NVA097_SET_SHADER_SCHEDULING V_NVA097_SET_SHADER_SCHEDULING

#define P_NVA097_SET_SHADER_SCHEDULING(push, args...) do { \
    UNUSED uint32_t MODE_OLDEST_THREAD_FIRST = NVA097_SET_SHADER_SCHEDULING_MODE_OLDEST_THREAD_FIRST; \
    UNUSED uint32_t MODE_ROUND_ROBIN = NVA097_SET_SHADER_SCHEDULING_MODE_ROUND_ROBIN; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_SCHEDULING(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_SCHEDULING, nvk_p_ret); \
} while(0)

struct nv_nva097_CLEAR_ZCULL_REGION {
    uint32_t z_enable;
    uint32_t stencil_enable;
    uint32_t use_clear_rect;
    uint32_t use_rt_array_index;
    uint32_t rt_array_index;
    uint32_t make_conservative;
};

static inline void
__NVA097_CLEAR_ZCULL_REGION(uint32_t *val_out, struct nv_nva097_CLEAR_ZCULL_REGION st)
{
    uint32_t val = 0;
    
    assert(st.z_enable < (1ULL << 1));
    val |= st.z_enable << 0;
    
    assert(st.stencil_enable < (1ULL << 1));
    val |= st.stencil_enable << 4;
    
    assert(st.use_clear_rect < (1ULL << 1));
    val |= st.use_clear_rect << 1;
    
    assert(st.use_rt_array_index < (1ULL << 1));
    val |= st.use_rt_array_index << 2;
    
    assert(st.rt_array_index < (1ULL << 16));
    val |= st.rt_array_index << 5;
    
    assert(st.make_conservative < (1ULL << 1));
    val |= st.make_conservative << 3;
    *val_out = val;
}

#define V_NVA097_CLEAR_ZCULL_REGION(val, args...) { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_CLEAR_ZCULL_REGION_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_CLEAR_ZCULL_REGION_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_CLEAR_ZCULL_REGION_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_CLEAR_ZCULL_REGION_STENCIL_ENABLE_TRUE; \
    UNUSED uint32_t USE_CLEAR_RECT_FALSE = NVA097_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_FALSE; \
    UNUSED uint32_t USE_CLEAR_RECT_TRUE = NVA097_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_TRUE; \
    UNUSED uint32_t USE_RT_ARRAY_INDEX_FALSE = NVA097_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_FALSE; \
    UNUSED uint32_t USE_RT_ARRAY_INDEX_TRUE = NVA097_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_TRUE; \
    UNUSED uint32_t MAKE_CONSERVATIVE_FALSE = NVA097_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_FALSE; \
    UNUSED uint32_t MAKE_CONSERVATIVE_TRUE = NVA097_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_TRUE; \
    struct nv_nva097_CLEAR_ZCULL_REGION __data = args; \
    __NVA097_CLEAR_ZCULL_REGION(&val, __data); \
}

#define VA_NVA097_CLEAR_ZCULL_REGION V_NVA097_CLEAR_ZCULL_REGION

#define P_NVA097_CLEAR_ZCULL_REGION(push, args...) do { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_CLEAR_ZCULL_REGION_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_CLEAR_ZCULL_REGION_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_CLEAR_ZCULL_REGION_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_CLEAR_ZCULL_REGION_STENCIL_ENABLE_TRUE; \
    UNUSED uint32_t USE_CLEAR_RECT_FALSE = NVA097_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_FALSE; \
    UNUSED uint32_t USE_CLEAR_RECT_TRUE = NVA097_CLEAR_ZCULL_REGION_USE_CLEAR_RECT_TRUE; \
    UNUSED uint32_t USE_RT_ARRAY_INDEX_FALSE = NVA097_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_FALSE; \
    UNUSED uint32_t USE_RT_ARRAY_INDEX_TRUE = NVA097_CLEAR_ZCULL_REGION_USE_RT_ARRAY_INDEX_TRUE; \
    UNUSED uint32_t MAKE_CONSERVATIVE_FALSE = NVA097_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_FALSE; \
    UNUSED uint32_t MAKE_CONSERVATIVE_TRUE = NVA097_CLEAR_ZCULL_REGION_MAKE_CONSERVATIVE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_CLEAR_ZCULL_REGION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CLEAR_ZCULL_REGION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_DEPTH_TEST(uint32_t *val_out, struct nv_nva097_SET_DEPTH_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_DEPTH_TEST __data = { .enable = (args) }; \
    __NVA097_SET_DEPTH_TEST(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_TEST V_NVA097_SET_DEPTH_TEST

#define P_NVA097_SET_DEPTH_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FILL_MODE {
    uint32_t v;
};

static inline void
__NVA097_SET_FILL_MODE(uint32_t *val_out, struct nv_nva097_SET_FILL_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FILL_MODE(val, args...) { \
    UNUSED uint32_t V_POINT = NVA097_SET_FILL_MODE_V_POINT; \
    UNUSED uint32_t V_WIREFRAME = NVA097_SET_FILL_MODE_V_WIREFRAME; \
    UNUSED uint32_t V_SOLID = NVA097_SET_FILL_MODE_V_SOLID; \
    struct nv_nva097_SET_FILL_MODE __data = { .v = (args) }; \
    __NVA097_SET_FILL_MODE(&val, __data); \
}

#define VA_NVA097_SET_FILL_MODE V_NVA097_SET_FILL_MODE

#define P_NVA097_SET_FILL_MODE(push, args...) do { \
    UNUSED uint32_t V_POINT = NVA097_SET_FILL_MODE_V_POINT; \
    UNUSED uint32_t V_WIREFRAME = NVA097_SET_FILL_MODE_V_WIREFRAME; \
    UNUSED uint32_t V_SOLID = NVA097_SET_FILL_MODE_V_SOLID; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FILL_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FILL_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADE_MODE {
    uint32_t v;
};

static inline void
__NVA097_SET_SHADE_MODE(uint32_t *val_out, struct nv_nva097_SET_SHADE_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SHADE_MODE(val, args...) { \
    UNUSED uint32_t V_FLAT = NVA097_SET_SHADE_MODE_V_FLAT; \
    UNUSED uint32_t V_GOURAUD = NVA097_SET_SHADE_MODE_V_GOURAUD; \
    UNUSED uint32_t V_OGL_FLAT = NVA097_SET_SHADE_MODE_V_OGL_FLAT; \
    UNUSED uint32_t V_OGL_SMOOTH = NVA097_SET_SHADE_MODE_V_OGL_SMOOTH; \
    struct nv_nva097_SET_SHADE_MODE __data = { .v = (args) }; \
    __NVA097_SET_SHADE_MODE(&val, __data); \
}

#define VA_NVA097_SET_SHADE_MODE V_NVA097_SET_SHADE_MODE

#define P_NVA097_SET_SHADE_MODE(push, args...) do { \
    UNUSED uint32_t V_FLAT = NVA097_SET_SHADE_MODE_V_FLAT; \
    UNUSED uint32_t V_GOURAUD = NVA097_SET_SHADE_MODE_V_GOURAUD; \
    UNUSED uint32_t V_OGL_FLAT = NVA097_SET_SHADE_MODE_V_OGL_FLAT; \
    UNUSED uint32_t V_OGL_SMOOTH = NVA097_SET_SHADE_MODE_V_OGL_SMOOTH; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADE_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADE_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS {
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS(val, args...) { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS __data = { .policy = (args) }; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS(push, args...) do { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_NONINTERLOCKED_WRITE_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS {
    uint32_t policy;
};

static inline void
__NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS(uint32_t *val_out, struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS st)
{
    uint32_t val = 0;
    
    assert(st.policy < (1ULL << 2));
    val |= st.policy << 4;
    *val_out = val;
}

#define V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS(val, args...) { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST; \
    struct nv_nva097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS __data = { .policy = (args) }; \
    __NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS(&val, __data); \
}

#define VA_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS

#define P_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS(push, args...) do { \
    UNUSED uint32_t POLICY_EVICT_FIRST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_FIRST; \
    UNUSED uint32_t POLICY_EVICT_NORMAL = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_NORMAL; \
    UNUSED uint32_t POLICY_EVICT_LAST = NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS_POLICY_EVICT_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_L2_CACHE_CONTROL_FOR_ROP_INTERLOCKED_WRITE_REQUESTS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL {
    uint32_t dither_footprint;
};

static inline void
__NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL(uint32_t *val_out, struct nv_nva097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.dither_footprint < (1ULL << 4));
    val |= st.dither_footprint << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL(val, args...) { \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_1X1 = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1; \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_2X2 = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_2X2; \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES; \
    struct nv_nva097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL __data = { .dither_footprint = (args) }; \
    __NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL V_NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL

#define P_NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL(push, args...) do { \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_1X1 = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1; \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_2X2 = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_2X2; \
    UNUSED uint32_t DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES = NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL_DITHER_FOOTPRINT_PIXELS_1X1_VIRTUAL_SAMPLES; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_TO_COVERAGE_DITHER_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_STATE_PER_TARGET {
    uint32_t enable;
};

static inline void
__NVA097_SET_BLEND_STATE_PER_TARGET(uint32_t *val_out, struct nv_nva097_SET_BLEND_STATE_PER_TARGET st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_STATE_PER_TARGET(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_STATE_PER_TARGET_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_STATE_PER_TARGET_ENABLE_TRUE; \
    struct nv_nva097_SET_BLEND_STATE_PER_TARGET __data = { .enable = (args) }; \
    __NVA097_SET_BLEND_STATE_PER_TARGET(&val, __data); \
}

#define VA_NVA097_SET_BLEND_STATE_PER_TARGET V_NVA097_SET_BLEND_STATE_PER_TARGET

#define P_NVA097_SET_BLEND_STATE_PER_TARGET(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_STATE_PER_TARGET_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_STATE_PER_TARGET_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_STATE_PER_TARGET(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_STATE_PER_TARGET, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_WRITE {
    uint32_t enable;
};

static inline void
__NVA097_SET_DEPTH_WRITE(uint32_t *val_out, struct nv_nva097_SET_DEPTH_WRITE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_WRITE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_WRITE_ENABLE_TRUE; \
    struct nv_nva097_SET_DEPTH_WRITE __data = { .enable = (args) }; \
    __NVA097_SET_DEPTH_WRITE(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_WRITE V_NVA097_SET_DEPTH_WRITE

#define P_NVA097_SET_DEPTH_WRITE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_WRITE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_WRITE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_WRITE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_ALPHA_TEST(uint32_t *val_out, struct nv_nva097_SET_ALPHA_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ALPHA_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ALPHA_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_ALPHA_TEST __data = { .enable = (args) }; \
    __NVA097_SET_ALPHA_TEST(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_TEST V_NVA097_SET_ALPHA_TEST

#define P_NVA097_SET_ALPHA_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ALPHA_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ALPHA_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INLINE_INDEX4X8_ALIGN {
    uint32_t count;
    uint32_t start;
};

static inline void
__NVA097_SET_INLINE_INDEX4X8_ALIGN(uint32_t *val_out, struct nv_nva097_SET_INLINE_INDEX4X8_ALIGN st)
{
    uint32_t val = 0;
    
    assert(st.count < (1ULL << 30));
    val |= st.count << 0;
    
    assert(st.start < (1ULL << 2));
    val |= st.start << 30;
    *val_out = val;
}

#define V_NVA097_SET_INLINE_INDEX4X8_ALIGN(val, args...) { \
    struct nv_nva097_SET_INLINE_INDEX4X8_ALIGN __data = args; \
    __NVA097_SET_INLINE_INDEX4X8_ALIGN(&val, __data); \
}

#define VA_NVA097_SET_INLINE_INDEX4X8_ALIGN V_NVA097_SET_INLINE_INDEX4X8_ALIGN

#define P_NVA097_SET_INLINE_INDEX4X8_ALIGN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INLINE_INDEX4X8_ALIGN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INLINE_INDEX4X8_ALIGN, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INLINE_INDEX4X8 {
    uint32_t index0;
    uint32_t index1;
    uint32_t index2;
    uint32_t index3;
};

static inline void
__NVA097_DRAW_INLINE_INDEX4X8(uint32_t *val_out, struct nv_nva097_DRAW_INLINE_INDEX4X8 st)
{
    uint32_t val = 0;
    
    assert(st.index0 < (1ULL << 8));
    val |= st.index0 << 0;
    
    assert(st.index1 < (1ULL << 8));
    val |= st.index1 << 8;
    
    assert(st.index2 < (1ULL << 8));
    val |= st.index2 << 16;
    
    assert(st.index3 < (1ULL << 8));
    val |= st.index3 << 24;
    *val_out = val;
}

#define V_NVA097_DRAW_INLINE_INDEX4X8(val, args...) { \
    struct nv_nva097_DRAW_INLINE_INDEX4X8 __data = args; \
    __NVA097_DRAW_INLINE_INDEX4X8(&val, __data); \
}

#define VA_NVA097_DRAW_INLINE_INDEX4X8 V_NVA097_DRAW_INLINE_INDEX4X8

#define P_NVA097_DRAW_INLINE_INDEX4X8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INLINE_INDEX4X8(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INLINE_INDEX4X8, nvk_p_ret); \
} while(0)

struct nv_nva097_D3D_SET_CULL_MODE {
    uint32_t v;
};

static inline void
__NVA097_D3D_SET_CULL_MODE(uint32_t *val_out, struct nv_nva097_D3D_SET_CULL_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_D3D_SET_CULL_MODE(val, args...) { \
    UNUSED uint32_t V_NONE = NVA097_D3D_SET_CULL_MODE_V_NONE; \
    UNUSED uint32_t V_CW = NVA097_D3D_SET_CULL_MODE_V_CW; \
    UNUSED uint32_t V_CCW = NVA097_D3D_SET_CULL_MODE_V_CCW; \
    struct nv_nva097_D3D_SET_CULL_MODE __data = { .v = (args) }; \
    __NVA097_D3D_SET_CULL_MODE(&val, __data); \
}

#define VA_NVA097_D3D_SET_CULL_MODE V_NVA097_D3D_SET_CULL_MODE

#define P_NVA097_D3D_SET_CULL_MODE(push, args...) do { \
    UNUSED uint32_t V_NONE = NVA097_D3D_SET_CULL_MODE_V_NONE; \
    UNUSED uint32_t V_CW = NVA097_D3D_SET_CULL_MODE_V_CW; \
    UNUSED uint32_t V_CCW = NVA097_D3D_SET_CULL_MODE_V_CCW; \
    uint32_t nvk_p_ret; \
    V_NVA097_D3D_SET_CULL_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_D3D_SET_CULL_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_FUNC {
    uint32_t v;
};

static inline void
__NVA097_SET_DEPTH_FUNC(uint32_t *val_out, struct nv_nva097_SET_DEPTH_FUNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_FUNC(val, args...) { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_DEPTH_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_DEPTH_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_DEPTH_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_DEPTH_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_DEPTH_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_DEPTH_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_DEPTH_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_DEPTH_FUNC_V_D3D_ALWAYS; \
    struct nv_nva097_SET_DEPTH_FUNC __data = { .v = (args) }; \
    __NVA097_SET_DEPTH_FUNC(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_FUNC V_NVA097_SET_DEPTH_FUNC

#define P_NVA097_SET_DEPTH_FUNC(push, args...) do { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_DEPTH_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_DEPTH_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_DEPTH_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_DEPTH_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_DEPTH_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_DEPTH_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_DEPTH_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_DEPTH_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_DEPTH_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_DEPTH_FUNC_V_D3D_ALWAYS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_FUNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_FUNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_REF {
    uint32_t v;
};

static inline void
__NVA097_SET_ALPHA_REF(uint32_t *val_out, struct nv_nva097_SET_ALPHA_REF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_REF(val, args...) { \
    struct nv_nva097_SET_ALPHA_REF __data = { .v = (args) }; \
    __NVA097_SET_ALPHA_REF(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_REF V_NVA097_SET_ALPHA_REF

#define P_NVA097_SET_ALPHA_REF(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_REF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_REF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_FUNC {
    uint32_t v;
};

static inline void
__NVA097_SET_ALPHA_FUNC(uint32_t *val_out, struct nv_nva097_SET_ALPHA_FUNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_FUNC(val, args...) { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_ALPHA_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_ALPHA_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_ALPHA_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_ALPHA_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_ALPHA_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_ALPHA_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_ALPHA_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_ALPHA_FUNC_V_D3D_ALWAYS; \
    struct nv_nva097_SET_ALPHA_FUNC __data = { .v = (args) }; \
    __NVA097_SET_ALPHA_FUNC(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_FUNC V_NVA097_SET_ALPHA_FUNC

#define P_NVA097_SET_ALPHA_FUNC(push, args...) do { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_ALPHA_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_ALPHA_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_ALPHA_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_ALPHA_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_ALPHA_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_ALPHA_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_ALPHA_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_ALPHA_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_ALPHA_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_ALPHA_FUNC_V_D3D_ALWAYS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_FUNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_FUNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DRAW_AUTO_STRIDE {
    uint32_t v;
};

static inline void
__NVA097_SET_DRAW_AUTO_STRIDE(uint32_t *val_out, struct nv_nva097_SET_DRAW_AUTO_STRIDE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 12));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_DRAW_AUTO_STRIDE(val, args...) { \
    struct nv_nva097_SET_DRAW_AUTO_STRIDE __data = { .v = (args) }; \
    __NVA097_SET_DRAW_AUTO_STRIDE(&val, __data); \
}

#define VA_NVA097_SET_DRAW_AUTO_STRIDE V_NVA097_SET_DRAW_AUTO_STRIDE

#define P_NVA097_SET_DRAW_AUTO_STRIDE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DRAW_AUTO_STRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DRAW_AUTO_STRIDE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_CONST_RED {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_CONST_RED(uint32_t *val_out, struct nv_nva097_SET_BLEND_CONST_RED st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_CONST_RED(val, args...) { \
    struct nv_nva097_SET_BLEND_CONST_RED __data = { .v = (args) }; \
    __NVA097_SET_BLEND_CONST_RED(&val, __data); \
}

#define VA_NVA097_SET_BLEND_CONST_RED V_NVA097_SET_BLEND_CONST_RED

#define P_NVA097_SET_BLEND_CONST_RED(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_CONST_RED(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_CONST_RED, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_CONST_GREEN {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_CONST_GREEN(uint32_t *val_out, struct nv_nva097_SET_BLEND_CONST_GREEN st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_CONST_GREEN(val, args...) { \
    struct nv_nva097_SET_BLEND_CONST_GREEN __data = { .v = (args) }; \
    __NVA097_SET_BLEND_CONST_GREEN(&val, __data); \
}

#define VA_NVA097_SET_BLEND_CONST_GREEN V_NVA097_SET_BLEND_CONST_GREEN

#define P_NVA097_SET_BLEND_CONST_GREEN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_CONST_GREEN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_CONST_GREEN, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_CONST_BLUE {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_CONST_BLUE(uint32_t *val_out, struct nv_nva097_SET_BLEND_CONST_BLUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_CONST_BLUE(val, args...) { \
    struct nv_nva097_SET_BLEND_CONST_BLUE __data = { .v = (args) }; \
    __NVA097_SET_BLEND_CONST_BLUE(&val, __data); \
}

#define VA_NVA097_SET_BLEND_CONST_BLUE V_NVA097_SET_BLEND_CONST_BLUE

#define P_NVA097_SET_BLEND_CONST_BLUE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_CONST_BLUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_CONST_BLUE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_CONST_ALPHA {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_CONST_ALPHA(uint32_t *val_out, struct nv_nva097_SET_BLEND_CONST_ALPHA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_CONST_ALPHA(val, args...) { \
    struct nv_nva097_SET_BLEND_CONST_ALPHA __data = { .v = (args) }; \
    __NVA097_SET_BLEND_CONST_ALPHA(&val, __data); \
}

#define VA_NVA097_SET_BLEND_CONST_ALPHA V_NVA097_SET_BLEND_CONST_ALPHA

#define P_NVA097_SET_BLEND_CONST_ALPHA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_CONST_ALPHA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_CONST_ALPHA, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_SAMPLER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_SAMPLER_CACHE(uint32_t *val_out, struct nv_nva097_INVALIDATE_SAMPLER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_SAMPLER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    struct nv_nva097_INVALIDATE_SAMPLER_CACHE __data = args; \
    __NVA097_INVALIDATE_SAMPLER_CACHE(&val, __data); \
}

#define VA_NVA097_INVALIDATE_SAMPLER_CACHE V_NVA097_INVALIDATE_SAMPLER_CACHE

#define P_NVA097_INVALIDATE_SAMPLER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_SAMPLER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_SAMPLER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_TEXTURE_HEADER_CACHE(uint32_t *val_out, struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE __data = args; \
    __NVA097_INVALIDATE_TEXTURE_HEADER_CACHE(&val, __data); \
}

#define VA_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE

#define P_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_TEXTURE_HEADER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_TEXTURE_DATA_CACHE(uint32_t *val_out, struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    struct nv_nva097_INVALIDATE_TEXTURE_DATA_CACHE __data = args; \
    __NVA097_INVALIDATE_TEXTURE_DATA_CACHE(&val, __data); \
}

#define VA_NVA097_INVALIDATE_TEXTURE_DATA_CACHE V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE

#define P_NVA097_INVALIDATE_TEXTURE_DATA_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_TEXTURE_DATA_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_TEXTURE_DATA_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_SEPARATE_FOR_ALPHA {
    uint32_t enable;
};

static inline void
__NVA097_SET_BLEND_SEPARATE_FOR_ALPHA(uint32_t *val_out, struct nv_nva097_SET_BLEND_SEPARATE_FOR_ALPHA st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_SEPARATE_FOR_ALPHA(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_TRUE; \
    struct nv_nva097_SET_BLEND_SEPARATE_FOR_ALPHA __data = { .enable = (args) }; \
    __NVA097_SET_BLEND_SEPARATE_FOR_ALPHA(&val, __data); \
}

#define VA_NVA097_SET_BLEND_SEPARATE_FOR_ALPHA V_NVA097_SET_BLEND_SEPARATE_FOR_ALPHA

#define P_NVA097_SET_BLEND_SEPARATE_FOR_ALPHA(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_SEPARATE_FOR_ALPHA_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_SEPARATE_FOR_ALPHA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_SEPARATE_FOR_ALPHA, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_COLOR_OP {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_COLOR_OP(uint32_t *val_out, struct nv_nva097_SET_BLEND_COLOR_OP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_COLOR_OP(val, args...) { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_COLOR_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_COLOR_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_COLOR_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_COLOR_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_COLOR_OP_V_D3D_MAX; \
    struct nv_nva097_SET_BLEND_COLOR_OP __data = { .v = (args) }; \
    __NVA097_SET_BLEND_COLOR_OP(&val, __data); \
}

#define VA_NVA097_SET_BLEND_COLOR_OP V_NVA097_SET_BLEND_COLOR_OP

#define P_NVA097_SET_BLEND_COLOR_OP(push, args...) do { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_COLOR_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_COLOR_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_COLOR_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_COLOR_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_COLOR_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_COLOR_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_COLOR_OP_V_D3D_MAX; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_COLOR_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_COLOR_OP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_COLOR_SOURCE_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_COLOR_SOURCE_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_COLOR_SOURCE_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_COLOR_SOURCE_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_COLOR_SOURCE_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_COLOR_SOURCE_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_COLOR_SOURCE_COEFF V_NVA097_SET_BLEND_COLOR_SOURCE_COEFF

#define P_NVA097_SET_BLEND_COLOR_SOURCE_COEFF(push, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_COLOR_SOURCE_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_COLOR_SOURCE_COEFF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_COLOR_DEST_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_COLOR_DEST_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_COLOR_DEST_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_COLOR_DEST_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_COLOR_DEST_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_COLOR_DEST_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_COLOR_DEST_COEFF V_NVA097_SET_BLEND_COLOR_DEST_COEFF

#define P_NVA097_SET_BLEND_COLOR_DEST_COEFF(push, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_COLOR_DEST_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_COLOR_DEST_COEFF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_ALPHA_OP {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_ALPHA_OP(uint32_t *val_out, struct nv_nva097_SET_BLEND_ALPHA_OP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_ALPHA_OP(val, args...) { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_ALPHA_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_ALPHA_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_ALPHA_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_ALPHA_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_ALPHA_OP_V_D3D_MAX; \
    struct nv_nva097_SET_BLEND_ALPHA_OP __data = { .v = (args) }; \
    __NVA097_SET_BLEND_ALPHA_OP(&val, __data); \
}

#define VA_NVA097_SET_BLEND_ALPHA_OP V_NVA097_SET_BLEND_ALPHA_OP

#define P_NVA097_SET_BLEND_ALPHA_OP(push, args...) do { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_ALPHA_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_ALPHA_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_ALPHA_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_ALPHA_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_ALPHA_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_ALPHA_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_ALPHA_OP_V_D3D_MAX; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_ALPHA_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_ALPHA_OP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_ALPHA_SOURCE_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_ALPHA_SOURCE_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_ALPHA_SOURCE_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_ALPHA_SOURCE_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_ALPHA_SOURCE_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_ALPHA_SOURCE_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_ALPHA_SOURCE_COEFF V_NVA097_SET_BLEND_ALPHA_SOURCE_COEFF

#define P_NVA097_SET_BLEND_ALPHA_SOURCE_COEFF(push, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_ALPHA_SOURCE_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_ALPHA_SOURCE_COEFF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_COLOR_KEY {
    uint32_t enable;
};

static inline void
__NVA097_SET_GLOBAL_COLOR_KEY(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_COLOR_KEY st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_COLOR_KEY(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE; \
    struct nv_nva097_SET_GLOBAL_COLOR_KEY __data = { .enable = (args) }; \
    __NVA097_SET_GLOBAL_COLOR_KEY(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_COLOR_KEY V_NVA097_SET_GLOBAL_COLOR_KEY

#define P_NVA097_SET_GLOBAL_COLOR_KEY(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_GLOBAL_COLOR_KEY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_GLOBAL_COLOR_KEY_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_COLOR_KEY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_COLOR_KEY, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_ALPHA_DEST_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_ALPHA_DEST_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_ALPHA_DEST_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_ALPHA_DEST_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_ALPHA_DEST_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_ALPHA_DEST_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_ALPHA_DEST_COEFF V_NVA097_SET_BLEND_ALPHA_DEST_COEFF

#define P_NVA097_SET_BLEND_ALPHA_DEST_COEFF(push, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_ALPHA_DEST_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_ALPHA_DEST_COEFF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SINGLE_ROP_CONTROL {
    uint32_t enable;
};

static inline void
__NVA097_SET_SINGLE_ROP_CONTROL(uint32_t *val_out, struct nv_nva097_SET_SINGLE_ROP_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SINGLE_ROP_CONTROL(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SINGLE_ROP_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SINGLE_ROP_CONTROL_ENABLE_TRUE; \
    struct nv_nva097_SET_SINGLE_ROP_CONTROL __data = { .enable = (args) }; \
    __NVA097_SET_SINGLE_ROP_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_SINGLE_ROP_CONTROL V_NVA097_SET_SINGLE_ROP_CONTROL

#define P_NVA097_SET_SINGLE_ROP_CONTROL(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SINGLE_ROP_CONTROL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SINGLE_ROP_CONTROL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SINGLE_ROP_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SINGLE_ROP_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND {
    uint32_t enable;
};

static inline void
__NVA097_SET_BLEND(uint32_t *val_out, struct nv_nva097_SET_BLEND st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_ENABLE_TRUE; \
    struct nv_nva097_SET_BLEND __data = { .enable = (args) }; \
    __NVA097_SET_BLEND(&val, __data); \
}

#define VA_NVA097_SET_BLEND(i) V_NVA097_SET_BLEND

#define P_NVA097_SET_BLEND(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_STENCIL_TEST(uint32_t *val_out, struct nv_nva097_SET_STENCIL_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_STENCIL_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_STENCIL_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_STENCIL_TEST __data = { .enable = (args) }; \
    __NVA097_SET_STENCIL_TEST(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_TEST V_NVA097_SET_STENCIL_TEST

#define P_NVA097_SET_STENCIL_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_STENCIL_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_STENCIL_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_OP_FAIL {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_OP_FAIL(uint32_t *val_out, struct nv_nva097_SET_STENCIL_OP_FAIL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_OP_FAIL(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_FAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_FAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_FAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_FAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_FAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_FAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_FAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_FAIL_V_D3D_DECR; \
    struct nv_nva097_SET_STENCIL_OP_FAIL __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_OP_FAIL(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_OP_FAIL V_NVA097_SET_STENCIL_OP_FAIL

#define P_NVA097_SET_STENCIL_OP_FAIL(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_FAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_FAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_FAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_FAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_FAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_FAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_FAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_FAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_FAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_FAIL_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_OP_FAIL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_OP_FAIL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_OP_ZFAIL {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_OP_ZFAIL(uint32_t *val_out, struct nv_nva097_SET_STENCIL_OP_ZFAIL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_OP_ZFAIL(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_DECR; \
    struct nv_nva097_SET_STENCIL_OP_ZFAIL __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_OP_ZFAIL(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_OP_ZFAIL V_NVA097_SET_STENCIL_OP_ZFAIL

#define P_NVA097_SET_STENCIL_OP_ZFAIL(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_ZFAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_ZFAIL_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_OP_ZFAIL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_OP_ZFAIL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_OP_ZPASS {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_OP_ZPASS(uint32_t *val_out, struct nv_nva097_SET_STENCIL_OP_ZPASS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_OP_ZPASS(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_DECR; \
    struct nv_nva097_SET_STENCIL_OP_ZPASS __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_OP_ZPASS(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_OP_ZPASS V_NVA097_SET_STENCIL_OP_ZPASS

#define P_NVA097_SET_STENCIL_OP_ZPASS(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_STENCIL_OP_ZPASS_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_STENCIL_OP_ZPASS_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_OP_ZPASS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_OP_ZPASS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_FUNC {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_FUNC(uint32_t *val_out, struct nv_nva097_SET_STENCIL_FUNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_FUNC(val, args...) { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_STENCIL_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_STENCIL_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_STENCIL_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_STENCIL_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_STENCIL_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_STENCIL_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_STENCIL_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_STENCIL_FUNC_V_D3D_ALWAYS; \
    struct nv_nva097_SET_STENCIL_FUNC __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_FUNC(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_FUNC V_NVA097_SET_STENCIL_FUNC

#define P_NVA097_SET_STENCIL_FUNC(push, args...) do { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_STENCIL_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_STENCIL_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_STENCIL_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_STENCIL_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_STENCIL_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_STENCIL_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_STENCIL_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_STENCIL_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_STENCIL_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_STENCIL_FUNC_V_D3D_ALWAYS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_FUNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_FUNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_FUNC_REF {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_FUNC_REF(uint32_t *val_out, struct nv_nva097_SET_STENCIL_FUNC_REF st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_FUNC_REF(val, args...) { \
    struct nv_nva097_SET_STENCIL_FUNC_REF __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_FUNC_REF(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_FUNC_REF V_NVA097_SET_STENCIL_FUNC_REF

#define P_NVA097_SET_STENCIL_FUNC_REF(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_FUNC_REF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_FUNC_REF, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_FUNC_MASK {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_FUNC_MASK(uint32_t *val_out, struct nv_nva097_SET_STENCIL_FUNC_MASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_FUNC_MASK(val, args...) { \
    struct nv_nva097_SET_STENCIL_FUNC_MASK __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_FUNC_MASK(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_FUNC_MASK V_NVA097_SET_STENCIL_FUNC_MASK

#define P_NVA097_SET_STENCIL_FUNC_MASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_FUNC_MASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_FUNC_MASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_STENCIL_MASK {
    uint32_t v;
};

static inline void
__NVA097_SET_STENCIL_MASK(uint32_t *val_out, struct nv_nva097_SET_STENCIL_MASK st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_STENCIL_MASK(val, args...) { \
    struct nv_nva097_SET_STENCIL_MASK __data = { .v = (args) }; \
    __NVA097_SET_STENCIL_MASK(&val, __data); \
}

#define VA_NVA097_SET_STENCIL_MASK V_NVA097_SET_STENCIL_MASK

#define P_NVA097_SET_STENCIL_MASK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_STENCIL_MASK(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_STENCIL_MASK, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DRAW_AUTO_START {
    uint32_t byte_count;
};

static inline void
__NVA097_SET_DRAW_AUTO_START(uint32_t *val_out, struct nv_nva097_SET_DRAW_AUTO_START st)
{
    uint32_t val = 0;
    
    val |= st.byte_count;
    *val_out = val;
}

#define V_NVA097_SET_DRAW_AUTO_START(val, args...) { \
    struct nv_nva097_SET_DRAW_AUTO_START __data = { .byte_count = (args) }; \
    __NVA097_SET_DRAW_AUTO_START(&val, __data); \
}

#define VA_NVA097_SET_DRAW_AUTO_START V_NVA097_SET_DRAW_AUTO_START

#define P_NVA097_SET_DRAW_AUTO_START(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DRAW_AUTO_START(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DRAW_AUTO_START, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PS_SATURATE {
    uint32_t output0;
    uint32_t output1;
    uint32_t output2;
    uint32_t output3;
    uint32_t output4;
    uint32_t output5;
    uint32_t output6;
    uint32_t output7;
};

static inline void
__NVA097_SET_PS_SATURATE(uint32_t *val_out, struct nv_nva097_SET_PS_SATURATE st)
{
    uint32_t val = 0;
    
    assert(st.output0 < (1ULL << 1));
    val |= st.output0 << 0;
    
    assert(st.output1 < (1ULL << 1));
    val |= st.output1 << 4;
    
    assert(st.output2 < (1ULL << 1));
    val |= st.output2 << 8;
    
    assert(st.output3 < (1ULL << 1));
    val |= st.output3 << 12;
    
    assert(st.output4 < (1ULL << 1));
    val |= st.output4 << 16;
    
    assert(st.output5 < (1ULL << 1));
    val |= st.output5 << 20;
    
    assert(st.output6 < (1ULL << 1));
    val |= st.output6 << 24;
    
    assert(st.output7 < (1ULL << 1));
    val |= st.output7 << 28;
    *val_out = val;
}

#define V_NVA097_SET_PS_SATURATE(val, args...) { \
    UNUSED uint32_t OUTPUT0_FALSE = NVA097_SET_PS_SATURATE_OUTPUT0_FALSE; \
    UNUSED uint32_t OUTPUT0_TRUE = NVA097_SET_PS_SATURATE_OUTPUT0_TRUE; \
    UNUSED uint32_t OUTPUT1_FALSE = NVA097_SET_PS_SATURATE_OUTPUT1_FALSE; \
    UNUSED uint32_t OUTPUT1_TRUE = NVA097_SET_PS_SATURATE_OUTPUT1_TRUE; \
    UNUSED uint32_t OUTPUT2_FALSE = NVA097_SET_PS_SATURATE_OUTPUT2_FALSE; \
    UNUSED uint32_t OUTPUT2_TRUE = NVA097_SET_PS_SATURATE_OUTPUT2_TRUE; \
    UNUSED uint32_t OUTPUT3_FALSE = NVA097_SET_PS_SATURATE_OUTPUT3_FALSE; \
    UNUSED uint32_t OUTPUT3_TRUE = NVA097_SET_PS_SATURATE_OUTPUT3_TRUE; \
    UNUSED uint32_t OUTPUT4_FALSE = NVA097_SET_PS_SATURATE_OUTPUT4_FALSE; \
    UNUSED uint32_t OUTPUT4_TRUE = NVA097_SET_PS_SATURATE_OUTPUT4_TRUE; \
    UNUSED uint32_t OUTPUT5_FALSE = NVA097_SET_PS_SATURATE_OUTPUT5_FALSE; \
    UNUSED uint32_t OUTPUT5_TRUE = NVA097_SET_PS_SATURATE_OUTPUT5_TRUE; \
    UNUSED uint32_t OUTPUT6_FALSE = NVA097_SET_PS_SATURATE_OUTPUT6_FALSE; \
    UNUSED uint32_t OUTPUT6_TRUE = NVA097_SET_PS_SATURATE_OUTPUT6_TRUE; \
    UNUSED uint32_t OUTPUT7_FALSE = NVA097_SET_PS_SATURATE_OUTPUT7_FALSE; \
    UNUSED uint32_t OUTPUT7_TRUE = NVA097_SET_PS_SATURATE_OUTPUT7_TRUE; \
    struct nv_nva097_SET_PS_SATURATE __data = args; \
    __NVA097_SET_PS_SATURATE(&val, __data); \
}

#define VA_NVA097_SET_PS_SATURATE V_NVA097_SET_PS_SATURATE

#define P_NVA097_SET_PS_SATURATE(push, args...) do { \
    UNUSED uint32_t OUTPUT0_FALSE = NVA097_SET_PS_SATURATE_OUTPUT0_FALSE; \
    UNUSED uint32_t OUTPUT0_TRUE = NVA097_SET_PS_SATURATE_OUTPUT0_TRUE; \
    UNUSED uint32_t OUTPUT1_FALSE = NVA097_SET_PS_SATURATE_OUTPUT1_FALSE; \
    UNUSED uint32_t OUTPUT1_TRUE = NVA097_SET_PS_SATURATE_OUTPUT1_TRUE; \
    UNUSED uint32_t OUTPUT2_FALSE = NVA097_SET_PS_SATURATE_OUTPUT2_FALSE; \
    UNUSED uint32_t OUTPUT2_TRUE = NVA097_SET_PS_SATURATE_OUTPUT2_TRUE; \
    UNUSED uint32_t OUTPUT3_FALSE = NVA097_SET_PS_SATURATE_OUTPUT3_FALSE; \
    UNUSED uint32_t OUTPUT3_TRUE = NVA097_SET_PS_SATURATE_OUTPUT3_TRUE; \
    UNUSED uint32_t OUTPUT4_FALSE = NVA097_SET_PS_SATURATE_OUTPUT4_FALSE; \
    UNUSED uint32_t OUTPUT4_TRUE = NVA097_SET_PS_SATURATE_OUTPUT4_TRUE; \
    UNUSED uint32_t OUTPUT5_FALSE = NVA097_SET_PS_SATURATE_OUTPUT5_FALSE; \
    UNUSED uint32_t OUTPUT5_TRUE = NVA097_SET_PS_SATURATE_OUTPUT5_TRUE; \
    UNUSED uint32_t OUTPUT6_FALSE = NVA097_SET_PS_SATURATE_OUTPUT6_FALSE; \
    UNUSED uint32_t OUTPUT6_TRUE = NVA097_SET_PS_SATURATE_OUTPUT6_TRUE; \
    UNUSED uint32_t OUTPUT7_FALSE = NVA097_SET_PS_SATURATE_OUTPUT7_FALSE; \
    UNUSED uint32_t OUTPUT7_TRUE = NVA097_SET_PS_SATURATE_OUTPUT7_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PS_SATURATE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PS_SATURATE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_ORIGIN {
    uint32_t mode;
    uint32_t flip_y;
};

static inline void
__NVA097_SET_WINDOW_ORIGIN(uint32_t *val_out, struct nv_nva097_SET_WINDOW_ORIGIN st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 1));
    val |= st.mode << 0;
    
    assert(st.flip_y < (1ULL << 1));
    val |= st.flip_y << 4;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_ORIGIN(val, args...) { \
    UNUSED uint32_t MODE_UPPER_LEFT = NVA097_SET_WINDOW_ORIGIN_MODE_UPPER_LEFT; \
    UNUSED uint32_t MODE_LOWER_LEFT = NVA097_SET_WINDOW_ORIGIN_MODE_LOWER_LEFT; \
    UNUSED uint32_t FLIP_Y_FALSE = NVA097_SET_WINDOW_ORIGIN_FLIP_Y_FALSE; \
    UNUSED uint32_t FLIP_Y_TRUE = NVA097_SET_WINDOW_ORIGIN_FLIP_Y_TRUE; \
    struct nv_nva097_SET_WINDOW_ORIGIN __data = args; \
    __NVA097_SET_WINDOW_ORIGIN(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_ORIGIN V_NVA097_SET_WINDOW_ORIGIN

#define P_NVA097_SET_WINDOW_ORIGIN(push, args...) do { \
    UNUSED uint32_t MODE_UPPER_LEFT = NVA097_SET_WINDOW_ORIGIN_MODE_UPPER_LEFT; \
    UNUSED uint32_t MODE_LOWER_LEFT = NVA097_SET_WINDOW_ORIGIN_MODE_LOWER_LEFT; \
    UNUSED uint32_t FLIP_Y_FALSE = NVA097_SET_WINDOW_ORIGIN_FLIP_Y_FALSE; \
    UNUSED uint32_t FLIP_Y_TRUE = NVA097_SET_WINDOW_ORIGIN_FLIP_Y_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_ORIGIN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_ORIGIN, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_WIDTH_FLOAT {
    uint32_t v;
};

static inline void
__NVA097_SET_LINE_WIDTH_FLOAT(uint32_t *val_out, struct nv_nva097_SET_LINE_WIDTH_FLOAT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_LINE_WIDTH_FLOAT(val, args...) { \
    struct nv_nva097_SET_LINE_WIDTH_FLOAT __data = { .v = (args) }; \
    __NVA097_SET_LINE_WIDTH_FLOAT(&val, __data); \
}

#define VA_NVA097_SET_LINE_WIDTH_FLOAT V_NVA097_SET_LINE_WIDTH_FLOAT

#define P_NVA097_SET_LINE_WIDTH_FLOAT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_WIDTH_FLOAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_WIDTH_FLOAT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALIASED_LINE_WIDTH_FLOAT {
    uint32_t v;
};

static inline void
__NVA097_SET_ALIASED_LINE_WIDTH_FLOAT(uint32_t *val_out, struct nv_nva097_SET_ALIASED_LINE_WIDTH_FLOAT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_ALIASED_LINE_WIDTH_FLOAT(val, args...) { \
    struct nv_nva097_SET_ALIASED_LINE_WIDTH_FLOAT __data = { .v = (args) }; \
    __NVA097_SET_ALIASED_LINE_WIDTH_FLOAT(&val, __data); \
}

#define VA_NVA097_SET_ALIASED_LINE_WIDTH_FLOAT V_NVA097_SET_ALIASED_LINE_WIDTH_FLOAT

#define P_NVA097_SET_ALIASED_LINE_WIDTH_FLOAT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALIASED_LINE_WIDTH_FLOAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALIASED_LINE_WIDTH_FLOAT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_MULTISAMPLE_OVERRIDE {
    uint32_t enable;
};

static inline void
__NVA097_SET_LINE_MULTISAMPLE_OVERRIDE(uint32_t *val_out, struct nv_nva097_SET_LINE_MULTISAMPLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_LINE_MULTISAMPLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_TRUE; \
    struct nv_nva097_SET_LINE_MULTISAMPLE_OVERRIDE __data = { .enable = (args) }; \
    __NVA097_SET_LINE_MULTISAMPLE_OVERRIDE(&val, __data); \
}

#define VA_NVA097_SET_LINE_MULTISAMPLE_OVERRIDE V_NVA097_SET_LINE_MULTISAMPLE_OVERRIDE

#define P_NVA097_SET_LINE_MULTISAMPLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LINE_MULTISAMPLE_OVERRIDE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_MULTISAMPLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_MULTISAMPLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_HYSTERESIS {
    uint32_t rounds_of_alpha;
};

static inline void
__NVA097_SET_ALPHA_HYSTERESIS(uint32_t *val_out, struct nv_nva097_SET_ALPHA_HYSTERESIS st)
{
    uint32_t val = 0;
    
    assert(st.rounds_of_alpha < (1ULL << 8));
    val |= st.rounds_of_alpha << 0;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_HYSTERESIS(val, args...) { \
    struct nv_nva097_SET_ALPHA_HYSTERESIS __data = { .rounds_of_alpha = (args) }; \
    __NVA097_SET_ALPHA_HYSTERESIS(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_HYSTERESIS V_NVA097_SET_ALPHA_HYSTERESIS

#define P_NVA097_SET_ALPHA_HYSTERESIS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_HYSTERESIS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_HYSTERESIS, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_SAMPLER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nva097_INVALIDATE_SAMPLER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nva097_INVALIDATE_SAMPLER_CACHE_NO_WFI __data = args; \
    __NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI V_NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI

#define P_NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_SAMPLER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nva097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI __data = args; \
    __NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI

#define P_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_DA_DMA_CACHE {
    uint32_t v;
};

static inline void
__NVA097_INVALIDATE_DA_DMA_CACHE(uint32_t *val_out, struct nv_nva097_INVALIDATE_DA_DMA_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_DA_DMA_CACHE(val, args...) { \
    struct nv_nva097_INVALIDATE_DA_DMA_CACHE __data = { .v = (args) }; \
    __NVA097_INVALIDATE_DA_DMA_CACHE(&val, __data); \
}

#define VA_NVA097_INVALIDATE_DA_DMA_CACHE V_NVA097_INVALIDATE_DA_DMA_CACHE

#define P_NVA097_INVALIDATE_DA_DMA_CACHE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_DA_DMA_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_DA_DMA_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_BASE_VERTEX_INDEX {
    uint32_t v;
};

static inline void
__NVA097_SET_GLOBAL_BASE_VERTEX_INDEX(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_BASE_VERTEX_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_BASE_VERTEX_INDEX(val, args...) { \
    struct nv_nva097_SET_GLOBAL_BASE_VERTEX_INDEX __data = { .v = (args) }; \
    __NVA097_SET_GLOBAL_BASE_VERTEX_INDEX(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_BASE_VERTEX_INDEX V_NVA097_SET_GLOBAL_BASE_VERTEX_INDEX

#define P_NVA097_SET_GLOBAL_BASE_VERTEX_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_BASE_VERTEX_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_BASE_VERTEX_INDEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_GLOBAL_BASE_INSTANCE_INDEX {
    uint32_t v;
};

static inline void
__NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX(uint32_t *val_out, struct nv_nva097_SET_GLOBAL_BASE_INSTANCE_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX(val, args...) { \
    struct nv_nva097_SET_GLOBAL_BASE_INSTANCE_INDEX __data = { .v = (args) }; \
    __NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX(&val, __data); \
}

#define VA_NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX V_NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX

#define P_NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_GLOBAL_BASE_INSTANCE_INDEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PS_WARP_WATERMARKS {
    uint32_t low;
    uint32_t high;
};

static inline void
__NVA097_SET_PS_WARP_WATERMARKS(uint32_t *val_out, struct nv_nva097_SET_PS_WARP_WATERMARKS st)
{
    uint32_t val = 0;
    
    assert(st.low < (1ULL << 16));
    val |= st.low << 0;
    
    assert(st.high < (1ULL << 16));
    val |= st.high << 16;
    *val_out = val;
}

#define V_NVA097_SET_PS_WARP_WATERMARKS(val, args...) { \
    struct nv_nva097_SET_PS_WARP_WATERMARKS __data = args; \
    __NVA097_SET_PS_WARP_WATERMARKS(&val, __data); \
}

#define VA_NVA097_SET_PS_WARP_WATERMARKS V_NVA097_SET_PS_WARP_WATERMARKS

#define P_NVA097_SET_PS_WARP_WATERMARKS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PS_WARP_WATERMARKS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PS_WARP_WATERMARKS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PS_REGISTER_WATERMARKS {
    uint32_t low;
    uint32_t high;
};

static inline void
__NVA097_SET_PS_REGISTER_WATERMARKS(uint32_t *val_out, struct nv_nva097_SET_PS_REGISTER_WATERMARKS st)
{
    uint32_t val = 0;
    
    assert(st.low < (1ULL << 16));
    val |= st.low << 0;
    
    assert(st.high < (1ULL << 16));
    val |= st.high << 16;
    *val_out = val;
}

#define V_NVA097_SET_PS_REGISTER_WATERMARKS(val, args...) { \
    struct nv_nva097_SET_PS_REGISTER_WATERMARKS __data = args; \
    __NVA097_SET_PS_REGISTER_WATERMARKS(&val, __data); \
}

#define VA_NVA097_SET_PS_REGISTER_WATERMARKS V_NVA097_SET_PS_REGISTER_WATERMARKS

#define P_NVA097_SET_PS_REGISTER_WATERMARKS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PS_REGISTER_WATERMARKS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PS_REGISTER_WATERMARKS, nvk_p_ret); \
} while(0)

struct nv_nva097_STORE_ZCULL {
    uint32_t v;
};

static inline void
__NVA097_STORE_ZCULL(uint32_t *val_out, struct nv_nva097_STORE_ZCULL st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_STORE_ZCULL(val, args...) { \
    struct nv_nva097_STORE_ZCULL __data = { .v = (args) }; \
    __NVA097_STORE_ZCULL(&val, __data); \
}

#define VA_NVA097_STORE_ZCULL V_NVA097_STORE_ZCULL

#define P_NVA097_STORE_ZCULL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_STORE_ZCULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_STORE_ZCULL, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_ZCULL {
    uint32_t v;
};

static inline void
__NVA097_LOAD_ZCULL(uint32_t *val_out, struct nv_nva097_LOAD_ZCULL st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_LOAD_ZCULL(val, args...) { \
    struct nv_nva097_LOAD_ZCULL __data = { .v = (args) }; \
    __NVA097_LOAD_ZCULL(&val, __data); \
}

#define VA_NVA097_LOAD_ZCULL V_NVA097_LOAD_ZCULL

#define P_NVA097_LOAD_ZCULL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_ZCULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_ZCULL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_ID_HEIGHT {
    uint32_t v;
};

static inline void
__NVA097_SET_SURFACE_CLIP_ID_HEIGHT(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_ID_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_ID_HEIGHT(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_ID_HEIGHT __data = { .v = (args) }; \
    __NVA097_SET_SURFACE_CLIP_ID_HEIGHT(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_ID_HEIGHT V_NVA097_SET_SURFACE_CLIP_ID_HEIGHT

#define P_NVA097_SET_SURFACE_CLIP_ID_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_ID_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_ID_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL {
    uint32_t xmin;
    uint32_t xmax;
};

static inline void
__NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL st)
{
    uint32_t val = 0;
    
    assert(st.xmin < (1ULL << 16));
    val |= st.xmin << 0;
    
    assert(st.xmax < (1ULL << 16));
    val |= st.xmax << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL(val, args...) { \
    struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL __data = args; \
    __NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL V_NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL

#define P_NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID_CLEAR_RECT_HORIZONTAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_VERTICAL {
    uint32_t ymin;
    uint32_t ymax;
};

static inline void
__NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_VERTICAL st)
{
    uint32_t val = 0;
    
    assert(st.ymin < (1ULL << 16));
    val |= st.ymin << 0;
    
    assert(st.ymax < (1ULL << 16));
    val |= st.ymax << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL(val, args...) { \
    struct nv_nva097_SET_CLIP_ID_CLEAR_RECT_VERTICAL __data = args; \
    __NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL V_NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL

#define P_NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID_CLEAR_RECT_VERTICAL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_USER_CLIP_ENABLE {
    uint32_t plane0;
    uint32_t plane1;
    uint32_t plane2;
    uint32_t plane3;
    uint32_t plane4;
    uint32_t plane5;
    uint32_t plane6;
    uint32_t plane7;
};

static inline void
__NVA097_SET_USER_CLIP_ENABLE(uint32_t *val_out, struct nv_nva097_SET_USER_CLIP_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.plane0 < (1ULL << 1));
    val |= st.plane0 << 0;
    
    assert(st.plane1 < (1ULL << 1));
    val |= st.plane1 << 1;
    
    assert(st.plane2 < (1ULL << 1));
    val |= st.plane2 << 2;
    
    assert(st.plane3 < (1ULL << 1));
    val |= st.plane3 << 3;
    
    assert(st.plane4 < (1ULL << 1));
    val |= st.plane4 << 4;
    
    assert(st.plane5 < (1ULL << 1));
    val |= st.plane5 << 5;
    
    assert(st.plane6 < (1ULL << 1));
    val |= st.plane6 << 6;
    
    assert(st.plane7 < (1ULL << 1));
    val |= st.plane7 << 7;
    *val_out = val;
}

#define V_NVA097_SET_USER_CLIP_ENABLE(val, args...) { \
    UNUSED uint32_t PLANE0_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE0_FALSE; \
    UNUSED uint32_t PLANE0_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE0_TRUE; \
    UNUSED uint32_t PLANE1_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE1_FALSE; \
    UNUSED uint32_t PLANE1_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE1_TRUE; \
    UNUSED uint32_t PLANE2_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE2_FALSE; \
    UNUSED uint32_t PLANE2_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE2_TRUE; \
    UNUSED uint32_t PLANE3_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE3_FALSE; \
    UNUSED uint32_t PLANE3_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE3_TRUE; \
    UNUSED uint32_t PLANE4_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE4_FALSE; \
    UNUSED uint32_t PLANE4_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE4_TRUE; \
    UNUSED uint32_t PLANE5_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE5_FALSE; \
    UNUSED uint32_t PLANE5_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE5_TRUE; \
    UNUSED uint32_t PLANE6_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE6_FALSE; \
    UNUSED uint32_t PLANE6_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE6_TRUE; \
    UNUSED uint32_t PLANE7_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE7_FALSE; \
    UNUSED uint32_t PLANE7_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE7_TRUE; \
    struct nv_nva097_SET_USER_CLIP_ENABLE __data = args; \
    __NVA097_SET_USER_CLIP_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_USER_CLIP_ENABLE V_NVA097_SET_USER_CLIP_ENABLE

#define P_NVA097_SET_USER_CLIP_ENABLE(push, args...) do { \
    UNUSED uint32_t PLANE0_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE0_FALSE; \
    UNUSED uint32_t PLANE0_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE0_TRUE; \
    UNUSED uint32_t PLANE1_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE1_FALSE; \
    UNUSED uint32_t PLANE1_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE1_TRUE; \
    UNUSED uint32_t PLANE2_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE2_FALSE; \
    UNUSED uint32_t PLANE2_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE2_TRUE; \
    UNUSED uint32_t PLANE3_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE3_FALSE; \
    UNUSED uint32_t PLANE3_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE3_TRUE; \
    UNUSED uint32_t PLANE4_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE4_FALSE; \
    UNUSED uint32_t PLANE4_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE4_TRUE; \
    UNUSED uint32_t PLANE5_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE5_FALSE; \
    UNUSED uint32_t PLANE5_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE5_TRUE; \
    UNUSED uint32_t PLANE6_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE6_FALSE; \
    UNUSED uint32_t PLANE6_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE6_TRUE; \
    UNUSED uint32_t PLANE7_FALSE = NVA097_SET_USER_CLIP_ENABLE_PLANE7_FALSE; \
    UNUSED uint32_t PLANE7_TRUE = NVA097_SET_USER_CLIP_ENABLE_PLANE7_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_USER_CLIP_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_USER_CLIP_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZPASS_PIXEL_COUNT {
    uint32_t enable;
};

static inline void
__NVA097_SET_ZPASS_PIXEL_COUNT(uint32_t *val_out, struct nv_nva097_SET_ZPASS_PIXEL_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZPASS_PIXEL_COUNT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZPASS_PIXEL_COUNT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZPASS_PIXEL_COUNT_ENABLE_TRUE; \
    struct nv_nva097_SET_ZPASS_PIXEL_COUNT __data = { .enable = (args) }; \
    __NVA097_SET_ZPASS_PIXEL_COUNT(&val, __data); \
}

#define VA_NVA097_SET_ZPASS_PIXEL_COUNT V_NVA097_SET_ZPASS_PIXEL_COUNT

#define P_NVA097_SET_ZPASS_PIXEL_COUNT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZPASS_PIXEL_COUNT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZPASS_PIXEL_COUNT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZPASS_PIXEL_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZPASS_PIXEL_COUNT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POINT_SIZE {
    uint32_t v;
};

static inline void
__NVA097_SET_POINT_SIZE(uint32_t *val_out, struct nv_nva097_SET_POINT_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_POINT_SIZE(val, args...) { \
    struct nv_nva097_SET_POINT_SIZE __data = { .v = (args) }; \
    __NVA097_SET_POINT_SIZE(&val, __data); \
}

#define VA_NVA097_SET_POINT_SIZE V_NVA097_SET_POINT_SIZE

#define P_NVA097_SET_POINT_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POINT_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POINT_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_STATS {
    uint32_t enable;
};

static inline void
__NVA097_SET_ZCULL_STATS(uint32_t *val_out, struct nv_nva097_SET_ZCULL_STATS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_STATS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_STATS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_STATS_ENABLE_TRUE; \
    struct nv_nva097_SET_ZCULL_STATS __data = { .enable = (args) }; \
    __NVA097_SET_ZCULL_STATS(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_STATS V_NVA097_SET_ZCULL_STATS

#define P_NVA097_SET_ZCULL_STATS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ZCULL_STATS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ZCULL_STATS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_STATS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_STATS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POINT_SPRITE {
    uint32_t enable;
};

static inline void
__NVA097_SET_POINT_SPRITE(uint32_t *val_out, struct nv_nva097_SET_POINT_SPRITE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POINT_SPRITE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POINT_SPRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POINT_SPRITE_ENABLE_TRUE; \
    struct nv_nva097_SET_POINT_SPRITE __data = { .enable = (args) }; \
    __NVA097_SET_POINT_SPRITE(&val, __data); \
}

#define VA_NVA097_SET_POINT_SPRITE V_NVA097_SET_POINT_SPRITE

#define P_NVA097_SET_POINT_SPRITE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POINT_SPRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POINT_SPRITE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POINT_SPRITE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POINT_SPRITE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_EXCEPTIONS {
    uint32_t enable;
};

static inline void
__NVA097_SET_SHADER_EXCEPTIONS(uint32_t *val_out, struct nv_nva097_SET_SHADER_EXCEPTIONS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_EXCEPTIONS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    struct nv_nva097_SET_SHADER_EXCEPTIONS __data = { .enable = (args) }; \
    __NVA097_SET_SHADER_EXCEPTIONS(&val, __data); \
}

#define VA_NVA097_SET_SHADER_EXCEPTIONS V_NVA097_SET_SHADER_EXCEPTIONS

#define P_NVA097_SET_SHADER_EXCEPTIONS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_EXCEPTIONS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_EXCEPTIONS, nvk_p_ret); \
} while(0)

struct nv_nva097_CLEAR_REPORT_VALUE {
    uint32_t type;
};

static inline void
__NVA097_CLEAR_REPORT_VALUE(uint32_t *val_out, struct nv_nva097_CLEAR_REPORT_VALUE st)
{
    uint32_t val = 0;
    
    assert(st.type < (1ULL << 5));
    val |= st.type << 0;
    *val_out = val;
}

#define V_NVA097_CLEAR_REPORT_VALUE(val, args...) { \
    UNUSED uint32_t TYPE_DA_VERTICES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED; \
    UNUSED uint32_t TYPE_DA_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_VS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS; \
    UNUSED uint32_t TYPE_TI_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS; \
    UNUSED uint32_t TYPE_TS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS; \
    UNUSED uint32_t TYPE_TS_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_GS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS; \
    UNUSED uint32_t TYPE_GS_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_VTG_PRIMITIVES_OUT = NVA097_CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT; \
    UNUSED uint32_t TYPE_STREAMING_PRIMITIVES_SUCCEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED; \
    UNUSED uint32_t TYPE_STREAMING_PRIMITIVES_NEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED; \
    UNUSED uint32_t TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t TYPE_CLIPPER_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS; \
    UNUSED uint32_t TYPE_CLIPPER_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_ZCULL_STATS = NVA097_CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS; \
    UNUSED uint32_t TYPE_PS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS; \
    UNUSED uint32_t TYPE_ZPASS_PIXEL_CNT = NVA097_CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT; \
    UNUSED uint32_t TYPE_ALPHA_BETA_CLOCKS = NVA097_CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS; \
    struct nv_nva097_CLEAR_REPORT_VALUE __data = { .type = (args) }; \
    __NVA097_CLEAR_REPORT_VALUE(&val, __data); \
}

#define VA_NVA097_CLEAR_REPORT_VALUE V_NVA097_CLEAR_REPORT_VALUE

#define P_NVA097_CLEAR_REPORT_VALUE(push, args...) do { \
    UNUSED uint32_t TYPE_DA_VERTICES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_DA_VERTICES_GENERATED; \
    UNUSED uint32_t TYPE_DA_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_DA_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_VS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_VS_INVOCATIONS; \
    UNUSED uint32_t TYPE_TI_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_TI_INVOCATIONS; \
    UNUSED uint32_t TYPE_TS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_TS_INVOCATIONS; \
    UNUSED uint32_t TYPE_TS_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_TS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_GS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_GS_INVOCATIONS; \
    UNUSED uint32_t TYPE_GS_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_GS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_VTG_PRIMITIVES_OUT = NVA097_CLEAR_REPORT_VALUE_TYPE_VTG_PRIMITIVES_OUT; \
    UNUSED uint32_t TYPE_STREAMING_PRIMITIVES_SUCCEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_SUCCEEDED; \
    UNUSED uint32_t TYPE_STREAMING_PRIMITIVES_NEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_STREAMING_PRIMITIVES_NEEDED; \
    UNUSED uint32_t TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_CLEAR_REPORT_VALUE_TYPE_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t TYPE_CLIPPER_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_CLIPPER_INVOCATIONS; \
    UNUSED uint32_t TYPE_CLIPPER_PRIMITIVES_GENERATED = NVA097_CLEAR_REPORT_VALUE_TYPE_CLIPPER_PRIMITIVES_GENERATED; \
    UNUSED uint32_t TYPE_ZCULL_STATS = NVA097_CLEAR_REPORT_VALUE_TYPE_ZCULL_STATS; \
    UNUSED uint32_t TYPE_PS_INVOCATIONS = NVA097_CLEAR_REPORT_VALUE_TYPE_PS_INVOCATIONS; \
    UNUSED uint32_t TYPE_ZPASS_PIXEL_CNT = NVA097_CLEAR_REPORT_VALUE_TYPE_ZPASS_PIXEL_CNT; \
    UNUSED uint32_t TYPE_ALPHA_BETA_CLOCKS = NVA097_CLEAR_REPORT_VALUE_TYPE_ALPHA_BETA_CLOCKS; \
    uint32_t nvk_p_ret; \
    V_NVA097_CLEAR_REPORT_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CLEAR_REPORT_VALUE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ANTI_ALIAS_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_ANTI_ALIAS_ENABLE(uint32_t *val_out, struct nv_nva097_SET_ANTI_ALIAS_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_ANTI_ALIAS_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_ANTI_ALIAS_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_ANTI_ALIAS_ENABLE_V_TRUE; \
    struct nv_nva097_SET_ANTI_ALIAS_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_ANTI_ALIAS_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_ANTI_ALIAS_ENABLE V_NVA097_SET_ANTI_ALIAS_ENABLE

#define P_NVA097_SET_ANTI_ALIAS_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_ANTI_ALIAS_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_ANTI_ALIAS_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ANTI_ALIAS_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ANTI_ALIAS_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_SELECT {
    uint32_t target_count;
};

static inline void
__NVA097_SET_ZT_SELECT(uint32_t *val_out, struct nv_nva097_SET_ZT_SELECT st)
{
    uint32_t val = 0;
    
    assert(st.target_count < (1ULL << 1));
    val |= st.target_count << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_SELECT(val, args...) { \
    struct nv_nva097_SET_ZT_SELECT __data = { .target_count = (args) }; \
    __NVA097_SET_ZT_SELECT(&val, __data); \
}

#define VA_NVA097_SET_ZT_SELECT V_NVA097_SET_ZT_SELECT

#define P_NVA097_SET_ZT_SELECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_SELECT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_SELECT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ANTI_ALIAS_ALPHA_CONTROL {
    uint32_t alpha_to_coverage;
    uint32_t alpha_to_one;
};

static inline void
__NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL(uint32_t *val_out, struct nv_nva097_SET_ANTI_ALIAS_ALPHA_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.alpha_to_coverage < (1ULL << 1));
    val |= st.alpha_to_coverage << 0;
    
    assert(st.alpha_to_one < (1ULL << 1));
    val |= st.alpha_to_one << 4;
    *val_out = val;
}

#define V_NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL(val, args...) { \
    UNUSED uint32_t ALPHA_TO_COVERAGE_DISABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_DISABLE; \
    UNUSED uint32_t ALPHA_TO_COVERAGE_ENABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_ENABLE; \
    UNUSED uint32_t ALPHA_TO_ONE_DISABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_DISABLE; \
    UNUSED uint32_t ALPHA_TO_ONE_ENABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_ENABLE; \
    struct nv_nva097_SET_ANTI_ALIAS_ALPHA_CONTROL __data = args; \
    __NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL V_NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL

#define P_NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL(push, args...) do { \
    UNUSED uint32_t ALPHA_TO_COVERAGE_DISABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_DISABLE; \
    UNUSED uint32_t ALPHA_TO_COVERAGE_ENABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_COVERAGE_ENABLE; \
    UNUSED uint32_t ALPHA_TO_ONE_DISABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_DISABLE; \
    UNUSED uint32_t ALPHA_TO_ONE_ENABLE = NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL_ALPHA_TO_ONE_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ANTI_ALIAS_ALPHA_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nva097_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nva097_SET_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVA097_SET_RENDER_ENABLE_A V_NVA097_SET_RENDER_ENABLE_A

#define P_NVA097_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nva097_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nva097_SET_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVA097_SET_RENDER_ENABLE_B V_NVA097_SET_RENDER_ENABLE_B

#define P_NVA097_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVA097_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nva097_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA097_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVA097_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA097_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA097_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA097_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA097_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nva097_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVA097_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVA097_SET_RENDER_ENABLE_C V_NVA097_SET_RENDER_ENABLE_C

#define P_NVA097_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVA097_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVA097_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVA097_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVA097_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVA097_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_SAMPLER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_TEX_SAMPLER_POOL_A(uint32_t *val_out, struct nv_nva097_SET_TEX_SAMPLER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_TEX_SAMPLER_POOL_A(val, args...) { \
    struct nv_nva097_SET_TEX_SAMPLER_POOL_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_TEX_SAMPLER_POOL_A(&val, __data); \
}

#define VA_NVA097_SET_TEX_SAMPLER_POOL_A V_NVA097_SET_TEX_SAMPLER_POOL_A

#define P_NVA097_SET_TEX_SAMPLER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_SAMPLER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_SAMPLER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_SAMPLER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_TEX_SAMPLER_POOL_B(uint32_t *val_out, struct nv_nva097_SET_TEX_SAMPLER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_TEX_SAMPLER_POOL_B(val, args...) { \
    struct nv_nva097_SET_TEX_SAMPLER_POOL_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_TEX_SAMPLER_POOL_B(&val, __data); \
}

#define VA_NVA097_SET_TEX_SAMPLER_POOL_B V_NVA097_SET_TEX_SAMPLER_POOL_B

#define P_NVA097_SET_TEX_SAMPLER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_SAMPLER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_SAMPLER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_SAMPLER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NVA097_SET_TEX_SAMPLER_POOL_C(uint32_t *val_out, struct nv_nva097_SET_TEX_SAMPLER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 20));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NVA097_SET_TEX_SAMPLER_POOL_C(val, args...) { \
    struct nv_nva097_SET_TEX_SAMPLER_POOL_C __data = { .maximum_index = (args) }; \
    __NVA097_SET_TEX_SAMPLER_POOL_C(&val, __data); \
}

#define VA_NVA097_SET_TEX_SAMPLER_POOL_C V_NVA097_SET_TEX_SAMPLER_POOL_C

#define P_NVA097_SET_TEX_SAMPLER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_SAMPLER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_SAMPLER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SLOPE_SCALE_DEPTH_BIAS {
    uint32_t v;
};

static inline void
__NVA097_SET_SLOPE_SCALE_DEPTH_BIAS(uint32_t *val_out, struct nv_nva097_SET_SLOPE_SCALE_DEPTH_BIAS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SLOPE_SCALE_DEPTH_BIAS(val, args...) { \
    struct nv_nva097_SET_SLOPE_SCALE_DEPTH_BIAS __data = { .v = (args) }; \
    __NVA097_SET_SLOPE_SCALE_DEPTH_BIAS(&val, __data); \
}

#define VA_NVA097_SET_SLOPE_SCALE_DEPTH_BIAS V_NVA097_SET_SLOPE_SCALE_DEPTH_BIAS

#define P_NVA097_SET_SLOPE_SCALE_DEPTH_BIAS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SLOPE_SCALE_DEPTH_BIAS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SLOPE_SCALE_DEPTH_BIAS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ANTI_ALIASED_LINE {
    uint32_t enable;
};

static inline void
__NVA097_SET_ANTI_ALIASED_LINE(uint32_t *val_out, struct nv_nva097_SET_ANTI_ALIASED_LINE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ANTI_ALIASED_LINE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ANTI_ALIASED_LINE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ANTI_ALIASED_LINE_ENABLE_TRUE; \
    struct nv_nva097_SET_ANTI_ALIASED_LINE __data = { .enable = (args) }; \
    __NVA097_SET_ANTI_ALIASED_LINE(&val, __data); \
}

#define VA_NVA097_SET_ANTI_ALIASED_LINE V_NVA097_SET_ANTI_ALIASED_LINE

#define P_NVA097_SET_ANTI_ALIASED_LINE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ANTI_ALIASED_LINE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ANTI_ALIASED_LINE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ANTI_ALIASED_LINE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ANTI_ALIASED_LINE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_HEADER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_TEX_HEADER_POOL_A(uint32_t *val_out, struct nv_nva097_SET_TEX_HEADER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_TEX_HEADER_POOL_A(val, args...) { \
    struct nv_nva097_SET_TEX_HEADER_POOL_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_TEX_HEADER_POOL_A(&val, __data); \
}

#define VA_NVA097_SET_TEX_HEADER_POOL_A V_NVA097_SET_TEX_HEADER_POOL_A

#define P_NVA097_SET_TEX_HEADER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_HEADER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_HEADER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_HEADER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_TEX_HEADER_POOL_B(uint32_t *val_out, struct nv_nva097_SET_TEX_HEADER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_TEX_HEADER_POOL_B(val, args...) { \
    struct nv_nva097_SET_TEX_HEADER_POOL_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_TEX_HEADER_POOL_B(&val, __data); \
}

#define VA_NVA097_SET_TEX_HEADER_POOL_B V_NVA097_SET_TEX_HEADER_POOL_B

#define P_NVA097_SET_TEX_HEADER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_HEADER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_HEADER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TEX_HEADER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NVA097_SET_TEX_HEADER_POOL_C(uint32_t *val_out, struct nv_nva097_SET_TEX_HEADER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 22));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NVA097_SET_TEX_HEADER_POOL_C(val, args...) { \
    struct nv_nva097_SET_TEX_HEADER_POOL_C __data = { .maximum_index = (args) }; \
    __NVA097_SET_TEX_HEADER_POOL_C(&val, __data); \
}

#define VA_NVA097_SET_TEX_HEADER_POOL_C V_NVA097_SET_TEX_HEADER_POOL_C

#define P_NVA097_SET_TEX_HEADER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TEX_HEADER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TEX_HEADER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ACTIVE_ZCULL_REGION {
    uint32_t id;
};

static inline void
__NVA097_SET_ACTIVE_ZCULL_REGION(uint32_t *val_out, struct nv_nva097_SET_ACTIVE_ZCULL_REGION st)
{
    uint32_t val = 0;
    
    assert(st.id < (1ULL << 6));
    val |= st.id << 0;
    *val_out = val;
}

#define V_NVA097_SET_ACTIVE_ZCULL_REGION(val, args...) { \
    struct nv_nva097_SET_ACTIVE_ZCULL_REGION __data = { .id = (args) }; \
    __NVA097_SET_ACTIVE_ZCULL_REGION(&val, __data); \
}

#define VA_NVA097_SET_ACTIVE_ZCULL_REGION V_NVA097_SET_ACTIVE_ZCULL_REGION

#define P_NVA097_SET_ACTIVE_ZCULL_REGION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ACTIVE_ZCULL_REGION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ACTIVE_ZCULL_REGION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TWO_SIDED_STENCIL_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_TWO_SIDED_STENCIL_TEST(uint32_t *val_out, struct nv_nva097_SET_TWO_SIDED_STENCIL_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_TWO_SIDED_STENCIL_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_TWO_SIDED_STENCIL_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_TWO_SIDED_STENCIL_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_TWO_SIDED_STENCIL_TEST __data = { .enable = (args) }; \
    __NVA097_SET_TWO_SIDED_STENCIL_TEST(&val, __data); \
}

#define VA_NVA097_SET_TWO_SIDED_STENCIL_TEST V_NVA097_SET_TWO_SIDED_STENCIL_TEST

#define P_NVA097_SET_TWO_SIDED_STENCIL_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_TWO_SIDED_STENCIL_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_TWO_SIDED_STENCIL_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TWO_SIDED_STENCIL_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TWO_SIDED_STENCIL_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_OP_FAIL {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_OP_FAIL(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_OP_FAIL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_OP_FAIL(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECR; \
    struct nv_nva097_SET_BACK_STENCIL_OP_FAIL __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_OP_FAIL(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_OP_FAIL V_NVA097_SET_BACK_STENCIL_OP_FAIL

#define P_NVA097_SET_BACK_STENCIL_OP_FAIL(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_FAIL_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_OP_FAIL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_OP_FAIL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_OP_ZFAIL {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_OP_ZFAIL(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_OP_ZFAIL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_OP_ZFAIL(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECR; \
    struct nv_nva097_SET_BACK_STENCIL_OP_ZFAIL __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_OP_ZFAIL(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_OP_ZFAIL V_NVA097_SET_BACK_STENCIL_OP_ZFAIL

#define P_NVA097_SET_BACK_STENCIL_OP_ZFAIL(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_ZFAIL_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_OP_ZFAIL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_OP_ZFAIL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_OP_ZPASS {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_OP_ZPASS(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_OP_ZPASS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_OP_ZPASS(val, args...) { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECR; \
    struct nv_nva097_SET_BACK_STENCIL_OP_ZPASS __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_OP_ZPASS(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_OP_ZPASS V_NVA097_SET_BACK_STENCIL_OP_ZPASS

#define P_NVA097_SET_BACK_STENCIL_OP_ZPASS(push, args...) do { \
    UNUSED uint32_t V_OGL_KEEP = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_KEEP; \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_REPLACE; \
    UNUSED uint32_t V_OGL_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCRSAT; \
    UNUSED uint32_t V_OGL_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECRSAT; \
    UNUSED uint32_t V_OGL_INVERT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INVERT; \
    UNUSED uint32_t V_OGL_INCR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_INCR; \
    UNUSED uint32_t V_OGL_DECR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_OGL_DECR; \
    UNUSED uint32_t V_D3D_KEEP = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_KEEP; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_REPLACE = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_REPLACE; \
    UNUSED uint32_t V_D3D_INCRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCRSAT; \
    UNUSED uint32_t V_D3D_DECRSAT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECRSAT; \
    UNUSED uint32_t V_D3D_INVERT = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INVERT; \
    UNUSED uint32_t V_D3D_INCR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_INCR; \
    UNUSED uint32_t V_D3D_DECR = NVA097_SET_BACK_STENCIL_OP_ZPASS_V_D3D_DECR; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_OP_ZPASS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_OP_ZPASS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BACK_STENCIL_FUNC {
    uint32_t v;
};

static inline void
__NVA097_SET_BACK_STENCIL_FUNC(uint32_t *val_out, struct nv_nva097_SET_BACK_STENCIL_FUNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BACK_STENCIL_FUNC(val, args...) { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_ALWAYS; \
    struct nv_nva097_SET_BACK_STENCIL_FUNC __data = { .v = (args) }; \
    __NVA097_SET_BACK_STENCIL_FUNC(&val, __data); \
}

#define VA_NVA097_SET_BACK_STENCIL_FUNC V_NVA097_SET_BACK_STENCIL_FUNC

#define P_NVA097_SET_BACK_STENCIL_FUNC(push, args...) do { \
    UNUSED uint32_t V_OGL_NEVER = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_NEVER; \
    UNUSED uint32_t V_OGL_LESS = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_LESS; \
    UNUSED uint32_t V_OGL_EQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_EQUAL; \
    UNUSED uint32_t V_OGL_LEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_LEQUAL; \
    UNUSED uint32_t V_OGL_GREATER = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_GREATER; \
    UNUSED uint32_t V_OGL_NOTEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_NOTEQUAL; \
    UNUSED uint32_t V_OGL_GEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_GEQUAL; \
    UNUSED uint32_t V_OGL_ALWAYS = NVA097_SET_BACK_STENCIL_FUNC_V_OGL_ALWAYS; \
    UNUSED uint32_t V_D3D_NEVER = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_NEVER; \
    UNUSED uint32_t V_D3D_LESS = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_LESS; \
    UNUSED uint32_t V_D3D_EQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_EQUAL; \
    UNUSED uint32_t V_D3D_LESSEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_LESSEQUAL; \
    UNUSED uint32_t V_D3D_GREATER = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_GREATER; \
    UNUSED uint32_t V_D3D_NOTEQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_NOTEQUAL; \
    UNUSED uint32_t V_D3D_GREATEREQUAL = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_GREATEREQUAL; \
    UNUSED uint32_t V_D3D_ALWAYS = NVA097_SET_BACK_STENCIL_FUNC_V_D3D_ALWAYS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BACK_STENCIL_FUNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BACK_STENCIL_FUNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SRGB_WRITE {
    uint32_t enable;
};

static inline void
__NVA097_SET_SRGB_WRITE(uint32_t *val_out, struct nv_nva097_SET_SRGB_WRITE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SRGB_WRITE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SRGB_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SRGB_WRITE_ENABLE_TRUE; \
    struct nv_nva097_SET_SRGB_WRITE __data = { .enable = (args) }; \
    __NVA097_SET_SRGB_WRITE(&val, __data); \
}

#define VA_NVA097_SET_SRGB_WRITE V_NVA097_SET_SRGB_WRITE

#define P_NVA097_SET_SRGB_WRITE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_SRGB_WRITE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_SRGB_WRITE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SRGB_WRITE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SRGB_WRITE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BIAS {
    uint32_t v;
};

static inline void
__NVA097_SET_DEPTH_BIAS(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BIAS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BIAS(val, args...) { \
    struct nv_nva097_SET_DEPTH_BIAS __data = { .v = (args) }; \
    __NVA097_SET_DEPTH_BIAS(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BIAS V_NVA097_SET_DEPTH_BIAS

#define P_NVA097_SET_DEPTH_BIAS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BIAS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BIAS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_FORMAT {
    uint32_t type;
};

static inline void
__NVA097_SET_ZCULL_REGION_FORMAT(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.type < (1ULL << 4));
    val |= st.type << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_FORMAT(val, args...) { \
    UNUSED uint32_t TYPE_Z_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4; \
    UNUSED uint32_t TYPE_ZS_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4; \
    UNUSED uint32_t TYPE_Z_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2; \
    UNUSED uint32_t TYPE_Z_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4; \
    UNUSED uint32_t TYPE_Z_16X8_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4; \
    UNUSED uint32_t TYPE_Z_8X8_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2; \
    UNUSED uint32_t TYPE_Z_8X8_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4; \
    UNUSED uint32_t TYPE_Z_16X16_4X8 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8; \
    UNUSED uint32_t TYPE_Z_4X8_2X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2; \
    UNUSED uint32_t TYPE_ZS_16X8_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2; \
    UNUSED uint32_t TYPE_ZS_16X8_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4; \
    UNUSED uint32_t TYPE_ZS_8X8_2X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2; \
    UNUSED uint32_t TYPE_Z_4X8_1X1 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1; \
    struct nv_nva097_SET_ZCULL_REGION_FORMAT __data = { .type = (args) }; \
    __NVA097_SET_ZCULL_REGION_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_FORMAT V_NVA097_SET_ZCULL_REGION_FORMAT

#define P_NVA097_SET_ZCULL_REGION_FORMAT(push, args...) do { \
    UNUSED uint32_t TYPE_Z_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X4; \
    UNUSED uint32_t TYPE_ZS_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_4X4; \
    UNUSED uint32_t TYPE_Z_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X2; \
    UNUSED uint32_t TYPE_Z_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_2X4; \
    UNUSED uint32_t TYPE_Z_16X8_4X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X8_4X4; \
    UNUSED uint32_t TYPE_Z_8X8_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_4X2; \
    UNUSED uint32_t TYPE_Z_8X8_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_8X8_2X4; \
    UNUSED uint32_t TYPE_Z_16X16_4X8 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_16X16_4X8; \
    UNUSED uint32_t TYPE_Z_4X8_2X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_2X2; \
    UNUSED uint32_t TYPE_ZS_16X8_4X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_4X2; \
    UNUSED uint32_t TYPE_ZS_16X8_2X4 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_16X8_2X4; \
    UNUSED uint32_t TYPE_ZS_8X8_2X2 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_ZS_8X8_2X2; \
    UNUSED uint32_t TYPE_Z_4X8_1X1 = NVA097_SET_ZCULL_REGION_FORMAT_TYPE_Z_4X8_1X1; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_FORMAT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RT_LAYER {
    uint32_t v;
    uint32_t control;
};

static inline void
__NVA097_SET_RT_LAYER(uint32_t *val_out, struct nv_nva097_SET_RT_LAYER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    
    assert(st.control < (1ULL << 1));
    val |= st.control << 16;
    *val_out = val;
}

#define V_NVA097_SET_RT_LAYER(val, args...) { \
    UNUSED uint32_t CONTROL_V_SELECTS_LAYER = NVA097_SET_RT_LAYER_CONTROL_V_SELECTS_LAYER; \
    UNUSED uint32_t CONTROL_GEOMETRY_SHADER_SELECTS_LAYER = NVA097_SET_RT_LAYER_CONTROL_GEOMETRY_SHADER_SELECTS_LAYER; \
    struct nv_nva097_SET_RT_LAYER __data = args; \
    __NVA097_SET_RT_LAYER(&val, __data); \
}

#define VA_NVA097_SET_RT_LAYER V_NVA097_SET_RT_LAYER

#define P_NVA097_SET_RT_LAYER(push, args...) do { \
    UNUSED uint32_t CONTROL_V_SELECTS_LAYER = NVA097_SET_RT_LAYER_CONTROL_V_SELECTS_LAYER; \
    UNUSED uint32_t CONTROL_GEOMETRY_SHADER_SELECTS_LAYER = NVA097_SET_RT_LAYER_CONTROL_GEOMETRY_SHADER_SELECTS_LAYER; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RT_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RT_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ANTI_ALIAS {
    uint32_t samples;
};

static inline void
__NVA097_SET_ANTI_ALIAS(uint32_t *val_out, struct nv_nva097_SET_ANTI_ALIAS st)
{
    uint32_t val = 0;
    
    assert(st.samples < (1ULL << 4));
    val |= st.samples << 0;
    *val_out = val;
}

#define V_NVA097_SET_ANTI_ALIAS(val, args...) { \
    UNUSED uint32_t SAMPLES_MODE_1X1 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_1X1; \
    UNUSED uint32_t SAMPLES_MODE_2X1 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X1; \
    UNUSED uint32_t SAMPLES_MODE_2X2 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2; \
    UNUSED uint32_t SAMPLES_MODE_4X2 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2; \
    UNUSED uint32_t SAMPLES_MODE_4X2_D3D = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_D3D; \
    UNUSED uint32_t SAMPLES_MODE_2X1_D3D = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X1_D3D; \
    UNUSED uint32_t SAMPLES_MODE_4X4 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X4; \
    UNUSED uint32_t SAMPLES_MODE_2X2_VC_4 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_4; \
    UNUSED uint32_t SAMPLES_MODE_2X2_VC_12 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_12; \
    UNUSED uint32_t SAMPLES_MODE_4X2_VC_8 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_8; \
    UNUSED uint32_t SAMPLES_MODE_4X2_VC_24 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_24; \
    struct nv_nva097_SET_ANTI_ALIAS __data = { .samples = (args) }; \
    __NVA097_SET_ANTI_ALIAS(&val, __data); \
}

#define VA_NVA097_SET_ANTI_ALIAS V_NVA097_SET_ANTI_ALIAS

#define P_NVA097_SET_ANTI_ALIAS(push, args...) do { \
    UNUSED uint32_t SAMPLES_MODE_1X1 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_1X1; \
    UNUSED uint32_t SAMPLES_MODE_2X1 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X1; \
    UNUSED uint32_t SAMPLES_MODE_2X2 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2; \
    UNUSED uint32_t SAMPLES_MODE_4X2 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2; \
    UNUSED uint32_t SAMPLES_MODE_4X2_D3D = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_D3D; \
    UNUSED uint32_t SAMPLES_MODE_2X1_D3D = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X1_D3D; \
    UNUSED uint32_t SAMPLES_MODE_4X4 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X4; \
    UNUSED uint32_t SAMPLES_MODE_2X2_VC_4 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_4; \
    UNUSED uint32_t SAMPLES_MODE_2X2_VC_12 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_2X2_VC_12; \
    UNUSED uint32_t SAMPLES_MODE_4X2_VC_8 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_8; \
    UNUSED uint32_t SAMPLES_MODE_4X2_VC_24 = NVA097_SET_ANTI_ALIAS_SAMPLES_MODE_4X2_VC_24; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ANTI_ALIAS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ANTI_ALIAS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_EDGE_FLAG {
    uint32_t v;
};

static inline void
__NVA097_SET_EDGE_FLAG(uint32_t *val_out, struct nv_nva097_SET_EDGE_FLAG st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_EDGE_FLAG(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_EDGE_FLAG_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_EDGE_FLAG_V_TRUE; \
    struct nv_nva097_SET_EDGE_FLAG __data = { .v = (args) }; \
    __NVA097_SET_EDGE_FLAG(&val, __data); \
}

#define VA_NVA097_SET_EDGE_FLAG V_NVA097_SET_EDGE_FLAG

#define P_NVA097_SET_EDGE_FLAG(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_EDGE_FLAG_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_EDGE_FLAG_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_EDGE_FLAG(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_EDGE_FLAG, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INLINE_INDEX {
    uint32_t v;
};

static inline void
__NVA097_DRAW_INLINE_INDEX(uint32_t *val_out, struct nv_nva097_DRAW_INLINE_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_DRAW_INLINE_INDEX(val, args...) { \
    struct nv_nva097_DRAW_INLINE_INDEX __data = { .v = (args) }; \
    __NVA097_DRAW_INLINE_INDEX(&val, __data); \
}

#define VA_NVA097_DRAW_INLINE_INDEX V_NVA097_DRAW_INLINE_INDEX

#define P_NVA097_DRAW_INLINE_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INLINE_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INLINE_INDEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INLINE_INDEX2X16_ALIGN {
    uint32_t count;
    uint32_t start_odd;
};

static inline void
__NVA097_SET_INLINE_INDEX2X16_ALIGN(uint32_t *val_out, struct nv_nva097_SET_INLINE_INDEX2X16_ALIGN st)
{
    uint32_t val = 0;
    
    assert(st.count < (1ULL << 31));
    val |= st.count << 0;
    
    assert(st.start_odd < (1ULL << 1));
    val |= st.start_odd << 31;
    *val_out = val;
}

#define V_NVA097_SET_INLINE_INDEX2X16_ALIGN(val, args...) { \
    UNUSED uint32_t START_ODD_FALSE = NVA097_SET_INLINE_INDEX2X16_ALIGN_START_ODD_FALSE; \
    UNUSED uint32_t START_ODD_TRUE = NVA097_SET_INLINE_INDEX2X16_ALIGN_START_ODD_TRUE; \
    struct nv_nva097_SET_INLINE_INDEX2X16_ALIGN __data = args; \
    __NVA097_SET_INLINE_INDEX2X16_ALIGN(&val, __data); \
}

#define VA_NVA097_SET_INLINE_INDEX2X16_ALIGN V_NVA097_SET_INLINE_INDEX2X16_ALIGN

#define P_NVA097_SET_INLINE_INDEX2X16_ALIGN(push, args...) do { \
    UNUSED uint32_t START_ODD_FALSE = NVA097_SET_INLINE_INDEX2X16_ALIGN_START_ODD_FALSE; \
    UNUSED uint32_t START_ODD_TRUE = NVA097_SET_INLINE_INDEX2X16_ALIGN_START_ODD_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INLINE_INDEX2X16_ALIGN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INLINE_INDEX2X16_ALIGN, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INLINE_INDEX2X16 {
    uint32_t even;
    uint32_t odd;
};

static inline void
__NVA097_DRAW_INLINE_INDEX2X16(uint32_t *val_out, struct nv_nva097_DRAW_INLINE_INDEX2X16 st)
{
    uint32_t val = 0;
    
    assert(st.even < (1ULL << 16));
    val |= st.even << 0;
    
    assert(st.odd < (1ULL << 16));
    val |= st.odd << 16;
    *val_out = val;
}

#define V_NVA097_DRAW_INLINE_INDEX2X16(val, args...) { \
    struct nv_nva097_DRAW_INLINE_INDEX2X16 __data = args; \
    __NVA097_DRAW_INLINE_INDEX2X16(&val, __data); \
}

#define VA_NVA097_DRAW_INLINE_INDEX2X16 V_NVA097_DRAW_INLINE_INDEX2X16

#define P_NVA097_DRAW_INLINE_INDEX2X16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INLINE_INDEX2X16(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INLINE_INDEX2X16, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_A {
    uint32_t upper;
};

static inline void
__NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_A __data = { .upper = (args) }; \
    __NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A

#define P_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_B {
    uint32_t lower;
};

static inline void
__NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_GLOBAL_BASE_OFFSET_B __data = { .lower = (args) }; \
    __NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B

#define P_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_GLOBAL_BASE_OFFSET_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_A {
    uint32_t width;
};

static inline void
__NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_A st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 16));
    val |= st.width << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_A __data = { .width = (args) }; \
    __NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A

#define P_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_B {
    uint32_t height;
};

static inline void
__NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B(uint32_t *val_out, struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_B st)
{
    uint32_t val = 0;
    
    assert(st.height < (1ULL << 16));
    val |= st.height << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B(val, args...) { \
    struct nv_nva097_SET_ZCULL_REGION_PIXEL_OFFSET_B __data = { .height = (args) }; \
    __NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B

#define P_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_REGION_PIXEL_OFFSET_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POINT_SPRITE_SELECT {
    uint32_t rmode;
    uint32_t origin;
    uint32_t texture0;
    uint32_t texture1;
    uint32_t texture2;
    uint32_t texture3;
    uint32_t texture4;
    uint32_t texture5;
    uint32_t texture6;
    uint32_t texture7;
    uint32_t texture8;
    uint32_t texture9;
};

static inline void
__NVA097_SET_POINT_SPRITE_SELECT(uint32_t *val_out, struct nv_nva097_SET_POINT_SPRITE_SELECT st)
{
    uint32_t val = 0;
    
    assert(st.rmode < (1ULL << 2));
    val |= st.rmode << 0;
    
    assert(st.origin < (1ULL << 1));
    val |= st.origin << 2;
    
    assert(st.texture0 < (1ULL << 1));
    val |= st.texture0 << 3;
    
    assert(st.texture1 < (1ULL << 1));
    val |= st.texture1 << 4;
    
    assert(st.texture2 < (1ULL << 1));
    val |= st.texture2 << 5;
    
    assert(st.texture3 < (1ULL << 1));
    val |= st.texture3 << 6;
    
    assert(st.texture4 < (1ULL << 1));
    val |= st.texture4 << 7;
    
    assert(st.texture5 < (1ULL << 1));
    val |= st.texture5 << 8;
    
    assert(st.texture6 < (1ULL << 1));
    val |= st.texture6 << 9;
    
    assert(st.texture7 < (1ULL << 1));
    val |= st.texture7 << 10;
    
    assert(st.texture8 < (1ULL << 1));
    val |= st.texture8 << 11;
    
    assert(st.texture9 < (1ULL << 1));
    val |= st.texture9 << 12;
    *val_out = val;
}

#define V_NVA097_SET_POINT_SPRITE_SELECT(val, args...) { \
    UNUSED uint32_t RMODE_ZERO = NVA097_SET_POINT_SPRITE_SELECT_RMODE_ZERO; \
    UNUSED uint32_t RMODE_FROM_R = NVA097_SET_POINT_SPRITE_SELECT_RMODE_FROM_R; \
    UNUSED uint32_t RMODE_FROM_S = NVA097_SET_POINT_SPRITE_SELECT_RMODE_FROM_S; \
    UNUSED uint32_t ORIGIN_BOTTOM = NVA097_SET_POINT_SPRITE_SELECT_ORIGIN_BOTTOM; \
    UNUSED uint32_t ORIGIN_TOP = NVA097_SET_POINT_SPRITE_SELECT_ORIGIN_TOP; \
    UNUSED uint32_t TEXTURE0_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE0_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE0_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE0_GENERATE; \
    UNUSED uint32_t TEXTURE1_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE1_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE1_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE1_GENERATE; \
    UNUSED uint32_t TEXTURE2_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE2_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE2_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE2_GENERATE; \
    UNUSED uint32_t TEXTURE3_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE3_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE3_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE3_GENERATE; \
    UNUSED uint32_t TEXTURE4_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE4_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE4_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE4_GENERATE; \
    UNUSED uint32_t TEXTURE5_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE5_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE5_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE5_GENERATE; \
    UNUSED uint32_t TEXTURE6_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE6_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE6_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE6_GENERATE; \
    UNUSED uint32_t TEXTURE7_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE7_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE7_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE7_GENERATE; \
    UNUSED uint32_t TEXTURE8_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE8_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE8_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE8_GENERATE; \
    UNUSED uint32_t TEXTURE9_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE9_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE9_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE9_GENERATE; \
    struct nv_nva097_SET_POINT_SPRITE_SELECT __data = args; \
    __NVA097_SET_POINT_SPRITE_SELECT(&val, __data); \
}

#define VA_NVA097_SET_POINT_SPRITE_SELECT V_NVA097_SET_POINT_SPRITE_SELECT

#define P_NVA097_SET_POINT_SPRITE_SELECT(push, args...) do { \
    UNUSED uint32_t RMODE_ZERO = NVA097_SET_POINT_SPRITE_SELECT_RMODE_ZERO; \
    UNUSED uint32_t RMODE_FROM_R = NVA097_SET_POINT_SPRITE_SELECT_RMODE_FROM_R; \
    UNUSED uint32_t RMODE_FROM_S = NVA097_SET_POINT_SPRITE_SELECT_RMODE_FROM_S; \
    UNUSED uint32_t ORIGIN_BOTTOM = NVA097_SET_POINT_SPRITE_SELECT_ORIGIN_BOTTOM; \
    UNUSED uint32_t ORIGIN_TOP = NVA097_SET_POINT_SPRITE_SELECT_ORIGIN_TOP; \
    UNUSED uint32_t TEXTURE0_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE0_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE0_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE0_GENERATE; \
    UNUSED uint32_t TEXTURE1_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE1_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE1_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE1_GENERATE; \
    UNUSED uint32_t TEXTURE2_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE2_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE2_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE2_GENERATE; \
    UNUSED uint32_t TEXTURE3_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE3_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE3_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE3_GENERATE; \
    UNUSED uint32_t TEXTURE4_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE4_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE4_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE4_GENERATE; \
    UNUSED uint32_t TEXTURE5_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE5_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE5_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE5_GENERATE; \
    UNUSED uint32_t TEXTURE6_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE6_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE6_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE6_GENERATE; \
    UNUSED uint32_t TEXTURE7_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE7_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE7_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE7_GENERATE; \
    UNUSED uint32_t TEXTURE8_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE8_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE8_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE8_GENERATE; \
    UNUSED uint32_t TEXTURE9_PASSTHROUGH = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE9_PASSTHROUGH; \
    UNUSED uint32_t TEXTURE9_GENERATE = NVA097_SET_POINT_SPRITE_SELECT_TEXTURE9_GENERATE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POINT_SPRITE_SELECT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POINT_SPRITE_SELECT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PROGRAM_REGION_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_PROGRAM_REGION_A(uint32_t *val_out, struct nv_nva097_SET_PROGRAM_REGION_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_PROGRAM_REGION_A(val, args...) { \
    struct nv_nva097_SET_PROGRAM_REGION_A __data = { .address_upper = (args) }; \
    __NVA097_SET_PROGRAM_REGION_A(&val, __data); \
}

#define VA_NVA097_SET_PROGRAM_REGION_A V_NVA097_SET_PROGRAM_REGION_A

#define P_NVA097_SET_PROGRAM_REGION_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PROGRAM_REGION_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PROGRAM_REGION_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PROGRAM_REGION_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_PROGRAM_REGION_B(uint32_t *val_out, struct nv_nva097_SET_PROGRAM_REGION_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_PROGRAM_REGION_B(val, args...) { \
    struct nv_nva097_SET_PROGRAM_REGION_B __data = { .address_lower = (args) }; \
    __NVA097_SET_PROGRAM_REGION_B(&val, __data); \
}

#define VA_NVA097_SET_PROGRAM_REGION_B V_NVA097_SET_PROGRAM_REGION_B

#define P_NVA097_SET_PROGRAM_REGION_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PROGRAM_REGION_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PROGRAM_REGION_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ATTRIBUTE_DEFAULT {
    uint32_t color_front_diffuse;
    uint32_t color_front_specular;
    uint32_t generic_vector;
    uint32_t fixed_fnc_texture;
    uint32_t dx9_color0;
    uint32_t dx9_color1_to_color15;
};

static inline void
__NVA097_SET_ATTRIBUTE_DEFAULT(uint32_t *val_out, struct nv_nva097_SET_ATTRIBUTE_DEFAULT st)
{
    uint32_t val = 0;
    
    assert(st.color_front_diffuse < (1ULL << 1));
    val |= st.color_front_diffuse << 0;
    
    assert(st.color_front_specular < (1ULL << 1));
    val |= st.color_front_specular << 1;
    
    assert(st.generic_vector < (1ULL << 1));
    val |= st.generic_vector << 2;
    
    assert(st.fixed_fnc_texture < (1ULL << 1));
    val |= st.fixed_fnc_texture << 3;
    
    assert(st.dx9_color0 < (1ULL << 1));
    val |= st.dx9_color0 << 4;
    
    assert(st.dx9_color1_to_color15 < (1ULL << 1));
    val |= st.dx9_color1_to_color15 << 5;
    *val_out = val;
}

#define V_NVA097_SET_ATTRIBUTE_DEFAULT(val, args...) { \
    UNUSED uint32_t COLOR_FRONT_DIFFUSE_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_0001; \
    UNUSED uint32_t COLOR_FRONT_DIFFUSE_VECTOR_1111 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_1111; \
    UNUSED uint32_t COLOR_FRONT_SPECULAR_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0000; \
    UNUSED uint32_t COLOR_FRONT_SPECULAR_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0001; \
    UNUSED uint32_t GENERIC_VECTOR_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0000; \
    UNUSED uint32_t GENERIC_VECTOR_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0001; \
    UNUSED uint32_t FIXED_FNC_TEXTURE_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0000; \
    UNUSED uint32_t FIXED_FNC_TEXTURE_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0001; \
    UNUSED uint32_t DX9_COLOR0_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_0001; \
    UNUSED uint32_t DX9_COLOR0_VECTOR_1111 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_1111; \
    UNUSED uint32_t DX9_COLOR1_TO_COLOR15_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0000; \
    UNUSED uint32_t DX9_COLOR1_TO_COLOR15_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0001; \
    struct nv_nva097_SET_ATTRIBUTE_DEFAULT __data = args; \
    __NVA097_SET_ATTRIBUTE_DEFAULT(&val, __data); \
}

#define VA_NVA097_SET_ATTRIBUTE_DEFAULT V_NVA097_SET_ATTRIBUTE_DEFAULT

#define P_NVA097_SET_ATTRIBUTE_DEFAULT(push, args...) do { \
    UNUSED uint32_t COLOR_FRONT_DIFFUSE_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_0001; \
    UNUSED uint32_t COLOR_FRONT_DIFFUSE_VECTOR_1111 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_DIFFUSE_VECTOR_1111; \
    UNUSED uint32_t COLOR_FRONT_SPECULAR_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0000; \
    UNUSED uint32_t COLOR_FRONT_SPECULAR_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_COLOR_FRONT_SPECULAR_VECTOR_0001; \
    UNUSED uint32_t GENERIC_VECTOR_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0000; \
    UNUSED uint32_t GENERIC_VECTOR_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_GENERIC_VECTOR_VECTOR_0001; \
    UNUSED uint32_t FIXED_FNC_TEXTURE_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0000; \
    UNUSED uint32_t FIXED_FNC_TEXTURE_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_FIXED_FNC_TEXTURE_VECTOR_0001; \
    UNUSED uint32_t DX9_COLOR0_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_0001; \
    UNUSED uint32_t DX9_COLOR0_VECTOR_1111 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR0_VECTOR_1111; \
    UNUSED uint32_t DX9_COLOR1_TO_COLOR15_VECTOR_0000 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0000; \
    UNUSED uint32_t DX9_COLOR1_TO_COLOR15_VECTOR_0001 = NVA097_SET_ATTRIBUTE_DEFAULT_DX9_COLOR1_TO_COLOR15_VECTOR_0001; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ATTRIBUTE_DEFAULT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ATTRIBUTE_DEFAULT, nvk_p_ret); \
} while(0)

struct nv_nva097_END {
    uint32_t v;
};

static inline void
__NVA097_END(uint32_t *val_out, struct nv_nva097_END st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_END(val, args...) { \
    struct nv_nva097_END __data = { .v = (args) }; \
    __NVA097_END(&val, __data); \
}

#define VA_NVA097_END V_NVA097_END

#define P_NVA097_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_END(nvk_p_ret, args); \
    nv_push_val(push, NVA097_END, nvk_p_ret); \
} while(0)

struct nv_nva097_BEGIN {
    uint32_t op;
    uint32_t primitive_id;
    uint32_t instance_id;
    uint32_t split_mode;
};

static inline void
__NVA097_BEGIN(uint32_t *val_out, struct nv_nva097_BEGIN st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 16));
    val |= st.op << 0;
    
    assert(st.primitive_id < (1ULL << 1));
    val |= st.primitive_id << 24;
    
    assert(st.instance_id < (1ULL << 2));
    val |= st.instance_id << 26;
    
    assert(st.split_mode < (1ULL << 2));
    val |= st.split_mode << 29;
    *val_out = val;
}

#define V_NVA097_BEGIN(val, args...) { \
    UNUSED uint32_t OP_POINTS = NVA097_BEGIN_OP_POINTS; \
    UNUSED uint32_t OP_LINES = NVA097_BEGIN_OP_LINES; \
    UNUSED uint32_t OP_LINE_LOOP = NVA097_BEGIN_OP_LINE_LOOP; \
    UNUSED uint32_t OP_LINE_STRIP = NVA097_BEGIN_OP_LINE_STRIP; \
    UNUSED uint32_t OP_TRIANGLES = NVA097_BEGIN_OP_TRIANGLES; \
    UNUSED uint32_t OP_TRIANGLE_STRIP = NVA097_BEGIN_OP_TRIANGLE_STRIP; \
    UNUSED uint32_t OP_TRIANGLE_FAN = NVA097_BEGIN_OP_TRIANGLE_FAN; \
    UNUSED uint32_t OP_QUADS = NVA097_BEGIN_OP_QUADS; \
    UNUSED uint32_t OP_QUAD_STRIP = NVA097_BEGIN_OP_QUAD_STRIP; \
    UNUSED uint32_t OP_POLYGON = NVA097_BEGIN_OP_POLYGON; \
    UNUSED uint32_t OP_LINELIST_ADJCY = NVA097_BEGIN_OP_LINELIST_ADJCY; \
    UNUSED uint32_t OP_LINESTRIP_ADJCY = NVA097_BEGIN_OP_LINESTRIP_ADJCY; \
    UNUSED uint32_t OP_TRIANGLELIST_ADJCY = NVA097_BEGIN_OP_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t OP_TRIANGLESTRIP_ADJCY = NVA097_BEGIN_OP_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t OP_PATCH = NVA097_BEGIN_OP_PATCH; \
    UNUSED uint32_t PRIMITIVE_ID_FIRST = NVA097_BEGIN_PRIMITIVE_ID_FIRST; \
    UNUSED uint32_t PRIMITIVE_ID_UNCHANGED = NVA097_BEGIN_PRIMITIVE_ID_UNCHANGED; \
    UNUSED uint32_t INSTANCE_ID_FIRST = NVA097_BEGIN_INSTANCE_ID_FIRST; \
    UNUSED uint32_t INSTANCE_ID_SUBSEQUENT = NVA097_BEGIN_INSTANCE_ID_SUBSEQUENT; \
    UNUSED uint32_t INSTANCE_ID_UNCHANGED = NVA097_BEGIN_INSTANCE_ID_UNCHANGED; \
    UNUSED uint32_t SPLIT_MODE_NORMAL_BEGIN_NORMAL_END = NVA097_BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END; \
    UNUSED uint32_t SPLIT_MODE_NORMAL_BEGIN_OPEN_END = NVA097_BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END; \
    UNUSED uint32_t SPLIT_MODE_OPEN_BEGIN_OPEN_END = NVA097_BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END; \
    UNUSED uint32_t SPLIT_MODE_OPEN_BEGIN_NORMAL_END = NVA097_BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END; \
    struct nv_nva097_BEGIN __data = args; \
    __NVA097_BEGIN(&val, __data); \
}

#define VA_NVA097_BEGIN V_NVA097_BEGIN

#define P_NVA097_BEGIN(push, args...) do { \
    UNUSED uint32_t OP_POINTS = NVA097_BEGIN_OP_POINTS; \
    UNUSED uint32_t OP_LINES = NVA097_BEGIN_OP_LINES; \
    UNUSED uint32_t OP_LINE_LOOP = NVA097_BEGIN_OP_LINE_LOOP; \
    UNUSED uint32_t OP_LINE_STRIP = NVA097_BEGIN_OP_LINE_STRIP; \
    UNUSED uint32_t OP_TRIANGLES = NVA097_BEGIN_OP_TRIANGLES; \
    UNUSED uint32_t OP_TRIANGLE_STRIP = NVA097_BEGIN_OP_TRIANGLE_STRIP; \
    UNUSED uint32_t OP_TRIANGLE_FAN = NVA097_BEGIN_OP_TRIANGLE_FAN; \
    UNUSED uint32_t OP_QUADS = NVA097_BEGIN_OP_QUADS; \
    UNUSED uint32_t OP_QUAD_STRIP = NVA097_BEGIN_OP_QUAD_STRIP; \
    UNUSED uint32_t OP_POLYGON = NVA097_BEGIN_OP_POLYGON; \
    UNUSED uint32_t OP_LINELIST_ADJCY = NVA097_BEGIN_OP_LINELIST_ADJCY; \
    UNUSED uint32_t OP_LINESTRIP_ADJCY = NVA097_BEGIN_OP_LINESTRIP_ADJCY; \
    UNUSED uint32_t OP_TRIANGLELIST_ADJCY = NVA097_BEGIN_OP_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t OP_TRIANGLESTRIP_ADJCY = NVA097_BEGIN_OP_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t OP_PATCH = NVA097_BEGIN_OP_PATCH; \
    UNUSED uint32_t PRIMITIVE_ID_FIRST = NVA097_BEGIN_PRIMITIVE_ID_FIRST; \
    UNUSED uint32_t PRIMITIVE_ID_UNCHANGED = NVA097_BEGIN_PRIMITIVE_ID_UNCHANGED; \
    UNUSED uint32_t INSTANCE_ID_FIRST = NVA097_BEGIN_INSTANCE_ID_FIRST; \
    UNUSED uint32_t INSTANCE_ID_SUBSEQUENT = NVA097_BEGIN_INSTANCE_ID_SUBSEQUENT; \
    UNUSED uint32_t INSTANCE_ID_UNCHANGED = NVA097_BEGIN_INSTANCE_ID_UNCHANGED; \
    UNUSED uint32_t SPLIT_MODE_NORMAL_BEGIN_NORMAL_END = NVA097_BEGIN_SPLIT_MODE_NORMAL_BEGIN_NORMAL_END; \
    UNUSED uint32_t SPLIT_MODE_NORMAL_BEGIN_OPEN_END = NVA097_BEGIN_SPLIT_MODE_NORMAL_BEGIN_OPEN_END; \
    UNUSED uint32_t SPLIT_MODE_OPEN_BEGIN_OPEN_END = NVA097_BEGIN_SPLIT_MODE_OPEN_BEGIN_OPEN_END; \
    UNUSED uint32_t SPLIT_MODE_OPEN_BEGIN_NORMAL_END = NVA097_BEGIN_SPLIT_MODE_OPEN_BEGIN_NORMAL_END; \
    uint32_t nvk_p_ret; \
    V_NVA097_BEGIN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BEGIN, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_ID_COPY {
    uint32_t enable;
    uint32_t attribute_slot;
};

static inline void
__NVA097_SET_VERTEX_ID_COPY(uint32_t *val_out, struct nv_nva097_SET_VERTEX_ID_COPY st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.attribute_slot < (1ULL << 8));
    val |= st.attribute_slot << 4;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_ID_COPY(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_ID_COPY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_ID_COPY_ENABLE_TRUE; \
    struct nv_nva097_SET_VERTEX_ID_COPY __data = args; \
    __NVA097_SET_VERTEX_ID_COPY(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_ID_COPY V_NVA097_SET_VERTEX_ID_COPY

#define P_NVA097_SET_VERTEX_ID_COPY(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_ID_COPY_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_ID_COPY_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_ID_COPY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_ID_COPY, nvk_p_ret); \
} while(0)

struct nv_nva097_ADD_TO_PRIMITIVE_ID {
    uint32_t v;
};

static inline void
__NVA097_ADD_TO_PRIMITIVE_ID(uint32_t *val_out, struct nv_nva097_ADD_TO_PRIMITIVE_ID st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_ADD_TO_PRIMITIVE_ID(val, args...) { \
    struct nv_nva097_ADD_TO_PRIMITIVE_ID __data = { .v = (args) }; \
    __NVA097_ADD_TO_PRIMITIVE_ID(&val, __data); \
}

#define VA_NVA097_ADD_TO_PRIMITIVE_ID V_NVA097_ADD_TO_PRIMITIVE_ID

#define P_NVA097_ADD_TO_PRIMITIVE_ID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_ADD_TO_PRIMITIVE_ID(nvk_p_ret, args); \
    nv_push_val(push, NVA097_ADD_TO_PRIMITIVE_ID, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_PRIMITIVE_ID {
    uint32_t v;
};

static inline void
__NVA097_LOAD_PRIMITIVE_ID(uint32_t *val_out, struct nv_nva097_LOAD_PRIMITIVE_ID st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_PRIMITIVE_ID(val, args...) { \
    struct nv_nva097_LOAD_PRIMITIVE_ID __data = { .v = (args) }; \
    __NVA097_LOAD_PRIMITIVE_ID(&val, __data); \
}

#define VA_NVA097_LOAD_PRIMITIVE_ID V_NVA097_LOAD_PRIMITIVE_ID

#define P_NVA097_LOAD_PRIMITIVE_ID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_PRIMITIVE_ID(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_PRIMITIVE_ID, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_BASED_CULL {
    uint32_t batch_cull_enable;
    uint32_t before_fetch_enable;
};

static inline void
__NVA097_SET_SHADER_BASED_CULL(uint32_t *val_out, struct nv_nva097_SET_SHADER_BASED_CULL st)
{
    uint32_t val = 0;
    
    assert(st.batch_cull_enable < (1ULL << 1));
    val |= st.batch_cull_enable << 1;
    
    assert(st.before_fetch_enable < (1ULL << 1));
    val |= st.before_fetch_enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_BASED_CULL(val, args...) { \
    UNUSED uint32_t BATCH_CULL_ENABLE_FALSE = NVA097_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_FALSE; \
    UNUSED uint32_t BATCH_CULL_ENABLE_TRUE = NVA097_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_TRUE; \
    UNUSED uint32_t BEFORE_FETCH_ENABLE_FALSE = NVA097_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_FALSE; \
    UNUSED uint32_t BEFORE_FETCH_ENABLE_TRUE = NVA097_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_TRUE; \
    struct nv_nva097_SET_SHADER_BASED_CULL __data = args; \
    __NVA097_SET_SHADER_BASED_CULL(&val, __data); \
}

#define VA_NVA097_SET_SHADER_BASED_CULL V_NVA097_SET_SHADER_BASED_CULL

#define P_NVA097_SET_SHADER_BASED_CULL(push, args...) do { \
    UNUSED uint32_t BATCH_CULL_ENABLE_FALSE = NVA097_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_FALSE; \
    UNUSED uint32_t BATCH_CULL_ENABLE_TRUE = NVA097_SET_SHADER_BASED_CULL_BATCH_CULL_ENABLE_TRUE; \
    UNUSED uint32_t BEFORE_FETCH_ENABLE_FALSE = NVA097_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_FALSE; \
    UNUSED uint32_t BEFORE_FETCH_ENABLE_TRUE = NVA097_SET_SHADER_BASED_CULL_BEFORE_FETCH_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_BASED_CULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_BASED_CULL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLASS_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_SET_CLASS_VERSION(uint32_t *val_out, struct nv_nva097_SET_CLASS_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_SET_CLASS_VERSION(val, args...) { \
    struct nv_nva097_SET_CLASS_VERSION __data = args; \
    __NVA097_SET_CLASS_VERSION(&val, __data); \
}

#define VA_NVA097_SET_CLASS_VERSION V_NVA097_SET_CLASS_VERSION

#define P_NVA097_SET_CLASS_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLASS_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLASS_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_PAGE {
    uint32_t read_select;
};

static inline void
__NVA097_SET_VAB_PAGE(uint32_t *val_out, struct nv_nva097_SET_VAB_PAGE st)
{
    uint32_t val = 0;
    
    assert(st.read_select < (1ULL << 1));
    val |= st.read_select << 0;
    *val_out = val;
}

#define V_NVA097_SET_VAB_PAGE(val, args...) { \
    UNUSED uint32_t READ_SELECT_PAGES_0_AND_1 = NVA097_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_1; \
    UNUSED uint32_t READ_SELECT_PAGES_0_AND_2 = NVA097_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_2; \
    struct nv_nva097_SET_VAB_PAGE __data = { .read_select = (args) }; \
    __NVA097_SET_VAB_PAGE(&val, __data); \
}

#define VA_NVA097_SET_VAB_PAGE V_NVA097_SET_VAB_PAGE

#define P_NVA097_SET_VAB_PAGE(push, args...) do { \
    UNUSED uint32_t READ_SELECT_PAGES_0_AND_1 = NVA097_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_1; \
    UNUSED uint32_t READ_SELECT_PAGES_0_AND_2 = NVA097_SET_VAB_PAGE_READ_SELECT_PAGES_0_AND_2; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_PAGE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_PAGE, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INLINE_VERTEX {
    uint32_t v;
};

static inline void
__NVA097_DRAW_INLINE_VERTEX(uint32_t *val_out, struct nv_nva097_DRAW_INLINE_VERTEX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_DRAW_INLINE_VERTEX(val, args...) { \
    struct nv_nva097_DRAW_INLINE_VERTEX __data = { .v = (args) }; \
    __NVA097_DRAW_INLINE_VERTEX(&val, __data); \
}

#define VA_NVA097_DRAW_INLINE_VERTEX V_NVA097_DRAW_INLINE_VERTEX

#define P_NVA097_DRAW_INLINE_VERTEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INLINE_VERTEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INLINE_VERTEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_PRIMITIVE_RESTART {
    uint32_t enable;
};

static inline void
__NVA097_SET_DA_PRIMITIVE_RESTART(uint32_t *val_out, struct nv_nva097_SET_DA_PRIMITIVE_RESTART st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DA_PRIMITIVE_RESTART(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_ENABLE_TRUE; \
    struct nv_nva097_SET_DA_PRIMITIVE_RESTART __data = { .enable = (args) }; \
    __NVA097_SET_DA_PRIMITIVE_RESTART(&val, __data); \
}

#define VA_NVA097_SET_DA_PRIMITIVE_RESTART V_NVA097_SET_DA_PRIMITIVE_RESTART

#define P_NVA097_SET_DA_PRIMITIVE_RESTART(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DA_PRIMITIVE_RESTART_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DA_PRIMITIVE_RESTART_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_PRIMITIVE_RESTART(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_PRIMITIVE_RESTART, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX {
    uint32_t v;
};

static inline void
__NVA097_SET_DA_PRIMITIVE_RESTART_INDEX(uint32_t *val_out, struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX(val, args...) { \
    struct nv_nva097_SET_DA_PRIMITIVE_RESTART_INDEX __data = { .v = (args) }; \
    __NVA097_SET_DA_PRIMITIVE_RESTART_INDEX(&val, __data); \
}

#define VA_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX

#define P_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_PRIMITIVE_RESTART_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_PRIMITIVE_RESTART_INDEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DA_OUTPUT {
    uint32_t vertex_id_uses_array_start;
};

static inline void
__NVA097_SET_DA_OUTPUT(uint32_t *val_out, struct nv_nva097_SET_DA_OUTPUT st)
{
    uint32_t val = 0;
    
    assert(st.vertex_id_uses_array_start < (1ULL << 1));
    val |= st.vertex_id_uses_array_start << 12;
    *val_out = val;
}

#define V_NVA097_SET_DA_OUTPUT(val, args...) { \
    UNUSED uint32_t VERTEX_ID_USES_ARRAY_START_FALSE = NVA097_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_FALSE; \
    UNUSED uint32_t VERTEX_ID_USES_ARRAY_START_TRUE = NVA097_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_TRUE; \
    struct nv_nva097_SET_DA_OUTPUT __data = { .vertex_id_uses_array_start = (args) }; \
    __NVA097_SET_DA_OUTPUT(&val, __data); \
}

#define VA_NVA097_SET_DA_OUTPUT V_NVA097_SET_DA_OUTPUT

#define P_NVA097_SET_DA_OUTPUT(push, args...) do { \
    UNUSED uint32_t VERTEX_ID_USES_ARRAY_START_FALSE = NVA097_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_FALSE; \
    UNUSED uint32_t VERTEX_ID_USES_ARRAY_START_TRUE = NVA097_SET_DA_OUTPUT_VERTEX_ID_USES_ARRAY_START_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DA_OUTPUT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DA_OUTPUT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ANTI_ALIASED_POINT {
    uint32_t enable;
};

static inline void
__NVA097_SET_ANTI_ALIASED_POINT(uint32_t *val_out, struct nv_nva097_SET_ANTI_ALIASED_POINT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_ANTI_ALIASED_POINT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ANTI_ALIASED_POINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ANTI_ALIASED_POINT_ENABLE_TRUE; \
    struct nv_nva097_SET_ANTI_ALIASED_POINT __data = { .enable = (args) }; \
    __NVA097_SET_ANTI_ALIASED_POINT(&val, __data); \
}

#define VA_NVA097_SET_ANTI_ALIASED_POINT V_NVA097_SET_ANTI_ALIASED_POINT

#define P_NVA097_SET_ANTI_ALIASED_POINT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ANTI_ALIASED_POINT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ANTI_ALIASED_POINT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ANTI_ALIASED_POINT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ANTI_ALIASED_POINT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POINT_CENTER_MODE {
    uint32_t v;
};

static inline void
__NVA097_SET_POINT_CENTER_MODE(uint32_t *val_out, struct nv_nva097_SET_POINT_CENTER_MODE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_POINT_CENTER_MODE(val, args...) { \
    UNUSED uint32_t V_OGL = NVA097_SET_POINT_CENTER_MODE_V_OGL; \
    UNUSED uint32_t V_D3D = NVA097_SET_POINT_CENTER_MODE_V_D3D; \
    struct nv_nva097_SET_POINT_CENTER_MODE __data = { .v = (args) }; \
    __NVA097_SET_POINT_CENTER_MODE(&val, __data); \
}

#define VA_NVA097_SET_POINT_CENTER_MODE V_NVA097_SET_POINT_CENTER_MODE

#define P_NVA097_SET_POINT_CENTER_MODE(push, args...) do { \
    UNUSED uint32_t V_OGL = NVA097_SET_POINT_CENTER_MODE_V_OGL; \
    UNUSED uint32_t V_D3D = NVA097_SET_POINT_CENTER_MODE_V_D3D; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POINT_CENTER_MODE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POINT_CENTER_MODE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_SMOOTH_PARAMETERS {
    uint32_t falloff;
};

static inline void
__NVA097_SET_LINE_SMOOTH_PARAMETERS(uint32_t *val_out, struct nv_nva097_SET_LINE_SMOOTH_PARAMETERS st)
{
    uint32_t val = 0;
    
    val |= st.falloff;
    *val_out = val;
}

#define V_NVA097_SET_LINE_SMOOTH_PARAMETERS(val, args...) { \
    UNUSED uint32_t FALLOFF__1_00 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_00; \
    UNUSED uint32_t FALLOFF__1_33 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_33; \
    UNUSED uint32_t FALLOFF__1_60 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_60; \
    struct nv_nva097_SET_LINE_SMOOTH_PARAMETERS __data = { .falloff = (args) }; \
    __NVA097_SET_LINE_SMOOTH_PARAMETERS(&val, __data); \
}

#define VA_NVA097_SET_LINE_SMOOTH_PARAMETERS V_NVA097_SET_LINE_SMOOTH_PARAMETERS

#define P_NVA097_SET_LINE_SMOOTH_PARAMETERS(push, args...) do { \
    UNUSED uint32_t FALLOFF__1_00 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_00; \
    UNUSED uint32_t FALLOFF__1_33 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_33; \
    UNUSED uint32_t FALLOFF__1_60 = NVA097_SET_LINE_SMOOTH_PARAMETERS_FALLOFF__1_60; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_SMOOTH_PARAMETERS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_SMOOTH_PARAMETERS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_STIPPLE {
    uint32_t enable;
};

static inline void
__NVA097_SET_LINE_STIPPLE(uint32_t *val_out, struct nv_nva097_SET_LINE_STIPPLE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_LINE_STIPPLE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LINE_STIPPLE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LINE_STIPPLE_ENABLE_TRUE; \
    struct nv_nva097_SET_LINE_STIPPLE __data = { .enable = (args) }; \
    __NVA097_SET_LINE_STIPPLE(&val, __data); \
}

#define VA_NVA097_SET_LINE_STIPPLE V_NVA097_SET_LINE_STIPPLE

#define P_NVA097_SET_LINE_STIPPLE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LINE_STIPPLE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LINE_STIPPLE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_STIPPLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_STIPPLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_SMOOTH_EDGE_TABLE {
    uint32_t v0;
    uint32_t v1;
    uint32_t v2;
    uint32_t v3;
};

static inline void
__NVA097_SET_LINE_SMOOTH_EDGE_TABLE(uint32_t *val_out, struct nv_nva097_SET_LINE_SMOOTH_EDGE_TABLE st)
{
    uint32_t val = 0;
    
    assert(st.v0 < (1ULL << 8));
    val |= st.v0 << 0;
    
    assert(st.v1 < (1ULL << 8));
    val |= st.v1 << 8;
    
    assert(st.v2 < (1ULL << 8));
    val |= st.v2 << 16;
    
    assert(st.v3 < (1ULL << 8));
    val |= st.v3 << 24;
    *val_out = val;
}

#define V_NVA097_SET_LINE_SMOOTH_EDGE_TABLE(val, args...) { \
    struct nv_nva097_SET_LINE_SMOOTH_EDGE_TABLE __data = args; \
    __NVA097_SET_LINE_SMOOTH_EDGE_TABLE(&val, __data); \
}

#define VA_NVA097_SET_LINE_SMOOTH_EDGE_TABLE(i) V_NVA097_SET_LINE_SMOOTH_EDGE_TABLE

#define P_NVA097_SET_LINE_SMOOTH_EDGE_TABLE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_SMOOTH_EDGE_TABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_SMOOTH_EDGE_TABLE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LINE_STIPPLE_PARAMETERS {
    uint32_t factor;
    uint32_t pattern;
};

static inline void
__NVA097_SET_LINE_STIPPLE_PARAMETERS(uint32_t *val_out, struct nv_nva097_SET_LINE_STIPPLE_PARAMETERS st)
{
    uint32_t val = 0;
    
    assert(st.factor < (1ULL << 8));
    val |= st.factor << 0;
    
    assert(st.pattern < (1ULL << 16));
    val |= st.pattern << 8;
    *val_out = val;
}

#define V_NVA097_SET_LINE_STIPPLE_PARAMETERS(val, args...) { \
    struct nv_nva097_SET_LINE_STIPPLE_PARAMETERS __data = args; \
    __NVA097_SET_LINE_STIPPLE_PARAMETERS(&val, __data); \
}

#define VA_NVA097_SET_LINE_STIPPLE_PARAMETERS V_NVA097_SET_LINE_STIPPLE_PARAMETERS

#define P_NVA097_SET_LINE_STIPPLE_PARAMETERS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LINE_STIPPLE_PARAMETERS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LINE_STIPPLE_PARAMETERS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PROVOKING_VERTEX {
    uint32_t v;
};

static inline void
__NVA097_SET_PROVOKING_VERTEX(uint32_t *val_out, struct nv_nva097_SET_PROVOKING_VERTEX st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PROVOKING_VERTEX(val, args...) { \
    UNUSED uint32_t V_FIRST = NVA097_SET_PROVOKING_VERTEX_V_FIRST; \
    UNUSED uint32_t V_LAST = NVA097_SET_PROVOKING_VERTEX_V_LAST; \
    struct nv_nva097_SET_PROVOKING_VERTEX __data = { .v = (args) }; \
    __NVA097_SET_PROVOKING_VERTEX(&val, __data); \
}

#define VA_NVA097_SET_PROVOKING_VERTEX V_NVA097_SET_PROVOKING_VERTEX

#define P_NVA097_SET_PROVOKING_VERTEX(push, args...) do { \
    UNUSED uint32_t V_FIRST = NVA097_SET_PROVOKING_VERTEX_V_FIRST; \
    UNUSED uint32_t V_LAST = NVA097_SET_PROVOKING_VERTEX_V_LAST; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PROVOKING_VERTEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PROVOKING_VERTEX, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TWO_SIDED_LIGHT {
    uint32_t enable;
};

static inline void
__NVA097_SET_TWO_SIDED_LIGHT(uint32_t *val_out, struct nv_nva097_SET_TWO_SIDED_LIGHT st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_TWO_SIDED_LIGHT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_TWO_SIDED_LIGHT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_TWO_SIDED_LIGHT_ENABLE_TRUE; \
    struct nv_nva097_SET_TWO_SIDED_LIGHT __data = { .enable = (args) }; \
    __NVA097_SET_TWO_SIDED_LIGHT(&val, __data); \
}

#define VA_NVA097_SET_TWO_SIDED_LIGHT V_NVA097_SET_TWO_SIDED_LIGHT

#define P_NVA097_SET_TWO_SIDED_LIGHT(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_TWO_SIDED_LIGHT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_TWO_SIDED_LIGHT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TWO_SIDED_LIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TWO_SIDED_LIGHT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLYGON_STIPPLE {
    uint32_t enable;
};

static inline void
__NVA097_SET_POLYGON_STIPPLE(uint32_t *val_out, struct nv_nva097_SET_POLYGON_STIPPLE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_POLYGON_STIPPLE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLYGON_STIPPLE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLYGON_STIPPLE_ENABLE_TRUE; \
    struct nv_nva097_SET_POLYGON_STIPPLE __data = { .enable = (args) }; \
    __NVA097_SET_POLYGON_STIPPLE(&val, __data); \
}

#define VA_NVA097_SET_POLYGON_STIPPLE V_NVA097_SET_POLYGON_STIPPLE

#define P_NVA097_SET_POLYGON_STIPPLE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_POLYGON_STIPPLE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_POLYGON_STIPPLE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLYGON_STIPPLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLYGON_STIPPLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_CONTROL {
    uint32_t default_partial;
    uint32_t fp32_nan_behavior;
    uint32_t fp32_f2i_nan_behavior;
};

static inline void
__NVA097_SET_SHADER_CONTROL(uint32_t *val_out, struct nv_nva097_SET_SHADER_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.default_partial < (1ULL << 1));
    val |= st.default_partial << 0;
    
    assert(st.fp32_nan_behavior < (1ULL << 1));
    val |= st.fp32_nan_behavior << 1;
    
    assert(st.fp32_f2i_nan_behavior < (1ULL << 1));
    val |= st.fp32_f2i_nan_behavior << 2;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_CONTROL(val, args...) { \
    UNUSED uint32_t DEFAULT_PARTIAL_ZERO = NVA097_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO; \
    UNUSED uint32_t DEFAULT_PARTIAL_INFINITY = NVA097_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_LEGACY = NVA097_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_FP64_COMPATIBLE = NVA097_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_ZERO = NVA097_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE = NVA097_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE; \
    struct nv_nva097_SET_SHADER_CONTROL __data = args; \
    __NVA097_SET_SHADER_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_SHADER_CONTROL V_NVA097_SET_SHADER_CONTROL

#define P_NVA097_SET_SHADER_CONTROL(push, args...) do { \
    UNUSED uint32_t DEFAULT_PARTIAL_ZERO = NVA097_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO; \
    UNUSED uint32_t DEFAULT_PARTIAL_INFINITY = NVA097_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_LEGACY = NVA097_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY; \
    UNUSED uint32_t FP32_NAN_BEHAVIOR_FP64_COMPATIBLE = NVA097_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_ZERO = NVA097_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO; \
    UNUSED uint32_t FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE = NVA097_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_LAUNCH_VERTEX {
    uint32_t v;
};

static inline void
__NVA097_LAUNCH_VERTEX(uint32_t *val_out, struct nv_nva097_LAUNCH_VERTEX st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_LAUNCH_VERTEX(val, args...) { \
    struct nv_nva097_LAUNCH_VERTEX __data = { .v = (args) }; \
    __NVA097_LAUNCH_VERTEX(&val, __data); \
}

#define VA_NVA097_LAUNCH_VERTEX V_NVA097_LAUNCH_VERTEX

#define P_NVA097_LAUNCH_VERTEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LAUNCH_VERTEX(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LAUNCH_VERTEX, nvk_p_ret); \
} while(0)

struct nv_nva097_CHECK_CLASS_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_CHECK_CLASS_VERSION(uint32_t *val_out, struct nv_nva097_CHECK_CLASS_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_CHECK_CLASS_VERSION(val, args...) { \
    struct nv_nva097_CHECK_CLASS_VERSION __data = args; \
    __NVA097_CHECK_CLASS_VERSION(&val, __data); \
}

#define VA_NVA097_CHECK_CLASS_VERSION V_NVA097_CHECK_CLASS_VERSION

#define P_NVA097_CHECK_CLASS_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CHECK_CLASS_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CHECK_CLASS_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPH_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_SET_SPH_VERSION(uint32_t *val_out, struct nv_nva097_SET_SPH_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_SET_SPH_VERSION(val, args...) { \
    struct nv_nva097_SET_SPH_VERSION __data = args; \
    __NVA097_SET_SPH_VERSION(&val, __data); \
}

#define VA_NVA097_SET_SPH_VERSION V_NVA097_SET_SPH_VERSION

#define P_NVA097_SET_SPH_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPH_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPH_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_CHECK_SPH_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_CHECK_SPH_VERSION(uint32_t *val_out, struct nv_nva097_CHECK_SPH_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_CHECK_SPH_VERSION(val, args...) { \
    struct nv_nva097_CHECK_SPH_VERSION __data = args; \
    __NVA097_CHECK_SPH_VERSION(&val, __data); \
}

#define VA_NVA097_CHECK_SPH_VERSION V_NVA097_CHECK_SPH_VERSION

#define P_NVA097_CHECK_SPH_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CHECK_SPH_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CHECK_SPH_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ALPHA_TO_COVERAGE_OVERRIDE {
    uint32_t qualify_by_anti_alias_enable;
    uint32_t qualify_by_ps_sample_mask_output;
};

static inline void
__NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE(uint32_t *val_out, struct nv_nva097_SET_ALPHA_TO_COVERAGE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.qualify_by_anti_alias_enable < (1ULL << 1));
    val |= st.qualify_by_anti_alias_enable << 0;
    
    assert(st.qualify_by_ps_sample_mask_output < (1ULL << 1));
    val |= st.qualify_by_ps_sample_mask_output << 1;
    *val_out = val;
}

#define V_NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE(val, args...) { \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE; \
    UNUSED uint32_t QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE; \
    struct nv_nva097_SET_ALPHA_TO_COVERAGE_OVERRIDE __data = args; \
    __NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE(&val, __data); \
}

#define VA_NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE V_NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE

#define P_NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_ANTI_ALIAS_ENABLE_ENABLE; \
    UNUSED uint32_t QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_DISABLE; \
    UNUSED uint32_t QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE = NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE_QUALIFY_BY_PS_SAMPLE_MASK_OUTPUT_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ALPHA_TO_COVERAGE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_POLYGON_STIPPLE_PATTERN {
    uint32_t v;
};

static inline void
__NVA097_SET_POLYGON_STIPPLE_PATTERN(uint32_t *val_out, struct nv_nva097_SET_POLYGON_STIPPLE_PATTERN st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_POLYGON_STIPPLE_PATTERN(val, args...) { \
    struct nv_nva097_SET_POLYGON_STIPPLE_PATTERN __data = { .v = (args) }; \
    __NVA097_SET_POLYGON_STIPPLE_PATTERN(&val, __data); \
}

#define VA_NVA097_SET_POLYGON_STIPPLE_PATTERN(i) V_NVA097_SET_POLYGON_STIPPLE_PATTERN

#define P_NVA097_SET_POLYGON_STIPPLE_PATTERN(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_POLYGON_STIPPLE_PATTERN(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_POLYGON_STIPPLE_PATTERN(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_AAM_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_SET_AAM_VERSION(uint32_t *val_out, struct nv_nva097_SET_AAM_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_SET_AAM_VERSION(val, args...) { \
    struct nv_nva097_SET_AAM_VERSION __data = args; \
    __NVA097_SET_AAM_VERSION(&val, __data); \
}

#define VA_NVA097_SET_AAM_VERSION V_NVA097_SET_AAM_VERSION

#define P_NVA097_SET_AAM_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_AAM_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_AAM_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_CHECK_AAM_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVA097_CHECK_AAM_VERSION(uint32_t *val_out, struct nv_nva097_CHECK_AAM_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVA097_CHECK_AAM_VERSION(val, args...) { \
    struct nv_nva097_CHECK_AAM_VERSION __data = args; \
    __NVA097_CHECK_AAM_VERSION(&val, __data); \
}

#define VA_NVA097_CHECK_AAM_VERSION V_NVA097_CHECK_AAM_VERSION

#define P_NVA097_CHECK_AAM_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CHECK_AAM_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CHECK_AAM_VERSION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZT_LAYER {
    uint32_t offset;
};

static inline void
__NVA097_SET_ZT_LAYER(uint32_t *val_out, struct nv_nva097_SET_ZT_LAYER st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 16));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVA097_SET_ZT_LAYER(val, args...) { \
    struct nv_nva097_SET_ZT_LAYER __data = { .offset = (args) }; \
    __NVA097_SET_ZT_LAYER(&val, __data); \
}

#define VA_NVA097_SET_ZT_LAYER V_NVA097_SET_ZT_LAYER

#define P_NVA097_SET_ZT_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZT_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZT_LAYER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_MEMORY_AREA_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_VAB_MEMORY_AREA_A(uint32_t *val_out, struct nv_nva097_SET_VAB_MEMORY_AREA_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VAB_MEMORY_AREA_A(val, args...) { \
    struct nv_nva097_SET_VAB_MEMORY_AREA_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_VAB_MEMORY_AREA_A(&val, __data); \
}

#define VA_NVA097_SET_VAB_MEMORY_AREA_A V_NVA097_SET_VAB_MEMORY_AREA_A

#define P_NVA097_SET_VAB_MEMORY_AREA_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_MEMORY_AREA_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_MEMORY_AREA_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_MEMORY_AREA_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_VAB_MEMORY_AREA_B(uint32_t *val_out, struct nv_nva097_SET_VAB_MEMORY_AREA_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_VAB_MEMORY_AREA_B(val, args...) { \
    struct nv_nva097_SET_VAB_MEMORY_AREA_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_VAB_MEMORY_AREA_B(&val, __data); \
}

#define VA_NVA097_SET_VAB_MEMORY_AREA_B V_NVA097_SET_VAB_MEMORY_AREA_B

#define P_NVA097_SET_VAB_MEMORY_AREA_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_MEMORY_AREA_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_MEMORY_AREA_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VAB_MEMORY_AREA_C {
    uint32_t size;
};

static inline void
__NVA097_SET_VAB_MEMORY_AREA_C(uint32_t *val_out, struct nv_nva097_SET_VAB_MEMORY_AREA_C st)
{
    uint32_t val = 0;
    
    assert(st.size < (1ULL << 2));
    val |= st.size << 0;
    *val_out = val;
}

#define V_NVA097_SET_VAB_MEMORY_AREA_C(val, args...) { \
    UNUSED uint32_t SIZE_BYTES_64K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_64K; \
    UNUSED uint32_t SIZE_BYTES_128K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_128K; \
    UNUSED uint32_t SIZE_BYTES_256K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_256K; \
    struct nv_nva097_SET_VAB_MEMORY_AREA_C __data = { .size = (args) }; \
    __NVA097_SET_VAB_MEMORY_AREA_C(&val, __data); \
}

#define VA_NVA097_SET_VAB_MEMORY_AREA_C V_NVA097_SET_VAB_MEMORY_AREA_C

#define P_NVA097_SET_VAB_MEMORY_AREA_C(push, args...) do { \
    UNUSED uint32_t SIZE_BYTES_64K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_64K; \
    UNUSED uint32_t SIZE_BYTES_128K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_128K; \
    UNUSED uint32_t SIZE_BYTES_256K = NVA097_SET_VAB_MEMORY_AREA_C_SIZE_BYTES_256K; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VAB_MEMORY_AREA_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VAB_MEMORY_AREA_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_A {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_INDEX_BUFFER_A(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_A(val, args...) { \
    struct nv_nva097_SET_INDEX_BUFFER_A __data = { .address_upper = (args) }; \
    __NVA097_SET_INDEX_BUFFER_A(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_A V_NVA097_SET_INDEX_BUFFER_A

#define P_NVA097_SET_INDEX_BUFFER_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_B {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_INDEX_BUFFER_B(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_B(val, args...) { \
    struct nv_nva097_SET_INDEX_BUFFER_B __data = { .address_lower = (args) }; \
    __NVA097_SET_INDEX_BUFFER_B(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_B V_NVA097_SET_INDEX_BUFFER_B

#define P_NVA097_SET_INDEX_BUFFER_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_C {
    uint32_t limit_address_upper;
};

static inline void
__NVA097_SET_INDEX_BUFFER_C(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_C st)
{
    uint32_t val = 0;
    
    assert(st.limit_address_upper < (1ULL << 8));
    val |= st.limit_address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_C(val, args...) { \
    struct nv_nva097_SET_INDEX_BUFFER_C __data = { .limit_address_upper = (args) }; \
    __NVA097_SET_INDEX_BUFFER_C(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_C V_NVA097_SET_INDEX_BUFFER_C

#define P_NVA097_SET_INDEX_BUFFER_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_D {
    uint32_t limit_address_lower;
};

static inline void
__NVA097_SET_INDEX_BUFFER_D(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_D st)
{
    uint32_t val = 0;
    
    val |= st.limit_address_lower;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_D(val, args...) { \
    struct nv_nva097_SET_INDEX_BUFFER_D __data = { .limit_address_lower = (args) }; \
    __NVA097_SET_INDEX_BUFFER_D(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_D V_NVA097_SET_INDEX_BUFFER_D

#define P_NVA097_SET_INDEX_BUFFER_D(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_D, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_E {
    uint32_t index_size;
};

static inline void
__NVA097_SET_INDEX_BUFFER_E(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_E st)
{
    uint32_t val = 0;
    
    assert(st.index_size < (1ULL << 2));
    val |= st.index_size << 0;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_E(val, args...) { \
    UNUSED uint32_t INDEX_SIZE_ONE_BYTE = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_ONE_BYTE; \
    UNUSED uint32_t INDEX_SIZE_TWO_BYTES = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_TWO_BYTES; \
    UNUSED uint32_t INDEX_SIZE_FOUR_BYTES = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_FOUR_BYTES; \
    struct nv_nva097_SET_INDEX_BUFFER_E __data = { .index_size = (args) }; \
    __NVA097_SET_INDEX_BUFFER_E(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_E V_NVA097_SET_INDEX_BUFFER_E

#define P_NVA097_SET_INDEX_BUFFER_E(push, args...) do { \
    UNUSED uint32_t INDEX_SIZE_ONE_BYTE = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_ONE_BYTE; \
    UNUSED uint32_t INDEX_SIZE_TWO_BYTES = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_TWO_BYTES; \
    UNUSED uint32_t INDEX_SIZE_FOUR_BYTES = NVA097_SET_INDEX_BUFFER_E_INDEX_SIZE_FOUR_BYTES; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_E(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_E, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_INDEX_BUFFER_F {
    uint32_t first;
};

static inline void
__NVA097_SET_INDEX_BUFFER_F(uint32_t *val_out, struct nv_nva097_SET_INDEX_BUFFER_F st)
{
    uint32_t val = 0;
    
    val |= st.first;
    *val_out = val;
}

#define V_NVA097_SET_INDEX_BUFFER_F(val, args...) { \
    struct nv_nva097_SET_INDEX_BUFFER_F __data = { .first = (args) }; \
    __NVA097_SET_INDEX_BUFFER_F(&val, __data); \
}

#define VA_NVA097_SET_INDEX_BUFFER_F V_NVA097_SET_INDEX_BUFFER_F

#define P_NVA097_SET_INDEX_BUFFER_F(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_INDEX_BUFFER_F(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_INDEX_BUFFER_F, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER {
    uint32_t count;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER(val, args...) { \
    struct nv_nva097_DRAW_INDEX_BUFFER __data = { .count = (args) }; \
    __NVA097_DRAW_INDEX_BUFFER(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER V_NVA097_DRAW_INDEX_BUFFER

#define P_NVA097_DRAW_INDEX_BUFFER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST __data = args; \
    __NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST

#define P_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_FIRST, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST __data = args; \
    __NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST

#define P_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_FIRST, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST __data = args; \
    __NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST

#define P_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_FIRST, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT __data = args; \
    __NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT

#define P_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER32_BEGIN_END_INSTANCE_SUBSEQUENT, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT __data = args; \
    __NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT

#define P_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER16_BEGIN_END_INSTANCE_SUBSEQUENT, nvk_p_ret); \
} while(0)

struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT {
    uint32_t first;
    uint32_t count;
    uint32_t topology;
};

static inline void
__NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT(uint32_t *val_out, struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT st)
{
    uint32_t val = 0;
    
    assert(st.first < (1ULL << 16));
    val |= st.first << 0;
    
    assert(st.count < (1ULL << 12));
    val |= st.count << 16;
    
    assert(st.topology < (1ULL << 4));
    val |= st.topology << 28;
    *val_out = val;
}

#define V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT(val, args...) { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    struct nv_nva097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT __data = args; \
    __NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT(&val, __data); \
}

#define VA_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT

#define P_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT(push, args...) do { \
    UNUSED uint32_t TOPOLOGY_POINTS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POINTS; \
    UNUSED uint32_t TOPOLOGY_LINES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINES; \
    UNUSED uint32_t TOPOLOGY_LINE_LOOP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_LOOP; \
    UNUSED uint32_t TOPOLOGY_LINE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLES = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLES; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_STRIP; \
    UNUSED uint32_t TOPOLOGY_TRIANGLE_FAN = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLE_FAN; \
    UNUSED uint32_t TOPOLOGY_QUADS = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUADS; \
    UNUSED uint32_t TOPOLOGY_QUAD_STRIP = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_QUAD_STRIP; \
    UNUSED uint32_t TOPOLOGY_POLYGON = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_POLYGON; \
    UNUSED uint32_t TOPOLOGY_LINELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_LINESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_LINESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLELIST_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t TOPOLOGY_TRIANGLESTRIP_ADJCY = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t TOPOLOGY_PATCH = NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT_TOPOLOGY_PATCH; \
    uint32_t nvk_p_ret; \
    V_NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_DRAW_INDEX_BUFFER8_BEGIN_END_INSTANCE_SUBSEQUENT, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BIAS_CLAMP {
    uint32_t v;
};

static inline void
__NVA097_SET_DEPTH_BIAS_CLAMP(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BIAS_CLAMP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BIAS_CLAMP(val, args...) { \
    struct nv_nva097_SET_DEPTH_BIAS_CLAMP __data = { .v = (args) }; \
    __NVA097_SET_DEPTH_BIAS_CLAMP(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BIAS_CLAMP V_NVA097_SET_DEPTH_BIAS_CLAMP

#define P_NVA097_SET_DEPTH_BIAS_CLAMP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BIAS_CLAMP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BIAS_CLAMP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_A {
    uint32_t is_instanced;
};

static inline void
__NVA097_SET_VERTEX_STREAM_INSTANCE_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_A st)
{
    uint32_t val = 0;
    
    assert(st.is_instanced < (1ULL << 1));
    val |= st.is_instanced << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_INSTANCE_A(val, args...) { \
    UNUSED uint32_t IS_INSTANCED_FALSE = NVA097_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_FALSE; \
    UNUSED uint32_t IS_INSTANCED_TRUE = NVA097_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_TRUE; \
    struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_A __data = { .is_instanced = (args) }; \
    __NVA097_SET_VERTEX_STREAM_INSTANCE_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_INSTANCE_A(i) V_NVA097_SET_VERTEX_STREAM_INSTANCE_A

#define P_NVA097_SET_VERTEX_STREAM_INSTANCE_A(push, idx, args...) do { \
    UNUSED uint32_t IS_INSTANCED_FALSE = NVA097_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_FALSE; \
    UNUSED uint32_t IS_INSTANCED_TRUE = NVA097_SET_VERTEX_STREAM_INSTANCE_A_IS_INSTANCED_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_INSTANCE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_INSTANCE_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_B {
    uint32_t is_instanced;
};

static inline void
__NVA097_SET_VERTEX_STREAM_INSTANCE_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_B st)
{
    uint32_t val = 0;
    
    assert(st.is_instanced < (1ULL << 1));
    val |= st.is_instanced << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_INSTANCE_B(val, args...) { \
    UNUSED uint32_t IS_INSTANCED_FALSE = NVA097_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_FALSE; \
    UNUSED uint32_t IS_INSTANCED_TRUE = NVA097_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_TRUE; \
    struct nv_nva097_SET_VERTEX_STREAM_INSTANCE_B __data = { .is_instanced = (args) }; \
    __NVA097_SET_VERTEX_STREAM_INSTANCE_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_INSTANCE_B(i) V_NVA097_SET_VERTEX_STREAM_INSTANCE_B

#define P_NVA097_SET_VERTEX_STREAM_INSTANCE_B(push, idx, args...) do { \
    UNUSED uint32_t IS_INSTANCED_FALSE = NVA097_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_FALSE; \
    UNUSED uint32_t IS_INSTANCED_TRUE = NVA097_SET_VERTEX_STREAM_INSTANCE_B_IS_INSTANCED_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_INSTANCE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_INSTANCE_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ATTRIBUTE_POINT_SIZE {
    uint32_t enable;
    uint32_t slot;
};

static inline void
__NVA097_SET_ATTRIBUTE_POINT_SIZE(uint32_t *val_out, struct nv_nva097_SET_ATTRIBUTE_POINT_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.slot < (1ULL << 8));
    val |= st.slot << 4;
    *val_out = val;
}

#define V_NVA097_SET_ATTRIBUTE_POINT_SIZE(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ATTRIBUTE_POINT_SIZE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ATTRIBUTE_POINT_SIZE_ENABLE_TRUE; \
    struct nv_nva097_SET_ATTRIBUTE_POINT_SIZE __data = args; \
    __NVA097_SET_ATTRIBUTE_POINT_SIZE(&val, __data); \
}

#define VA_NVA097_SET_ATTRIBUTE_POINT_SIZE V_NVA097_SET_ATTRIBUTE_POINT_SIZE

#define P_NVA097_SET_ATTRIBUTE_POINT_SIZE(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_ATTRIBUTE_POINT_SIZE_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_ATTRIBUTE_POINT_SIZE_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ATTRIBUTE_POINT_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ATTRIBUTE_POINT_SIZE, nvk_p_ret); \
} while(0)

struct nv_nva097_OGL_SET_CULL {
    uint32_t enable;
};

static inline void
__NVA097_OGL_SET_CULL(uint32_t *val_out, struct nv_nva097_OGL_SET_CULL st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_OGL_SET_CULL(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_OGL_SET_CULL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_OGL_SET_CULL_ENABLE_TRUE; \
    struct nv_nva097_OGL_SET_CULL __data = { .enable = (args) }; \
    __NVA097_OGL_SET_CULL(&val, __data); \
}

#define VA_NVA097_OGL_SET_CULL V_NVA097_OGL_SET_CULL

#define P_NVA097_OGL_SET_CULL(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_OGL_SET_CULL_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_OGL_SET_CULL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_OGL_SET_CULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_OGL_SET_CULL, nvk_p_ret); \
} while(0)

struct nv_nva097_OGL_SET_FRONT_FACE {
    uint32_t v;
};

static inline void
__NVA097_OGL_SET_FRONT_FACE(uint32_t *val_out, struct nv_nva097_OGL_SET_FRONT_FACE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_OGL_SET_FRONT_FACE(val, args...) { \
    UNUSED uint32_t V_CW = NVA097_OGL_SET_FRONT_FACE_V_CW; \
    UNUSED uint32_t V_CCW = NVA097_OGL_SET_FRONT_FACE_V_CCW; \
    struct nv_nva097_OGL_SET_FRONT_FACE __data = { .v = (args) }; \
    __NVA097_OGL_SET_FRONT_FACE(&val, __data); \
}

#define VA_NVA097_OGL_SET_FRONT_FACE V_NVA097_OGL_SET_FRONT_FACE

#define P_NVA097_OGL_SET_FRONT_FACE(push, args...) do { \
    UNUSED uint32_t V_CW = NVA097_OGL_SET_FRONT_FACE_V_CW; \
    UNUSED uint32_t V_CCW = NVA097_OGL_SET_FRONT_FACE_V_CCW; \
    uint32_t nvk_p_ret; \
    V_NVA097_OGL_SET_FRONT_FACE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_OGL_SET_FRONT_FACE, nvk_p_ret); \
} while(0)

struct nv_nva097_OGL_SET_CULL_FACE {
    uint32_t v;
};

static inline void
__NVA097_OGL_SET_CULL_FACE(uint32_t *val_out, struct nv_nva097_OGL_SET_CULL_FACE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_OGL_SET_CULL_FACE(val, args...) { \
    UNUSED uint32_t V_FRONT = NVA097_OGL_SET_CULL_FACE_V_FRONT; \
    UNUSED uint32_t V_BACK = NVA097_OGL_SET_CULL_FACE_V_BACK; \
    UNUSED uint32_t V_FRONT_AND_BACK = NVA097_OGL_SET_CULL_FACE_V_FRONT_AND_BACK; \
    struct nv_nva097_OGL_SET_CULL_FACE __data = { .v = (args) }; \
    __NVA097_OGL_SET_CULL_FACE(&val, __data); \
}

#define VA_NVA097_OGL_SET_CULL_FACE V_NVA097_OGL_SET_CULL_FACE

#define P_NVA097_OGL_SET_CULL_FACE(push, args...) do { \
    UNUSED uint32_t V_FRONT = NVA097_OGL_SET_CULL_FACE_V_FRONT; \
    UNUSED uint32_t V_BACK = NVA097_OGL_SET_CULL_FACE_V_BACK; \
    UNUSED uint32_t V_FRONT_AND_BACK = NVA097_OGL_SET_CULL_FACE_V_FRONT_AND_BACK; \
    uint32_t nvk_p_ret; \
    V_NVA097_OGL_SET_CULL_FACE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_OGL_SET_CULL_FACE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_PIXEL {
    uint32_t center;
};

static inline void
__NVA097_SET_VIEWPORT_PIXEL(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_PIXEL st)
{
    uint32_t val = 0;
    
    assert(st.center < (1ULL << 1));
    val |= st.center << 0;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_PIXEL(val, args...) { \
    UNUSED uint32_t CENTER_AT_HALF_INTEGERS = NVA097_SET_VIEWPORT_PIXEL_CENTER_AT_HALF_INTEGERS; \
    UNUSED uint32_t CENTER_AT_INTEGERS = NVA097_SET_VIEWPORT_PIXEL_CENTER_AT_INTEGERS; \
    struct nv_nva097_SET_VIEWPORT_PIXEL __data = { .center = (args) }; \
    __NVA097_SET_VIEWPORT_PIXEL(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_PIXEL V_NVA097_SET_VIEWPORT_PIXEL

#define P_NVA097_SET_VIEWPORT_PIXEL(push, args...) do { \
    UNUSED uint32_t CENTER_AT_HALF_INTEGERS = NVA097_SET_VIEWPORT_PIXEL_CENTER_AT_HALF_INTEGERS; \
    UNUSED uint32_t CENTER_AT_INTEGERS = NVA097_SET_VIEWPORT_PIXEL_CENTER_AT_INTEGERS; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_PIXEL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_PIXEL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_SCALE_OFFSET {
    uint32_t enable;
};

static inline void
__NVA097_SET_VIEWPORT_SCALE_OFFSET(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_SCALE_OFFSET st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_SCALE_OFFSET(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VIEWPORT_SCALE_OFFSET_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VIEWPORT_SCALE_OFFSET_ENABLE_TRUE; \
    struct nv_nva097_SET_VIEWPORT_SCALE_OFFSET __data = { .enable = (args) }; \
    __NVA097_SET_VIEWPORT_SCALE_OFFSET(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_SCALE_OFFSET V_NVA097_SET_VIEWPORT_SCALE_OFFSET

#define P_NVA097_SET_VIEWPORT_SCALE_OFFSET(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VIEWPORT_SCALE_OFFSET_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VIEWPORT_SCALE_OFFSET_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_SCALE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_SCALE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_CONSTANT_BUFFER_CACHE {
    uint32_t thru_l2;
};

static inline void
__NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE(uint32_t *val_out, struct nv_nva097_INVALIDATE_CONSTANT_BUFFER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.thru_l2 < (1ULL << 1));
    val |= st.thru_l2 << 0;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE(val, args...) { \
    UNUSED uint32_t THRU_L2_FALSE = NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE; \
    UNUSED uint32_t THRU_L2_TRUE = NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE; \
    struct nv_nva097_INVALIDATE_CONSTANT_BUFFER_CACHE __data = { .thru_l2 = (args) }; \
    __NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE(&val, __data); \
}

#define VA_NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE V_NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE

#define P_NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE(push, args...) do { \
    UNUSED uint32_t THRU_L2_FALSE = NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_FALSE; \
    UNUSED uint32_t THRU_L2_TRUE = NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE_THRU_L2_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_CONSTANT_BUFFER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VIEWPORT_CLIP_CONTROL {
    uint32_t min_z_zero_max_z_one;
    uint32_t pixel_min_z;
    uint32_t pixel_max_z;
    uint32_t geometry_guardband;
    uint32_t line_point_cull_guardband;
    uint32_t geometry_clip;
    uint32_t geometry_guardband_z;
};

static inline void
__NVA097_SET_VIEWPORT_CLIP_CONTROL(uint32_t *val_out, struct nv_nva097_SET_VIEWPORT_CLIP_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.min_z_zero_max_z_one < (1ULL << 1));
    val |= st.min_z_zero_max_z_one << 0;
    
    assert(st.pixel_min_z < (1ULL << 1));
    val |= st.pixel_min_z << 3;
    
    assert(st.pixel_max_z < (1ULL << 1));
    val |= st.pixel_max_z << 4;
    
    assert(st.geometry_guardband < (1ULL << 1));
    val |= st.geometry_guardband << 7;
    
    assert(st.line_point_cull_guardband < (1ULL << 1));
    val |= st.line_point_cull_guardband << 10;
    
    assert(st.geometry_clip < (1ULL << 3));
    val |= st.geometry_clip << 11;
    
    assert(st.geometry_guardband_z < (1ULL << 2));
    val |= st.geometry_guardband_z << 1;
    *val_out = val;
}

#define V_NVA097_SET_VIEWPORT_CLIP_CONTROL(val, args...) { \
    UNUSED uint32_t MIN_Z_ZERO_MAX_Z_ONE_FALSE = NVA097_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE; \
    UNUSED uint32_t MIN_Z_ZERO_MAX_Z_ONE_TRUE = NVA097_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE; \
    UNUSED uint32_t PIXEL_MIN_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP; \
    UNUSED uint32_t PIXEL_MIN_Z_CLAMP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP; \
    UNUSED uint32_t PIXEL_MAX_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP; \
    UNUSED uint32_t PIXEL_MAX_Z_CLAMP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1; \
    UNUSED uint32_t LINE_POINT_CULL_GUARDBAND_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256; \
    UNUSED uint32_t LINE_POINT_CULL_GUARDBAND_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1; \
    UNUSED uint32_t GEOMETRY_CLIP_WZERO_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_PASSTHRU = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_XY_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1; \
    struct nv_nva097_SET_VIEWPORT_CLIP_CONTROL __data = args; \
    __NVA097_SET_VIEWPORT_CLIP_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_VIEWPORT_CLIP_CONTROL V_NVA097_SET_VIEWPORT_CLIP_CONTROL

#define P_NVA097_SET_VIEWPORT_CLIP_CONTROL(push, args...) do { \
    UNUSED uint32_t MIN_Z_ZERO_MAX_Z_ONE_FALSE = NVA097_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_FALSE; \
    UNUSED uint32_t MIN_Z_ZERO_MAX_Z_ONE_TRUE = NVA097_SET_VIEWPORT_CLIP_CONTROL_MIN_Z_ZERO_MAX_Z_ONE_TRUE; \
    UNUSED uint32_t PIXEL_MIN_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLIP; \
    UNUSED uint32_t PIXEL_MIN_Z_CLAMP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MIN_Z_CLAMP; \
    UNUSED uint32_t PIXEL_MAX_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLIP; \
    UNUSED uint32_t PIXEL_MAX_Z_CLAMP = NVA097_SET_VIEWPORT_CLIP_CONTROL_PIXEL_MAX_Z_CLAMP; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_256; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_SCALE_1; \
    UNUSED uint32_t LINE_POINT_CULL_GUARDBAND_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_256; \
    UNUSED uint32_t LINE_POINT_CULL_GUARDBAND_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_LINE_POINT_CULL_GUARDBAND_SCALE_1; \
    UNUSED uint32_t GEOMETRY_CLIP_WZERO_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_PASSTHRU = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_PASSTHRU; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_XY_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XY_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_XYZ_CLIP; \
    UNUSED uint32_t GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_WZERO_CLIP_NO_Z_CULL; \
    UNUSED uint32_t GEOMETRY_CLIP_FRUSTUM_Z_CLIP = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_CLIP_FRUSTUM_Z_CLIP; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SAME_AS_XY_GUARDBAND; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SCALE_256 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_256; \
    UNUSED uint32_t GEOMETRY_GUARDBAND_Z_SCALE_1 = NVA097_SET_VIEWPORT_CLIP_CONTROL_GEOMETRY_GUARDBAND_Z_SCALE_1; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VIEWPORT_CLIP_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VIEWPORT_CLIP_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_USER_CLIP_OP {
    uint32_t plane0;
    uint32_t plane1;
    uint32_t plane2;
    uint32_t plane3;
    uint32_t plane4;
    uint32_t plane5;
    uint32_t plane6;
    uint32_t plane7;
};

static inline void
__NVA097_SET_USER_CLIP_OP(uint32_t *val_out, struct nv_nva097_SET_USER_CLIP_OP st)
{
    uint32_t val = 0;
    
    assert(st.plane0 < (1ULL << 1));
    val |= st.plane0 << 0;
    
    assert(st.plane1 < (1ULL << 1));
    val |= st.plane1 << 4;
    
    assert(st.plane2 < (1ULL << 1));
    val |= st.plane2 << 8;
    
    assert(st.plane3 < (1ULL << 1));
    val |= st.plane3 << 12;
    
    assert(st.plane4 < (1ULL << 1));
    val |= st.plane4 << 16;
    
    assert(st.plane5 < (1ULL << 1));
    val |= st.plane5 << 20;
    
    assert(st.plane6 < (1ULL << 1));
    val |= st.plane6 << 24;
    
    assert(st.plane7 < (1ULL << 1));
    val |= st.plane7 << 28;
    *val_out = val;
}

#define V_NVA097_SET_USER_CLIP_OP(val, args...) { \
    UNUSED uint32_t PLANE0_CLIP = NVA097_SET_USER_CLIP_OP_PLANE0_CLIP; \
    UNUSED uint32_t PLANE0_CULL = NVA097_SET_USER_CLIP_OP_PLANE0_CULL; \
    UNUSED uint32_t PLANE1_CLIP = NVA097_SET_USER_CLIP_OP_PLANE1_CLIP; \
    UNUSED uint32_t PLANE1_CULL = NVA097_SET_USER_CLIP_OP_PLANE1_CULL; \
    UNUSED uint32_t PLANE2_CLIP = NVA097_SET_USER_CLIP_OP_PLANE2_CLIP; \
    UNUSED uint32_t PLANE2_CULL = NVA097_SET_USER_CLIP_OP_PLANE2_CULL; \
    UNUSED uint32_t PLANE3_CLIP = NVA097_SET_USER_CLIP_OP_PLANE3_CLIP; \
    UNUSED uint32_t PLANE3_CULL = NVA097_SET_USER_CLIP_OP_PLANE3_CULL; \
    UNUSED uint32_t PLANE4_CLIP = NVA097_SET_USER_CLIP_OP_PLANE4_CLIP; \
    UNUSED uint32_t PLANE4_CULL = NVA097_SET_USER_CLIP_OP_PLANE4_CULL; \
    UNUSED uint32_t PLANE5_CLIP = NVA097_SET_USER_CLIP_OP_PLANE5_CLIP; \
    UNUSED uint32_t PLANE5_CULL = NVA097_SET_USER_CLIP_OP_PLANE5_CULL; \
    UNUSED uint32_t PLANE6_CLIP = NVA097_SET_USER_CLIP_OP_PLANE6_CLIP; \
    UNUSED uint32_t PLANE6_CULL = NVA097_SET_USER_CLIP_OP_PLANE6_CULL; \
    UNUSED uint32_t PLANE7_CLIP = NVA097_SET_USER_CLIP_OP_PLANE7_CLIP; \
    UNUSED uint32_t PLANE7_CULL = NVA097_SET_USER_CLIP_OP_PLANE7_CULL; \
    struct nv_nva097_SET_USER_CLIP_OP __data = args; \
    __NVA097_SET_USER_CLIP_OP(&val, __data); \
}

#define VA_NVA097_SET_USER_CLIP_OP V_NVA097_SET_USER_CLIP_OP

#define P_NVA097_SET_USER_CLIP_OP(push, args...) do { \
    UNUSED uint32_t PLANE0_CLIP = NVA097_SET_USER_CLIP_OP_PLANE0_CLIP; \
    UNUSED uint32_t PLANE0_CULL = NVA097_SET_USER_CLIP_OP_PLANE0_CULL; \
    UNUSED uint32_t PLANE1_CLIP = NVA097_SET_USER_CLIP_OP_PLANE1_CLIP; \
    UNUSED uint32_t PLANE1_CULL = NVA097_SET_USER_CLIP_OP_PLANE1_CULL; \
    UNUSED uint32_t PLANE2_CLIP = NVA097_SET_USER_CLIP_OP_PLANE2_CLIP; \
    UNUSED uint32_t PLANE2_CULL = NVA097_SET_USER_CLIP_OP_PLANE2_CULL; \
    UNUSED uint32_t PLANE3_CLIP = NVA097_SET_USER_CLIP_OP_PLANE3_CLIP; \
    UNUSED uint32_t PLANE3_CULL = NVA097_SET_USER_CLIP_OP_PLANE3_CULL; \
    UNUSED uint32_t PLANE4_CLIP = NVA097_SET_USER_CLIP_OP_PLANE4_CLIP; \
    UNUSED uint32_t PLANE4_CULL = NVA097_SET_USER_CLIP_OP_PLANE4_CULL; \
    UNUSED uint32_t PLANE5_CLIP = NVA097_SET_USER_CLIP_OP_PLANE5_CLIP; \
    UNUSED uint32_t PLANE5_CULL = NVA097_SET_USER_CLIP_OP_PLANE5_CULL; \
    UNUSED uint32_t PLANE6_CLIP = NVA097_SET_USER_CLIP_OP_PLANE6_CLIP; \
    UNUSED uint32_t PLANE6_CULL = NVA097_SET_USER_CLIP_OP_PLANE6_CULL; \
    UNUSED uint32_t PLANE7_CLIP = NVA097_SET_USER_CLIP_OP_PLANE7_CLIP; \
    UNUSED uint32_t PLANE7_CULL = NVA097_SET_USER_CLIP_OP_PLANE7_CULL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_USER_CLIP_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_USER_CLIP_OP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_RENDER_ENABLE_OVERRIDE {
    uint32_t mode;
};

static inline void
__NVA097_SET_RENDER_ENABLE_OVERRIDE(uint32_t *val_out, struct nv_nva097_SET_RENDER_ENABLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVA097_SET_RENDER_ENABLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    struct nv_nva097_SET_RENDER_ENABLE_OVERRIDE __data = { .mode = (args) }; \
    __NVA097_SET_RENDER_ENABLE_OVERRIDE(&val, __data); \
}

#define VA_NVA097_SET_RENDER_ENABLE_OVERRIDE V_NVA097_SET_RENDER_ENABLE_OVERRIDE

#define P_NVA097_SET_RENDER_ENABLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVA097_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_RENDER_ENABLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_RENDER_ENABLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PRIMITIVE_TOPOLOGY_CONTROL {
    uint32_t override;
};

static inline void
__NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL(uint32_t *val_out, struct nv_nva097_SET_PRIMITIVE_TOPOLOGY_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.override < (1ULL << 1));
    val |= st.override << 0;
    *val_out = val;
}

#define V_NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL(val, args...) { \
    UNUSED uint32_t OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS = NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS; \
    UNUSED uint32_t OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE = NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE; \
    struct nv_nva097_SET_PRIMITIVE_TOPOLOGY_CONTROL __data = { .override = (args) }; \
    __NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL V_NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL

#define P_NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL(push, args...) do { \
    UNUSED uint32_t OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS = NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_TOPOLOGY_IN_BEGIN_METHODS; \
    UNUSED uint32_t OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE = NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL_OVERRIDE_USE_SEPARATE_TOPOLOGY_STATE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PRIMITIVE_TOPOLOGY_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_CLIP_ENABLE {
    uint32_t v;
};

static inline void
__NVA097_SET_WINDOW_CLIP_ENABLE(uint32_t *val_out, struct nv_nva097_SET_WINDOW_CLIP_ENABLE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_CLIP_ENABLE(val, args...) { \
    UNUSED uint32_t V_FALSE = NVA097_SET_WINDOW_CLIP_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_WINDOW_CLIP_ENABLE_V_TRUE; \
    struct nv_nva097_SET_WINDOW_CLIP_ENABLE __data = { .v = (args) }; \
    __NVA097_SET_WINDOW_CLIP_ENABLE(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_CLIP_ENABLE V_NVA097_SET_WINDOW_CLIP_ENABLE

#define P_NVA097_SET_WINDOW_CLIP_ENABLE(push, args...) do { \
    UNUSED uint32_t V_FALSE = NVA097_SET_WINDOW_CLIP_ENABLE_V_FALSE; \
    UNUSED uint32_t V_TRUE = NVA097_SET_WINDOW_CLIP_ENABLE_V_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_CLIP_ENABLE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_CLIP_ENABLE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_WINDOW_CLIP_TYPE {
    uint32_t v;
};

static inline void
__NVA097_SET_WINDOW_CLIP_TYPE(uint32_t *val_out, struct nv_nva097_SET_WINDOW_CLIP_TYPE st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 2));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_WINDOW_CLIP_TYPE(val, args...) { \
    UNUSED uint32_t V_INCLUSIVE = NVA097_SET_WINDOW_CLIP_TYPE_V_INCLUSIVE; \
    UNUSED uint32_t V_EXCLUSIVE = NVA097_SET_WINDOW_CLIP_TYPE_V_EXCLUSIVE; \
    UNUSED uint32_t V_CLIPALL = NVA097_SET_WINDOW_CLIP_TYPE_V_CLIPALL; \
    struct nv_nva097_SET_WINDOW_CLIP_TYPE __data = { .v = (args) }; \
    __NVA097_SET_WINDOW_CLIP_TYPE(&val, __data); \
}

#define VA_NVA097_SET_WINDOW_CLIP_TYPE V_NVA097_SET_WINDOW_CLIP_TYPE

#define P_NVA097_SET_WINDOW_CLIP_TYPE(push, args...) do { \
    UNUSED uint32_t V_INCLUSIVE = NVA097_SET_WINDOW_CLIP_TYPE_V_INCLUSIVE; \
    UNUSED uint32_t V_EXCLUSIVE = NVA097_SET_WINDOW_CLIP_TYPE_V_EXCLUSIVE; \
    UNUSED uint32_t V_CLIPALL = NVA097_SET_WINDOW_CLIP_TYPE_V_CLIPALL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_WINDOW_CLIP_TYPE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_WINDOW_CLIP_TYPE, nvk_p_ret); \
} while(0)

struct nv_nva097_INVALIDATE_ZCULL {
    uint32_t v;
};

static inline void
__NVA097_INVALIDATE_ZCULL(uint32_t *val_out, struct nv_nva097_INVALIDATE_ZCULL st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_INVALIDATE_ZCULL(val, args...) { \
    UNUSED uint32_t V_INVALIDATE = NVA097_INVALIDATE_ZCULL_V_INVALIDATE; \
    struct nv_nva097_INVALIDATE_ZCULL __data = { .v = (args) }; \
    __NVA097_INVALIDATE_ZCULL(&val, __data); \
}

#define VA_NVA097_INVALIDATE_ZCULL V_NVA097_INVALIDATE_ZCULL

#define P_NVA097_INVALIDATE_ZCULL(push, args...) do { \
    UNUSED uint32_t V_INVALIDATE = NVA097_INVALIDATE_ZCULL_V_INVALIDATE; \
    uint32_t nvk_p_ret; \
    V_NVA097_INVALIDATE_ZCULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_INVALIDATE_ZCULL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL {
    uint32_t z_enable;
    uint32_t stencil_enable;
};

static inline void
__NVA097_SET_ZCULL(uint32_t *val_out, struct nv_nva097_SET_ZCULL st)
{
    uint32_t val = 0;
    
    assert(st.z_enable < (1ULL << 1));
    val |= st.z_enable << 0;
    
    assert(st.stencil_enable < (1ULL << 1));
    val |= st.stencil_enable << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL(val, args...) { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_SET_ZCULL_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_SET_ZCULL_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_SET_ZCULL_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_SET_ZCULL_STENCIL_ENABLE_TRUE; \
    struct nv_nva097_SET_ZCULL __data = args; \
    __NVA097_SET_ZCULL(&val, __data); \
}

#define VA_NVA097_SET_ZCULL V_NVA097_SET_ZCULL

#define P_NVA097_SET_ZCULL(push, args...) do { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_SET_ZCULL_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_SET_ZCULL_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_SET_ZCULL_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_SET_ZCULL_STENCIL_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_ZCULL_BOUNDS {
    uint32_t z_min_unbounded_enable;
    uint32_t z_max_unbounded_enable;
};

static inline void
__NVA097_SET_ZCULL_BOUNDS(uint32_t *val_out, struct nv_nva097_SET_ZCULL_BOUNDS st)
{
    uint32_t val = 0;
    
    assert(st.z_min_unbounded_enable < (1ULL << 1));
    val |= st.z_min_unbounded_enable << 0;
    
    assert(st.z_max_unbounded_enable < (1ULL << 1));
    val |= st.z_max_unbounded_enable << 4;
    *val_out = val;
}

#define V_NVA097_SET_ZCULL_BOUNDS(val, args...) { \
    UNUSED uint32_t Z_MIN_UNBOUNDED_ENABLE_FALSE = NVA097_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_FALSE; \
    UNUSED uint32_t Z_MIN_UNBOUNDED_ENABLE_TRUE = NVA097_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_TRUE; \
    UNUSED uint32_t Z_MAX_UNBOUNDED_ENABLE_FALSE = NVA097_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_FALSE; \
    UNUSED uint32_t Z_MAX_UNBOUNDED_ENABLE_TRUE = NVA097_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_TRUE; \
    struct nv_nva097_SET_ZCULL_BOUNDS __data = args; \
    __NVA097_SET_ZCULL_BOUNDS(&val, __data); \
}

#define VA_NVA097_SET_ZCULL_BOUNDS V_NVA097_SET_ZCULL_BOUNDS

#define P_NVA097_SET_ZCULL_BOUNDS(push, args...) do { \
    UNUSED uint32_t Z_MIN_UNBOUNDED_ENABLE_FALSE = NVA097_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_FALSE; \
    UNUSED uint32_t Z_MIN_UNBOUNDED_ENABLE_TRUE = NVA097_SET_ZCULL_BOUNDS_Z_MIN_UNBOUNDED_ENABLE_TRUE; \
    UNUSED uint32_t Z_MAX_UNBOUNDED_ENABLE_FALSE = NVA097_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_FALSE; \
    UNUSED uint32_t Z_MAX_UNBOUNDED_ENABLE_TRUE = NVA097_SET_ZCULL_BOUNDS_Z_MAX_UNBOUNDED_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_ZCULL_BOUNDS(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_ZCULL_BOUNDS, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PRIMITIVE_TOPOLOGY {
    uint32_t v;
};

static inline void
__NVA097_SET_PRIMITIVE_TOPOLOGY(uint32_t *val_out, struct nv_nva097_SET_PRIMITIVE_TOPOLOGY st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PRIMITIVE_TOPOLOGY(val, args...) { \
    UNUSED uint32_t V_POINTLIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_POINTLIST; \
    UNUSED uint32_t V_LINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINELIST; \
    UNUSED uint32_t V_LINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP; \
    UNUSED uint32_t V_TRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST; \
    UNUSED uint32_t V_TRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP; \
    UNUSED uint32_t V_LINELIST_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINELIST_ADJCY; \
    UNUSED uint32_t V_LINESTRIP_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP_ADJCY; \
    UNUSED uint32_t V_TRIANGLELIST_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t V_TRIANGLESTRIP_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t V_PATCHLIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_PATCHLIST; \
    UNUSED uint32_t V_LEGACY_POINTS = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_POINTS; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST; \
    UNUSED uint32_t V_LEGACY_LINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST; \
    UNUSED uint32_t V_LEGACY_LINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINESTRIP; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINESTRIP; \
    UNUSED uint32_t V_LEGACY_TRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLELIST; \
    UNUSED uint32_t V_LEGACY_TRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLESTRIP; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLESTRIP; \
    UNUSED uint32_t V_LEGACY_TRIANGLEFAN = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLEFAN = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLEFAN; \
    UNUSED uint32_t V_LEGACY_TRIANGLEFAN_IMM = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN_IMM; \
    UNUSED uint32_t V_LEGACY_LINELIST_IMM = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST_IMM; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLELIST2 = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST2; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINELIST2 = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST2; \
    struct nv_nva097_SET_PRIMITIVE_TOPOLOGY __data = { .v = (args) }; \
    __NVA097_SET_PRIMITIVE_TOPOLOGY(&val, __data); \
}

#define VA_NVA097_SET_PRIMITIVE_TOPOLOGY V_NVA097_SET_PRIMITIVE_TOPOLOGY

#define P_NVA097_SET_PRIMITIVE_TOPOLOGY(push, args...) do { \
    UNUSED uint32_t V_POINTLIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_POINTLIST; \
    UNUSED uint32_t V_LINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINELIST; \
    UNUSED uint32_t V_LINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP; \
    UNUSED uint32_t V_TRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST; \
    UNUSED uint32_t V_TRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP; \
    UNUSED uint32_t V_LINELIST_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINELIST_ADJCY; \
    UNUSED uint32_t V_LINESTRIP_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LINESTRIP_ADJCY; \
    UNUSED uint32_t V_TRIANGLELIST_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLELIST_ADJCY; \
    UNUSED uint32_t V_TRIANGLESTRIP_ADJCY = NVA097_SET_PRIMITIVE_TOPOLOGY_V_TRIANGLESTRIP_ADJCY; \
    UNUSED uint32_t V_PATCHLIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_PATCHLIST; \
    UNUSED uint32_t V_LEGACY_POINTS = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_POINTS; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST; \
    UNUSED uint32_t V_LEGACY_LINELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST; \
    UNUSED uint32_t V_LEGACY_LINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINESTRIP; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINESTRIP; \
    UNUSED uint32_t V_LEGACY_TRIANGLELIST = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLELIST; \
    UNUSED uint32_t V_LEGACY_TRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLESTRIP; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLESTRIP = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLESTRIP; \
    UNUSED uint32_t V_LEGACY_TRIANGLEFAN = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLEFAN = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLEFAN; \
    UNUSED uint32_t V_LEGACY_TRIANGLEFAN_IMM = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_TRIANGLEFAN_IMM; \
    UNUSED uint32_t V_LEGACY_LINELIST_IMM = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_LINELIST_IMM; \
    UNUSED uint32_t V_LEGACY_INDEXEDTRIANGLELIST2 = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDTRIANGLELIST2; \
    UNUSED uint32_t V_LEGACY_INDEXEDLINELIST2 = NVA097_SET_PRIMITIVE_TOPOLOGY_V_LEGACY_INDEXEDLINELIST2; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PRIMITIVE_TOPOLOGY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PRIMITIVE_TOPOLOGY, nvk_p_ret); \
} while(0)

struct nv_nva097_ZCULL_SYNC {
    uint32_t v;
};

static inline void
__NVA097_ZCULL_SYNC(uint32_t *val_out, struct nv_nva097_ZCULL_SYNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_ZCULL_SYNC(val, args...) { \
    struct nv_nva097_ZCULL_SYNC __data = { .v = (args) }; \
    __NVA097_ZCULL_SYNC(&val, __data); \
}

#define VA_NVA097_ZCULL_SYNC V_NVA097_ZCULL_SYNC

#define P_NVA097_ZCULL_SYNC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_ZCULL_SYNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_ZCULL_SYNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_CLIP_ID_TEST(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_CLIP_ID_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_CLIP_ID_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_CLIP_ID_TEST __data = { .enable = (args) }; \
    __NVA097_SET_CLIP_ID_TEST(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID_TEST V_NVA097_SET_CLIP_ID_TEST

#define P_NVA097_SET_CLIP_ID_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_CLIP_ID_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_CLIP_ID_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SURFACE_CLIP_ID_WIDTH {
    uint32_t v;
};

static inline void
__NVA097_SET_SURFACE_CLIP_ID_WIDTH(uint32_t *val_out, struct nv_nva097_SET_SURFACE_CLIP_ID_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SURFACE_CLIP_ID_WIDTH(val, args...) { \
    struct nv_nva097_SET_SURFACE_CLIP_ID_WIDTH __data = { .v = (args) }; \
    __NVA097_SET_SURFACE_CLIP_ID_WIDTH(&val, __data); \
}

#define VA_NVA097_SET_SURFACE_CLIP_ID_WIDTH V_NVA097_SET_SURFACE_CLIP_ID_WIDTH

#define P_NVA097_SET_SURFACE_CLIP_ID_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SURFACE_CLIP_ID_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SURFACE_CLIP_ID_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CLIP_ID {
    uint32_t v;
};

static inline void
__NVA097_SET_CLIP_ID(uint32_t *val_out, struct nv_nva097_SET_CLIP_ID st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_CLIP_ID(val, args...) { \
    struct nv_nva097_SET_CLIP_ID __data = { .v = (args) }; \
    __NVA097_SET_CLIP_ID(&val, __data); \
}

#define VA_NVA097_SET_CLIP_ID V_NVA097_SET_CLIP_ID

#define P_NVA097_SET_CLIP_ID(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CLIP_ID(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CLIP_ID, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_DEPTH_BOUNDS_TEST {
    uint32_t enable;
};

static inline void
__NVA097_SET_DEPTH_BOUNDS_TEST(uint32_t *val_out, struct nv_nva097_SET_DEPTH_BOUNDS_TEST st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_DEPTH_BOUNDS_TEST(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_BOUNDS_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_BOUNDS_TEST_ENABLE_TRUE; \
    struct nv_nva097_SET_DEPTH_BOUNDS_TEST __data = { .enable = (args) }; \
    __NVA097_SET_DEPTH_BOUNDS_TEST(&val, __data); \
}

#define VA_NVA097_SET_DEPTH_BOUNDS_TEST V_NVA097_SET_DEPTH_BOUNDS_TEST

#define P_NVA097_SET_DEPTH_BOUNDS_TEST(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_DEPTH_BOUNDS_TEST_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_DEPTH_BOUNDS_TEST_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_DEPTH_BOUNDS_TEST(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_DEPTH_BOUNDS_TEST, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_FLOAT_OPTION {
    uint32_t zero_times_anything_is_zero;
};

static inline void
__NVA097_SET_BLEND_FLOAT_OPTION(uint32_t *val_out, struct nv_nva097_SET_BLEND_FLOAT_OPTION st)
{
    uint32_t val = 0;
    
    assert(st.zero_times_anything_is_zero < (1ULL << 1));
    val |= st.zero_times_anything_is_zero << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_FLOAT_OPTION(val, args...) { \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_FALSE = NVA097_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_TRUE = NVA097_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE; \
    struct nv_nva097_SET_BLEND_FLOAT_OPTION __data = { .zero_times_anything_is_zero = (args) }; \
    __NVA097_SET_BLEND_FLOAT_OPTION(&val, __data); \
}

#define VA_NVA097_SET_BLEND_FLOAT_OPTION V_NVA097_SET_BLEND_FLOAT_OPTION

#define P_NVA097_SET_BLEND_FLOAT_OPTION(push, args...) do { \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_FALSE = NVA097_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE; \
    UNUSED uint32_t ZERO_TIMES_ANYTHING_IS_ZERO_TRUE = NVA097_SET_BLEND_FLOAT_OPTION_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_FLOAT_OPTION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_FLOAT_OPTION, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LOGIC_OP {
    uint32_t enable;
};

static inline void
__NVA097_SET_LOGIC_OP(uint32_t *val_out, struct nv_nva097_SET_LOGIC_OP st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_LOGIC_OP(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LOGIC_OP_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LOGIC_OP_ENABLE_TRUE; \
    struct nv_nva097_SET_LOGIC_OP __data = { .enable = (args) }; \
    __NVA097_SET_LOGIC_OP(&val, __data); \
}

#define VA_NVA097_SET_LOGIC_OP V_NVA097_SET_LOGIC_OP

#define P_NVA097_SET_LOGIC_OP(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_LOGIC_OP_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_LOGIC_OP_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LOGIC_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LOGIC_OP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_LOGIC_OP_FUNC {
    uint32_t v;
};

static inline void
__NVA097_SET_LOGIC_OP_FUNC(uint32_t *val_out, struct nv_nva097_SET_LOGIC_OP_FUNC st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_LOGIC_OP_FUNC(val, args...) { \
    UNUSED uint32_t V_CLEAR = NVA097_SET_LOGIC_OP_FUNC_V_CLEAR; \
    UNUSED uint32_t V_AND = NVA097_SET_LOGIC_OP_FUNC_V_AND; \
    UNUSED uint32_t V_AND_REVERSE = NVA097_SET_LOGIC_OP_FUNC_V_AND_REVERSE; \
    UNUSED uint32_t V_COPY = NVA097_SET_LOGIC_OP_FUNC_V_COPY; \
    UNUSED uint32_t V_AND_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_AND_INVERTED; \
    UNUSED uint32_t V_NOOP = NVA097_SET_LOGIC_OP_FUNC_V_NOOP; \
    UNUSED uint32_t V_XOR = NVA097_SET_LOGIC_OP_FUNC_V_XOR; \
    UNUSED uint32_t V_OR = NVA097_SET_LOGIC_OP_FUNC_V_OR; \
    UNUSED uint32_t V_NOR = NVA097_SET_LOGIC_OP_FUNC_V_NOR; \
    UNUSED uint32_t V_EQUIV = NVA097_SET_LOGIC_OP_FUNC_V_EQUIV; \
    UNUSED uint32_t V_INVERT = NVA097_SET_LOGIC_OP_FUNC_V_INVERT; \
    UNUSED uint32_t V_OR_REVERSE = NVA097_SET_LOGIC_OP_FUNC_V_OR_REVERSE; \
    UNUSED uint32_t V_COPY_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_COPY_INVERTED; \
    UNUSED uint32_t V_OR_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_OR_INVERTED; \
    UNUSED uint32_t V_NAND = NVA097_SET_LOGIC_OP_FUNC_V_NAND; \
    UNUSED uint32_t V_SET = NVA097_SET_LOGIC_OP_FUNC_V_SET; \
    struct nv_nva097_SET_LOGIC_OP_FUNC __data = { .v = (args) }; \
    __NVA097_SET_LOGIC_OP_FUNC(&val, __data); \
}

#define VA_NVA097_SET_LOGIC_OP_FUNC V_NVA097_SET_LOGIC_OP_FUNC

#define P_NVA097_SET_LOGIC_OP_FUNC(push, args...) do { \
    UNUSED uint32_t V_CLEAR = NVA097_SET_LOGIC_OP_FUNC_V_CLEAR; \
    UNUSED uint32_t V_AND = NVA097_SET_LOGIC_OP_FUNC_V_AND; \
    UNUSED uint32_t V_AND_REVERSE = NVA097_SET_LOGIC_OP_FUNC_V_AND_REVERSE; \
    UNUSED uint32_t V_COPY = NVA097_SET_LOGIC_OP_FUNC_V_COPY; \
    UNUSED uint32_t V_AND_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_AND_INVERTED; \
    UNUSED uint32_t V_NOOP = NVA097_SET_LOGIC_OP_FUNC_V_NOOP; \
    UNUSED uint32_t V_XOR = NVA097_SET_LOGIC_OP_FUNC_V_XOR; \
    UNUSED uint32_t V_OR = NVA097_SET_LOGIC_OP_FUNC_V_OR; \
    UNUSED uint32_t V_NOR = NVA097_SET_LOGIC_OP_FUNC_V_NOR; \
    UNUSED uint32_t V_EQUIV = NVA097_SET_LOGIC_OP_FUNC_V_EQUIV; \
    UNUSED uint32_t V_INVERT = NVA097_SET_LOGIC_OP_FUNC_V_INVERT; \
    UNUSED uint32_t V_OR_REVERSE = NVA097_SET_LOGIC_OP_FUNC_V_OR_REVERSE; \
    UNUSED uint32_t V_COPY_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_COPY_INVERTED; \
    UNUSED uint32_t V_OR_INVERTED = NVA097_SET_LOGIC_OP_FUNC_V_OR_INVERTED; \
    UNUSED uint32_t V_NAND = NVA097_SET_LOGIC_OP_FUNC_V_NAND; \
    UNUSED uint32_t V_SET = NVA097_SET_LOGIC_OP_FUNC_V_SET; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_LOGIC_OP_FUNC(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_LOGIC_OP_FUNC, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_Z_COMPRESSION {
    uint32_t enable;
};

static inline void
__NVA097_SET_Z_COMPRESSION(uint32_t *val_out, struct nv_nva097_SET_Z_COMPRESSION st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_Z_COMPRESSION(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_Z_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_Z_COMPRESSION_ENABLE_TRUE; \
    struct nv_nva097_SET_Z_COMPRESSION __data = { .enable = (args) }; \
    __NVA097_SET_Z_COMPRESSION(&val, __data); \
}

#define VA_NVA097_SET_Z_COMPRESSION V_NVA097_SET_Z_COMPRESSION

#define P_NVA097_SET_Z_COMPRESSION(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_Z_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_Z_COMPRESSION_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_Z_COMPRESSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_Z_COMPRESSION, nvk_p_ret); \
} while(0)

struct nv_nva097_CLEAR_SURFACE {
    uint32_t z_enable;
    uint32_t stencil_enable;
    uint32_t r_enable;
    uint32_t g_enable;
    uint32_t b_enable;
    uint32_t a_enable;
    uint32_t mrt_select;
    uint32_t rt_array_index;
};

static inline void
__NVA097_CLEAR_SURFACE(uint32_t *val_out, struct nv_nva097_CLEAR_SURFACE st)
{
    uint32_t val = 0;
    
    assert(st.z_enable < (1ULL << 1));
    val |= st.z_enable << 0;
    
    assert(st.stencil_enable < (1ULL << 1));
    val |= st.stencil_enable << 1;
    
    assert(st.r_enable < (1ULL << 1));
    val |= st.r_enable << 2;
    
    assert(st.g_enable < (1ULL << 1));
    val |= st.g_enable << 3;
    
    assert(st.b_enable < (1ULL << 1));
    val |= st.b_enable << 4;
    
    assert(st.a_enable < (1ULL << 1));
    val |= st.a_enable << 5;
    
    assert(st.mrt_select < (1ULL << 4));
    val |= st.mrt_select << 6;
    
    assert(st.rt_array_index < (1ULL << 16));
    val |= st.rt_array_index << 10;
    *val_out = val;
}

#define V_NVA097_CLEAR_SURFACE(val, args...) { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_CLEAR_SURFACE_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_CLEAR_SURFACE_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_CLEAR_SURFACE_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_CLEAR_SURFACE_STENCIL_ENABLE_TRUE; \
    UNUSED uint32_t R_ENABLE_FALSE = NVA097_CLEAR_SURFACE_R_ENABLE_FALSE; \
    UNUSED uint32_t R_ENABLE_TRUE = NVA097_CLEAR_SURFACE_R_ENABLE_TRUE; \
    UNUSED uint32_t G_ENABLE_FALSE = NVA097_CLEAR_SURFACE_G_ENABLE_FALSE; \
    UNUSED uint32_t G_ENABLE_TRUE = NVA097_CLEAR_SURFACE_G_ENABLE_TRUE; \
    UNUSED uint32_t B_ENABLE_FALSE = NVA097_CLEAR_SURFACE_B_ENABLE_FALSE; \
    UNUSED uint32_t B_ENABLE_TRUE = NVA097_CLEAR_SURFACE_B_ENABLE_TRUE; \
    UNUSED uint32_t A_ENABLE_FALSE = NVA097_CLEAR_SURFACE_A_ENABLE_FALSE; \
    UNUSED uint32_t A_ENABLE_TRUE = NVA097_CLEAR_SURFACE_A_ENABLE_TRUE; \
    struct nv_nva097_CLEAR_SURFACE __data = args; \
    __NVA097_CLEAR_SURFACE(&val, __data); \
}

#define VA_NVA097_CLEAR_SURFACE V_NVA097_CLEAR_SURFACE

#define P_NVA097_CLEAR_SURFACE(push, args...) do { \
    UNUSED uint32_t Z_ENABLE_FALSE = NVA097_CLEAR_SURFACE_Z_ENABLE_FALSE; \
    UNUSED uint32_t Z_ENABLE_TRUE = NVA097_CLEAR_SURFACE_Z_ENABLE_TRUE; \
    UNUSED uint32_t STENCIL_ENABLE_FALSE = NVA097_CLEAR_SURFACE_STENCIL_ENABLE_FALSE; \
    UNUSED uint32_t STENCIL_ENABLE_TRUE = NVA097_CLEAR_SURFACE_STENCIL_ENABLE_TRUE; \
    UNUSED uint32_t R_ENABLE_FALSE = NVA097_CLEAR_SURFACE_R_ENABLE_FALSE; \
    UNUSED uint32_t R_ENABLE_TRUE = NVA097_CLEAR_SURFACE_R_ENABLE_TRUE; \
    UNUSED uint32_t G_ENABLE_FALSE = NVA097_CLEAR_SURFACE_G_ENABLE_FALSE; \
    UNUSED uint32_t G_ENABLE_TRUE = NVA097_CLEAR_SURFACE_G_ENABLE_TRUE; \
    UNUSED uint32_t B_ENABLE_FALSE = NVA097_CLEAR_SURFACE_B_ENABLE_FALSE; \
    UNUSED uint32_t B_ENABLE_TRUE = NVA097_CLEAR_SURFACE_B_ENABLE_TRUE; \
    UNUSED uint32_t A_ENABLE_FALSE = NVA097_CLEAR_SURFACE_A_ENABLE_FALSE; \
    UNUSED uint32_t A_ENABLE_TRUE = NVA097_CLEAR_SURFACE_A_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_CLEAR_SURFACE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CLEAR_SURFACE, nvk_p_ret); \
} while(0)

struct nv_nva097_CLEAR_CLIP_ID_SURFACE {
    uint32_t v;
};

static inline void
__NVA097_CLEAR_CLIP_ID_SURFACE(uint32_t *val_out, struct nv_nva097_CLEAR_CLIP_ID_SURFACE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_CLEAR_CLIP_ID_SURFACE(val, args...) { \
    struct nv_nva097_CLEAR_CLIP_ID_SURFACE __data = { .v = (args) }; \
    __NVA097_CLEAR_CLIP_ID_SURFACE(&val, __data); \
}

#define VA_NVA097_CLEAR_CLIP_ID_SURFACE V_NVA097_CLEAR_CLIP_ID_SURFACE

#define P_NVA097_CLEAR_CLIP_ID_SURFACE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CLEAR_CLIP_ID_SURFACE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CLEAR_CLIP_ID_SURFACE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_COMPRESSION {
    uint32_t enable;
};

static inline void
__NVA097_SET_COLOR_COMPRESSION(uint32_t *val_out, struct nv_nva097_SET_COLOR_COMPRESSION st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_COMPRESSION(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_COLOR_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_COLOR_COMPRESSION_ENABLE_TRUE; \
    struct nv_nva097_SET_COLOR_COMPRESSION __data = { .enable = (args) }; \
    __NVA097_SET_COLOR_COMPRESSION(&val, __data); \
}

#define VA_NVA097_SET_COLOR_COMPRESSION(i) V_NVA097_SET_COLOR_COMPRESSION

#define P_NVA097_SET_COLOR_COMPRESSION(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_COLOR_COMPRESSION_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_COLOR_COMPRESSION_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_COMPRESSION(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_COMPRESSION(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CT_WRITE {
    uint32_t r_enable;
    uint32_t g_enable;
    uint32_t b_enable;
    uint32_t a_enable;
};

static inline void
__NVA097_SET_CT_WRITE(uint32_t *val_out, struct nv_nva097_SET_CT_WRITE st)
{
    uint32_t val = 0;
    
    assert(st.r_enable < (1ULL << 1));
    val |= st.r_enable << 0;
    
    assert(st.g_enable < (1ULL << 1));
    val |= st.g_enable << 4;
    
    assert(st.b_enable < (1ULL << 1));
    val |= st.b_enable << 8;
    
    assert(st.a_enable < (1ULL << 1));
    val |= st.a_enable << 12;
    *val_out = val;
}

#define V_NVA097_SET_CT_WRITE(val, args...) { \
    UNUSED uint32_t R_ENABLE_FALSE = NVA097_SET_CT_WRITE_R_ENABLE_FALSE; \
    UNUSED uint32_t R_ENABLE_TRUE = NVA097_SET_CT_WRITE_R_ENABLE_TRUE; \
    UNUSED uint32_t G_ENABLE_FALSE = NVA097_SET_CT_WRITE_G_ENABLE_FALSE; \
    UNUSED uint32_t G_ENABLE_TRUE = NVA097_SET_CT_WRITE_G_ENABLE_TRUE; \
    UNUSED uint32_t B_ENABLE_FALSE = NVA097_SET_CT_WRITE_B_ENABLE_FALSE; \
    UNUSED uint32_t B_ENABLE_TRUE = NVA097_SET_CT_WRITE_B_ENABLE_TRUE; \
    UNUSED uint32_t A_ENABLE_FALSE = NVA097_SET_CT_WRITE_A_ENABLE_FALSE; \
    UNUSED uint32_t A_ENABLE_TRUE = NVA097_SET_CT_WRITE_A_ENABLE_TRUE; \
    struct nv_nva097_SET_CT_WRITE __data = args; \
    __NVA097_SET_CT_WRITE(&val, __data); \
}

#define VA_NVA097_SET_CT_WRITE(i) V_NVA097_SET_CT_WRITE

#define P_NVA097_SET_CT_WRITE(push, idx, args...) do { \
    UNUSED uint32_t R_ENABLE_FALSE = NVA097_SET_CT_WRITE_R_ENABLE_FALSE; \
    UNUSED uint32_t R_ENABLE_TRUE = NVA097_SET_CT_WRITE_R_ENABLE_TRUE; \
    UNUSED uint32_t G_ENABLE_FALSE = NVA097_SET_CT_WRITE_G_ENABLE_FALSE; \
    UNUSED uint32_t G_ENABLE_TRUE = NVA097_SET_CT_WRITE_G_ENABLE_TRUE; \
    UNUSED uint32_t B_ENABLE_FALSE = NVA097_SET_CT_WRITE_B_ENABLE_FALSE; \
    UNUSED uint32_t B_ENABLE_TRUE = NVA097_SET_CT_WRITE_B_ENABLE_TRUE; \
    UNUSED uint32_t A_ENABLE_FALSE = NVA097_SET_CT_WRITE_A_ENABLE_FALSE; \
    UNUSED uint32_t A_ENABLE_TRUE = NVA097_SET_CT_WRITE_A_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CT_WRITE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CT_WRITE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_PIPE_NOP {
    uint32_t v;
};

static inline void
__NVA097_PIPE_NOP(uint32_t *val_out, struct nv_nva097_PIPE_NOP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_PIPE_NOP(val, args...) { \
    struct nv_nva097_PIPE_NOP __data = { .v = (args) }; \
    __NVA097_PIPE_NOP(&val, __data); \
}

#define VA_NVA097_PIPE_NOP V_NVA097_PIPE_NOP

#define P_NVA097_PIPE_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_PIPE_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_PIPE_NOP, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE00 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE00(uint32_t *val_out, struct nv_nva097_SET_SPARE00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE00(val, args...) { \
    struct nv_nva097_SET_SPARE00 __data = { .v = (args) }; \
    __NVA097_SET_SPARE00(&val, __data); \
}

#define VA_NVA097_SET_SPARE00 V_NVA097_SET_SPARE00

#define P_NVA097_SET_SPARE00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE00(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE00, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE01 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE01(uint32_t *val_out, struct nv_nva097_SET_SPARE01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE01(val, args...) { \
    struct nv_nva097_SET_SPARE01 __data = { .v = (args) }; \
    __NVA097_SET_SPARE01(&val, __data); \
}

#define VA_NVA097_SET_SPARE01 V_NVA097_SET_SPARE01

#define P_NVA097_SET_SPARE01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE01(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE01, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE02 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE02(uint32_t *val_out, struct nv_nva097_SET_SPARE02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE02(val, args...) { \
    struct nv_nva097_SET_SPARE02 __data = { .v = (args) }; \
    __NVA097_SET_SPARE02(&val, __data); \
}

#define VA_NVA097_SET_SPARE02 V_NVA097_SET_SPARE02

#define P_NVA097_SET_SPARE02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE02(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE02, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SPARE03 {
    uint32_t v;
};

static inline void
__NVA097_SET_SPARE03(uint32_t *val_out, struct nv_nva097_SET_SPARE03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SPARE03(val, args...) { \
    struct nv_nva097_SET_SPARE03 __data = { .v = (args) }; \
    __NVA097_SET_SPARE03(&val, __data); \
}

#define VA_NVA097_SET_SPARE03 V_NVA097_SET_SPARE03

#define P_NVA097_SET_SPARE03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SPARE03(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SPARE03, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REPORT_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_REPORT_SEMAPHORE_A(uint32_t *val_out, struct nv_nva097_SET_REPORT_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_REPORT_SEMAPHORE_A(val, args...) { \
    struct nv_nva097_SET_REPORT_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_REPORT_SEMAPHORE_A(&val, __data); \
}

#define VA_NVA097_SET_REPORT_SEMAPHORE_A V_NVA097_SET_REPORT_SEMAPHORE_A

#define P_NVA097_SET_REPORT_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REPORT_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REPORT_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REPORT_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_REPORT_SEMAPHORE_B(uint32_t *val_out, struct nv_nva097_SET_REPORT_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_REPORT_SEMAPHORE_B(val, args...) { \
    struct nv_nva097_SET_REPORT_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_REPORT_SEMAPHORE_B(&val, __data); \
}

#define VA_NVA097_SET_REPORT_SEMAPHORE_B V_NVA097_SET_REPORT_SEMAPHORE_B

#define P_NVA097_SET_REPORT_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REPORT_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REPORT_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REPORT_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVA097_SET_REPORT_SEMAPHORE_C(uint32_t *val_out, struct nv_nva097_SET_REPORT_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA097_SET_REPORT_SEMAPHORE_C(val, args...) { \
    struct nv_nva097_SET_REPORT_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVA097_SET_REPORT_SEMAPHORE_C(&val, __data); \
}

#define VA_NVA097_SET_REPORT_SEMAPHORE_C V_NVA097_SET_REPORT_SEMAPHORE_C

#define P_NVA097_SET_REPORT_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REPORT_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REPORT_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_REPORT_SEMAPHORE_D {
    uint32_t operation;
    uint32_t release;
    uint32_t acquire;
    uint32_t pipeline_location;
    uint32_t comparison;
    uint32_t awaken_enable;
    uint32_t report;
    uint32_t structure_size;
    uint32_t sub_report;
    uint32_t report_dword_number;
    uint32_t flush_disable;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
};

static inline void
__NVA097_SET_REPORT_SEMAPHORE_D(uint32_t *val_out, struct nv_nva097_SET_REPORT_SEMAPHORE_D st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 0;
    
    assert(st.release < (1ULL << 1));
    val |= st.release << 4;
    
    assert(st.acquire < (1ULL << 1));
    val |= st.acquire << 8;
    
    assert(st.pipeline_location < (1ULL << 4));
    val |= st.pipeline_location << 12;
    
    assert(st.comparison < (1ULL << 1));
    val |= st.comparison << 16;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 20;
    
    assert(st.report < (1ULL << 5));
    val |= st.report << 23;
    
    assert(st.structure_size < (1ULL << 1));
    val |= st.structure_size << 28;
    
    assert(st.sub_report < (1ULL << 3));
    val |= st.sub_report << 5;
    
    assert(st.report_dword_number < (1ULL << 1));
    val |= st.report_dword_number << 21;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 2;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 3;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 9;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 17;
    *val_out = val;
}

#define V_NVA097_SET_REPORT_SEMAPHORE_D(val, args...) { \
    UNUSED uint32_t OPERATION_RELEASE = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_REPORT_ONLY = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY; \
    UNUSED uint32_t OPERATION_TRAP = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE = NVA097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE; \
    UNUSED uint32_t RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE = NVA097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE; \
    UNUSED uint32_t ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START = NVA097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START; \
    UNUSED uint32_t ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START = NVA097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START; \
    UNUSED uint32_t PIPELINE_LOCATION_NONE = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE; \
    UNUSED uint32_t PIPELINE_LOCATION_DATA_ASSEMBLER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER; \
    UNUSED uint32_t PIPELINE_LOCATION_VERTEX_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_TESSELATION_INIT_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_TESSELATION_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_GEOMETRY_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_STREAMING_OUTPUT = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT; \
    UNUSED uint32_t PIPELINE_LOCATION_VPC = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC; \
    UNUSED uint32_t PIPELINE_LOCATION_ZCULL = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL; \
    UNUSED uint32_t PIPELINE_LOCATION_PIXEL_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_DEPTH_TEST = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST; \
    UNUSED uint32_t PIPELINE_LOCATION_ALL = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL; \
    UNUSED uint32_t COMPARISON_EQ = NVA097_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ; \
    UNUSED uint32_t COMPARISON_GE = NVA097_SET_REPORT_SEMAPHORE_D_COMPARISON_GE; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t REPORT_NONE = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_NONE; \
    UNUSED uint32_t REPORT_DA_VERTICES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED; \
    UNUSED uint32_t REPORT_DA_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_VS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS; \
    UNUSED uint32_t REPORT_TI_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS; \
    UNUSED uint32_t REPORT_TS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS; \
    UNUSED uint32_t REPORT_TS_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_GS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS; \
    UNUSED uint32_t REPORT_GS_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_ALPHA_BETA_CLOCKS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS; \
    UNUSED uint32_t REPORT_VTG_PRIMITIVES_OUT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT; \
    UNUSED uint32_t REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_NEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_BYTE_COUNT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT; \
    UNUSED uint32_t REPORT_CLIPPER_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS; \
    UNUSED uint32_t REPORT_CLIPPER_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_ZCULL_STATS0 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0; \
    UNUSED uint32_t REPORT_ZCULL_STATS1 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1; \
    UNUSED uint32_t REPORT_ZCULL_STATS2 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2; \
    UNUSED uint32_t REPORT_ZCULL_STATS3 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3; \
    UNUSED uint32_t REPORT_PS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS; \
    UNUSED uint32_t REPORT_ZPASS_PIXEL_CNT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT; \
    UNUSED uint32_t REPORT_ZPASS_PIXEL_CNT64 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64; \
    UNUSED uint32_t REPORT_IEEE_CLEAN_COLOR_TARGET = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET; \
    UNUSED uint32_t REPORT_IEEE_CLEAN_ZETA_TARGET = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET; \
    UNUSED uint32_t REPORT_BOUNDING_RECTANGLE = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NVA097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NVA097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32; \
    struct nv_nva097_SET_REPORT_SEMAPHORE_D __data = args; \
    __NVA097_SET_REPORT_SEMAPHORE_D(&val, __data); \
}

#define VA_NVA097_SET_REPORT_SEMAPHORE_D V_NVA097_SET_REPORT_SEMAPHORE_D

#define P_NVA097_SET_REPORT_SEMAPHORE_D(push, args...) do { \
    UNUSED uint32_t OPERATION_RELEASE = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_REPORT_ONLY = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_REPORT_ONLY; \
    UNUSED uint32_t OPERATION_TRAP = NVA097_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE = NVA097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_READS_COMPLETE; \
    UNUSED uint32_t RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE = NVA097_SET_REPORT_SEMAPHORE_D_RELEASE_AFTER_ALL_PRECEEDING_WRITES_COMPLETE; \
    UNUSED uint32_t ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START = NVA097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_WRITES_START; \
    UNUSED uint32_t ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START = NVA097_SET_REPORT_SEMAPHORE_D_ACQUIRE_BEFORE_ANY_FOLLOWING_READS_START; \
    UNUSED uint32_t PIPELINE_LOCATION_NONE = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_NONE; \
    UNUSED uint32_t PIPELINE_LOCATION_DATA_ASSEMBLER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DATA_ASSEMBLER; \
    UNUSED uint32_t PIPELINE_LOCATION_VERTEX_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VERTEX_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_TESSELATION_INIT_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_INIT_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_TESSELATION_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_TESSELATION_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_GEOMETRY_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_GEOMETRY_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_STREAMING_OUTPUT = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_STREAMING_OUTPUT; \
    UNUSED uint32_t PIPELINE_LOCATION_VPC = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_VPC; \
    UNUSED uint32_t PIPELINE_LOCATION_ZCULL = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ZCULL; \
    UNUSED uint32_t PIPELINE_LOCATION_PIXEL_SHADER = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_PIXEL_SHADER; \
    UNUSED uint32_t PIPELINE_LOCATION_DEPTH_TEST = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_DEPTH_TEST; \
    UNUSED uint32_t PIPELINE_LOCATION_ALL = NVA097_SET_REPORT_SEMAPHORE_D_PIPELINE_LOCATION_ALL; \
    UNUSED uint32_t COMPARISON_EQ = NVA097_SET_REPORT_SEMAPHORE_D_COMPARISON_EQ; \
    UNUSED uint32_t COMPARISON_GE = NVA097_SET_REPORT_SEMAPHORE_D_COMPARISON_GE; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t REPORT_NONE = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_NONE; \
    UNUSED uint32_t REPORT_DA_VERTICES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_DA_VERTICES_GENERATED; \
    UNUSED uint32_t REPORT_DA_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_DA_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_VS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_VS_INVOCATIONS; \
    UNUSED uint32_t REPORT_TI_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TI_INVOCATIONS; \
    UNUSED uint32_t REPORT_TS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TS_INVOCATIONS; \
    UNUSED uint32_t REPORT_TS_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_GS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_GS_INVOCATIONS; \
    UNUSED uint32_t REPORT_GS_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_GS_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_ALPHA_BETA_CLOCKS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ALPHA_BETA_CLOCKS; \
    UNUSED uint32_t REPORT_VTG_PRIMITIVES_OUT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_VTG_PRIMITIVES_OUT; \
    UNUSED uint32_t REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_TOTAL_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_NEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED; \
    UNUSED uint32_t REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_PRIMITIVES_NEEDED_MINUS_SUCCEEDED; \
    UNUSED uint32_t REPORT_STREAMING_BYTE_COUNT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_STREAMING_BYTE_COUNT; \
    UNUSED uint32_t REPORT_CLIPPER_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_INVOCATIONS; \
    UNUSED uint32_t REPORT_CLIPPER_PRIMITIVES_GENERATED = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_CLIPPER_PRIMITIVES_GENERATED; \
    UNUSED uint32_t REPORT_ZCULL_STATS0 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS0; \
    UNUSED uint32_t REPORT_ZCULL_STATS1 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS1; \
    UNUSED uint32_t REPORT_ZCULL_STATS2 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS2; \
    UNUSED uint32_t REPORT_ZCULL_STATS3 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZCULL_STATS3; \
    UNUSED uint32_t REPORT_PS_INVOCATIONS = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_PS_INVOCATIONS; \
    UNUSED uint32_t REPORT_ZPASS_PIXEL_CNT = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT; \
    UNUSED uint32_t REPORT_ZPASS_PIXEL_CNT64 = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_ZPASS_PIXEL_CNT64; \
    UNUSED uint32_t REPORT_IEEE_CLEAN_COLOR_TARGET = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_COLOR_TARGET; \
    UNUSED uint32_t REPORT_IEEE_CLEAN_ZETA_TARGET = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_IEEE_CLEAN_ZETA_TARGET; \
    UNUSED uint32_t REPORT_BOUNDING_RECTANGLE = NVA097_SET_REPORT_SEMAPHORE_D_REPORT_BOUNDING_RECTANGLE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NVA097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NVA097_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVA097_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_REPORT_SEMAPHORE_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_REPORT_SEMAPHORE_D, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_A_FORMAT {
    uint32_t stride;
    uint32_t enable;
};

static inline void
__NVA097_SET_VERTEX_STREAM_A_FORMAT(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_A_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.stride < (1ULL << 12));
    val |= st.stride << 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 12;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_A_FORMAT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_STREAM_A_FORMAT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_STREAM_A_FORMAT_ENABLE_TRUE; \
    struct nv_nva097_SET_VERTEX_STREAM_A_FORMAT __data = args; \
    __NVA097_SET_VERTEX_STREAM_A_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_A_FORMAT(i) V_NVA097_SET_VERTEX_STREAM_A_FORMAT

#define P_NVA097_SET_VERTEX_STREAM_A_FORMAT(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_STREAM_A_FORMAT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_STREAM_A_FORMAT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_A_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_A_FORMAT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_VERTEX_STREAM_A_LOCATION_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_A_LOCATION_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_VERTEX_STREAM_A_LOCATION_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_A_LOCATION_A(i) V_NVA097_SET_VERTEX_STREAM_A_LOCATION_A

#define P_NVA097_SET_VERTEX_STREAM_A_LOCATION_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_A_LOCATION_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_A_LOCATION_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_VERTEX_STREAM_A_LOCATION_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_A_LOCATION_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_A_LOCATION_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_VERTEX_STREAM_A_LOCATION_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_A_LOCATION_B(i) V_NVA097_SET_VERTEX_STREAM_A_LOCATION_B

#define P_NVA097_SET_VERTEX_STREAM_A_LOCATION_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_A_LOCATION_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_A_LOCATION_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_A_FREQUENCY {
    uint32_t v;
};

static inline void
__NVA097_SET_VERTEX_STREAM_A_FREQUENCY(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_A_FREQUENCY st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_A_FREQUENCY(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_A_FREQUENCY __data = { .v = (args) }; \
    __NVA097_SET_VERTEX_STREAM_A_FREQUENCY(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_A_FREQUENCY(i) V_NVA097_SET_VERTEX_STREAM_A_FREQUENCY

#define P_NVA097_SET_VERTEX_STREAM_A_FREQUENCY(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_A_FREQUENCY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_A_FREQUENCY(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_B_FORMAT {
    uint32_t stride;
    uint32_t enable;
};

static inline void
__NVA097_SET_VERTEX_STREAM_B_FORMAT(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_B_FORMAT st)
{
    uint32_t val = 0;
    
    assert(st.stride < (1ULL << 12));
    val |= st.stride << 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 12;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_B_FORMAT(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_STREAM_B_FORMAT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_STREAM_B_FORMAT_ENABLE_TRUE; \
    struct nv_nva097_SET_VERTEX_STREAM_B_FORMAT __data = args; \
    __NVA097_SET_VERTEX_STREAM_B_FORMAT(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_B_FORMAT(i) V_NVA097_SET_VERTEX_STREAM_B_FORMAT

#define P_NVA097_SET_VERTEX_STREAM_B_FORMAT(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_VERTEX_STREAM_B_FORMAT_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_VERTEX_STREAM_B_FORMAT_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_B_FORMAT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_B_FORMAT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_A {
    uint32_t offset_upper;
};

static inline void
__NVA097_SET_VERTEX_STREAM_B_LOCATION_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_B_LOCATION_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_A __data = { .offset_upper = (args) }; \
    __NVA097_SET_VERTEX_STREAM_B_LOCATION_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_B_LOCATION_A(i) V_NVA097_SET_VERTEX_STREAM_B_LOCATION_A

#define P_NVA097_SET_VERTEX_STREAM_B_LOCATION_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_B_LOCATION_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_B_LOCATION_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_B {
    uint32_t offset_lower;
};

static inline void
__NVA097_SET_VERTEX_STREAM_B_LOCATION_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_B_LOCATION_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_B_LOCATION_B __data = { .offset_lower = (args) }; \
    __NVA097_SET_VERTEX_STREAM_B_LOCATION_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_B_LOCATION_B(i) V_NVA097_SET_VERTEX_STREAM_B_LOCATION_B

#define P_NVA097_SET_VERTEX_STREAM_B_LOCATION_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_B_LOCATION_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_B_LOCATION_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_B_FREQUENCY {
    uint32_t v;
};

static inline void
__NVA097_SET_VERTEX_STREAM_B_FREQUENCY(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_B_FREQUENCY st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_B_FREQUENCY(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_B_FREQUENCY __data = { .v = (args) }; \
    __NVA097_SET_VERTEX_STREAM_B_FREQUENCY(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_B_FREQUENCY(i) V_NVA097_SET_VERTEX_STREAM_B_FREQUENCY

#define P_NVA097_SET_VERTEX_STREAM_B_FREQUENCY(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_B_FREQUENCY(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_B_FREQUENCY(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA {
    uint32_t enable;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_TRUE; \
    struct nv_nva097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA __data = { .enable = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(i) V_NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA

#define P_NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_SEPARATE_FOR_ALPHA(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_OP {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_COLOR_OP(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_OP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_COLOR_OP(val, args...) { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MAX; \
    struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_OP __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_COLOR_OP(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_COLOR_OP(i) V_NVA097_SET_BLEND_PER_TARGET_COLOR_OP

#define P_NVA097_SET_BLEND_PER_TARGET_COLOR_OP(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_PER_TARGET_COLOR_OP_V_D3D_MAX; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_COLOR_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_COLOR_OP(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(i) V_NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF

#define P_NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_COLOR_SOURCE_COEFF(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(i) V_NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF

#define P_NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_COLOR_DEST_COEFF(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_OP {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_OP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(val, args...) { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MAX; \
    struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_OP __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(i) V_NVA097_SET_BLEND_PER_TARGET_ALPHA_OP

#define P_NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_FUNC_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_REVERSE_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_REVERSE_SUBTRACT; \
    UNUSED uint32_t V_OGL_FUNC_ADD = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_FUNC_ADD; \
    UNUSED uint32_t V_OGL_MIN = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MIN; \
    UNUSED uint32_t V_OGL_MAX = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_OGL_MAX; \
    UNUSED uint32_t V_D3D_ADD = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_ADD; \
    UNUSED uint32_t V_D3D_SUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_SUBTRACT; \
    UNUSED uint32_t V_D3D_REVSUBTRACT = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_REVSUBTRACT; \
    UNUSED uint32_t V_D3D_MIN = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MIN; \
    UNUSED uint32_t V_D3D_MAX = NVA097_SET_BLEND_PER_TARGET_ALPHA_OP_V_D3D_MAX; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_ALPHA_OP(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(i) V_NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF

#define P_NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BOTHSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHSRCALPHA; \
    UNUSED uint32_t V_D3D_BOTHINVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BOTHINVSRCALPHA; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_ALPHA_SOURCE_COEFF(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF {
    uint32_t v;
};

static inline void
__NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(uint32_t *val_out, struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(val, args...) { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    struct nv_nva097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF __data = { .v = (args) }; \
    __NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(&val, __data); \
}

#define VA_NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(i) V_NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF

#define P_NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(push, idx, args...) do { \
    UNUSED uint32_t V_OGL_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ZERO; \
    UNUSED uint32_t V_OGL_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE; \
    UNUSED uint32_t V_OGL_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_SRC_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_SRC_ALPHA; \
    UNUSED uint32_t V_OGL_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_ALPHA; \
    UNUSED uint32_t V_OGL_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_DST_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_DST_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_DST_COLOR; \
    UNUSED uint32_t V_OGL_SRC_ALPHA_SATURATE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC_ALPHA_SATURATE; \
    UNUSED uint32_t V_OGL_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_COLOR; \
    UNUSED uint32_t V_OGL_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_ONE_MINUS_CONSTANT_ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_ONE_MINUS_CONSTANT_ALPHA; \
    UNUSED uint32_t V_OGL_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1COLOR; \
    UNUSED uint32_t V_OGL_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1COLOR; \
    UNUSED uint32_t V_OGL_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_SRC1ALPHA; \
    UNUSED uint32_t V_OGL_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_OGL_INVSRC1ALPHA; \
    UNUSED uint32_t V_D3D_ZERO = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ZERO; \
    UNUSED uint32_t V_D3D_ONE = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_ONE; \
    UNUSED uint32_t V_D3D_SRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCCOLOR; \
    UNUSED uint32_t V_D3D_INVSRCCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHA; \
    UNUSED uint32_t V_D3D_INVSRCALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRCALPHA; \
    UNUSED uint32_t V_D3D_DESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTALPHA; \
    UNUSED uint32_t V_D3D_INVDESTALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTALPHA; \
    UNUSED uint32_t V_D3D_DESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_DESTCOLOR; \
    UNUSED uint32_t V_D3D_INVDESTCOLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVDESTCOLOR; \
    UNUSED uint32_t V_D3D_SRCALPHASAT = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRCALPHASAT; \
    UNUSED uint32_t V_D3D_BLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_BLENDFACTOR; \
    UNUSED uint32_t V_D3D_INVBLENDFACTOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVBLENDFACTOR; \
    UNUSED uint32_t V_D3D_SRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1COLOR; \
    UNUSED uint32_t V_D3D_INVSRC1COLOR = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1COLOR; \
    UNUSED uint32_t V_D3D_SRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_SRC1ALPHA; \
    UNUSED uint32_t V_D3D_INVSRC1ALPHA = NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF_V_D3D_INVSRC1ALPHA; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BLEND_PER_TARGET_ALPHA_DEST_COEFF(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_A {
    uint32_t upper;
};

static inline void
__NVA097_SET_VERTEX_STREAM_LIMIT_A_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_LIMIT_A_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_A __data = { .upper = (args) }; \
    __NVA097_SET_VERTEX_STREAM_LIMIT_A_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_LIMIT_A_A(i) V_NVA097_SET_VERTEX_STREAM_LIMIT_A_A

#define P_NVA097_SET_VERTEX_STREAM_LIMIT_A_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_LIMIT_A_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_LIMIT_A_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_B {
    uint32_t lower;
};

static inline void
__NVA097_SET_VERTEX_STREAM_LIMIT_A_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_LIMIT_A_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_LIMIT_A_B __data = { .lower = (args) }; \
    __NVA097_SET_VERTEX_STREAM_LIMIT_A_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_LIMIT_A_B(i) V_NVA097_SET_VERTEX_STREAM_LIMIT_A_B

#define P_NVA097_SET_VERTEX_STREAM_LIMIT_A_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_LIMIT_A_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_LIMIT_A_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_A {
    uint32_t upper;
};

static inline void
__NVA097_SET_VERTEX_STREAM_LIMIT_B_A(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_LIMIT_B_A(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_A __data = { .upper = (args) }; \
    __NVA097_SET_VERTEX_STREAM_LIMIT_B_A(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_LIMIT_B_A(i) V_NVA097_SET_VERTEX_STREAM_LIMIT_B_A

#define P_NVA097_SET_VERTEX_STREAM_LIMIT_B_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_LIMIT_B_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_LIMIT_B_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_B {
    uint32_t lower;
};

static inline void
__NVA097_SET_VERTEX_STREAM_LIMIT_B_B(uint32_t *val_out, struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVA097_SET_VERTEX_STREAM_LIMIT_B_B(val, args...) { \
    struct nv_nva097_SET_VERTEX_STREAM_LIMIT_B_B __data = { .lower = (args) }; \
    __NVA097_SET_VERTEX_STREAM_LIMIT_B_B(&val, __data); \
}

#define VA_NVA097_SET_VERTEX_STREAM_LIMIT_B_B(i) V_NVA097_SET_VERTEX_STREAM_LIMIT_B_B

#define P_NVA097_SET_VERTEX_STREAM_LIMIT_B_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_VERTEX_STREAM_LIMIT_B_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_VERTEX_STREAM_LIMIT_B_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_SHADER {
    uint32_t enable;
    uint32_t type;
};

static inline void
__NVA097_SET_PIPELINE_SHADER(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_SHADER st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    
    assert(st.type < (1ULL << 4));
    val |= st.type << 4;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_SHADER(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_PIPELINE_SHADER_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_PIPELINE_SHADER_ENABLE_TRUE; \
    UNUSED uint32_t TYPE_VERTEX_CULL_BEFORE_FETCH = NVA097_SET_PIPELINE_SHADER_TYPE_VERTEX_CULL_BEFORE_FETCH; \
    UNUSED uint32_t TYPE_VERTEX = NVA097_SET_PIPELINE_SHADER_TYPE_VERTEX; \
    UNUSED uint32_t TYPE_TESSELLATION_INIT = NVA097_SET_PIPELINE_SHADER_TYPE_TESSELLATION_INIT; \
    UNUSED uint32_t TYPE_TESSELLATION = NVA097_SET_PIPELINE_SHADER_TYPE_TESSELLATION; \
    UNUSED uint32_t TYPE_GEOMETRY = NVA097_SET_PIPELINE_SHADER_TYPE_GEOMETRY; \
    UNUSED uint32_t TYPE_PIXEL = NVA097_SET_PIPELINE_SHADER_TYPE_PIXEL; \
    struct nv_nva097_SET_PIPELINE_SHADER __data = args; \
    __NVA097_SET_PIPELINE_SHADER(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_SHADER(i) V_NVA097_SET_PIPELINE_SHADER

#define P_NVA097_SET_PIPELINE_SHADER(push, idx, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_PIPELINE_SHADER_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_PIPELINE_SHADER_ENABLE_TRUE; \
    UNUSED uint32_t TYPE_VERTEX_CULL_BEFORE_FETCH = NVA097_SET_PIPELINE_SHADER_TYPE_VERTEX_CULL_BEFORE_FETCH; \
    UNUSED uint32_t TYPE_VERTEX = NVA097_SET_PIPELINE_SHADER_TYPE_VERTEX; \
    UNUSED uint32_t TYPE_TESSELLATION_INIT = NVA097_SET_PIPELINE_SHADER_TYPE_TESSELLATION_INIT; \
    UNUSED uint32_t TYPE_TESSELLATION = NVA097_SET_PIPELINE_SHADER_TYPE_TESSELLATION; \
    UNUSED uint32_t TYPE_GEOMETRY = NVA097_SET_PIPELINE_SHADER_TYPE_GEOMETRY; \
    UNUSED uint32_t TYPE_PIXEL = NVA097_SET_PIPELINE_SHADER_TYPE_PIXEL; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_SHADER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_SHADER(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_PROGRAM {
    uint32_t offset;
};

static inline void
__NVA097_SET_PIPELINE_PROGRAM(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_PROGRAM st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_PROGRAM(val, args...) { \
    struct nv_nva097_SET_PIPELINE_PROGRAM __data = { .offset = (args) }; \
    __NVA097_SET_PIPELINE_PROGRAM(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_PROGRAM(i) V_NVA097_SET_PIPELINE_PROGRAM

#define P_NVA097_SET_PIPELINE_PROGRAM(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_PROGRAM(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_PROGRAM(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_RESERVED_A {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_RESERVED_A(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_RESERVED_A st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_RESERVED_A(val, args...) { \
    struct nv_nva097_SET_PIPELINE_RESERVED_A __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_RESERVED_A(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_RESERVED_A(i) V_NVA097_SET_PIPELINE_RESERVED_A

#define P_NVA097_SET_PIPELINE_RESERVED_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_RESERVED_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_RESERVED_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_REGISTER_COUNT {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_REGISTER_COUNT(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_REGISTER_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_REGISTER_COUNT(val, args...) { \
    struct nv_nva097_SET_PIPELINE_REGISTER_COUNT __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_REGISTER_COUNT(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_REGISTER_COUNT(i) V_NVA097_SET_PIPELINE_REGISTER_COUNT

#define P_NVA097_SET_PIPELINE_REGISTER_COUNT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_REGISTER_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_REGISTER_COUNT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_BINDING {
    uint32_t group;
};

static inline void
__NVA097_SET_PIPELINE_BINDING(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_BINDING st)
{
    uint32_t val = 0;
    
    assert(st.group < (1ULL << 3));
    val |= st.group << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_BINDING(val, args...) { \
    struct nv_nva097_SET_PIPELINE_BINDING __data = { .group = (args) }; \
    __NVA097_SET_PIPELINE_BINDING(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_BINDING(i) V_NVA097_SET_PIPELINE_BINDING

#define P_NVA097_SET_PIPELINE_BINDING(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_BINDING(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_BINDING(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_RESERVED_B {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_RESERVED_B(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_RESERVED_B st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_RESERVED_B(val, args...) { \
    struct nv_nva097_SET_PIPELINE_RESERVED_B __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_RESERVED_B(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_RESERVED_B(i) V_NVA097_SET_PIPELINE_RESERVED_B

#define P_NVA097_SET_PIPELINE_RESERVED_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_RESERVED_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_RESERVED_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_RESERVED_C {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_RESERVED_C(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_RESERVED_C st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_RESERVED_C(val, args...) { \
    struct nv_nva097_SET_PIPELINE_RESERVED_C __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_RESERVED_C(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_RESERVED_C(i) V_NVA097_SET_PIPELINE_RESERVED_C

#define P_NVA097_SET_PIPELINE_RESERVED_C(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_RESERVED_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_RESERVED_C(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_RESERVED_D {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_RESERVED_D(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_RESERVED_D st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_RESERVED_D(val, args...) { \
    struct nv_nva097_SET_PIPELINE_RESERVED_D __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_RESERVED_D(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_RESERVED_D(i) V_NVA097_SET_PIPELINE_RESERVED_D

#define P_NVA097_SET_PIPELINE_RESERVED_D(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_RESERVED_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_RESERVED_D(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_PIPELINE_RESERVED_E {
    uint32_t v;
};

static inline void
__NVA097_SET_PIPELINE_RESERVED_E(uint32_t *val_out, struct nv_nva097_SET_PIPELINE_RESERVED_E st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_SET_PIPELINE_RESERVED_E(val, args...) { \
    struct nv_nva097_SET_PIPELINE_RESERVED_E __data = { .v = (args) }; \
    __NVA097_SET_PIPELINE_RESERVED_E(&val, __data); \
}

#define VA_NVA097_SET_PIPELINE_RESERVED_E(i) V_NVA097_SET_PIPELINE_RESERVED_E

#define P_NVA097_SET_PIPELINE_RESERVED_E(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_PIPELINE_RESERVED_E(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_PIPELINE_RESERVED_E(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON00 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON00(uint32_t *val_out, struct nv_nva097_SET_FALCON00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON00(val, args...) { \
    struct nv_nva097_SET_FALCON00 __data = { .v = (args) }; \
    __NVA097_SET_FALCON00(&val, __data); \
}

#define VA_NVA097_SET_FALCON00 V_NVA097_SET_FALCON00

#define P_NVA097_SET_FALCON00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON00(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON00, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON01 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON01(uint32_t *val_out, struct nv_nva097_SET_FALCON01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON01(val, args...) { \
    struct nv_nva097_SET_FALCON01 __data = { .v = (args) }; \
    __NVA097_SET_FALCON01(&val, __data); \
}

#define VA_NVA097_SET_FALCON01 V_NVA097_SET_FALCON01

#define P_NVA097_SET_FALCON01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON01(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON01, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON02 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON02(uint32_t *val_out, struct nv_nva097_SET_FALCON02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON02(val, args...) { \
    struct nv_nva097_SET_FALCON02 __data = { .v = (args) }; \
    __NVA097_SET_FALCON02(&val, __data); \
}

#define VA_NVA097_SET_FALCON02 V_NVA097_SET_FALCON02

#define P_NVA097_SET_FALCON02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON02(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON02, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON03 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON03(uint32_t *val_out, struct nv_nva097_SET_FALCON03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON03(val, args...) { \
    struct nv_nva097_SET_FALCON03 __data = { .v = (args) }; \
    __NVA097_SET_FALCON03(&val, __data); \
}

#define VA_NVA097_SET_FALCON03 V_NVA097_SET_FALCON03

#define P_NVA097_SET_FALCON03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON03(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON03, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON04 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON04(uint32_t *val_out, struct nv_nva097_SET_FALCON04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON04(val, args...) { \
    struct nv_nva097_SET_FALCON04 __data = { .v = (args) }; \
    __NVA097_SET_FALCON04(&val, __data); \
}

#define VA_NVA097_SET_FALCON04 V_NVA097_SET_FALCON04

#define P_NVA097_SET_FALCON04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON04(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON04, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON05 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON05(uint32_t *val_out, struct nv_nva097_SET_FALCON05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON05(val, args...) { \
    struct nv_nva097_SET_FALCON05 __data = { .v = (args) }; \
    __NVA097_SET_FALCON05(&val, __data); \
}

#define VA_NVA097_SET_FALCON05 V_NVA097_SET_FALCON05

#define P_NVA097_SET_FALCON05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON05(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON05, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON06 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON06(uint32_t *val_out, struct nv_nva097_SET_FALCON06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON06(val, args...) { \
    struct nv_nva097_SET_FALCON06 __data = { .v = (args) }; \
    __NVA097_SET_FALCON06(&val, __data); \
}

#define VA_NVA097_SET_FALCON06 V_NVA097_SET_FALCON06

#define P_NVA097_SET_FALCON06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON06(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON06, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON07 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON07(uint32_t *val_out, struct nv_nva097_SET_FALCON07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON07(val, args...) { \
    struct nv_nva097_SET_FALCON07 __data = { .v = (args) }; \
    __NVA097_SET_FALCON07(&val, __data); \
}

#define VA_NVA097_SET_FALCON07 V_NVA097_SET_FALCON07

#define P_NVA097_SET_FALCON07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON07(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON07, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON08 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON08(uint32_t *val_out, struct nv_nva097_SET_FALCON08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON08(val, args...) { \
    struct nv_nva097_SET_FALCON08 __data = { .v = (args) }; \
    __NVA097_SET_FALCON08(&val, __data); \
}

#define VA_NVA097_SET_FALCON08 V_NVA097_SET_FALCON08

#define P_NVA097_SET_FALCON08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON08(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON08, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON09 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON09(uint32_t *val_out, struct nv_nva097_SET_FALCON09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON09(val, args...) { \
    struct nv_nva097_SET_FALCON09 __data = { .v = (args) }; \
    __NVA097_SET_FALCON09(&val, __data); \
}

#define VA_NVA097_SET_FALCON09 V_NVA097_SET_FALCON09

#define P_NVA097_SET_FALCON09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON09(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON09, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON10 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON10(uint32_t *val_out, struct nv_nva097_SET_FALCON10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON10(val, args...) { \
    struct nv_nva097_SET_FALCON10 __data = { .v = (args) }; \
    __NVA097_SET_FALCON10(&val, __data); \
}

#define VA_NVA097_SET_FALCON10 V_NVA097_SET_FALCON10

#define P_NVA097_SET_FALCON10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON10(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON10, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON11 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON11(uint32_t *val_out, struct nv_nva097_SET_FALCON11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON11(val, args...) { \
    struct nv_nva097_SET_FALCON11 __data = { .v = (args) }; \
    __NVA097_SET_FALCON11(&val, __data); \
}

#define VA_NVA097_SET_FALCON11 V_NVA097_SET_FALCON11

#define P_NVA097_SET_FALCON11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON11(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON11, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON12 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON12(uint32_t *val_out, struct nv_nva097_SET_FALCON12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON12(val, args...) { \
    struct nv_nva097_SET_FALCON12 __data = { .v = (args) }; \
    __NVA097_SET_FALCON12(&val, __data); \
}

#define VA_NVA097_SET_FALCON12 V_NVA097_SET_FALCON12

#define P_NVA097_SET_FALCON12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON12(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON12, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON13 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON13(uint32_t *val_out, struct nv_nva097_SET_FALCON13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON13(val, args...) { \
    struct nv_nva097_SET_FALCON13 __data = { .v = (args) }; \
    __NVA097_SET_FALCON13(&val, __data); \
}

#define VA_NVA097_SET_FALCON13 V_NVA097_SET_FALCON13

#define P_NVA097_SET_FALCON13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON13(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON13, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON14 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON14(uint32_t *val_out, struct nv_nva097_SET_FALCON14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON14(val, args...) { \
    struct nv_nva097_SET_FALCON14 __data = { .v = (args) }; \
    __NVA097_SET_FALCON14(&val, __data); \
}

#define VA_NVA097_SET_FALCON14 V_NVA097_SET_FALCON14

#define P_NVA097_SET_FALCON14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON14(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON14, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON15 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON15(uint32_t *val_out, struct nv_nva097_SET_FALCON15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON15(val, args...) { \
    struct nv_nva097_SET_FALCON15 __data = { .v = (args) }; \
    __NVA097_SET_FALCON15(&val, __data); \
}

#define VA_NVA097_SET_FALCON15 V_NVA097_SET_FALCON15

#define P_NVA097_SET_FALCON15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON15(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON15, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON16 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON16(uint32_t *val_out, struct nv_nva097_SET_FALCON16 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON16(val, args...) { \
    struct nv_nva097_SET_FALCON16 __data = { .v = (args) }; \
    __NVA097_SET_FALCON16(&val, __data); \
}

#define VA_NVA097_SET_FALCON16 V_NVA097_SET_FALCON16

#define P_NVA097_SET_FALCON16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON16(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON16, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON17 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON17(uint32_t *val_out, struct nv_nva097_SET_FALCON17 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON17(val, args...) { \
    struct nv_nva097_SET_FALCON17 __data = { .v = (args) }; \
    __NVA097_SET_FALCON17(&val, __data); \
}

#define VA_NVA097_SET_FALCON17 V_NVA097_SET_FALCON17

#define P_NVA097_SET_FALCON17(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON17(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON17, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON18 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON18(uint32_t *val_out, struct nv_nva097_SET_FALCON18 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON18(val, args...) { \
    struct nv_nva097_SET_FALCON18 __data = { .v = (args) }; \
    __NVA097_SET_FALCON18(&val, __data); \
}

#define VA_NVA097_SET_FALCON18 V_NVA097_SET_FALCON18

#define P_NVA097_SET_FALCON18(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON18(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON18, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON19 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON19(uint32_t *val_out, struct nv_nva097_SET_FALCON19 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON19(val, args...) { \
    struct nv_nva097_SET_FALCON19 __data = { .v = (args) }; \
    __NVA097_SET_FALCON19(&val, __data); \
}

#define VA_NVA097_SET_FALCON19 V_NVA097_SET_FALCON19

#define P_NVA097_SET_FALCON19(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON19(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON19, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON20 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON20(uint32_t *val_out, struct nv_nva097_SET_FALCON20 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON20(val, args...) { \
    struct nv_nva097_SET_FALCON20 __data = { .v = (args) }; \
    __NVA097_SET_FALCON20(&val, __data); \
}

#define VA_NVA097_SET_FALCON20 V_NVA097_SET_FALCON20

#define P_NVA097_SET_FALCON20(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON20(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON20, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON21 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON21(uint32_t *val_out, struct nv_nva097_SET_FALCON21 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON21(val, args...) { \
    struct nv_nva097_SET_FALCON21 __data = { .v = (args) }; \
    __NVA097_SET_FALCON21(&val, __data); \
}

#define VA_NVA097_SET_FALCON21 V_NVA097_SET_FALCON21

#define P_NVA097_SET_FALCON21(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON21(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON21, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON22 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON22(uint32_t *val_out, struct nv_nva097_SET_FALCON22 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON22(val, args...) { \
    struct nv_nva097_SET_FALCON22 __data = { .v = (args) }; \
    __NVA097_SET_FALCON22(&val, __data); \
}

#define VA_NVA097_SET_FALCON22 V_NVA097_SET_FALCON22

#define P_NVA097_SET_FALCON22(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON22(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON22, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON23 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON23(uint32_t *val_out, struct nv_nva097_SET_FALCON23 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON23(val, args...) { \
    struct nv_nva097_SET_FALCON23 __data = { .v = (args) }; \
    __NVA097_SET_FALCON23(&val, __data); \
}

#define VA_NVA097_SET_FALCON23 V_NVA097_SET_FALCON23

#define P_NVA097_SET_FALCON23(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON23(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON23, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON24 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON24(uint32_t *val_out, struct nv_nva097_SET_FALCON24 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON24(val, args...) { \
    struct nv_nva097_SET_FALCON24 __data = { .v = (args) }; \
    __NVA097_SET_FALCON24(&val, __data); \
}

#define VA_NVA097_SET_FALCON24 V_NVA097_SET_FALCON24

#define P_NVA097_SET_FALCON24(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON24(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON24, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON25 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON25(uint32_t *val_out, struct nv_nva097_SET_FALCON25 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON25(val, args...) { \
    struct nv_nva097_SET_FALCON25 __data = { .v = (args) }; \
    __NVA097_SET_FALCON25(&val, __data); \
}

#define VA_NVA097_SET_FALCON25 V_NVA097_SET_FALCON25

#define P_NVA097_SET_FALCON25(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON25(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON25, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON26 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON26(uint32_t *val_out, struct nv_nva097_SET_FALCON26 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON26(val, args...) { \
    struct nv_nva097_SET_FALCON26 __data = { .v = (args) }; \
    __NVA097_SET_FALCON26(&val, __data); \
}

#define VA_NVA097_SET_FALCON26 V_NVA097_SET_FALCON26

#define P_NVA097_SET_FALCON26(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON26(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON26, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON27 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON27(uint32_t *val_out, struct nv_nva097_SET_FALCON27 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON27(val, args...) { \
    struct nv_nva097_SET_FALCON27 __data = { .v = (args) }; \
    __NVA097_SET_FALCON27(&val, __data); \
}

#define VA_NVA097_SET_FALCON27 V_NVA097_SET_FALCON27

#define P_NVA097_SET_FALCON27(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON27(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON27, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON28 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON28(uint32_t *val_out, struct nv_nva097_SET_FALCON28 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON28(val, args...) { \
    struct nv_nva097_SET_FALCON28 __data = { .v = (args) }; \
    __NVA097_SET_FALCON28(&val, __data); \
}

#define VA_NVA097_SET_FALCON28 V_NVA097_SET_FALCON28

#define P_NVA097_SET_FALCON28(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON28(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON28, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON29 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON29(uint32_t *val_out, struct nv_nva097_SET_FALCON29 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON29(val, args...) { \
    struct nv_nva097_SET_FALCON29 __data = { .v = (args) }; \
    __NVA097_SET_FALCON29(&val, __data); \
}

#define VA_NVA097_SET_FALCON29 V_NVA097_SET_FALCON29

#define P_NVA097_SET_FALCON29(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON29(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON29, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON30 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON30(uint32_t *val_out, struct nv_nva097_SET_FALCON30 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON30(val, args...) { \
    struct nv_nva097_SET_FALCON30 __data = { .v = (args) }; \
    __NVA097_SET_FALCON30(&val, __data); \
}

#define VA_NVA097_SET_FALCON30 V_NVA097_SET_FALCON30

#define P_NVA097_SET_FALCON30(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON30(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON30, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_FALCON31 {
    uint32_t v;
};

static inline void
__NVA097_SET_FALCON31(uint32_t *val_out, struct nv_nva097_SET_FALCON31 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_FALCON31(val, args...) { \
    struct nv_nva097_SET_FALCON31 __data = { .v = (args) }; \
    __NVA097_SET_FALCON31(&val, __data); \
}

#define VA_NVA097_SET_FALCON31 V_NVA097_SET_FALCON31

#define P_NVA097_SET_FALCON31(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_FALCON31(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_FALCON31, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_A {
    uint32_t size;
};

static inline void
__NVA097_SET_CONSTANT_BUFFER_SELECTOR_A(uint32_t *val_out, struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_A st)
{
    uint32_t val = 0;
    
    assert(st.size < (1ULL << 17));
    val |= st.size << 0;
    *val_out = val;
}

#define V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_A(val, args...) { \
    struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_A __data = { .size = (args) }; \
    __NVA097_SET_CONSTANT_BUFFER_SELECTOR_A(&val, __data); \
}

#define VA_NVA097_SET_CONSTANT_BUFFER_SELECTOR_A V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_A

#define P_NVA097_SET_CONSTANT_BUFFER_SELECTOR_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CONSTANT_BUFFER_SELECTOR_A, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_B {
    uint32_t address_upper;
};

static inline void
__NVA097_SET_CONSTANT_BUFFER_SELECTOR_B(uint32_t *val_out, struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_B st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_B(val, args...) { \
    struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_B __data = { .address_upper = (args) }; \
    __NVA097_SET_CONSTANT_BUFFER_SELECTOR_B(&val, __data); \
}

#define VA_NVA097_SET_CONSTANT_BUFFER_SELECTOR_B V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_B

#define P_NVA097_SET_CONSTANT_BUFFER_SELECTOR_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CONSTANT_BUFFER_SELECTOR_B, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_C {
    uint32_t address_lower;
};

static inline void
__NVA097_SET_CONSTANT_BUFFER_SELECTOR_C(uint32_t *val_out, struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_C st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_C(val, args...) { \
    struct nv_nva097_SET_CONSTANT_BUFFER_SELECTOR_C __data = { .address_lower = (args) }; \
    __NVA097_SET_CONSTANT_BUFFER_SELECTOR_C(&val, __data); \
}

#define VA_NVA097_SET_CONSTANT_BUFFER_SELECTOR_C V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_C

#define P_NVA097_SET_CONSTANT_BUFFER_SELECTOR_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_CONSTANT_BUFFER_SELECTOR_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_CONSTANT_BUFFER_SELECTOR_C, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_CONSTANT_BUFFER_OFFSET {
    uint32_t v;
};

static inline void
__NVA097_LOAD_CONSTANT_BUFFER_OFFSET(uint32_t *val_out, struct nv_nva097_LOAD_CONSTANT_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 16));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_LOAD_CONSTANT_BUFFER_OFFSET(val, args...) { \
    struct nv_nva097_LOAD_CONSTANT_BUFFER_OFFSET __data = { .v = (args) }; \
    __NVA097_LOAD_CONSTANT_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVA097_LOAD_CONSTANT_BUFFER_OFFSET V_NVA097_LOAD_CONSTANT_BUFFER_OFFSET

#define P_NVA097_LOAD_CONSTANT_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_CONSTANT_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_CONSTANT_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nva097_LOAD_CONSTANT_BUFFER {
    uint32_t v;
};

static inline void
__NVA097_LOAD_CONSTANT_BUFFER(uint32_t *val_out, struct nv_nva097_LOAD_CONSTANT_BUFFER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_LOAD_CONSTANT_BUFFER(val, args...) { \
    struct nv_nva097_LOAD_CONSTANT_BUFFER __data = { .v = (args) }; \
    __NVA097_LOAD_CONSTANT_BUFFER(&val, __data); \
}

#define VA_NVA097_LOAD_CONSTANT_BUFFER(i) V_NVA097_LOAD_CONSTANT_BUFFER

#define P_NVA097_LOAD_CONSTANT_BUFFER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_LOAD_CONSTANT_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_LOAD_CONSTANT_BUFFER(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_BIND_GROUP_RESERVED_A {
    uint32_t v;
};

static inline void
__NVA097_BIND_GROUP_RESERVED_A(uint32_t *val_out, struct nv_nva097_BIND_GROUP_RESERVED_A st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_BIND_GROUP_RESERVED_A(val, args...) { \
    struct nv_nva097_BIND_GROUP_RESERVED_A __data = { .v = (args) }; \
    __NVA097_BIND_GROUP_RESERVED_A(&val, __data); \
}

#define VA_NVA097_BIND_GROUP_RESERVED_A(i) V_NVA097_BIND_GROUP_RESERVED_A

#define P_NVA097_BIND_GROUP_RESERVED_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_BIND_GROUP_RESERVED_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BIND_GROUP_RESERVED_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_BIND_GROUP_RESERVED_B {
    uint32_t v;
};

static inline void
__NVA097_BIND_GROUP_RESERVED_B(uint32_t *val_out, struct nv_nva097_BIND_GROUP_RESERVED_B st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_BIND_GROUP_RESERVED_B(val, args...) { \
    struct nv_nva097_BIND_GROUP_RESERVED_B __data = { .v = (args) }; \
    __NVA097_BIND_GROUP_RESERVED_B(&val, __data); \
}

#define VA_NVA097_BIND_GROUP_RESERVED_B(i) V_NVA097_BIND_GROUP_RESERVED_B

#define P_NVA097_BIND_GROUP_RESERVED_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_BIND_GROUP_RESERVED_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BIND_GROUP_RESERVED_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_BIND_GROUP_RESERVED_C {
    uint32_t v;
};

static inline void
__NVA097_BIND_GROUP_RESERVED_C(uint32_t *val_out, struct nv_nva097_BIND_GROUP_RESERVED_C st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_BIND_GROUP_RESERVED_C(val, args...) { \
    struct nv_nva097_BIND_GROUP_RESERVED_C __data = { .v = (args) }; \
    __NVA097_BIND_GROUP_RESERVED_C(&val, __data); \
}

#define VA_NVA097_BIND_GROUP_RESERVED_C(i) V_NVA097_BIND_GROUP_RESERVED_C

#define P_NVA097_BIND_GROUP_RESERVED_C(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_BIND_GROUP_RESERVED_C(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BIND_GROUP_RESERVED_C(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_BIND_GROUP_RESERVED_D {
    uint32_t v;
};

static inline void
__NVA097_BIND_GROUP_RESERVED_D(uint32_t *val_out, struct nv_nva097_BIND_GROUP_RESERVED_D st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVA097_BIND_GROUP_RESERVED_D(val, args...) { \
    struct nv_nva097_BIND_GROUP_RESERVED_D __data = { .v = (args) }; \
    __NVA097_BIND_GROUP_RESERVED_D(&val, __data); \
}

#define VA_NVA097_BIND_GROUP_RESERVED_D(i) V_NVA097_BIND_GROUP_RESERVED_D

#define P_NVA097_BIND_GROUP_RESERVED_D(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_BIND_GROUP_RESERVED_D(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BIND_GROUP_RESERVED_D(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_BIND_GROUP_CONSTANT_BUFFER {
    uint32_t valid;
    uint32_t shader_slot;
};

static inline void
__NVA097_BIND_GROUP_CONSTANT_BUFFER(uint32_t *val_out, struct nv_nva097_BIND_GROUP_CONSTANT_BUFFER st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.shader_slot < (1ULL << 5));
    val |= st.shader_slot << 4;
    *val_out = val;
}

#define V_NVA097_BIND_GROUP_CONSTANT_BUFFER(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NVA097_BIND_GROUP_CONSTANT_BUFFER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NVA097_BIND_GROUP_CONSTANT_BUFFER_VALID_TRUE; \
    struct nv_nva097_BIND_GROUP_CONSTANT_BUFFER __data = args; \
    __NVA097_BIND_GROUP_CONSTANT_BUFFER(&val, __data); \
}

#define VA_NVA097_BIND_GROUP_CONSTANT_BUFFER(i) V_NVA097_BIND_GROUP_CONSTANT_BUFFER

#define P_NVA097_BIND_GROUP_CONSTANT_BUFFER(push, idx, args...) do { \
    UNUSED uint32_t VALID_FALSE = NVA097_BIND_GROUP_CONSTANT_BUFFER_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NVA097_BIND_GROUP_CONSTANT_BUFFER_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_BIND_GROUP_CONSTANT_BUFFER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_BIND_GROUP_CONSTANT_BUFFER(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_COLOR_CLAMP {
    uint32_t enable;
};

static inline void
__NVA097_SET_COLOR_CLAMP(uint32_t *val_out, struct nv_nva097_SET_COLOR_CLAMP st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVA097_SET_COLOR_CLAMP(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_COLOR_CLAMP_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_COLOR_CLAMP_ENABLE_TRUE; \
    struct nv_nva097_SET_COLOR_CLAMP __data = { .enable = (args) }; \
    __NVA097_SET_COLOR_CLAMP(&val, __data); \
}

#define VA_NVA097_SET_COLOR_CLAMP V_NVA097_SET_COLOR_CLAMP

#define P_NVA097_SET_COLOR_CLAMP(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVA097_SET_COLOR_CLAMP_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVA097_SET_COLOR_CLAMP_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_COLOR_CLAMP(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_COLOR_CLAMP, nvk_p_ret); \
} while(0)

struct nv_nva097_NOOP_X_X_X_SET_VALVE {
    uint32_t higher_priority;
};

static inline void
__NVA097_NOOP_X_X_X_SET_VALVE(uint32_t *val_out, struct nv_nva097_NOOP_X_X_X_SET_VALVE st)
{
    uint32_t val = 0;
    
    assert(st.higher_priority < (1ULL << 1));
    val |= st.higher_priority << 0;
    *val_out = val;
}

#define V_NVA097_NOOP_X_X_X_SET_VALVE(val, args...) { \
    UNUSED uint32_t HIGHER_PRIORITY_COMPUTE = NVA097_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_COMPUTE; \
    UNUSED uint32_t HIGHER_PRIORITY_GRAPHICS = NVA097_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_GRAPHICS; \
    struct nv_nva097_NOOP_X_X_X_SET_VALVE __data = { .higher_priority = (args) }; \
    __NVA097_NOOP_X_X_X_SET_VALVE(&val, __data); \
}

#define VA_NVA097_NOOP_X_X_X_SET_VALVE V_NVA097_NOOP_X_X_X_SET_VALVE

#define P_NVA097_NOOP_X_X_X_SET_VALVE(push, args...) do { \
    UNUSED uint32_t HIGHER_PRIORITY_COMPUTE = NVA097_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_COMPUTE; \
    UNUSED uint32_t HIGHER_PRIORITY_GRAPHICS = NVA097_NOOP_X_X_X_SET_VALVE_HIGHER_PRIORITY_GRAPHICS; \
    uint32_t nvk_p_ret; \
    V_NVA097_NOOP_X_X_X_SET_VALVE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_NOOP_X_X_X_SET_VALVE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_BINDLESS_TEXTURE {
    uint32_t constant_buffer_slot_select;
};

static inline void
__NVA097_SET_BINDLESS_TEXTURE(uint32_t *val_out, struct nv_nva097_SET_BINDLESS_TEXTURE st)
{
    uint32_t val = 0;
    
    assert(st.constant_buffer_slot_select < (1ULL << 5));
    val |= st.constant_buffer_slot_select << 0;
    *val_out = val;
}

#define V_NVA097_SET_BINDLESS_TEXTURE(val, args...) { \
    struct nv_nva097_SET_BINDLESS_TEXTURE __data = { .constant_buffer_slot_select = (args) }; \
    __NVA097_SET_BINDLESS_TEXTURE(&val, __data); \
}

#define VA_NVA097_SET_BINDLESS_TEXTURE V_NVA097_SET_BINDLESS_TEXTURE

#define P_NVA097_SET_BINDLESS_TEXTURE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_BINDLESS_TEXTURE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_BINDLESS_TEXTURE, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_TRAP_HANDLER {
    uint32_t offset;
};

static inline void
__NVA097_SET_TRAP_HANDLER(uint32_t *val_out, struct nv_nva097_SET_TRAP_HANDLER st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVA097_SET_TRAP_HANDLER(val, args...) { \
    struct nv_nva097_SET_TRAP_HANDLER __data = { .offset = (args) }; \
    __NVA097_SET_TRAP_HANDLER(&val, __data); \
}

#define VA_NVA097_SET_TRAP_HANDLER V_NVA097_SET_TRAP_HANDLER

#define P_NVA097_SET_TRAP_HANDLER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_TRAP_HANDLER(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_TRAP_HANDLER, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_VALUE {
    uint32_t v;
};

static inline void
__NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(uint32_t *val_out, struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(val, args...) { \
    struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_VALUE __data = { .v = (args) }; \
    __NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(&val, __data); \
}

#define VA_NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(i) V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE

#define P_NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_PERFORMANCE_COUNTER_VALUE(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_EVENT {
    uint32_t event;
};

static inline void
__NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(uint32_t *val_out, struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_EVENT st)
{
    uint32_t val = 0;
    
    assert(st.event < (1ULL << 8));
    val |= st.event << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(val, args...) { \
    struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_EVENT __data = { .event = (args) }; \
    __NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(&val, __data); \
}

#define VA_NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(i) V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT

#define P_NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_PERFORMANCE_COUNTER_EVENT(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A {
    uint32_t event0;
    uint32_t bit_select0;
    uint32_t event1;
    uint32_t bit_select1;
    uint32_t event2;
    uint32_t bit_select2;
    uint32_t event3;
    uint32_t bit_select3;
    uint32_t event4;
    uint32_t bit_select4;
    uint32_t event5;
    uint32_t bit_select5;
    uint32_t spare;
};

static inline void
__NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(uint32_t *val_out, struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A st)
{
    uint32_t val = 0;
    
    assert(st.event0 < (1ULL << 2));
    val |= st.event0 << 0;
    
    assert(st.bit_select0 < (1ULL << 3));
    val |= st.bit_select0 << 2;
    
    assert(st.event1 < (1ULL << 2));
    val |= st.event1 << 5;
    
    assert(st.bit_select1 < (1ULL << 3));
    val |= st.bit_select1 << 7;
    
    assert(st.event2 < (1ULL << 2));
    val |= st.event2 << 10;
    
    assert(st.bit_select2 < (1ULL << 3));
    val |= st.bit_select2 << 12;
    
    assert(st.event3 < (1ULL << 2));
    val |= st.event3 << 15;
    
    assert(st.bit_select3 < (1ULL << 3));
    val |= st.bit_select3 << 17;
    
    assert(st.event4 < (1ULL << 2));
    val |= st.event4 << 20;
    
    assert(st.bit_select4 < (1ULL << 3));
    val |= st.bit_select4 << 22;
    
    assert(st.event5 < (1ULL << 2));
    val |= st.event5 << 25;
    
    assert(st.bit_select5 < (1ULL << 3));
    val |= st.bit_select5 << 27;
    
    assert(st.spare < (1ULL << 2));
    val |= st.spare << 30;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(val, args...) { \
    struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A __data = args; \
    __NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(&val, __data); \
}

#define VA_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(i) V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A

#define P_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B {
    uint32_t edge;
    uint32_t mode;
    uint32_t windowed;
    uint32_t func;
};

static inline void
__NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(uint32_t *val_out, struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B st)
{
    uint32_t val = 0;
    
    assert(st.edge < (1ULL << 1));
    val |= st.edge << 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 1;
    
    assert(st.windowed < (1ULL << 1));
    val |= st.windowed << 3;
    
    assert(st.func < (1ULL << 16));
    val |= st.func << 4;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(val, args...) { \
    struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B __data = args; \
    __NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(&val, __data); \
}

#define VA_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(i) V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B

#define P_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL {
    uint32_t mask;
};

static inline void
__NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(uint32_t *val_out, struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mask < (1ULL << 8));
    val |= st.mask << 0;
    *val_out = val;
}

#define V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(val, args...) { \
    struct nv_nva097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL __data = { .mask = (args) }; \
    __NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(&val, __data); \
}

#define VA_NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL

#define P_NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nva097_SET_MME_SHADOW_SCRATCH {
    uint32_t v;
};

static inline void
__NVA097_SET_MME_SHADOW_SCRATCH(uint32_t *val_out, struct nv_nva097_SET_MME_SHADOW_SCRATCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_SET_MME_SHADOW_SCRATCH(val, args...) { \
    struct nv_nva097_SET_MME_SHADOW_SCRATCH __data = { .v = (args) }; \
    __NVA097_SET_MME_SHADOW_SCRATCH(&val, __data); \
}

#define VA_NVA097_SET_MME_SHADOW_SCRATCH(i) V_NVA097_SET_MME_SHADOW_SCRATCH

#define P_NVA097_SET_MME_SHADOW_SCRATCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_SET_MME_SHADOW_SCRATCH(nvk_p_ret, args); \
    nv_push_val(push, NVA097_SET_MME_SHADOW_SCRATCH(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_CALL_MME_MACRO {
    uint32_t v;
};

static inline void
__NVA097_CALL_MME_MACRO(uint32_t *val_out, struct nv_nva097_CALL_MME_MACRO st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_CALL_MME_MACRO(val, args...) { \
    struct nv_nva097_CALL_MME_MACRO __data = { .v = (args) }; \
    __NVA097_CALL_MME_MACRO(&val, __data); \
}

#define VA_NVA097_CALL_MME_MACRO(i) V_NVA097_CALL_MME_MACRO

#define P_NVA097_CALL_MME_MACRO(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CALL_MME_MACRO(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CALL_MME_MACRO(idx), nvk_p_ret); \
} while(0)

struct nv_nva097_CALL_MME_DATA {
    uint32_t v;
};

static inline void
__NVA097_CALL_MME_DATA(uint32_t *val_out, struct nv_nva097_CALL_MME_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVA097_CALL_MME_DATA(val, args...) { \
    struct nv_nva097_CALL_MME_DATA __data = { .v = (args) }; \
    __NVA097_CALL_MME_DATA(&val, __data); \
}

#define VA_NVA097_CALL_MME_DATA(i) V_NVA097_CALL_MME_DATA

#define P_NVA097_CALL_MME_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA097_CALL_MME_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVA097_CALL_MME_DATA(idx), nvk_p_ret); \
} while(0)


const char *P_PARSE_NVA097_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA097_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
