/* idle-monitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from idle-monitor.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include "X11/extensions/sync.h"
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_IDLE_MONITOR (idle_monitor_get_type ())
#define IDLE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDLE_MONITOR, IdleMonitor))
#define IDLE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDLE_MONITOR, IdleMonitorClass))
#define IS_IDLE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDLE_MONITOR))
#define IS_IDLE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDLE_MONITOR))
#define IDLE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDLE_MONITOR, IdleMonitorClass))

typedef struct _IdleMonitor IdleMonitor;
typedef struct _IdleMonitorClass IdleMonitorClass;
typedef void (*IdleMonitorWatchFunc) (IdleMonitor* monitor, guint id, gpointer user_data);
typedef struct _IdleMonitorPrivate IdleMonitorPrivate;

#define TYPE_IDLE_MONITOR_WATCH (idle_monitor_watch_get_type ())
#define IDLE_MONITOR_WATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDLE_MONITOR_WATCH, IdleMonitorWatch))
#define IDLE_MONITOR_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDLE_MONITOR_WATCH, IdleMonitorWatchClass))
#define IS_IDLE_MONITOR_WATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDLE_MONITOR_WATCH))
#define IS_IDLE_MONITOR_WATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDLE_MONITOR_WATCH))
#define IDLE_MONITOR_WATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDLE_MONITOR_WATCH, IdleMonitorWatchClass))

typedef struct _IdleMonitorWatch IdleMonitorWatch;
typedef struct _IdleMonitorWatchClass IdleMonitorWatchClass;
typedef struct _IdleMonitorWatchPrivate IdleMonitorWatchPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _idle_monitor_watch_unref0(var) ((var == NULL) ? NULL : (var = (idle_monitor_watch_unref (var), NULL)))
typedef struct _ParamSpecIdleMonitor ParamSpecIdleMonitor;
typedef struct _ParamSpecIdleMonitorWatch ParamSpecIdleMonitorWatch;

struct _IdleMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdleMonitorPrivate * priv;
};

struct _IdleMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (IdleMonitor *self);
};

struct _IdleMonitorPrivate {
	Display* display;
	GHashTable* watches;
	GHashTable* alarms;
	gint sync_event_base;
	XID counter;
	XID user_active_alarm;
	gint serial;
};

struct _IdleMonitorWatch {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdleMonitorWatchPrivate * priv;
	guint id;
	IdleMonitorWatchFunc callback;
	gpointer callback_target;
	XID xalarm;
};

struct _IdleMonitorWatchClass {
	GTypeClass parent_class;
	void (*finalize) (IdleMonitorWatch *self);
};

struct _ParamSpecIdleMonitor {
	GParamSpec parent_instance;
};

struct _ParamSpecIdleMonitorWatch {
	GParamSpec parent_instance;
};

static gint IdleMonitor_private_offset;
static gpointer idle_monitor_parent_class = NULL;
static gpointer idle_monitor_watch_parent_class = NULL;

VALA_EXTERN gpointer idle_monitor_ref (gpointer instance);
VALA_EXTERN void idle_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_idle_monitor (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_idle_monitor (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_idle_monitor (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_idle_monitor (const GValue* value);
VALA_EXTERN GType idle_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IdleMonitor, idle_monitor_unref)
VALA_EXTERN gpointer idle_monitor_watch_ref (gpointer instance);
VALA_EXTERN void idle_monitor_watch_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_idle_monitor_watch (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_idle_monitor_watch (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_idle_monitor_watch (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_idle_monitor_watch (const GValue* value);
VALA_EXTERN GType idle_monitor_watch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IdleMonitorWatch, idle_monitor_watch_unref)
VALA_EXTERN void idle_monitor_remove_watch (IdleMonitor* self,
                                guint id);
static GdkFilterReturn idle_monitor_xevent_filter (IdleMonitor* self,
                                            GdkXEvent* xevent,
                                            GdkEvent* event);
static GdkFilterReturn _idle_monitor_xevent_filter_gdk_filter_func (GdkXEvent* xevent,
                                                             GdkEvent* event,
                                                             gpointer self);
VALA_EXTERN IdleMonitor* idle_monitor_new (void);
VALA_EXTERN IdleMonitor* idle_monitor_construct (GType object_type);
static void _idle_monitor_watch_unref0_ (gpointer var);
static void idle_monitor_init_xsync (IdleMonitor* self);
VALA_EXTERN guint idle_monitor_add_idle_watch (IdleMonitor* self,
                                   guint64 interval_msec,
                                   IdleMonitorWatchFunc callback,
                                   gpointer callback_target);
static IdleMonitorWatch* idle_monitor_make_watch (IdleMonitor* self,
                                           XID xalarm,
                                           IdleMonitorWatchFunc callback,
                                           gpointer callback_target);
static XID idle_monitor_xsync_alarm_set (IdleMonitor* self,
                                  XSyncTestType test_type,
                                  guint64 interval,
                                  gboolean want_events);
VALA_EXTERN guint idle_monitor_add_user_active_watch (IdleMonitor* self,
                                          IdleMonitorWatchFunc callback,
                                          gpointer callback_target);
static void idle_monitor_set_alarm_enabled (IdleMonitor* self,
                                     Display* dpy,
                                     XID alarm,
                                     gboolean enabled);
static XID idle_monitor_find_idletime_counter (IdleMonitor* self);
static void idle_monitor_handle_alarm_notify_event (IdleMonitor* self,
                                             XSyncAlarmNotifyEvent* alarm_event);
VALA_EXTERN IdleMonitorWatch* idle_monitor_watch_new (void);
VALA_EXTERN IdleMonitorWatch* idle_monitor_watch_construct (GType object_type);
static guint32 idle_monitor_get_next_watch_serial (IdleMonitor* self);
static void idle_monitor_ensure_alarm_rescheduled (IdleMonitor* self,
                                            Display* dpy,
                                            XID alarm);
static void idle_monitor_fire_watch (IdleMonitor* self,
                              IdleMonitorWatch* watch,
                              XID alarm);
static void idle_monitor_finalize (IdleMonitor * obj);
static GType idle_monitor_get_type_once (void);
static void idle_monitor_watch_finalize (IdleMonitorWatch * obj);
static GType idle_monitor_watch_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
idle_monitor_get_instance_private (IdleMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, IdleMonitor_private_offset);
}

static GdkFilterReturn
_idle_monitor_xevent_filter_gdk_filter_func (GdkXEvent* xevent,
                                             GdkEvent* event,
                                             gpointer self)
{
	GdkFilterReturn result;
	result = idle_monitor_xevent_filter ((IdleMonitor*) self, xevent, event);
#line 29 "../src/idle-monitor.vala"
	return result;
#line 205 "idle-monitor.c"
}

static void
_idle_monitor_watch_unref0_ (gpointer var)
{
#line 15 "../src/idle-monitor.vala"
	(var == NULL) ? NULL : (var = (idle_monitor_watch_unref (var), NULL));
#line 213 "idle-monitor.c"
}

IdleMonitor*
idle_monitor_construct (GType object_type)
{
	IdleMonitor* self = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
#line 13 "../src/idle-monitor.vala"
	self = (IdleMonitor*) g_type_create_instance (object_type);
#line 15 "../src/idle-monitor.vala"
	_tmp0_ = g_hash_table_new_full (NULL, NULL, NULL, _idle_monitor_watch_unref0_);
#line 15 "../src/idle-monitor.vala"
	_g_hash_table_unref0 (self->priv->watches);
#line 15 "../src/idle-monitor.vala"
	self->priv->watches = _tmp0_;
#line 16 "../src/idle-monitor.vala"
	_tmp1_ = g_hash_table_new_full (NULL, NULL, NULL, NULL);
#line 16 "../src/idle-monitor.vala"
	_g_hash_table_unref0 (self->priv->alarms);
#line 16 "../src/idle-monitor.vala"
	self->priv->alarms = _tmp1_;
#line 17 "../src/idle-monitor.vala"
	idle_monitor_init_xsync (self);
#line 13 "../src/idle-monitor.vala"
	return self;
#line 240 "idle-monitor.c"
}

IdleMonitor*
idle_monitor_new (void)
{
#line 13 "../src/idle-monitor.vala"
	return idle_monitor_construct (TYPE_IDLE_MONITOR);
#line 248 "idle-monitor.c"
}

guint
idle_monitor_add_idle_watch (IdleMonitor* self,
                             guint64 interval_msec,
                             IdleMonitorWatchFunc callback,
                             gpointer callback_target)
{
	IdleMonitorWatch* watch = NULL;
	IdleMonitorWatch* _tmp0_;
	GHashTable* _tmp1_;
	guint result;
#line 32 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 34 "../src/idle-monitor.vala"
	_tmp0_ = idle_monitor_make_watch (self, idle_monitor_xsync_alarm_set (self, XSyncPositiveTransition, interval_msec, TRUE), callback, callback_target);
#line 34 "../src/idle-monitor.vala"
	watch = _tmp0_;
#line 35 "../src/idle-monitor.vala"
	_tmp1_ = self->priv->alarms;
#line 35 "../src/idle-monitor.vala"
	g_hash_table_add (_tmp1_, (gpointer) ((guintptr) watch->xalarm));
#line 36 "../src/idle-monitor.vala"
	result = watch->id;
#line 36 "../src/idle-monitor.vala"
	_idle_monitor_watch_unref0 (watch);
#line 36 "../src/idle-monitor.vala"
	return result;
#line 277 "idle-monitor.c"
}

guint
idle_monitor_add_user_active_watch (IdleMonitor* self,
                                    IdleMonitorWatchFunc callback,
                                    gpointer callback_target)
{
	Display* _tmp0_;
	IdleMonitorWatch* watch = NULL;
	IdleMonitorWatch* _tmp1_;
	guint result;
#line 39 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 41 "../src/idle-monitor.vala"
	_tmp0_ = self->priv->display;
#line 41 "../src/idle-monitor.vala"
	idle_monitor_set_alarm_enabled (self, _tmp0_, self->priv->user_active_alarm, TRUE);
#line 42 "../src/idle-monitor.vala"
	_tmp1_ = idle_monitor_make_watch (self, self->priv->user_active_alarm, callback, callback_target);
#line 42 "../src/idle-monitor.vala"
	watch = _tmp1_;
#line 43 "../src/idle-monitor.vala"
	result = watch->id;
#line 43 "../src/idle-monitor.vala"
	_idle_monitor_watch_unref0 (watch);
#line 43 "../src/idle-monitor.vala"
	return result;
#line 305 "idle-monitor.c"
}

static gpointer
_idle_monitor_watch_ref0 (gpointer self)
{
#line 48 "../src/idle-monitor.vala"
	return self ? idle_monitor_watch_ref (self) : NULL;
#line 313 "idle-monitor.c"
}

void
idle_monitor_remove_watch (IdleMonitor* self,
                           guint id)
{
	IdleMonitorWatch* watch = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	IdleMonitorWatch* _tmp2_;
	GHashTable* _tmp3_;
	IdleMonitorWatch* _tmp4_;
#line 46 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 48 "../src/idle-monitor.vala"
	_tmp0_ = self->priv->watches;
#line 48 "../src/idle-monitor.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
#line 48 "../src/idle-monitor.vala"
	_tmp2_ = _idle_monitor_watch_ref0 ((IdleMonitorWatch*) _tmp1_);
#line 48 "../src/idle-monitor.vala"
	watch = _tmp2_;
#line 49 "../src/idle-monitor.vala"
	_tmp3_ = self->priv->watches;
#line 49 "../src/idle-monitor.vala"
	g_hash_table_remove (_tmp3_, (gpointer) ((guintptr) id));
#line 50 "../src/idle-monitor.vala"
	_tmp4_ = watch;
#line 50 "../src/idle-monitor.vala"
	if (_tmp4_->xalarm != self->priv->user_active_alarm) {
#line 344 "idle-monitor.c"
		Display* _tmp5_;
		IdleMonitorWatch* _tmp6_;
#line 51 "../src/idle-monitor.vala"
		_tmp5_ = self->priv->display;
#line 51 "../src/idle-monitor.vala"
		_tmp6_ = watch;
#line 51 "../src/idle-monitor.vala"
		XSyncDestroyAlarm (_tmp5_, _tmp6_->xalarm);
#line 353 "idle-monitor.c"
	}
#line 46 "../src/idle-monitor.vala"
	_idle_monitor_watch_unref0 (watch);
#line 357 "idle-monitor.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 56 "../src/idle-monitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 365 "idle-monitor.c"
}

static void
idle_monitor_init_xsync (IdleMonitor* self)
{
	GdkDisplay* d = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkDisplay* _tmp3_;
	Display* _tmp4_;
	gint sync_error_base = 0;
	Status res = {0};
	Display* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Status _tmp8_;
	gint major = 0;
	gint minor = 0;
	Display* _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Status _tmp12_;
	GdkWindow* w = NULL;
	GdkWindow* _tmp13_;
#line 54 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 56 "../src/idle-monitor.vala"
	_tmp0_ = gdk_display_get_default ();
#line 56 "../src/idle-monitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "../src/idle-monitor.vala"
	d = _tmp1_;
#line 57 "../src/idle-monitor.vala"
	_tmp2_ = d;
#line 57 "../src/idle-monitor.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_display_get_type ())) {
#line 59 "../src/idle-monitor.vala"
		g_warning ("idle-monitor.vala:59: Only support idle monitor under X");
#line 60 "../src/idle-monitor.vala"
		_g_object_unref0 (d);
#line 60 "../src/idle-monitor.vala"
		return;
#line 409 "idle-monitor.c"
	}
#line 62 "../src/idle-monitor.vala"
	_tmp3_ = d;
#line 62 "../src/idle-monitor.vala"
	_tmp4_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp3_) : NULL);
#line 62 "../src/idle-monitor.vala"
	self->priv->display = _tmp4_;
#line 65 "../src/idle-monitor.vala"
	_tmp5_ = self->priv->display;
#line 65 "../src/idle-monitor.vala"
	_tmp8_ = XSyncQueryExtension (_tmp5_, &_tmp6_, &_tmp7_);
#line 65 "../src/idle-monitor.vala"
	self->priv->sync_event_base = _tmp6_;
#line 65 "../src/idle-monitor.vala"
	sync_error_base = _tmp7_;
#line 65 "../src/idle-monitor.vala"
	res = _tmp8_;
#line 66 "../src/idle-monitor.vala"
	if (res == ((Status) 0)) {
#line 68 "../src/idle-monitor.vala"
		g_warning ("idle-monitor.vala:68: IdleMonitor: Sync extension not present");
#line 69 "../src/idle-monitor.vala"
		_g_object_unref0 (d);
#line 69 "../src/idle-monitor.vala"
		return;
#line 435 "idle-monitor.c"
	}
#line 73 "../src/idle-monitor.vala"
	_tmp9_ = self->priv->display;
#line 73 "../src/idle-monitor.vala"
	_tmp12_ = XSyncInitialize (_tmp9_, &_tmp10_, &_tmp11_);
#line 73 "../src/idle-monitor.vala"
	major = _tmp10_;
#line 73 "../src/idle-monitor.vala"
	minor = _tmp11_;
#line 73 "../src/idle-monitor.vala"
	res = _tmp12_;
#line 74 "../src/idle-monitor.vala"
	if (res == ((Status) 0)) {
#line 76 "../src/idle-monitor.vala"
		g_warning ("idle-monitor.vala:76: IdleMonitor: Unable to initialize Sync extension");
#line 77 "../src/idle-monitor.vala"
		_g_object_unref0 (d);
#line 77 "../src/idle-monitor.vala"
		return;
#line 455 "idle-monitor.c"
	}
#line 80 "../src/idle-monitor.vala"
	self->priv->counter = idle_monitor_find_idletime_counter (self);
#line 82 "../src/idle-monitor.vala"
	if (self->priv->counter == None) {
#line 83 "../src/idle-monitor.vala"
		_g_object_unref0 (d);
#line 83 "../src/idle-monitor.vala"
		return;
#line 465 "idle-monitor.c"
	}
#line 85 "../src/idle-monitor.vala"
	self->priv->user_active_alarm = idle_monitor_xsync_alarm_set (self, XSyncNegativeTransition, (guint64) 1, FALSE);
#line 88 "../src/idle-monitor.vala"
	w = NULL;
#line 89 "../src/idle-monitor.vala"
	_tmp13_ = w;
#line 89 "../src/idle-monitor.vala"
	gdk_window_add_filter (_tmp13_, _idle_monitor_xevent_filter_gdk_filter_func, self);
#line 54 "../src/idle-monitor.vala"
	_g_object_unref0 (w);
#line 54 "../src/idle-monitor.vala"
	_g_object_unref0 (d);
#line 479 "idle-monitor.c"
}

static GdkFilterReturn
idle_monitor_xevent_filter (IdleMonitor* self,
                            GdkXEvent* xevent,
                            GdkEvent* event)
{
	XEvent* ev = NULL;
	XEvent* _tmp0_;
	XAnyEvent _tmp1_;
	XSyncAlarmNotifyEvent* alarm_event = NULL;
	XSyncAlarmNotifyEvent* _tmp2_;
	GdkFilterReturn result;
#line 92 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 92 "../src/idle-monitor.vala"
	g_return_val_if_fail (xevent != NULL, 0);
#line 92 "../src/idle-monitor.vala"
	g_return_val_if_fail (event != NULL, 0);
#line 94 "../src/idle-monitor.vala"
	ev = (XEvent*) xevent;
#line 95 "../src/idle-monitor.vala"
	_tmp0_ = ev;
#line 95 "../src/idle-monitor.vala"
	_tmp1_ = (*_tmp0_).xany;
#line 95 "../src/idle-monitor.vala"
	if (_tmp1_.type != (self->priv->sync_event_base + XSyncAlarmNotify)) {
#line 96 "../src/idle-monitor.vala"
		result = GDK_FILTER_CONTINUE;
#line 96 "../src/idle-monitor.vala"
		return result;
#line 511 "idle-monitor.c"
	}
#line 98 "../src/idle-monitor.vala"
	alarm_event = (XSyncAlarmNotifyEvent*) xevent;
#line 99 "../src/idle-monitor.vala"
	_tmp2_ = alarm_event;
#line 99 "../src/idle-monitor.vala"
	idle_monitor_handle_alarm_notify_event (self, _tmp2_);
#line 101 "../src/idle-monitor.vala"
	result = GDK_FILTER_CONTINUE;
#line 101 "../src/idle-monitor.vala"
	return result;
#line 523 "idle-monitor.c"
}

static IdleMonitorWatch*
idle_monitor_make_watch (IdleMonitor* self,
                         XID xalarm,
                         IdleMonitorWatchFunc callback,
                         gpointer callback_target)
{
	IdleMonitorWatch* watch = NULL;
	IdleMonitorWatch* _tmp0_;
	GHashTable* _tmp1_;
	IdleMonitorWatch* _tmp2_;
	IdleMonitorWatch* result;
#line 104 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 106 "../src/idle-monitor.vala"
	_tmp0_ = idle_monitor_watch_new ();
#line 106 "../src/idle-monitor.vala"
	watch = _tmp0_;
#line 107 "../src/idle-monitor.vala"
	watch->id = (guint) idle_monitor_get_next_watch_serial (self);
#line 108 "../src/idle-monitor.vala"
	watch->callback = callback;
#line 108 "../src/idle-monitor.vala"
	watch->callback_target = callback_target;
#line 109 "../src/idle-monitor.vala"
	watch->xalarm = xalarm;
#line 111 "../src/idle-monitor.vala"
	_tmp1_ = self->priv->watches;
#line 111 "../src/idle-monitor.vala"
	_tmp2_ = _idle_monitor_watch_ref0 (watch);
#line 111 "../src/idle-monitor.vala"
	g_hash_table_insert (_tmp1_, (gpointer) ((guintptr) watch->id), _tmp2_);
#line 113 "../src/idle-monitor.vala"
	result = watch;
#line 113 "../src/idle-monitor.vala"
	return result;
#line 561 "idle-monitor.c"
}

static XID
idle_monitor_xsync_alarm_set (IdleMonitor* self,
                              XSyncTestType test_type,
                              guint64 interval,
                              gboolean want_events)
{
	XSyncAlarmAttributes attr = {0};
	XSyncValue delta = {0};
	XSyncValue _tmp0_ = {0};
	XSyncValue _tmp1_ = {0};
	Display* _tmp2_;
	XSyncAlarmAttributes _tmp3_;
	XID result;
#line 116 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 118 "../src/idle-monitor.vala"
	memset (&attr, 0, sizeof (XSyncAlarmAttributes));
#line 120 "../src/idle-monitor.vala"
	XSyncIntToValue (&_tmp0_, 0);
#line 120 "../src/idle-monitor.vala"
	delta = _tmp0_;
#line 121 "../src/idle-monitor.vala"
	attr.trigger.counter = self->priv->counter;
#line 122 "../src/idle-monitor.vala"
	attr.trigger.value_type = XSyncAbsolute;
#line 123 "../src/idle-monitor.vala"
	attr.delta = delta;
#line 124 "../src/idle-monitor.vala"
	attr.events = want_events;
#line 125 "../src/idle-monitor.vala"
	XSyncIntsToValue (&_tmp1_, (guint) interval, (gint) (interval >> 32));
#line 125 "../src/idle-monitor.vala"
	attr.trigger.wait_value = _tmp1_;
#line 126 "../src/idle-monitor.vala"
	attr.trigger.test_type = test_type;
#line 128 "../src/idle-monitor.vala"
	_tmp2_ = self->priv->display;
#line 128 "../src/idle-monitor.vala"
	_tmp3_ = attr;
#line 128 "../src/idle-monitor.vala"
	result = XSyncCreateAlarm (_tmp2_, ((((XSyncCACounter | XSyncCAValueType) | XSyncCATestType) | XSyncCAValue) | XSyncCADelta) | XSyncCAEvents, &_tmp3_);
#line 128 "../src/idle-monitor.vala"
	return result;
#line 607 "idle-monitor.c"
}

static void
idle_monitor_ensure_alarm_rescheduled (IdleMonitor* self,
                                       Display* dpy,
                                       XID alarm)
{
	XSyncAlarmAttributes attr = {0};
	XSyncAlarmAttributes _tmp0_;
#line 131 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 131 "../src/idle-monitor.vala"
	g_return_if_fail (dpy != NULL);
#line 136 "../src/idle-monitor.vala"
	memset (&attr, 0, sizeof (XSyncAlarmAttributes));
#line 137 "../src/idle-monitor.vala"
	_tmp0_ = attr;
#line 137 "../src/idle-monitor.vala"
	XSyncChangeAlarm (dpy, alarm, 0, &_tmp0_);
#line 627 "idle-monitor.c"
}

static void
idle_monitor_set_alarm_enabled (IdleMonitor* self,
                                Display* dpy,
                                XID alarm,
                                gboolean enabled)
{
	XSyncAlarmAttributes attr = {0};
	XSyncAlarmAttributes _tmp0_;
#line 140 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 140 "../src/idle-monitor.vala"
	g_return_if_fail (dpy != NULL);
#line 142 "../src/idle-monitor.vala"
	memset (&attr, 0, sizeof (XSyncAlarmAttributes));
#line 143 "../src/idle-monitor.vala"
	attr.events = enabled;
#line 144 "../src/idle-monitor.vala"
	_tmp0_ = attr;
#line 144 "../src/idle-monitor.vala"
	XSyncChangeAlarm (dpy, alarm, XSyncCAEvents, &_tmp0_);
#line 650 "idle-monitor.c"
}

static void
idle_monitor_handle_alarm_notify_event (IdleMonitor* self,
                                        XSyncAlarmNotifyEvent* alarm_event)
{
	XID alarm = 0;
	gboolean has_alarm = FALSE;
#line 147 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 149 "../src/idle-monitor.vala"
	if ((*alarm_event).state != XSyncAlarmActive) {
#line 150 "../src/idle-monitor.vala"
		return;
#line 665 "idle-monitor.c"
	}
#line 152 "../src/idle-monitor.vala"
	alarm = (*alarm_event).alarm;
#line 153 "../src/idle-monitor.vala"
	has_alarm = FALSE;
#line 155 "../src/idle-monitor.vala"
	if (alarm == self->priv->user_active_alarm) {
#line 673 "idle-monitor.c"
		Display* _tmp0_;
#line 157 "../src/idle-monitor.vala"
		_tmp0_ = self->priv->display;
#line 157 "../src/idle-monitor.vala"
		idle_monitor_set_alarm_enabled (self, _tmp0_, alarm, FALSE);
#line 158 "../src/idle-monitor.vala"
		has_alarm = TRUE;
#line 681 "idle-monitor.c"
	} else {
		GHashTable* _tmp1_;
#line 160 "../src/idle-monitor.vala"
		_tmp1_ = self->priv->alarms;
#line 160 "../src/idle-monitor.vala"
		if (g_hash_table_contains (_tmp1_, (gpointer) ((guintptr) alarm))) {
#line 688 "idle-monitor.c"
			Display* _tmp2_;
#line 162 "../src/idle-monitor.vala"
			_tmp2_ = self->priv->display;
#line 162 "../src/idle-monitor.vala"
			idle_monitor_ensure_alarm_rescheduled (self, _tmp2_, alarm);
#line 163 "../src/idle-monitor.vala"
			has_alarm = TRUE;
#line 696 "idle-monitor.c"
		}
	}
#line 166 "../src/idle-monitor.vala"
	if (has_alarm) {
#line 701 "idle-monitor.c"
		GHashTable* _tmp3_;
		GList* _tmp4_;
#line 168 "../src/idle-monitor.vala"
		_tmp3_ = self->priv->watches;
#line 168 "../src/idle-monitor.vala"
		_tmp4_ = g_hash_table_get_values (_tmp3_);
#line 708 "idle-monitor.c"
		{
			GList* watch_collection = NULL;
			GList* watch_it = NULL;
#line 168 "../src/idle-monitor.vala"
			watch_collection = _tmp4_;
#line 168 "../src/idle-monitor.vala"
			for (watch_it = watch_collection; watch_it != NULL; watch_it = watch_it->next) {
#line 716 "idle-monitor.c"
				IdleMonitorWatch* watch = NULL;
#line 168 "../src/idle-monitor.vala"
				watch = (IdleMonitorWatch*) watch_it->data;
#line 720 "idle-monitor.c"
				{
					IdleMonitorWatch* _tmp5_;
#line 169 "../src/idle-monitor.vala"
					_tmp5_ = watch;
#line 169 "../src/idle-monitor.vala"
					idle_monitor_fire_watch (self, _tmp5_, alarm);
#line 727 "idle-monitor.c"
				}
			}
#line 168 "../src/idle-monitor.vala"
			(watch_collection == NULL) ? NULL : (watch_collection = (g_list_free (watch_collection), NULL));
#line 732 "idle-monitor.c"
		}
	}
}

static void
idle_monitor_fire_watch (IdleMonitor* self,
                         IdleMonitorWatch* watch,
                         XID alarm)
{
	IdleMonitorWatchFunc _tmp0_;
	gpointer _tmp0__target;
#line 173 "../src/idle-monitor.vala"
	g_return_if_fail (self != NULL);
#line 173 "../src/idle-monitor.vala"
	g_return_if_fail (watch != NULL);
#line 175 "../src/idle-monitor.vala"
	if (watch->xalarm != alarm) {
#line 176 "../src/idle-monitor.vala"
		return;
#line 752 "idle-monitor.c"
	}
#line 178 "../src/idle-monitor.vala"
	_tmp0_ = watch->callback;
#line 178 "../src/idle-monitor.vala"
	_tmp0__target = watch->callback_target;
#line 178 "../src/idle-monitor.vala"
	if (_tmp0_ != NULL) {
#line 760 "idle-monitor.c"
		IdleMonitorWatchFunc _tmp1_;
		gpointer _tmp1__target;
#line 179 "../src/idle-monitor.vala"
		_tmp1_ = watch->callback;
#line 179 "../src/idle-monitor.vala"
		_tmp1__target = watch->callback_target;
#line 179 "../src/idle-monitor.vala"
		_tmp1_ (self, watch->id, _tmp1__target);
#line 769 "idle-monitor.c"
	}
#line 181 "../src/idle-monitor.vala"
	if (watch->xalarm == self->priv->user_active_alarm) {
#line 182 "../src/idle-monitor.vala"
		idle_monitor_remove_watch (self, watch->id);
#line 775 "idle-monitor.c"
	}
}

static XID
idle_monitor_find_idletime_counter (IdleMonitor* self)
{
	XID counter = 0;
	gint ncounters = 0;
	XSyncSystemCounter* counters = NULL;
	Display* _tmp0_;
	gint _tmp1_ = 0;
	XSyncSystemCounter* _tmp2_;
	XSyncSystemCounter* _tmp15_;
	XID result;
#line 185 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 187 "../src/idle-monitor.vala"
	counter = None;
#line 190 "../src/idle-monitor.vala"
	_tmp0_ = self->priv->display;
#line 190 "../src/idle-monitor.vala"
	_tmp2_ = XSyncListSystemCounters (_tmp0_, &_tmp1_);
#line 190 "../src/idle-monitor.vala"
	ncounters = _tmp1_;
#line 190 "../src/idle-monitor.vala"
	counters = _tmp2_;
#line 802 "idle-monitor.c"
	{
		gint i = 0;
#line 191 "../src/idle-monitor.vala"
		i = 0;
#line 807 "idle-monitor.c"
		{
			gboolean _tmp3_ = FALSE;
#line 191 "../src/idle-monitor.vala"
			_tmp3_ = TRUE;
#line 191 "../src/idle-monitor.vala"
			while (TRUE) {
#line 814 "idle-monitor.c"
				gboolean _tmp5_ = FALSE;
				XSyncSystemCounter* _tmp6_;
				XSyncSystemCounter _tmp7_;
				const gchar* _tmp8_;
#line 191 "../src/idle-monitor.vala"
				if (!_tmp3_) {
#line 821 "idle-monitor.c"
					gint _tmp4_;
#line 191 "../src/idle-monitor.vala"
					_tmp4_ = i;
#line 191 "../src/idle-monitor.vala"
					i = _tmp4_ + 1;
#line 827 "idle-monitor.c"
				}
#line 191 "../src/idle-monitor.vala"
				_tmp3_ = FALSE;
#line 191 "../src/idle-monitor.vala"
				if (!(i < ncounters)) {
#line 191 "../src/idle-monitor.vala"
					break;
#line 835 "idle-monitor.c"
				}
#line 193 "../src/idle-monitor.vala"
				_tmp6_ = counters;
#line 193 "../src/idle-monitor.vala"
				_tmp7_ = _tmp6_[i];
#line 193 "../src/idle-monitor.vala"
				_tmp8_ = _tmp7_.name;
#line 193 "../src/idle-monitor.vala"
				if (_tmp8_ != NULL) {
#line 845 "idle-monitor.c"
					GCompareFunc _tmp9_;
					XSyncSystemCounter* _tmp10_;
					XSyncSystemCounter _tmp11_;
					const gchar* _tmp12_;
#line 193 "../src/idle-monitor.vala"
					_tmp9_ = ((GCompareFunc) g_strcmp0);
#line 193 "../src/idle-monitor.vala"
					_tmp10_ = counters;
#line 193 "../src/idle-monitor.vala"
					_tmp11_ = _tmp10_[i];
#line 193 "../src/idle-monitor.vala"
					_tmp12_ = _tmp11_.name;
#line 193 "../src/idle-monitor.vala"
					_tmp5_ = _tmp9_ (_tmp12_, "IDLETIME") == 0;
#line 860 "idle-monitor.c"
				} else {
#line 193 "../src/idle-monitor.vala"
					_tmp5_ = FALSE;
#line 864 "idle-monitor.c"
				}
#line 193 "../src/idle-monitor.vala"
				if (_tmp5_) {
#line 868 "idle-monitor.c"
					XSyncSystemCounter* _tmp13_;
					XSyncSystemCounter _tmp14_;
#line 195 "../src/idle-monitor.vala"
					_tmp13_ = counters;
#line 195 "../src/idle-monitor.vala"
					_tmp14_ = _tmp13_[i];
#line 195 "../src/idle-monitor.vala"
					counter = _tmp14_.counter;
#line 196 "../src/idle-monitor.vala"
					break;
#line 879 "idle-monitor.c"
				}
			}
		}
	}
#line 199 "../src/idle-monitor.vala"
	_tmp15_ = counters;
#line 199 "../src/idle-monitor.vala"
	XSyncFreeSystemCounterList (_tmp15_);
#line 201 "../src/idle-monitor.vala"
	result = counter;
#line 201 "../src/idle-monitor.vala"
	return result;
#line 892 "idle-monitor.c"
}

static guint32
idle_monitor_get_next_watch_serial (IdleMonitor* self)
{
	guint32 result;
#line 204 "../src/idle-monitor.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 206 "../src/idle-monitor.vala"
	g_atomic_int_inc ((volatile gint *) (&self->priv->serial));
#line 207 "../src/idle-monitor.vala"
	result = (guint32) self->priv->serial;
#line 207 "../src/idle-monitor.vala"
	return result;
#line 907 "idle-monitor.c"
}

static void
value_idle_monitor_init (GValue* value)
{
#line 3 "../src/idle-monitor.vala"
	value->data[0].v_pointer = NULL;
#line 915 "idle-monitor.c"
}

static void
value_idle_monitor_free_value (GValue* value)
{
#line 3 "../src/idle-monitor.vala"
	if (value->data[0].v_pointer) {
#line 3 "../src/idle-monitor.vala"
		idle_monitor_unref (value->data[0].v_pointer);
#line 925 "idle-monitor.c"
	}
}

static void
value_idle_monitor_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 3 "../src/idle-monitor.vala"
	if (src_value->data[0].v_pointer) {
#line 3 "../src/idle-monitor.vala"
		dest_value->data[0].v_pointer = idle_monitor_ref (src_value->data[0].v_pointer);
#line 937 "idle-monitor.c"
	} else {
#line 3 "../src/idle-monitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 941 "idle-monitor.c"
	}
}

static gpointer
value_idle_monitor_peek_pointer (const GValue* value)
{
#line 3 "../src/idle-monitor.vala"
	return value->data[0].v_pointer;
#line 950 "idle-monitor.c"
}

static gchar*
value_idle_monitor_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 3 "../src/idle-monitor.vala"
	if (collect_values[0].v_pointer) {
#line 961 "idle-monitor.c"
		IdleMonitor * object;
		object = collect_values[0].v_pointer;
#line 3 "../src/idle-monitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 3 "../src/idle-monitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 968 "idle-monitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 3 "../src/idle-monitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 972 "idle-monitor.c"
		}
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = idle_monitor_ref (object);
#line 976 "idle-monitor.c"
	} else {
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 980 "idle-monitor.c"
	}
#line 3 "../src/idle-monitor.vala"
	return NULL;
#line 984 "idle-monitor.c"
}

static gchar*
value_idle_monitor_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	IdleMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 3 "../src/idle-monitor.vala"
	if (!object_p) {
#line 3 "../src/idle-monitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 999 "idle-monitor.c"
	}
#line 3 "../src/idle-monitor.vala"
	if (!value->data[0].v_pointer) {
#line 3 "../src/idle-monitor.vala"
		*object_p = NULL;
#line 1005 "idle-monitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 3 "../src/idle-monitor.vala"
		*object_p = value->data[0].v_pointer;
#line 1009 "idle-monitor.c"
	} else {
#line 3 "../src/idle-monitor.vala"
		*object_p = idle_monitor_ref (value->data[0].v_pointer);
#line 1013 "idle-monitor.c"
	}
#line 3 "../src/idle-monitor.vala"
	return NULL;
#line 1017 "idle-monitor.c"
}

GParamSpec*
param_spec_idle_monitor (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecIdleMonitor* spec;
#line 3 "../src/idle-monitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IDLE_MONITOR), NULL);
#line 3 "../src/idle-monitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 3 "../src/idle-monitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 3 "../src/idle-monitor.vala"
	return G_PARAM_SPEC (spec);
#line 1036 "idle-monitor.c"
}

gpointer
value_get_idle_monitor (const GValue* value)
{
#line 3 "../src/idle-monitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR), NULL);
#line 3 "../src/idle-monitor.vala"
	return value->data[0].v_pointer;
#line 1046 "idle-monitor.c"
}

void
value_set_idle_monitor (GValue* value,
                        gpointer v_object)
{
	IdleMonitor * old;
#line 3 "../src/idle-monitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR));
#line 3 "../src/idle-monitor.vala"
	old = value->data[0].v_pointer;
#line 3 "../src/idle-monitor.vala"
	if (v_object) {
#line 3 "../src/idle-monitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDLE_MONITOR));
#line 3 "../src/idle-monitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = v_object;
#line 3 "../src/idle-monitor.vala"
		idle_monitor_ref (value->data[0].v_pointer);
#line 1068 "idle-monitor.c"
	} else {
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 1072 "idle-monitor.c"
	}
#line 3 "../src/idle-monitor.vala"
	if (old) {
#line 3 "../src/idle-monitor.vala"
		idle_monitor_unref (old);
#line 1078 "idle-monitor.c"
	}
}

void
value_take_idle_monitor (GValue* value,
                         gpointer v_object)
{
	IdleMonitor * old;
#line 3 "../src/idle-monitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR));
#line 3 "../src/idle-monitor.vala"
	old = value->data[0].v_pointer;
#line 3 "../src/idle-monitor.vala"
	if (v_object) {
#line 3 "../src/idle-monitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDLE_MONITOR));
#line 3 "../src/idle-monitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = v_object;
#line 1099 "idle-monitor.c"
	} else {
#line 3 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 1103 "idle-monitor.c"
	}
#line 3 "../src/idle-monitor.vala"
	if (old) {
#line 3 "../src/idle-monitor.vala"
		idle_monitor_unref (old);
#line 1109 "idle-monitor.c"
	}
}

static void
idle_monitor_class_init (IdleMonitorClass * klass,
                         gpointer klass_data)
{
#line 3 "../src/idle-monitor.vala"
	idle_monitor_parent_class = g_type_class_peek_parent (klass);
#line 3 "../src/idle-monitor.vala"
	((IdleMonitorClass *) klass)->finalize = idle_monitor_finalize;
#line 3 "../src/idle-monitor.vala"
	g_type_class_adjust_private_offset (klass, &IdleMonitor_private_offset);
#line 1123 "idle-monitor.c"
}

static void
idle_monitor_instance_init (IdleMonitor * self,
                            gpointer klass)
{
#line 3 "../src/idle-monitor.vala"
	self->priv = idle_monitor_get_instance_private (self);
#line 11 "../src/idle-monitor.vala"
	self->priv->serial = 0;
#line 3 "../src/idle-monitor.vala"
	self->ref_count = 1;
#line 1136 "idle-monitor.c"
}

static void
idle_monitor_finalize (IdleMonitor * obj)
{
	IdleMonitor * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GdkWindow* w = NULL;
	GdkWindow* _tmp4_;
#line 3 "../src/idle-monitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDLE_MONITOR, IdleMonitor);
#line 3 "../src/idle-monitor.vala"
	g_signal_handlers_destroy (self);
#line 22 "../src/idle-monitor.vala"
	_tmp0_ = self->priv->watches;
#line 22 "../src/idle-monitor.vala"
	_tmp1_ = g_hash_table_get_values (_tmp0_);
#line 1155 "idle-monitor.c"
	{
		GList* watch_collection = NULL;
		GList* watch_it = NULL;
#line 22 "../src/idle-monitor.vala"
		watch_collection = _tmp1_;
#line 22 "../src/idle-monitor.vala"
		for (watch_it = watch_collection; watch_it != NULL; watch_it = watch_it->next) {
#line 1163 "idle-monitor.c"
			IdleMonitorWatch* watch = NULL;
#line 22 "../src/idle-monitor.vala"
			watch = (IdleMonitorWatch*) watch_it->data;
#line 1167 "idle-monitor.c"
			{
				IdleMonitorWatch* _tmp2_;
#line 23 "../src/idle-monitor.vala"
				_tmp2_ = watch;
#line 23 "../src/idle-monitor.vala"
				idle_monitor_remove_watch (self, _tmp2_->id);
#line 1174 "idle-monitor.c"
			}
		}
#line 22 "../src/idle-monitor.vala"
		(watch_collection == NULL) ? NULL : (watch_collection = (g_list_free (watch_collection), NULL));
#line 1179 "idle-monitor.c"
	}
#line 24 "../src/idle-monitor.vala"
	if (self->priv->user_active_alarm != None) {
#line 1183 "idle-monitor.c"
		Display* _tmp3_;
#line 25 "../src/idle-monitor.vala"
		_tmp3_ = self->priv->display;
#line 25 "../src/idle-monitor.vala"
		XSyncDestroyAlarm (_tmp3_, self->priv->user_active_alarm);
#line 1189 "idle-monitor.c"
	}
#line 28 "../src/idle-monitor.vala"
	w = NULL;
#line 29 "../src/idle-monitor.vala"
	_tmp4_ = w;
#line 29 "../src/idle-monitor.vala"
	gdk_window_remove_filter (_tmp4_, _idle_monitor_xevent_filter_gdk_filter_func, self);
#line 3 "../src/idle-monitor.vala"
	_g_object_unref0 (w);
#line 6 "../src/idle-monitor.vala"
	_g_hash_table_unref0 (self->priv->watches);
#line 7 "../src/idle-monitor.vala"
	_g_hash_table_unref0 (self->priv->alarms);
#line 1203 "idle-monitor.c"
}

static GType
idle_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_idle_monitor_init, value_idle_monitor_free_value, value_idle_monitor_copy_value, value_idle_monitor_peek_pointer, "p", value_idle_monitor_collect_value, "p", value_idle_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IdleMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) idle_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdleMonitor), 0, (GInstanceInitFunc) idle_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType idle_monitor_type_id;
	idle_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IdleMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	IdleMonitor_private_offset = g_type_add_instance_private (idle_monitor_type_id, sizeof (IdleMonitorPrivate));
	return idle_monitor_type_id;
}

GType
idle_monitor_get_type (void)
{
	static volatile gsize idle_monitor_type_id__once = 0;
	if (g_once_init_enter (&idle_monitor_type_id__once)) {
		GType idle_monitor_type_id;
		idle_monitor_type_id = idle_monitor_get_type_once ();
		g_once_init_leave (&idle_monitor_type_id__once, idle_monitor_type_id);
	}
	return idle_monitor_type_id__once;
}

gpointer
idle_monitor_ref (gpointer instance)
{
	IdleMonitor * self;
	self = instance;
#line 3 "../src/idle-monitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 3 "../src/idle-monitor.vala"
	return instance;
#line 1239 "idle-monitor.c"
}

void
idle_monitor_unref (gpointer instance)
{
	IdleMonitor * self;
	self = instance;
#line 3 "../src/idle-monitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 3 "../src/idle-monitor.vala"
		IDLE_MONITOR_GET_CLASS (self)->finalize (self);
#line 3 "../src/idle-monitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1253 "idle-monitor.c"
	}
}

IdleMonitorWatch*
idle_monitor_watch_construct (GType object_type)
{
	IdleMonitorWatch* self = NULL;
#line 211 "../src/idle-monitor.vala"
	self = (IdleMonitorWatch*) g_type_create_instance (object_type);
#line 211 "../src/idle-monitor.vala"
	return self;
#line 1265 "idle-monitor.c"
}

IdleMonitorWatch*
idle_monitor_watch_new (void)
{
#line 211 "../src/idle-monitor.vala"
	return idle_monitor_watch_construct (TYPE_IDLE_MONITOR_WATCH);
#line 1273 "idle-monitor.c"
}

static void
value_idle_monitor_watch_init (GValue* value)
{
#line 211 "../src/idle-monitor.vala"
	value->data[0].v_pointer = NULL;
#line 1281 "idle-monitor.c"
}

static void
value_idle_monitor_watch_free_value (GValue* value)
{
#line 211 "../src/idle-monitor.vala"
	if (value->data[0].v_pointer) {
#line 211 "../src/idle-monitor.vala"
		idle_monitor_watch_unref (value->data[0].v_pointer);
#line 1291 "idle-monitor.c"
	}
}

static void
value_idle_monitor_watch_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
#line 211 "../src/idle-monitor.vala"
	if (src_value->data[0].v_pointer) {
#line 211 "../src/idle-monitor.vala"
		dest_value->data[0].v_pointer = idle_monitor_watch_ref (src_value->data[0].v_pointer);
#line 1303 "idle-monitor.c"
	} else {
#line 211 "../src/idle-monitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1307 "idle-monitor.c"
	}
}

static gpointer
value_idle_monitor_watch_peek_pointer (const GValue* value)
{
#line 211 "../src/idle-monitor.vala"
	return value->data[0].v_pointer;
#line 1316 "idle-monitor.c"
}

static gchar*
value_idle_monitor_watch_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
#line 211 "../src/idle-monitor.vala"
	if (collect_values[0].v_pointer) {
#line 1327 "idle-monitor.c"
		IdleMonitorWatch * object;
		object = collect_values[0].v_pointer;
#line 211 "../src/idle-monitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 211 "../src/idle-monitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1334 "idle-monitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 211 "../src/idle-monitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1338 "idle-monitor.c"
		}
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = idle_monitor_watch_ref (object);
#line 1342 "idle-monitor.c"
	} else {
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 1346 "idle-monitor.c"
	}
#line 211 "../src/idle-monitor.vala"
	return NULL;
#line 1350 "idle-monitor.c"
}

static gchar*
value_idle_monitor_watch_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	IdleMonitorWatch ** object_p;
	object_p = collect_values[0].v_pointer;
#line 211 "../src/idle-monitor.vala"
	if (!object_p) {
#line 211 "../src/idle-monitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1365 "idle-monitor.c"
	}
#line 211 "../src/idle-monitor.vala"
	if (!value->data[0].v_pointer) {
#line 211 "../src/idle-monitor.vala"
		*object_p = NULL;
#line 1371 "idle-monitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 211 "../src/idle-monitor.vala"
		*object_p = value->data[0].v_pointer;
#line 1375 "idle-monitor.c"
	} else {
#line 211 "../src/idle-monitor.vala"
		*object_p = idle_monitor_watch_ref (value->data[0].v_pointer);
#line 1379 "idle-monitor.c"
	}
#line 211 "../src/idle-monitor.vala"
	return NULL;
#line 1383 "idle-monitor.c"
}

GParamSpec*
param_spec_idle_monitor_watch (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecIdleMonitorWatch* spec;
#line 211 "../src/idle-monitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IDLE_MONITOR_WATCH), NULL);
#line 211 "../src/idle-monitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 211 "../src/idle-monitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 211 "../src/idle-monitor.vala"
	return G_PARAM_SPEC (spec);
#line 1402 "idle-monitor.c"
}

gpointer
value_get_idle_monitor_watch (const GValue* value)
{
#line 211 "../src/idle-monitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR_WATCH), NULL);
#line 211 "../src/idle-monitor.vala"
	return value->data[0].v_pointer;
#line 1412 "idle-monitor.c"
}

void
value_set_idle_monitor_watch (GValue* value,
                              gpointer v_object)
{
	IdleMonitorWatch * old;
#line 211 "../src/idle-monitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR_WATCH));
#line 211 "../src/idle-monitor.vala"
	old = value->data[0].v_pointer;
#line 211 "../src/idle-monitor.vala"
	if (v_object) {
#line 211 "../src/idle-monitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDLE_MONITOR_WATCH));
#line 211 "../src/idle-monitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = v_object;
#line 211 "../src/idle-monitor.vala"
		idle_monitor_watch_ref (value->data[0].v_pointer);
#line 1434 "idle-monitor.c"
	} else {
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 1438 "idle-monitor.c"
	}
#line 211 "../src/idle-monitor.vala"
	if (old) {
#line 211 "../src/idle-monitor.vala"
		idle_monitor_watch_unref (old);
#line 1444 "idle-monitor.c"
	}
}

void
value_take_idle_monitor_watch (GValue* value,
                               gpointer v_object)
{
	IdleMonitorWatch * old;
#line 211 "../src/idle-monitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IDLE_MONITOR_WATCH));
#line 211 "../src/idle-monitor.vala"
	old = value->data[0].v_pointer;
#line 211 "../src/idle-monitor.vala"
	if (v_object) {
#line 211 "../src/idle-monitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IDLE_MONITOR_WATCH));
#line 211 "../src/idle-monitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = v_object;
#line 1465 "idle-monitor.c"
	} else {
#line 211 "../src/idle-monitor.vala"
		value->data[0].v_pointer = NULL;
#line 1469 "idle-monitor.c"
	}
#line 211 "../src/idle-monitor.vala"
	if (old) {
#line 211 "../src/idle-monitor.vala"
		idle_monitor_watch_unref (old);
#line 1475 "idle-monitor.c"
	}
}

static void
idle_monitor_watch_class_init (IdleMonitorWatchClass * klass,
                               gpointer klass_data)
{
#line 211 "../src/idle-monitor.vala"
	idle_monitor_watch_parent_class = g_type_class_peek_parent (klass);
#line 211 "../src/idle-monitor.vala"
	((IdleMonitorWatchClass *) klass)->finalize = idle_monitor_watch_finalize;
#line 1487 "idle-monitor.c"
}

static void
idle_monitor_watch_instance_init (IdleMonitorWatch * self,
                                  gpointer klass)
{
#line 211 "../src/idle-monitor.vala"
	self->ref_count = 1;
#line 1496 "idle-monitor.c"
}

static void
idle_monitor_watch_finalize (IdleMonitorWatch * obj)
{
	IdleMonitorWatch * self;
#line 211 "../src/idle-monitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IDLE_MONITOR_WATCH, IdleMonitorWatch);
#line 211 "../src/idle-monitor.vala"
	g_signal_handlers_destroy (self);
#line 1507 "idle-monitor.c"
}

static GType
idle_monitor_watch_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_idle_monitor_watch_init, value_idle_monitor_watch_free_value, value_idle_monitor_watch_copy_value, value_idle_monitor_watch_peek_pointer, "p", value_idle_monitor_watch_collect_value, "p", value_idle_monitor_watch_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (IdleMonitorWatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) idle_monitor_watch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdleMonitorWatch), 0, (GInstanceInitFunc) idle_monitor_watch_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType idle_monitor_watch_type_id;
	idle_monitor_watch_type_id = g_type_register_fundamental (g_type_fundamental_next (), "IdleMonitorWatch", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return idle_monitor_watch_type_id;
}

GType
idle_monitor_watch_get_type (void)
{
	static volatile gsize idle_monitor_watch_type_id__once = 0;
	if (g_once_init_enter (&idle_monitor_watch_type_id__once)) {
		GType idle_monitor_watch_type_id;
		idle_monitor_watch_type_id = idle_monitor_watch_get_type_once ();
		g_once_init_leave (&idle_monitor_watch_type_id__once, idle_monitor_watch_type_id);
	}
	return idle_monitor_watch_type_id__once;
}

gpointer
idle_monitor_watch_ref (gpointer instance)
{
	IdleMonitorWatch * self;
	self = instance;
#line 211 "../src/idle-monitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 211 "../src/idle-monitor.vala"
	return instance;
#line 1542 "idle-monitor.c"
}

void
idle_monitor_watch_unref (gpointer instance)
{
	IdleMonitorWatch * self;
	self = instance;
#line 211 "../src/idle-monitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 211 "../src/idle-monitor.vala"
		IDLE_MONITOR_WATCH_GET_CLASS (self)->finalize (self);
#line 211 "../src/idle-monitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1556 "idle-monitor.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

