/* UserCard.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from UserCard.vala, do not modify */

/*
 * Copyright 2018-2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <lightdm.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <sys/types.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <handy.h>

#define GREETER_BASE_CARD_ERROR_SHAKE_DURATION 450
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_BASE_CARD (greeter_base_card_get_type ())
#define GREETER_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCard))
#define GREETER_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))
#define GREETER_IS_BASE_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BASE_CARD))
#define GREETER_IS_BASE_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BASE_CARD))
#define GREETER_BASE_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BASE_CARD, GreeterBaseCardClass))

typedef struct _GreeterBaseCard GreeterBaseCard;
typedef struct _GreeterBaseCardClass GreeterBaseCardClass;
typedef struct _GreeterBaseCardPrivate GreeterBaseCardPrivate;

#define GREETER_TYPE_USER_CARD (greeter_user_card_get_type ())
#define GREETER_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_USER_CARD, GreeterUserCard))
#define GREETER_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_USER_CARD, GreeterUserCardClass))
#define GREETER_IS_USER_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_USER_CARD))
#define GREETER_IS_USER_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_USER_CARD))
#define GREETER_USER_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_USER_CARD, GreeterUserCardClass))

typedef struct _GreeterUserCard GreeterUserCard;
typedef struct _GreeterUserCardClass GreeterUserCardClass;
typedef struct _GreeterUserCardPrivate GreeterUserCardPrivate;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_accounts_service_get_type ())
#define PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsService))
#define PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsServiceIface))

typedef struct _PantheonAccountsService PantheonAccountsService;
typedef struct _PantheonAccountsServiceIface PantheonAccountsServiceIface;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_accounts_service_proxy_get_type ())

#define PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE (pantheon_settings_daemon_accounts_service_get_type ())
#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, PantheonSettingsDaemonAccountsService))
#define PANTHEON_SETTINGS_DAEMON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, PantheonSettingsDaemonAccountsServiceIface))

typedef struct _PantheonSettingsDaemonAccountsService PantheonSettingsDaemonAccountsService;
typedef struct _PantheonSettingsDaemonAccountsServiceIface PantheonSettingsDaemonAccountsServiceIface;

#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_KEYBOARD_LAYOUT (pantheon_settings_daemon_accounts_service_keyboard_layout_get_type ())
typedef struct _PantheonSettingsDaemonAccountsServiceKeyboardLayout PantheonSettingsDaemonAccountsServiceKeyboardLayout;

#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_XKB_OPTION (pantheon_settings_daemon_accounts_service_xkb_option_get_type ())
typedef struct _PantheonSettingsDaemonAccountsServiceXkbOption PantheonSettingsDaemonAccountsServiceXkbOption;

#define PANTHEON_SETTINGS_DAEMON_ACCOUNTS_SERVICE_TYPE_COORDINATES (pantheon_settings_daemon_accounts_service_coordinates_get_type ())
typedef struct _PantheonSettingsDaemonAccountsServiceCoordinates PantheonSettingsDaemonAccountsServiceCoordinates;

#define PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_settings_daemon_accounts_service_proxy_get_type ())

#define GREETER_TYPE_PASSWORD_ENTRY (greeter_password_entry_get_type ())
#define GREETER_PASSWORD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntry))
#define GREETER_PASSWORD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntryClass))
#define GREETER_IS_PASSWORD_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_PASSWORD_ENTRY))
#define GREETER_IS_PASSWORD_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_PASSWORD_ENTRY))
#define GREETER_PASSWORD_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_PASSWORD_ENTRY, GreeterPasswordEntryClass))

typedef struct _GreeterPasswordEntry GreeterPasswordEntry;
typedef struct _GreeterPasswordEntryClass GreeterPasswordEntryClass;

#define GREETER_USER_CARD_TYPE_SELECTION_CHECK (greeter_user_card_selection_check_get_type ())
#define GREETER_USER_CARD_SELECTION_CHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheck))
#define GREETER_USER_CARD_SELECTION_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheckClass))
#define GREETER_USER_CARD_IS_SELECTION_CHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK))
#define GREETER_USER_CARD_IS_SELECTION_CHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_USER_CARD_TYPE_SELECTION_CHECK))
#define GREETER_USER_CARD_SELECTION_CHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_USER_CARD_TYPE_SELECTION_CHECK, GreeterUserCardSelectionCheckClass))

typedef struct _GreeterUserCardSelectionCheck GreeterUserCardSelectionCheck;
typedef struct _GreeterUserCardSelectionCheckClass GreeterUserCardSelectionCheckClass;
enum  {
	GREETER_USER_CARD_0_PROPERTY,
	GREETER_USER_CARD_LIGHTDM_USER_PROPERTY,
	GREETER_USER_CARD_SHOW_INPUT_PROPERTY,
	GREETER_USER_CARD_IS_24H_PROPERTY,
	GREETER_USER_CARD_CLICK_GESTURE_PROPERTY,
	GREETER_USER_CARD_NUM_PROPERTIES
};
static GParamSpec* greeter_user_card_properties[GREETER_USER_CARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GREETER_TYPE_BACKGROUND_IMAGE (greeter_background_image_get_type ())
#define GREETER_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImage))
#define GREETER_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))
#define GREETER_IS_BACKGROUND_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_IS_BACKGROUND_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_BACKGROUND_IMAGE))
#define GREETER_BACKGROUND_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_BACKGROUND_IMAGE, GreeterBackgroundImageClass))

typedef struct _GreeterBackgroundImage GreeterBackgroundImage;
typedef struct _GreeterBackgroundImageClass GreeterBackgroundImageClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

#define GREETER_TYPE_SETTINGS_PORTAL (greeter_settings_portal_get_type ())
#define GREETER_SETTINGS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortal))
#define GREETER_SETTINGS_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortalClass))
#define GREETER_IS_SETTINGS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SETTINGS_PORTAL))
#define GREETER_IS_SETTINGS_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SETTINGS_PORTAL))
#define GREETER_SETTINGS_PORTAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortalClass))

typedef struct _GreeterSettingsPortal GreeterSettingsPortal;
typedef struct _GreeterSettingsPortalClass GreeterSettingsPortalClass;
typedef struct _GreeterUserCardSelectionCheckPrivate GreeterUserCardSelectionCheckPrivate;
enum  {
	GREETER_USER_CARD_SELECTION_CHECK_0_PROPERTY,
	GREETER_USER_CARD_SELECTION_CHECK_NUM_PROPERTIES
};
static GParamSpec* greeter_user_card_selection_check_properties[GREETER_USER_CARD_SELECTION_CHECK_NUM_PROPERTIES];
typedef struct _Block5Data Block5Data;

#define GREETER_TYPE_SESSION_BUTTON (greeter_session_button_get_type ())
#define GREETER_SESSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButton))
#define GREETER_SESSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButtonClass))
#define GREETER_IS_SESSION_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SESSION_BUTTON))
#define GREETER_IS_SESSION_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SESSION_BUTTON))
#define GREETER_SESSION_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SESSION_BUTTON, GreeterSessionButtonClass))

typedef struct _GreeterSessionButton GreeterSessionButton;
typedef struct _GreeterSessionButtonClass GreeterSessionButtonClass;

#define GREETER_TYPE_CAPS_LOCK_REVEALER (greeter_caps_lock_revealer_get_type ())
#define GREETER_CAPS_LOCK_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealer))
#define GREETER_CAPS_LOCK_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealerClass))
#define GREETER_IS_CAPS_LOCK_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER))
#define GREETER_IS_CAPS_LOCK_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_CAPS_LOCK_REVEALER))
#define GREETER_CAPS_LOCK_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_CAPS_LOCK_REVEALER, GreeterCapsLockRevealerClass))

typedef struct _GreeterCapsLockRevealer GreeterCapsLockRevealer;
typedef struct _GreeterCapsLockRevealerClass GreeterCapsLockRevealerClass;

struct _GreeterBaseCard {
	GtkBin parent_instance;
	GreeterBaseCardPrivate * priv;
};

struct _GreeterBaseCardClass {
	GtkBinClass parent_class;
	void (*wrong_credentials) (GreeterBaseCard* self);
};

struct _GreeterUserCard {
	GreeterBaseCard parent_instance;
	GreeterUserCardPrivate * priv;
};

struct _GreeterUserCardClass {
	GreeterBaseCardClass parent_class;
};

struct _PantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gchar* (*get_time_format) (PantheonAccountsService* self);
	void (*set_time_format) (PantheonAccountsService* self, const gchar* value);
	gint (*get_prefers_color_scheme) (PantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_ac_timeout) (PantheonAccountsService* self);
	void (*set_sleep_inactive_ac_timeout) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_ac_type) (PantheonAccountsService* self);
	void (*set_sleep_inactive_ac_type) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_battery_timeout) (PantheonAccountsService* self);
	void (*set_sleep_inactive_battery_timeout) (PantheonAccountsService* self, gint value);
	gint (*get_sleep_inactive_battery_type) (PantheonAccountsService* self);
	void (*set_sleep_inactive_battery_type) (PantheonAccountsService* self, gint value);
};

struct _PantheonSettingsDaemonAccountsServiceKeyboardLayout {
	gchar* backend;
	gchar* name;
};

struct _PantheonSettingsDaemonAccountsServiceXkbOption {
	gchar* option;
};

struct _PantheonSettingsDaemonAccountsServiceCoordinates {
	gdouble latitude;
	gdouble longitude;
};

struct _PantheonSettingsDaemonAccountsServiceIface {
	GTypeInterface parent_iface;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* (*get_keyboard_layouts) (PantheonSettingsDaemonAccountsService* self, gint* result_length1);
	void (*set_keyboard_layouts) (PantheonSettingsDaemonAccountsService* self, PantheonSettingsDaemonAccountsServiceKeyboardLayout* value, gint value_length1);
	guint (*get_active_keyboard_layout) (PantheonSettingsDaemonAccountsService* self);
	void (*set_active_keyboard_layout) (PantheonSettingsDaemonAccountsService* self, guint value);
	PantheonSettingsDaemonAccountsServiceXkbOption* (*get_xkb_options) (PantheonSettingsDaemonAccountsService* self, gint* result_length1);
	void (*set_xkb_options) (PantheonSettingsDaemonAccountsService* self, PantheonSettingsDaemonAccountsServiceXkbOption* value, gint value_length1);
	gboolean (*get_left_handed) (PantheonSettingsDaemonAccountsService* self);
	void (*set_left_handed) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gint (*get_accel_profile) (PantheonSettingsDaemonAccountsService* self);
	void (*set_accel_profile) (PantheonSettingsDaemonAccountsService* self, gint value);
	gboolean (*get_mouse_natural_scroll) (PantheonSettingsDaemonAccountsService* self);
	void (*set_mouse_natural_scroll) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_mouse_speed) (PantheonSettingsDaemonAccountsService* self);
	void (*set_mouse_speed) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gint (*get_touchpad_click_method) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_click_method) (PantheonSettingsDaemonAccountsService* self, gint value);
	gboolean (*get_touchpad_disable_while_typing) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_disable_while_typing) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_edge_scrolling) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_edge_scrolling) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_natural_scroll) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_natural_scroll) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gint (*get_touchpad_send_events) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_send_events) (PantheonSettingsDaemonAccountsService* self, gint value);
	gdouble (*get_touchpad_speed) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_speed) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gboolean (*get_touchpad_tap_to_click) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_tap_to_click) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_touchpad_two_finger_scrolling) (PantheonSettingsDaemonAccountsService* self);
	void (*set_touchpad_two_finger_scrolling) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gint (*get_accent_color) (PantheonSettingsDaemonAccountsService* self);
	void (*set_accent_color) (PantheonSettingsDaemonAccountsService* self, gint value);
	gboolean (*get_cursor_blink) (PantheonSettingsDaemonAccountsService* self);
	void (*set_cursor_blink) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gint (*get_cursor_blink_time) (PantheonSettingsDaemonAccountsService* self);
	void (*set_cursor_blink_time) (PantheonSettingsDaemonAccountsService* self, gint value);
	gint (*get_cursor_blink_timeout) (PantheonSettingsDaemonAccountsService* self);
	void (*set_cursor_blink_timeout) (PantheonSettingsDaemonAccountsService* self, gint value);
	gint (*get_cursor_size) (PantheonSettingsDaemonAccountsService* self);
	void (*set_cursor_size) (PantheonSettingsDaemonAccountsService* self, gint value);
	gboolean (*get_locate_pointer) (PantheonSettingsDaemonAccountsService* self);
	void (*set_locate_pointer) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_text_scaling_factor) (PantheonSettingsDaemonAccountsService* self);
	void (*set_text_scaling_factor) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gint (*get_picture_options) (PantheonSettingsDaemonAccountsService* self);
	void (*set_picture_options) (PantheonSettingsDaemonAccountsService* self, gint value);
	gchar* (*get_primary_color) (PantheonSettingsDaemonAccountsService* self);
	void (*set_primary_color) (PantheonSettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_document_font_name) (PantheonSettingsDaemonAccountsService* self);
	void (*set_document_font_name) (PantheonSettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_font_name) (PantheonSettingsDaemonAccountsService* self);
	void (*set_font_name) (PantheonSettingsDaemonAccountsService* self, const gchar* value);
	gchar* (*get_monospace_font_name) (PantheonSettingsDaemonAccountsService* self);
	void (*set_monospace_font_name) (PantheonSettingsDaemonAccountsService* self, const gchar* value);
	gboolean (*get_orientation_lock) (PantheonSettingsDaemonAccountsService* self);
	void (*set_orientation_lock) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_wingpanel_use_transparency) (PantheonSettingsDaemonAccountsService* self);
	void (*set_wingpanel_use_transparency) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_wingpanel_show_percentage) (PantheonSettingsDaemonAccountsService* self);
	void (*set_wingpanel_show_percentage) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	void (*get_last_coordinates) (PantheonSettingsDaemonAccountsService* self, PantheonSettingsDaemonAccountsServiceCoordinates * result);
	void (*set_last_coordinates) (PantheonSettingsDaemonAccountsService* self, PantheonSettingsDaemonAccountsServiceCoordinates * value);
	gint (*get_prefer_dark_schedule) (PantheonSettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule) (PantheonSettingsDaemonAccountsService* self, gint value);
	gdouble (*get_prefer_dark_schedule_from) (PantheonSettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule_from) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gdouble (*get_prefer_dark_schedule_to) (PantheonSettingsDaemonAccountsService* self);
	void (*set_prefer_dark_schedule_to) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gboolean (*get_night_light_enabled) (PantheonSettingsDaemonAccountsService* self);
	void (*set_night_light_enabled) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gboolean (*get_night_light_schedule_automatic) (PantheonSettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_automatic) (PantheonSettingsDaemonAccountsService* self, gboolean value);
	gdouble (*get_night_light_schedule_from) (PantheonSettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_from) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	gdouble (*get_night_light_schedule_to) (PantheonSettingsDaemonAccountsService* self);
	void (*set_night_light_schedule_to) (PantheonSettingsDaemonAccountsService* self, gdouble value);
	guint (*get_night_light_temperature) (PantheonSettingsDaemonAccountsService* self);
	void (*set_night_light_temperature) (PantheonSettingsDaemonAccountsService* self, guint value);
};

struct _GreeterUserCardPrivate {
	LightDMUser* _lightdm_user;
	gboolean _show_input;
	gboolean _is_24h;
	GtkGestureMultiPress* _click_gesture;
	PantheonAccountsService* greeter_act;
	PantheonSettingsDaemonAccountsService* settings_act;
	GtkRevealer* form_revealer;
	GtkStack* login_stack;
	GreeterPasswordEntry* password_entry;
	GtkBox* main_box;
	GreeterUserCardSelectionCheck* logged_in;
};

struct _GreeterUserCardSelectionCheck {
	GtkSpinner parent_instance;
	GreeterUserCardSelectionCheckPrivate * priv;
};

struct _GreeterUserCardSelectionCheckClass {
	GtkSpinnerClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	GreeterUserCard* self;
	GtkGrid* password_grid;
	GtkButton* login_button;
};

static gint GreeterUserCard_private_offset;
static gpointer greeter_user_card_parent_class = NULL;
static gpointer greeter_user_card_selection_check_parent_class = NULL;

VALA_EXTERN GType greeter_base_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBaseCard, g_object_unref)
VALA_EXTERN GType greeter_user_card_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCard, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_accounts_service_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_keyboard_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonSettingsDaemonAccountsServiceKeyboardLayout* pantheon_settings_daemon_accounts_service_keyboard_layout_dup (const PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_copy (const PantheonSettingsDaemonAccountsServiceKeyboardLayout* self,
                                                                     PantheonSettingsDaemonAccountsServiceKeyboardLayout* dest);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (PantheonSettingsDaemonAccountsServiceKeyboardLayout* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonSettingsDaemonAccountsServiceKeyboardLayout, pantheon_settings_daemon_accounts_service_keyboard_layout_destroy)
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_xkb_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonSettingsDaemonAccountsServiceXkbOption* pantheon_settings_daemon_accounts_service_xkb_option_dup (const PantheonSettingsDaemonAccountsServiceXkbOption* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_xkb_option_free (PantheonSettingsDaemonAccountsServiceXkbOption* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_xkb_option_copy (const PantheonSettingsDaemonAccountsServiceXkbOption* self,
                                                                PantheonSettingsDaemonAccountsServiceXkbOption* dest);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_xkb_option_destroy (PantheonSettingsDaemonAccountsServiceXkbOption* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonSettingsDaemonAccountsServiceXkbOption, pantheon_settings_daemon_accounts_service_xkb_option_destroy)
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_coordinates_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonSettingsDaemonAccountsServiceCoordinates* pantheon_settings_daemon_accounts_service_coordinates_dup (const PantheonSettingsDaemonAccountsServiceCoordinates* self);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_coordinates_free (PantheonSettingsDaemonAccountsServiceCoordinates* self);
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonSettingsDaemonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_settings_daemon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_settings_daemon_accounts_service_register_object (void* object,
                                                                 GDBusConnection* connection,
                                                                 const gchar* path,
                                                                 GError** error);
VALA_EXTERN GType greeter_password_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterPasswordEntry, g_object_unref)
static GType greeter_user_card_selection_check_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterUserCardSelectionCheck, g_object_unref)
VALA_EXTERN void greeter_base_card_wrong_credentials (GreeterBaseCard* self);
VALA_EXTERN GreeterUserCard* greeter_user_card_new (LightDMUser* lightdm_user);
VALA_EXTERN GreeterUserCard* greeter_user_card_construct (GType object_type,
                                              LightDMUser* lightdm_user);
static void greeter_user_card_set_check_style (GreeterUserCard* self);
static gchar* greeter_user_card_accent_to_string (GreeterUserCard* self,
                                           gint i);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_accent_color (PantheonSettingsDaemonAccountsService* self);
static void greeter_user_card_set_background_image (GreeterUserCard* self);
VALA_EXTERN GType greeter_background_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterBackgroundImage, g_object_unref)
VALA_EXTERN LightDMUser* greeter_user_card_get_lightdm_user (GreeterUserCard* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_picture_options (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_new_from_path (const gchar* path);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_construct_from_path (GType object_type,
                                                                      const gchar* path);
VALA_EXTERN gchar* pantheon_settings_daemon_accounts_service_get_primary_color (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_new_from_color (const gchar* color);
VALA_EXTERN GreeterBackgroundImage* greeter_background_image_construct_from_color (GType object_type,
                                                                       const gchar* color);
static void greeter_user_card_connect_to_dbus_interfaces (GreeterUserCard* self);
VALA_EXTERN gchar* pantheon_accounts_service_get_time_format (PantheonAccountsService* self);
VALA_EXTERN void greeter_user_card_set_is_24h (GreeterUserCard* self,
                                   gboolean value);
VALA_EXTERN gboolean greeter_base_card_get_need_password (GreeterBaseCard* self);
static void greeter_user_card_on_login (GreeterUserCard* self);
VALA_EXTERN gboolean greeter_base_card_get_connecting (GreeterBaseCard* self);
VALA_EXTERN void greeter_base_card_set_connecting (GreeterBaseCard* self,
                                       gboolean value);
static void greeter_user_card_update_collapsed_class (GreeterUserCard* self);
VALA_EXTERN gboolean greeter_user_card_get_show_input (GreeterUserCard* self);
VALA_EXTERN void greeter_user_card_set_settings (GreeterUserCard* self);
static void greeter_user_card_set_keyboard_layouts (GreeterUserCard* self);
static void greeter_user_card_set_mouse_touchpad_settings (GreeterUserCard* self);
static void greeter_user_card_set_interface_settings (GreeterUserCard* self);
static void greeter_user_card_set_wingpanel_settings (GreeterUserCard* self);
static void greeter_user_card_set_night_light_settings (GreeterUserCard* self);
static void greeter_user_card_set_power_settings (GreeterUserCard* self);
static void greeter_user_card_update_style (GreeterUserCard* self);
VALA_EXTERN PantheonSettingsDaemonAccountsServiceKeyboardLayout* pantheon_settings_daemon_accounts_service_get_keyboard_layouts (PantheonSettingsDaemonAccountsService* self,
                                                                                                                     gint* result_length1);
static void _vala_array_add1 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void _vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout * array,
                                                                           gssize array_length);
VALA_EXTERN guint pantheon_settings_daemon_accounts_service_get_active_keyboard_layout (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new2 (guint value);
VALA_EXTERN PantheonSettingsDaemonAccountsServiceXkbOption* pantheon_settings_daemon_accounts_service_get_xkb_options (PantheonSettingsDaemonAccountsService* self,
                                                                                                           gint* result_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_PantheonSettingsDaemonAccountsServiceXkbOption_array_free (PantheonSettingsDaemonAccountsServiceXkbOption * array,
                                                                      gssize array_length);
static GVariant* _variant_new3 (gchar** value,
                         gint value_length1);
static void greeter_user_card_set_or_reset_settings_key (GreeterUserCard* self,
                                                  GSettings* settings,
                                                  const gchar* key,
                                                  GVariant* value);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_left_handed (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_accel_profile (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_mouse_natural_scroll (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_mouse_speed (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_touchpad_click_method (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_touchpad_disable_while_typing (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_touchpad_edge_scrolling (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_touchpad_natural_scroll (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_touchpad_send_events (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_touchpad_speed (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_touchpad_tap_to_click (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_touchpad_two_finger_scrolling (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_cursor_blink (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_cursor_blink_time (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_cursor_blink_timeout (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_cursor_size (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_locate_pointer (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_text_scaling_factor (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gchar* pantheon_settings_daemon_accounts_service_get_document_font_name (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new4 (gchar* value);
VALA_EXTERN gchar* pantheon_settings_daemon_accounts_service_get_font_name (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new5 (gchar* value);
VALA_EXTERN gchar* pantheon_settings_daemon_accounts_service_get_monospace_font_name (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new6 (gchar* value);
VALA_EXTERN void pantheon_settings_daemon_accounts_service_get_last_coordinates (PantheonSettingsDaemonAccountsService* self,
                                                                     PantheonSettingsDaemonAccountsServiceCoordinates * result);
VALA_EXTERN gint pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule_from (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule_to (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_orientation_lock (PantheonSettingsDaemonAccountsService* self);
static GVariant* _variant_new7 (const gchar* value);
static GVariant* _variant_new8 (gchar* value);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_wingpanel_use_transparency (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_wingpanel_show_percentage (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_night_light_enabled (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gboolean pantheon_settings_daemon_accounts_service_get_night_light_schedule_automatic (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_night_light_schedule_from (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gdouble pantheon_settings_daemon_accounts_service_get_night_light_schedule_to (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN guint pantheon_settings_daemon_accounts_service_get_night_light_temperature (PantheonSettingsDaemonAccountsService* self);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_ac_timeout (PantheonAccountsService* self);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_ac_type (PantheonAccountsService* self);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_battery_timeout (PantheonAccountsService* self);
VALA_EXTERN gint pantheon_accounts_service_get_sleep_inactive_battery_type (PantheonAccountsService* self);
VALA_EXTERN GType greeter_settings_portal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSettingsPortal, g_object_unref)
VALA_EXTERN guint greeter_settings_portal_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GreeterSettingsPortal* greeter_settings_portal_get_default (void);
VALA_EXTERN gint pantheon_accounts_service_get_prefers_color_scheme (PantheonAccountsService* self);
VALA_EXTERN void greeter_settings_portal_set_prefers_color_scheme (GreeterSettingsPortal* self,
                                                       gint value);
static void greeter_user_card_real_wrong_credentials (GreeterBaseCard* base);
static gboolean __lambda13_ (GreeterUserCard* self);
static gboolean ___lambda13__gsource_func (gpointer self);
static void greeter_user_card_set_lightdm_user (GreeterUserCard* self,
                                         LightDMUser* value);
VALA_EXTERN void greeter_user_card_set_show_input (GreeterUserCard* self,
                                       gboolean value);
VALA_EXTERN gboolean greeter_user_card_get_is_24h (GreeterUserCard* self);
VALA_EXTERN GtkGestureMultiPress* greeter_user_card_get_click_gesture (GreeterUserCard* self);
static void greeter_user_card_set_click_gesture (GreeterUserCard* self,
                                          GtkGestureMultiPress* value);
static GreeterUserCardSelectionCheck* greeter_user_card_selection_check_new (void);
static GreeterUserCardSelectionCheck* greeter_user_card_selection_check_construct (GType object_type);
static GType greeter_user_card_selection_check_get_type_once (void);
static GObject * greeter_user_card_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN void greeter_base_card_set_need_password (GreeterBaseCard* self,
                                          gboolean value);
VALA_EXTERN GreeterPasswordEntry* greeter_password_entry_new (void);
VALA_EXTERN GreeterPasswordEntry* greeter_password_entry_construct (GType object_type);
VALA_EXTERN GType greeter_session_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSessionButton, g_object_unref)
VALA_EXTERN GreeterSessionButton* greeter_session_button_new (void);
VALA_EXTERN GreeterSessionButton* greeter_session_button_construct (GType object_type);
VALA_EXTERN GreeterCapsLockRevealer* greeter_caps_lock_revealer_new (void);
VALA_EXTERN GreeterCapsLockRevealer* greeter_caps_lock_revealer_construct (GType object_type);
VALA_EXTERN GType greeter_caps_lock_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCapsLockRevealer, g_object_unref)
static void _greeter_user_card_update_collapsed_class_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _greeter_user_card_on_login_gtk_entry_activate (GtkEntry* _sender,
                                                     gpointer self);
static void _greeter_user_card_on_login_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _greeter_user_card___lambda14_ (Block5Data* _data5_);
static void __greeter_user_card___lambda14__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _greeter_user_card___lambda15_ (GreeterUserCard* self);
static void __greeter_user_card___lambda15__gtk_widget_grab_focus (GtkWidget* _sender,
                                                            gpointer self);
static void greeter_user_card_finalize (GObject * obj);
static GType greeter_user_card_get_type_once (void);
static void _vala_greeter_user_card_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_greeter_user_card_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
greeter_user_card_get_instance_private (GreeterUserCard* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterUserCard_private_offset);
}

GreeterUserCard*
greeter_user_card_construct (GType object_type,
                             LightDMUser* lightdm_user)
{
	GreeterUserCard * self = NULL;
	g_return_val_if_fail (lightdm_user != NULL, NULL);
	self = (GreeterUserCard*) g_object_new (object_type, "lightdm-user", lightdm_user, NULL);
	return self;
}

GreeterUserCard*
greeter_user_card_new (LightDMUser* lightdm_user)
{
	return greeter_user_card_construct (GREETER_TYPE_USER_CARD, lightdm_user);
}

static void
greeter_user_card_set_check_style (GreeterUserCard* self)
{
	GreeterUserCardSelectionCheck* _tmp0_;
	GtkStyleContext* _tmp1_;
	PantheonSettingsDaemonAccountsService* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logged_in;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->settings_act;
	_tmp3_ = pantheon_settings_daemon_accounts_service_get_accent_color (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = greeter_user_card_accent_to_string (self, _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_style_context_add_class (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
}

static void
greeter_user_card_set_background_image (GreeterUserCard* self)
{
	GreeterBackgroundImage* background_image = NULL;
	gchar* background_path = NULL;
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean background_exists = FALSE;
	gboolean _tmp16_ = FALSE;
	PantheonSettingsDaemonAccountsService* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GtkBox* _tmp36_;
	GreeterBackgroundImage* _tmp37_;
	GtkBox* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lightdm_user;
	_tmp1_ = lightdm_user_get_background (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	background_path = _tmp3_;
	_tmp6_ = background_path;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = background_path;
		_tmp5_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		_tmp8_ = background_path;
		_tmp4_ = g_file_test (_tmp8_, G_FILE_TEST_IS_REGULAR);
	} else {
		_tmp4_ = FALSE;
	}
	background_exists = _tmp4_;
	if (!background_exists) {
		LightDMUser* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp9_ = self->priv->_lightdm_user;
		_tmp10_ = lightdm_user_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_build_filename ("/", "var", "lib", "lightdm-data", _tmp11_, "wallpaper", NULL);
		_g_free0 (background_path);
		background_path = _tmp12_;
		_tmp14_ = background_path;
		if (g_file_test (_tmp14_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp15_;
			_tmp15_ = background_path;
			_tmp13_ = g_file_test (_tmp15_, G_FILE_TEST_IS_REGULAR);
		} else {
			_tmp13_ = FALSE;
		}
		background_exists = _tmp13_;
	}
	_tmp17_ = self->priv->settings_act;
	_tmp18_ = pantheon_settings_daemon_accounts_service_get_picture_options (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != 0) {
		_tmp16_ = background_exists;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp20_;
		GreeterBackgroundImage* _tmp21_;
		_tmp20_ = background_path;
		_tmp21_ = greeter_background_image_new_from_path (_tmp20_);
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (background_image);
		background_image = _tmp21_;
	} else {
		gboolean _tmp22_ = FALSE;
		PantheonSettingsDaemonAccountsService* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp23_ = self->priv->settings_act;
		_tmp24_ = pantheon_settings_daemon_accounts_service_get_picture_options (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			PantheonSettingsDaemonAccountsService* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp26_ = self->priv->settings_act;
			_tmp27_ = pantheon_settings_daemon_accounts_service_get_primary_color (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = _tmp28_;
			_tmp22_ = _tmp29_ != NULL;
			_g_free0 (_tmp29_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			PantheonSettingsDaemonAccountsService* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GreeterBackgroundImage* _tmp34_;
			_tmp30_ = self->priv->settings_act;
			_tmp31_ = pantheon_settings_daemon_accounts_service_get_primary_color (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			_tmp34_ = greeter_background_image_new_from_color (_tmp33_);
			g_object_ref_sink (_tmp34_);
			_g_object_unref0 (background_image);
			background_image = _tmp34_;
			_g_free0 (_tmp33_);
		} else {
			GreeterBackgroundImage* _tmp35_;
			_tmp35_ = greeter_background_image_new_from_path (NULL);
			g_object_ref_sink (_tmp35_);
			_g_object_unref0 (background_image);
			background_image = _tmp35_;
		}
	}
	_tmp36_ = self->priv->main_box;
	_tmp37_ = background_image;
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = self->priv->main_box;
	gtk_widget_show_all ((GtkWidget*) _tmp38_);
	_g_free0 (background_path);
	_g_object_unref0 (background_image);
}

static gchar*
greeter_user_card_accent_to_string (GreeterUserCard* self,
                                    gint i)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (i) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("strawberry");
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("orange");
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("banana");
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("lime");
			result = _tmp3_;
			return result;
		}
		case 5:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("mint");
			result = _tmp4_;
			return result;
		}
		case 7:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("grape");
			result = _tmp5_;
			return result;
		}
		case 8:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("bubblegum");
			result = _tmp6_;
			return result;
		}
		case 9:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("cocoa");
			result = _tmp7_;
			return result;
		}
		case 10:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("slate");
			result = _tmp8_;
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("blueberry");
			result = _tmp9_;
			return result;
		}
	}
}

static void
greeter_user_card_connect_to_dbus_interfaces (GreeterUserCard* self)
{
	gchar* account_path = NULL;
	LightDMUser* _tmp0_;
	uid_t _tmp1_;
	uid_t _tmp2_;
	gchar* _tmp3_;
	LightDMUser* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_lightdm_user;
	_tmp1_ = lightdm_user_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("/org/freedesktop/Accounts/User%d", (gint) _tmp2_);
	account_path = _tmp3_;
	{
		PantheonAccountsService* _tmp4_ = NULL;
		const gchar* _tmp5_;
		PantheonAccountsService* _tmp6_;
		PantheonAccountsService* _tmp7_;
		PantheonSettingsDaemonAccountsService* _tmp8_ = NULL;
		const gchar* _tmp9_;
		PantheonSettingsDaemonAccountsService* _tmp10_;
		PantheonSettingsDaemonAccountsService* _tmp11_;
		PantheonAccountsService* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp5_ = account_path;
		_tmp6_ = (PantheonAccountsService*) g_initable_new (PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp5_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
		_tmp4_ = (PantheonAccountsService*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->greeter_act);
		self->priv->greeter_act = _tmp7_;
		_tmp9_ = account_path;
		_tmp10_ = (PantheonSettingsDaemonAccountsService*) g_initable_new (PANTHEON_SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp9_, "g-interface-name", "io.elementary.SettingsDaemon.AccountsService", NULL);
		_tmp8_ = (PantheonSettingsDaemonAccountsService*) _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->settings_act);
		self->priv->settings_act = _tmp11_;
		_tmp12_ = self->priv->greeter_act;
		_tmp13_ = pantheon_accounts_service_get_time_format (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		greeter_user_card_set_is_24h (self, g_strcmp0 (_tmp15_, "12h") != 0);
		_g_free0 (_tmp15_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("UserCard.vala:252: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (account_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	greeter_user_card_set_background_image (self);
	greeter_user_card_set_check_style (self);
	_tmp18_ = self->priv->_lightdm_user;
	_tmp19_ = lightdm_user_get_is_locked (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		GtkStack* _tmp21_;
		_tmp21_ = self->priv->login_stack;
		gtk_stack_set_visible_child_name (_tmp21_, "disabled");
	} else {
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp22_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
		_tmp23_ = _tmp22_;
		if (_tmp23_) {
			GtkStack* _tmp24_;
			_tmp24_ = self->priv->login_stack;
			gtk_stack_set_visible_child_name (_tmp24_, "password");
		} else {
			GtkStack* _tmp25_;
			_tmp25_ = self->priv->login_stack;
			gtk_stack_set_visible_child_name (_tmp25_, "button");
		}
	}
	_g_free0 (account_path);
}

static void
greeter_user_card_on_login (GreeterUserCard* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_base_card_get_connecting ((GreeterBaseCard*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	greeter_base_card_set_connecting ((GreeterBaseCard*) self, TRUE);
	_tmp2_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GreeterPasswordEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->password_entry;
		_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_signal_emit_by_name ((GreeterBaseCard*) self, "do-connect", _tmp6_);
	} else {
		g_signal_emit_by_name ((GreeterBaseCard*) self, "do-connect", NULL);
	}
}

static void
greeter_user_card_update_collapsed_class (GreeterUserCard* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_show_input;
	if (_tmp0_) {
		GtkBox* _tmp1_;
		GtkStyleContext* _tmp2_;
		_tmp1_ = self->priv->main_box;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_remove_class (_tmp2_, "collapsed");
	} else {
		GtkBox* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp3_ = self->priv->main_box;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "collapsed");
	}
}

void
greeter_user_card_set_settings (GreeterUserCard* self)
{
	g_return_if_fail (self != NULL);
	greeter_user_card_set_keyboard_layouts (self);
	greeter_user_card_set_mouse_touchpad_settings (self);
	greeter_user_card_set_interface_settings (self);
	greeter_user_card_set_wingpanel_settings (self);
	greeter_user_card_set_night_light_settings (self);
	greeter_user_card_set_power_settings (self);
	greeter_user_card_update_style (self);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
_vala_array_add1 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (PantheonSettingsDaemonAccountsServiceKeyboardLayout * array,
                                                                      gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (&array[i]);
		}
	}
	g_free (array);
}

static GVariant*
_variant_new2 (guint value)
{
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_PantheonSettingsDaemonAccountsServiceXkbOption_array_free (PantheonSettingsDaemonAccountsServiceXkbOption * array,
                                                                 gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			pantheon_settings_daemon_accounts_service_xkb_option_destroy (&array[i]);
		}
	}
	g_free (array);
}

static GVariant*
_variant_new3 (gchar** value,
               gint value_length1)
{
	gchar** _tmp48_;
	GVariantBuilder _tmp49_;
	gint _tmp50_;
	_tmp48_ = value;
	g_variant_builder_init (&_tmp49_, G_VARIANT_TYPE ("as"));
	for (_tmp50_ = 0; _tmp50_ < value_length1; _tmp50_++) {
		g_variant_builder_add_value (&_tmp49_, g_variant_new_string (*_tmp48_));
		_tmp48_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp49_));
}

static void
greeter_user_card_set_keyboard_layouts (GreeterUserCard* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GVariant** elements = NULL;
	GVariant** _tmp1_;
	gint elements_length1;
	gint _elements_size_;
	PantheonSettingsDaemonAccountsService* _tmp2_;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	PantheonSettingsDaemonAccountsServiceKeyboardLayout* _tmp5_;
	gint _tmp5__length1;
	GVariant* layouts_list = NULL;
	GVariantType* _tmp24_;
	GVariantType* _tmp25_;
	GVariant** _tmp26_;
	gint _tmp26__length1;
	GVariant* _tmp27_;
	GVariant* _tmp28_;
	GSettings* _tmp29_;
	GVariant* _tmp30_;
	GSettings* _tmp31_;
	PantheonSettingsDaemonAccountsService* _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	GVariant* _tmp35_;
	gchar** options = NULL;
	gchar** _tmp36_;
	gint options_length1;
	gint _options_size_;
	PantheonSettingsDaemonAccountsService* _tmp37_;
	PantheonSettingsDaemonAccountsServiceXkbOption* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_ = 0;
	PantheonSettingsDaemonAccountsServiceXkbOption* _tmp40_;
	gint _tmp40__length1;
	GSettings* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	GVariant* _tmp51_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.input-sources");
	settings = _tmp0_;
	_tmp1_ = g_new0 (GVariant*, 0 + 1);
	elements = _tmp1_;
	elements_length1 = 0;
	_elements_size_ = elements_length1;
	_tmp2_ = self->priv->settings_act;
	_tmp3_ = pantheon_settings_daemon_accounts_service_get_keyboard_layouts (_tmp2_, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	{
		PantheonSettingsDaemonAccountsServiceKeyboardLayout* layout_collection = NULL;
		gint layout_collection_length1 = 0;
		gint _layout_collection_size_ = 0;
		gint layout_it = 0;
		layout_collection = _tmp5_;
		layout_collection_length1 = _tmp5__length1;
		for (layout_it = 0; layout_it < layout_collection_length1; layout_it = layout_it + 1) {
			PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp6_;
			PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp7_ = {0};
			PantheonSettingsDaemonAccountsServiceKeyboardLayout layout = {0};
			_tmp6_ = layout_collection[layout_it];
			pantheon_settings_daemon_accounts_service_keyboard_layout_copy (&_tmp6_, &_tmp7_);
			layout = _tmp7_;
			{
				GVariant* first = NULL;
				PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp8_;
				const gchar* _tmp9_;
				GVariant* _tmp10_;
				GVariant* second = NULL;
				PantheonSettingsDaemonAccountsServiceKeyboardLayout _tmp11_;
				const gchar* _tmp12_;
				GVariant* _tmp13_;
				GVariant* _result_ = NULL;
				GVariant* _tmp14_;
				GVariant* _tmp15_;
				GVariant* _tmp16_;
				GVariant* _tmp17_;
				GVariant** _tmp18_;
				GVariant** _tmp19_;
				gint _tmp19__length1;
				GVariant* _tmp20_;
				GVariant* _tmp21_;
				GVariant* _tmp22_;
				GVariant* _tmp23_;
				_tmp8_ = layout;
				_tmp9_ = _tmp8_.backend;
				_tmp10_ = g_variant_new_string (_tmp9_);
				g_variant_ref_sink (_tmp10_);
				first = _tmp10_;
				_tmp11_ = layout;
				_tmp12_ = _tmp11_.name;
				_tmp13_ = g_variant_new_string (_tmp12_);
				g_variant_ref_sink (_tmp13_);
				second = _tmp13_;
				_tmp14_ = first;
				_tmp15_ = _g_variant_ref0 (_tmp14_);
				_tmp16_ = second;
				_tmp17_ = _g_variant_ref0 (_tmp16_);
				_tmp18_ = g_new0 (GVariant*, 2 + 1);
				_tmp18_[0] = _tmp15_;
				_tmp18_[1] = _tmp17_;
				_tmp19_ = _tmp18_;
				_tmp19__length1 = 2;
				_tmp20_ = g_variant_new_tuple (_tmp19_, 2);
				g_variant_ref_sink (_tmp20_);
				_tmp21_ = _tmp20_;
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_variant_unref), NULL);
				_result_ = _tmp21_;
				_tmp22_ = _result_;
				_tmp23_ = _g_variant_ref0 (_tmp22_);
				_vala_array_add1 (&elements, &elements_length1, &_elements_size_, _tmp23_);
				_g_variant_unref0 (_result_);
				_g_variant_unref0 (second);
				_g_variant_unref0 (first);
				pantheon_settings_daemon_accounts_service_keyboard_layout_destroy (&layout);
			}
		}
		layout_collection = (_vala_PantheonSettingsDaemonAccountsServiceKeyboardLayout_array_free (layout_collection, layout_collection_length1), NULL);
	}
	_tmp24_ = g_variant_type_new ("(ss)");
	_tmp25_ = _tmp24_;
	_tmp26_ = elements;
	_tmp26__length1 = elements_length1;
	_tmp27_ = g_variant_new_array (_tmp25_, _tmp26_, _tmp26__length1);
	g_variant_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	_g_variant_type_free0 (_tmp25_);
	layouts_list = _tmp28_;
	_tmp29_ = settings;
	_tmp30_ = layouts_list;
	g_settings_set_value (_tmp29_, "sources", _tmp30_);
	_tmp31_ = settings;
	_tmp32_ = self->priv->settings_act;
	_tmp33_ = pantheon_settings_daemon_accounts_service_get_active_keyboard_layout (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _variant_new2 (_tmp34_);
	g_settings_set_value (_tmp31_, "current", _tmp35_);
	_g_variant_unref0 (_tmp35_);
	_tmp36_ = g_new0 (gchar*, 0 + 1);
	options = _tmp36_;
	options_length1 = 0;
	_options_size_ = options_length1;
	_tmp37_ = self->priv->settings_act;
	_tmp38_ = pantheon_settings_daemon_accounts_service_get_xkb_options (_tmp37_, &_tmp39_);
	_tmp38__length1 = _tmp39_;
	_tmp40_ = _tmp38_;
	_tmp40__length1 = _tmp38__length1;
	{
		PantheonSettingsDaemonAccountsServiceXkbOption* option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp40_;
		option_collection_length1 = _tmp40__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			PantheonSettingsDaemonAccountsServiceXkbOption _tmp41_;
			PantheonSettingsDaemonAccountsServiceXkbOption _tmp42_ = {0};
			PantheonSettingsDaemonAccountsServiceXkbOption option = {0};
			_tmp41_ = option_collection[option_it];
			pantheon_settings_daemon_accounts_service_xkb_option_copy (&_tmp41_, &_tmp42_);
			option = _tmp42_;
			{
				PantheonSettingsDaemonAccountsServiceXkbOption _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp43_ = option;
				_tmp44_ = _tmp43_.option;
				_tmp45_ = g_strdup (_tmp44_);
				_vala_array_add2 (&options, &options_length1, &_options_size_, _tmp45_);
				pantheon_settings_daemon_accounts_service_xkb_option_destroy (&option);
			}
		}
		option_collection = (_vala_PantheonSettingsDaemonAccountsServiceXkbOption_array_free (option_collection, option_collection_length1), NULL);
	}
	_tmp46_ = settings;
	_tmp47_ = options;
	_tmp47__length1 = options_length1;
	_tmp51_ = _variant_new3 (_tmp47_, _tmp47__length1);
	g_settings_set_value (_tmp46_, "xkb-options", _tmp51_);
	_g_variant_unref0 (_tmp51_);
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (layouts_list);
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_object_unref0 (settings);
}

static void
greeter_user_card_set_or_reset_settings_key (GreeterUserCard* self,
                                             GSettings* settings,
                                             const gchar* key,
                                             GVariant* value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (value != NULL) {
		g_settings_set_value (settings, key, value);
	} else {
		g_settings_reset (settings, key);
	}
}

static void
greeter_user_card_set_mouse_touchpad_settings (GreeterUserCard* self)
{
	GSettings* mouse_settings = NULL;
	GSettings* _tmp0_;
	PantheonSettingsDaemonAccountsService* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	PantheonSettingsDaemonAccountsService* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PantheonSettingsDaemonAccountsService* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	PantheonSettingsDaemonAccountsService* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GSettings* touchpad_settings = NULL;
	GSettings* _tmp13_;
	PantheonSettingsDaemonAccountsService* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	PantheonSettingsDaemonAccountsService* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	PantheonSettingsDaemonAccountsService* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	PantheonSettingsDaemonAccountsService* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	PantheonSettingsDaemonAccountsService* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	PantheonSettingsDaemonAccountsService* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	PantheonSettingsDaemonAccountsService* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	PantheonSettingsDaemonAccountsService* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.peripherals.mouse");
	mouse_settings = _tmp0_;
	_tmp1_ = self->priv->settings_act;
	_tmp2_ = pantheon_settings_daemon_accounts_service_get_left_handed (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (mouse_settings, "left-handed", _tmp3_);
	_tmp4_ = self->priv->settings_act;
	_tmp5_ = pantheon_settings_daemon_accounts_service_get_accel_profile (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_enum (mouse_settings, "accel-profile", _tmp6_);
	_tmp7_ = self->priv->settings_act;
	_tmp8_ = pantheon_settings_daemon_accounts_service_get_mouse_natural_scroll (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_boolean (mouse_settings, "natural-scroll", _tmp9_);
	_tmp10_ = self->priv->settings_act;
	_tmp11_ = pantheon_settings_daemon_accounts_service_get_mouse_speed (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_double (mouse_settings, "speed", _tmp12_);
	_tmp13_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	touchpad_settings = _tmp13_;
	_tmp14_ = self->priv->settings_act;
	_tmp15_ = pantheon_settings_daemon_accounts_service_get_touchpad_click_method (_tmp14_);
	_tmp16_ = _tmp15_;
	g_settings_set_enum (touchpad_settings, "click-method", _tmp16_);
	_tmp17_ = self->priv->settings_act;
	_tmp18_ = pantheon_settings_daemon_accounts_service_get_touchpad_disable_while_typing (_tmp17_);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (touchpad_settings, "disable-while-typing", _tmp19_);
	_tmp20_ = self->priv->settings_act;
	_tmp21_ = pantheon_settings_daemon_accounts_service_get_touchpad_edge_scrolling (_tmp20_);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (touchpad_settings, "edge-scrolling-enabled", _tmp22_);
	_tmp23_ = self->priv->settings_act;
	_tmp24_ = pantheon_settings_daemon_accounts_service_get_touchpad_natural_scroll (_tmp23_);
	_tmp25_ = _tmp24_;
	g_settings_set_boolean (touchpad_settings, "natural-scroll", _tmp25_);
	_tmp26_ = self->priv->settings_act;
	_tmp27_ = pantheon_settings_daemon_accounts_service_get_touchpad_send_events (_tmp26_);
	_tmp28_ = _tmp27_;
	g_settings_set_enum (touchpad_settings, "send-events", _tmp28_);
	_tmp29_ = self->priv->settings_act;
	_tmp30_ = pantheon_settings_daemon_accounts_service_get_touchpad_speed (_tmp29_);
	_tmp31_ = _tmp30_;
	g_settings_set_double (touchpad_settings, "speed", _tmp31_);
	_tmp32_ = self->priv->settings_act;
	_tmp33_ = pantheon_settings_daemon_accounts_service_get_touchpad_tap_to_click (_tmp32_);
	_tmp34_ = _tmp33_;
	g_settings_set_boolean (touchpad_settings, "tap-to-click", _tmp34_);
	_tmp35_ = self->priv->settings_act;
	_tmp36_ = pantheon_settings_daemon_accounts_service_get_touchpad_two_finger_scrolling (_tmp35_);
	_tmp37_ = _tmp36_;
	g_settings_set_boolean (touchpad_settings, "two-finger-scrolling-enabled", _tmp37_);
	_g_object_unref0 (touchpad_settings);
	_g_object_unref0 (mouse_settings);
}

static GVariant*
_variant_new4 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new6 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new8 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
greeter_user_card_set_interface_settings (GreeterUserCard* self)
{
	GSettings* interface_settings = NULL;
	GSettings* _tmp0_;
	PantheonSettingsDaemonAccountsService* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	PantheonSettingsDaemonAccountsService* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PantheonSettingsDaemonAccountsService* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	PantheonSettingsDaemonAccountsService* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	PantheonSettingsDaemonAccountsService* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	PantheonSettingsDaemonAccountsService* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	PantheonSettingsDaemonAccountsService* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GVariant* _tmp23_;
	PantheonSettingsDaemonAccountsService* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GVariant* _tmp28_;
	PantheonSettingsDaemonAccountsService* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GVariant* _tmp33_;
	GSettings* settings_daemon_settings = NULL;
	GSettings* _tmp34_;
	GVariant* latitude = NULL;
	PantheonSettingsDaemonAccountsService* _tmp35_;
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp36_ = {0};
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp37_;
	GVariant* _tmp38_;
	GVariant* longitude = NULL;
	PantheonSettingsDaemonAccountsService* _tmp39_;
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp40_ = {0};
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp41_;
	GVariant* _tmp42_;
	GVariant* coordinates = NULL;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GVariant** _tmp45_;
	GVariant** _tmp46_;
	gint _tmp46__length1;
	GVariant* _tmp47_;
	GVariant* _tmp48_;
	PantheonSettingsDaemonAccountsService* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	PantheonSettingsDaemonAccountsService* _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	PantheonSettingsDaemonAccountsService* _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	GSettings* touchscreen_settings = NULL;
	GSettings* _tmp58_;
	PantheonSettingsDaemonAccountsService* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp61_;
	GSettings* background_settings = NULL;
	GSettings* _tmp62_;
	PantheonSettingsDaemonAccountsService* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	LightDMUser* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	GVariant* _tmp69_;
	PantheonSettingsDaemonAccountsService* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	GVariant* _tmp74_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	interface_settings = _tmp0_;
	_tmp1_ = self->priv->settings_act;
	_tmp2_ = pantheon_settings_daemon_accounts_service_get_cursor_blink (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (interface_settings, "cursor-blink", _tmp3_);
	_tmp4_ = self->priv->settings_act;
	_tmp5_ = pantheon_settings_daemon_accounts_service_get_cursor_blink_time (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_int (interface_settings, "cursor-blink-time", _tmp6_);
	_tmp7_ = self->priv->settings_act;
	_tmp8_ = pantheon_settings_daemon_accounts_service_get_cursor_blink_timeout (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_int (interface_settings, "cursor-blink-timeout", _tmp9_);
	_tmp10_ = self->priv->settings_act;
	_tmp11_ = pantheon_settings_daemon_accounts_service_get_cursor_size (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_int (interface_settings, "cursor-size", _tmp12_);
	_tmp13_ = self->priv->settings_act;
	_tmp14_ = pantheon_settings_daemon_accounts_service_get_locate_pointer (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_boolean (interface_settings, "locate-pointer", _tmp15_);
	_tmp16_ = self->priv->settings_act;
	_tmp17_ = pantheon_settings_daemon_accounts_service_get_text_scaling_factor (_tmp16_);
	_tmp18_ = _tmp17_;
	g_settings_set_double (interface_settings, "text-scaling-factor", _tmp18_);
	_tmp19_ = self->priv->settings_act;
	_tmp20_ = pantheon_settings_daemon_accounts_service_get_document_font_name (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp23_ = _variant_new4 (_tmp22_);
	greeter_user_card_set_or_reset_settings_key (self, interface_settings, "document-font-name", _tmp23_);
	_g_variant_unref0 (_tmp23_);
	_g_free0 (_tmp22_);
	_tmp24_ = self->priv->settings_act;
	_tmp25_ = pantheon_settings_daemon_accounts_service_get_font_name (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp28_ = _variant_new5 (_tmp27_);
	greeter_user_card_set_or_reset_settings_key (self, interface_settings, "font-name", _tmp28_);
	_g_variant_unref0 (_tmp28_);
	_g_free0 (_tmp27_);
	_tmp29_ = self->priv->settings_act;
	_tmp30_ = pantheon_settings_daemon_accounts_service_get_monospace_font_name (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp33_ = _variant_new6 (_tmp32_);
	greeter_user_card_set_or_reset_settings_key (self, interface_settings, "monospace-font-name", _tmp33_);
	_g_variant_unref0 (_tmp33_);
	_g_free0 (_tmp32_);
	_tmp34_ = g_settings_new ("io.elementary.settings-daemon.prefers-color-scheme");
	settings_daemon_settings = _tmp34_;
	_tmp35_ = self->priv->settings_act;
	pantheon_settings_daemon_accounts_service_get_last_coordinates (_tmp35_, &_tmp36_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_variant_new_double (_tmp37_.latitude);
	g_variant_ref_sink (_tmp38_);
	latitude = _tmp38_;
	_tmp39_ = self->priv->settings_act;
	pantheon_settings_daemon_accounts_service_get_last_coordinates (_tmp39_, &_tmp40_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_variant_new_double (_tmp41_.longitude);
	g_variant_ref_sink (_tmp42_);
	longitude = _tmp42_;
	_tmp43_ = _g_variant_ref0 (latitude);
	_tmp44_ = _g_variant_ref0 (longitude);
	_tmp45_ = g_new0 (GVariant*, 2 + 1);
	_tmp45_[0] = _tmp43_;
	_tmp45_[1] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 2;
	_tmp47_ = g_variant_new_tuple (_tmp46_, 2);
	g_variant_ref_sink (_tmp47_);
	_tmp48_ = _tmp47_;
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_variant_unref), NULL);
	coordinates = _tmp48_;
	g_settings_set_value (settings_daemon_settings, "last-coordinates", coordinates);
	_tmp49_ = self->priv->settings_act;
	_tmp50_ = pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule (_tmp49_);
	_tmp51_ = _tmp50_;
	g_settings_set_enum (settings_daemon_settings, "prefer-dark-schedule", _tmp51_);
	_tmp52_ = self->priv->settings_act;
	_tmp53_ = pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule_from (_tmp52_);
	_tmp54_ = _tmp53_;
	g_settings_set_double (settings_daemon_settings, "prefer-dark-schedule-from", _tmp54_);
	_tmp55_ = self->priv->settings_act;
	_tmp56_ = pantheon_settings_daemon_accounts_service_get_prefer_dark_schedule_to (_tmp55_);
	_tmp57_ = _tmp56_;
	g_settings_set_double (settings_daemon_settings, "prefer-dark-schedule-to", _tmp57_);
	_tmp58_ = g_settings_new ("org.gnome.settings-daemon.peripherals.touchscreen");
	touchscreen_settings = _tmp58_;
	_tmp59_ = self->priv->settings_act;
	_tmp60_ = pantheon_settings_daemon_accounts_service_get_orientation_lock (_tmp59_);
	_tmp61_ = _tmp60_;
	g_settings_set_boolean (touchscreen_settings, "orientation-lock", _tmp61_);
	_tmp62_ = g_settings_new ("org.gnome.desktop.background");
	background_settings = _tmp62_;
	_tmp63_ = self->priv->settings_act;
	_tmp64_ = pantheon_settings_daemon_accounts_service_get_picture_options (_tmp63_);
	_tmp65_ = _tmp64_;
	g_settings_set_enum (background_settings, "picture-options", _tmp65_);
	_tmp66_ = self->priv->_lightdm_user;
	_tmp67_ = lightdm_user_get_background (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = _variant_new7 (_tmp68_);
	greeter_user_card_set_or_reset_settings_key (self, background_settings, "picture-uri", _tmp69_);
	_g_variant_unref0 (_tmp69_);
	_tmp70_ = self->priv->settings_act;
	_tmp71_ = pantheon_settings_daemon_accounts_service_get_primary_color (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = _tmp72_;
	_tmp74_ = _variant_new8 (_tmp73_);
	greeter_user_card_set_or_reset_settings_key (self, background_settings, "primary-color", _tmp74_);
	_g_variant_unref0 (_tmp74_);
	_g_free0 (_tmp73_);
	_g_object_unref0 (background_settings);
	_g_object_unref0 (touchscreen_settings);
	_g_variant_unref0 (coordinates);
	_g_variant_unref0 (longitude);
	_g_variant_unref0 (latitude);
	_g_object_unref0 (settings_daemon_settings);
	_g_object_unref0 (interface_settings);
}

static void
greeter_user_card_set_wingpanel_settings (GreeterUserCard* self)
{
	GSettingsSchema* wingpanel_schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* wingpanel_power_schema = NULL;
	GSettingsSchemaSource* _tmp10_;
	GSettingsSchema* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GSettingsSchema* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "io.elementary.desktop.wingpanel", TRUE);
	wingpanel_schema = _tmp1_;
	_tmp3_ = wingpanel_schema;
	if (_tmp3_ != NULL) {
		GSettingsSchema* _tmp4_;
		_tmp4_ = wingpanel_schema;
		_tmp2_ = g_settings_schema_has_key (_tmp4_, "use-transparency");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GSettings* wingpanel_settings = NULL;
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		PantheonSettingsDaemonAccountsService* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = g_settings_new ("io.elementary.desktop.wingpanel");
		wingpanel_settings = _tmp5_;
		_tmp6_ = wingpanel_settings;
		_tmp7_ = self->priv->settings_act;
		_tmp8_ = pantheon_settings_daemon_accounts_service_get_wingpanel_use_transparency (_tmp7_);
		_tmp9_ = _tmp8_;
		g_settings_set_boolean (_tmp6_, "use-transparency", _tmp9_);
		_g_object_unref0 (wingpanel_settings);
	}
	_tmp10_ = g_settings_schema_source_get_default ();
	_tmp11_ = g_settings_schema_source_lookup (_tmp10_, "io.elementary.desktop.wingpanel.power", TRUE);
	wingpanel_power_schema = _tmp11_;
	_tmp13_ = wingpanel_power_schema;
	if (_tmp13_ != NULL) {
		GSettingsSchema* _tmp14_;
		_tmp14_ = wingpanel_power_schema;
		_tmp12_ = g_settings_schema_has_key (_tmp14_, "show-percentage");
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GSettings* wingpanel_power_settings = NULL;
		GSettings* _tmp15_;
		GSettings* _tmp16_;
		PantheonSettingsDaemonAccountsService* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp15_ = g_settings_new ("io.elementary.desktop.wingpanel.power");
		wingpanel_power_settings = _tmp15_;
		_tmp16_ = wingpanel_power_settings;
		_tmp17_ = self->priv->settings_act;
		_tmp18_ = pantheon_settings_daemon_accounts_service_get_wingpanel_show_percentage (_tmp17_);
		_tmp19_ = _tmp18_;
		g_settings_set_boolean (_tmp16_, "show-percentage", _tmp19_);
		_g_object_unref0 (wingpanel_power_settings);
	}
	_g_settings_schema_unref0 (wingpanel_power_schema);
	_g_settings_schema_unref0 (wingpanel_schema);
}

static void
greeter_user_card_set_night_light_settings (GreeterUserCard* self)
{
	GSettings* night_light_settings = NULL;
	GSettings* _tmp0_;
	PantheonSettingsDaemonAccountsService* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* latitude = NULL;
	PantheonSettingsDaemonAccountsService* _tmp4_;
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp5_ = {0};
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp6_;
	GVariant* _tmp7_;
	GVariant* longitude = NULL;
	PantheonSettingsDaemonAccountsService* _tmp8_;
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp9_ = {0};
	PantheonSettingsDaemonAccountsServiceCoordinates _tmp10_;
	GVariant* _tmp11_;
	GVariant* coordinates = NULL;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant** _tmp14_;
	GVariant** _tmp15_;
	gint _tmp15__length1;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	PantheonSettingsDaemonAccountsService* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	PantheonSettingsDaemonAccountsService* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	PantheonSettingsDaemonAccountsService* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	PantheonSettingsDaemonAccountsService* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	night_light_settings = _tmp0_;
	_tmp1_ = self->priv->settings_act;
	_tmp2_ = pantheon_settings_daemon_accounts_service_get_night_light_enabled (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (night_light_settings, "night-light-enabled", _tmp3_);
	_tmp4_ = self->priv->settings_act;
	pantheon_settings_daemon_accounts_service_get_last_coordinates (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_new_double (_tmp6_.latitude);
	g_variant_ref_sink (_tmp7_);
	latitude = _tmp7_;
	_tmp8_ = self->priv->settings_act;
	pantheon_settings_daemon_accounts_service_get_last_coordinates (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_new_double (_tmp10_.longitude);
	g_variant_ref_sink (_tmp11_);
	longitude = _tmp11_;
	_tmp12_ = _g_variant_ref0 (latitude);
	_tmp13_ = _g_variant_ref0 (longitude);
	_tmp14_ = g_new0 (GVariant*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = g_variant_new_tuple (_tmp15_, 2);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_variant_unref), NULL);
	coordinates = _tmp17_;
	g_settings_set_value (night_light_settings, "night-light-last-coordinates", coordinates);
	_tmp18_ = self->priv->settings_act;
	_tmp19_ = pantheon_settings_daemon_accounts_service_get_night_light_schedule_automatic (_tmp18_);
	_tmp20_ = _tmp19_;
	g_settings_set_boolean (night_light_settings, "night-light-schedule-automatic", _tmp20_);
	_tmp21_ = self->priv->settings_act;
	_tmp22_ = pantheon_settings_daemon_accounts_service_get_night_light_schedule_from (_tmp21_);
	_tmp23_ = _tmp22_;
	g_settings_set_double (night_light_settings, "night-light-schedule-from", _tmp23_);
	_tmp24_ = self->priv->settings_act;
	_tmp25_ = pantheon_settings_daemon_accounts_service_get_night_light_schedule_to (_tmp24_);
	_tmp26_ = _tmp25_;
	g_settings_set_double (night_light_settings, "night-light-schedule-to", _tmp26_);
	_tmp27_ = self->priv->settings_act;
	_tmp28_ = pantheon_settings_daemon_accounts_service_get_night_light_temperature (_tmp27_);
	_tmp29_ = _tmp28_;
	g_settings_set_uint (night_light_settings, "night-light-temperature", _tmp29_);
	_g_variant_unref0 (coordinates);
	_g_variant_unref0 (longitude);
	_g_variant_unref0 (latitude);
	_g_object_unref0 (night_light_settings);
}

static void
greeter_user_card_set_power_settings (GreeterUserCard* self)
{
	GSettings* power_settings = NULL;
	GSettings* _tmp0_;
	PantheonAccountsService* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	PantheonAccountsService* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PantheonAccountsService* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	PantheonAccountsService* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.settings-daemon.plugins.power");
	power_settings = _tmp0_;
	_tmp1_ = self->priv->greeter_act;
	_tmp2_ = pantheon_accounts_service_get_sleep_inactive_ac_timeout (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (power_settings, "sleep-inactive-ac-timeout", _tmp3_);
	_tmp4_ = self->priv->greeter_act;
	_tmp5_ = pantheon_accounts_service_get_sleep_inactive_ac_type (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_enum (power_settings, "sleep-inactive-ac-type", _tmp6_);
	_tmp7_ = self->priv->greeter_act;
	_tmp8_ = pantheon_accounts_service_get_sleep_inactive_battery_timeout (_tmp7_);
	_tmp9_ = _tmp8_;
	g_settings_set_int (power_settings, "sleep-inactive-battery-timeout", _tmp9_);
	_tmp10_ = self->priv->greeter_act;
	_tmp11_ = pantheon_accounts_service_get_sleep_inactive_battery_type (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_enum (power_settings, "sleep-inactive-battery-type", _tmp12_);
	_g_object_unref0 (power_settings);
}

static void
greeter_user_card_update_style (GreeterUserCard* self)
{
	GSettings* interface_settings = NULL;
	GSettings* _tmp0_;
	PantheonSettingsDaemonAccountsService* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GreeterSettingsPortal* _tmp8_;
	PantheonAccountsService* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.interface");
	interface_settings = _tmp0_;
	_tmp1_ = self->priv->settings_act;
	_tmp2_ = pantheon_settings_daemon_accounts_service_get_accent_color (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = greeter_user_card_accent_to_string (self, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("io.elementary.stylesheet.", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_string (interface_settings, "gtk-theme", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = greeter_settings_portal_get_default ();
	_tmp9_ = self->priv->greeter_act;
	_tmp10_ = pantheon_accounts_service_get_prefers_color_scheme (_tmp9_);
	_tmp11_ = _tmp10_;
	greeter_settings_portal_set_prefers_color_scheme (_tmp8_, _tmp11_);
	_g_object_unref0 (interface_settings);
}

static gboolean
__lambda13_ (GreeterUserCard* self)
{
	GreeterPasswordEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	GreeterPasswordEntry* _tmp4_;
	gboolean result;
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, GTK_STYLE_CLASS_ERROR);
	_tmp2_ = self->priv->main_box;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "shake");
	greeter_base_card_set_connecting ((GreeterBaseCard*) self, FALSE);
	_tmp4_ = self->priv->password_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((GreeterUserCard*) self);
	return result;
}

static void
greeter_user_card_real_wrong_credentials (GreeterBaseCard* base)
{
	GreeterUserCard * self;
	GreeterPasswordEntry* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	self = (GreeterUserCard*) base;
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_ERROR);
	_tmp2_ = self->priv->main_box;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "shake");
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GREETER_BASE_CARD_ERROR_SHAKE_DURATION, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
}

LightDMUser*
greeter_user_card_get_lightdm_user (GreeterUserCard* self)
{
	LightDMUser* result;
	LightDMUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lightdm_user;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_user_card_set_lightdm_user (GreeterUserCard* self,
                                    LightDMUser* value)
{
	LightDMUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_lightdm_user (self);
	if (old_value != value) {
		LightDMUser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_lightdm_user);
		self->priv->_lightdm_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_LIGHTDM_USER_PROPERTY]);
	}
}

gboolean
greeter_user_card_get_show_input (GreeterUserCard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_input;
	return result;
}

void
greeter_user_card_set_show_input (GreeterUserCard* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_show_input (self);
	if (old_value != value) {
		self->priv->_show_input = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_SHOW_INPUT_PROPERTY]);
	}
}

gboolean
greeter_user_card_get_is_24h (GreeterUserCard* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_24h;
	return result;
}

void
greeter_user_card_set_is_24h (GreeterUserCard* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_is_24h (self);
	if (old_value != value) {
		self->priv->_is_24h = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_IS_24H_PROPERTY]);
	}
}

GtkGestureMultiPress*
greeter_user_card_get_click_gesture (GreeterUserCard* self)
{
	GtkGestureMultiPress* result;
	GtkGestureMultiPress* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_click_gesture;
	result = _tmp0_;
	return result;
}

static void
greeter_user_card_set_click_gesture (GreeterUserCard* self,
                                     GtkGestureMultiPress* value)
{
	GtkGestureMultiPress* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_user_card_get_click_gesture (self);
	if (old_value != value) {
		GtkGestureMultiPress* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_click_gesture);
		self->priv->_click_gesture = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_user_card_properties[GREETER_USER_CARD_CLICK_GESTURE_PROPERTY]);
	}
}

static GreeterUserCardSelectionCheck*
greeter_user_card_selection_check_construct (GType object_type)
{
	GreeterUserCardSelectionCheck * self = NULL;
	self = (GreeterUserCardSelectionCheck*) g_object_new (object_type, NULL);
	return self;
}

static GreeterUserCardSelectionCheck*
greeter_user_card_selection_check_new (void)
{
	return greeter_user_card_selection_check_construct (GREETER_USER_CARD_TYPE_SELECTION_CHECK);
}

static void
greeter_user_card_selection_check_base_init (GreeterUserCardSelectionCheckClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_CHECK);
}

static void
greeter_user_card_selection_check_class_init (GreeterUserCardSelectionCheckClass * klass,
                                              gpointer klass_data)
{
	greeter_user_card_selection_check_parent_class = g_type_class_peek_parent (klass);
}

static void
greeter_user_card_selection_check_instance_init (GreeterUserCardSelectionCheck * self,
                                                 gpointer klass)
{
}

static GType
greeter_user_card_selection_check_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterUserCardSelectionCheckClass), (GBaseInitFunc) greeter_user_card_selection_check_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_user_card_selection_check_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterUserCardSelectionCheck), 0, (GInstanceInitFunc) greeter_user_card_selection_check_instance_init, NULL };
	GType greeter_user_card_selection_check_type_id;
	greeter_user_card_selection_check_type_id = g_type_register_static (gtk_spinner_get_type (), "GreeterUserCardSelectionCheck", &g_define_type_info, 0);
	return greeter_user_card_selection_check_type_id;
}

static GType
greeter_user_card_selection_check_get_type (void)
{
	static volatile gsize greeter_user_card_selection_check_type_id__once = 0;
	if (g_once_init_enter (&greeter_user_card_selection_check_type_id__once)) {
		GType greeter_user_card_selection_check_type_id;
		greeter_user_card_selection_check_type_id = greeter_user_card_selection_check_get_type_once ();
		g_once_init_leave (&greeter_user_card_selection_check_type_id__once, greeter_user_card_selection_check_type_id);
	}
	return greeter_user_card_selection_check_type_id__once;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GreeterUserCard* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->login_button);
		_g_object_unref0 (_data5_->password_grid);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_greeter_user_card_update_collapsed_class_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	greeter_user_card_update_collapsed_class ((GreeterUserCard*) self);
}

static void
_greeter_user_card_on_login_gtk_entry_activate (GtkEntry* _sender,
                                                gpointer self)
{
	greeter_user_card_on_login ((GreeterUserCard*) self);
}

static void
_greeter_user_card_on_login_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	greeter_user_card_on_login ((GreeterUserCard*) self);
}

static void
_greeter_user_card___lambda14_ (Block5Data* _data5_)
{
	GreeterUserCard* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data5_->self;
	_tmp0_ = greeter_base_card_get_need_password ((GreeterBaseCard*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkStack* _tmp2_;
		GtkGrid* _tmp3_;
		_tmp2_ = self->priv->login_stack;
		_tmp3_ = _data5_->password_grid;
		gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
	} else {
		GtkStack* _tmp4_;
		GtkButton* _tmp5_;
		_tmp4_ = self->priv->login_stack;
		_tmp5_ = _data5_->login_button;
		gtk_stack_set_visible_child (_tmp4_, (GtkWidget*) _tmp5_);
	}
}

static void
__greeter_user_card___lambda14__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_greeter_user_card___lambda14_ (self);
}

static void
_greeter_user_card___lambda15_ (GreeterUserCard* self)
{
	GreeterPasswordEntry* _tmp0_;
	_tmp0_ = self->priv->password_entry;
	gtk_entry_grab_focus_without_selecting ((GtkEntry*) _tmp0_);
}

static void
__greeter_user_card___lambda15__gtk_widget_grab_focus (GtkWidget* _sender,
                                                       gpointer self)
{
	_greeter_user_card___lambda15_ ((GreeterUserCard*) self);
}

static GObject *
greeter_user_card_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterUserCard * self;
	Block5Data* _data5_;
	GtkLabel* username_label = NULL;
	LightDMUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkStyleContext* _tmp5_;
	LightDMUser* _tmp6_;
	GtkLabel* _tmp7_;
	GreeterPasswordEntry* _tmp8_;
	GreeterPasswordEntry* _tmp9_;
	GtkImage* fingerprint_image = NULL;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GreeterSessionButton* password_session_button = NULL;
	GreeterSessionButton* _tmp13_ = NULL;
	LightDMUser* _tmp14_;
	GreeterSessionButton* _tmp15_;
	GtkGrid* _tmp16_ = NULL;
	GtkGrid* _tmp17_;
	GreeterPasswordEntry* _tmp18_;
	GtkGrid* _tmp19_;
	GtkImage* _tmp20_;
	GtkGrid* _tmp21_;
	GreeterSessionButton* _tmp22_;
	GtkGrid* _tmp23_;
	GreeterCapsLockRevealer* _tmp24_;
	GreeterCapsLockRevealer* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkStyleContext* _tmp28_;
	GtkButton* _tmp29_;
	GreeterSessionButton* login_button_session_button = NULL;
	GreeterSessionButton* _tmp30_ = NULL;
	LightDMUser* _tmp31_;
	GreeterSessionButton* _tmp32_;
	GtkBox* login_box = NULL;
	GtkBox* _tmp33_;
	GtkBox* _tmp34_;
	GtkButton* _tmp35_;
	GtkBox* _tmp36_;
	GreeterSessionButton* _tmp37_;
	GtkBox* disabled_box = NULL;
	GtkBox* _tmp38_ = NULL;
	GtkBox* _tmp39_;
	GtkImage* _tmp40_;
	GtkImage* _tmp41_;
	GtkBox* _tmp42_;
	GtkLabel* _tmp43_;
	GtkLabel* _tmp44_;
	GtkBox* _tmp45_;
	GtkStyleContext* _tmp46_;
	GtkStack* _tmp47_ = NULL;
	GtkStack* _tmp48_;
	GtkGrid* _tmp49_;
	GtkStack* _tmp50_;
	GtkButton* _tmp51_;
	GtkStack* _tmp52_;
	GtkBox* _tmp53_;
	GtkStack* _tmp54_;
	GtkWidget* _tmp55_;
	GtkRevealer* _tmp56_ = NULL;
	GtkRevealer* _tmp57_;
	GtkBox* _tmp58_ = NULL;
	GtkBox* _tmp59_;
	GtkRevealer* _tmp60_;
	GtkBox* _tmp61_;
	GtkLabel* _tmp62_;
	GtkBox* _tmp63_;
	GtkStyleContext* _tmp64_;
	GtkBox* _tmp65_;
	GtkStyleContext* _tmp66_;
	HdyAvatar* avatar = NULL;
	LightDMUser* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	LightDMUser* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	GFile* _tmp73_;
	GFile* _tmp74_;
	GFileIcon* _tmp75_;
	HdyAvatar* _tmp76_ = NULL;
	HdyAvatar* _tmp77_;
	GtkOverlay* avatar_overlay = NULL;
	HdyAvatar* _tmp78_;
	GtkWidget* _tmp79_;
	GtkOverlay* _tmp80_ = NULL;
	GreeterUserCardSelectionCheck* _tmp81_ = NULL;
	LightDMUser* _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	GtkOverlay* card_overlay = NULL;
	GtkBox* _tmp91_;
	GtkWidget* _tmp92_;
	GtkOverlay* _tmp93_ = NULL;
	GtkOverlay* _tmp94_;
	GtkOverlay* _tmp95_;
	GtkOverlay* _tmp96_;
	GtkGestureMultiPress* _tmp97_;
	GtkGestureMultiPress* _tmp98_;
	GreeterPasswordEntry* _tmp99_;
	GtkButton* _tmp100_;
	parent_class = G_OBJECT_CLASS (greeter_user_card_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_USER_CARD, GreeterUserCard);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	greeter_base_card_set_need_password ((GreeterBaseCard*) self, TRUE);
	_tmp0_ = self->priv->_lightdm_user;
	_tmp1_ = lightdm_user_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp3_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 24);
	g_object_ref_sink (_tmp3_);
	username_label = _tmp3_;
	_tmp4_ = username_label;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp6_ = self->priv->_lightdm_user;
	_tmp7_ = username_label;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "is-locked", (GObject*) _tmp7_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp8_ = greeter_password_entry_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp8_;
	_tmp9_ = self->priv->password_entry;
	g_object_bind_property_with_closures ((GObject*) self, "connecting", (GObject*) _tmp9_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name ("fingerprint-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp10_);
	fingerprint_image = _tmp10_;
	_tmp11_ = fingerprint_image;
	g_object_bind_property_with_closures ((GObject*) self, "use-fingerprint", (GObject*) _tmp11_, "no-show-all", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp12_ = fingerprint_image;
	g_object_bind_property_with_closures ((GObject*) self, "use-fingerprint", (GObject*) _tmp12_, "visible", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = greeter_session_button_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	password_session_button = _tmp13_;
	_tmp14_ = self->priv->_lightdm_user;
	_tmp15_ = password_session_button;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "is-locked", (GObject*) _tmp15_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp16_, 6);
	gtk_grid_set_row_spacing (_tmp16_, 6);
	g_object_ref_sink (_tmp16_);
	_data5_->password_grid = _tmp16_;
	_tmp17_ = _data5_->password_grid;
	_tmp18_ = self->priv->password_entry;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 0, 0, 1, 1);
	_tmp19_ = _data5_->password_grid;
	_tmp20_ = fingerprint_image;
	gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp20_, 1, 0, 1, 1);
	_tmp21_ = _data5_->password_grid;
	_tmp22_ = password_session_button;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 2, 0, 1, 1);
	_tmp23_ = _data5_->password_grid;
	_tmp24_ = greeter_caps_lock_revealer_new ();
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	gtk_grid_attach (_tmp23_, (GtkWidget*) _tmp25_, 0, 1, 3, 1);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = (GtkButton*) gtk_button_new_with_label (_ ("Log In"));
	g_object_ref_sink (_tmp26_);
	_data5_->login_button = _tmp26_;
	_tmp27_ = _data5_->login_button;
	_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
	gtk_style_context_add_class (_tmp28_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp29_ = _data5_->login_button;
	g_object_bind_property_with_closures ((GObject*) self, "connecting", (GObject*) _tmp29_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp30_ = greeter_session_button_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp30_, TRUE);
	g_object_ref_sink (_tmp30_);
	login_button_session_button = _tmp30_;
	_tmp31_ = self->priv->_lightdm_user;
	_tmp32_ = login_button_session_button;
	g_object_bind_property_with_closures ((GObject*) _tmp31_, "is-locked", (GObject*) _tmp32_, "sensitive", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp33_);
	login_box = _tmp33_;
	_tmp34_ = login_box;
	_tmp35_ = _data5_->login_button;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = login_box;
	_tmp37_ = login_button_session_button;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _tmp38_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp38_, 3);
	g_object_ref_sink (_tmp38_);
	disabled_box = _tmp38_;
	_tmp39_ = disabled_box;
	_tmp40_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = disabled_box;
	_tmp43_ = (GtkLabel*) gtk_label_new (_ ("Account disabled"));
	g_object_ref_sink (_tmp43_);
	_tmp44_ = _tmp43_;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp44_);
	_g_object_unref0 (_tmp44_);
	_tmp45_ = disabled_box;
	_tmp46_ = gtk_widget_get_style_context ((GtkWidget*) _tmp45_);
	gtk_style_context_add_class (_tmp46_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp47_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp47_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp47_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp47_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp47_, 24);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->login_stack);
	self->priv->login_stack = _tmp47_;
	_tmp48_ = self->priv->login_stack;
	_tmp49_ = _data5_->password_grid;
	gtk_stack_add_named (_tmp48_, (GtkWidget*) _tmp49_, "password");
	_tmp50_ = self->priv->login_stack;
	_tmp51_ = _data5_->login_button;
	gtk_stack_add_named (_tmp50_, (GtkWidget*) _tmp51_, "button");
	_tmp52_ = self->priv->login_stack;
	_tmp53_ = disabled_box;
	gtk_stack_add_named (_tmp52_, (GtkWidget*) _tmp53_, "disabled");
	_tmp54_ = self->priv->login_stack;
	_tmp55_ = _g_object_ref0 ((GtkWidget*) _tmp54_);
	_tmp56_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp56_, 12);
	gtk_revealer_set_reveal_child (_tmp56_, TRUE);
	gtk_revealer_set_transition_type (_tmp56_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_set ((GtkContainer*) _tmp56_, "child", _tmp55_, NULL);
	_g_object_unref0 (_tmp55_);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->form_revealer);
	self->priv->form_revealer = _tmp56_;
	_tmp57_ = self->priv->form_revealer;
	g_object_bind_property_with_closures ((GObject*) self, "show-input", (GObject*) _tmp57_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp58_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp58_, 48);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp58_;
	_tmp59_ = self->priv->main_box;
	_tmp60_ = self->priv->form_revealer;
	gtk_box_pack_end (_tmp59_, (GtkWidget*) _tmp60_, TRUE, TRUE, (guint) 0);
	_tmp61_ = self->priv->main_box;
	_tmp62_ = username_label;
	gtk_box_pack_end (_tmp61_, (GtkWidget*) _tmp62_, TRUE, TRUE, (guint) 0);
	_tmp63_ = self->priv->main_box;
	_tmp64_ = gtk_widget_get_style_context ((GtkWidget*) _tmp63_);
	gtk_style_context_add_class (_tmp64_, GRANITE_STYLE_CLASS_CARD);
	_tmp65_ = self->priv->main_box;
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) _tmp65_);
	gtk_style_context_add_class (_tmp66_, GRANITE_STYLE_CLASS_ROUNDED);
	greeter_user_card_update_collapsed_class (self);
	_tmp67_ = self->priv->_lightdm_user;
	_tmp68_ = lightdm_user_get_display_name (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = self->priv->_lightdm_user;
	_tmp71_ = lightdm_user_get_image (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = g_file_new_for_path (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = (GFileIcon*) g_file_icon_new (_tmp74_);
	_tmp76_ = (HdyAvatar*) hdy_avatar_new (64, _tmp69_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp76_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp76_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp76_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp76_, 6);
	hdy_avatar_set_loadable_icon (_tmp76_, (GLoadableIcon*) _tmp75_);
	_g_object_unref0 (_tmp75_);
	g_object_ref_sink (_tmp76_);
	_tmp77_ = _tmp76_;
	_g_object_unref0 (_tmp74_);
	avatar = _tmp77_;
	_tmp78_ = avatar;
	_tmp79_ = _g_object_ref0 ((GtkWidget*) _tmp78_);
	_tmp80_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp80_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp80_, GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp80_, 100);
	g_object_set ((GtkContainer*) _tmp80_, "child", _tmp79_, NULL);
	_g_object_unref0 (_tmp79_);
	g_object_ref_sink (_tmp80_);
	avatar_overlay = _tmp80_;
	_tmp81_ = greeter_user_card_selection_check_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp81_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp81_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp81_);
	_g_object_unref0 (self->priv->logged_in);
	self->priv->logged_in = _tmp81_;
	_tmp82_ = self->priv->_lightdm_user;
	_tmp83_ = lightdm_user_get_logged_in (_tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_) {
		GtkOverlay* _tmp85_;
		GreeterUserCardSelectionCheck* _tmp86_;
		GreeterSessionButton* _tmp87_;
		GreeterSessionButton* _tmp88_;
		GreeterSessionButton* _tmp89_;
		GreeterSessionButton* _tmp90_;
		_tmp85_ = avatar_overlay;
		_tmp86_ = self->priv->logged_in;
		gtk_overlay_add_overlay (_tmp85_, (GtkWidget*) _tmp86_);
		_tmp87_ = password_session_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp87_, FALSE);
		_tmp88_ = password_session_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp88_, _ ("Session cannot be changed while user is logged in"));
		_tmp89_ = login_button_session_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp89_, FALSE);
		_tmp90_ = login_button_session_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp90_, _ ("Session cannot be changed while user is logged in"));
	}
	_tmp91_ = self->priv->main_box;
	_tmp92_ = _g_object_ref0 ((GtkWidget*) _tmp91_);
	_tmp93_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp93_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp93_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp93_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp93_, 12);
	g_object_set ((GtkContainer*) _tmp93_, "child", _tmp92_, NULL);
	_g_object_unref0 (_tmp92_);
	g_object_ref_sink (_tmp93_);
	card_overlay = _tmp93_;
	_tmp94_ = card_overlay;
	_tmp95_ = avatar_overlay;
	gtk_overlay_add_overlay (_tmp94_, (GtkWidget*) _tmp95_);
	_tmp96_ = card_overlay;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp96_, NULL);
	greeter_user_card_connect_to_dbus_interfaces (self);
	_tmp97_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	_tmp98_ = _tmp97_;
	greeter_user_card_set_click_gesture (self, _tmp98_);
	_g_object_unref0 (_tmp98_);
	g_signal_connect_object ((GObject*) self, "notify::show-input", (GCallback) _greeter_user_card_update_collapsed_class_g_object_notify, self, 0);
	_tmp99_ = self->priv->password_entry;
	g_signal_connect_object ((GtkEntry*) _tmp99_, "activate", (GCallback) _greeter_user_card_on_login_gtk_entry_activate, self, 0);
	_tmp100_ = _data5_->login_button;
	g_signal_connect_object (_tmp100_, "clicked", (GCallback) _greeter_user_card_on_login_gtk_button_clicked, self, 0);
	g_signal_connect_data ((GObject*) self, "notify::need-password", (GCallback) __greeter_user_card___lambda14__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "grab-focus", (GCallback) __greeter_user_card___lambda15__gtk_widget_grab_focus, self, 0);
	_g_object_unref0 (card_overlay);
	_g_object_unref0 (avatar_overlay);
	_g_object_unref0 (avatar);
	_g_object_unref0 (disabled_box);
	_g_object_unref0 (login_box);
	_g_object_unref0 (login_button_session_button);
	_g_object_unref0 (password_session_button);
	_g_object_unref0 (fingerprint_image);
	_g_object_unref0 (username_label);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
greeter_user_card_class_init (GreeterUserCardClass * klass,
                              gpointer klass_data)
{
	greeter_user_card_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterUserCard_private_offset);
	((GreeterBaseCardClass *) klass)->wrong_credentials = (void (*) (GreeterBaseCard*)) greeter_user_card_real_wrong_credentials;
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_user_card_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_user_card_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_user_card_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_user_card_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_LIGHTDM_USER_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_LIGHTDM_USER_PROPERTY] = g_param_spec_object ("lightdm-user", "lightdm-user", "lightdm-user", lightdm_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_SHOW_INPUT_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_SHOW_INPUT_PROPERTY] = g_param_spec_boolean ("show-input", "show-input", "show-input", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_IS_24H_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_IS_24H_PROPERTY] = g_param_spec_boolean ("is-24h", "is-24h", "is-24h", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_USER_CARD_CLICK_GESTURE_PROPERTY, greeter_user_card_properties[GREETER_USER_CARD_CLICK_GESTURE_PROPERTY] = g_param_spec_object ("click-gesture", "click-gesture", "click-gesture", gtk_gesture_multi_press_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
greeter_user_card_instance_init (GreeterUserCard * self,
                                 gpointer klass)
{
	self->priv = greeter_user_card_get_instance_private (self);
	self->priv->_show_input = FALSE;
	self->priv->_is_24h = TRUE;
}

static void
greeter_user_card_finalize (GObject * obj)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_USER_CARD, GreeterUserCard);
	_g_object_unref0 (self->priv->_lightdm_user);
	_g_object_unref0 (self->priv->_click_gesture);
	_g_object_unref0 (self->priv->greeter_act);
	_g_object_unref0 (self->priv->settings_act);
	_g_object_unref0 (self->priv->form_revealer);
	_g_object_unref0 (self->priv->login_stack);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->logged_in);
	G_OBJECT_CLASS (greeter_user_card_parent_class)->finalize (obj);
}

static GType
greeter_user_card_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterUserCardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_user_card_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterUserCard), 0, (GInstanceInitFunc) greeter_user_card_instance_init, NULL };
	GType greeter_user_card_type_id;
	greeter_user_card_type_id = g_type_register_static (GREETER_TYPE_BASE_CARD, "GreeterUserCard", &g_define_type_info, 0);
	GreeterUserCard_private_offset = g_type_add_instance_private (greeter_user_card_type_id, sizeof (GreeterUserCardPrivate));
	return greeter_user_card_type_id;
}

GType
greeter_user_card_get_type (void)
{
	static volatile gsize greeter_user_card_type_id__once = 0;
	if (g_once_init_enter (&greeter_user_card_type_id__once)) {
		GType greeter_user_card_type_id;
		greeter_user_card_type_id = greeter_user_card_get_type_once ();
		g_once_init_leave (&greeter_user_card_type_id__once, greeter_user_card_type_id);
	}
	return greeter_user_card_type_id__once;
}

static void
_vala_greeter_user_card_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_USER_CARD, GreeterUserCard);
	switch (property_id) {
		case GREETER_USER_CARD_LIGHTDM_USER_PROPERTY:
		g_value_set_object (value, greeter_user_card_get_lightdm_user (self));
		break;
		case GREETER_USER_CARD_SHOW_INPUT_PROPERTY:
		g_value_set_boolean (value, greeter_user_card_get_show_input (self));
		break;
		case GREETER_USER_CARD_IS_24H_PROPERTY:
		g_value_set_boolean (value, greeter_user_card_get_is_24h (self));
		break;
		case GREETER_USER_CARD_CLICK_GESTURE_PROPERTY:
		g_value_set_object (value, greeter_user_card_get_click_gesture (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_user_card_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GreeterUserCard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_TYPE_USER_CARD, GreeterUserCard);
	switch (property_id) {
		case GREETER_USER_CARD_LIGHTDM_USER_PROPERTY:
		greeter_user_card_set_lightdm_user (self, g_value_get_object (value));
		break;
		case GREETER_USER_CARD_SHOW_INPUT_PROPERTY:
		greeter_user_card_set_show_input (self, g_value_get_boolean (value));
		break;
		case GREETER_USER_CARD_IS_24H_PROPERTY:
		greeter_user_card_set_is_24h (self, g_value_get_boolean (value));
		break;
		case GREETER_USER_CARD_CLICK_GESTURE_PROPERTY:
		greeter_user_card_set_click_gesture (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

