#ifndef INCLUDED_OFFICECFG_OFFICE_WRITER_HXX
#define INCLUDED_OFFICECFG_OFFICE_WRITER_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Writer {

struct GlobalTemplateList: public comphelper::ConfigurationGroup< GlobalTemplateList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/GlobalTemplateList"_ustr); return PATH; }

struct Paths: public comphelper::ConfigurationProperty<Paths, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/GlobalTemplateList/Paths"_ustr); return PATH; }
private:
    Paths(); // not defined
    ~Paths(); // not defined
};

private:
    GlobalTemplateList(); // not defined
    ~GlobalTemplateList(); // not defined
};

struct MailMergeWizard: public comphelper::ConfigurationGroup< MailMergeWizard> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard"_ustr); return PATH; }

struct OutputToLetter: public comphelper::ConfigurationProperty<OutputToLetter, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/OutputToLetter"_ustr); return PATH; }
private:
    OutputToLetter(); // not defined
    ~OutputToLetter(); // not defined
};

struct IncludeCountry: public comphelper::ConfigurationProperty<IncludeCountry, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IncludeCountry"_ustr); return PATH; }
private:
    IncludeCountry(); // not defined
    ~IncludeCountry(); // not defined
};

struct ExcludeCountry: public comphelper::ConfigurationProperty<ExcludeCountry, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/ExcludeCountry"_ustr); return PATH; }
private:
    ExcludeCountry(); // not defined
    ~ExcludeCountry(); // not defined
};

struct SavedDocuments: public comphelper::ConfigurationProperty<SavedDocuments, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/SavedDocuments"_ustr); return PATH; }
private:
    SavedDocuments(); // not defined
    ~SavedDocuments(); // not defined
};

struct AddressBlockSettings: public comphelper::ConfigurationProperty<AddressBlockSettings, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/AddressBlockSettings"_ustr); return PATH; }
private:
    AddressBlockSettings(); // not defined
    ~AddressBlockSettings(); // not defined
};

struct IsAddressBlock: public comphelper::ConfigurationProperty<IsAddressBlock, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsAddressBlock"_ustr); return PATH; }
private:
    IsAddressBlock(); // not defined
    ~IsAddressBlock(); // not defined
};

struct CurrentAddressBlock: public comphelper::ConfigurationProperty<CurrentAddressBlock, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/CurrentAddressBlock"_ustr); return PATH; }
private:
    CurrentAddressBlock(); // not defined
    ~CurrentAddressBlock(); // not defined
};

struct IsHideEmptyParagraphs: public comphelper::ConfigurationProperty<IsHideEmptyParagraphs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsHideEmptyParagraphs"_ustr); return PATH; }
private:
    IsHideEmptyParagraphs(); // not defined
    ~IsHideEmptyParagraphs(); // not defined
};

struct IsGreetingLine: public comphelper::ConfigurationProperty<IsGreetingLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsGreetingLine"_ustr); return PATH; }
private:
    IsGreetingLine(); // not defined
    ~IsGreetingLine(); // not defined
};

struct IsEMailGreetingLine: public comphelper::ConfigurationProperty<IsEMailGreetingLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsEMailGreetingLine"_ustr); return PATH; }
private:
    IsEMailGreetingLine(); // not defined
    ~IsEMailGreetingLine(); // not defined
};

struct IsIndividualGreetingLine: public comphelper::ConfigurationProperty<IsIndividualGreetingLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsIndividualGreetingLine"_ustr); return PATH; }
private:
    IsIndividualGreetingLine(); // not defined
    ~IsIndividualGreetingLine(); // not defined
};

struct IsEMailIndividualGreetingLine: public comphelper::ConfigurationProperty<IsEMailIndividualGreetingLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsEMailIndividualGreetingLine"_ustr); return PATH; }
private:
    IsEMailIndividualGreetingLine(); // not defined
    ~IsEMailIndividualGreetingLine(); // not defined
};

struct FemaleGreetingLines: public comphelper::ConfigurationLocalizedProperty<FemaleGreetingLines, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/FemaleGreetingLines"_ustr); return PATH; }
private:
    FemaleGreetingLines(); // not defined
    ~FemaleGreetingLines(); // not defined
};

struct MaleGreetingLines: public comphelper::ConfigurationLocalizedProperty<MaleGreetingLines, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MaleGreetingLines"_ustr); return PATH; }
private:
    MaleGreetingLines(); // not defined
    ~MaleGreetingLines(); // not defined
};

struct NeutralGreetingLines: public comphelper::ConfigurationLocalizedProperty<NeutralGreetingLines, std::optional<com::sun::star::uno::Sequence<OUString> > > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/NeutralGreetingLines"_ustr); return PATH; }
private:
    NeutralGreetingLines(); // not defined
    ~NeutralGreetingLines(); // not defined
};

struct CurrentFemaleGreeting: public comphelper::ConfigurationProperty<CurrentFemaleGreeting, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/CurrentFemaleGreeting"_ustr); return PATH; }
private:
    CurrentFemaleGreeting(); // not defined
    ~CurrentFemaleGreeting(); // not defined
};

struct CurrentMaleGreeting: public comphelper::ConfigurationProperty<CurrentMaleGreeting, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/CurrentMaleGreeting"_ustr); return PATH; }
private:
    CurrentMaleGreeting(); // not defined
    ~CurrentMaleGreeting(); // not defined
};

struct CurrentNeutralGreeting: public comphelper::ConfigurationProperty<CurrentNeutralGreeting, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/CurrentNeutralGreeting"_ustr); return PATH; }
private:
    CurrentNeutralGreeting(); // not defined
    ~CurrentNeutralGreeting(); // not defined
};

struct FemaleGenderValue: public comphelper::ConfigurationProperty<FemaleGenderValue, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/FemaleGenderValue"_ustr); return PATH; }
private:
    FemaleGenderValue(); // not defined
    ~FemaleGenderValue(); // not defined
};

struct MailDisplayName: public comphelper::ConfigurationProperty<MailDisplayName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailDisplayName"_ustr); return PATH; }
private:
    MailDisplayName(); // not defined
    ~MailDisplayName(); // not defined
};

struct MailAddress: public comphelper::ConfigurationProperty<MailAddress, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailAddress"_ustr); return PATH; }
private:
    MailAddress(); // not defined
    ~MailAddress(); // not defined
};

struct IsMailReplyTo: public comphelper::ConfigurationProperty<IsMailReplyTo, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsMailReplyTo"_ustr); return PATH; }
private:
    IsMailReplyTo(); // not defined
    ~IsMailReplyTo(); // not defined
};

struct MailReplyTo: public comphelper::ConfigurationProperty<MailReplyTo, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailReplyTo"_ustr); return PATH; }
private:
    MailReplyTo(); // not defined
    ~MailReplyTo(); // not defined
};

struct MailServer: public comphelper::ConfigurationProperty<MailServer, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailServer"_ustr); return PATH; }
private:
    MailServer(); // not defined
    ~MailServer(); // not defined
};

struct MailPort: public comphelper::ConfigurationProperty<MailPort, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailPort"_ustr); return PATH; }
private:
    MailPort(); // not defined
    ~MailPort(); // not defined
};

struct IsSecureConnection: public comphelper::ConfigurationProperty<IsSecureConnection, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsSecureConnection"_ustr); return PATH; }
private:
    IsSecureConnection(); // not defined
    ~IsSecureConnection(); // not defined
};

struct IsAuthentication: public comphelper::ConfigurationProperty<IsAuthentication, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsAuthentication"_ustr); return PATH; }
private:
    IsAuthentication(); // not defined
    ~IsAuthentication(); // not defined
};

struct MailUserName: public comphelper::ConfigurationProperty<MailUserName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailUserName"_ustr); return PATH; }
private:
    MailUserName(); // not defined
    ~MailUserName(); // not defined
};

struct MailPassword: public comphelper::ConfigurationProperty<MailPassword, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/MailPassword"_ustr); return PATH; }
private:
    MailPassword(); // not defined
    ~MailPassword(); // not defined
};

struct IsSMPTAfterPOP: public comphelper::ConfigurationProperty<IsSMPTAfterPOP, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/IsSMPTAfterPOP"_ustr); return PATH; }
private:
    IsSMPTAfterPOP(); // not defined
    ~IsSMPTAfterPOP(); // not defined
};

struct InServerName: public comphelper::ConfigurationProperty<InServerName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/InServerName"_ustr); return PATH; }
private:
    InServerName(); // not defined
    ~InServerName(); // not defined
};

struct InServerPort: public comphelper::ConfigurationProperty<InServerPort, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/InServerPort"_ustr); return PATH; }
private:
    InServerPort(); // not defined
    ~InServerPort(); // not defined
};

struct InServerIsPOP: public comphelper::ConfigurationProperty<InServerIsPOP, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/InServerIsPOP"_ustr); return PATH; }
private:
    InServerIsPOP(); // not defined
    ~InServerIsPOP(); // not defined
};

struct InServerUserName: public comphelper::ConfigurationProperty<InServerUserName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/InServerUserName"_ustr); return PATH; }
private:
    InServerUserName(); // not defined
    ~InServerUserName(); // not defined
};

struct InServerPassword: public comphelper::ConfigurationProperty<InServerPassword, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/InServerPassword"_ustr); return PATH; }
private:
    InServerPassword(); // not defined
    ~InServerPassword(); // not defined
};

struct Filter: public comphelper::ConfigurationProperty<Filter, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/Filter"_ustr); return PATH; }
private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct EMailSupported: public comphelper::ConfigurationProperty<EMailSupported, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/EMailSupported"_ustr); return PATH; }
private:
    EMailSupported(); // not defined
    ~EMailSupported(); // not defined
};

struct AddressDataAssignments: public comphelper::ConfigurationSet< AddressDataAssignments> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/MailMergeWizard/AddressDataAssignments"_ustr); return PATH; }
private:
    AddressDataAssignments(); // not defined
    ~AddressDataAssignments(); // not defined
};

private:
    MailMergeWizard(); // not defined
    ~MailMergeWizard(); // not defined
};

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display"_ustr); return PATH; }

struct GraphicObject: public comphelper::ConfigurationProperty<GraphicObject, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/GraphicObject"_ustr); return PATH; }
private:
    GraphicObject(); // not defined
    ~GraphicObject(); // not defined
};

struct Table: public comphelper::ConfigurationProperty<Table, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/Table"_ustr); return PATH; }
private:
    Table(); // not defined
    ~Table(); // not defined
};

struct DrawingControl: public comphelper::ConfigurationProperty<DrawingControl, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/DrawingControl"_ustr); return PATH; }
private:
    DrawingControl(); // not defined
    ~DrawingControl(); // not defined
};

struct FieldCode: public comphelper::ConfigurationProperty<FieldCode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/FieldCode"_ustr); return PATH; }
private:
    FieldCode(); // not defined
    ~FieldCode(); // not defined
};

struct Note: public comphelper::ConfigurationProperty<Note, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/Note"_ustr); return PATH; }
private:
    Note(); // not defined
    ~Note(); // not defined
};

struct ShowContentTips: public comphelper::ConfigurationProperty<ShowContentTips, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowContentTips"_ustr); return PATH; }
private:
    ShowContentTips(); // not defined
    ~ShowContentTips(); // not defined
};

struct ShowInlineTooltips: public comphelper::ConfigurationProperty<ShowInlineTooltips, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowInlineTooltips"_ustr); return PATH; }
private:
    ShowInlineTooltips(); // not defined
    ~ShowInlineTooltips(); // not defined
};

struct UseHeaderFooterMenu: public comphelper::ConfigurationProperty<UseHeaderFooterMenu, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/UseHeaderFooterMenu"_ustr); return PATH; }
private:
    UseHeaderFooterMenu(); // not defined
    ~UseHeaderFooterMenu(); // not defined
};

struct ShowOutlineContentVisibilityButton: public comphelper::ConfigurationProperty<ShowOutlineContentVisibilityButton, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowOutlineContentVisibilityButton"_ustr); return PATH; }
private:
    ShowOutlineContentVisibilityButton(); // not defined
    ~ShowOutlineContentVisibilityButton(); // not defined
};

struct TreatSubOutlineLevelsAsContent: public comphelper::ConfigurationProperty<TreatSubOutlineLevelsAsContent, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/TreatSubOutlineLevelsAsContent"_ustr); return PATH; }
private:
    TreatSubOutlineLevelsAsContent(); // not defined
    ~TreatSubOutlineLevelsAsContent(); // not defined
};

struct ShowChangesInMargin: public comphelper::ConfigurationProperty<ShowChangesInMargin, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowChangesInMargin"_ustr); return PATH; }
private:
    ShowChangesInMargin(); // not defined
    ~ShowChangesInMargin(); // not defined
};

struct ShowWarningHiddenSection: public comphelper::ConfigurationProperty<ShowWarningHiddenSection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowWarningHiddenSection"_ustr); return PATH; }
private:
    ShowWarningHiddenSection(); // not defined
    ~ShowWarningHiddenSection(); // not defined
};

struct DefaultAnchor: public comphelper::ConfigurationProperty<DefaultAnchor, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/DefaultAnchor"_ustr); return PATH; }
private:
    DefaultAnchor(); // not defined
    ~DefaultAnchor(); // not defined
};

struct TextBoundaries: public comphelper::ConfigurationProperty<TextBoundaries, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/TextBoundaries"_ustr); return PATH; }
private:
    TextBoundaries(); // not defined
    ~TextBoundaries(); // not defined
};

struct TextBoundariesFull: public comphelper::ConfigurationProperty<TextBoundariesFull, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/TextBoundariesFull"_ustr); return PATH; }
private:
    TextBoundariesFull(); // not defined
    ~TextBoundariesFull(); // not defined
};

struct SectionBoundaries: public comphelper::ConfigurationProperty<SectionBoundaries, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/SectionBoundaries"_ustr); return PATH; }
private:
    SectionBoundaries(); // not defined
    ~SectionBoundaries(); // not defined
};

struct TableBoundaries: public comphelper::ConfigurationProperty<TableBoundaries, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/TableBoundaries"_ustr); return PATH; }
private:
    TableBoundaries(); // not defined
    ~TableBoundaries(); // not defined
};

struct ShowBoundaries: public comphelper::ConfigurationProperty<ShowBoundaries, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Display/ShowBoundaries"_ustr); return PATH; }
private:
    ShowBoundaries(); // not defined
    ~ShowBoundaries(); // not defined
};

private:
    Display(); // not defined
    ~Display(); // not defined
};

struct Zoom: public comphelper::ConfigurationGroup< Zoom> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Zoom"_ustr); return PATH; }

struct DefaultZoom: public comphelper::ConfigurationProperty<DefaultZoom, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Zoom/DefaultZoom"_ustr); return PATH; }
private:
    DefaultZoom(); // not defined
    ~DefaultZoom(); // not defined
};

struct ZoomType: public comphelper::ConfigurationProperty<ZoomType, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Zoom/ZoomType"_ustr); return PATH; }
private:
    ZoomType(); // not defined
    ~ZoomType(); // not defined
};

struct ZoomValue: public comphelper::ConfigurationProperty<ZoomValue, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Zoom/ZoomValue"_ustr); return PATH; }
private:
    ZoomValue(); // not defined
    ~ZoomValue(); // not defined
};

private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

struct NonprintingCharacter: public comphelper::ConfigurationGroup< NonprintingCharacter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter"_ustr); return PATH; }

struct MetaCharacters: public comphelper::ConfigurationProperty<MetaCharacters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/MetaCharacters"_ustr); return PATH; }
private:
    MetaCharacters(); // not defined
    ~MetaCharacters(); // not defined
};

struct ParagraphEnd: public comphelper::ConfigurationProperty<ParagraphEnd, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/ParagraphEnd"_ustr); return PATH; }
private:
    ParagraphEnd(); // not defined
    ~ParagraphEnd(); // not defined
};

struct OptionalHyphen: public comphelper::ConfigurationProperty<OptionalHyphen, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/OptionalHyphen"_ustr); return PATH; }
private:
    OptionalHyphen(); // not defined
    ~OptionalHyphen(); // not defined
};

struct Space: public comphelper::ConfigurationProperty<Space, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/Space"_ustr); return PATH; }
private:
    Space(); // not defined
    ~Space(); // not defined
};

struct ProtectedSpace: public comphelper::ConfigurationProperty<ProtectedSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/ProtectedSpace"_ustr); return PATH; }
private:
    ProtectedSpace(); // not defined
    ~ProtectedSpace(); // not defined
};

struct Tab: public comphelper::ConfigurationProperty<Tab, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/Tab"_ustr); return PATH; }
private:
    Tab(); // not defined
    ~Tab(); // not defined
};

struct Break: public comphelper::ConfigurationProperty<Break, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/Break"_ustr); return PATH; }
private:
    Break(); // not defined
    ~Break(); // not defined
};

struct HiddenText: public comphelper::ConfigurationProperty<HiddenText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/HiddenText"_ustr); return PATH; }
private:
    HiddenText(); // not defined
    ~HiddenText(); // not defined
};

struct HiddenParagraph: public comphelper::ConfigurationProperty<HiddenParagraph, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/HiddenParagraph"_ustr); return PATH; }
private:
    HiddenParagraph(); // not defined
    ~HiddenParagraph(); // not defined
};

struct HiddenCharacter: public comphelper::ConfigurationProperty<HiddenCharacter, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/HiddenCharacter"_ustr); return PATH; }
private:
    HiddenCharacter(); // not defined
    ~HiddenCharacter(); // not defined
};

struct Bookmarks: public comphelper::ConfigurationProperty<Bookmarks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/NonprintingCharacter/Bookmarks"_ustr); return PATH; }
private:
    Bookmarks(); // not defined
    ~Bookmarks(); // not defined
};

private:
    NonprintingCharacter(); // not defined
    ~NonprintingCharacter(); // not defined
};

struct Update: public comphelper::ConfigurationGroup< Update> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Update"_ustr); return PATH; }

struct Link: public comphelper::ConfigurationProperty<Link, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Update/Link"_ustr); return PATH; }
private:
    Link(); // not defined
    ~Link(); // not defined
};

struct Field: public comphelper::ConfigurationProperty<Field, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Update/Field"_ustr); return PATH; }
private:
    Field(); // not defined
    ~Field(); // not defined
};

struct Chart: public comphelper::ConfigurationProperty<Chart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Content/Update/Chart"_ustr); return PATH; }
private:
    Chart(); // not defined
    ~Chart(); // not defined
};

private:
    Update(); // not defined
    ~Update(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Layout: public comphelper::ConfigurationGroup< Layout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout"_ustr); return PATH; }

struct Line: public comphelper::ConfigurationGroup< Line> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Line"_ustr); return PATH; }

struct Guide: public comphelper::ConfigurationProperty<Guide, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Line/Guide"_ustr); return PATH; }
private:
    Guide(); // not defined
    ~Guide(); // not defined
};

private:
    Line(); // not defined
    ~Line(); // not defined
};

struct Window: public comphelper::ConfigurationGroup< Window> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window"_ustr); return PATH; }

struct ShowScrollBarTips: public comphelper::ConfigurationProperty<ShowScrollBarTips, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/ShowScrollBarTips"_ustr); return PATH; }
private:
    ShowScrollBarTips(); // not defined
    ~ShowScrollBarTips(); // not defined
};

struct HorizontalScroll: public comphelper::ConfigurationProperty<HorizontalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/HorizontalScroll"_ustr); return PATH; }
private:
    HorizontalScroll(); // not defined
    ~HorizontalScroll(); // not defined
};

struct VerticalScroll: public comphelper::ConfigurationProperty<VerticalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/VerticalScroll"_ustr); return PATH; }
private:
    VerticalScroll(); // not defined
    ~VerticalScroll(); // not defined
};

struct ShowRulers: public comphelper::ConfigurationProperty<ShowRulers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/ShowRulers"_ustr); return PATH; }
private:
    ShowRulers(); // not defined
    ~ShowRulers(); // not defined
};

struct HorizontalRuler: public comphelper::ConfigurationProperty<HorizontalRuler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/HorizontalRuler"_ustr); return PATH; }
private:
    HorizontalRuler(); // not defined
    ~HorizontalRuler(); // not defined
};

struct HorizontalRulerUnit: public comphelper::ConfigurationProperty<HorizontalRulerUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/HorizontalRulerUnit"_ustr); return PATH; }
private:
    HorizontalRulerUnit(); // not defined
    ~HorizontalRulerUnit(); // not defined
};

struct VerticalRuler: public comphelper::ConfigurationProperty<VerticalRuler, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/VerticalRuler"_ustr); return PATH; }
private:
    VerticalRuler(); // not defined
    ~VerticalRuler(); // not defined
};

struct IsVerticalRulerRight: public comphelper::ConfigurationProperty<IsVerticalRulerRight, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/IsVerticalRulerRight"_ustr); return PATH; }
private:
    IsVerticalRulerRight(); // not defined
    ~IsVerticalRulerRight(); // not defined
};

struct VerticalRulerUnit: public comphelper::ConfigurationProperty<VerticalRulerUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/VerticalRulerUnit"_ustr); return PATH; }
private:
    VerticalRulerUnit(); // not defined
    ~VerticalRulerUnit(); // not defined
};

struct SmoothScroll: public comphelper::ConfigurationProperty<SmoothScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Window/SmoothScroll"_ustr); return PATH; }
private:
    SmoothScroll(); // not defined
    ~SmoothScroll(); // not defined
};

private:
    Window(); // not defined
    ~Window(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other"_ustr); return PATH; }

struct IsAlignMathObjectsToBaseline: public comphelper::ConfigurationProperty<IsAlignMathObjectsToBaseline, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other/IsAlignMathObjectsToBaseline"_ustr); return PATH; }
private:
    IsAlignMathObjectsToBaseline(); // not defined
    ~IsAlignMathObjectsToBaseline(); // not defined
};

struct MeasureUnit: public comphelper::ConfigurationProperty<MeasureUnit, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other/MeasureUnit"_ustr); return PATH; }
private:
    MeasureUnit(); // not defined
    ~MeasureUnit(); // not defined
};

struct TabStop: public comphelper::ConfigurationLocalizedProperty<TabStop, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other/TabStop"_ustr); return PATH; }
private:
    TabStop(); // not defined
    ~TabStop(); // not defined
};

struct IsSquaredPageMode: public comphelper::ConfigurationProperty<IsSquaredPageMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other/IsSquaredPageMode"_ustr); return PATH; }
private:
    IsSquaredPageMode(); // not defined
    ~IsSquaredPageMode(); // not defined
};

struct ApplyCharUnit: public comphelper::ConfigurationProperty<ApplyCharUnit, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Other/ApplyCharUnit"_ustr); return PATH; }
private:
    ApplyCharUnit(); // not defined
    ~ApplyCharUnit(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

struct Zoom: public comphelper::ConfigurationGroup< Zoom> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Zoom"_ustr); return PATH; }

struct Type: public comphelper::ConfigurationProperty<Type, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Zoom/Type"_ustr); return PATH; }
private:
    Type(); // not defined
    ~Type(); // not defined
};

struct Value: public comphelper::ConfigurationProperty<Value, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/Zoom/Value"_ustr); return PATH; }
private:
    Value(); // not defined
    ~Value(); // not defined
};

private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

struct ViewLayout: public comphelper::ConfigurationGroup< ViewLayout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/ViewLayout"_ustr); return PATH; }

struct Columns: public comphelper::ConfigurationProperty<Columns, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/ViewLayout/Columns"_ustr); return PATH; }
private:
    Columns(); // not defined
    ~Columns(); // not defined
};

struct BookMode: public comphelper::ConfigurationProperty<BookMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Layout/ViewLayout/BookMode"_ustr); return PATH; }
private:
    BookMode(); // not defined
    ~BookMode(); // not defined
};

private:
    ViewLayout(); // not defined
    ~ViewLayout(); // not defined
};

private:
    Layout(); // not defined
    ~Layout(); // not defined
};

struct Grid: public comphelper::ConfigurationGroup< Grid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Option"_ustr); return PATH; }

struct SnapToGrid: public comphelper::ConfigurationProperty<SnapToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Option/SnapToGrid"_ustr); return PATH; }
private:
    SnapToGrid(); // not defined
    ~SnapToGrid(); // not defined
};

struct VisibleGrid: public comphelper::ConfigurationProperty<VisibleGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Option/VisibleGrid"_ustr); return PATH; }
private:
    VisibleGrid(); // not defined
    ~VisibleGrid(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Resolution: public comphelper::ConfigurationGroup< Resolution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Resolution"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Resolution/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Resolution/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

struct Subdivision: public comphelper::ConfigurationGroup< Subdivision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Subdivision"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Subdivision/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Grid/Subdivision/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Subdivision(); // not defined
    ~Subdivision(); // not defined
};

private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct DefaultFont: public comphelper::ConfigurationGroup< DefaultFont> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont"_ustr); return PATH; }

struct Standard: public comphelper::ConfigurationProperty<Standard, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/Standard"_ustr); return PATH; }
private:
    Standard(); // not defined
    ~Standard(); // not defined
};

struct StandardHeight: public comphelper::ConfigurationProperty<StandardHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/StandardHeight"_ustr); return PATH; }
private:
    StandardHeight(); // not defined
    ~StandardHeight(); // not defined
};

struct Heading: public comphelper::ConfigurationProperty<Heading, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/Heading"_ustr); return PATH; }
private:
    Heading(); // not defined
    ~Heading(); // not defined
};

struct HeadingHeight: public comphelper::ConfigurationProperty<HeadingHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/HeadingHeight"_ustr); return PATH; }
private:
    HeadingHeight(); // not defined
    ~HeadingHeight(); // not defined
};

struct List: public comphelper::ConfigurationProperty<List, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/List"_ustr); return PATH; }
private:
    List(); // not defined
    ~List(); // not defined
};

struct ListHeight: public comphelper::ConfigurationProperty<ListHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/ListHeight"_ustr); return PATH; }
private:
    ListHeight(); // not defined
    ~ListHeight(); // not defined
};

struct Caption: public comphelper::ConfigurationProperty<Caption, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/Caption"_ustr); return PATH; }
private:
    Caption(); // not defined
    ~Caption(); // not defined
};

struct CaptionHeight: public comphelper::ConfigurationProperty<CaptionHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/CaptionHeight"_ustr); return PATH; }
private:
    CaptionHeight(); // not defined
    ~CaptionHeight(); // not defined
};

struct Index: public comphelper::ConfigurationProperty<Index, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/Index"_ustr); return PATH; }
private:
    Index(); // not defined
    ~Index(); // not defined
};

struct IndexHeight: public comphelper::ConfigurationProperty<IndexHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/IndexHeight"_ustr); return PATH; }
private:
    IndexHeight(); // not defined
    ~IndexHeight(); // not defined
};

struct Document: public comphelper::ConfigurationProperty<Document, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFont/Document"_ustr); return PATH; }
private:
    Document(); // not defined
    ~Document(); // not defined
};

private:
    DefaultFont(); // not defined
    ~DefaultFont(); // not defined
};

struct DefaultFontCJK: public comphelper::ConfigurationGroup< DefaultFontCJK> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK"_ustr); return PATH; }

struct Standard: public comphelper::ConfigurationProperty<Standard, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/Standard"_ustr); return PATH; }
private:
    Standard(); // not defined
    ~Standard(); // not defined
};

struct StandardHeight: public comphelper::ConfigurationProperty<StandardHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/StandardHeight"_ustr); return PATH; }
private:
    StandardHeight(); // not defined
    ~StandardHeight(); // not defined
};

struct Heading: public comphelper::ConfigurationProperty<Heading, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/Heading"_ustr); return PATH; }
private:
    Heading(); // not defined
    ~Heading(); // not defined
};

struct HeadingHeight: public comphelper::ConfigurationProperty<HeadingHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/HeadingHeight"_ustr); return PATH; }
private:
    HeadingHeight(); // not defined
    ~HeadingHeight(); // not defined
};

struct List: public comphelper::ConfigurationProperty<List, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/List"_ustr); return PATH; }
private:
    List(); // not defined
    ~List(); // not defined
};

struct ListHeight: public comphelper::ConfigurationProperty<ListHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/ListHeight"_ustr); return PATH; }
private:
    ListHeight(); // not defined
    ~ListHeight(); // not defined
};

struct Caption: public comphelper::ConfigurationProperty<Caption, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/Caption"_ustr); return PATH; }
private:
    Caption(); // not defined
    ~Caption(); // not defined
};

struct CaptionHeight: public comphelper::ConfigurationProperty<CaptionHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/CaptionHeight"_ustr); return PATH; }
private:
    CaptionHeight(); // not defined
    ~CaptionHeight(); // not defined
};

struct Index: public comphelper::ConfigurationProperty<Index, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/Index"_ustr); return PATH; }
private:
    Index(); // not defined
    ~Index(); // not defined
};

struct IndexHeight: public comphelper::ConfigurationProperty<IndexHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/IndexHeight"_ustr); return PATH; }
private:
    IndexHeight(); // not defined
    ~IndexHeight(); // not defined
};

struct Document: public comphelper::ConfigurationProperty<Document, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCJK/Document"_ustr); return PATH; }
private:
    Document(); // not defined
    ~Document(); // not defined
};

private:
    DefaultFontCJK(); // not defined
    ~DefaultFontCJK(); // not defined
};

struct DefaultFontCTL: public comphelper::ConfigurationGroup< DefaultFontCTL> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL"_ustr); return PATH; }

struct Standard: public comphelper::ConfigurationProperty<Standard, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/Standard"_ustr); return PATH; }
private:
    Standard(); // not defined
    ~Standard(); // not defined
};

struct StandardHeight: public comphelper::ConfigurationProperty<StandardHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/StandardHeight"_ustr); return PATH; }
private:
    StandardHeight(); // not defined
    ~StandardHeight(); // not defined
};

struct Heading: public comphelper::ConfigurationProperty<Heading, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/Heading"_ustr); return PATH; }
private:
    Heading(); // not defined
    ~Heading(); // not defined
};

struct HeadingHeight: public comphelper::ConfigurationProperty<HeadingHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/HeadingHeight"_ustr); return PATH; }
private:
    HeadingHeight(); // not defined
    ~HeadingHeight(); // not defined
};

struct List: public comphelper::ConfigurationProperty<List, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/List"_ustr); return PATH; }
private:
    List(); // not defined
    ~List(); // not defined
};

struct ListHeight: public comphelper::ConfigurationProperty<ListHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/ListHeight"_ustr); return PATH; }
private:
    ListHeight(); // not defined
    ~ListHeight(); // not defined
};

struct Caption: public comphelper::ConfigurationProperty<Caption, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/Caption"_ustr); return PATH; }
private:
    Caption(); // not defined
    ~Caption(); // not defined
};

struct CaptionHeight: public comphelper::ConfigurationProperty<CaptionHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/CaptionHeight"_ustr); return PATH; }
private:
    CaptionHeight(); // not defined
    ~CaptionHeight(); // not defined
};

struct Index: public comphelper::ConfigurationProperty<Index, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/Index"_ustr); return PATH; }
private:
    Index(); // not defined
    ~Index(); // not defined
};

struct IndexHeight: public comphelper::ConfigurationProperty<IndexHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/IndexHeight"_ustr); return PATH; }
private:
    IndexHeight(); // not defined
    ~IndexHeight(); // not defined
};

struct Document: public comphelper::ConfigurationProperty<Document, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/DefaultFontCTL/Document"_ustr); return PATH; }
private:
    Document(); // not defined
    ~Document(); // not defined
};

private:
    DefaultFontCTL(); // not defined
    ~DefaultFontCTL(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print"_ustr); return PATH; }

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content"_ustr); return PATH; }

struct Graphic: public comphelper::ConfigurationProperty<Graphic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Control: public comphelper::ConfigurationProperty<Control, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/Control"_ustr); return PATH; }
private:
    Control(); // not defined
    ~Control(); // not defined
};

struct Background: public comphelper::ConfigurationProperty<Background, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/Background"_ustr); return PATH; }
private:
    Background(); // not defined
    ~Background(); // not defined
};

struct PrintBlack: public comphelper::ConfigurationProperty<PrintBlack, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/PrintBlack"_ustr); return PATH; }
private:
    PrintBlack(); // not defined
    ~PrintBlack(); // not defined
};

struct PrintHiddenText: public comphelper::ConfigurationProperty<PrintHiddenText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/PrintHiddenText"_ustr); return PATH; }
private:
    PrintHiddenText(); // not defined
    ~PrintHiddenText(); // not defined
};

struct PrintPlaceholders: public comphelper::ConfigurationProperty<PrintPlaceholders, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/PrintPlaceholders"_ustr); return PATH; }
private:
    PrintPlaceholders(); // not defined
    ~PrintPlaceholders(); // not defined
};

struct Note: public comphelper::ConfigurationProperty<Note, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Content/Note"_ustr); return PATH; }
private:
    Note(); // not defined
    ~Note(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Page: public comphelper::ConfigurationGroup< Page> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Page"_ustr); return PATH; }

struct LeftPage: public comphelper::ConfigurationProperty<LeftPage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Page/LeftPage"_ustr); return PATH; }
private:
    LeftPage(); // not defined
    ~LeftPage(); // not defined
};

struct RightPage: public comphelper::ConfigurationProperty<RightPage, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Page/RightPage"_ustr); return PATH; }
private:
    RightPage(); // not defined
    ~RightPage(); // not defined
};

struct Brochure: public comphelper::ConfigurationProperty<Brochure, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Page/Brochure"_ustr); return PATH; }
private:
    Brochure(); // not defined
    ~Brochure(); // not defined
};

struct BrochureRightToLeft: public comphelper::ConfigurationProperty<BrochureRightToLeft, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Page/BrochureRightToLeft"_ustr); return PATH; }
private:
    BrochureRightToLeft(); // not defined
    ~BrochureRightToLeft(); // not defined
};

private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Output: public comphelper::ConfigurationGroup< Output> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Output"_ustr); return PATH; }

struct Fax: public comphelper::ConfigurationProperty<Fax, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Output/Fax"_ustr); return PATH; }
private:
    Fax(); // not defined
    ~Fax(); // not defined
};

private:
    Output(); // not defined
    ~Output(); // not defined
};

struct Papertray: public comphelper::ConfigurationGroup< Papertray> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Papertray"_ustr); return PATH; }

struct FromPrinterSetup: public comphelper::ConfigurationProperty<FromPrinterSetup, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/Papertray/FromPrinterSetup"_ustr); return PATH; }
private:
    FromPrinterSetup(); // not defined
    ~FromPrinterSetup(); // not defined
};

private:
    Papertray(); // not defined
    ~Papertray(); // not defined
};

struct EmptyPages: public comphelper::ConfigurationProperty<EmptyPages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Print/EmptyPages"_ustr); return PATH; }
private:
    EmptyPages(); // not defined
    ~EmptyPages(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct Table: public comphelper::ConfigurationGroup< Table> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table"_ustr); return PATH; }

struct Shift: public comphelper::ConfigurationGroup< Shift> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Shift"_ustr); return PATH; }

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Shift/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Shift/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

private:
    Shift(); // not defined
    ~Shift(); // not defined
};

struct Insert: public comphelper::ConfigurationGroup< Insert> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Insert"_ustr); return PATH; }

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Insert/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Insert/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

private:
    Insert(); // not defined
    ~Insert(); // not defined
};

struct Change: public comphelper::ConfigurationGroup< Change> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Change"_ustr); return PATH; }

struct Effect: public comphelper::ConfigurationProperty<Effect, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Change/Effect"_ustr); return PATH; }
private:
    Effect(); // not defined
    ~Effect(); // not defined
};

struct ApplyTableAutoFormat: public comphelper::ConfigurationProperty<ApplyTableAutoFormat, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Change/ApplyTableAutoFormat"_ustr); return PATH; }
private:
    ApplyTableAutoFormat(); // not defined
    ~ApplyTableAutoFormat(); // not defined
};

private:
    Change(); // not defined
    ~Change(); // not defined
};

struct Input: public comphelper::ConfigurationGroup< Input> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Input"_ustr); return PATH; }

struct NumberRecognition: public comphelper::ConfigurationProperty<NumberRecognition, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Input/NumberRecognition"_ustr); return PATH; }
private:
    NumberRecognition(); // not defined
    ~NumberRecognition(); // not defined
};

struct NumberFormatRecognition: public comphelper::ConfigurationProperty<NumberFormatRecognition, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Input/NumberFormatRecognition"_ustr); return PATH; }
private:
    NumberFormatRecognition(); // not defined
    ~NumberFormatRecognition(); // not defined
};

struct Alignment: public comphelper::ConfigurationProperty<Alignment, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Input/Alignment"_ustr); return PATH; }
private:
    Alignment(); // not defined
    ~Alignment(); // not defined
};

struct SplitVerticalByDefault: public comphelper::ConfigurationProperty<SplitVerticalByDefault, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Table/Input/SplitVerticalByDefault"_ustr); return PATH; }
private:
    SplitVerticalByDefault(); // not defined
    ~SplitVerticalByDefault(); // not defined
};

private:
    Input(); // not defined
    ~Input(); // not defined
};

private:
    Table(); // not defined
    ~Table(); // not defined
};

struct Cursor: public comphelper::ConfigurationGroup< Cursor> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor"_ustr); return PATH; }

struct DirectCursor: public comphelper::ConfigurationGroup< DirectCursor> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/DirectCursor"_ustr); return PATH; }

struct UseDirectCursor: public comphelper::ConfigurationProperty<UseDirectCursor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/DirectCursor/UseDirectCursor"_ustr); return PATH; }
private:
    UseDirectCursor(); // not defined
    ~UseDirectCursor(); // not defined
};

struct Insert: public comphelper::ConfigurationProperty<Insert, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/DirectCursor/Insert"_ustr); return PATH; }
private:
    Insert(); // not defined
    ~Insert(); // not defined
};

private:
    DirectCursor(); // not defined
    ~DirectCursor(); // not defined
};

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/Option"_ustr); return PATH; }

struct ProtectedArea: public comphelper::ConfigurationProperty<ProtectedArea, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/Option/ProtectedArea"_ustr); return PATH; }
private:
    ProtectedArea(); // not defined
    ~ProtectedArea(); // not defined
};

struct IgnoreProtectedArea: public comphelper::ConfigurationProperty<IgnoreProtectedArea, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Cursor/Option/IgnoreProtectedArea"_ustr); return PATH; }
private:
    IgnoreProtectedArea(); // not defined
    ~IgnoreProtectedArea(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

private:
    Cursor(); // not defined
    ~Cursor(); // not defined
};

struct FmtAidsAutocomplete: public comphelper::ConfigurationGroup< FmtAidsAutocomplete> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FmtAidsAutocomplete"_ustr); return PATH; }

struct EncloseWithCharacters: public comphelper::ConfigurationProperty<EncloseWithCharacters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FmtAidsAutocomplete/EncloseWithCharacters"_ustr); return PATH; }
private:
    EncloseWithCharacters(); // not defined
    ~EncloseWithCharacters(); // not defined
};

private:
    FmtAidsAutocomplete(); // not defined
    ~FmtAidsAutocomplete(); // not defined
};

struct Revision: public comphelper::ConfigurationGroup< Revision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision"_ustr); return PATH; }

struct TextDisplay: public comphelper::ConfigurationGroup< TextDisplay> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay"_ustr); return PATH; }

struct Insert: public comphelper::ConfigurationGroup< Insert> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Insert"_ustr); return PATH; }

struct Attribute: public comphelper::ConfigurationProperty<Attribute, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Insert/Attribute"_ustr); return PATH; }
private:
    Attribute(); // not defined
    ~Attribute(); // not defined
};

struct Color: public comphelper::ConfigurationProperty<Color, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Insert/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    Insert(); // not defined
    ~Insert(); // not defined
};

struct Delete: public comphelper::ConfigurationGroup< Delete> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Delete"_ustr); return PATH; }

struct Attribute: public comphelper::ConfigurationProperty<Attribute, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Delete/Attribute"_ustr); return PATH; }
private:
    Attribute(); // not defined
    ~Attribute(); // not defined
};

struct Color: public comphelper::ConfigurationProperty<Color, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/Delete/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    Delete(); // not defined
    ~Delete(); // not defined
};

struct ChangedAttribute: public comphelper::ConfigurationGroup< ChangedAttribute> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/ChangedAttribute"_ustr); return PATH; }

struct Attribute: public comphelper::ConfigurationProperty<Attribute, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/ChangedAttribute/Attribute"_ustr); return PATH; }
private:
    Attribute(); // not defined
    ~Attribute(); // not defined
};

struct Color: public comphelper::ConfigurationProperty<Color, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/TextDisplay/ChangedAttribute/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    ChangedAttribute(); // not defined
    ~ChangedAttribute(); // not defined
};

private:
    TextDisplay(); // not defined
    ~TextDisplay(); // not defined
};

struct LinesChanged: public comphelper::ConfigurationGroup< LinesChanged> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/LinesChanged"_ustr); return PATH; }

struct Mark: public comphelper::ConfigurationProperty<Mark, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/LinesChanged/Mark"_ustr); return PATH; }
private:
    Mark(); // not defined
    ~Mark(); // not defined
};

struct Color: public comphelper::ConfigurationProperty<Color, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Revision/LinesChanged/Color"_ustr); return PATH; }
private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    LinesChanged(); // not defined
    ~LinesChanged(); // not defined
};

private:
    Revision(); // not defined
    ~Revision(); // not defined
};

struct Comparison: public comphelper::ConfigurationGroup< Comparison> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison"_ustr); return PATH; }

struct Mode: public comphelper::ConfigurationProperty<Mode, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/Mode"_ustr); return PATH; }
private:
    Mode(); // not defined
    ~Mode(); // not defined
};

struct UseRSID: public comphelper::ConfigurationProperty<UseRSID, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/UseRSID"_ustr); return PATH; }
private:
    UseRSID(); // not defined
    ~UseRSID(); // not defined
};

struct IgnorePieces: public comphelper::ConfigurationProperty<IgnorePieces, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/IgnorePieces"_ustr); return PATH; }
private:
    IgnorePieces(); // not defined
    ~IgnorePieces(); // not defined
};

struct IgnoreLength: public comphelper::ConfigurationProperty<IgnoreLength, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/IgnoreLength"_ustr); return PATH; }
private:
    IgnoreLength(); // not defined
    ~IgnoreLength(); // not defined
};

struct StoreRSID: public comphelper::ConfigurationProperty<StoreRSID, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/StoreRSID"_ustr); return PATH; }
private:
    StoreRSID(); // not defined
    ~StoreRSID(); // not defined
};

struct DisplayChangedParagraphNumbering: public comphelper::ConfigurationProperty<DisplayChangedParagraphNumbering, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/DisplayChangedParagraphNumbering"_ustr); return PATH; }
private:
    DisplayChangedParagraphNumbering(); // not defined
    ~DisplayChangedParagraphNumbering(); // not defined
};

struct DisplayMovedTextInGreen: public comphelper::ConfigurationProperty<DisplayMovedTextInGreen, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Comparison/DisplayMovedTextInGreen"_ustr); return PATH; }
private:
    DisplayMovedTextInGreen(); // not defined
    ~DisplayMovedTextInGreen(); // not defined
};

private:
    Comparison(); // not defined
    ~Comparison(); // not defined
};

struct Insert: public comphelper::ConfigurationGroup< Insert> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert"_ustr); return PATH; }

struct Caption: public comphelper::ConfigurationGroup< Caption> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption"_ustr); return PATH; }

struct CaptionOrderNumberingFirst: public comphelper::ConfigurationLocalizedProperty<CaptionOrderNumberingFirst, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/CaptionOrderNumberingFirst"_ustr); return PATH; }
private:
    CaptionOrderNumberingFirst(); // not defined
    ~CaptionOrderNumberingFirst(); // not defined
};

struct Automatic: public comphelper::ConfigurationProperty<Automatic, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/Automatic"_ustr); return PATH; }
private:
    Automatic(); // not defined
    ~Automatic(); // not defined
};

struct WriterObject: public comphelper::ConfigurationGroup< WriterObject> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject"_ustr); return PATH; }

struct Table: public comphelper::ConfigurationGroup< Table> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Table/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Table(); // not defined
    ~Table(); // not defined
};

struct Frame: public comphelper::ConfigurationGroup< Frame> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Frame/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Frame(); // not defined
    ~Frame(); // not defined
};

struct Graphic: public comphelper::ConfigurationGroup< Graphic> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/WriterObject/Graphic/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

private:
    WriterObject(); // not defined
    ~WriterObject(); // not defined
};

struct OfficeObject: public comphelper::ConfigurationGroup< OfficeObject> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject"_ustr); return PATH; }

struct Calc: public comphelper::ConfigurationGroup< Calc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Calc/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Calc(); // not defined
    ~Calc(); // not defined
};

struct Draw: public comphelper::ConfigurationGroup< Draw> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Draw/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Draw(); // not defined
    ~Draw(); // not defined
};

struct Chart: public comphelper::ConfigurationGroup< Chart> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Chart/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Chart(); // not defined
    ~Chart(); // not defined
};

struct Image: public comphelper::ConfigurationGroup< Image> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Image/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Image(); // not defined
    ~Image(); // not defined
};

struct Formula: public comphelper::ConfigurationGroup< Formula> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Formula/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Formula(); // not defined
    ~Formula(); // not defined
};

struct Impress: public comphelper::ConfigurationGroup< Impress> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/Impress/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    Impress(); // not defined
    ~Impress(); // not defined
};

struct OLEMisc: public comphelper::ConfigurationGroup< OLEMisc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct Settings: public comphelper::ConfigurationGroup< Settings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings"_ustr); return PATH; }

struct Category: public comphelper::ConfigurationLocalizedProperty<Category, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/Category"_ustr); return PATH; }
private:
    Category(); // not defined
    ~Category(); // not defined
};

struct Numbering: public comphelper::ConfigurationProperty<Numbering, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/Numbering"_ustr); return PATH; }
private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct NumberingSeparator: public comphelper::ConfigurationLocalizedProperty<NumberingSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/NumberingSeparator"_ustr); return PATH; }
private:
    NumberingSeparator(); // not defined
    ~NumberingSeparator(); // not defined
};

struct CaptionText: public comphelper::ConfigurationLocalizedProperty<CaptionText, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/CaptionText"_ustr); return PATH; }
private:
    CaptionText(); // not defined
    ~CaptionText(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Level: public comphelper::ConfigurationProperty<Level, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/Level"_ustr); return PATH; }
private:
    Level(); // not defined
    ~Level(); // not defined
};

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

struct CharacterStyle: public comphelper::ConfigurationProperty<CharacterStyle, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/CharacterStyle"_ustr); return PATH; }
private:
    CharacterStyle(); // not defined
    ~CharacterStyle(); // not defined
};

struct ApplyAttributes: public comphelper::ConfigurationProperty<ApplyAttributes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Caption/OfficeObject/OLEMisc/Settings/ApplyAttributes"_ustr); return PATH; }
private:
    ApplyAttributes(); // not defined
    ~ApplyAttributes(); // not defined
};

private:
    Settings(); // not defined
    ~Settings(); // not defined
};

private:
    OLEMisc(); // not defined
    ~OLEMisc(); // not defined
};

private:
    OfficeObject(); // not defined
    ~OfficeObject(); // not defined
};

private:
    Caption(); // not defined
    ~Caption(); // not defined
};

struct Table: public comphelper::ConfigurationGroup< Table> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Table"_ustr); return PATH; }

struct Header: public comphelper::ConfigurationProperty<Header, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Table/Header"_ustr); return PATH; }
private:
    Header(); // not defined
    ~Header(); // not defined
};

struct RepeatHeader: public comphelper::ConfigurationProperty<RepeatHeader, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Table/RepeatHeader"_ustr); return PATH; }
private:
    RepeatHeader(); // not defined
    ~RepeatHeader(); // not defined
};

struct Split: public comphelper::ConfigurationProperty<Split, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Table/Split"_ustr); return PATH; }
private:
    Split(); // not defined
    ~Split(); // not defined
};

struct Border: public comphelper::ConfigurationProperty<Border, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Insert/Table/Border"_ustr); return PATH; }
private:
    Border(); // not defined
    ~Border(); // not defined
};

private:
    Table(); // not defined
    ~Table(); // not defined
};

private:
    Insert(); // not defined
    ~Insert(); // not defined
};

struct AutoFunction: public comphelper::ConfigurationGroup< AutoFunction> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction"_ustr); return PATH; }

struct Text: public comphelper::ConfigurationGroup< Text> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text"_ustr); return PATH; }

struct FileLinks: public comphelper::ConfigurationProperty<FileLinks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text/FileLinks"_ustr); return PATH; }
private:
    FileLinks(); // not defined
    ~FileLinks(); // not defined
};

struct InternetLinks: public comphelper::ConfigurationProperty<InternetLinks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text/InternetLinks"_ustr); return PATH; }
private:
    InternetLinks(); // not defined
    ~InternetLinks(); // not defined
};

struct ShowPreview: public comphelper::ConfigurationProperty<ShowPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text/ShowPreview"_ustr); return PATH; }
private:
    ShowPreview(); // not defined
    ~ShowPreview(); // not defined
};

struct ShowToolTip: public comphelper::ConfigurationProperty<ShowToolTip, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text/ShowToolTip"_ustr); return PATH; }
private:
    ShowToolTip(); // not defined
    ~ShowToolTip(); // not defined
};

struct SearchInAllCategories: public comphelper::ConfigurationProperty<SearchInAllCategories, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Text/SearchInAllCategories"_ustr); return PATH; }
private:
    SearchInAllCategories(); // not defined
    ~SearchInAllCategories(); // not defined
};

private:
    Text(); // not defined
    ~Text(); // not defined
};

struct Format: public comphelper::ConfigurationGroup< Format> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option"_ustr); return PATH; }

struct UseReplacementTable: public comphelper::ConfigurationProperty<UseReplacementTable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/UseReplacementTable"_ustr); return PATH; }
private:
    UseReplacementTable(); // not defined
    ~UseReplacementTable(); // not defined
};

struct TwoCapitalsAtStart: public comphelper::ConfigurationProperty<TwoCapitalsAtStart, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/TwoCapitalsAtStart"_ustr); return PATH; }
private:
    TwoCapitalsAtStart(); // not defined
    ~TwoCapitalsAtStart(); // not defined
};

struct CapitalAtStartSentence: public comphelper::ConfigurationProperty<CapitalAtStartSentence, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/CapitalAtStartSentence"_ustr); return PATH; }
private:
    CapitalAtStartSentence(); // not defined
    ~CapitalAtStartSentence(); // not defined
};

struct ChangeUnderlineWeight: public comphelper::ConfigurationProperty<ChangeUnderlineWeight, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeUnderlineWeight"_ustr); return PATH; }
private:
    ChangeUnderlineWeight(); // not defined
    ~ChangeUnderlineWeight(); // not defined
};

struct SetInetAttribute: public comphelper::ConfigurationProperty<SetInetAttribute, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/SetInetAttribute"_ustr); return PATH; }
private:
    SetInetAttribute(); // not defined
    ~SetInetAttribute(); // not defined
};

struct SetDOIAttribute: public comphelper::ConfigurationProperty<SetDOIAttribute, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/SetDOIAttribute"_ustr); return PATH; }
private:
    SetDOIAttribute(); // not defined
    ~SetDOIAttribute(); // not defined
};

struct ChangeOrdinalNumber: public comphelper::ConfigurationProperty<ChangeOrdinalNumber, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeOrdinalNumber"_ustr); return PATH; }
private:
    ChangeOrdinalNumber(); // not defined
    ~ChangeOrdinalNumber(); // not defined
};

struct ChangeDash: public comphelper::ConfigurationProperty<ChangeDash, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeDash"_ustr); return PATH; }
private:
    ChangeDash(); // not defined
    ~ChangeDash(); // not defined
};

struct AddNonBreakingSpace: public comphelper::ConfigurationProperty<AddNonBreakingSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/AddNonBreakingSpace"_ustr); return PATH; }
private:
    AddNonBreakingSpace(); // not defined
    ~AddNonBreakingSpace(); // not defined
};

struct TransliterateRTL: public comphelper::ConfigurationProperty<TransliterateRTL, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/TransliterateRTL"_ustr); return PATH; }
private:
    TransliterateRTL(); // not defined
    ~TransliterateRTL(); // not defined
};

struct ChangeAngleQuotes: public comphelper::ConfigurationProperty<ChangeAngleQuotes, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeAngleQuotes"_ustr); return PATH; }
private:
    ChangeAngleQuotes(); // not defined
    ~ChangeAngleQuotes(); // not defined
};

struct DelEmptyParagraphs: public comphelper::ConfigurationProperty<DelEmptyParagraphs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/DelEmptyParagraphs"_ustr); return PATH; }
private:
    DelEmptyParagraphs(); // not defined
    ~DelEmptyParagraphs(); // not defined
};

struct ReplaceUserStyle: public comphelper::ConfigurationProperty<ReplaceUserStyle, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ReplaceUserStyle"_ustr); return PATH; }
private:
    ReplaceUserStyle(); // not defined
    ~ReplaceUserStyle(); // not defined
};

struct CombineParagraphs: public comphelper::ConfigurationProperty<CombineParagraphs, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/CombineParagraphs"_ustr); return PATH; }
private:
    CombineParagraphs(); // not defined
    ~CombineParagraphs(); // not defined
};

struct CombineValue: public comphelper::ConfigurationProperty<CombineValue, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/CombineValue"_ustr); return PATH; }
private:
    CombineValue(); // not defined
    ~CombineValue(); // not defined
};

struct DelSpacesAtStartEnd: public comphelper::ConfigurationProperty<DelSpacesAtStartEnd, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/DelSpacesAtStartEnd"_ustr); return PATH; }
private:
    DelSpacesAtStartEnd(); // not defined
    ~DelSpacesAtStartEnd(); // not defined
};

struct DelSpacesBetween: public comphelper::ConfigurationProperty<DelSpacesBetween, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/DelSpacesBetween"_ustr); return PATH; }
private:
    DelSpacesBetween(); // not defined
    ~DelSpacesBetween(); // not defined
};

struct ChangeToBullets: public comphelper::ConfigurationGroup< ChangeToBullets> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct SpecialCharacter: public comphelper::ConfigurationGroup< SpecialCharacter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter"_ustr); return PATH; }

struct Char: public comphelper::ConfigurationProperty<Char, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter/Char"_ustr); return PATH; }
private:
    Char(); // not defined
    ~Char(); // not defined
};

struct Font: public comphelper::ConfigurationProperty<Font, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter/Font"_ustr); return PATH; }
private:
    Font(); // not defined
    ~Font(); // not defined
};

struct FontFamily: public comphelper::ConfigurationProperty<FontFamily, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter/FontFamily"_ustr); return PATH; }
private:
    FontFamily(); // not defined
    ~FontFamily(); // not defined
};

struct FontCharset: public comphelper::ConfigurationProperty<FontCharset, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter/FontCharset"_ustr); return PATH; }
private:
    FontCharset(); // not defined
    ~FontCharset(); // not defined
};

struct FontPitch: public comphelper::ConfigurationProperty<FontPitch, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/Option/ChangeToBullets/SpecialCharacter/FontPitch"_ustr); return PATH; }
private:
    FontPitch(); // not defined
    ~FontPitch(); // not defined
};

private:
    SpecialCharacter(); // not defined
    ~SpecialCharacter(); // not defined
};

private:
    ChangeToBullets(); // not defined
    ~ChangeToBullets(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct ByInput: public comphelper::ConfigurationGroup< ByInput> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct ChangeDash: public comphelper::ConfigurationProperty<ChangeDash, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ChangeDash"_ustr); return PATH; }
private:
    ChangeDash(); // not defined
    ~ChangeDash(); // not defined
};

struct ChangeToBorders: public comphelper::ConfigurationProperty<ChangeToBorders, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ChangeToBorders"_ustr); return PATH; }
private:
    ChangeToBorders(); // not defined
    ~ChangeToBorders(); // not defined
};

struct ChangeToTable: public comphelper::ConfigurationProperty<ChangeToTable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ChangeToTable"_ustr); return PATH; }
private:
    ChangeToTable(); // not defined
    ~ChangeToTable(); // not defined
};

struct ReplaceStyle: public comphelper::ConfigurationProperty<ReplaceStyle, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ReplaceStyle"_ustr); return PATH; }
private:
    ReplaceStyle(); // not defined
    ~ReplaceStyle(); // not defined
};

struct DelSpacesAtStartEnd: public comphelper::ConfigurationProperty<DelSpacesAtStartEnd, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/DelSpacesAtStartEnd"_ustr); return PATH; }
private:
    DelSpacesAtStartEnd(); // not defined
    ~DelSpacesAtStartEnd(); // not defined
};

struct DelSpacesBetween: public comphelper::ConfigurationProperty<DelSpacesBetween, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/DelSpacesBetween"_ustr); return PATH; }
private:
    DelSpacesBetween(); // not defined
    ~DelSpacesBetween(); // not defined
};

struct ApplyBulletsAfterSpace: public comphelper::ConfigurationProperty<ApplyBulletsAfterSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyBulletsAfterSpace"_ustr); return PATH; }
private:
    ApplyBulletsAfterSpace(); // not defined
    ~ApplyBulletsAfterSpace(); // not defined
};

struct ApplyNumbering: public comphelper::ConfigurationGroup< ApplyNumbering> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct SpecialCharacter: public comphelper::ConfigurationGroup< SpecialCharacter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter"_ustr); return PATH; }

struct Char: public comphelper::ConfigurationProperty<Char, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter/Char"_ustr); return PATH; }
private:
    Char(); // not defined
    ~Char(); // not defined
};

struct Font: public comphelper::ConfigurationProperty<Font, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter/Font"_ustr); return PATH; }
private:
    Font(); // not defined
    ~Font(); // not defined
};

struct FontFamily: public comphelper::ConfigurationProperty<FontFamily, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter/FontFamily"_ustr); return PATH; }
private:
    FontFamily(); // not defined
    ~FontFamily(); // not defined
};

struct FontCharset: public comphelper::ConfigurationProperty<FontCharset, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter/FontCharset"_ustr); return PATH; }
private:
    FontCharset(); // not defined
    ~FontCharset(); // not defined
};

struct FontPitch: public comphelper::ConfigurationProperty<FontPitch, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Format/ByInput/ApplyNumbering/SpecialCharacter/FontPitch"_ustr); return PATH; }
private:
    FontPitch(); // not defined
    ~FontPitch(); // not defined
};

private:
    SpecialCharacter(); // not defined
    ~SpecialCharacter(); // not defined
};

private:
    ApplyNumbering(); // not defined
    ~ApplyNumbering(); // not defined
};

private:
    ByInput(); // not defined
    ~ByInput(); // not defined
};

private:
    Format(); // not defined
    ~Format(); // not defined
};

struct Completion: public comphelper::ConfigurationGroup< Completion> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion"_ustr); return PATH; }

struct Enable: public comphelper::ConfigurationProperty<Enable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/Enable"_ustr); return PATH; }
private:
    Enable(); // not defined
    ~Enable(); // not defined
};

struct MinWordLen: public comphelper::ConfigurationProperty<MinWordLen, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/MinWordLen"_ustr); return PATH; }
private:
    MinWordLen(); // not defined
    ~MinWordLen(); // not defined
};

struct MaxListLen: public comphelper::ConfigurationProperty<MaxListLen, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/MaxListLen"_ustr); return PATH; }
private:
    MaxListLen(); // not defined
    ~MaxListLen(); // not defined
};

struct CollectWords: public comphelper::ConfigurationProperty<CollectWords, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/CollectWords"_ustr); return PATH; }
private:
    CollectWords(); // not defined
    ~CollectWords(); // not defined
};

struct EndlessList: public comphelper::ConfigurationProperty<EndlessList, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/EndlessList"_ustr); return PATH; }
private:
    EndlessList(); // not defined
    ~EndlessList(); // not defined
};

struct AppendBlank: public comphelper::ConfigurationProperty<AppendBlank, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/AppendBlank"_ustr); return PATH; }
private:
    AppendBlank(); // not defined
    ~AppendBlank(); // not defined
};

struct ShowAsTip: public comphelper::ConfigurationProperty<ShowAsTip, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/ShowAsTip"_ustr); return PATH; }
private:
    ShowAsTip(); // not defined
    ~ShowAsTip(); // not defined
};

struct AcceptKey: public comphelper::ConfigurationProperty<AcceptKey, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/AcceptKey"_ustr); return PATH; }
private:
    AcceptKey(); // not defined
    ~AcceptKey(); // not defined
};

struct KeepList: public comphelper::ConfigurationProperty<KeepList, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/AutoFunction/Completion/KeepList"_ustr); return PATH; }
private:
    KeepList(); // not defined
    ~KeepList(); // not defined
};

private:
    Completion(); // not defined
    ~Completion(); // not defined
};

private:
    AutoFunction(); // not defined
    ~AutoFunction(); // not defined
};

struct Label: public comphelper::ConfigurationGroup< Label> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label"_ustr); return PATH; }

struct Inscription: public comphelper::ConfigurationGroup< Inscription> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Inscription"_ustr); return PATH; }

struct UseAddress: public comphelper::ConfigurationProperty<UseAddress, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Inscription/UseAddress"_ustr); return PATH; }
private:
    UseAddress(); // not defined
    ~UseAddress(); // not defined
};

struct Address: public comphelper::ConfigurationProperty<Address, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Inscription/Address"_ustr); return PATH; }
private:
    Address(); // not defined
    ~Address(); // not defined
};

struct Database: public comphelper::ConfigurationProperty<Database, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Inscription/Database"_ustr); return PATH; }
private:
    Database(); // not defined
    ~Database(); // not defined
};

private:
    Inscription(); // not defined
    ~Inscription(); // not defined
};

struct Medium: public comphelper::ConfigurationGroup< Medium> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Medium"_ustr); return PATH; }

struct Continuous: public comphelper::ConfigurationProperty<Continuous, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Medium/Continuous"_ustr); return PATH; }
private:
    Continuous(); // not defined
    ~Continuous(); // not defined
};

struct Brand: public comphelper::ConfigurationProperty<Brand, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Medium/Brand"_ustr); return PATH; }
private:
    Brand(); // not defined
    ~Brand(); // not defined
};

struct Type: public comphelper::ConfigurationProperty<Type, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Medium/Type"_ustr); return PATH; }
private:
    Type(); // not defined
    ~Type(); // not defined
};

private:
    Medium(); // not defined
    ~Medium(); // not defined
};

struct Format: public comphelper::ConfigurationGroup< Format> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format"_ustr); return PATH; }

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct HorizontalDistance: public comphelper::ConfigurationProperty<HorizontalDistance, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/HorizontalDistance"_ustr); return PATH; }
private:
    HorizontalDistance(); // not defined
    ~HorizontalDistance(); // not defined
};

struct VerticalDistance: public comphelper::ConfigurationProperty<VerticalDistance, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/VerticalDistance"_ustr); return PATH; }
private:
    VerticalDistance(); // not defined
    ~VerticalDistance(); // not defined
};

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

struct LeftMargin: public comphelper::ConfigurationProperty<LeftMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/LeftMargin"_ustr); return PATH; }
private:
    LeftMargin(); // not defined
    ~LeftMargin(); // not defined
};

struct TopMargin: public comphelper::ConfigurationProperty<TopMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/TopMargin"_ustr); return PATH; }
private:
    TopMargin(); // not defined
    ~TopMargin(); // not defined
};

struct PageWidth: public comphelper::ConfigurationProperty<PageWidth, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/PageWidth"_ustr); return PATH; }
private:
    PageWidth(); // not defined
    ~PageWidth(); // not defined
};

struct PageHeight: public comphelper::ConfigurationProperty<PageHeight, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Format/PageHeight"_ustr); return PATH; }
private:
    PageHeight(); // not defined
    ~PageHeight(); // not defined
};

private:
    Format(); // not defined
    ~Format(); // not defined
};

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Option"_ustr); return PATH; }

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

struct Page: public comphelper::ConfigurationProperty<Page, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Option/Page"_ustr); return PATH; }
private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Option/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Label/Option/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

private:
    Label(); // not defined
    ~Label(); // not defined
};

struct BusinessCard: public comphelper::ConfigurationGroup< BusinessCard> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard"_ustr); return PATH; }

struct Medium: public comphelper::ConfigurationGroup< Medium> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Medium"_ustr); return PATH; }

struct Continuous: public comphelper::ConfigurationProperty<Continuous, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Medium/Continuous"_ustr); return PATH; }
private:
    Continuous(); // not defined
    ~Continuous(); // not defined
};

struct Brand: public comphelper::ConfigurationProperty<Brand, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Medium/Brand"_ustr); return PATH; }
private:
    Brand(); // not defined
    ~Brand(); // not defined
};

struct Type: public comphelper::ConfigurationProperty<Type, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Medium/Type"_ustr); return PATH; }
private:
    Type(); // not defined
    ~Type(); // not defined
};

private:
    Medium(); // not defined
    ~Medium(); // not defined
};

struct Format: public comphelper::ConfigurationGroup< Format> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format"_ustr); return PATH; }

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

struct HorizontalDistance: public comphelper::ConfigurationProperty<HorizontalDistance, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/HorizontalDistance"_ustr); return PATH; }
private:
    HorizontalDistance(); // not defined
    ~HorizontalDistance(); // not defined
};

struct VerticalDistance: public comphelper::ConfigurationProperty<VerticalDistance, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/VerticalDistance"_ustr); return PATH; }
private:
    VerticalDistance(); // not defined
    ~VerticalDistance(); // not defined
};

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

struct LeftMargin: public comphelper::ConfigurationProperty<LeftMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/LeftMargin"_ustr); return PATH; }
private:
    LeftMargin(); // not defined
    ~LeftMargin(); // not defined
};

struct TopMargin: public comphelper::ConfigurationProperty<TopMargin, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Format/TopMargin"_ustr); return PATH; }
private:
    TopMargin(); // not defined
    ~TopMargin(); // not defined
};

private:
    Format(); // not defined
    ~Format(); // not defined
};

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Option"_ustr); return PATH; }

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

struct Page: public comphelper::ConfigurationProperty<Page, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Option/Page"_ustr); return PATH; }
private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Column: public comphelper::ConfigurationProperty<Column, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Option/Column"_ustr); return PATH; }
private:
    Column(); // not defined
    ~Column(); // not defined
};

struct Row: public comphelper::ConfigurationProperty<Row, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/Option/Row"_ustr); return PATH; }
private:
    Row(); // not defined
    ~Row(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct AutoText: public comphelper::ConfigurationGroup< AutoText> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/AutoText"_ustr); return PATH; }

struct Group: public comphelper::ConfigurationProperty<Group, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/AutoText/Group"_ustr); return PATH; }
private:
    Group(); // not defined
    ~Group(); // not defined
};

struct Block: public comphelper::ConfigurationProperty<Block, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/AutoText/Block"_ustr); return PATH; }
private:
    Block(); // not defined
    ~Block(); // not defined
};

private:
    AutoText(); // not defined
    ~AutoText(); // not defined
};

struct PrivateAddress: public comphelper::ConfigurationGroup< PrivateAddress> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress"_ustr); return PATH; }

struct FirstName: public comphelper::ConfigurationProperty<FirstName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/FirstName"_ustr); return PATH; }
private:
    FirstName(); // not defined
    ~FirstName(); // not defined
};

struct Name: public comphelper::ConfigurationProperty<Name, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Name"_ustr); return PATH; }
private:
    Name(); // not defined
    ~Name(); // not defined
};

struct ShortCut: public comphelper::ConfigurationProperty<ShortCut, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/ShortCut"_ustr); return PATH; }
private:
    ShortCut(); // not defined
    ~ShortCut(); // not defined
};

struct SecondFirstName: public comphelper::ConfigurationProperty<SecondFirstName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/SecondFirstName"_ustr); return PATH; }
private:
    SecondFirstName(); // not defined
    ~SecondFirstName(); // not defined
};

struct SecondName: public comphelper::ConfigurationProperty<SecondName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/SecondName"_ustr); return PATH; }
private:
    SecondName(); // not defined
    ~SecondName(); // not defined
};

struct SecondShortCut: public comphelper::ConfigurationProperty<SecondShortCut, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/SecondShortCut"_ustr); return PATH; }
private:
    SecondShortCut(); // not defined
    ~SecondShortCut(); // not defined
};

struct Street: public comphelper::ConfigurationProperty<Street, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Street"_ustr); return PATH; }
private:
    Street(); // not defined
    ~Street(); // not defined
};

struct Zip: public comphelper::ConfigurationProperty<Zip, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Zip"_ustr); return PATH; }
private:
    Zip(); // not defined
    ~Zip(); // not defined
};

struct City: public comphelper::ConfigurationProperty<City, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/City"_ustr); return PATH; }
private:
    City(); // not defined
    ~City(); // not defined
};

struct Country: public comphelper::ConfigurationProperty<Country, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Country"_ustr); return PATH; }
private:
    Country(); // not defined
    ~Country(); // not defined
};

struct State: public comphelper::ConfigurationProperty<State, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/State"_ustr); return PATH; }
private:
    State(); // not defined
    ~State(); // not defined
};

struct Title: public comphelper::ConfigurationProperty<Title, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Title"_ustr); return PATH; }
private:
    Title(); // not defined
    ~Title(); // not defined
};

struct Profession: public comphelper::ConfigurationProperty<Profession, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Profession"_ustr); return PATH; }
private:
    Profession(); // not defined
    ~Profession(); // not defined
};

struct Phone: public comphelper::ConfigurationProperty<Phone, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Phone"_ustr); return PATH; }
private:
    Phone(); // not defined
    ~Phone(); // not defined
};

struct Mobile: public comphelper::ConfigurationProperty<Mobile, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Mobile"_ustr); return PATH; }
private:
    Mobile(); // not defined
    ~Mobile(); // not defined
};

struct Fax: public comphelper::ConfigurationProperty<Fax, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Fax"_ustr); return PATH; }
private:
    Fax(); // not defined
    ~Fax(); // not defined
};

struct WebAddress: public comphelper::ConfigurationProperty<WebAddress, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/WebAddress"_ustr); return PATH; }
private:
    WebAddress(); // not defined
    ~WebAddress(); // not defined
};

struct Email: public comphelper::ConfigurationProperty<Email, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/PrivateAddress/Email"_ustr); return PATH; }
private:
    Email(); // not defined
    ~Email(); // not defined
};

private:
    PrivateAddress(); // not defined
    ~PrivateAddress(); // not defined
};

struct BusinessAddress: public comphelper::ConfigurationGroup< BusinessAddress> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress"_ustr); return PATH; }

struct Company: public comphelper::ConfigurationProperty<Company, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Company"_ustr); return PATH; }
private:
    Company(); // not defined
    ~Company(); // not defined
};

struct CompanyExt: public comphelper::ConfigurationProperty<CompanyExt, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/CompanyExt"_ustr); return PATH; }
private:
    CompanyExt(); // not defined
    ~CompanyExt(); // not defined
};

struct Slogan: public comphelper::ConfigurationProperty<Slogan, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Slogan"_ustr); return PATH; }
private:
    Slogan(); // not defined
    ~Slogan(); // not defined
};

struct Street: public comphelper::ConfigurationProperty<Street, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Street"_ustr); return PATH; }
private:
    Street(); // not defined
    ~Street(); // not defined
};

struct Zip: public comphelper::ConfigurationProperty<Zip, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Zip"_ustr); return PATH; }
private:
    Zip(); // not defined
    ~Zip(); // not defined
};

struct City: public comphelper::ConfigurationProperty<City, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/City"_ustr); return PATH; }
private:
    City(); // not defined
    ~City(); // not defined
};

struct Country: public comphelper::ConfigurationProperty<Country, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Country"_ustr); return PATH; }
private:
    Country(); // not defined
    ~Country(); // not defined
};

struct State: public comphelper::ConfigurationProperty<State, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/State"_ustr); return PATH; }
private:
    State(); // not defined
    ~State(); // not defined
};

struct Position: public comphelper::ConfigurationProperty<Position, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Position"_ustr); return PATH; }
private:
    Position(); // not defined
    ~Position(); // not defined
};

struct Phone: public comphelper::ConfigurationProperty<Phone, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Phone"_ustr); return PATH; }
private:
    Phone(); // not defined
    ~Phone(); // not defined
};

struct Mobile: public comphelper::ConfigurationProperty<Mobile, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Mobile"_ustr); return PATH; }
private:
    Mobile(); // not defined
    ~Mobile(); // not defined
};

struct Fax: public comphelper::ConfigurationProperty<Fax, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Fax"_ustr); return PATH; }
private:
    Fax(); // not defined
    ~Fax(); // not defined
};

struct WebAddress: public comphelper::ConfigurationProperty<WebAddress, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/WebAddress"_ustr); return PATH; }
private:
    WebAddress(); // not defined
    ~WebAddress(); // not defined
};

struct Email: public comphelper::ConfigurationProperty<Email, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/BusinessCard/BusinessAddress/Email"_ustr); return PATH; }
private:
    Email(); // not defined
    ~Email(); // not defined
};

private:
    BusinessAddress(); // not defined
    ~BusinessAddress(); // not defined
};

private:
    BusinessCard(); // not defined
    ~BusinessCard(); // not defined
};

struct ObjectBar: public comphelper::ConfigurationGroup< ObjectBar> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar"_ustr); return PATH; }

struct Selection: public comphelper::ConfigurationGroup< Selection> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection"_ustr); return PATH; }

struct Graphic: public comphelper::ConfigurationProperty<Graphic, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection/Graphic"_ustr); return PATH; }
private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct Table: public comphelper::ConfigurationProperty<Table, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection/Table"_ustr); return PATH; }
private:
    Table(); // not defined
    ~Table(); // not defined
};

struct NumberedList: public comphelper::ConfigurationProperty<NumberedList, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection/NumberedList"_ustr); return PATH; }
private:
    NumberedList(); // not defined
    ~NumberedList(); // not defined
};

struct NumberedList_InTable: public comphelper::ConfigurationProperty<NumberedList_InTable, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection/NumberedList_InTable"_ustr); return PATH; }
private:
    NumberedList_InTable(); // not defined
    ~NumberedList_InTable(); // not defined
};

struct BezierObject: public comphelper::ConfigurationProperty<BezierObject, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/ObjectBar/Selection/BezierObject"_ustr); return PATH; }
private:
    BezierObject(); // not defined
    ~BezierObject(); // not defined
};

private:
    Selection(); // not defined
    ~Selection(); // not defined
};

private:
    ObjectBar(); // not defined
    ~ObjectBar(); // not defined
};

struct Notes: public comphelper::ConfigurationGroup< Notes> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Notes"_ustr); return PATH; }

struct ShowAnkor: public comphelper::ConfigurationProperty<ShowAnkor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Notes/ShowAnkor"_ustr); return PATH; }
private:
    ShowAnkor(); // not defined
    ~ShowAnkor(); // not defined
};

struct DisplayWidthFactor: public comphelper::ConfigurationProperty<DisplayWidthFactor, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Notes/DisplayWidthFactor"_ustr); return PATH; }
private:
    DisplayWidthFactor(); // not defined
    ~DisplayWidthFactor(); // not defined
};

private:
    Notes(); // not defined
    ~Notes(); // not defined
};

struct WordCount: public comphelper::ConfigurationGroup< WordCount> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/WordCount"_ustr); return PATH; }

struct AdditionalSeparators: public comphelper::ConfigurationProperty<AdditionalSeparators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/WordCount/AdditionalSeparators"_ustr); return PATH; }
private:
    AdditionalSeparators(); // not defined
    ~AdditionalSeparators(); // not defined
};

struct ShowStandardizedPageCount: public comphelper::ConfigurationProperty<ShowStandardizedPageCount, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/WordCount/ShowStandardizedPageCount"_ustr); return PATH; }
private:
    ShowStandardizedPageCount(); // not defined
    ~ShowStandardizedPageCount(); // not defined
};

struct StandardizedPageSize: public comphelper::ConfigurationProperty<StandardizedPageSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/WordCount/StandardizedPageSize"_ustr); return PATH; }
private:
    StandardizedPageSize(); // not defined
    ~StandardizedPageSize(); // not defined
};

private:
    WordCount(); // not defined
    ~WordCount(); // not defined
};

struct Navigator: public comphelper::ConfigurationGroup< Navigator> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator"_ustr); return PATH; }

struct ShowListBox: public comphelper::ConfigurationProperty<ShowListBox, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/ShowListBox"_ustr); return PATH; }
private:
    ShowListBox(); // not defined
    ~ShowListBox(); // not defined
};

struct GlobalDocMode: public comphelper::ConfigurationProperty<GlobalDocMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/GlobalDocMode"_ustr); return PATH; }
private:
    GlobalDocMode(); // not defined
    ~GlobalDocMode(); // not defined
};

struct RootType: public comphelper::ConfigurationProperty<RootType, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/RootType"_ustr); return PATH; }
private:
    RootType(); // not defined
    ~RootType(); // not defined
};

struct SelectedPosition: public comphelper::ConfigurationProperty<SelectedPosition, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/SelectedPosition"_ustr); return PATH; }
private:
    SelectedPosition(); // not defined
    ~SelectedPosition(); // not defined
};

struct OutlineLevel: public comphelper::ConfigurationProperty<OutlineLevel, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/OutlineLevel"_ustr); return PATH; }
private:
    OutlineLevel(); // not defined
    ~OutlineLevel(); // not defined
};

struct InsertMode: public comphelper::ConfigurationProperty<InsertMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/InsertMode"_ustr); return PATH; }
private:
    InsertMode(); // not defined
    ~InsertMode(); // not defined
};

struct ActiveBlock: public comphelper::ConfigurationProperty<ActiveBlock, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/ActiveBlock"_ustr); return PATH; }
private:
    ActiveBlock(); // not defined
    ~ActiveBlock(); // not defined
};

struct OutlineTracking: public comphelper::ConfigurationProperty<OutlineTracking, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/OutlineTracking"_ustr); return PATH; }
private:
    OutlineTracking(); // not defined
    ~OutlineTracking(); // not defined
};

struct TableTracking: public comphelper::ConfigurationProperty<TableTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/TableTracking"_ustr); return PATH; }
private:
    TableTracking(); // not defined
    ~TableTracking(); // not defined
};

struct FrameTracking: public comphelper::ConfigurationProperty<FrameTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/FrameTracking"_ustr); return PATH; }
private:
    FrameTracking(); // not defined
    ~FrameTracking(); // not defined
};

struct ImageTracking: public comphelper::ConfigurationProperty<ImageTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/ImageTracking"_ustr); return PATH; }
private:
    ImageTracking(); // not defined
    ~ImageTracking(); // not defined
};

struct OLEobjectTracking: public comphelper::ConfigurationProperty<OLEobjectTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/OLEobjectTracking"_ustr); return PATH; }
private:
    OLEobjectTracking(); // not defined
    ~OLEobjectTracking(); // not defined
};

struct BookmarkTracking: public comphelper::ConfigurationProperty<BookmarkTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/BookmarkTracking"_ustr); return PATH; }
private:
    BookmarkTracking(); // not defined
    ~BookmarkTracking(); // not defined
};

struct SectionTracking: public comphelper::ConfigurationProperty<SectionTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/SectionTracking"_ustr); return PATH; }
private:
    SectionTracking(); // not defined
    ~SectionTracking(); // not defined
};

struct HyperlinkTracking: public comphelper::ConfigurationProperty<HyperlinkTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/HyperlinkTracking"_ustr); return PATH; }
private:
    HyperlinkTracking(); // not defined
    ~HyperlinkTracking(); // not defined
};

struct ReferenceTracking: public comphelper::ConfigurationProperty<ReferenceTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/ReferenceTracking"_ustr); return PATH; }
private:
    ReferenceTracking(); // not defined
    ~ReferenceTracking(); // not defined
};

struct IndexTracking: public comphelper::ConfigurationProperty<IndexTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/IndexTracking"_ustr); return PATH; }
private:
    IndexTracking(); // not defined
    ~IndexTracking(); // not defined
};

struct CommentTracking: public comphelper::ConfigurationProperty<CommentTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/CommentTracking"_ustr); return PATH; }
private:
    CommentTracking(); // not defined
    ~CommentTracking(); // not defined
};

struct DrawingObjectTracking: public comphelper::ConfigurationProperty<DrawingObjectTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/DrawingObjectTracking"_ustr); return PATH; }
private:
    DrawingObjectTracking(); // not defined
    ~DrawingObjectTracking(); // not defined
};

struct FieldTracking: public comphelper::ConfigurationProperty<FieldTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/FieldTracking"_ustr); return PATH; }
private:
    FieldTracking(); // not defined
    ~FieldTracking(); // not defined
};

struct FootnoteTracking: public comphelper::ConfigurationProperty<FootnoteTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/FootnoteTracking"_ustr); return PATH; }
private:
    FootnoteTracking(); // not defined
    ~FootnoteTracking(); // not defined
};

struct EndnoteTracking: public comphelper::ConfigurationProperty<EndnoteTracking, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/EndnoteTracking"_ustr); return PATH; }
private:
    EndnoteTracking(); // not defined
    ~EndnoteTracking(); // not defined
};

struct NavigateOnSelect: public comphelper::ConfigurationProperty<NavigateOnSelect, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/NavigateOnSelect"_ustr); return PATH; }
private:
    NavigateOnSelect(); // not defined
    ~NavigateOnSelect(); // not defined
};

struct SortAlphabeticallyBlock: public comphelper::ConfigurationProperty<SortAlphabeticallyBlock, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Navigator/SortAlphabeticallyBlock"_ustr); return PATH; }
private:
    SortAlphabeticallyBlock(); // not defined
    ~SortAlphabeticallyBlock(); // not defined
};

private:
    Navigator(); // not defined
    ~Navigator(); // not defined
};

struct Envelope: public comphelper::ConfigurationGroup< Envelope> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope"_ustr); return PATH; }

struct Inscription: public comphelper::ConfigurationGroup< Inscription> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Inscription"_ustr); return PATH; }

struct Addressee: public comphelper::ConfigurationProperty<Addressee, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Inscription/Addressee"_ustr); return PATH; }
private:
    Addressee(); // not defined
    ~Addressee(); // not defined
};

struct Sender: public comphelper::ConfigurationProperty<Sender, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Inscription/Sender"_ustr); return PATH; }
private:
    Sender(); // not defined
    ~Sender(); // not defined
};

struct UseSender: public comphelper::ConfigurationProperty<UseSender, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Inscription/UseSender"_ustr); return PATH; }
private:
    UseSender(); // not defined
    ~UseSender(); // not defined
};

struct Database: public comphelper::ConfigurationProperty<Database, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Inscription/Database"_ustr); return PATH; }
private:
    Database(); // not defined
    ~Database(); // not defined
};

private:
    Inscription(); // not defined
    ~Inscription(); // not defined
};

struct Format: public comphelper::ConfigurationGroup< Format> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format"_ustr); return PATH; }

struct AddresseeFromLeft: public comphelper::ConfigurationProperty<AddresseeFromLeft, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/AddresseeFromLeft"_ustr); return PATH; }
private:
    AddresseeFromLeft(); // not defined
    ~AddresseeFromLeft(); // not defined
};

struct AddresseeFromTop: public comphelper::ConfigurationProperty<AddresseeFromTop, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/AddresseeFromTop"_ustr); return PATH; }
private:
    AddresseeFromTop(); // not defined
    ~AddresseeFromTop(); // not defined
};

struct SenderFromLeft: public comphelper::ConfigurationProperty<SenderFromLeft, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/SenderFromLeft"_ustr); return PATH; }
private:
    SenderFromLeft(); // not defined
    ~SenderFromLeft(); // not defined
};

struct SenderFromTop: public comphelper::ConfigurationProperty<SenderFromTop, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/SenderFromTop"_ustr); return PATH; }
private:
    SenderFromTop(); // not defined
    ~SenderFromTop(); // not defined
};

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Format/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

private:
    Format(); // not defined
    ~Format(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Print"_ustr); return PATH; }

struct Alignment: public comphelper::ConfigurationProperty<Alignment, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Print/Alignment"_ustr); return PATH; }
private:
    Alignment(); // not defined
    ~Alignment(); // not defined
};

struct FromAbove: public comphelper::ConfigurationProperty<FromAbove, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Print/FromAbove"_ustr); return PATH; }
private:
    FromAbove(); // not defined
    ~FromAbove(); // not defined
};

struct Right: public comphelper::ConfigurationProperty<Right, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Print/Right"_ustr); return PATH; }
private:
    Right(); // not defined
    ~Right(); // not defined
};

struct Down: public comphelper::ConfigurationProperty<Down, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Envelope/Print/Down"_ustr); return PATH; }
private:
    Down(); // not defined
    ~Down(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

private:
    Envelope(); // not defined
    ~Envelope(); // not defined
};

struct InsertData: public comphelper::ConfigurationGroup< InsertData> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/InsertData"_ustr); return PATH; }

struct DataSet: public comphelper::ConfigurationSet< DataSet> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/InsertData/DataSet"_ustr); return PATH; }
private:
    DataSet(); // not defined
    ~DataSet(); // not defined
};

private:
    InsertData(); // not defined
    ~InsertData(); // not defined
};

struct Filter: public comphelper::ConfigurationGroup< Filter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import"_ustr); return PATH; }

struct VBA: public comphelper::ConfigurationGroup< VBA> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/VBA"_ustr); return PATH; }

struct Load: public comphelper::ConfigurationProperty<Load, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/VBA/Load"_ustr); return PATH; }
private:
    Load(); // not defined
    ~Load(); // not defined
};

struct Executable: public comphelper::ConfigurationProperty<Executable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/VBA/Executable"_ustr); return PATH; }
private:
    Executable(); // not defined
    ~Executable(); // not defined
};

struct Save: public comphelper::ConfigurationProperty<Save, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/VBA/Save"_ustr); return PATH; }
private:
    Save(); // not defined
    ~Save(); // not defined
};

private:
    VBA(); // not defined
    ~VBA(); // not defined
};

struct HTML: public comphelper::ConfigurationGroup< HTML> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/HTML"_ustr); return PATH; }

struct IgnoreComments: public comphelper::ConfigurationProperty<IgnoreComments, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/HTML/IgnoreComments"_ustr); return PATH; }
private:
    IgnoreComments(); // not defined
    ~IgnoreComments(); // not defined
};

private:
    HTML(); // not defined
    ~HTML(); // not defined
};

struct DOCX: public comphelper::ConfigurationGroup< DOCX> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/DOCX"_ustr); return PATH; }

struct ImportComboBoxAsDropDown: public comphelper::ConfigurationProperty<ImportComboBoxAsDropDown, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Filter/Import/DOCX/ImportComboBoxAsDropDown"_ustr); return PATH; }
private:
    ImportComboBoxAsDropDown(); // not defined
    ~ImportComboBoxAsDropDown(); // not defined
};

private:
    DOCX(); // not defined
    ~DOCX(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct Numbering: public comphelper::ConfigurationGroup< Numbering> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering"_ustr); return PATH; }

struct Graphic: public comphelper::ConfigurationGroup< Graphic> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/Graphic"_ustr); return PATH; }

struct KeepRatio: public comphelper::ConfigurationProperty<KeepRatio, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/Graphic/KeepRatio"_ustr); return PATH; }
private:
    KeepRatio(); // not defined
    ~KeepRatio(); // not defined
};

private:
    Graphic(); // not defined
    ~Graphic(); // not defined
};

struct DefaultBulletList: public comphelper::ConfigurationGroup< DefaultBulletList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList"_ustr); return PATH; }

struct BulletFont: public comphelper::ConfigurationGroup< BulletFont> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletFont"_ustr); return PATH; }

struct FontFamilyname: public comphelper::ConfigurationProperty<FontFamilyname, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletFont/FontFamilyname"_ustr); return PATH; }
private:
    FontFamilyname(); // not defined
    ~FontFamilyname(); // not defined
};

struct FontWeight: public comphelper::ConfigurationProperty<FontWeight, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletFont/FontWeight"_ustr); return PATH; }
private:
    FontWeight(); // not defined
    ~FontWeight(); // not defined
};

struct FontItalic: public comphelper::ConfigurationProperty<FontItalic, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletFont/FontItalic"_ustr); return PATH; }
private:
    FontItalic(); // not defined
    ~FontItalic(); // not defined
};

private:
    BulletFont(); // not defined
    ~BulletFont(); // not defined
};

struct BulletCharLvl1: public comphelper::ConfigurationProperty<BulletCharLvl1, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl1"_ustr); return PATH; }
private:
    BulletCharLvl1(); // not defined
    ~BulletCharLvl1(); // not defined
};

struct BulletCharLvl2: public comphelper::ConfigurationProperty<BulletCharLvl2, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl2"_ustr); return PATH; }
private:
    BulletCharLvl2(); // not defined
    ~BulletCharLvl2(); // not defined
};

struct BulletCharLvl3: public comphelper::ConfigurationProperty<BulletCharLvl3, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl3"_ustr); return PATH; }
private:
    BulletCharLvl3(); // not defined
    ~BulletCharLvl3(); // not defined
};

struct BulletCharLvl4: public comphelper::ConfigurationProperty<BulletCharLvl4, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl4"_ustr); return PATH; }
private:
    BulletCharLvl4(); // not defined
    ~BulletCharLvl4(); // not defined
};

struct BulletCharLvl5: public comphelper::ConfigurationProperty<BulletCharLvl5, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl5"_ustr); return PATH; }
private:
    BulletCharLvl5(); // not defined
    ~BulletCharLvl5(); // not defined
};

struct BulletCharLvl6: public comphelper::ConfigurationProperty<BulletCharLvl6, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl6"_ustr); return PATH; }
private:
    BulletCharLvl6(); // not defined
    ~BulletCharLvl6(); // not defined
};

struct BulletCharLvl7: public comphelper::ConfigurationProperty<BulletCharLvl7, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl7"_ustr); return PATH; }
private:
    BulletCharLvl7(); // not defined
    ~BulletCharLvl7(); // not defined
};

struct BulletCharLvl8: public comphelper::ConfigurationProperty<BulletCharLvl8, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl8"_ustr); return PATH; }
private:
    BulletCharLvl8(); // not defined
    ~BulletCharLvl8(); // not defined
};

struct BulletCharLvl9: public comphelper::ConfigurationProperty<BulletCharLvl9, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl9"_ustr); return PATH; }
private:
    BulletCharLvl9(); // not defined
    ~BulletCharLvl9(); // not defined
};

struct BulletCharLvl10: public comphelper::ConfigurationProperty<BulletCharLvl10, std::optional<sal_Int16> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/DefaultBulletList/BulletCharLvl10"_ustr); return PATH; }
private:
    BulletCharLvl10(); // not defined
    ~BulletCharLvl10(); // not defined
};

private:
    DefaultBulletList(); // not defined
    ~DefaultBulletList(); // not defined
};

struct UserInterfaceBehavior: public comphelper::ConfigurationGroup< UserInterfaceBehavior> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/UserInterfaceBehavior"_ustr); return PATH; }

struct ChangeIndentOnTabAtFirstPosOfFirstListItem: public comphelper::ConfigurationProperty<ChangeIndentOnTabAtFirstPosOfFirstListItem, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Numbering/UserInterfaceBehavior/ChangeIndentOnTabAtFirstPosOfFirstListItem"_ustr); return PATH; }
private:
    ChangeIndentOnTabAtFirstPosOfFirstListItem(); // not defined
    ~ChangeIndentOnTabAtFirstPosOfFirstListItem(); // not defined
};

private:
    UserInterfaceBehavior(); // not defined
    ~UserInterfaceBehavior(); // not defined
};

private:
    Numbering(); // not defined
    ~Numbering(); // not defined
};

struct Statistics: public comphelper::ConfigurationGroup< Statistics> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Statistics"_ustr); return PATH; }

struct WordNumber: public comphelper::ConfigurationGroup< WordNumber> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Statistics/WordNumber"_ustr); return PATH; }

struct Delimiter: public comphelper::ConfigurationProperty<Delimiter, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Statistics/WordNumber/Delimiter"_ustr); return PATH; }
private:
    Delimiter(); // not defined
    ~Delimiter(); // not defined
};

private:
    WordNumber(); // not defined
    ~WordNumber(); // not defined
};

private:
    Statistics(); // not defined
    ~Statistics(); // not defined
};

struct Index: public comphelper::ConfigurationGroup< Index> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Index"_ustr); return PATH; }

struct ShowPreview: public comphelper::ConfigurationProperty<ShowPreview, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Index/ShowPreview"_ustr); return PATH; }
private:
    ShowPreview(); // not defined
    ~ShowPreview(); // not defined
};

private:
    Index(); // not defined
    ~Index(); // not defined
};

struct FormLetter: public comphelper::ConfigurationGroup< FormLetter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter"_ustr); return PATH; }

struct PrintOutput: public comphelper::ConfigurationGroup< PrintOutput> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/PrintOutput"_ustr); return PATH; }

struct AskForMerge: public comphelper::ConfigurationProperty<AskForMerge, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/PrintOutput/AskForMerge"_ustr); return PATH; }
private:
    AskForMerge(); // not defined
    ~AskForMerge(); // not defined
};

private:
    PrintOutput(); // not defined
    ~PrintOutput(); // not defined
};

struct MailingOutput: public comphelper::ConfigurationGroup< MailingOutput> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/MailingOutput"_ustr); return PATH; }

struct Format: public comphelper::ConfigurationProperty<Format, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/MailingOutput/Format"_ustr); return PATH; }
private:
    Format(); // not defined
    ~Format(); // not defined
};

private:
    MailingOutput(); // not defined
    ~MailingOutput(); // not defined
};

struct FileOutput: public comphelper::ConfigurationGroup< FileOutput> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput"_ustr); return PATH; }

struct Path: public comphelper::ConfigurationProperty<Path, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/Path"_ustr); return PATH; }
private:
    Path(); // not defined
    ~Path(); // not defined
};

struct FileName: public comphelper::ConfigurationGroup< FileName> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FileName"_ustr); return PATH; }

struct Generation: public comphelper::ConfigurationProperty<Generation, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FileName/Generation"_ustr); return PATH; }
private:
    Generation(); // not defined
    ~Generation(); // not defined
};

struct FromDatabaseField: public comphelper::ConfigurationProperty<FromDatabaseField, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FileName/FromDatabaseField"_ustr); return PATH; }
private:
    FromDatabaseField(); // not defined
    ~FromDatabaseField(); // not defined
};

struct FromManualSetting: public comphelper::ConfigurationProperty<FromManualSetting, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FileName/FromManualSetting"_ustr); return PATH; }
private:
    FromManualSetting(); // not defined
    ~FromManualSetting(); // not defined
};

private:
    FileName(); // not defined
    ~FileName(); // not defined
};

struct FilePassword: public comphelper::ConfigurationGroup< FilePassword> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FilePassword"_ustr); return PATH; }

struct Generation: public comphelper::ConfigurationProperty<Generation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FilePassword/Generation"_ustr); return PATH; }
private:
    Generation(); // not defined
    ~Generation(); // not defined
};

struct FromDatabaseField: public comphelper::ConfigurationProperty<FromDatabaseField, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/FileOutput/FilePassword/FromDatabaseField"_ustr); return PATH; }
private:
    FromDatabaseField(); // not defined
    ~FromDatabaseField(); // not defined
};

private:
    FilePassword(); // not defined
    ~FilePassword(); // not defined
};

private:
    FileOutput(); // not defined
    ~FileOutput(); // not defined
};

struct ConvertToTextOnlyMMFields: public comphelper::ConfigurationProperty<ConvertToTextOnlyMMFields, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FormLetter/ConvertToTextOnlyMMFields"_ustr); return PATH; }
private:
    ConvertToTextOnlyMMFields(); // not defined
    ~ConvertToTextOnlyMMFields(); // not defined
};

private:
    FormLetter(); // not defined
    ~FormLetter(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Misc"_ustr); return PATH; }

struct GraphicToGalleryAsLink: public comphelper::ConfigurationProperty<GraphicToGalleryAsLink, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Misc/GraphicToGalleryAsLink"_ustr); return PATH; }
private:
    GraphicToGalleryAsLink(); // not defined
    ~GraphicToGalleryAsLink(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct FilterFlags: public comphelper::ConfigurationGroup< FilterFlags> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags"_ustr); return PATH; }

struct WinWord: public comphelper::ConfigurationGroup< WinWord> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord"_ustr); return PATH; }

struct WW1F: public comphelper::ConfigurationProperty<WW1F, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WW1F"_ustr); return PATH; }
private:
    WW1F(); // not defined
    ~WW1F(); // not defined
};

struct WW: public comphelper::ConfigurationProperty<WW, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WW"_ustr); return PATH; }
private:
    WW(); // not defined
    ~WW(); // not defined
};

struct WW8: public comphelper::ConfigurationProperty<WW8, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WW8"_ustr); return PATH; }
private:
    WW8(); // not defined
    ~WW8(); // not defined
};

struct WWF: public comphelper::ConfigurationProperty<WWF, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWF"_ustr); return PATH; }
private:
    WWF(); // not defined
    ~WWF(); // not defined
};

struct WWFA0: public comphelper::ConfigurationProperty<WWFA0, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFA0"_ustr); return PATH; }
private:
    WWFA0(); // not defined
    ~WWFA0(); // not defined
};

struct WWFA1: public comphelper::ConfigurationProperty<WWFA1, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFA1"_ustr); return PATH; }
private:
    WWFA1(); // not defined
    ~WWFA1(); // not defined
};

struct WWFA2: public comphelper::ConfigurationProperty<WWFA2, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFA2"_ustr); return PATH; }
private:
    WWFA2(); // not defined
    ~WWFA2(); // not defined
};

struct WWFB0: public comphelper::ConfigurationProperty<WWFB0, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFB0"_ustr); return PATH; }
private:
    WWFB0(); // not defined
    ~WWFB0(); // not defined
};

struct WWFB1: public comphelper::ConfigurationProperty<WWFB1, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFB1"_ustr); return PATH; }
private:
    WWFB1(); // not defined
    ~WWFB1(); // not defined
};

struct WWFB2: public comphelper::ConfigurationProperty<WWFB2, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFB2"_ustr); return PATH; }
private:
    WWFB2(); // not defined
    ~WWFB2(); // not defined
};

struct WWFLX: public comphelper::ConfigurationProperty<WWFLX, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFLX"_ustr); return PATH; }
private:
    WWFLX(); // not defined
    ~WWFLX(); // not defined
};

struct WWFLY: public comphelper::ConfigurationProperty<WWFLY, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFLY"_ustr); return PATH; }
private:
    WWFLY(); // not defined
    ~WWFLY(); // not defined
};

struct WWFT: public comphelper::ConfigurationProperty<WWFT, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWFT"_ustr); return PATH; }
private:
    WWFT(); // not defined
    ~WWFT(); // not defined
};

struct WWWR: public comphelper::ConfigurationProperty<WWWR, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/WWWR"_ustr); return PATH; }
private:
    WWWR(); // not defined
    ~WWWR(); // not defined
};

struct RegardHindiDigits: public comphelper::ConfigurationProperty<RegardHindiDigits, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/WinWord/RegardHindiDigits"_ustr); return PATH; }
private:
    RegardHindiDigits(); // not defined
    ~RegardHindiDigits(); // not defined
};

private:
    WinWord(); // not defined
    ~WinWord(); // not defined
};

struct HTML: public comphelper::ConfigurationGroup< HTML> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/HTML"_ustr); return PATH; }

struct IncludeHiddenText: public comphelper::ConfigurationProperty<IncludeHiddenText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/HTML/IncludeHiddenText"_ustr); return PATH; }
private:
    IncludeHiddenText(); // not defined
    ~IncludeHiddenText(); // not defined
};

private:
    HTML(); // not defined
    ~HTML(); // not defined
};

struct ASCII: public comphelper::ConfigurationGroup< ASCII> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/ASCII"_ustr); return PATH; }

struct IncludeHiddenText: public comphelper::ConfigurationProperty<IncludeHiddenText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/FilterFlags/ASCII/IncludeHiddenText"_ustr); return PATH; }
private:
    IncludeHiddenText(); // not defined
    ~IncludeHiddenText(); // not defined
};

private:
    ASCII(); // not defined
    ~ASCII(); // not defined
};

private:
    FilterFlags(); // not defined
    ~FilterFlags(); // not defined
};

struct Wizards: public comphelper::ConfigurationGroup< Wizards> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards"_ustr); return PATH; }

struct Letter: public comphelper::ConfigurationGroup< Letter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Letter"_ustr); return PATH; }

struct LetterType: public comphelper::ConfigurationProperty<LetterType, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Letter/LetterType"_ustr); return PATH; }
private:
    LetterType(); // not defined
    ~LetterType(); // not defined
};

private:
    Letter(); // not defined
    ~Letter(); // not defined
};

struct Fax: public comphelper::ConfigurationGroup< Fax> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Fax"_ustr); return PATH; }

struct FaxType: public comphelper::ConfigurationProperty<FaxType, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Fax/FaxType"_ustr); return PATH; }
private:
    FaxType(); // not defined
    ~FaxType(); // not defined
};

private:
    Fax(); // not defined
    ~Fax(); // not defined
};

struct Agenda: public comphelper::ConfigurationGroup< Agenda> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda"_ustr); return PATH; }

struct AgendaType: public comphelper::ConfigurationProperty<AgendaType, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/AgendaType"_ustr); return PATH; }
private:
    AgendaType(); // not defined
    ~AgendaType(); // not defined
};

struct IncludeMinutes: public comphelper::ConfigurationProperty<IncludeMinutes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/IncludeMinutes"_ustr); return PATH; }
private:
    IncludeMinutes(); // not defined
    ~IncludeMinutes(); // not defined
};

struct Title: public comphelper::ConfigurationProperty<Title, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/Title"_ustr); return PATH; }
private:
    Title(); // not defined
    ~Title(); // not defined
};

struct Date: public comphelper::ConfigurationProperty<Date, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/Date"_ustr); return PATH; }
private:
    Date(); // not defined
    ~Date(); // not defined
};

struct Time: public comphelper::ConfigurationProperty<Time, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/Time"_ustr); return PATH; }
private:
    Time(); // not defined
    ~Time(); // not defined
};

struct Location: public comphelper::ConfigurationProperty<Location, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/Location"_ustr); return PATH; }
private:
    Location(); // not defined
    ~Location(); // not defined
};

struct ShowMeetingType: public comphelper::ConfigurationProperty<ShowMeetingType, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowMeetingType"_ustr); return PATH; }
private:
    ShowMeetingType(); // not defined
    ~ShowMeetingType(); // not defined
};

struct ShowRead: public comphelper::ConfigurationProperty<ShowRead, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowRead"_ustr); return PATH; }
private:
    ShowRead(); // not defined
    ~ShowRead(); // not defined
};

struct ShowBring: public comphelper::ConfigurationProperty<ShowBring, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowBring"_ustr); return PATH; }
private:
    ShowBring(); // not defined
    ~ShowBring(); // not defined
};

struct ShowNotes: public comphelper::ConfigurationProperty<ShowNotes, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowNotes"_ustr); return PATH; }
private:
    ShowNotes(); // not defined
    ~ShowNotes(); // not defined
};

struct ShowCalledBy: public comphelper::ConfigurationProperty<ShowCalledBy, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowCalledBy"_ustr); return PATH; }
private:
    ShowCalledBy(); // not defined
    ~ShowCalledBy(); // not defined
};

struct ShowFacilitator: public comphelper::ConfigurationProperty<ShowFacilitator, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowFacilitator"_ustr); return PATH; }
private:
    ShowFacilitator(); // not defined
    ~ShowFacilitator(); // not defined
};

struct ShowNotetaker: public comphelper::ConfigurationProperty<ShowNotetaker, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowNotetaker"_ustr); return PATH; }
private:
    ShowNotetaker(); // not defined
    ~ShowNotetaker(); // not defined
};

struct ShowTimekeeper: public comphelper::ConfigurationProperty<ShowTimekeeper, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowTimekeeper"_ustr); return PATH; }
private:
    ShowTimekeeper(); // not defined
    ~ShowTimekeeper(); // not defined
};

struct ShowAttendees: public comphelper::ConfigurationProperty<ShowAttendees, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowAttendees"_ustr); return PATH; }
private:
    ShowAttendees(); // not defined
    ~ShowAttendees(); // not defined
};

struct ShowObservers: public comphelper::ConfigurationProperty<ShowObservers, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowObservers"_ustr); return PATH; }
private:
    ShowObservers(); // not defined
    ~ShowObservers(); // not defined
};

struct ShowResourcePersons: public comphelper::ConfigurationProperty<ShowResourcePersons, std::optional<bool> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ShowResourcePersons"_ustr); return PATH; }
private:
    ShowResourcePersons(); // not defined
    ~ShowResourcePersons(); // not defined
};

struct TemplateName: public comphelper::ConfigurationProperty<TemplateName, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/TemplateName"_ustr); return PATH; }
private:
    TemplateName(); // not defined
    ~TemplateName(); // not defined
};

struct TemplatePath: public comphelper::ConfigurationProperty<TemplatePath, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/TemplatePath"_ustr); return PATH; }
private:
    TemplatePath(); // not defined
    ~TemplatePath(); // not defined
};

struct ProceedMethod: public comphelper::ConfigurationProperty<ProceedMethod, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/ProceedMethod"_ustr); return PATH; }
private:
    ProceedMethod(); // not defined
    ~ProceedMethod(); // not defined
};

struct Topics: public comphelper::ConfigurationSet< Topics> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Writer/Wizards/Agenda/Topics"_ustr); return PATH; }
private:
    Topics(); // not defined
    ~Topics(); // not defined
};

private:
    Agenda(); // not defined
    ~Agenda(); // not defined
};

private:
    Wizards(); // not defined
    ~Wizards(); // not defined
};

} } }

#endif
