#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0066\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x0046\x0072\x0065\x006e\x0063\x0068";
static constexpr OUStringLiteral countryID = u"\x004d\x0043";
static constexpr OUStringLiteral countryDefaultName = u"\x004d\x006f\x006e\x0061\x0063\x006f";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_fr_MC(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_fr_MC(sal_Int16& count)
{
	return getLocaleItem_fr_FR(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x46, 0x2d, 0x31, 0x38, 0x30, 0x43, 0x5d, 0x0};
extern OUString const * getAllFormats0_fr_FR(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_fr_MC(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_fr_FR(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_fr_MC(sal_Int16& count)
{
	return getDateAcceptancePatterns_fr_FR(count);
}
extern const OUString *  getCollatorImplementation_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_fr_MC(sal_Int16& count)
{
	return getCollatorImplementation_fr_FR(count);
}
extern const OUString *  getCollationOptions_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_fr_MC(sal_Int16& count)
{
	return getCollationOptions_fr_FR(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_fr_MC(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_fr_MC(sal_Int16& count)
{
	return getIndexAlgorithm_fr_FR(count);
}
extern const OUString *  getUnicodeScripts_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_fr_MC(sal_Int16& count)
{
	return getUnicodeScripts_fr_FR(count);
}
extern const OUString *  getFollowPageWords_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_fr_MC(sal_Int16& count)
{
	return getFollowPageWords_fr_FR(count);
}
extern const OUString *  getAllCalendars_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_fr_MC(sal_Int16& count)
{
	return getAllCalendars_fr_FR(count);
}
extern const OUString *  getAllCurrencies_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_fr_MC(sal_Int16& count)
{
	return getAllCurrencies_fr_FR(count);
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_fr_MC(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_fr_MC(sal_Int16& count)
{
	return getForbiddenCharacters_fr_FR(count);
}
extern const OUString *  getBreakIteratorRules_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_fr_MC(sal_Int16& count)
{
	return getBreakIteratorRules_fr_FR(count);
}
extern const OUString *  getReservedWords_fr_FR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_fr_MC(sal_Int16& count)
{
	return getReservedWords_fr_FR(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_fr_MC(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_fr_MC(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

