#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0061\x0066";
static constexpr OUStringLiteral langDefaultName = u"\x0041\x0066\x0072\x0069\x006b\x0061\x0061\x006e\x0073";
static constexpr OUStringLiteral countryID = u"\x004e\x0041";
static constexpr OUStringLiteral countryDefaultName = u"\x004e\x0061\x006d\x0069\x0062\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_af_NA(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_en_NA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_af_NA(sal_Int16& count)
{
	return getLocaleItem_en_NA(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x24, 0x2d, 0x38, 0x30, 0x33, 0x36, 0x5d, 0x0};
extern OUString const * getAllFormats0_en_NA(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_af_NA(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_en_NA(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_en_NA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_af_NA(sal_Int16& count)
{
	return getDateAcceptancePatterns_en_NA(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_af_NA(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_af_NA(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_af_NA(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_af_NA(sal_Int16& count)
{
	return getIndexAlgorithm_af_ZA(count);
}
extern const OUString *  getUnicodeScripts_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_af_NA(sal_Int16& count)
{
	return getUnicodeScripts_af_ZA(count);
}
extern const OUString *  getFollowPageWords_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_af_NA(sal_Int16& count)
{
	return getFollowPageWords_af_ZA(count);
}
extern const OUString *  getAllCalendars_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_af_NA(sal_Int16& count)
{
	return getAllCalendars_af_ZA(count);
}
extern const OUString *  getAllCurrencies_en_NA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_af_NA(sal_Int16& count)
{
	return getAllCurrencies_en_NA(count);
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_af_NA(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_af_NA(sal_Int16& count)
{
	return getForbiddenCharacters_af_ZA(count);
}
extern const OUString *  getBreakIteratorRules_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_af_NA(sal_Int16& count)
{
	return getBreakIteratorRules_af_ZA(count);
}
extern const OUString *  getReservedWords_af_ZA(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_af_NA(sal_Int16& count)
{
	return getReservedWords_af_ZA(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_af_NA(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_af_NA(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

