#ifndef SBK_KXYSELECTORWRAPPER_H
#define SBK_KXYSELECTORWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kxyselector.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KXYSelectorWrapper : public KXYSelector
{
public:
    KXYSelectorWrapper(::QWidget * parent = nullptr);
    KXYSelectorWrapper(const KXYSelectorWrapper &) = delete;
    KXYSelectorWrapper& operator=(const KXYSelectorWrapper &) = delete;
    KXYSelectorWrapper(KXYSelectorWrapper &&) = delete;
    KXYSelectorWrapper& operator=(KXYSelectorWrapper &&) = delete;
    ~KXYSelectorWrapper() override;

    void actionEvent(::QActionEvent * event) override;
    static void sbk_o_actionEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QActionEvent * event);
    void changeEvent(::QEvent * event) override;
    static void sbk_o_changeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void closeEvent(::QCloseEvent * event) override;
    static void sbk_o_closeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QCloseEvent * event);
    void connectNotify(const ::QMetaMethod & signal) override;
    static void sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal);
    void contextMenuEvent(::QContextMenuEvent * event) override;
    static void sbk_o_contextMenuEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QContextMenuEvent * event);
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    int devType() const override;
    static int sbk_o_devType(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    static void sbk_o_dragEnterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragEnterEvent * event);
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    static void sbk_o_dragLeaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragLeaveEvent * event);
    void dragMoveEvent(::QDragMoveEvent * event) override;
    static void sbk_o_dragMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDragMoveEvent * event);
    void drawContents(::QPainter * arg__1) override;
    static void sbk_o_drawContents(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPainter * arg__1);
    void drawMarker(::QPainter * p, int xp, int yp) override;
    static void sbk_o_drawMarker(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPainter * p, int xp, int yp);
    void dropEvent(::QDropEvent * event) override;
    static void sbk_o_dropEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDropEvent * event);
    void enterEvent(::QEnterEvent * event) override;
    static void sbk_o_enterEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEnterEvent * event);
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    void focusInEvent(::QFocusEvent * event) override;
    static void sbk_o_focusInEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool focusNextPrevChild(bool next) override;
    static bool sbk_o_focusNextPrevChild(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, bool next);
    void focusOutEvent(::QFocusEvent * event) override;
    static void sbk_o_focusOutEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFocusEvent * event);
    bool hasHeightForWidth() const override;
    static bool sbk_o_hasHeightForWidth(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    int heightForWidth(int arg__1) const override;
    static int sbk_o_heightForWidth(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int arg__1);
    void hideEvent(::QHideEvent * event) override;
    static void sbk_o_hideEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QHideEvent * event);
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    static void sbk_o_inputMethodEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QInputMethodEvent * event);
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    static ::QVariant sbk_o_inputMethodQuery(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::Qt::InputMethodQuery arg__1);
    void keyPressEvent(::QKeyEvent * event) override;
    static void sbk_o_keyPressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void keyReleaseEvent(::QKeyEvent * event) override;
    static void sbk_o_keyReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QKeyEvent * event);
    void leaveEvent(::QEvent * event) override;
    static void sbk_o_leaveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    static int sbk_o_metric(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPaintDevice::PaintDeviceMetric arg__1);
    ::QSize minimumSizeHint() const override;
    static ::QSize sbk_o_minimumSizeHint(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseDoubleClickEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void mouseMoveEvent(::QMouseEvent * e) override;
    static void sbk_o_mouseMoveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * e);
    void mousePressEvent(::QMouseEvent * e) override;
    static void sbk_o_mousePressEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * e);
    void mouseReleaseEvent(::QMouseEvent * event) override;
    static void sbk_o_mouseReleaseEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMouseEvent * event);
    void moveEvent(::QMoveEvent * event) override;
    static void sbk_o_moveEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QMoveEvent * event);
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    static bool sbk_o_nativeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QByteArray & eventType, void * message, ::qintptr * result);
    ::QPaintEngine * paintEngine() const override;
    static ::QPaintEngine * sbk_o_paintEngine(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void paintEvent(::QPaintEvent * e) override;
    static void sbk_o_paintEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPaintEvent * e);
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    static ::QPaintDevice * sbk_o_redirected(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPoint * offset);
    void resizeEvent(::QResizeEvent * event) override;
    static void sbk_o_resizeEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QResizeEvent * event);
    void setVisible(bool visible) override;
    static void sbk_o_setVisible(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, bool visible);
    ::QPainter * sharedPainter() const override;
    static ::QPainter * sbk_o_sharedPainter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void showEvent(::QShowEvent * event) override;
    static void sbk_o_showEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QShowEvent * event);
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    static void sbk_o_tabletEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTabletEvent * event);
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);
    void wheelEvent(::QWheelEvent * arg__1) override;
    static void sbk_o_wheelEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QWheelEvent * arg__1);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 49> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KXYSELECTORWRAPPER_H
