
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "knewpasswordwidget_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <knewpasswordwidget.h>
#include <kpassword.h>
#include <qbytearray.h>
#include <qcolor.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNewPasswordWidget_Type = nullptr;
static PyTypeObject *Sbk_KNewPasswordWidget_TypeF(void)
{
    return _Sbk_KNewPasswordWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNewPasswordWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNewPasswordWidgetWrapper::KNewPasswordWidgetWrapper(::QWidget * parent) : KNewPasswordWidget(parent)
{
}

void KNewPasswordWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KNewPasswordWidget", funcName, gil, pyOverride, signal);
}

void KNewPasswordWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

int KNewPasswordWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KNewPasswordWidget", funcName, gil, pyOverride);
}

void KNewPasswordWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KNewPasswordWidget", funcName, gil, pyOverride, signal);
}

void KNewPasswordWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

bool KNewPasswordWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

bool KNewPasswordWidgetWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KNewPasswordWidget", funcName, gil, pyOverride, watched, event);
}

void KNewPasswordWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

bool KNewPasswordWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KNewPasswordWidget", funcName, gil, pyOverride, next);
}

void KNewPasswordWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

bool KNewPasswordWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KNewPasswordWidget", funcName, gil, pyOverride);
}

int KNewPasswordWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KNewPasswordWidget", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KNewPasswordWidget", funcName, gil, pyOverride, painter);
}

void KNewPasswordWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

::QVariant KNewPasswordWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KNewPasswordWidget", funcName, gil, pyOverride, arg__1);
}

void KNewPasswordWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

int KNewPasswordWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KNewPasswordWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KNewPasswordWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KNewPasswordWidget", funcName, gil, pyOverride);
}

void KNewPasswordWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

bool KNewPasswordWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KNewPasswordWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KNewPasswordWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KNewPasswordWidget", funcName, gil, pyOverride);
}

void KNewPasswordWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KNewPasswordWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KNewPasswordWidget", funcName, gil, pyOverride, offset);
}

void KNewPasswordWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KNewPasswordWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KNewPasswordWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KNewPasswordWidget", funcName, gil, pyOverride);
}

void KNewPasswordWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

::QSize KNewPasswordWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KNewPasswordWidget", funcName, gil, pyOverride);
}

void KNewPasswordWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

void KNewPasswordWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNewPasswordWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KNewPasswordWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KNewPasswordWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNewPasswordWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNewPasswordWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNewPasswordWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNewPasswordWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNewPasswordWidgetWrapper *>(this));
    }
    return KNewPasswordWidget::qt_metacast(_clname);
}

KNewPasswordWidgetWrapper::~KNewPasswordWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNewPasswordWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNewPasswordWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNewPasswordWidget >()))
        return -1;

    KNewPasswordWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KNewPasswordWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNewPasswordWidget::KNewPasswordWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KNewPasswordWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KNewPasswordWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KNewPasswordWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KNewPasswordWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KNewPasswordWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNewPasswordWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNewPasswordWidgetFunc_allowEmptyPasswords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allowEmptyPasswords()const
        bool cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->allowEmptyPasswords();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_backgroundWarningColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backgroundWarningColor()const
        QColor cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->backgroundWarningColor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_isPasswordStrengthMeterVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isPasswordStrengthMeterVisible()const
        bool cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->isPasswordStrengthMeterVisible();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_isRevealPasswordAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KNewPasswordWidget", "isRevealPasswordAvailable() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // isRevealPasswordAvailable()const
        bool cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->isRevealPasswordAvailable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_maximumPasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumPasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->maximumPasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_minimumPasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumPasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->minimumPasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // password()const
        QString cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->password();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_passwordStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // passwordStatus()const
        KNewPasswordWidget::PasswordStatus cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->passwordStatus();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_PasswordStatus_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_passwordStrengthWarningLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // passwordStrengthWarningLevel()const
        int cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->passwordStrengthWarningLevel();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_reasonablePasswordLength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reasonablePasswordLength()const
        int cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->reasonablePasswordLength();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_revealPasswordMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // revealPasswordMode()const
        KPassword::RevealMode cppResult = const_cast<const ::KNewPasswordWidget *>(cppSelf)->revealPasswordMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setAllowEmptyPasswords(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setAllowEmptyPasswords(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllowEmptyPasswords(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAllowEmptyPasswords", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAllowEmptyPasswords(bool)
            cppSelf->setAllowEmptyPasswords(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setBackgroundWarningColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setBackgroundWarningColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundWarningColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBackgroundWarningColor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setBackgroundWarningColor(QColor)
            cppSelf->setBackgroundWarningColor(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setMaximumPasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setMaximumPasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaximumPasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaximumPasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumPasswordLength(int)
            cppSelf->setMaximumPasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setMinimumPasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setMinimumPasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMinimumPasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMinimumPasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinimumPasswordLength(int)
            cppSelf->setMinimumPasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setPasswordStrengthMeterVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setPasswordStrengthMeterVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPasswordStrengthMeterVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPasswordStrengthMeterVisible", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPasswordStrengthMeterVisible(bool)
            cppSelf->setPasswordStrengthMeterVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setPasswordStrengthWarningLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setPasswordStrengthWarningLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPasswordStrengthWarningLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPasswordStrengthWarningLevel", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPasswordStrengthWarningLevel(int)
            cppSelf->setPasswordStrengthWarningLevel(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setReasonablePasswordLength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setReasonablePasswordLength(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setReasonablePasswordLength(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setReasonablePasswordLength", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setReasonablePasswordLength(int)
            cppSelf->setReasonablePasswordLength(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setRevealPasswordAvailable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setRevealPasswordAvailable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRevealPasswordAvailable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordAvailable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KNewPasswordWidget", "setRevealPasswordAvailable(bool reveal)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordAvailable(bool)
            cppSelf->setRevealPasswordAvailable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNewPasswordWidgetFunc_setRevealPasswordMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KNewPasswordWidget::setRevealPasswordMode(KPassword::RevealMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPassword_RevealMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setRevealPasswordMode(KPassword::RevealMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRevealPasswordMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);

    // Call function/method
    {
        ::KPassword::RevealMode cppArg0{KPassword::RevealMode::OnlyNew};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRevealPasswordMode(KPassword::RevealMode)
            cppSelf->setRevealPasswordMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNewPasswordWidget_PropertyStrings[] = {
    "allowEmptyPasswords::",
    "backgroundWarningColor::",
    "maximumPasswordLength::",
    "minimumPasswordLength::",
    "passwordStatus:",
    "passwordStrengthMeterVisible:isPasswordStrengthMeterVisible:",
    "passwordStrengthWarningLevel::",
    "reasonablePasswordLength::",
    "revealPasswordAvailable:isRevealPasswordAvailable:",
    "revealPasswordMode::",
    nullptr // Sentinel
};

static const char *Sbk_KNewPasswordWidget_EnumFlagInfo[] = {
    "PasswordStatus:IntEnum",
    "RevealPasswordMode:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNewPasswordWidget_methods[] = {
    {"allowEmptyPasswords", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_allowEmptyPasswords), METH_NOARGS, nullptr},
    {"backgroundWarningColor", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_backgroundWarningColor), METH_NOARGS, nullptr},
    {"isPasswordStrengthMeterVisible", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_isPasswordStrengthMeterVisible), METH_NOARGS, nullptr},
    {"isRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_isRevealPasswordAvailable), METH_NOARGS, nullptr},
    {"maximumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_maximumPasswordLength), METH_NOARGS, nullptr},
    {"minimumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_minimumPasswordLength), METH_NOARGS, nullptr},
    {"password", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_password), METH_NOARGS, nullptr},
    {"passwordStatus", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_passwordStatus), METH_NOARGS, nullptr},
    {"passwordStrengthWarningLevel", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_passwordStrengthWarningLevel), METH_NOARGS, nullptr},
    {"reasonablePasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_reasonablePasswordLength), METH_NOARGS, nullptr},
    {"revealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_revealPasswordMode), METH_NOARGS, nullptr},
    {"setAllowEmptyPasswords", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setAllowEmptyPasswords), METH_O, nullptr},
    {"setBackgroundWarningColor", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setBackgroundWarningColor), METH_O, nullptr},
    {"setMaximumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setMaximumPasswordLength), METH_O, nullptr},
    {"setMinimumPasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setMinimumPasswordLength), METH_O, nullptr},
    {"setPasswordStrengthMeterVisible", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setPasswordStrengthMeterVisible), METH_O, nullptr},
    {"setPasswordStrengthWarningLevel", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setPasswordStrengthWarningLevel), METH_O, nullptr},
    {"setReasonablePasswordLength", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setReasonablePasswordLength), METH_O, nullptr},
    {"setRevealPasswordAvailable", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setRevealPasswordAvailable), METH_O, nullptr},
    {"setRevealPasswordMode", reinterpret_cast<PyCFunction>(Sbk_KNewPasswordWidgetFunc_setRevealPasswordMode), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNewPasswordWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNewPasswordWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNewPasswordWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNewPasswordWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNewPasswordWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KNewPasswordWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KNewPasswordWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNewPasswordWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNewPasswordWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNewPasswordWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNewPasswordWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNewPasswordWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNewPasswordWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNewPasswordWidget_spec = {
    "1:KWidgetsAddons.KNewPasswordWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNewPasswordWidget_slots
};

} //extern "C"

static void *Sbk_KNewPasswordWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KNewPasswordWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNewPasswordWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KNewPasswordWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KNewPasswordWidget_PasswordStatus(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNewPasswordWidget::PasswordStatus>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNewPasswordWidget::PasswordStatus *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNewPasswordWidget_PasswordStatus_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_PasswordStatus_IDX])))
        return Enum_PythonToCpp_KNewPasswordWidget_PasswordStatus;
    return {};
}

static PyObject *KNewPasswordWidget_PasswordStatus_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNewPasswordWidget::PasswordStatus>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNewPasswordWidget::PasswordStatus *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KNewPasswordWidget_RevealPasswordMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KNewPasswordWidget::RevealPasswordMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KNewPasswordWidget::RevealPasswordMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KNewPasswordWidget_RevealPasswordMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_RevealPasswordMode_IDX])))
        return Enum_PythonToCpp_KNewPasswordWidget_RevealPasswordMode;
    return {};
}

static PyObject *KNewPasswordWidget_RevealPasswordMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KNewPasswordWidget::RevealPasswordMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KNewPasswordWidget::RevealPasswordMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNewPasswordWidget_PythonToCpp_KNewPasswordWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNewPasswordWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNewPasswordWidget_PythonToCpp_KNewPasswordWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNewPasswordWidget_TypeF()))
        return KNewPasswordWidget_PythonToCpp_KNewPasswordWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNewPasswordWidget_PTR_CppToPython_KNewPasswordWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNewPasswordWidget *>(const_cast<void *>(cppIn)), Sbk_KNewPasswordWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNewPasswordWidget_SignatureStrings[] = {
    "KWidgetsAddons.KNewPasswordWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,passwordStatus:KWidgetsAddons.KNewPasswordWidget.PasswordStatus=None,allowEmptyPasswords:bool=None,minimumPasswordLength:int=None,maximumPasswordLength:int=None,reasonablePasswordLength:int=None,passwordStrengthWarningLevel:int=None,backgroundWarningColor:QColor=None,passwordStrengthMeterVisible:bool=None,revealPasswordAvailable:bool=None,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode=None)",
    "KWidgetsAddons.KNewPasswordWidget.allowEmptyPasswords(self)->bool",
    "KWidgetsAddons.KNewPasswordWidget.backgroundWarningColor(self)->PySide6.QtGui.QColor",
    "KWidgetsAddons.KNewPasswordWidget.isPasswordStrengthMeterVisible(self)->bool",
    "KWidgetsAddons.KNewPasswordWidget.isRevealPasswordAvailable(self)->bool",
    "KWidgetsAddons.KNewPasswordWidget.maximumPasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordWidget.minimumPasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordWidget.password(self)->QString",
    "KWidgetsAddons.KNewPasswordWidget.passwordStatus(self)->KWidgetsAddons.KNewPasswordWidget.PasswordStatus",
    "KWidgetsAddons.KNewPasswordWidget.passwordStrengthWarningLevel(self)->int",
    "KWidgetsAddons.KNewPasswordWidget.reasonablePasswordLength(self)->int",
    "KWidgetsAddons.KNewPasswordWidget.revealPasswordMode(self)->KWidgetsAddons.KPassword.RevealMode",
    "KWidgetsAddons.KNewPasswordWidget.setAllowEmptyPasswords(self,allowed:bool)",
    "KWidgetsAddons.KNewPasswordWidget.setBackgroundWarningColor(self,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "KWidgetsAddons.KNewPasswordWidget.setMaximumPasswordLength(self,maxLength:int)",
    "KWidgetsAddons.KNewPasswordWidget.setMinimumPasswordLength(self,minLength:int)",
    "KWidgetsAddons.KNewPasswordWidget.setPasswordStrengthMeterVisible(self,visible:bool)",
    "KWidgetsAddons.KNewPasswordWidget.setPasswordStrengthWarningLevel(self,warningLevel:int)",
    "KWidgetsAddons.KNewPasswordWidget.setReasonablePasswordLength(self,reasonableLength:int)",
    "KWidgetsAddons.KNewPasswordWidget.setRevealPasswordAvailable(self,reveal:bool)",
    "KWidgetsAddons.KNewPasswordWidget.setRevealPasswordMode(self,revealPasswordMode:KWidgetsAddons.KPassword.RevealMode)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNewPasswordWidget_SignatureByteSize = 481;
static constexpr uint8_t KNewPasswordWidget_SignatureBytes[481] = {
    0x78, 0xda, 0x9d, 0x95, 0xc1, 0x6e, 0xdb, 0x30, 0x0c, 0x86, 0xef, 0x7d, 0x8a, 0x1c, 0x97, 0xc2,
    0x33, 0x30, 0x60, 0xe8, 0xc1, 0x40, 0x0b, 0x64, 0xc5, 0xd0, 0x43, 0x92, 0x36, 0x76, 0xd1, 0xf6,
    0x30, 0xec, 0x40, 0x57, 0x9c, 0x27, 0x4c, 0xa1, 0x02, 0x49, 0x4e, 0xe6, 0xb7, 0x9f, 0x6c, 0x45,
    0x48, 0x96, 0xc8, 0x8e, 0xd5, 0x93, 0x0d, 0x93, 0xfc, 0x24, 0xfd, 0xe6, 0x4f, 0xcd, 0xdf, 0x38,
    0xab, 0xd0, 0xe8, 0x19, 0x63, 0x92, 0x74, 0x3a, 0x7f, 0xc4, 0xdd, 0x0a, 0xb4, 0xde, 0x49, 0xc5,
    0x5c, 0xe4, 0x93, 0x46, 0xf1, 0x2b, 0xd9, 0x80, 0x42, 0x32, 0xd9, 0xaa, 0x79, 0xe6, 0x0c, 0x6f,
    0xd2, 0xdc, 0xec, 0xcb, 0xd2, 0xdc, 0xbd, 0xdc, 0x52, 0x2d, 0xc4, 0xc6, 0xa8, 0xe4, 0x3a, 0x9b,
    0x63, 0xd3, 0x56, 0x3f, 0x91, 0x68, 0x6e, 0x1f, 0x25, 0xa1, 0xad, 0x75, 0xbc, 0x67, 0x03, 0xa6,
    0xd6, 0xd9, 0xfc, 0xd2, 0x8a, 0xe9, 0xea, 0xbf, 0x02, 0x07, 0x01, 0x21, 0xe4, 0xee, 0xfb, 0x7a,
    0x63, 0x1a, 0x1f, 0xd5, 0x59, 0x29, 0xa5, 0x70, 0xd1, 0x35, 0x27, 0xbe, 0xae, 0xd7, 0x3e, 0xb4,
    0x40, 0xaa, 0xcc, 0xef, 0x8c, 0x93, 0xd9, 0x87, 0xe1, 0xef, 0x50, 0x58, 0x21, 0x68, 0x49, 0x50,
    0x0a, 0xec, 0xcb, 0x38, 0x1c, 0x41, 0x75, 0x91, 0x37, 0x50, 0xc4, 0xa9, 0x5a, 0xe0, 0x16, 0xc5,
    0x21, 0xab, 0x84, 0xf7, 0x3f, 0x95, 0x92, 0x35, 0xb1, 0x7d, 0xfc, 0x5e, 0x0a, 0xa9, 0xb2, 0xbc,
    0x7b, 0x84, 0x41, 0x4b, 0x34, 0xa8, 0x5e, 0xb9, 0xe6, 0x76, 0xf1, 0xa3, 0xf3, 0x28, 0x0b, 0x06,
    0xe1, 0x77, 0x33, 0xdb, 0x02, 0x17, 0x30, 0x94, 0xb1, 0x94, 0x0c, 0xcf, 0x84, 0xf5, 0xc1, 0xb4,
    0xe8, 0x72, 0xdb, 0x9c, 0xae, 0x76, 0x7a, 0x75, 0xf9, 0x17, 0x04, 0xe4, 0xee, 0x1a, 0x61, 0xfa,
    0xf9, 0xae, 0xdd, 0xc3, 0x08, 0x42, 0x58, 0x0c, 0x0f, 0x39, 0x34, 0xd2, 0x43, 0xcd, 0x53, 0xa7,
    0xd0, 0x08, 0x28, 0xd7, 0xab, 0x01, 0x01, 0x23, 0x77, 0xc8, 0x75, 0x11, 0x96, 0x39, 0x92, 0x13,
    0xec, 0x2e, 0xcf, 0xb0, 0xcd, 0x31, 0x06, 0x11, 0xea, 0xdf, 0x38, 0x84, 0xef, 0x2c, 0x5f, 0x95,
    0x5b, 0x85, 0xac, 0xea, 0x11, 0x95, 0xce, 0x6e, 0xbe, 0x3e, 0xd6, 0xa6, 0x51, 0x0b, 0x9d, 0xbb,
    0x28, 0xee, 0xb0, 0x7d, 0x8e, 0x8d, 0xa5, 0x9c, 0x7a, 0xa8, 0xef, 0xf0, 0x01, 0x2b, 0x8d, 0xe0,
    0x6b, 0x34, 0xb3, 0x1e, 0x1f, 0xb9, 0x79, 0x86, 0xac, 0x73, 0xf4, 0x74, 0x1c, 0xeb, 0x5b, 0xbf,
    0xa3, 0x92, 0xf7, 0x6e, 0xd2, 0x98, 0x66, 0x63, 0x3f, 0xa7, 0x2f, 0xc4, 0x25, 0xfd, 0x08, 0x59,
    0x2c, 0x99, 0xe4, 0x0b, 0x30, 0x9c, 0xbe, 0xb8, 0xe6, 0x48, 0x26, 0x27, 0x49, 0x45, 0x55, 0xc2,
    0xcd, 0x57, 0x9b, 0xf5, 0x0a, 0x8a, 0x03, 0x99, 0xe3, 0x84, 0x7b, 0xa9, 0xd0, 0x3e, 0xd2, 0x07,
    0x21, 0x4b, 0x10, 0x1e, 0xe7, 0x41, 0x35, 0x69, 0x5e, 0x11, 0xb2, 0x89, 0x95, 0xfe, 0xe7, 0xc8,
    0x03, 0x2d, 0x7b, 0x8d, 0xd3, 0x4e, 0xec, 0xc3, 0x0c, 0x1e, 0x8b, 0xeb, 0x35, 0x51, 0x7b, 0x3f,
    0x44, 0xe3, 0x2e, 0x4e, 0x9a, 0x64, 0x7b, 0x34, 0xb7, 0x3f, 0x08, 0x3d, 0xb3, 0x40, 0xb2, 0x3b,
    0xb9, 0x5a, 0x46, 0x82, 0x8b, 0x21, 0x47, 0x1c, 0xdd, 0x70, 0xd1, 0x32, 0x0c, 0xcd, 0xc8, 0xfd,
    0x2d, 0x14, 0x23, 0x40, 0x11, 0xf6, 0xdc, 0x07, 0xef, 0xb3, 0xe9, 0xd5, 0x3f, 0x9e, 0x10, 0x53,
    0xc7
};
#endif

PyTypeObject *init_KNewPasswordWidget(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KNewPasswordWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KNewPasswordWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNewPasswordWidget",
        "KNewPasswordWidget*",
        &Sbk_KNewPasswordWidget_spec,
        &Shiboken::callCppDestructor< KNewPasswordWidget >,
        Sbk_KNewPasswordWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KNewPasswordWidget_Type; // references _Sbk_KNewPasswordWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNewPasswordWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNewPasswordWidget_SignatureBytes, KNewPasswordWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNewPasswordWidget_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNewPasswordWidget_PythonToCpp_KNewPasswordWidget_PTR,
        is_KNewPasswordWidget_PythonToCpp_KNewPasswordWidget_PTR_Convertible,
        KNewPasswordWidget_PTR_CppToPython_KNewPasswordWidget);

    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordWidget");
    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KNewPasswordWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNewPasswordWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNewPasswordWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KNewPasswordWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KNewPasswordWidget_TypeF(), &Sbk_KNewPasswordWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNewPasswordWidget_TypeF(), &Sbk_KNewPasswordWidget_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KNewPasswordWidget_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'PasswordStatus'.
    const char *PasswordStatus_Initializer[] = {
        "EmptyPasswordNotAllowed",
        "PasswordTooShort",
        "PasswordNotVerified",
        "WeakPassword",
        "StrongPassword",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t PasswordStatus_InitializerValues[] = {
        uint8_t(KNewPasswordWidget::PasswordStatus::EmptyPasswordNotAllowed), //  0x00  0
        uint8_t(KNewPasswordWidget::PasswordStatus::PasswordTooShort),        //  0x01  1
        uint8_t(KNewPasswordWidget::PasswordStatus::PasswordNotVerified),     //  0x02  2
        uint8_t(KNewPasswordWidget::PasswordStatus::WeakPassword),            //  0x03  3
        uint8_t(KNewPasswordWidget::PasswordStatus::StrongPassword)           //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNewPasswordWidget_TypeF(),
        "1:KWidgetsAddons.KNewPasswordWidget.PasswordStatus",
        PasswordStatus_Initializer, PasswordStatus_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_PasswordStatus_IDX].type = EType;
    // Register converter for enum 'KNewPasswordWidget::PasswordStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNewPasswordWidget_PasswordStatus_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNewPasswordWidget_PasswordStatus,
            is_Enum_PythonToCpp_KNewPasswordWidget_PasswordStatus_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNewPasswordWidget::PasswordStatus");
        Shiboken::Conversions::registerConverterAlias(converter, "PasswordStatus");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'PasswordStatus' enum.

    // Initialization of enum 'RevealPasswordMode'.
    const char *RevealPasswordMode_Initializer[] = {
        "OnlyNew",
        "Never",
        "Always",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t RevealPasswordMode_InitializerValues[] = {
        int8_t(KNewPasswordWidget::RevealPasswordMode::OnlyNew), //  0x00  0
        int8_t(KNewPasswordWidget::RevealPasswordMode::Never),   //  0x01  1
        int8_t(KNewPasswordWidget::RevealPasswordMode::Always)   //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KNewPasswordWidget_TypeF(),
        "1:KWidgetsAddons.KNewPasswordWidget.RevealPasswordMode",
        RevealPasswordMode_Initializer, RevealPasswordMode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_RevealPasswordMode_IDX].type = EType;
    // Register converter for enum 'KNewPasswordWidget::RevealPasswordMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KNewPasswordWidget_RevealPasswordMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KNewPasswordWidget_RevealPasswordMode,
            is_Enum_PythonToCpp_KNewPasswordWidget_RevealPasswordMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KNewPasswordWidget::RevealPasswordMode");
        Shiboken::Conversions::registerConverterAlias(converter, "RevealPasswordMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'RevealPasswordMode' enum.

    PySide::Signal::registerSignals(pyType, &::KNewPasswordWidget::staticMetaObject);
    qRegisterMetaType< ::KNewPasswordWidget::PasswordStatus >("KNewPasswordWidget::PasswordStatus");
    qRegisterMetaType< ::KNewPasswordWidget::RevealPasswordMode >("KNewPasswordWidget::RevealPasswordMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNewPasswordWidget::staticMetaObject, sizeof(KNewPasswordWidgetWrapper));

    return pyType;
}
