/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apiv1 "sigs.k8s.io/gateway-api-inference-extension/api/v1"
)

// LabelSelectorApplyConfiguration represents a declarative configuration of the LabelSelector type for use
// with apply.
type LabelSelectorApplyConfiguration struct {
	MatchLabels map[apiv1.LabelKey]apiv1.LabelValue `json:"matchLabels,omitempty"`
}

// LabelSelectorApplyConfiguration constructs a declarative configuration of the LabelSelector type for use with
// apply.
func LabelSelector() *LabelSelectorApplyConfiguration {
	return &LabelSelectorApplyConfiguration{}
}

// WithMatchLabels puts the entries into the MatchLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the MatchLabels field,
// overwriting an existing map entries in MatchLabels field with the same key.
func (b *LabelSelectorApplyConfiguration) WithMatchLabels(entries map[apiv1.LabelKey]apiv1.LabelValue) *LabelSelectorApplyConfiguration {
	if b.MatchLabels == nil && len(entries) > 0 {
		b.MatchLabels = make(map[apiv1.LabelKey]apiv1.LabelValue, len(entries))
	}
	for k, v := range entries {
		b.MatchLabels[k] = v
	}
	return b
}
