//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/network/redis_proxy/v3/redis_proxy.proto

package redis_proxyv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on RedisProxy with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisProxy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RedisProxyMultiError, or
// nil if none found.
func (m *RedisProxy) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := RedisProxyValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSettings() == nil {
		err := RedisProxyValidationError{
			field:  "Settings",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSettings()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "Settings",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "Settings",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSettings()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxyValidationError{
				field:  "Settings",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for LatencyInMicros

	if all {
		switch v := interface{}(m.GetPrefixRoutes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "PrefixRoutes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "PrefixRoutes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPrefixRoutes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxyValidationError{
				field:  "PrefixRoutes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDownstreamAuthPassword()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "DownstreamAuthPassword",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "DownstreamAuthPassword",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamAuthPassword()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxyValidationError{
				field:  "DownstreamAuthPassword",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetDownstreamAuthPasswords() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisProxyValidationError{
						field:  fmt.Sprintf("DownstreamAuthPasswords[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisProxyValidationError{
						field:  fmt.Sprintf("DownstreamAuthPasswords[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisProxyValidationError{
					field:  fmt.Sprintf("DownstreamAuthPasswords[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetFaults() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisProxyValidationError{
						field:  fmt.Sprintf("Faults[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisProxyValidationError{
						field:  fmt.Sprintf("Faults[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisProxyValidationError{
					field:  fmt.Sprintf("Faults[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetDownstreamAuthUsername()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "DownstreamAuthUsername",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "DownstreamAuthUsername",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamAuthUsername()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxyValidationError{
				field:  "DownstreamAuthUsername",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetExternalAuthProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "ExternalAuthProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxyValidationError{
					field:  "ExternalAuthProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetExternalAuthProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxyValidationError{
				field:  "ExternalAuthProvider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProxyMultiError(errors)
	}

	return nil
}

// RedisProxyMultiError is an error wrapping multiple validation errors
// returned by RedisProxy.ValidateAll() if the designated constraints aren't met.
type RedisProxyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxyMultiError) AllErrors() []error { return m }

// RedisProxyValidationError is the validation error returned by
// RedisProxy.Validate if the designated constraints aren't met.
type RedisProxyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxyValidationError) ErrorName() string { return "RedisProxyValidationError" }

// Error satisfies the builtin error interface
func (e RedisProxyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxyValidationError{}

// Validate checks the field values on RedisProtocolOptions with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProtocolOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProtocolOptions with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisProtocolOptionsMultiError, or nil if none found.
func (m *RedisProtocolOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProtocolOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAuthPassword()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AuthPassword",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AuthPassword",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAuthPassword()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProtocolOptionsValidationError{
				field:  "AuthPassword",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAuthUsername()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AuthUsername",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AuthUsername",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAuthUsername()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProtocolOptionsValidationError{
				field:  "AuthUsername",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAwsIam()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AwsIam",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProtocolOptionsValidationError{
					field:  "AwsIam",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAwsIam()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProtocolOptionsValidationError{
				field:  "AwsIam",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProtocolOptionsMultiError(errors)
	}

	return nil
}

// RedisProtocolOptionsMultiError is an error wrapping multiple validation
// errors returned by RedisProtocolOptions.ValidateAll() if the designated
// constraints aren't met.
type RedisProtocolOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProtocolOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProtocolOptionsMultiError) AllErrors() []error { return m }

// RedisProtocolOptionsValidationError is the validation error returned by
// RedisProtocolOptions.Validate if the designated constraints aren't met.
type RedisProtocolOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProtocolOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProtocolOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProtocolOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProtocolOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProtocolOptionsValidationError) ErrorName() string {
	return "RedisProtocolOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProtocolOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProtocolOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProtocolOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProtocolOptionsValidationError{}

// Validate checks the field values on AwsIam with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AwsIam) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AwsIam with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in AwsIamMultiError, or nil if none found.
func (m *AwsIam) ValidateAll() error {
	return m.validate(true)
}

func (m *AwsIam) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCredentialProvider()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AwsIamValidationError{
					field:  "CredentialProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AwsIamValidationError{
					field:  "CredentialProvider",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCredentialProvider()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AwsIamValidationError{
				field:  "CredentialProvider",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetCacheName()) < 1 {
		err := AwsIamValidationError{
			field:  "CacheName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for ServiceName

	// no validation rules for Region

	if d := m.GetExpirationTime(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = AwsIamValidationError{
				field:  "ExpirationTime",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lte := time.Duration(900*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte || dur > lte {
				err := AwsIamValidationError{
					field:  "ExpirationTime",
					reason: "value must be inside range [0s, 15m0s]",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return AwsIamMultiError(errors)
	}

	return nil
}

// AwsIamMultiError is an error wrapping multiple validation errors returned by
// AwsIam.ValidateAll() if the designated constraints aren't met.
type AwsIamMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AwsIamMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AwsIamMultiError) AllErrors() []error { return m }

// AwsIamValidationError is the validation error returned by AwsIam.Validate if
// the designated constraints aren't met.
type AwsIamValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AwsIamValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AwsIamValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AwsIamValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AwsIamValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AwsIamValidationError) ErrorName() string { return "AwsIamValidationError" }

// Error satisfies the builtin error interface
func (e AwsIamValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAwsIam.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AwsIamValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AwsIamValidationError{}

// Validate checks the field values on RedisExternalAuthProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisExternalAuthProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisExternalAuthProvider with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisExternalAuthProviderMultiError, or nil if none found.
func (m *RedisExternalAuthProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisExternalAuthProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetGrpcService()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisExternalAuthProviderValidationError{
					field:  "GrpcService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisExternalAuthProviderValidationError{
					field:  "GrpcService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcService()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisExternalAuthProviderValidationError{
				field:  "GrpcService",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableAuthExpiration

	if len(errors) > 0 {
		return RedisExternalAuthProviderMultiError(errors)
	}

	return nil
}

// RedisExternalAuthProviderMultiError is an error wrapping multiple validation
// errors returned by RedisExternalAuthProvider.ValidateAll() if the
// designated constraints aren't met.
type RedisExternalAuthProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisExternalAuthProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisExternalAuthProviderMultiError) AllErrors() []error { return m }

// RedisExternalAuthProviderValidationError is the validation error returned by
// RedisExternalAuthProvider.Validate if the designated constraints aren't met.
type RedisExternalAuthProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisExternalAuthProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisExternalAuthProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisExternalAuthProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisExternalAuthProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisExternalAuthProviderValidationError) ErrorName() string {
	return "RedisExternalAuthProviderValidationError"
}

// Error satisfies the builtin error interface
func (e RedisExternalAuthProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisExternalAuthProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisExternalAuthProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisExternalAuthProviderValidationError{}

// Validate checks the field values on RedisProxy_ConnPoolSettings with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_ConnPoolSettings) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy_ConnPoolSettings with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisProxy_ConnPoolSettingsMultiError, or nil if none found.
func (m *RedisProxy_ConnPoolSettings) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_ConnPoolSettings) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetOpTimeout() == nil {
		err := RedisProxy_ConnPoolSettingsValidationError{
			field:  "OpTimeout",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for EnableHashtagging

	// no validation rules for EnableRedirection

	if all {
		switch v := interface{}(m.GetDnsCacheConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "DnsCacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "DnsCacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDnsCacheConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_ConnPoolSettingsValidationError{
				field:  "DnsCacheConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for MaxBufferSizeBeforeFlush

	if all {
		switch v := interface{}(m.GetBufferFlushTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "BufferFlushTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "BufferFlushTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBufferFlushTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_ConnPoolSettingsValidationError{
				field:  "BufferFlushTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxUpstreamUnknownConnections()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "MaxUpstreamUnknownConnections",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "MaxUpstreamUnknownConnections",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxUpstreamUnknownConnections()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_ConnPoolSettingsValidationError{
				field:  "MaxUpstreamUnknownConnections",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableCommandStats

	if _, ok := RedisProxy_ConnPoolSettings_ReadPolicy_name[int32(m.GetReadPolicy())]; !ok {
		err := RedisProxy_ConnPoolSettingsValidationError{
			field:  "ReadPolicy",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConnectionRateLimit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "ConnectionRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_ConnPoolSettingsValidationError{
					field:  "ConnectionRateLimit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConnectionRateLimit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_ConnPoolSettingsValidationError{
				field:  "ConnectionRateLimit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProxy_ConnPoolSettingsMultiError(errors)
	}

	return nil
}

// RedisProxy_ConnPoolSettingsMultiError is an error wrapping multiple
// validation errors returned by RedisProxy_ConnPoolSettings.ValidateAll() if
// the designated constraints aren't met.
type RedisProxy_ConnPoolSettingsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_ConnPoolSettingsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_ConnPoolSettingsMultiError) AllErrors() []error { return m }

// RedisProxy_ConnPoolSettingsValidationError is the validation error returned
// by RedisProxy_ConnPoolSettings.Validate if the designated constraints
// aren't met.
type RedisProxy_ConnPoolSettingsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_ConnPoolSettingsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxy_ConnPoolSettingsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxy_ConnPoolSettingsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_ConnPoolSettingsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_ConnPoolSettingsValidationError) ErrorName() string {
	return "RedisProxy_ConnPoolSettingsValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_ConnPoolSettingsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_ConnPoolSettings.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_ConnPoolSettingsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_ConnPoolSettingsValidationError{}

// Validate checks the field values on RedisProxy_PrefixRoutes with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_PrefixRoutes) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy_PrefixRoutes with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisProxy_PrefixRoutesMultiError, or nil if none found.
func (m *RedisProxy_PrefixRoutes) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_PrefixRoutes) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetRoutes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisProxy_PrefixRoutesValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisProxy_PrefixRoutesValidationError{
						field:  fmt.Sprintf("Routes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisProxy_PrefixRoutesValidationError{
					field:  fmt.Sprintf("Routes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for CaseInsensitive

	if all {
		switch v := interface{}(m.GetCatchAllRoute()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutesValidationError{
					field:  "CatchAllRoute",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutesValidationError{
					field:  "CatchAllRoute",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCatchAllRoute()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_PrefixRoutesValidationError{
				field:  "CatchAllRoute",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProxy_PrefixRoutesMultiError(errors)
	}

	return nil
}

// RedisProxy_PrefixRoutesMultiError is an error wrapping multiple validation
// errors returned by RedisProxy_PrefixRoutes.ValidateAll() if the designated
// constraints aren't met.
type RedisProxy_PrefixRoutesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_PrefixRoutesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_PrefixRoutesMultiError) AllErrors() []error { return m }

// RedisProxy_PrefixRoutesValidationError is the validation error returned by
// RedisProxy_PrefixRoutes.Validate if the designated constraints aren't met.
type RedisProxy_PrefixRoutesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_PrefixRoutesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxy_PrefixRoutesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxy_PrefixRoutesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_PrefixRoutesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_PrefixRoutesValidationError) ErrorName() string {
	return "RedisProxy_PrefixRoutesValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_PrefixRoutesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_PrefixRoutes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_PrefixRoutesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_PrefixRoutesValidationError{}

// Validate checks the field values on RedisProxy_RedisFault with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_RedisFault) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy_RedisFault with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RedisProxy_RedisFaultMultiError, or nil if none found.
func (m *RedisProxy_RedisFault) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_RedisFault) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := RedisProxy_RedisFault_RedisFaultType_name[int32(m.GetFaultType())]; !ok {
		err := RedisProxy_RedisFaultValidationError{
			field:  "FaultType",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetFaultEnabled() == nil {
		err := RedisProxy_RedisFaultValidationError{
			field:  "FaultEnabled",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFaultEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_RedisFaultValidationError{
					field:  "FaultEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_RedisFaultValidationError{
					field:  "FaultEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFaultEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_RedisFaultValidationError{
				field:  "FaultEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDelay()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_RedisFaultValidationError{
					field:  "Delay",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_RedisFaultValidationError{
					field:  "Delay",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDelay()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_RedisFaultValidationError{
				field:  "Delay",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProxy_RedisFaultMultiError(errors)
	}

	return nil
}

// RedisProxy_RedisFaultMultiError is an error wrapping multiple validation
// errors returned by RedisProxy_RedisFault.ValidateAll() if the designated
// constraints aren't met.
type RedisProxy_RedisFaultMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_RedisFaultMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_RedisFaultMultiError) AllErrors() []error { return m }

// RedisProxy_RedisFaultValidationError is the validation error returned by
// RedisProxy_RedisFault.Validate if the designated constraints aren't met.
type RedisProxy_RedisFaultValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_RedisFaultValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxy_RedisFaultValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxy_RedisFaultValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_RedisFaultValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_RedisFaultValidationError) ErrorName() string {
	return "RedisProxy_RedisFaultValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_RedisFaultValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_RedisFault.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_RedisFaultValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_RedisFaultValidationError{}

// Validate checks the field values on RedisProxy_ConnectionRateLimit with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_ConnectionRateLimit) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy_ConnectionRateLimit with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RedisProxy_ConnectionRateLimitMultiError, or nil if none found.
func (m *RedisProxy_ConnectionRateLimit) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_ConnectionRateLimit) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetConnectionRateLimitPerSec() <= 0 {
		err := RedisProxy_ConnectionRateLimitValidationError{
			field:  "ConnectionRateLimitPerSec",
			reason: "value must be greater than 0",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RedisProxy_ConnectionRateLimitMultiError(errors)
	}

	return nil
}

// RedisProxy_ConnectionRateLimitMultiError is an error wrapping multiple
// validation errors returned by RedisProxy_ConnectionRateLimit.ValidateAll()
// if the designated constraints aren't met.
type RedisProxy_ConnectionRateLimitMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_ConnectionRateLimitMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_ConnectionRateLimitMultiError) AllErrors() []error { return m }

// RedisProxy_ConnectionRateLimitValidationError is the validation error
// returned by RedisProxy_ConnectionRateLimit.Validate if the designated
// constraints aren't met.
type RedisProxy_ConnectionRateLimitValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_ConnectionRateLimitValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxy_ConnectionRateLimitValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxy_ConnectionRateLimitValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_ConnectionRateLimitValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_ConnectionRateLimitValidationError) ErrorName() string {
	return "RedisProxy_ConnectionRateLimitValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_ConnectionRateLimitValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_ConnectionRateLimit.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_ConnectionRateLimitValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_ConnectionRateLimitValidationError{}

// Validate checks the field values on RedisProxy_PrefixRoutes_Route with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_PrefixRoutes_Route) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RedisProxy_PrefixRoutes_Route with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// RedisProxy_PrefixRoutes_RouteMultiError, or nil if none found.
func (m *RedisProxy_PrefixRoutes_Route) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_PrefixRoutes_Route) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetPrefix()) > 1000 {
		err := RedisProxy_PrefixRoutes_RouteValidationError{
			field:  "Prefix",
			reason: "value length must be at most 1000 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for RemovePrefix

	if utf8.RuneCountInString(m.GetCluster()) < 1 {
		err := RedisProxy_PrefixRoutes_RouteValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequestMirrorPolicy() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RedisProxy_PrefixRoutes_RouteValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicy[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RedisProxy_PrefixRoutes_RouteValidationError{
						field:  fmt.Sprintf("RequestMirrorPolicy[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RedisProxy_PrefixRoutes_RouteValidationError{
					field:  fmt.Sprintf("RequestMirrorPolicy[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for KeyFormatter

	if all {
		switch v := interface{}(m.GetReadCommandPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutes_RouteValidationError{
					field:  "ReadCommandPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutes_RouteValidationError{
					field:  "ReadCommandPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetReadCommandPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_PrefixRoutes_RouteValidationError{
				field:  "ReadCommandPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RedisProxy_PrefixRoutes_RouteMultiError(errors)
	}

	return nil
}

// RedisProxy_PrefixRoutes_RouteMultiError is an error wrapping multiple
// validation errors returned by RedisProxy_PrefixRoutes_Route.ValidateAll()
// if the designated constraints aren't met.
type RedisProxy_PrefixRoutes_RouteMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_PrefixRoutes_RouteMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_PrefixRoutes_RouteMultiError) AllErrors() []error { return m }

// RedisProxy_PrefixRoutes_RouteValidationError is the validation error
// returned by RedisProxy_PrefixRoutes_Route.Validate if the designated
// constraints aren't met.
type RedisProxy_PrefixRoutes_RouteValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_PrefixRoutes_RouteValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RedisProxy_PrefixRoutes_RouteValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RedisProxy_PrefixRoutes_RouteValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_PrefixRoutes_RouteValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_PrefixRoutes_RouteValidationError) ErrorName() string {
	return "RedisProxy_PrefixRoutes_RouteValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_PrefixRoutes_RouteValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_PrefixRoutes_Route.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_PrefixRoutes_RouteValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_PrefixRoutes_RouteValidationError{}

// Validate checks the field values on
// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError, or nil if none found.
func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetCluster()) < 1 {
		err := RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRuntimeFraction()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{
					field:  "RuntimeFraction",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRuntimeFraction()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{
				field:  "RuntimeFraction",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ExcludeReadCommands

	if len(errors) > 0 {
		return RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError(errors)
	}

	return nil
}

// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError is an error
// wrapping multiple validation errors returned by
// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.ValidateAll() if the
// designated constraints aren't met.
type RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyMultiError) AllErrors() []error { return m }

// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError is the
// validation error returned by
// RedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.Validate if the
// designated constraints aren't met.
type RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) ErrorName() string {
	return "RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_PrefixRoutes_Route_RequestMirrorPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_PrefixRoutes_Route_RequestMirrorPolicyValidationError{}

// Validate checks the field values on
// RedisProxy_PrefixRoutes_Route_ReadCommandPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// RedisProxy_PrefixRoutes_Route_ReadCommandPolicy with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError, or nil if none found.
func (m *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *RedisProxy_PrefixRoutes_Route_ReadCommandPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetCluster()) < 1 {
		err := RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError(errors)
	}

	return nil
}

// RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError is an error
// wrapping multiple validation errors returned by
// RedisProxy_PrefixRoutes_Route_ReadCommandPolicy.ValidateAll() if the
// designated constraints aren't met.
type RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RedisProxy_PrefixRoutes_Route_ReadCommandPolicyMultiError) AllErrors() []error { return m }

// RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError is the
// validation error returned by
// RedisProxy_PrefixRoutes_Route_ReadCommandPolicy.Validate if the designated
// constraints aren't met.
type RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) ErrorName() string {
	return "RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedisProxy_PrefixRoutes_Route_ReadCommandPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RedisProxy_PrefixRoutes_Route_ReadCommandPolicyValidationError{}
