// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: workloadapi/workload.proto

package workloadapi

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type IPFamilies int32

const (
	// AUTOMATIC is inferred from the configured addresses.
	IPFamilies_AUTOMATIC IPFamilies = 0
	// Only IPv4 is supported
	IPFamilies_IPV4_ONLY IPFamilies = 1
	// Only IPv6 is supported
	IPFamilies_IPV6_ONLY IPFamilies = 2
	// Both IPv4 and IPv6 is supported
	IPFamilies_DUAL IPFamilies = 3
)

// Enum value maps for IPFamilies.
var (
	IPFamilies_name = map[int32]string{
		0: "AUTOMATIC",
		1: "IPV4_ONLY",
		2: "IPV6_ONLY",
		3: "DUAL",
	}
	IPFamilies_value = map[string]int32{
		"AUTOMATIC": 0,
		"IPV4_ONLY": 1,
		"IPV6_ONLY": 2,
		"DUAL":      3,
	}
)

func (x IPFamilies) Enum() *IPFamilies {
	p := new(IPFamilies)
	*p = x
	return p
}

func (x IPFamilies) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IPFamilies) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[0].Descriptor()
}

func (IPFamilies) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[0]
}

func (x IPFamilies) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IPFamilies.Descriptor instead.
func (IPFamilies) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{0}
}

// NetworkMode indicates how the addresses of the workload should be treated.
type NetworkMode int32

const (
	// STANDARD means that the workload is uniquely identified by its address (within its network).
	NetworkMode_STANDARD NetworkMode = 0
	// HOST_NETWORK means the workload has an IP address that is shared by many workloads. The data plane should avoid
	// attempting to lookup these workloads by IP address (which could return the wrong result).
	NetworkMode_HOST_NETWORK NetworkMode = 1
)

// Enum value maps for NetworkMode.
var (
	NetworkMode_name = map[int32]string{
		0: "STANDARD",
		1: "HOST_NETWORK",
	}
	NetworkMode_value = map[string]int32{
		"STANDARD":     0,
		"HOST_NETWORK": 1,
	}
)

func (x NetworkMode) Enum() *NetworkMode {
	p := new(NetworkMode)
	*p = x
	return p
}

func (x NetworkMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkMode) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[1].Descriptor()
}

func (NetworkMode) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[1]
}

func (x NetworkMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkMode.Descriptor instead.
func (NetworkMode) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{1}
}

type WorkloadStatus int32

const (
	// Workload is healthy and ready to serve traffic.
	WorkloadStatus_HEALTHY WorkloadStatus = 0
	// Workload is unhealthy and NOT ready to serve traffic.
	WorkloadStatus_UNHEALTHY WorkloadStatus = 1
)

// Enum value maps for WorkloadStatus.
var (
	WorkloadStatus_name = map[int32]string{
		0: "HEALTHY",
		1: "UNHEALTHY",
	}
	WorkloadStatus_value = map[string]int32{
		"HEALTHY":   0,
		"UNHEALTHY": 1,
	}
)

func (x WorkloadStatus) Enum() *WorkloadStatus {
	p := new(WorkloadStatus)
	*p = x
	return p
}

func (x WorkloadStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[2].Descriptor()
}

func (WorkloadStatus) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[2]
}

func (x WorkloadStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadStatus.Descriptor instead.
func (WorkloadStatus) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{2}
}

type WorkloadType int32

const (
	WorkloadType_DEPLOYMENT WorkloadType = 0
	WorkloadType_CRONJOB    WorkloadType = 1
	WorkloadType_POD        WorkloadType = 2
	WorkloadType_JOB        WorkloadType = 3
)

// Enum value maps for WorkloadType.
var (
	WorkloadType_name = map[int32]string{
		0: "DEPLOYMENT",
		1: "CRONJOB",
		2: "POD",
		3: "JOB",
	}
	WorkloadType_value = map[string]int32{
		"DEPLOYMENT": 0,
		"CRONJOB":    1,
		"POD":        2,
		"JOB":        3,
	}
)

func (x WorkloadType) Enum() *WorkloadType {
	p := new(WorkloadType)
	*p = x
	return p
}

func (x WorkloadType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkloadType) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[3].Descriptor()
}

func (WorkloadType) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[3]
}

func (x WorkloadType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkloadType.Descriptor instead.
func (WorkloadType) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{3}
}

// TunnelProtocol indicates the tunneling protocol for requests.
type TunnelProtocol int32

const (
	// NONE means requests should be forwarded as-is, without tunneling.
	TunnelProtocol_NONE TunnelProtocol = 0
	// HBONE means requests should be tunneled over HTTP.
	// This does not dictate HTTP/1.1 vs HTTP/2; ALPN should be used for that purpose.
	TunnelProtocol_HBONE TunnelProtocol = 1 // Future options may include things like QUIC/HTTP3, etc.
)

// Enum value maps for TunnelProtocol.
var (
	TunnelProtocol_name = map[int32]string{
		0: "NONE",
		1: "HBONE",
	}
	TunnelProtocol_value = map[string]int32{
		"NONE":  0,
		"HBONE": 1,
	}
)

func (x TunnelProtocol) Enum() *TunnelProtocol {
	p := new(TunnelProtocol)
	*p = x
	return p
}

func (x TunnelProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TunnelProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[4].Descriptor()
}

func (TunnelProtocol) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[4]
}

func (x TunnelProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TunnelProtocol.Descriptor instead.
func (TunnelProtocol) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{4}
}

type LoadBalancing_Scope int32

const (
	LoadBalancing_UNSPECIFIED_SCOPE LoadBalancing_Scope = 0
	// Prefer traffic in the same region.
	LoadBalancing_REGION LoadBalancing_Scope = 1
	// Prefer traffic in the same zone.
	LoadBalancing_ZONE LoadBalancing_Scope = 2
	// Prefer traffic in the same subzone.
	LoadBalancing_SUBZONE LoadBalancing_Scope = 3
	// Prefer traffic on the same node.
	LoadBalancing_NODE LoadBalancing_Scope = 4
	// Prefer traffic in the same cluster.
	LoadBalancing_CLUSTER LoadBalancing_Scope = 5
	// Prefer traffic in the same network.
	LoadBalancing_NETWORK LoadBalancing_Scope = 6
)

// Enum value maps for LoadBalancing_Scope.
var (
	LoadBalancing_Scope_name = map[int32]string{
		0: "UNSPECIFIED_SCOPE",
		1: "REGION",
		2: "ZONE",
		3: "SUBZONE",
		4: "NODE",
		5: "CLUSTER",
		6: "NETWORK",
	}
	LoadBalancing_Scope_value = map[string]int32{
		"UNSPECIFIED_SCOPE": 0,
		"REGION":            1,
		"ZONE":              2,
		"SUBZONE":           3,
		"NODE":              4,
		"CLUSTER":           5,
		"NETWORK":           6,
	}
)

func (x LoadBalancing_Scope) Enum() *LoadBalancing_Scope {
	p := new(LoadBalancing_Scope)
	*p = x
	return p
}

func (x LoadBalancing_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancing_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[5].Descriptor()
}

func (LoadBalancing_Scope) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[5]
}

func (x LoadBalancing_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancing_Scope.Descriptor instead.
func (LoadBalancing_Scope) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{2, 0}
}

type LoadBalancing_Mode int32

const (
	LoadBalancing_UNSPECIFIED_MODE LoadBalancing_Mode = 0
	// In STRICT mode, only endpoints that meets all of the routing preferences will be considered.
	// This can be used, for instance, to keep traffic ONLY within the same cluster/node/region.
	// This should be used with caution, as it can result in all traffic being dropped if there is no matching endpoints,
	// even if there are endpoints outside of the preferences.
	LoadBalancing_STRICT LoadBalancing_Mode = 1
	// In FAILOVER mode, endpoint selection will prefer endpoints that match all preferences, but failover to groups of endpoints
	// that match less (or, eventually, none) preferences.
	// For instance, with `[NETWORK, REGION, ZONE]`, we will send to:
	// 1. Endpoints matching `[NETWORK, REGION, ZONE]`
	// 2. Endpoints matching `[NETWORK, REGION]`
	// 3. Endpoints matching `[NETWORK]`
	// 4. Any endpoints
	LoadBalancing_FAILOVER LoadBalancing_Mode = 2
	// In PASSTHROUGH mode, endpoint selection will not be done and traffic passes directly through to the original
	// desitnation address.
	LoadBalancing_PASSTHROUGH LoadBalancing_Mode = 3
)

// Enum value maps for LoadBalancing_Mode.
var (
	LoadBalancing_Mode_name = map[int32]string{
		0: "UNSPECIFIED_MODE",
		1: "STRICT",
		2: "FAILOVER",
		3: "PASSTHROUGH",
	}
	LoadBalancing_Mode_value = map[string]int32{
		"UNSPECIFIED_MODE": 0,
		"STRICT":           1,
		"FAILOVER":         2,
		"PASSTHROUGH":      3,
	}
)

func (x LoadBalancing_Mode) Enum() *LoadBalancing_Mode {
	p := new(LoadBalancing_Mode)
	*p = x
	return p
}

func (x LoadBalancing_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancing_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[6].Descriptor()
}

func (LoadBalancing_Mode) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[6]
}

func (x LoadBalancing_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancing_Mode.Descriptor instead.
func (LoadBalancing_Mode) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{2, 1}
}

type LoadBalancing_HealthPolicy int32

const (
	// Only select healthy endpoints
	LoadBalancing_ONLY_HEALTHY LoadBalancing_HealthPolicy = 0
	// Include all endpoints, even if they are unhealthy.
	LoadBalancing_ALLOW_ALL LoadBalancing_HealthPolicy = 1
)

// Enum value maps for LoadBalancing_HealthPolicy.
var (
	LoadBalancing_HealthPolicy_name = map[int32]string{
		0: "ONLY_HEALTHY",
		1: "ALLOW_ALL",
	}
	LoadBalancing_HealthPolicy_value = map[string]int32{
		"ONLY_HEALTHY": 0,
		"ALLOW_ALL":    1,
	}
)

func (x LoadBalancing_HealthPolicy) Enum() *LoadBalancing_HealthPolicy {
	p := new(LoadBalancing_HealthPolicy)
	*p = x
	return p
}

func (x LoadBalancing_HealthPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancing_HealthPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[7].Descriptor()
}

func (LoadBalancing_HealthPolicy) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[7]
}

func (x LoadBalancing_HealthPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancing_HealthPolicy.Descriptor instead.
func (LoadBalancing_HealthPolicy) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{2, 2}
}

type ApplicationTunnel_Protocol int32

const (
	// Bytes are copied from the inner stream without modification.
	ApplicationTunnel_NONE ApplicationTunnel_Protocol = 0
	// Prepend PROXY protocol headers before copying bytes
	// Standard PROXY source and destination information
	// is included, along with potential extra TLV headers:
	// 0xD0 - The SPIFFE identity of the source workload
	// 0xD1 - The FQDN or Hostname of the targeted Service
	ApplicationTunnel_PROXY ApplicationTunnel_Protocol = 1
)

// Enum value maps for ApplicationTunnel_Protocol.
var (
	ApplicationTunnel_Protocol_name = map[int32]string{
		0: "NONE",
		1: "PROXY",
	}
	ApplicationTunnel_Protocol_value = map[string]int32{
		"NONE":  0,
		"PROXY": 1,
	}
)

func (x ApplicationTunnel_Protocol) Enum() *ApplicationTunnel_Protocol {
	p := new(ApplicationTunnel_Protocol)
	*p = x
	return p
}

func (x ApplicationTunnel_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplicationTunnel_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_workloadapi_workload_proto_enumTypes[8].Descriptor()
}

func (ApplicationTunnel_Protocol) Type() protoreflect.EnumType {
	return &file_workloadapi_workload_proto_enumTypes[8]
}

func (x ApplicationTunnel_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplicationTunnel_Protocol.Descriptor instead.
func (ApplicationTunnel_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{7, 0}
}

// Address represents a unique address.
//
// Address joins two sub-resources, Workload and Service, to support querying by IP address.
// Address is intended to be able to be looked up on-demand, allowing a client
// to answer a question like "what is this IP address", similar to a reverse DNS lookup.
//
// Each resource will have a mesh-wide unique opaque name, defined in the individual messages.
// In addition, to support lookup by IP address, they will have *alias* names for each IP the resource represents.
// There may be multiple aliases for the same resource (examples: service in multiple networks, or a dual-stack workload).
// Aliases are keyed by network/IP address. Example: "default/1.2.3.4".
//
// In some cases, we do not know the IP address of a Workload. For instance, we may simply know
// that there is a workload behind a gateway, and rely on the gateway to handle the rest.
// In this case, the key format will be "resource-uid". The resource can be a Pod, WorkloadEntry, etc.
// These resources cannot be looked up on-demand.
//
// In some cases, we do not know the IP address of a Service. These services cannot be used for matching
// outbound traffic, as we only have L4 attributes to route based on. However,
// they can be used for Gateways.
// In this case, the key format will be "network/hostname".
// These resources cannot be looked up on-demand.
type Address struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*Address_Workload
	//	*Address_Service
	Type          isAddress_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_workloadapi_workload_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{0}
}

func (x *Address) GetType() isAddress_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Address) GetWorkload() *Workload {
	if x != nil {
		if x, ok := x.Type.(*Address_Workload); ok {
			return x.Workload
		}
	}
	return nil
}

func (x *Address) GetService() *Service {
	if x != nil {
		if x, ok := x.Type.(*Address_Service); ok {
			return x.Service
		}
	}
	return nil
}

type isAddress_Type interface {
	isAddress_Type()
}

type Address_Workload struct {
	// Workload represents an individual workload.
	// This could be a single Pod, a VM instance, etc.
	Workload *Workload `protobuf:"bytes,1,opt,name=workload,proto3,oneof"`
}

type Address_Service struct {
	// Service represents a service - a group of workloads that can be accessed together.
	Service *Service `protobuf:"bytes,2,opt,name=service,proto3,oneof"`
}

func (*Address_Workload) isAddress_Type() {}

func (*Address_Service) isAddress_Type() {}

// Service represents a service - a group of workloads that can be accessed together.
// The xds primary key is "namespace/hostname".
// Secondary (alias) keys are the unique `network/IP` pairs that the service can be reached at.
type Service struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name represents the name for the service.
	// For Kubernetes, this is the Service name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace represents the namespace for the service.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Hostname represents the FQDN of the service.
	// For Kubernetes, this would be <name>.<namespace>.svc.<cluster domain>.
	Hostname string `protobuf:"bytes,3,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Address represents the addresses the service can be reached at.
	// There may be multiple addresses for a single service if it resides in multiple networks,
	// multiple clusters, and/or if it's dual stack.
	// For a headless kubernetes service, this list will be empty.
	Addresses []*NetworkAddress `protobuf:"bytes,4,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Ports for the service.
	// The target_port may be overridden on a per-workload basis.
	Ports []*Port `protobuf:"bytes,5,rep,name=ports,proto3" json:"ports,omitempty"`
	// Optional; if set, the SAN to verify for TLS connections.
	// Typically, this is not set and per-workload identity is used to verify
	SubjectAltNames []string `protobuf:"bytes,6,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// Waypoint is the waypoint proxy for this service. When set, all incoming requests must go
	// through the waypoint.
	Waypoint *GatewayAddress `protobuf:"bytes,7,opt,name=waypoint,proto3" json:"waypoint,omitempty"`
	// Load balancing policy for selecting endpoints.
	// Note: this applies only to connecting directly to the workload; when waypoints are used, the waypoint's load_balancing
	// configuration is used.
	LoadBalancing *LoadBalancing `protobuf:"bytes,8,opt,name=load_balancing,json=loadBalancing,proto3" json:"load_balancing,omitempty"`
	// IP families provides configuration about the IP families this service supports.
	IpFamilies IPFamilies `protobuf:"varint,9,opt,name=ip_families,json=ipFamilies,proto3,enum=istio.workload.IPFamilies" json:"ip_families,omitempty"`
	// Extension provides a mechanism to attach arbitrary additional configuration to an object.
	Extensions    []*Extension `protobuf:"bytes,10,rep,name=extensions,proto3" json:"extensions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Service) Reset() {
	*x = Service{}
	mi := &file_workloadapi_workload_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Service) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Service) ProtoMessage() {}

func (x *Service) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Service.ProtoReflect.Descriptor instead.
func (*Service) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{1}
}

func (x *Service) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Service) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Service) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Service) GetAddresses() []*NetworkAddress {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Service) GetPorts() []*Port {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *Service) GetSubjectAltNames() []string {
	if x != nil {
		return x.SubjectAltNames
	}
	return nil
}

func (x *Service) GetWaypoint() *GatewayAddress {
	if x != nil {
		return x.Waypoint
	}
	return nil
}

func (x *Service) GetLoadBalancing() *LoadBalancing {
	if x != nil {
		return x.LoadBalancing
	}
	return nil
}

func (x *Service) GetIpFamilies() IPFamilies {
	if x != nil {
		return x.IpFamilies
	}
	return IPFamilies_AUTOMATIC
}

func (x *Service) GetExtensions() []*Extension {
	if x != nil {
		return x.Extensions
	}
	return nil
}

type LoadBalancing struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// routing_preference defines what scopes we want to keep traffic within.
	// The `mode` determines how these routing preferences are handled
	RoutingPreference []LoadBalancing_Scope `protobuf:"varint,1,rep,packed,name=routing_preference,json=routingPreference,proto3,enum=istio.workload.LoadBalancing_Scope" json:"routing_preference,omitempty"`
	// mode defines how we should handle the routing preferences.
	Mode LoadBalancing_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.workload.LoadBalancing_Mode" json:"mode,omitempty"`
	// health_policy defines how we should filter endpoints
	HealthPolicy  LoadBalancing_HealthPolicy `protobuf:"varint,3,opt,name=health_policy,json=healthPolicy,proto3,enum=istio.workload.LoadBalancing_HealthPolicy" json:"health_policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoadBalancing) Reset() {
	*x = LoadBalancing{}
	mi := &file_workloadapi_workload_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancing) ProtoMessage() {}

func (x *LoadBalancing) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancing.ProtoReflect.Descriptor instead.
func (*LoadBalancing) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{2}
}

func (x *LoadBalancing) GetRoutingPreference() []LoadBalancing_Scope {
	if x != nil {
		return x.RoutingPreference
	}
	return nil
}

func (x *LoadBalancing) GetMode() LoadBalancing_Mode {
	if x != nil {
		return x.Mode
	}
	return LoadBalancing_UNSPECIFIED_MODE
}

func (x *LoadBalancing) GetHealthPolicy() LoadBalancing_HealthPolicy {
	if x != nil {
		return x.HealthPolicy
	}
	return LoadBalancing_ONLY_HEALTHY
}

// Workload represents a workload - an endpoint (or collection behind a hostname).
// The xds primary key is "uid" as defined on the workload below.
// Secondary (alias) keys are the unique `network/IP` pairs that the workload can be reached at.
type Workload struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// UID represents a globally unique opaque identifier for this workload.
	// For k8s resources, it is recommended to use the more readable format:
	//
	// cluster/group/kind/namespace/name/section-name
	//
	// As an example, a ServiceEntry with two WorkloadEntries inlined could become
	// two Workloads with the following UIDs:
	// - cluster1/networking.istio.io/v1alpha3/ServiceEntry/default/external-svc/endpoint1
	// - cluster1/networking.istio.io/v1alpha3/ServiceEntry/default/external-svc/endpoint2
	//
	// For VMs and other workloads other formats are also supported; for example,
	// a single UID string: "0ae5c03d-5fb3-4eb9-9de8-2bd4b51606ba"
	Uid string `protobuf:"bytes,20,opt,name=uid,proto3" json:"uid,omitempty"`
	// Name represents the name for the workload.
	// For Kubernetes, this is the pod name.
	// This is just for debugging and may be elided as an optimization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace represents the namespace for the workload.
	// This is just for debugging and may be elided as an optimization.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Address represents the IPv4/IPv6 address for the workload.
	// This should be globally unique.
	// This should not have a port number.
	// Each workload must have at least either an address or hostname; not both.
	Addresses [][]byte `protobuf:"bytes,3,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// The hostname for the workload to be resolved by the ztunnel.
	// DNS queries are sent on-demand by default.
	// If the resolved DNS query has several endpoints, the request will be forwarded
	// to the first response.
	//
	// At a minimum, each workload must have either an address or hostname. For example,
	// a workload that backs a Kubernetes service will typically have only endpoints. A
	// workload that backs a headless Kubernetes service, however, will have both
	// addresses as well as a hostname used for direct access to the headless endpoint.
	Hostname string `protobuf:"bytes,21,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Network represents the network this workload is on. This may be elided for the default network.
	// A (network,address) pair makeup a unique key for a workload *at a point in time*.
	Network string `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
	// Protocol that should be used to connect to this workload.
	TunnelProtocol TunnelProtocol `protobuf:"varint,5,opt,name=tunnel_protocol,json=tunnelProtocol,proto3,enum=istio.workload.TunnelProtocol" json:"tunnel_protocol,omitempty"`
	// The SPIFFE identity of the workload. The identity is joined to form spiffe://<trust_domain>/ns/<namespace>/sa/<service_account>.
	// TrustDomain of the workload. May be elided if this is the mesh wide default (typically cluster.local)
	TrustDomain string `protobuf:"bytes,6,opt,name=trust_domain,json=trustDomain,proto3" json:"trust_domain,omitempty"`
	// ServiceAccount of the workload. May be elided if this is "default"
	ServiceAccount string `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// If present, the waypoint proxy for this workload.
	// All incoming requests must go through the waypoint.
	Waypoint *GatewayAddress `protobuf:"bytes,8,opt,name=waypoint,proto3" json:"waypoint,omitempty"`
	// If present, East West network gateway this workload can be reached through.
	// Requests from remote networks should traverse this gateway.
	NetworkGateway *GatewayAddress `protobuf:"bytes,19,opt,name=network_gateway,json=networkGateway,proto3" json:"network_gateway,omitempty"`
	// Name of the node the workload runs on
	Node string `protobuf:"bytes,9,opt,name=node,proto3" json:"node,omitempty"`
	// CanonicalName for the workload. Used for telemetry.
	CanonicalName string `protobuf:"bytes,10,opt,name=canonical_name,json=canonicalName,proto3" json:"canonical_name,omitempty"`
	// CanonicalRevision for the workload. Used for telemetry.
	CanonicalRevision string `protobuf:"bytes,11,opt,name=canonical_revision,json=canonicalRevision,proto3" json:"canonical_revision,omitempty"`
	// WorkloadType represents the type of the workload. Used for telemetry.
	WorkloadType WorkloadType `protobuf:"varint,12,opt,name=workload_type,json=workloadType,proto3,enum=istio.workload.WorkloadType" json:"workload_type,omitempty"`
	// WorkloadName represents the name for the workload (of type WorkloadType). Used for telemetry.
	WorkloadName string `protobuf:"bytes,13,opt,name=workload_name,json=workloadName,proto3" json:"workload_name,omitempty"`
	// If set, this indicates a workload expects to directly receive tunnel traffic.
	// In ztunnel, this means:
	// * Requests *from* this workload do not need to be tunneled if they already are tunneled by the tunnel_protocol.
	// * Requests *to* this workload, via the tunnel_protocol, do not need to be de-tunneled.
	NativeTunnel bool `protobuf:"varint,14,opt,name=native_tunnel,json=nativeTunnel,proto3" json:"native_tunnel,omitempty"`
	// If an application, such as a sandwiched waypoint proxy, supports directly
	// receiving information from zTunnel they can set application_protocol.
	ApplicationTunnel *ApplicationTunnel `protobuf:"bytes,23,opt,name=application_tunnel,json=applicationTunnel,proto3" json:"application_tunnel,omitempty"`
	// The services for which this workload is an endpoint.
	// The key is the NamespacedHostname string of the format namespace/hostname.
	Services map[string]*PortList `protobuf:"bytes,22,rep,name=services,proto3" json:"services,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A list of authorization policies applicable to this workload.
	// NOTE: this *only* includes Selector based policies. Namespace and global polices
	// are returned out of band.
	// Authorization policies are only valid for workloads with `addresses` rather than `hostname`.
	AuthorizationPolicies []string       `protobuf:"bytes,16,rep,name=authorization_policies,json=authorizationPolicies,proto3" json:"authorization_policies,omitempty"`
	Status                WorkloadStatus `protobuf:"varint,17,opt,name=status,proto3,enum=istio.workload.WorkloadStatus" json:"status,omitempty"`
	// The cluster ID that the workload instance belongs to
	ClusterId string `protobuf:"bytes,18,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// The Locality defines information about where a workload is geographically deployed
	Locality    *Locality   `protobuf:"bytes,24,opt,name=locality,proto3" json:"locality,omitempty"`
	NetworkMode NetworkMode `protobuf:"varint,25,opt,name=network_mode,json=networkMode,proto3,enum=istio.workload.NetworkMode" json:"network_mode,omitempty"`
	// Extension provides a mechanism to attach arbitrary additional configuration to an object.
	Extensions []*Extension `protobuf:"bytes,26,rep,name=extensions,proto3" json:"extensions,omitempty"`
	// Capacity for this workload.
	// This represents the amount of traffic the workload can handle, relative to other workloads
	// If unset, the capacity is default to 1.
	Capacity      *wrapperspb.UInt32Value `protobuf:"bytes,27,opt,name=capacity,proto3" json:"capacity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Workload) Reset() {
	*x = Workload{}
	mi := &file_workloadapi_workload_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Workload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Workload) ProtoMessage() {}

func (x *Workload) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Workload.ProtoReflect.Descriptor instead.
func (*Workload) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{3}
}

func (x *Workload) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Workload) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Workload) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Workload) GetAddresses() [][]byte {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Workload) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Workload) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Workload) GetTunnelProtocol() TunnelProtocol {
	if x != nil {
		return x.TunnelProtocol
	}
	return TunnelProtocol_NONE
}

func (x *Workload) GetTrustDomain() string {
	if x != nil {
		return x.TrustDomain
	}
	return ""
}

func (x *Workload) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Workload) GetWaypoint() *GatewayAddress {
	if x != nil {
		return x.Waypoint
	}
	return nil
}

func (x *Workload) GetNetworkGateway() *GatewayAddress {
	if x != nil {
		return x.NetworkGateway
	}
	return nil
}

func (x *Workload) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *Workload) GetCanonicalName() string {
	if x != nil {
		return x.CanonicalName
	}
	return ""
}

func (x *Workload) GetCanonicalRevision() string {
	if x != nil {
		return x.CanonicalRevision
	}
	return ""
}

func (x *Workload) GetWorkloadType() WorkloadType {
	if x != nil {
		return x.WorkloadType
	}
	return WorkloadType_DEPLOYMENT
}

func (x *Workload) GetWorkloadName() string {
	if x != nil {
		return x.WorkloadName
	}
	return ""
}

func (x *Workload) GetNativeTunnel() bool {
	if x != nil {
		return x.NativeTunnel
	}
	return false
}

func (x *Workload) GetApplicationTunnel() *ApplicationTunnel {
	if x != nil {
		return x.ApplicationTunnel
	}
	return nil
}

func (x *Workload) GetServices() map[string]*PortList {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *Workload) GetAuthorizationPolicies() []string {
	if x != nil {
		return x.AuthorizationPolicies
	}
	return nil
}

func (x *Workload) GetStatus() WorkloadStatus {
	if x != nil {
		return x.Status
	}
	return WorkloadStatus_HEALTHY
}

func (x *Workload) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *Workload) GetLocality() *Locality {
	if x != nil {
		return x.Locality
	}
	return nil
}

func (x *Workload) GetNetworkMode() NetworkMode {
	if x != nil {
		return x.NetworkMode
	}
	return NetworkMode_STANDARD
}

func (x *Workload) GetExtensions() []*Extension {
	if x != nil {
		return x.Extensions
	}
	return nil
}

func (x *Workload) GetCapacity() *wrapperspb.UInt32Value {
	if x != nil {
		return x.Capacity
	}
	return nil
}

type Locality struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Region        string                 `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	Zone          string                 `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	Subzone       string                 `protobuf:"bytes,3,opt,name=subzone,proto3" json:"subzone,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Locality) Reset() {
	*x = Locality{}
	mi := &file_workloadapi_workload_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Locality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Locality) ProtoMessage() {}

func (x *Locality) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Locality.ProtoReflect.Descriptor instead.
func (*Locality) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{4}
}

func (x *Locality) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *Locality) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Locality) GetSubzone() string {
	if x != nil {
		return x.Subzone
	}
	return ""
}

// PorList represents the ports for a service
type PortList struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Ports         []*Port                `protobuf:"bytes,1,rep,name=ports,proto3" json:"ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PortList) Reset() {
	*x = PortList{}
	mi := &file_workloadapi_workload_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PortList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortList) ProtoMessage() {}

func (x *PortList) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortList.ProtoReflect.Descriptor instead.
func (*PortList) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{5}
}

func (x *PortList) GetPorts() []*Port {
	if x != nil {
		return x.Ports
	}
	return nil
}

type Port struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Port the service is reached at (frontend).
	ServicePort uint32 `protobuf:"varint,1,opt,name=service_port,json=servicePort,proto3" json:"service_port,omitempty"`
	// Port the service forwards to (backend).
	TargetPort    uint32 `protobuf:"varint,2,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Port) Reset() {
	*x = Port{}
	mi := &file_workloadapi_workload_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Port) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Port) ProtoMessage() {}

func (x *Port) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Port.ProtoReflect.Descriptor instead.
func (*Port) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{6}
}

func (x *Port) GetServicePort() uint32 {
	if x != nil {
		return x.ServicePort
	}
	return 0
}

func (x *Port) GetTargetPort() uint32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

// ApplicationProtocol specifies a workload  (application or gateway) can
// consume tunnel information.
type ApplicationTunnel struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A target natively handles this type of traffic.
	Protocol ApplicationTunnel_Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=istio.workload.ApplicationTunnel_Protocol" json:"protocol,omitempty"`
	// optional: if set, traffic should be sent to this port after the last zTunnel hop
	Port          uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplicationTunnel) Reset() {
	*x = ApplicationTunnel{}
	mi := &file_workloadapi_workload_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplicationTunnel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplicationTunnel) ProtoMessage() {}

func (x *ApplicationTunnel) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplicationTunnel.ProtoReflect.Descriptor instead.
func (*ApplicationTunnel) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{7}
}

func (x *ApplicationTunnel) GetProtocol() ApplicationTunnel_Protocol {
	if x != nil {
		return x.Protocol
	}
	return ApplicationTunnel_NONE
}

func (x *ApplicationTunnel) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// GatewayAddress represents the address of a gateway
type GatewayAddress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// address can either be a hostname (ex: gateway.example.com) or an IP (ex: 1.2.3.4).
	//
	// Types that are valid to be assigned to Destination:
	//
	//	*GatewayAddress_Hostname
	//	*GatewayAddress_Address
	Destination isGatewayAddress_Destination `protobuf_oneof:"destination"`
	// port to reach the gateway at for mTLS HBONE connections
	HboneMtlsPort uint32 `protobuf:"varint,3,opt,name=hbone_mtls_port,json=hboneMtlsPort,proto3" json:"hbone_mtls_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GatewayAddress) Reset() {
	*x = GatewayAddress{}
	mi := &file_workloadapi_workload_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayAddress) ProtoMessage() {}

func (x *GatewayAddress) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayAddress.ProtoReflect.Descriptor instead.
func (*GatewayAddress) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{8}
}

func (x *GatewayAddress) GetDestination() isGatewayAddress_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *GatewayAddress) GetHostname() *NamespacedHostname {
	if x != nil {
		if x, ok := x.Destination.(*GatewayAddress_Hostname); ok {
			return x.Hostname
		}
	}
	return nil
}

func (x *GatewayAddress) GetAddress() *NetworkAddress {
	if x != nil {
		if x, ok := x.Destination.(*GatewayAddress_Address); ok {
			return x.Address
		}
	}
	return nil
}

func (x *GatewayAddress) GetHboneMtlsPort() uint32 {
	if x != nil {
		return x.HboneMtlsPort
	}
	return 0
}

type isGatewayAddress_Destination interface {
	isGatewayAddress_Destination()
}

type GatewayAddress_Hostname struct {
	// TODO: add support for hostname lookup
	Hostname *NamespacedHostname `protobuf:"bytes,1,opt,name=hostname,proto3,oneof"`
}

type GatewayAddress_Address struct {
	Address *NetworkAddress `protobuf:"bytes,2,opt,name=address,proto3,oneof"`
}

func (*GatewayAddress_Hostname) isGatewayAddress_Destination() {}

func (*GatewayAddress_Address) isGatewayAddress_Destination() {}

// NetworkAddress represents an address bound to a specific network.
type NetworkAddress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Network represents the network this address is on.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Address presents the IP (v4 or v6).
	Address       []byte `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NetworkAddress) Reset() {
	*x = NetworkAddress{}
	mi := &file_workloadapi_workload_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkAddress) ProtoMessage() {}

func (x *NetworkAddress) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkAddress.ProtoReflect.Descriptor instead.
func (*NetworkAddress) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{9}
}

func (x *NetworkAddress) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkAddress) GetAddress() []byte {
	if x != nil {
		return x.Address
	}
	return nil
}

// NamespacedHostname represents a service bound to a specific namespace.
type NamespacedHostname struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The namespace the service is in.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// hostname (ex: gateway.example.com)
	Hostname      string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NamespacedHostname) Reset() {
	*x = NamespacedHostname{}
	mi := &file_workloadapi_workload_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamespacedHostname) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespacedHostname) ProtoMessage() {}

func (x *NamespacedHostname) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespacedHostname.ProtoReflect.Descriptor instead.
func (*NamespacedHostname) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{10}
}

func (x *NamespacedHostname) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *NamespacedHostname) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

// Extension provides a mechanism to attach arbitrary additional configuration to an object.
type Extension struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name provides an opaque name for the extension.
	// This may have semantic meaning or used for debugging.
	// This should be unique amongst all extensions attached to an item.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// config provides some opaque configuration.
	Config        *anypb.Any `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Extension) Reset() {
	*x = Extension{}
	mi := &file_workloadapi_workload_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Extension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Extension) ProtoMessage() {}

func (x *Extension) ProtoReflect() protoreflect.Message {
	mi := &file_workloadapi_workload_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Extension.ProtoReflect.Descriptor instead.
func (*Extension) Descriptor() ([]byte, []int) {
	return file_workloadapi_workload_proto_rawDescGZIP(), []int{11}
}

func (x *Extension) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Extension) GetConfig() *anypb.Any {
	if x != nil {
		return x.Config
	}
	return nil
}

var File_workloadapi_workload_proto protoreflect.FileDescriptor

const file_workloadapi_workload_proto_rawDesc = "" +
	"\n" +
	"\x1aworkloadapi/workload.proto\x12\x0eistio.workload\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x19google/protobuf/any.proto\"~\n" +
	"\aAddress\x126\n" +
	"\bworkload\x18\x01 \x01(\v2\x18.istio.workload.WorkloadH\x00R\bworkload\x123\n" +
	"\aservice\x18\x02 \x01(\v2\x17.istio.workload.ServiceH\x00R\aserviceB\x06\n" +
	"\x04type\"\xe7\x03\n" +
	"\aService\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\x12\x1a\n" +
	"\bhostname\x18\x03 \x01(\tR\bhostname\x12<\n" +
	"\taddresses\x18\x04 \x03(\v2\x1e.istio.workload.NetworkAddressR\taddresses\x12*\n" +
	"\x05ports\x18\x05 \x03(\v2\x14.istio.workload.PortR\x05ports\x12*\n" +
	"\x11subject_alt_names\x18\x06 \x03(\tR\x0fsubjectAltNames\x12:\n" +
	"\bwaypoint\x18\a \x01(\v2\x1e.istio.workload.GatewayAddressR\bwaypoint\x12D\n" +
	"\x0eload_balancing\x18\b \x01(\v2\x1d.istio.workload.LoadBalancingR\rloadBalancing\x12;\n" +
	"\vip_families\x18\t \x01(\x0e2\x1a.istio.workload.IPFamiliesR\n" +
	"ipFamilies\x129\n" +
	"\n" +
	"extensions\x18\n" +
	" \x03(\v2\x19.istio.workload.ExtensionR\n" +
	"extensions\"\xcd\x03\n" +
	"\rLoadBalancing\x12R\n" +
	"\x12routing_preference\x18\x01 \x03(\x0e2#.istio.workload.LoadBalancing.ScopeR\x11routingPreference\x126\n" +
	"\x04mode\x18\x02 \x01(\x0e2\".istio.workload.LoadBalancing.ModeR\x04mode\x12O\n" +
	"\rhealth_policy\x18\x03 \x01(\x0e2*.istio.workload.LoadBalancing.HealthPolicyR\fhealthPolicy\"e\n" +
	"\x05Scope\x12\x15\n" +
	"\x11UNSPECIFIED_SCOPE\x10\x00\x12\n" +
	"\n" +
	"\x06REGION\x10\x01\x12\b\n" +
	"\x04ZONE\x10\x02\x12\v\n" +
	"\aSUBZONE\x10\x03\x12\b\n" +
	"\x04NODE\x10\x04\x12\v\n" +
	"\aCLUSTER\x10\x05\x12\v\n" +
	"\aNETWORK\x10\x06\"G\n" +
	"\x04Mode\x12\x14\n" +
	"\x10UNSPECIFIED_MODE\x10\x00\x12\n" +
	"\n" +
	"\x06STRICT\x10\x01\x12\f\n" +
	"\bFAILOVER\x10\x02\x12\x0f\n" +
	"\vPASSTHROUGH\x10\x03\"/\n" +
	"\fHealthPolicy\x12\x10\n" +
	"\fONLY_HEALTHY\x10\x00\x12\r\n" +
	"\tALLOW_ALL\x10\x01\"\x9f\n" +
	"\n" +
	"\bWorkload\x12\x10\n" +
	"\x03uid\x18\x14 \x01(\tR\x03uid\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\x12\x1c\n" +
	"\taddresses\x18\x03 \x03(\fR\taddresses\x12\x1a\n" +
	"\bhostname\x18\x15 \x01(\tR\bhostname\x12\x18\n" +
	"\anetwork\x18\x04 \x01(\tR\anetwork\x12G\n" +
	"\x0ftunnel_protocol\x18\x05 \x01(\x0e2\x1e.istio.workload.TunnelProtocolR\x0etunnelProtocol\x12!\n" +
	"\ftrust_domain\x18\x06 \x01(\tR\vtrustDomain\x12'\n" +
	"\x0fservice_account\x18\a \x01(\tR\x0eserviceAccount\x12:\n" +
	"\bwaypoint\x18\b \x01(\v2\x1e.istio.workload.GatewayAddressR\bwaypoint\x12G\n" +
	"\x0fnetwork_gateway\x18\x13 \x01(\v2\x1e.istio.workload.GatewayAddressR\x0enetworkGateway\x12\x12\n" +
	"\x04node\x18\t \x01(\tR\x04node\x12%\n" +
	"\x0ecanonical_name\x18\n" +
	" \x01(\tR\rcanonicalName\x12-\n" +
	"\x12canonical_revision\x18\v \x01(\tR\x11canonicalRevision\x12A\n" +
	"\rworkload_type\x18\f \x01(\x0e2\x1c.istio.workload.WorkloadTypeR\fworkloadType\x12#\n" +
	"\rworkload_name\x18\r \x01(\tR\fworkloadName\x12#\n" +
	"\rnative_tunnel\x18\x0e \x01(\bR\fnativeTunnel\x12P\n" +
	"\x12application_tunnel\x18\x17 \x01(\v2!.istio.workload.ApplicationTunnelR\x11applicationTunnel\x12B\n" +
	"\bservices\x18\x16 \x03(\v2&.istio.workload.Workload.ServicesEntryR\bservices\x125\n" +
	"\x16authorization_policies\x18\x10 \x03(\tR\x15authorizationPolicies\x126\n" +
	"\x06status\x18\x11 \x01(\x0e2\x1e.istio.workload.WorkloadStatusR\x06status\x12\x1d\n" +
	"\n" +
	"cluster_id\x18\x12 \x01(\tR\tclusterId\x124\n" +
	"\blocality\x18\x18 \x01(\v2\x18.istio.workload.LocalityR\blocality\x12>\n" +
	"\fnetwork_mode\x18\x19 \x01(\x0e2\x1b.istio.workload.NetworkModeR\vnetworkMode\x129\n" +
	"\n" +
	"extensions\x18\x1a \x03(\v2\x19.istio.workload.ExtensionR\n" +
	"extensions\x128\n" +
	"\bcapacity\x18\x1b \x01(\v2\x1c.google.protobuf.UInt32ValueR\bcapacity\x1aU\n" +
	"\rServicesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12.\n" +
	"\x05value\x18\x02 \x01(\v2\x18.istio.workload.PortListR\x05value:\x028\x01J\x04\b\x0f\x10\x10\"P\n" +
	"\bLocality\x12\x16\n" +
	"\x06region\x18\x01 \x01(\tR\x06region\x12\x12\n" +
	"\x04zone\x18\x02 \x01(\tR\x04zone\x12\x18\n" +
	"\asubzone\x18\x03 \x01(\tR\asubzone\"6\n" +
	"\bPortList\x12*\n" +
	"\x05ports\x18\x01 \x03(\v2\x14.istio.workload.PortR\x05ports\"J\n" +
	"\x04Port\x12!\n" +
	"\fservice_port\x18\x01 \x01(\rR\vservicePort\x12\x1f\n" +
	"\vtarget_port\x18\x02 \x01(\rR\n" +
	"targetPort\"\x90\x01\n" +
	"\x11ApplicationTunnel\x12F\n" +
	"\bprotocol\x18\x01 \x01(\x0e2*.istio.workload.ApplicationTunnel.ProtocolR\bprotocol\x12\x12\n" +
	"\x04port\x18\x02 \x01(\rR\x04port\"\x1f\n" +
	"\bProtocol\x12\b\n" +
	"\x04NONE\x10\x00\x12\t\n" +
	"\x05PROXY\x10\x01\"\xe2\x01\n" +
	"\x0eGatewayAddress\x12@\n" +
	"\bhostname\x18\x01 \x01(\v2\".istio.workload.NamespacedHostnameH\x00R\bhostname\x12:\n" +
	"\aaddress\x18\x02 \x01(\v2\x1e.istio.workload.NetworkAddressH\x00R\aaddress\x12&\n" +
	"\x0fhbone_mtls_port\x18\x03 \x01(\rR\rhboneMtlsPortB\r\n" +
	"\vdestinationJ\x04\b\x04\x10\x05R\x15hbone_single_tls_port\"D\n" +
	"\x0eNetworkAddress\x12\x18\n" +
	"\anetwork\x18\x01 \x01(\tR\anetwork\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\fR\aaddress\"N\n" +
	"\x12NamespacedHostname\x12\x1c\n" +
	"\tnamespace\x18\x01 \x01(\tR\tnamespace\x12\x1a\n" +
	"\bhostname\x18\x02 \x01(\tR\bhostname\"M\n" +
	"\tExtension\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12,\n" +
	"\x06config\x18\x02 \x01(\v2\x14.google.protobuf.AnyR\x06config*C\n" +
	"\n" +
	"IPFamilies\x12\r\n" +
	"\tAUTOMATIC\x10\x00\x12\r\n" +
	"\tIPV4_ONLY\x10\x01\x12\r\n" +
	"\tIPV6_ONLY\x10\x02\x12\b\n" +
	"\x04DUAL\x10\x03*-\n" +
	"\vNetworkMode\x12\f\n" +
	"\bSTANDARD\x10\x00\x12\x10\n" +
	"\fHOST_NETWORK\x10\x01*,\n" +
	"\x0eWorkloadStatus\x12\v\n" +
	"\aHEALTHY\x10\x00\x12\r\n" +
	"\tUNHEALTHY\x10\x01*=\n" +
	"\fWorkloadType\x12\x0e\n" +
	"\n" +
	"DEPLOYMENT\x10\x00\x12\v\n" +
	"\aCRONJOB\x10\x01\x12\a\n" +
	"\x03POD\x10\x02\x12\a\n" +
	"\x03JOB\x10\x03*%\n" +
	"\x0eTunnelProtocol\x12\b\n" +
	"\x04NONE\x10\x00\x12\t\n" +
	"\x05HBONE\x10\x01B\x11Z\x0fpkg/workloadapib\x06proto3"

var (
	file_workloadapi_workload_proto_rawDescOnce sync.Once
	file_workloadapi_workload_proto_rawDescData []byte
)

func file_workloadapi_workload_proto_rawDescGZIP() []byte {
	file_workloadapi_workload_proto_rawDescOnce.Do(func() {
		file_workloadapi_workload_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_workloadapi_workload_proto_rawDesc), len(file_workloadapi_workload_proto_rawDesc)))
	})
	return file_workloadapi_workload_proto_rawDescData
}

var file_workloadapi_workload_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_workloadapi_workload_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_workloadapi_workload_proto_goTypes = []any{
	(IPFamilies)(0),                 // 0: istio.workload.IPFamilies
	(NetworkMode)(0),                // 1: istio.workload.NetworkMode
	(WorkloadStatus)(0),             // 2: istio.workload.WorkloadStatus
	(WorkloadType)(0),               // 3: istio.workload.WorkloadType
	(TunnelProtocol)(0),             // 4: istio.workload.TunnelProtocol
	(LoadBalancing_Scope)(0),        // 5: istio.workload.LoadBalancing.Scope
	(LoadBalancing_Mode)(0),         // 6: istio.workload.LoadBalancing.Mode
	(LoadBalancing_HealthPolicy)(0), // 7: istio.workload.LoadBalancing.HealthPolicy
	(ApplicationTunnel_Protocol)(0), // 8: istio.workload.ApplicationTunnel.Protocol
	(*Address)(nil),                 // 9: istio.workload.Address
	(*Service)(nil),                 // 10: istio.workload.Service
	(*LoadBalancing)(nil),           // 11: istio.workload.LoadBalancing
	(*Workload)(nil),                // 12: istio.workload.Workload
	(*Locality)(nil),                // 13: istio.workload.Locality
	(*PortList)(nil),                // 14: istio.workload.PortList
	(*Port)(nil),                    // 15: istio.workload.Port
	(*ApplicationTunnel)(nil),       // 16: istio.workload.ApplicationTunnel
	(*GatewayAddress)(nil),          // 17: istio.workload.GatewayAddress
	(*NetworkAddress)(nil),          // 18: istio.workload.NetworkAddress
	(*NamespacedHostname)(nil),      // 19: istio.workload.NamespacedHostname
	(*Extension)(nil),               // 20: istio.workload.Extension
	nil,                             // 21: istio.workload.Workload.ServicesEntry
	(*wrapperspb.UInt32Value)(nil),  // 22: google.protobuf.UInt32Value
	(*anypb.Any)(nil),               // 23: google.protobuf.Any
}
var file_workloadapi_workload_proto_depIdxs = []int32{
	12, // 0: istio.workload.Address.workload:type_name -> istio.workload.Workload
	10, // 1: istio.workload.Address.service:type_name -> istio.workload.Service
	18, // 2: istio.workload.Service.addresses:type_name -> istio.workload.NetworkAddress
	15, // 3: istio.workload.Service.ports:type_name -> istio.workload.Port
	17, // 4: istio.workload.Service.waypoint:type_name -> istio.workload.GatewayAddress
	11, // 5: istio.workload.Service.load_balancing:type_name -> istio.workload.LoadBalancing
	0,  // 6: istio.workload.Service.ip_families:type_name -> istio.workload.IPFamilies
	20, // 7: istio.workload.Service.extensions:type_name -> istio.workload.Extension
	5,  // 8: istio.workload.LoadBalancing.routing_preference:type_name -> istio.workload.LoadBalancing.Scope
	6,  // 9: istio.workload.LoadBalancing.mode:type_name -> istio.workload.LoadBalancing.Mode
	7,  // 10: istio.workload.LoadBalancing.health_policy:type_name -> istio.workload.LoadBalancing.HealthPolicy
	4,  // 11: istio.workload.Workload.tunnel_protocol:type_name -> istio.workload.TunnelProtocol
	17, // 12: istio.workload.Workload.waypoint:type_name -> istio.workload.GatewayAddress
	17, // 13: istio.workload.Workload.network_gateway:type_name -> istio.workload.GatewayAddress
	3,  // 14: istio.workload.Workload.workload_type:type_name -> istio.workload.WorkloadType
	16, // 15: istio.workload.Workload.application_tunnel:type_name -> istio.workload.ApplicationTunnel
	21, // 16: istio.workload.Workload.services:type_name -> istio.workload.Workload.ServicesEntry
	2,  // 17: istio.workload.Workload.status:type_name -> istio.workload.WorkloadStatus
	13, // 18: istio.workload.Workload.locality:type_name -> istio.workload.Locality
	1,  // 19: istio.workload.Workload.network_mode:type_name -> istio.workload.NetworkMode
	20, // 20: istio.workload.Workload.extensions:type_name -> istio.workload.Extension
	22, // 21: istio.workload.Workload.capacity:type_name -> google.protobuf.UInt32Value
	15, // 22: istio.workload.PortList.ports:type_name -> istio.workload.Port
	8,  // 23: istio.workload.ApplicationTunnel.protocol:type_name -> istio.workload.ApplicationTunnel.Protocol
	19, // 24: istio.workload.GatewayAddress.hostname:type_name -> istio.workload.NamespacedHostname
	18, // 25: istio.workload.GatewayAddress.address:type_name -> istio.workload.NetworkAddress
	23, // 26: istio.workload.Extension.config:type_name -> google.protobuf.Any
	14, // 27: istio.workload.Workload.ServicesEntry.value:type_name -> istio.workload.PortList
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_workloadapi_workload_proto_init() }
func file_workloadapi_workload_proto_init() {
	if File_workloadapi_workload_proto != nil {
		return
	}
	file_workloadapi_workload_proto_msgTypes[0].OneofWrappers = []any{
		(*Address_Workload)(nil),
		(*Address_Service)(nil),
	}
	file_workloadapi_workload_proto_msgTypes[8].OneofWrappers = []any{
		(*GatewayAddress_Hostname)(nil),
		(*GatewayAddress_Address)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_workloadapi_workload_proto_rawDesc), len(file_workloadapi_workload_proto_rawDesc)),
			NumEnums:      9,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_workloadapi_workload_proto_goTypes,
		DependencyIndexes: file_workloadapi_workload_proto_depIdxs,
		EnumInfos:         file_workloadapi_workload_proto_enumTypes,
		MessageInfos:      file_workloadapi_workload_proto_msgTypes,
	}.Build()
	File_workloadapi_workload_proto = out.File
	file_workloadapi_workload_proto_goTypes = nil
	file_workloadapi_workload_proto_depIdxs = nil
}
