{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Allows to select a numeric value with a slider control.
-- 
-- \<picture>
--   \<source srcset=\"scales-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkScale\" src=\"scales.png\">
-- \<\/picture>
-- 
-- To use it, you’ll probably want to investigate the methods on its base
-- class, t'GI.Gtk.Objects.Range.Range', in addition to the methods for @GtkScale@ itself.
-- To set the value of a scale, you would normally use 'GI.Gtk.Objects.Range.rangeSetValue'.
-- To detect changes to the value, you would normally use the
-- [Range::valueChanged]("GI.Gtk.Objects.Range#g:signal:valueChanged") signal.
-- 
-- Note that using the same upper and lower bounds for the @GtkScale@ (through
-- the @GtkRange@ methods) will hide the slider itself. This is useful for
-- applications that want to show an undeterminate value on the scale, without
-- changing the layout of the application (such as movie or music players).
-- 
-- = GtkScale as GtkBuildable
-- 
-- @GtkScale@ supports a custom @\<marks>@ element, which can contain multiple
-- @\<mark\\>@ elements. The “value” and “position” attributes have the same
-- meaning as 'GI.Gtk.Objects.Scale.scaleAddMark' parameters of the same name. If
-- the element is not empty, its content is taken as the markup to show at
-- the mark. It can be translated with the usual ”translatable” and
-- “context” attributes.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkPopoverMenu@ supports the following keyboard shortcuts:
-- 
-- * Arrow keys, \<kbd>+\<\/kbd> and \<kbd>-\<\/kbd> will increment or decrement
--   by step, or by page when combined with \<kbd>Ctrl\<\/kbd>.
-- * \<kbd>PgUp\<\/kbd> and \<kbd>PgDn\<\/kbd> will increment or decrement by page.
-- * \<kbd>Home\<\/kbd> and \<kbd>End\<\/kbd> will set the minimum or maximum value.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >scale[.fine-tune][.marks-before][.marks-after]
-- >├── [value][.top][.right][.bottom][.left]
-- >├── marks.top
-- >│   ├── mark
-- >│   ┊    ├── [label]
-- >│   ┊    ╰── indicator
-- >┊   ┊
-- >│   ╰── mark
-- >├── marks.bottom
-- >│   ├── mark
-- >│   ┊    ├── indicator
-- >│   ┊    ╰── [label]
-- >┊   ┊
-- >│   ╰── mark
-- >╰── trough
-- >    ├── [fill]
-- >    ├── [highlight]
-- >    ╰── slider
-- 
-- 
-- @GtkScale@ has a main CSS node with name scale and a subnode for its contents,
-- with subnodes named trough and slider.
-- 
-- The main node gets the style class .fine-tune added when the scale is in
-- \'fine-tuning\' mode.
-- 
-- If the scale has an origin (see 'GI.Gtk.Objects.Scale.scaleSetHasOrigin'), there is
-- a subnode with name highlight below the trough node that is used for rendering
-- the highlighted part of the trough.
-- 
-- If the scale is showing a fill level (see 'GI.Gtk.Objects.Range.rangeSetShowFillLevel'),
-- there is a subnode with name fill below the trough node that is used for
-- rendering the filled in part of the trough.
-- 
-- If marks are present, there is a marks subnode before or after the trough
-- node, below which each mark gets a node with name mark. The marks nodes get
-- either the .top or .bottom style class.
-- 
-- The mark node has a subnode named indicator. If the mark has text, it also
-- has a subnode named label. When the mark is either above or left of the
-- scale, the label subnode is the first when present. Otherwise, the indicator
-- subnode is the first.
-- 
-- The main CSS node gets the \'marks-before\' and\/or \'marks-after\' style classes
-- added depending on what marks are present.
-- 
-- If the scale is displaying the value (see [Scale:drawValue]("GI.Gtk.Objects.Scale#g:attr:drawValue")),
-- there is subnode with name value. This node will get the .top or .bottom style
-- classes similar to the marks node.
-- 
-- = Accessibility
-- 
-- @GtkScale@ uses the 'GI.Gtk.Enums.AccessibleRoleSlider' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Scale
    ( 

-- * Exported types
    Scale(..)                               ,
    IsScale                                 ,
    toScale                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMark]("GI.Gtk.Objects.Scale#g:method:addMark"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clearMarks]("GI.Gtk.Objects.Scale#g:method:clearMarks"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAdjustment]("GI.Gtk.Objects.Range#g:method:getAdjustment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDigits]("GI.Gtk.Objects.Scale#g:method:getDigits"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getDrawValue]("GI.Gtk.Objects.Scale#g:method:getDrawValue"), [getFillLevel]("GI.Gtk.Objects.Range#g:method:getFillLevel"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFlippable]("GI.Gtk.Objects.Range#g:method:getFlippable"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasOrigin]("GI.Gtk.Objects.Scale#g:method:getHasOrigin"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInverted]("GI.Gtk.Objects.Range#g:method:getInverted"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayout]("GI.Gtk.Objects.Scale#g:method:getLayout"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLayoutOffsets]("GI.Gtk.Objects.Scale#g:method:getLayoutOffsets"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRangeRect]("GI.Gtk.Objects.Range#g:method:getRangeRect"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRestrictToFillLevel]("GI.Gtk.Objects.Range#g:method:getRestrictToFillLevel"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRoundDigits]("GI.Gtk.Objects.Range#g:method:getRoundDigits"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowFillLevel]("GI.Gtk.Objects.Range#g:method:getShowFillLevel"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSliderRange]("GI.Gtk.Objects.Range#g:method:getSliderRange"), [getSliderSizeFixed]("GI.Gtk.Objects.Range#g:method:getSliderSizeFixed"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getValue]("GI.Gtk.Objects.Range#g:method:getValue"), [getValuePos]("GI.Gtk.Objects.Scale#g:method:getValuePos"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAdjustment]("GI.Gtk.Objects.Range#g:method:setAdjustment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDigits]("GI.Gtk.Objects.Scale#g:method:setDigits"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDrawValue]("GI.Gtk.Objects.Scale#g:method:setDrawValue"), [setFillLevel]("GI.Gtk.Objects.Range#g:method:setFillLevel"), [setFlippable]("GI.Gtk.Objects.Range#g:method:setFlippable"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setFormatValueFunc]("GI.Gtk.Objects.Scale#g:method:setFormatValueFunc"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasOrigin]("GI.Gtk.Objects.Scale#g:method:setHasOrigin"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIncrements]("GI.Gtk.Objects.Range#g:method:setIncrements"), [setInverted]("GI.Gtk.Objects.Range#g:method:setInverted"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRange]("GI.Gtk.Objects.Range#g:method:setRange"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRestrictToFillLevel]("GI.Gtk.Objects.Range#g:method:setRestrictToFillLevel"), [setRoundDigits]("GI.Gtk.Objects.Range#g:method:setRoundDigits"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowFillLevel]("GI.Gtk.Objects.Range#g:method:setShowFillLevel"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSliderSizeFixed]("GI.Gtk.Objects.Range#g:method:setSliderSizeFixed"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setValue]("GI.Gtk.Objects.Range#g:method:setValue"), [setValuePos]("GI.Gtk.Objects.Scale#g:method:setValuePos"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveScaleMethod                      ,
#endif

-- ** addMark #method:addMark#

#if defined(ENABLE_OVERLOADING)
    ScaleAddMarkMethodInfo                  ,
#endif
    scaleAddMark                            ,


-- ** clearMarks #method:clearMarks#

#if defined(ENABLE_OVERLOADING)
    ScaleClearMarksMethodInfo               ,
#endif
    scaleClearMarks                         ,


-- ** getDigits #method:getDigits#

#if defined(ENABLE_OVERLOADING)
    ScaleGetDigitsMethodInfo                ,
#endif
    scaleGetDigits                          ,


-- ** getDrawValue #method:getDrawValue#

#if defined(ENABLE_OVERLOADING)
    ScaleGetDrawValueMethodInfo             ,
#endif
    scaleGetDrawValue                       ,


-- ** getHasOrigin #method:getHasOrigin#

#if defined(ENABLE_OVERLOADING)
    ScaleGetHasOriginMethodInfo             ,
#endif
    scaleGetHasOrigin                       ,


-- ** getLayout #method:getLayout#

#if defined(ENABLE_OVERLOADING)
    ScaleGetLayoutMethodInfo                ,
#endif
    scaleGetLayout                          ,


-- ** getLayoutOffsets #method:getLayoutOffsets#

#if defined(ENABLE_OVERLOADING)
    ScaleGetLayoutOffsetsMethodInfo         ,
#endif
    scaleGetLayoutOffsets                   ,


-- ** getValuePos #method:getValuePos#

#if defined(ENABLE_OVERLOADING)
    ScaleGetValuePosMethodInfo              ,
#endif
    scaleGetValuePos                        ,


-- ** new #method:new#

    scaleNew                                ,


-- ** newWithRange #method:newWithRange#

    scaleNewWithRange                       ,


-- ** setDigits #method:setDigits#

#if defined(ENABLE_OVERLOADING)
    ScaleSetDigitsMethodInfo                ,
#endif
    scaleSetDigits                          ,


-- ** setDrawValue #method:setDrawValue#

#if defined(ENABLE_OVERLOADING)
    ScaleSetDrawValueMethodInfo             ,
#endif
    scaleSetDrawValue                       ,


-- ** setFormatValueFunc #method:setFormatValueFunc#

#if defined(ENABLE_OVERLOADING)
    ScaleSetFormatValueFuncMethodInfo       ,
#endif
    scaleSetFormatValueFunc                 ,


-- ** setHasOrigin #method:setHasOrigin#

#if defined(ENABLE_OVERLOADING)
    ScaleSetHasOriginMethodInfo             ,
#endif
    scaleSetHasOrigin                       ,


-- ** setValuePos #method:setValuePos#

#if defined(ENABLE_OVERLOADING)
    ScaleSetValuePosMethodInfo              ,
#endif
    scaleSetValuePos                        ,




 -- * Properties


-- ** digits #attr:digits#
-- | The number of decimal places that are displayed in the value.

#if defined(ENABLE_OVERLOADING)
    ScaleDigitsPropertyInfo                 ,
#endif
    constructScaleDigits                    ,
    getScaleDigits                          ,
#if defined(ENABLE_OVERLOADING)
    scaleDigits                             ,
#endif
    setScaleDigits                          ,


-- ** drawValue #attr:drawValue#
-- | Whether the current value is displayed as a string next to the slider.

#if defined(ENABLE_OVERLOADING)
    ScaleDrawValuePropertyInfo              ,
#endif
    constructScaleDrawValue                 ,
    getScaleDrawValue                       ,
#if defined(ENABLE_OVERLOADING)
    scaleDrawValue                          ,
#endif
    setScaleDrawValue                       ,


-- ** hasOrigin #attr:hasOrigin#
-- | Whether the scale has an origin.

#if defined(ENABLE_OVERLOADING)
    ScaleHasOriginPropertyInfo              ,
#endif
    constructScaleHasOrigin                 ,
    getScaleHasOrigin                       ,
#if defined(ENABLE_OVERLOADING)
    scaleHasOrigin                          ,
#endif
    setScaleHasOrigin                       ,


-- ** valuePos #attr:valuePos#
-- | The position in which the current value is displayed.

#if defined(ENABLE_OVERLOADING)
    ScaleValuePosPropertyInfo               ,
#endif
    constructScaleValuePos                  ,
    getScaleValuePos                        ,
#if defined(ENABLE_OVERLOADING)
    scaleValuePos                           ,
#endif
    setScaleValuePos                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Range as Gtk.Range
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Range as Gtk.Range
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import qualified GI.Pango.Objects.Layout as Pango.Layout

#endif

-- | Memory-managed wrapper type.
newtype Scale = Scale (SP.ManagedPtr Scale)
    deriving (Eq)

instance SP.ManagedPtrNewtype Scale where
    toManagedPtr (Scale p) = p

foreign import ccall "gtk_scale_get_type"
    c_gtk_scale_get_type :: IO B.Types.GType

instance B.Types.TypedObject Scale where
    glibType = c_gtk_scale_get_type

instance B.Types.GObject Scale

-- | Type class for types which can be safely cast to t'Scale', for instance with `toScale`.
class (SP.GObject o, O.IsDescendantOf Scale o) => IsScale o
instance (SP.GObject o, O.IsDescendantOf Scale o) => IsScale o

instance O.HasParentTypes Scale
type instance O.ParentTypes Scale = '[Gtk.Range.Range, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to t'Scale', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toScale :: (MIO.MonadIO m, IsScale o) => o -> m Scale
toScale = MIO.liftIO . B.ManagedPtr.unsafeCastTo Scale

-- | Convert t'Scale' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Scale) where
    gvalueGType_ = c_gtk_scale_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Scale)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Scale)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Scale ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveScaleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScaleMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveScaleMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveScaleMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveScaleMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveScaleMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveScaleMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveScaleMethod "addMark" o = ScaleAddMarkMethodInfo
    ResolveScaleMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveScaleMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveScaleMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveScaleMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveScaleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveScaleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveScaleMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveScaleMethod "clearMarks" o = ScaleClearMarksMethodInfo
    ResolveScaleMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveScaleMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveScaleMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveScaleMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveScaleMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveScaleMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveScaleMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveScaleMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveScaleMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveScaleMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveScaleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveScaleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveScaleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveScaleMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveScaleMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveScaleMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveScaleMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveScaleMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveScaleMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveScaleMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveScaleMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveScaleMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveScaleMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveScaleMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveScaleMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveScaleMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveScaleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveScaleMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveScaleMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveScaleMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveScaleMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveScaleMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveScaleMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveScaleMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveScaleMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveScaleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveScaleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveScaleMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveScaleMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveScaleMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveScaleMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveScaleMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveScaleMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveScaleMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveScaleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveScaleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveScaleMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveScaleMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveScaleMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveScaleMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveScaleMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveScaleMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveScaleMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveScaleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveScaleMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveScaleMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveScaleMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveScaleMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveScaleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveScaleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveScaleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveScaleMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveScaleMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveScaleMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveScaleMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveScaleMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveScaleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveScaleMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveScaleMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveScaleMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveScaleMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveScaleMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveScaleMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveScaleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveScaleMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveScaleMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveScaleMethod "getAdjustment" o = Gtk.Range.RangeGetAdjustmentMethodInfo
    ResolveScaleMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveScaleMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveScaleMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveScaleMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveScaleMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveScaleMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveScaleMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveScaleMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveScaleMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveScaleMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveScaleMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveScaleMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveScaleMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveScaleMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveScaleMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveScaleMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveScaleMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveScaleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveScaleMethod "getDigits" o = ScaleGetDigitsMethodInfo
    ResolveScaleMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveScaleMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveScaleMethod "getDrawValue" o = ScaleGetDrawValueMethodInfo
    ResolveScaleMethod "getFillLevel" o = Gtk.Range.RangeGetFillLevelMethodInfo
    ResolveScaleMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveScaleMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveScaleMethod "getFlippable" o = Gtk.Range.RangeGetFlippableMethodInfo
    ResolveScaleMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveScaleMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveScaleMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveScaleMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveScaleMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveScaleMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveScaleMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveScaleMethod "getHasOrigin" o = ScaleGetHasOriginMethodInfo
    ResolveScaleMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveScaleMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveScaleMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveScaleMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveScaleMethod "getInverted" o = Gtk.Range.RangeGetInvertedMethodInfo
    ResolveScaleMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveScaleMethod "getLayout" o = ScaleGetLayoutMethodInfo
    ResolveScaleMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveScaleMethod "getLayoutOffsets" o = ScaleGetLayoutOffsetsMethodInfo
    ResolveScaleMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveScaleMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveScaleMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveScaleMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveScaleMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveScaleMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveScaleMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveScaleMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveScaleMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveScaleMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveScaleMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveScaleMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveScaleMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveScaleMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveScaleMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveScaleMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveScaleMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveScaleMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveScaleMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveScaleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveScaleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveScaleMethod "getRangeRect" o = Gtk.Range.RangeGetRangeRectMethodInfo
    ResolveScaleMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveScaleMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveScaleMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveScaleMethod "getRestrictToFillLevel" o = Gtk.Range.RangeGetRestrictToFillLevelMethodInfo
    ResolveScaleMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveScaleMethod "getRoundDigits" o = Gtk.Range.RangeGetRoundDigitsMethodInfo
    ResolveScaleMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveScaleMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveScaleMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveScaleMethod "getShowFillLevel" o = Gtk.Range.RangeGetShowFillLevelMethodInfo
    ResolveScaleMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveScaleMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveScaleMethod "getSliderRange" o = Gtk.Range.RangeGetSliderRangeMethodInfo
    ResolveScaleMethod "getSliderSizeFixed" o = Gtk.Range.RangeGetSliderSizeFixedMethodInfo
    ResolveScaleMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveScaleMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveScaleMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveScaleMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveScaleMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveScaleMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveScaleMethod "getValue" o = Gtk.Range.RangeGetValueMethodInfo
    ResolveScaleMethod "getValuePos" o = ScaleGetValuePosMethodInfo
    ResolveScaleMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveScaleMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveScaleMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveScaleMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveScaleMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveScaleMethod "setAdjustment" o = Gtk.Range.RangeSetAdjustmentMethodInfo
    ResolveScaleMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveScaleMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveScaleMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveScaleMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveScaleMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveScaleMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveScaleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveScaleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveScaleMethod "setDigits" o = ScaleSetDigitsMethodInfo
    ResolveScaleMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveScaleMethod "setDrawValue" o = ScaleSetDrawValueMethodInfo
    ResolveScaleMethod "setFillLevel" o = Gtk.Range.RangeSetFillLevelMethodInfo
    ResolveScaleMethod "setFlippable" o = Gtk.Range.RangeSetFlippableMethodInfo
    ResolveScaleMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveScaleMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveScaleMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveScaleMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveScaleMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveScaleMethod "setFormatValueFunc" o = ScaleSetFormatValueFuncMethodInfo
    ResolveScaleMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveScaleMethod "setHasOrigin" o = ScaleSetHasOriginMethodInfo
    ResolveScaleMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveScaleMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveScaleMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveScaleMethod "setIncrements" o = Gtk.Range.RangeSetIncrementsMethodInfo
    ResolveScaleMethod "setInverted" o = Gtk.Range.RangeSetInvertedMethodInfo
    ResolveScaleMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveScaleMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveScaleMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveScaleMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveScaleMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveScaleMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveScaleMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveScaleMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveScaleMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveScaleMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveScaleMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveScaleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveScaleMethod "setRange" o = Gtk.Range.RangeSetRangeMethodInfo
    ResolveScaleMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveScaleMethod "setRestrictToFillLevel" o = Gtk.Range.RangeSetRestrictToFillLevelMethodInfo
    ResolveScaleMethod "setRoundDigits" o = Gtk.Range.RangeSetRoundDigitsMethodInfo
    ResolveScaleMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveScaleMethod "setShowFillLevel" o = Gtk.Range.RangeSetShowFillLevelMethodInfo
    ResolveScaleMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveScaleMethod "setSliderSizeFixed" o = Gtk.Range.RangeSetSliderSizeFixedMethodInfo
    ResolveScaleMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveScaleMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveScaleMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveScaleMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveScaleMethod "setValue" o = Gtk.Range.RangeSetValueMethodInfo
    ResolveScaleMethod "setValuePos" o = ScaleSetValuePosMethodInfo
    ResolveScaleMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveScaleMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveScaleMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveScaleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScaleMethod t Scale, O.OverloadedMethod info Scale p) => OL.IsLabel t (Scale -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScaleMethod t Scale, O.OverloadedMethod info Scale p, R.HasField t Scale p) => R.HasField t Scale p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScaleMethod t Scale, O.OverloadedMethodInfo info Scale) => OL.IsLabel t (O.MethodProxy info Scale) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "digits"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scale #digits
-- @
getScaleDigits :: (MonadIO m, IsScale o) => o -> m Int32
getScaleDigits obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "digits"

-- | Set the value of the “@digits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scale [ #digits 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleDigits :: (MonadIO m, IsScale o) => o -> Int32 -> m ()
setScaleDigits obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "digits" val

-- | Construct a t'GValueConstruct' with valid value for the “@digits@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleDigits :: (IsScale o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructScaleDigits val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "digits" val

#if defined(ENABLE_OVERLOADING)
data ScaleDigitsPropertyInfo
instance AttrInfo ScaleDigitsPropertyInfo where
    type AttrAllowedOps ScaleDigitsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScaleDigitsPropertyInfo = IsScale
    type AttrSetTypeConstraint ScaleDigitsPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ScaleDigitsPropertyInfo = (~) Int32
    type AttrTransferType ScaleDigitsPropertyInfo = Int32
    type AttrGetType ScaleDigitsPropertyInfo = Int32
    type AttrLabel ScaleDigitsPropertyInfo = "digits"
    type AttrOrigin ScaleDigitsPropertyInfo = Scale
    attrGet = getScaleDigits
    attrSet = setScaleDigits
    attrPut = setScaleDigits
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleDigits
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.digits"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#g:attr:digits"
        })
#endif

-- VVV Prop "draw-value"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@draw-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scale #drawValue
-- @
getScaleDrawValue :: (MonadIO m, IsScale o) => o -> m Bool
getScaleDrawValue obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "draw-value"

-- | Set the value of the “@draw-value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scale [ #drawValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleDrawValue :: (MonadIO m, IsScale o) => o -> Bool -> m ()
setScaleDrawValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "draw-value" val

-- | Construct a t'GValueConstruct' with valid value for the “@draw-value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleDrawValue :: (IsScale o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScaleDrawValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "draw-value" val

#if defined(ENABLE_OVERLOADING)
data ScaleDrawValuePropertyInfo
instance AttrInfo ScaleDrawValuePropertyInfo where
    type AttrAllowedOps ScaleDrawValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScaleDrawValuePropertyInfo = IsScale
    type AttrSetTypeConstraint ScaleDrawValuePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScaleDrawValuePropertyInfo = (~) Bool
    type AttrTransferType ScaleDrawValuePropertyInfo = Bool
    type AttrGetType ScaleDrawValuePropertyInfo = Bool
    type AttrLabel ScaleDrawValuePropertyInfo = "draw-value"
    type AttrOrigin ScaleDrawValuePropertyInfo = Scale
    attrGet = getScaleDrawValue
    attrSet = setScaleDrawValue
    attrPut = setScaleDrawValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleDrawValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.drawValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#g:attr:drawValue"
        })
#endif

-- VVV Prop "has-origin"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-origin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scale #hasOrigin
-- @
getScaleHasOrigin :: (MonadIO m, IsScale o) => o -> m Bool
getScaleHasOrigin obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-origin"

-- | Set the value of the “@has-origin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scale [ #hasOrigin 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleHasOrigin :: (MonadIO m, IsScale o) => o -> Bool -> m ()
setScaleHasOrigin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-origin" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-origin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleHasOrigin :: (IsScale o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScaleHasOrigin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-origin" val

#if defined(ENABLE_OVERLOADING)
data ScaleHasOriginPropertyInfo
instance AttrInfo ScaleHasOriginPropertyInfo where
    type AttrAllowedOps ScaleHasOriginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScaleHasOriginPropertyInfo = IsScale
    type AttrSetTypeConstraint ScaleHasOriginPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScaleHasOriginPropertyInfo = (~) Bool
    type AttrTransferType ScaleHasOriginPropertyInfo = Bool
    type AttrGetType ScaleHasOriginPropertyInfo = Bool
    type AttrLabel ScaleHasOriginPropertyInfo = "has-origin"
    type AttrOrigin ScaleHasOriginPropertyInfo = Scale
    attrGet = getScaleHasOrigin
    attrSet = setScaleHasOrigin
    attrPut = setScaleHasOrigin
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleHasOrigin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.hasOrigin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#g:attr:hasOrigin"
        })
#endif

-- VVV Prop "value-pos"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PositionType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@value-pos@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scale #valuePos
-- @
getScaleValuePos :: (MonadIO m, IsScale o) => o -> m Gtk.Enums.PositionType
getScaleValuePos obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "value-pos"

-- | Set the value of the “@value-pos@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scale [ #valuePos 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleValuePos :: (MonadIO m, IsScale o) => o -> Gtk.Enums.PositionType -> m ()
setScaleValuePos obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "value-pos" val

-- | Construct a t'GValueConstruct' with valid value for the “@value-pos@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleValuePos :: (IsScale o, MIO.MonadIO m) => Gtk.Enums.PositionType -> m (GValueConstruct o)
constructScaleValuePos val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "value-pos" val

#if defined(ENABLE_OVERLOADING)
data ScaleValuePosPropertyInfo
instance AttrInfo ScaleValuePosPropertyInfo where
    type AttrAllowedOps ScaleValuePosPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ScaleValuePosPropertyInfo = IsScale
    type AttrSetTypeConstraint ScaleValuePosPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferTypeConstraint ScaleValuePosPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferType ScaleValuePosPropertyInfo = Gtk.Enums.PositionType
    type AttrGetType ScaleValuePosPropertyInfo = Gtk.Enums.PositionType
    type AttrLabel ScaleValuePosPropertyInfo = "value-pos"
    type AttrOrigin ScaleValuePosPropertyInfo = Scale
    attrGet = getScaleValuePos
    attrSet = setScaleValuePos
    attrPut = setScaleValuePos
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleValuePos
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.valuePos"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#g:attr:valuePos"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Scale
type instance O.AttributeList Scale = ScaleAttributeList
type ScaleAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("adjustment", Gtk.Range.RangeAdjustmentPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("digits", ScaleDigitsPropertyInfo), '("drawValue", ScaleDrawValuePropertyInfo), '("fillLevel", Gtk.Range.RangeFillLevelPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasOrigin", ScaleHasOriginPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inverted", Gtk.Range.RangeInvertedPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("restrictToFillLevel", Gtk.Range.RangeRestrictToFillLevelPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("roundDigits", Gtk.Range.RangeRoundDigitsPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showFillLevel", Gtk.Range.RangeShowFillLevelPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("valuePos", ScaleValuePosPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
scaleDigits :: AttrLabelProxy "digits"
scaleDigits = AttrLabelProxy

scaleDrawValue :: AttrLabelProxy "drawValue"
scaleDrawValue = AttrLabelProxy

scaleHasOrigin :: AttrLabelProxy "hasOrigin"
scaleHasOrigin = AttrLabelProxy

scaleValuePos :: AttrLabelProxy "valuePos"
scaleValuePos = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Scale = ScaleSignalList
type ScaleSignalList = ('[ '("adjustBounds", Gtk.Range.RangeAdjustBoundsSignalInfo), '("changeValue", Gtk.Range.RangeChangeValueSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveSlider", Gtk.Range.RangeMoveSliderSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("valueChanged", Gtk.Range.RangeValueChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Scale::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scale\8217s orientation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [class@Gtk.Adjustment] which sets\n  the range of the scale, or %NULL to create a new adjustment."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Scale" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_new" gtk_scale_new :: 
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO (Ptr Scale)

-- | Creates a new @GtkScale@.
scaleNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Adjustment.IsAdjustment a) =>
    Gtk.Enums.Orientation
    -- ^ /@orientation@/: the scale’s orientation.
    -> Maybe (a)
    -- ^ /@adjustment@/: the t'GI.Gtk.Objects.Adjustment.Adjustment' which sets
    --   the range of the scale, or 'P.Nothing' to create a new adjustment.
    -> m Scale
    -- ^ __Returns:__ a new @GtkScale@
scaleNew orientation adjustment = liftIO $ do
    let orientation' = (fromIntegral . fromEnum) orientation
    maybeAdjustment <- case adjustment of
        Nothing -> return FP.nullPtr
        Just jAdjustment -> do
            jAdjustment' <- unsafeManagedPtrCastPtr jAdjustment
            return jAdjustment'
    result <- gtk_scale_new orientation' maybeAdjustment
    checkUnexpectedReturnNULL "scaleNew" result
    result' <- (newObject Scale) result
    whenJust adjustment touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Scale::new_with_range
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scale\8217s orientation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "step increment (tick size) used with keyboard shortcuts"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Scale" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_new_with_range" gtk_scale_new_with_range :: 
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    CDouble ->                              -- min : TBasicType TDouble
    CDouble ->                              -- max : TBasicType TDouble
    CDouble ->                              -- step : TBasicType TDouble
    IO (Ptr Scale)

-- | Creates a new scale widget with a range from /@min@/ to /@max@/.
-- 
-- The returns scale will have the given orientation and will let the
-- user input a number between /@min@/ and /@max@/ (including /@min@/ and /@max@/)
-- with the increment /@step@/. /@step@/ must be nonzero; it’s the distance
-- the slider moves when using the arrow keys to adjust the scale
-- value.
-- 
-- Note that the way in which the precision is derived works best if
-- /@step@/ is a power of ten. If the resulting precision is not suitable
-- for your needs, use 'GI.Gtk.Objects.Scale.scaleSetDigits' to correct it.
scaleNewWithRange ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Enums.Orientation
    -- ^ /@orientation@/: the scale’s orientation.
    -> Double
    -- ^ /@min@/: minimum value
    -> Double
    -- ^ /@max@/: maximum value
    -> Double
    -- ^ /@step@/: step increment (tick size) used with keyboard shortcuts
    -> m Scale
    -- ^ __Returns:__ a new @GtkScale@
scaleNewWithRange orientation min max step = liftIO $ do
    let orientation' = (fromIntegral . fromEnum) orientation
    let min' = realToFrac min
    let max' = realToFrac max
    let step' = realToFrac step
    result <- gtk_scale_new_with_range orientation' min' max' step'
    checkUnexpectedReturnNULL "scaleNewWithRange" result
    result' <- (newObject Scale) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Scale::add_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the value at which the mark is placed, must be between\n  the lower and upper limits of the scales\8217 adjustment"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "where to draw the mark. For a horizontal scale, %GTK_POS_TOP\n  and %GTK_POS_LEFT are drawn above the scale, anything else below.\n  For a vertical scale, %GTK_POS_LEFT and %GTK_POS_TOP are drawn to\n  the left of the scale, anything else to the right."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "markup"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Text to be shown at the mark, using Pango markup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_add_mark" gtk_scale_add_mark :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    CDouble ->                              -- value : TBasicType TDouble
    CUInt ->                                -- position : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    CString ->                              -- markup : TBasicType TUTF8
    IO ()

-- | Adds a mark at /@value@/.
-- 
-- A mark is indicated visually by drawing a tick mark next to the scale,
-- and GTK makes it easy for the user to position the scale exactly at the
-- marks value.
-- 
-- If /@markup@/ is not 'P.Nothing', text is shown next to the tick mark.
-- 
-- To remove marks from a scale, use 'GI.Gtk.Objects.Scale.scaleClearMarks'.
scaleAddMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Double
    -- ^ /@value@/: the value at which the mark is placed, must be between
    --   the lower and upper limits of the scales’ adjustment
    -> Gtk.Enums.PositionType
    -- ^ /@position@/: where to draw the mark. For a horizontal scale, 'GI.Gtk.Enums.PositionTypeTop'
    --   and 'GI.Gtk.Enums.PositionTypeLeft' are drawn above the scale, anything else below.
    --   For a vertical scale, 'GI.Gtk.Enums.PositionTypeLeft' and 'GI.Gtk.Enums.PositionTypeTop' are drawn to
    --   the left of the scale, anything else to the right.
    -> Maybe (T.Text)
    -- ^ /@markup@/: Text to be shown at the mark, using Pango markup
    -> m ()
scaleAddMark scale value position markup = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    let value' = realToFrac value
    let position' = (fromIntegral . fromEnum) position
    maybeMarkup <- case markup of
        Nothing -> return FP.nullPtr
        Just jMarkup -> do
            jMarkup' <- textToCString jMarkup
            return jMarkup'
    gtk_scale_add_mark scale' value' position' maybeMarkup
    touchManagedPtr scale
    freeMem maybeMarkup
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleAddMarkMethodInfo
instance (signature ~ (Double -> Gtk.Enums.PositionType -> Maybe (T.Text) -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleAddMarkMethodInfo a signature where
    overloadedMethod = scaleAddMark

instance O.OverloadedMethodInfo ScaleAddMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleAddMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleAddMark"
        })


#endif

-- method Scale::clear_marks
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_clear_marks" gtk_scale_clear_marks :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO ()

-- | Removes any marks that have been added.
scaleClearMarks ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m ()
scaleClearMarks scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    gtk_scale_clear_marks scale'
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleClearMarksMethodInfo
instance (signature ~ (m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleClearMarksMethodInfo a signature where
    overloadedMethod = scaleClearMarks

instance O.OverloadedMethodInfo ScaleClearMarksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleClearMarks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleClearMarks"
        })


#endif

-- method Scale::get_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_digits" gtk_scale_get_digits :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO Int32

-- | Gets the number of decimal places that are displayed in the value.
scaleGetDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m Int32
    -- ^ __Returns:__ the number of decimal places that are displayed
scaleGetDigits scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    result <- gtk_scale_get_digits scale'
    touchManagedPtr scale
    return result

#if defined(ENABLE_OVERLOADING)
data ScaleGetDigitsMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetDigitsMethodInfo a signature where
    overloadedMethod = scaleGetDigits

instance O.OverloadedMethodInfo ScaleGetDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetDigits"
        })


#endif

-- method Scale::get_draw_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_draw_value" gtk_scale_get_draw_value :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO CInt

-- | Returns whether the current value is displayed as a string
-- next to the slider.
scaleGetDrawValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m Bool
    -- ^ __Returns:__ whether the current value is displayed as a string
scaleGetDrawValue scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    result <- gtk_scale_get_draw_value scale'
    let result' = (/= 0) result
    touchManagedPtr scale
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleGetDrawValueMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetDrawValueMethodInfo a signature where
    overloadedMethod = scaleGetDrawValue

instance O.OverloadedMethodInfo ScaleGetDrawValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetDrawValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetDrawValue"
        })


#endif

-- method Scale::get_has_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_has_origin" gtk_scale_get_has_origin :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO CInt

-- | Returns whether the scale has an origin.
scaleGetHasOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the scale has an origin.
scaleGetHasOrigin scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    result <- gtk_scale_get_has_origin scale'
    let result' = (/= 0) result
    touchManagedPtr scale
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleGetHasOriginMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetHasOriginMethodInfo a signature where
    overloadedMethod = scaleGetHasOrigin

instance O.OverloadedMethodInfo ScaleGetHasOriginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetHasOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetHasOrigin"
        })


#endif

-- method Scale::get_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Layout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_layout" gtk_scale_get_layout :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO (Ptr Pango.Layout.Layout)

-- | Gets the @PangoLayout@ used to display the scale.
-- 
-- The returned object is owned by the scale so does not need
-- to be freed by the caller.
scaleGetLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: A @GtkScale@
    -> m (Maybe Pango.Layout.Layout)
    -- ^ __Returns:__ the t'GI.Pango.Objects.Layout.Layout'
    --   for this scale, or 'P.Nothing' if the [Scale:drawValue]("GI.Gtk.Objects.Scale#g:attr:drawValue")
    --   property is 'P.False'.
scaleGetLayout scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    result <- gtk_scale_get_layout scale'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Pango.Layout.Layout) result'
        return result''
    touchManagedPtr scale
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScaleGetLayoutMethodInfo
instance (signature ~ (m (Maybe Pango.Layout.Layout)), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetLayoutMethodInfo a signature where
    overloadedMethod = scaleGetLayout

instance O.OverloadedMethodInfo ScaleGetLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetLayout"
        })


#endif

-- method Scale::get_layout_offsets
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store X offset of layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store Y offset of layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_layout_offsets" gtk_scale_get_layout_offsets :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    IO ()

-- | Obtains the coordinates where the scale will draw the
-- @PangoLayout@ representing the text in the scale.
-- 
-- Remember when using the @PangoLayout@ function you need to
-- convert to and from pixels using @PANGO_PIXELS()@ or @PANGO_SCALE@.
-- 
-- If the [Scale:drawValue]("GI.Gtk.Objects.Scale#g:attr:drawValue") property is 'P.False', the return
-- values are undefined.
scaleGetLayoutOffsets ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m ((Int32, Int32))
scaleGetLayoutOffsets scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    gtk_scale_get_layout_offsets scale' x y
    x' <- peek x
    y' <- peek y
    touchManagedPtr scale
    freeMem x
    freeMem y
    return (x', y')

#if defined(ENABLE_OVERLOADING)
data ScaleGetLayoutOffsetsMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetLayoutOffsetsMethodInfo a signature where
    overloadedMethod = scaleGetLayoutOffsets

instance O.OverloadedMethodInfo ScaleGetLayoutOffsetsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetLayoutOffsets",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetLayoutOffsets"
        })


#endif

-- method Scale::get_value_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PositionType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_get_value_pos" gtk_scale_get_value_pos :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    IO CUInt

-- | Gets the position in which the current value is displayed.
scaleGetValuePos ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> m Gtk.Enums.PositionType
    -- ^ __Returns:__ the position in which the current value is displayed
scaleGetValuePos scale = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    result <- gtk_scale_get_value_pos scale'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr scale
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleGetValuePosMethodInfo
instance (signature ~ (m Gtk.Enums.PositionType), MonadIO m, IsScale a) => O.OverloadedMethod ScaleGetValuePosMethodInfo a signature where
    overloadedMethod = scaleGetValuePos

instance O.OverloadedMethodInfo ScaleGetValuePosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleGetValuePos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleGetValuePos"
        })


#endif

-- method Scale::set_digits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "digits"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of decimal places to display,\n  e.g. use 1 to display 1.0, 2 to display 1.00, etc"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_set_digits" gtk_scale_set_digits :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    Int32 ->                                -- digits : TBasicType TInt
    IO ()

-- | Sets the number of decimal places that are displayed in the value.
-- 
-- Also causes the value of the adjustment to be rounded to this number
-- of digits, so the retrieved value matches the displayed one, if
-- [Scale:drawValue]("GI.Gtk.Objects.Scale#g:attr:drawValue") is 'P.True' when the value changes. If
-- you want to enforce rounding the value when [Scale:drawValue]("GI.Gtk.Objects.Scale#g:attr:drawValue")
-- is 'P.False', you can set [Range:roundDigits]("GI.Gtk.Objects.Range#g:attr:roundDigits") instead.
-- 
-- Note that rounding to a small number of digits can interfere with
-- the smooth autoscrolling that is built into @GtkScale@. As an alternative,
-- you can use 'GI.Gtk.Objects.Scale.scaleSetFormatValueFunc' to format the displayed
-- value yourself.
scaleSetDigits ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Int32
    -- ^ /@digits@/: the number of decimal places to display,
    --   e.g. use 1 to display 1.0, 2 to display 1.00, etc
    -> m ()
scaleSetDigits scale digits = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    gtk_scale_set_digits scale' digits
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleSetDigitsMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleSetDigitsMethodInfo a signature where
    overloadedMethod = scaleSetDigits

instance O.OverloadedMethodInfo ScaleSetDigitsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleSetDigits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleSetDigits"
        })


#endif

-- method Scale::set_draw_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "draw_value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to draw the value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_set_draw_value" gtk_scale_set_draw_value :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    CInt ->                                 -- draw_value : TBasicType TBoolean
    IO ()

-- | Specifies whether the current value is displayed as a string next
-- to the slider.
scaleSetDrawValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Bool
    -- ^ /@drawValue@/: 'P.True' to draw the value
    -> m ()
scaleSetDrawValue scale drawValue = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    let drawValue' = (P.fromIntegral . P.fromEnum) drawValue
    gtk_scale_set_draw_value scale' drawValue'
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleSetDrawValueMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleSetDrawValueMethodInfo a signature where
    overloadedMethod = scaleSetDrawValue

instance O.OverloadedMethodInfo ScaleSetDrawValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleSetDrawValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleSetDrawValue"
        })


#endif

-- method Scale::set_format_value_func
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "ScaleFormatValueFunc" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function\n  that formats the value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy_notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy function for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_set_format_value_func" gtk_scale_set_format_value_func :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    FunPtr Gtk.Callbacks.C_ScaleFormatValueFunc -> -- func : TInterface (Name {namespace = "Gtk", name = "ScaleFormatValueFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy_notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | /@func@/ allows you to change how the scale value is displayed.
-- 
-- The given function will return an allocated string representing
-- /@value@/. That string will then be used to display the scale\'s value.
-- 
-- If @/NULL/@ is passed as /@func@/, the value will be displayed on
-- its own, rounded according to the value of the
-- [Scale:digits]("GI.Gtk.Objects.Scale#g:attr:digits") property.
scaleSetFormatValueFunc ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Maybe (Gtk.Callbacks.ScaleFormatValueFunc)
    -- ^ /@func@/: function
    --   that formats the value
    -> m ()
scaleSetFormatValueFunc scale func = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    maybeFunc <- case func of
        Nothing -> return FP.nullFunPtr
        Just jFunc -> do
            jFunc' <- Gtk.Callbacks.mk_ScaleFormatValueFunc (Gtk.Callbacks.wrap_ScaleFormatValueFunc Nothing (Gtk.Callbacks.drop_closures_ScaleFormatValueFunc jFunc))
            return jFunc'
    let userData = castFunPtrToPtr maybeFunc
    let destroyNotify = SP.safeFreeFunPtrPtr
    gtk_scale_set_format_value_func scale' maybeFunc userData destroyNotify
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleSetFormatValueFuncMethodInfo
instance (signature ~ (Maybe (Gtk.Callbacks.ScaleFormatValueFunc) -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleSetFormatValueFuncMethodInfo a signature where
    overloadedMethod = scaleSetFormatValueFunc

instance O.OverloadedMethodInfo ScaleSetFormatValueFuncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleSetFormatValueFunc",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleSetFormatValueFunc"
        })


#endif

-- method Scale::set_has_origin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_origin"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the scale has an origin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_set_has_origin" gtk_scale_set_has_origin :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    CInt ->                                 -- has_origin : TBasicType TBoolean
    IO ()

-- | Sets whether the scale has an origin.
-- 
-- If [Scale:hasOrigin]("GI.Gtk.Objects.Scale#g:attr:hasOrigin") is set to 'P.True' (the default),
-- the scale will highlight the part of the trough between the origin
-- (bottom or left side) and the current value.
scaleSetHasOrigin ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Bool
    -- ^ /@hasOrigin@/: 'P.True' if the scale has an origin
    -> m ()
scaleSetHasOrigin scale hasOrigin = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    let hasOrigin' = (P.fromIntegral . P.fromEnum) hasOrigin
    gtk_scale_set_has_origin scale' hasOrigin'
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleSetHasOriginMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleSetHasOriginMethodInfo a signature where
    overloadedMethod = scaleSetHasOrigin

instance O.OverloadedMethodInfo ScaleSetHasOriginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleSetHasOrigin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleSetHasOrigin"
        })


#endif

-- method Scale::set_value_pos
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scale"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Scale" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScale`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the position in which the current value is displayed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_set_value_pos" gtk_scale_set_value_pos :: 
    Ptr Scale ->                            -- scale : TInterface (Name {namespace = "Gtk", name = "Scale"})
    CUInt ->                                -- pos : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    IO ()

-- | Sets the position in which the current value is displayed.
scaleSetValuePos ::
    (B.CallStack.HasCallStack, MonadIO m, IsScale a) =>
    a
    -- ^ /@scale@/: a @GtkScale@
    -> Gtk.Enums.PositionType
    -- ^ /@pos@/: the position in which the current value is displayed
    -> m ()
scaleSetValuePos scale pos = liftIO $ do
    scale' <- unsafeManagedPtrCastPtr scale
    let pos' = (fromIntegral . fromEnum) pos
    gtk_scale_set_value_pos scale' pos'
    touchManagedPtr scale
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleSetValuePosMethodInfo
instance (signature ~ (Gtk.Enums.PositionType -> m ()), MonadIO m, IsScale a) => O.OverloadedMethod ScaleSetValuePosMethodInfo a signature where
    overloadedMethod = scaleSetValuePos

instance O.OverloadedMethodInfo ScaleSetValuePosMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Scale.scaleSetValuePos",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Scale.html#v:scaleSetValuePos"
        })


#endif


