{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents a job that is sent to a printer.
-- 
-- You only need to deal directly with print jobs if you use the
-- non-portable t'GI.Gtk.Objects.PrintUnixDialog.PrintUnixDialog' API.
-- 
-- Use 'GI.Gtk.Objects.PrintJob.printJobGetSurface' to obtain the cairo surface
-- onto which the pages must be drawn. Use 'GI.Gtk.Objects.PrintJob.printJobSend'
-- to send the finished job to the printer. If you don’t use cairo
-- @GtkPrintJob@ also supports printing of manually generated PostScript,
-- via 'GI.Gtk.Objects.PrintJob.printJobSetSourceFile'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PrintJob
    ( 

-- * Exported types
    PrintJob(..)                            ,
    IsPrintJob                              ,
    toPrintJob                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [send]("GI.Gtk.Objects.PrintJob#g:method:send"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCollate]("GI.Gtk.Objects.PrintJob#g:method:getCollate"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getNUp]("GI.Gtk.Objects.PrintJob#g:method:getNUp"), [getNUpLayout]("GI.Gtk.Objects.PrintJob#g:method:getNUpLayout"), [getNumCopies]("GI.Gtk.Objects.PrintJob#g:method:getNumCopies"), [getPageRanges]("GI.Gtk.Objects.PrintJob#g:method:getPageRanges"), [getPageSet]("GI.Gtk.Objects.PrintJob#g:method:getPageSet"), [getPages]("GI.Gtk.Objects.PrintJob#g:method:getPages"), [getPrinter]("GI.Gtk.Objects.PrintJob#g:method:getPrinter"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getReverse]("GI.Gtk.Objects.PrintJob#g:method:getReverse"), [getRotate]("GI.Gtk.Objects.PrintJob#g:method:getRotate"), [getScale]("GI.Gtk.Objects.PrintJob#g:method:getScale"), [getSettings]("GI.Gtk.Objects.PrintJob#g:method:getSettings"), [getStatus]("GI.Gtk.Objects.PrintJob#g:method:getStatus"), [getSurface]("GI.Gtk.Objects.PrintJob#g:method:getSurface"), [getTitle]("GI.Gtk.Objects.PrintJob#g:method:getTitle"), [getTrackPrintStatus]("GI.Gtk.Objects.PrintJob#g:method:getTrackPrintStatus").
-- 
-- ==== Setters
-- [setCollate]("GI.Gtk.Objects.PrintJob#g:method:setCollate"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setNUp]("GI.Gtk.Objects.PrintJob#g:method:setNUp"), [setNUpLayout]("GI.Gtk.Objects.PrintJob#g:method:setNUpLayout"), [setNumCopies]("GI.Gtk.Objects.PrintJob#g:method:setNumCopies"), [setPageRanges]("GI.Gtk.Objects.PrintJob#g:method:setPageRanges"), [setPageSet]("GI.Gtk.Objects.PrintJob#g:method:setPageSet"), [setPages]("GI.Gtk.Objects.PrintJob#g:method:setPages"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReverse]("GI.Gtk.Objects.PrintJob#g:method:setReverse"), [setRotate]("GI.Gtk.Objects.PrintJob#g:method:setRotate"), [setScale]("GI.Gtk.Objects.PrintJob#g:method:setScale"), [setSourceFd]("GI.Gtk.Objects.PrintJob#g:method:setSourceFd"), [setSourceFile]("GI.Gtk.Objects.PrintJob#g:method:setSourceFile"), [setTrackPrintStatus]("GI.Gtk.Objects.PrintJob#g:method:setTrackPrintStatus").

#if defined(ENABLE_OVERLOADING)
    ResolvePrintJobMethod                   ,
#endif

-- ** getCollate #method:getCollate#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetCollateMethodInfo            ,
#endif
    printJobGetCollate                      ,


-- ** getNUp #method:getNUp#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetNUpMethodInfo                ,
#endif
    printJobGetNUp                          ,


-- ** getNUpLayout #method:getNUpLayout#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetNUpLayoutMethodInfo          ,
#endif
    printJobGetNUpLayout                    ,


-- ** getNumCopies #method:getNumCopies#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetNumCopiesMethodInfo          ,
#endif
    printJobGetNumCopies                    ,


-- ** getPageRanges #method:getPageRanges#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetPageRangesMethodInfo         ,
#endif
    printJobGetPageRanges                   ,


-- ** getPageSet #method:getPageSet#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetPageSetMethodInfo            ,
#endif
    printJobGetPageSet                      ,


-- ** getPages #method:getPages#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetPagesMethodInfo              ,
#endif
    printJobGetPages                        ,


-- ** getPrinter #method:getPrinter#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetPrinterMethodInfo            ,
#endif
    printJobGetPrinter                      ,


-- ** getReverse #method:getReverse#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetReverseMethodInfo            ,
#endif
    printJobGetReverse                      ,


-- ** getRotate #method:getRotate#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetRotateMethodInfo             ,
#endif
    printJobGetRotate                       ,


-- ** getScale #method:getScale#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetScaleMethodInfo              ,
#endif
    printJobGetScale                        ,


-- ** getSettings #method:getSettings#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetSettingsMethodInfo           ,
#endif
    printJobGetSettings                     ,


-- ** getStatus #method:getStatus#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetStatusMethodInfo             ,
#endif
    printJobGetStatus                       ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetSurfaceMethodInfo            ,
#endif
    printJobGetSurface                      ,


-- ** getTitle #method:getTitle#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetTitleMethodInfo              ,
#endif
    printJobGetTitle                        ,


-- ** getTrackPrintStatus #method:getTrackPrintStatus#

#if defined(ENABLE_OVERLOADING)
    PrintJobGetTrackPrintStatusMethodInfo   ,
#endif
    printJobGetTrackPrintStatus             ,


-- ** new #method:new#

    printJobNew                             ,


-- ** send #method:send#

#if defined(ENABLE_OVERLOADING)
    PrintJobSendMethodInfo                  ,
#endif
    printJobSend                            ,


-- ** setCollate #method:setCollate#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetCollateMethodInfo            ,
#endif
    printJobSetCollate                      ,


-- ** setNUp #method:setNUp#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetNUpMethodInfo                ,
#endif
    printJobSetNUp                          ,


-- ** setNUpLayout #method:setNUpLayout#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetNUpLayoutMethodInfo          ,
#endif
    printJobSetNUpLayout                    ,


-- ** setNumCopies #method:setNumCopies#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetNumCopiesMethodInfo          ,
#endif
    printJobSetNumCopies                    ,


-- ** setPageRanges #method:setPageRanges#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetPageRangesMethodInfo         ,
#endif
    printJobSetPageRanges                   ,


-- ** setPageSet #method:setPageSet#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetPageSetMethodInfo            ,
#endif
    printJobSetPageSet                      ,


-- ** setPages #method:setPages#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetPagesMethodInfo              ,
#endif
    printJobSetPages                        ,


-- ** setReverse #method:setReverse#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetReverseMethodInfo            ,
#endif
    printJobSetReverse                      ,


-- ** setRotate #method:setRotate#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetRotateMethodInfo             ,
#endif
    printJobSetRotate                       ,


-- ** setScale #method:setScale#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetScaleMethodInfo              ,
#endif
    printJobSetScale                        ,


-- ** setSourceFd #method:setSourceFd#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetSourceFdMethodInfo           ,
#endif
    printJobSetSourceFd                     ,


-- ** setSourceFile #method:setSourceFile#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetSourceFileMethodInfo         ,
#endif
    printJobSetSourceFile                   ,


-- ** setTrackPrintStatus #method:setTrackPrintStatus#

#if defined(ENABLE_OVERLOADING)
    PrintJobSetTrackPrintStatusMethodInfo   ,
#endif
    printJobSetTrackPrintStatus             ,




 -- * Properties


-- ** pageSetup #attr:pageSetup#
-- | Page setup.

#if defined(ENABLE_OVERLOADING)
    PrintJobPageSetupPropertyInfo           ,
#endif
    constructPrintJobPageSetup              ,
    getPrintJobPageSetup                    ,
#if defined(ENABLE_OVERLOADING)
    printJobPageSetup                       ,
#endif


-- ** printer #attr:printer#
-- | The printer to send the job to.

#if defined(ENABLE_OVERLOADING)
    PrintJobPrinterPropertyInfo             ,
#endif
    constructPrintJobPrinter                ,
    getPrintJobPrinter                      ,
#if defined(ENABLE_OVERLOADING)
    printJobPrinter                         ,
#endif


-- ** settings #attr:settings#
-- | Printer settings.

#if defined(ENABLE_OVERLOADING)
    PrintJobSettingsPropertyInfo            ,
#endif
    constructPrintJobSettings               ,
    getPrintJobSettings                     ,
#if defined(ENABLE_OVERLOADING)
    printJobSettings                        ,
#endif


-- ** title #attr:title#
-- | The title of the print job.

#if defined(ENABLE_OVERLOADING)
    PrintJobTitlePropertyInfo               ,
#endif
    constructPrintJobTitle                  ,
    getPrintJobTitle                        ,
#if defined(ENABLE_OVERLOADING)
    printJobTitle                           ,
#endif


-- ** trackPrintStatus #attr:trackPrintStatus#
-- | 'P.True' if the print job will continue to emit status-changed
-- signals after the print data has been setn to the printer.

#if defined(ENABLE_OVERLOADING)
    PrintJobTrackPrintStatusPropertyInfo    ,
#endif
    constructPrintJobTrackPrintStatus       ,
    getPrintJobTrackPrintStatus             ,
#if defined(ENABLE_OVERLOADING)
    printJobTrackPrintStatus                ,
#endif
    setPrintJobTrackPrintStatus             ,




 -- * Signals


-- ** statusChanged #signal:statusChanged#

    PrintJobStatusChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    PrintJobStatusChangedSignalInfo         ,
#endif
    afterPrintJobStatusChanged              ,
    onPrintJobStatusChanged                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.PrintBackend as Gtk.PrintBackend

#else
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange

#endif

-- | Memory-managed wrapper type.
newtype PrintJob = PrintJob (SP.ManagedPtr PrintJob)
    deriving (Eq)

instance SP.ManagedPtrNewtype PrintJob where
    toManagedPtr (PrintJob p) = p

foreign import ccall "gtk_print_job_get_type"
    c_gtk_print_job_get_type :: IO B.Types.GType

instance B.Types.TypedObject PrintJob where
    glibType = c_gtk_print_job_get_type

instance B.Types.GObject PrintJob

-- | Type class for types which can be safely cast to t'PrintJob', for instance with `toPrintJob`.
class (SP.GObject o, O.IsDescendantOf PrintJob o) => IsPrintJob o
instance (SP.GObject o, O.IsDescendantOf PrintJob o) => IsPrintJob o

instance O.HasParentTypes PrintJob
type instance O.ParentTypes PrintJob = '[GObject.Object.Object]

-- | Cast to t'PrintJob', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPrintJob :: (MIO.MonadIO m, IsPrintJob o) => o -> m PrintJob
toPrintJob = MIO.liftIO . B.ManagedPtr.unsafeCastTo PrintJob

-- | Convert t'PrintJob' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PrintJob) where
    gvalueGType_ = c_gtk_print_job_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PrintJob)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PrintJob)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PrintJob ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePrintJobMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePrintJobMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePrintJobMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePrintJobMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePrintJobMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePrintJobMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePrintJobMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePrintJobMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePrintJobMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePrintJobMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePrintJobMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePrintJobMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePrintJobMethod "send" o = PrintJobSendMethodInfo
    ResolvePrintJobMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePrintJobMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePrintJobMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePrintJobMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePrintJobMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePrintJobMethod "getCollate" o = PrintJobGetCollateMethodInfo
    ResolvePrintJobMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePrintJobMethod "getNUp" o = PrintJobGetNUpMethodInfo
    ResolvePrintJobMethod "getNUpLayout" o = PrintJobGetNUpLayoutMethodInfo
    ResolvePrintJobMethod "getNumCopies" o = PrintJobGetNumCopiesMethodInfo
    ResolvePrintJobMethod "getPageRanges" o = PrintJobGetPageRangesMethodInfo
    ResolvePrintJobMethod "getPageSet" o = PrintJobGetPageSetMethodInfo
    ResolvePrintJobMethod "getPages" o = PrintJobGetPagesMethodInfo
    ResolvePrintJobMethod "getPrinter" o = PrintJobGetPrinterMethodInfo
    ResolvePrintJobMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePrintJobMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePrintJobMethod "getReverse" o = PrintJobGetReverseMethodInfo
    ResolvePrintJobMethod "getRotate" o = PrintJobGetRotateMethodInfo
    ResolvePrintJobMethod "getScale" o = PrintJobGetScaleMethodInfo
    ResolvePrintJobMethod "getSettings" o = PrintJobGetSettingsMethodInfo
    ResolvePrintJobMethod "getStatus" o = PrintJobGetStatusMethodInfo
    ResolvePrintJobMethod "getSurface" o = PrintJobGetSurfaceMethodInfo
    ResolvePrintJobMethod "getTitle" o = PrintJobGetTitleMethodInfo
    ResolvePrintJobMethod "getTrackPrintStatus" o = PrintJobGetTrackPrintStatusMethodInfo
    ResolvePrintJobMethod "setCollate" o = PrintJobSetCollateMethodInfo
    ResolvePrintJobMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePrintJobMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePrintJobMethod "setNUp" o = PrintJobSetNUpMethodInfo
    ResolvePrintJobMethod "setNUpLayout" o = PrintJobSetNUpLayoutMethodInfo
    ResolvePrintJobMethod "setNumCopies" o = PrintJobSetNumCopiesMethodInfo
    ResolvePrintJobMethod "setPageRanges" o = PrintJobSetPageRangesMethodInfo
    ResolvePrintJobMethod "setPageSet" o = PrintJobSetPageSetMethodInfo
    ResolvePrintJobMethod "setPages" o = PrintJobSetPagesMethodInfo
    ResolvePrintJobMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePrintJobMethod "setReverse" o = PrintJobSetReverseMethodInfo
    ResolvePrintJobMethod "setRotate" o = PrintJobSetRotateMethodInfo
    ResolvePrintJobMethod "setScale" o = PrintJobSetScaleMethodInfo
    ResolvePrintJobMethod "setSourceFd" o = PrintJobSetSourceFdMethodInfo
    ResolvePrintJobMethod "setSourceFile" o = PrintJobSetSourceFileMethodInfo
    ResolvePrintJobMethod "setTrackPrintStatus" o = PrintJobSetTrackPrintStatusMethodInfo
    ResolvePrintJobMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePrintJobMethod t PrintJob, O.OverloadedMethod info PrintJob p) => OL.IsLabel t (PrintJob -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePrintJobMethod t PrintJob, O.OverloadedMethod info PrintJob p, R.HasField t PrintJob p) => R.HasField t PrintJob p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePrintJobMethod t PrintJob, O.OverloadedMethodInfo info PrintJob) => OL.IsLabel t (O.MethodProxy info PrintJob) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal PrintJob::status-changed
-- | Emitted when the status of a job changes.
-- 
-- The signal handler can use 'GI.Gtk.Objects.PrintJob.printJobGetStatus'
-- to obtain the new status.
type PrintJobStatusChangedCallback =
    IO ()

type C_PrintJobStatusChangedCallback =
    Ptr PrintJob ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_PrintJobStatusChangedCallback`.
foreign import ccall "wrapper"
    mk_PrintJobStatusChangedCallback :: C_PrintJobStatusChangedCallback -> IO (FunPtr C_PrintJobStatusChangedCallback)

wrap_PrintJobStatusChangedCallback :: 
    GObject a => (a -> PrintJobStatusChangedCallback) ->
    C_PrintJobStatusChangedCallback
wrap_PrintJobStatusChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [statusChanged](#signal:statusChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' printJob #statusChanged callback
-- @
-- 
-- 
onPrintJobStatusChanged :: (IsPrintJob a, MonadIO m) => a -> ((?self :: a) => PrintJobStatusChangedCallback) -> m SignalHandlerId
onPrintJobStatusChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PrintJobStatusChangedCallback wrapped
    wrapped'' <- mk_PrintJobStatusChangedCallback wrapped'
    connectSignalFunPtr obj "status-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [statusChanged](#signal:statusChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' printJob #statusChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPrintJobStatusChanged :: (IsPrintJob a, MonadIO m) => a -> ((?self :: a) => PrintJobStatusChangedCallback) -> m SignalHandlerId
afterPrintJobStatusChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PrintJobStatusChangedCallback wrapped
    wrapped'' <- mk_PrintJobStatusChangedCallback wrapped'
    connectSignalFunPtr obj "status-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PrintJobStatusChangedSignalInfo
instance SignalInfo PrintJobStatusChangedSignalInfo where
    type HaskellCallbackType PrintJobStatusChangedSignalInfo = PrintJobStatusChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PrintJobStatusChangedCallback cb
        cb'' <- mk_PrintJobStatusChangedCallback cb'
        connectSignalFunPtr obj "status-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob::status-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:signal:statusChanged"})

#endif

-- VVV Prop "page-setup"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PageSetup"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@page-setup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printJob #pageSetup
-- @
getPrintJobPageSetup :: (MonadIO m, IsPrintJob o) => o -> m (Maybe Gtk.PageSetup.PageSetup)
getPrintJobPageSetup obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "page-setup" Gtk.PageSetup.PageSetup

-- | Construct a t'GValueConstruct' with valid value for the “@page-setup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintJobPageSetup :: (IsPrintJob o, MIO.MonadIO m, Gtk.PageSetup.IsPageSetup a) => a -> m (GValueConstruct o)
constructPrintJobPageSetup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "page-setup" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrintJobPageSetupPropertyInfo
instance AttrInfo PrintJobPageSetupPropertyInfo where
    type AttrAllowedOps PrintJobPageSetupPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintJobPageSetupPropertyInfo = IsPrintJob
    type AttrSetTypeConstraint PrintJobPageSetupPropertyInfo = Gtk.PageSetup.IsPageSetup
    type AttrTransferTypeConstraint PrintJobPageSetupPropertyInfo = Gtk.PageSetup.IsPageSetup
    type AttrTransferType PrintJobPageSetupPropertyInfo = Gtk.PageSetup.PageSetup
    type AttrGetType PrintJobPageSetupPropertyInfo = (Maybe Gtk.PageSetup.PageSetup)
    type AttrLabel PrintJobPageSetupPropertyInfo = "page-setup"
    type AttrOrigin PrintJobPageSetupPropertyInfo = PrintJob
    attrGet = getPrintJobPageSetup
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.PageSetup.PageSetup v
    attrConstruct = constructPrintJobPageSetup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.pageSetup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:attr:pageSetup"
        })
#endif

-- VVV Prop "printer"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Printer"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@printer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printJob #printer
-- @
getPrintJobPrinter :: (MonadIO m, IsPrintJob o) => o -> m Gtk.Printer.Printer
getPrintJobPrinter obj = MIO.liftIO $ checkUnexpectedNothing "getPrintJobPrinter" $ B.Properties.getObjectPropertyObject obj "printer" Gtk.Printer.Printer

-- | Construct a t'GValueConstruct' with valid value for the “@printer@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintJobPrinter :: (IsPrintJob o, MIO.MonadIO m, Gtk.Printer.IsPrinter a) => a -> m (GValueConstruct o)
constructPrintJobPrinter val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "printer" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrintJobPrinterPropertyInfo
instance AttrInfo PrintJobPrinterPropertyInfo where
    type AttrAllowedOps PrintJobPrinterPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintJobPrinterPropertyInfo = IsPrintJob
    type AttrSetTypeConstraint PrintJobPrinterPropertyInfo = Gtk.Printer.IsPrinter
    type AttrTransferTypeConstraint PrintJobPrinterPropertyInfo = Gtk.Printer.IsPrinter
    type AttrTransferType PrintJobPrinterPropertyInfo = Gtk.Printer.Printer
    type AttrGetType PrintJobPrinterPropertyInfo = Gtk.Printer.Printer
    type AttrLabel PrintJobPrinterPropertyInfo = "printer"
    type AttrOrigin PrintJobPrinterPropertyInfo = PrintJob
    attrGet = getPrintJobPrinter
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Printer.Printer v
    attrConstruct = constructPrintJobPrinter
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:attr:printer"
        })
#endif

-- VVV Prop "settings"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@settings@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printJob #settings
-- @
getPrintJobSettings :: (MonadIO m, IsPrintJob o) => o -> m Gtk.PrintSettings.PrintSettings
getPrintJobSettings obj = MIO.liftIO $ checkUnexpectedNothing "getPrintJobSettings" $ B.Properties.getObjectPropertyObject obj "settings" Gtk.PrintSettings.PrintSettings

-- | Construct a t'GValueConstruct' with valid value for the “@settings@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintJobSettings :: (IsPrintJob o, MIO.MonadIO m, Gtk.PrintSettings.IsPrintSettings a) => a -> m (GValueConstruct o)
constructPrintJobSettings val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "settings" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrintJobSettingsPropertyInfo
instance AttrInfo PrintJobSettingsPropertyInfo where
    type AttrAllowedOps PrintJobSettingsPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintJobSettingsPropertyInfo = IsPrintJob
    type AttrSetTypeConstraint PrintJobSettingsPropertyInfo = Gtk.PrintSettings.IsPrintSettings
    type AttrTransferTypeConstraint PrintJobSettingsPropertyInfo = Gtk.PrintSettings.IsPrintSettings
    type AttrTransferType PrintJobSettingsPropertyInfo = Gtk.PrintSettings.PrintSettings
    type AttrGetType PrintJobSettingsPropertyInfo = Gtk.PrintSettings.PrintSettings
    type AttrLabel PrintJobSettingsPropertyInfo = "settings"
    type AttrOrigin PrintJobSettingsPropertyInfo = PrintJob
    attrGet = getPrintJobSettings
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.PrintSettings.PrintSettings v
    attrConstruct = constructPrintJobSettings
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.settings"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:attr:settings"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printJob #title
-- @
getPrintJobTitle :: (MonadIO m, IsPrintJob o) => o -> m T.Text
getPrintJobTitle obj = MIO.liftIO $ checkUnexpectedNothing "getPrintJobTitle" $ B.Properties.getObjectPropertyString obj "title"

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintJobTitle :: (IsPrintJob o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructPrintJobTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrintJobTitlePropertyInfo
instance AttrInfo PrintJobTitlePropertyInfo where
    type AttrAllowedOps PrintJobTitlePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintJobTitlePropertyInfo = IsPrintJob
    type AttrSetTypeConstraint PrintJobTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint PrintJobTitlePropertyInfo = (~) T.Text
    type AttrTransferType PrintJobTitlePropertyInfo = T.Text
    type AttrGetType PrintJobTitlePropertyInfo = T.Text
    type AttrLabel PrintJobTitlePropertyInfo = "title"
    type AttrOrigin PrintJobTitlePropertyInfo = PrintJob
    attrGet = getPrintJobTitle
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintJobTitle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:attr:title"
        })
#endif

-- VVV Prop "track-print-status"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@track-print-status@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printJob #trackPrintStatus
-- @
getPrintJobTrackPrintStatus :: (MonadIO m, IsPrintJob o) => o -> m Bool
getPrintJobTrackPrintStatus obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "track-print-status"

-- | Set the value of the “@track-print-status@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printJob [ #trackPrintStatus 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintJobTrackPrintStatus :: (MonadIO m, IsPrintJob o) => o -> Bool -> m ()
setPrintJobTrackPrintStatus obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "track-print-status" val

-- | Construct a t'GValueConstruct' with valid value for the “@track-print-status@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintJobTrackPrintStatus :: (IsPrintJob o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrintJobTrackPrintStatus val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "track-print-status" val

#if defined(ENABLE_OVERLOADING)
data PrintJobTrackPrintStatusPropertyInfo
instance AttrInfo PrintJobTrackPrintStatusPropertyInfo where
    type AttrAllowedOps PrintJobTrackPrintStatusPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PrintJobTrackPrintStatusPropertyInfo = IsPrintJob
    type AttrSetTypeConstraint PrintJobTrackPrintStatusPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrintJobTrackPrintStatusPropertyInfo = (~) Bool
    type AttrTransferType PrintJobTrackPrintStatusPropertyInfo = Bool
    type AttrGetType PrintJobTrackPrintStatusPropertyInfo = Bool
    type AttrLabel PrintJobTrackPrintStatusPropertyInfo = "track-print-status"
    type AttrOrigin PrintJobTrackPrintStatusPropertyInfo = PrintJob
    attrGet = getPrintJobTrackPrintStatus
    attrSet = setPrintJobTrackPrintStatus
    attrPut = setPrintJobTrackPrintStatus
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintJobTrackPrintStatus
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.trackPrintStatus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#g:attr:trackPrintStatus"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PrintJob
type instance O.AttributeList PrintJob = PrintJobAttributeList
type PrintJobAttributeList = ('[ '("pageSetup", PrintJobPageSetupPropertyInfo), '("printer", PrintJobPrinterPropertyInfo), '("settings", PrintJobSettingsPropertyInfo), '("title", PrintJobTitlePropertyInfo), '("trackPrintStatus", PrintJobTrackPrintStatusPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
printJobPageSetup :: AttrLabelProxy "pageSetup"
printJobPageSetup = AttrLabelProxy

printJobPrinter :: AttrLabelProxy "printer"
printJobPrinter = AttrLabelProxy

printJobSettings :: AttrLabelProxy "settings"
printJobSettings = AttrLabelProxy

printJobTitle :: AttrLabelProxy "title"
printJobTitle = AttrLabelProxy

printJobTrackPrintStatus :: AttrLabelProxy "trackPrintStatus"
printJobTrackPrintStatus = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PrintJob = PrintJobSignalList
type PrintJobSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo), '("statusChanged", PrintJobStatusChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PrintJob::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the job title" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "printer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Printer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrinter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintSettings" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintSettings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetup`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PrintJob" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_new" gtk_print_job_new :: 
    CString ->                              -- title : TBasicType TUTF8
    Ptr Gtk.Printer.Printer ->              -- printer : TInterface (Name {namespace = "Gtk", name = "Printer"})
    Ptr Gtk.PrintSettings.PrintSettings ->  -- settings : TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
    Ptr Gtk.PageSetup.PageSetup ->          -- page_setup : TInterface (Name {namespace = "Gtk", name = "PageSetup"})
    IO (Ptr PrintJob)

-- | Creates a new @GtkPrintJob@.
printJobNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Printer.IsPrinter a, Gtk.PrintSettings.IsPrintSettings b, Gtk.PageSetup.IsPageSetup c) =>
    T.Text
    -- ^ /@title@/: the job title
    -> a
    -- ^ /@printer@/: a @GtkPrinter@
    -> b
    -- ^ /@settings@/: a @GtkPrintSettings@
    -> c
    -- ^ /@pageSetup@/: a @GtkPageSetup@
    -> m PrintJob
    -- ^ __Returns:__ a new @GtkPrintJob@
printJobNew title printer settings pageSetup = liftIO $ do
    title' <- textToCString title
    printer' <- unsafeManagedPtrCastPtr printer
    settings' <- unsafeManagedPtrCastPtr settings
    pageSetup' <- unsafeManagedPtrCastPtr pageSetup
    result <- gtk_print_job_new title' printer' settings' pageSetup'
    checkUnexpectedReturnNULL "printJobNew" result
    result' <- (wrapObject PrintJob) result
    touchManagedPtr printer
    touchManagedPtr settings
    touchManagedPtr pageSetup
    freeMem title'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PrintJob::get_collate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_collate" gtk_print_job_get_collate :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CInt

-- | Gets whether this job is printed collated.
printJobGetCollate ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Bool
    -- ^ __Returns:__ whether the job is printed collated
printJobGetCollate job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_collate job'
    let result' = (/= 0) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetCollateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetCollateMethodInfo a signature where
    overloadedMethod = printJobGetCollate

instance O.OverloadedMethodInfo PrintJobGetCollateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetCollate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetCollate"
        })


#endif

-- method PrintJob::get_n_up
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_n_up" gtk_print_job_get_n_up :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO Word32

-- | Gets the n-up setting for this job.
printJobGetNUp ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Word32
    -- ^ __Returns:__ the n-up setting
printJobGetNUp job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_n_up job'
    touchManagedPtr job
    return result

#if defined(ENABLE_OVERLOADING)
data PrintJobGetNUpMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetNUpMethodInfo a signature where
    overloadedMethod = printJobGetNUp

instance O.OverloadedMethodInfo PrintJobGetNUpMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetNUp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetNUp"
        })


#endif

-- method PrintJob::get_n_up_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "NumberUpLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_n_up_layout" gtk_print_job_get_n_up_layout :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CUInt

-- | Gets the n-up layout setting for this job.
printJobGetNUpLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.Enums.NumberUpLayout
    -- ^ __Returns:__ the n-up layout
printJobGetNUpLayout job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_n_up_layout job'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetNUpLayoutMethodInfo
instance (signature ~ (m Gtk.Enums.NumberUpLayout), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetNUpLayoutMethodInfo a signature where
    overloadedMethod = printJobGetNUpLayout

instance O.OverloadedMethodInfo PrintJobGetNUpLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetNUpLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetNUpLayout"
        })


#endif

-- method PrintJob::get_num_copies
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_num_copies" gtk_print_job_get_num_copies :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO Int32

-- | Gets the number of copies of this job.
printJobGetNumCopies ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Int32
    -- ^ __Returns:__ the number of copies
printJobGetNumCopies job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_num_copies job'
    touchManagedPtr job
    return result

#if defined(ENABLE_OVERLOADING)
data PrintJobGetNumCopiesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetNumCopiesMethodInfo a signature where
    overloadedMethod = printJobGetNumCopies

instance O.OverloadedMethodInfo PrintJobGetNumCopiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetNumCopies",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetNumCopies"
        })


#endif

-- method PrintJob::get_page_ranges
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_ranges"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the number of ranges"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_ranges"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "return location for the number of ranges"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just
--               (TCArray
--                  False
--                  (-1)
--                  1
--                  (TInterface Name { namespace = "Gtk" , name = "PageRange" }))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_page_ranges" gtk_print_job_get_page_ranges :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Ptr Int32 ->                            -- n_ranges : TBasicType TInt
    IO (Ptr Gtk.PageRange.PageRange)

-- | Gets the page ranges for this job.
printJobGetPageRanges ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m [Gtk.PageRange.PageRange]
    -- ^ __Returns:__ a pointer to an
    --   array of @GtkPageRange@ structs
printJobGetPageRanges job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    nRanges <- allocMem :: IO (Ptr Int32)
    result <- gtk_print_job_get_page_ranges job' nRanges
    nRanges' <- peek nRanges
    checkUnexpectedReturnNULL "printJobGetPageRanges" result
    result' <- (unpackBlockArrayWithLength 8 nRanges') result
    result'' <- mapM (newPtr Gtk.PageRange.PageRange) result'
    touchManagedPtr job
    freeMem nRanges
    return result''

#if defined(ENABLE_OVERLOADING)
data PrintJobGetPageRangesMethodInfo
instance (signature ~ (m [Gtk.PageRange.PageRange]), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetPageRangesMethodInfo a signature where
    overloadedMethod = printJobGetPageRanges

instance O.OverloadedMethodInfo PrintJobGetPageRangesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetPageRanges",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetPageRanges"
        })


#endif

-- method PrintJob::get_page_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PageSet" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_page_set" gtk_print_job_get_page_set :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CUInt

-- | Gets the @GtkPageSet@ setting for this job.
printJobGetPageSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.Enums.PageSet
    -- ^ __Returns:__ the @GtkPageSet@ setting
printJobGetPageSet job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_page_set job'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetPageSetMethodInfo
instance (signature ~ (m Gtk.Enums.PageSet), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetPageSetMethodInfo a signature where
    overloadedMethod = printJobGetPageSet

instance O.OverloadedMethodInfo PrintJobGetPageSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetPageSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetPageSet"
        })


#endif

-- method PrintJob::get_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PrintPages" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_pages" gtk_print_job_get_pages :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CUInt

-- | Gets the @GtkPrintPages@ setting for this job.
printJobGetPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.Enums.PrintPages
    -- ^ __Returns:__ the @GtkPrintPages@ setting
printJobGetPages job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_pages job'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetPagesMethodInfo
instance (signature ~ (m Gtk.Enums.PrintPages), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetPagesMethodInfo a signature where
    overloadedMethod = printJobGetPages

instance O.OverloadedMethodInfo PrintJobGetPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetPages"
        })


#endif

-- method PrintJob::get_printer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Printer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_printer" gtk_print_job_get_printer :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO (Ptr Gtk.Printer.Printer)

-- | Gets the @GtkPrinter@ of the print job.
printJobGetPrinter ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.Printer.Printer
    -- ^ __Returns:__ the printer of /@job@/
printJobGetPrinter job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_printer job'
    checkUnexpectedReturnNULL "printJobGetPrinter" result
    result' <- (newObject Gtk.Printer.Printer) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetPrinterMethodInfo
instance (signature ~ (m Gtk.Printer.Printer), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetPrinterMethodInfo a signature where
    overloadedMethod = printJobGetPrinter

instance O.OverloadedMethodInfo PrintJobGetPrinterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetPrinter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetPrinter"
        })


#endif

-- method PrintJob::get_reverse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_reverse" gtk_print_job_get_reverse :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CInt

-- | Gets whether this job is printed reversed.
printJobGetReverse ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Bool
    -- ^ __Returns:__ whether the job is printed reversed.
printJobGetReverse job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_reverse job'
    let result' = (/= 0) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetReverseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetReverseMethodInfo a signature where
    overloadedMethod = printJobGetReverse

instance O.OverloadedMethodInfo PrintJobGetReverseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetReverse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetReverse"
        })


#endif

-- method PrintJob::get_rotate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_rotate" gtk_print_job_get_rotate :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CInt

-- | Gets whether the job is printed rotated.
printJobGetRotate ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Bool
    -- ^ __Returns:__ whether the job is printed rotated
printJobGetRotate job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_rotate job'
    let result' = (/= 0) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetRotateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetRotateMethodInfo a signature where
    overloadedMethod = printJobGetRotate

instance O.OverloadedMethodInfo PrintJobGetRotateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetRotate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetRotate"
        })


#endif

-- method PrintJob::get_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_scale" gtk_print_job_get_scale :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CDouble

-- | Gets the scale for this job.
printJobGetScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Double
    -- ^ __Returns:__ the scale
printJobGetScale job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_scale job'
    let result' = realToFrac result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetScaleMethodInfo
instance (signature ~ (m Double), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetScaleMethodInfo a signature where
    overloadedMethod = printJobGetScale

instance O.OverloadedMethodInfo PrintJobGetScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetScale"
        })


#endif

-- method PrintJob::get_settings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PrintSettings" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_settings" gtk_print_job_get_settings :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO (Ptr Gtk.PrintSettings.PrintSettings)

-- | Gets the @GtkPrintSettings@ of the print job.
printJobGetSettings ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.PrintSettings.PrintSettings
    -- ^ __Returns:__ the settings of /@job@/
printJobGetSettings job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_settings job'
    checkUnexpectedReturnNULL "printJobGetSettings" result
    result' <- (newObject Gtk.PrintSettings.PrintSettings) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetSettingsMethodInfo
instance (signature ~ (m Gtk.PrintSettings.PrintSettings), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetSettingsMethodInfo a signature where
    overloadedMethod = printJobGetSettings

instance O.OverloadedMethodInfo PrintJobGetSettingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetSettings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetSettings"
        })


#endif

-- method PrintJob::get_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PrintStatus" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_status" gtk_print_job_get_status :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CUInt

-- | Gets the status of the print job.
printJobGetStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Gtk.Enums.PrintStatus
    -- ^ __Returns:__ the status of /@job@/
printJobGetStatus job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_status job'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetStatusMethodInfo
instance (signature ~ (m Gtk.Enums.PrintStatus), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetStatusMethodInfo a signature where
    overloadedMethod = printJobGetStatus

instance O.OverloadedMethodInfo PrintJobGetStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetStatus"
        })


#endif

-- method PrintJob::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Surface" })
-- throws : True
-- Skip return : False

foreign import ccall "gtk_print_job_get_surface" gtk_print_job_get_surface :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Cairo.Surface.Surface)

-- | Gets a cairo surface onto which the pages of
-- the print job should be rendered.
printJobGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Cairo.Surface.Surface
    -- ^ __Returns:__ the cairo surface of /@job@/ /(Can throw 'Data.GI.Base.GError.GError')/
printJobGetSurface job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    onException (do
        result <- propagateGError $ gtk_print_job_get_surface job'
        checkUnexpectedReturnNULL "printJobGetSurface" result
        result' <- (newBoxed Cairo.Surface.Surface) result
        touchManagedPtr job
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data PrintJobGetSurfaceMethodInfo
instance (signature ~ (m Cairo.Surface.Surface), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetSurfaceMethodInfo a signature where
    overloadedMethod = printJobGetSurface

instance O.OverloadedMethodInfo PrintJobGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetSurface"
        })


#endif

-- method PrintJob::get_title
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_title" gtk_print_job_get_title :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CString

-- | Gets the job title.
printJobGetTitle ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m T.Text
    -- ^ __Returns:__ the title of /@job@/
printJobGetTitle job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_title job'
    checkUnexpectedReturnNULL "printJobGetTitle" result
    result' <- cstringToText result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetTitleMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetTitleMethodInfo a signature where
    overloadedMethod = printJobGetTitle

instance O.OverloadedMethodInfo PrintJobGetTitleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetTitle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetTitle"
        })


#endif

-- method PrintJob::get_track_print_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_get_track_print_status" gtk_print_job_get_track_print_status :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    IO CInt

-- | Returns whether jobs will be tracked after printing.
-- 
-- For details, see 'GI.Gtk.Objects.PrintJob.printJobSetTrackPrintStatus'.
printJobGetTrackPrintStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if print job status will be reported after printing
printJobGetTrackPrintStatus job = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    result <- gtk_print_job_get_track_print_status job'
    let result' = (/= 0) result
    touchManagedPtr job
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintJobGetTrackPrintStatusMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobGetTrackPrintStatusMethodInfo a signature where
    overloadedMethod = printJobGetTrackPrintStatus

instance O.OverloadedMethodInfo PrintJobGetTrackPrintStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobGetTrackPrintStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobGetTrackPrintStatus"
        })


#endif

-- method PrintJob::send
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "PrintJobCompleteFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "function\n  to call when the job completes or an error occurs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 2
--           , argDestroy = 3
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data that gets passed to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dnotify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destroy notify for @user_data"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_send" gtk_print_job_send :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    FunPtr Gtk.Callbacks.C_PrintJobCompleteFunc -> -- callback : TInterface (Name {namespace = "Gtk", name = "PrintJobCompleteFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- dnotify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Sends the print job off to the printer.
printJobSend ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Gtk.Callbacks.PrintJobCompleteFunc
    -- ^ /@callback@/: function
    --   to call when the job completes or an error occurs
    -> m ()
printJobSend job callback = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    callback' <- Gtk.Callbacks.mk_PrintJobCompleteFunc (Gtk.Callbacks.wrap_PrintJobCompleteFunc Nothing (Gtk.Callbacks.drop_closures_PrintJobCompleteFunc callback))
    let userData = castFunPtrToPtr callback'
    let dnotify = SP.safeFreeFunPtrPtr
    gtk_print_job_send job' callback' userData dnotify
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSendMethodInfo
instance (signature ~ (Gtk.Callbacks.PrintJobCompleteFunc -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSendMethodInfo a signature where
    overloadedMethod = printJobSend

instance O.OverloadedMethodInfo PrintJobSendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSend"
        })


#endif

-- method PrintJob::set_collate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the job is printed collated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_collate" gtk_print_job_set_collate :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CInt ->                                 -- collate : TBasicType TBoolean
    IO ()

-- | Sets whether this job is printed collated.
printJobSetCollate ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Bool
    -- ^ /@collate@/: whether the job is printed collated
    -> m ()
printJobSetCollate job collate = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let collate' = (P.fromIntegral . P.fromEnum) collate
    gtk_print_job_set_collate job' collate'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetCollateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetCollateMethodInfo a signature where
    overloadedMethod = printJobSetCollate

instance O.OverloadedMethodInfo PrintJobSetCollateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetCollate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetCollate"
        })


#endif

-- method PrintJob::set_n_up
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_up"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the n-up value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_n_up" gtk_print_job_set_n_up :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Word32 ->                               -- n_up : TBasicType TUInt
    IO ()

-- | Sets the n-up setting for this job.
printJobSetNUp ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Word32
    -- ^ /@nUp@/: the n-up value
    -> m ()
printJobSetNUp job nUp = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    gtk_print_job_set_n_up job' nUp
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetNUpMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetNUpMethodInfo a signature where
    overloadedMethod = printJobSetNUp

instance O.OverloadedMethodInfo PrintJobSetNUpMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetNUp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetNUp"
        })


#endif

-- method PrintJob::set_n_up_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "layout"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NumberUpLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the n-up layout setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_n_up_layout" gtk_print_job_set_n_up_layout :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CUInt ->                                -- layout : TInterface (Name {namespace = "Gtk", name = "NumberUpLayout"})
    IO ()

-- | Sets the n-up layout setting for this job.
printJobSetNUpLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Gtk.Enums.NumberUpLayout
    -- ^ /@layout@/: the n-up layout setting
    -> m ()
printJobSetNUpLayout job layout = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let layout' = (fromIntegral . fromEnum) layout
    gtk_print_job_set_n_up_layout job' layout'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetNUpLayoutMethodInfo
instance (signature ~ (Gtk.Enums.NumberUpLayout -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetNUpLayoutMethodInfo a signature where
    overloadedMethod = printJobSetNUpLayout

instance O.OverloadedMethodInfo PrintJobSetNUpLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetNUpLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetNUpLayout"
        })


#endif

-- method PrintJob::set_num_copies
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "num_copies"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of copies"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_num_copies" gtk_print_job_set_num_copies :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Int32 ->                                -- num_copies : TBasicType TInt
    IO ()

-- | Sets the number of copies for this job.
printJobSetNumCopies ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Int32
    -- ^ /@numCopies@/: the number of copies
    -> m ()
printJobSetNumCopies job numCopies = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    gtk_print_job_set_num_copies job' numCopies
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetNumCopiesMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetNumCopiesMethodInfo a signature where
    overloadedMethod = printJobSetNumCopies

instance O.OverloadedMethodInfo PrintJobSetNumCopiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetNumCopies",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetNumCopies"
        })


#endif

-- method PrintJob::set_page_ranges
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ranges"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gtk" , name = "PageRange" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to an array of\n   `GtkPageRange` structs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_ranges"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of the @ranges array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_ranges"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of the @ranges array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_page_ranges" gtk_print_job_set_page_ranges :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Ptr Gtk.PageRange.PageRange ->          -- ranges : TCArray False (-1) 2 (TInterface (Name {namespace = "Gtk", name = "PageRange"}))
    Int32 ->                                -- n_ranges : TBasicType TInt
    IO ()

-- | Sets the page ranges for this job.
printJobSetPageRanges ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> [Gtk.PageRange.PageRange]
    -- ^ /@ranges@/: pointer to an array of
    --    @GtkPageRange@ structs
    -> m ()
printJobSetPageRanges job ranges = liftIO $ do
    let nRanges = fromIntegral $ P.length ranges
    job' <- unsafeManagedPtrCastPtr job
    ranges' <- mapM unsafeManagedPtrGetPtr ranges
    ranges'' <- packBlockArray 8 ranges'
    gtk_print_job_set_page_ranges job' ranges'' nRanges
    touchManagedPtr job
    mapM_ touchManagedPtr ranges
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetPageRangesMethodInfo
instance (signature ~ ([Gtk.PageRange.PageRange] -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetPageRangesMethodInfo a signature where
    overloadedMethod = printJobSetPageRanges

instance O.OverloadedMethodInfo PrintJobSetPageRangesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetPageRanges",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetPageRanges"
        })


#endif

-- method PrintJob::set_page_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_set"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSet" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSet` setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_page_set" gtk_print_job_set_page_set :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CUInt ->                                -- page_set : TInterface (Name {namespace = "Gtk", name = "PageSet"})
    IO ()

-- | Sets the @GtkPageSet@ setting for this job.
printJobSetPageSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Gtk.Enums.PageSet
    -- ^ /@pageSet@/: a @GtkPageSet@ setting
    -> m ()
printJobSetPageSet job pageSet = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let pageSet' = (fromIntegral . fromEnum) pageSet
    gtk_print_job_set_page_set job' pageSet'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetPageSetMethodInfo
instance (signature ~ (Gtk.Enums.PageSet -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetPageSetMethodInfo a signature where
    overloadedMethod = printJobSetPageSet

instance O.OverloadedMethodInfo PrintJobSetPageSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetPageSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetPageSet"
        })


#endif

-- method PrintJob::set_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pages"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintPages" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkPrintPages` setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_pages" gtk_print_job_set_pages :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CUInt ->                                -- pages : TInterface (Name {namespace = "Gtk", name = "PrintPages"})
    IO ()

-- | Sets the @GtkPrintPages@ setting for this job.
printJobSetPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Gtk.Enums.PrintPages
    -- ^ /@pages@/: the @GtkPrintPages@ setting
    -> m ()
printJobSetPages job pages = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let pages' = (fromIntegral . fromEnum) pages
    gtk_print_job_set_pages job' pages'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetPagesMethodInfo
instance (signature ~ (Gtk.Enums.PrintPages -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetPagesMethodInfo a signature where
    overloadedMethod = printJobSetPages

instance O.OverloadedMethodInfo PrintJobSetPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetPages"
        })


#endif

-- method PrintJob::set_reverse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "reverse"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the job is printed reversed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_reverse" gtk_print_job_set_reverse :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CInt ->                                 -- reverse : TBasicType TBoolean
    IO ()

-- | Sets whether this job is printed reversed.
printJobSetReverse ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Bool
    -- ^ /@reverse@/: whether the job is printed reversed
    -> m ()
printJobSetReverse job reverse = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let reverse' = (P.fromIntegral . P.fromEnum) reverse
    gtk_print_job_set_reverse job' reverse'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetReverseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetReverseMethodInfo a signature where
    overloadedMethod = printJobSetReverse

instance O.OverloadedMethodInfo PrintJobSetReverseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetReverse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetReverse"
        })


#endif

-- method PrintJob::set_rotate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rotate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to print rotated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_rotate" gtk_print_job_set_rotate :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CInt ->                                 -- rotate : TBasicType TBoolean
    IO ()

-- | Sets whether this job is printed rotated.
printJobSetRotate ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Bool
    -- ^ /@rotate@/: whether to print rotated
    -> m ()
printJobSetRotate job rotate = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let rotate' = (P.fromIntegral . P.fromEnum) rotate
    gtk_print_job_set_rotate job' rotate'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetRotateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetRotateMethodInfo a signature where
    overloadedMethod = printJobSetRotate

instance O.OverloadedMethodInfo PrintJobSetRotateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetRotate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetRotate"
        })


#endif

-- method PrintJob::set_scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scale"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scale" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_scale" gtk_print_job_set_scale :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CDouble ->                              -- scale : TBasicType TDouble
    IO ()

-- | Sets the scale for this job.
-- 
-- 1.0 means unscaled.
printJobSetScale ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Double
    -- ^ /@scale@/: the scale
    -> m ()
printJobSetScale job scale = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let scale' = realToFrac scale
    gtk_print_job_set_scale job' scale'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetScaleMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetScaleMethodInfo a signature where
    overloadedMethod = printJobSetScale

instance O.OverloadedMethodInfo PrintJobSetScaleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetScale"
        })


#endif

-- method PrintJob::set_source_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file descriptor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_print_job_set_source_fd" gtk_print_job_set_source_fd :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    Int32 ->                                -- fd : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Make the @GtkPrintJob@ send an existing document to the
-- printing system.
-- 
-- The file can be in any format understood by the platforms
-- printing system (typically PostScript, but on many platforms
-- PDF may work too). See 'GI.Gtk.Objects.Printer.printerAcceptsPdf' and
-- 'GI.Gtk.Objects.Printer.printerAcceptsPs'.
-- 
-- This is similar to 'GI.Gtk.Objects.PrintJob.printJobSetSourceFile',
-- but takes expects an open file descriptor for the file,
-- instead of a filename.
printJobSetSourceFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Int32
    -- ^ /@fd@/: a file descriptor
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
printJobSetSourceFd job fd = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    onException (do
        _ <- propagateGError $ gtk_print_job_set_source_fd job' fd
        touchManagedPtr job
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data PrintJobSetSourceFdMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetSourceFdMethodInfo a signature where
    overloadedMethod = printJobSetSourceFd

instance O.OverloadedMethodInfo PrintJobSetSourceFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetSourceFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetSourceFd"
        })


#endif

-- method PrintJob::set_source_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file to be printed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_print_job_set_source_file" gtk_print_job_set_source_file :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CString ->                              -- filename : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Make the @GtkPrintJob@ send an existing document to the
-- printing system.
-- 
-- The file can be in any format understood by the platforms
-- printing system (typically PostScript, but on many platforms
-- PDF may work too). See 'GI.Gtk.Objects.Printer.printerAcceptsPdf' and
-- 'GI.Gtk.Objects.Printer.printerAcceptsPs'.
printJobSetSourceFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> [Char]
    -- ^ /@filename@/: the file to be printed
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
printJobSetSourceFile job filename = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    filename' <- stringToCString filename
    onException (do
        _ <- propagateGError $ gtk_print_job_set_source_file job' filename'
        touchManagedPtr job
        freeMem filename'
        return ()
     ) (do
        freeMem filename'
     )

#if defined(ENABLE_OVERLOADING)
data PrintJobSetSourceFileMethodInfo
instance (signature ~ ([Char] -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetSourceFileMethodInfo a signature where
    overloadedMethod = printJobSetSourceFile

instance O.OverloadedMethodInfo PrintJobSetSourceFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetSourceFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetSourceFile"
        })


#endif

-- method PrintJob::set_track_print_status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintJob`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "track_status"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to track status after printing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_job_set_track_print_status" gtk_print_job_set_track_print_status :: 
    Ptr PrintJob ->                         -- job : TInterface (Name {namespace = "Gtk", name = "PrintJob"})
    CInt ->                                 -- track_status : TBasicType TBoolean
    IO ()

-- | If track_status is 'P.True', the print job will try to continue report
-- on the status of the print job in the printer queues and printer.
-- 
-- This can allow your application to show things like “out of paper”
-- issues, and when the print job actually reaches the printer.
-- 
-- This function is often implemented using some form of polling,
-- so it should not be enabled unless needed.
printJobSetTrackPrintStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintJob a) =>
    a
    -- ^ /@job@/: a @GtkPrintJob@
    -> Bool
    -- ^ /@trackStatus@/: 'P.True' to track status after printing
    -> m ()
printJobSetTrackPrintStatus job trackStatus = liftIO $ do
    job' <- unsafeManagedPtrCastPtr job
    let trackStatus' = (P.fromIntegral . P.fromEnum) trackStatus
    gtk_print_job_set_track_print_status job' trackStatus'
    touchManagedPtr job
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintJobSetTrackPrintStatusMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintJob a) => O.OverloadedMethod PrintJobSetTrackPrintStatusMethodInfo a signature where
    overloadedMethod = printJobSetTrackPrintStatus

instance O.OverloadedMethodInfo PrintJobSetTrackPrintStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintJob.printJobSetTrackPrintStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-PrintJob.html#v:printJobSetTrackPrintStatus"
        })


#endif


