{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Arranges its children in two panes, horizontally or vertically.
-- 
-- \<picture>
--   \<source srcset=\"panes-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPaned\" src=\"panes.png\">
-- \<\/picture>
-- 
-- The division between the two panes is adjustable by the user
-- by dragging a handle.
-- 
-- Child widgets are added to the panes of the widget with
-- 'GI.Gtk.Objects.Paned.panedSetStartChild' and 'GI.Gtk.Objects.Paned.panedSetEndChild'.
-- The division between the two children is set by default from the size
-- requests of the children, but it can be adjusted by the user.
-- 
-- A paned widget draws a separator between the two child widgets and a
-- small handle that the user can drag to adjust the division. It does not
-- draw any relief around the children or around the separator. (The space
-- in which the separator is called the gutter.) Often, it is useful to put
-- each child inside a t'GI.Gtk.Objects.Frame.Frame' so that the gutter appears as a
-- ridge. No separator is drawn if one of the children is missing.
-- 
-- Each child has two options that can be set, \"resize\" and \"shrink\". If
-- \"resize\" is true then, when the @GtkPaned@ is resized, that child will
-- expand or shrink along with the paned widget. If \"shrink\" is true, then
-- that child can be made smaller than its requisition by the user.
-- Setting \"shrink\" to false allows the application to set a minimum size.
-- If \"resize\" is false for both children, then this is treated as if
-- \"resize\" is true for both children.
-- 
-- The application can set the position of the slider as if it were set
-- by the user, by calling 'GI.Gtk.Objects.Paned.panedSetPosition'.
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [Paned::acceptPosition]("GI.Gtk.Objects.Paned#g:signal:acceptPosition")
-- * [Paned::cancelPosition]("GI.Gtk.Objects.Paned#g:signal:cancelPosition")
-- * [Paned::cycleChildFocus]("GI.Gtk.Objects.Paned#g:signal:cycleChildFocus")
-- * [Paned::cycleHandleFocus]("GI.Gtk.Objects.Paned#g:signal:cycleHandleFocus")
-- * [Paned::moveHandle]("GI.Gtk.Objects.Paned#g:signal:moveHandle")
-- * [Paned::toggleHandleFocus]("GI.Gtk.Objects.Paned#g:signal:toggleHandleFocus")
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >paned
-- >├── <child>
-- >├── separator[.wide]
-- >╰── <child>
-- 
-- 
-- @GtkPaned@ has a main CSS node with name paned, and a subnode for
-- the separator with name separator. The subnode gets a .wide style
-- class when the paned is supposed to be wide.
-- 
-- In horizontal orientation, the nodes are arranged based on the text
-- direction, so in left-to-right mode, :first-child will select the
-- leftmost child, while it will select the rightmost child in
-- RTL layouts.
-- 
-- == Creating a paned widget with minimum sizes.
-- 
-- 
-- === /c code/
-- >GtkWidget *hpaned = gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
-- >GtkWidget *frame1 = gtk_frame_new (NULL);
-- >GtkWidget *frame2 = gtk_frame_new (NULL);
-- >
-- >gtk_widget_set_size_request (hpaned, 200, -1);
-- >
-- >gtk_paned_set_start_child (GTK_PANED (hpaned), frame1);
-- >gtk_paned_set_resize_start_child (GTK_PANED (hpaned), TRUE);
-- >gtk_paned_set_shrink_start_child (GTK_PANED (hpaned), FALSE);
-- >gtk_widget_set_size_request (frame1, 50, -1);
-- >
-- >gtk_paned_set_end_child (GTK_PANED (hpaned), frame2);
-- >gtk_paned_set_resize_end_child (GTK_PANED (hpaned), FALSE);
-- >gtk_paned_set_shrink_end_child (GTK_PANED (hpaned), FALSE);
-- >gtk_widget_set_size_request (frame2, 50, -1);
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Paned
    ( 

-- * Exported types
    Paned(..)                               ,
    IsPaned                                 ,
    toPaned                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEndChild]("GI.Gtk.Objects.Paned#g:method:getEndChild"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPosition]("GI.Gtk.Objects.Paned#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizeEndChild]("GI.Gtk.Objects.Paned#g:method:getResizeEndChild"), [getResizeStartChild]("GI.Gtk.Objects.Paned#g:method:getResizeStartChild"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShrinkEndChild]("GI.Gtk.Objects.Paned#g:method:getShrinkEndChild"), [getShrinkStartChild]("GI.Gtk.Objects.Paned#g:method:getShrinkStartChild"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStartChild]("GI.Gtk.Objects.Paned#g:method:getStartChild"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWideHandle]("GI.Gtk.Objects.Paned#g:method:getWideHandle"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEndChild]("GI.Gtk.Objects.Paned#g:method:setEndChild"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPosition]("GI.Gtk.Objects.Paned#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizeEndChild]("GI.Gtk.Objects.Paned#g:method:setResizeEndChild"), [setResizeStartChild]("GI.Gtk.Objects.Paned#g:method:setResizeStartChild"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShrinkEndChild]("GI.Gtk.Objects.Paned#g:method:setShrinkEndChild"), [setShrinkStartChild]("GI.Gtk.Objects.Paned#g:method:setShrinkStartChild"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartChild]("GI.Gtk.Objects.Paned#g:method:setStartChild"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWideHandle]("GI.Gtk.Objects.Paned#g:method:setWideHandle").

#if defined(ENABLE_OVERLOADING)
    ResolvePanedMethod                      ,
#endif

-- ** getEndChild #method:getEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetEndChildMethodInfo              ,
#endif
    panedGetEndChild                        ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    PanedGetPositionMethodInfo              ,
#endif
    panedGetPosition                        ,


-- ** getResizeEndChild #method:getResizeEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetResizeEndChildMethodInfo        ,
#endif
    panedGetResizeEndChild                  ,


-- ** getResizeStartChild #method:getResizeStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetResizeStartChildMethodInfo      ,
#endif
    panedGetResizeStartChild                ,


-- ** getShrinkEndChild #method:getShrinkEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetShrinkEndChildMethodInfo        ,
#endif
    panedGetShrinkEndChild                  ,


-- ** getShrinkStartChild #method:getShrinkStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetShrinkStartChildMethodInfo      ,
#endif
    panedGetShrinkStartChild                ,


-- ** getStartChild #method:getStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedGetStartChildMethodInfo            ,
#endif
    panedGetStartChild                      ,


-- ** getWideHandle #method:getWideHandle#

#if defined(ENABLE_OVERLOADING)
    PanedGetWideHandleMethodInfo            ,
#endif
    panedGetWideHandle                      ,


-- ** new #method:new#

    panedNew                                ,


-- ** setEndChild #method:setEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetEndChildMethodInfo              ,
#endif
    panedSetEndChild                        ,


-- ** setPosition #method:setPosition#

#if defined(ENABLE_OVERLOADING)
    PanedSetPositionMethodInfo              ,
#endif
    panedSetPosition                        ,


-- ** setResizeEndChild #method:setResizeEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetResizeEndChildMethodInfo        ,
#endif
    panedSetResizeEndChild                  ,


-- ** setResizeStartChild #method:setResizeStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetResizeStartChildMethodInfo      ,
#endif
    panedSetResizeStartChild                ,


-- ** setShrinkEndChild #method:setShrinkEndChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetShrinkEndChildMethodInfo        ,
#endif
    panedSetShrinkEndChild                  ,


-- ** setShrinkStartChild #method:setShrinkStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetShrinkStartChildMethodInfo      ,
#endif
    panedSetShrinkStartChild                ,


-- ** setStartChild #method:setStartChild#

#if defined(ENABLE_OVERLOADING)
    PanedSetStartChildMethodInfo            ,
#endif
    panedSetStartChild                      ,


-- ** setWideHandle #method:setWideHandle#

#if defined(ENABLE_OVERLOADING)
    PanedSetWideHandleMethodInfo            ,
#endif
    panedSetWideHandle                      ,




 -- * Properties


-- ** endChild #attr:endChild#
-- | The second child.

#if defined(ENABLE_OVERLOADING)
    PanedEndChildPropertyInfo               ,
#endif
    clearPanedEndChild                      ,
    constructPanedEndChild                  ,
    getPanedEndChild                        ,
#if defined(ENABLE_OVERLOADING)
    panedEndChild                           ,
#endif
    setPanedEndChild                        ,


-- ** maxPosition #attr:maxPosition#
-- | The largest possible value for the [Paned:position]("GI.Gtk.Objects.Paned#g:attr:position")
-- property.
-- 
-- This property is derived from the size and shrinkability
-- of the widget\'s children.

#if defined(ENABLE_OVERLOADING)
    PanedMaxPositionPropertyInfo            ,
#endif
    getPanedMaxPosition                     ,
#if defined(ENABLE_OVERLOADING)
    panedMaxPosition                        ,
#endif


-- ** minPosition #attr:minPosition#
-- | The smallest possible value for the [Paned:position]("GI.Gtk.Objects.Paned#g:attr:position")
-- property.
-- 
-- This property is derived from the size and shrinkability
-- of the widget\'s children.

#if defined(ENABLE_OVERLOADING)
    PanedMinPositionPropertyInfo            ,
#endif
    getPanedMinPosition                     ,
#if defined(ENABLE_OVERLOADING)
    panedMinPosition                        ,
#endif


-- ** position #attr:position#
-- | Position of the separator in pixels, from the left\/top.

#if defined(ENABLE_OVERLOADING)
    PanedPositionPropertyInfo               ,
#endif
    constructPanedPosition                  ,
    getPanedPosition                        ,
#if defined(ENABLE_OVERLOADING)
    panedPosition                           ,
#endif
    setPanedPosition                        ,


-- ** positionSet #attr:positionSet#
-- | Whether the [Paned:position]("GI.Gtk.Objects.Paned#g:attr:position") property has been set.

#if defined(ENABLE_OVERLOADING)
    PanedPositionSetPropertyInfo            ,
#endif
    constructPanedPositionSet               ,
    getPanedPositionSet                     ,
#if defined(ENABLE_OVERLOADING)
    panedPositionSet                        ,
#endif
    setPanedPositionSet                     ,


-- ** resizeEndChild #attr:resizeEndChild#
-- | Determines whether the second child expands and shrinks
-- along with the paned widget.

#if defined(ENABLE_OVERLOADING)
    PanedResizeEndChildPropertyInfo         ,
#endif
    constructPanedResizeEndChild            ,
    getPanedResizeEndChild                  ,
#if defined(ENABLE_OVERLOADING)
    panedResizeEndChild                     ,
#endif
    setPanedResizeEndChild                  ,


-- ** resizeStartChild #attr:resizeStartChild#
-- | Determines whether the first child expands and shrinks
-- along with the paned widget.

#if defined(ENABLE_OVERLOADING)
    PanedResizeStartChildPropertyInfo       ,
#endif
    constructPanedResizeStartChild          ,
    getPanedResizeStartChild                ,
#if defined(ENABLE_OVERLOADING)
    panedResizeStartChild                   ,
#endif
    setPanedResizeStartChild                ,


-- ** shrinkEndChild #attr:shrinkEndChild#
-- | Determines whether the second child can be made smaller
-- than its requisition.

#if defined(ENABLE_OVERLOADING)
    PanedShrinkEndChildPropertyInfo         ,
#endif
    constructPanedShrinkEndChild            ,
    getPanedShrinkEndChild                  ,
#if defined(ENABLE_OVERLOADING)
    panedShrinkEndChild                     ,
#endif
    setPanedShrinkEndChild                  ,


-- ** shrinkStartChild #attr:shrinkStartChild#
-- | Determines whether the first child can be made smaller
-- than its requisition.

#if defined(ENABLE_OVERLOADING)
    PanedShrinkStartChildPropertyInfo       ,
#endif
    constructPanedShrinkStartChild          ,
    getPanedShrinkStartChild                ,
#if defined(ENABLE_OVERLOADING)
    panedShrinkStartChild                   ,
#endif
    setPanedShrinkStartChild                ,


-- ** startChild #attr:startChild#
-- | The first child.

#if defined(ENABLE_OVERLOADING)
    PanedStartChildPropertyInfo             ,
#endif
    clearPanedStartChild                    ,
    constructPanedStartChild                ,
    getPanedStartChild                      ,
#if defined(ENABLE_OVERLOADING)
    panedStartChild                         ,
#endif
    setPanedStartChild                      ,


-- ** wideHandle #attr:wideHandle#
-- | Whether the @GtkPaned@ should provide a stronger visual separation.
-- 
-- For example, this could be set when a paned contains two
-- t'GI.Gtk.Objects.Notebook.Notebook's, whose tab rows would otherwise merge visually.

#if defined(ENABLE_OVERLOADING)
    PanedWideHandlePropertyInfo             ,
#endif
    constructPanedWideHandle                ,
    getPanedWideHandle                      ,
#if defined(ENABLE_OVERLOADING)
    panedWideHandle                         ,
#endif
    setPanedWideHandle                      ,




 -- * Signals


-- ** acceptPosition #signal:acceptPosition#

    PanedAcceptPositionCallback             ,
#if defined(ENABLE_OVERLOADING)
    PanedAcceptPositionSignalInfo           ,
#endif
    afterPanedAcceptPosition                ,
    onPanedAcceptPosition                   ,


-- ** cancelPosition #signal:cancelPosition#

    PanedCancelPositionCallback             ,
#if defined(ENABLE_OVERLOADING)
    PanedCancelPositionSignalInfo           ,
#endif
    afterPanedCancelPosition                ,
    onPanedCancelPosition                   ,


-- ** cycleChildFocus #signal:cycleChildFocus#

    PanedCycleChildFocusCallback            ,
#if defined(ENABLE_OVERLOADING)
    PanedCycleChildFocusSignalInfo          ,
#endif
    afterPanedCycleChildFocus               ,
    onPanedCycleChildFocus                  ,


-- ** cycleHandleFocus #signal:cycleHandleFocus#

    PanedCycleHandleFocusCallback           ,
#if defined(ENABLE_OVERLOADING)
    PanedCycleHandleFocusSignalInfo         ,
#endif
    afterPanedCycleHandleFocus              ,
    onPanedCycleHandleFocus                 ,


-- ** moveHandle #signal:moveHandle#

    PanedMoveHandleCallback                 ,
#if defined(ENABLE_OVERLOADING)
    PanedMoveHandleSignalInfo               ,
#endif
    afterPanedMoveHandle                    ,
    onPanedMoveHandle                       ,


-- ** toggleHandleFocus #signal:toggleHandleFocus#

    PanedToggleHandleFocusCallback          ,
#if defined(ENABLE_OVERLOADING)
    PanedToggleHandleFocusSignalInfo        ,
#endif
    afterPanedToggleHandleFocus             ,
    onPanedToggleHandleFocus                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Paned = Paned (SP.ManagedPtr Paned)
    deriving (Eq)

instance SP.ManagedPtrNewtype Paned where
    toManagedPtr (Paned p) = p

foreign import ccall "gtk_paned_get_type"
    c_gtk_paned_get_type :: IO B.Types.GType

instance B.Types.TypedObject Paned where
    glibType = c_gtk_paned_get_type

instance B.Types.GObject Paned

-- | Type class for types which can be safely cast to t'Paned', for instance with `toPaned`.
class (SP.GObject o, O.IsDescendantOf Paned o) => IsPaned o
instance (SP.GObject o, O.IsDescendantOf Paned o) => IsPaned o

instance O.HasParentTypes Paned
type instance O.ParentTypes Paned = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to t'Paned', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPaned :: (MIO.MonadIO m, IsPaned o) => o -> m Paned
toPaned = MIO.liftIO . B.ManagedPtr.unsafeCastTo Paned

-- | Convert t'Paned' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Paned) where
    gvalueGType_ = c_gtk_paned_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Paned)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Paned)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Paned ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePanedMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePanedMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePanedMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePanedMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePanedMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePanedMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePanedMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePanedMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePanedMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePanedMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePanedMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePanedMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePanedMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePanedMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePanedMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePanedMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePanedMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePanedMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePanedMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePanedMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePanedMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePanedMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePanedMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePanedMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePanedMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePanedMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePanedMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePanedMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePanedMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePanedMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePanedMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePanedMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePanedMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePanedMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePanedMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePanedMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePanedMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePanedMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePanedMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePanedMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePanedMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePanedMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePanedMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePanedMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePanedMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePanedMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePanedMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePanedMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePanedMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePanedMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePanedMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePanedMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePanedMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePanedMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePanedMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePanedMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePanedMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePanedMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePanedMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePanedMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePanedMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePanedMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePanedMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePanedMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePanedMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePanedMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePanedMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePanedMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePanedMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePanedMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePanedMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePanedMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePanedMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePanedMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePanedMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePanedMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePanedMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePanedMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePanedMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePanedMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePanedMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePanedMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePanedMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePanedMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePanedMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePanedMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePanedMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePanedMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePanedMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePanedMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePanedMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePanedMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePanedMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePanedMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePanedMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePanedMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePanedMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePanedMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePanedMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePanedMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePanedMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePanedMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePanedMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePanedMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePanedMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePanedMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePanedMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePanedMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePanedMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePanedMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePanedMethod "getEndChild" o = PanedGetEndChildMethodInfo
    ResolvePanedMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePanedMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePanedMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePanedMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePanedMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePanedMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePanedMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePanedMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePanedMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePanedMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePanedMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePanedMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePanedMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePanedMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePanedMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePanedMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePanedMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePanedMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePanedMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePanedMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePanedMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePanedMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePanedMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePanedMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePanedMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePanedMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePanedMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolvePanedMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePanedMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePanedMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePanedMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePanedMethod "getPosition" o = PanedGetPositionMethodInfo
    ResolvePanedMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePanedMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePanedMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePanedMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePanedMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePanedMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePanedMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePanedMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePanedMethod "getResizeEndChild" o = PanedGetResizeEndChildMethodInfo
    ResolvePanedMethod "getResizeStartChild" o = PanedGetResizeStartChildMethodInfo
    ResolvePanedMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePanedMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePanedMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePanedMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePanedMethod "getShrinkEndChild" o = PanedGetShrinkEndChildMethodInfo
    ResolvePanedMethod "getShrinkStartChild" o = PanedGetShrinkStartChildMethodInfo
    ResolvePanedMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePanedMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePanedMethod "getStartChild" o = PanedGetStartChildMethodInfo
    ResolvePanedMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePanedMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePanedMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePanedMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePanedMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePanedMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePanedMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePanedMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePanedMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePanedMethod "getWideHandle" o = PanedGetWideHandleMethodInfo
    ResolvePanedMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePanedMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePanedMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePanedMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePanedMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePanedMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePanedMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePanedMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePanedMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePanedMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePanedMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePanedMethod "setEndChild" o = PanedSetEndChildMethodInfo
    ResolvePanedMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePanedMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePanedMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePanedMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePanedMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePanedMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePanedMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePanedMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePanedMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePanedMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePanedMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePanedMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePanedMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePanedMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePanedMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePanedMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePanedMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePanedMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolvePanedMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePanedMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePanedMethod "setPosition" o = PanedSetPositionMethodInfo
    ResolvePanedMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePanedMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePanedMethod "setResizeEndChild" o = PanedSetResizeEndChildMethodInfo
    ResolvePanedMethod "setResizeStartChild" o = PanedSetResizeStartChildMethodInfo
    ResolvePanedMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePanedMethod "setShrinkEndChild" o = PanedSetShrinkEndChildMethodInfo
    ResolvePanedMethod "setShrinkStartChild" o = PanedSetShrinkStartChildMethodInfo
    ResolvePanedMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePanedMethod "setStartChild" o = PanedSetStartChildMethodInfo
    ResolvePanedMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePanedMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePanedMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePanedMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePanedMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePanedMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePanedMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePanedMethod "setWideHandle" o = PanedSetWideHandleMethodInfo
    ResolvePanedMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePanedMethod t Paned, O.OverloadedMethod info Paned p) => OL.IsLabel t (Paned -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePanedMethod t Paned, O.OverloadedMethod info Paned p, R.HasField t Paned p) => R.HasField t Paned p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePanedMethod t Paned, O.OverloadedMethodInfo info Paned) => OL.IsLabel t (O.MethodProxy info Paned) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Paned::accept-position
-- | Emitted to accept the current position of the handle when
-- moving it using key bindings.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Return\<\/kbd> or
-- \<kbd>Space\<\/kbd>.
type PanedAcceptPositionCallback =
    IO Bool
    -- ^ __Returns:__ whether the position was accepted

type C_PanedAcceptPositionCallback =
    Ptr Paned ->                            -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedAcceptPositionCallback`.
foreign import ccall "wrapper"
    mk_PanedAcceptPositionCallback :: C_PanedAcceptPositionCallback -> IO (FunPtr C_PanedAcceptPositionCallback)

wrap_PanedAcceptPositionCallback :: 
    GObject a => (a -> PanedAcceptPositionCallback) ->
    C_PanedAcceptPositionCallback
wrap_PanedAcceptPositionCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [acceptPosition](#signal:acceptPosition) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #acceptPosition callback
-- @
-- 
-- 
onPanedAcceptPosition :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedAcceptPositionCallback) -> m SignalHandlerId
onPanedAcceptPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedAcceptPositionCallback wrapped
    wrapped'' <- mk_PanedAcceptPositionCallback wrapped'
    connectSignalFunPtr obj "accept-position" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [acceptPosition](#signal:acceptPosition) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #acceptPosition callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedAcceptPosition :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedAcceptPositionCallback) -> m SignalHandlerId
afterPanedAcceptPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedAcceptPositionCallback wrapped
    wrapped'' <- mk_PanedAcceptPositionCallback wrapped'
    connectSignalFunPtr obj "accept-position" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedAcceptPositionSignalInfo
instance SignalInfo PanedAcceptPositionSignalInfo where
    type HaskellCallbackType PanedAcceptPositionSignalInfo = PanedAcceptPositionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedAcceptPositionCallback cb
        cb'' <- mk_PanedAcceptPositionCallback cb'
        connectSignalFunPtr obj "accept-position" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::accept-position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:acceptPosition"})

#endif

-- signal Paned::cancel-position
-- | Emitted to cancel moving the position of the handle using key
-- bindings.
-- 
-- The position of the handle will be reset to the value prior to
-- moving it.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Escape\<\/kbd>.
type PanedCancelPositionCallback =
    IO Bool
    -- ^ __Returns:__ whether the position was canceled

type C_PanedCancelPositionCallback =
    Ptr Paned ->                            -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedCancelPositionCallback`.
foreign import ccall "wrapper"
    mk_PanedCancelPositionCallback :: C_PanedCancelPositionCallback -> IO (FunPtr C_PanedCancelPositionCallback)

wrap_PanedCancelPositionCallback :: 
    GObject a => (a -> PanedCancelPositionCallback) ->
    C_PanedCancelPositionCallback
wrap_PanedCancelPositionCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [cancelPosition](#signal:cancelPosition) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #cancelPosition callback
-- @
-- 
-- 
onPanedCancelPosition :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCancelPositionCallback) -> m SignalHandlerId
onPanedCancelPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCancelPositionCallback wrapped
    wrapped'' <- mk_PanedCancelPositionCallback wrapped'
    connectSignalFunPtr obj "cancel-position" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cancelPosition](#signal:cancelPosition) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #cancelPosition callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedCancelPosition :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCancelPositionCallback) -> m SignalHandlerId
afterPanedCancelPosition obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCancelPositionCallback wrapped
    wrapped'' <- mk_PanedCancelPositionCallback wrapped'
    connectSignalFunPtr obj "cancel-position" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedCancelPositionSignalInfo
instance SignalInfo PanedCancelPositionSignalInfo where
    type HaskellCallbackType PanedCancelPositionSignalInfo = PanedCancelPositionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedCancelPositionCallback cb
        cb'' <- mk_PanedCancelPositionCallback cb'
        connectSignalFunPtr obj "cancel-position" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::cancel-position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:cancelPosition"})

#endif

-- signal Paned::cycle-child-focus
-- | Emitted to cycle the focus between the children of the paned.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding is \<kbd>F6\<\/kbd>.
type PanedCycleChildFocusCallback =
    Bool
    -- ^ /@reversed@/: whether cycling backward or forward
    -> IO Bool
    -- ^ __Returns:__ whether the behavior was cycled

type C_PanedCycleChildFocusCallback =
    Ptr Paned ->                            -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedCycleChildFocusCallback`.
foreign import ccall "wrapper"
    mk_PanedCycleChildFocusCallback :: C_PanedCycleChildFocusCallback -> IO (FunPtr C_PanedCycleChildFocusCallback)

wrap_PanedCycleChildFocusCallback :: 
    GObject a => (a -> PanedCycleChildFocusCallback) ->
    C_PanedCycleChildFocusCallback
wrap_PanedCycleChildFocusCallback gi'cb gi'selfPtr reversed _ = do
    let reversed' = (/= 0) reversed
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  reversed'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [cycleChildFocus](#signal:cycleChildFocus) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #cycleChildFocus callback
-- @
-- 
-- 
onPanedCycleChildFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCycleChildFocusCallback) -> m SignalHandlerId
onPanedCycleChildFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCycleChildFocusCallback wrapped
    wrapped'' <- mk_PanedCycleChildFocusCallback wrapped'
    connectSignalFunPtr obj "cycle-child-focus" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cycleChildFocus](#signal:cycleChildFocus) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #cycleChildFocus callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedCycleChildFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCycleChildFocusCallback) -> m SignalHandlerId
afterPanedCycleChildFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCycleChildFocusCallback wrapped
    wrapped'' <- mk_PanedCycleChildFocusCallback wrapped'
    connectSignalFunPtr obj "cycle-child-focus" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedCycleChildFocusSignalInfo
instance SignalInfo PanedCycleChildFocusSignalInfo where
    type HaskellCallbackType PanedCycleChildFocusSignalInfo = PanedCycleChildFocusCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedCycleChildFocusCallback cb
        cb'' <- mk_PanedCycleChildFocusCallback cb'
        connectSignalFunPtr obj "cycle-child-focus" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::cycle-child-focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:cycleChildFocus"})

#endif

-- signal Paned::cycle-handle-focus
-- | Emitted to cycle whether the paned should grab focus to allow
-- the user to change position of the handle by using key bindings.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>F8\<\/kbd>.
type PanedCycleHandleFocusCallback =
    Bool
    -- ^ /@reversed@/: whether cycling backward or forward
    -> IO Bool
    -- ^ __Returns:__ whether the behavior was cycled

type C_PanedCycleHandleFocusCallback =
    Ptr Paned ->                            -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedCycleHandleFocusCallback`.
foreign import ccall "wrapper"
    mk_PanedCycleHandleFocusCallback :: C_PanedCycleHandleFocusCallback -> IO (FunPtr C_PanedCycleHandleFocusCallback)

wrap_PanedCycleHandleFocusCallback :: 
    GObject a => (a -> PanedCycleHandleFocusCallback) ->
    C_PanedCycleHandleFocusCallback
wrap_PanedCycleHandleFocusCallback gi'cb gi'selfPtr reversed _ = do
    let reversed' = (/= 0) reversed
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  reversed'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [cycleHandleFocus](#signal:cycleHandleFocus) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #cycleHandleFocus callback
-- @
-- 
-- 
onPanedCycleHandleFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCycleHandleFocusCallback) -> m SignalHandlerId
onPanedCycleHandleFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCycleHandleFocusCallback wrapped
    wrapped'' <- mk_PanedCycleHandleFocusCallback wrapped'
    connectSignalFunPtr obj "cycle-handle-focus" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cycleHandleFocus](#signal:cycleHandleFocus) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #cycleHandleFocus callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedCycleHandleFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedCycleHandleFocusCallback) -> m SignalHandlerId
afterPanedCycleHandleFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedCycleHandleFocusCallback wrapped
    wrapped'' <- mk_PanedCycleHandleFocusCallback wrapped'
    connectSignalFunPtr obj "cycle-handle-focus" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedCycleHandleFocusSignalInfo
instance SignalInfo PanedCycleHandleFocusSignalInfo where
    type HaskellCallbackType PanedCycleHandleFocusSignalInfo = PanedCycleHandleFocusCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedCycleHandleFocusCallback cb
        cb'' <- mk_PanedCycleHandleFocusCallback cb'
        connectSignalFunPtr obj "cycle-handle-focus" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::cycle-handle-focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:cycleHandleFocus"})

#endif

-- signal Paned::move-handle
-- | Emitted to move the handle with key bindings.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>←\<\/kbd>, \<kbd>←\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>→\<\/kbd>, \<kbd>→\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>↑\<\/kbd>, \<kbd>↑\<\/kbd>,
-- \<kbd>Ctrl\<\/kbd>+\<kbd>↓\<\/kbd>, \<kbd>↓\<\/kbd>,
-- \<kbd>PgUp\<\/kbd>, \<kbd>PgDn\<\/kbd>, \<kbd>Home\<\/kbd>, \<kbd>End\<\/kbd>.
type PanedMoveHandleCallback =
    Gtk.Enums.ScrollType
    -- ^ /@scrollType@/: a @GtkScrollType@
    -> IO Bool
    -- ^ __Returns:__ whether the handle was moved

type C_PanedMoveHandleCallback =
    Ptr Paned ->                            -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedMoveHandleCallback`.
foreign import ccall "wrapper"
    mk_PanedMoveHandleCallback :: C_PanedMoveHandleCallback -> IO (FunPtr C_PanedMoveHandleCallback)

wrap_PanedMoveHandleCallback :: 
    GObject a => (a -> PanedMoveHandleCallback) ->
    C_PanedMoveHandleCallback
wrap_PanedMoveHandleCallback gi'cb gi'selfPtr scrollType _ = do
    let scrollType' = (toEnum . fromIntegral) scrollType
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scrollType'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [moveHandle](#signal:moveHandle) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #moveHandle callback
-- @
-- 
-- 
onPanedMoveHandle :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedMoveHandleCallback) -> m SignalHandlerId
onPanedMoveHandle obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedMoveHandleCallback wrapped
    wrapped'' <- mk_PanedMoveHandleCallback wrapped'
    connectSignalFunPtr obj "move-handle" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveHandle](#signal:moveHandle) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #moveHandle callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedMoveHandle :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedMoveHandleCallback) -> m SignalHandlerId
afterPanedMoveHandle obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedMoveHandleCallback wrapped
    wrapped'' <- mk_PanedMoveHandleCallback wrapped'
    connectSignalFunPtr obj "move-handle" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedMoveHandleSignalInfo
instance SignalInfo PanedMoveHandleSignalInfo where
    type HaskellCallbackType PanedMoveHandleSignalInfo = PanedMoveHandleCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedMoveHandleCallback cb
        cb'' <- mk_PanedMoveHandleCallback cb'
        connectSignalFunPtr obj "move-handle" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::move-handle"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:moveHandle"})

#endif

-- signal Paned::toggle-handle-focus
-- | Emitted to accept the current position of the handle and then
-- move focus to the next widget in the focus chain.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding is \<kbd>Tab\<\/kbd>.
type PanedToggleHandleFocusCallback =
    IO Bool
    -- ^ __Returns:__ whether handle focus was toggled

type C_PanedToggleHandleFocusCallback =
    Ptr Paned ->                            -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_PanedToggleHandleFocusCallback`.
foreign import ccall "wrapper"
    mk_PanedToggleHandleFocusCallback :: C_PanedToggleHandleFocusCallback -> IO (FunPtr C_PanedToggleHandleFocusCallback)

wrap_PanedToggleHandleFocusCallback :: 
    GObject a => (a -> PanedToggleHandleFocusCallback) ->
    C_PanedToggleHandleFocusCallback
wrap_PanedToggleHandleFocusCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [toggleHandleFocus](#signal:toggleHandleFocus) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' paned #toggleHandleFocus callback
-- @
-- 
-- 
onPanedToggleHandleFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedToggleHandleFocusCallback) -> m SignalHandlerId
onPanedToggleHandleFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedToggleHandleFocusCallback wrapped
    wrapped'' <- mk_PanedToggleHandleFocusCallback wrapped'
    connectSignalFunPtr obj "toggle-handle-focus" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggleHandleFocus](#signal:toggleHandleFocus) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' paned #toggleHandleFocus callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPanedToggleHandleFocus :: (IsPaned a, MonadIO m) => a -> ((?self :: a) => PanedToggleHandleFocusCallback) -> m SignalHandlerId
afterPanedToggleHandleFocus obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PanedToggleHandleFocusCallback wrapped
    wrapped'' <- mk_PanedToggleHandleFocusCallback wrapped'
    connectSignalFunPtr obj "toggle-handle-focus" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PanedToggleHandleFocusSignalInfo
instance SignalInfo PanedToggleHandleFocusSignalInfo where
    type HaskellCallbackType PanedToggleHandleFocusSignalInfo = PanedToggleHandleFocusCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PanedToggleHandleFocusCallback cb
        cb'' <- mk_PanedToggleHandleFocusCallback cb'
        connectSignalFunPtr obj "toggle-handle-focus" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned::toggle-handle-focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:signal:toggleHandleFocus"})

#endif

-- VVV Prop "end-child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #endChild
-- @
getPanedEndChild :: (MonadIO m, IsPaned o) => o -> m (Maybe Gtk.Widget.Widget)
getPanedEndChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "end-child" Gtk.Widget.Widget

-- | Set the value of the “@end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #endChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedEndChild :: (MonadIO m, IsPaned o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setPanedEndChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "end-child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@end-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedEndChild :: (IsPaned o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructPanedEndChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "end-child" (P.Just val)

-- | Set the value of the “@end-child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #endChild
-- @
clearPanedEndChild :: (MonadIO m, IsPaned o) => o -> m ()
clearPanedEndChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "end-child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data PanedEndChildPropertyInfo
instance AttrInfo PanedEndChildPropertyInfo where
    type AttrAllowedOps PanedEndChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PanedEndChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedEndChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint PanedEndChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType PanedEndChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType PanedEndChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel PanedEndChildPropertyInfo = "end-child"
    type AttrOrigin PanedEndChildPropertyInfo = Paned
    attrGet = getPanedEndChild
    attrSet = setPanedEndChild
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructPanedEndChild
    attrClear = clearPanedEndChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.endChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:endChild"
        })
#endif

-- VVV Prop "max-position"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@max-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #maxPosition
-- @
getPanedMaxPosition :: (MonadIO m, IsPaned o) => o -> m Int32
getPanedMaxPosition obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "max-position"

#if defined(ENABLE_OVERLOADING)
data PanedMaxPositionPropertyInfo
instance AttrInfo PanedMaxPositionPropertyInfo where
    type AttrAllowedOps PanedMaxPositionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PanedMaxPositionPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedMaxPositionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PanedMaxPositionPropertyInfo = (~) ()
    type AttrTransferType PanedMaxPositionPropertyInfo = ()
    type AttrGetType PanedMaxPositionPropertyInfo = Int32
    type AttrLabel PanedMaxPositionPropertyInfo = "max-position"
    type AttrOrigin PanedMaxPositionPropertyInfo = Paned
    attrGet = getPanedMaxPosition
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.maxPosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:maxPosition"
        })
#endif

-- VVV Prop "min-position"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@min-position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #minPosition
-- @
getPanedMinPosition :: (MonadIO m, IsPaned o) => o -> m Int32
getPanedMinPosition obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "min-position"

#if defined(ENABLE_OVERLOADING)
data PanedMinPositionPropertyInfo
instance AttrInfo PanedMinPositionPropertyInfo where
    type AttrAllowedOps PanedMinPositionPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PanedMinPositionPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedMinPositionPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PanedMinPositionPropertyInfo = (~) ()
    type AttrTransferType PanedMinPositionPropertyInfo = ()
    type AttrGetType PanedMinPositionPropertyInfo = Int32
    type AttrLabel PanedMinPositionPropertyInfo = "min-position"
    type AttrOrigin PanedMinPositionPropertyInfo = Paned
    attrGet = getPanedMinPosition
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.minPosition"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:minPosition"
        })
#endif

-- VVV Prop "position"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #position
-- @
getPanedPosition :: (MonadIO m, IsPaned o) => o -> m Int32
getPanedPosition obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "position"

-- | Set the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #position 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedPosition :: (MonadIO m, IsPaned o) => o -> Int32 -> m ()
setPanedPosition obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "position" val

-- | Construct a t'GValueConstruct' with valid value for the “@position@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedPosition :: (IsPaned o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructPanedPosition val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "position" val

#if defined(ENABLE_OVERLOADING)
data PanedPositionPropertyInfo
instance AttrInfo PanedPositionPropertyInfo where
    type AttrAllowedOps PanedPositionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedPositionPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedPositionPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint PanedPositionPropertyInfo = (~) Int32
    type AttrTransferType PanedPositionPropertyInfo = Int32
    type AttrGetType PanedPositionPropertyInfo = Int32
    type AttrLabel PanedPositionPropertyInfo = "position"
    type AttrOrigin PanedPositionPropertyInfo = Paned
    attrGet = getPanedPosition
    attrSet = setPanedPosition
    attrPut = setPanedPosition
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedPosition
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:position"
        })
#endif

-- VVV Prop "position-set"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@position-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #positionSet
-- @
getPanedPositionSet :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedPositionSet obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "position-set"

-- | Set the value of the “@position-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #positionSet 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedPositionSet :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedPositionSet obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "position-set" val

-- | Construct a t'GValueConstruct' with valid value for the “@position-set@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedPositionSet :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedPositionSet val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "position-set" val

#if defined(ENABLE_OVERLOADING)
data PanedPositionSetPropertyInfo
instance AttrInfo PanedPositionSetPropertyInfo where
    type AttrAllowedOps PanedPositionSetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedPositionSetPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedPositionSetPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedPositionSetPropertyInfo = (~) Bool
    type AttrTransferType PanedPositionSetPropertyInfo = Bool
    type AttrGetType PanedPositionSetPropertyInfo = Bool
    type AttrLabel PanedPositionSetPropertyInfo = "position-set"
    type AttrOrigin PanedPositionSetPropertyInfo = Paned
    attrGet = getPanedPositionSet
    attrSet = setPanedPositionSet
    attrPut = setPanedPositionSet
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedPositionSet
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.positionSet"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:positionSet"
        })
#endif

-- VVV Prop "resize-end-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@resize-end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #resizeEndChild
-- @
getPanedResizeEndChild :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedResizeEndChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "resize-end-child"

-- | Set the value of the “@resize-end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #resizeEndChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedResizeEndChild :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedResizeEndChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "resize-end-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@resize-end-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedResizeEndChild :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedResizeEndChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "resize-end-child" val

#if defined(ENABLE_OVERLOADING)
data PanedResizeEndChildPropertyInfo
instance AttrInfo PanedResizeEndChildPropertyInfo where
    type AttrAllowedOps PanedResizeEndChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedResizeEndChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedResizeEndChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedResizeEndChildPropertyInfo = (~) Bool
    type AttrTransferType PanedResizeEndChildPropertyInfo = Bool
    type AttrGetType PanedResizeEndChildPropertyInfo = Bool
    type AttrLabel PanedResizeEndChildPropertyInfo = "resize-end-child"
    type AttrOrigin PanedResizeEndChildPropertyInfo = Paned
    attrGet = getPanedResizeEndChild
    attrSet = setPanedResizeEndChild
    attrPut = setPanedResizeEndChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedResizeEndChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.resizeEndChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:resizeEndChild"
        })
#endif

-- VVV Prop "resize-start-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@resize-start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #resizeStartChild
-- @
getPanedResizeStartChild :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedResizeStartChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "resize-start-child"

-- | Set the value of the “@resize-start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #resizeStartChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedResizeStartChild :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedResizeStartChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "resize-start-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@resize-start-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedResizeStartChild :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedResizeStartChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "resize-start-child" val

#if defined(ENABLE_OVERLOADING)
data PanedResizeStartChildPropertyInfo
instance AttrInfo PanedResizeStartChildPropertyInfo where
    type AttrAllowedOps PanedResizeStartChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedResizeStartChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedResizeStartChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedResizeStartChildPropertyInfo = (~) Bool
    type AttrTransferType PanedResizeStartChildPropertyInfo = Bool
    type AttrGetType PanedResizeStartChildPropertyInfo = Bool
    type AttrLabel PanedResizeStartChildPropertyInfo = "resize-start-child"
    type AttrOrigin PanedResizeStartChildPropertyInfo = Paned
    attrGet = getPanedResizeStartChild
    attrSet = setPanedResizeStartChild
    attrPut = setPanedResizeStartChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedResizeStartChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.resizeStartChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:resizeStartChild"
        })
#endif

-- VVV Prop "shrink-end-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@shrink-end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #shrinkEndChild
-- @
getPanedShrinkEndChild :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedShrinkEndChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shrink-end-child"

-- | Set the value of the “@shrink-end-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #shrinkEndChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedShrinkEndChild :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedShrinkEndChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "shrink-end-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@shrink-end-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedShrinkEndChild :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedShrinkEndChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "shrink-end-child" val

#if defined(ENABLE_OVERLOADING)
data PanedShrinkEndChildPropertyInfo
instance AttrInfo PanedShrinkEndChildPropertyInfo where
    type AttrAllowedOps PanedShrinkEndChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedShrinkEndChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedShrinkEndChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedShrinkEndChildPropertyInfo = (~) Bool
    type AttrTransferType PanedShrinkEndChildPropertyInfo = Bool
    type AttrGetType PanedShrinkEndChildPropertyInfo = Bool
    type AttrLabel PanedShrinkEndChildPropertyInfo = "shrink-end-child"
    type AttrOrigin PanedShrinkEndChildPropertyInfo = Paned
    attrGet = getPanedShrinkEndChild
    attrSet = setPanedShrinkEndChild
    attrPut = setPanedShrinkEndChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedShrinkEndChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.shrinkEndChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:shrinkEndChild"
        })
#endif

-- VVV Prop "shrink-start-child"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@shrink-start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #shrinkStartChild
-- @
getPanedShrinkStartChild :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedShrinkStartChild obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shrink-start-child"

-- | Set the value of the “@shrink-start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #shrinkStartChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedShrinkStartChild :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedShrinkStartChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "shrink-start-child" val

-- | Construct a t'GValueConstruct' with valid value for the “@shrink-start-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedShrinkStartChild :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedShrinkStartChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "shrink-start-child" val

#if defined(ENABLE_OVERLOADING)
data PanedShrinkStartChildPropertyInfo
instance AttrInfo PanedShrinkStartChildPropertyInfo where
    type AttrAllowedOps PanedShrinkStartChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedShrinkStartChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedShrinkStartChildPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedShrinkStartChildPropertyInfo = (~) Bool
    type AttrTransferType PanedShrinkStartChildPropertyInfo = Bool
    type AttrGetType PanedShrinkStartChildPropertyInfo = Bool
    type AttrLabel PanedShrinkStartChildPropertyInfo = "shrink-start-child"
    type AttrOrigin PanedShrinkStartChildPropertyInfo = Paned
    attrGet = getPanedShrinkStartChild
    attrSet = setPanedShrinkStartChild
    attrPut = setPanedShrinkStartChild
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedShrinkStartChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.shrinkStartChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:shrinkStartChild"
        })
#endif

-- VVV Prop "start-child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #startChild
-- @
getPanedStartChild :: (MonadIO m, IsPaned o) => o -> m (Maybe Gtk.Widget.Widget)
getPanedStartChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "start-child" Gtk.Widget.Widget

-- | Set the value of the “@start-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #startChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedStartChild :: (MonadIO m, IsPaned o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setPanedStartChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "start-child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@start-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedStartChild :: (IsPaned o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructPanedStartChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "start-child" (P.Just val)

-- | Set the value of the “@start-child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #startChild
-- @
clearPanedStartChild :: (MonadIO m, IsPaned o) => o -> m ()
clearPanedStartChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "start-child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data PanedStartChildPropertyInfo
instance AttrInfo PanedStartChildPropertyInfo where
    type AttrAllowedOps PanedStartChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PanedStartChildPropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedStartChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint PanedStartChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType PanedStartChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType PanedStartChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel PanedStartChildPropertyInfo = "start-child"
    type AttrOrigin PanedStartChildPropertyInfo = Paned
    attrGet = getPanedStartChild
    attrSet = setPanedStartChild
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructPanedStartChild
    attrClear = clearPanedStartChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.startChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:startChild"
        })
#endif

-- VVV Prop "wide-handle"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@wide-handle@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' paned #wideHandle
-- @
getPanedWideHandle :: (MonadIO m, IsPaned o) => o -> m Bool
getPanedWideHandle obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "wide-handle"

-- | Set the value of the “@wide-handle@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' paned [ #wideHandle 'Data.GI.Base.Attributes.:=' value ]
-- @
setPanedWideHandle :: (MonadIO m, IsPaned o) => o -> Bool -> m ()
setPanedWideHandle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "wide-handle" val

-- | Construct a t'GValueConstruct' with valid value for the “@wide-handle@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPanedWideHandle :: (IsPaned o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPanedWideHandle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "wide-handle" val

#if defined(ENABLE_OVERLOADING)
data PanedWideHandlePropertyInfo
instance AttrInfo PanedWideHandlePropertyInfo where
    type AttrAllowedOps PanedWideHandlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint PanedWideHandlePropertyInfo = IsPaned
    type AttrSetTypeConstraint PanedWideHandlePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PanedWideHandlePropertyInfo = (~) Bool
    type AttrTransferType PanedWideHandlePropertyInfo = Bool
    type AttrGetType PanedWideHandlePropertyInfo = Bool
    type AttrLabel PanedWideHandlePropertyInfo = "wide-handle"
    type AttrOrigin PanedWideHandlePropertyInfo = Paned
    attrGet = getPanedWideHandle
    attrSet = setPanedWideHandle
    attrPut = setPanedWideHandle
    attrTransfer _ v = do
        return v
    attrConstruct = constructPanedWideHandle
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.wideHandle"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#g:attr:wideHandle"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Paned
type instance O.AttributeList Paned = PanedAttributeList
type PanedAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("endChild", PanedEndChildPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxPosition", PanedMaxPositionPropertyInfo), '("minPosition", PanedMinPositionPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("position", PanedPositionPropertyInfo), '("positionSet", PanedPositionSetPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizeEndChild", PanedResizeEndChildPropertyInfo), '("resizeStartChild", PanedResizeStartChildPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("shrinkEndChild", PanedShrinkEndChildPropertyInfo), '("shrinkStartChild", PanedShrinkStartChildPropertyInfo), '("startChild", PanedStartChildPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("wideHandle", PanedWideHandlePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
panedEndChild :: AttrLabelProxy "endChild"
panedEndChild = AttrLabelProxy

panedMaxPosition :: AttrLabelProxy "maxPosition"
panedMaxPosition = AttrLabelProxy

panedMinPosition :: AttrLabelProxy "minPosition"
panedMinPosition = AttrLabelProxy

panedPosition :: AttrLabelProxy "position"
panedPosition = AttrLabelProxy

panedPositionSet :: AttrLabelProxy "positionSet"
panedPositionSet = AttrLabelProxy

panedResizeEndChild :: AttrLabelProxy "resizeEndChild"
panedResizeEndChild = AttrLabelProxy

panedResizeStartChild :: AttrLabelProxy "resizeStartChild"
panedResizeStartChild = AttrLabelProxy

panedShrinkEndChild :: AttrLabelProxy "shrinkEndChild"
panedShrinkEndChild = AttrLabelProxy

panedShrinkStartChild :: AttrLabelProxy "shrinkStartChild"
panedShrinkStartChild = AttrLabelProxy

panedStartChild :: AttrLabelProxy "startChild"
panedStartChild = AttrLabelProxy

panedWideHandle :: AttrLabelProxy "wideHandle"
panedWideHandle = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Paned = PanedSignalList
type PanedSignalList = ('[ '("acceptPosition", PanedAcceptPositionSignalInfo), '("cancelPosition", PanedCancelPositionSignalInfo), '("cycleChildFocus", PanedCycleChildFocusSignalInfo), '("cycleHandleFocus", PanedCycleHandleFocusSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveHandle", PanedMoveHandleSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("toggleHandleFocus", PanedToggleHandleFocusSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Paned::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "orientation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Orientation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the paned\8217s orientation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Paned" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_new" gtk_paned_new :: 
    CUInt ->                                -- orientation : TInterface (Name {namespace = "Gtk", name = "Orientation"})
    IO (Ptr Paned)

-- | Creates a new @GtkPaned@ widget.
panedNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Enums.Orientation
    -- ^ /@orientation@/: the paned’s orientation.
    -> m Paned
    -- ^ __Returns:__ the newly created paned widget
panedNew orientation = liftIO $ do
    let orientation' = (fromIntegral . fromEnum) orientation
    result <- gtk_paned_new orientation'
    checkUnexpectedReturnNULL "panedNew" result
    result' <- (newObject Paned) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Paned::get_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_end_child" gtk_paned_get_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the end child of the given @GtkPaned@.
panedGetEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the end child widget
panedGetEndChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_end_child paned'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr paned
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PanedGetEndChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetEndChildMethodInfo a signature where
    overloadedMethod = panedGetEndChild

instance O.OverloadedMethodInfo PanedGetEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetEndChild"
        })


#endif

-- method Paned::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_position" gtk_paned_get_position :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO Int32

-- | Obtains the position of the divider between the two panes.
panedGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@ widget
    -> m Int32
    -- ^ __Returns:__ the position of the divider, in pixels
panedGetPosition paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_position paned'
    touchManagedPtr paned
    return result

#if defined(ENABLE_OVERLOADING)
data PanedGetPositionMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetPositionMethodInfo a signature where
    overloadedMethod = panedGetPosition

instance O.OverloadedMethodInfo PanedGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetPosition"
        })


#endif

-- method Paned::get_resize_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_resize_end_child" gtk_paned_get_resize_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO CInt

-- | Returns whether the [Paned:endChild]("GI.Gtk.Objects.Paned#g:attr:endChild") can be resized.
panedGetResizeEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m Bool
    -- ^ __Returns:__ true if the end child is resizable
panedGetResizeEndChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_resize_end_child paned'
    let result' = (/= 0) result
    touchManagedPtr paned
    return result'

#if defined(ENABLE_OVERLOADING)
data PanedGetResizeEndChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetResizeEndChildMethodInfo a signature where
    overloadedMethod = panedGetResizeEndChild

instance O.OverloadedMethodInfo PanedGetResizeEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetResizeEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetResizeEndChild"
        })


#endif

-- method Paned::get_resize_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_resize_start_child" gtk_paned_get_resize_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO CInt

-- | Returns whether the [Paned:startChild]("GI.Gtk.Objects.Paned#g:attr:startChild") can be resized.
panedGetResizeStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m Bool
    -- ^ __Returns:__ true if the start child is resizable
panedGetResizeStartChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_resize_start_child paned'
    let result' = (/= 0) result
    touchManagedPtr paned
    return result'

#if defined(ENABLE_OVERLOADING)
data PanedGetResizeStartChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetResizeStartChildMethodInfo a signature where
    overloadedMethod = panedGetResizeStartChild

instance O.OverloadedMethodInfo PanedGetResizeStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetResizeStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetResizeStartChild"
        })


#endif

-- method Paned::get_shrink_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_shrink_end_child" gtk_paned_get_shrink_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO CInt

-- | Returns whether the [Paned:endChild]("GI.Gtk.Objects.Paned#g:attr:endChild") can shrink.
panedGetShrinkEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m Bool
    -- ^ __Returns:__ true if the end child is shrinkable
panedGetShrinkEndChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_shrink_end_child paned'
    let result' = (/= 0) result
    touchManagedPtr paned
    return result'

#if defined(ENABLE_OVERLOADING)
data PanedGetShrinkEndChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetShrinkEndChildMethodInfo a signature where
    overloadedMethod = panedGetShrinkEndChild

instance O.OverloadedMethodInfo PanedGetShrinkEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetShrinkEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetShrinkEndChild"
        })


#endif

-- method Paned::get_shrink_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_shrink_start_child" gtk_paned_get_shrink_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO CInt

-- | Returns whether the [Paned:startChild]("GI.Gtk.Objects.Paned#g:attr:startChild") can shrink.
panedGetShrinkStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m Bool
    -- ^ __Returns:__ true if the start child is shrinkable
panedGetShrinkStartChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_shrink_start_child paned'
    let result' = (/= 0) result
    touchManagedPtr paned
    return result'

#if defined(ENABLE_OVERLOADING)
data PanedGetShrinkStartChildMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetShrinkStartChildMethodInfo a signature where
    overloadedMethod = panedGetShrinkStartChild

instance O.OverloadedMethodInfo PanedGetShrinkStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetShrinkStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetShrinkStartChild"
        })


#endif

-- method Paned::get_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_start_child" gtk_paned_get_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the start child of the given @GtkPaned@.
panedGetStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the start child widget
panedGetStartChild paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_start_child paned'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr paned
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PanedGetStartChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetStartChildMethodInfo a signature where
    overloadedMethod = panedGetStartChild

instance O.OverloadedMethodInfo PanedGetStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetStartChild"
        })


#endif

-- method Paned::get_wide_handle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_get_wide_handle" gtk_paned_get_wide_handle :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    IO CInt

-- | Gets whether the separator should be wide.
panedGetWideHandle ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the paned should have a wide handle
panedGetWideHandle paned = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    result <- gtk_paned_get_wide_handle paned'
    let result' = (/= 0) result
    touchManagedPtr paned
    return result'

#if defined(ENABLE_OVERLOADING)
data PanedGetWideHandleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPaned a) => O.OverloadedMethod PanedGetWideHandleMethodInfo a signature where
    overloadedMethod = panedGetWideHandle

instance O.OverloadedMethodInfo PanedGetWideHandleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedGetWideHandle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedGetWideHandle"
        })


#endif

-- method Paned::set_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_end_child" gtk_paned_set_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the end child of /@paned@/ to /@child@/.
-- 
-- If /@child@/ is @NULL@, the existing child will be removed.
panedSetEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Maybe (b)
    -- ^ /@child@/: the widget to add
    -> m ()
panedSetEndChild paned child = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_paned_set_end_child paned' maybeChild
    touchManagedPtr paned
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetEndChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPaned a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PanedSetEndChildMethodInfo a signature where
    overloadedMethod = panedSetEndChild

instance O.OverloadedMethodInfo PanedSetEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetEndChild"
        })


#endif

-- method Paned::set_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "pixel position of divider, a negative value means that the position\n  is unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_position" gtk_paned_set_position :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    Int32 ->                                -- position : TBasicType TInt
    IO ()

-- | Sets the position of the divider between the two panes.
panedSetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@ widget
    -> Int32
    -- ^ /@position@/: pixel position of divider, a negative value means that the position
    --   is unset
    -> m ()
panedSetPosition paned position = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    gtk_paned_set_position paned' position
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetPositionMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetPositionMethodInfo a signature where
    overloadedMethod = panedSetPosition

instance O.OverloadedMethodInfo PanedSetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetPosition"
        })


#endif

-- method Paned::set_resize_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resize"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to let the end child be resized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_resize_end_child" gtk_paned_set_resize_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    CInt ->                                 -- resize : TBasicType TBoolean
    IO ()

-- | Sets whether the [Paned:endChild]("GI.Gtk.Objects.Paned#g:attr:endChild") can be resized.
panedSetResizeEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Bool
    -- ^ /@resize@/: true to let the end child be resized
    -> m ()
panedSetResizeEndChild paned resize = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    let resize' = (P.fromIntegral . P.fromEnum) resize
    gtk_paned_set_resize_end_child paned' resize'
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetResizeEndChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetResizeEndChildMethodInfo a signature where
    overloadedMethod = panedSetResizeEndChild

instance O.OverloadedMethodInfo PanedSetResizeEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetResizeEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetResizeEndChild"
        })


#endif

-- method Paned::set_resize_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resize"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to let the start child be resized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_resize_start_child" gtk_paned_set_resize_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    CInt ->                                 -- resize : TBasicType TBoolean
    IO ()

-- | Sets whether the [Paned:startChild]("GI.Gtk.Objects.Paned#g:attr:startChild") can be resized.
panedSetResizeStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Bool
    -- ^ /@resize@/: true to let the start child be resized
    -> m ()
panedSetResizeStartChild paned resize = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    let resize' = (P.fromIntegral . P.fromEnum) resize
    gtk_paned_set_resize_start_child paned' resize'
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetResizeStartChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetResizeStartChildMethodInfo a signature where
    overloadedMethod = panedSetResizeStartChild

instance O.OverloadedMethodInfo PanedSetResizeStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetResizeStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetResizeStartChild"
        })


#endif

-- method Paned::set_shrink_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resize"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to let the end child be shrunk"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_shrink_end_child" gtk_paned_set_shrink_end_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    CInt ->                                 -- resize : TBasicType TBoolean
    IO ()

-- | Sets whether the [Paned:endChild]("GI.Gtk.Objects.Paned#g:attr:endChild") can shrink.
panedSetShrinkEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Bool
    -- ^ /@resize@/: true to let the end child be shrunk
    -> m ()
panedSetShrinkEndChild paned resize = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    let resize' = (P.fromIntegral . P.fromEnum) resize
    gtk_paned_set_shrink_end_child paned' resize'
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetShrinkEndChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetShrinkEndChildMethodInfo a signature where
    overloadedMethod = panedSetShrinkEndChild

instance O.OverloadedMethodInfo PanedSetShrinkEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetShrinkEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetShrinkEndChild"
        })


#endif

-- method Paned::set_shrink_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resize"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to let the start child be shrunk"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_shrink_start_child" gtk_paned_set_shrink_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    CInt ->                                 -- resize : TBasicType TBoolean
    IO ()

-- | Sets whether the [Paned:startChild]("GI.Gtk.Objects.Paned#g:attr:startChild") can shrink.
panedSetShrinkStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Bool
    -- ^ /@resize@/: true to let the start child be shrunk
    -> m ()
panedSetShrinkStartChild paned resize = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    let resize' = (P.fromIntegral . P.fromEnum) resize
    gtk_paned_set_shrink_start_child paned' resize'
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetShrinkStartChildMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetShrinkStartChildMethodInfo a signature where
    overloadedMethod = panedSetShrinkStartChild

instance O.OverloadedMethodInfo PanedSetShrinkStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetShrinkStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetShrinkStartChild"
        })


#endif

-- method Paned::set_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_start_child" gtk_paned_set_start_child :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the start child of /@paned@/ to /@child@/.
-- 
-- If /@child@/ is @NULL@, the existing child will be removed.
panedSetStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Maybe (b)
    -- ^ /@child@/: the widget to add
    -> m ()
panedSetStartChild paned child = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_paned_set_start_child paned' maybeChild
    touchManagedPtr paned
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetStartChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPaned a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PanedSetStartChildMethodInfo a signature where
    overloadedMethod = panedSetStartChild

instance O.OverloadedMethodInfo PanedSetStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetStartChild"
        })


#endif

-- method Paned::set_wide_handle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "paned"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Paned" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPaned`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wide"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the new value for the [property@Gtk.Paned:wide-handle] property"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_paned_set_wide_handle" gtk_paned_set_wide_handle :: 
    Ptr Paned ->                            -- paned : TInterface (Name {namespace = "Gtk", name = "Paned"})
    CInt ->                                 -- wide : TBasicType TBoolean
    IO ()

-- | Sets whether the separator should be wide.
panedSetWideHandle ::
    (B.CallStack.HasCallStack, MonadIO m, IsPaned a) =>
    a
    -- ^ /@paned@/: a @GtkPaned@
    -> Bool
    -- ^ /@wide@/: the new value for the [Paned:wideHandle]("GI.Gtk.Objects.Paned#g:attr:wideHandle") property
    -> m ()
panedSetWideHandle paned wide = liftIO $ do
    paned' <- unsafeManagedPtrCastPtr paned
    let wide' = (P.fromIntegral . P.fromEnum) wide
    gtk_paned_set_wide_handle paned' wide'
    touchManagedPtr paned
    return ()

#if defined(ENABLE_OVERLOADING)
data PanedSetWideHandleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPaned a) => O.OverloadedMethod PanedSetWideHandleMethodInfo a signature where
    overloadedMethod = panedSetWideHandle

instance O.OverloadedMethodInfo PanedSetWideHandleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Paned.panedSetWideHandle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Paned.html#v:panedSetWideHandle"
        })


#endif


