{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Activates a named action.
-- 
-- See 'GI.Gtk.Structs.WidgetClass.widgetClassInstallAction' and
-- 'GI.Gtk.Objects.Widget.widgetInsertActionGroup' for ways
-- to associate named actions with widgets.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.NamedAction
    ( 

-- * Exported types
    NamedAction(..)                         ,
    IsNamedAction                           ,
    toNamedAction                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gtk.Objects.ShortcutAction#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutAction#g:method:print"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gtk.Objects.ShortcutAction#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActionName]("GI.Gtk.Objects.NamedAction#g:method:getActionName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNamedActionMethod                ,
#endif

-- ** getActionName #method:getActionName#

#if defined(ENABLE_OVERLOADING)
    NamedActionGetActionNameMethodInfo      ,
#endif
    namedActionGetActionName                ,


-- ** new #method:new#

    namedActionNew                          ,




 -- * Properties


-- ** actionName #attr:actionName#
-- | The name of the action to activate.

#if defined(ENABLE_OVERLOADING)
    NamedActionActionNamePropertyInfo       ,
#endif
    constructNamedActionActionName          ,
    getNamedActionActionName                ,
#if defined(ENABLE_OVERLOADING)
    namedActionActionName                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction

#endif

-- | Memory-managed wrapper type.
newtype NamedAction = NamedAction (SP.ManagedPtr NamedAction)
    deriving (Eq)

instance SP.ManagedPtrNewtype NamedAction where
    toManagedPtr (NamedAction p) = p

foreign import ccall "gtk_named_action_get_type"
    c_gtk_named_action_get_type :: IO B.Types.GType

instance B.Types.TypedObject NamedAction where
    glibType = c_gtk_named_action_get_type

instance B.Types.GObject NamedAction

-- | Type class for types which can be safely cast to t'NamedAction', for instance with `toNamedAction`.
class (SP.GObject o, O.IsDescendantOf NamedAction o) => IsNamedAction o
instance (SP.GObject o, O.IsDescendantOf NamedAction o) => IsNamedAction o

instance O.HasParentTypes NamedAction
type instance O.ParentTypes NamedAction = '[Gtk.ShortcutAction.ShortcutAction, GObject.Object.Object]

-- | Cast to t'NamedAction', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNamedAction :: (MIO.MonadIO m, IsNamedAction o) => o -> m NamedAction
toNamedAction = MIO.liftIO . B.ManagedPtr.unsafeCastTo NamedAction

-- | Convert t'NamedAction' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NamedAction) where
    gvalueGType_ = c_gtk_named_action_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NamedAction)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NamedAction)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NamedAction ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNamedActionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNamedActionMethod "activate" o = Gtk.ShortcutAction.ShortcutActionActivateMethodInfo
    ResolveNamedActionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNamedActionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNamedActionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNamedActionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNamedActionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNamedActionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNamedActionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNamedActionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNamedActionMethod "print" o = Gtk.ShortcutAction.ShortcutActionPrintMethodInfo
    ResolveNamedActionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNamedActionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNamedActionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNamedActionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNamedActionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNamedActionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNamedActionMethod "toString" o = Gtk.ShortcutAction.ShortcutActionToStringMethodInfo
    ResolveNamedActionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNamedActionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNamedActionMethod "getActionName" o = NamedActionGetActionNameMethodInfo
    ResolveNamedActionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNamedActionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNamedActionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNamedActionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNamedActionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNamedActionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNamedActionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNamedActionMethod t NamedAction, O.OverloadedMethod info NamedAction p) => OL.IsLabel t (NamedAction -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNamedActionMethod t NamedAction, O.OverloadedMethod info NamedAction p, R.HasField t NamedAction p) => R.HasField t NamedAction p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNamedActionMethod t NamedAction, O.OverloadedMethodInfo info NamedAction) => OL.IsLabel t (O.MethodProxy info NamedAction) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "action-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@action-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' namedAction #actionName
-- @
getNamedActionActionName :: (MonadIO m, IsNamedAction o) => o -> m T.Text
getNamedActionActionName obj = MIO.liftIO $ checkUnexpectedNothing "getNamedActionActionName" $ B.Properties.getObjectPropertyString obj "action-name"

-- | Construct a t'GValueConstruct' with valid value for the “@action-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructNamedActionActionName :: (IsNamedAction o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructNamedActionActionName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "action-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data NamedActionActionNamePropertyInfo
instance AttrInfo NamedActionActionNamePropertyInfo where
    type AttrAllowedOps NamedActionActionNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint NamedActionActionNamePropertyInfo = IsNamedAction
    type AttrSetTypeConstraint NamedActionActionNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint NamedActionActionNamePropertyInfo = (~) T.Text
    type AttrTransferType NamedActionActionNamePropertyInfo = T.Text
    type AttrGetType NamedActionActionNamePropertyInfo = T.Text
    type AttrLabel NamedActionActionNamePropertyInfo = "action-name"
    type AttrOrigin NamedActionActionNamePropertyInfo = NamedAction
    attrGet = getNamedActionActionName
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructNamedActionActionName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NamedAction.actionName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NamedAction.html#g:attr:actionName"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NamedAction
type instance O.AttributeList NamedAction = NamedActionAttributeList
type NamedActionAttributeList = ('[ '("actionName", NamedActionActionNamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
namedActionActionName :: AttrLabelProxy "actionName"
namedActionActionName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NamedAction = NamedActionSignalList
type NamedActionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NamedAction::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detailed name of the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "NamedAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_named_action_new" gtk_named_action_new :: 
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr NamedAction)

-- | Creates an action that when activated, activates
-- the named action on the widget.
-- 
-- It also passes the given arguments to it.
-- 
-- See 'GI.Gtk.Objects.Widget.widgetInsertActionGroup' for
-- how to add actions to widgets.
namedActionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the detailed name of the action
    -> m NamedAction
    -- ^ __Returns:__ a new @GtkShortcutAction@
namedActionNew name = liftIO $ do
    name' <- textToCString name
    result <- gtk_named_action_new name'
    checkUnexpectedReturnNULL "namedActionNew" result
    result' <- (wrapObject NamedAction) result
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method NamedAction::get_action_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "NamedAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a named action" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_named_action_get_action_name" gtk_named_action_get_action_name :: 
    Ptr NamedAction ->                      -- self : TInterface (Name {namespace = "Gtk", name = "NamedAction"})
    IO CString

-- | Returns the name of the action that will be activated.
namedActionGetActionName ::
    (B.CallStack.HasCallStack, MonadIO m, IsNamedAction a) =>
    a
    -- ^ /@self@/: a named action
    -> m T.Text
    -- ^ __Returns:__ the name of the action to activate
namedActionGetActionName self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_named_action_get_action_name self'
    checkUnexpectedReturnNULL "namedActionGetActionName" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data NamedActionGetActionNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsNamedAction a) => O.OverloadedMethod NamedActionGetActionNameMethodInfo a signature where
    overloadedMethod = namedActionGetActionName

instance O.OverloadedMethodInfo NamedActionGetActionNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.NamedAction.namedActionGetActionName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-NamedAction.html#v:namedActionGetActionName"
        })


#endif


