{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node cross fading between two child nodes.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.CrossFadeNode
    ( 

-- * Exported types
    CrossFadeNode(..)                       ,
    IsCrossFadeNode                         ,
    toCrossFadeNode                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getEndChild]("GI.Gsk.Objects.CrossFadeNode#g:method:getEndChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getProgress]("GI.Gsk.Objects.CrossFadeNode#g:method:getProgress"), [getStartChild]("GI.Gsk.Objects.CrossFadeNode#g:method:getStartChild").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveCrossFadeNodeMethod              ,
#endif

-- ** getEndChild #method:getEndChild#

#if defined(ENABLE_OVERLOADING)
    CrossFadeNodeGetEndChildMethodInfo      ,
#endif
    crossFadeNodeGetEndChild                ,


-- ** getProgress #method:getProgress#

#if defined(ENABLE_OVERLOADING)
    CrossFadeNodeGetProgressMethodInfo      ,
#endif
    crossFadeNodeGetProgress                ,


-- ** getStartChild #method:getStartChild#

#if defined(ENABLE_OVERLOADING)
    CrossFadeNodeGetStartChildMethodInfo    ,
#endif
    crossFadeNodeGetStartChild              ,


-- ** new #method:new#

    crossFadeNodeNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype CrossFadeNode = CrossFadeNode (SP.ManagedPtr CrossFadeNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype CrossFadeNode where
    toManagedPtr (CrossFadeNode p) = p

foreign import ccall "gsk_cross_fade_node_get_type"
    c_gsk_cross_fade_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject CrossFadeNode where
    glibType = c_gsk_cross_fade_node_get_type

-- | Type class for types which can be safely cast to t'CrossFadeNode', for instance with `toCrossFadeNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CrossFadeNode o) => IsCrossFadeNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf CrossFadeNode o) => IsCrossFadeNode o

instance O.HasParentTypes CrossFadeNode
type instance O.ParentTypes CrossFadeNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'CrossFadeNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCrossFadeNode :: (MIO.MonadIO m, IsCrossFadeNode o) => o -> m CrossFadeNode
toCrossFadeNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo CrossFadeNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveCrossFadeNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCrossFadeNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveCrossFadeNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveCrossFadeNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveCrossFadeNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveCrossFadeNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveCrossFadeNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveCrossFadeNodeMethod "getEndChild" o = CrossFadeNodeGetEndChildMethodInfo
    ResolveCrossFadeNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveCrossFadeNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveCrossFadeNodeMethod "getProgress" o = CrossFadeNodeGetProgressMethodInfo
    ResolveCrossFadeNodeMethod "getStartChild" o = CrossFadeNodeGetStartChildMethodInfo
    ResolveCrossFadeNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCrossFadeNodeMethod t CrossFadeNode, O.OverloadedMethod info CrossFadeNode p) => OL.IsLabel t (CrossFadeNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCrossFadeNodeMethod t CrossFadeNode, O.OverloadedMethod info CrossFadeNode p, R.HasField t CrossFadeNode p) => R.HasField t CrossFadeNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCrossFadeNodeMethod t CrossFadeNode, O.OverloadedMethodInfo info CrossFadeNode) => OL.IsLabel t (O.MethodProxy info CrossFadeNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr CrossFadeNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method CrossFadeNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The start node to be drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The node to be cross_fadeed onto the @start node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "progress"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "How far the fade has progressed from start to end. The value will\n    be clamped to the range [0 ... 1]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "CrossFadeNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_cross_fade_node_new" gsk_cross_fade_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- start : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Gsk.RenderNode.RenderNode ->        -- end : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    CFloat ->                               -- progress : TBasicType TFloat
    IO (Ptr CrossFadeNode)

-- | Creates a @GskRenderNode@ that will do a cross-fade between /@start@/ and /@end@/.
crossFadeNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a, Gsk.RenderNode.IsRenderNode b) =>
    a
    -- ^ /@start@/: The start node to be drawn
    -> b
    -- ^ /@end@/: The node to be cross_fadeed onto the /@start@/ node
    -> Float
    -- ^ /@progress@/: How far the fade has progressed from start to end. The value will
    --     be clamped to the range [0 ... 1]
    -> m CrossFadeNode
    -- ^ __Returns:__ A new @GskRenderNode@
crossFadeNodeNew start end progress = liftIO $ do
    start' <- unsafeManagedPtrCastPtr start
    end' <- unsafeManagedPtrCastPtr end
    let progress' = realToFrac progress
    result <- gsk_cross_fade_node_new start' end' progress'
    checkUnexpectedReturnNULL "crossFadeNodeNew" result
    result' <- (wrapPtr CrossFadeNode) result
    touchManagedPtr start
    touchManagedPtr end
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method CrossFadeNode::get_end_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "CrossFadeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cross-fading `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_cross_fade_node_get_end_child" gsk_cross_fade_node_get_end_child :: 
    Ptr CrossFadeNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "CrossFadeNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the child @GskRenderNode@ at the end of the cross-fade.
crossFadeNodeGetEndChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossFadeNode a) =>
    a
    -- ^ /@node@/: a cross-fading @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ a @GskRenderNode@
crossFadeNodeGetEndChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_cross_fade_node_get_end_child node'
    checkUnexpectedReturnNULL "crossFadeNodeGetEndChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossFadeNodeGetEndChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsCrossFadeNode a) => O.OverloadedMethod CrossFadeNodeGetEndChildMethodInfo a signature where
    overloadedMethod = crossFadeNodeGetEndChild

instance O.OverloadedMethodInfo CrossFadeNodeGetEndChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.CrossFadeNode.crossFadeNodeGetEndChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-CrossFadeNode.html#v:crossFadeNodeGetEndChild"
        })


#endif

-- method CrossFadeNode::get_progress
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "CrossFadeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cross-fading `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_cross_fade_node_get_progress" gsk_cross_fade_node_get_progress :: 
    Ptr CrossFadeNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "CrossFadeNode"})
    IO CFloat

-- | Retrieves the progress value of the cross fade.
crossFadeNodeGetProgress ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossFadeNode a) =>
    a
    -- ^ /@node@/: a cross-fading @GskRenderNode@
    -> m Float
    -- ^ __Returns:__ the progress value, between 0 and 1
crossFadeNodeGetProgress node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_cross_fade_node_get_progress node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossFadeNodeGetProgressMethodInfo
instance (signature ~ (m Float), MonadIO m, IsCrossFadeNode a) => O.OverloadedMethod CrossFadeNodeGetProgressMethodInfo a signature where
    overloadedMethod = crossFadeNodeGetProgress

instance O.OverloadedMethodInfo CrossFadeNodeGetProgressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.CrossFadeNode.crossFadeNodeGetProgress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-CrossFadeNode.html#v:crossFadeNodeGetProgress"
        })


#endif

-- method CrossFadeNode::get_start_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "CrossFadeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cross-fading `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_cross_fade_node_get_start_child" gsk_cross_fade_node_get_start_child :: 
    Ptr CrossFadeNode ->                    -- node : TInterface (Name {namespace = "Gsk", name = "CrossFadeNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the child @GskRenderNode@ at the beginning of the cross-fade.
crossFadeNodeGetStartChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsCrossFadeNode a) =>
    a
    -- ^ /@node@/: a cross-fading @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ a @GskRenderNode@
crossFadeNodeGetStartChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_cross_fade_node_get_start_child node'
    checkUnexpectedReturnNULL "crossFadeNodeGetStartChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data CrossFadeNodeGetStartChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsCrossFadeNode a) => O.OverloadedMethod CrossFadeNodeGetStartChildMethodInfo a signature where
    overloadedMethod = crossFadeNodeGetStartChild

instance O.OverloadedMethodInfo CrossFadeNodeGetStartChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.CrossFadeNode.crossFadeNodeGetStartChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-CrossFadeNode.html#v:crossFadeNodeGetStartChild"
        })


#endif


