{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Renders a GSK rendernode tree with cairo.
-- 
-- Since it is using cairo, this renderer cannot support
-- 3D transformations.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.CairoRenderer
    ( 

-- * Exported types
    CairoRenderer(..)                       ,
    IsCairoRenderer                         ,
    toCairoRenderer                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRealized]("GI.Gsk.Objects.Renderer#g:method:isRealized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gsk.Objects.Renderer#g:method:realize"), [realizeForDisplay]("GI.Gsk.Objects.Renderer#g:method:realizeForDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [render]("GI.Gsk.Objects.Renderer#g:method:render"), [renderTexture]("GI.Gsk.Objects.Renderer#g:method:renderTexture"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gsk.Objects.Renderer#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gsk.Objects.Renderer#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCairoRendererMethod              ,
#endif

-- ** new #method:new#

    cairoRendererNew                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#endif

-- | Memory-managed wrapper type.
newtype CairoRenderer = CairoRenderer (SP.ManagedPtr CairoRenderer)
    deriving (Eq)

instance SP.ManagedPtrNewtype CairoRenderer where
    toManagedPtr (CairoRenderer p) = p

foreign import ccall "gsk_cairo_renderer_get_type"
    c_gsk_cairo_renderer_get_type :: IO B.Types.GType

instance B.Types.TypedObject CairoRenderer where
    glibType = c_gsk_cairo_renderer_get_type

instance B.Types.GObject CairoRenderer

-- | Type class for types which can be safely cast to t'CairoRenderer', for instance with `toCairoRenderer`.
class (SP.GObject o, O.IsDescendantOf CairoRenderer o) => IsCairoRenderer o
instance (SP.GObject o, O.IsDescendantOf CairoRenderer o) => IsCairoRenderer o

instance O.HasParentTypes CairoRenderer
type instance O.ParentTypes CairoRenderer = '[Gsk.Renderer.Renderer, GObject.Object.Object]

-- | Cast to t'CairoRenderer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCairoRenderer :: (MIO.MonadIO m, IsCairoRenderer o) => o -> m CairoRenderer
toCairoRenderer = MIO.liftIO . B.ManagedPtr.unsafeCastTo CairoRenderer

-- | Convert t'CairoRenderer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CairoRenderer) where
    gvalueGType_ = c_gsk_cairo_renderer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CairoRenderer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CairoRenderer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CairoRenderer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCairoRendererMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCairoRendererMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCairoRendererMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCairoRendererMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCairoRendererMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCairoRendererMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCairoRendererMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCairoRendererMethod "isRealized" o = Gsk.Renderer.RendererIsRealizedMethodInfo
    ResolveCairoRendererMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCairoRendererMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCairoRendererMethod "realize" o = Gsk.Renderer.RendererRealizeMethodInfo
    ResolveCairoRendererMethod "realizeForDisplay" o = Gsk.Renderer.RendererRealizeForDisplayMethodInfo
    ResolveCairoRendererMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCairoRendererMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCairoRendererMethod "render" o = Gsk.Renderer.RendererRenderMethodInfo
    ResolveCairoRendererMethod "renderTexture" o = Gsk.Renderer.RendererRenderTextureMethodInfo
    ResolveCairoRendererMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCairoRendererMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCairoRendererMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCairoRendererMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCairoRendererMethod "unrealize" o = Gsk.Renderer.RendererUnrealizeMethodInfo
    ResolveCairoRendererMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCairoRendererMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCairoRendererMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCairoRendererMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCairoRendererMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCairoRendererMethod "getSurface" o = Gsk.Renderer.RendererGetSurfaceMethodInfo
    ResolveCairoRendererMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCairoRendererMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCairoRendererMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCairoRendererMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCairoRendererMethod t CairoRenderer, O.OverloadedMethod info CairoRenderer p) => OL.IsLabel t (CairoRenderer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCairoRendererMethod t CairoRenderer, O.OverloadedMethod info CairoRenderer p, R.HasField t CairoRenderer p) => R.HasField t CairoRenderer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCairoRendererMethod t CairoRenderer, O.OverloadedMethodInfo info CairoRenderer) => OL.IsLabel t (O.MethodProxy info CairoRenderer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CairoRenderer
type instance O.AttributeList CairoRenderer = CairoRendererAttributeList
type CairoRendererAttributeList = ('[ '("realized", Gsk.Renderer.RendererRealizedPropertyInfo), '("surface", Gsk.Renderer.RendererSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CairoRenderer = CairoRendererSignalList
type CairoRendererSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CairoRenderer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "CairoRenderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_cairo_renderer_new" gsk_cairo_renderer_new :: 
    IO (Ptr CairoRenderer)

-- | Creates a new Cairo renderer.
-- 
-- The Cairo renderer is the fallback renderer drawing in ways similar
-- to how GTK 3 drew its content. Its primary use is as comparison tool.
-- 
-- The Cairo renderer is incomplete. It cannot render 3D transformed
-- content and will instead render an error marker. Its usage should be
-- avoided.
cairoRendererNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m CairoRenderer
    -- ^ __Returns:__ a new Cairo renderer.
cairoRendererNew  = liftIO $ do
    result <- gsk_cairo_renderer_new
    checkUnexpectedReturnNULL "cairoRendererNew" result
    result' <- (wrapObject CairoRenderer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


