{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Graphene.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ ]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Graphene.Config"
 , "GI.Graphene"
 , "GI.Graphene.Constants"
 , "GI.Graphene.Enums"
 , "GI.Graphene.Structs"
 , "GI.Graphene.Structs.Box"
 , "GI.Graphene.Structs.Euler"
 , "GI.Graphene.Structs.Frustum"
 , "GI.Graphene.Structs.Matrix"
 , "GI.Graphene.Structs.Plane"
 , "GI.Graphene.Structs.Point"
 , "GI.Graphene.Structs.Point3D"
 , "GI.Graphene.Structs.Quad"
 , "GI.Graphene.Structs.Quaternion"
 , "GI.Graphene.Structs.Ray"
 , "GI.Graphene.Structs.Rect"
 , "GI.Graphene.Structs.Simd4F"
 , "GI.Graphene.Structs.Simd4X4F"
 , "GI.Graphene.Structs.Size"
 , "GI.Graphene.Structs.Sphere"
 , "GI.Graphene.Structs.Triangle"
 , "GI.Graphene.Structs.Vec2"
 , "GI.Graphene.Structs.Vec3"
 , "GI.Graphene.Structs.Vec4"]
