{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A Unix pipe. The advantage of this type over @int[2]@ is that it can
-- be closed automatically when it goes out of scope, using @g_auto(GUnixPipe)@,
-- on compilers that support that feature.
-- 
-- /Since: 2.80/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.UnixPipe
    ( 

-- * Exported types
    UnixPipe(..)                            ,
    newZeroUnixPipe                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveUnixPipeMethod                   ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype UnixPipe = UnixPipe (SP.ManagedPtr UnixPipe)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixPipe where
    toManagedPtr (UnixPipe p) = p

instance BoxedPtr UnixPipe where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr UnixPipe)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr UnixPipe where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'UnixPipe' struct initialized to zero.
newZeroUnixPipe :: MonadIO m => m UnixPipe
newZeroUnixPipe = liftIO $ boxedPtrCalloc >>= wrapPtr UnixPipe

instance tag ~ 'AttrSet => Constructible UnixPipe tag where
    new _ attrs = do
        o <- newZeroUnixPipe
        GI.Attributes.set o attrs
        return o


-- XXX Skipped attribute for "UnixPipe:fds"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TInt)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixPipe
type instance O.AttributeList UnixPipe = UnixPipeAttributeList
type UnixPipeAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixPipeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixPipeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixPipeMethod t UnixPipe, O.OverloadedMethod info UnixPipe p) => OL.IsLabel t (UnixPipe -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixPipeMethod t UnixPipe, O.OverloadedMethod info UnixPipe p, R.HasField t UnixPipe p) => R.HasField t UnixPipe p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixPipeMethod t UnixPipe, O.OverloadedMethodInfo info UnixPipe) => OL.IsLabel t (O.MethodProxy info UnixPipe) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


