{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.GLib.Structs.Node.Node' struct represents one node in a <http://developer.gnome.org/glib/stable/data-structures.html#n-ary-trees n-ary tree>.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.Node
    ( 

-- * Exported types
    Node(..)                                ,
    newZeroNode                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [childIndex]("GI.GLib.Structs.Node#g:method:childIndex"), [childPosition]("GI.GLib.Structs.Node#g:method:childPosition"), [childrenForeach]("GI.GLib.Structs.Node#g:method:childrenForeach"), [depth]("GI.GLib.Structs.Node#g:method:depth"), [destroy]("GI.GLib.Structs.Node#g:method:destroy"), [isAncestor]("GI.GLib.Structs.Node#g:method:isAncestor"), [maxHeight]("GI.GLib.Structs.Node#g:method:maxHeight"), [nChildren]("GI.GLib.Structs.Node#g:method:nChildren"), [nNodes]("GI.GLib.Structs.Node#g:method:nNodes"), [reverseChildren]("GI.GLib.Structs.Node#g:method:reverseChildren"), [traverse]("GI.GLib.Structs.Node#g:method:traverse"), [unlink]("GI.GLib.Structs.Node#g:method:unlink").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveNodeMethod                       ,
#endif

-- ** childIndex #method:childIndex#

#if defined(ENABLE_OVERLOADING)
    NodeChildIndexMethodInfo                ,
#endif
    nodeChildIndex                          ,


-- ** childPosition #method:childPosition#

#if defined(ENABLE_OVERLOADING)
    NodeChildPositionMethodInfo             ,
#endif
    nodeChildPosition                       ,


-- ** childrenForeach #method:childrenForeach#

#if defined(ENABLE_OVERLOADING)
    NodeChildrenForeachMethodInfo           ,
#endif
    nodeChildrenForeach                     ,


-- ** depth #method:depth#

#if defined(ENABLE_OVERLOADING)
    NodeDepthMethodInfo                     ,
#endif
    nodeDepth                               ,


-- ** destroy #method:destroy#

#if defined(ENABLE_OVERLOADING)
    NodeDestroyMethodInfo                   ,
#endif
    nodeDestroy                             ,


-- ** isAncestor #method:isAncestor#

#if defined(ENABLE_OVERLOADING)
    NodeIsAncestorMethodInfo                ,
#endif
    nodeIsAncestor                          ,


-- ** maxHeight #method:maxHeight#

#if defined(ENABLE_OVERLOADING)
    NodeMaxHeightMethodInfo                 ,
#endif
    nodeMaxHeight                           ,


-- ** nChildren #method:nChildren#

#if defined(ENABLE_OVERLOADING)
    NodeNChildrenMethodInfo                 ,
#endif
    nodeNChildren                           ,


-- ** nNodes #method:nNodes#

#if defined(ENABLE_OVERLOADING)
    NodeNNodesMethodInfo                    ,
#endif
    nodeNNodes                              ,


-- ** popAllocator #method:popAllocator#

    nodePopAllocator                        ,


-- ** pushAllocator #method:pushAllocator#

    nodePushAllocator                       ,


-- ** reverseChildren #method:reverseChildren#

#if defined(ENABLE_OVERLOADING)
    NodeReverseChildrenMethodInfo           ,
#endif
    nodeReverseChildren                     ,


-- ** traverse #method:traverse#

#if defined(ENABLE_OVERLOADING)
    NodeTraverseMethodInfo                  ,
#endif
    nodeTraverse                            ,


-- ** unlink #method:unlink#

#if defined(ENABLE_OVERLOADING)
    NodeUnlinkMethodInfo                    ,
#endif
    nodeUnlink                              ,




 -- * Properties


-- ** children #attr:children#
-- | points to the first child of the t'GI.GLib.Structs.Node.Node'.  The other
--            children are accessed by using the /@next@/ pointer of each
--            child.

    clearNodeChildren                       ,
    getNodeChildren                         ,
#if defined(ENABLE_OVERLOADING)
    node_children                           ,
#endif
    setNodeChildren                         ,


-- ** data #attr:data#
-- | contains the actual data of the node.

    clearNodeData                           ,
    getNodeData                             ,
#if defined(ENABLE_OVERLOADING)
    node_data                               ,
#endif
    setNodeData                             ,


-- ** next #attr:next#
-- | points to the node\'s next sibling (a sibling is another
--        t'GI.GLib.Structs.Node.Node' with the same parent).

    clearNodeNext                           ,
    getNodeNext                             ,
#if defined(ENABLE_OVERLOADING)
    node_next                               ,
#endif
    setNodeNext                             ,


-- ** parent #attr:parent#
-- | points to the parent of the t'GI.GLib.Structs.Node.Node', or is 'P.Nothing' if the
--          t'GI.GLib.Structs.Node.Node' is the root of the tree.

    clearNodeParent                         ,
    getNodeParent                           ,
#if defined(ENABLE_OVERLOADING)
    node_parent                             ,
#endif
    setNodeParent                           ,


-- ** prev #attr:prev#
-- | points to the node\'s previous sibling.

    clearNodePrev                           ,
    getNodePrev                             ,
#if defined(ENABLE_OVERLOADING)
    node_prev                               ,
#endif
    setNodePrev                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Allocator as GLib.Allocator

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Allocator as GLib.Allocator

#endif

-- | Memory-managed wrapper type.
newtype Node = Node (SP.ManagedPtr Node)
    deriving (Eq)

instance SP.ManagedPtrNewtype Node where
    toManagedPtr (Node p) = p

instance BoxedPtr Node where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr Node)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Node where
    boxedPtrCalloc = callocBytes 40


-- | Construct a t'Node' struct initialized to zero.
newZeroNode :: MonadIO m => m Node
newZeroNode = liftIO $ boxedPtrCalloc >>= wrapPtr Node

instance tag ~ 'AttrSet => Constructible Node tag where
    new _ attrs = do
        o <- newZeroNode
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' node #data
-- @
getNodeData :: MonadIO m => Node -> m (Ptr ())
getNodeData s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr ())
    return val

-- | Set the value of the “@data@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' node [ #data 'Data.GI.Base.Attributes.:=' value ]
-- @
setNodeData :: MonadIO m => Node -> Ptr () -> m ()
setNodeData s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr ())

-- | Set the value of the “@data@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #data
-- @
clearNodeData :: MonadIO m => Node -> m ()
clearNodeData s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr ())

#if defined(ENABLE_OVERLOADING)
data NodeDataFieldInfo
instance AttrInfo NodeDataFieldInfo where
    type AttrBaseTypeConstraint NodeDataFieldInfo = (~) Node
    type AttrAllowedOps NodeDataFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NodeDataFieldInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint NodeDataFieldInfo = (~)(Ptr ())
    type AttrTransferType NodeDataFieldInfo = (Ptr ())
    type AttrGetType NodeDataFieldInfo = Ptr ()
    type AttrLabel NodeDataFieldInfo = "data"
    type AttrOrigin NodeDataFieldInfo = Node
    attrGet = getNodeData
    attrSet = setNodeData
    attrConstruct = undefined
    attrClear = clearNodeData
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#g:attr:data"
        })

node_data :: AttrLabelProxy "data"
node_data = AttrLabelProxy

#endif


-- | Get the value of the “@next@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' node #next
-- @
getNodeNext :: MonadIO m => Node -> m (Maybe Node)
getNodeNext s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Node)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Node) val'
        return val''
    return result

-- | Set the value of the “@next@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' node [ #next 'Data.GI.Base.Attributes.:=' value ]
-- @
setNodeNext :: MonadIO m => Node -> Ptr Node -> m ()
setNodeNext s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Node)

-- | Set the value of the “@next@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #next
-- @
clearNodeNext :: MonadIO m => Node -> m ()
clearNodeNext s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Node)

#if defined(ENABLE_OVERLOADING)
data NodeNextFieldInfo
instance AttrInfo NodeNextFieldInfo where
    type AttrBaseTypeConstraint NodeNextFieldInfo = (~) Node
    type AttrAllowedOps NodeNextFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NodeNextFieldInfo = (~) (Ptr Node)
    type AttrTransferTypeConstraint NodeNextFieldInfo = (~)(Ptr Node)
    type AttrTransferType NodeNextFieldInfo = (Ptr Node)
    type AttrGetType NodeNextFieldInfo = Maybe Node
    type AttrLabel NodeNextFieldInfo = "next"
    type AttrOrigin NodeNextFieldInfo = Node
    attrGet = getNodeNext
    attrSet = setNodeNext
    attrConstruct = undefined
    attrClear = clearNodeNext
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.next"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#g:attr:next"
        })

node_next :: AttrLabelProxy "next"
node_next = AttrLabelProxy

#endif


-- | Get the value of the “@prev@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' node #prev
-- @
getNodePrev :: MonadIO m => Node -> m (Maybe Node)
getNodePrev s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (Ptr Node)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Node) val'
        return val''
    return result

-- | Set the value of the “@prev@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' node [ #prev 'Data.GI.Base.Attributes.:=' value ]
-- @
setNodePrev :: MonadIO m => Node -> Ptr Node -> m ()
setNodePrev s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Ptr Node)

-- | Set the value of the “@prev@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #prev
-- @
clearNodePrev :: MonadIO m => Node -> m ()
clearNodePrev s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: Ptr Node)

#if defined(ENABLE_OVERLOADING)
data NodePrevFieldInfo
instance AttrInfo NodePrevFieldInfo where
    type AttrBaseTypeConstraint NodePrevFieldInfo = (~) Node
    type AttrAllowedOps NodePrevFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NodePrevFieldInfo = (~) (Ptr Node)
    type AttrTransferTypeConstraint NodePrevFieldInfo = (~)(Ptr Node)
    type AttrTransferType NodePrevFieldInfo = (Ptr Node)
    type AttrGetType NodePrevFieldInfo = Maybe Node
    type AttrLabel NodePrevFieldInfo = "prev"
    type AttrOrigin NodePrevFieldInfo = Node
    attrGet = getNodePrev
    attrSet = setNodePrev
    attrConstruct = undefined
    attrClear = clearNodePrev
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.prev"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#g:attr:prev"
        })

node_prev :: AttrLabelProxy "prev"
node_prev = AttrLabelProxy

#endif


-- | Get the value of the “@parent@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' node #parent
-- @
getNodeParent :: MonadIO m => Node -> m (Maybe Node)
getNodeParent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr Node)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Node) val'
        return val''
    return result

-- | Set the value of the “@parent@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' node [ #parent 'Data.GI.Base.Attributes.:=' value ]
-- @
setNodeParent :: MonadIO m => Node -> Ptr Node -> m ()
setNodeParent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr Node)

-- | Set the value of the “@parent@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #parent
-- @
clearNodeParent :: MonadIO m => Node -> m ()
clearNodeParent s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr Node)

#if defined(ENABLE_OVERLOADING)
data NodeParentFieldInfo
instance AttrInfo NodeParentFieldInfo where
    type AttrBaseTypeConstraint NodeParentFieldInfo = (~) Node
    type AttrAllowedOps NodeParentFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NodeParentFieldInfo = (~) (Ptr Node)
    type AttrTransferTypeConstraint NodeParentFieldInfo = (~)(Ptr Node)
    type AttrTransferType NodeParentFieldInfo = (Ptr Node)
    type AttrGetType NodeParentFieldInfo = Maybe Node
    type AttrLabel NodeParentFieldInfo = "parent"
    type AttrOrigin NodeParentFieldInfo = Node
    attrGet = getNodeParent
    attrSet = setNodeParent
    attrConstruct = undefined
    attrClear = clearNodeParent
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.parent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#g:attr:parent"
        })

node_parent :: AttrLabelProxy "parent"
node_parent = AttrLabelProxy

#endif


-- | Get the value of the “@children@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' node #children
-- @
getNodeChildren :: MonadIO m => Node -> m (Maybe Node)
getNodeChildren s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr Node)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newPtr Node) val'
        return val''
    return result

-- | Set the value of the “@children@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' node [ #children 'Data.GI.Base.Attributes.:=' value ]
-- @
setNodeChildren :: MonadIO m => Node -> Ptr Node -> m ()
setNodeChildren s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr Node)

-- | Set the value of the “@children@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #children
-- @
clearNodeChildren :: MonadIO m => Node -> m ()
clearNodeChildren s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr Node)

#if defined(ENABLE_OVERLOADING)
data NodeChildrenFieldInfo
instance AttrInfo NodeChildrenFieldInfo where
    type AttrBaseTypeConstraint NodeChildrenFieldInfo = (~) Node
    type AttrAllowedOps NodeChildrenFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint NodeChildrenFieldInfo = (~) (Ptr Node)
    type AttrTransferTypeConstraint NodeChildrenFieldInfo = (~)(Ptr Node)
    type AttrTransferType NodeChildrenFieldInfo = (Ptr Node)
    type AttrGetType NodeChildrenFieldInfo = Maybe Node
    type AttrLabel NodeChildrenFieldInfo = "children"
    type AttrOrigin NodeChildrenFieldInfo = Node
    attrGet = getNodeChildren
    attrSet = setNodeChildren
    attrConstruct = undefined
    attrClear = clearNodeChildren
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.children"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#g:attr:children"
        })

node_children :: AttrLabelProxy "children"
node_children = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Node
type instance O.AttributeList Node = NodeAttributeList
type NodeAttributeList = ('[ '("data", NodeDataFieldInfo), '("next", NodeNextFieldInfo), '("prev", NodePrevFieldInfo), '("parent", NodeParentFieldInfo), '("children", NodeChildrenFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Node::child_index
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to find" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_child_index" g_node_child_index :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO Int32

-- | Gets the position of the first child of a t'GI.GLib.Structs.Node.Node'
-- which contains the given data.
nodeChildIndex ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> Ptr ()
    -- ^ /@data@/: the data to find
    -> m Int32
    -- ^ __Returns:__ the index of the child of /@node@/ which contains
    --     /@data@/, or -1 if the data is not found
nodeChildIndex node data_ = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_node_child_index node' data_
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data NodeChildIndexMethodInfo
instance (signature ~ (Ptr () -> m Int32), MonadIO m) => O.OverloadedMethod NodeChildIndexMethodInfo Node signature where
    overloadedMethod = nodeChildIndex

instance O.OverloadedMethodInfo NodeChildIndexMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeChildIndex",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeChildIndex"
        })


#endif

-- method Node::child_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child of @node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_child_position" g_node_child_position :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    Ptr Node ->                             -- child : TInterface (Name {namespace = "GLib", name = "Node"})
    IO Int32

-- | Gets the position of a t'GI.GLib.Structs.Node.Node' with respect to its siblings.
-- /@child@/ must be a child of /@node@/. The first child is numbered 0,
-- the second 1, and so on.
nodeChildPosition ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> Node
    -- ^ /@child@/: a child of /@node@/
    -> m Int32
    -- ^ __Returns:__ the position of /@child@/ with respect to its siblings
nodeChildPosition node child = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    child' <- unsafeManagedPtrGetPtr child
    result <- g_node_child_position node' child'
    touchManagedPtr node
    touchManagedPtr child
    return result

#if defined(ENABLE_OVERLOADING)
data NodeChildPositionMethodInfo
instance (signature ~ (Node -> m Int32), MonadIO m) => O.OverloadedMethod NodeChildPositionMethodInfo Node signature where
    overloadedMethod = nodeChildPosition

instance O.OverloadedMethodInfo NodeChildPositionMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeChildPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeChildPosition"
        })


#endif

-- method Node::children_foreach
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "which types of children are to be visited, one of\n    %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "NodeForeachFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each visited node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_children_foreach" g_node_children_foreach :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "TraverseFlags"})
    FunPtr GLib.Callbacks.C_NodeForeachFunc -> -- func : TInterface (Name {namespace = "GLib", name = "NodeForeachFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Calls a function for each of the children of a t'GI.GLib.Structs.Node.Node'. Note that it
-- doesn\'t descend beneath the child nodes. /@func@/ must not do anything
-- that would modify the structure of the tree.
nodeChildrenForeach ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> [GLib.Flags.TraverseFlags]
    -- ^ /@flags@/: which types of children are to be visited, one of
    --     'GI.GLib.Flags.TraverseFlagsAll', 'GI.GLib.Flags.TraverseFlagsLeaves' and 'GI.GLib.Flags.TraverseFlagsNonLeaves'
    -> GLib.Callbacks.NodeForeachFunc
    -- ^ /@func@/: the function to call for each visited node
    -> m ()
nodeChildrenForeach node flags func = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    let flags' = gflagsToWord flags
    func' <- GLib.Callbacks.mk_NodeForeachFunc (GLib.Callbacks.wrap_NodeForeachFunc Nothing func)
    let data_ = nullPtr
    g_node_children_foreach node' flags' func' data_
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr node
    return ()

#if defined(ENABLE_OVERLOADING)
data NodeChildrenForeachMethodInfo
instance (signature ~ ([GLib.Flags.TraverseFlags] -> GLib.Callbacks.NodeForeachFunc -> m ()), MonadIO m) => O.OverloadedMethod NodeChildrenForeachMethodInfo Node signature where
    overloadedMethod = nodeChildrenForeach

instance O.OverloadedMethodInfo NodeChildrenForeachMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeChildrenForeach",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeChildrenForeach"
        })


#endif

-- method Node::depth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_depth" g_node_depth :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    IO Word32

-- | Gets the depth of a t'GI.GLib.Structs.Node.Node'.
-- 
-- If /@node@/ is 'P.Nothing' the depth is 0. The root node has a depth of 1.
-- For the children of the root node the depth is 2. And so on.
nodeDepth ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> m Word32
    -- ^ __Returns:__ the depth of the t'GI.GLib.Structs.Node.Node'
nodeDepth node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_node_depth node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data NodeDepthMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod NodeDepthMethodInfo Node signature where
    overloadedMethod = nodeDepth

instance O.OverloadedMethodInfo NodeDepthMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeDepth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeDepth"
        })


#endif

-- method Node::destroy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "root"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the root of the tree/subtree to destroy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_destroy" g_node_destroy :: 
    Ptr Node ->                             -- root : TInterface (Name {namespace = "GLib", name = "Node"})
    IO ()

-- | Removes /@root@/ and its children from the tree, freeing any memory
-- allocated.
nodeDestroy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@root@/: the root of the tree\/subtree to destroy
    -> m ()
nodeDestroy root = liftIO $ do
    root' <- unsafeManagedPtrGetPtr root
    g_node_destroy root'
    touchManagedPtr root
    return ()

#if defined(ENABLE_OVERLOADING)
data NodeDestroyMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod NodeDestroyMethodInfo Node signature where
    overloadedMethod = nodeDestroy

instance O.OverloadedMethodInfo NodeDestroyMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeDestroy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeDestroy"
        })


#endif

-- method Node::is_ancestor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "descendant"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_is_ancestor" g_node_is_ancestor :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    Ptr Node ->                             -- descendant : TInterface (Name {namespace = "GLib", name = "Node"})
    IO CInt

-- | Returns 'P.True' if /@node@/ is an ancestor of /@descendant@/.
-- This is true if node is the parent of /@descendant@/,
-- or if node is the grandparent of /@descendant@/ etc.
nodeIsAncestor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> Node
    -- ^ /@descendant@/: a t'GI.GLib.Structs.Node.Node'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@node@/ is an ancestor of /@descendant@/
nodeIsAncestor node descendant = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    descendant' <- unsafeManagedPtrGetPtr descendant
    result <- g_node_is_ancestor node' descendant'
    let result' = (/= 0) result
    touchManagedPtr node
    touchManagedPtr descendant
    return result'

#if defined(ENABLE_OVERLOADING)
data NodeIsAncestorMethodInfo
instance (signature ~ (Node -> m Bool), MonadIO m) => O.OverloadedMethod NodeIsAncestorMethodInfo Node signature where
    overloadedMethod = nodeIsAncestor

instance O.OverloadedMethodInfo NodeIsAncestorMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeIsAncestor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeIsAncestor"
        })


#endif

-- method Node::max_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "root"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_max_height" g_node_max_height :: 
    Ptr Node ->                             -- root : TInterface (Name {namespace = "GLib", name = "Node"})
    IO Word32

-- | Gets the maximum height of all branches beneath a t'GI.GLib.Structs.Node.Node'.
-- This is the maximum distance from the t'GI.GLib.Structs.Node.Node' to all leaf nodes.
-- 
-- If /@root@/ is 'P.Nothing', 0 is returned. If /@root@/ has no children,
-- 1 is returned. If /@root@/ has children, 2 is returned. And so on.
nodeMaxHeight ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@root@/: a t'GI.GLib.Structs.Node.Node'
    -> m Word32
    -- ^ __Returns:__ the maximum height of the tree beneath /@root@/
nodeMaxHeight root = liftIO $ do
    root' <- unsafeManagedPtrGetPtr root
    result <- g_node_max_height root'
    touchManagedPtr root
    return result

#if defined(ENABLE_OVERLOADING)
data NodeMaxHeightMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod NodeMaxHeightMethodInfo Node signature where
    overloadedMethod = nodeMaxHeight

instance O.OverloadedMethodInfo NodeMaxHeightMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeMaxHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeMaxHeight"
        })


#endif

-- method Node::n_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_n_children" g_node_n_children :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    IO Word32

-- | Gets the number of children of a t'GI.GLib.Structs.Node.Node'.
nodeNChildren ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'
    -> m Word32
    -- ^ __Returns:__ the number of children of /@node@/
nodeNChildren node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- g_node_n_children node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data NodeNChildrenMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod NodeNChildrenMethodInfo Node signature where
    overloadedMethod = nodeNChildren

instance O.OverloadedMethodInfo NodeNChildrenMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeNChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeNChildren"
        })


#endif

-- method Node::n_nodes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "root"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "which types of children are to be counted, one of\n    %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_node_n_nodes" g_node_n_nodes :: 
    Ptr Node ->                             -- root : TInterface (Name {namespace = "GLib", name = "Node"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "TraverseFlags"})
    IO Word32

-- | Gets the number of nodes in a tree.
nodeNNodes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@root@/: a t'GI.GLib.Structs.Node.Node'
    -> [GLib.Flags.TraverseFlags]
    -- ^ /@flags@/: which types of children are to be counted, one of
    --     'GI.GLib.Flags.TraverseFlagsAll', 'GI.GLib.Flags.TraverseFlagsLeaves' and 'GI.GLib.Flags.TraverseFlagsNonLeaves'
    -> m Word32
    -- ^ __Returns:__ the number of nodes in the tree
nodeNNodes root flags = liftIO $ do
    root' <- unsafeManagedPtrGetPtr root
    let flags' = gflagsToWord flags
    result <- g_node_n_nodes root' flags'
    touchManagedPtr root
    return result

#if defined(ENABLE_OVERLOADING)
data NodeNNodesMethodInfo
instance (signature ~ ([GLib.Flags.TraverseFlags] -> m Word32), MonadIO m) => O.OverloadedMethod NodeNNodesMethodInfo Node signature where
    overloadedMethod = nodeNNodes

instance O.OverloadedMethodInfo NodeNNodesMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeNNodes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeNNodes"
        })


#endif

-- method Node::reverse_children
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_reverse_children" g_node_reverse_children :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    IO ()

-- | Reverses the order of the children of a t'GI.GLib.Structs.Node.Node'.
-- (It doesn\'t change the order of the grandchildren.)
nodeReverseChildren ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'.
    -> m ()
nodeReverseChildren node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    g_node_reverse_children node'
    touchManagedPtr node
    return ()

#if defined(ENABLE_OVERLOADING)
data NodeReverseChildrenMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod NodeReverseChildrenMethodInfo Node signature where
    overloadedMethod = nodeReverseChildren

instance O.OverloadedMethodInfo NodeReverseChildrenMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeReverseChildren",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeReverseChildren"
        })


#endif

-- method Node::traverse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "root"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the root #GNode of the tree to traverse"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the order in which nodes are visited - %G_IN_ORDER,\n    %G_PRE_ORDER, %G_POST_ORDER, or %G_LEVEL_ORDER."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TraverseFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "which types of children are to be visited, one of\n    %G_TRAVERSE_ALL, %G_TRAVERSE_LEAVES and %G_TRAVERSE_NON_LEAVES"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max_depth"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum depth of the traversal. Nodes below this\n    depth will not be visited. If max_depth is -1 all nodes in\n    the tree are visited. If depth is 1, only the root is visited.\n    If depth is 2, the root and its children are visited. And so on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "NodeTraverseFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the function to call for each visited #GNode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data to pass to the function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_traverse" g_node_traverse :: 
    Ptr Node ->                             -- root : TInterface (Name {namespace = "GLib", name = "Node"})
    CUInt ->                                -- order : TInterface (Name {namespace = "GLib", name = "TraverseType"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "GLib", name = "TraverseFlags"})
    Int32 ->                                -- max_depth : TBasicType TInt
    FunPtr GLib.Callbacks.C_NodeTraverseFunc -> -- func : TInterface (Name {namespace = "GLib", name = "NodeTraverseFunc"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Traverses a tree starting at the given root t'GI.GLib.Structs.Node.Node'.
-- It calls the given function for each node visited.
-- The traversal can be halted at any point by returning 'P.True' from /@func@/.
-- /@func@/ must not do anything that would modify the structure of the tree.
nodeTraverse ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@root@/: the root t'GI.GLib.Structs.Node.Node' of the tree to traverse
    -> GLib.Enums.TraverseType
    -- ^ /@order@/: the order in which nodes are visited - 'GI.GLib.Enums.TraverseTypeInOrder',
    --     'GI.GLib.Enums.TraverseTypePreOrder', 'GI.GLib.Enums.TraverseTypePostOrder', or 'GI.GLib.Enums.TraverseTypeLevelOrder'.
    -> [GLib.Flags.TraverseFlags]
    -- ^ /@flags@/: which types of children are to be visited, one of
    --     'GI.GLib.Flags.TraverseFlagsAll', 'GI.GLib.Flags.TraverseFlagsLeaves' and 'GI.GLib.Flags.TraverseFlagsNonLeaves'
    -> Int32
    -- ^ /@maxDepth@/: the maximum depth of the traversal. Nodes below this
    --     depth will not be visited. If max_depth is -1 all nodes in
    --     the tree are visited. If depth is 1, only the root is visited.
    --     If depth is 2, the root and its children are visited. And so on.
    -> GLib.Callbacks.NodeTraverseFunc
    -- ^ /@func@/: the function to call for each visited t'GI.GLib.Structs.Node.Node'
    -> m ()
nodeTraverse root order flags maxDepth func = liftIO $ do
    root' <- unsafeManagedPtrGetPtr root
    let order' = (fromIntegral . fromEnum) order
    let flags' = gflagsToWord flags
    func' <- GLib.Callbacks.mk_NodeTraverseFunc (GLib.Callbacks.wrap_NodeTraverseFunc Nothing func)
    let data_ = nullPtr
    g_node_traverse root' order' flags' maxDepth func' data_
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr root
    return ()

#if defined(ENABLE_OVERLOADING)
data NodeTraverseMethodInfo
instance (signature ~ (GLib.Enums.TraverseType -> [GLib.Flags.TraverseFlags] -> Int32 -> GLib.Callbacks.NodeTraverseFunc -> m ()), MonadIO m) => O.OverloadedMethod NodeTraverseMethodInfo Node signature where
    overloadedMethod = nodeTraverse

instance O.OverloadedMethodInfo NodeTraverseMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeTraverse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeTraverse"
        })


#endif

-- method Node::unlink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GNode to unlink, which becomes the root of a new tree"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_unlink" g_node_unlink :: 
    Ptr Node ->                             -- node : TInterface (Name {namespace = "GLib", name = "Node"})
    IO ()

-- | Unlinks a t'GI.GLib.Structs.Node.Node' from a tree, resulting in two separate trees.
nodeUnlink ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Node
    -- ^ /@node@/: the t'GI.GLib.Structs.Node.Node' to unlink, which becomes the root of a new tree
    -> m ()
nodeUnlink node = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    g_node_unlink node'
    touchManagedPtr node
    return ()

#if defined(ENABLE_OVERLOADING)
data NodeUnlinkMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod NodeUnlinkMethodInfo Node signature where
    overloadedMethod = nodeUnlink

instance O.OverloadedMethodInfo NodeUnlinkMethodInfo Node where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.Node.nodeUnlink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-Node.html#v:nodeUnlink"
        })


#endif

-- method Node::pop_allocator
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_pop_allocator" g_node_pop_allocator :: 
    IO ()

{-# DEPRECATED nodePopAllocator ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
nodePopAllocator ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
nodePopAllocator  = liftIO $ do
    g_node_pop_allocator
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method Node::push_allocator
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "allocator"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Allocator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_node_push_allocator" g_node_push_allocator :: 
    Ptr GLib.Allocator.Allocator ->         -- allocator : TInterface (Name {namespace = "GLib", name = "Allocator"})
    IO ()

{-# DEPRECATED nodePushAllocator ["(Since version 2.10)"] #-}
-- | /No description available in the introspection data./
nodePushAllocator ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Allocator.Allocator
    -> m ()
nodePushAllocator allocator = liftIO $ do
    allocator' <- unsafeManagedPtrGetPtr allocator
    g_node_push_allocator allocator'
    touchManagedPtr allocator
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNodeMethod "childIndex" o = NodeChildIndexMethodInfo
    ResolveNodeMethod "childPosition" o = NodeChildPositionMethodInfo
    ResolveNodeMethod "childrenForeach" o = NodeChildrenForeachMethodInfo
    ResolveNodeMethod "depth" o = NodeDepthMethodInfo
    ResolveNodeMethod "destroy" o = NodeDestroyMethodInfo
    ResolveNodeMethod "isAncestor" o = NodeIsAncestorMethodInfo
    ResolveNodeMethod "maxHeight" o = NodeMaxHeightMethodInfo
    ResolveNodeMethod "nChildren" o = NodeNChildrenMethodInfo
    ResolveNodeMethod "nNodes" o = NodeNNodesMethodInfo
    ResolveNodeMethod "reverseChildren" o = NodeReverseChildrenMethodInfo
    ResolveNodeMethod "traverse" o = NodeTraverseMethodInfo
    ResolveNodeMethod "unlink" o = NodeUnlinkMethodInfo
    ResolveNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNodeMethod t Node, O.OverloadedMethod info Node p) => OL.IsLabel t (Node -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNodeMethod t Node, O.OverloadedMethod info Node p, R.HasField t Node p) => R.HasField t Node p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNodeMethod t Node, O.OverloadedMethodInfo info Node) => OL.IsLabel t (O.MethodProxy info Node) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


