{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about a specific attribute.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.FileAttributeInfo
    ( 

-- * Exported types
    FileAttributeInfo(..)                   ,
    newZeroFileAttributeInfo                ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFileAttributeInfoMethod          ,
#endif



 -- * Properties


-- ** flags #attr:flags#
-- | a set of t'GI.Gio.Flags.FileAttributeInfoFlags'.

#if defined(ENABLE_OVERLOADING)
    fileAttributeInfo_flags                 ,
#endif
    getFileAttributeInfoFlags               ,
    setFileAttributeInfoFlags               ,


-- ** name #attr:name#
-- | the name of the attribute.

    clearFileAttributeInfoName              ,
#if defined(ENABLE_OVERLOADING)
    fileAttributeInfo_name                  ,
#endif
    getFileAttributeInfoName                ,
    setFileAttributeInfoName                ,


-- ** type #attr:type#
-- | the t'GI.Gio.Enums.FileAttributeType' type of the attribute.

#if defined(ENABLE_OVERLOADING)
    fileAttributeInfo_type                  ,
#endif
    getFileAttributeInfoType                ,
    setFileAttributeInfoType                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags

#else
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags

#endif

-- | Memory-managed wrapper type.
newtype FileAttributeInfo = FileAttributeInfo (SP.ManagedPtr FileAttributeInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileAttributeInfo where
    toManagedPtr (FileAttributeInfo p) = p

instance BoxedPtr FileAttributeInfo where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr FileAttributeInfo)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr FileAttributeInfo where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'FileAttributeInfo' struct initialized to zero.
newZeroFileAttributeInfo :: MonadIO m => m FileAttributeInfo
newZeroFileAttributeInfo = liftIO $ boxedPtrCalloc >>= wrapPtr FileAttributeInfo

instance tag ~ 'AttrSet => Constructible FileAttributeInfo tag where
    new _ attrs = do
        o <- newZeroFileAttributeInfo
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileAttributeInfo #name
-- @
getFileAttributeInfoName :: MonadIO m => FileAttributeInfo -> m (Maybe T.Text)
getFileAttributeInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileAttributeInfo [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileAttributeInfoName :: MonadIO m => FileAttributeInfo -> CString -> m ()
setFileAttributeInfoName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearFileAttributeInfoName :: MonadIO m => FileAttributeInfo -> m ()
clearFileAttributeInfoName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoNameFieldInfo
instance AttrInfo FileAttributeInfoNameFieldInfo where
    type AttrBaseTypeConstraint FileAttributeInfoNameFieldInfo = (~) FileAttributeInfo
    type AttrAllowedOps FileAttributeInfoNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FileAttributeInfoNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint FileAttributeInfoNameFieldInfo = (~)CString
    type AttrTransferType FileAttributeInfoNameFieldInfo = CString
    type AttrGetType FileAttributeInfoNameFieldInfo = Maybe T.Text
    type AttrLabel FileAttributeInfoNameFieldInfo = "name"
    type AttrOrigin FileAttributeInfoNameFieldInfo = FileAttributeInfo
    attrGet = getFileAttributeInfoName
    attrSet = setFileAttributeInfoName
    attrConstruct = undefined
    attrClear = clearFileAttributeInfoName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfo.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfo.html#g:attr:name"
        })

fileAttributeInfo_name :: AttrLabelProxy "name"
fileAttributeInfo_name = AttrLabelProxy

#endif


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileAttributeInfo #type
-- @
getFileAttributeInfoType :: MonadIO m => FileAttributeInfo -> m Gio.Enums.FileAttributeType
getFileAttributeInfoType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileAttributeInfo [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileAttributeInfoType :: MonadIO m => FileAttributeInfo -> Gio.Enums.FileAttributeType -> m ()
setFileAttributeInfoType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 8) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoTypeFieldInfo
instance AttrInfo FileAttributeInfoTypeFieldInfo where
    type AttrBaseTypeConstraint FileAttributeInfoTypeFieldInfo = (~) FileAttributeInfo
    type AttrAllowedOps FileAttributeInfoTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FileAttributeInfoTypeFieldInfo = (~) Gio.Enums.FileAttributeType
    type AttrTransferTypeConstraint FileAttributeInfoTypeFieldInfo = (~)Gio.Enums.FileAttributeType
    type AttrTransferType FileAttributeInfoTypeFieldInfo = Gio.Enums.FileAttributeType
    type AttrGetType FileAttributeInfoTypeFieldInfo = Gio.Enums.FileAttributeType
    type AttrLabel FileAttributeInfoTypeFieldInfo = "type"
    type AttrOrigin FileAttributeInfoTypeFieldInfo = FileAttributeInfo
    attrGet = getFileAttributeInfoType
    attrSet = setFileAttributeInfoType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfo.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfo.html#g:attr:type"
        })

fileAttributeInfo_type :: AttrLabelProxy "type"
fileAttributeInfo_type = AttrLabelProxy

#endif


-- | Get the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileAttributeInfo #flags
-- @
getFileAttributeInfoFlags :: MonadIO m => FileAttributeInfo -> m [Gio.Flags.FileAttributeInfoFlags]
getFileAttributeInfoFlags s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@flags@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fileAttributeInfo [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setFileAttributeInfoFlags :: MonadIO m => FileAttributeInfo -> [Gio.Flags.FileAttributeInfoFlags] -> m ()
setFileAttributeInfoFlags s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 12) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data FileAttributeInfoFlagsFieldInfo
instance AttrInfo FileAttributeInfoFlagsFieldInfo where
    type AttrBaseTypeConstraint FileAttributeInfoFlagsFieldInfo = (~) FileAttributeInfo
    type AttrAllowedOps FileAttributeInfoFlagsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FileAttributeInfoFlagsFieldInfo = (~) [Gio.Flags.FileAttributeInfoFlags]
    type AttrTransferTypeConstraint FileAttributeInfoFlagsFieldInfo = (~)[Gio.Flags.FileAttributeInfoFlags]
    type AttrTransferType FileAttributeInfoFlagsFieldInfo = [Gio.Flags.FileAttributeInfoFlags]
    type AttrGetType FileAttributeInfoFlagsFieldInfo = [Gio.Flags.FileAttributeInfoFlags]
    type AttrLabel FileAttributeInfoFlagsFieldInfo = "flags"
    type AttrOrigin FileAttributeInfoFlagsFieldInfo = FileAttributeInfo
    attrGet = getFileAttributeInfoFlags
    attrSet = setFileAttributeInfoFlags
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.FileAttributeInfo.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-FileAttributeInfo.html#g:attr:flags"
        })

fileAttributeInfo_flags :: AttrLabelProxy "flags"
fileAttributeInfo_flags = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileAttributeInfo
type instance O.AttributeList FileAttributeInfo = FileAttributeInfoAttributeList
type FileAttributeInfoAttributeList = ('[ '("name", FileAttributeInfoNameFieldInfo), '("type", FileAttributeInfoTypeFieldInfo), '("flags", FileAttributeInfoFlagsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFileAttributeInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileAttributeInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileAttributeInfoMethod t FileAttributeInfo, O.OverloadedMethod info FileAttributeInfo p) => OL.IsLabel t (FileAttributeInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileAttributeInfoMethod t FileAttributeInfo, O.OverloadedMethod info FileAttributeInfo p, R.HasField t FileAttributeInfo p) => R.HasField t FileAttributeInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileAttributeInfoMethod t FileAttributeInfo, O.OverloadedMethodInfo info FileAttributeInfo) => OL.IsLabel t (O.MethodProxy info FileAttributeInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


